from enum import IntEnum


class DeviceType(IntEnum):
    ELCOR = 128
    ELCOR_PLUS = 131
    ELCOR_LITE = 134


class CertificationVariant(IntEnum):
    CMI_MID = 2
    GENERIC = 4


class SwitchFunction(IntEnum):
    NONE = 0
    PROTECT_METROLOGICAL = 1
    PROTECT_ALL = 2


class CompressibilityFormula(IntEnum):
    CONST = 0
    AGANX19 = 1
    SGERG88 = 2
    AGANX19MOD = 3
    AGA8G1 = 4
    AGA8G2 = 5
    AGA892DC = 6
    GOSTNX19MOD = 7


class ParameterObjectType(IntEnum):

    SYSTEM_PARAMETER = 0
    ANALOG_MEASURAND = 30
    BINARY = 31
    COUNTER = 32
    STANDARD_COUNTER = 33
    FLOW_RATE = 34
    STANDARD_FLOW_RATE = 35
    CONVERSION_COEFFICIENT = 36
    ERROR_COUNTER = 45
    ERROR_STANDARD_COUNTER = 46
    COMPRESSIBILITY = 47
    TIME_WINDOW = 48
    CORRECTION_COUNTER = 49
    DOUBLE_COUNTER = 53
    DOUBLE_ERROR_COUNTER = 54
    DIAGNOSTICS = 59
    DEVICE_ERROR = 61
    SUM_OF_ALARMS = 62
    TIMER = 65

    TARIFF_COUNTER = 68
    BASE_TARIFF_COUNTER = 69
    SET_POINT = 70
    DIFFERENCE_COUNTER = 72
    DIFFERENCE_BASE_COUNTER = 73
    COMPRESSIBILITY_Z = 74
    COMPRESSIBILITY_Z_BASE = 75
    ENERGY = 77
    ERROR_ENERGY = 78
    DOUBLE_TARIFF_COUNTER = 79
    ANALOG_STATISTICS = 80
    COUNTER_STATISTICS = 81
    STANDARD_COUNTER_STATISTICS = 82
    STATISTICS = 83
    ANALOG_TIME_STATISTICS = 84
    TIME_STATISTICS = 85

    MODEM = 141
