(()=>{"use strict";var __webpack_modules__={56488:(__unused_webpack_module,__unused_webpack___webpack_exports__,__webpack_require__)=>{eval('\n// EXTERNAL MODULE: ./node_modules/@babel/runtime/regenerator/index.js\nvar regenerator = __webpack_require__(87757);\nvar regenerator_default = /*#__PURE__*/__webpack_require__.n(regenerator);\n// EXTERNAL MODULE: ./node_modules/core-js/index.js\nvar core_js = __webpack_require__(81486);\n// EXTERNAL MODULE: ./node_modules/react-dom/index.js\nvar react_dom = __webpack_require__(73935);\n// EXTERNAL MODULE: ./node_modules/react-redux/es/index.js + 18 modules\nvar es = __webpack_require__(39704);\n// EXTERNAL MODULE: ./node_modules/redux-saga/dist/redux-saga-effects-npm-proxy.esm.js + 1 modules\nvar redux_saga_effects_npm_proxy_esm = __webpack_require__(34857);\n// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/defineProperty.js\nvar defineProperty = __webpack_require__(4942);\n// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/slicedToArray.js + 3 modules\nvar slicedToArray = __webpack_require__(70885);\n// EXTERNAL MODULE: ./node_modules/react/index.js\nvar react = __webpack_require__(67294);\n// EXTERNAL MODULE: ./node_modules/react-konva/es/ReactKonva.js + 60 modules\nvar ReactKonva = __webpack_require__(74736);\n// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/classCallCheck.js\nvar classCallCheck = __webpack_require__(15671);\n// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/createClass.js\nvar createClass = __webpack_require__(43144);\n// EXTERNAL MODULE: ./node_modules/redux-act/esm/index.js + 7 modules\nvar esm = __webpack_require__(81978);\n// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/toConsumableArray.js + 3 modules\nvar toConsumableArray = __webpack_require__(42982);\n// EXTERNAL MODULE: ./node_modules/redux-saga/dist/redux-saga-core-npm-proxy.esm.js + 3 modules\nvar redux_saga_core_npm_proxy_esm = __webpack_require__(87159);\n// EXTERNAL MODULE: ./node_modules/uuid/dist/esm-browser/v4.js + 4 modules\nvar v4 = __webpack_require__(44586);\n;// CONCATENATED MODULE: ./js/wsclient.js\n\n\n\n\n\n\nvar _marked = /*#__PURE__*/regenerator_default().mark(maybeTimeoutMessage),\n    _marked2 = /*#__PURE__*/regenerator_default().mark(sendToSocket),\n    _marked3 = /*#__PURE__*/regenerator_default().mark(tickMessages),\n    _marked4 = /*#__PURE__*/regenerator_default().mark(startWS),\n    _marked5 = /*#__PURE__*/regenerator_default().mark(processWsSend),\n    _marked6 = /*#__PURE__*/regenerator_default().mark(processWsReceive),\n    _marked7 = /*#__PURE__*/regenerator_default().mark(getWSCommands),\n    _marked8 = /*#__PURE__*/regenerator_default().mark(listen);\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,defineProperty/* default */.Z)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\n\n\n\n\n\n\nvar WSStateKls = /*#__PURE__*/function () {\n  function WSStateKls() {\n    (0,classCallCheck/* default */.Z)(this, WSStateKls);\n\n    (0,defineProperty/* default */.Z)(this, "Loading", (0,esm/* createAction */.PH)("Starting to open connection"));\n\n    (0,defineProperty/* default */.Z)(this, "Error", (0,esm/* createAction */.PH)("Got an error connecting to the websocket"));\n\n    (0,defineProperty/* default */.Z)(this, "Connected", (0,esm/* createAction */.PH)("Successfully connected to the websocket"));\n\n    (0,defineProperty/* default */.Z)(this, "ServerTime", (0,esm/* createAction */.PH)("Got a new server time from the server", function (time) {\n      return {\n        time: time\n      };\n    }));\n  }\n\n  (0,createClass/* default */.Z)(WSStateKls, [{\n    key: "disabledSelector",\n    value: function disabledSelector(state) {\n      return state.ws.loading || state.ws.error;\n    }\n  }, {\n    key: "reducer",\n    value: function reducer() {\n      var _createReducer;\n\n      return (0,esm/* createReducer */.Lq)((_createReducer = {}, (0,defineProperty/* default */.Z)(_createReducer, this.Loading, function (state) {\n        return _objectSpread(_objectSpread({}, state), {}, {\n          loading: true\n        });\n      }), (0,defineProperty/* default */.Z)(_createReducer, this.Error, function (state, _ref) {\n        var error = _ref.error;\n        var errorStr = "Unknown error";\n\n        try {\n          errorStr = "".concat(error.error_code, ": ").concat(error.error);\n        } catch (e) {\n          try {\n            errorStr = JSON.stringify(error);\n          } catch (e) {\n            try {\n              errorStr = error.toString();\n            } catch (e) {\n              errorStr = String(error);\n            }\n          }\n        }\n\n        return _objectSpread(_objectSpread({}, state), {}, {\n          error: error,\n          errorStr: errorStr,\n          loading: true\n        });\n      }), (0,defineProperty/* default */.Z)(_createReducer, this.Connected, function (state) {\n        return _objectSpread(_objectSpread({}, state), {}, {\n          error: undefined,\n          errorStr: undefined,\n          loading: false\n        });\n      }), _createReducer), {\n        error: undefined,\n        errorStr: undefined,\n        devices: {},\n        loading: true\n      });\n    }\n  }]);\n\n  return WSStateKls;\n}();\n\nvar WSState = new WSStateKls();\nvar WSCommand = (0,esm/* createAction */.PH)("Command to the websocket server", function (path, body, _ref2) {\n  var onreply = _ref2.onreply,\n      onerror = _ref2.onerror,\n      onprogress = _ref2.onprogress,\n      timeout = _ref2.timeout,\n      original = _ref2.original,\n      parentMessageIds = _ref2.parentMessageIds;\n  return {\n    path: path,\n    body: body,\n    onreply: onreply,\n    onerror: onerror,\n    onprogress: onprogress,\n    timeout: timeout,\n    original: original,\n    parentMessageIds: parentMessageIds\n  };\n});\n\nfunction maybeTimeoutMessage(actions, messageId) {\n  var action, response;\n  return regenerator_default().wrap(function maybeTimeoutMessage$(_context) {\n    while (1) {\n      switch (_context.prev = _context.next) {\n        case 0:\n          action = actions[messageId];\n          _context.next = 3;\n          return (0,redux_saga_effects_npm_proxy_esm/* delay */.gw)(action.timeout || 5000);\n\n        case 3:\n          _context.prev = 3;\n          response = action.onerror({\n            error: "Timedout waiting for a reply to the message",\n            error_code: "Timedout"\n          });\n\n        case 5:\n          _context.prev = 5;\n\n          if (!response) {\n            _context.next = 10;\n            break;\n          }\n\n          _context.next = 9;\n          return (0,redux_saga_effects_npm_proxy_esm/* put */.gz)(response);\n\n        case 9:\n          delete actions[messageId];\n\n        case 10:\n          return _context.finish(5);\n\n        case 11:\n        case "end":\n          return _context.stop();\n      }\n    }\n  }, _marked, null, [[3,, 5, 11]]);\n}\n\nfunction sendToSocket(socket, sendch, actions) {\n  var action, response;\n  return regenerator_default().wrap(function sendToSocket$(_context2) {\n    while (1) {\n      switch (_context2.prev = _context2.next) {\n        case 0:\n          if (false) {}\n\n          _context2.next = 3;\n          return (0,redux_saga_effects_npm_proxy_esm/* take */.qn)(sendch);\n\n        case 3:\n          action = _context2.sent;\n\n          if (!(socket.readyState === 1)) {\n            _context2.next = 8;\n            break;\n          }\n\n          socket.send(JSON.stringify(action.data));\n          _context2.next = 16;\n          break;\n\n        case 8:\n          _context2.prev = 8;\n          response = action.onerror({\n            error: "Connection to the server wasn\'t active",\n            error_code: "InactiveConnection"\n          });\n\n        case 10:\n          _context2.prev = 10;\n\n          if (!response) {\n            _context2.next = 15;\n            break;\n          }\n\n          _context2.next = 14;\n          return (0,redux_saga_effects_npm_proxy_esm/* put */.gz)(response);\n\n        case 14:\n          delete actions[action.messageId];\n\n        case 15:\n          return _context2.finish(10);\n\n        case 16:\n          _context2.next = 0;\n          break;\n\n        case 18:\n        case "end":\n          return _context2.stop();\n      }\n    }\n  }, _marked2, null, [[8,, 10, 16]]);\n}\n\nfunction tickMessages(socket) {\n  return regenerator_default().wrap(function tickMessages$(_context3) {\n    while (1) {\n      switch (_context3.prev = _context3.next) {\n        case 0:\n          if (false) {}\n\n          _context3.next = 3;\n          return (0,redux_saga_effects_npm_proxy_esm/* delay */.gw)(15000);\n\n        case 3:\n          if (socket.readyState === 1) {\n            socket.send(JSON.stringify({\n              path: "__tick__"\n            }));\n          }\n\n          _context3.next = 0;\n          break;\n\n        case 6:\n        case "end":\n          return _context3.stop();\n      }\n    }\n  }, _marked3);\n}\n\nfunction startWS(url, _, sendch, receivech, actions) {\n  var socket, oncloses, ws, start, _yield$race, timeout, w, diff, waiter, ticker, sender;\n\n  return regenerator_default().wrap(function startWS$(_context4) {\n    while (1) {\n      switch (_context4.prev = _context4.next) {\n        case 0:\n          socket = new WebSocket(url);\n          oncloses = [];\n          ws = new Promise(function (resolve, reject) {\n            socket.onopen = function () {\n              resolve(socket);\n            };\n\n            socket.onmessage = function (event) {\n              return receivech.put(event);\n            };\n\n            socket.onerror = function (evt) {\n              console.error("Websocket got error", evt);\n              reject(evt);\n            };\n\n            socket.onclose = function (evt) {\n              console.error("Websocket closed", evt);\n              reject(evt);\n              oncloses.map(function (cb) {\n                try {\n                  cb(evt);\n                } catch (e) {\n                  console.error(e);\n                }\n              });\n            };\n          });\n          start = Date.now();\n          _context4.prev = 4;\n          _context4.next = 7;\n          return (0,redux_saga_effects_npm_proxy_esm/* race */.S3)({\n            timeout: (0,redux_saga_effects_npm_proxy_esm/* delay */.gw)(2000),\n            w: ws\n          });\n\n        case 7:\n          _yield$race = _context4.sent;\n          timeout = _yield$race.timeout;\n          w = _yield$race.w;\n          _context4.next = 22;\n          break;\n\n        case 12:\n          _context4.prev = 12;\n          _context4.t0 = _context4["catch"](4);\n          console.error("Failed to start websocket connection", _context4.t0);\n          _context4.next = 17;\n          return (0,redux_saga_effects_npm_proxy_esm/* put */.gz)(WSState.Error({\n            error: {\n              error: "Could not connect to server",\n              error_code: "FailedToConnected"\n            }\n          }));\n\n        case 17:\n          diff = Date.now() - start;\n\n          if (!(diff < 1000)) {\n            _context4.next = 21;\n            break;\n          }\n\n          _context4.next = 21;\n          return (0,redux_saga_effects_npm_proxy_esm/* delay */.gw)(1000 - diff);\n\n        case 21:\n          return _context4.abrupt("return");\n\n        case 22:\n          if (!timeout) {\n            _context4.next = 26;\n            break;\n          }\n\n          console.error("timed out waiting for websocket");\n          socket.close();\n          return _context4.abrupt("return", false);\n\n        case 26:\n          _context4.next = 28;\n          return (0,redux_saga_effects_npm_proxy_esm/* call */.RE)(redux_saga_core_npm_proxy_esm/* channel */.CE);\n\n        case 28:\n          waiter = _context4.sent;\n          _context4.next = 31;\n          return (0,redux_saga_effects_npm_proxy_esm/* fork */.rM)(tickMessages, w);\n\n        case 31:\n          ticker = _context4.sent;\n          _context4.next = 34;\n          return (0,redux_saga_effects_npm_proxy_esm/* fork */.rM)(sendToSocket, w, sendch, actions);\n\n        case 34:\n          sender = _context4.sent;\n          oncloses.push(function () {\n            waiter.put(redux_saga_core_npm_proxy_esm/* END */.uR);\n          });\n          _context4.prev = 36;\n          _context4.next = 39;\n          return (0,redux_saga_effects_npm_proxy_esm/* put */.gz)(WSState.Connected());\n\n        case 39:\n          _context4.next = 41;\n          return (0,redux_saga_effects_npm_proxy_esm/* take */.qn)(waiter);\n\n        case 41:\n          _context4.prev = 41;\n          _context4.next = 44;\n          return (0,redux_saga_effects_npm_proxy_esm/* put */.gz)(WSState.Error({\n            error: {\n              error: "Server went away",\n              error_code: "ServerWentAway"\n            }\n          }));\n\n        case 44:\n          waiter.close();\n          _context4.next = 47;\n          return (0,redux_saga_effects_npm_proxy_esm/* cancel */.al)(ticker);\n\n        case 47:\n          _context4.next = 49;\n          return (0,redux_saga_effects_npm_proxy_esm/* cancel */.al)(sender);\n\n        case 49:\n          return _context4.finish(41);\n\n        case 50:\n        case "end":\n          return _context4.stop();\n      }\n    }\n  }, _marked4, null, [[4, 12], [36,, 41, 50]]);\n}\n\nfunction processWsSend(commandch, sendch, actions, defaultonerror) {\n  var normalise, _yield$take, payload, messageId, normalised;\n\n  return regenerator_default().wrap(function processWsSend$(_context5) {\n    while (1) {\n      switch (_context5.prev = _context5.next) {\n        case 0:\n          normalise = function normalise(messageId, _ref3) {\n            var path = _ref3.path,\n                body = _ref3.body,\n                onerror = _ref3.onerror,\n                onreply = _ref3.onreply,\n                onprogress = _ref3.onprogress,\n                original = _ref3.original,\n                timeout = _ref3.timeout;\n            var done = false;\n\n            var create = function create(cb, msg) {\n              try {\n                return cb(msg);\n              } catch (e) {\n                console.error(e);\n\n                try {\n                  return defaultonerror({\n                    error_code: "INTERNAL_ERROR",\n                    error: e.toString()\n                  });\n                } catch (e2) {\n                  console.error(e2);\n                }\n              }\n            };\n\n            var data = {\n              path: path,\n              body: body,\n              message_id: messageId\n            };\n\n            var doerror = function doerror(error) {\n              if (done) {\n                return;\n              }\n\n              done = true;\n\n              if (onerror) {\n                return (0,redux_saga_effects_npm_proxy_esm/* put */.gz)(create(onerror, _objectSpread(_objectSpread({}, error), {}, {\n                  messageId: messageId,\n                  original: original\n                })));\n              }\n            };\n\n            var doreply = function doreply(data) {\n              if (done || !data) {\n                return;\n              }\n\n              done = true;\n              var payloads = [];\n\n              if (data.error_code && onerror) {\n                payloads.push((0,redux_saga_effects_npm_proxy_esm/* put */.gz)(create(onerror, _objectSpread(_objectSpread({}, data), {}, {\n                  namespace: "",\n                  messageId: messageId,\n                  original: original\n                }))));\n              } else if (data.error && onerror) {\n                payloads.push((0,redux_saga_effects_npm_proxy_esm/* put */.gz)(create(onerror, _objectSpread(_objectSpread({}, data.error.msg), {}, {\n                  namespace: data.error.namespace,\n                  messageId: messageId,\n                  original: original\n                }))));\n              }\n\n              if (data.result && onreply) {\n                payloads.push((0,redux_saga_effects_npm_proxy_esm/* put */.gz)(create(onreply, {\n                  messageId: messageId,\n                  data: data.result,\n                  original: original\n                })));\n              }\n\n              return (0,redux_saga_effects_npm_proxy_esm/* all */.$6)(payloads);\n            };\n\n            var doprogress = function doprogress(progress) {\n              if (onprogress) {\n                return (0,redux_saga_effects_npm_proxy_esm/* put */.gz)(create(onprogress, {\n                  messageId: messageId,\n                  progress: progress,\n                  original: original\n                }));\n              }\n            };\n\n            return {\n              data: data,\n              timeouter: undefined,\n              messageId: messageId,\n              timeout: timeout,\n              onreply: doreply,\n              onerror: doerror,\n              onprogress: doprogress\n            };\n          };\n\n        case 1:\n          if (false) {}\n\n          _context5.next = 4;\n          return (0,redux_saga_effects_npm_proxy_esm/* take */.qn)(commandch);\n\n        case 4:\n          _yield$take = _context5.sent;\n          payload = _yield$take.payload;\n          messageId = (0,v4/* default */.Z)();\n\n          if (payload.parentMessageIds) {\n            messageId = [].concat((0,toConsumableArray/* default */.Z)(payload.parentMessageIds), [messageId]);\n          }\n\n          normalised = normalise(messageId, payload);\n          actions[messageId] = normalised;\n          _context5.next = 12;\n          return (0,redux_saga_effects_npm_proxy_esm/* spawn */.Cs)(maybeTimeoutMessage, actions, messageId);\n\n        case 12:\n          normalised.timeouter = _context5.sent;\n          _context5.next = 15;\n          return (0,redux_saga_effects_npm_proxy_esm/* put */.gz)(sendch, normalised);\n\n        case 15:\n          _context5.next = 1;\n          break;\n\n        case 17:\n        case "end":\n          return _context5.stop();\n      }\n    }\n  }, _marked5);\n}\n\nfunction processWsReceive(receivech, actions) {\n  var makeResponse, _yield$take2, data, action, response;\n\n  return regenerator_default().wrap(function processWsReceive$(_context6) {\n    while (1) {\n      switch (_context6.prev = _context6.next) {\n        case 0:\n          makeResponse = function makeResponse(action, data) {\n            if (data.reply) {\n              if (data.reply.progress) {\n                return action.onprogress(data.reply.progress);\n              } else {\n                return action.onreply(data.reply, data.message_id);\n              }\n            }\n\n            if (data.error) {\n              return action.onerror(data.error);\n            }\n          };\n\n        case 1:\n          if (false) {}\n\n          _context6.next = 4;\n          return (0,redux_saga_effects_npm_proxy_esm/* take */.qn)(receivech);\n\n        case 4:\n          _yield$take2 = _context6.sent;\n          data = _yield$take2.data;\n          _context6.prev = 6;\n          data = JSON.parse(data);\n          _context6.next = 14;\n          break;\n\n        case 10:\n          _context6.prev = 10;\n          _context6.t0 = _context6["catch"](6);\n          console.error("failed to parse json from the server", _context6.t0);\n          return _context6.abrupt("continue", 1);\n\n        case 14:\n          if (data.message_id) {\n            _context6.next = 17;\n            break;\n          }\n\n          console.error("Got a message from the server without a message id", data);\n          return _context6.abrupt("continue", 1);\n\n        case 17:\n          if (!(data.message_id == "__tick__")) {\n            _context6.next = 19;\n            break;\n          }\n\n          return _context6.abrupt("continue", 1);\n\n        case 19:\n          if (!(data.message_id == "__server_time__")) {\n            _context6.next = 23;\n            break;\n          }\n\n          _context6.next = 22;\n          return (0,redux_saga_effects_npm_proxy_esm/* put */.gz)(WSState.ServerTime(data.reply));\n\n        case 22:\n          return _context6.abrupt("continue", 1);\n\n        case 23:\n          action = actions[data.message_id];\n\n          if (action) {\n            _context6.next = 27;\n            break;\n          }\n\n          console.error("Got a message from the server with unknown message id", data.message_id, data);\n          return _context6.abrupt("continue", 1);\n\n        case 27:\n          if (!action.timeouter) {\n            _context6.next = 30;\n            break;\n          }\n\n          _context6.next = 30;\n          return (0,redux_saga_effects_npm_proxy_esm/* cancel */.al)(action.timeouter);\n\n        case 30:\n          response = undefined;\n          _context6.prev = 31;\n          response = makeResponse(action, data);\n\n        case 33:\n          _context6.prev = 33;\n\n          if (!response) {\n            _context6.next = 37;\n            break;\n          }\n\n          _context6.next = 37;\n          return response;\n\n        case 37:\n          return _context6.finish(33);\n\n        case 38:\n          // Finished with this message if not a progress message\n          if (response && (!data.reply || !data.reply.progress)) {\n            delete actions[data.message_id];\n          }\n\n          _context6.next = 1;\n          break;\n\n        case 41:\n        case "end":\n          return _context6.stop();\n      }\n    }\n  }, _marked6, null, [[6, 10], [31,, 33, 38]]);\n}\n\nfunction getWSCommands(commandch) {\n  var nxt;\n  return regenerator_default().wrap(function getWSCommands$(_context7) {\n    while (1) {\n      switch (_context7.prev = _context7.next) {\n        case 0:\n          if (false) {}\n\n          _context7.next = 3;\n          return (0,redux_saga_effects_npm_proxy_esm/* take */.qn)(WSCommand);\n\n        case 3:\n          nxt = _context7.sent;\n          _context7.next = 6;\n          return (0,redux_saga_effects_npm_proxy_esm/* put */.gz)(commandch, nxt);\n\n        case 6:\n          _context7.next = 0;\n          break;\n\n        case 8:\n        case "end":\n          return _context7.stop();\n      }\n    }\n  }, _marked7);\n}\nfunction listen(url, defaultonerror, delayMS) {\n  var count, messages, sendch, receivech, commandch, actions, sendprocess, receiveprocess, ids, i, action, response;\n  return regenerator_default().wrap(function listen$(_context8) {\n    while (1) {\n      switch (_context8.prev = _context8.next) {\n        case 0:\n          count = 0;\n          messages = {};\n          _context8.next = 4;\n          return (0,redux_saga_effects_npm_proxy_esm/* call */.RE)(redux_saga_core_npm_proxy_esm/* channel */.CE);\n\n        case 4:\n          sendch = _context8.sent;\n          _context8.next = 7;\n          return (0,redux_saga_effects_npm_proxy_esm/* call */.RE)(redux_saga_core_npm_proxy_esm/* channel */.CE);\n\n        case 7:\n          receivech = _context8.sent;\n          _context8.next = 10;\n          return (0,redux_saga_effects_npm_proxy_esm/* call */.RE)(redux_saga_core_npm_proxy_esm/* channel */.CE);\n\n        case 10:\n          commandch = _context8.sent;\n\n          if (defaultonerror === undefined) {\n            defaultonerror = function defaultonerror(e) {\n              return console.error(e);\n            };\n          } // This is outside the while true so that we don\'t miss messages\n          // when the server goes away and before we\'ve started processWsSend again\n\n\n          _context8.next = 14;\n          return (0,redux_saga_effects_npm_proxy_esm/* fork */.rM)(getWSCommands, commandch);\n\n        case 14:\n          if (false) {}\n\n          _context8.next = 17;\n          return (0,redux_saga_effects_npm_proxy_esm/* put */.gz)(WSState.Loading());\n\n        case 17:\n          count += 1;\n          actions = {};\n          messages[count] = actions;\n          _context8.next = 22;\n          return (0,redux_saga_effects_npm_proxy_esm/* fork */.rM)(processWsSend, commandch, sendch, actions, defaultonerror);\n\n        case 22:\n          sendprocess = _context8.sent;\n          _context8.next = 25;\n          return (0,redux_saga_effects_npm_proxy_esm/* fork */.rM)(processWsReceive, receivech, actions);\n\n        case 25:\n          receiveprocess = _context8.sent;\n          _context8.next = 28;\n          return (0,redux_saga_effects_npm_proxy_esm/* call */.RE)(startWS, url, count, sendch, receivech, actions);\n\n        case 28:\n          _context8.next = 30;\n          return (0,redux_saga_effects_npm_proxy_esm/* cancel */.al)(sendprocess);\n\n        case 30:\n          _context8.next = 32;\n          return (0,redux_saga_effects_npm_proxy_esm/* cancel */.al)(receiveprocess);\n\n        case 32:\n          ids = Object.keys(actions);\n          i = 0;\n\n        case 34:\n          if (!(i < ids.length)) {\n            _context8.next = 46;\n            break;\n          }\n\n          action = actions[ids[i]];\n\n          if (!action.timeouter) {\n            _context8.next = 39;\n            break;\n          }\n\n          _context8.next = 39;\n          return (0,redux_saga_effects_npm_proxy_esm/* cancel */.al)(action.timeouter);\n\n        case 39:\n          response = action.onerror({\n            error: "Lost connection to the server",\n            error_code: "LostConnection"\n          });\n\n          if (!response) {\n            _context8.next = 43;\n            break;\n          }\n\n          _context8.next = 43;\n          return (0,redux_saga_effects_npm_proxy_esm/* put */.gz)(response);\n\n        case 43:\n          i++;\n          _context8.next = 34;\n          break;\n\n        case 46:\n          delete messages[count];\n          _context8.next = 49;\n          return (0,redux_saga_effects_npm_proxy_esm/* delay */.gw)(delayMS || 5000);\n\n        case 49:\n          _context8.next = 14;\n          break;\n\n        case 51:\n        case "end":\n          return _context8.stop();\n      }\n    }\n  }, _marked8);\n}\n;// CONCATENATED MODULE: ./js/state.js\n\n\n\n\n\nvar state_marked = /*#__PURE__*/regenerator_default().mark(wsConnectedSaga),\n    state_marked2 = /*#__PURE__*/regenerator_default().mark(changePositionSaga),\n    state_marked3 = /*#__PURE__*/regenerator_default().mark(highlightSaga),\n    state_marked4 = /*#__PURE__*/regenerator_default().mark(makePartStreamSaga),\n    state_marked5 = /*#__PURE__*/regenerator_default().mark(streamProgressSaga),\n    state_marked6 = /*#__PURE__*/regenerator_default().mark(partsSaga);\n\nfunction state_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\n\nfunction state_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? state_ownKeys(Object(source), !0).forEach(function (key) { (0,defineProperty/* default */.Z)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : state_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\n\n\n\n\n\nvar combine_parts = function combine_parts(parts, existing) {\n  var by_key = {};\n  existing.map(function (part) {\n    by_key[part.key] = part;\n  });\n  var result = [];\n  var anyDifferent = false;\n  parts.map(function (part) {\n    if (!by_key[part.key]) {\n      by_key[part.key] = {};\n    }\n\n    var nxt = state_objectSpread(state_objectSpread({}, by_key[part.key]), part);\n\n    var different = false;\n    Object.keys(nxt).map(function (attr) {\n      if (by_key[part.key][attr] != nxt[attr]) {\n        different = true;\n      }\n    });\n\n    if (different) {\n      result.push(nxt);\n      anyDifferent = true;\n    } else {\n      result.push(by_key[part.key]);\n    }\n  });\n\n  if (anyDifferent) {\n    return result;\n  } else {\n    return existing;\n  }\n};\n\nvar PartsStateKls = /*#__PURE__*/function () {\n  function PartsStateKls() {\n    (0,classCallCheck/* default */.Z)(this, PartsStateKls);\n\n    (0,defineProperty/* default */.Z)(this, "Error", (0,esm/* createAction */.PH)("Failed to interact with the server", function (_ref) {\n      var namespace = _ref.namespace,\n          error = _ref.error,\n          error_code = _ref.error_code,\n          reason = _ref.reason,\n          original = _ref.original;\n\n      if (!reason) {\n        reason = original.type.substr(original.type.indexOf("] ") + 2);\n\n        if (original.reason) {\n          reason = original.reason;\n        }\n      }\n\n      reason = "".concat(error_code, ": Failure while ").concat(reason);\n\n      if (typeof error !== "string" && !(error instanceof String)) {\n        error = JSON.stringify(error);\n      }\n\n      return {\n        namespace: namespace,\n        reason: reason,\n        error: error,\n        original: original\n      };\n    }));\n\n    (0,defineProperty/* default */.Z)(this, "ClearError", (0,esm/* createAction */.PH)("Clear error"));\n\n    (0,defineProperty/* default */.Z)(this, "MakeStream", (0,esm/* createAction */.PH)("Make a stream"));\n\n    (0,defineProperty/* default */.Z)(this, "StartedStream", (0,esm/* createAction */.PH)("Started a stream", function (messageId) {\n      return {\n        messageId: messageId\n      };\n    }));\n\n    (0,defineProperty/* default */.Z)(this, "LoadingStream", (0,esm/* createAction */.PH)("Loading a stream"));\n\n    (0,defineProperty/* default */.Z)(this, "StreamProgress", (0,esm/* createAction */.PH)("Progress from a stream"));\n\n    (0,defineProperty/* default */.Z)(this, "Highlight", (0,esm/* createAction */.PH)("highlight a part", function (serial, part_number) {\n      return {\n        serial: serial,\n        part_number: part_number\n      };\n    }));\n\n    (0,defineProperty/* default */.Z)(this, "GotParts", (0,esm/* createAction */.PH)("Got parts"));\n\n    (0,defineProperty/* default */.Z)(this, "ChangePosition", (0,esm/* createAction */.PH)("Change Position"));\n  }\n\n  (0,createClass/* default */.Z)(PartsStateKls, [{\n    key: "reducer",\n    value: function reducer() {\n      var _createReducer;\n\n      return (0,esm/* createReducer */.Lq)((_createReducer = {}, (0,defineProperty/* default */.Z)(_createReducer, this.Error, function (state, error) {\n        return state_objectSpread(state_objectSpread({}, state), {}, {\n          error: error\n        });\n      }), (0,defineProperty/* default */.Z)(_createReducer, this.ClearError, function (state) {\n        return state_objectSpread(state_objectSpread({}, state), {}, {\n          error: undefined\n        });\n      }), (0,defineProperty/* default */.Z)(_createReducer, this.StartedStream, function (state, _ref2) {\n        var messageId = _ref2.messageId;\n        return state_objectSpread(state_objectSpread({}, state), {}, {\n          loading: false,\n          messageId: messageId\n        });\n      }), (0,defineProperty/* default */.Z)(_createReducer, WSState.Error, function (state) {\n        return state_objectSpread(state_objectSpread({}, state), {}, {\n          loading: false,\n          parts: []\n        });\n      }), (0,defineProperty/* default */.Z)(_createReducer, this.LoadingStream, function (state) {\n        return state_objectSpread(state_objectSpread({}, state), {}, {\n          loading: true,\n          error: undefined,\n          parts: [],\n          messageId: undefined\n        });\n      }), (0,defineProperty/* default */.Z)(_createReducer, this.GotParts, function (state, parts) {\n        return state_objectSpread(state_objectSpread({}, state), {}, {\n          parts: combine_parts(parts, state.parts),\n          waiting: false\n        });\n      }), _createReducer), {\n        parts: [],\n        error: undefined,\n        waiting: true,\n        loading: false,\n        messageId: undefined\n      });\n    }\n  }]);\n\n  return PartsStateKls;\n}();\n\nvar PartState = new PartsStateKls();\n\nfunction wsConnectedSaga() {\n  return regenerator_default().wrap(function wsConnectedSaga$(_context) {\n    while (1) {\n      switch (_context.prev = _context.next) {\n        case 0:\n          _context.next = 2;\n          return (0,redux_saga_effects_npm_proxy_esm/* put */.gz)(PartState.MakeStream());\n\n        case 2:\n        case "end":\n          return _context.stop();\n      }\n    }\n  }, state_marked);\n}\n\nfunction changePositionSaga(original) {\n  var messageId;\n  return regenerator_default().wrap(function changePositionSaga$(_context2) {\n    while (1) {\n      switch (_context2.prev = _context2.next) {\n        case 0:\n          _context2.next = 2;\n          return (0,redux_saga_effects_npm_proxy_esm/* select */.Ys)(function (state) {\n            return state.parts.messageId;\n          });\n\n        case 2:\n          messageId = _context2.sent;\n\n          if (messageId) {\n            _context2.next = 5;\n            break;\n          }\n\n          return _context2.abrupt("return");\n\n        case 5:\n          _context2.next = 7;\n          return (0,redux_saga_effects_npm_proxy_esm/* put */.gz)(WSCommand("/v1/lifx/command", {\n            command: "change_position",\n            args: original.payload\n          }, {\n            onerror: PartState.Error,\n            original: original,\n            parentMessageIds: [messageId]\n          }));\n\n        case 7:\n        case "end":\n          return _context2.stop();\n      }\n    }\n  }, state_marked2);\n}\n\nfunction highlightSaga(original) {\n  var messageId;\n  return regenerator_default().wrap(function highlightSaga$(_context3) {\n    while (1) {\n      switch (_context3.prev = _context3.next) {\n        case 0:\n          _context3.next = 2;\n          return (0,redux_saga_effects_npm_proxy_esm/* select */.Ys)(function (state) {\n            return state.parts.messageId;\n          });\n\n        case 2:\n          messageId = _context3.sent;\n\n          if (messageId) {\n            _context3.next = 5;\n            break;\n          }\n\n          return _context3.abrupt("return");\n\n        case 5:\n          _context3.next = 7;\n          return (0,redux_saga_effects_npm_proxy_esm/* put */.gz)(WSCommand("/v1/lifx/command", {\n            command: "highlight",\n            args: original.payload\n          }, {\n            onerror: PartState.Error,\n            original: original,\n            parentMessageIds: [messageId]\n          }));\n\n        case 7:\n        case "end":\n          return _context3.stop();\n      }\n    }\n  }, state_marked3);\n}\n\nfunction makePartStreamSaga(original) {\n  var loading, onsuccess, onerror, onprogress;\n  return regenerator_default().wrap(function makePartStreamSaga$(_context4) {\n    while (1) {\n      switch (_context4.prev = _context4.next) {\n        case 0:\n          _context4.next = 2;\n          return (0,redux_saga_effects_npm_proxy_esm/* select */.Ys)(function (state) {\n            return state.parts.loading;\n          });\n\n        case 2:\n          loading = _context4.sent;\n\n          if (!loading) {\n            _context4.next = 5;\n            break;\n          }\n\n          return _context4.abrupt("return");\n\n        case 5:\n          onsuccess = PartState.LoadingStream;\n          onerror = PartState.Error;\n          onprogress = PartState.StreamProgress;\n          _context4.next = 10;\n          return (0,redux_saga_effects_npm_proxy_esm/* put */.gz)(PartState.LoadingStream());\n\n        case 10:\n          _context4.next = 12;\n          return (0,redux_saga_effects_npm_proxy_esm/* put */.gz)(WSCommand("/v1/lifx/command", {\n            command: "parts/store"\n          }, {\n            onsuccess: onsuccess,\n            onprogress: onprogress,\n            onerror: onerror,\n            original: original\n          }));\n\n        case 12:\n        case "end":\n          return _context4.stop();\n      }\n    }\n  }, state_marked4);\n}\n\nfunction streamProgressSaga(command) {\n  var payload, instruction;\n  return regenerator_default().wrap(function streamProgressSaga$(_context5) {\n    while (1) {\n      switch (_context5.prev = _context5.next) {\n        case 0:\n          payload = command.payload;\n\n          if (!payload.progress.error) {\n            _context5.next = 5;\n            break;\n          }\n\n          _context5.next = 4;\n          return (0,redux_saga_effects_npm_proxy_esm/* put */.gz)(PartState.Error(state_objectSpread(state_objectSpread({}, payload.progress), {}, {\n            original: {\n              type: "[] processing device discovery"\n            }\n          })));\n\n        case 4:\n          return _context5.abrupt("return");\n\n        case 5:\n          instruction = payload.progress.instruction;\n\n          if (!(instruction == "started")) {\n            _context5.next = 11;\n            break;\n          }\n\n          _context5.next = 9;\n          return (0,redux_saga_effects_npm_proxy_esm/* put */.gz)(PartState.StartedStream(payload.messageId));\n\n        case 9:\n          _context5.next = 14;\n          break;\n\n        case 11:\n          if (!(instruction == "parts")) {\n            _context5.next = 14;\n            break;\n          }\n\n          _context5.next = 14;\n          return (0,redux_saga_effects_npm_proxy_esm/* put */.gz)(PartState.GotParts(payload.progress.parts));\n\n        case 14:\n        case "end":\n          return _context5.stop();\n      }\n    }\n  }, state_marked5);\n}\n\nfunction partsSaga() {\n  return regenerator_default().wrap(function partsSaga$(_context6) {\n    while (1) {\n      switch (_context6.prev = _context6.next) {\n        case 0:\n          _context6.next = 2;\n          return (0,redux_saga_effects_npm_proxy_esm/* takeEvery */.ib)(PartState.StreamProgress, streamProgressSaga);\n\n        case 2:\n          _context6.next = 4;\n          return (0,redux_saga_effects_npm_proxy_esm/* takeEvery */.ib)(PartState.Highlight, highlightSaga);\n\n        case 4:\n          _context6.next = 6;\n          return (0,redux_saga_effects_npm_proxy_esm/* takeEvery */.ib)(PartState.ChangePosition, changePositionSaga);\n\n        case 6:\n          _context6.next = 8;\n          return (0,redux_saga_effects_npm_proxy_esm/* takeLatest */.Fm)(PartState.MakeStream, makePartStreamSaga);\n\n        case 8:\n          _context6.next = 10;\n          return (0,redux_saga_effects_npm_proxy_esm/* takeLatest */.Fm)(WSState.Connected, wsConnectedSaga);\n\n        case 10:\n        case "end":\n          return _context6.stop();\n      }\n    }\n  }, state_marked6);\n}\n// EXTERNAL MODULE: ./node_modules/react/jsx-runtime.js\nvar jsx_runtime = __webpack_require__(85893);\n;// CONCATENATED MODULE: ./js/parts.js\n\n\n\nfunction parts_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\n\nfunction parts_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? parts_ownKeys(Object(source), !0).forEach(function (key) { (0,defineProperty/* default */.Z)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : parts_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\n\n\n\n\n\n\n\n\nvar PartPixels = function PartPixels(_ref) {\n  var part = _ref.part,\n      pixelWidth = _ref.pixelWidth,\n      lineWidth = _ref.lineWidth;\n\n  var x = function x(col) {\n    return col * pixelWidth;\n  };\n\n  var y = function y(row) {\n    return row * pixelWidth;\n  };\n\n  return /*#__PURE__*/(0,jsx_runtime.jsxs)(ReactKonva/* Group */.ZA, {\n    children: [part.pixels.map(function (pixel) {\n      return /*#__PURE__*/(0,jsx_runtime.jsx)(ReactKonva/* Rect */.UL, {\n        width: pixelWidth,\n        height: pixelWidth,\n        x: x(pixel.col),\n        y: y(pixel.row),\n        fill: pixel.color\n      }, pixel.key);\n    }), /*#__PURE__*/(0,jsx_runtime.jsx)(ReactKonva/* Line */.x1, {\n      stroke: "white",\n      strokeWidth: lineWidth,\n      points: [x(0), y(0), x(part.width), y(0), x(part.width), y(part.height), x(0), y(part.height), x(0), y(0)]\n    })]\n  });\n};\n\nvar Part = function Part(_ref2) {\n  var part = _ref2.part,\n      zero_x = _ref2.zero_x,\n      zero_y = _ref2.zero_y,\n      pixelWidth = _ref2.pixelWidth,\n      partWidth = _ref2.partWidth;\n  var dispatch = (0,es/* useDispatch */.I0)();\n\n  var _useState = (0,react.useState)({\n    x: 0,\n    y: 0\n  }),\n      _useState2 = (0,slicedToArray/* default */.Z)(_useState, 2),\n      position = _useState2[0],\n      setPosition = _useState2[1];\n\n  var start_x = zero_x + part.user_x * pixelWidth;\n  var start_y = zero_y - part.user_y * pixelWidth;\n  var lineWidth = Math.max(Math.floor(pixelWidth / 2), 1);\n\n  var onDragEnd = function onDragEnd() {\n    var user_x = (position.x - zero_x) / pixelWidth;\n    var user_y = (zero_y - position.y) / pixelWidth;\n    dispatch(PartState.ChangePosition({\n      serial: part.serial,\n      part_number: part.part_number,\n      user_x: user_x,\n      user_y: user_y\n    }));\n  };\n\n  var dragBound = function dragBound(pos) {\n    var newpos = {\n      x: pos.x - (pos.x - zero_x) % pixelWidth,\n      y: pos.y - (pos.y - zero_y) % pixelWidth\n    };\n    setPosition(newpos);\n    return newpos;\n  };\n\n  return /*#__PURE__*/(0,jsx_runtime.jsx)(ReactKonva/* Group */.ZA, {\n    x: start_x,\n    y: start_y,\n    draggable: true,\n    onDragEnd: onDragEnd,\n    dragBoundFunc: dragBound,\n    onClick: function onClick() {\n      return dispatch(PartState.Highlight(part.serial, part.part_number));\n    },\n    onTap: function onTap() {\n      return dispatch(PartState.Highlight(part.serial, part.part_number));\n    },\n    children: /*#__PURE__*/(0,jsx_runtime.jsx)(PartPixels, {\n      serial: part.serial,\n      part: part,\n      pixelWidth: pixelWidth,\n      lineWidth: lineWidth,\n      partWidth: partWidth\n    })\n  });\n};\n\n/* harmony default export */ const parts = (function (props) {\n  var parts = (0,es/* useSelector */.v9)(function (state) {\n    return state.parts.parts;\n  });\n  return /*#__PURE__*/(0,jsx_runtime.jsx)(ReactKonva/* Layer */.mh, {\n    children: parts.map(function (part) {\n      return /*#__PURE__*/(0,jsx_runtime.jsx)(Part, parts_objectSpread({\n        part: part\n      }, props), part.key);\n    })\n  });\n});\n;// CONCATENATED MODULE: ./js/page.js\n\n\n\nfunction page_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\n\nfunction page_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? page_ownKeys(Object(source), !0).forEach(function (key) { (0,defineProperty/* default */.Z)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : page_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\n\n\n\n\n\n\n\n\nfunction getPos(el) {\n  for (var lx = 0, ly = 0; el != null; lx += el.offsetLeft, ly += el.offsetTop, el = el.offsetParent) {\n    ;\n  }\n\n  return {\n    x: lx,\n    y: ly\n  };\n}\n\nfunction x_y_for_evt(evt, offset) {\n  var s_x, s_y;\n\n  if (evt.clientX === undefined) {\n    s_x = evt.changedTouches[0].clientX - offset.x;\n    s_y = evt.changedTouches[0].clientY - offset.y;\n  } else {\n    s_x = evt.clientX - offset.x;\n    s_y = evt.clientY - offset.y;\n  }\n\n  return [s_x, s_y];\n}\n\nfunction makeGrid(dimensions, zerosState) {\n  var pixelWidth = dimensions.pixelWidth,\n      height = dimensions.height,\n      width = dimensions.width;\n  var squareWidth = pixelWidth * 8;\n  var grid = [/*#__PURE__*/(0,jsx_runtime.jsx)(ReactKonva/* Line */.x1, {\n    strokeWidth: 2,\n    stroke: "red",\n    points: [zerosState.zero_x, 0, zerosState.zero_x, height]\n  }, "centerx0"), /*#__PURE__*/(0,jsx_runtime.jsx)(ReactKonva/* Line */.x1, {\n    strokeWidth: 2,\n    stroke: "red",\n    points: [0, zerosState.zero_y, width, zerosState.zero_y]\n  }, "centery0")];\n  var i;\n\n  for (i = zerosState.zero_x + squareWidth; i <= width + squareWidth * 2; i += squareWidth) {\n    if (i > 0) {\n      grid.push( /*#__PURE__*/(0,jsx_runtime.jsx)(ReactKonva/* Line */.x1, {\n        strokeWidth: 1,\n        stroke: "#868686",\n        points: [i, 0, i, height]\n      }, "rcol" + i));\n    }\n  }\n\n  for (i = zerosState.zero_x - squareWidth; i >= -squareWidth * 2; i -= squareWidth) {\n    if (i < width) {\n      grid.push( /*#__PURE__*/(0,jsx_runtime.jsx)(ReactKonva/* Line */.x1, {\n        strokeWidth: 1,\n        stroke: "#868686",\n        points: [i, 0, i, height]\n      }, "lcol" + i));\n    }\n  }\n\n  for (i = zerosState.zero_y + squareWidth; i <= height + squareWidth * 2; i += squareWidth) {\n    if (i > 0) {\n      grid.push( /*#__PURE__*/(0,jsx_runtime.jsx)(ReactKonva/* Line */.x1, {\n        strokeWidth: 1,\n        stroke: "#868686",\n        points: [0, i, width, i]\n      }, "trow" + i));\n    }\n  }\n\n  for (i = zerosState.zero_y - squareWidth; i >= -squareWidth * 2; i -= squareWidth) {\n    if (i < height) {\n      grid.push( /*#__PURE__*/(0,jsx_runtime.jsx)(ReactKonva/* Line */.x1, {\n        strokeWidth: 1,\n        stroke: "#868686",\n        points: [0, i, width, i]\n      }, "bcol" + i));\n    }\n  }\n\n  return grid;\n}\n\n/* harmony default export */ const page = (function () {\n  var makeDimensions = function makeDimensions() {\n    var width = Math.max(document.documentElement.clientWidth, window.innerWidth || 0);\n    var height = Math.max(document.documentElement.clientHeight, window.innerHeight || 0);\n    var pixelWidth = Math.ceil(window.innerWidth / 40 / 8);\n    return {\n      width: width,\n      height: height,\n      pixelWidth: pixelWidth\n    };\n  };\n\n  var _useState = (0,react.useState)(makeDimensions()),\n      _useState2 = (0,slicedToArray/* default */.Z)(_useState, 2),\n      dimensions = _useState2[0],\n      setDimensions = _useState2[1];\n\n  var zeroReducer = function zeroReducer(state, action) {\n    var offset = getPos(action.e.target.getStage().attrs.container);\n\n    var _x_y_for_evt = x_y_for_evt(action.e.evt, offset),\n        _x_y_for_evt2 = (0,slicedToArray/* default */.Z)(_x_y_for_evt, 2),\n        s_x = _x_y_for_evt2[0],\n        s_y = _x_y_for_evt2[1];\n\n    switch (action.type) {\n      case "drag_grid_start":\n        return page_objectSpread(page_objectSpread({}, state), {}, {\n          grid_x: s_x,\n          grid_y: s_y,\n          start_offset: {\n            zero_x: state.zero_x,\n            zero_y: state.zero_y\n          }\n        });\n\n      case "drag_grid":\n        var diffx = state.grid_x - s_x;\n        var diffy = state.grid_y - s_y;\n        return page_objectSpread(page_objectSpread({}, state), {}, {\n          zero_x: state.start_offset.zero_x - diffx,\n          zero_y: state.start_offset.zero_y - diffy\n        });\n\n      default:\n        throw new Error("Unknown event ".concat(action.type));\n    }\n  };\n\n  var width = dimensions.width;\n  var height = dimensions.height;\n  var zero_x = Math.floor(width / 2);\n  var zero_y = Math.floor(height / 2);\n\n  var _useReducer = (0,react.useReducer)(zeroReducer, {\n    zero_x: zero_x,\n    zero_y: zero_y,\n    grid_x: 0,\n    grid_y: 0,\n    start_offset: {\n      zero_x: zero_x,\n      zero_y: zero_y\n    }\n  }),\n      _useReducer2 = (0,slicedToArray/* default */.Z)(_useReducer, 2),\n      zerosState = _useReducer2[0],\n      dispatchZeros = _useReducer2[1];\n\n  (0,react.useEffect)(function () {\n    function handleResize() {\n      setDimensions(makeDimensions());\n    }\n\n    window.addEventListener("resize", handleResize);\n    return function () {\n      return window.removeEventListener("resize", handleResize);\n    };\n  }, []);\n  zero_x = Math.floor(width / 2);\n  zero_y = Math.floor(height / 2) - 100;\n  return /*#__PURE__*/(0,jsx_runtime.jsx)(es/* ReactReduxContext.Consumer */.ET.Consumer, {\n    children: function children(_ref) {\n      var store = _ref.store;\n      return /*#__PURE__*/(0,jsx_runtime.jsx)(ReactKonva/* Stage */.Hf, {\n        width: width,\n        height: height,\n        fill: "red",\n        children: /*#__PURE__*/(0,jsx_runtime.jsxs)(es/* Provider */.zt, {\n          store: store,\n          children: [/*#__PURE__*/(0,jsx_runtime.jsx)(ReactKonva/* Layer */.mh, {\n            children: /*#__PURE__*/(0,jsx_runtime.jsx)(ReactKonva/* Rect */.UL, {\n              width: width,\n              height: height,\n              fill: "#e6e6e6",\n              draggable: true,\n              dragBoundFunc: function dragBoundFunc() {\n                return {\n                  x: 0,\n                  y: 0\n                };\n              },\n              onDragMove: function onDragMove(e) {\n                return dispatchZeros({\n                  type: "drag_grid",\n                  e: e\n                });\n              },\n              onDragStart: function onDragStart(e) {\n                return dispatchZeros({\n                  type: "drag_grid_start",\n                  e: e\n                });\n              }\n            })\n          }), /*#__PURE__*/(0,jsx_runtime.jsx)(ReactKonva/* Layer */.mh, {\n            children: makeGrid(dimensions, zerosState)\n          }), /*#__PURE__*/(0,jsx_runtime.jsx)(parts, {\n            zero_x: zerosState.zero_x,\n            zero_y: zerosState.zero_y,\n            pixelWidth: dimensions.pixelWidth\n          })]\n        })\n      });\n    }\n  });\n});\n// EXTERNAL MODULE: ./node_modules/redux/es/redux.js + 1 modules\nvar redux = __webpack_require__(97779);\n// EXTERNAL MODULE: ./node_modules/redux-devtools-extension/index.js\nvar redux_devtools_extension = __webpack_require__(28500);\n;// CONCATENATED MODULE: ./js/store.js\n\n\nfunction store_ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\n\nfunction store_objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? store_ownKeys(Object(source), !0).forEach(function (key) { (0,defineProperty/* default */.Z)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : store_ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\n\n\n\n\n\n\nvar makeReducer = function makeReducer(extra) {\n  return (0,redux/* combineReducers */.UY)(store_objectSpread(store_objectSpread({}, extra), {}, {\n    wsclient: WSState.reducer(),\n    parts: PartState.reducer()\n  }));\n};\nvar makeSagaMiddleware = function makeSagaMiddleware() {\n  return (0,redux_saga_core_npm_proxy_esm/* default */.ZP)();\n};\nvar makeStore = function makeStore(reducer, sagaMiddleware) {\n  var creator = (0,redux/* applyMiddleware */.md)(sagaMiddleware)(redux/* createStore */.MT);\n  return creator(reducer, (0,redux_devtools_extension/* devToolsEnhancer */.nR)());\n};\nvar runSagaMiddleware = function runSagaMiddleware(sagaMiddleware) {\n  sagaMiddleware.run(partsSaga);\n};\n;// CONCATENATED MODULE: ./js/index.js\n\n\nvar js_marked = /*#__PURE__*/regenerator_default().mark(mainSaga);\n\n\n\n\n\n\n\n\n\nvar reducer = makeReducer();\nvar sagaMiddleware = makeSagaMiddleware();\nvar store = makeStore(reducer, sagaMiddleware);\nrunSagaMiddleware(sagaMiddleware);\nvar scheme = "ws";\n\nif (window.location.protocol.startsWith("https")) {\n  scheme = "wss";\n}\n\nvar url = scheme + "://" + window.location.hostname + ":" + String(window.location.port) + "/v1/ws";\n\nfunction mainSaga() {\n  return regenerator_default().wrap(function mainSaga$(_context) {\n    while (1) {\n      switch (_context.prev = _context.next) {\n        case 0:\n          _context.next = 2;\n          return (0,redux_saga_effects_npm_proxy_esm/* fork */.rM)(listen, url);\n\n        case 2:\n        case "end":\n          return _context.stop();\n      }\n    }\n  }, js_marked);\n}\n\nsagaMiddleware.run(mainSaga);\n(0,react_dom.render)( /*#__PURE__*/(0,jsx_runtime.jsx)(es/* Provider */.zt, {\n  store: store,\n  children: /*#__PURE__*/(0,jsx_runtime.jsx)(page, {})\n}), document.getElementById("page"));//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///56488\n')}},__webpack_module_cache__={},deferred;function __webpack_require__(g){var I=__webpack_module_cache__[g];if(void 0!==I)return I.exports;var e=__webpack_module_cache__[g]={id:g,loaded:!1,exports:{}};return __webpack_modules__[g](e,e.exports,__webpack_require__),e.loaded=!0,e.exports}__webpack_require__.m=__webpack_modules__,deferred=[],__webpack_require__.O=(g,I,e,n)=>{if(!I){var t=1/0;for(B=0;B<deferred.length;B++){for(var[I,e,n]=deferred[B],C=!0,c=0;c<I.length;c++)(!1&n||t>=n)&&Object.keys(__webpack_require__.O).every((g=>__webpack_require__.O[g](I[c])))?I.splice(c--,1):(C=!1,n<t&&(t=n));if(C){deferred.splice(B--,1);var A=e();void 0!==A&&(g=A)}}return g}n=n||0;for(var B=deferred.length;B>0&&deferred[B-1][2]>n;B--)deferred[B]=deferred[B-1];deferred[B]=[I,e,n]},__webpack_require__.n=g=>{var I=g&&g.__esModule?()=>g.default:()=>g;return __webpack_require__.d(I,{a:I}),I},__webpack_require__.d=(g,I)=>{for(var e in I)__webpack_require__.o(I,e)&&!__webpack_require__.o(g,e)&&Object.defineProperty(g,e,{enumerable:!0,get:I[e]})},__webpack_require__.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(g){if("object"==typeof window)return window}}(),__webpack_require__.o=(g,I)=>Object.prototype.hasOwnProperty.call(g,I),__webpack_require__.r=g=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(g,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(g,"__esModule",{value:!0})},__webpack_require__.nmd=g=>(g.paths=[],g.children||(g.children=[]),g),(()=>{var g={179:0};__webpack_require__.O.j=I=>0===g[I];var I=(I,e)=>{var n,t,[C,c,A]=e,B=0;if(C.some((I=>0!==g[I]))){for(n in c)__webpack_require__.o(c,n)&&(__webpack_require__.m[n]=c[n]);if(A)var r=A(__webpack_require__)}for(I&&I(e);B<C.length;B++)t=C[B],__webpack_require__.o(g,t)&&g[t]&&g[t][0](),g[C[B]]=0;return __webpack_require__.O(r)},e=self.webpackChunkphotons_arranger=self.webpackChunkphotons_arranger||[];e.forEach(I.bind(null,0)),e.push=I.bind(null,e.push.bind(e))})();var __webpack_exports__=__webpack_require__.O(void 0,[618],(()=>__webpack_require__(56488)));__webpack_exports__=__webpack_require__.O(__webpack_exports__)})();