# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetInstanceConfigurationsResult',
    'AwaitableGetInstanceConfigurationsResult',
    'get_instance_configurations',
    'get_instance_configurations_output',
]

@pulumi.output_type
class GetInstanceConfigurationsResult:
    """
    A collection of values returned by getInstanceConfigurations.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, instance_configurations=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_configurations and not isinstance(instance_configurations, list):
            raise TypeError("Expected argument 'instance_configurations' to be a list")
        pulumi.set(__self__, "instance_configurations", instance_configurations)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing images to search
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetInstanceConfigurationsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceConfigurations")
    def instance_configurations(self) -> Sequence['outputs.GetInstanceConfigurationsInstanceConfigurationResult']:
        """
        The list of instance_configurations.
        """
        return pulumi.get(self, "instance_configurations")


class AwaitableGetInstanceConfigurationsResult(GetInstanceConfigurationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceConfigurationsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            instance_configurations=self.instance_configurations)


def get_instance_configurations(compartment_id: Optional[str] = None,
                                filters: Optional[Sequence[Union['GetInstanceConfigurationsFilterArgs', 'GetInstanceConfigurationsFilterArgsDict']]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceConfigurationsResult:
    """
    This data source provides the list of Instance Configurations in Oracle Cloud Infrastructure Core service.

    Lists the instance configurations in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_instance_configurations = oci.Core.get_instance_configurations(compartment_id=compartment_id)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getInstanceConfigurations:getInstanceConfigurations', __args__, opts=opts, typ=GetInstanceConfigurationsResult).value

    return AwaitableGetInstanceConfigurationsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        instance_configurations=pulumi.get(__ret__, 'instance_configurations'))
def get_instance_configurations_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetInstanceConfigurationsFilterArgs', 'GetInstanceConfigurationsFilterArgsDict']]]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstanceConfigurationsResult]:
    """
    This data source provides the list of Instance Configurations in Oracle Cloud Infrastructure Core service.

    Lists the instance configurations in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_instance_configurations = oci.Core.get_instance_configurations(compartment_id=compartment_id)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getInstanceConfigurations:getInstanceConfigurations', __args__, opts=opts, typ=GetInstanceConfigurationsResult)
    return __ret__.apply(lambda __response__: GetInstanceConfigurationsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        instance_configurations=pulumi.get(__response__, 'instance_configurations')))
