# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAutonomousDatabaseDataguardAssociationsResult',
    'AwaitableGetAutonomousDatabaseDataguardAssociationsResult',
    'get_autonomous_database_dataguard_associations',
    'get_autonomous_database_dataguard_associations_output',
]

@pulumi.output_type
class GetAutonomousDatabaseDataguardAssociationsResult:
    """
    A collection of values returned by getAutonomousDatabaseDataguardAssociations.
    """
    def __init__(__self__, autonomous_database_dataguard_associations=None, autonomous_database_id=None, filters=None, id=None):
        if autonomous_database_dataguard_associations and not isinstance(autonomous_database_dataguard_associations, list):
            raise TypeError("Expected argument 'autonomous_database_dataguard_associations' to be a list")
        pulumi.set(__self__, "autonomous_database_dataguard_associations", autonomous_database_dataguard_associations)
        if autonomous_database_id and not isinstance(autonomous_database_id, str):
            raise TypeError("Expected argument 'autonomous_database_id' to be a str")
        pulumi.set(__self__, "autonomous_database_id", autonomous_database_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="autonomousDatabaseDataguardAssociations")
    def autonomous_database_dataguard_associations(self) -> Sequence['outputs.GetAutonomousDatabaseDataguardAssociationsAutonomousDatabaseDataguardAssociationResult']:
        """
        The list of autonomous_database_dataguard_associations.
        """
        return pulumi.get(self, "autonomous_database_dataguard_associations")

    @property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous Database that has a relationship with the peer Autonomous Database.
        """
        return pulumi.get(self, "autonomous_database_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAutonomousDatabaseDataguardAssociationsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetAutonomousDatabaseDataguardAssociationsResult(GetAutonomousDatabaseDataguardAssociationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousDatabaseDataguardAssociationsResult(
            autonomous_database_dataguard_associations=self.autonomous_database_dataguard_associations,
            autonomous_database_id=self.autonomous_database_id,
            filters=self.filters,
            id=self.id)


def get_autonomous_database_dataguard_associations(autonomous_database_id: Optional[str] = None,
                                                   filters: Optional[Sequence[Union['GetAutonomousDatabaseDataguardAssociationsFilterArgs', 'GetAutonomousDatabaseDataguardAssociationsFilterArgsDict']]] = None,
                                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousDatabaseDataguardAssociationsResult:
    """
    This data source provides the list of Autonomous Database Dataguard Associations in Oracle Cloud Infrastructure Database service.

    Gets a list of the Autonomous Data Guard-enabled databases associated with the specified Autonomous Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_database_dataguard_associations = oci.Database.get_autonomous_database_dataguard_associations(autonomous_database_id=test_autonomous_database["id"])
    ```


    :param str autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['autonomousDatabaseId'] = autonomous_database_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousDatabaseDataguardAssociations:getAutonomousDatabaseDataguardAssociations', __args__, opts=opts, typ=GetAutonomousDatabaseDataguardAssociationsResult).value

    return AwaitableGetAutonomousDatabaseDataguardAssociationsResult(
        autonomous_database_dataguard_associations=pulumi.get(__ret__, 'autonomous_database_dataguard_associations'),
        autonomous_database_id=pulumi.get(__ret__, 'autonomous_database_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_autonomous_database_dataguard_associations_output(autonomous_database_id: Optional[pulumi.Input[str]] = None,
                                                          filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAutonomousDatabaseDataguardAssociationsFilterArgs', 'GetAutonomousDatabaseDataguardAssociationsFilterArgsDict']]]]] = None,
                                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAutonomousDatabaseDataguardAssociationsResult]:
    """
    This data source provides the list of Autonomous Database Dataguard Associations in Oracle Cloud Infrastructure Database service.

    Gets a list of the Autonomous Data Guard-enabled databases associated with the specified Autonomous Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_database_dataguard_associations = oci.Database.get_autonomous_database_dataguard_associations(autonomous_database_id=test_autonomous_database["id"])
    ```


    :param str autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['autonomousDatabaseId'] = autonomous_database_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getAutonomousDatabaseDataguardAssociations:getAutonomousDatabaseDataguardAssociations', __args__, opts=opts, typ=GetAutonomousDatabaseDataguardAssociationsResult)
    return __ret__.apply(lambda __response__: GetAutonomousDatabaseDataguardAssociationsResult(
        autonomous_database_dataguard_associations=pulumi.get(__response__, 'autonomous_database_dataguard_associations'),
        autonomous_database_id=pulumi.get(__response__, 'autonomous_database_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
