# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDelegatedResourceAccessRequestAuditLogReportResult',
    'AwaitableGetDelegatedResourceAccessRequestAuditLogReportResult',
    'get_delegated_resource_access_request_audit_log_report',
    'get_delegated_resource_access_request_audit_log_report_output',
]

@pulumi.output_type
class GetDelegatedResourceAccessRequestAuditLogReportResult:
    """
    A collection of values returned by getDelegatedResourceAccessRequestAuditLogReport.
    """
    def __init__(__self__, audit_report_status=None, delegated_resource_access_request_id=None, id=None, is_process_tree_enabled=None, process_tree=None, report=None, time_report_generated=None):
        if audit_report_status and not isinstance(audit_report_status, str):
            raise TypeError("Expected argument 'audit_report_status' to be a str")
        pulumi.set(__self__, "audit_report_status", audit_report_status)
        if delegated_resource_access_request_id and not isinstance(delegated_resource_access_request_id, str):
            raise TypeError("Expected argument 'delegated_resource_access_request_id' to be a str")
        pulumi.set(__self__, "delegated_resource_access_request_id", delegated_resource_access_request_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_process_tree_enabled and not isinstance(is_process_tree_enabled, bool):
            raise TypeError("Expected argument 'is_process_tree_enabled' to be a bool")
        pulumi.set(__self__, "is_process_tree_enabled", is_process_tree_enabled)
        if process_tree and not isinstance(process_tree, str):
            raise TypeError("Expected argument 'process_tree' to be a str")
        pulumi.set(__self__, "process_tree", process_tree)
        if report and not isinstance(report, str):
            raise TypeError("Expected argument 'report' to be a str")
        pulumi.set(__self__, "report", report)
        if time_report_generated and not isinstance(time_report_generated, str):
            raise TypeError("Expected argument 'time_report_generated' to be a str")
        pulumi.set(__self__, "time_report_generated", time_report_generated)

    @property
    @pulumi.getter(name="auditReportStatus")
    def audit_report_status(self) -> str:
        """
        Status of the audit report
        """
        return pulumi.get(self, "audit_report_status")

    @property
    @pulumi.getter(name="delegatedResourceAccessRequestId")
    def delegated_resource_access_request_id(self) -> str:
        return pulumi.get(self, "delegated_resource_access_request_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isProcessTreeEnabled")
    def is_process_tree_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "is_process_tree_enabled")

    @property
    @pulumi.getter(name="processTree")
    def process_tree(self) -> str:
        """
        The process tree data
        """
        return pulumi.get(self, "process_tree")

    @property
    @pulumi.getter
    def report(self) -> str:
        """
        Audit log report.
        """
        return pulumi.get(self, "report")

    @property
    @pulumi.getter(name="timeReportGenerated")
    def time_report_generated(self) -> str:
        """
        Time when the audit report was generated [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_report_generated")


class AwaitableGetDelegatedResourceAccessRequestAuditLogReportResult(GetDelegatedResourceAccessRequestAuditLogReportResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDelegatedResourceAccessRequestAuditLogReportResult(
            audit_report_status=self.audit_report_status,
            delegated_resource_access_request_id=self.delegated_resource_access_request_id,
            id=self.id,
            is_process_tree_enabled=self.is_process_tree_enabled,
            process_tree=self.process_tree,
            report=self.report,
            time_report_generated=self.time_report_generated)


def get_delegated_resource_access_request_audit_log_report(delegated_resource_access_request_id: Optional[str] = None,
                                                           is_process_tree_enabled: Optional[bool] = None,
                                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDelegatedResourceAccessRequestAuditLogReportResult:
    """
    This data source provides details about a specific Delegated Resource Access Request Audit Log Report resource in Oracle Cloud Infrastructure Delegate Access Control service.

    Gets the audit log report for the given Delegated Resource Access Request.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_delegated_resource_access_request_audit_log_report = oci.DelegateAccessControl.get_delegated_resource_access_request_audit_log_report(delegated_resource_access_request_id=test_delegated_resource_access_request["id"],
        is_process_tree_enabled=delegated_resource_access_request_audit_log_report_is_process_tree_enabled)
    ```


    :param str delegated_resource_access_request_id: Unique Delegated Resource Access Request identifier
    :param bool is_process_tree_enabled: Set to true to enable process tree computation in audit report
    """
    __args__ = dict()
    __args__['delegatedResourceAccessRequestId'] = delegated_resource_access_request_id
    __args__['isProcessTreeEnabled'] = is_process_tree_enabled
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DelegateAccessControl/getDelegatedResourceAccessRequestAuditLogReport:getDelegatedResourceAccessRequestAuditLogReport', __args__, opts=opts, typ=GetDelegatedResourceAccessRequestAuditLogReportResult).value

    return AwaitableGetDelegatedResourceAccessRequestAuditLogReportResult(
        audit_report_status=pulumi.get(__ret__, 'audit_report_status'),
        delegated_resource_access_request_id=pulumi.get(__ret__, 'delegated_resource_access_request_id'),
        id=pulumi.get(__ret__, 'id'),
        is_process_tree_enabled=pulumi.get(__ret__, 'is_process_tree_enabled'),
        process_tree=pulumi.get(__ret__, 'process_tree'),
        report=pulumi.get(__ret__, 'report'),
        time_report_generated=pulumi.get(__ret__, 'time_report_generated'))
def get_delegated_resource_access_request_audit_log_report_output(delegated_resource_access_request_id: Optional[pulumi.Input[str]] = None,
                                                                  is_process_tree_enabled: Optional[pulumi.Input[Optional[bool]]] = None,
                                                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDelegatedResourceAccessRequestAuditLogReportResult]:
    """
    This data source provides details about a specific Delegated Resource Access Request Audit Log Report resource in Oracle Cloud Infrastructure Delegate Access Control service.

    Gets the audit log report for the given Delegated Resource Access Request.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_delegated_resource_access_request_audit_log_report = oci.DelegateAccessControl.get_delegated_resource_access_request_audit_log_report(delegated_resource_access_request_id=test_delegated_resource_access_request["id"],
        is_process_tree_enabled=delegated_resource_access_request_audit_log_report_is_process_tree_enabled)
    ```


    :param str delegated_resource_access_request_id: Unique Delegated Resource Access Request identifier
    :param bool is_process_tree_enabled: Set to true to enable process tree computation in audit report
    """
    __args__ = dict()
    __args__['delegatedResourceAccessRequestId'] = delegated_resource_access_request_id
    __args__['isProcessTreeEnabled'] = is_process_tree_enabled
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DelegateAccessControl/getDelegatedResourceAccessRequestAuditLogReport:getDelegatedResourceAccessRequestAuditLogReport', __args__, opts=opts, typ=GetDelegatedResourceAccessRequestAuditLogReportResult)
    return __ret__.apply(lambda __response__: GetDelegatedResourceAccessRequestAuditLogReportResult(
        audit_report_status=pulumi.get(__response__, 'audit_report_status'),
        delegated_resource_access_request_id=pulumi.get(__response__, 'delegated_resource_access_request_id'),
        id=pulumi.get(__response__, 'id'),
        is_process_tree_enabled=pulumi.get(__response__, 'is_process_tree_enabled'),
        process_tree=pulumi.get(__response__, 'process_tree'),
        report=pulumi.get(__response__, 'report'),
        time_report_generated=pulumi.get(__response__, 'time_report_generated')))
