# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMaintenanceWindowsResult',
    'AwaitableGetMaintenanceWindowsResult',
    'get_maintenance_windows',
    'get_maintenance_windows_output',
]

@pulumi.output_type
class GetMaintenanceWindowsResult:
    """
    A collection of values returned by getMaintenanceWindows.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, maintenance_window_collections=None, state=None, time_schedule_start_greater_than_or_equal_to=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if maintenance_window_collections and not isinstance(maintenance_window_collections, list):
            raise TypeError("Expected argument 'maintenance_window_collections' to be a list")
        pulumi.set(__self__, "maintenance_window_collections", maintenance_window_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_schedule_start_greater_than_or_equal_to and not isinstance(time_schedule_start_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_schedule_start_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_schedule_start_greater_than_or_equal_to", time_schedule_start_greater_than_or_equal_to)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        Tenancy OCID
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMaintenanceWindowsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maintenanceWindowCollections")
    def maintenance_window_collections(self) -> Sequence['outputs.GetMaintenanceWindowsMaintenanceWindowCollectionResult']:
        """
        The list of maintenance_window_collection.
        """
        return pulumi.get(self, "maintenance_window_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the MaintenanceWindow.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeScheduleStartGreaterThanOrEqualTo")
    def time_schedule_start_greater_than_or_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "time_schedule_start_greater_than_or_equal_to")


class AwaitableGetMaintenanceWindowsResult(GetMaintenanceWindowsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMaintenanceWindowsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            maintenance_window_collections=self.maintenance_window_collections,
            state=self.state,
            time_schedule_start_greater_than_or_equal_to=self.time_schedule_start_greater_than_or_equal_to)


def get_maintenance_windows(compartment_id: Optional[str] = None,
                            display_name: Optional[str] = None,
                            filters: Optional[Sequence[Union['GetMaintenanceWindowsFilterArgs', 'GetMaintenanceWindowsFilterArgsDict']]] = None,
                            id: Optional[str] = None,
                            state: Optional[str] = None,
                            time_schedule_start_greater_than_or_equal_to: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMaintenanceWindowsResult:
    """
    This data source provides the list of Maintenance Windows in Oracle Cloud Infrastructure Fleet Apps Management service.

    List maintenance windows for a specified tenancy in Fleet Application Management.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_maintenance_windows = oci.FleetAppsManagement.get_maintenance_windows(compartment_id=compartment_id,
        display_name=maintenance_window_display_name,
        id=maintenance_window_id,
        state=maintenance_window_state,
        time_schedule_start_greater_than_or_equal_to=maintenance_window_time_schedule_start_greater_than_or_equal_to)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: A filter to return only the Maintenance Windows whose identifier matches the given identifier.
    :param str state: A filter to return only resources whose lifecycleState matches the given lifecycleState.
    :param str time_schedule_start_greater_than_or_equal_to: A filter to return only resources whose timeScheduleStart is greater than or equal to the provided date and time.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    __args__['timeScheduleStartGreaterThanOrEqualTo'] = time_schedule_start_greater_than_or_equal_to
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getMaintenanceWindows:getMaintenanceWindows', __args__, opts=opts, typ=GetMaintenanceWindowsResult).value

    return AwaitableGetMaintenanceWindowsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        maintenance_window_collections=pulumi.get(__ret__, 'maintenance_window_collections'),
        state=pulumi.get(__ret__, 'state'),
        time_schedule_start_greater_than_or_equal_to=pulumi.get(__ret__, 'time_schedule_start_greater_than_or_equal_to'))
def get_maintenance_windows_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                   display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetMaintenanceWindowsFilterArgs', 'GetMaintenanceWindowsFilterArgsDict']]]]] = None,
                                   id: Optional[pulumi.Input[Optional[str]]] = None,
                                   state: Optional[pulumi.Input[Optional[str]]] = None,
                                   time_schedule_start_greater_than_or_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMaintenanceWindowsResult]:
    """
    This data source provides the list of Maintenance Windows in Oracle Cloud Infrastructure Fleet Apps Management service.

    List maintenance windows for a specified tenancy in Fleet Application Management.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_maintenance_windows = oci.FleetAppsManagement.get_maintenance_windows(compartment_id=compartment_id,
        display_name=maintenance_window_display_name,
        id=maintenance_window_id,
        state=maintenance_window_state,
        time_schedule_start_greater_than_or_equal_to=maintenance_window_time_schedule_start_greater_than_or_equal_to)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: A filter to return only the Maintenance Windows whose identifier matches the given identifier.
    :param str state: A filter to return only resources whose lifecycleState matches the given lifecycleState.
    :param str time_schedule_start_greater_than_or_equal_to: A filter to return only resources whose timeScheduleStart is greater than or equal to the provided date and time.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    __args__['timeScheduleStartGreaterThanOrEqualTo'] = time_schedule_start_greater_than_or_equal_to
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getMaintenanceWindows:getMaintenanceWindows', __args__, opts=opts, typ=GetMaintenanceWindowsResult)
    return __ret__.apply(lambda __response__: GetMaintenanceWindowsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        maintenance_window_collections=pulumi.get(__response__, 'maintenance_window_collections'),
        state=pulumi.get(__response__, 'state'),
        time_schedule_start_greater_than_or_equal_to=pulumi.get(__response__, 'time_schedule_start_greater_than_or_equal_to')))
