# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetManagementAgentCountResult',
    'AwaitableGetManagementAgentCountResult',
    'get_management_agent_count',
    'get_management_agent_count_output',
]

@pulumi.output_type
class GetManagementAgentCountResult:
    """
    A collection of values returned by getManagementAgentCount.
    """
    def __init__(__self__, compartment_id=None, group_bies=None, has_plugins=None, id=None, install_type=None, items=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if group_bies and not isinstance(group_bies, list):
            raise TypeError("Expected argument 'group_bies' to be a list")
        pulumi.set(__self__, "group_bies", group_bies)
        if has_plugins and not isinstance(has_plugins, bool):
            raise TypeError("Expected argument 'has_plugins' to be a bool")
        pulumi.set(__self__, "has_plugins", has_plugins)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if install_type and not isinstance(install_type, str):
            raise TypeError("Expected argument 'install_type' to be a str")
        pulumi.set(__self__, "install_type", install_type)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Sequence[str]:
        return pulumi.get(self, "group_bies")

    @property
    @pulumi.getter(name="hasPlugins")
    def has_plugins(self) -> Optional[bool]:
        """
        Whether or not a managementAgent has at least one plugin
        """
        return pulumi.get(self, "has_plugins")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="installType")
    def install_type(self) -> Optional[str]:
        """
        The install type, either AGENT or GATEWAY
        """
        return pulumi.get(self, "install_type")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetManagementAgentCountItemResult']:
        """
        List in which each item describes an aggregation of Managment Agents
        """
        return pulumi.get(self, "items")


class AwaitableGetManagementAgentCountResult(GetManagementAgentCountResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagementAgentCountResult(
            compartment_id=self.compartment_id,
            group_bies=self.group_bies,
            has_plugins=self.has_plugins,
            id=self.id,
            install_type=self.install_type,
            items=self.items)


def get_management_agent_count(compartment_id: Optional[str] = None,
                               group_bies: Optional[Sequence[str]] = None,
                               has_plugins: Optional[bool] = None,
                               install_type: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagementAgentCountResult:
    """
    This data source provides details about a specific Management Agent Count resource in Oracle Cloud Infrastructure Management Agent service.

    Gets count of the inventory of agents for a given compartment id, group by, and isPluginDeployed parameters.
    Supported groupBy parameters: availabilityStatus, platformType, version

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_management_agent_count = oci.ManagementAgent.get_management_agent_count(compartment_id=compartment_id,
        group_bies=management_agent_count_group_by,
        has_plugins=management_agent_count_has_plugins,
        install_type=management_agent_count_install_type)
    ```


    :param str compartment_id: The OCID of the compartment to which a request will be scoped.
    :param Sequence[str] group_bies: The field by which to group Management Agents. Currently, only one groupBy dimension is supported at a time.
    :param bool has_plugins: When set to true then agents that have at least one plugin deployed will be returned. When set to false only agents that have no plugins deployed will be returned.
    :param str install_type: A filter to return either agents or gateway types depending upon install type selected by user. By default both install type will be returned.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['groupBies'] = group_bies
    __args__['hasPlugins'] = has_plugins
    __args__['installType'] = install_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ManagementAgent/getManagementAgentCount:getManagementAgentCount', __args__, opts=opts, typ=GetManagementAgentCountResult).value

    return AwaitableGetManagementAgentCountResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        group_bies=pulumi.get(__ret__, 'group_bies'),
        has_plugins=pulumi.get(__ret__, 'has_plugins'),
        id=pulumi.get(__ret__, 'id'),
        install_type=pulumi.get(__ret__, 'install_type'),
        items=pulumi.get(__ret__, 'items'))
def get_management_agent_count_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                      group_bies: Optional[pulumi.Input[Sequence[str]]] = None,
                                      has_plugins: Optional[pulumi.Input[Optional[bool]]] = None,
                                      install_type: Optional[pulumi.Input[Optional[str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagementAgentCountResult]:
    """
    This data source provides details about a specific Management Agent Count resource in Oracle Cloud Infrastructure Management Agent service.

    Gets count of the inventory of agents for a given compartment id, group by, and isPluginDeployed parameters.
    Supported groupBy parameters: availabilityStatus, platformType, version

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_management_agent_count = oci.ManagementAgent.get_management_agent_count(compartment_id=compartment_id,
        group_bies=management_agent_count_group_by,
        has_plugins=management_agent_count_has_plugins,
        install_type=management_agent_count_install_type)
    ```


    :param str compartment_id: The OCID of the compartment to which a request will be scoped.
    :param Sequence[str] group_bies: The field by which to group Management Agents. Currently, only one groupBy dimension is supported at a time.
    :param bool has_plugins: When set to true then agents that have at least one plugin deployed will be returned. When set to false only agents that have no plugins deployed will be returned.
    :param str install_type: A filter to return either agents or gateway types depending upon install type selected by user. By default both install type will be returned.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['groupBies'] = group_bies
    __args__['hasPlugins'] = has_plugins
    __args__['installType'] = install_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ManagementAgent/getManagementAgentCount:getManagementAgentCount', __args__, opts=opts, typ=GetManagementAgentCountResult)
    return __ret__.apply(lambda __response__: GetManagementAgentCountResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        group_bies=pulumi.get(__response__, 'group_bies'),
        has_plugins=pulumi.get(__response__, 'has_plugins'),
        id=pulumi.get(__response__, 'id'),
        install_type=pulumi.get(__response__, 'install_type'),
        items=pulumi.get(__response__, 'items')))
