"""Constants used in MWR processing."""

# Triple point of water
T0 = 273.16

# Ratio of the molecular weight of water vapor to dry air
MW_RATIO = 0.62198

# Specific heat capacity of air at around 275K (J kg-1 K-1)
SPECIFIC_HEAT = 1004.0

# Latent heat of evaporation (J kg-1)
LATENT_HEAT = 2.26e6

# Specific gas constant for dry  air (J kg-1 K-1)
RS = 287.058

# Specific gas constant for water vapor (J/kg K)
RW = 462.0

# Vapor pressure e0 (Pa) at T0 (K)
e0 = 611.0
