"""
    VRt.Account [AC]

    The version of the OpenAPI document: 5.1.1673
    Contact: servicedesk@veeroute.com
    Auto Generated
"""


import re  # noqa: F401
import sys  # noqa: F401

from vrt_lss_account.api_client import ApiClient, Endpoint as _Endpoint
from vrt_lss_account.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from vrt_lss_account.model.inline_response400 import InlineResponse400
from vrt_lss_account.model.inline_response401 import InlineResponse401
from vrt_lss_account.model.inline_response402 import InlineResponse402
from vrt_lss_account.model.inline_response403 import InlineResponse403
from vrt_lss_account.model.inline_response404 import InlineResponse404
from vrt_lss_account.model.inline_response429 import InlineResponse429
from vrt_lss_account.model.inline_response500 import InlineResponse500
from vrt_lss_account.model.user_statistics import UserStatistics


class StatisticsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.generate_statistics_endpoint = _Endpoint(
            settings={
                'response_type': (UserStatistics,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/account/statistics',
                'operation_id': 'generate_statistics',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    '_from',
                    'to',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    '_from':
                        (date,),
                    'to':
                        (date,),
                },
                'attribute_map': {
                    '_from': 'from',
                    'to': 'to',
                },
                'location_map': {
                    '_from': 'query',
                    'to': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.read_report_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/account/report',
                'operation_id': 'read_report',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    '_from',
                    'to',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    '_from':
                        (date,),
                    'to':
                        (date,),
                },
                'attribute_map': {
                    '_from': 'from',
                    'to': 'to',
                },
                'location_map': {
                    '_from': 'query',
                    'to': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/octet-stream',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def generate_statistics(
        self,
        **kwargs
    ):
        """Statistics for the period  

        User statistics for the period. If the period is not specified, the statistics for the current month returns (from the beginning of the month to the present day). If no 'from' datetime is specified, data are returned from the beginning of the month. If no 'to' datetime is specified, data are returned be to the present day (excluding).   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.generate_statistics(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _from (date): Date 'from' in the YYYY-MM-DD format.. [optional]
            to (date): Date 'to' in the YYYY-MM-DD format.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UserStatistics
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.generate_statistics_endpoint.call_with_http_info(**kwargs)

    def read_report(
        self,
        **kwargs
    ):
        """Report creating  

        Creating report with usage statistics. If the period is not specified, records are returned from the beginning of the month to the present day (excluding). If no 'from' datetime is specified, data are returned from the beginning of the month. If no 'to' datetime is specified, data are returned be the the present day (excluding).   
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_report(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _from (date): Date 'from' in the YYYY-MM-DD format.. [optional]
            to (date): Date 'to' in the YYYY-MM-DD format.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.read_report_endpoint.call_with_http_info(**kwargs)

