from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkFiltersGeneral

VTK_EXTRACT_COMPONENT:int
VTK_EXTRACT_DETERMINANT:int
VTK_EXTRACT_EFFECTIVE_STRESS:int
VTK_EXTRACT_NONNEGATIVE_DETERMINANT:int
VTK_EXTRACT_TRACE:int

class vtkSelector(vtkmodules.vtkCommonCore.vtkObject):
    def Execute(self, input:vtkDataObject, output:vtkDataObject) -> None: ...
    def Finalize(self) -> None: ...
    def GetInsidednessArrayName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self, node:vtkSelectionNode) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkSelector: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkSelector: ...
    def SetInsidednessArrayName(self, _arg:str) -> None: ...

class vtkBlockSelector(vtkSelector):
    def Execute(self, input:vtkDataObject, output:vtkDataObject) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self, node:vtkSelectionNode) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkBlockSelector: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkBlockSelector: ...

class vtkConvertSelection(vtkmodules.vtkCommonExecutionModel.vtkSelectionAlgorithm):
    def AddArrayName(self, __a:str) -> None: ...
    def AllowMissingArrayOff(self) -> None: ...
    def AllowMissingArrayOn(self) -> None: ...
    def ClearArrayNames(self) -> None: ...
    def GetAllowMissingArray(self) -> bool: ...
    def GetArrayName(self) -> str: ...
    def GetArrayNames(self) -> vtkStringArray: ...
    def GetInputFieldType(self) -> int: ...
    def GetMatchAnyValues(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputType(self) -> int: ...
    @staticmethod
    def GetSelectedCells(input:vtkSelection, data:vtkDataSet, indices:vtkIdTypeArray) -> None: ...
    @staticmethod
    def GetSelectedEdges(input:vtkSelection, data:vtkGraph, indices:vtkIdTypeArray) -> None: ...
    @staticmethod
    def GetSelectedItems(input:vtkSelection, data:vtkDataObject, fieldType:int, indices:vtkIdTypeArray) -> None: ...
    @staticmethod
    def GetSelectedPoints(input:vtkSelection, data:vtkDataSet, indices:vtkIdTypeArray) -> None: ...
    @staticmethod
    def GetSelectedRows(input:vtkSelection, data:vtkTable, indices:vtkIdTypeArray) -> None: ...
    @staticmethod
    def GetSelectedVertices(input:vtkSelection, data:vtkGraph, indices:vtkIdTypeArray) -> None: ...
    def GetSelectionExtractor(self) -> vtkExtractSelection: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MatchAnyValuesOff(self) -> None: ...
    def MatchAnyValuesOn(self) -> None: ...
    def NewInstance(self) -> vtkConvertSelection: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkConvertSelection: ...
    def SetAllowMissingArray(self, _arg:bool) -> None: ...
    def SetArrayName(self, __a:str) -> None: ...
    def SetArrayNames(self, __a:vtkStringArray) -> None: ...
    def SetDataObjectConnection(self, in_:vtkAlgorithmOutput) -> None: ...
    def SetInputFieldType(self, _arg:int) -> None: ...
    def SetMatchAnyValues(self, _arg:bool) -> None: ...
    def SetOutputType(self, _arg:int) -> None: ...
    def SetSelectionExtractor(self, __a:vtkExtractSelection) -> None: ...
    @staticmethod
    def ToGlobalIdSelection(input:vtkSelection, data:vtkDataObject) -> vtkSelection: ...
    @staticmethod
    def ToIndexSelection(input:vtkSelection, data:vtkDataObject) -> vtkSelection: ...
    @staticmethod
    def ToPedigreeIdSelection(input:vtkSelection, data:vtkDataObject) -> vtkSelection: ...
    @staticmethod
    def ToSelectionType(input:vtkSelection, data:vtkDataObject, type:int, arrayNames:vtkStringArray=..., inputFieldType:int=-1, allowMissingArray:bool=False) -> vtkSelection: ...
    @overload
    @staticmethod
    def ToValueSelection(input:vtkSelection, data:vtkDataObject, arrayName:str) -> vtkSelection: ...
    @overload
    @staticmethod
    def ToValueSelection(input:vtkSelection, data:vtkDataObject, arrayNames:vtkStringArray) -> vtkSelection: ...

class vtkExpandMarkedElements(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    def GetController(self) -> vtkMultiProcessController: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLayers(self) -> int: ...
    def GetNumberOfLayersMaxValue(self) -> int: ...
    def GetNumberOfLayersMinValue(self) -> int: ...
    def GetRemoveIntermediateLayers(self) -> bool: ...
    def GetRemoveSeed(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExpandMarkedElements: ...
    def RemoveIntermediateLayersOff(self) -> None: ...
    def RemoveIntermediateLayersOn(self) -> None: ...
    def RemoveSeedOff(self) -> None: ...
    def RemoveSeedOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExpandMarkedElements: ...
    def SetController(self, __a:vtkMultiProcessController) -> None: ...
    def SetNumberOfLayers(self, _arg:int) -> None: ...
    def SetRemoveIntermediateLayers(self, _arg:bool) -> None: ...
    def SetRemoveSeed(self, _arg:bool) -> None: ...

class vtkExtractBlock(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    def AddIndex(self, index:int) -> None: ...
    def GetMaintainStructure(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPruneOutput(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MaintainStructureOff(self) -> None: ...
    def MaintainStructureOn(self) -> None: ...
    def NewInstance(self) -> vtkExtractBlock: ...
    def PruneOutputOff(self) -> None: ...
    def PruneOutputOn(self) -> None: ...
    def RemoveAllIndices(self) -> None: ...
    def RemoveIndex(self, index:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractBlock: ...
    def SetMaintainStructure(self, _arg:int) -> None: ...
    def SetPruneOutput(self, _arg:int) -> None: ...

class vtkExtractBlockUsingDataAssembly(vtkmodules.vtkCommonExecutionModel.vtkCompositeDataSetAlgorithm):
    def AddSelector(self, selector:str) -> bool: ...
    def ClearSelectors(self) -> None: ...
    def GetAssemblyName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSelectors(self) -> int: ...
    def GetPruneDataAssembly(self) -> bool: ...
    def GetSelectSubtrees(self) -> bool: ...
    def GetSelector(self, index:int) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExtractBlockUsingDataAssembly: ...
    def PruneDataAssemblyOff(self) -> None: ...
    def PruneDataAssemblyOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractBlockUsingDataAssembly: ...
    def SelectSubtreesOff(self) -> None: ...
    def SelectSubtreesOn(self) -> None: ...
    def SetAssemblyName(self, _arg:str) -> None: ...
    def SetPruneDataAssembly(self, _arg:bool) -> None: ...
    def SetSelectSubtrees(self, _arg:bool) -> None: ...
    def SetSelector(self, selector:str) -> None: ...

class vtkExtractCellsByType(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    def AddAllCellTypes(self) -> None: ...
    def AddCellType(self, type:int) -> None: ...
    def ExtractCellType(self, type:int) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExtractCellsByType: ...
    def RemoveAllCellTypes(self) -> None: ...
    def RemoveCellType(self, type:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractCellsByType: ...

class vtkExtractDataArraysOverTime(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    def GetFieldAssociation(self) -> int: ...
    def GetFieldAssociationMaxValue(self) -> int: ...
    def GetFieldAssociationMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTimeSteps(self) -> int: ...
    def GetReportStatisticsOnly(self) -> bool: ...
    def GetUseGlobalIDs(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExtractDataArraysOverTime: ...
    def ReportStatisticsOnlyOff(self) -> None: ...
    def ReportStatisticsOnlyOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractDataArraysOverTime: ...
    def SetFieldAssociation(self, _arg:int) -> None: ...
    def SetReportStatisticsOnly(self, _arg:bool) -> None: ...
    def SetUseGlobalIDs(self, _arg:bool) -> None: ...

class vtkExtractDataOverTime(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTimeSteps(self) -> int: ...
    def GetPointIndex(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExtractDataOverTime: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractDataOverTime: ...
    def SetPointIndex(self, _arg:int) -> None: ...

class vtkExtractDataSets(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    def AddDataSet(self, level:int, idx:int) -> None: ...
    def ClearDataSetList(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExtractDataSets: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractDataSets: ...

class vtkExtractExodusGlobalTemporalVariables(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    def AutoDetectGlobalTemporalDataArraysOff(self) -> None: ...
    def AutoDetectGlobalTemporalDataArraysOn(self) -> None: ...
    def GetAutoDetectGlobalTemporalDataArrays(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExtractExodusGlobalTemporalVariables: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractExodusGlobalTemporalVariables: ...
    def SetAutoDetectGlobalTemporalDataArrays(self, _arg:bool) -> None: ...

class vtkExtractGeometry(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    def ExtractBoundaryCellsOff(self) -> None: ...
    def ExtractBoundaryCellsOn(self) -> None: ...
    def ExtractInsideOff(self) -> None: ...
    def ExtractInsideOn(self) -> None: ...
    def ExtractOnlyBoundaryCellsOff(self) -> None: ...
    def ExtractOnlyBoundaryCellsOn(self) -> None: ...
    def GetExtractBoundaryCells(self) -> int: ...
    def GetExtractInside(self) -> int: ...
    def GetExtractOnlyBoundaryCells(self) -> int: ...
    def GetImplicitFunction(self) -> vtkImplicitFunction: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExtractGeometry: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractGeometry: ...
    def SetExtractBoundaryCells(self, _arg:int) -> None: ...
    def SetExtractInside(self, _arg:int) -> None: ...
    def SetExtractOnlyBoundaryCells(self, _arg:int) -> None: ...
    def SetImplicitFunction(self, __a:vtkImplicitFunction) -> None: ...

class vtkExtractGrid(vtkmodules.vtkCommonExecutionModel.vtkStructuredGridAlgorithm):
    def GetIncludeBoundary(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSampleRate(self) -> (int, int, int): ...
    def GetVOI(self) -> (int, int, int, int, int, int): ...
    def IncludeBoundaryOff(self) -> None: ...
    def IncludeBoundaryOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExtractGrid: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractGrid: ...
    def SetIncludeBoundary(self, _arg:int) -> None: ...
    @overload
    def SetSampleRate(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetSampleRate(self, _arg:(int, int, int)) -> None: ...
    @overload
    def SetVOI(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int, _arg5:int, _arg6:int) -> None: ...
    @overload
    def SetVOI(self, _arg:(int, int, int, int, int, int)) -> None: ...

class vtkExtractLevel(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    def AddLevel(self, level:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExtractLevel: ...
    def RemoveAllLevels(self) -> None: ...
    def RemoveLevel(self, level:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractLevel: ...

class vtkExtractParticlesOverTime(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    def GetIdChannelArray(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExtractParticlesOverTime: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractParticlesOverTime: ...
    def SetIdChannelArray(self, arg:str) -> None: ...

class vtkExtractPolyDataGeometry(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def ExtractBoundaryCellsOff(self) -> None: ...
    def ExtractBoundaryCellsOn(self) -> None: ...
    def ExtractInsideOff(self) -> None: ...
    def ExtractInsideOn(self) -> None: ...
    def GetExtractBoundaryCells(self) -> int: ...
    def GetExtractInside(self) -> int: ...
    def GetImplicitFunction(self) -> vtkImplicitFunction: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassPoints(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExtractPolyDataGeometry: ...
    def PassPointsOff(self) -> None: ...
    def PassPointsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractPolyDataGeometry: ...
    def SetExtractBoundaryCells(self, _arg:int) -> None: ...
    def SetExtractInside(self, _arg:int) -> None: ...
    def SetImplicitFunction(self, __a:vtkImplicitFunction) -> None: ...
    def SetPassPoints(self, _arg:int) -> None: ...

class vtkExtractRectilinearGrid(vtkmodules.vtkCommonExecutionModel.vtkRectilinearGridAlgorithm):
    def GetIncludeBoundary(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSampleRate(self) -> (int, int, int): ...
    def GetVOI(self) -> (int, int, int, int, int, int): ...
    def IncludeBoundaryOff(self) -> None: ...
    def IncludeBoundaryOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExtractRectilinearGrid: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractRectilinearGrid: ...
    def SetIncludeBoundary(self, _arg:int) -> None: ...
    @overload
    def SetSampleRate(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetSampleRate(self, _arg:(int, int, int)) -> None: ...
    @overload
    def SetVOI(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int, _arg5:int, _arg6:int) -> None: ...
    @overload
    def SetVOI(self, _arg:(int, int, int, int, int, int)) -> None: ...

class vtkExtractSelectedArraysOverTime(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTimeSteps(self) -> int: ...
    def GetReportStatisticsOnly(self) -> bool: ...
    def GetSelectionExtractor(self) -> vtkExtractSelection: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExtractSelectedArraysOverTime: ...
    def ReportStatisticsOnlyOff(self) -> None: ...
    def ReportStatisticsOnlyOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractSelectedArraysOverTime: ...
    def SetReportStatisticsOnly(self, _arg:bool) -> None: ...
    def SetSelectionConnection(self, algOutput:vtkAlgorithmOutput) -> None: ...
    def SetSelectionExtractor(self, __a:vtkExtractSelection) -> None: ...

class vtkExtractSelectedBlock(vtkmodules.vtkFiltersGeneral.vtkExtractSelectionBase):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExtractSelectedBlock: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractSelectedBlock: ...

class vtkExtractSelectedIds(vtkmodules.vtkFiltersGeneral.vtkExtractSelectionBase):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExtractSelectedIds: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractSelectedIds: ...

class vtkExtractSelectedLocations(vtkmodules.vtkFiltersGeneral.vtkExtractSelectionBase):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExtractSelectedLocations: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractSelectedLocations: ...

class vtkExtractSelectedPolyDataIds(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExtractSelectedPolyDataIds: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractSelectedPolyDataIds: ...

class vtkExtractSelectedRows(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    def AddOriginalRowIdsArrayOff(self) -> None: ...
    def AddOriginalRowIdsArrayOn(self) -> None: ...
    def FillInputPortInformation(self, port:int, info:vtkInformation) -> int: ...
    def GetAddOriginalRowIdsArray(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExtractSelectedRows: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractSelectedRows: ...
    def SetAddOriginalRowIdsArray(self, _arg:bool) -> None: ...
    def SetAnnotationLayersConnection(self, in_:vtkAlgorithmOutput) -> None: ...
    def SetSelectionConnection(self, in_:vtkAlgorithmOutput) -> None: ...

class vtkExtractSelectedThresholds(vtkmodules.vtkFiltersGeneral.vtkExtractSelectionBase):
    @overload
    @staticmethod
    def EvaluateValue(scalars:vtkDataArray, id:int, lims:vtkDataArray) -> int: ...
    @overload
    @staticmethod
    def EvaluateValue(array:vtkDataArray, array_component_no:int, id:int, lims:vtkDataArray) -> int: ...
    @overload
    @staticmethod
    def EvaluateValue(scalars:vtkDataArray, id:int, lims:vtkDataArray, AboveCount:[int, ...], BelowCount:[int, ...], InsideCount:[int, ...]) -> int: ...
    @overload
    @staticmethod
    def EvaluateValue(scalars:vtkDataArray, array_component_no:int, id:int, lims:vtkDataArray, AboveCount:[int, ...], BelowCount:[int, ...], InsideCount:[int, ...]) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExtractSelectedThresholds: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractSelectedThresholds: ...

class vtkExtractSelection(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    def GetHyperTreeGridToUnstructuredGrid(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPreserveTopology(self) -> bool: ...
    def HyperTreeGridToUnstructuredGridOff(self) -> None: ...
    def HyperTreeGridToUnstructuredGridOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExtractSelection: ...
    def PreserveTopologyOff(self) -> None: ...
    def PreserveTopologyOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractSelection: ...
    def SetHyperTreeGridToUnstructuredGrid(self, _arg:bool) -> None: ...
    def SetPreserveTopology(self, _arg:bool) -> None: ...
    def SetSelectionConnection(self, algOutput:vtkAlgorithmOutput) -> None: ...

class vtkExtractTensorComponents(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    def ExtractNormalsOff(self) -> None: ...
    def ExtractNormalsOn(self) -> None: ...
    def ExtractScalarsOff(self) -> None: ...
    def ExtractScalarsOn(self) -> None: ...
    def ExtractTCoordsOff(self) -> None: ...
    def ExtractTCoordsOn(self) -> None: ...
    def ExtractVectorsOff(self) -> None: ...
    def ExtractVectorsOn(self) -> None: ...
    def GetExtractNormals(self) -> int: ...
    def GetExtractScalars(self) -> int: ...
    def GetExtractTCoords(self) -> int: ...
    def GetExtractVectors(self) -> int: ...
    def GetNormalComponents(self) -> (int, int, int, int, int, int): ...
    def GetNormalizeNormals(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTCoords(self) -> int: ...
    def GetNumberOfTCoordsMaxValue(self) -> int: ...
    def GetNumberOfTCoordsMinValue(self) -> int: ...
    def GetOutputPrecision(self) -> int: ...
    def GetPassTensorsToOutput(self) -> int: ...
    def GetScalarComponents(self) -> (int, int): ...
    def GetScalarMode(self) -> int: ...
    def GetTCoordComponents(self) -> (int, int, int, int, int, int): ...
    def GetVectorComponents(self) -> (int, int, int, int, int, int): ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExtractTensorComponents: ...
    def NormalizeNormalsOff(self) -> None: ...
    def NormalizeNormalsOn(self) -> None: ...
    def PassTensorsToOutputOff(self) -> None: ...
    def PassTensorsToOutputOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractTensorComponents: ...
    def ScalarIsComponent(self) -> None: ...
    def ScalarIsDeterminant(self) -> None: ...
    def ScalarIsEffectiveStress(self) -> None: ...
    def ScalarIsNonNegativeDeterminant(self) -> None: ...
    def ScalarIsTrace(self) -> None: ...
    def SetExtractNormals(self, _arg:int) -> None: ...
    def SetExtractScalars(self, _arg:int) -> None: ...
    def SetExtractTCoords(self, _arg:int) -> None: ...
    def SetExtractVectors(self, _arg:int) -> None: ...
    @overload
    def SetNormalComponents(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int, _arg5:int, _arg6:int) -> None: ...
    @overload
    def SetNormalComponents(self, _arg:(int, int, int, int, int, int)) -> None: ...
    def SetNormalizeNormals(self, _arg:int) -> None: ...
    def SetNumberOfTCoords(self, _arg:int) -> None: ...
    def SetOutputPrecision(self, _arg:int) -> None: ...
    def SetPassTensorsToOutput(self, _arg:int) -> None: ...
    @overload
    def SetScalarComponents(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetScalarComponents(self, _arg:(int, int)) -> None: ...
    def SetScalarMode(self, _arg:int) -> None: ...
    def SetScalarModeToComponent(self) -> None: ...
    def SetScalarModeToDeterminant(self) -> None: ...
    def SetScalarModeToEffectiveStress(self) -> None: ...
    def SetScalarModeToNonNegativeDeterminant(self) -> None: ...
    def SetScalarModeToTrace(self) -> None: ...
    @overload
    def SetTCoordComponents(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int, _arg5:int, _arg6:int) -> None: ...
    @overload
    def SetTCoordComponents(self, _arg:(int, int, int, int, int, int)) -> None: ...
    @overload
    def SetVectorComponents(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int, _arg5:int, _arg6:int) -> None: ...
    @overload
    def SetVectorComponents(self, _arg:(int, int, int, int, int, int)) -> None: ...

class vtkExtractTimeSteps(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    NEAREST_TIMESTEP:int
    NEXT_TIMESTEP:int
    PREVIOUS_TIMESTEP:int
    def AddTimeStepIndex(self, timeStepIndex:int) -> None: ...
    def ClearTimeStepIndices(self) -> None: ...
    def GenerateTimeStepIndices(self, begin:int, end:int, step:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTimeSteps(self) -> int: ...
    def GetRange(self) -> (int, int): ...
    def GetTimeEstimationMode(self) -> int: ...
    def GetTimeStepIndices(self, timeStepIndices:[int, ...]) -> None: ...
    def GetTimeStepInterval(self) -> int: ...
    def GetTimeStepIntervalMaxValue(self) -> int: ...
    def GetTimeStepIntervalMinValue(self) -> int: ...
    def GetUseRange(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExtractTimeSteps: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractTimeSteps: ...
    @overload
    def SetRange(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetRange(self, _arg:(int, int)) -> None: ...
    def SetTimeEstimationMode(self, _arg:int) -> None: ...
    def SetTimeEstimationModeToNearest(self) -> None: ...
    def SetTimeEstimationModeToNext(self) -> None: ...
    def SetTimeEstimationModeToPrevious(self) -> None: ...
    def SetTimeStepIndices(self, count:int, timeStepIndices:(int, ...)) -> None: ...
    def SetTimeStepInterval(self, _arg:int) -> None: ...
    def SetUseRange(self, _arg:bool) -> None: ...
    def UseRangeOff(self) -> None: ...
    def UseRangeOn(self) -> None: ...

class vtkExtractUnstructuredGrid(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    def CellClippingOff(self) -> None: ...
    def CellClippingOn(self) -> None: ...
    def CreateDefaultLocator(self) -> None: ...
    def ExtentClippingOff(self) -> None: ...
    def ExtentClippingOn(self) -> None: ...
    def GetCellClipping(self) -> int: ...
    def GetCellMaximum(self) -> int: ...
    def GetCellMaximumMaxValue(self) -> int: ...
    def GetCellMaximumMinValue(self) -> int: ...
    def GetCellMinimum(self) -> int: ...
    def GetCellMinimumMaxValue(self) -> int: ...
    def GetCellMinimumMinValue(self) -> int: ...
    def GetExtent(self) -> (float, float, float, float, float, float): ...
    def GetExtentClipping(self) -> int: ...
    def GetLocator(self) -> vtkIncrementalPointLocator: ...
    def GetMTime(self) -> int: ...
    def GetMerging(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointClipping(self) -> int: ...
    def GetPointMaximum(self) -> int: ...
    def GetPointMaximumMaxValue(self) -> int: ...
    def GetPointMaximumMinValue(self) -> int: ...
    def GetPointMinimum(self) -> int: ...
    def GetPointMinimumMaxValue(self) -> int: ...
    def GetPointMinimumMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MergingOff(self) -> None: ...
    def MergingOn(self) -> None: ...
    def NewInstance(self) -> vtkExtractUnstructuredGrid: ...
    def PointClippingOff(self) -> None: ...
    def PointClippingOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractUnstructuredGrid: ...
    def SetCellClipping(self, _arg:int) -> None: ...
    def SetCellMaximum(self, _arg:int) -> None: ...
    def SetCellMinimum(self, _arg:int) -> None: ...
    @overload
    def SetExtent(self, xMin:float, xMax:float, yMin:float, yMax:float, zMin:float, zMax:float) -> None: ...
    @overload
    def SetExtent(self, extent:[float, float, float, float, float, float]) -> None: ...
    def SetExtentClipping(self, _arg:int) -> None: ...
    def SetLocator(self, locator:vtkIncrementalPointLocator) -> None: ...
    def SetMerging(self, _arg:int) -> None: ...
    def SetPointClipping(self, _arg:int) -> None: ...
    def SetPointMaximum(self, _arg:int) -> None: ...
    def SetPointMinimum(self, _arg:int) -> None: ...

class vtkExtractVectorComponents(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    def ExtractToFieldDataOff(self) -> None: ...
    def ExtractToFieldDataOn(self) -> None: ...
    def GetExtractToFieldData(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetVxComponent(self) -> vtkDataSet: ...
    def GetVyComponent(self) -> vtkDataSet: ...
    def GetVzComponent(self) -> vtkDataSet: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkExtractVectorComponents: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkExtractVectorComponents: ...
    def SetExtractToFieldData(self, _arg:int) -> None: ...
    def SetInputData(self, input:vtkDataSet) -> None: ...

class vtkFrustumSelector(vtkSelector):
    def GetFrustum(self) -> vtkPlanes: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self, node:vtkSelectionNode) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkFrustumSelector: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkFrustumSelector: ...
    def SetFrustum(self, __a:vtkPlanes) -> None: ...

class vtkHierarchicalDataExtractDataSets(vtkExtractDataSets):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkHierarchicalDataExtractDataSets: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkHierarchicalDataExtractDataSets: ...

class vtkHierarchicalDataExtractLevel(vtkExtractLevel):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkHierarchicalDataExtractLevel: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkHierarchicalDataExtractLevel: ...

class vtkLocationSelector(vtkSelector):
    def Finalize(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self, node:vtkSelectionNode) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkLocationSelector: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkLocationSelector: ...

class vtkProbeSelectedLocations(vtkmodules.vtkFiltersGeneral.vtkExtractSelectionBase):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkProbeSelectedLocations: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkProbeSelectedLocations: ...

class vtkValueSelector(vtkSelector):
    def Finalize(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self, node:vtkSelectionNode) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkValueSelector: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkValueSelector: ...

