from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkIOXMLParser

class vtkXMLReader(vtkmodules.vtkCommonExecutionModel.vtkAlgorithm):
    class FieldType(int): ...
    CELL_DATA:'FieldType'
    OTHER:'FieldType'
    POINT_DATA:'FieldType'
    def CanReadFile(self, name:str) -> int: ...
    def CopyOutputInformation(self, outInfo:vtkInformation, port:int) -> None: ...
    def GetActiveTimeDataArrayName(self) -> str: ...
    def GetCellArrayName(self, index:int) -> str: ...
    def GetCellArrayStatus(self, name:str) -> int: ...
    def GetCellDataArraySelection(self) -> vtkDataArraySelection: ...
    def GetColumnArrayName(self, index:int) -> str: ...
    def GetColumnArraySelection(self) -> vtkDataArraySelection: ...
    def GetColumnArrayStatus(self, name:str) -> int: ...
    def GetFileName(self) -> str: ...
    def GetNumberOfCellArrays(self) -> int: ...
    def GetNumberOfColumnArrays(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPointArrays(self) -> int: ...
    def GetNumberOfTimeDataArrays(self) -> int: ...
    def GetNumberOfTimeSteps(self) -> int: ...
    @overload
    def GetOutputAsDataSet(self) -> vtkDataSet: ...
    @overload
    def GetOutputAsDataSet(self, index:int) -> vtkDataSet: ...
    def GetParserErrorObserver(self) -> vtkCommand: ...
    def GetPointArrayName(self, index:int) -> str: ...
    def GetPointArrayStatus(self, name:str) -> int: ...
    def GetPointDataArraySelection(self) -> vtkDataArraySelection: ...
    def GetReadFromInputString(self) -> int: ...
    def GetReaderErrorObserver(self) -> vtkCommand: ...
    def GetTimeDataArray(self, idx:int) -> str: ...
    def GetTimeDataStringArray(self) -> vtkStringArray: ...
    def GetTimeStep(self) -> int: ...
    def GetTimeStepRange(self) -> (int, int): ...
    def GetXMLParser(self) -> vtkXMLDataParser: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLReader: ...
    def ReadFromInputStringOff(self) -> None: ...
    def ReadFromInputStringOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLReader: ...
    def SetActiveTimeDataArrayName(self, _arg:str) -> None: ...
    def SetCellArrayStatus(self, name:str, status:int) -> None: ...
    def SetColumnArrayStatus(self, name:str, status:int) -> None: ...
    def SetFileName(self, _arg:str) -> None: ...
    def SetInputString(self, s:str) -> None: ...
    def SetParserErrorObserver(self, __a:vtkCommand) -> None: ...
    def SetPointArrayStatus(self, name:str, status:int) -> None: ...
    def SetReadFromInputString(self, _arg:int) -> None: ...
    def SetReaderErrorObserver(self, __a:vtkCommand) -> None: ...
    def SetTimeStep(self, _arg:int) -> None: ...
    @overload
    def SetTimeStepRange(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetTimeStepRange(self, _arg:(int, int)) -> None: ...

class vtkXMLDataReader(vtkXMLReader):
    def CopyOutputInformation(self, outInfo:vtkInformation, port:int) -> None: ...
    def GetNumberOfCells(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLDataReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLDataReader: ...

class vtkXMLUnstructuredDataReader(vtkXMLDataReader):
    def CopyOutputInformation(self, outInfo:vtkInformation, port:int) -> None: ...
    def GetNumberOfCells(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPieces(self) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLUnstructuredDataReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLUnstructuredDataReader: ...
    def SetupUpdateExtent(self, piece:int, numberOfPieces:int, ghostLevel:int) -> None: ...

class vtkXMLPolyDataReader(vtkXMLUnstructuredDataReader):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLines(self) -> int: ...
    def GetNumberOfPolys(self) -> int: ...
    def GetNumberOfStrips(self) -> int: ...
    def GetNumberOfVerts(self) -> int: ...
    @overload
    def GetOutput(self) -> vtkPolyData: ...
    @overload
    def GetOutput(self, idx:int) -> vtkPolyData: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLPolyDataReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLPolyDataReader: ...

class vtkRTXMLPolyDataReader(vtkXMLPolyDataReader):
    def GetDataLocation(self) -> str: ...
    def GetNextFileName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewDataAvailable(self) -> int: ...
    def NewInstance(self) -> vtkRTXMLPolyDataReader: ...
    def ResetReader(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkRTXMLPolyDataReader: ...
    def SetLocation(self, dataLocation:str) -> None: ...
    def UpdateToNextFile(self) -> None: ...

class vtkXMLCompositeDataReader(vtkXMLReader):
    Block:int
    Interleave:int
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> vtkCompositeDataSet: ...
    @overload
    def GetOutput(self, __a:int) -> vtkCompositeDataSet: ...
    def GetPieceDistribution(self) -> int: ...
    def GetPieceDistributionMaxValue(self) -> int: ...
    def GetPieceDistributionMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLCompositeDataReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLCompositeDataReader: ...
    def SetFileName(self, __a:str) -> None: ...
    def SetPieceDistribution(self, _arg:int) -> None: ...

class vtkXMLWriterBase(vtkmodules.vtkCommonExecutionModel.vtkAlgorithm):
    class CompressorType(int): ...
    Appended:int
    Ascii:int
    BigEndian:int
    Binary:int
    Int32:int
    Int64:int
    LZ4:'CompressorType'
    LZMA:'CompressorType'
    LittleEndian:int
    NONE:'CompressorType'
    UInt32:int
    UInt64:int
    ZLIB:'CompressorType'
    def EncodeAppendedDataOff(self) -> None: ...
    def EncodeAppendedDataOn(self) -> None: ...
    def GetBlockSize(self) -> int: ...
    def GetByteOrder(self) -> int: ...
    def GetCompressionLevel(self) -> int: ...
    def GetCompressor(self) -> vtkDataCompressor: ...
    def GetDataMode(self) -> int: ...
    def GetDefaultFileExtension(self) -> str: ...
    def GetEncodeAppendedData(self) -> bool: ...
    def GetFileName(self) -> str: ...
    def GetHeaderType(self) -> int: ...
    def GetIdType(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputString(self) -> str: ...
    def GetWriteToOutputString(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLWriterBase: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLWriterBase: ...
    def SetBlockSize(self, blockSize:int) -> None: ...
    def SetByteOrder(self, _arg:int) -> None: ...
    def SetByteOrderToBigEndian(self) -> None: ...
    def SetByteOrderToLittleEndian(self) -> None: ...
    def SetCompressionLevel(self, compressorLevel:int) -> None: ...
    def SetCompressor(self, __a:vtkDataCompressor) -> None: ...
    def SetCompressorType(self, compressorType:int) -> None: ...
    def SetCompressorTypeToLZ4(self) -> None: ...
    def SetCompressorTypeToLZMA(self) -> None: ...
    def SetCompressorTypeToNone(self) -> None: ...
    def SetCompressorTypeToZLib(self) -> None: ...
    def SetDataMode(self, _arg:int) -> None: ...
    def SetDataModeToAppended(self) -> None: ...
    def SetDataModeToAscii(self) -> None: ...
    def SetDataModeToBinary(self) -> None: ...
    def SetEncodeAppendedData(self, _arg:bool) -> None: ...
    def SetFileName(self, _arg:str) -> None: ...
    def SetHeaderType(self, __a:int) -> None: ...
    def SetHeaderTypeToUInt32(self) -> None: ...
    def SetHeaderTypeToUInt64(self) -> None: ...
    def SetIdType(self, __a:int) -> None: ...
    def SetIdTypeToInt32(self) -> None: ...
    def SetIdTypeToInt64(self) -> None: ...
    def SetWriteToOutputString(self, _arg:bool) -> None: ...
    def Write(self) -> int: ...
    def WriteToOutputStringOff(self) -> None: ...
    def WriteToOutputStringOn(self) -> None: ...

class vtkXMLWriter(vtkXMLWriterBase):
    @overload
    def GetInput(self, port:int) -> vtkDataObject: ...
    @overload
    def GetInput(self) -> vtkDataObject: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTimeSteps(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLWriter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLWriter: ...
    @overload
    def SetInputData(self, __a:vtkDataObject) -> None: ...
    @overload
    def SetInputData(self, __a:int, __b:vtkDataObject) -> None: ...
    def SetNumberOfTimeSteps(self, _arg:int) -> None: ...
    def Start(self) -> None: ...
    def Stop(self) -> None: ...
    def WriteNextTime(self, time:float) -> None: ...

class vtkXMLCompositeDataWriter(vtkXMLWriter):
    def GetDefaultFileExtension(self) -> str: ...
    def GetGhostLevel(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetWriteMetaFile(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLCompositeDataWriter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLCompositeDataWriter: ...
    def SetGhostLevel(self, _arg:int) -> None: ...
    def SetWriteMetaFile(self, flag:int) -> None: ...

class vtkXMLDataObjectWriter(vtkXMLWriter):
    def GetInput(self) -> vtkDataSet: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLDataObjectWriter: ...
    @staticmethod
    def NewWriter(dataset_type:int) -> vtkXMLWriter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLDataObjectWriter: ...

class vtkXMLDataSetWriter(vtkXMLDataObjectWriter):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLDataSetWriter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLDataSetWriter: ...

class vtkXMLFileReadTester(vtkmodules.vtkIOXMLParser.vtkXMLParser):
    def GetFileDataType(self) -> str: ...
    def GetFileVersion(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLFileReadTester: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLFileReadTester: ...
    def TestReadFile(self) -> int: ...

class vtkXMLGenericDataObjectReader(vtkXMLDataReader):
    @staticmethod
    def CreateReader(data_object_type:int, parallel:bool) -> vtkXMLReader: ...
    def GetHierarchicalBoxDataSetOutput(self) -> vtkHierarchicalBoxDataSet: ...
    def GetImageDataOutput(self) -> vtkImageData: ...
    def GetMultiBlockDataSetOutput(self) -> vtkMultiBlockDataSet: ...
    def GetNumberOfCells(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    @overload
    def GetOutput(self) -> vtkDataObject: ...
    @overload
    def GetOutput(self, idx:int) -> vtkDataObject: ...
    def GetPolyDataOutput(self) -> vtkPolyData: ...
    def GetRectilinearGridOutput(self) -> vtkRectilinearGrid: ...
    def GetStructuredGridOutput(self) -> vtkStructuredGrid: ...
    def GetUnstructuredGridOutput(self) -> vtkUnstructuredGrid: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLGenericDataObjectReader: ...
    def ReadOutputType(self, name:str, parallel:bool) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLGenericDataObjectReader: ...
    def SetupEmptyOutput(self) -> None: ...

class vtkXMLHierarchicalBoxDataFileConverter(vtkmodules.vtkCommonCore.vtkObject):
    def Convert(self) -> bool: ...
    def GetInputFileName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputFileName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLHierarchicalBoxDataFileConverter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLHierarchicalBoxDataFileConverter: ...
    def SetInputFileName(self, _arg:str) -> None: ...
    def SetOutputFileName(self, _arg:str) -> None: ...

class vtkXMLUniformGridAMRReader(vtkXMLCompositeDataReader):
    def GetMaximumLevelsToReadByDefault(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLUniformGridAMRReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLUniformGridAMRReader: ...
    def SetMaximumLevelsToReadByDefault(self, _arg:int) -> None: ...

class vtkXMLHierarchicalBoxDataReader(vtkXMLUniformGridAMRReader):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLHierarchicalBoxDataReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLHierarchicalBoxDataReader: ...

class vtkXMLUniformGridAMRWriter(vtkXMLCompositeDataWriter):
    def GetDefaultFileExtension(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLUniformGridAMRWriter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLUniformGridAMRWriter: ...

class vtkXMLHierarchicalBoxDataWriter(vtkXMLUniformGridAMRWriter):
    def GetDefaultFileExtension(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLHierarchicalBoxDataWriter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLHierarchicalBoxDataWriter: ...

class vtkXMLMultiBlockDataReader(vtkXMLCompositeDataReader):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLMultiBlockDataReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLMultiBlockDataReader: ...

class vtkXMLMultiGroupDataReader(vtkXMLMultiBlockDataReader):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLMultiGroupDataReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLMultiGroupDataReader: ...

class vtkXMLHierarchicalDataReader(vtkXMLMultiGroupDataReader):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLHierarchicalDataReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLHierarchicalDataReader: ...

class vtkXMLHyperTreeGridReader(vtkXMLReader):
    def AddSelectedHT(self, idg:int, fixedLevel:int=...) -> None: ...
    def ClearAndAddSelectedHT(self, idg:int, fixedLevel:int=...) -> None: ...
    def CopyOutputInformation(self, outInfo:vtkInformation, port:int) -> None: ...
    def GetFixedLevel(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPieces(self) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    @overload
    def GetOutput(self) -> vtkHyperTreeGrid: ...
    @overload
    def GetOutput(self, idx:int) -> vtkHyperTreeGrid: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLHyperTreeGridReader: ...
    def ReadXMLData(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLHyperTreeGridReader: ...
    def SetCoordinatesBoundingBox(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    def SetFixedLevel(self, _arg:int) -> None: ...
    def SetIndicesBoundingBox(self, imin:int, imax:int, jmin:int, jmax:int, kmin:int, kmax:int) -> None: ...
    def SetupUpdateExtent(self, piece:int, numberOfPieces:int) -> None: ...

class vtkXMLHyperTreeGridWriter(vtkXMLWriter):
    def GetDefaultFileExtension(self) -> str: ...
    def GetInput(self) -> vtkHyperTreeGrid: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLHyperTreeGridWriter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLHyperTreeGridWriter: ...
    def SetDataSetMajorVersion(self, _arg:int) -> None: ...
    def SetDataSetMinorVersion(self, _arg:int) -> None: ...

class vtkXMLStructuredDataReader(vtkXMLDataReader):
    def CopyOutputInformation(self, outInfo:vtkInformation, port:int) -> None: ...
    def GetNumberOfCells(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPoints(self) -> int: ...
    def GetWholeSlices(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLStructuredDataReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLStructuredDataReader: ...
    def SetWholeSlices(self, _arg:int) -> None: ...
    def WholeSlicesOff(self) -> None: ...
    def WholeSlicesOn(self) -> None: ...

class vtkXMLImageDataReader(vtkXMLStructuredDataReader):
    def CopyOutputInformation(self, outInfo:vtkInformation, port:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> vtkImageData: ...
    @overload
    def GetOutput(self, idx:int) -> vtkImageData: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLImageDataReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLImageDataReader: ...

class vtkXMLStructuredDataWriter(vtkXMLWriter):
    def GetGhostLevel(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPieces(self) -> int: ...
    def GetWriteExtent(self) -> (int, int, int, int, int, int): ...
    def GetWritePiece(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLStructuredDataWriter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLStructuredDataWriter: ...
    def SetGhostLevel(self, _arg:int) -> None: ...
    def SetNumberOfPieces(self, _arg:int) -> None: ...
    @overload
    def SetWriteExtent(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int, _arg5:int, _arg6:int) -> None: ...
    @overload
    def SetWriteExtent(self, _arg:(int, int, int, int, int, int)) -> None: ...
    def SetWritePiece(self, _arg:int) -> None: ...

class vtkXMLImageDataWriter(vtkXMLStructuredDataWriter):
    def GetDefaultFileExtension(self) -> str: ...
    def GetInput(self) -> vtkImageData: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLImageDataWriter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLImageDataWriter: ...

class vtkXMLMultiBlockDataWriter(vtkXMLCompositeDataWriter):
    def GetDefaultFileExtension(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLMultiBlockDataWriter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLMultiBlockDataWriter: ...

class vtkXMLPDataObjectReader(vtkXMLReader):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPieces(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLPDataObjectReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLPDataObjectReader: ...

class vtkXMLPDataReader(vtkXMLPDataObjectReader):
    def CopyOutputInformation(self, outInfo:vtkInformation, port:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLPDataReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLPDataReader: ...

class vtkXMLPHyperTreeGridReader(vtkXMLPDataObjectReader):
    def CopyOutputInformation(self, outInfo:vtkInformation, port:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> vtkHyperTreeGrid: ...
    @overload
    def GetOutput(self, idx:int) -> vtkHyperTreeGrid: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLPHyperTreeGridReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLPHyperTreeGridReader: ...

class vtkXMLPStructuredDataReader(vtkXMLPDataReader):
    def CopyOutputInformation(self, outInfo:vtkInformation, port:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLPStructuredDataReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLPStructuredDataReader: ...

class vtkXMLPImageDataReader(vtkXMLPStructuredDataReader):
    def CopyOutputInformation(self, outInfo:vtkInformation, port:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> vtkImageData: ...
    @overload
    def GetOutput(self, idx:int) -> vtkImageData: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLPImageDataReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLPImageDataReader: ...

class vtkXMLPUnstructuredDataReader(vtkXMLPDataReader):
    def CopyOutputInformation(self, outInfo:vtkInformation, port:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLPUnstructuredDataReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLPUnstructuredDataReader: ...

class vtkXMLPPolyDataReader(vtkXMLPUnstructuredDataReader):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> vtkPolyData: ...
    @overload
    def GetOutput(self, idx:int) -> vtkPolyData: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLPPolyDataReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLPPolyDataReader: ...

class vtkXMLPRectilinearGridReader(vtkXMLPStructuredDataReader):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> vtkRectilinearGrid: ...
    @overload
    def GetOutput(self, idx:int) -> vtkRectilinearGrid: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLPRectilinearGridReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLPRectilinearGridReader: ...

class vtkXMLPStructuredGridReader(vtkXMLPStructuredDataReader):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> vtkStructuredGrid: ...
    @overload
    def GetOutput(self, idx:int) -> vtkStructuredGrid: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLPStructuredGridReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLPStructuredGridReader: ...

class vtkXMLPTableReader(vtkXMLPDataObjectReader):
    def CopyOutputInformation(self, outInfo:vtkInformation, port:int) -> None: ...
    def GetColumnArrayName(self, index:int) -> str: ...
    def GetColumnArrayStatus(self, name:str) -> int: ...
    def GetColumnSelection(self) -> vtkDataArraySelection: ...
    def GetNumberOfColumnArrays(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> vtkTable: ...
    @overload
    def GetOutput(self, idx:int) -> vtkTable: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLPTableReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLPTableReader: ...
    def SetColumnArrayStatus(self, name:str, status:int) -> None: ...

class vtkXMLPUnstructuredGridReader(vtkXMLPUnstructuredDataReader):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> vtkUnstructuredGrid: ...
    @overload
    def GetOutput(self, idx:int) -> vtkUnstructuredGrid: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLPUnstructuredGridReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLPUnstructuredGridReader: ...

class vtkXMLPartitionedDataSetCollectionReader(vtkXMLCompositeDataReader):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLPartitionedDataSetCollectionReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLPartitionedDataSetCollectionReader: ...

class vtkXMLPartitionedDataSetReader(vtkXMLCompositeDataReader):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLPartitionedDataSetReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLPartitionedDataSetReader: ...

class vtkXMLUnstructuredDataWriter(vtkXMLWriter):
    def GetGhostLevel(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPieces(self) -> int: ...
    def GetWritePiece(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLUnstructuredDataWriter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLUnstructuredDataWriter: ...
    def SetGhostLevel(self, _arg:int) -> None: ...
    def SetNumberOfPieces(self, _arg:int) -> None: ...
    def SetWritePiece(self, _arg:int) -> None: ...

class vtkXMLPolyDataWriter(vtkXMLUnstructuredDataWriter):
    def GetDefaultFileExtension(self) -> str: ...
    def GetInput(self) -> vtkPolyData: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLPolyDataWriter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLPolyDataWriter: ...

class vtkXMLRectilinearGridReader(vtkXMLStructuredDataReader):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> vtkRectilinearGrid: ...
    @overload
    def GetOutput(self, idx:int) -> vtkRectilinearGrid: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLRectilinearGridReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLRectilinearGridReader: ...

class vtkXMLRectilinearGridWriter(vtkXMLStructuredDataWriter):
    def GetDefaultFileExtension(self) -> str: ...
    def GetInput(self) -> vtkRectilinearGrid: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLRectilinearGridWriter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLRectilinearGridWriter: ...

class vtkXMLStructuredGridReader(vtkXMLStructuredDataReader):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> vtkStructuredGrid: ...
    @overload
    def GetOutput(self, idx:int) -> vtkStructuredGrid: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLStructuredGridReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLStructuredGridReader: ...

class vtkXMLStructuredGridWriter(vtkXMLStructuredDataWriter):
    def GetDefaultFileExtension(self) -> str: ...
    def GetInput(self) -> vtkStructuredGrid: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLStructuredGridWriter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLStructuredGridWriter: ...

class vtkXMLTableReader(vtkXMLReader):
    def CopyOutputInformation(self, outInfo:vtkInformation, port:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPieces(self) -> int: ...
    def GetNumberOfRows(self) -> int: ...
    @overload
    def GetOutput(self) -> vtkTable: ...
    @overload
    def GetOutput(self, idx:int) -> vtkTable: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLTableReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLTableReader: ...
    def SetupUpdateExtent(self, piece:int, numberOfPieces:int) -> None: ...

class vtkXMLTableWriter(vtkXMLWriter):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPieces(self) -> int: ...
    def GetWritePiece(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLTableWriter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLTableWriter: ...
    def SetNumberOfPieces(self, _arg:int) -> None: ...
    def SetWritePiece(self, _arg:int) -> None: ...

class vtkXMLUnstructuredGridReader(vtkXMLUnstructuredDataReader):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> vtkUnstructuredGrid: ...
    @overload
    def GetOutput(self, idx:int) -> vtkUnstructuredGrid: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLUnstructuredGridReader: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLUnstructuredGridReader: ...

class vtkXMLUnstructuredGridWriter(vtkXMLUnstructuredDataWriter):
    def GetDefaultFileExtension(self) -> str: ...
    def GetInput(self) -> vtkUnstructuredGridBase: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkXMLUnstructuredGridWriter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkXMLUnstructuredGridWriter: ...

