"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Aspects = void 0;
const ASPECTS_SYMBOL = Symbol('cdk-aspects');
/**
 * Aspects can be applied to CDK tree scopes and can operate on the tree before synthesis.
 */
class Aspects {
    // TODO(2.0): private readonly _aspects = new Array<IAspect>();
    constructor(scope) {
        this.scope = scope;
    }
    /**
     * Returns the `Aspects` object associated with a construct scope.
     *
     * @param scope The scope for which these aspects will apply.
     */
    static of(scope) {
        let aspects = scope[ASPECTS_SYMBOL];
        if (!aspects) {
            aspects = new Aspects(scope);
            Object.defineProperty(scope, ASPECTS_SYMBOL, {
                value: aspects,
                configurable: false,
                enumerable: false,
            });
        }
        return aspects;
    }
    /**
     * Adds an aspect to apply this scope before synthesis.
     *
     * @param aspect The aspect to add.
     */
    add(aspect) {
        // TODO(2.0): this._aspects.push(aspect);
        this.scope.node._actualNode.applyAspect(aspect);
    }
    /**
     * The list of aspects which were directly applied on this scope.
     */
    get aspects() {
        // TODO(2.0): return  [ ...this._aspects ];
        return [...this.scope.node._actualNode._aspects]; // clone
    }
}
exports.Aspects = Aspects;
//# sourceMappingURL=data:application/json;base64,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