import { DockerImageAssetLocation, DockerImageAssetSource, FileAssetLocation, FileAssetSource } from '../assets';
import { ISynthesisSession } from '../construct-compat';
import { Stack } from '../stack';
import { StackSynthesizer } from './stack-synthesizer';
import { IStackSynthesizer } from './types';
/**
 * Deployment environment for a nested stack.
 *
 * Interoperates with the StackSynthesizer of the parent stack.
 */
export declare class NestedStackSynthesizer extends StackSynthesizer {
    private readonly parentDeployment;
    private stack?;
    /**
     *
     */
    constructor(parentDeployment: IStackSynthesizer);
    /**
     * Bind to the stack this environment is going to be used on.
     *
     * Must be called before any of the other methods are called.
     */
    bind(stack: Stack): void;
    /**
     * Register a File Asset.
     *
     * Returns the parameters that can be used to refer to the asset inside the template.
     */
    addFileAsset(asset: FileAssetSource): FileAssetLocation;
    /**
     * Register a Docker Image Asset.
     *
     * Returns the parameters that can be used to refer to the asset inside the template.
     */
    addDockerImageAsset(asset: DockerImageAssetSource): DockerImageAssetLocation;
    /**
     * Synthesize the associated stack to the session.
     */
    synthesize(session: ISynthesisSession): void;
}
