# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/04_cli.ipynb.

# %% auto 0
__all__ = ['railway_link', 'railway_deploy']

# %% ../nbs/04_cli.ipynb 1
from fastcore.utils import *
from fastcore.script import call_parse, bool_arg
from subprocess import check_output, run

import json

# %% ../nbs/04_cli.ipynb 3
@call_parse
def railway_link():
    "Link the current directory to the current project's Railway service"
    j = json.loads(check_output("railway status --json".split()))
    prj = j['id']
    idxpath = 'edges', 0, 'node', 'id'
    env = nested_idx(j, 'environments', *idxpath)
    svc = nested_idx(j, 'services', *idxpath)

    cmd = f"railway link -e {env} -p {prj} -s {svc}"
    res = check_output(cmd.split())

# %% ../nbs/04_cli.ipynb 4
def _run(a, **kw):
    print('#', ' '.join(a))
    run(a)

# %% ../nbs/04_cli.ipynb 5
@call_parse
def railway_deploy(
    name:str, # The project name to deploy
    mount:bool_arg=True # Create a mounted volume at /app/data?
):
    cp = run("railway status --json".split(), capture_output=True)
    if not cp.returncode: return print("This project is already deployed. Run `railway open`.")
    reqs = Path('requirements.txt')
    if not reqs.exists(): reqs.write_text('python-fasthtml')
    _run(f"railway init -n {name}".split())
    _run(f"railway up -c".split())
    _run(f"railway domain".split())
    railway_link.__wrapped__()
    _run(f"railway volume add -m /app/data".split())    
