#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Mon Sep  8 15:46:47 2014 by generateDS.py version 2.12a.
#

import sys
import getopt
import re as re_
import base64
import datetime as datetime_

etree_ = None
Verbose_import_ = False
(
    XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")


def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
            'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class uForgeObject(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, extensiontype_=None):
        if isinstance(created, basestring):
            initvalue_ = datetime_.datetime.strptime(created, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = created
        self.created = initvalue_
        self.dbId = dbId
        self.digest = digest
        if isinstance(lastModified, basestring):
            initvalue_ = datetime_.datetime.strptime(lastModified, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = lastModified
        self.lastModified = initvalue_
        self.name = name
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if uForgeObject.subclass:
            return uForgeObject.subclass(*args_, **kwargs_)
        else:
            return uForgeObject(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_created(self): return self.created
    def set_created(self, created): self.created = created
    def get_dbId(self): return self.dbId
    def set_dbId(self, dbId): self.dbId = dbId
    def get_digest(self): return self.digest
    def set_digest(self, digest): self.digest = digest
    def get_lastModified(self): return self.lastModified
    def set_lastModified(self, lastModified): self.lastModified = lastModified
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.created is not None or
            self.dbId is not None or
            self.digest is not None or
            self.lastModified is not None or
            self.name is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='uForgeObject', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='uForgeObject')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='uForgeObject'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='uForgeObject', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.created is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%screated>%s</%screated>%s' % (namespace_, self.gds_format_datetime(self.created, input_name='created'), namespace_, eol_))
        if self.dbId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdbId>%s</%sdbId>%s' % (namespace_, self.gds_format_integer(self.dbId, input_name='dbId'), namespace_, eol_))
        if self.digest is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdigest>%s</%sdigest>%s' % (namespace_, self.gds_format_string(quote_xml(self.digest).encode(ExternalEncoding), input_name='digest'), namespace_, eol_))
        if self.lastModified is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slastModified>%s</%slastModified>%s' % (namespace_, self.gds_format_datetime(self.lastModified, input_name='lastModified'), namespace_, eol_))
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='uForgeObject'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.created is not None:
            showIndent(outfile, level)
            outfile.write('created=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.created, input_name='created'))
        if self.dbId is not None:
            showIndent(outfile, level)
            outfile.write('dbId=%d,\n' % self.dbId)
        if self.digest is not None:
            showIndent(outfile, level)
            outfile.write('digest=%s,\n' % quote_python(self.digest).encode(ExternalEncoding))
        if self.lastModified is not None:
            showIndent(outfile, level)
            outfile.write('lastModified=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.lastModified, input_name='lastModified'))
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'created':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.created = dval_
        elif nodeName_ == 'dbId':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'dbId')
            self.dbId = ival_
        elif nodeName_ == 'digest':
            digest_ = child_.text
            digest_ = self.gds_validate_string(digest_, node, 'digest')
            self.digest = digest_
        elif nodeName_ == 'lastModified':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.lastModified = dval_
        elif nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
# end class uForgeObject


class permission(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, action=None, active=None, dflt=None, resourceName=None, resourceType=None, resourceUri=None, tag=None, uri=None, visible=None, extensiontype_=None):
        super(permission, self).__init__(created, dbId, digest, lastModified, name, extensiontype_, )
        self.action = action
        self.active = active
        self.dflt = dflt
        self.resourceName = resourceName
        self.resourceType = resourceType
        self.resourceUri = resourceUri
        self.tag = tag
        self.uri = uri
        self.visible = visible
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if permission.subclass:
            return permission.subclass(*args_, **kwargs_)
        else:
            return permission(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_action(self): return self.action
    def set_action(self, action): self.action = action
    def get_active(self): return self.active
    def set_active(self, active): self.active = active
    def get_dflt(self): return self.dflt
    def set_dflt(self, dflt): self.dflt = dflt
    def get_resourceName(self): return self.resourceName
    def set_resourceName(self, resourceName): self.resourceName = resourceName
    def get_resourceType(self): return self.resourceType
    def set_resourceType(self, resourceType): self.resourceType = resourceType
    def get_resourceUri(self): return self.resourceUri
    def set_resourceUri(self, resourceUri): self.resourceUri = resourceUri
    def get_tag(self): return self.tag
    def set_tag(self, tag): self.tag = tag
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_visible(self): return self.visible
    def set_visible(self, visible): self.visible = visible
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.action is not None or
            self.active is not None or
            self.dflt is not None or
            self.resourceName is not None or
            self.resourceType is not None or
            self.resourceUri is not None or
            self.tag is not None or
            self.uri is not None or
            self.visible is not None or
            super(permission, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='permission', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='permission')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='permission'):
        super(permission, self).exportAttributes(outfile, level, already_processed, namespace_, name_='permission')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='permission', fromsubclass_=False, pretty_print=True):
        super(permission, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.action is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saction>%s</%saction>%s' % (namespace_, self.gds_format_string(quote_xml(self.action).encode(ExternalEncoding), input_name='action'), namespace_, eol_))
        if self.active is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sactive>%s</%sactive>%s' % (namespace_, self.gds_format_boolean(self.active, input_name='active'), namespace_, eol_))
        if self.dflt is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdflt>%s</%sdflt>%s' % (namespace_, self.gds_format_boolean(self.dflt, input_name='dflt'), namespace_, eol_))
        if self.resourceName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sresourceName>%s</%sresourceName>%s' % (namespace_, self.gds_format_string(quote_xml(self.resourceName).encode(ExternalEncoding), input_name='resourceName'), namespace_, eol_))
        if self.resourceType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sresourceType>%s</%sresourceType>%s' % (namespace_, self.gds_format_string(quote_xml(self.resourceType).encode(ExternalEncoding), input_name='resourceType'), namespace_, eol_))
        if self.resourceUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sresourceUri>%s</%sresourceUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.resourceUri).encode(ExternalEncoding), input_name='resourceUri'), namespace_, eol_))
        if self.tag is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stag>%s</%stag>%s' % (namespace_, self.gds_format_string(quote_xml(self.tag).encode(ExternalEncoding), input_name='tag'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
        if self.visible is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svisible>%s</%svisible>%s' % (namespace_, self.gds_format_boolean(self.visible, input_name='visible'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='permission'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(permission, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(permission, self).exportLiteralChildren(outfile, level, name_)
        if self.action is not None:
            showIndent(outfile, level)
            outfile.write('action=%s,\n' % quote_python(self.action).encode(ExternalEncoding))
        if self.active is not None:
            showIndent(outfile, level)
            outfile.write('active=%s,\n' % self.active)
        if self.dflt is not None:
            showIndent(outfile, level)
            outfile.write('dflt=%s,\n' % self.dflt)
        if self.resourceName is not None:
            showIndent(outfile, level)
            outfile.write('resourceName=%s,\n' % quote_python(self.resourceName).encode(ExternalEncoding))
        if self.resourceType is not None:
            showIndent(outfile, level)
            outfile.write('resourceType=%s,\n' % quote_python(self.resourceType).encode(ExternalEncoding))
        if self.resourceUri is not None:
            showIndent(outfile, level)
            outfile.write('resourceUri=%s,\n' % quote_python(self.resourceUri).encode(ExternalEncoding))
        if self.tag is not None:
            showIndent(outfile, level)
            outfile.write('tag=%s,\n' % quote_python(self.tag).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.visible is not None:
            showIndent(outfile, level)
            outfile.write('visible=%s,\n' % self.visible)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(permission, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'action':
            action_ = child_.text
            action_ = self.gds_validate_string(action_, node, 'action')
            self.action = action_
        elif nodeName_ == 'active':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'active')
            self.active = ival_
        elif nodeName_ == 'dflt':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'dflt')
            self.dflt = ival_
        elif nodeName_ == 'resourceName':
            resourceName_ = child_.text
            resourceName_ = self.gds_validate_string(resourceName_, node, 'resourceName')
            self.resourceName = resourceName_
        elif nodeName_ == 'resourceType':
            resourceType_ = child_.text
            resourceType_ = self.gds_validate_string(resourceType_, node, 'resourceType')
            self.resourceType = resourceType_
        elif nodeName_ == 'resourceUri':
            resourceUri_ = child_.text
            resourceUri_ = self.gds_validate_string(resourceUri_, node, 'resourceUri')
            self.resourceUri = resourceUri_
        elif nodeName_ == 'tag':
            tag_ = child_.text
            tag_ = self.gds_validate_string(tag_, node, 'tag')
            self.tag = tag_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'visible':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'visible')
            self.visible = ival_
        super(permission, self).buildChildren(child_, node, nodeName_, True)
# end class permission


class imageFormat(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, access=None, active=None, preselected=None, uri=None):
        super(imageFormat, self).__init__(created, dbId, digest, lastModified, name, )
        self.access = access
        self.active = active
        self.preselected = preselected
        self.uri = uri
    def factory(*args_, **kwargs_):
        if imageFormat.subclass:
            return imageFormat.subclass(*args_, **kwargs_)
        else:
            return imageFormat(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_access(self): return self.access
    def set_access(self, access): self.access = access
    def get_active(self): return self.active
    def set_active(self, active): self.active = active
    def get_preselected(self): return self.preselected
    def set_preselected(self, preselected): self.preselected = preselected
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def hasContent_(self):
        if (
            self.access is not None or
            self.active is not None or
            self.preselected is not None or
            self.uri is not None or
            super(imageFormat, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='imageFormat', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='imageFormat')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='imageFormat'):
        super(imageFormat, self).exportAttributes(outfile, level, already_processed, namespace_, name_='imageFormat')
    def exportChildren(self, outfile, level, namespace_='', name_='imageFormat', fromsubclass_=False, pretty_print=True):
        super(imageFormat, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.access is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saccess>%s</%saccess>%s' % (namespace_, self.gds_format_boolean(self.access, input_name='access'), namespace_, eol_))
        if self.active is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sactive>%s</%sactive>%s' % (namespace_, self.gds_format_boolean(self.active, input_name='active'), namespace_, eol_))
        if self.preselected is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spreselected>%s</%spreselected>%s' % (namespace_, self.gds_format_boolean(self.preselected, input_name='preselected'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='imageFormat'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(imageFormat, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(imageFormat, self).exportLiteralChildren(outfile, level, name_)
        if self.access is not None:
            showIndent(outfile, level)
            outfile.write('access=%s,\n' % self.access)
        if self.active is not None:
            showIndent(outfile, level)
            outfile.write('active=%s,\n' % self.active)
        if self.preselected is not None:
            showIndent(outfile, level)
            outfile.write('preselected=%s,\n' % self.preselected)
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(imageFormat, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'access':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'access')
            self.access = ival_
        elif nodeName_ == 'active':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'active')
            self.active = ival_
        elif nodeName_ == 'preselected':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'preselected')
            self.preselected = ival_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(imageFormat, self).buildChildren(child_, node, nodeName_, True)
# end class imageFormat


class permissionDistrib(permission):
    subclass = None
    superclass = permission
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, action=None, active=None, dflt=None, resourceName=None, resourceType=None, resourceUri=None, tag=None, uri=None, visible=None, resource=None):
        super(permissionDistrib, self).__init__(created, dbId, digest, lastModified, name, action, active, dflt, resourceName, resourceType, resourceUri, tag, uri, visible, )
        self.resource = resource
    def factory(*args_, **kwargs_):
        if permissionDistrib.subclass:
            return permissionDistrib.subclass(*args_, **kwargs_)
        else:
            return permissionDistrib(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_resource(self): return self.resource
    def set_resource(self, resource): self.resource = resource
    def hasContent_(self):
        if (
            self.resource is not None or
            super(permissionDistrib, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='permissionDistrib', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='permissionDistrib')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='permissionDistrib'):
        super(permissionDistrib, self).exportAttributes(outfile, level, already_processed, namespace_, name_='permissionDistrib')
    def exportChildren(self, outfile, level, namespace_='', name_='permissionDistrib', fromsubclass_=False, pretty_print=True):
        super(permissionDistrib, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.resource is not None:
            self.resource.export(outfile, level, namespace_, name_='resource', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='permissionDistrib'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(permissionDistrib, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(permissionDistrib, self).exportLiteralChildren(outfile, level, name_)
        if self.resource is not None:
            showIndent(outfile, level)
            outfile.write('resource=model_.distribution(\n')
            self.resource.exportLiteral(outfile, level, name_='resource')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(permissionDistrib, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'resource':
            obj_ = distribution.factory()
            obj_.build(child_)
            self.resource = obj_
        super(permissionDistrib, self).buildChildren(child_, node, nodeName_, True)
# end class permissionDistrib


class distribution(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, active=None, arch=None, baseInstallConfigUri=None, baseMilestonesUri=None, baseOASRtUri=None, basePkgsUri=None, baseProfilesUri=None, baseProhibitedFormatsUri=None, baseProjectsUri=None, baseServicesUri=None, company=None, completeProfileUri=None, description=None, family=None, lastPkgBuildDate=None, license=None, milestoneUris=None, orgResourcesAccessRights=None, orgResourcesAccessRightsUri=None, parentUri=None, pkgType=None, preselected=None, profileUris=None, distribProfiles=None, prohibitedFormats=None, projectUris=None, releaseDate=None, serviceUris=None, size=None, skeletonSize=None, uri=None, version=None, versionId=None, visible=None, welcomeMsg=None):
        super(distribution, self).__init__(created, dbId, digest, lastModified, name, )
        self.active = active
        self.arch = arch
        self.baseInstallConfigUri = baseInstallConfigUri
        self.baseMilestonesUri = baseMilestonesUri
        self.baseOASRtUri = baseOASRtUri
        self.basePkgsUri = basePkgsUri
        self.baseProfilesUri = baseProfilesUri
        self.baseProhibitedFormatsUri = baseProhibitedFormatsUri
        self.baseProjectsUri = baseProjectsUri
        self.baseServicesUri = baseServicesUri
        self.company = company
        self.completeProfileUri = completeProfileUri
        self.description = description
        self.family = family
        if isinstance(lastPkgBuildDate, basestring):
            initvalue_ = datetime_.datetime.strptime(lastPkgBuildDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = lastPkgBuildDate
        self.lastPkgBuildDate = initvalue_
        self.license = license
        self.milestoneUris = milestoneUris
        if orgResourcesAccessRights is None:
            self.orgResourcesAccessRights = []
        else:
            self.orgResourcesAccessRights = orgResourcesAccessRights
        self.orgResourcesAccessRightsUri = orgResourcesAccessRightsUri
        self.parentUri = parentUri
        self.pkgType = pkgType
        self.preselected = preselected
        self.profileUris = profileUris
        self.distribProfiles = distribProfiles
        if prohibitedFormats is None:
            self.prohibitedFormats = []
        else:
            self.prohibitedFormats = prohibitedFormats
        self.projectUris = projectUris
        if isinstance(releaseDate, basestring):
            initvalue_ = datetime_.datetime.strptime(releaseDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = releaseDate
        self.releaseDate = initvalue_
        self.serviceUris = serviceUris
        self.size = size
        self.skeletonSize = skeletonSize
        self.uri = uri
        self.version = version
        self.versionId = versionId
        self.visible = visible
        self.welcomeMsg = welcomeMsg
    def factory(*args_, **kwargs_):
        if distribution.subclass:
            return distribution.subclass(*args_, **kwargs_)
        else:
            return distribution(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_active(self): return self.active
    def set_active(self, active): self.active = active
    def get_arch(self): return self.arch
    def set_arch(self, arch): self.arch = arch
    def get_baseInstallConfigUri(self): return self.baseInstallConfigUri
    def set_baseInstallConfigUri(self, baseInstallConfigUri): self.baseInstallConfigUri = baseInstallConfigUri
    def get_baseMilestonesUri(self): return self.baseMilestonesUri
    def set_baseMilestonesUri(self, baseMilestonesUri): self.baseMilestonesUri = baseMilestonesUri
    def get_baseOASRtUri(self): return self.baseOASRtUri
    def set_baseOASRtUri(self, baseOASRtUri): self.baseOASRtUri = baseOASRtUri
    def get_basePkgsUri(self): return self.basePkgsUri
    def set_basePkgsUri(self, basePkgsUri): self.basePkgsUri = basePkgsUri
    def get_baseProfilesUri(self): return self.baseProfilesUri
    def set_baseProfilesUri(self, baseProfilesUri): self.baseProfilesUri = baseProfilesUri
    def get_baseProhibitedFormatsUri(self): return self.baseProhibitedFormatsUri
    def set_baseProhibitedFormatsUri(self, baseProhibitedFormatsUri): self.baseProhibitedFormatsUri = baseProhibitedFormatsUri
    def get_baseProjectsUri(self): return self.baseProjectsUri
    def set_baseProjectsUri(self, baseProjectsUri): self.baseProjectsUri = baseProjectsUri
    def get_baseServicesUri(self): return self.baseServicesUri
    def set_baseServicesUri(self, baseServicesUri): self.baseServicesUri = baseServicesUri
    def get_company(self): return self.company
    def set_company(self, company): self.company = company
    def get_completeProfileUri(self): return self.completeProfileUri
    def set_completeProfileUri(self, completeProfileUri): self.completeProfileUri = completeProfileUri
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_family(self): return self.family
    def set_family(self, family): self.family = family
    def get_lastPkgBuildDate(self): return self.lastPkgBuildDate
    def set_lastPkgBuildDate(self, lastPkgBuildDate): self.lastPkgBuildDate = lastPkgBuildDate
    def get_license(self): return self.license
    def set_license(self, license): self.license = license
    def get_milestoneUris(self): return self.milestoneUris
    def set_milestoneUris(self, milestoneUris): self.milestoneUris = milestoneUris
    def get_orgResourcesAccessRights(self): return self.orgResourcesAccessRights
    def set_orgResourcesAccessRights(self, orgResourcesAccessRights): self.orgResourcesAccessRights = orgResourcesAccessRights
    def add_orgResourcesAccessRights(self, value): self.orgResourcesAccessRights.append(value)
    def insert_orgResourcesAccessRights(self, index, value): self.orgResourcesAccessRights[index] = value
    def get_orgResourcesAccessRightsUri(self): return self.orgResourcesAccessRightsUri
    def set_orgResourcesAccessRightsUri(self, orgResourcesAccessRightsUri): self.orgResourcesAccessRightsUri = orgResourcesAccessRightsUri
    def get_parentUri(self): return self.parentUri
    def set_parentUri(self, parentUri): self.parentUri = parentUri
    def get_pkgType(self): return self.pkgType
    def set_pkgType(self, pkgType): self.pkgType = pkgType
    def get_preselected(self): return self.preselected
    def set_preselected(self, preselected): self.preselected = preselected
    def get_profileUris(self): return self.profileUris
    def set_profileUris(self, profileUris): self.profileUris = profileUris
    def get_distribProfiles(self): return self.distribProfiles
    def set_distribProfiles(self, distribProfiles): self.distribProfiles = distribProfiles
    def get_prohibitedFormats(self): return self.prohibitedFormats
    def set_prohibitedFormats(self, prohibitedFormats): self.prohibitedFormats = prohibitedFormats
    def add_prohibitedFormats(self, value): self.prohibitedFormats.append(value)
    def insert_prohibitedFormats(self, index, value): self.prohibitedFormats[index] = value
    def get_projectUris(self): return self.projectUris
    def set_projectUris(self, projectUris): self.projectUris = projectUris
    def get_releaseDate(self): return self.releaseDate
    def set_releaseDate(self, releaseDate): self.releaseDate = releaseDate
    def get_serviceUris(self): return self.serviceUris
    def set_serviceUris(self, serviceUris): self.serviceUris = serviceUris
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    def get_skeletonSize(self): return self.skeletonSize
    def set_skeletonSize(self, skeletonSize): self.skeletonSize = skeletonSize
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_versionId(self): return self.versionId
    def set_versionId(self, versionId): self.versionId = versionId
    def get_visible(self): return self.visible
    def set_visible(self, visible): self.visible = visible
    def get_welcomeMsg(self): return self.welcomeMsg
    def set_welcomeMsg(self, welcomeMsg): self.welcomeMsg = welcomeMsg
    def hasContent_(self):
        if (
            self.active is not None or
            self.arch is not None or
            self.baseInstallConfigUri is not None or
            self.baseMilestonesUri is not None or
            self.baseOASRtUri is not None or
            self.basePkgsUri is not None or
            self.baseProfilesUri is not None or
            self.baseProhibitedFormatsUri is not None or
            self.baseProjectsUri is not None or
            self.baseServicesUri is not None or
            self.company is not None or
            self.completeProfileUri is not None or
            self.description is not None or
            self.family is not None or
            self.lastPkgBuildDate is not None or
            self.license is not None or
            self.milestoneUris is not None or
            self.orgResourcesAccessRights or
            self.orgResourcesAccessRightsUri is not None or
            self.parentUri is not None or
            self.pkgType is not None or
            self.preselected is not None or
            self.profileUris is not None or
            self.distribProfiles is not None or
            self.prohibitedFormats or
            self.projectUris is not None or
            self.releaseDate is not None or
            self.serviceUris is not None or
            self.size is not None or
            self.skeletonSize is not None or
            self.uri is not None or
            self.version is not None or
            self.versionId is not None or
            self.visible is not None or
            self.welcomeMsg is not None or
            super(distribution, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='distribution', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='distribution')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='distribution'):
        super(distribution, self).exportAttributes(outfile, level, already_processed, namespace_, name_='distribution')
    def exportChildren(self, outfile, level, namespace_='', name_='distribution', fromsubclass_=False, pretty_print=True):
        super(distribution, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.active is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sactive>%s</%sactive>%s' % (namespace_, self.gds_format_boolean(self.active, input_name='active'), namespace_, eol_))
        if self.arch is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sarch>%s</%sarch>%s' % (namespace_, self.gds_format_string(quote_xml(self.arch).encode(ExternalEncoding), input_name='arch'), namespace_, eol_))
        if self.baseInstallConfigUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseInstallConfigUri>%s</%sbaseInstallConfigUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseInstallConfigUri).encode(ExternalEncoding), input_name='baseInstallConfigUri'), namespace_, eol_))
        if self.baseMilestonesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseMilestonesUri>%s</%sbaseMilestonesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseMilestonesUri).encode(ExternalEncoding), input_name='baseMilestonesUri'), namespace_, eol_))
        if self.baseOASRtUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseOASRtUri>%s</%sbaseOASRtUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseOASRtUri).encode(ExternalEncoding), input_name='baseOASRtUri'), namespace_, eol_))
        if self.basePkgsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbasePkgsUri>%s</%sbasePkgsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.basePkgsUri).encode(ExternalEncoding), input_name='basePkgsUri'), namespace_, eol_))
        if self.baseProfilesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseProfilesUri>%s</%sbaseProfilesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseProfilesUri).encode(ExternalEncoding), input_name='baseProfilesUri'), namespace_, eol_))
        if self.baseProhibitedFormatsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseProhibitedFormatsUri>%s</%sbaseProhibitedFormatsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseProhibitedFormatsUri).encode(ExternalEncoding), input_name='baseProhibitedFormatsUri'), namespace_, eol_))
        if self.baseProjectsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseProjectsUri>%s</%sbaseProjectsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseProjectsUri).encode(ExternalEncoding), input_name='baseProjectsUri'), namespace_, eol_))
        if self.baseServicesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseServicesUri>%s</%sbaseServicesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseServicesUri).encode(ExternalEncoding), input_name='baseServicesUri'), namespace_, eol_))
        if self.company is not None:
            self.company.export(outfile, level, namespace_, name_='company', pretty_print=pretty_print)
        if self.completeProfileUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scompleteProfileUri>%s</%scompleteProfileUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.completeProfileUri).encode(ExternalEncoding), input_name='completeProfileUri'), namespace_, eol_))
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_, eol_))
        if self.family is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfamily>%s</%sfamily>%s' % (namespace_, self.gds_format_string(quote_xml(self.family).encode(ExternalEncoding), input_name='family'), namespace_, eol_))
        if self.lastPkgBuildDate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slastPkgBuildDate>%s</%slastPkgBuildDate>%s' % (namespace_, self.gds_format_datetime(self.lastPkgBuildDate, input_name='lastPkgBuildDate'), namespace_, eol_))
        if self.license is not None:
            self.license.export(outfile, level, namespace_, name_='license', pretty_print=pretty_print)
        if self.milestoneUris is not None:
            self.milestoneUris.export(outfile, level, namespace_, name_='milestoneUris', pretty_print=pretty_print)
        for orgResourcesAccessRights_ in self.orgResourcesAccessRights:
            orgResourcesAccessRights_.export(outfile, level, namespace_, name_='orgResourcesAccessRights', pretty_print=pretty_print)
        if self.orgResourcesAccessRightsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorgResourcesAccessRightsUri>%s</%sorgResourcesAccessRightsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.orgResourcesAccessRightsUri).encode(ExternalEncoding), input_name='orgResourcesAccessRightsUri'), namespace_, eol_))
        if self.parentUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparentUri>%s</%sparentUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.parentUri).encode(ExternalEncoding), input_name='parentUri'), namespace_, eol_))
        if self.pkgType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spkgType>%s</%spkgType>%s' % (namespace_, self.gds_format_string(quote_xml(self.pkgType).encode(ExternalEncoding), input_name='pkgType'), namespace_, eol_))
        if self.preselected is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spreselected>%s</%spreselected>%s' % (namespace_, self.gds_format_boolean(self.preselected, input_name='preselected'), namespace_, eol_))
        if self.profileUris is not None:
            self.profileUris.export(outfile, level, namespace_, name_='profileUris', pretty_print=pretty_print)
        if self.distribProfiles is not None:
            self.distribProfiles.export(outfile, level, namespace_, name_='distribProfiles', pretty_print=pretty_print)
        for prohibitedFormats_ in self.prohibitedFormats:
            prohibitedFormats_.export(outfile, level, namespace_, name_='prohibitedFormats', pretty_print=pretty_print)
        if self.projectUris is not None:
            self.projectUris.export(outfile, level, namespace_, name_='projectUris', pretty_print=pretty_print)
        if self.releaseDate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreleaseDate>%s</%sreleaseDate>%s' % (namespace_, self.gds_format_datetime(self.releaseDate, input_name='releaseDate'), namespace_, eol_))
        if self.serviceUris is not None:
            self.serviceUris.export(outfile, level, namespace_, name_='serviceUris', pretty_print=pretty_print)
        if self.size is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssize>%s</%ssize>%s' % (namespace_, self.gds_format_integer(self.size, input_name='size'), namespace_, eol_))
        if self.skeletonSize is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sskeletonSize>%s</%sskeletonSize>%s' % (namespace_, self.gds_format_integer(self.skeletonSize, input_name='skeletonSize'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
        if self.version is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sversion>%s</%sversion>%s' % (namespace_, self.gds_format_string(quote_xml(self.version).encode(ExternalEncoding), input_name='version'), namespace_, eol_))
        if self.versionId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sversionId>%s</%sversionId>%s' % (namespace_, self.gds_format_integer(self.versionId, input_name='versionId'), namespace_, eol_))
        if self.visible is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svisible>%s</%svisible>%s' % (namespace_, self.gds_format_boolean(self.visible, input_name='visible'), namespace_, eol_))
        if self.welcomeMsg is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%swelcomeMsg>%s</%swelcomeMsg>%s' % (namespace_, self.gds_format_string(quote_xml(self.welcomeMsg).encode(ExternalEncoding), input_name='welcomeMsg'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='distribution'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(distribution, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(distribution, self).exportLiteralChildren(outfile, level, name_)
        if self.active is not None:
            showIndent(outfile, level)
            outfile.write('active=%s,\n' % self.active)
        if self.arch is not None:
            showIndent(outfile, level)
            outfile.write('arch=%s,\n' % quote_python(self.arch).encode(ExternalEncoding))
        if self.baseInstallConfigUri is not None:
            showIndent(outfile, level)
            outfile.write('baseInstallConfigUri=%s,\n' % quote_python(self.baseInstallConfigUri).encode(ExternalEncoding))
        if self.baseMilestonesUri is not None:
            showIndent(outfile, level)
            outfile.write('baseMilestonesUri=%s,\n' % quote_python(self.baseMilestonesUri).encode(ExternalEncoding))
        if self.baseOASRtUri is not None:
            showIndent(outfile, level)
            outfile.write('baseOASRtUri=%s,\n' % quote_python(self.baseOASRtUri).encode(ExternalEncoding))
        if self.basePkgsUri is not None:
            showIndent(outfile, level)
            outfile.write('basePkgsUri=%s,\n' % quote_python(self.basePkgsUri).encode(ExternalEncoding))
        if self.baseProfilesUri is not None:
            showIndent(outfile, level)
            outfile.write('baseProfilesUri=%s,\n' % quote_python(self.baseProfilesUri).encode(ExternalEncoding))
        if self.baseProhibitedFormatsUri is not None:
            showIndent(outfile, level)
            outfile.write('baseProhibitedFormatsUri=%s,\n' % quote_python(self.baseProhibitedFormatsUri).encode(ExternalEncoding))
        if self.baseProjectsUri is not None:
            showIndent(outfile, level)
            outfile.write('baseProjectsUri=%s,\n' % quote_python(self.baseProjectsUri).encode(ExternalEncoding))
        if self.baseServicesUri is not None:
            showIndent(outfile, level)
            outfile.write('baseServicesUri=%s,\n' % quote_python(self.baseServicesUri).encode(ExternalEncoding))
        if self.company is not None:
            showIndent(outfile, level)
            outfile.write('company=model_.company(\n')
            self.company.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.completeProfileUri is not None:
            showIndent(outfile, level)
            outfile.write('completeProfileUri=%s,\n' % quote_python(self.completeProfileUri).encode(ExternalEncoding))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        if self.family is not None:
            showIndent(outfile, level)
            outfile.write('family=%s,\n' % quote_python(self.family).encode(ExternalEncoding))
        if self.lastPkgBuildDate is not None:
            showIndent(outfile, level)
            outfile.write('lastPkgBuildDate=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.lastPkgBuildDate, input_name='lastPkgBuildDate'))
        if self.license is not None:
            showIndent(outfile, level)
            outfile.write('license=model_.license(\n')
            self.license.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.milestoneUris is not None:
            showIndent(outfile, level)
            outfile.write('milestoneUris=model_.uriList(\n')
            self.milestoneUris.exportLiteral(outfile, level, name_='milestoneUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('orgResourcesAccessRights=[\n')
        level += 1
        for orgResourcesAccessRights_ in self.orgResourcesAccessRights:
            showIndent(outfile, level)
            outfile.write('model_.orgResourcesRights(\n')
            orgResourcesAccessRights_.exportLiteral(outfile, level, name_='orgResourcesRights')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.orgResourcesAccessRightsUri is not None:
            showIndent(outfile, level)
            outfile.write('orgResourcesAccessRightsUri=%s,\n' % quote_python(self.orgResourcesAccessRightsUri).encode(ExternalEncoding))
        if self.parentUri is not None:
            showIndent(outfile, level)
            outfile.write('parentUri=%s,\n' % quote_python(self.parentUri).encode(ExternalEncoding))
        if self.pkgType is not None:
            showIndent(outfile, level)
            outfile.write('pkgType=%s,\n' % quote_python(self.pkgType).encode(ExternalEncoding))
        if self.preselected is not None:
            showIndent(outfile, level)
            outfile.write('preselected=%s,\n' % self.preselected)
        if self.profileUris is not None:
            showIndent(outfile, level)
            outfile.write('profileUris=model_.uriList(\n')
            self.profileUris.exportLiteral(outfile, level, name_='profileUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.distribProfiles is not None:
            showIndent(outfile, level)
            outfile.write('distribProfiles=model_.distribProfiles(\n')
            self.distribProfiles.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('prohibitedFormats=[\n')
        level += 1
        for prohibitedFormats_ in self.prohibitedFormats:
            showIndent(outfile, level)
            outfile.write('model_.permissionFormat(\n')
            prohibitedFormats_.exportLiteral(outfile, level, name_='permissionFormat')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.projectUris is not None:
            showIndent(outfile, level)
            outfile.write('projectUris=model_.uriList(\n')
            self.projectUris.exportLiteral(outfile, level, name_='projectUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.releaseDate is not None:
            showIndent(outfile, level)
            outfile.write('releaseDate=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.releaseDate, input_name='releaseDate'))
        if self.serviceUris is not None:
            showIndent(outfile, level)
            outfile.write('serviceUris=model_.uriList(\n')
            self.serviceUris.exportLiteral(outfile, level, name_='serviceUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('size=%d,\n' % self.size)
        if self.skeletonSize is not None:
            showIndent(outfile, level)
            outfile.write('skeletonSize=%d,\n' % self.skeletonSize)
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version=%s,\n' % quote_python(self.version).encode(ExternalEncoding))
        if self.versionId is not None:
            showIndent(outfile, level)
            outfile.write('versionId=%d,\n' % self.versionId)
        if self.visible is not None:
            showIndent(outfile, level)
            outfile.write('visible=%s,\n' % self.visible)
        if self.welcomeMsg is not None:
            showIndent(outfile, level)
            outfile.write('welcomeMsg=%s,\n' % quote_python(self.welcomeMsg).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(distribution, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'active':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'active')
            self.active = ival_
        elif nodeName_ == 'arch':
            arch_ = child_.text
            arch_ = self.gds_validate_string(arch_, node, 'arch')
            self.arch = arch_
        elif nodeName_ == 'baseInstallConfigUri':
            baseInstallConfigUri_ = child_.text
            baseInstallConfigUri_ = self.gds_validate_string(baseInstallConfigUri_, node, 'baseInstallConfigUri')
            self.baseInstallConfigUri = baseInstallConfigUri_
        elif nodeName_ == 'baseMilestonesUri':
            baseMilestonesUri_ = child_.text
            baseMilestonesUri_ = self.gds_validate_string(baseMilestonesUri_, node, 'baseMilestonesUri')
            self.baseMilestonesUri = baseMilestonesUri_
        elif nodeName_ == 'baseOASRtUri':
            baseOASRtUri_ = child_.text
            baseOASRtUri_ = self.gds_validate_string(baseOASRtUri_, node, 'baseOASRtUri')
            self.baseOASRtUri = baseOASRtUri_
        elif nodeName_ == 'basePkgsUri':
            basePkgsUri_ = child_.text
            basePkgsUri_ = self.gds_validate_string(basePkgsUri_, node, 'basePkgsUri')
            self.basePkgsUri = basePkgsUri_
        elif nodeName_ == 'baseProfilesUri':
            baseProfilesUri_ = child_.text
            baseProfilesUri_ = self.gds_validate_string(baseProfilesUri_, node, 'baseProfilesUri')
            self.baseProfilesUri = baseProfilesUri_
        elif nodeName_ == 'baseProhibitedFormatsUri':
            baseProhibitedFormatsUri_ = child_.text
            baseProhibitedFormatsUri_ = self.gds_validate_string(baseProhibitedFormatsUri_, node, 'baseProhibitedFormatsUri')
            self.baseProhibitedFormatsUri = baseProhibitedFormatsUri_
        elif nodeName_ == 'baseProjectsUri':
            baseProjectsUri_ = child_.text
            baseProjectsUri_ = self.gds_validate_string(baseProjectsUri_, node, 'baseProjectsUri')
            self.baseProjectsUri = baseProjectsUri_
        elif nodeName_ == 'baseServicesUri':
            baseServicesUri_ = child_.text
            baseServicesUri_ = self.gds_validate_string(baseServicesUri_, node, 'baseServicesUri')
            self.baseServicesUri = baseServicesUri_
        elif nodeName_ == 'company':
            obj_ = company.factory()
            obj_.build(child_)
            self.company = obj_
        elif nodeName_ == 'completeProfileUri':
            completeProfileUri_ = child_.text
            completeProfileUri_ = self.gds_validate_string(completeProfileUri_, node, 'completeProfileUri')
            self.completeProfileUri = completeProfileUri_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'family':
            family_ = child_.text
            family_ = self.gds_validate_string(family_, node, 'family')
            self.family = family_
        elif nodeName_ == 'lastPkgBuildDate':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.lastPkgBuildDate = dval_
        elif nodeName_ == 'license':
            obj_ = license.factory()
            obj_.build(child_)
            self.license = obj_
        elif nodeName_ == 'milestoneUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.milestoneUris = obj_
        elif nodeName_ == 'orgResourcesAccessRights':
            obj_ = orgResourcesRights.factory()
            obj_.build(child_)
            self.orgResourcesAccessRights.append(obj_)
        elif nodeName_ == 'orgResourcesAccessRightsUri':
            orgResourcesAccessRightsUri_ = child_.text
            orgResourcesAccessRightsUri_ = self.gds_validate_string(orgResourcesAccessRightsUri_, node, 'orgResourcesAccessRightsUri')
            self.orgResourcesAccessRightsUri = orgResourcesAccessRightsUri_
        elif nodeName_ == 'parentUri':
            parentUri_ = child_.text
            parentUri_ = self.gds_validate_string(parentUri_, node, 'parentUri')
            self.parentUri = parentUri_
        elif nodeName_ == 'pkgType':
            pkgType_ = child_.text
            pkgType_ = self.gds_validate_string(pkgType_, node, 'pkgType')
            self.pkgType = pkgType_
        elif nodeName_ == 'preselected':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'preselected')
            self.preselected = ival_
        elif nodeName_ == 'profileUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.profileUris = obj_
        elif nodeName_ == 'distribProfiles':
            obj_ = distribProfiles.factory()
            obj_.build(child_)
            self.distribProfiles = obj_
        elif nodeName_ == 'prohibitedFormats':
            obj_ = permissionFormat.factory()
            obj_.build(child_)
            self.prohibitedFormats.append(obj_)
        elif nodeName_ == 'projectUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.projectUris = obj_
        elif nodeName_ == 'releaseDate':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.releaseDate = dval_
        elif nodeName_ == 'serviceUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.serviceUris = obj_
        elif nodeName_ == 'size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'size')
            self.size = ival_
        elif nodeName_ == 'skeletonSize':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'skeletonSize')
            self.skeletonSize = ival_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'version':
            version_ = child_.text
            version_ = self.gds_validate_string(version_, node, 'version')
            self.version = version_
        elif nodeName_ == 'versionId':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'versionId')
            self.versionId = ival_
        elif nodeName_ == 'visible':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'visible')
            self.visible = ival_
        elif nodeName_ == 'welcomeMsg':
            welcomeMsg_ = child_.text
            welcomeMsg_ = self.gds_validate_string(welcomeMsg_, node, 'welcomeMsg')
            self.welcomeMsg = welcomeMsg_
        super(distribution, self).buildChildren(child_, node, nodeName_, True)
# end class distribution


class distribProfiles(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, distribProfile=None):
        if distribProfile is None:
            self.distribProfile = []
        else:
            self.distribProfile = distribProfile
    def factory(*args_, **kwargs_):
        if distribProfiles.subclass:
            return distribProfiles.subclass(*args_, **kwargs_)
        else:
            return distribProfiles(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_distribProfile(self): return self.distribProfile
    def set_distribProfile(self, distribProfile): self.distribProfile = distribProfile
    def add_distribProfile(self, value): self.distribProfile.append(value)
    def insert_distribProfile(self, index, value): self.distribProfile[index] = value
    def hasContent_(self):
        if (
            self.distribProfile
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='distribProfiles', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='distribProfiles')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='distribProfiles'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='distribProfiles', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for distribProfile_ in self.distribProfile:
            distribProfile_.export(outfile, level, namespace_, name_='distribProfile', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='distribProfiles'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('distribProfile=[\n')
        level += 1
        for distribProfile_ in self.distribProfile:
            showIndent(outfile, level)
            outfile.write('model_.distribProfileTemplate(\n')
            distribProfile_.exportLiteral(outfile, level, name_='distribProfileTemplate')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'distribProfile':
            class_obj_ = self.get_class_obj_(child_, distribProfileTemplate)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.distribProfile.append(obj_)
# end class distribProfiles


class company(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, address=None, logo=None, parentUri=None, uri=None, website=None):
        super(company, self).__init__(created, dbId, digest, lastModified, name, )
        self.address = address
        self.logo = logo
        self.parentUri = parentUri
        self.uri = uri
        self.website = website
    def factory(*args_, **kwargs_):
        if company.subclass:
            return company.subclass(*args_, **kwargs_)
        else:
            return company(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def get_logo(self): return self.logo
    def set_logo(self, logo): self.logo = logo
    def get_parentUri(self): return self.parentUri
    def set_parentUri(self, parentUri): self.parentUri = parentUri
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_website(self): return self.website
    def set_website(self, website): self.website = website
    def hasContent_(self):
        if (
            self.address is not None or
            self.logo is not None or
            self.parentUri is not None or
            self.uri is not None or
            self.website is not None or
            super(company, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='company', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='company')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='company'):
        super(company, self).exportAttributes(outfile, level, already_processed, namespace_, name_='company')
    def exportChildren(self, outfile, level, namespace_='', name_='company', fromsubclass_=False, pretty_print=True):
        super(company, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.address is not None:
            self.address.export(outfile, level, namespace_, name_='address', pretty_print=pretty_print)
        if self.logo is not None:
            self.logo.export(outfile, level, namespace_, name_='logo', pretty_print=pretty_print)
        if self.parentUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparentUri>%s</%sparentUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.parentUri).encode(ExternalEncoding), input_name='parentUri'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
        if self.website is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%swebsite>%s</%swebsite>%s' % (namespace_, self.gds_format_string(quote_xml(self.website).encode(ExternalEncoding), input_name='website'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='company'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(company, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(company, self).exportLiteralChildren(outfile, level, name_)
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('address=model_.address(\n')
            self.address.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.logo is not None:
            showIndent(outfile, level)
            outfile.write('logo=model_.logo(\n')
            self.logo.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.parentUri is not None:
            showIndent(outfile, level)
            outfile.write('parentUri=%s,\n' % quote_python(self.parentUri).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.website is not None:
            showIndent(outfile, level)
            outfile.write('website=%s,\n' % quote_python(self.website).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(company, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'address':
            obj_ = address.factory()
            obj_.build(child_)
            self.address = obj_
        elif nodeName_ == 'logo':
            obj_ = logo.factory()
            obj_.build(child_)
            self.logo = obj_
        elif nodeName_ == 'parentUri':
            parentUri_ = child_.text
            parentUri_ = self.gds_validate_string(parentUri_, node, 'parentUri')
            self.parentUri = parentUri_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'website':
            website_ = child_.text
            website_ = self.gds_validate_string(website_, node, 'website')
            self.website = website_
        super(company, self).buildChildren(child_, node, nodeName_, True)
# end class company


class address(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, country=None, region_state=None, street=None, town=None, zipcode=None):
        super(address, self).__init__(created, dbId, digest, lastModified, name, )
        self.country = country
        self.region_state = region_state
        self.street = street
        self.town = town
        self.zipcode = zipcode
    def factory(*args_, **kwargs_):
        if address.subclass:
            return address.subclass(*args_, **kwargs_)
        else:
            return address(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_country(self): return self.country
    def set_country(self, country): self.country = country
    def get_region_state(self): return self.region_state
    def set_region_state(self, region_state): self.region_state = region_state
    def get_street(self): return self.street
    def set_street(self, street): self.street = street
    def get_town(self): return self.town
    def set_town(self, town): self.town = town
    def get_zipcode(self): return self.zipcode
    def set_zipcode(self, zipcode): self.zipcode = zipcode
    def hasContent_(self):
        if (
            self.country is not None or
            self.region_state is not None or
            self.street is not None or
            self.town is not None or
            self.zipcode is not None or
            super(address, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='address', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='address')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='address'):
        super(address, self).exportAttributes(outfile, level, already_processed, namespace_, name_='address')
    def exportChildren(self, outfile, level, namespace_='', name_='address', fromsubclass_=False, pretty_print=True):
        super(address, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.country is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scountry>%s</%scountry>%s' % (namespace_, self.gds_format_string(quote_xml(self.country).encode(ExternalEncoding), input_name='country'), namespace_, eol_))
        if self.region_state is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sregion_state>%s</%sregion_state>%s' % (namespace_, self.gds_format_string(quote_xml(self.region_state).encode(ExternalEncoding), input_name='region_state'), namespace_, eol_))
        if self.street is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstreet>%s</%sstreet>%s' % (namespace_, self.gds_format_string(quote_xml(self.street).encode(ExternalEncoding), input_name='street'), namespace_, eol_))
        if self.town is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stown>%s</%stown>%s' % (namespace_, self.gds_format_string(quote_xml(self.town).encode(ExternalEncoding), input_name='town'), namespace_, eol_))
        if self.zipcode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%szipcode>%s</%szipcode>%s' % (namespace_, self.gds_format_string(quote_xml(self.zipcode).encode(ExternalEncoding), input_name='zipcode'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='address'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(address, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(address, self).exportLiteralChildren(outfile, level, name_)
        if self.country is not None:
            showIndent(outfile, level)
            outfile.write('country=%s,\n' % quote_python(self.country).encode(ExternalEncoding))
        if self.region_state is not None:
            showIndent(outfile, level)
            outfile.write('region_state=%s,\n' % quote_python(self.region_state).encode(ExternalEncoding))
        if self.street is not None:
            showIndent(outfile, level)
            outfile.write('street=%s,\n' % quote_python(self.street).encode(ExternalEncoding))
        if self.town is not None:
            showIndent(outfile, level)
            outfile.write('town=%s,\n' % quote_python(self.town).encode(ExternalEncoding))
        if self.zipcode is not None:
            showIndent(outfile, level)
            outfile.write('zipcode=%s,\n' % quote_python(self.zipcode).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(address, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'country':
            country_ = child_.text
            country_ = self.gds_validate_string(country_, node, 'country')
            self.country = country_
        elif nodeName_ == 'region_state':
            region_state_ = child_.text
            region_state_ = self.gds_validate_string(region_state_, node, 'region_state')
            self.region_state = region_state_
        elif nodeName_ == 'street':
            street_ = child_.text
            street_ = self.gds_validate_string(street_, node, 'street')
            self.street = street_
        elif nodeName_ == 'town':
            town_ = child_.text
            town_ = self.gds_validate_string(town_, node, 'town')
            self.town = town_
        elif nodeName_ == 'zipcode':
            zipcode_ = child_.text
            zipcode_ = self.gds_validate_string(zipcode_, node, 'zipcode')
            self.zipcode = zipcode_
        super(address, self).buildChildren(child_, node, nodeName_, True)
# end class address


class uForgeUploadObject(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, md5sum=None, mimeType=None, sha256sum=None, size=None, status=None, uploaded=None, uploadedTime=None, extensiontype_=None):
        super(uForgeUploadObject, self).__init__(created, dbId, digest, lastModified, name, extensiontype_, )
        self.md5sum = md5sum
        self.mimeType = mimeType
        self.sha256sum = sha256sum
        self.size = size
        self.status = status
        self.uploaded = uploaded
        if isinstance(uploadedTime, basestring):
            initvalue_ = datetime_.datetime.strptime(uploadedTime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = uploadedTime
        self.uploadedTime = initvalue_
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if uForgeUploadObject.subclass:
            return uForgeUploadObject.subclass(*args_, **kwargs_)
        else:
            return uForgeUploadObject(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_md5sum(self): return self.md5sum
    def set_md5sum(self, md5sum): self.md5sum = md5sum
    def get_mimeType(self): return self.mimeType
    def set_mimeType(self, mimeType): self.mimeType = mimeType
    def get_sha256sum(self): return self.sha256sum
    def set_sha256sum(self, sha256sum): self.sha256sum = sha256sum
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_uploaded(self): return self.uploaded
    def set_uploaded(self, uploaded): self.uploaded = uploaded
    def get_uploadedTime(self): return self.uploadedTime
    def set_uploadedTime(self, uploadedTime): self.uploadedTime = uploadedTime
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.md5sum is not None or
            self.mimeType is not None or
            self.sha256sum is not None or
            self.size is not None or
            self.status is not None or
            self.uploaded is not None or
            self.uploadedTime is not None or
            super(uForgeUploadObject, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='uForgeUploadObject', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='uForgeUploadObject')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='uForgeUploadObject'):
        super(uForgeUploadObject, self).exportAttributes(outfile, level, already_processed, namespace_, name_='uForgeUploadObject')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='uForgeUploadObject', fromsubclass_=False, pretty_print=True):
        super(uForgeUploadObject, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.md5sum is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smd5sum>%s</%smd5sum>%s' % (namespace_, self.gds_format_string(quote_xml(self.md5sum).encode(ExternalEncoding), input_name='md5sum'), namespace_, eol_))
        if self.mimeType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smimeType>%s</%smimeType>%s' % (namespace_, self.gds_format_string(quote_xml(self.mimeType).encode(ExternalEncoding), input_name='mimeType'), namespace_, eol_))
        if self.sha256sum is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssha256sum>%s</%ssha256sum>%s' % (namespace_, self.gds_format_string(quote_xml(self.sha256sum).encode(ExternalEncoding), input_name='sha256sum'), namespace_, eol_))
        if self.size is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssize>%s</%ssize>%s' % (namespace_, self.gds_format_integer(self.size, input_name='size'), namespace_, eol_))
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status', pretty_print=pretty_print)
        if self.uploaded is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suploaded>%s</%suploaded>%s' % (namespace_, self.gds_format_boolean(self.uploaded, input_name='uploaded'), namespace_, eol_))
        if self.uploadedTime is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suploadedTime>%s</%suploadedTime>%s' % (namespace_, self.gds_format_datetime(self.uploadedTime, input_name='uploadedTime'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='uForgeUploadObject'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(uForgeUploadObject, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(uForgeUploadObject, self).exportLiteralChildren(outfile, level, name_)
        if self.md5sum is not None:
            showIndent(outfile, level)
            outfile.write('md5sum=%s,\n' % quote_python(self.md5sum).encode(ExternalEncoding))
        if self.mimeType is not None:
            showIndent(outfile, level)
            outfile.write('mimeType=%s,\n' % quote_python(self.mimeType).encode(ExternalEncoding))
        if self.sha256sum is not None:
            showIndent(outfile, level)
            outfile.write('sha256sum=%s,\n' % quote_python(self.sha256sum).encode(ExternalEncoding))
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('size=%d,\n' % self.size)
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.uploaded is not None:
            showIndent(outfile, level)
            outfile.write('uploaded=%s,\n' % self.uploaded)
        if self.uploadedTime is not None:
            showIndent(outfile, level)
            outfile.write('uploadedTime=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.uploadedTime, input_name='uploadedTime'))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(uForgeUploadObject, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'md5sum':
            md5sum_ = child_.text
            md5sum_ = self.gds_validate_string(md5sum_, node, 'md5sum')
            self.md5sum = md5sum_
        elif nodeName_ == 'mimeType':
            mimeType_ = child_.text
            mimeType_ = self.gds_validate_string(mimeType_, node, 'mimeType')
            self.mimeType = mimeType_
        elif nodeName_ == 'sha256sum':
            sha256sum_ = child_.text
            sha256sum_ = self.gds_validate_string(sha256sum_, node, 'sha256sum')
            self.sha256sum = sha256sum_
        elif nodeName_ == 'size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'size')
            self.size = ival_
        elif nodeName_ == 'status':
            obj_ = opStatus.factory()
            obj_.build(child_)
            self.status = obj_
        elif nodeName_ == 'uploaded':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'uploaded')
            self.uploaded = ival_
        elif nodeName_ == 'uploadedTime':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.uploadedTime = dval_
        super(uForgeUploadObject, self).buildChildren(child_, node, nodeName_, True)
# end class uForgeUploadObject


class opStatus(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, bytesLoaded=None, bytesTotal=None, cancelled=None, complete=None, detailedError=None, detailedErrorMsg=None, error=None, errorMessage=None, eta=None, message=None, parentUri=None, percentage=None, published=None, totalTime=None, uri=None):
        super(opStatus, self).__init__(created, dbId, digest, lastModified, name, )
        self.bytesLoaded = bytesLoaded
        self.bytesTotal = bytesTotal
        self.cancelled = cancelled
        self.complete = complete
        self.detailedError = detailedError
        self.detailedErrorMsg = detailedErrorMsg
        self.error = error
        self.errorMessage = errorMessage
        if isinstance(eta, basestring):
            initvalue_ = datetime_.datetime.strptime(eta, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = eta
        self.eta = initvalue_
        self.message = message
        self.parentUri = parentUri
        self.percentage = percentage
        self.published = published
        if isinstance(totalTime, basestring):
            initvalue_ = datetime_.datetime.strptime(totalTime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = totalTime
        self.totalTime = initvalue_
        self.uri = uri
    def factory(*args_, **kwargs_):
        if opStatus.subclass:
            return opStatus.subclass(*args_, **kwargs_)
        else:
            return opStatus(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_bytesLoaded(self): return self.bytesLoaded
    def set_bytesLoaded(self, bytesLoaded): self.bytesLoaded = bytesLoaded
    def get_bytesTotal(self): return self.bytesTotal
    def set_bytesTotal(self, bytesTotal): self.bytesTotal = bytesTotal
    def get_cancelled(self): return self.cancelled
    def set_cancelled(self, cancelled): self.cancelled = cancelled
    def get_complete(self): return self.complete
    def set_complete(self, complete): self.complete = complete
    def get_detailedError(self): return self.detailedError
    def set_detailedError(self, detailedError): self.detailedError = detailedError
    def get_detailedErrorMsg(self): return self.detailedErrorMsg
    def set_detailedErrorMsg(self, detailedErrorMsg): self.detailedErrorMsg = detailedErrorMsg
    def get_error(self): return self.error
    def set_error(self, error): self.error = error
    def get_errorMessage(self): return self.errorMessage
    def set_errorMessage(self, errorMessage): self.errorMessage = errorMessage
    def get_eta(self): return self.eta
    def set_eta(self, eta): self.eta = eta
    def get_message(self): return self.message
    def set_message(self, message): self.message = message
    def get_parentUri(self): return self.parentUri
    def set_parentUri(self, parentUri): self.parentUri = parentUri
    def get_percentage(self): return self.percentage
    def set_percentage(self, percentage): self.percentage = percentage
    def get_published(self): return self.published
    def set_published(self, published): self.published = published
    def get_totalTime(self): return self.totalTime
    def set_totalTime(self, totalTime): self.totalTime = totalTime
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def hasContent_(self):
        if (
            self.bytesLoaded is not None or
            self.bytesTotal is not None or
            self.cancelled is not None or
            self.complete is not None or
            self.detailedError is not None or
            self.detailedErrorMsg is not None or
            self.error is not None or
            self.errorMessage is not None or
            self.eta is not None or
            self.message is not None or
            self.parentUri is not None or
            self.percentage is not None or
            self.published is not None or
            self.totalTime is not None or
            self.uri is not None or
            super(opStatus, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='opStatus', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='opStatus')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='opStatus'):
        super(opStatus, self).exportAttributes(outfile, level, already_processed, namespace_, name_='opStatus')
    def exportChildren(self, outfile, level, namespace_='', name_='opStatus', fromsubclass_=False, pretty_print=True):
        super(opStatus, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.bytesLoaded is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbytesLoaded>%s</%sbytesLoaded>%s' % (namespace_, self.gds_format_integer(self.bytesLoaded, input_name='bytesLoaded'), namespace_, eol_))
        if self.bytesTotal is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbytesTotal>%s</%sbytesTotal>%s' % (namespace_, self.gds_format_integer(self.bytesTotal, input_name='bytesTotal'), namespace_, eol_))
        if self.cancelled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scancelled>%s</%scancelled>%s' % (namespace_, self.gds_format_boolean(self.cancelled, input_name='cancelled'), namespace_, eol_))
        if self.complete is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scomplete>%s</%scomplete>%s' % (namespace_, self.gds_format_boolean(self.complete, input_name='complete'), namespace_, eol_))
        if self.detailedError is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetailedError>%s</%sdetailedError>%s' % (namespace_, self.gds_format_boolean(self.detailedError, input_name='detailedError'), namespace_, eol_))
        if self.detailedErrorMsg is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetailedErrorMsg>%s</%sdetailedErrorMsg>%s' % (namespace_, self.gds_format_string(quote_xml(self.detailedErrorMsg).encode(ExternalEncoding), input_name='detailedErrorMsg'), namespace_, eol_))
        if self.error is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespace_, self.gds_format_boolean(self.error, input_name='error'), namespace_, eol_))
        if self.errorMessage is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serrorMessage>%s</%serrorMessage>%s' % (namespace_, self.gds_format_string(quote_xml(self.errorMessage).encode(ExternalEncoding), input_name='errorMessage'), namespace_, eol_))
        if self.eta is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%seta>%s</%seta>%s' % (namespace_, self.gds_format_datetime(self.eta, input_name='eta'), namespace_, eol_))
        if self.message is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smessage>%s</%smessage>%s' % (namespace_, self.gds_format_string(quote_xml(self.message).encode(ExternalEncoding), input_name='message'), namespace_, eol_))
        if self.parentUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparentUri>%s</%sparentUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.parentUri).encode(ExternalEncoding), input_name='parentUri'), namespace_, eol_))
        if self.percentage is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spercentage>%s</%spercentage>%s' % (namespace_, self.gds_format_integer(self.percentage, input_name='percentage'), namespace_, eol_))
        if self.published is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spublished>%s</%spublished>%s' % (namespace_, self.gds_format_boolean(self.published, input_name='published'), namespace_, eol_))
        if self.totalTime is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stotalTime>%s</%stotalTime>%s' % (namespace_, self.gds_format_datetime(self.totalTime, input_name='totalTime'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='opStatus'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(opStatus, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(opStatus, self).exportLiteralChildren(outfile, level, name_)
        if self.bytesLoaded is not None:
            showIndent(outfile, level)
            outfile.write('bytesLoaded=%d,\n' % self.bytesLoaded)
        if self.bytesTotal is not None:
            showIndent(outfile, level)
            outfile.write('bytesTotal=%d,\n' % self.bytesTotal)
        if self.cancelled is not None:
            showIndent(outfile, level)
            outfile.write('cancelled=%s,\n' % self.cancelled)
        if self.complete is not None:
            showIndent(outfile, level)
            outfile.write('complete=%s,\n' % self.complete)
        if self.detailedError is not None:
            showIndent(outfile, level)
            outfile.write('detailedError=%s,\n' % self.detailedError)
        if self.detailedErrorMsg is not None:
            showIndent(outfile, level)
            outfile.write('detailedErrorMsg=%s,\n' % quote_python(self.detailedErrorMsg).encode(ExternalEncoding))
        if self.error is not None:
            showIndent(outfile, level)
            outfile.write('error=%s,\n' % self.error)
        if self.errorMessage is not None:
            showIndent(outfile, level)
            outfile.write('errorMessage=%s,\n' % quote_python(self.errorMessage).encode(ExternalEncoding))
        if self.eta is not None:
            showIndent(outfile, level)
            outfile.write('eta=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.eta, input_name='eta'))
        if self.message is not None:
            showIndent(outfile, level)
            outfile.write('message=%s,\n' % quote_python(self.message).encode(ExternalEncoding))
        if self.parentUri is not None:
            showIndent(outfile, level)
            outfile.write('parentUri=%s,\n' % quote_python(self.parentUri).encode(ExternalEncoding))
        if self.percentage is not None:
            showIndent(outfile, level)
            outfile.write('percentage=%d,\n' % self.percentage)
        if self.published is not None:
            showIndent(outfile, level)
            outfile.write('published=%s,\n' % self.published)
        if self.totalTime is not None:
            showIndent(outfile, level)
            outfile.write('totalTime=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.totalTime, input_name='totalTime'))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(opStatus, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'bytesLoaded':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'bytesLoaded')
            self.bytesLoaded = ival_
        elif nodeName_ == 'bytesTotal':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'bytesTotal')
            self.bytesTotal = ival_
        elif nodeName_ == 'cancelled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'cancelled')
            self.cancelled = ival_
        elif nodeName_ == 'complete':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'complete')
            self.complete = ival_
        elif nodeName_ == 'detailedError':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'detailedError')
            self.detailedError = ival_
        elif nodeName_ == 'detailedErrorMsg':
            detailedErrorMsg_ = child_.text
            detailedErrorMsg_ = self.gds_validate_string(detailedErrorMsg_, node, 'detailedErrorMsg')
            self.detailedErrorMsg = detailedErrorMsg_
        elif nodeName_ == 'error':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'error')
            self.error = ival_
        elif nodeName_ == 'errorMessage':
            errorMessage_ = child_.text
            errorMessage_ = self.gds_validate_string(errorMessage_, node, 'errorMessage')
            self.errorMessage = errorMessage_
        elif nodeName_ == 'eta':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.eta = dval_
        elif nodeName_ == 'message':
            message_ = child_.text
            message_ = self.gds_validate_string(message_, node, 'message')
            self.message = message_
        elif nodeName_ == 'parentUri':
            parentUri_ = child_.text
            parentUri_ = self.gds_validate_string(parentUri_, node, 'parentUri')
            self.parentUri = parentUri_
        elif nodeName_ == 'percentage':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'percentage')
            self.percentage = ival_
        elif nodeName_ == 'published':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'published')
            self.published = ival_
        elif nodeName_ == 'totalTime':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.totalTime = dval_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(opStatus, self).buildChildren(child_, node, nodeName_, True)
# end class opStatus


class license(uForgeUploadObject):
    subclass = None
    superclass = uForgeUploadObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, md5sum=None, mimeType=None, sha256sum=None, size=None, status=None, uploaded=None, uploadedTime=None, parentUri=None, type_=None, uri=None):
        super(license, self).__init__(created, dbId, digest, lastModified, name, md5sum, mimeType, sha256sum, size, status, uploaded, uploadedTime, )
        self.parentUri = parentUri
        self.type_ = type_
        self.uri = uri
    def factory(*args_, **kwargs_):
        if license.subclass:
            return license.subclass(*args_, **kwargs_)
        else:
            return license(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_parentUri(self): return self.parentUri
    def set_parentUri(self, parentUri): self.parentUri = parentUri
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def hasContent_(self):
        if (
            self.parentUri is not None or
            self.type_ is not None or
            self.uri is not None or
            super(license, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='license', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='license')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='license'):
        super(license, self).exportAttributes(outfile, level, already_processed, namespace_, name_='license')
    def exportChildren(self, outfile, level, namespace_='', name_='license', fromsubclass_=False, pretty_print=True):
        super(license, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.parentUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparentUri>%s</%sparentUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.parentUri).encode(ExternalEncoding), input_name='parentUri'), namespace_, eol_))
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='license'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(license, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(license, self).exportLiteralChildren(outfile, level, name_)
        if self.parentUri is not None:
            showIndent(outfile, level)
            outfile.write('parentUri=%s,\n' % quote_python(self.parentUri).encode(ExternalEncoding))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(license, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'parentUri':
            parentUri_ = child_.text
            parentUri_ = self.gds_validate_string(parentUri_, node, 'parentUri')
            self.parentUri = parentUri_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(license, self).buildChildren(child_, node, nodeName_, True)
# end class license


class uriList(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, uri=None):
        if uri is None:
            self.uri = []
        else:
            self.uri = uri
    def factory(*args_, **kwargs_):
        if uriList.subclass:
            return uriList.subclass(*args_, **kwargs_)
        else:
            return uriList(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def add_uri(self, value): self.uri.append(value)
    def insert_uri(self, index, value): self.uri[index] = value
    def hasContent_(self):
        if (
            self.uri
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='uriList', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='uriList')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='uriList'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='uriList', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for uri_ in self.uri:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(uri_).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='uriList'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('uri=[\n')
        level += 1
        for uri_ in self.uri:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(uri_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri.append(uri_)
# end class uriList


class distribProfileTemplate(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, abbreviation=None, active=None, arch=None, description=None, distributionPackagesUri=None, distributionServicesUri=None, distributionUri=None, installedSize=None, packageUris=None, packagesUri=None, serviceUris=None, servicesUri=None, size=None, uri=None, version=None, extensiontype_=None):
        super(distribProfileTemplate, self).__init__(created, dbId, digest, lastModified, name, extensiontype_, )
        self.abbreviation = abbreviation
        self.active = active
        self.arch = arch
        self.description = description
        self.distributionPackagesUri = distributionPackagesUri
        self.distributionServicesUri = distributionServicesUri
        self.distributionUri = distributionUri
        self.installedSize = installedSize
        self.packageUris = packageUris
        self.packagesUri = packagesUri
        self.serviceUris = serviceUris
        self.servicesUri = servicesUri
        self.size = size
        self.uri = uri
        self.version = version
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if distribProfileTemplate.subclass:
            return distribProfileTemplate.subclass(*args_, **kwargs_)
        else:
            return distribProfileTemplate(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_abbreviation(self): return self.abbreviation
    def set_abbreviation(self, abbreviation): self.abbreviation = abbreviation
    def get_active(self): return self.active
    def set_active(self, active): self.active = active
    def get_arch(self): return self.arch
    def set_arch(self, arch): self.arch = arch
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_distributionPackagesUri(self): return self.distributionPackagesUri
    def set_distributionPackagesUri(self, distributionPackagesUri): self.distributionPackagesUri = distributionPackagesUri
    def get_distributionServicesUri(self): return self.distributionServicesUri
    def set_distributionServicesUri(self, distributionServicesUri): self.distributionServicesUri = distributionServicesUri
    def get_distributionUri(self): return self.distributionUri
    def set_distributionUri(self, distributionUri): self.distributionUri = distributionUri
    def get_installedSize(self): return self.installedSize
    def set_installedSize(self, installedSize): self.installedSize = installedSize
    def get_packageUris(self): return self.packageUris
    def set_packageUris(self, packageUris): self.packageUris = packageUris
    def get_packagesUri(self): return self.packagesUri
    def set_packagesUri(self, packagesUri): self.packagesUri = packagesUri
    def get_serviceUris(self): return self.serviceUris
    def set_serviceUris(self, serviceUris): self.serviceUris = serviceUris
    def get_servicesUri(self): return self.servicesUri
    def set_servicesUri(self, servicesUri): self.servicesUri = servicesUri
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.abbreviation is not None or
            self.active is not None or
            self.arch is not None or
            self.description is not None or
            self.distributionPackagesUri is not None or
            self.distributionServicesUri is not None or
            self.distributionUri is not None or
            self.installedSize is not None or
            self.packageUris is not None or
            self.packagesUri is not None or
            self.serviceUris is not None or
            self.servicesUri is not None or
            self.size is not None or
            self.uri is not None or
            self.version is not None or
            super(distribProfileTemplate, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='distribProfileTemplate', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='distribProfileTemplate')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='distribProfileTemplate'):
        super(distribProfileTemplate, self).exportAttributes(outfile, level, already_processed, namespace_, name_='distribProfileTemplate')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='distribProfileTemplate', fromsubclass_=False, pretty_print=True):
        super(distribProfileTemplate, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.abbreviation is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sabbreviation>%s</%sabbreviation>%s' % (namespace_, self.gds_format_string(quote_xml(self.abbreviation).encode(ExternalEncoding), input_name='abbreviation'), namespace_, eol_))
        if self.active is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sactive>%s</%sactive>%s' % (namespace_, self.gds_format_boolean(self.active, input_name='active'), namespace_, eol_))
        if self.arch is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sarch>%s</%sarch>%s' % (namespace_, self.gds_format_string(quote_xml(self.arch).encode(ExternalEncoding), input_name='arch'), namespace_, eol_))
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_, eol_))
        if self.distributionPackagesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdistributionPackagesUri>%s</%sdistributionPackagesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.distributionPackagesUri).encode(ExternalEncoding), input_name='distributionPackagesUri'), namespace_, eol_))
        if self.distributionServicesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdistributionServicesUri>%s</%sdistributionServicesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.distributionServicesUri).encode(ExternalEncoding), input_name='distributionServicesUri'), namespace_, eol_))
        if self.distributionUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdistributionUri>%s</%sdistributionUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.distributionUri).encode(ExternalEncoding), input_name='distributionUri'), namespace_, eol_))
        if self.installedSize is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinstalledSize>%s</%sinstalledSize>%s' % (namespace_, self.gds_format_integer(self.installedSize, input_name='installedSize'), namespace_, eol_))
        if self.packageUris is not None:
            self.packageUris.export(outfile, level, namespace_, name_='packageUris', pretty_print=pretty_print)
        if self.packagesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spackagesUri>%s</%spackagesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.packagesUri).encode(ExternalEncoding), input_name='packagesUri'), namespace_, eol_))
        if self.serviceUris is not None:
            self.serviceUris.export(outfile, level, namespace_, name_='serviceUris', pretty_print=pretty_print)
        if self.servicesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sservicesUri>%s</%sservicesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.servicesUri).encode(ExternalEncoding), input_name='servicesUri'), namespace_, eol_))
        if self.size is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssize>%s</%ssize>%s' % (namespace_, self.gds_format_integer(self.size, input_name='size'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
        if self.version is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sversion>%s</%sversion>%s' % (namespace_, self.gds_format_string(quote_xml(self.version).encode(ExternalEncoding), input_name='version'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='distribProfileTemplate'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(distribProfileTemplate, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(distribProfileTemplate, self).exportLiteralChildren(outfile, level, name_)
        if self.abbreviation is not None:
            showIndent(outfile, level)
            outfile.write('abbreviation=%s,\n' % quote_python(self.abbreviation).encode(ExternalEncoding))
        if self.active is not None:
            showIndent(outfile, level)
            outfile.write('active=%s,\n' % self.active)
        if self.arch is not None:
            showIndent(outfile, level)
            outfile.write('arch=%s,\n' % quote_python(self.arch).encode(ExternalEncoding))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        if self.distributionPackagesUri is not None:
            showIndent(outfile, level)
            outfile.write('distributionPackagesUri=%s,\n' % quote_python(self.distributionPackagesUri).encode(ExternalEncoding))
        if self.distributionServicesUri is not None:
            showIndent(outfile, level)
            outfile.write('distributionServicesUri=%s,\n' % quote_python(self.distributionServicesUri).encode(ExternalEncoding))
        if self.distributionUri is not None:
            showIndent(outfile, level)
            outfile.write('distributionUri=%s,\n' % quote_python(self.distributionUri).encode(ExternalEncoding))
        if self.installedSize is not None:
            showIndent(outfile, level)
            outfile.write('installedSize=%d,\n' % self.installedSize)
        if self.packageUris is not None:
            showIndent(outfile, level)
            outfile.write('packageUris=model_.uriList(\n')
            self.packageUris.exportLiteral(outfile, level, name_='packageUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.packagesUri is not None:
            showIndent(outfile, level)
            outfile.write('packagesUri=%s,\n' % quote_python(self.packagesUri).encode(ExternalEncoding))
        if self.serviceUris is not None:
            showIndent(outfile, level)
            outfile.write('serviceUris=model_.uriList(\n')
            self.serviceUris.exportLiteral(outfile, level, name_='serviceUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.servicesUri is not None:
            showIndent(outfile, level)
            outfile.write('servicesUri=%s,\n' % quote_python(self.servicesUri).encode(ExternalEncoding))
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('size=%d,\n' % self.size)
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version=%s,\n' % quote_python(self.version).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(distribProfileTemplate, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'abbreviation':
            abbreviation_ = child_.text
            abbreviation_ = self.gds_validate_string(abbreviation_, node, 'abbreviation')
            self.abbreviation = abbreviation_
        elif nodeName_ == 'active':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'active')
            self.active = ival_
        elif nodeName_ == 'arch':
            arch_ = child_.text
            arch_ = self.gds_validate_string(arch_, node, 'arch')
            self.arch = arch_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'distributionPackagesUri':
            distributionPackagesUri_ = child_.text
            distributionPackagesUri_ = self.gds_validate_string(distributionPackagesUri_, node, 'distributionPackagesUri')
            self.distributionPackagesUri = distributionPackagesUri_
        elif nodeName_ == 'distributionServicesUri':
            distributionServicesUri_ = child_.text
            distributionServicesUri_ = self.gds_validate_string(distributionServicesUri_, node, 'distributionServicesUri')
            self.distributionServicesUri = distributionServicesUri_
        elif nodeName_ == 'distributionUri':
            distributionUri_ = child_.text
            distributionUri_ = self.gds_validate_string(distributionUri_, node, 'distributionUri')
            self.distributionUri = distributionUri_
        elif nodeName_ == 'installedSize':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'installedSize')
            self.installedSize = ival_
        elif nodeName_ == 'packageUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.packageUris = obj_
        elif nodeName_ == 'packagesUri':
            packagesUri_ = child_.text
            packagesUri_ = self.gds_validate_string(packagesUri_, node, 'packagesUri')
            self.packagesUri = packagesUri_
        elif nodeName_ == 'serviceUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.serviceUris = obj_
        elif nodeName_ == 'servicesUri':
            servicesUri_ = child_.text
            servicesUri_ = self.gds_validate_string(servicesUri_, node, 'servicesUri')
            self.servicesUri = servicesUri_
        elif nodeName_ == 'size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'size')
            self.size = ival_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'version':
            version_ = child_.text
            version_ = self.gds_validate_string(version_, node, 'version')
            self.version = version_
        super(distribProfileTemplate, self).buildChildren(child_, node, nodeName_, True)
# end class distribProfileTemplate


class resourceUtils(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        pass
    def factory(*args_, **kwargs_):
        if resourceUtils.subclass:
            return resourceUtils.subclass(*args_, **kwargs_)
        else:
            return resourceUtils(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='resourceUtils', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='resourceUtils')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='resourceUtils'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='resourceUtils', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='resourceUtils'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class resourceUtils


class osGroup(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, groupId=None, groupIdAuto=None, sudo=None, systemGroup=None, uri=None):
        super(osGroup, self).__init__(created, dbId, digest, lastModified, name, )
        self.groupId = groupId
        self.groupIdAuto = groupIdAuto
        self.sudo = sudo
        self.systemGroup = systemGroup
        self.uri = uri
    def factory(*args_, **kwargs_):
        if osGroup.subclass:
            return osGroup.subclass(*args_, **kwargs_)
        else:
            return osGroup(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_groupId(self): return self.groupId
    def set_groupId(self, groupId): self.groupId = groupId
    def get_groupIdAuto(self): return self.groupIdAuto
    def set_groupIdAuto(self, groupIdAuto): self.groupIdAuto = groupIdAuto
    def get_sudo(self): return self.sudo
    def set_sudo(self, sudo): self.sudo = sudo
    def get_systemGroup(self): return self.systemGroup
    def set_systemGroup(self, systemGroup): self.systemGroup = systemGroup
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def hasContent_(self):
        if (
            self.groupId is not None or
            self.groupIdAuto is not None or
            self.sudo is not None or
            self.systemGroup is not None or
            self.uri is not None or
            super(osGroup, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='osGroup', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='osGroup')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='osGroup'):
        super(osGroup, self).exportAttributes(outfile, level, already_processed, namespace_, name_='osGroup')
    def exportChildren(self, outfile, level, namespace_='', name_='osGroup', fromsubclass_=False, pretty_print=True):
        super(osGroup, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.groupId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgroupId>%s</%sgroupId>%s' % (namespace_, self.gds_format_string(quote_xml(self.groupId).encode(ExternalEncoding), input_name='groupId'), namespace_, eol_))
        if self.groupIdAuto is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgroupIdAuto>%s</%sgroupIdAuto>%s' % (namespace_, self.gds_format_boolean(self.groupIdAuto, input_name='groupIdAuto'), namespace_, eol_))
        if self.sudo is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssudo>%s</%ssudo>%s' % (namespace_, self.gds_format_integer(self.sudo, input_name='sudo'), namespace_, eol_))
        if self.systemGroup is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssystemGroup>%s</%ssystemGroup>%s' % (namespace_, self.gds_format_boolean(self.systemGroup, input_name='systemGroup'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='osGroup'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(osGroup, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(osGroup, self).exportLiteralChildren(outfile, level, name_)
        if self.groupId is not None:
            showIndent(outfile, level)
            outfile.write('groupId=%s,\n' % quote_python(self.groupId).encode(ExternalEncoding))
        if self.groupIdAuto is not None:
            showIndent(outfile, level)
            outfile.write('groupIdAuto=%s,\n' % self.groupIdAuto)
        if self.sudo is not None:
            showIndent(outfile, level)
            outfile.write('sudo=%d,\n' % self.sudo)
        if self.systemGroup is not None:
            showIndent(outfile, level)
            outfile.write('systemGroup=%s,\n' % self.systemGroup)
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(osGroup, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'groupId':
            groupId_ = child_.text
            groupId_ = self.gds_validate_string(groupId_, node, 'groupId')
            self.groupId = groupId_
        elif nodeName_ == 'groupIdAuto':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'groupIdAuto')
            self.groupIdAuto = ival_
        elif nodeName_ == 'sudo':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'sudo')
            self.sudo = ival_
        elif nodeName_ == 'systemGroup':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'systemGroup')
            self.systemGroup = ival_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(osGroup, self).buildChildren(child_, node, nodeName_, True)
# end class osGroup


class appliance(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, applianceExports=None, archName=None, baseCloneUri=None, baseImagesStatusUri=None, baseImagesUri=None, baseLogsUri=None, baseMySoftwareUri=None, baseOasPackageUri=None, baseOsProfileUri=None, baseProjectsUri=None, basePublishImagesStatusUri=None, basePublishImagesUri=None, baseTemplatesStatusUri=None, baseTemplatesUri=None, bootScriptUris=None, bootScriptsUri=None, confMgmtPlatformUris=None, confMgmtPlatformsUri=None, description=None, distributionName=None, distributionUri=None, exportsUri=None, imageUris=None, imported=None, installProfileUri=None, installedSize=None, lastLogUri=None, lastModifiedTimestamp=None, lastPkgUpdate=None, logo=None, mySoftwareUris=None, nbSecurityUpdates=None, nbUpdates=None, oasPackageUri=None, orgUri=None, osProfile=None, osProfileUri=None, parentAppliance=None, parentTemplateUri=None, projectUris=None, publishImageUris=None, published=None, revision=None, shared=None, size=None, tag=None, tagUris=None, uri=None, version=None, extensiontype_=None):
        super(appliance, self).__init__(created, dbId, digest, lastModified, name, extensiontype_, )
        if applianceExports is None:
            self.applianceExports = []
        else:
            self.applianceExports = applianceExports
        self.archName = archName
        self.baseCloneUri = baseCloneUri
        self.baseImagesStatusUri = baseImagesStatusUri
        self.baseImagesUri = baseImagesUri
        self.baseLogsUri = baseLogsUri
        self.baseMySoftwareUri = baseMySoftwareUri
        self.baseOasPackageUri = baseOasPackageUri
        self.baseOsProfileUri = baseOsProfileUri
        self.baseProjectsUri = baseProjectsUri
        self.basePublishImagesStatusUri = basePublishImagesStatusUri
        self.basePublishImagesUri = basePublishImagesUri
        self.baseTemplatesStatusUri = baseTemplatesStatusUri
        self.baseTemplatesUri = baseTemplatesUri
        self.bootScriptUris = bootScriptUris
        self.bootScriptsUri = bootScriptsUri
        self.confMgmtPlatformUris = confMgmtPlatformUris
        self.confMgmtPlatformsUri = confMgmtPlatformsUri
        self.description = description
        self.distributionName = distributionName
        self.distributionUri = distributionUri
        self.exportsUri = exportsUri
        self.imageUris = imageUris
        self.imported = imported
        self.installProfileUri = installProfileUri
        self.installedSize = installedSize
        self.lastLogUri = lastLogUri
        self.lastModifiedTimestamp = lastModifiedTimestamp
        if isinstance(lastPkgUpdate, basestring):
            initvalue_ = datetime_.datetime.strptime(lastPkgUpdate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = lastPkgUpdate
        self.lastPkgUpdate = initvalue_
        self.logo = logo
        self.mySoftwareUris = mySoftwareUris
        self.nbSecurityUpdates = nbSecurityUpdates
        self.nbUpdates = nbUpdates
        self.oasPackageUri = oasPackageUri
        self.orgUri = orgUri
        self.osProfile = osProfile
        self.osProfileUri = osProfileUri
        self.parentAppliance = parentAppliance
        self.parentTemplateUri = parentTemplateUri
        self.projectUris = projectUris
        self.publishImageUris = publishImageUris
        self.published = published
        self.revision = revision
        self.shared = shared
        self.size = size
        self.tag = tag
        self.tagUris = tagUris
        self.uri = uri
        self.version = version
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if appliance.subclass:
            return appliance.subclass(*args_, **kwargs_)
        else:
            return appliance(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_applianceExports(self): return self.applianceExports
    def set_applianceExports(self, applianceExports): self.applianceExports = applianceExports
    def add_applianceExports(self, value): self.applianceExports.append(value)
    def insert_applianceExports(self, index, value): self.applianceExports[index] = value
    def get_archName(self): return self.archName
    def set_archName(self, archName): self.archName = archName
    def get_baseCloneUri(self): return self.baseCloneUri
    def set_baseCloneUri(self, baseCloneUri): self.baseCloneUri = baseCloneUri
    def get_baseImagesStatusUri(self): return self.baseImagesStatusUri
    def set_baseImagesStatusUri(self, baseImagesStatusUri): self.baseImagesStatusUri = baseImagesStatusUri
    def get_baseImagesUri(self): return self.baseImagesUri
    def set_baseImagesUri(self, baseImagesUri): self.baseImagesUri = baseImagesUri
    def get_baseLogsUri(self): return self.baseLogsUri
    def set_baseLogsUri(self, baseLogsUri): self.baseLogsUri = baseLogsUri
    def get_baseMySoftwareUri(self): return self.baseMySoftwareUri
    def set_baseMySoftwareUri(self, baseMySoftwareUri): self.baseMySoftwareUri = baseMySoftwareUri
    def get_baseOasPackageUri(self): return self.baseOasPackageUri
    def set_baseOasPackageUri(self, baseOasPackageUri): self.baseOasPackageUri = baseOasPackageUri
    def get_baseOsProfileUri(self): return self.baseOsProfileUri
    def set_baseOsProfileUri(self, baseOsProfileUri): self.baseOsProfileUri = baseOsProfileUri
    def get_baseProjectsUri(self): return self.baseProjectsUri
    def set_baseProjectsUri(self, baseProjectsUri): self.baseProjectsUri = baseProjectsUri
    def get_basePublishImagesStatusUri(self): return self.basePublishImagesStatusUri
    def set_basePublishImagesStatusUri(self, basePublishImagesStatusUri): self.basePublishImagesStatusUri = basePublishImagesStatusUri
    def get_basePublishImagesUri(self): return self.basePublishImagesUri
    def set_basePublishImagesUri(self, basePublishImagesUri): self.basePublishImagesUri = basePublishImagesUri
    def get_baseTemplatesStatusUri(self): return self.baseTemplatesStatusUri
    def set_baseTemplatesStatusUri(self, baseTemplatesStatusUri): self.baseTemplatesStatusUri = baseTemplatesStatusUri
    def get_baseTemplatesUri(self): return self.baseTemplatesUri
    def set_baseTemplatesUri(self, baseTemplatesUri): self.baseTemplatesUri = baseTemplatesUri
    def get_bootScriptUris(self): return self.bootScriptUris
    def set_bootScriptUris(self, bootScriptUris): self.bootScriptUris = bootScriptUris
    def get_bootScriptsUri(self): return self.bootScriptsUri
    def set_bootScriptsUri(self, bootScriptsUri): self.bootScriptsUri = bootScriptsUri
    def get_confMgmtPlatformUris(self): return self.confMgmtPlatformUris
    def set_confMgmtPlatformUris(self, confMgmtPlatformUris): self.confMgmtPlatformUris = confMgmtPlatformUris
    def get_confMgmtPlatformsUri(self): return self.confMgmtPlatformsUri
    def set_confMgmtPlatformsUri(self, confMgmtPlatformsUri): self.confMgmtPlatformsUri = confMgmtPlatformsUri
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_distributionName(self): return self.distributionName
    def set_distributionName(self, distributionName): self.distributionName = distributionName
    def get_distributionUri(self): return self.distributionUri
    def set_distributionUri(self, distributionUri): self.distributionUri = distributionUri
    def get_exportsUri(self): return self.exportsUri
    def set_exportsUri(self, exportsUri): self.exportsUri = exportsUri
    def get_imageUris(self): return self.imageUris
    def set_imageUris(self, imageUris): self.imageUris = imageUris
    def get_imported(self): return self.imported
    def set_imported(self, imported): self.imported = imported
    def get_installProfileUri(self): return self.installProfileUri
    def set_installProfileUri(self, installProfileUri): self.installProfileUri = installProfileUri
    def get_installedSize(self): return self.installedSize
    def set_installedSize(self, installedSize): self.installedSize = installedSize
    def get_lastLogUri(self): return self.lastLogUri
    def set_lastLogUri(self, lastLogUri): self.lastLogUri = lastLogUri
    def get_lastModifiedTimestamp(self): return self.lastModifiedTimestamp
    def set_lastModifiedTimestamp(self, lastModifiedTimestamp): self.lastModifiedTimestamp = lastModifiedTimestamp
    def get_lastPkgUpdate(self): return self.lastPkgUpdate
    def set_lastPkgUpdate(self, lastPkgUpdate): self.lastPkgUpdate = lastPkgUpdate
    def get_logo(self): return self.logo
    def set_logo(self, logo): self.logo = logo
    def get_mySoftwareUris(self): return self.mySoftwareUris
    def set_mySoftwareUris(self, mySoftwareUris): self.mySoftwareUris = mySoftwareUris
    def get_nbSecurityUpdates(self): return self.nbSecurityUpdates
    def set_nbSecurityUpdates(self, nbSecurityUpdates): self.nbSecurityUpdates = nbSecurityUpdates
    def get_nbUpdates(self): return self.nbUpdates
    def set_nbUpdates(self, nbUpdates): self.nbUpdates = nbUpdates
    def get_oasPackageUri(self): return self.oasPackageUri
    def set_oasPackageUri(self, oasPackageUri): self.oasPackageUri = oasPackageUri
    def get_orgUri(self): return self.orgUri
    def set_orgUri(self, orgUri): self.orgUri = orgUri
    def get_osProfile(self): return self.osProfile
    def set_osProfile(self, osProfile): self.osProfile = osProfile
    def get_osProfileUri(self): return self.osProfileUri
    def set_osProfileUri(self, osProfileUri): self.osProfileUri = osProfileUri
    def get_parentAppliance(self): return self.parentAppliance
    def set_parentAppliance(self, parentAppliance): self.parentAppliance = parentAppliance
    def get_parentTemplateUri(self): return self.parentTemplateUri
    def set_parentTemplateUri(self, parentTemplateUri): self.parentTemplateUri = parentTemplateUri
    def get_projectUris(self): return self.projectUris
    def set_projectUris(self, projectUris): self.projectUris = projectUris
    def get_publishImageUris(self): return self.publishImageUris
    def set_publishImageUris(self, publishImageUris): self.publishImageUris = publishImageUris
    def get_published(self): return self.published
    def set_published(self, published): self.published = published
    def get_revision(self): return self.revision
    def set_revision(self, revision): self.revision = revision
    def get_shared(self): return self.shared
    def set_shared(self, shared): self.shared = shared
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    def get_tag(self): return self.tag
    def set_tag(self, tag): self.tag = tag
    def get_tagUris(self): return self.tagUris
    def set_tagUris(self, tagUris): self.tagUris = tagUris
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.applianceExports or
            self.archName is not None or
            self.baseCloneUri is not None or
            self.baseImagesStatusUri is not None or
            self.baseImagesUri is not None or
            self.baseLogsUri is not None or
            self.baseMySoftwareUri is not None or
            self.baseOasPackageUri is not None or
            self.baseOsProfileUri is not None or
            self.baseProjectsUri is not None or
            self.basePublishImagesStatusUri is not None or
            self.basePublishImagesUri is not None or
            self.baseTemplatesStatusUri is not None or
            self.baseTemplatesUri is not None or
            self.bootScriptUris is not None or
            self.bootScriptsUri is not None or
            self.confMgmtPlatformUris is not None or
            self.confMgmtPlatformsUri is not None or
            self.description is not None or
            self.distributionName is not None or
            self.distributionUri is not None or
            self.exportsUri is not None or
            self.imageUris is not None or
            self.imported is not None or
            self.installProfileUri is not None or
            self.installedSize is not None or
            self.lastLogUri is not None or
            self.lastModifiedTimestamp is not None or
            self.lastPkgUpdate is not None or
            self.logo is not None or
            self.mySoftwareUris is not None or
            self.nbSecurityUpdates is not None or
            self.nbUpdates is not None or
            self.oasPackageUri is not None or
            self.orgUri is not None or
            self.osProfile is not None or
            self.osProfileUri is not None or
            self.parentAppliance is not None or
            self.parentTemplateUri is not None or
            self.projectUris is not None or
            self.publishImageUris is not None or
            self.published is not None or
            self.revision is not None or
            self.shared is not None or
            self.size is not None or
            self.tag is not None or
            self.tagUris is not None or
            self.uri is not None or
            self.version is not None or
            super(appliance, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='appliance', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='appliance')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='appliance'):
        super(appliance, self).exportAttributes(outfile, level, already_processed, namespace_, name_='appliance')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='appliance', fromsubclass_=False, pretty_print=True):
        super(appliance, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for applianceExports_ in self.applianceExports:
            applianceExports_.export(outfile, level, namespace_, name_='applianceExports', pretty_print=pretty_print)
        if self.archName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sarchName>%s</%sarchName>%s' % (namespace_, self.gds_format_string(quote_xml(self.archName).encode(ExternalEncoding), input_name='archName'), namespace_, eol_))
        if self.baseCloneUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseCloneUri>%s</%sbaseCloneUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseCloneUri).encode(ExternalEncoding), input_name='baseCloneUri'), namespace_, eol_))
        if self.baseImagesStatusUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseImagesStatusUri>%s</%sbaseImagesStatusUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseImagesStatusUri).encode(ExternalEncoding), input_name='baseImagesStatusUri'), namespace_, eol_))
        if self.baseImagesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseImagesUri>%s</%sbaseImagesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseImagesUri).encode(ExternalEncoding), input_name='baseImagesUri'), namespace_, eol_))
        if self.baseLogsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseLogsUri>%s</%sbaseLogsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseLogsUri).encode(ExternalEncoding), input_name='baseLogsUri'), namespace_, eol_))
        if self.baseMySoftwareUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseMySoftwareUri>%s</%sbaseMySoftwareUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseMySoftwareUri).encode(ExternalEncoding), input_name='baseMySoftwareUri'), namespace_, eol_))
        if self.baseOasPackageUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseOasPackageUri>%s</%sbaseOasPackageUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseOasPackageUri).encode(ExternalEncoding), input_name='baseOasPackageUri'), namespace_, eol_))
        if self.baseOsProfileUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseOsProfileUri>%s</%sbaseOsProfileUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseOsProfileUri).encode(ExternalEncoding), input_name='baseOsProfileUri'), namespace_, eol_))
        if self.baseProjectsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseProjectsUri>%s</%sbaseProjectsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseProjectsUri).encode(ExternalEncoding), input_name='baseProjectsUri'), namespace_, eol_))
        if self.basePublishImagesStatusUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbasePublishImagesStatusUri>%s</%sbasePublishImagesStatusUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.basePublishImagesStatusUri).encode(ExternalEncoding), input_name='basePublishImagesStatusUri'), namespace_, eol_))
        if self.basePublishImagesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbasePublishImagesUri>%s</%sbasePublishImagesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.basePublishImagesUri).encode(ExternalEncoding), input_name='basePublishImagesUri'), namespace_, eol_))
        if self.baseTemplatesStatusUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseTemplatesStatusUri>%s</%sbaseTemplatesStatusUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseTemplatesStatusUri).encode(ExternalEncoding), input_name='baseTemplatesStatusUri'), namespace_, eol_))
        if self.baseTemplatesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseTemplatesUri>%s</%sbaseTemplatesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseTemplatesUri).encode(ExternalEncoding), input_name='baseTemplatesUri'), namespace_, eol_))
        if self.bootScriptUris is not None:
            self.bootScriptUris.export(outfile, level, namespace_, name_='bootScriptUris', pretty_print=pretty_print)
        if self.bootScriptsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbootScriptsUri>%s</%sbootScriptsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.bootScriptsUri).encode(ExternalEncoding), input_name='bootScriptsUri'), namespace_, eol_))
        if self.confMgmtPlatformUris is not None:
            self.confMgmtPlatformUris.export(outfile, level, namespace_, name_='confMgmtPlatformUris', pretty_print=pretty_print)
        if self.confMgmtPlatformsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sconfMgmtPlatformsUri>%s</%sconfMgmtPlatformsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.confMgmtPlatformsUri).encode(ExternalEncoding), input_name='confMgmtPlatformsUri'), namespace_, eol_))
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_, eol_))
        if self.distributionName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdistributionName>%s</%sdistributionName>%s' % (namespace_, self.gds_format_string(quote_xml(self.distributionName).encode(ExternalEncoding), input_name='distributionName'), namespace_, eol_))
        if self.distributionUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdistributionUri>%s</%sdistributionUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.distributionUri).encode(ExternalEncoding), input_name='distributionUri'), namespace_, eol_))
        if self.exportsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sexportsUri>%s</%sexportsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.exportsUri).encode(ExternalEncoding), input_name='exportsUri'), namespace_, eol_))
        if self.imageUris is not None:
            self.imageUris.export(outfile, level, namespace_, name_='imageUris', pretty_print=pretty_print)
        if self.imported is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%simported>%s</%simported>%s' % (namespace_, self.gds_format_boolean(self.imported, input_name='imported'), namespace_, eol_))
        if self.installProfileUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinstallProfileUri>%s</%sinstallProfileUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.installProfileUri).encode(ExternalEncoding), input_name='installProfileUri'), namespace_, eol_))
        if self.installedSize is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinstalledSize>%s</%sinstalledSize>%s' % (namespace_, self.gds_format_integer(self.installedSize, input_name='installedSize'), namespace_, eol_))
        if self.lastLogUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slastLogUri>%s</%slastLogUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.lastLogUri).encode(ExternalEncoding), input_name='lastLogUri'), namespace_, eol_))
        if self.lastModifiedTimestamp is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slastModifiedTimestamp>%s</%slastModifiedTimestamp>%s' % (namespace_, self.gds_format_string(quote_xml(self.lastModifiedTimestamp).encode(ExternalEncoding), input_name='lastModifiedTimestamp'), namespace_, eol_))
        if self.lastPkgUpdate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slastPkgUpdate>%s</%slastPkgUpdate>%s' % (namespace_, self.gds_format_datetime(self.lastPkgUpdate, input_name='lastPkgUpdate'), namespace_, eol_))
        if self.logo is not None:
            self.logo.export(outfile, level, namespace_, name_='logo', pretty_print=pretty_print)
        if self.mySoftwareUris is not None:
            self.mySoftwareUris.export(outfile, level, namespace_, name_='mySoftwareUris', pretty_print=pretty_print)
        if self.nbSecurityUpdates is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snbSecurityUpdates>%s</%snbSecurityUpdates>%s' % (namespace_, self.gds_format_integer(self.nbSecurityUpdates, input_name='nbSecurityUpdates'), namespace_, eol_))
        if self.nbUpdates is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snbUpdates>%s</%snbUpdates>%s' % (namespace_, self.gds_format_integer(self.nbUpdates, input_name='nbUpdates'), namespace_, eol_))
        if self.oasPackageUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soasPackageUri>%s</%soasPackageUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.oasPackageUri).encode(ExternalEncoding), input_name='oasPackageUri'), namespace_, eol_))
        if self.orgUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorgUri>%s</%sorgUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.orgUri).encode(ExternalEncoding), input_name='orgUri'), namespace_, eol_))
        if self.osProfile is not None:
            self.osProfile.export(outfile, level, namespace_, name_='osProfile', pretty_print=pretty_print)
        if self.osProfileUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sosProfileUri>%s</%sosProfileUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.osProfileUri).encode(ExternalEncoding), input_name='osProfileUri'), namespace_, eol_))
        if self.parentAppliance is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparentAppliance>%s</%sparentAppliance>%s' % (namespace_, self.gds_format_string(quote_xml(self.parentAppliance).encode(ExternalEncoding), input_name='parentAppliance'), namespace_, eol_))
        if self.parentTemplateUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparentTemplateUri>%s</%sparentTemplateUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.parentTemplateUri).encode(ExternalEncoding), input_name='parentTemplateUri'), namespace_, eol_))
        if self.projectUris is not None:
            self.projectUris.export(outfile, level, namespace_, name_='projectUris', pretty_print=pretty_print)
        if self.publishImageUris is not None:
            self.publishImageUris.export(outfile, level, namespace_, name_='publishImageUris', pretty_print=pretty_print)
        if self.published is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spublished>%s</%spublished>%s' % (namespace_, self.gds_format_boolean(self.published, input_name='published'), namespace_, eol_))
        if self.revision is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srevision>%s</%srevision>%s' % (namespace_, self.gds_format_integer(self.revision, input_name='revision'), namespace_, eol_))
        if self.shared is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshared>%s</%sshared>%s' % (namespace_, self.gds_format_boolean(self.shared, input_name='shared'), namespace_, eol_))
        if self.size is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssize>%s</%ssize>%s' % (namespace_, self.gds_format_integer(self.size, input_name='size'), namespace_, eol_))
        if self.tag is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stag>%s</%stag>%s' % (namespace_, self.gds_format_string(quote_xml(self.tag).encode(ExternalEncoding), input_name='tag'), namespace_, eol_))
        if self.tagUris is not None:
            self.tagUris.export(outfile, level, namespace_, name_='tagUris', pretty_print=pretty_print)
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
        if self.version is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sversion>%s</%sversion>%s' % (namespace_, self.gds_format_string(quote_xml(self.version).encode(ExternalEncoding), input_name='version'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='appliance'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(appliance, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(appliance, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('applianceExports=[\n')
        level += 1
        for applianceExports_ in self.applianceExports:
            showIndent(outfile, level)
            outfile.write('model_.applianceExport(\n')
            applianceExports_.exportLiteral(outfile, level, name_='applianceExport')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.archName is not None:
            showIndent(outfile, level)
            outfile.write('archName=%s,\n' % quote_python(self.archName).encode(ExternalEncoding))
        if self.baseCloneUri is not None:
            showIndent(outfile, level)
            outfile.write('baseCloneUri=%s,\n' % quote_python(self.baseCloneUri).encode(ExternalEncoding))
        if self.baseImagesStatusUri is not None:
            showIndent(outfile, level)
            outfile.write('baseImagesStatusUri=%s,\n' % quote_python(self.baseImagesStatusUri).encode(ExternalEncoding))
        if self.baseImagesUri is not None:
            showIndent(outfile, level)
            outfile.write('baseImagesUri=%s,\n' % quote_python(self.baseImagesUri).encode(ExternalEncoding))
        if self.baseLogsUri is not None:
            showIndent(outfile, level)
            outfile.write('baseLogsUri=%s,\n' % quote_python(self.baseLogsUri).encode(ExternalEncoding))
        if self.baseMySoftwareUri is not None:
            showIndent(outfile, level)
            outfile.write('baseMySoftwareUri=%s,\n' % quote_python(self.baseMySoftwareUri).encode(ExternalEncoding))
        if self.baseOasPackageUri is not None:
            showIndent(outfile, level)
            outfile.write('baseOasPackageUri=%s,\n' % quote_python(self.baseOasPackageUri).encode(ExternalEncoding))
        if self.baseOsProfileUri is not None:
            showIndent(outfile, level)
            outfile.write('baseOsProfileUri=%s,\n' % quote_python(self.baseOsProfileUri).encode(ExternalEncoding))
        if self.baseProjectsUri is not None:
            showIndent(outfile, level)
            outfile.write('baseProjectsUri=%s,\n' % quote_python(self.baseProjectsUri).encode(ExternalEncoding))
        if self.basePublishImagesStatusUri is not None:
            showIndent(outfile, level)
            outfile.write('basePublishImagesStatusUri=%s,\n' % quote_python(self.basePublishImagesStatusUri).encode(ExternalEncoding))
        if self.basePublishImagesUri is not None:
            showIndent(outfile, level)
            outfile.write('basePublishImagesUri=%s,\n' % quote_python(self.basePublishImagesUri).encode(ExternalEncoding))
        if self.baseTemplatesStatusUri is not None:
            showIndent(outfile, level)
            outfile.write('baseTemplatesStatusUri=%s,\n' % quote_python(self.baseTemplatesStatusUri).encode(ExternalEncoding))
        if self.baseTemplatesUri is not None:
            showIndent(outfile, level)
            outfile.write('baseTemplatesUri=%s,\n' % quote_python(self.baseTemplatesUri).encode(ExternalEncoding))
        if self.bootScriptUris is not None:
            showIndent(outfile, level)
            outfile.write('bootScriptUris=model_.uriList(\n')
            self.bootScriptUris.exportLiteral(outfile, level, name_='bootScriptUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.bootScriptsUri is not None:
            showIndent(outfile, level)
            outfile.write('bootScriptsUri=%s,\n' % quote_python(self.bootScriptsUri).encode(ExternalEncoding))
        if self.confMgmtPlatformUris is not None:
            showIndent(outfile, level)
            outfile.write('confMgmtPlatformUris=model_.uriList(\n')
            self.confMgmtPlatformUris.exportLiteral(outfile, level, name_='confMgmtPlatformUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.confMgmtPlatformsUri is not None:
            showIndent(outfile, level)
            outfile.write('confMgmtPlatformsUri=%s,\n' % quote_python(self.confMgmtPlatformsUri).encode(ExternalEncoding))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        if self.distributionName is not None:
            showIndent(outfile, level)
            outfile.write('distributionName=%s,\n' % quote_python(self.distributionName).encode(ExternalEncoding))
        if self.distributionUri is not None:
            showIndent(outfile, level)
            outfile.write('distributionUri=%s,\n' % quote_python(self.distributionUri).encode(ExternalEncoding))
        if self.exportsUri is not None:
            showIndent(outfile, level)
            outfile.write('exportsUri=%s,\n' % quote_python(self.exportsUri).encode(ExternalEncoding))
        if self.imageUris is not None:
            showIndent(outfile, level)
            outfile.write('imageUris=model_.uriList(\n')
            self.imageUris.exportLiteral(outfile, level, name_='imageUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.imported is not None:
            showIndent(outfile, level)
            outfile.write('imported=%s,\n' % self.imported)
        if self.installProfileUri is not None:
            showIndent(outfile, level)
            outfile.write('installProfileUri=%s,\n' % quote_python(self.installProfileUri).encode(ExternalEncoding))
        if self.installedSize is not None:
            showIndent(outfile, level)
            outfile.write('installedSize=%d,\n' % self.installedSize)
        if self.lastLogUri is not None:
            showIndent(outfile, level)
            outfile.write('lastLogUri=%s,\n' % quote_python(self.lastLogUri).encode(ExternalEncoding))
        if self.lastModifiedTimestamp is not None:
            showIndent(outfile, level)
            outfile.write('lastModifiedTimestamp=%s,\n' % quote_python(self.lastModifiedTimestamp).encode(ExternalEncoding))
        if self.lastPkgUpdate is not None:
            showIndent(outfile, level)
            outfile.write('lastPkgUpdate=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.lastPkgUpdate, input_name='lastPkgUpdate'))
        if self.logo is not None:
            showIndent(outfile, level)
            outfile.write('logo=model_.logo(\n')
            self.logo.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.mySoftwareUris is not None:
            showIndent(outfile, level)
            outfile.write('mySoftwareUris=model_.uriList(\n')
            self.mySoftwareUris.exportLiteral(outfile, level, name_='mySoftwareUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.nbSecurityUpdates is not None:
            showIndent(outfile, level)
            outfile.write('nbSecurityUpdates=%d,\n' % self.nbSecurityUpdates)
        if self.nbUpdates is not None:
            showIndent(outfile, level)
            outfile.write('nbUpdates=%d,\n' % self.nbUpdates)
        if self.oasPackageUri is not None:
            showIndent(outfile, level)
            outfile.write('oasPackageUri=%s,\n' % quote_python(self.oasPackageUri).encode(ExternalEncoding))
        if self.orgUri is not None:
            showIndent(outfile, level)
            outfile.write('orgUri=%s,\n' % quote_python(self.orgUri).encode(ExternalEncoding))
        if self.osProfile is not None:
            showIndent(outfile, level)
            outfile.write('osProfile=model_.distribProfile(\n')
            self.osProfile.exportLiteral(outfile, level, name_='osProfile')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.osProfileUri is not None:
            showIndent(outfile, level)
            outfile.write('osProfileUri=%s,\n' % quote_python(self.osProfileUri).encode(ExternalEncoding))
        if self.parentAppliance is not None:
            showIndent(outfile, level)
            outfile.write('parentAppliance=%s,\n' % quote_python(self.parentAppliance).encode(ExternalEncoding))
        if self.parentTemplateUri is not None:
            showIndent(outfile, level)
            outfile.write('parentTemplateUri=%s,\n' % quote_python(self.parentTemplateUri).encode(ExternalEncoding))
        if self.projectUris is not None:
            showIndent(outfile, level)
            outfile.write('projectUris=model_.uriList(\n')
            self.projectUris.exportLiteral(outfile, level, name_='projectUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.publishImageUris is not None:
            showIndent(outfile, level)
            outfile.write('publishImageUris=model_.uriList(\n')
            self.publishImageUris.exportLiteral(outfile, level, name_='publishImageUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.published is not None:
            showIndent(outfile, level)
            outfile.write('published=%s,\n' % self.published)
        if self.revision is not None:
            showIndent(outfile, level)
            outfile.write('revision=%d,\n' % self.revision)
        if self.shared is not None:
            showIndent(outfile, level)
            outfile.write('shared=%s,\n' % self.shared)
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('size=%d,\n' % self.size)
        if self.tag is not None:
            showIndent(outfile, level)
            outfile.write('tag=%s,\n' % quote_python(self.tag).encode(ExternalEncoding))
        if self.tagUris is not None:
            showIndent(outfile, level)
            outfile.write('tagUris=model_.uriList(\n')
            self.tagUris.exportLiteral(outfile, level, name_='tagUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version=%s,\n' % quote_python(self.version).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(appliance, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'applianceExports':
            obj_ = applianceExport.factory()
            obj_.build(child_)
            self.applianceExports.append(obj_)
        elif nodeName_ == 'archName':
            archName_ = child_.text
            archName_ = self.gds_validate_string(archName_, node, 'archName')
            self.archName = archName_
        elif nodeName_ == 'baseCloneUri':
            baseCloneUri_ = child_.text
            baseCloneUri_ = self.gds_validate_string(baseCloneUri_, node, 'baseCloneUri')
            self.baseCloneUri = baseCloneUri_
        elif nodeName_ == 'baseImagesStatusUri':
            baseImagesStatusUri_ = child_.text
            baseImagesStatusUri_ = self.gds_validate_string(baseImagesStatusUri_, node, 'baseImagesStatusUri')
            self.baseImagesStatusUri = baseImagesStatusUri_
        elif nodeName_ == 'baseImagesUri':
            baseImagesUri_ = child_.text
            baseImagesUri_ = self.gds_validate_string(baseImagesUri_, node, 'baseImagesUri')
            self.baseImagesUri = baseImagesUri_
        elif nodeName_ == 'baseLogsUri':
            baseLogsUri_ = child_.text
            baseLogsUri_ = self.gds_validate_string(baseLogsUri_, node, 'baseLogsUri')
            self.baseLogsUri = baseLogsUri_
        elif nodeName_ == 'baseMySoftwareUri':
            baseMySoftwareUri_ = child_.text
            baseMySoftwareUri_ = self.gds_validate_string(baseMySoftwareUri_, node, 'baseMySoftwareUri')
            self.baseMySoftwareUri = baseMySoftwareUri_
        elif nodeName_ == 'baseOasPackageUri':
            baseOasPackageUri_ = child_.text
            baseOasPackageUri_ = self.gds_validate_string(baseOasPackageUri_, node, 'baseOasPackageUri')
            self.baseOasPackageUri = baseOasPackageUri_
        elif nodeName_ == 'baseOsProfileUri':
            baseOsProfileUri_ = child_.text
            baseOsProfileUri_ = self.gds_validate_string(baseOsProfileUri_, node, 'baseOsProfileUri')
            self.baseOsProfileUri = baseOsProfileUri_
        elif nodeName_ == 'baseProjectsUri':
            baseProjectsUri_ = child_.text
            baseProjectsUri_ = self.gds_validate_string(baseProjectsUri_, node, 'baseProjectsUri')
            self.baseProjectsUri = baseProjectsUri_
        elif nodeName_ == 'basePublishImagesStatusUri':
            basePublishImagesStatusUri_ = child_.text
            basePublishImagesStatusUri_ = self.gds_validate_string(basePublishImagesStatusUri_, node, 'basePublishImagesStatusUri')
            self.basePublishImagesStatusUri = basePublishImagesStatusUri_
        elif nodeName_ == 'basePublishImagesUri':
            basePublishImagesUri_ = child_.text
            basePublishImagesUri_ = self.gds_validate_string(basePublishImagesUri_, node, 'basePublishImagesUri')
            self.basePublishImagesUri = basePublishImagesUri_
        elif nodeName_ == 'baseTemplatesStatusUri':
            baseTemplatesStatusUri_ = child_.text
            baseTemplatesStatusUri_ = self.gds_validate_string(baseTemplatesStatusUri_, node, 'baseTemplatesStatusUri')
            self.baseTemplatesStatusUri = baseTemplatesStatusUri_
        elif nodeName_ == 'baseTemplatesUri':
            baseTemplatesUri_ = child_.text
            baseTemplatesUri_ = self.gds_validate_string(baseTemplatesUri_, node, 'baseTemplatesUri')
            self.baseTemplatesUri = baseTemplatesUri_
        elif nodeName_ == 'bootScriptUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.bootScriptUris = obj_
        elif nodeName_ == 'bootScriptsUri':
            bootScriptsUri_ = child_.text
            bootScriptsUri_ = self.gds_validate_string(bootScriptsUri_, node, 'bootScriptsUri')
            self.bootScriptsUri = bootScriptsUri_
        elif nodeName_ == 'confMgmtPlatformUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.confMgmtPlatformUris = obj_
        elif nodeName_ == 'confMgmtPlatformsUri':
            confMgmtPlatformsUri_ = child_.text
            confMgmtPlatformsUri_ = self.gds_validate_string(confMgmtPlatformsUri_, node, 'confMgmtPlatformsUri')
            self.confMgmtPlatformsUri = confMgmtPlatformsUri_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'distributionName':
            distributionName_ = child_.text
            distributionName_ = self.gds_validate_string(distributionName_, node, 'distributionName')
            self.distributionName = distributionName_
        elif nodeName_ == 'distributionUri':
            distributionUri_ = child_.text
            distributionUri_ = self.gds_validate_string(distributionUri_, node, 'distributionUri')
            self.distributionUri = distributionUri_
        elif nodeName_ == 'exportsUri':
            exportsUri_ = child_.text
            exportsUri_ = self.gds_validate_string(exportsUri_, node, 'exportsUri')
            self.exportsUri = exportsUri_
        elif nodeName_ == 'imageUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.imageUris = obj_
        elif nodeName_ == 'imported':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'imported')
            self.imported = ival_
        elif nodeName_ == 'installProfileUri':
            installProfileUri_ = child_.text
            installProfileUri_ = self.gds_validate_string(installProfileUri_, node, 'installProfileUri')
            self.installProfileUri = installProfileUri_
        elif nodeName_ == 'installedSize':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'installedSize')
            self.installedSize = ival_
        elif nodeName_ == 'lastLogUri':
            lastLogUri_ = child_.text
            lastLogUri_ = self.gds_validate_string(lastLogUri_, node, 'lastLogUri')
            self.lastLogUri = lastLogUri_
        elif nodeName_ == 'lastModifiedTimestamp':
            lastModifiedTimestamp_ = child_.text
            lastModifiedTimestamp_ = self.gds_validate_string(lastModifiedTimestamp_, node, 'lastModifiedTimestamp')
            self.lastModifiedTimestamp = lastModifiedTimestamp_
        elif nodeName_ == 'lastPkgUpdate':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.lastPkgUpdate = dval_
        elif nodeName_ == 'logo':
            obj_ = logo.factory()
            obj_.build(child_)
            self.logo = obj_
        elif nodeName_ == 'mySoftwareUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.mySoftwareUris = obj_
        elif nodeName_ == 'nbSecurityUpdates':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'nbSecurityUpdates')
            self.nbSecurityUpdates = ival_
        elif nodeName_ == 'nbUpdates':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'nbUpdates')
            self.nbUpdates = ival_
        elif nodeName_ == 'oasPackageUri':
            oasPackageUri_ = child_.text
            oasPackageUri_ = self.gds_validate_string(oasPackageUri_, node, 'oasPackageUri')
            self.oasPackageUri = oasPackageUri_
        elif nodeName_ == 'orgUri':
            orgUri_ = child_.text
            orgUri_ = self.gds_validate_string(orgUri_, node, 'orgUri')
            self.orgUri = orgUri_
        elif nodeName_ == 'osProfile':
            obj_ = distribProfile.factory()
            obj_.build(child_)
            self.osProfile = obj_
        elif nodeName_ == 'osProfileUri':
            osProfileUri_ = child_.text
            osProfileUri_ = self.gds_validate_string(osProfileUri_, node, 'osProfileUri')
            self.osProfileUri = osProfileUri_
        elif nodeName_ == 'parentAppliance':
            parentAppliance_ = child_.text
            parentAppliance_ = self.gds_validate_string(parentAppliance_, node, 'parentAppliance')
            self.parentAppliance = parentAppliance_
        elif nodeName_ == 'parentTemplateUri':
            parentTemplateUri_ = child_.text
            parentTemplateUri_ = self.gds_validate_string(parentTemplateUri_, node, 'parentTemplateUri')
            self.parentTemplateUri = parentTemplateUri_
        elif nodeName_ == 'projectUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.projectUris = obj_
        elif nodeName_ == 'publishImageUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.publishImageUris = obj_
        elif nodeName_ == 'published':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'published')
            self.published = ival_
        elif nodeName_ == 'revision':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'revision')
            self.revision = ival_
        elif nodeName_ == 'shared':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'shared')
            self.shared = ival_
        elif nodeName_ == 'size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'size')
            self.size = ival_
        elif nodeName_ == 'tag':
            tag_ = child_.text
            tag_ = self.gds_validate_string(tag_, node, 'tag')
            self.tag = tag_
        elif nodeName_ == 'tagUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.tagUris = obj_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'version':
            version_ = child_.text
            version_ = self.gds_validate_string(version_, node, 'version')
            self.version = version_
        super(appliance, self).buildChildren(child_, node, nodeName_, True)
# end class appliance


class applianceExport(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, applianceName=None, applianceVersion=None, downloadUri=None, location=None, parentUri=None, status=None, uri=None):
        super(applianceExport, self).__init__(created, dbId, digest, lastModified, name, )
        self.applianceName = applianceName
        self.applianceVersion = applianceVersion
        self.downloadUri = downloadUri
        self.location = location
        self.parentUri = parentUri
        self.status = status
        self.uri = uri
    def factory(*args_, **kwargs_):
        if applianceExport.subclass:
            return applianceExport.subclass(*args_, **kwargs_)
        else:
            return applianceExport(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_applianceName(self): return self.applianceName
    def set_applianceName(self, applianceName): self.applianceName = applianceName
    def get_applianceVersion(self): return self.applianceVersion
    def set_applianceVersion(self, applianceVersion): self.applianceVersion = applianceVersion
    def get_downloadUri(self): return self.downloadUri
    def set_downloadUri(self, downloadUri): self.downloadUri = downloadUri
    def get_location(self): return self.location
    def set_location(self, location): self.location = location
    def get_parentUri(self): return self.parentUri
    def set_parentUri(self, parentUri): self.parentUri = parentUri
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def hasContent_(self):
        if (
            self.applianceName is not None or
            self.applianceVersion is not None or
            self.downloadUri is not None or
            self.location is not None or
            self.parentUri is not None or
            self.status is not None or
            self.uri is not None or
            super(applianceExport, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='applianceExport', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='applianceExport')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='applianceExport'):
        super(applianceExport, self).exportAttributes(outfile, level, already_processed, namespace_, name_='applianceExport')
    def exportChildren(self, outfile, level, namespace_='', name_='applianceExport', fromsubclass_=False, pretty_print=True):
        super(applianceExport, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.applianceName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sapplianceName>%s</%sapplianceName>%s' % (namespace_, self.gds_format_string(quote_xml(self.applianceName).encode(ExternalEncoding), input_name='applianceName'), namespace_, eol_))
        if self.applianceVersion is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sapplianceVersion>%s</%sapplianceVersion>%s' % (namespace_, self.gds_format_string(quote_xml(self.applianceVersion).encode(ExternalEncoding), input_name='applianceVersion'), namespace_, eol_))
        if self.downloadUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdownloadUri>%s</%sdownloadUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.downloadUri).encode(ExternalEncoding), input_name='downloadUri'), namespace_, eol_))
        if self.location is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slocation>%s</%slocation>%s' % (namespace_, self.gds_format_string(quote_xml(self.location).encode(ExternalEncoding), input_name='location'), namespace_, eol_))
        if self.parentUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparentUri>%s</%sparentUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.parentUri).encode(ExternalEncoding), input_name='parentUri'), namespace_, eol_))
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status', pretty_print=pretty_print)
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='applianceExport'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(applianceExport, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(applianceExport, self).exportLiteralChildren(outfile, level, name_)
        if self.applianceName is not None:
            showIndent(outfile, level)
            outfile.write('applianceName=%s,\n' % quote_python(self.applianceName).encode(ExternalEncoding))
        if self.applianceVersion is not None:
            showIndent(outfile, level)
            outfile.write('applianceVersion=%s,\n' % quote_python(self.applianceVersion).encode(ExternalEncoding))
        if self.downloadUri is not None:
            showIndent(outfile, level)
            outfile.write('downloadUri=%s,\n' % quote_python(self.downloadUri).encode(ExternalEncoding))
        if self.location is not None:
            showIndent(outfile, level)
            outfile.write('location=%s,\n' % quote_python(self.location).encode(ExternalEncoding))
        if self.parentUri is not None:
            showIndent(outfile, level)
            outfile.write('parentUri=%s,\n' % quote_python(self.parentUri).encode(ExternalEncoding))
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(applianceExport, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'applianceName':
            applianceName_ = child_.text
            applianceName_ = self.gds_validate_string(applianceName_, node, 'applianceName')
            self.applianceName = applianceName_
        elif nodeName_ == 'applianceVersion':
            applianceVersion_ = child_.text
            applianceVersion_ = self.gds_validate_string(applianceVersion_, node, 'applianceVersion')
            self.applianceVersion = applianceVersion_
        elif nodeName_ == 'downloadUri':
            downloadUri_ = child_.text
            downloadUri_ = self.gds_validate_string(downloadUri_, node, 'downloadUri')
            self.downloadUri = downloadUri_
        elif nodeName_ == 'location':
            location_ = child_.text
            location_ = self.gds_validate_string(location_, node, 'location')
            self.location = location_
        elif nodeName_ == 'parentUri':
            parentUri_ = child_.text
            parentUri_ = self.gds_validate_string(parentUri_, node, 'parentUri')
            self.parentUri = parentUri_
        elif nodeName_ == 'status':
            obj_ = opStatus.factory()
            obj_.build(child_)
            self.status = obj_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(applianceExport, self).buildChildren(child_, node, nodeName_, True)
# end class applianceExport


class distribProfile(distribProfileTemplate):
    subclass = None
    superclass = distribProfileTemplate
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, abbreviation=None, active=None, arch=None, description=None, distributionPackagesUri=None, distributionServicesUri=None, distributionUri=None, installedSize=None, packageUris=None, packagesUri=None, serviceUris=None, servicesUri=None, size=None, uri=None, version=None, applianceUri=None, excludeDocs=None, standardProfile=None, updatesUri=None):
        super(distribProfile, self).__init__(created, dbId, digest, lastModified, name, abbreviation, active, arch, description, distributionPackagesUri, distributionServicesUri, distributionUri, installedSize, packageUris, packagesUri, serviceUris, servicesUri, size, uri, version, )
        self.applianceUri = applianceUri
        self.excludeDocs = excludeDocs
        self.standardProfile = standardProfile
        self.updatesUri = updatesUri
    def factory(*args_, **kwargs_):
        if distribProfile.subclass:
            return distribProfile.subclass(*args_, **kwargs_)
        else:
            return distribProfile(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_applianceUri(self): return self.applianceUri
    def set_applianceUri(self, applianceUri): self.applianceUri = applianceUri
    def get_excludeDocs(self): return self.excludeDocs
    def set_excludeDocs(self, excludeDocs): self.excludeDocs = excludeDocs
    def get_standardProfile(self): return self.standardProfile
    def set_standardProfile(self, standardProfile): self.standardProfile = standardProfile
    def get_updatesUri(self): return self.updatesUri
    def set_updatesUri(self, updatesUri): self.updatesUri = updatesUri
    def hasContent_(self):
        if (
            self.applianceUri is not None or
            self.excludeDocs is not None or
            self.standardProfile is not None or
            self.updatesUri is not None or
            super(distribProfile, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='distribProfile', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='distribProfile')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='distribProfile'):
        super(distribProfile, self).exportAttributes(outfile, level, already_processed, namespace_, name_='distribProfile')
    def exportChildren(self, outfile, level, namespace_='', name_='distribProfile', fromsubclass_=False, pretty_print=True):
        super(distribProfile, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.applianceUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sapplianceUri>%s</%sapplianceUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.applianceUri).encode(ExternalEncoding), input_name='applianceUri'), namespace_, eol_))
        if self.excludeDocs is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sexcludeDocs>%s</%sexcludeDocs>%s' % (namespace_, self.gds_format_boolean(self.excludeDocs, input_name='excludeDocs'), namespace_, eol_))
        if self.standardProfile is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstandardProfile>%s</%sstandardProfile>%s' % (namespace_, self.gds_format_string(quote_xml(self.standardProfile).encode(ExternalEncoding), input_name='standardProfile'), namespace_, eol_))
        if self.updatesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%supdatesUri>%s</%supdatesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.updatesUri).encode(ExternalEncoding), input_name='updatesUri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='distribProfile'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(distribProfile, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(distribProfile, self).exportLiteralChildren(outfile, level, name_)
        if self.applianceUri is not None:
            showIndent(outfile, level)
            outfile.write('applianceUri=%s,\n' % quote_python(self.applianceUri).encode(ExternalEncoding))
        if self.excludeDocs is not None:
            showIndent(outfile, level)
            outfile.write('excludeDocs=%s,\n' % self.excludeDocs)
        if self.standardProfile is not None:
            showIndent(outfile, level)
            outfile.write('standardProfile=%s,\n' % quote_python(self.standardProfile).encode(ExternalEncoding))
        if self.updatesUri is not None:
            showIndent(outfile, level)
            outfile.write('updatesUri=%s,\n' % quote_python(self.updatesUri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(distribProfile, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'applianceUri':
            applianceUri_ = child_.text
            applianceUri_ = self.gds_validate_string(applianceUri_, node, 'applianceUri')
            self.applianceUri = applianceUri_
        elif nodeName_ == 'excludeDocs':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'excludeDocs')
            self.excludeDocs = ival_
        elif nodeName_ == 'standardProfile':
            standardProfile_ = child_.text
            standardProfile_ = self.gds_validate_string(standardProfile_, node, 'standardProfile')
            self.standardProfile = standardProfile_
        elif nodeName_ == 'updatesUri':
            updatesUri_ = child_.text
            updatesUri_ = self.gds_validate_string(updatesUri_, node, 'updatesUri')
            self.updatesUri = updatesUri_
        super(distribProfile, self).buildChildren(child_, node, nodeName_, True)
# end class distribProfile


class apiKeyPair(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, publicKey=None, secretKey=None, uri=None):
        super(apiKeyPair, self).__init__(created, dbId, digest, lastModified, name, )
        self.publicKey = publicKey
        self.secretKey = secretKey
        self.uri = uri
    def factory(*args_, **kwargs_):
        if apiKeyPair.subclass:
            return apiKeyPair.subclass(*args_, **kwargs_)
        else:
            return apiKeyPair(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_publicKey(self): return self.publicKey
    def set_publicKey(self, publicKey): self.publicKey = publicKey
    def get_secretKey(self): return self.secretKey
    def set_secretKey(self, secretKey): self.secretKey = secretKey
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def hasContent_(self):
        if (
            self.publicKey is not None or
            self.secretKey is not None or
            self.uri is not None or
            super(apiKeyPair, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='apiKeyPair', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='apiKeyPair')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='apiKeyPair'):
        super(apiKeyPair, self).exportAttributes(outfile, level, already_processed, namespace_, name_='apiKeyPair')
    def exportChildren(self, outfile, level, namespace_='', name_='apiKeyPair', fromsubclass_=False, pretty_print=True):
        super(apiKeyPair, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.publicKey is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spublicKey>%s</%spublicKey>%s' % (namespace_, self.gds_format_string(quote_xml(self.publicKey).encode(ExternalEncoding), input_name='publicKey'), namespace_, eol_))
        if self.secretKey is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssecretKey>%s</%ssecretKey>%s' % (namespace_, self.gds_format_string(quote_xml(self.secretKey).encode(ExternalEncoding), input_name='secretKey'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='apiKeyPair'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(apiKeyPair, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(apiKeyPair, self).exportLiteralChildren(outfile, level, name_)
        if self.publicKey is not None:
            showIndent(outfile, level)
            outfile.write('publicKey=%s,\n' % quote_python(self.publicKey).encode(ExternalEncoding))
        if self.secretKey is not None:
            showIndent(outfile, level)
            outfile.write('secretKey=%s,\n' % quote_python(self.secretKey).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(apiKeyPair, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'publicKey':
            publicKey_ = child_.text
            publicKey_ = self.gds_validate_string(publicKey_, node, 'publicKey')
            self.publicKey = publicKey_
        elif nodeName_ == 'secretKey':
            secretKey_ = child_.text
            secretKey_ = self.gds_validate_string(secretKey_, node, 'secretKey')
            self.secretKey = secretKey_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(apiKeyPair, self).buildChildren(child_, node, nodeName_, True)
# end class apiKeyPair


class gallery(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, membersUri=None, nbTemplates=None, notificationsUri=None, orgUri=None, partnersUri=None, publicGallery=None, publishers=None, publishersUri=None, templatesUri=None, uri=None, userGroupsUri=None):
        super(gallery, self).__init__(created, dbId, digest, lastModified, name, )
        self.membersUri = membersUri
        self.nbTemplates = nbTemplates
        self.notificationsUri = notificationsUri
        self.orgUri = orgUri
        self.partnersUri = partnersUri
        self.publicGallery = publicGallery
        if publishers is None:
            self.publishers = []
        else:
            self.publishers = publishers
        self.publishersUri = publishersUri
        self.templatesUri = templatesUri
        self.uri = uri
        self.userGroupsUri = userGroupsUri
    def factory(*args_, **kwargs_):
        if gallery.subclass:
            return gallery.subclass(*args_, **kwargs_)
        else:
            return gallery(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_membersUri(self): return self.membersUri
    def set_membersUri(self, membersUri): self.membersUri = membersUri
    def get_nbTemplates(self): return self.nbTemplates
    def set_nbTemplates(self, nbTemplates): self.nbTemplates = nbTemplates
    def get_notificationsUri(self): return self.notificationsUri
    def set_notificationsUri(self, notificationsUri): self.notificationsUri = notificationsUri
    def get_orgUri(self): return self.orgUri
    def set_orgUri(self, orgUri): self.orgUri = orgUri
    def get_partnersUri(self): return self.partnersUri
    def set_partnersUri(self, partnersUri): self.partnersUri = partnersUri
    def get_publicGallery(self): return self.publicGallery
    def set_publicGallery(self, publicGallery): self.publicGallery = publicGallery
    def get_publishers(self): return self.publishers
    def set_publishers(self, publishers): self.publishers = publishers
    def add_publishers(self, value): self.publishers.append(value)
    def insert_publishers(self, index, value): self.publishers[index] = value
    def get_publishersUri(self): return self.publishersUri
    def set_publishersUri(self, publishersUri): self.publishersUri = publishersUri
    def get_templatesUri(self): return self.templatesUri
    def set_templatesUri(self, templatesUri): self.templatesUri = templatesUri
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_userGroupsUri(self): return self.userGroupsUri
    def set_userGroupsUri(self, userGroupsUri): self.userGroupsUri = userGroupsUri
    def hasContent_(self):
        if (
            self.membersUri is not None or
            self.nbTemplates is not None or
            self.notificationsUri is not None or
            self.orgUri is not None or
            self.partnersUri is not None or
            self.publicGallery is not None or
            self.publishers or
            self.publishersUri is not None or
            self.templatesUri is not None or
            self.uri is not None or
            self.userGroupsUri is not None or
            super(gallery, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='gallery', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='gallery')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='gallery'):
        super(gallery, self).exportAttributes(outfile, level, already_processed, namespace_, name_='gallery')
    def exportChildren(self, outfile, level, namespace_='', name_='gallery', fromsubclass_=False, pretty_print=True):
        super(gallery, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.membersUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smembersUri>%s</%smembersUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.membersUri).encode(ExternalEncoding), input_name='membersUri'), namespace_, eol_))
        if self.nbTemplates is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snbTemplates>%s</%snbTemplates>%s' % (namespace_, self.gds_format_integer(self.nbTemplates, input_name='nbTemplates'), namespace_, eol_))
        if self.notificationsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snotificationsUri>%s</%snotificationsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.notificationsUri).encode(ExternalEncoding), input_name='notificationsUri'), namespace_, eol_))
        if self.orgUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorgUri>%s</%sorgUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.orgUri).encode(ExternalEncoding), input_name='orgUri'), namespace_, eol_))
        if self.partnersUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spartnersUri>%s</%spartnersUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.partnersUri).encode(ExternalEncoding), input_name='partnersUri'), namespace_, eol_))
        if self.publicGallery is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spublicGallery>%s</%spublicGallery>%s' % (namespace_, self.gds_format_boolean(self.publicGallery, input_name='publicGallery'), namespace_, eol_))
        for publishers_ in self.publishers:
            publishers_.export(outfile, level, namespace_, name_='publishers', pretty_print=pretty_print)
        if self.publishersUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spublishersUri>%s</%spublishersUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.publishersUri).encode(ExternalEncoding), input_name='publishersUri'), namespace_, eol_))
        if self.templatesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stemplatesUri>%s</%stemplatesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.templatesUri).encode(ExternalEncoding), input_name='templatesUri'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
        if self.userGroupsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suserGroupsUri>%s</%suserGroupsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.userGroupsUri).encode(ExternalEncoding), input_name='userGroupsUri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='gallery'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(gallery, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(gallery, self).exportLiteralChildren(outfile, level, name_)
        if self.membersUri is not None:
            showIndent(outfile, level)
            outfile.write('membersUri=%s,\n' % quote_python(self.membersUri).encode(ExternalEncoding))
        if self.nbTemplates is not None:
            showIndent(outfile, level)
            outfile.write('nbTemplates=%d,\n' % self.nbTemplates)
        if self.notificationsUri is not None:
            showIndent(outfile, level)
            outfile.write('notificationsUri=%s,\n' % quote_python(self.notificationsUri).encode(ExternalEncoding))
        if self.orgUri is not None:
            showIndent(outfile, level)
            outfile.write('orgUri=%s,\n' % quote_python(self.orgUri).encode(ExternalEncoding))
        if self.partnersUri is not None:
            showIndent(outfile, level)
            outfile.write('partnersUri=%s,\n' % quote_python(self.partnersUri).encode(ExternalEncoding))
        if self.publicGallery is not None:
            showIndent(outfile, level)
            outfile.write('publicGallery=%s,\n' % self.publicGallery)
        showIndent(outfile, level)
        outfile.write('publishers=[\n')
        level += 1
        for publishers_ in self.publishers:
            showIndent(outfile, level)
            outfile.write('model_.user(\n')
            publishers_.exportLiteral(outfile, level, name_='user')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.publishersUri is not None:
            showIndent(outfile, level)
            outfile.write('publishersUri=%s,\n' % quote_python(self.publishersUri).encode(ExternalEncoding))
        if self.templatesUri is not None:
            showIndent(outfile, level)
            outfile.write('templatesUri=%s,\n' % quote_python(self.templatesUri).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.userGroupsUri is not None:
            showIndent(outfile, level)
            outfile.write('userGroupsUri=%s,\n' % quote_python(self.userGroupsUri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(gallery, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'membersUri':
            membersUri_ = child_.text
            membersUri_ = self.gds_validate_string(membersUri_, node, 'membersUri')
            self.membersUri = membersUri_
        elif nodeName_ == 'nbTemplates':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'nbTemplates')
            self.nbTemplates = ival_
        elif nodeName_ == 'notificationsUri':
            notificationsUri_ = child_.text
            notificationsUri_ = self.gds_validate_string(notificationsUri_, node, 'notificationsUri')
            self.notificationsUri = notificationsUri_
        elif nodeName_ == 'orgUri':
            orgUri_ = child_.text
            orgUri_ = self.gds_validate_string(orgUri_, node, 'orgUri')
            self.orgUri = orgUri_
        elif nodeName_ == 'partnersUri':
            partnersUri_ = child_.text
            partnersUri_ = self.gds_validate_string(partnersUri_, node, 'partnersUri')
            self.partnersUri = partnersUri_
        elif nodeName_ == 'publicGallery':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'publicGallery')
            self.publicGallery = ival_
        elif nodeName_ == 'publishers':
            obj_ = user.factory()
            obj_.build(child_)
            self.publishers.append(obj_)
        elif nodeName_ == 'publishersUri':
            publishersUri_ = child_.text
            publishersUri_ = self.gds_validate_string(publishersUri_, node, 'publishersUri')
            self.publishersUri = publishersUri_
        elif nodeName_ == 'templatesUri':
            templatesUri_ = child_.text
            templatesUri_ = self.gds_validate_string(templatesUri_, node, 'templatesUri')
            self.templatesUri = templatesUri_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'userGroupsUri':
            userGroupsUri_ = child_.text
            userGroupsUri_ = self.gds_validate_string(userGroupsUri_, node, 'userGroupsUri')
            self.userGroupsUri = userGroupsUri_
        super(gallery, self).buildChildren(child_, node, nodeName_, True)
# end class gallery


class user(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, active=None, address=None, admin=None, adminOrgUris=None, adminOrgsUri=None, apiAccess=None, apiKeysQuota=None, applianceUris=None, baseApiKeysUri=None, baseAppliancesUri=None, baseCredAccountsUri=None, baseDistributionsUri=None, baseFormatsUri=None, baseGalleriesUri=None, baseGalleryOrgsUri=None, baseImagesUri=None, baseImportsUri=None, baseMySoftwareLibraryUri=None, baseOrgsUri=None, baseProjectsUri=None, basePublishImagesUri=None, baseRankingsUri=None, baseRolesUri=None, baseTagsUri=None, baseWorkspacesUri=None, blueprints=None, blueprintsUri=None, builderAccess=None, canCreateWorkspace=None, canMigrate=None, canProvision=None, company=None, creationCode=None, credAccountUris=None, crmId=None, distributionUris=None, dob=None, email=None, firstName=None, formatUris=None, userFormats=None, galleryAccess=None, gender=None, homePhone=None, instancesUri=None, jobTitle=None, joined=None, lang=None, loginName=None, mobilePhone=None, mySoftwareLibraryUris=None, officePhone=None, orgUris=None, password=None, photo=None, productAccess=None, projectUris=None, promoCode=None, publishGalleries=None, quotasUri=None, rankings=None, roles=None, scannedInstancesUri=None, scansUri=None, sshKeys=None, sshKeysUri=None, statsUri=None, surname=None, tags=None, uri=None, usageUri=None, userResourcesAccessRights=None, userResourcesAccessRightsUri=None, website=None, vAppAccess=None):
        super(user, self).__init__(created, dbId, digest, lastModified, name, )
        self.active = active
        self.address = address
        self.admin = admin
        self.adminOrgUris = adminOrgUris
        self.adminOrgsUri = adminOrgsUri
        self.apiAccess = apiAccess
        self.apiKeysQuota = apiKeysQuota
        self.applianceUris = applianceUris
        self.baseApiKeysUri = baseApiKeysUri
        self.baseAppliancesUri = baseAppliancesUri
        self.baseCredAccountsUri = baseCredAccountsUri
        self.baseDistributionsUri = baseDistributionsUri
        self.baseFormatsUri = baseFormatsUri
        self.baseGalleriesUri = baseGalleriesUri
        self.baseGalleryOrgsUri = baseGalleryOrgsUri
        self.baseImagesUri = baseImagesUri
        self.baseImportsUri = baseImportsUri
        self.baseMySoftwareLibraryUri = baseMySoftwareLibraryUri
        self.baseOrgsUri = baseOrgsUri
        self.baseProjectsUri = baseProjectsUri
        self.basePublishImagesUri = basePublishImagesUri
        self.baseRankingsUri = baseRankingsUri
        self.baseRolesUri = baseRolesUri
        self.baseTagsUri = baseTagsUri
        self.baseWorkspacesUri = baseWorkspacesUri
        if blueprints is None:
            self.blueprints = []
        else:
            self.blueprints = blueprints
        self.blueprintsUri = blueprintsUri
        self.builderAccess = builderAccess
        self.canCreateWorkspace = canCreateWorkspace
        self.canMigrate = canMigrate
        self.canProvision = canProvision
        self.company = company
        self.creationCode = creationCode
        self.credAccountUris = credAccountUris
        self.crmId = crmId
        self.distributionUris = distributionUris
        if isinstance(dob, basestring):
            initvalue_ = datetime_.datetime.strptime(dob, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = dob
        self.dob = initvalue_
        self.email = email
        self.firstName = firstName
        self.formatUris = formatUris
        self.userFormats = userFormats
        self.galleryAccess = galleryAccess
        self.gender = gender
        self.homePhone = homePhone
        self.instancesUri = instancesUri
        self.jobTitle = jobTitle
        self.joined = joined
        self.lang = lang
        self.loginName = loginName
        self.mobilePhone = mobilePhone
        self.mySoftwareLibraryUris = mySoftwareLibraryUris
        self.officePhone = officePhone
        self.orgUris = orgUris
        self.password = password
        self.photo = photo
        self.productAccess = productAccess
        self.projectUris = projectUris
        self.promoCode = promoCode
        self.publishGalleries = publishGalleries
        self.quotasUri = quotasUri
        if rankings is None:
            self.rankings = []
        else:
            self.rankings = rankings
        self.roles = roles
        self.scannedInstancesUri = scannedInstancesUri
        self.scansUri = scansUri
        if sshKeys is None:
            self.sshKeys = []
        else:
            self.sshKeys = sshKeys
        self.sshKeysUri = sshKeysUri
        self.statsUri = statsUri
        self.surname = surname
        if tags is None:
            self.tags = []
        else:
            self.tags = tags
        self.uri = uri
        self.usageUri = usageUri
        self.userResourcesAccessRights = userResourcesAccessRights
        self.userResourcesAccessRightsUri = userResourcesAccessRightsUri
        self.website = website
        self.vAppAccess = vAppAccess
    def factory(*args_, **kwargs_):
        if user.subclass:
            return user.subclass(*args_, **kwargs_)
        else:
            return user(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_active(self): return self.active
    def set_active(self, active): self.active = active
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def get_admin(self): return self.admin
    def set_admin(self, admin): self.admin = admin
    def get_adminOrgUris(self): return self.adminOrgUris
    def set_adminOrgUris(self, adminOrgUris): self.adminOrgUris = adminOrgUris
    def get_adminOrgsUri(self): return self.adminOrgsUri
    def set_adminOrgsUri(self, adminOrgsUri): self.adminOrgsUri = adminOrgsUri
    def get_apiAccess(self): return self.apiAccess
    def set_apiAccess(self, apiAccess): self.apiAccess = apiAccess
    def get_apiKeysQuota(self): return self.apiKeysQuota
    def set_apiKeysQuota(self, apiKeysQuota): self.apiKeysQuota = apiKeysQuota
    def get_applianceUris(self): return self.applianceUris
    def set_applianceUris(self, applianceUris): self.applianceUris = applianceUris
    def get_baseApiKeysUri(self): return self.baseApiKeysUri
    def set_baseApiKeysUri(self, baseApiKeysUri): self.baseApiKeysUri = baseApiKeysUri
    def get_baseAppliancesUri(self): return self.baseAppliancesUri
    def set_baseAppliancesUri(self, baseAppliancesUri): self.baseAppliancesUri = baseAppliancesUri
    def get_baseCredAccountsUri(self): return self.baseCredAccountsUri
    def set_baseCredAccountsUri(self, baseCredAccountsUri): self.baseCredAccountsUri = baseCredAccountsUri
    def get_baseDistributionsUri(self): return self.baseDistributionsUri
    def set_baseDistributionsUri(self, baseDistributionsUri): self.baseDistributionsUri = baseDistributionsUri
    def get_baseFormatsUri(self): return self.baseFormatsUri
    def set_baseFormatsUri(self, baseFormatsUri): self.baseFormatsUri = baseFormatsUri
    def get_baseGalleriesUri(self): return self.baseGalleriesUri
    def set_baseGalleriesUri(self, baseGalleriesUri): self.baseGalleriesUri = baseGalleriesUri
    def get_baseGalleryOrgsUri(self): return self.baseGalleryOrgsUri
    def set_baseGalleryOrgsUri(self, baseGalleryOrgsUri): self.baseGalleryOrgsUri = baseGalleryOrgsUri
    def get_baseImagesUri(self): return self.baseImagesUri
    def set_baseImagesUri(self, baseImagesUri): self.baseImagesUri = baseImagesUri
    def get_baseImportsUri(self): return self.baseImportsUri
    def set_baseImportsUri(self, baseImportsUri): self.baseImportsUri = baseImportsUri
    def get_baseMySoftwareLibraryUri(self): return self.baseMySoftwareLibraryUri
    def set_baseMySoftwareLibraryUri(self, baseMySoftwareLibraryUri): self.baseMySoftwareLibraryUri = baseMySoftwareLibraryUri
    def get_baseOrgsUri(self): return self.baseOrgsUri
    def set_baseOrgsUri(self, baseOrgsUri): self.baseOrgsUri = baseOrgsUri
    def get_baseProjectsUri(self): return self.baseProjectsUri
    def set_baseProjectsUri(self, baseProjectsUri): self.baseProjectsUri = baseProjectsUri
    def get_basePublishImagesUri(self): return self.basePublishImagesUri
    def set_basePublishImagesUri(self, basePublishImagesUri): self.basePublishImagesUri = basePublishImagesUri
    def get_baseRankingsUri(self): return self.baseRankingsUri
    def set_baseRankingsUri(self, baseRankingsUri): self.baseRankingsUri = baseRankingsUri
    def get_baseRolesUri(self): return self.baseRolesUri
    def set_baseRolesUri(self, baseRolesUri): self.baseRolesUri = baseRolesUri
    def get_baseTagsUri(self): return self.baseTagsUri
    def set_baseTagsUri(self, baseTagsUri): self.baseTagsUri = baseTagsUri
    def get_baseWorkspacesUri(self): return self.baseWorkspacesUri
    def set_baseWorkspacesUri(self, baseWorkspacesUri): self.baseWorkspacesUri = baseWorkspacesUri
    def get_blueprints(self): return self.blueprints
    def set_blueprints(self, blueprints): self.blueprints = blueprints
    def add_blueprints(self, value): self.blueprints.append(value)
    def insert_blueprints(self, index, value): self.blueprints[index] = value
    def get_blueprintsUri(self): return self.blueprintsUri
    def set_blueprintsUri(self, blueprintsUri): self.blueprintsUri = blueprintsUri
    def get_builderAccess(self): return self.builderAccess
    def set_builderAccess(self, builderAccess): self.builderAccess = builderAccess
    def get_canCreateWorkspace(self): return self.canCreateWorkspace
    def set_canCreateWorkspace(self, canCreateWorkspace): self.canCreateWorkspace = canCreateWorkspace
    def get_canMigrate(self): return self.canMigrate
    def set_canMigrate(self, canMigrate): self.canMigrate = canMigrate
    def get_canProvision(self): return self.canProvision
    def set_canProvision(self, canProvision): self.canProvision = canProvision
    def get_company(self): return self.company
    def set_company(self, company): self.company = company
    def get_creationCode(self): return self.creationCode
    def set_creationCode(self, creationCode): self.creationCode = creationCode
    def get_credAccountUris(self): return self.credAccountUris
    def set_credAccountUris(self, credAccountUris): self.credAccountUris = credAccountUris
    def get_crmId(self): return self.crmId
    def set_crmId(self, crmId): self.crmId = crmId
    def get_distributionUris(self): return self.distributionUris
    def set_distributionUris(self, distributionUris): self.distributionUris = distributionUris
    def get_dob(self): return self.dob
    def set_dob(self, dob): self.dob = dob
    def get_email(self): return self.email
    def set_email(self, email): self.email = email
    def get_firstName(self): return self.firstName
    def set_firstName(self, firstName): self.firstName = firstName
    def get_formatUris(self): return self.formatUris
    def set_formatUris(self, formatUris): self.formatUris = formatUris
    def get_userFormats(self): return self.userFormats
    def set_userFormats(self, userFormats): self.userFormats = userFormats
    def get_galleryAccess(self): return self.galleryAccess
    def set_galleryAccess(self, galleryAccess): self.galleryAccess = galleryAccess
    def get_gender(self): return self.gender
    def set_gender(self, gender): self.gender = gender
    def get_homePhone(self): return self.homePhone
    def set_homePhone(self, homePhone): self.homePhone = homePhone
    def get_instancesUri(self): return self.instancesUri
    def set_instancesUri(self, instancesUri): self.instancesUri = instancesUri
    def get_jobTitle(self): return self.jobTitle
    def set_jobTitle(self, jobTitle): self.jobTitle = jobTitle
    def get_joined(self): return self.joined
    def set_joined(self, joined): self.joined = joined
    def get_lang(self): return self.lang
    def set_lang(self, lang): self.lang = lang
    def get_loginName(self): return self.loginName
    def set_loginName(self, loginName): self.loginName = loginName
    def get_mobilePhone(self): return self.mobilePhone
    def set_mobilePhone(self, mobilePhone): self.mobilePhone = mobilePhone
    def get_mySoftwareLibraryUris(self): return self.mySoftwareLibraryUris
    def set_mySoftwareLibraryUris(self, mySoftwareLibraryUris): self.mySoftwareLibraryUris = mySoftwareLibraryUris
    def get_officePhone(self): return self.officePhone
    def set_officePhone(self, officePhone): self.officePhone = officePhone
    def get_orgUris(self): return self.orgUris
    def set_orgUris(self, orgUris): self.orgUris = orgUris
    def get_password(self): return self.password
    def set_password(self, password): self.password = password
    def get_photo(self): return self.photo
    def set_photo(self, photo): self.photo = photo
    def get_productAccess(self): return self.productAccess
    def set_productAccess(self, productAccess): self.productAccess = productAccess
    def get_projectUris(self): return self.projectUris
    def set_projectUris(self, projectUris): self.projectUris = projectUris
    def get_promoCode(self): return self.promoCode
    def set_promoCode(self, promoCode): self.promoCode = promoCode
    def get_publishGalleries(self): return self.publishGalleries
    def set_publishGalleries(self, publishGalleries): self.publishGalleries = publishGalleries
    def get_quotasUri(self): return self.quotasUri
    def set_quotasUri(self, quotasUri): self.quotasUri = quotasUri
    def get_rankings(self): return self.rankings
    def set_rankings(self, rankings): self.rankings = rankings
    def add_rankings(self, value): self.rankings.append(value)
    def insert_rankings(self, index, value): self.rankings[index] = value
    def get_roles(self): return self.roles
    def set_roles(self, roles): self.roles = roles
    def get_scannedInstancesUri(self): return self.scannedInstancesUri
    def set_scannedInstancesUri(self, scannedInstancesUri): self.scannedInstancesUri = scannedInstancesUri
    def get_scansUri(self): return self.scansUri
    def set_scansUri(self, scansUri): self.scansUri = scansUri
    def get_sshKeys(self): return self.sshKeys
    def set_sshKeys(self, sshKeys): self.sshKeys = sshKeys
    def add_sshKeys(self, value): self.sshKeys.append(value)
    def insert_sshKeys(self, index, value): self.sshKeys[index] = value
    def get_sshKeysUri(self): return self.sshKeysUri
    def set_sshKeysUri(self, sshKeysUri): self.sshKeysUri = sshKeysUri
    def get_statsUri(self): return self.statsUri
    def set_statsUri(self, statsUri): self.statsUri = statsUri
    def get_surname(self): return self.surname
    def set_surname(self, surname): self.surname = surname
    def get_tags(self): return self.tags
    def set_tags(self, tags): self.tags = tags
    def add_tags(self, value): self.tags.append(value)
    def insert_tags(self, index, value): self.tags[index] = value
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_usageUri(self): return self.usageUri
    def set_usageUri(self, usageUri): self.usageUri = usageUri
    def get_userResourcesAccessRights(self): return self.userResourcesAccessRights
    def set_userResourcesAccessRights(self, userResourcesAccessRights): self.userResourcesAccessRights = userResourcesAccessRights
    def get_userResourcesAccessRightsUri(self): return self.userResourcesAccessRightsUri
    def set_userResourcesAccessRightsUri(self, userResourcesAccessRightsUri): self.userResourcesAccessRightsUri = userResourcesAccessRightsUri
    def get_website(self): return self.website
    def set_website(self, website): self.website = website
    def get_vAppAccess(self): return self.vAppAccess
    def set_vAppAccess(self, vAppAccess): self.vAppAccess = vAppAccess
    def hasContent_(self):
        if (
            self.active is not None or
            self.address is not None or
            self.admin is not None or
            self.adminOrgUris is not None or
            self.adminOrgsUri is not None or
            self.apiAccess is not None or
            self.apiKeysQuota is not None or
            self.applianceUris is not None or
            self.baseApiKeysUri is not None or
            self.baseAppliancesUri is not None or
            self.baseCredAccountsUri is not None or
            self.baseDistributionsUri is not None or
            self.baseFormatsUri is not None or
            self.baseGalleriesUri is not None or
            self.baseGalleryOrgsUri is not None or
            self.baseImagesUri is not None or
            self.baseImportsUri is not None or
            self.baseMySoftwareLibraryUri is not None or
            self.baseOrgsUri is not None or
            self.baseProjectsUri is not None or
            self.basePublishImagesUri is not None or
            self.baseRankingsUri is not None or
            self.baseRolesUri is not None or
            self.baseTagsUri is not None or
            self.baseWorkspacesUri is not None or
            self.blueprints or
            self.blueprintsUri is not None or
            self.builderAccess is not None or
            self.canCreateWorkspace is not None or
            self.canMigrate is not None or
            self.canProvision is not None or
            self.company is not None or
            self.creationCode is not None or
            self.credAccountUris is not None or
            self.crmId is not None or
            self.distributionUris is not None or
            self.dob is not None or
            self.email is not None or
            self.firstName is not None or
            self.formatUris is not None or
            self.userFormats is not None or
            self.galleryAccess is not None or
            self.gender is not None or
            self.homePhone is not None or
            self.instancesUri is not None or
            self.jobTitle is not None or
            self.joined is not None or
            self.lang is not None or
            self.loginName is not None or
            self.mobilePhone is not None or
            self.mySoftwareLibraryUris is not None or
            self.officePhone is not None or
            self.orgUris is not None or
            self.password is not None or
            self.photo is not None or
            self.productAccess is not None or
            self.projectUris is not None or
            self.promoCode is not None or
            self.publishGalleries is not None or
            self.quotasUri is not None or
            self.rankings or
            self.roles is not None or
            self.scannedInstancesUri is not None or
            self.scansUri is not None or
            self.sshKeys or
            self.sshKeysUri is not None or
            self.statsUri is not None or
            self.surname is not None or
            self.tags or
            self.uri is not None or
            self.usageUri is not None or
            self.userResourcesAccessRights is not None or
            self.userResourcesAccessRightsUri is not None or
            self.website is not None or
            self.vAppAccess is not None or
            super(user, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='user', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='user')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='user'):
        super(user, self).exportAttributes(outfile, level, already_processed, namespace_, name_='user')
    def exportChildren(self, outfile, level, namespace_='', name_='user', fromsubclass_=False, pretty_print=True):
        super(user, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.active is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sactive>%s</%sactive>%s' % (namespace_, self.gds_format_boolean(self.active, input_name='active'), namespace_, eol_))
        if self.address is not None:
            self.address.export(outfile, level, namespace_, name_='address', pretty_print=pretty_print)
        if self.admin is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sadmin>%s</%sadmin>%s' % (namespace_, self.gds_format_boolean(self.admin, input_name='admin'), namespace_, eol_))
        if self.adminOrgUris is not None:
            self.adminOrgUris.export(outfile, level, namespace_, name_='adminOrgUris', pretty_print=pretty_print)
        if self.adminOrgsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sadminOrgsUri>%s</%sadminOrgsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.adminOrgsUri).encode(ExternalEncoding), input_name='adminOrgsUri'), namespace_, eol_))
        if self.apiAccess is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sapiAccess>%s</%sapiAccess>%s' % (namespace_, self.gds_format_boolean(self.apiAccess, input_name='apiAccess'), namespace_, eol_))
        if self.apiKeysQuota is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sapiKeysQuota>%s</%sapiKeysQuota>%s' % (namespace_, self.gds_format_integer(self.apiKeysQuota, input_name='apiKeysQuota'), namespace_, eol_))
        if self.applianceUris is not None:
            self.applianceUris.export(outfile, level, namespace_, name_='applianceUris', pretty_print=pretty_print)
        if self.baseApiKeysUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseApiKeysUri>%s</%sbaseApiKeysUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseApiKeysUri).encode(ExternalEncoding), input_name='baseApiKeysUri'), namespace_, eol_))
        if self.baseAppliancesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseAppliancesUri>%s</%sbaseAppliancesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseAppliancesUri).encode(ExternalEncoding), input_name='baseAppliancesUri'), namespace_, eol_))
        if self.baseCredAccountsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseCredAccountsUri>%s</%sbaseCredAccountsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseCredAccountsUri).encode(ExternalEncoding), input_name='baseCredAccountsUri'), namespace_, eol_))
        if self.baseDistributionsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseDistributionsUri>%s</%sbaseDistributionsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseDistributionsUri).encode(ExternalEncoding), input_name='baseDistributionsUri'), namespace_, eol_))
        if self.baseFormatsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseFormatsUri>%s</%sbaseFormatsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseFormatsUri).encode(ExternalEncoding), input_name='baseFormatsUri'), namespace_, eol_))
        if self.baseGalleriesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseGalleriesUri>%s</%sbaseGalleriesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseGalleriesUri).encode(ExternalEncoding), input_name='baseGalleriesUri'), namespace_, eol_))
        if self.baseGalleryOrgsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseGalleryOrgsUri>%s</%sbaseGalleryOrgsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseGalleryOrgsUri).encode(ExternalEncoding), input_name='baseGalleryOrgsUri'), namespace_, eol_))
        if self.baseImagesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseImagesUri>%s</%sbaseImagesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseImagesUri).encode(ExternalEncoding), input_name='baseImagesUri'), namespace_, eol_))
        if self.baseImportsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseImportsUri>%s</%sbaseImportsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseImportsUri).encode(ExternalEncoding), input_name='baseImportsUri'), namespace_, eol_))
        if self.baseMySoftwareLibraryUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseMySoftwareLibraryUri>%s</%sbaseMySoftwareLibraryUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseMySoftwareLibraryUri).encode(ExternalEncoding), input_name='baseMySoftwareLibraryUri'), namespace_, eol_))
        if self.baseOrgsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseOrgsUri>%s</%sbaseOrgsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseOrgsUri).encode(ExternalEncoding), input_name='baseOrgsUri'), namespace_, eol_))
        if self.baseProjectsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseProjectsUri>%s</%sbaseProjectsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseProjectsUri).encode(ExternalEncoding), input_name='baseProjectsUri'), namespace_, eol_))
        if self.basePublishImagesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbasePublishImagesUri>%s</%sbasePublishImagesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.basePublishImagesUri).encode(ExternalEncoding), input_name='basePublishImagesUri'), namespace_, eol_))
        if self.baseRankingsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseRankingsUri>%s</%sbaseRankingsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseRankingsUri).encode(ExternalEncoding), input_name='baseRankingsUri'), namespace_, eol_))
        if self.baseRolesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseRolesUri>%s</%sbaseRolesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseRolesUri).encode(ExternalEncoding), input_name='baseRolesUri'), namespace_, eol_))
        if self.baseTagsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseTagsUri>%s</%sbaseTagsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseTagsUri).encode(ExternalEncoding), input_name='baseTagsUri'), namespace_, eol_))
        if self.baseWorkspacesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseWorkspacesUri>%s</%sbaseWorkspacesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseWorkspacesUri).encode(ExternalEncoding), input_name='baseWorkspacesUri'), namespace_, eol_))
        for blueprints_ in self.blueprints:
            blueprints_.export(outfile, level, namespace_, name_='blueprints', pretty_print=pretty_print)
        if self.blueprintsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sblueprintsUri>%s</%sblueprintsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.blueprintsUri).encode(ExternalEncoding), input_name='blueprintsUri'), namespace_, eol_))
        if self.builderAccess is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbuilderAccess>%s</%sbuilderAccess>%s' % (namespace_, self.gds_format_boolean(self.builderAccess, input_name='builderAccess'), namespace_, eol_))
        if self.canCreateWorkspace is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scanCreateWorkspace>%s</%scanCreateWorkspace>%s' % (namespace_, self.gds_format_boolean(self.canCreateWorkspace, input_name='canCreateWorkspace'), namespace_, eol_))
        if self.canMigrate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scanMigrate>%s</%scanMigrate>%s' % (namespace_, self.gds_format_boolean(self.canMigrate, input_name='canMigrate'), namespace_, eol_))
        if self.canProvision is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scanProvision>%s</%scanProvision>%s' % (namespace_, self.gds_format_boolean(self.canProvision, input_name='canProvision'), namespace_, eol_))
        if self.company is not None:
            self.company.export(outfile, level, namespace_, name_='company', pretty_print=pretty_print)
        if self.creationCode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%screationCode>%s</%screationCode>%s' % (namespace_, self.gds_format_string(quote_xml(self.creationCode).encode(ExternalEncoding), input_name='creationCode'), namespace_, eol_))
        if self.credAccountUris is not None:
            self.credAccountUris.export(outfile, level, namespace_, name_='credAccountUris', pretty_print=pretty_print)
        if self.crmId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scrmId>%s</%scrmId>%s' % (namespace_, self.gds_format_string(quote_xml(self.crmId).encode(ExternalEncoding), input_name='crmId'), namespace_, eol_))
        if self.distributionUris is not None:
            self.distributionUris.export(outfile, level, namespace_, name_='distributionUris', pretty_print=pretty_print)
        if self.dob is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdob>%s</%sdob>%s' % (namespace_, self.gds_format_datetime(self.dob, input_name='dob'), namespace_, eol_))
        if self.email is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%semail>%s</%semail>%s' % (namespace_, self.gds_format_string(quote_xml(self.email).encode(ExternalEncoding), input_name='email'), namespace_, eol_))
        if self.firstName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfirstName>%s</%sfirstName>%s' % (namespace_, self.gds_format_string(quote_xml(self.firstName).encode(ExternalEncoding), input_name='firstName'), namespace_, eol_))
        if self.formatUris is not None:
            self.formatUris.export(outfile, level, namespace_, name_='formatUris', pretty_print=pretty_print)
        if self.userFormats is not None:
            self.userFormats.export(outfile, level, namespace_, name_='userFormats', pretty_print=pretty_print)
        if self.galleryAccess is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgalleryAccess>%s</%sgalleryAccess>%s' % (namespace_, self.gds_format_boolean(self.galleryAccess, input_name='galleryAccess'), namespace_, eol_))
        if self.gender is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgender>%s</%sgender>%s' % (namespace_, self.gds_format_string(quote_xml(self.gender).encode(ExternalEncoding), input_name='gender'), namespace_, eol_))
        if self.homePhone is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shomePhone>%s</%shomePhone>%s' % (namespace_, self.gds_format_string(quote_xml(self.homePhone).encode(ExternalEncoding), input_name='homePhone'), namespace_, eol_))
        if self.instancesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinstancesUri>%s</%sinstancesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.instancesUri).encode(ExternalEncoding), input_name='instancesUri'), namespace_, eol_))
        if self.jobTitle is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sjobTitle>%s</%sjobTitle>%s' % (namespace_, self.gds_format_string(quote_xml(self.jobTitle).encode(ExternalEncoding), input_name='jobTitle'), namespace_, eol_))
        if self.joined is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sjoined>%s</%sjoined>%s' % (namespace_, self.gds_format_string(quote_xml(self.joined).encode(ExternalEncoding), input_name='joined'), namespace_, eol_))
        if self.lang is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slang>%s</%slang>%s' % (namespace_, self.gds_format_string(quote_xml(self.lang).encode(ExternalEncoding), input_name='lang'), namespace_, eol_))
        if self.loginName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sloginName>%s</%sloginName>%s' % (namespace_, self.gds_format_string(quote_xml(self.loginName).encode(ExternalEncoding), input_name='loginName'), namespace_, eol_))
        if self.mobilePhone is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smobilePhone>%s</%smobilePhone>%s' % (namespace_, self.gds_format_string(quote_xml(self.mobilePhone).encode(ExternalEncoding), input_name='mobilePhone'), namespace_, eol_))
        if self.mySoftwareLibraryUris is not None:
            self.mySoftwareLibraryUris.export(outfile, level, namespace_, name_='mySoftwareLibraryUris', pretty_print=pretty_print)
        if self.officePhone is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sofficePhone>%s</%sofficePhone>%s' % (namespace_, self.gds_format_string(quote_xml(self.officePhone).encode(ExternalEncoding), input_name='officePhone'), namespace_, eol_))
        if self.orgUris is not None:
            self.orgUris.export(outfile, level, namespace_, name_='orgUris', pretty_print=pretty_print)
        if self.password is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespace_, self.gds_format_string(quote_xml(self.password).encode(ExternalEncoding), input_name='password'), namespace_, eol_))
        if self.photo is not None:
            self.photo.export(outfile, level, namespace_, name_='photo', pretty_print=pretty_print)
        if self.productAccess is not None:
            self.productAccess.export(outfile, level, namespace_, name_='productAccess', pretty_print=pretty_print)
        if self.projectUris is not None:
            self.projectUris.export(outfile, level, namespace_, name_='projectUris', pretty_print=pretty_print)
        if self.promoCode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spromoCode>%s</%spromoCode>%s' % (namespace_, self.gds_format_string(quote_xml(self.promoCode).encode(ExternalEncoding), input_name='promoCode'), namespace_, eol_))
        if self.publishGalleries is not None:
            self.publishGalleries.export(outfile, level, namespace_, name_='publishGalleries', pretty_print=pretty_print)
        if self.quotasUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%squotasUri>%s</%squotasUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.quotasUri).encode(ExternalEncoding), input_name='quotasUri'), namespace_, eol_))
        for rankings_ in self.rankings:
            rankings_.export(outfile, level, namespace_, name_='rankings', pretty_print=pretty_print)
        if self.roles is not None:
            self.roles.export(outfile, level, namespace_, name_='roles', pretty_print=pretty_print)
        if self.scannedInstancesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sscannedInstancesUri>%s</%sscannedInstancesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.scannedInstancesUri).encode(ExternalEncoding), input_name='scannedInstancesUri'), namespace_, eol_))
        if self.scansUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sscansUri>%s</%sscansUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.scansUri).encode(ExternalEncoding), input_name='scansUri'), namespace_, eol_))
        for sshKeys_ in self.sshKeys:
            sshKeys_.export(outfile, level, namespace_, name_='sshKeys', pretty_print=pretty_print)
        if self.sshKeysUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssshKeysUri>%s</%ssshKeysUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.sshKeysUri).encode(ExternalEncoding), input_name='sshKeysUri'), namespace_, eol_))
        if self.statsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstatsUri>%s</%sstatsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.statsUri).encode(ExternalEncoding), input_name='statsUri'), namespace_, eol_))
        if self.surname is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssurname>%s</%ssurname>%s' % (namespace_, self.gds_format_string(quote_xml(self.surname).encode(ExternalEncoding), input_name='surname'), namespace_, eol_))
        for tags_ in self.tags:
            tags_.export(outfile, level, namespace_, name_='tags', pretty_print=pretty_print)
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
        if self.usageUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%susageUri>%s</%susageUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.usageUri).encode(ExternalEncoding), input_name='usageUri'), namespace_, eol_))
        if self.userResourcesAccessRights is not None:
            self.userResourcesAccessRights.export(outfile, level, namespace_, name_='userResourcesAccessRights', pretty_print=pretty_print)
        if self.userResourcesAccessRightsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suserResourcesAccessRightsUri>%s</%suserResourcesAccessRightsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.userResourcesAccessRightsUri).encode(ExternalEncoding), input_name='userResourcesAccessRightsUri'), namespace_, eol_))
        if self.website is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%swebsite>%s</%swebsite>%s' % (namespace_, self.gds_format_string(quote_xml(self.website).encode(ExternalEncoding), input_name='website'), namespace_, eol_))
        if self.vAppAccess is not None:
            self.vAppAccess.export(outfile, level, namespace_, name_='vAppAccess', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='user'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(user, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(user, self).exportLiteralChildren(outfile, level, name_)
        if self.active is not None:
            showIndent(outfile, level)
            outfile.write('active=%s,\n' % self.active)
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('address=model_.address(\n')
            self.address.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.admin is not None:
            showIndent(outfile, level)
            outfile.write('admin=%s,\n' % self.admin)
        if self.adminOrgUris is not None:
            showIndent(outfile, level)
            outfile.write('adminOrgUris=model_.uriList(\n')
            self.adminOrgUris.exportLiteral(outfile, level, name_='adminOrgUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.adminOrgsUri is not None:
            showIndent(outfile, level)
            outfile.write('adminOrgsUri=%s,\n' % quote_python(self.adminOrgsUri).encode(ExternalEncoding))
        if self.apiAccess is not None:
            showIndent(outfile, level)
            outfile.write('apiAccess=%s,\n' % self.apiAccess)
        if self.apiKeysQuota is not None:
            showIndent(outfile, level)
            outfile.write('apiKeysQuota=%d,\n' % self.apiKeysQuota)
        if self.applianceUris is not None:
            showIndent(outfile, level)
            outfile.write('applianceUris=model_.uriList(\n')
            self.applianceUris.exportLiteral(outfile, level, name_='applianceUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.baseApiKeysUri is not None:
            showIndent(outfile, level)
            outfile.write('baseApiKeysUri=%s,\n' % quote_python(self.baseApiKeysUri).encode(ExternalEncoding))
        if self.baseAppliancesUri is not None:
            showIndent(outfile, level)
            outfile.write('baseAppliancesUri=%s,\n' % quote_python(self.baseAppliancesUri).encode(ExternalEncoding))
        if self.baseCredAccountsUri is not None:
            showIndent(outfile, level)
            outfile.write('baseCredAccountsUri=%s,\n' % quote_python(self.baseCredAccountsUri).encode(ExternalEncoding))
        if self.baseDistributionsUri is not None:
            showIndent(outfile, level)
            outfile.write('baseDistributionsUri=%s,\n' % quote_python(self.baseDistributionsUri).encode(ExternalEncoding))
        if self.baseFormatsUri is not None:
            showIndent(outfile, level)
            outfile.write('baseFormatsUri=%s,\n' % quote_python(self.baseFormatsUri).encode(ExternalEncoding))
        if self.baseGalleriesUri is not None:
            showIndent(outfile, level)
            outfile.write('baseGalleriesUri=%s,\n' % quote_python(self.baseGalleriesUri).encode(ExternalEncoding))
        if self.baseGalleryOrgsUri is not None:
            showIndent(outfile, level)
            outfile.write('baseGalleryOrgsUri=%s,\n' % quote_python(self.baseGalleryOrgsUri).encode(ExternalEncoding))
        if self.baseImagesUri is not None:
            showIndent(outfile, level)
            outfile.write('baseImagesUri=%s,\n' % quote_python(self.baseImagesUri).encode(ExternalEncoding))
        if self.baseImportsUri is not None:
            showIndent(outfile, level)
            outfile.write('baseImportsUri=%s,\n' % quote_python(self.baseImportsUri).encode(ExternalEncoding))
        if self.baseMySoftwareLibraryUri is not None:
            showIndent(outfile, level)
            outfile.write('baseMySoftwareLibraryUri=%s,\n' % quote_python(self.baseMySoftwareLibraryUri).encode(ExternalEncoding))
        if self.baseOrgsUri is not None:
            showIndent(outfile, level)
            outfile.write('baseOrgsUri=%s,\n' % quote_python(self.baseOrgsUri).encode(ExternalEncoding))
        if self.baseProjectsUri is not None:
            showIndent(outfile, level)
            outfile.write('baseProjectsUri=%s,\n' % quote_python(self.baseProjectsUri).encode(ExternalEncoding))
        if self.basePublishImagesUri is not None:
            showIndent(outfile, level)
            outfile.write('basePublishImagesUri=%s,\n' % quote_python(self.basePublishImagesUri).encode(ExternalEncoding))
        if self.baseRankingsUri is not None:
            showIndent(outfile, level)
            outfile.write('baseRankingsUri=%s,\n' % quote_python(self.baseRankingsUri).encode(ExternalEncoding))
        if self.baseRolesUri is not None:
            showIndent(outfile, level)
            outfile.write('baseRolesUri=%s,\n' % quote_python(self.baseRolesUri).encode(ExternalEncoding))
        if self.baseTagsUri is not None:
            showIndent(outfile, level)
            outfile.write('baseTagsUri=%s,\n' % quote_python(self.baseTagsUri).encode(ExternalEncoding))
        if self.baseWorkspacesUri is not None:
            showIndent(outfile, level)
            outfile.write('baseWorkspacesUri=%s,\n' % quote_python(self.baseWorkspacesUri).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('blueprints=[\n')
        level += 1
        for blueprints_ in self.blueprints:
            showIndent(outfile, level)
            outfile.write('model_.blueprint(\n')
            blueprints_.exportLiteral(outfile, level, name_='blueprint')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.blueprintsUri is not None:
            showIndent(outfile, level)
            outfile.write('blueprintsUri=%s,\n' % quote_python(self.blueprintsUri).encode(ExternalEncoding))
        if self.builderAccess is not None:
            showIndent(outfile, level)
            outfile.write('builderAccess=%s,\n' % self.builderAccess)
        if self.canCreateWorkspace is not None:
            showIndent(outfile, level)
            outfile.write('canCreateWorkspace=%s,\n' % self.canCreateWorkspace)
        if self.canMigrate is not None:
            showIndent(outfile, level)
            outfile.write('canMigrate=%s,\n' % self.canMigrate)
        if self.canProvision is not None:
            showIndent(outfile, level)
            outfile.write('canProvision=%s,\n' % self.canProvision)
        if self.company is not None:
            showIndent(outfile, level)
            outfile.write('company=model_.company(\n')
            self.company.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.creationCode is not None:
            showIndent(outfile, level)
            outfile.write('creationCode=%s,\n' % quote_python(self.creationCode).encode(ExternalEncoding))
        if self.credAccountUris is not None:
            showIndent(outfile, level)
            outfile.write('credAccountUris=model_.uriList(\n')
            self.credAccountUris.exportLiteral(outfile, level, name_='credAccountUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.crmId is not None:
            showIndent(outfile, level)
            outfile.write('crmId=%s,\n' % quote_python(self.crmId).encode(ExternalEncoding))
        if self.distributionUris is not None:
            showIndent(outfile, level)
            outfile.write('distributionUris=model_.uriList(\n')
            self.distributionUris.exportLiteral(outfile, level, name_='distributionUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.dob is not None:
            showIndent(outfile, level)
            outfile.write('dob=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.dob, input_name='dob'))
        if self.email is not None:
            showIndent(outfile, level)
            outfile.write('email=%s,\n' % quote_python(self.email).encode(ExternalEncoding))
        if self.firstName is not None:
            showIndent(outfile, level)
            outfile.write('firstName=%s,\n' % quote_python(self.firstName).encode(ExternalEncoding))
        if self.formatUris is not None:
            showIndent(outfile, level)
            outfile.write('formatUris=model_.uriList(\n')
            self.formatUris.exportLiteral(outfile, level, name_='formatUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.userFormats is not None:
            showIndent(outfile, level)
            outfile.write('userFormats=model_.userFormats(\n')
            self.userFormats.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.galleryAccess is not None:
            showIndent(outfile, level)
            outfile.write('galleryAccess=%s,\n' % self.galleryAccess)
        if self.gender is not None:
            showIndent(outfile, level)
            outfile.write('gender=%s,\n' % quote_python(self.gender).encode(ExternalEncoding))
        if self.homePhone is not None:
            showIndent(outfile, level)
            outfile.write('homePhone=%s,\n' % quote_python(self.homePhone).encode(ExternalEncoding))
        if self.instancesUri is not None:
            showIndent(outfile, level)
            outfile.write('instancesUri=%s,\n' % quote_python(self.instancesUri).encode(ExternalEncoding))
        if self.jobTitle is not None:
            showIndent(outfile, level)
            outfile.write('jobTitle=%s,\n' % quote_python(self.jobTitle).encode(ExternalEncoding))
        if self.joined is not None:
            showIndent(outfile, level)
            outfile.write('joined=%s,\n' % quote_python(self.joined).encode(ExternalEncoding))
        if self.lang is not None:
            showIndent(outfile, level)
            outfile.write('lang=%s,\n' % quote_python(self.lang).encode(ExternalEncoding))
        if self.loginName is not None:
            showIndent(outfile, level)
            outfile.write('loginName=%s,\n' % quote_python(self.loginName).encode(ExternalEncoding))
        if self.mobilePhone is not None:
            showIndent(outfile, level)
            outfile.write('mobilePhone=%s,\n' % quote_python(self.mobilePhone).encode(ExternalEncoding))
        if self.mySoftwareLibraryUris is not None:
            showIndent(outfile, level)
            outfile.write('mySoftwareLibraryUris=model_.uriList(\n')
            self.mySoftwareLibraryUris.exportLiteral(outfile, level, name_='mySoftwareLibraryUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.officePhone is not None:
            showIndent(outfile, level)
            outfile.write('officePhone=%s,\n' % quote_python(self.officePhone).encode(ExternalEncoding))
        if self.orgUris is not None:
            showIndent(outfile, level)
            outfile.write('orgUris=model_.uriList(\n')
            self.orgUris.exportLiteral(outfile, level, name_='orgUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('password=%s,\n' % quote_python(self.password).encode(ExternalEncoding))
        if self.photo is not None:
            showIndent(outfile, level)
            outfile.write('photo=model_.logo(\n')
            self.photo.exportLiteral(outfile, level, name_='photo')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.productAccess is not None:
            showIndent(outfile, level)
            outfile.write('productAccess=model_.productAccess(\n')
            self.productAccess.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.projectUris is not None:
            showIndent(outfile, level)
            outfile.write('projectUris=model_.uriList(\n')
            self.projectUris.exportLiteral(outfile, level, name_='projectUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.promoCode is not None:
            showIndent(outfile, level)
            outfile.write('promoCode=%s,\n' % quote_python(self.promoCode).encode(ExternalEncoding))
        if self.publishGalleries is not None:
            showIndent(outfile, level)
            outfile.write('publishGalleries=model_.publishGalleries(\n')
            self.publishGalleries.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.quotasUri is not None:
            showIndent(outfile, level)
            outfile.write('quotasUri=%s,\n' % quote_python(self.quotasUri).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('rankings=[\n')
        level += 1
        for rankings_ in self.rankings:
            showIndent(outfile, level)
            outfile.write('model_.ranking(\n')
            rankings_.exportLiteral(outfile, level, name_='ranking')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.roles is not None:
            showIndent(outfile, level)
            outfile.write('roles=model_.roles(\n')
            self.roles.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.scannedInstancesUri is not None:
            showIndent(outfile, level)
            outfile.write('scannedInstancesUri=%s,\n' % quote_python(self.scannedInstancesUri).encode(ExternalEncoding))
        if self.scansUri is not None:
            showIndent(outfile, level)
            outfile.write('scansUri=%s,\n' % quote_python(self.scansUri).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('sshKeys=[\n')
        level += 1
        for sshKeys_ in self.sshKeys:
            showIndent(outfile, level)
            outfile.write('model_.sshKey(\n')
            sshKeys_.exportLiteral(outfile, level, name_='sshKey')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.sshKeysUri is not None:
            showIndent(outfile, level)
            outfile.write('sshKeysUri=%s,\n' % quote_python(self.sshKeysUri).encode(ExternalEncoding))
        if self.statsUri is not None:
            showIndent(outfile, level)
            outfile.write('statsUri=%s,\n' % quote_python(self.statsUri).encode(ExternalEncoding))
        if self.surname is not None:
            showIndent(outfile, level)
            outfile.write('surname=%s,\n' % quote_python(self.surname).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('tags=[\n')
        level += 1
        for tags_ in self.tags:
            showIndent(outfile, level)
            outfile.write('model_.tag(\n')
            tags_.exportLiteral(outfile, level, name_='tag')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.usageUri is not None:
            showIndent(outfile, level)
            outfile.write('usageUri=%s,\n' % quote_python(self.usageUri).encode(ExternalEncoding))
        if self.userResourcesAccessRights is not None:
            showIndent(outfile, level)
            outfile.write('userResourcesAccessRights=model_.userResourcesRights(\n')
            self.userResourcesAccessRights.exportLiteral(outfile, level, name_='userResourcesAccessRights')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.userResourcesAccessRightsUri is not None:
            showIndent(outfile, level)
            outfile.write('userResourcesAccessRightsUri=%s,\n' % quote_python(self.userResourcesAccessRightsUri).encode(ExternalEncoding))
        if self.website is not None:
            showIndent(outfile, level)
            outfile.write('website=%s,\n' % quote_python(self.website).encode(ExternalEncoding))
        if self.vAppAccess is not None:
            showIndent(outfile, level)
            outfile.write('vAppAccess=model_.vAppAccess(\n')
            self.vAppAccess.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(user, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'active':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'active')
            self.active = ival_
        elif nodeName_ == 'address':
            obj_ = address.factory()
            obj_.build(child_)
            self.address = obj_
        elif nodeName_ == 'admin':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'admin')
            self.admin = ival_
        elif nodeName_ == 'adminOrgUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.adminOrgUris = obj_
        elif nodeName_ == 'adminOrgsUri':
            adminOrgsUri_ = child_.text
            adminOrgsUri_ = self.gds_validate_string(adminOrgsUri_, node, 'adminOrgsUri')
            self.adminOrgsUri = adminOrgsUri_
        elif nodeName_ == 'apiAccess':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'apiAccess')
            self.apiAccess = ival_
        elif nodeName_ == 'apiKeysQuota':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'apiKeysQuota')
            self.apiKeysQuota = ival_
        elif nodeName_ == 'applianceUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.applianceUris = obj_
        elif nodeName_ == 'baseApiKeysUri':
            baseApiKeysUri_ = child_.text
            baseApiKeysUri_ = self.gds_validate_string(baseApiKeysUri_, node, 'baseApiKeysUri')
            self.baseApiKeysUri = baseApiKeysUri_
        elif nodeName_ == 'baseAppliancesUri':
            baseAppliancesUri_ = child_.text
            baseAppliancesUri_ = self.gds_validate_string(baseAppliancesUri_, node, 'baseAppliancesUri')
            self.baseAppliancesUri = baseAppliancesUri_
        elif nodeName_ == 'baseCredAccountsUri':
            baseCredAccountsUri_ = child_.text
            baseCredAccountsUri_ = self.gds_validate_string(baseCredAccountsUri_, node, 'baseCredAccountsUri')
            self.baseCredAccountsUri = baseCredAccountsUri_
        elif nodeName_ == 'baseDistributionsUri':
            baseDistributionsUri_ = child_.text
            baseDistributionsUri_ = self.gds_validate_string(baseDistributionsUri_, node, 'baseDistributionsUri')
            self.baseDistributionsUri = baseDistributionsUri_
        elif nodeName_ == 'baseFormatsUri':
            baseFormatsUri_ = child_.text
            baseFormatsUri_ = self.gds_validate_string(baseFormatsUri_, node, 'baseFormatsUri')
            self.baseFormatsUri = baseFormatsUri_
        elif nodeName_ == 'baseGalleriesUri':
            baseGalleriesUri_ = child_.text
            baseGalleriesUri_ = self.gds_validate_string(baseGalleriesUri_, node, 'baseGalleriesUri')
            self.baseGalleriesUri = baseGalleriesUri_
        elif nodeName_ == 'baseGalleryOrgsUri':
            baseGalleryOrgsUri_ = child_.text
            baseGalleryOrgsUri_ = self.gds_validate_string(baseGalleryOrgsUri_, node, 'baseGalleryOrgsUri')
            self.baseGalleryOrgsUri = baseGalleryOrgsUri_
        elif nodeName_ == 'baseImagesUri':
            baseImagesUri_ = child_.text
            baseImagesUri_ = self.gds_validate_string(baseImagesUri_, node, 'baseImagesUri')
            self.baseImagesUri = baseImagesUri_
        elif nodeName_ == 'baseImportsUri':
            baseImportsUri_ = child_.text
            baseImportsUri_ = self.gds_validate_string(baseImportsUri_, node, 'baseImportsUri')
            self.baseImportsUri = baseImportsUri_
        elif nodeName_ == 'baseMySoftwareLibraryUri':
            baseMySoftwareLibraryUri_ = child_.text
            baseMySoftwareLibraryUri_ = self.gds_validate_string(baseMySoftwareLibraryUri_, node, 'baseMySoftwareLibraryUri')
            self.baseMySoftwareLibraryUri = baseMySoftwareLibraryUri_
        elif nodeName_ == 'baseOrgsUri':
            baseOrgsUri_ = child_.text
            baseOrgsUri_ = self.gds_validate_string(baseOrgsUri_, node, 'baseOrgsUri')
            self.baseOrgsUri = baseOrgsUri_
        elif nodeName_ == 'baseProjectsUri':
            baseProjectsUri_ = child_.text
            baseProjectsUri_ = self.gds_validate_string(baseProjectsUri_, node, 'baseProjectsUri')
            self.baseProjectsUri = baseProjectsUri_
        elif nodeName_ == 'basePublishImagesUri':
            basePublishImagesUri_ = child_.text
            basePublishImagesUri_ = self.gds_validate_string(basePublishImagesUri_, node, 'basePublishImagesUri')
            self.basePublishImagesUri = basePublishImagesUri_
        elif nodeName_ == 'baseRankingsUri':
            baseRankingsUri_ = child_.text
            baseRankingsUri_ = self.gds_validate_string(baseRankingsUri_, node, 'baseRankingsUri')
            self.baseRankingsUri = baseRankingsUri_
        elif nodeName_ == 'baseRolesUri':
            baseRolesUri_ = child_.text
            baseRolesUri_ = self.gds_validate_string(baseRolesUri_, node, 'baseRolesUri')
            self.baseRolesUri = baseRolesUri_
        elif nodeName_ == 'baseTagsUri':
            baseTagsUri_ = child_.text
            baseTagsUri_ = self.gds_validate_string(baseTagsUri_, node, 'baseTagsUri')
            self.baseTagsUri = baseTagsUri_
        elif nodeName_ == 'baseWorkspacesUri':
            baseWorkspacesUri_ = child_.text
            baseWorkspacesUri_ = self.gds_validate_string(baseWorkspacesUri_, node, 'baseWorkspacesUri')
            self.baseWorkspacesUri = baseWorkspacesUri_
        elif nodeName_ == 'blueprints':
            obj_ = blueprint.factory()
            obj_.build(child_)
            self.blueprints.append(obj_)
        elif nodeName_ == 'blueprintsUri':
            blueprintsUri_ = child_.text
            blueprintsUri_ = self.gds_validate_string(blueprintsUri_, node, 'blueprintsUri')
            self.blueprintsUri = blueprintsUri_
        elif nodeName_ == 'builderAccess':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'builderAccess')
            self.builderAccess = ival_
        elif nodeName_ == 'canCreateWorkspace':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'canCreateWorkspace')
            self.canCreateWorkspace = ival_
        elif nodeName_ == 'canMigrate':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'canMigrate')
            self.canMigrate = ival_
        elif nodeName_ == 'canProvision':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'canProvision')
            self.canProvision = ival_
        elif nodeName_ == 'company':
            obj_ = company.factory()
            obj_.build(child_)
            self.company = obj_
        elif nodeName_ == 'creationCode':
            creationCode_ = child_.text
            creationCode_ = self.gds_validate_string(creationCode_, node, 'creationCode')
            self.creationCode = creationCode_
        elif nodeName_ == 'credAccountUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.credAccountUris = obj_
        elif nodeName_ == 'crmId':
            crmId_ = child_.text
            crmId_ = self.gds_validate_string(crmId_, node, 'crmId')
            self.crmId = crmId_
        elif nodeName_ == 'distributionUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.distributionUris = obj_
        elif nodeName_ == 'dob':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.dob = dval_
        elif nodeName_ == 'email':
            email_ = child_.text
            email_ = self.gds_validate_string(email_, node, 'email')
            self.email = email_
        elif nodeName_ == 'firstName':
            firstName_ = child_.text
            firstName_ = self.gds_validate_string(firstName_, node, 'firstName')
            self.firstName = firstName_
        elif nodeName_ == 'formatUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.formatUris = obj_
        elif nodeName_ == 'userFormats':
            obj_ = userFormats.factory()
            obj_.build(child_)
            self.userFormats = obj_
        elif nodeName_ == 'galleryAccess':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'galleryAccess')
            self.galleryAccess = ival_
        elif nodeName_ == 'gender':
            gender_ = child_.text
            gender_ = self.gds_validate_string(gender_, node, 'gender')
            self.gender = gender_
        elif nodeName_ == 'homePhone':
            homePhone_ = child_.text
            homePhone_ = self.gds_validate_string(homePhone_, node, 'homePhone')
            self.homePhone = homePhone_
        elif nodeName_ == 'instancesUri':
            instancesUri_ = child_.text
            instancesUri_ = self.gds_validate_string(instancesUri_, node, 'instancesUri')
            self.instancesUri = instancesUri_
        elif nodeName_ == 'jobTitle':
            jobTitle_ = child_.text
            jobTitle_ = self.gds_validate_string(jobTitle_, node, 'jobTitle')
            self.jobTitle = jobTitle_
        elif nodeName_ == 'joined':
            joined_ = child_.text
            joined_ = self.gds_validate_string(joined_, node, 'joined')
            self.joined = joined_
        elif nodeName_ == 'lang':
            lang_ = child_.text
            lang_ = self.gds_validate_string(lang_, node, 'lang')
            self.lang = lang_
        elif nodeName_ == 'loginName':
            loginName_ = child_.text
            loginName_ = self.gds_validate_string(loginName_, node, 'loginName')
            self.loginName = loginName_
        elif nodeName_ == 'mobilePhone':
            mobilePhone_ = child_.text
            mobilePhone_ = self.gds_validate_string(mobilePhone_, node, 'mobilePhone')
            self.mobilePhone = mobilePhone_
        elif nodeName_ == 'mySoftwareLibraryUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.mySoftwareLibraryUris = obj_
        elif nodeName_ == 'officePhone':
            officePhone_ = child_.text
            officePhone_ = self.gds_validate_string(officePhone_, node, 'officePhone')
            self.officePhone = officePhone_
        elif nodeName_ == 'orgUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.orgUris = obj_
        elif nodeName_ == 'password':
            password_ = child_.text
            password_ = self.gds_validate_string(password_, node, 'password')
            self.password = password_
        elif nodeName_ == 'photo':
            obj_ = logo.factory()
            obj_.build(child_)
            self.photo = obj_
        elif nodeName_ == 'productAccess':
            obj_ = productAccess.factory()
            obj_.build(child_)
            self.productAccess = obj_
        elif nodeName_ == 'projectUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.projectUris = obj_
        elif nodeName_ == 'promoCode':
            promoCode_ = child_.text
            promoCode_ = self.gds_validate_string(promoCode_, node, 'promoCode')
            self.promoCode = promoCode_
        elif nodeName_ == 'publishGalleries':
            obj_ = publishGalleries.factory()
            obj_.build(child_)
            self.publishGalleries = obj_
        elif nodeName_ == 'quotasUri':
            quotasUri_ = child_.text
            quotasUri_ = self.gds_validate_string(quotasUri_, node, 'quotasUri')
            self.quotasUri = quotasUri_
        elif nodeName_ == 'rankings':
            obj_ = ranking.factory()
            obj_.build(child_)
            self.rankings.append(obj_)
        elif nodeName_ == 'roles':
            obj_ = roles.factory()
            obj_.build(child_)
            self.roles = obj_
        elif nodeName_ == 'scannedInstancesUri':
            scannedInstancesUri_ = child_.text
            scannedInstancesUri_ = self.gds_validate_string(scannedInstancesUri_, node, 'scannedInstancesUri')
            self.scannedInstancesUri = scannedInstancesUri_
        elif nodeName_ == 'scansUri':
            scansUri_ = child_.text
            scansUri_ = self.gds_validate_string(scansUri_, node, 'scansUri')
            self.scansUri = scansUri_
        elif nodeName_ == 'sshKeys':
            obj_ = sshKey.factory()
            obj_.build(child_)
            self.sshKeys.append(obj_)
        elif nodeName_ == 'sshKeysUri':
            sshKeysUri_ = child_.text
            sshKeysUri_ = self.gds_validate_string(sshKeysUri_, node, 'sshKeysUri')
            self.sshKeysUri = sshKeysUri_
        elif nodeName_ == 'statsUri':
            statsUri_ = child_.text
            statsUri_ = self.gds_validate_string(statsUri_, node, 'statsUri')
            self.statsUri = statsUri_
        elif nodeName_ == 'surname':
            surname_ = child_.text
            surname_ = self.gds_validate_string(surname_, node, 'surname')
            self.surname = surname_
        elif nodeName_ == 'tags':
            obj_ = tag.factory()
            obj_.build(child_)
            self.tags.append(obj_)
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'usageUri':
            usageUri_ = child_.text
            usageUri_ = self.gds_validate_string(usageUri_, node, 'usageUri')
            self.usageUri = usageUri_
        elif nodeName_ == 'userResourcesAccessRights':
            obj_ = userResourcesRights.factory()
            obj_.build(child_)
            self.userResourcesAccessRights = obj_
        elif nodeName_ == 'userResourcesAccessRightsUri':
            userResourcesAccessRightsUri_ = child_.text
            userResourcesAccessRightsUri_ = self.gds_validate_string(userResourcesAccessRightsUri_, node, 'userResourcesAccessRightsUri')
            self.userResourcesAccessRightsUri = userResourcesAccessRightsUri_
        elif nodeName_ == 'website':
            website_ = child_.text
            website_ = self.gds_validate_string(website_, node, 'website')
            self.website = website_
        elif nodeName_ == 'vAppAccess':
            obj_ = vAppAccess.factory()
            obj_.build(child_)
            self.vAppAccess = obj_
        super(user, self).buildChildren(child_, node, nodeName_, True)
# end class user


class userFormats(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, format=None):
        if format is None:
            self.format = []
        else:
            self.format = format
    def factory(*args_, **kwargs_):
        if userFormats.subclass:
            return userFormats.subclass(*args_, **kwargs_)
        else:
            return userFormats(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def add_format(self, value): self.format.append(value)
    def insert_format(self, index, value): self.format[index] = value
    def hasContent_(self):
        if (
            self.format
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='userFormats', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='userFormats')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='userFormats'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='userFormats', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for format_ in self.format:
            format_.export(outfile, level, namespace_, name_='format', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='userFormats'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('format=[\n')
        level += 1
        for format_ in self.format:
            showIndent(outfile, level)
            outfile.write('model_.imageFormat(\n')
            format_.exportLiteral(outfile, level, name_='imageFormat')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'format':
            obj_ = imageFormat.factory()
            obj_.build(child_)
            self.format.append(obj_)
# end class userFormats


class publishGalleries(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, gallery=None):
        if gallery is None:
            self.gallery = []
        else:
            self.gallery = gallery
    def factory(*args_, **kwargs_):
        if publishGalleries.subclass:
            return publishGalleries.subclass(*args_, **kwargs_)
        else:
            return publishGalleries(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_gallery(self): return self.gallery
    def set_gallery(self, gallery): self.gallery = gallery
    def add_gallery(self, value): self.gallery.append(value)
    def insert_gallery(self, index, value): self.gallery[index] = value
    def hasContent_(self):
        if (
            self.gallery
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='publishGalleries', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='publishGalleries')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='publishGalleries'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='publishGalleries', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for gallery_ in self.gallery:
            gallery_.export(outfile, level, namespace_, name_='gallery', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='publishGalleries'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('gallery=[\n')
        level += 1
        for gallery_ in self.gallery:
            showIndent(outfile, level)
            outfile.write('model_.gallery(\n')
            gallery_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'gallery':
            obj_ = gallery.factory()
            obj_.build(child_)
            self.gallery.append(obj_)
# end class publishGalleries


class roles(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, role=None):
        if role is None:
            self.role = []
        else:
            self.role = role
    def factory(*args_, **kwargs_):
        if roles.subclass:
            return roles.subclass(*args_, **kwargs_)
        else:
            return roles(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_role(self): return self.role
    def set_role(self, role): self.role = role
    def add_role(self, value): self.role.append(value)
    def insert_role(self, index, value): self.role[index] = value
    def hasContent_(self):
        if (
            self.role
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='roles', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='roles')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='roles'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='roles', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for role_ in self.role:
            role_.export(outfile, level, namespace_, name_='role', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='roles'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('role=[\n')
        level += 1
        for role_ in self.role:
            showIndent(outfile, level)
            outfile.write('model_.role(\n')
            role_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'role':
            obj_ = role.factory()
            obj_.build(child_)
            self.role.append(obj_)
# end class roles


class blueprint(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, deployments=None, deploymentsUri=None, description=None, exportsUri=None, layers=None, layersUri=None, logo=None, orgUri=None, parentUri=None, revision=None, uri=None, version=None, zones=None):
        super(blueprint, self).__init__(created, dbId, digest, lastModified, name, )
        if deployments is None:
            self.deployments = []
        else:
            self.deployments = deployments
        self.deploymentsUri = deploymentsUri
        self.description = description
        self.exportsUri = exportsUri
        self.layers = layers
        self.layersUri = layersUri
        self.logo = logo
        self.orgUri = orgUri
        self.parentUri = parentUri
        self.revision = revision
        self.uri = uri
        self.version = version
        if zones is None:
            self.zones = []
        else:
            self.zones = zones
    def factory(*args_, **kwargs_):
        if blueprint.subclass:
            return blueprint.subclass(*args_, **kwargs_)
        else:
            return blueprint(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_deployments(self): return self.deployments
    def set_deployments(self, deployments): self.deployments = deployments
    def add_deployments(self, value): self.deployments.append(value)
    def insert_deployments(self, index, value): self.deployments[index] = value
    def get_deploymentsUri(self): return self.deploymentsUri
    def set_deploymentsUri(self, deploymentsUri): self.deploymentsUri = deploymentsUri
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_exportsUri(self): return self.exportsUri
    def set_exportsUri(self, exportsUri): self.exportsUri = exportsUri
    def get_layers(self): return self.layers
    def set_layers(self, layers): self.layers = layers
    def get_layersUri(self): return self.layersUri
    def set_layersUri(self, layersUri): self.layersUri = layersUri
    def get_logo(self): return self.logo
    def set_logo(self, logo): self.logo = logo
    def get_orgUri(self): return self.orgUri
    def set_orgUri(self, orgUri): self.orgUri = orgUri
    def get_parentUri(self): return self.parentUri
    def set_parentUri(self, parentUri): self.parentUri = parentUri
    def get_revision(self): return self.revision
    def set_revision(self, revision): self.revision = revision
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_zones(self): return self.zones
    def set_zones(self, zones): self.zones = zones
    def add_zones(self, value): self.zones.append(value)
    def insert_zones(self, index, value): self.zones[index] = value
    def hasContent_(self):
        if (
            self.deployments or
            self.deploymentsUri is not None or
            self.description is not None or
            self.exportsUri is not None or
            self.layers is not None or
            self.layersUri is not None or
            self.logo is not None or
            self.orgUri is not None or
            self.parentUri is not None or
            self.revision is not None or
            self.uri is not None or
            self.version is not None or
            self.zones or
            super(blueprint, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='blueprint', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='blueprint')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='blueprint'):
        super(blueprint, self).exportAttributes(outfile, level, already_processed, namespace_, name_='blueprint')
    def exportChildren(self, outfile, level, namespace_='', name_='blueprint', fromsubclass_=False, pretty_print=True):
        super(blueprint, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for deployments_ in self.deployments:
            deployments_.export(outfile, level, namespace_, name_='deployments', pretty_print=pretty_print)
        if self.deploymentsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdeploymentsUri>%s</%sdeploymentsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.deploymentsUri).encode(ExternalEncoding), input_name='deploymentsUri'), namespace_, eol_))
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_, eol_))
        if self.exportsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sexportsUri>%s</%sexportsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.exportsUri).encode(ExternalEncoding), input_name='exportsUri'), namespace_, eol_))
        if self.layers is not None:
            self.layers.export(outfile, level, namespace_, name_='layers', pretty_print=pretty_print)
        if self.layersUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slayersUri>%s</%slayersUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.layersUri).encode(ExternalEncoding), input_name='layersUri'), namespace_, eol_))
        if self.logo is not None:
            self.logo.export(outfile, level, namespace_, name_='logo', pretty_print=pretty_print)
        if self.orgUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorgUri>%s</%sorgUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.orgUri).encode(ExternalEncoding), input_name='orgUri'), namespace_, eol_))
        if self.parentUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparentUri>%s</%sparentUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.parentUri).encode(ExternalEncoding), input_name='parentUri'), namespace_, eol_))
        if self.revision is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srevision>%s</%srevision>%s' % (namespace_, self.gds_format_integer(self.revision, input_name='revision'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
        if self.version is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sversion>%s</%sversion>%s' % (namespace_, self.gds_format_string(quote_xml(self.version).encode(ExternalEncoding), input_name='version'), namespace_, eol_))
        for zones_ in self.zones:
            zones_.export(outfile, level, namespace_, name_='zones', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='blueprint'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(blueprint, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(blueprint, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('deployments=[\n')
        level += 1
        for deployments_ in self.deployments:
            showIndent(outfile, level)
            outfile.write('model_.deployment(\n')
            deployments_.exportLiteral(outfile, level, name_='deployment')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.deploymentsUri is not None:
            showIndent(outfile, level)
            outfile.write('deploymentsUri=%s,\n' % quote_python(self.deploymentsUri).encode(ExternalEncoding))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        if self.exportsUri is not None:
            showIndent(outfile, level)
            outfile.write('exportsUri=%s,\n' % quote_python(self.exportsUri).encode(ExternalEncoding))
        if self.layers is not None:
            showIndent(outfile, level)
            outfile.write('layers=model_.layers(\n')
            self.layers.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.layersUri is not None:
            showIndent(outfile, level)
            outfile.write('layersUri=%s,\n' % quote_python(self.layersUri).encode(ExternalEncoding))
        if self.logo is not None:
            showIndent(outfile, level)
            outfile.write('logo=model_.logo(\n')
            self.logo.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.orgUri is not None:
            showIndent(outfile, level)
            outfile.write('orgUri=%s,\n' % quote_python(self.orgUri).encode(ExternalEncoding))
        if self.parentUri is not None:
            showIndent(outfile, level)
            outfile.write('parentUri=%s,\n' % quote_python(self.parentUri).encode(ExternalEncoding))
        if self.revision is not None:
            showIndent(outfile, level)
            outfile.write('revision=%d,\n' % self.revision)
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version=%s,\n' % quote_python(self.version).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('zones=[\n')
        level += 1
        for zones_ in self.zones:
            showIndent(outfile, level)
            outfile.write('model_.networkZone(\n')
            zones_.exportLiteral(outfile, level, name_='networkZone')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(blueprint, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'deployments':
            obj_ = deployment.factory()
            obj_.build(child_)
            self.deployments.append(obj_)
        elif nodeName_ == 'deploymentsUri':
            deploymentsUri_ = child_.text
            deploymentsUri_ = self.gds_validate_string(deploymentsUri_, node, 'deploymentsUri')
            self.deploymentsUri = deploymentsUri_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'exportsUri':
            exportsUri_ = child_.text
            exportsUri_ = self.gds_validate_string(exportsUri_, node, 'exportsUri')
            self.exportsUri = exportsUri_
        elif nodeName_ == 'layers':
            obj_ = layers.factory()
            obj_.build(child_)
            self.layers = obj_
        elif nodeName_ == 'layersUri':
            layersUri_ = child_.text
            layersUri_ = self.gds_validate_string(layersUri_, node, 'layersUri')
            self.layersUri = layersUri_
        elif nodeName_ == 'logo':
            obj_ = logo.factory()
            obj_.build(child_)
            self.logo = obj_
        elif nodeName_ == 'orgUri':
            orgUri_ = child_.text
            orgUri_ = self.gds_validate_string(orgUri_, node, 'orgUri')
            self.orgUri = orgUri_
        elif nodeName_ == 'parentUri':
            parentUri_ = child_.text
            parentUri_ = self.gds_validate_string(parentUri_, node, 'parentUri')
            self.parentUri = parentUri_
        elif nodeName_ == 'revision':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'revision')
            self.revision = ival_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'version':
            version_ = child_.text
            version_ = self.gds_validate_string(version_, node, 'version')
            self.version = version_
        elif nodeName_ == 'zones':
            obj_ = networkZone.factory()
            obj_.build(child_)
            self.zones.append(obj_)
        super(blueprint, self).buildChildren(child_, node, nodeName_, True)
# end class blueprint


class layers(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, layer=None):
        if layer is None:
            self.layer = []
        else:
            self.layer = layer
    def factory(*args_, **kwargs_):
        if layers.subclass:
            return layers.subclass(*args_, **kwargs_)
        else:
            return layers(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_layer(self): return self.layer
    def set_layer(self, layer): self.layer = layer
    def add_layer(self, value): self.layer.append(value)
    def insert_layer(self, index, value): self.layer[index] = value
    def hasContent_(self):
        if (
            self.layer
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='layers', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='layers')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='layers'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='layers', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for layer_ in self.layer:
            layer_.export(outfile, level, namespace_, name_='layer', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='layers'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('layer=[\n')
        level += 1
        for layer_ in self.layer:
            showIndent(outfile, level)
            outfile.write('model_.layer(\n')
            layer_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'layer':
            obj_ = blueprintLayer.factory()
            obj_.build(child_)
            self.layer.append(obj_)
# end class layers


class deployment(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, blueprintUri=None, description=None, images=None, parentUri=None, status=None, statusUri=None, uri=None):
        super(deployment, self).__init__(created, dbId, digest, lastModified, name, )
        self.blueprintUri = blueprintUri
        self.description = description
        self.images = images
        self.parentUri = parentUri
        self.status = status
        self.statusUri = statusUri
        self.uri = uri
    def factory(*args_, **kwargs_):
        if deployment.subclass:
            return deployment.subclass(*args_, **kwargs_)
        else:
            return deployment(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_blueprintUri(self): return self.blueprintUri
    def set_blueprintUri(self, blueprintUri): self.blueprintUri = blueprintUri
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_images(self): return self.images
    def set_images(self, images): self.images = images
    def get_parentUri(self): return self.parentUri
    def set_parentUri(self, parentUri): self.parentUri = parentUri
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_statusUri(self): return self.statusUri
    def set_statusUri(self, statusUri): self.statusUri = statusUri
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def hasContent_(self):
        if (
            self.blueprintUri is not None or
            self.description is not None or
            self.images is not None or
            self.parentUri is not None or
            self.status is not None or
            self.statusUri is not None or
            self.uri is not None or
            super(deployment, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='deployment', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='deployment')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='deployment'):
        super(deployment, self).exportAttributes(outfile, level, already_processed, namespace_, name_='deployment')
    def exportChildren(self, outfile, level, namespace_='', name_='deployment', fromsubclass_=False, pretty_print=True):
        super(deployment, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.blueprintUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sblueprintUri>%s</%sblueprintUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.blueprintUri).encode(ExternalEncoding), input_name='blueprintUri'), namespace_, eol_))
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_, eol_))
        if self.images is not None:
            self.images.export(outfile, level, namespace_, name_='images', pretty_print=pretty_print)
        if self.parentUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparentUri>%s</%sparentUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.parentUri).encode(ExternalEncoding), input_name='parentUri'), namespace_, eol_))
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status', pretty_print=pretty_print)
        if self.statusUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstatusUri>%s</%sstatusUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.statusUri).encode(ExternalEncoding), input_name='statusUri'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='deployment'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(deployment, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(deployment, self).exportLiteralChildren(outfile, level, name_)
        if self.blueprintUri is not None:
            showIndent(outfile, level)
            outfile.write('blueprintUri=%s,\n' % quote_python(self.blueprintUri).encode(ExternalEncoding))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        if self.images is not None:
            showIndent(outfile, level)
            outfile.write('images=model_.images(\n')
            self.images.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.parentUri is not None:
            showIndent(outfile, level)
            outfile.write('parentUri=%s,\n' % quote_python(self.parentUri).encode(ExternalEncoding))
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.statusUri is not None:
            showIndent(outfile, level)
            outfile.write('statusUri=%s,\n' % quote_python(self.statusUri).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(deployment, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'blueprintUri':
            blueprintUri_ = child_.text
            blueprintUri_ = self.gds_validate_string(blueprintUri_, node, 'blueprintUri')
            self.blueprintUri = blueprintUri_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'images':
            obj_ = images.factory()
            obj_.build(child_)
            self.images = obj_
        elif nodeName_ == 'parentUri':
            parentUri_ = child_.text
            parentUri_ = self.gds_validate_string(parentUri_, node, 'parentUri')
            self.parentUri = parentUri_
        elif nodeName_ == 'status':
            obj_ = opStatus.factory()
            obj_.build(child_)
            self.status = obj_
        elif nodeName_ == 'statusUri':
            statusUri_ = child_.text
            statusUri_ = self.gds_validate_string(statusUri_, node, 'statusUri')
            self.statusUri = statusUri_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(deployment, self).buildChildren(child_, node, nodeName_, True)
# end class deployment


class images(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, image=None):
        if image is None:
            self.image = []
        else:
            self.image = image
    def factory(*args_, **kwargs_):
        if images.subclass:
            return images.subclass(*args_, **kwargs_)
        else:
            return images(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_image(self): return self.image
    def set_image(self, image): self.image = image
    def add_image(self, value): self.image.append(value)
    def insert_image(self, index, value): self.image[index] = value
    def hasContent_(self):
        if (
            self.image
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='images', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='images')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='images'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='images', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for image_ in self.image:
            image_.export(outfile, level, namespace_, name_='image', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='images'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('image=[\n')
        level += 1
        for image_ in self.image:
            showIndent(outfile, level)
            outfile.write('model_.image(\n')
            image_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'image':
            class_obj_ = self.get_class_obj_(child_, image)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.image.append(obj_)
# end class images


class image(uForgeUploadObject):
    subclass = None
    superclass = uForgeUploadObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, md5sum=None, mimeType=None, sha256sum=None, size=None, status=None, uploaded=None, uploadedTime=None, applianceUri=None, basePublishImagesUri=None, completeInstalledSize=None, completeSize=None, compress=None, credAccount=None, disableRootPassword=None, downloadKey=None, downloadUri=None, ebs=None, ebsVolumeSize=None, fileExtension=None, fileName=None, fileSize=None, format=None, fullName=None, imageCreated=None, installProfile=None, orgUri=None, pkgsUri=None, publicAccess=None, registeredCredAccount=None, revision=None, simulated=None, statusUri=None, tag=None, updateTools=None, uri=None, version=None, vmDiskSize=None, vmMemorySize=None, extensiontype_=None):
        super(image, self).__init__(created, dbId, digest, lastModified, name, md5sum, mimeType, sha256sum, size, status, uploaded, uploadedTime, extensiontype_, )
        self.applianceUri = applianceUri
        self.basePublishImagesUri = basePublishImagesUri
        self.completeInstalledSize = completeInstalledSize
        self.completeSize = completeSize
        self.compress = compress
        self.credAccount = credAccount
        self.disableRootPassword = disableRootPassword
        self.downloadKey = downloadKey
        self.downloadUri = downloadUri
        self.ebs = ebs
        self.ebsVolumeSize = ebsVolumeSize
        self.fileExtension = fileExtension
        self.fileName = fileName
        self.fileSize = fileSize
        self.format = format
        self.fullName = fullName
        self.imageCreated = imageCreated
        self.installProfile = installProfile
        self.orgUri = orgUri
        self.pkgsUri = pkgsUri
        self.publicAccess = publicAccess
        self.registeredCredAccount = registeredCredAccount
        self.revision = revision
        self.simulated = simulated
        self.statusUri = statusUri
        self.tag = tag
        self.updateTools = updateTools
        self.uri = uri
        self.version = version
        self.vmDiskSize = vmDiskSize
        self.vmMemorySize = vmMemorySize
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if image.subclass:
            return image.subclass(*args_, **kwargs_)
        else:
            return image(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_applianceUri(self): return self.applianceUri
    def set_applianceUri(self, applianceUri): self.applianceUri = applianceUri
    def get_basePublishImagesUri(self): return self.basePublishImagesUri
    def set_basePublishImagesUri(self, basePublishImagesUri): self.basePublishImagesUri = basePublishImagesUri
    def get_completeInstalledSize(self): return self.completeInstalledSize
    def set_completeInstalledSize(self, completeInstalledSize): self.completeInstalledSize = completeInstalledSize
    def get_completeSize(self): return self.completeSize
    def set_completeSize(self, completeSize): self.completeSize = completeSize
    def get_compress(self): return self.compress
    def set_compress(self, compress): self.compress = compress
    def get_credAccount(self): return self.credAccount
    def set_credAccount(self, credAccount): self.credAccount = credAccount
    def get_disableRootPassword(self): return self.disableRootPassword
    def set_disableRootPassword(self, disableRootPassword): self.disableRootPassword = disableRootPassword
    def get_downloadKey(self): return self.downloadKey
    def set_downloadKey(self, downloadKey): self.downloadKey = downloadKey
    def get_downloadUri(self): return self.downloadUri
    def set_downloadUri(self, downloadUri): self.downloadUri = downloadUri
    def get_ebs(self): return self.ebs
    def set_ebs(self, ebs): self.ebs = ebs
    def get_ebsVolumeSize(self): return self.ebsVolumeSize
    def set_ebsVolumeSize(self, ebsVolumeSize): self.ebsVolumeSize = ebsVolumeSize
    def get_fileExtension(self): return self.fileExtension
    def set_fileExtension(self, fileExtension): self.fileExtension = fileExtension
    def get_fileName(self): return self.fileName
    def set_fileName(self, fileName): self.fileName = fileName
    def get_fileSize(self): return self.fileSize
    def set_fileSize(self, fileSize): self.fileSize = fileSize
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def get_fullName(self): return self.fullName
    def set_fullName(self, fullName): self.fullName = fullName
    def get_imageCreated(self): return self.imageCreated
    def set_imageCreated(self, imageCreated): self.imageCreated = imageCreated
    def get_installProfile(self): return self.installProfile
    def set_installProfile(self, installProfile): self.installProfile = installProfile
    def get_orgUri(self): return self.orgUri
    def set_orgUri(self, orgUri): self.orgUri = orgUri
    def get_pkgsUri(self): return self.pkgsUri
    def set_pkgsUri(self, pkgsUri): self.pkgsUri = pkgsUri
    def get_publicAccess(self): return self.publicAccess
    def set_publicAccess(self, publicAccess): self.publicAccess = publicAccess
    def get_registeredCredAccount(self): return self.registeredCredAccount
    def set_registeredCredAccount(self, registeredCredAccount): self.registeredCredAccount = registeredCredAccount
    def get_revision(self): return self.revision
    def set_revision(self, revision): self.revision = revision
    def get_simulated(self): return self.simulated
    def set_simulated(self, simulated): self.simulated = simulated
    def get_statusUri(self): return self.statusUri
    def set_statusUri(self, statusUri): self.statusUri = statusUri
    def get_tag(self): return self.tag
    def set_tag(self, tag): self.tag = tag
    def get_updateTools(self): return self.updateTools
    def set_updateTools(self, updateTools): self.updateTools = updateTools
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_vmDiskSize(self): return self.vmDiskSize
    def set_vmDiskSize(self, vmDiskSize): self.vmDiskSize = vmDiskSize
    def get_vmMemorySize(self): return self.vmMemorySize
    def set_vmMemorySize(self, vmMemorySize): self.vmMemorySize = vmMemorySize
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.applianceUri is not None or
            self.basePublishImagesUri is not None or
            self.completeInstalledSize is not None or
            self.completeSize is not None or
            self.compress is not None or
            self.credAccount is not None or
            self.disableRootPassword is not None or
            self.downloadKey is not None or
            self.downloadUri is not None or
            self.ebs is not None or
            self.ebsVolumeSize is not None or
            self.fileExtension is not None or
            self.fileName is not None or
            self.fileSize is not None or
            self.format is not None or
            self.fullName is not None or
            self.imageCreated is not None or
            self.installProfile is not None or
            self.orgUri is not None or
            self.pkgsUri is not None or
            self.publicAccess is not None or
            self.registeredCredAccount is not None or
            self.revision is not None or
            self.simulated is not None or
            self.statusUri is not None or
            self.tag is not None or
            self.updateTools is not None or
            self.uri is not None or
            self.version is not None or
            self.vmDiskSize is not None or
            self.vmMemorySize is not None or
            super(image, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='image', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='image')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='image'):
        super(image, self).exportAttributes(outfile, level, already_processed, namespace_, name_='image')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='image', fromsubclass_=False, pretty_print=True):
        super(image, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.applianceUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sapplianceUri>%s</%sapplianceUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.applianceUri).encode(ExternalEncoding), input_name='applianceUri'), namespace_, eol_))
        if self.basePublishImagesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbasePublishImagesUri>%s</%sbasePublishImagesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.basePublishImagesUri).encode(ExternalEncoding), input_name='basePublishImagesUri'), namespace_, eol_))
        if self.completeInstalledSize is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scompleteInstalledSize>%s</%scompleteInstalledSize>%s' % (namespace_, self.gds_format_integer(self.completeInstalledSize, input_name='completeInstalledSize'), namespace_, eol_))
        if self.completeSize is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scompleteSize>%s</%scompleteSize>%s' % (namespace_, self.gds_format_integer(self.completeSize, input_name='completeSize'), namespace_, eol_))
        if self.compress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scompress>%s</%scompress>%s' % (namespace_, self.gds_format_boolean(self.compress, input_name='compress'), namespace_, eol_))
        if self.credAccount is not None:
            self.credAccount.export(outfile, level, namespace_, name_='credAccount', pretty_print=pretty_print)
        if self.disableRootPassword is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisableRootPassword>%s</%sdisableRootPassword>%s' % (namespace_, self.gds_format_boolean(self.disableRootPassword, input_name='disableRootPassword'), namespace_, eol_))
        if self.downloadKey is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdownloadKey>%s</%sdownloadKey>%s' % (namespace_, self.gds_format_string(quote_xml(self.downloadKey).encode(ExternalEncoding), input_name='downloadKey'), namespace_, eol_))
        if self.downloadUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdownloadUri>%s</%sdownloadUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.downloadUri).encode(ExternalEncoding), input_name='downloadUri'), namespace_, eol_))
        if self.ebs is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sebs>%s</%sebs>%s' % (namespace_, self.gds_format_boolean(self.ebs, input_name='ebs'), namespace_, eol_))
        if self.ebsVolumeSize is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sebsVolumeSize>%s</%sebsVolumeSize>%s' % (namespace_, self.gds_format_integer(self.ebsVolumeSize, input_name='ebsVolumeSize'), namespace_, eol_))
        if self.fileExtension is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfileExtension>%s</%sfileExtension>%s' % (namespace_, self.gds_format_string(quote_xml(self.fileExtension).encode(ExternalEncoding), input_name='fileExtension'), namespace_, eol_))
        if self.fileName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfileName>%s</%sfileName>%s' % (namespace_, self.gds_format_string(quote_xml(self.fileName).encode(ExternalEncoding), input_name='fileName'), namespace_, eol_))
        if self.fileSize is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfileSize>%s</%sfileSize>%s' % (namespace_, self.gds_format_integer(self.fileSize, input_name='fileSize'), namespace_, eol_))
        if self.format is not None:
            self.format.export(outfile, level, namespace_, name_='format', pretty_print=pretty_print)
        if self.fullName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfullName>%s</%sfullName>%s' % (namespace_, self.gds_format_string(quote_xml(self.fullName).encode(ExternalEncoding), input_name='fullName'), namespace_, eol_))
        if self.imageCreated is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%simageCreated>%s</%simageCreated>%s' % (namespace_, self.gds_format_boolean(self.imageCreated, input_name='imageCreated'), namespace_, eol_))
        if self.installProfile is not None:
            self.installProfile.export(outfile, level, namespace_, name_='installProfile', pretty_print=pretty_print)
        if self.orgUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorgUri>%s</%sorgUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.orgUri).encode(ExternalEncoding), input_name='orgUri'), namespace_, eol_))
        if self.pkgsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spkgsUri>%s</%spkgsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.pkgsUri).encode(ExternalEncoding), input_name='pkgsUri'), namespace_, eol_))
        if self.publicAccess is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spublicAccess>%s</%spublicAccess>%s' % (namespace_, self.gds_format_boolean(self.publicAccess, input_name='publicAccess'), namespace_, eol_))
        if self.registeredCredAccount is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sregisteredCredAccount>%s</%sregisteredCredAccount>%s' % (namespace_, self.gds_format_boolean(self.registeredCredAccount, input_name='registeredCredAccount'), namespace_, eol_))
        if self.revision is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srevision>%s</%srevision>%s' % (namespace_, self.gds_format_integer(self.revision, input_name='revision'), namespace_, eol_))
        if self.simulated is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssimulated>%s</%ssimulated>%s' % (namespace_, self.gds_format_boolean(self.simulated, input_name='simulated'), namespace_, eol_))
        if self.statusUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstatusUri>%s</%sstatusUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.statusUri).encode(ExternalEncoding), input_name='statusUri'), namespace_, eol_))
        if self.tag is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stag>%s</%stag>%s' % (namespace_, self.gds_format_string(quote_xml(self.tag).encode(ExternalEncoding), input_name='tag'), namespace_, eol_))
        if self.updateTools is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%supdateTools>%s</%supdateTools>%s' % (namespace_, self.gds_format_boolean(self.updateTools, input_name='updateTools'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
        if self.version is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sversion>%s</%sversion>%s' % (namespace_, self.gds_format_string(quote_xml(self.version).encode(ExternalEncoding), input_name='version'), namespace_, eol_))
        if self.vmDiskSize is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svmDiskSize>%s</%svmDiskSize>%s' % (namespace_, self.gds_format_integer(self.vmDiskSize, input_name='vmDiskSize'), namespace_, eol_))
        if self.vmMemorySize is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svmMemorySize>%s</%svmMemorySize>%s' % (namespace_, self.gds_format_integer(self.vmMemorySize, input_name='vmMemorySize'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='image'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(image, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(image, self).exportLiteralChildren(outfile, level, name_)
        if self.applianceUri is not None:
            showIndent(outfile, level)
            outfile.write('applianceUri=%s,\n' % quote_python(self.applianceUri).encode(ExternalEncoding))
        if self.basePublishImagesUri is not None:
            showIndent(outfile, level)
            outfile.write('basePublishImagesUri=%s,\n' % quote_python(self.basePublishImagesUri).encode(ExternalEncoding))
        if self.completeInstalledSize is not None:
            showIndent(outfile, level)
            outfile.write('completeInstalledSize=%d,\n' % self.completeInstalledSize)
        if self.completeSize is not None:
            showIndent(outfile, level)
            outfile.write('completeSize=%d,\n' % self.completeSize)
        if self.compress is not None:
            showIndent(outfile, level)
            outfile.write('compress=%s,\n' % self.compress)
        if self.credAccount is not None:
            showIndent(outfile, level)
            outfile.write('credAccount=model_.credAccount(\n')
            self.credAccount.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.disableRootPassword is not None:
            showIndent(outfile, level)
            outfile.write('disableRootPassword=%s,\n' % self.disableRootPassword)
        if self.downloadKey is not None:
            showIndent(outfile, level)
            outfile.write('downloadKey=%s,\n' % quote_python(self.downloadKey).encode(ExternalEncoding))
        if self.downloadUri is not None:
            showIndent(outfile, level)
            outfile.write('downloadUri=%s,\n' % quote_python(self.downloadUri).encode(ExternalEncoding))
        if self.ebs is not None:
            showIndent(outfile, level)
            outfile.write('ebs=%s,\n' % self.ebs)
        if self.ebsVolumeSize is not None:
            showIndent(outfile, level)
            outfile.write('ebsVolumeSize=%d,\n' % self.ebsVolumeSize)
        if self.fileExtension is not None:
            showIndent(outfile, level)
            outfile.write('fileExtension=%s,\n' % quote_python(self.fileExtension).encode(ExternalEncoding))
        if self.fileName is not None:
            showIndent(outfile, level)
            outfile.write('fileName=%s,\n' % quote_python(self.fileName).encode(ExternalEncoding))
        if self.fileSize is not None:
            showIndent(outfile, level)
            outfile.write('fileSize=%d,\n' % self.fileSize)
        if self.format is not None:
            showIndent(outfile, level)
            outfile.write('format=model_.imageFormat(\n')
            self.format.exportLiteral(outfile, level, name_='format')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.fullName is not None:
            showIndent(outfile, level)
            outfile.write('fullName=%s,\n' % quote_python(self.fullName).encode(ExternalEncoding))
        if self.imageCreated is not None:
            showIndent(outfile, level)
            outfile.write('imageCreated=%s,\n' % self.imageCreated)
        if self.installProfile is not None:
            showIndent(outfile, level)
            outfile.write('installProfile=model_.installProfile(\n')
            self.installProfile.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.orgUri is not None:
            showIndent(outfile, level)
            outfile.write('orgUri=%s,\n' % quote_python(self.orgUri).encode(ExternalEncoding))
        if self.pkgsUri is not None:
            showIndent(outfile, level)
            outfile.write('pkgsUri=%s,\n' % quote_python(self.pkgsUri).encode(ExternalEncoding))
        if self.publicAccess is not None:
            showIndent(outfile, level)
            outfile.write('publicAccess=%s,\n' % self.publicAccess)
        if self.registeredCredAccount is not None:
            showIndent(outfile, level)
            outfile.write('registeredCredAccount=%s,\n' % self.registeredCredAccount)
        if self.revision is not None:
            showIndent(outfile, level)
            outfile.write('revision=%d,\n' % self.revision)
        if self.simulated is not None:
            showIndent(outfile, level)
            outfile.write('simulated=%s,\n' % self.simulated)
        if self.statusUri is not None:
            showIndent(outfile, level)
            outfile.write('statusUri=%s,\n' % quote_python(self.statusUri).encode(ExternalEncoding))
        if self.tag is not None:
            showIndent(outfile, level)
            outfile.write('tag=%s,\n' % quote_python(self.tag).encode(ExternalEncoding))
        if self.updateTools is not None:
            showIndent(outfile, level)
            outfile.write('updateTools=%s,\n' % self.updateTools)
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version=%s,\n' % quote_python(self.version).encode(ExternalEncoding))
        if self.vmDiskSize is not None:
            showIndent(outfile, level)
            outfile.write('vmDiskSize=%d,\n' % self.vmDiskSize)
        if self.vmMemorySize is not None:
            showIndent(outfile, level)
            outfile.write('vmMemorySize=%d,\n' % self.vmMemorySize)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(image, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'applianceUri':
            applianceUri_ = child_.text
            applianceUri_ = self.gds_validate_string(applianceUri_, node, 'applianceUri')
            self.applianceUri = applianceUri_
        elif nodeName_ == 'basePublishImagesUri':
            basePublishImagesUri_ = child_.text
            basePublishImagesUri_ = self.gds_validate_string(basePublishImagesUri_, node, 'basePublishImagesUri')
            self.basePublishImagesUri = basePublishImagesUri_
        elif nodeName_ == 'completeInstalledSize':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'completeInstalledSize')
            self.completeInstalledSize = ival_
        elif nodeName_ == 'completeSize':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'completeSize')
            self.completeSize = ival_
        elif nodeName_ == 'compress':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'compress')
            self.compress = ival_
        elif nodeName_ == 'credAccount':
            obj_ = credAccount.factory()
            obj_.build(child_)
            self.credAccount = obj_
        elif nodeName_ == 'disableRootPassword':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'disableRootPassword')
            self.disableRootPassword = ival_
        elif nodeName_ == 'downloadKey':
            downloadKey_ = child_.text
            downloadKey_ = self.gds_validate_string(downloadKey_, node, 'downloadKey')
            self.downloadKey = downloadKey_
        elif nodeName_ == 'downloadUri':
            downloadUri_ = child_.text
            downloadUri_ = self.gds_validate_string(downloadUri_, node, 'downloadUri')
            self.downloadUri = downloadUri_
        elif nodeName_ == 'ebs':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'ebs')
            self.ebs = ival_
        elif nodeName_ == 'ebsVolumeSize':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'ebsVolumeSize')
            self.ebsVolumeSize = ival_
        elif nodeName_ == 'fileExtension':
            fileExtension_ = child_.text
            fileExtension_ = self.gds_validate_string(fileExtension_, node, 'fileExtension')
            self.fileExtension = fileExtension_
        elif nodeName_ == 'fileName':
            fileName_ = child_.text
            fileName_ = self.gds_validate_string(fileName_, node, 'fileName')
            self.fileName = fileName_
        elif nodeName_ == 'fileSize':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'fileSize')
            self.fileSize = ival_
        elif nodeName_ == 'format':
            obj_ = imageFormat.factory()
            obj_.build(child_)
            self.format = obj_
        elif nodeName_ == 'fullName':
            fullName_ = child_.text
            fullName_ = self.gds_validate_string(fullName_, node, 'fullName')
            self.fullName = fullName_
        elif nodeName_ == 'imageCreated':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'imageCreated')
            self.imageCreated = ival_
        elif nodeName_ == 'installProfile':
            obj_ = installProfile.factory()
            obj_.build(child_)
            self.installProfile = obj_
        elif nodeName_ == 'orgUri':
            orgUri_ = child_.text
            orgUri_ = self.gds_validate_string(orgUri_, node, 'orgUri')
            self.orgUri = orgUri_
        elif nodeName_ == 'pkgsUri':
            pkgsUri_ = child_.text
            pkgsUri_ = self.gds_validate_string(pkgsUri_, node, 'pkgsUri')
            self.pkgsUri = pkgsUri_
        elif nodeName_ == 'publicAccess':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'publicAccess')
            self.publicAccess = ival_
        elif nodeName_ == 'registeredCredAccount':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'registeredCredAccount')
            self.registeredCredAccount = ival_
        elif nodeName_ == 'revision':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'revision')
            self.revision = ival_
        elif nodeName_ == 'simulated':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'simulated')
            self.simulated = ival_
        elif nodeName_ == 'statusUri':
            statusUri_ = child_.text
            statusUri_ = self.gds_validate_string(statusUri_, node, 'statusUri')
            self.statusUri = statusUri_
        elif nodeName_ == 'tag':
            tag_ = child_.text
            tag_ = self.gds_validate_string(tag_, node, 'tag')
            self.tag = tag_
        elif nodeName_ == 'updateTools':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'updateTools')
            self.updateTools = ival_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'version':
            version_ = child_.text
            version_ = self.gds_validate_string(version_, node, 'version')
            self.version = version_
        elif nodeName_ == 'vmDiskSize':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'vmDiskSize')
            self.vmDiskSize = ival_
        elif nodeName_ == 'vmMemorySize':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'vmMemorySize')
            self.vmMemorySize = ival_
        super(image, self).buildChildren(child_, node, nodeName_, True)
# end class image


class credAccount(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, accessKeyID=None, accountNumber=None, baseCertificatesUri=None, bucket=None, catalogId=None, category=None, certificateUris=None, certificates=None, clusterName=None, datacenterName=None, datastore=None, datastorePath=None, description=None, displayName=None, ec2Url=None, email=None, esxHost=None, featuredEnabled=None, hostname=None, imageVersion=None, kernelAuto=None, kernelId=None, keyPairName=None, keystoneUrl=None, listName=None, login=None, network=None, organizationName=None, parentUri=None, password=None, passwordEnabled=None, port=None, prodUUID=None, proxyHost=None, proxyPort=None, publicAPIKey=None, publicImage=None, ramdiskId=None, s3Url=None, secretAPIKey=None, secretAccessKeyID=None, serverUrl=None, tenantName=None, type_=None, uri=None, userUUID=None, vdcId=None, wsdlLocation=None, zoneName=None):
        super(credAccount, self).__init__(created, dbId, digest, lastModified, name, )
        self.accessKeyID = accessKeyID
        self.accountNumber = accountNumber
        self.baseCertificatesUri = baseCertificatesUri
        self.bucket = bucket
        self.catalogId = catalogId
        self.category = category
        self.certificateUris = certificateUris
        self.certificates = certificates
        self.clusterName = clusterName
        self.datacenterName = datacenterName
        self.datastore = datastore
        self.datastorePath = datastorePath
        self.description = description
        self.displayName = displayName
        self.ec2Url = ec2Url
        self.email = email
        self.esxHost = esxHost
        self.featuredEnabled = featuredEnabled
        self.hostname = hostname
        self.imageVersion = imageVersion
        self.kernelAuto = kernelAuto
        self.kernelId = kernelId
        self.keyPairName = keyPairName
        self.keystoneUrl = keystoneUrl
        self.listName = listName
        self.login = login
        self.network = network
        self.organizationName = organizationName
        self.parentUri = parentUri
        self.password = password
        self.passwordEnabled = passwordEnabled
        self.port = port
        self.prodUUID = prodUUID
        self.proxyHost = proxyHost
        self.proxyPort = proxyPort
        self.publicAPIKey = publicAPIKey
        self.publicImage = publicImage
        self.ramdiskId = ramdiskId
        self.s3Url = s3Url
        self.secretAPIKey = secretAPIKey
        self.secretAccessKeyID = secretAccessKeyID
        self.serverUrl = serverUrl
        self.tenantName = tenantName
        self.type_ = type_
        self.uri = uri
        self.userUUID = userUUID
        self.vdcId = vdcId
        self.wsdlLocation = wsdlLocation
        self.zoneName = zoneName
    def factory(*args_, **kwargs_):
        if credAccount.subclass:
            return credAccount.subclass(*args_, **kwargs_)
        else:
            return credAccount(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_accessKeyID(self): return self.accessKeyID
    def set_accessKeyID(self, accessKeyID): self.accessKeyID = accessKeyID
    def get_accountNumber(self): return self.accountNumber
    def set_accountNumber(self, accountNumber): self.accountNumber = accountNumber
    def get_baseCertificatesUri(self): return self.baseCertificatesUri
    def set_baseCertificatesUri(self, baseCertificatesUri): self.baseCertificatesUri = baseCertificatesUri
    def get_bucket(self): return self.bucket
    def set_bucket(self, bucket): self.bucket = bucket
    def get_catalogId(self): return self.catalogId
    def set_catalogId(self, catalogId): self.catalogId = catalogId
    def get_category(self): return self.category
    def set_category(self, category): self.category = category
    def get_certificateUris(self): return self.certificateUris
    def set_certificateUris(self, certificateUris): self.certificateUris = certificateUris
    def get_certificates(self): return self.certificates
    def set_certificates(self, certificates): self.certificates = certificates
    def get_clusterName(self): return self.clusterName
    def set_clusterName(self, clusterName): self.clusterName = clusterName
    def get_datacenterName(self): return self.datacenterName
    def set_datacenterName(self, datacenterName): self.datacenterName = datacenterName
    def get_datastore(self): return self.datastore
    def set_datastore(self, datastore): self.datastore = datastore
    def get_datastorePath(self): return self.datastorePath
    def set_datastorePath(self, datastorePath): self.datastorePath = datastorePath
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_displayName(self): return self.displayName
    def set_displayName(self, displayName): self.displayName = displayName
    def get_ec2Url(self): return self.ec2Url
    def set_ec2Url(self, ec2Url): self.ec2Url = ec2Url
    def get_email(self): return self.email
    def set_email(self, email): self.email = email
    def get_esxHost(self): return self.esxHost
    def set_esxHost(self, esxHost): self.esxHost = esxHost
    def get_featuredEnabled(self): return self.featuredEnabled
    def set_featuredEnabled(self, featuredEnabled): self.featuredEnabled = featuredEnabled
    def get_hostname(self): return self.hostname
    def set_hostname(self, hostname): self.hostname = hostname
    def get_imageVersion(self): return self.imageVersion
    def set_imageVersion(self, imageVersion): self.imageVersion = imageVersion
    def get_kernelAuto(self): return self.kernelAuto
    def set_kernelAuto(self, kernelAuto): self.kernelAuto = kernelAuto
    def get_kernelId(self): return self.kernelId
    def set_kernelId(self, kernelId): self.kernelId = kernelId
    def get_keyPairName(self): return self.keyPairName
    def set_keyPairName(self, keyPairName): self.keyPairName = keyPairName
    def get_keystoneUrl(self): return self.keystoneUrl
    def set_keystoneUrl(self, keystoneUrl): self.keystoneUrl = keystoneUrl
    def get_listName(self): return self.listName
    def set_listName(self, listName): self.listName = listName
    def get_login(self): return self.login
    def set_login(self, login): self.login = login
    def get_network(self): return self.network
    def set_network(self, network): self.network = network
    def get_organizationName(self): return self.organizationName
    def set_organizationName(self, organizationName): self.organizationName = organizationName
    def get_parentUri(self): return self.parentUri
    def set_parentUri(self, parentUri): self.parentUri = parentUri
    def get_password(self): return self.password
    def set_password(self, password): self.password = password
    def get_passwordEnabled(self): return self.passwordEnabled
    def set_passwordEnabled(self, passwordEnabled): self.passwordEnabled = passwordEnabled
    def get_port(self): return self.port
    def set_port(self, port): self.port = port
    def get_prodUUID(self): return self.prodUUID
    def set_prodUUID(self, prodUUID): self.prodUUID = prodUUID
    def get_proxyHost(self): return self.proxyHost
    def set_proxyHost(self, proxyHost): self.proxyHost = proxyHost
    def get_proxyPort(self): return self.proxyPort
    def set_proxyPort(self, proxyPort): self.proxyPort = proxyPort
    def get_publicAPIKey(self): return self.publicAPIKey
    def set_publicAPIKey(self, publicAPIKey): self.publicAPIKey = publicAPIKey
    def get_publicImage(self): return self.publicImage
    def set_publicImage(self, publicImage): self.publicImage = publicImage
    def get_ramdiskId(self): return self.ramdiskId
    def set_ramdiskId(self, ramdiskId): self.ramdiskId = ramdiskId
    def get_s3Url(self): return self.s3Url
    def set_s3Url(self, s3Url): self.s3Url = s3Url
    def get_secretAPIKey(self): return self.secretAPIKey
    def set_secretAPIKey(self, secretAPIKey): self.secretAPIKey = secretAPIKey
    def get_secretAccessKeyID(self): return self.secretAccessKeyID
    def set_secretAccessKeyID(self, secretAccessKeyID): self.secretAccessKeyID = secretAccessKeyID
    def get_serverUrl(self): return self.serverUrl
    def set_serverUrl(self, serverUrl): self.serverUrl = serverUrl
    def get_tenantName(self): return self.tenantName
    def set_tenantName(self, tenantName): self.tenantName = tenantName
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_userUUID(self): return self.userUUID
    def set_userUUID(self, userUUID): self.userUUID = userUUID
    def get_vdcId(self): return self.vdcId
    def set_vdcId(self, vdcId): self.vdcId = vdcId
    def get_wsdlLocation(self): return self.wsdlLocation
    def set_wsdlLocation(self, wsdlLocation): self.wsdlLocation = wsdlLocation
    def get_zoneName(self): return self.zoneName
    def set_zoneName(self, zoneName): self.zoneName = zoneName
    def hasContent_(self):
        if (
            self.accessKeyID is not None or
            self.accountNumber is not None or
            self.baseCertificatesUri is not None or
            self.bucket is not None or
            self.catalogId is not None or
            self.category is not None or
            self.certificateUris is not None or
            self.certificates is not None or
            self.clusterName is not None or
            self.datacenterName is not None or
            self.datastore is not None or
            self.datastorePath is not None or
            self.description is not None or
            self.displayName is not None or
            self.ec2Url is not None or
            self.email is not None or
            self.esxHost is not None or
            self.featuredEnabled is not None or
            self.hostname is not None or
            self.imageVersion is not None or
            self.kernelAuto is not None or
            self.kernelId is not None or
            self.keyPairName is not None or
            self.keystoneUrl is not None or
            self.listName is not None or
            self.login is not None or
            self.network is not None or
            self.organizationName is not None or
            self.parentUri is not None or
            self.password is not None or
            self.passwordEnabled is not None or
            self.port is not None or
            self.prodUUID is not None or
            self.proxyHost is not None or
            self.proxyPort is not None or
            self.publicAPIKey is not None or
            self.publicImage is not None or
            self.ramdiskId is not None or
            self.s3Url is not None or
            self.secretAPIKey is not None or
            self.secretAccessKeyID is not None or
            self.serverUrl is not None or
            self.tenantName is not None or
            self.type_ is not None or
            self.uri is not None or
            self.userUUID is not None or
            self.vdcId is not None or
            self.wsdlLocation is not None or
            self.zoneName is not None or
            super(credAccount, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='credAccount', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='credAccount')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='credAccount'):
        super(credAccount, self).exportAttributes(outfile, level, already_processed, namespace_, name_='credAccount')
    def exportChildren(self, outfile, level, namespace_='', name_='credAccount', fromsubclass_=False, pretty_print=True):
        super(credAccount, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.accessKeyID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saccessKeyID>%s</%saccessKeyID>%s' % (namespace_, self.gds_format_string(quote_xml(self.accessKeyID).encode(ExternalEncoding), input_name='accessKeyID'), namespace_, eol_))
        if self.accountNumber is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saccountNumber>%s</%saccountNumber>%s' % (namespace_, self.gds_format_string(quote_xml(self.accountNumber).encode(ExternalEncoding), input_name='accountNumber'), namespace_, eol_))
        if self.baseCertificatesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseCertificatesUri>%s</%sbaseCertificatesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseCertificatesUri).encode(ExternalEncoding), input_name='baseCertificatesUri'), namespace_, eol_))
        if self.bucket is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbucket>%s</%sbucket>%s' % (namespace_, self.gds_format_string(quote_xml(self.bucket).encode(ExternalEncoding), input_name='bucket'), namespace_, eol_))
        if self.catalogId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scatalogId>%s</%scatalogId>%s' % (namespace_, self.gds_format_string(quote_xml(self.catalogId).encode(ExternalEncoding), input_name='catalogId'), namespace_, eol_))
        if self.category is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scategory>%s</%scategory>%s' % (namespace_, self.gds_format_string(quote_xml(self.category).encode(ExternalEncoding), input_name='category'), namespace_, eol_))
        if self.certificateUris is not None:
            self.certificateUris.export(outfile, level, namespace_, name_='certificateUris', pretty_print=pretty_print)
        if self.certificates is not None:
            self.certificates.export(outfile, level, namespace_, name_='certificates', pretty_print=pretty_print)
        if self.clusterName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sclusterName>%s</%sclusterName>%s' % (namespace_, self.gds_format_string(quote_xml(self.clusterName).encode(ExternalEncoding), input_name='clusterName'), namespace_, eol_))
        if self.datacenterName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdatacenterName>%s</%sdatacenterName>%s' % (namespace_, self.gds_format_string(quote_xml(self.datacenterName).encode(ExternalEncoding), input_name='datacenterName'), namespace_, eol_))
        if self.datastore is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdatastore>%s</%sdatastore>%s' % (namespace_, self.gds_format_string(quote_xml(self.datastore).encode(ExternalEncoding), input_name='datastore'), namespace_, eol_))
        if self.datastorePath is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdatastorePath>%s</%sdatastorePath>%s' % (namespace_, self.gds_format_string(quote_xml(self.datastorePath).encode(ExternalEncoding), input_name='datastorePath'), namespace_, eol_))
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_, eol_))
        if self.displayName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisplayName>%s</%sdisplayName>%s' % (namespace_, self.gds_format_string(quote_xml(self.displayName).encode(ExternalEncoding), input_name='displayName'), namespace_, eol_))
        if self.ec2Url is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sec2Url>%s</%sec2Url>%s' % (namespace_, self.gds_format_string(quote_xml(self.ec2Url).encode(ExternalEncoding), input_name='ec2Url'), namespace_, eol_))
        if self.email is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%semail>%s</%semail>%s' % (namespace_, self.gds_format_string(quote_xml(self.email).encode(ExternalEncoding), input_name='email'), namespace_, eol_))
        if self.esxHost is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sesxHost>%s</%sesxHost>%s' % (namespace_, self.gds_format_string(quote_xml(self.esxHost).encode(ExternalEncoding), input_name='esxHost'), namespace_, eol_))
        if self.featuredEnabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfeaturedEnabled>%s</%sfeaturedEnabled>%s' % (namespace_, self.gds_format_boolean(self.featuredEnabled, input_name='featuredEnabled'), namespace_, eol_))
        if self.hostname is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shostname>%s</%shostname>%s' % (namespace_, self.gds_format_string(quote_xml(self.hostname).encode(ExternalEncoding), input_name='hostname'), namespace_, eol_))
        if self.imageVersion is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%simageVersion>%s</%simageVersion>%s' % (namespace_, self.gds_format_string(quote_xml(self.imageVersion).encode(ExternalEncoding), input_name='imageVersion'), namespace_, eol_))
        if self.kernelAuto is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skernelAuto>%s</%skernelAuto>%s' % (namespace_, self.gds_format_boolean(self.kernelAuto, input_name='kernelAuto'), namespace_, eol_))
        if self.kernelId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skernelId>%s</%skernelId>%s' % (namespace_, self.gds_format_string(quote_xml(self.kernelId).encode(ExternalEncoding), input_name='kernelId'), namespace_, eol_))
        if self.keyPairName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skeyPairName>%s</%skeyPairName>%s' % (namespace_, self.gds_format_string(quote_xml(self.keyPairName).encode(ExternalEncoding), input_name='keyPairName'), namespace_, eol_))
        if self.keystoneUrl is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skeystoneUrl>%s</%skeystoneUrl>%s' % (namespace_, self.gds_format_string(quote_xml(self.keystoneUrl).encode(ExternalEncoding), input_name='keystoneUrl'), namespace_, eol_))
        if self.listName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slistName>%s</%slistName>%s' % (namespace_, self.gds_format_string(quote_xml(self.listName).encode(ExternalEncoding), input_name='listName'), namespace_, eol_))
        if self.login is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slogin>%s</%slogin>%s' % (namespace_, self.gds_format_string(quote_xml(self.login).encode(ExternalEncoding), input_name='login'), namespace_, eol_))
        if self.network is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snetwork>%s</%snetwork>%s' % (namespace_, self.gds_format_string(quote_xml(self.network).encode(ExternalEncoding), input_name='network'), namespace_, eol_))
        if self.organizationName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorganizationName>%s</%sorganizationName>%s' % (namespace_, self.gds_format_string(quote_xml(self.organizationName).encode(ExternalEncoding), input_name='organizationName'), namespace_, eol_))
        if self.parentUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparentUri>%s</%sparentUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.parentUri).encode(ExternalEncoding), input_name='parentUri'), namespace_, eol_))
        if self.password is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespace_, self.gds_format_string(quote_xml(self.password).encode(ExternalEncoding), input_name='password'), namespace_, eol_))
        if self.passwordEnabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spasswordEnabled>%s</%spasswordEnabled>%s' % (namespace_, self.gds_format_boolean(self.passwordEnabled, input_name='passwordEnabled'), namespace_, eol_))
        if self.port is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sport>%s</%sport>%s' % (namespace_, self.gds_format_integer(self.port, input_name='port'), namespace_, eol_))
        if self.prodUUID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprodUUID>%s</%sprodUUID>%s' % (namespace_, self.gds_format_string(quote_xml(self.prodUUID).encode(ExternalEncoding), input_name='prodUUID'), namespace_, eol_))
        if self.proxyHost is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sproxyHost>%s</%sproxyHost>%s' % (namespace_, self.gds_format_string(quote_xml(self.proxyHost).encode(ExternalEncoding), input_name='proxyHost'), namespace_, eol_))
        if self.proxyPort is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sproxyPort>%s</%sproxyPort>%s' % (namespace_, self.gds_format_integer(self.proxyPort, input_name='proxyPort'), namespace_, eol_))
        if self.publicAPIKey is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spublicAPIKey>%s</%spublicAPIKey>%s' % (namespace_, self.gds_format_string(quote_xml(self.publicAPIKey).encode(ExternalEncoding), input_name='publicAPIKey'), namespace_, eol_))
        if self.publicImage is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spublicImage>%s</%spublicImage>%s' % (namespace_, self.gds_format_boolean(self.publicImage, input_name='publicImage'), namespace_, eol_))
        if self.ramdiskId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sramdiskId>%s</%sramdiskId>%s' % (namespace_, self.gds_format_string(quote_xml(self.ramdiskId).encode(ExternalEncoding), input_name='ramdiskId'), namespace_, eol_))
        if self.s3Url is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ss3Url>%s</%ss3Url>%s' % (namespace_, self.gds_format_string(quote_xml(self.s3Url).encode(ExternalEncoding), input_name='s3Url'), namespace_, eol_))
        if self.secretAPIKey is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssecretAPIKey>%s</%ssecretAPIKey>%s' % (namespace_, self.gds_format_string(quote_xml(self.secretAPIKey).encode(ExternalEncoding), input_name='secretAPIKey'), namespace_, eol_))
        if self.secretAccessKeyID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssecretAccessKeyID>%s</%ssecretAccessKeyID>%s' % (namespace_, self.gds_format_string(quote_xml(self.secretAccessKeyID).encode(ExternalEncoding), input_name='secretAccessKeyID'), namespace_, eol_))
        if self.serverUrl is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sserverUrl>%s</%sserverUrl>%s' % (namespace_, self.gds_format_string(quote_xml(self.serverUrl).encode(ExternalEncoding), input_name='serverUrl'), namespace_, eol_))
        if self.tenantName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stenantName>%s</%stenantName>%s' % (namespace_, self.gds_format_string(quote_xml(self.tenantName).encode(ExternalEncoding), input_name='tenantName'), namespace_, eol_))
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
        if self.userUUID is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suserUUID>%s</%suserUUID>%s' % (namespace_, self.gds_format_string(quote_xml(self.userUUID).encode(ExternalEncoding), input_name='userUUID'), namespace_, eol_))
        if self.vdcId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svdcId>%s</%svdcId>%s' % (namespace_, self.gds_format_string(quote_xml(self.vdcId).encode(ExternalEncoding), input_name='vdcId'), namespace_, eol_))
        if self.wsdlLocation is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%swsdlLocation>%s</%swsdlLocation>%s' % (namespace_, self.gds_format_string(quote_xml(self.wsdlLocation).encode(ExternalEncoding), input_name='wsdlLocation'), namespace_, eol_))
        if self.zoneName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%szoneName>%s</%szoneName>%s' % (namespace_, self.gds_format_string(quote_xml(self.zoneName).encode(ExternalEncoding), input_name='zoneName'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='credAccount'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(credAccount, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(credAccount, self).exportLiteralChildren(outfile, level, name_)
        if self.accessKeyID is not None:
            showIndent(outfile, level)
            outfile.write('accessKeyID=%s,\n' % quote_python(self.accessKeyID).encode(ExternalEncoding))
        if self.accountNumber is not None:
            showIndent(outfile, level)
            outfile.write('accountNumber=%s,\n' % quote_python(self.accountNumber).encode(ExternalEncoding))
        if self.baseCertificatesUri is not None:
            showIndent(outfile, level)
            outfile.write('baseCertificatesUri=%s,\n' % quote_python(self.baseCertificatesUri).encode(ExternalEncoding))
        if self.bucket is not None:
            showIndent(outfile, level)
            outfile.write('bucket=%s,\n' % quote_python(self.bucket).encode(ExternalEncoding))
        if self.catalogId is not None:
            showIndent(outfile, level)
            outfile.write('catalogId=%s,\n' % quote_python(self.catalogId).encode(ExternalEncoding))
        if self.category is not None:
            showIndent(outfile, level)
            outfile.write('category=%s,\n' % quote_python(self.category).encode(ExternalEncoding))
        if self.certificateUris is not None:
            showIndent(outfile, level)
            outfile.write('certificateUris=model_.uriList(\n')
            self.certificateUris.exportLiteral(outfile, level, name_='certificateUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.certificates is not None:
            showIndent(outfile, level)
            outfile.write('certificates=model_.certificates(\n')
            self.certificates.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.clusterName is not None:
            showIndent(outfile, level)
            outfile.write('clusterName=%s,\n' % quote_python(self.clusterName).encode(ExternalEncoding))
        if self.datacenterName is not None:
            showIndent(outfile, level)
            outfile.write('datacenterName=%s,\n' % quote_python(self.datacenterName).encode(ExternalEncoding))
        if self.datastore is not None:
            showIndent(outfile, level)
            outfile.write('datastore=%s,\n' % quote_python(self.datastore).encode(ExternalEncoding))
        if self.datastorePath is not None:
            showIndent(outfile, level)
            outfile.write('datastorePath=%s,\n' % quote_python(self.datastorePath).encode(ExternalEncoding))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        if self.displayName is not None:
            showIndent(outfile, level)
            outfile.write('displayName=%s,\n' % quote_python(self.displayName).encode(ExternalEncoding))
        if self.ec2Url is not None:
            showIndent(outfile, level)
            outfile.write('ec2Url=%s,\n' % quote_python(self.ec2Url).encode(ExternalEncoding))
        if self.email is not None:
            showIndent(outfile, level)
            outfile.write('email=%s,\n' % quote_python(self.email).encode(ExternalEncoding))
        if self.esxHost is not None:
            showIndent(outfile, level)
            outfile.write('esxHost=%s,\n' % quote_python(self.esxHost).encode(ExternalEncoding))
        if self.featuredEnabled is not None:
            showIndent(outfile, level)
            outfile.write('featuredEnabled=%s,\n' % self.featuredEnabled)
        if self.hostname is not None:
            showIndent(outfile, level)
            outfile.write('hostname=%s,\n' % quote_python(self.hostname).encode(ExternalEncoding))
        if self.imageVersion is not None:
            showIndent(outfile, level)
            outfile.write('imageVersion=%s,\n' % quote_python(self.imageVersion).encode(ExternalEncoding))
        if self.kernelAuto is not None:
            showIndent(outfile, level)
            outfile.write('kernelAuto=%s,\n' % self.kernelAuto)
        if self.kernelId is not None:
            showIndent(outfile, level)
            outfile.write('kernelId=%s,\n' % quote_python(self.kernelId).encode(ExternalEncoding))
        if self.keyPairName is not None:
            showIndent(outfile, level)
            outfile.write('keyPairName=%s,\n' % quote_python(self.keyPairName).encode(ExternalEncoding))
        if self.keystoneUrl is not None:
            showIndent(outfile, level)
            outfile.write('keystoneUrl=%s,\n' % quote_python(self.keystoneUrl).encode(ExternalEncoding))
        if self.listName is not None:
            showIndent(outfile, level)
            outfile.write('listName=%s,\n' % quote_python(self.listName).encode(ExternalEncoding))
        if self.login is not None:
            showIndent(outfile, level)
            outfile.write('login=%s,\n' % quote_python(self.login).encode(ExternalEncoding))
        if self.network is not None:
            showIndent(outfile, level)
            outfile.write('network=%s,\n' % quote_python(self.network).encode(ExternalEncoding))
        if self.organizationName is not None:
            showIndent(outfile, level)
            outfile.write('organizationName=%s,\n' % quote_python(self.organizationName).encode(ExternalEncoding))
        if self.parentUri is not None:
            showIndent(outfile, level)
            outfile.write('parentUri=%s,\n' % quote_python(self.parentUri).encode(ExternalEncoding))
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('password=%s,\n' % quote_python(self.password).encode(ExternalEncoding))
        if self.passwordEnabled is not None:
            showIndent(outfile, level)
            outfile.write('passwordEnabled=%s,\n' % self.passwordEnabled)
        if self.port is not None:
            showIndent(outfile, level)
            outfile.write('port=%d,\n' % self.port)
        if self.prodUUID is not None:
            showIndent(outfile, level)
            outfile.write('prodUUID=%s,\n' % quote_python(self.prodUUID).encode(ExternalEncoding))
        if self.proxyHost is not None:
            showIndent(outfile, level)
            outfile.write('proxyHost=%s,\n' % quote_python(self.proxyHost).encode(ExternalEncoding))
        if self.proxyPort is not None:
            showIndent(outfile, level)
            outfile.write('proxyPort=%d,\n' % self.proxyPort)
        if self.publicAPIKey is not None:
            showIndent(outfile, level)
            outfile.write('publicAPIKey=%s,\n' % quote_python(self.publicAPIKey).encode(ExternalEncoding))
        if self.publicImage is not None:
            showIndent(outfile, level)
            outfile.write('publicImage=%s,\n' % self.publicImage)
        if self.ramdiskId is not None:
            showIndent(outfile, level)
            outfile.write('ramdiskId=%s,\n' % quote_python(self.ramdiskId).encode(ExternalEncoding))
        if self.s3Url is not None:
            showIndent(outfile, level)
            outfile.write('s3Url=%s,\n' % quote_python(self.s3Url).encode(ExternalEncoding))
        if self.secretAPIKey is not None:
            showIndent(outfile, level)
            outfile.write('secretAPIKey=%s,\n' % quote_python(self.secretAPIKey).encode(ExternalEncoding))
        if self.secretAccessKeyID is not None:
            showIndent(outfile, level)
            outfile.write('secretAccessKeyID=%s,\n' % quote_python(self.secretAccessKeyID).encode(ExternalEncoding))
        if self.serverUrl is not None:
            showIndent(outfile, level)
            outfile.write('serverUrl=%s,\n' % quote_python(self.serverUrl).encode(ExternalEncoding))
        if self.tenantName is not None:
            showIndent(outfile, level)
            outfile.write('tenantName=%s,\n' % quote_python(self.tenantName).encode(ExternalEncoding))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.userUUID is not None:
            showIndent(outfile, level)
            outfile.write('userUUID=%s,\n' % quote_python(self.userUUID).encode(ExternalEncoding))
        if self.vdcId is not None:
            showIndent(outfile, level)
            outfile.write('vdcId=%s,\n' % quote_python(self.vdcId).encode(ExternalEncoding))
        if self.wsdlLocation is not None:
            showIndent(outfile, level)
            outfile.write('wsdlLocation=%s,\n' % quote_python(self.wsdlLocation).encode(ExternalEncoding))
        if self.zoneName is not None:
            showIndent(outfile, level)
            outfile.write('zoneName=%s,\n' % quote_python(self.zoneName).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(credAccount, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'accessKeyID':
            accessKeyID_ = child_.text
            accessKeyID_ = self.gds_validate_string(accessKeyID_, node, 'accessKeyID')
            self.accessKeyID = accessKeyID_
        elif nodeName_ == 'accountNumber':
            accountNumber_ = child_.text
            accountNumber_ = self.gds_validate_string(accountNumber_, node, 'accountNumber')
            self.accountNumber = accountNumber_
        elif nodeName_ == 'baseCertificatesUri':
            baseCertificatesUri_ = child_.text
            baseCertificatesUri_ = self.gds_validate_string(baseCertificatesUri_, node, 'baseCertificatesUri')
            self.baseCertificatesUri = baseCertificatesUri_
        elif nodeName_ == 'bucket':
            bucket_ = child_.text
            bucket_ = self.gds_validate_string(bucket_, node, 'bucket')
            self.bucket = bucket_
        elif nodeName_ == 'catalogId':
            catalogId_ = child_.text
            catalogId_ = self.gds_validate_string(catalogId_, node, 'catalogId')
            self.catalogId = catalogId_
        elif nodeName_ == 'category':
            category_ = child_.text
            category_ = self.gds_validate_string(category_, node, 'category')
            self.category = category_
        elif nodeName_ == 'certificateUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.certificateUris = obj_
        elif nodeName_ == 'certificates':
            obj_ = certificates.factory()
            obj_.build(child_)
            self.certificates = obj_
        elif nodeName_ == 'clusterName':
            clusterName_ = child_.text
            clusterName_ = self.gds_validate_string(clusterName_, node, 'clusterName')
            self.clusterName = clusterName_
        elif nodeName_ == 'datacenterName':
            datacenterName_ = child_.text
            datacenterName_ = self.gds_validate_string(datacenterName_, node, 'datacenterName')
            self.datacenterName = datacenterName_
        elif nodeName_ == 'datastore':
            datastore_ = child_.text
            datastore_ = self.gds_validate_string(datastore_, node, 'datastore')
            self.datastore = datastore_
        elif nodeName_ == 'datastorePath':
            datastorePath_ = child_.text
            datastorePath_ = self.gds_validate_string(datastorePath_, node, 'datastorePath')
            self.datastorePath = datastorePath_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'displayName':
            displayName_ = child_.text
            displayName_ = self.gds_validate_string(displayName_, node, 'displayName')
            self.displayName = displayName_
        elif nodeName_ == 'ec2Url':
            ec2Url_ = child_.text
            ec2Url_ = self.gds_validate_string(ec2Url_, node, 'ec2Url')
            self.ec2Url = ec2Url_
        elif nodeName_ == 'email':
            email_ = child_.text
            email_ = self.gds_validate_string(email_, node, 'email')
            self.email = email_
        elif nodeName_ == 'esxHost':
            esxHost_ = child_.text
            esxHost_ = self.gds_validate_string(esxHost_, node, 'esxHost')
            self.esxHost = esxHost_
        elif nodeName_ == 'featuredEnabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'featuredEnabled')
            self.featuredEnabled = ival_
        elif nodeName_ == 'hostname':
            hostname_ = child_.text
            hostname_ = self.gds_validate_string(hostname_, node, 'hostname')
            self.hostname = hostname_
        elif nodeName_ == 'imageVersion':
            imageVersion_ = child_.text
            imageVersion_ = self.gds_validate_string(imageVersion_, node, 'imageVersion')
            self.imageVersion = imageVersion_
        elif nodeName_ == 'kernelAuto':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'kernelAuto')
            self.kernelAuto = ival_
        elif nodeName_ == 'kernelId':
            kernelId_ = child_.text
            kernelId_ = self.gds_validate_string(kernelId_, node, 'kernelId')
            self.kernelId = kernelId_
        elif nodeName_ == 'keyPairName':
            keyPairName_ = child_.text
            keyPairName_ = self.gds_validate_string(keyPairName_, node, 'keyPairName')
            self.keyPairName = keyPairName_
        elif nodeName_ == 'keystoneUrl':
            keystoneUrl_ = child_.text
            keystoneUrl_ = self.gds_validate_string(keystoneUrl_, node, 'keystoneUrl')
            self.keystoneUrl = keystoneUrl_
        elif nodeName_ == 'listName':
            listName_ = child_.text
            listName_ = self.gds_validate_string(listName_, node, 'listName')
            self.listName = listName_
        elif nodeName_ == 'login':
            login_ = child_.text
            login_ = self.gds_validate_string(login_, node, 'login')
            self.login = login_
        elif nodeName_ == 'network':
            network_ = child_.text
            network_ = self.gds_validate_string(network_, node, 'network')
            self.network = network_
        elif nodeName_ == 'organizationName':
            organizationName_ = child_.text
            organizationName_ = self.gds_validate_string(organizationName_, node, 'organizationName')
            self.organizationName = organizationName_
        elif nodeName_ == 'parentUri':
            parentUri_ = child_.text
            parentUri_ = self.gds_validate_string(parentUri_, node, 'parentUri')
            self.parentUri = parentUri_
        elif nodeName_ == 'password':
            password_ = child_.text
            password_ = self.gds_validate_string(password_, node, 'password')
            self.password = password_
        elif nodeName_ == 'passwordEnabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'passwordEnabled')
            self.passwordEnabled = ival_
        elif nodeName_ == 'port':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'port')
            self.port = ival_
        elif nodeName_ == 'prodUUID':
            prodUUID_ = child_.text
            prodUUID_ = self.gds_validate_string(prodUUID_, node, 'prodUUID')
            self.prodUUID = prodUUID_
        elif nodeName_ == 'proxyHost':
            proxyHost_ = child_.text
            proxyHost_ = self.gds_validate_string(proxyHost_, node, 'proxyHost')
            self.proxyHost = proxyHost_
        elif nodeName_ == 'proxyPort':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'proxyPort')
            self.proxyPort = ival_
        elif nodeName_ == 'publicAPIKey':
            publicAPIKey_ = child_.text
            publicAPIKey_ = self.gds_validate_string(publicAPIKey_, node, 'publicAPIKey')
            self.publicAPIKey = publicAPIKey_
        elif nodeName_ == 'publicImage':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'publicImage')
            self.publicImage = ival_
        elif nodeName_ == 'ramdiskId':
            ramdiskId_ = child_.text
            ramdiskId_ = self.gds_validate_string(ramdiskId_, node, 'ramdiskId')
            self.ramdiskId = ramdiskId_
        elif nodeName_ == 's3Url':
            s3Url_ = child_.text
            s3Url_ = self.gds_validate_string(s3Url_, node, 's3Url')
            self.s3Url = s3Url_
        elif nodeName_ == 'secretAPIKey':
            secretAPIKey_ = child_.text
            secretAPIKey_ = self.gds_validate_string(secretAPIKey_, node, 'secretAPIKey')
            self.secretAPIKey = secretAPIKey_
        elif nodeName_ == 'secretAccessKeyID':
            secretAccessKeyID_ = child_.text
            secretAccessKeyID_ = self.gds_validate_string(secretAccessKeyID_, node, 'secretAccessKeyID')
            self.secretAccessKeyID = secretAccessKeyID_
        elif nodeName_ == 'serverUrl':
            serverUrl_ = child_.text
            serverUrl_ = self.gds_validate_string(serverUrl_, node, 'serverUrl')
            self.serverUrl = serverUrl_
        elif nodeName_ == 'tenantName':
            tenantName_ = child_.text
            tenantName_ = self.gds_validate_string(tenantName_, node, 'tenantName')
            self.tenantName = tenantName_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'userUUID':
            userUUID_ = child_.text
            userUUID_ = self.gds_validate_string(userUUID_, node, 'userUUID')
            self.userUUID = userUUID_
        elif nodeName_ == 'vdcId':
            vdcId_ = child_.text
            vdcId_ = self.gds_validate_string(vdcId_, node, 'vdcId')
            self.vdcId = vdcId_
        elif nodeName_ == 'wsdlLocation':
            wsdlLocation_ = child_.text
            wsdlLocation_ = self.gds_validate_string(wsdlLocation_, node, 'wsdlLocation')
            self.wsdlLocation = wsdlLocation_
        elif nodeName_ == 'zoneName':
            zoneName_ = child_.text
            zoneName_ = self.gds_validate_string(zoneName_, node, 'zoneName')
            self.zoneName = zoneName_
        super(credAccount, self).buildChildren(child_, node, nodeName_, True)
# end class credAccount


class certificates(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, certificate=None):
        if certificate is None:
            self.certificate = []
        else:
            self.certificate = certificate
    def factory(*args_, **kwargs_):
        if certificates.subclass:
            return certificates.subclass(*args_, **kwargs_)
        else:
            return certificates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_certificate(self): return self.certificate
    def set_certificate(self, certificate): self.certificate = certificate
    def add_certificate(self, value): self.certificate.append(value)
    def insert_certificate(self, index, value): self.certificate[index] = value
    def hasContent_(self):
        if (
            self.certificate
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='certificates', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='certificates')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='certificates'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='certificates', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for certificate_ in self.certificate:
            certificate_.export(outfile, level, namespace_, name_='certificate', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='certificates'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('certificate=[\n')
        level += 1
        for certificate_ in self.certificate:
            showIndent(outfile, level)
            outfile.write('model_.certificate(\n')
            certificate_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'certificate':
            obj_ = certificate.factory()
            obj_.build(child_)
            self.certificate.append(obj_)
# end class certificates


class certificate(uForgeUploadObject):
    subclass = None
    superclass = uForgeUploadObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, md5sum=None, mimeType=None, sha256sum=None, size=None, status=None, uploaded=None, uploadedTime=None, certStr=None, parentUri=None, type_=None, uri=None):
        super(certificate, self).__init__(created, dbId, digest, lastModified, name, md5sum, mimeType, sha256sum, size, status, uploaded, uploadedTime, )
        self.certStr = certStr
        self.parentUri = parentUri
        self.type_ = type_
        self.uri = uri
    def factory(*args_, **kwargs_):
        if certificate.subclass:
            return certificate.subclass(*args_, **kwargs_)
        else:
            return certificate(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_certStr(self): return self.certStr
    def set_certStr(self, certStr): self.certStr = certStr
    def get_parentUri(self): return self.parentUri
    def set_parentUri(self, parentUri): self.parentUri = parentUri
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def hasContent_(self):
        if (
            self.certStr is not None or
            self.parentUri is not None or
            self.type_ is not None or
            self.uri is not None or
            super(certificate, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='certificate', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='certificate')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='certificate'):
        super(certificate, self).exportAttributes(outfile, level, already_processed, namespace_, name_='certificate')
    def exportChildren(self, outfile, level, namespace_='', name_='certificate', fromsubclass_=False, pretty_print=True):
        super(certificate, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.certStr is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scertStr>%s</%scertStr>%s' % (namespace_, self.gds_format_string(quote_xml(self.certStr).encode(ExternalEncoding), input_name='certStr'), namespace_, eol_))
        if self.parentUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparentUri>%s</%sparentUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.parentUri).encode(ExternalEncoding), input_name='parentUri'), namespace_, eol_))
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='certificate'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(certificate, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(certificate, self).exportLiteralChildren(outfile, level, name_)
        if self.certStr is not None:
            showIndent(outfile, level)
            outfile.write('certStr=%s,\n' % quote_python(self.certStr).encode(ExternalEncoding))
        if self.parentUri is not None:
            showIndent(outfile, level)
            outfile.write('parentUri=%s,\n' % quote_python(self.parentUri).encode(ExternalEncoding))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(certificate, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'certStr':
            certStr_ = child_.text
            certStr_ = self.gds_validate_string(certStr_, node, 'certStr')
            self.certStr = certStr_
        elif nodeName_ == 'parentUri':
            parentUri_ = child_.text
            parentUri_ = self.gds_validate_string(parentUri_, node, 'parentUri')
            self.parentUri = parentUri_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(certificate, self).buildChildren(child_, node, nodeName_, True)
# end class certificate


class installProfile(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, activationKey=None, adminLoginAuto=None, adminPassword=None, adminPasswordAuto=None, applianceUri=None, disableRootPassword=None, diskSize=None, firewallAuto=None, firewallEnabled=None, osgroups=None, groupsUri=None, hwType=None, internetSettingsAuto=None, kernelParameters=None, keyboard=None, keyboardAuto=None, memorySize=None, nics=None, partitionAuto=None, partitionTable=None, rootUser=None, skipLicenses=None, swapSize=None, timezone=None, timezoneAuto=None, timezoneCity=None, updateTools=None, uri=None, osusers=None, usersUri=None, vagrantUser=None, welcomeMsg=None):
        super(installProfile, self).__init__(created, dbId, digest, lastModified, name, )
        self.activationKey = activationKey
        self.adminLoginAuto = adminLoginAuto
        self.adminPassword = adminPassword
        self.adminPasswordAuto = adminPasswordAuto
        self.applianceUri = applianceUri
        self.disableRootPassword = disableRootPassword
        self.diskSize = diskSize
        self.firewallAuto = firewallAuto
        self.firewallEnabled = firewallEnabled
        self.osgroups = osgroups
        self.groupsUri = groupsUri
        self.hwType = hwType
        self.internetSettingsAuto = internetSettingsAuto
        self.kernelParameters = kernelParameters
        self.keyboard = keyboard
        self.keyboardAuto = keyboardAuto
        self.memorySize = memorySize
        self.nics = nics
        self.partitionAuto = partitionAuto
        self.partitionTable = partitionTable
        self.rootUser = rootUser
        self.skipLicenses = skipLicenses
        self.swapSize = swapSize
        self.timezone = timezone
        self.timezoneAuto = timezoneAuto
        self.timezoneCity = timezoneCity
        self.updateTools = updateTools
        self.uri = uri
        self.osusers = osusers
        self.usersUri = usersUri
        self.vagrantUser = vagrantUser
        self.welcomeMsg = welcomeMsg
    def factory(*args_, **kwargs_):
        if installProfile.subclass:
            return installProfile.subclass(*args_, **kwargs_)
        else:
            return installProfile(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_activationKey(self): return self.activationKey
    def set_activationKey(self, activationKey): self.activationKey = activationKey
    def get_adminLoginAuto(self): return self.adminLoginAuto
    def set_adminLoginAuto(self, adminLoginAuto): self.adminLoginAuto = adminLoginAuto
    def get_adminPassword(self): return self.adminPassword
    def set_adminPassword(self, adminPassword): self.adminPassword = adminPassword
    def get_adminPasswordAuto(self): return self.adminPasswordAuto
    def set_adminPasswordAuto(self, adminPasswordAuto): self.adminPasswordAuto = adminPasswordAuto
    def get_applianceUri(self): return self.applianceUri
    def set_applianceUri(self, applianceUri): self.applianceUri = applianceUri
    def get_disableRootPassword(self): return self.disableRootPassword
    def set_disableRootPassword(self, disableRootPassword): self.disableRootPassword = disableRootPassword
    def get_diskSize(self): return self.diskSize
    def set_diskSize(self, diskSize): self.diskSize = diskSize
    def get_firewallAuto(self): return self.firewallAuto
    def set_firewallAuto(self, firewallAuto): self.firewallAuto = firewallAuto
    def get_firewallEnabled(self): return self.firewallEnabled
    def set_firewallEnabled(self, firewallEnabled): self.firewallEnabled = firewallEnabled
    def get_osgroups(self): return self.osgroups
    def set_osgroups(self, osgroups): self.osgroups = osgroups
    def get_groupsUri(self): return self.groupsUri
    def set_groupsUri(self, groupsUri): self.groupsUri = groupsUri
    def get_hwType(self): return self.hwType
    def set_hwType(self, hwType): self.hwType = hwType
    def get_internetSettingsAuto(self): return self.internetSettingsAuto
    def set_internetSettingsAuto(self, internetSettingsAuto): self.internetSettingsAuto = internetSettingsAuto
    def get_kernelParameters(self): return self.kernelParameters
    def set_kernelParameters(self, kernelParameters): self.kernelParameters = kernelParameters
    def get_keyboard(self): return self.keyboard
    def set_keyboard(self, keyboard): self.keyboard = keyboard
    def get_keyboardAuto(self): return self.keyboardAuto
    def set_keyboardAuto(self, keyboardAuto): self.keyboardAuto = keyboardAuto
    def get_memorySize(self): return self.memorySize
    def set_memorySize(self, memorySize): self.memorySize = memorySize
    def get_nics(self): return self.nics
    def set_nics(self, nics): self.nics = nics
    def get_partitionAuto(self): return self.partitionAuto
    def set_partitionAuto(self, partitionAuto): self.partitionAuto = partitionAuto
    def get_partitionTable(self): return self.partitionTable
    def set_partitionTable(self, partitionTable): self.partitionTable = partitionTable
    def get_rootUser(self): return self.rootUser
    def set_rootUser(self, rootUser): self.rootUser = rootUser
    def get_skipLicenses(self): return self.skipLicenses
    def set_skipLicenses(self, skipLicenses): self.skipLicenses = skipLicenses
    def get_swapSize(self): return self.swapSize
    def set_swapSize(self, swapSize): self.swapSize = swapSize
    def get_timezone(self): return self.timezone
    def set_timezone(self, timezone): self.timezone = timezone
    def get_timezoneAuto(self): return self.timezoneAuto
    def set_timezoneAuto(self, timezoneAuto): self.timezoneAuto = timezoneAuto
    def get_timezoneCity(self): return self.timezoneCity
    def set_timezoneCity(self, timezoneCity): self.timezoneCity = timezoneCity
    def get_updateTools(self): return self.updateTools
    def set_updateTools(self, updateTools): self.updateTools = updateTools
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_osusers(self): return self.osusers
    def set_osusers(self, osusers): self.osusers = osusers
    def get_usersUri(self): return self.usersUri
    def set_usersUri(self, usersUri): self.usersUri = usersUri
    def get_vagrantUser(self): return self.vagrantUser
    def set_vagrantUser(self, vagrantUser): self.vagrantUser = vagrantUser
    def get_welcomeMsg(self): return self.welcomeMsg
    def set_welcomeMsg(self, welcomeMsg): self.welcomeMsg = welcomeMsg
    def hasContent_(self):
        if (
            self.activationKey is not None or
            self.adminLoginAuto is not None or
            self.adminPassword is not None or
            self.adminPasswordAuto is not None or
            self.applianceUri is not None or
            self.disableRootPassword is not None or
            self.diskSize is not None or
            self.firewallAuto is not None or
            self.firewallEnabled is not None or
            self.osgroups is not None or
            self.groupsUri is not None or
            self.hwType is not None or
            self.internetSettingsAuto is not None or
            self.kernelParameters is not None or
            self.keyboard is not None or
            self.keyboardAuto is not None or
            self.memorySize is not None or
            self.nics is not None or
            self.partitionAuto is not None or
            self.partitionTable is not None or
            self.rootUser is not None or
            self.skipLicenses is not None or
            self.swapSize is not None or
            self.timezone is not None or
            self.timezoneAuto is not None or
            self.timezoneCity is not None or
            self.updateTools is not None or
            self.uri is not None or
            self.osusers is not None or
            self.usersUri is not None or
            self.vagrantUser is not None or
            self.welcomeMsg is not None or
            super(installProfile, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='installProfile', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='installProfile')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='installProfile'):
        super(installProfile, self).exportAttributes(outfile, level, already_processed, namespace_, name_='installProfile')
    def exportChildren(self, outfile, level, namespace_='', name_='installProfile', fromsubclass_=False, pretty_print=True):
        super(installProfile, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.activationKey is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sactivationKey>%s</%sactivationKey>%s' % (namespace_, self.gds_format_string(quote_xml(self.activationKey).encode(ExternalEncoding), input_name='activationKey'), namespace_, eol_))
        if self.adminLoginAuto is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sadminLoginAuto>%s</%sadminLoginAuto>%s' % (namespace_, self.gds_format_boolean(self.adminLoginAuto, input_name='adminLoginAuto'), namespace_, eol_))
        if self.adminPassword is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sadminPassword>%s</%sadminPassword>%s' % (namespace_, self.gds_format_string(quote_xml(self.adminPassword).encode(ExternalEncoding), input_name='adminPassword'), namespace_, eol_))
        if self.adminPasswordAuto is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sadminPasswordAuto>%s</%sadminPasswordAuto>%s' % (namespace_, self.gds_format_boolean(self.adminPasswordAuto, input_name='adminPasswordAuto'), namespace_, eol_))
        if self.applianceUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sapplianceUri>%s</%sapplianceUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.applianceUri).encode(ExternalEncoding), input_name='applianceUri'), namespace_, eol_))
        if self.disableRootPassword is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisableRootPassword>%s</%sdisableRootPassword>%s' % (namespace_, self.gds_format_boolean(self.disableRootPassword, input_name='disableRootPassword'), namespace_, eol_))
        if self.diskSize is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdiskSize>%s</%sdiskSize>%s' % (namespace_, self.gds_format_integer(self.diskSize, input_name='diskSize'), namespace_, eol_))
        if self.firewallAuto is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfirewallAuto>%s</%sfirewallAuto>%s' % (namespace_, self.gds_format_boolean(self.firewallAuto, input_name='firewallAuto'), namespace_, eol_))
        if self.firewallEnabled is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfirewallEnabled>%s</%sfirewallEnabled>%s' % (namespace_, self.gds_format_boolean(self.firewallEnabled, input_name='firewallEnabled'), namespace_, eol_))
        if self.osgroups is not None:
            self.osgroups.export(outfile, level, namespace_, name_='osgroups', pretty_print=pretty_print)
        if self.groupsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgroupsUri>%s</%sgroupsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.groupsUri).encode(ExternalEncoding), input_name='groupsUri'), namespace_, eol_))
        if self.hwType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shwType>%s</%shwType>%s' % (namespace_, self.gds_format_string(quote_xml(self.hwType).encode(ExternalEncoding), input_name='hwType'), namespace_, eol_))
        if self.internetSettingsAuto is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinternetSettingsAuto>%s</%sinternetSettingsAuto>%s' % (namespace_, self.gds_format_boolean(self.internetSettingsAuto, input_name='internetSettingsAuto'), namespace_, eol_))
        if self.kernelParameters is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skernelParameters>%s</%skernelParameters>%s' % (namespace_, self.gds_format_string(quote_xml(self.kernelParameters).encode(ExternalEncoding), input_name='kernelParameters'), namespace_, eol_))
        if self.keyboard is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skeyboard>%s</%skeyboard>%s' % (namespace_, self.gds_format_string(quote_xml(self.keyboard).encode(ExternalEncoding), input_name='keyboard'), namespace_, eol_))
        if self.keyboardAuto is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skeyboardAuto>%s</%skeyboardAuto>%s' % (namespace_, self.gds_format_boolean(self.keyboardAuto, input_name='keyboardAuto'), namespace_, eol_))
        if self.memorySize is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smemorySize>%s</%smemorySize>%s' % (namespace_, self.gds_format_integer(self.memorySize, input_name='memorySize'), namespace_, eol_))
        if self.nics is not None:
            self.nics.export(outfile, level, namespace_, name_='nics', pretty_print=pretty_print)
        if self.partitionAuto is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spartitionAuto>%s</%spartitionAuto>%s' % (namespace_, self.gds_format_boolean(self.partitionAuto, input_name='partitionAuto'), namespace_, eol_))
        if self.partitionTable is not None:
            self.partitionTable.export(outfile, level, namespace_, name_='partitionTable', pretty_print=pretty_print)
        if self.rootUser is not None:
            self.rootUser.export(outfile, level, namespace_, name_='rootUser', pretty_print=pretty_print)
        if self.skipLicenses is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sskipLicenses>%s</%sskipLicenses>%s' % (namespace_, self.gds_format_boolean(self.skipLicenses, input_name='skipLicenses'), namespace_, eol_))
        if self.swapSize is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sswapSize>%s</%sswapSize>%s' % (namespace_, self.gds_format_integer(self.swapSize, input_name='swapSize'), namespace_, eol_))
        if self.timezone is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stimezone>%s</%stimezone>%s' % (namespace_, self.gds_format_string(quote_xml(self.timezone).encode(ExternalEncoding), input_name='timezone'), namespace_, eol_))
        if self.timezoneAuto is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stimezoneAuto>%s</%stimezoneAuto>%s' % (namespace_, self.gds_format_boolean(self.timezoneAuto, input_name='timezoneAuto'), namespace_, eol_))
        if self.timezoneCity is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stimezoneCity>%s</%stimezoneCity>%s' % (namespace_, self.gds_format_string(quote_xml(self.timezoneCity).encode(ExternalEncoding), input_name='timezoneCity'), namespace_, eol_))
        if self.updateTools is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%supdateTools>%s</%supdateTools>%s' % (namespace_, self.gds_format_boolean(self.updateTools, input_name='updateTools'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
        if self.osusers is not None:
            self.osusers.export(outfile, level, namespace_, name_='osusers', pretty_print=pretty_print)
        if self.usersUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%susersUri>%s</%susersUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.usersUri).encode(ExternalEncoding), input_name='usersUri'), namespace_, eol_))
        if self.vagrantUser is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svagrantUser>%s</%svagrantUser>%s' % (namespace_, self.gds_format_string(quote_xml(self.vagrantUser).encode(ExternalEncoding), input_name='vagrantUser'), namespace_, eol_))
        if self.welcomeMsg is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%swelcomeMsg>%s</%swelcomeMsg>%s' % (namespace_, self.gds_format_string(quote_xml(self.welcomeMsg).encode(ExternalEncoding), input_name='welcomeMsg'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='installProfile'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(installProfile, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(installProfile, self).exportLiteralChildren(outfile, level, name_)
        if self.activationKey is not None:
            showIndent(outfile, level)
            outfile.write('activationKey=%s,\n' % quote_python(self.activationKey).encode(ExternalEncoding))
        if self.adminLoginAuto is not None:
            showIndent(outfile, level)
            outfile.write('adminLoginAuto=%s,\n' % self.adminLoginAuto)
        if self.adminPassword is not None:
            showIndent(outfile, level)
            outfile.write('adminPassword=%s,\n' % quote_python(self.adminPassword).encode(ExternalEncoding))
        if self.adminPasswordAuto is not None:
            showIndent(outfile, level)
            outfile.write('adminPasswordAuto=%s,\n' % self.adminPasswordAuto)
        if self.applianceUri is not None:
            showIndent(outfile, level)
            outfile.write('applianceUri=%s,\n' % quote_python(self.applianceUri).encode(ExternalEncoding))
        if self.disableRootPassword is not None:
            showIndent(outfile, level)
            outfile.write('disableRootPassword=%s,\n' % self.disableRootPassword)
        if self.diskSize is not None:
            showIndent(outfile, level)
            outfile.write('diskSize=%d,\n' % self.diskSize)
        if self.firewallAuto is not None:
            showIndent(outfile, level)
            outfile.write('firewallAuto=%s,\n' % self.firewallAuto)
        if self.firewallEnabled is not None:
            showIndent(outfile, level)
            outfile.write('firewallEnabled=%s,\n' % self.firewallEnabled)
        if self.osgroups is not None:
            showIndent(outfile, level)
            outfile.write('osgroups=model_.osgroups(\n')
            self.osgroups.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.groupsUri is not None:
            showIndent(outfile, level)
            outfile.write('groupsUri=%s,\n' % quote_python(self.groupsUri).encode(ExternalEncoding))
        if self.hwType is not None:
            showIndent(outfile, level)
            outfile.write('hwType=%s,\n' % quote_python(self.hwType).encode(ExternalEncoding))
        if self.internetSettingsAuto is not None:
            showIndent(outfile, level)
            outfile.write('internetSettingsAuto=%s,\n' % self.internetSettingsAuto)
        if self.kernelParameters is not None:
            showIndent(outfile, level)
            outfile.write('kernelParameters=%s,\n' % quote_python(self.kernelParameters).encode(ExternalEncoding))
        if self.keyboard is not None:
            showIndent(outfile, level)
            outfile.write('keyboard=%s,\n' % quote_python(self.keyboard).encode(ExternalEncoding))
        if self.keyboardAuto is not None:
            showIndent(outfile, level)
            outfile.write('keyboardAuto=%s,\n' % self.keyboardAuto)
        if self.memorySize is not None:
            showIndent(outfile, level)
            outfile.write('memorySize=%d,\n' % self.memorySize)
        if self.nics is not None:
            showIndent(outfile, level)
            outfile.write('nics=model_.nics(\n')
            self.nics.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.partitionAuto is not None:
            showIndent(outfile, level)
            outfile.write('partitionAuto=%s,\n' % self.partitionAuto)
        if self.partitionTable is not None:
            showIndent(outfile, level)
            outfile.write('partitionTable=model_.partitionTable(\n')
            self.partitionTable.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.rootUser is not None:
            showIndent(outfile, level)
            outfile.write('rootUser=model_.osUser(\n')
            self.rootUser.exportLiteral(outfile, level, name_='rootUser')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.skipLicenses is not None:
            showIndent(outfile, level)
            outfile.write('skipLicenses=%s,\n' % self.skipLicenses)
        if self.swapSize is not None:
            showIndent(outfile, level)
            outfile.write('swapSize=%d,\n' % self.swapSize)
        if self.timezone is not None:
            showIndent(outfile, level)
            outfile.write('timezone=%s,\n' % quote_python(self.timezone).encode(ExternalEncoding))
        if self.timezoneAuto is not None:
            showIndent(outfile, level)
            outfile.write('timezoneAuto=%s,\n' % self.timezoneAuto)
        if self.timezoneCity is not None:
            showIndent(outfile, level)
            outfile.write('timezoneCity=%s,\n' % quote_python(self.timezoneCity).encode(ExternalEncoding))
        if self.updateTools is not None:
            showIndent(outfile, level)
            outfile.write('updateTools=%s,\n' % self.updateTools)
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.osusers is not None:
            showIndent(outfile, level)
            outfile.write('osusers=model_.osusers(\n')
            self.osusers.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.usersUri is not None:
            showIndent(outfile, level)
            outfile.write('usersUri=%s,\n' % quote_python(self.usersUri).encode(ExternalEncoding))
        if self.vagrantUser is not None:
            showIndent(outfile, level)
            outfile.write('vagrantUser=%s,\n' % quote_python(self.vagrantUser).encode(ExternalEncoding))
        if self.welcomeMsg is not None:
            showIndent(outfile, level)
            outfile.write('welcomeMsg=%s,\n' % quote_python(self.welcomeMsg).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(installProfile, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'activationKey':
            activationKey_ = child_.text
            activationKey_ = self.gds_validate_string(activationKey_, node, 'activationKey')
            self.activationKey = activationKey_
        elif nodeName_ == 'adminLoginAuto':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'adminLoginAuto')
            self.adminLoginAuto = ival_
        elif nodeName_ == 'adminPassword':
            adminPassword_ = child_.text
            adminPassword_ = self.gds_validate_string(adminPassword_, node, 'adminPassword')
            self.adminPassword = adminPassword_
        elif nodeName_ == 'adminPasswordAuto':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'adminPasswordAuto')
            self.adminPasswordAuto = ival_
        elif nodeName_ == 'applianceUri':
            applianceUri_ = child_.text
            applianceUri_ = self.gds_validate_string(applianceUri_, node, 'applianceUri')
            self.applianceUri = applianceUri_
        elif nodeName_ == 'disableRootPassword':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'disableRootPassword')
            self.disableRootPassword = ival_
        elif nodeName_ == 'diskSize':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'diskSize')
            self.diskSize = ival_
        elif nodeName_ == 'firewallAuto':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'firewallAuto')
            self.firewallAuto = ival_
        elif nodeName_ == 'firewallEnabled':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'firewallEnabled')
            self.firewallEnabled = ival_
        elif nodeName_ == 'osgroups':
            obj_ = osgroups.factory()
            obj_.build(child_)
            self.osgroups = obj_
        elif nodeName_ == 'groupsUri':
            groupsUri_ = child_.text
            groupsUri_ = self.gds_validate_string(groupsUri_, node, 'groupsUri')
            self.groupsUri = groupsUri_
        elif nodeName_ == 'hwType':
            hwType_ = child_.text
            hwType_ = self.gds_validate_string(hwType_, node, 'hwType')
            self.hwType = hwType_
        elif nodeName_ == 'internetSettingsAuto':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'internetSettingsAuto')
            self.internetSettingsAuto = ival_
        elif nodeName_ == 'kernelParameters':
            kernelParameters_ = child_.text
            kernelParameters_ = self.gds_validate_string(kernelParameters_, node, 'kernelParameters')
            self.kernelParameters = kernelParameters_
        elif nodeName_ == 'keyboard':
            keyboard_ = child_.text
            keyboard_ = self.gds_validate_string(keyboard_, node, 'keyboard')
            self.keyboard = keyboard_
        elif nodeName_ == 'keyboardAuto':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'keyboardAuto')
            self.keyboardAuto = ival_
        elif nodeName_ == 'memorySize':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'memorySize')
            self.memorySize = ival_
        elif nodeName_ == 'nics':
            obj_ = nics.factory()
            obj_.build(child_)
            self.nics = obj_
        elif nodeName_ == 'partitionAuto':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'partitionAuto')
            self.partitionAuto = ival_
        elif nodeName_ == 'partitionTable':
            obj_ = partitionTable.factory()
            obj_.build(child_)
            self.partitionTable = obj_
        elif nodeName_ == 'rootUser':
            obj_ = osUser.factory()
            obj_.build(child_)
            self.rootUser = obj_
        elif nodeName_ == 'skipLicenses':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'skipLicenses')
            self.skipLicenses = ival_
        elif nodeName_ == 'swapSize':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'swapSize')
            self.swapSize = ival_
        elif nodeName_ == 'timezone':
            timezone_ = child_.text
            timezone_ = self.gds_validate_string(timezone_, node, 'timezone')
            self.timezone = timezone_
        elif nodeName_ == 'timezoneAuto':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'timezoneAuto')
            self.timezoneAuto = ival_
        elif nodeName_ == 'timezoneCity':
            timezoneCity_ = child_.text
            timezoneCity_ = self.gds_validate_string(timezoneCity_, node, 'timezoneCity')
            self.timezoneCity = timezoneCity_
        elif nodeName_ == 'updateTools':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'updateTools')
            self.updateTools = ival_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'osusers':
            obj_ = osusers.factory()
            obj_.build(child_)
            self.osusers = obj_
        elif nodeName_ == 'usersUri':
            usersUri_ = child_.text
            usersUri_ = self.gds_validate_string(usersUri_, node, 'usersUri')
            self.usersUri = usersUri_
        elif nodeName_ == 'vagrantUser':
            vagrantUser_ = child_.text
            vagrantUser_ = self.gds_validate_string(vagrantUser_, node, 'vagrantUser')
            self.vagrantUser = vagrantUser_
        elif nodeName_ == 'welcomeMsg':
            welcomeMsg_ = child_.text
            welcomeMsg_ = self.gds_validate_string(welcomeMsg_, node, 'welcomeMsg')
            self.welcomeMsg = welcomeMsg_
        super(installProfile, self).buildChildren(child_, node, nodeName_, True)
# end class installProfile


class osgroups(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, osgroup=None):
        if osgroup is None:
            self.osgroup = []
        else:
            self.osgroup = osgroup
    def factory(*args_, **kwargs_):
        if osgroups.subclass:
            return osgroups.subclass(*args_, **kwargs_)
        else:
            return osgroups(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_osgroup(self): return self.osgroup
    def set_osgroup(self, osgroup): self.osgroup = osgroup
    def add_osgroup(self, value): self.osgroup.append(value)
    def insert_osgroup(self, index, value): self.osgroup[index] = value
    def hasContent_(self):
        if (
            self.osgroup
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='osgroups', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='osgroups')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='osgroups'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='osgroups', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for osgroup_ in self.osgroup:
            osgroup_.export(outfile, level, namespace_, name_='osgroup', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='osgroups'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('osgroup=[\n')
        level += 1
        for osgroup_ in self.osgroup:
            showIndent(outfile, level)
            outfile.write('model_.osgroup(\n')
            osgroup_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'osgroup':
            obj_ = osGroup.factory()
            obj_.build(child_)
            self.osgroup.append(obj_)
# end class osgroups


class nics(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, nic=None):
        if nic is None:
            self.nic = []
        else:
            self.nic = nic
    def factory(*args_, **kwargs_):
        if nics.subclass:
            return nics.subclass(*args_, **kwargs_)
        else:
            return nics(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_nic(self): return self.nic
    def set_nic(self, nic): self.nic = nic
    def add_nic(self, value): self.nic.append(value)
    def insert_nic(self, index, value): self.nic[index] = value
    def hasContent_(self):
        if (
            self.nic
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='nics', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='nics')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='nics'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='nics', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for nic_ in self.nic:
            nic_.export(outfile, level, namespace_, name_='nic', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='nics'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('nic=[\n')
        level += 1
        for nic_ in self.nic:
            showIndent(outfile, level)
            outfile.write('model_.nic(\n')
            nic_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'nic':
            obj_ = nic.factory()
            obj_.build(child_)
            self.nic.append(obj_)
# end class nics


class osusers(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, osuser=None):
        if osuser is None:
            self.osuser = []
        else:
            self.osuser = osuser
    def factory(*args_, **kwargs_):
        if osusers.subclass:
            return osusers.subclass(*args_, **kwargs_)
        else:
            return osusers(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_osuser(self): return self.osuser
    def set_osuser(self, osuser): self.osuser = osuser
    def add_osuser(self, value): self.osuser.append(value)
    def insert_osuser(self, index, value): self.osuser[index] = value
    def hasContent_(self):
        if (
            self.osuser
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='osusers', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='osusers')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='osusers'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='osusers', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for osuser_ in self.osuser:
            osuser_.export(outfile, level, namespace_, name_='osuser', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='osusers'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('osuser=[\n')
        level += 1
        for osuser_ in self.osuser:
            showIndent(outfile, level)
            outfile.write('model_.osUser(\n')
            osuser_.exportLiteral(outfile, level, name_='osUser')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'osuser':
            obj_ = osUser.factory()
            obj_.build(child_)
            self.osuser.append(obj_)
# end class osusers


class nic(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, autoConnect=None, dflt=None, dhcpClientId=None, ipAddresses=None, ipv4DnsServers=None, ipv4Method=None, ipv4SearchDomains=None, ipv6DnsServers=None, ipv6Method=None, ipv6SearchDomains=None, macAddress=None, parentUri=None, privateNic=None, routes=None, type_=None, uri=None):
        super(nic, self).__init__(created, dbId, digest, lastModified, name, )
        self.autoConnect = autoConnect
        self.dflt = dflt
        self.dhcpClientId = dhcpClientId
        self.ipAddresses = ipAddresses
        self.ipv4DnsServers = ipv4DnsServers
        self.ipv4Method = ipv4Method
        self.ipv4SearchDomains = ipv4SearchDomains
        self.ipv6DnsServers = ipv6DnsServers
        self.ipv6Method = ipv6Method
        self.ipv6SearchDomains = ipv6SearchDomains
        self.macAddress = macAddress
        self.parentUri = parentUri
        self.privateNic = privateNic
        self.routes = routes
        self.type_ = type_
        self.uri = uri
    def factory(*args_, **kwargs_):
        if nic.subclass:
            return nic.subclass(*args_, **kwargs_)
        else:
            return nic(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_autoConnect(self): return self.autoConnect
    def set_autoConnect(self, autoConnect): self.autoConnect = autoConnect
    def get_dflt(self): return self.dflt
    def set_dflt(self, dflt): self.dflt = dflt
    def get_dhcpClientId(self): return self.dhcpClientId
    def set_dhcpClientId(self, dhcpClientId): self.dhcpClientId = dhcpClientId
    def get_ipAddresses(self): return self.ipAddresses
    def set_ipAddresses(self, ipAddresses): self.ipAddresses = ipAddresses
    def get_ipv4DnsServers(self): return self.ipv4DnsServers
    def set_ipv4DnsServers(self, ipv4DnsServers): self.ipv4DnsServers = ipv4DnsServers
    def get_ipv4Method(self): return self.ipv4Method
    def set_ipv4Method(self, ipv4Method): self.ipv4Method = ipv4Method
    def get_ipv4SearchDomains(self): return self.ipv4SearchDomains
    def set_ipv4SearchDomains(self, ipv4SearchDomains): self.ipv4SearchDomains = ipv4SearchDomains
    def get_ipv6DnsServers(self): return self.ipv6DnsServers
    def set_ipv6DnsServers(self, ipv6DnsServers): self.ipv6DnsServers = ipv6DnsServers
    def get_ipv6Method(self): return self.ipv6Method
    def set_ipv6Method(self, ipv6Method): self.ipv6Method = ipv6Method
    def get_ipv6SearchDomains(self): return self.ipv6SearchDomains
    def set_ipv6SearchDomains(self, ipv6SearchDomains): self.ipv6SearchDomains = ipv6SearchDomains
    def get_macAddress(self): return self.macAddress
    def set_macAddress(self, macAddress): self.macAddress = macAddress
    def get_parentUri(self): return self.parentUri
    def set_parentUri(self, parentUri): self.parentUri = parentUri
    def get_privateNic(self): return self.privateNic
    def set_privateNic(self, privateNic): self.privateNic = privateNic
    def get_routes(self): return self.routes
    def set_routes(self, routes): self.routes = routes
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def hasContent_(self):
        if (
            self.autoConnect is not None or
            self.dflt is not None or
            self.dhcpClientId is not None or
            self.ipAddresses is not None or
            self.ipv4DnsServers is not None or
            self.ipv4Method is not None or
            self.ipv4SearchDomains is not None or
            self.ipv6DnsServers is not None or
            self.ipv6Method is not None or
            self.ipv6SearchDomains is not None or
            self.macAddress is not None or
            self.parentUri is not None or
            self.privateNic is not None or
            self.routes is not None or
            self.type_ is not None or
            self.uri is not None or
            super(nic, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='nic', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='nic')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='nic'):
        super(nic, self).exportAttributes(outfile, level, already_processed, namespace_, name_='nic')
    def exportChildren(self, outfile, level, namespace_='', name_='nic', fromsubclass_=False, pretty_print=True):
        super(nic, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.autoConnect is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sautoConnect>%s</%sautoConnect>%s' % (namespace_, self.gds_format_boolean(self.autoConnect, input_name='autoConnect'), namespace_, eol_))
        if self.dflt is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdflt>%s</%sdflt>%s' % (namespace_, self.gds_format_boolean(self.dflt, input_name='dflt'), namespace_, eol_))
        if self.dhcpClientId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdhcpClientId>%s</%sdhcpClientId>%s' % (namespace_, self.gds_format_string(quote_xml(self.dhcpClientId).encode(ExternalEncoding), input_name='dhcpClientId'), namespace_, eol_))
        if self.ipAddresses is not None:
            self.ipAddresses.export(outfile, level, namespace_, name_='ipAddresses', pretty_print=pretty_print)
        if self.ipv4DnsServers is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sipv4DnsServers>%s</%sipv4DnsServers>%s' % (namespace_, self.gds_format_string(quote_xml(self.ipv4DnsServers).encode(ExternalEncoding), input_name='ipv4DnsServers'), namespace_, eol_))
        if self.ipv4Method is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sipv4Method>%s</%sipv4Method>%s' % (namespace_, self.gds_format_string(quote_xml(self.ipv4Method).encode(ExternalEncoding), input_name='ipv4Method'), namespace_, eol_))
        if self.ipv4SearchDomains is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sipv4SearchDomains>%s</%sipv4SearchDomains>%s' % (namespace_, self.gds_format_string(quote_xml(self.ipv4SearchDomains).encode(ExternalEncoding), input_name='ipv4SearchDomains'), namespace_, eol_))
        if self.ipv6DnsServers is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sipv6DnsServers>%s</%sipv6DnsServers>%s' % (namespace_, self.gds_format_string(quote_xml(self.ipv6DnsServers).encode(ExternalEncoding), input_name='ipv6DnsServers'), namespace_, eol_))
        if self.ipv6Method is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sipv6Method>%s</%sipv6Method>%s' % (namespace_, self.gds_format_string(quote_xml(self.ipv6Method).encode(ExternalEncoding), input_name='ipv6Method'), namespace_, eol_))
        if self.ipv6SearchDomains is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sipv6SearchDomains>%s</%sipv6SearchDomains>%s' % (namespace_, self.gds_format_string(quote_xml(self.ipv6SearchDomains).encode(ExternalEncoding), input_name='ipv6SearchDomains'), namespace_, eol_))
        if self.macAddress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smacAddress>%s</%smacAddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.macAddress).encode(ExternalEncoding), input_name='macAddress'), namespace_, eol_))
        if self.parentUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparentUri>%s</%sparentUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.parentUri).encode(ExternalEncoding), input_name='parentUri'), namespace_, eol_))
        if self.privateNic is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprivateNic>%s</%sprivateNic>%s' % (namespace_, self.gds_format_boolean(self.privateNic, input_name='privateNic'), namespace_, eol_))
        if self.routes is not None:
            self.routes.export(outfile, level, namespace_, name_='routes', pretty_print=pretty_print)
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='nic'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(nic, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(nic, self).exportLiteralChildren(outfile, level, name_)
        if self.autoConnect is not None:
            showIndent(outfile, level)
            outfile.write('autoConnect=%s,\n' % self.autoConnect)
        if self.dflt is not None:
            showIndent(outfile, level)
            outfile.write('dflt=%s,\n' % self.dflt)
        if self.dhcpClientId is not None:
            showIndent(outfile, level)
            outfile.write('dhcpClientId=%s,\n' % quote_python(self.dhcpClientId).encode(ExternalEncoding))
        if self.ipAddresses is not None:
            showIndent(outfile, level)
            outfile.write('ipAddresses=model_.ipAddresses(\n')
            self.ipAddresses.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ipv4DnsServers is not None:
            showIndent(outfile, level)
            outfile.write('ipv4DnsServers=%s,\n' % quote_python(self.ipv4DnsServers).encode(ExternalEncoding))
        if self.ipv4Method is not None:
            showIndent(outfile, level)
            outfile.write('ipv4Method=%s,\n' % quote_python(self.ipv4Method).encode(ExternalEncoding))
        if self.ipv4SearchDomains is not None:
            showIndent(outfile, level)
            outfile.write('ipv4SearchDomains=%s,\n' % quote_python(self.ipv4SearchDomains).encode(ExternalEncoding))
        if self.ipv6DnsServers is not None:
            showIndent(outfile, level)
            outfile.write('ipv6DnsServers=%s,\n' % quote_python(self.ipv6DnsServers).encode(ExternalEncoding))
        if self.ipv6Method is not None:
            showIndent(outfile, level)
            outfile.write('ipv6Method=%s,\n' % quote_python(self.ipv6Method).encode(ExternalEncoding))
        if self.ipv6SearchDomains is not None:
            showIndent(outfile, level)
            outfile.write('ipv6SearchDomains=%s,\n' % quote_python(self.ipv6SearchDomains).encode(ExternalEncoding))
        if self.macAddress is not None:
            showIndent(outfile, level)
            outfile.write('macAddress=%s,\n' % quote_python(self.macAddress).encode(ExternalEncoding))
        if self.parentUri is not None:
            showIndent(outfile, level)
            outfile.write('parentUri=%s,\n' % quote_python(self.parentUri).encode(ExternalEncoding))
        if self.privateNic is not None:
            showIndent(outfile, level)
            outfile.write('privateNic=%s,\n' % self.privateNic)
        if self.routes is not None:
            showIndent(outfile, level)
            outfile.write('routes=model_.routes(\n')
            self.routes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(nic, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'autoConnect':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'autoConnect')
            self.autoConnect = ival_
        elif nodeName_ == 'dflt':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'dflt')
            self.dflt = ival_
        elif nodeName_ == 'dhcpClientId':
            dhcpClientId_ = child_.text
            dhcpClientId_ = self.gds_validate_string(dhcpClientId_, node, 'dhcpClientId')
            self.dhcpClientId = dhcpClientId_
        elif nodeName_ == 'ipAddresses':
            obj_ = ipAddresses.factory()
            obj_.build(child_)
            self.ipAddresses = obj_
        elif nodeName_ == 'ipv4DnsServers':
            ipv4DnsServers_ = child_.text
            ipv4DnsServers_ = self.gds_validate_string(ipv4DnsServers_, node, 'ipv4DnsServers')
            self.ipv4DnsServers = ipv4DnsServers_
        elif nodeName_ == 'ipv4Method':
            ipv4Method_ = child_.text
            ipv4Method_ = self.gds_validate_string(ipv4Method_, node, 'ipv4Method')
            self.ipv4Method = ipv4Method_
        elif nodeName_ == 'ipv4SearchDomains':
            ipv4SearchDomains_ = child_.text
            ipv4SearchDomains_ = self.gds_validate_string(ipv4SearchDomains_, node, 'ipv4SearchDomains')
            self.ipv4SearchDomains = ipv4SearchDomains_
        elif nodeName_ == 'ipv6DnsServers':
            ipv6DnsServers_ = child_.text
            ipv6DnsServers_ = self.gds_validate_string(ipv6DnsServers_, node, 'ipv6DnsServers')
            self.ipv6DnsServers = ipv6DnsServers_
        elif nodeName_ == 'ipv6Method':
            ipv6Method_ = child_.text
            ipv6Method_ = self.gds_validate_string(ipv6Method_, node, 'ipv6Method')
            self.ipv6Method = ipv6Method_
        elif nodeName_ == 'ipv6SearchDomains':
            ipv6SearchDomains_ = child_.text
            ipv6SearchDomains_ = self.gds_validate_string(ipv6SearchDomains_, node, 'ipv6SearchDomains')
            self.ipv6SearchDomains = ipv6SearchDomains_
        elif nodeName_ == 'macAddress':
            macAddress_ = child_.text
            macAddress_ = self.gds_validate_string(macAddress_, node, 'macAddress')
            self.macAddress = macAddress_
        elif nodeName_ == 'parentUri':
            parentUri_ = child_.text
            parentUri_ = self.gds_validate_string(parentUri_, node, 'parentUri')
            self.parentUri = parentUri_
        elif nodeName_ == 'privateNic':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'privateNic')
            self.privateNic = ival_
        elif nodeName_ == 'routes':
            obj_ = routes.factory()
            obj_.build(child_)
            self.routes = obj_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(nic, self).buildChildren(child_, node, nodeName_, True)
# end class nic


class ipAddresses(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ipAddress=None):
        if ipAddress is None:
            self.ipAddress = []
        else:
            self.ipAddress = ipAddress
    def factory(*args_, **kwargs_):
        if ipAddresses.subclass:
            return ipAddresses.subclass(*args_, **kwargs_)
        else:
            return ipAddresses(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ipAddress(self): return self.ipAddress
    def set_ipAddress(self, ipAddress): self.ipAddress = ipAddress
    def add_ipAddress(self, value): self.ipAddress.append(value)
    def insert_ipAddress(self, index, value): self.ipAddress[index] = value
    def hasContent_(self):
        if (
            self.ipAddress
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ipAddresses', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ipAddresses')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ipAddresses'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ipAddresses', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ipAddress_ in self.ipAddress:
            ipAddress_.export(outfile, level, namespace_, name_='ipAddress', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ipAddresses'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('ipAddress=[\n')
        level += 1
        for ipAddress_ in self.ipAddress:
            showIndent(outfile, level)
            outfile.write('model_.ipAddress(\n')
            ipAddress_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ipAddress':
            obj_ = ipAddress.factory()
            obj_.build(child_)
            self.ipAddress.append(obj_)
# end class ipAddresses


class routes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, route=None):
        if route is None:
            self.route = []
        else:
            self.route = route
    def factory(*args_, **kwargs_):
        if routes.subclass:
            return routes.subclass(*args_, **kwargs_)
        else:
            return routes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_route(self): return self.route
    def set_route(self, route): self.route = route
    def add_route(self, value): self.route.append(value)
    def insert_route(self, index, value): self.route[index] = value
    def hasContent_(self):
        if (
            self.route
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='routes', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='routes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='routes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='routes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for route_ in self.route:
            route_.export(outfile, level, namespace_, name_='route', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='routes'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('route=[\n')
        level += 1
        for route_ in self.route:
            showIndent(outfile, level)
            outfile.write('model_.route(\n')
            route_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'route':
            obj_ = route.factory()
            obj_.build(child_)
            self.route.append(obj_)
# end class routes


class ipAddress(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, address=None, gateway=None, netmask=None, parentUri=None, type_=None, uri=None):
        super(ipAddress, self).__init__(created, dbId, digest, lastModified, name, )
        self.address = address
        self.gateway = gateway
        self.netmask = netmask
        self.parentUri = parentUri
        self.type_ = type_
        self.uri = uri
    def factory(*args_, **kwargs_):
        if ipAddress.subclass:
            return ipAddress.subclass(*args_, **kwargs_)
        else:
            return ipAddress(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def get_gateway(self): return self.gateway
    def set_gateway(self, gateway): self.gateway = gateway
    def get_netmask(self): return self.netmask
    def set_netmask(self, netmask): self.netmask = netmask
    def get_parentUri(self): return self.parentUri
    def set_parentUri(self, parentUri): self.parentUri = parentUri
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def hasContent_(self):
        if (
            self.address is not None or
            self.gateway is not None or
            self.netmask is not None or
            self.parentUri is not None or
            self.type_ is not None or
            self.uri is not None or
            super(ipAddress, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ipAddress', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ipAddress')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ipAddress'):
        super(ipAddress, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ipAddress')
    def exportChildren(self, outfile, level, namespace_='', name_='ipAddress', fromsubclass_=False, pretty_print=True):
        super(ipAddress, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.address is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddress>%s</%saddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.address).encode(ExternalEncoding), input_name='address'), namespace_, eol_))
        if self.gateway is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgateway>%s</%sgateway>%s' % (namespace_, self.gds_format_string(quote_xml(self.gateway).encode(ExternalEncoding), input_name='gateway'), namespace_, eol_))
        if self.netmask is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snetmask>%s</%snetmask>%s' % (namespace_, self.gds_format_string(quote_xml(self.netmask).encode(ExternalEncoding), input_name='netmask'), namespace_, eol_))
        if self.parentUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparentUri>%s</%sparentUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.parentUri).encode(ExternalEncoding), input_name='parentUri'), namespace_, eol_))
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='ipAddress'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(ipAddress, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ipAddress, self).exportLiteralChildren(outfile, level, name_)
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('address=%s,\n' % quote_python(self.address).encode(ExternalEncoding))
        if self.gateway is not None:
            showIndent(outfile, level)
            outfile.write('gateway=%s,\n' % quote_python(self.gateway).encode(ExternalEncoding))
        if self.netmask is not None:
            showIndent(outfile, level)
            outfile.write('netmask=%s,\n' % quote_python(self.netmask).encode(ExternalEncoding))
        if self.parentUri is not None:
            showIndent(outfile, level)
            outfile.write('parentUri=%s,\n' % quote_python(self.parentUri).encode(ExternalEncoding))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ipAddress, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'address':
            address_ = child_.text
            address_ = self.gds_validate_string(address_, node, 'address')
            self.address = address_
        elif nodeName_ == 'gateway':
            gateway_ = child_.text
            gateway_ = self.gds_validate_string(gateway_, node, 'gateway')
            self.gateway = gateway_
        elif nodeName_ == 'netmask':
            netmask_ = child_.text
            netmask_ = self.gds_validate_string(netmask_, node, 'netmask')
            self.netmask = netmask_
        elif nodeName_ == 'parentUri':
            parentUri_ = child_.text
            parentUri_ = self.gds_validate_string(parentUri_, node, 'parentUri')
            self.parentUri = parentUri_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(ipAddress, self).buildChildren(child_, node, nodeName_, True)
# end class ipAddress


class route(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, address=None, gateway=None, metric=None, netmask=None, parentUri=None, type_=None, uri=None):
        super(route, self).__init__(created, dbId, digest, lastModified, name, )
        self.address = address
        self.gateway = gateway
        self.metric = metric
        self.netmask = netmask
        self.parentUri = parentUri
        self.type_ = type_
        self.uri = uri
    def factory(*args_, **kwargs_):
        if route.subclass:
            return route.subclass(*args_, **kwargs_)
        else:
            return route(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def get_gateway(self): return self.gateway
    def set_gateway(self, gateway): self.gateway = gateway
    def get_metric(self): return self.metric
    def set_metric(self, metric): self.metric = metric
    def get_netmask(self): return self.netmask
    def set_netmask(self, netmask): self.netmask = netmask
    def get_parentUri(self): return self.parentUri
    def set_parentUri(self, parentUri): self.parentUri = parentUri
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def hasContent_(self):
        if (
            self.address is not None or
            self.gateway is not None or
            self.metric is not None or
            self.netmask is not None or
            self.parentUri is not None or
            self.type_ is not None or
            self.uri is not None or
            super(route, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='route', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='route')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='route'):
        super(route, self).exportAttributes(outfile, level, already_processed, namespace_, name_='route')
    def exportChildren(self, outfile, level, namespace_='', name_='route', fromsubclass_=False, pretty_print=True):
        super(route, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.address is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddress>%s</%saddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.address).encode(ExternalEncoding), input_name='address'), namespace_, eol_))
        if self.gateway is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgateway>%s</%sgateway>%s' % (namespace_, self.gds_format_string(quote_xml(self.gateway).encode(ExternalEncoding), input_name='gateway'), namespace_, eol_))
        if self.metric is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smetric>%s</%smetric>%s' % (namespace_, self.gds_format_string(quote_xml(self.metric).encode(ExternalEncoding), input_name='metric'), namespace_, eol_))
        if self.netmask is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snetmask>%s</%snetmask>%s' % (namespace_, self.gds_format_string(quote_xml(self.netmask).encode(ExternalEncoding), input_name='netmask'), namespace_, eol_))
        if self.parentUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparentUri>%s</%sparentUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.parentUri).encode(ExternalEncoding), input_name='parentUri'), namespace_, eol_))
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='route'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(route, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(route, self).exportLiteralChildren(outfile, level, name_)
        if self.address is not None:
            showIndent(outfile, level)
            outfile.write('address=%s,\n' % quote_python(self.address).encode(ExternalEncoding))
        if self.gateway is not None:
            showIndent(outfile, level)
            outfile.write('gateway=%s,\n' % quote_python(self.gateway).encode(ExternalEncoding))
        if self.metric is not None:
            showIndent(outfile, level)
            outfile.write('metric=%s,\n' % quote_python(self.metric).encode(ExternalEncoding))
        if self.netmask is not None:
            showIndent(outfile, level)
            outfile.write('netmask=%s,\n' % quote_python(self.netmask).encode(ExternalEncoding))
        if self.parentUri is not None:
            showIndent(outfile, level)
            outfile.write('parentUri=%s,\n' % quote_python(self.parentUri).encode(ExternalEncoding))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(route, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'address':
            address_ = child_.text
            address_ = self.gds_validate_string(address_, node, 'address')
            self.address = address_
        elif nodeName_ == 'gateway':
            gateway_ = child_.text
            gateway_ = self.gds_validate_string(gateway_, node, 'gateway')
            self.gateway = gateway_
        elif nodeName_ == 'metric':
            metric_ = child_.text
            metric_ = self.gds_validate_string(metric_, node, 'metric')
            self.metric = metric_
        elif nodeName_ == 'netmask':
            netmask_ = child_.text
            netmask_ = self.gds_validate_string(netmask_, node, 'netmask')
            self.netmask = netmask_
        elif nodeName_ == 'parentUri':
            parentUri_ = child_.text
            parentUri_ = self.gds_validate_string(parentUri_, node, 'parentUri')
            self.parentUri = parentUri_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(route, self).buildChildren(child_, node, nodeName_, True)
# end class route


class partitionTable(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, diskUris=None, disks=None, disksUri=None, installProfileUri=None, logicalGroupUris=None, logicalGroups=None, logicalGroupsUri=None, logicalVolumeUris=None, logicalVolumes=None, logicalVolumesUri=None, uri=None):
        super(partitionTable, self).__init__(created, dbId, digest, lastModified, name, )
        self.diskUris = diskUris
        self.disks = disks
        self.disksUri = disksUri
        self.installProfileUri = installProfileUri
        self.logicalGroupUris = logicalGroupUris
        self.logicalGroups = logicalGroups
        self.logicalGroupsUri = logicalGroupsUri
        self.logicalVolumeUris = logicalVolumeUris
        self.logicalVolumes = logicalVolumes
        self.logicalVolumesUri = logicalVolumesUri
        self.uri = uri
    def factory(*args_, **kwargs_):
        if partitionTable.subclass:
            return partitionTable.subclass(*args_, **kwargs_)
        else:
            return partitionTable(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_diskUris(self): return self.diskUris
    def set_diskUris(self, diskUris): self.diskUris = diskUris
    def get_disks(self): return self.disks
    def set_disks(self, disks): self.disks = disks
    def get_disksUri(self): return self.disksUri
    def set_disksUri(self, disksUri): self.disksUri = disksUri
    def get_installProfileUri(self): return self.installProfileUri
    def set_installProfileUri(self, installProfileUri): self.installProfileUri = installProfileUri
    def get_logicalGroupUris(self): return self.logicalGroupUris
    def set_logicalGroupUris(self, logicalGroupUris): self.logicalGroupUris = logicalGroupUris
    def get_logicalGroups(self): return self.logicalGroups
    def set_logicalGroups(self, logicalGroups): self.logicalGroups = logicalGroups
    def get_logicalGroupsUri(self): return self.logicalGroupsUri
    def set_logicalGroupsUri(self, logicalGroupsUri): self.logicalGroupsUri = logicalGroupsUri
    def get_logicalVolumeUris(self): return self.logicalVolumeUris
    def set_logicalVolumeUris(self, logicalVolumeUris): self.logicalVolumeUris = logicalVolumeUris
    def get_logicalVolumes(self): return self.logicalVolumes
    def set_logicalVolumes(self, logicalVolumes): self.logicalVolumes = logicalVolumes
    def get_logicalVolumesUri(self): return self.logicalVolumesUri
    def set_logicalVolumesUri(self, logicalVolumesUri): self.logicalVolumesUri = logicalVolumesUri
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def hasContent_(self):
        if (
            self.diskUris is not None or
            self.disks is not None or
            self.disksUri is not None or
            self.installProfileUri is not None or
            self.logicalGroupUris is not None or
            self.logicalGroups is not None or
            self.logicalGroupsUri is not None or
            self.logicalVolumeUris is not None or
            self.logicalVolumes is not None or
            self.logicalVolumesUri is not None or
            self.uri is not None or
            super(partitionTable, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='partitionTable', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='partitionTable')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='partitionTable'):
        super(partitionTable, self).exportAttributes(outfile, level, already_processed, namespace_, name_='partitionTable')
    def exportChildren(self, outfile, level, namespace_='', name_='partitionTable', fromsubclass_=False, pretty_print=True):
        super(partitionTable, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.diskUris is not None:
            self.diskUris.export(outfile, level, namespace_, name_='diskUris', pretty_print=pretty_print)
        if self.disks is not None:
            self.disks.export(outfile, level, namespace_, name_='disks', pretty_print=pretty_print)
        if self.disksUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisksUri>%s</%sdisksUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.disksUri).encode(ExternalEncoding), input_name='disksUri'), namespace_, eol_))
        if self.installProfileUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinstallProfileUri>%s</%sinstallProfileUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.installProfileUri).encode(ExternalEncoding), input_name='installProfileUri'), namespace_, eol_))
        if self.logicalGroupUris is not None:
            self.logicalGroupUris.export(outfile, level, namespace_, name_='logicalGroupUris', pretty_print=pretty_print)
        if self.logicalGroups is not None:
            self.logicalGroups.export(outfile, level, namespace_, name_='logicalGroups', pretty_print=pretty_print)
        if self.logicalGroupsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slogicalGroupsUri>%s</%slogicalGroupsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.logicalGroupsUri).encode(ExternalEncoding), input_name='logicalGroupsUri'), namespace_, eol_))
        if self.logicalVolumeUris is not None:
            self.logicalVolumeUris.export(outfile, level, namespace_, name_='logicalVolumeUris', pretty_print=pretty_print)
        if self.logicalVolumes is not None:
            self.logicalVolumes.export(outfile, level, namespace_, name_='logicalVolumes', pretty_print=pretty_print)
        if self.logicalVolumesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slogicalVolumesUri>%s</%slogicalVolumesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.logicalVolumesUri).encode(ExternalEncoding), input_name='logicalVolumesUri'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='partitionTable'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(partitionTable, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(partitionTable, self).exportLiteralChildren(outfile, level, name_)
        if self.diskUris is not None:
            showIndent(outfile, level)
            outfile.write('diskUris=model_.uriList(\n')
            self.diskUris.exportLiteral(outfile, level, name_='diskUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.disks is not None:
            showIndent(outfile, level)
            outfile.write('disks=model_.disks(\n')
            self.disks.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.disksUri is not None:
            showIndent(outfile, level)
            outfile.write('disksUri=%s,\n' % quote_python(self.disksUri).encode(ExternalEncoding))
        if self.installProfileUri is not None:
            showIndent(outfile, level)
            outfile.write('installProfileUri=%s,\n' % quote_python(self.installProfileUri).encode(ExternalEncoding))
        if self.logicalGroupUris is not None:
            showIndent(outfile, level)
            outfile.write('logicalGroupUris=model_.uriList(\n')
            self.logicalGroupUris.exportLiteral(outfile, level, name_='logicalGroupUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.logicalGroups is not None:
            showIndent(outfile, level)
            outfile.write('logicalGroups=model_.logicalGroups(\n')
            self.logicalGroups.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.logicalGroupsUri is not None:
            showIndent(outfile, level)
            outfile.write('logicalGroupsUri=%s,\n' % quote_python(self.logicalGroupsUri).encode(ExternalEncoding))
        if self.logicalVolumeUris is not None:
            showIndent(outfile, level)
            outfile.write('logicalVolumeUris=model_.uriList(\n')
            self.logicalVolumeUris.exportLiteral(outfile, level, name_='logicalVolumeUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.logicalVolumes is not None:
            showIndent(outfile, level)
            outfile.write('logicalVolumes=model_.logicalVolumes(\n')
            self.logicalVolumes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.logicalVolumesUri is not None:
            showIndent(outfile, level)
            outfile.write('logicalVolumesUri=%s,\n' % quote_python(self.logicalVolumesUri).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(partitionTable, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'diskUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.diskUris = obj_
        elif nodeName_ == 'disks':
            obj_ = disks.factory()
            obj_.build(child_)
            self.disks = obj_
        elif nodeName_ == 'disksUri':
            disksUri_ = child_.text
            disksUri_ = self.gds_validate_string(disksUri_, node, 'disksUri')
            self.disksUri = disksUri_
        elif nodeName_ == 'installProfileUri':
            installProfileUri_ = child_.text
            installProfileUri_ = self.gds_validate_string(installProfileUri_, node, 'installProfileUri')
            self.installProfileUri = installProfileUri_
        elif nodeName_ == 'logicalGroupUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.logicalGroupUris = obj_
        elif nodeName_ == 'logicalGroups':
            obj_ = logicalGroups.factory()
            obj_.build(child_)
            self.logicalGroups = obj_
        elif nodeName_ == 'logicalGroupsUri':
            logicalGroupsUri_ = child_.text
            logicalGroupsUri_ = self.gds_validate_string(logicalGroupsUri_, node, 'logicalGroupsUri')
            self.logicalGroupsUri = logicalGroupsUri_
        elif nodeName_ == 'logicalVolumeUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.logicalVolumeUris = obj_
        elif nodeName_ == 'logicalVolumes':
            obj_ = logicalVolumes.factory()
            obj_.build(child_)
            self.logicalVolumes = obj_
        elif nodeName_ == 'logicalVolumesUri':
            logicalVolumesUri_ = child_.text
            logicalVolumesUri_ = self.gds_validate_string(logicalVolumesUri_, node, 'logicalVolumesUri')
            self.logicalVolumesUri = logicalVolumesUri_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(partitionTable, self).buildChildren(child_, node, nodeName_, True)
# end class partitionTable


class disks(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, disk=None):
        if disk is None:
            self.disk = []
        else:
            self.disk = disk
    def factory(*args_, **kwargs_):
        if disks.subclass:
            return disks.subclass(*args_, **kwargs_)
        else:
            return disks(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_disk(self): return self.disk
    def set_disk(self, disk): self.disk = disk
    def add_disk(self, value): self.disk.append(value)
    def insert_disk(self, index, value): self.disk[index] = value
    def hasContent_(self):
        if (
            self.disk
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='disks', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='disks')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='disks'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='disks', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for disk_ in self.disk:
            disk_.export(outfile, level, namespace_, name_='disk', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='disks'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('disk=[\n')
        level += 1
        for disk_ in self.disk:
            showIndent(outfile, level)
            outfile.write('model_.disk(\n')
            disk_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'disk':
            obj_ = disk.factory()
            obj_.build(child_)
            self.disk.append(obj_)
# end class disks


class logicalGroups(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, logicalGroup=None):
        if logicalGroup is None:
            self.logicalGroup = []
        else:
            self.logicalGroup = logicalGroup
    def factory(*args_, **kwargs_):
        if logicalGroups.subclass:
            return logicalGroups.subclass(*args_, **kwargs_)
        else:
            return logicalGroups(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_logicalGroup(self): return self.logicalGroup
    def set_logicalGroup(self, logicalGroup): self.logicalGroup = logicalGroup
    def add_logicalGroup(self, value): self.logicalGroup.append(value)
    def insert_logicalGroup(self, index, value): self.logicalGroup[index] = value
    def hasContent_(self):
        if (
            self.logicalGroup
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='logicalGroups', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='logicalGroups')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='logicalGroups'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='logicalGroups', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for logicalGroup_ in self.logicalGroup:
            logicalGroup_.export(outfile, level, namespace_, name_='logicalGroup', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='logicalGroups'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('logicalGroup=[\n')
        level += 1
        for logicalGroup_ in self.logicalGroup:
            showIndent(outfile, level)
            outfile.write('model_.logicalGroup(\n')
            logicalGroup_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'logicalGroup':
            obj_ = logicalGroup.factory()
            obj_.build(child_)
            self.logicalGroup.append(obj_)
# end class logicalGroups


class logicalVolumes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, logicalVolume=None):
        if logicalVolume is None:
            self.logicalVolume = []
        else:
            self.logicalVolume = logicalVolume
    def factory(*args_, **kwargs_):
        if logicalVolumes.subclass:
            return logicalVolumes.subclass(*args_, **kwargs_)
        else:
            return logicalVolumes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_logicalVolume(self): return self.logicalVolume
    def set_logicalVolume(self, logicalVolume): self.logicalVolume = logicalVolume
    def add_logicalVolume(self, value): self.logicalVolume.append(value)
    def insert_logicalVolume(self, index, value): self.logicalVolume[index] = value
    def hasContent_(self):
        if (
            self.logicalVolume
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='logicalVolumes', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='logicalVolumes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='logicalVolumes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='logicalVolumes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for logicalVolume_ in self.logicalVolume:
            logicalVolume_.export(outfile, level, namespace_, name_='logicalVolume', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='logicalVolumes'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('logicalVolume=[\n')
        level += 1
        for logicalVolume_ in self.logicalVolume:
            showIndent(outfile, level)
            outfile.write('model_.logicalVolume(\n')
            logicalVolume_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'logicalVolume':
            obj_ = logicalVolume.factory()
            obj_.build(child_)
            self.logicalVolume.append(obj_)
# end class logicalVolumes


class disk(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, blockSize=None, partitionTableUri=None, partitionType=None, partitionUris=None, partitions=None, partitionsUri=None, size=None, uri=None):
        super(disk, self).__init__(created, dbId, digest, lastModified, name, )
        self.blockSize = blockSize
        self.partitionTableUri = partitionTableUri
        self.partitionType = partitionType
        self.partitionUris = partitionUris
        self.partitions = partitions
        self.partitionsUri = partitionsUri
        self.size = size
        self.uri = uri
    def factory(*args_, **kwargs_):
        if disk.subclass:
            return disk.subclass(*args_, **kwargs_)
        else:
            return disk(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_blockSize(self): return self.blockSize
    def set_blockSize(self, blockSize): self.blockSize = blockSize
    def get_partitionTableUri(self): return self.partitionTableUri
    def set_partitionTableUri(self, partitionTableUri): self.partitionTableUri = partitionTableUri
    def get_partitionType(self): return self.partitionType
    def set_partitionType(self, partitionType): self.partitionType = partitionType
    def get_partitionUris(self): return self.partitionUris
    def set_partitionUris(self, partitionUris): self.partitionUris = partitionUris
    def get_partitions(self): return self.partitions
    def set_partitions(self, partitions): self.partitions = partitions
    def get_partitionsUri(self): return self.partitionsUri
    def set_partitionsUri(self, partitionsUri): self.partitionsUri = partitionsUri
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def hasContent_(self):
        if (
            self.blockSize is not None or
            self.partitionTableUri is not None or
            self.partitionType is not None or
            self.partitionUris is not None or
            self.partitions is not None or
            self.partitionsUri is not None or
            self.size is not None or
            self.uri is not None or
            super(disk, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='disk', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='disk')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='disk'):
        super(disk, self).exportAttributes(outfile, level, already_processed, namespace_, name_='disk')
    def exportChildren(self, outfile, level, namespace_='', name_='disk', fromsubclass_=False, pretty_print=True):
        super(disk, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.blockSize is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sblockSize>%s</%sblockSize>%s' % (namespace_, self.gds_format_integer(self.blockSize, input_name='blockSize'), namespace_, eol_))
        if self.partitionTableUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spartitionTableUri>%s</%spartitionTableUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.partitionTableUri).encode(ExternalEncoding), input_name='partitionTableUri'), namespace_, eol_))
        if self.partitionType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spartitionType>%s</%spartitionType>%s' % (namespace_, self.gds_format_string(quote_xml(self.partitionType).encode(ExternalEncoding), input_name='partitionType'), namespace_, eol_))
        if self.partitionUris is not None:
            self.partitionUris.export(outfile, level, namespace_, name_='partitionUris', pretty_print=pretty_print)
        if self.partitions is not None:
            self.partitions.export(outfile, level, namespace_, name_='partitions', pretty_print=pretty_print)
        if self.partitionsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spartitionsUri>%s</%spartitionsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.partitionsUri).encode(ExternalEncoding), input_name='partitionsUri'), namespace_, eol_))
        if self.size is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssize>%s</%ssize>%s' % (namespace_, self.gds_format_integer(self.size, input_name='size'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='disk'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(disk, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(disk, self).exportLiteralChildren(outfile, level, name_)
        if self.blockSize is not None:
            showIndent(outfile, level)
            outfile.write('blockSize=%d,\n' % self.blockSize)
        if self.partitionTableUri is not None:
            showIndent(outfile, level)
            outfile.write('partitionTableUri=%s,\n' % quote_python(self.partitionTableUri).encode(ExternalEncoding))
        if self.partitionType is not None:
            showIndent(outfile, level)
            outfile.write('partitionType=%s,\n' % quote_python(self.partitionType).encode(ExternalEncoding))
        if self.partitionUris is not None:
            showIndent(outfile, level)
            outfile.write('partitionUris=model_.uriList(\n')
            self.partitionUris.exportLiteral(outfile, level, name_='partitionUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.partitions is not None:
            showIndent(outfile, level)
            outfile.write('partitions=model_.partitions(\n')
            self.partitions.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.partitionsUri is not None:
            showIndent(outfile, level)
            outfile.write('partitionsUri=%s,\n' % quote_python(self.partitionsUri).encode(ExternalEncoding))
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('size=%d,\n' % self.size)
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(disk, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'blockSize':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'blockSize')
            self.blockSize = ival_
        elif nodeName_ == 'partitionTableUri':
            partitionTableUri_ = child_.text
            partitionTableUri_ = self.gds_validate_string(partitionTableUri_, node, 'partitionTableUri')
            self.partitionTableUri = partitionTableUri_
        elif nodeName_ == 'partitionType':
            partitionType_ = child_.text
            partitionType_ = self.gds_validate_string(partitionType_, node, 'partitionType')
            self.partitionType = partitionType_
        elif nodeName_ == 'partitionUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.partitionUris = obj_
        elif nodeName_ == 'partitions':
            obj_ = partitions.factory()
            obj_.build(child_)
            self.partitions = obj_
        elif nodeName_ == 'partitionsUri':
            partitionsUri_ = child_.text
            partitionsUri_ = self.gds_validate_string(partitionsUri_, node, 'partitionsUri')
            self.partitionsUri = partitionsUri_
        elif nodeName_ == 'size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'size')
            self.size = ival_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(disk, self).buildChildren(child_, node, nodeName_, True)
# end class disk


class partitions(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, partition=None):
        if partition is None:
            self.partition = []
        else:
            self.partition = partition
    def factory(*args_, **kwargs_):
        if partitions.subclass:
            return partitions.subclass(*args_, **kwargs_)
        else:
            return partitions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partition(self): return self.partition
    def set_partition(self, partition): self.partition = partition
    def add_partition(self, value): self.partition.append(value)
    def insert_partition(self, index, value): self.partition[index] = value
    def hasContent_(self):
        if (
            self.partition
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='partitions', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='partitions')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='partitions'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='partitions', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for partition_ in self.partition:
            partition_.export(outfile, level, namespace_, name_='partition', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='partitions'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('partition=[\n')
        level += 1
        for partition_ in self.partition:
            showIndent(outfile, level)
            outfile.write('model_.partition(\n')
            partition_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'partition':
            obj_ = partition.factory()
            obj_.build(child_)
            self.partition.append(obj_)
# end class partitions


class partition(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, fstype=None, growable=None, label=None, logicalPartitionUris=None, logicalPartitions=None, logicalPartitionsUri=None, mpoint=None, parentUri=None, partitionTableUri=None, size=None, uri=None, volumeOrder=None):
        super(partition, self).__init__(created, dbId, digest, lastModified, name, )
        self.fstype = fstype
        self.growable = growable
        self.label = label
        self.logicalPartitionUris = logicalPartitionUris
        self.logicalPartitions = logicalPartitions
        self.logicalPartitionsUri = logicalPartitionsUri
        self.mpoint = mpoint
        self.parentUri = parentUri
        self.partitionTableUri = partitionTableUri
        self.size = size
        self.uri = uri
        self.volumeOrder = volumeOrder
    def factory(*args_, **kwargs_):
        if partition.subclass:
            return partition.subclass(*args_, **kwargs_)
        else:
            return partition(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_fstype(self): return self.fstype
    def set_fstype(self, fstype): self.fstype = fstype
    def get_growable(self): return self.growable
    def set_growable(self, growable): self.growable = growable
    def get_label(self): return self.label
    def set_label(self, label): self.label = label
    def get_logicalPartitionUris(self): return self.logicalPartitionUris
    def set_logicalPartitionUris(self, logicalPartitionUris): self.logicalPartitionUris = logicalPartitionUris
    def get_logicalPartitions(self): return self.logicalPartitions
    def set_logicalPartitions(self, logicalPartitions): self.logicalPartitions = logicalPartitions
    def get_logicalPartitionsUri(self): return self.logicalPartitionsUri
    def set_logicalPartitionsUri(self, logicalPartitionsUri): self.logicalPartitionsUri = logicalPartitionsUri
    def get_mpoint(self): return self.mpoint
    def set_mpoint(self, mpoint): self.mpoint = mpoint
    def get_parentUri(self): return self.parentUri
    def set_parentUri(self, parentUri): self.parentUri = parentUri
    def get_partitionTableUri(self): return self.partitionTableUri
    def set_partitionTableUri(self, partitionTableUri): self.partitionTableUri = partitionTableUri
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_volumeOrder(self): return self.volumeOrder
    def set_volumeOrder(self, volumeOrder): self.volumeOrder = volumeOrder
    def hasContent_(self):
        if (
            self.fstype is not None or
            self.growable is not None or
            self.label is not None or
            self.logicalPartitionUris is not None or
            self.logicalPartitions is not None or
            self.logicalPartitionsUri is not None or
            self.mpoint is not None or
            self.parentUri is not None or
            self.partitionTableUri is not None or
            self.size is not None or
            self.uri is not None or
            self.volumeOrder is not None or
            super(partition, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='partition', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='partition')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='partition'):
        super(partition, self).exportAttributes(outfile, level, already_processed, namespace_, name_='partition')
    def exportChildren(self, outfile, level, namespace_='', name_='partition', fromsubclass_=False, pretty_print=True):
        super(partition, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.fstype is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfstype>%s</%sfstype>%s' % (namespace_, self.gds_format_string(quote_xml(self.fstype).encode(ExternalEncoding), input_name='fstype'), namespace_, eol_))
        if self.growable is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgrowable>%s</%sgrowable>%s' % (namespace_, self.gds_format_boolean(self.growable, input_name='growable'), namespace_, eol_))
        if self.label is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slabel>%s</%slabel>%s' % (namespace_, self.gds_format_string(quote_xml(self.label).encode(ExternalEncoding), input_name='label'), namespace_, eol_))
        if self.logicalPartitionUris is not None:
            self.logicalPartitionUris.export(outfile, level, namespace_, name_='logicalPartitionUris', pretty_print=pretty_print)
        if self.logicalPartitions is not None:
            self.logicalPartitions.export(outfile, level, namespace_, name_='logicalPartitions', pretty_print=pretty_print)
        if self.logicalPartitionsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slogicalPartitionsUri>%s</%slogicalPartitionsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.logicalPartitionsUri).encode(ExternalEncoding), input_name='logicalPartitionsUri'), namespace_, eol_))
        if self.mpoint is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smpoint>%s</%smpoint>%s' % (namespace_, self.gds_format_string(quote_xml(self.mpoint).encode(ExternalEncoding), input_name='mpoint'), namespace_, eol_))
        if self.parentUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparentUri>%s</%sparentUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.parentUri).encode(ExternalEncoding), input_name='parentUri'), namespace_, eol_))
        if self.partitionTableUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spartitionTableUri>%s</%spartitionTableUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.partitionTableUri).encode(ExternalEncoding), input_name='partitionTableUri'), namespace_, eol_))
        if self.size is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssize>%s</%ssize>%s' % (namespace_, self.gds_format_integer(self.size, input_name='size'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
        if self.volumeOrder is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svolumeOrder>%s</%svolumeOrder>%s' % (namespace_, self.gds_format_integer(self.volumeOrder, input_name='volumeOrder'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='partition'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(partition, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(partition, self).exportLiteralChildren(outfile, level, name_)
        if self.fstype is not None:
            showIndent(outfile, level)
            outfile.write('fstype=%s,\n' % quote_python(self.fstype).encode(ExternalEncoding))
        if self.growable is not None:
            showIndent(outfile, level)
            outfile.write('growable=%s,\n' % self.growable)
        if self.label is not None:
            showIndent(outfile, level)
            outfile.write('label=%s,\n' % quote_python(self.label).encode(ExternalEncoding))
        if self.logicalPartitionUris is not None:
            showIndent(outfile, level)
            outfile.write('logicalPartitionUris=model_.uriList(\n')
            self.logicalPartitionUris.exportLiteral(outfile, level, name_='logicalPartitionUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.logicalPartitions is not None:
            showIndent(outfile, level)
            outfile.write('logicalPartitions=model_.logicalPartitions(\n')
            self.logicalPartitions.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.logicalPartitionsUri is not None:
            showIndent(outfile, level)
            outfile.write('logicalPartitionsUri=%s,\n' % quote_python(self.logicalPartitionsUri).encode(ExternalEncoding))
        if self.mpoint is not None:
            showIndent(outfile, level)
            outfile.write('mpoint=%s,\n' % quote_python(self.mpoint).encode(ExternalEncoding))
        if self.parentUri is not None:
            showIndent(outfile, level)
            outfile.write('parentUri=%s,\n' % quote_python(self.parentUri).encode(ExternalEncoding))
        if self.partitionTableUri is not None:
            showIndent(outfile, level)
            outfile.write('partitionTableUri=%s,\n' % quote_python(self.partitionTableUri).encode(ExternalEncoding))
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('size=%d,\n' % self.size)
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.volumeOrder is not None:
            showIndent(outfile, level)
            outfile.write('volumeOrder=%d,\n' % self.volumeOrder)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(partition, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'fstype':
            fstype_ = child_.text
            fstype_ = self.gds_validate_string(fstype_, node, 'fstype')
            self.fstype = fstype_
        elif nodeName_ == 'growable':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'growable')
            self.growable = ival_
        elif nodeName_ == 'label':
            label_ = child_.text
            label_ = self.gds_validate_string(label_, node, 'label')
            self.label = label_
        elif nodeName_ == 'logicalPartitionUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.logicalPartitionUris = obj_
        elif nodeName_ == 'logicalPartitions':
            obj_ = logicalPartitions.factory()
            obj_.build(child_)
            self.logicalPartitions = obj_
        elif nodeName_ == 'logicalPartitionsUri':
            logicalPartitionsUri_ = child_.text
            logicalPartitionsUri_ = self.gds_validate_string(logicalPartitionsUri_, node, 'logicalPartitionsUri')
            self.logicalPartitionsUri = logicalPartitionsUri_
        elif nodeName_ == 'mpoint':
            mpoint_ = child_.text
            mpoint_ = self.gds_validate_string(mpoint_, node, 'mpoint')
            self.mpoint = mpoint_
        elif nodeName_ == 'parentUri':
            parentUri_ = child_.text
            parentUri_ = self.gds_validate_string(parentUri_, node, 'parentUri')
            self.parentUri = parentUri_
        elif nodeName_ == 'partitionTableUri':
            partitionTableUri_ = child_.text
            partitionTableUri_ = self.gds_validate_string(partitionTableUri_, node, 'partitionTableUri')
            self.partitionTableUri = partitionTableUri_
        elif nodeName_ == 'size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'size')
            self.size = ival_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'volumeOrder':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'volumeOrder')
            self.volumeOrder = ival_
        super(partition, self).buildChildren(child_, node, nodeName_, True)
# end class partition


class logicalPartitions(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, partition=None):
        if partition is None:
            self.partition = []
        else:
            self.partition = partition
    def factory(*args_, **kwargs_):
        if logicalPartitions.subclass:
            return logicalPartitions.subclass(*args_, **kwargs_)
        else:
            return logicalPartitions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_partition(self): return self.partition
    def set_partition(self, partition): self.partition = partition
    def add_partition(self, value): self.partition.append(value)
    def insert_partition(self, index, value): self.partition[index] = value
    def hasContent_(self):
        if (
            self.partition
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='logicalPartitions', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='logicalPartitions')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='logicalPartitions'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='logicalPartitions', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for partition_ in self.partition:
            partition_.export(outfile, level, namespace_, name_='partition', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='logicalPartitions'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('partition=[\n')
        level += 1
        for partition_ in self.partition:
            showIndent(outfile, level)
            outfile.write('model_.partition(\n')
            partition_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'partition':
            obj_ = partition.factory()
            obj_.build(child_)
            self.partition.append(obj_)
# end class logicalPartitions


class logicalGroup(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, diskUris=None, groupName=None, partitionTableUri=None, partitionUris=None, uri=None):
        super(logicalGroup, self).__init__(created, dbId, digest, lastModified, name, )
        self.diskUris = diskUris
        self.groupName = groupName
        self.partitionTableUri = partitionTableUri
        self.partitionUris = partitionUris
        self.uri = uri
    def factory(*args_, **kwargs_):
        if logicalGroup.subclass:
            return logicalGroup.subclass(*args_, **kwargs_)
        else:
            return logicalGroup(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_diskUris(self): return self.diskUris
    def set_diskUris(self, diskUris): self.diskUris = diskUris
    def get_groupName(self): return self.groupName
    def set_groupName(self, groupName): self.groupName = groupName
    def get_partitionTableUri(self): return self.partitionTableUri
    def set_partitionTableUri(self, partitionTableUri): self.partitionTableUri = partitionTableUri
    def get_partitionUris(self): return self.partitionUris
    def set_partitionUris(self, partitionUris): self.partitionUris = partitionUris
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def hasContent_(self):
        if (
            self.diskUris is not None or
            self.groupName is not None or
            self.partitionTableUri is not None or
            self.partitionUris is not None or
            self.uri is not None or
            super(logicalGroup, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='logicalGroup', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='logicalGroup')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='logicalGroup'):
        super(logicalGroup, self).exportAttributes(outfile, level, already_processed, namespace_, name_='logicalGroup')
    def exportChildren(self, outfile, level, namespace_='', name_='logicalGroup', fromsubclass_=False, pretty_print=True):
        super(logicalGroup, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.diskUris is not None:
            self.diskUris.export(outfile, level, namespace_, name_='diskUris', pretty_print=pretty_print)
        if self.groupName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgroupName>%s</%sgroupName>%s' % (namespace_, self.gds_format_string(quote_xml(self.groupName).encode(ExternalEncoding), input_name='groupName'), namespace_, eol_))
        if self.partitionTableUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spartitionTableUri>%s</%spartitionTableUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.partitionTableUri).encode(ExternalEncoding), input_name='partitionTableUri'), namespace_, eol_))
        if self.partitionUris is not None:
            self.partitionUris.export(outfile, level, namespace_, name_='partitionUris', pretty_print=pretty_print)
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='logicalGroup'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(logicalGroup, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(logicalGroup, self).exportLiteralChildren(outfile, level, name_)
        if self.diskUris is not None:
            showIndent(outfile, level)
            outfile.write('diskUris=model_.uriList(\n')
            self.diskUris.exportLiteral(outfile, level, name_='diskUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.groupName is not None:
            showIndent(outfile, level)
            outfile.write('groupName=%s,\n' % quote_python(self.groupName).encode(ExternalEncoding))
        if self.partitionTableUri is not None:
            showIndent(outfile, level)
            outfile.write('partitionTableUri=%s,\n' % quote_python(self.partitionTableUri).encode(ExternalEncoding))
        if self.partitionUris is not None:
            showIndent(outfile, level)
            outfile.write('partitionUris=model_.uriList(\n')
            self.partitionUris.exportLiteral(outfile, level, name_='partitionUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(logicalGroup, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'diskUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.diskUris = obj_
        elif nodeName_ == 'groupName':
            groupName_ = child_.text
            groupName_ = self.gds_validate_string(groupName_, node, 'groupName')
            self.groupName = groupName_
        elif nodeName_ == 'partitionTableUri':
            partitionTableUri_ = child_.text
            partitionTableUri_ = self.gds_validate_string(partitionTableUri_, node, 'partitionTableUri')
            self.partitionTableUri = partitionTableUri_
        elif nodeName_ == 'partitionUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.partitionUris = obj_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(logicalGroup, self).buildChildren(child_, node, nodeName_, True)
# end class logicalGroup


class logicalVolume(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, groupUri=None, partitionTableUri=None, uri=None, volumeUris=None, volumes=None, volumesUri=None):
        super(logicalVolume, self).__init__(created, dbId, digest, lastModified, name, )
        self.groupUri = groupUri
        self.partitionTableUri = partitionTableUri
        self.uri = uri
        self.volumeUris = volumeUris
        self.volumes = volumes
        self.volumesUri = volumesUri
    def factory(*args_, **kwargs_):
        if logicalVolume.subclass:
            return logicalVolume.subclass(*args_, **kwargs_)
        else:
            return logicalVolume(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_groupUri(self): return self.groupUri
    def set_groupUri(self, groupUri): self.groupUri = groupUri
    def get_partitionTableUri(self): return self.partitionTableUri
    def set_partitionTableUri(self, partitionTableUri): self.partitionTableUri = partitionTableUri
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_volumeUris(self): return self.volumeUris
    def set_volumeUris(self, volumeUris): self.volumeUris = volumeUris
    def get_volumes(self): return self.volumes
    def set_volumes(self, volumes): self.volumes = volumes
    def get_volumesUri(self): return self.volumesUri
    def set_volumesUri(self, volumesUri): self.volumesUri = volumesUri
    def hasContent_(self):
        if (
            self.groupUri is not None or
            self.partitionTableUri is not None or
            self.uri is not None or
            self.volumeUris is not None or
            self.volumes is not None or
            self.volumesUri is not None or
            super(logicalVolume, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='logicalVolume', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='logicalVolume')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='logicalVolume'):
        super(logicalVolume, self).exportAttributes(outfile, level, already_processed, namespace_, name_='logicalVolume')
    def exportChildren(self, outfile, level, namespace_='', name_='logicalVolume', fromsubclass_=False, pretty_print=True):
        super(logicalVolume, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.groupUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgroupUri>%s</%sgroupUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.groupUri).encode(ExternalEncoding), input_name='groupUri'), namespace_, eol_))
        if self.partitionTableUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spartitionTableUri>%s</%spartitionTableUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.partitionTableUri).encode(ExternalEncoding), input_name='partitionTableUri'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
        if self.volumeUris is not None:
            self.volumeUris.export(outfile, level, namespace_, name_='volumeUris', pretty_print=pretty_print)
        if self.volumes is not None:
            self.volumes.export(outfile, level, namespace_, name_='volumes', pretty_print=pretty_print)
        if self.volumesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svolumesUri>%s</%svolumesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.volumesUri).encode(ExternalEncoding), input_name='volumesUri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='logicalVolume'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(logicalVolume, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(logicalVolume, self).exportLiteralChildren(outfile, level, name_)
        if self.groupUri is not None:
            showIndent(outfile, level)
            outfile.write('groupUri=%s,\n' % quote_python(self.groupUri).encode(ExternalEncoding))
        if self.partitionTableUri is not None:
            showIndent(outfile, level)
            outfile.write('partitionTableUri=%s,\n' % quote_python(self.partitionTableUri).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.volumeUris is not None:
            showIndent(outfile, level)
            outfile.write('volumeUris=model_.uriList(\n')
            self.volumeUris.exportLiteral(outfile, level, name_='volumeUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.volumes is not None:
            showIndent(outfile, level)
            outfile.write('volumes=model_.volumes(\n')
            self.volumes.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.volumesUri is not None:
            showIndent(outfile, level)
            outfile.write('volumesUri=%s,\n' % quote_python(self.volumesUri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(logicalVolume, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'groupUri':
            groupUri_ = child_.text
            groupUri_ = self.gds_validate_string(groupUri_, node, 'groupUri')
            self.groupUri = groupUri_
        elif nodeName_ == 'partitionTableUri':
            partitionTableUri_ = child_.text
            partitionTableUri_ = self.gds_validate_string(partitionTableUri_, node, 'partitionTableUri')
            self.partitionTableUri = partitionTableUri_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'volumeUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.volumeUris = obj_
        elif nodeName_ == 'volumes':
            obj_ = volumes.factory()
            obj_.build(child_)
            self.volumes = obj_
        elif nodeName_ == 'volumesUri':
            volumesUri_ = child_.text
            volumesUri_ = self.gds_validate_string(volumesUri_, node, 'volumesUri')
            self.volumesUri = volumesUri_
        super(logicalVolume, self).buildChildren(child_, node, nodeName_, True)
# end class logicalVolume


class volumes(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, volume=None):
        if volume is None:
            self.volume = []
        else:
            self.volume = volume
    def factory(*args_, **kwargs_):
        if volumes.subclass:
            return volumes.subclass(*args_, **kwargs_)
        else:
            return volumes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_volume(self): return self.volume
    def set_volume(self, volume): self.volume = volume
    def add_volume(self, value): self.volume.append(value)
    def insert_volume(self, index, value): self.volume[index] = value
    def hasContent_(self):
        if (
            self.volume
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='volumes', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='volumes')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='volumes'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='volumes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for volume_ in self.volume:
            volume_.export(outfile, level, namespace_, name_='volume', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='volumes'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('volume=[\n')
        level += 1
        for volume_ in self.volume:
            showIndent(outfile, level)
            outfile.write('model_.partition(\n')
            volume_.exportLiteral(outfile, level, name_='partition')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'volume':
            obj_ = partition.factory()
            obj_.build(child_)
            self.volume.append(obj_)
# end class volumes


class osUser(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, disablePasswordLogin=None, encrypted=None, fullName=None, homeDir=None, password=None, primaryGroup=None, primaryGroupAuto=None, secondaryGroups=None, shell=None, sshKeys=None, sudo=None, systemUser=None, uri=None, userId=None, userIdAuto=None):
        super(osUser, self).__init__(created, dbId, digest, lastModified, name, )
        self.disablePasswordLogin = disablePasswordLogin
        self.encrypted = encrypted
        self.fullName = fullName
        self.homeDir = homeDir
        self.password = password
        self.primaryGroup = primaryGroup
        self.primaryGroupAuto = primaryGroupAuto
        self.secondaryGroups = secondaryGroups
        self.shell = shell
        self.sshKeys = sshKeys
        self.sudo = sudo
        self.systemUser = systemUser
        self.uri = uri
        self.userId = userId
        self.userIdAuto = userIdAuto
    def factory(*args_, **kwargs_):
        if osUser.subclass:
            return osUser.subclass(*args_, **kwargs_)
        else:
            return osUser(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_disablePasswordLogin(self): return self.disablePasswordLogin
    def set_disablePasswordLogin(self, disablePasswordLogin): self.disablePasswordLogin = disablePasswordLogin
    def get_encrypted(self): return self.encrypted
    def set_encrypted(self, encrypted): self.encrypted = encrypted
    def get_fullName(self): return self.fullName
    def set_fullName(self, fullName): self.fullName = fullName
    def get_homeDir(self): return self.homeDir
    def set_homeDir(self, homeDir): self.homeDir = homeDir
    def get_password(self): return self.password
    def set_password(self, password): self.password = password
    def get_primaryGroup(self): return self.primaryGroup
    def set_primaryGroup(self, primaryGroup): self.primaryGroup = primaryGroup
    def get_primaryGroupAuto(self): return self.primaryGroupAuto
    def set_primaryGroupAuto(self, primaryGroupAuto): self.primaryGroupAuto = primaryGroupAuto
    def get_secondaryGroups(self): return self.secondaryGroups
    def set_secondaryGroups(self, secondaryGroups): self.secondaryGroups = secondaryGroups
    def get_shell(self): return self.shell
    def set_shell(self, shell): self.shell = shell
    def get_sshKeys(self): return self.sshKeys
    def set_sshKeys(self, sshKeys): self.sshKeys = sshKeys
    def get_sudo(self): return self.sudo
    def set_sudo(self, sudo): self.sudo = sudo
    def get_systemUser(self): return self.systemUser
    def set_systemUser(self, systemUser): self.systemUser = systemUser
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_userId(self): return self.userId
    def set_userId(self, userId): self.userId = userId
    def get_userIdAuto(self): return self.userIdAuto
    def set_userIdAuto(self, userIdAuto): self.userIdAuto = userIdAuto
    def hasContent_(self):
        if (
            self.disablePasswordLogin is not None or
            self.encrypted is not None or
            self.fullName is not None or
            self.homeDir is not None or
            self.password is not None or
            self.primaryGroup is not None or
            self.primaryGroupAuto is not None or
            self.secondaryGroups is not None or
            self.shell is not None or
            self.sshKeys is not None or
            self.sudo is not None or
            self.systemUser is not None or
            self.uri is not None or
            self.userId is not None or
            self.userIdAuto is not None or
            super(osUser, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='osUser', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='osUser')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='osUser'):
        super(osUser, self).exportAttributes(outfile, level, already_processed, namespace_, name_='osUser')
    def exportChildren(self, outfile, level, namespace_='', name_='osUser', fromsubclass_=False, pretty_print=True):
        super(osUser, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.disablePasswordLogin is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdisablePasswordLogin>%s</%sdisablePasswordLogin>%s' % (namespace_, self.gds_format_boolean(self.disablePasswordLogin, input_name='disablePasswordLogin'), namespace_, eol_))
        if self.encrypted is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sencrypted>%s</%sencrypted>%s' % (namespace_, self.gds_format_boolean(self.encrypted, input_name='encrypted'), namespace_, eol_))
        if self.fullName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfullName>%s</%sfullName>%s' % (namespace_, self.gds_format_string(quote_xml(self.fullName).encode(ExternalEncoding), input_name='fullName'), namespace_, eol_))
        if self.homeDir is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shomeDir>%s</%shomeDir>%s' % (namespace_, self.gds_format_string(quote_xml(self.homeDir).encode(ExternalEncoding), input_name='homeDir'), namespace_, eol_))
        if self.password is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spassword>%s</%spassword>%s' % (namespace_, self.gds_format_string(quote_xml(self.password).encode(ExternalEncoding), input_name='password'), namespace_, eol_))
        if self.primaryGroup is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprimaryGroup>%s</%sprimaryGroup>%s' % (namespace_, self.gds_format_string(quote_xml(self.primaryGroup).encode(ExternalEncoding), input_name='primaryGroup'), namespace_, eol_))
        if self.primaryGroupAuto is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprimaryGroupAuto>%s</%sprimaryGroupAuto>%s' % (namespace_, self.gds_format_boolean(self.primaryGroupAuto, input_name='primaryGroupAuto'), namespace_, eol_))
        if self.secondaryGroups is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssecondaryGroups>%s</%ssecondaryGroups>%s' % (namespace_, self.gds_format_string(quote_xml(self.secondaryGroups).encode(ExternalEncoding), input_name='secondaryGroups'), namespace_, eol_))
        if self.shell is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshell>%s</%sshell>%s' % (namespace_, self.gds_format_string(quote_xml(self.shell).encode(ExternalEncoding), input_name='shell'), namespace_, eol_))
        if self.sshKeys is not None:
            self.sshKeys.export(outfile, level, namespace_, name_='sshKeys', pretty_print=pretty_print)
        if self.sudo is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssudo>%s</%ssudo>%s' % (namespace_, self.gds_format_integer(self.sudo, input_name='sudo'), namespace_, eol_))
        if self.systemUser is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssystemUser>%s</%ssystemUser>%s' % (namespace_, self.gds_format_boolean(self.systemUser, input_name='systemUser'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
        if self.userId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suserId>%s</%suserId>%s' % (namespace_, self.gds_format_string(quote_xml(self.userId).encode(ExternalEncoding), input_name='userId'), namespace_, eol_))
        if self.userIdAuto is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suserIdAuto>%s</%suserIdAuto>%s' % (namespace_, self.gds_format_boolean(self.userIdAuto, input_name='userIdAuto'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='osUser'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(osUser, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(osUser, self).exportLiteralChildren(outfile, level, name_)
        if self.disablePasswordLogin is not None:
            showIndent(outfile, level)
            outfile.write('disablePasswordLogin=%s,\n' % self.disablePasswordLogin)
        if self.encrypted is not None:
            showIndent(outfile, level)
            outfile.write('encrypted=%s,\n' % self.encrypted)
        if self.fullName is not None:
            showIndent(outfile, level)
            outfile.write('fullName=%s,\n' % quote_python(self.fullName).encode(ExternalEncoding))
        if self.homeDir is not None:
            showIndent(outfile, level)
            outfile.write('homeDir=%s,\n' % quote_python(self.homeDir).encode(ExternalEncoding))
        if self.password is not None:
            showIndent(outfile, level)
            outfile.write('password=%s,\n' % quote_python(self.password).encode(ExternalEncoding))
        if self.primaryGroup is not None:
            showIndent(outfile, level)
            outfile.write('primaryGroup=%s,\n' % quote_python(self.primaryGroup).encode(ExternalEncoding))
        if self.primaryGroupAuto is not None:
            showIndent(outfile, level)
            outfile.write('primaryGroupAuto=%s,\n' % self.primaryGroupAuto)
        if self.secondaryGroups is not None:
            showIndent(outfile, level)
            outfile.write('secondaryGroups=%s,\n' % quote_python(self.secondaryGroups).encode(ExternalEncoding))
        if self.shell is not None:
            showIndent(outfile, level)
            outfile.write('shell=%s,\n' % quote_python(self.shell).encode(ExternalEncoding))
        if self.sshKeys is not None:
            showIndent(outfile, level)
            outfile.write('sshKeys=model_.sshKeys(\n')
            self.sshKeys.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.sudo is not None:
            showIndent(outfile, level)
            outfile.write('sudo=%d,\n' % self.sudo)
        if self.systemUser is not None:
            showIndent(outfile, level)
            outfile.write('systemUser=%s,\n' % self.systemUser)
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.userId is not None:
            showIndent(outfile, level)
            outfile.write('userId=%s,\n' % quote_python(self.userId).encode(ExternalEncoding))
        if self.userIdAuto is not None:
            showIndent(outfile, level)
            outfile.write('userIdAuto=%s,\n' % self.userIdAuto)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(osUser, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'disablePasswordLogin':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'disablePasswordLogin')
            self.disablePasswordLogin = ival_
        elif nodeName_ == 'encrypted':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'encrypted')
            self.encrypted = ival_
        elif nodeName_ == 'fullName':
            fullName_ = child_.text
            fullName_ = self.gds_validate_string(fullName_, node, 'fullName')
            self.fullName = fullName_
        elif nodeName_ == 'homeDir':
            homeDir_ = child_.text
            homeDir_ = self.gds_validate_string(homeDir_, node, 'homeDir')
            self.homeDir = homeDir_
        elif nodeName_ == 'password':
            password_ = child_.text
            password_ = self.gds_validate_string(password_, node, 'password')
            self.password = password_
        elif nodeName_ == 'primaryGroup':
            primaryGroup_ = child_.text
            primaryGroup_ = self.gds_validate_string(primaryGroup_, node, 'primaryGroup')
            self.primaryGroup = primaryGroup_
        elif nodeName_ == 'primaryGroupAuto':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'primaryGroupAuto')
            self.primaryGroupAuto = ival_
        elif nodeName_ == 'secondaryGroups':
            secondaryGroups_ = child_.text
            secondaryGroups_ = self.gds_validate_string(secondaryGroups_, node, 'secondaryGroups')
            self.secondaryGroups = secondaryGroups_
        elif nodeName_ == 'shell':
            shell_ = child_.text
            shell_ = self.gds_validate_string(shell_, node, 'shell')
            self.shell = shell_
        elif nodeName_ == 'sshKeys':
            obj_ = sshKeys.factory()
            obj_.build(child_)
            self.sshKeys = obj_
        elif nodeName_ == 'sudo':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'sudo')
            self.sudo = ival_
        elif nodeName_ == 'systemUser':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'systemUser')
            self.systemUser = ival_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'userId':
            userId_ = child_.text
            userId_ = self.gds_validate_string(userId_, node, 'userId')
            self.userId = userId_
        elif nodeName_ == 'userIdAuto':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'userIdAuto')
            self.userIdAuto = ival_
        super(osUser, self).buildChildren(child_, node, nodeName_, True)
# end class osUser


class sshKeys(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, sshKey=None):
        if sshKey is None:
            self.sshKey = []
        else:
            self.sshKey = sshKey
    def factory(*args_, **kwargs_):
        if sshKeys.subclass:
            return sshKeys.subclass(*args_, **kwargs_)
        else:
            return sshKeys(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_sshKey(self): return self.sshKey
    def set_sshKey(self, sshKey): self.sshKey = sshKey
    def add_sshKey(self, value): self.sshKey.append(value)
    def insert_sshKey(self, index, value): self.sshKey[index] = value
    def hasContent_(self):
        if (
            self.sshKey
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='sshKeys', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='sshKeys')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='sshKeys'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='sshKeys', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for sshKey_ in self.sshKey:
            sshKey_.export(outfile, level, namespace_, name_='sshKey', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='sshKeys'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('sshKey=[\n')
        level += 1
        for sshKey_ in self.sshKey:
            showIndent(outfile, level)
            outfile.write('model_.sshKey(\n')
            sshKey_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'sshKey':
            obj_ = sshKey.factory()
            obj_.build(child_)
            self.sshKey.append(obj_)
# end class sshKeys


class sshKey(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, publicKey=None, relativeCreated=None, uri=None):
        super(sshKey, self).__init__(created, dbId, digest, lastModified, name, )
        self.publicKey = publicKey
        self.relativeCreated = relativeCreated
        self.uri = uri
    def factory(*args_, **kwargs_):
        if sshKey.subclass:
            return sshKey.subclass(*args_, **kwargs_)
        else:
            return sshKey(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_publicKey(self): return self.publicKey
    def set_publicKey(self, publicKey): self.publicKey = publicKey
    def get_relativeCreated(self): return self.relativeCreated
    def set_relativeCreated(self, relativeCreated): self.relativeCreated = relativeCreated
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def hasContent_(self):
        if (
            self.publicKey is not None or
            self.relativeCreated is not None or
            self.uri is not None or
            super(sshKey, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='sshKey', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='sshKey')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='sshKey'):
        super(sshKey, self).exportAttributes(outfile, level, already_processed, namespace_, name_='sshKey')
    def exportChildren(self, outfile, level, namespace_='', name_='sshKey', fromsubclass_=False, pretty_print=True):
        super(sshKey, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.publicKey is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spublicKey>%s</%spublicKey>%s' % (namespace_, self.gds_format_string(quote_xml(self.publicKey).encode(ExternalEncoding), input_name='publicKey'), namespace_, eol_))
        if self.relativeCreated is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srelativeCreated>%s</%srelativeCreated>%s' % (namespace_, self.gds_format_string(quote_xml(self.relativeCreated).encode(ExternalEncoding), input_name='relativeCreated'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='sshKey'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(sshKey, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(sshKey, self).exportLiteralChildren(outfile, level, name_)
        if self.publicKey is not None:
            showIndent(outfile, level)
            outfile.write('publicKey=%s,\n' % quote_python(self.publicKey).encode(ExternalEncoding))
        if self.relativeCreated is not None:
            showIndent(outfile, level)
            outfile.write('relativeCreated=%s,\n' % quote_python(self.relativeCreated).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(sshKey, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'publicKey':
            publicKey_ = child_.text
            publicKey_ = self.gds_validate_string(publicKey_, node, 'publicKey')
            self.publicKey = publicKey_
        elif nodeName_ == 'relativeCreated':
            relativeCreated_ = child_.text
            relativeCreated_ = self.gds_validate_string(relativeCreated_, node, 'relativeCreated')
            self.relativeCreated = relativeCreated_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(sshKey, self).buildChildren(child_, node, nodeName_, True)
# end class sshKey


class blueprintLayer(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, bootOrder=None, description=None, hardwareSettings=None, installProfile=None, installProfileUri=None, nbInstances=None, parentUri=None, securityGroup=None, securityGroupUri=None, template=None, uri=None):
        super(blueprintLayer, self).__init__(created, dbId, digest, lastModified, name, )
        self.bootOrder = bootOrder
        self.description = description
        self.hardwareSettings = hardwareSettings
        self.installProfile = installProfile
        self.installProfileUri = installProfileUri
        self.nbInstances = nbInstances
        self.parentUri = parentUri
        self.securityGroup = securityGroup
        self.securityGroupUri = securityGroupUri
        self.template = template
        self.uri = uri
    def factory(*args_, **kwargs_):
        if blueprintLayer.subclass:
            return blueprintLayer.subclass(*args_, **kwargs_)
        else:
            return blueprintLayer(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_bootOrder(self): return self.bootOrder
    def set_bootOrder(self, bootOrder): self.bootOrder = bootOrder
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_hardwareSettings(self): return self.hardwareSettings
    def set_hardwareSettings(self, hardwareSettings): self.hardwareSettings = hardwareSettings
    def get_installProfile(self): return self.installProfile
    def set_installProfile(self, installProfile): self.installProfile = installProfile
    def get_installProfileUri(self): return self.installProfileUri
    def set_installProfileUri(self, installProfileUri): self.installProfileUri = installProfileUri
    def get_nbInstances(self): return self.nbInstances
    def set_nbInstances(self, nbInstances): self.nbInstances = nbInstances
    def get_parentUri(self): return self.parentUri
    def set_parentUri(self, parentUri): self.parentUri = parentUri
    def get_securityGroup(self): return self.securityGroup
    def set_securityGroup(self, securityGroup): self.securityGroup = securityGroup
    def get_securityGroupUri(self): return self.securityGroupUri
    def set_securityGroupUri(self, securityGroupUri): self.securityGroupUri = securityGroupUri
    def get_template(self): return self.template
    def set_template(self, template): self.template = template
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def hasContent_(self):
        if (
            self.bootOrder is not None or
            self.description is not None or
            self.hardwareSettings is not None or
            self.installProfile is not None or
            self.installProfileUri is not None or
            self.nbInstances is not None or
            self.parentUri is not None or
            self.securityGroup is not None or
            self.securityGroupUri is not None or
            self.template is not None or
            self.uri is not None or
            super(blueprintLayer, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='blueprintLayer', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='blueprintLayer')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='blueprintLayer'):
        super(blueprintLayer, self).exportAttributes(outfile, level, already_processed, namespace_, name_='blueprintLayer')
    def exportChildren(self, outfile, level, namespace_='', name_='blueprintLayer', fromsubclass_=False, pretty_print=True):
        super(blueprintLayer, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.bootOrder is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbootOrder>%s</%sbootOrder>%s' % (namespace_, self.gds_format_integer(self.bootOrder, input_name='bootOrder'), namespace_, eol_))
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_, eol_))
        if self.hardwareSettings is not None:
            self.hardwareSettings.export(outfile, level, namespace_, name_='hardwareSettings', pretty_print=pretty_print)
        if self.installProfile is not None:
            self.installProfile.export(outfile, level, namespace_, name_='installProfile', pretty_print=pretty_print)
        if self.installProfileUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinstallProfileUri>%s</%sinstallProfileUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.installProfileUri).encode(ExternalEncoding), input_name='installProfileUri'), namespace_, eol_))
        if self.nbInstances is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snbInstances>%s</%snbInstances>%s' % (namespace_, self.gds_format_integer(self.nbInstances, input_name='nbInstances'), namespace_, eol_))
        if self.parentUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparentUri>%s</%sparentUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.parentUri).encode(ExternalEncoding), input_name='parentUri'), namespace_, eol_))
        if self.securityGroup is not None:
            self.securityGroup.export(outfile, level, namespace_, name_='securityGroup', pretty_print=pretty_print)
        if self.securityGroupUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssecurityGroupUri>%s</%ssecurityGroupUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.securityGroupUri).encode(ExternalEncoding), input_name='securityGroupUri'), namespace_, eol_))
        if self.template is not None:
            self.template.export(outfile, level, namespace_, name_='template', pretty_print=pretty_print)
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='blueprintLayer'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(blueprintLayer, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(blueprintLayer, self).exportLiteralChildren(outfile, level, name_)
        if self.bootOrder is not None:
            showIndent(outfile, level)
            outfile.write('bootOrder=%d,\n' % self.bootOrder)
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        if self.hardwareSettings is not None:
            showIndent(outfile, level)
            outfile.write('hardwareSettings=model_.hardwareSettings(\n')
            self.hardwareSettings.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.installProfile is not None:
            showIndent(outfile, level)
            outfile.write('installProfile=model_.installProfile(\n')
            self.installProfile.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.installProfileUri is not None:
            showIndent(outfile, level)
            outfile.write('installProfileUri=%s,\n' % quote_python(self.installProfileUri).encode(ExternalEncoding))
        if self.nbInstances is not None:
            showIndent(outfile, level)
            outfile.write('nbInstances=%d,\n' % self.nbInstances)
        if self.parentUri is not None:
            showIndent(outfile, level)
            outfile.write('parentUri=%s,\n' % quote_python(self.parentUri).encode(ExternalEncoding))
        if self.securityGroup is not None:
            showIndent(outfile, level)
            outfile.write('securityGroup=model_.securityGroup(\n')
            self.securityGroup.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.securityGroupUri is not None:
            showIndent(outfile, level)
            outfile.write('securityGroupUri=%s,\n' % quote_python(self.securityGroupUri).encode(ExternalEncoding))
        if self.template is not None:
            showIndent(outfile, level)
            outfile.write('template=model_.appliance(\n')
            self.template.exportLiteral(outfile, level, name_='template')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(blueprintLayer, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'bootOrder':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'bootOrder')
            self.bootOrder = ival_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'hardwareSettings':
            obj_ = hardwareSettings.factory()
            obj_.build(child_)
            self.hardwareSettings = obj_
        elif nodeName_ == 'installProfile':
            obj_ = installProfile.factory()
            obj_.build(child_)
            self.installProfile = obj_
        elif nodeName_ == 'installProfileUri':
            installProfileUri_ = child_.text
            installProfileUri_ = self.gds_validate_string(installProfileUri_, node, 'installProfileUri')
            self.installProfileUri = installProfileUri_
        elif nodeName_ == 'nbInstances':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'nbInstances')
            self.nbInstances = ival_
        elif nodeName_ == 'parentUri':
            parentUri_ = child_.text
            parentUri_ = self.gds_validate_string(parentUri_, node, 'parentUri')
            self.parentUri = parentUri_
        elif nodeName_ == 'securityGroup':
            obj_ = securityGroup.factory()
            obj_.build(child_)
            self.securityGroup = obj_
        elif nodeName_ == 'securityGroupUri':
            securityGroupUri_ = child_.text
            securityGroupUri_ = self.gds_validate_string(securityGroupUri_, node, 'securityGroupUri')
            self.securityGroupUri = securityGroupUri_
        elif nodeName_ == 'template':
            class_obj_ = self.get_class_obj_(child_, appliance)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.template = obj_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(blueprintLayer, self).buildChildren(child_, node, nodeName_, True)
# end class blueprintLayer


class hardwareSettings(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, cores=None, cpus=None, memory=None, parentUri=None, storagePerformance=None, uri=None, vcpus=None):
        super(hardwareSettings, self).__init__(created, dbId, digest, lastModified, name, )
        self.cores = cores
        self.cpus = cpus
        self.memory = memory
        self.parentUri = parentUri
        self.storagePerformance = storagePerformance
        self.uri = uri
        self.vcpus = vcpus
    def factory(*args_, **kwargs_):
        if hardwareSettings.subclass:
            return hardwareSettings.subclass(*args_, **kwargs_)
        else:
            return hardwareSettings(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_cores(self): return self.cores
    def set_cores(self, cores): self.cores = cores
    def get_cpus(self): return self.cpus
    def set_cpus(self, cpus): self.cpus = cpus
    def get_memory(self): return self.memory
    def set_memory(self, memory): self.memory = memory
    def get_parentUri(self): return self.parentUri
    def set_parentUri(self, parentUri): self.parentUri = parentUri
    def get_storagePerformance(self): return self.storagePerformance
    def set_storagePerformance(self, storagePerformance): self.storagePerformance = storagePerformance
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_vcpus(self): return self.vcpus
    def set_vcpus(self, vcpus): self.vcpus = vcpus
    def hasContent_(self):
        if (
            self.cores is not None or
            self.cpus is not None or
            self.memory is not None or
            self.parentUri is not None or
            self.storagePerformance is not None or
            self.uri is not None or
            self.vcpus is not None or
            super(hardwareSettings, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='hardwareSettings', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='hardwareSettings')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='hardwareSettings'):
        super(hardwareSettings, self).exportAttributes(outfile, level, already_processed, namespace_, name_='hardwareSettings')
    def exportChildren(self, outfile, level, namespace_='', name_='hardwareSettings', fromsubclass_=False, pretty_print=True):
        super(hardwareSettings, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cores is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scores>%s</%scores>%s' % (namespace_, self.gds_format_integer(self.cores, input_name='cores'), namespace_, eol_))
        if self.cpus is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scpus>%s</%scpus>%s' % (namespace_, self.gds_format_integer(self.cpus, input_name='cpus'), namespace_, eol_))
        if self.memory is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smemory>%s</%smemory>%s' % (namespace_, self.gds_format_integer(self.memory, input_name='memory'), namespace_, eol_))
        if self.parentUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparentUri>%s</%sparentUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.parentUri).encode(ExternalEncoding), input_name='parentUri'), namespace_, eol_))
        if self.storagePerformance is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstoragePerformance>%s</%sstoragePerformance>%s' % (namespace_, self.gds_format_string(quote_xml(self.storagePerformance).encode(ExternalEncoding), input_name='storagePerformance'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
        if self.vcpus is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svcpus>%s</%svcpus>%s' % (namespace_, self.gds_format_integer(self.vcpus, input_name='vcpus'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='hardwareSettings'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(hardwareSettings, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(hardwareSettings, self).exportLiteralChildren(outfile, level, name_)
        if self.cores is not None:
            showIndent(outfile, level)
            outfile.write('cores=%d,\n' % self.cores)
        if self.cpus is not None:
            showIndent(outfile, level)
            outfile.write('cpus=%d,\n' % self.cpus)
        if self.memory is not None:
            showIndent(outfile, level)
            outfile.write('memory=%d,\n' % self.memory)
        if self.parentUri is not None:
            showIndent(outfile, level)
            outfile.write('parentUri=%s,\n' % quote_python(self.parentUri).encode(ExternalEncoding))
        if self.storagePerformance is not None:
            showIndent(outfile, level)
            outfile.write('storagePerformance=%s,\n' % quote_python(self.storagePerformance).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.vcpus is not None:
            showIndent(outfile, level)
            outfile.write('vcpus=%d,\n' % self.vcpus)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(hardwareSettings, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'cores':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'cores')
            self.cores = ival_
        elif nodeName_ == 'cpus':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'cpus')
            self.cpus = ival_
        elif nodeName_ == 'memory':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'memory')
            self.memory = ival_
        elif nodeName_ == 'parentUri':
            parentUri_ = child_.text
            parentUri_ = self.gds_validate_string(parentUri_, node, 'parentUri')
            self.parentUri = parentUri_
        elif nodeName_ == 'storagePerformance':
            storagePerformance_ = child_.text
            storagePerformance_ = self.gds_validate_string(storagePerformance_, node, 'storagePerformance')
            self.storagePerformance = storagePerformance_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'vcpus':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'vcpus')
            self.vcpus = ival_
        super(hardwareSettings, self).buildChildren(child_, node, nodeName_, True)
# end class hardwareSettings


class securityGroup(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, description=None, parentUri=None, refId=None, ruleUris=None, rules=None, rulesUri=None, uri=None):
        super(securityGroup, self).__init__(created, dbId, digest, lastModified, name, )
        self.description = description
        self.parentUri = parentUri
        self.refId = refId
        self.ruleUris = ruleUris
        self.rules = rules
        self.rulesUri = rulesUri
        self.uri = uri
    def factory(*args_, **kwargs_):
        if securityGroup.subclass:
            return securityGroup.subclass(*args_, **kwargs_)
        else:
            return securityGroup(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_parentUri(self): return self.parentUri
    def set_parentUri(self, parentUri): self.parentUri = parentUri
    def get_refId(self): return self.refId
    def set_refId(self, refId): self.refId = refId
    def get_ruleUris(self): return self.ruleUris
    def set_ruleUris(self, ruleUris): self.ruleUris = ruleUris
    def get_rules(self): return self.rules
    def set_rules(self, rules): self.rules = rules
    def get_rulesUri(self): return self.rulesUri
    def set_rulesUri(self, rulesUri): self.rulesUri = rulesUri
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def hasContent_(self):
        if (
            self.description is not None or
            self.parentUri is not None or
            self.refId is not None or
            self.ruleUris is not None or
            self.rules is not None or
            self.rulesUri is not None or
            self.uri is not None or
            super(securityGroup, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='securityGroup', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='securityGroup')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='securityGroup'):
        super(securityGroup, self).exportAttributes(outfile, level, already_processed, namespace_, name_='securityGroup')
    def exportChildren(self, outfile, level, namespace_='', name_='securityGroup', fromsubclass_=False, pretty_print=True):
        super(securityGroup, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_, eol_))
        if self.parentUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparentUri>%s</%sparentUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.parentUri).encode(ExternalEncoding), input_name='parentUri'), namespace_, eol_))
        if self.refId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srefId>%s</%srefId>%s' % (namespace_, self.gds_format_string(quote_xml(self.refId).encode(ExternalEncoding), input_name='refId'), namespace_, eol_))
        if self.ruleUris is not None:
            self.ruleUris.export(outfile, level, namespace_, name_='ruleUris', pretty_print=pretty_print)
        if self.rules is not None:
            self.rules.export(outfile, level, namespace_, name_='rules', pretty_print=pretty_print)
        if self.rulesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srulesUri>%s</%srulesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.rulesUri).encode(ExternalEncoding), input_name='rulesUri'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='securityGroup'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(securityGroup, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(securityGroup, self).exportLiteralChildren(outfile, level, name_)
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        if self.parentUri is not None:
            showIndent(outfile, level)
            outfile.write('parentUri=%s,\n' % quote_python(self.parentUri).encode(ExternalEncoding))
        if self.refId is not None:
            showIndent(outfile, level)
            outfile.write('refId=%s,\n' % quote_python(self.refId).encode(ExternalEncoding))
        if self.ruleUris is not None:
            showIndent(outfile, level)
            outfile.write('ruleUris=model_.uriList(\n')
            self.ruleUris.exportLiteral(outfile, level, name_='ruleUris')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.rules is not None:
            showIndent(outfile, level)
            outfile.write('rules=model_.rules(\n')
            self.rules.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.rulesUri is not None:
            showIndent(outfile, level)
            outfile.write('rulesUri=%s,\n' % quote_python(self.rulesUri).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(securityGroup, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'parentUri':
            parentUri_ = child_.text
            parentUri_ = self.gds_validate_string(parentUri_, node, 'parentUri')
            self.parentUri = parentUri_
        elif nodeName_ == 'refId':
            refId_ = child_.text
            refId_ = self.gds_validate_string(refId_, node, 'refId')
            self.refId = refId_
        elif nodeName_ == 'ruleUris':
            obj_ = uriList.factory()
            obj_.build(child_)
            self.ruleUris = obj_
        elif nodeName_ == 'rules':
            obj_ = rules.factory()
            obj_.build(child_)
            self.rules = obj_
        elif nodeName_ == 'rulesUri':
            rulesUri_ = child_.text
            rulesUri_ = self.gds_validate_string(rulesUri_, node, 'rulesUri')
            self.rulesUri = rulesUri_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(securityGroup, self).buildChildren(child_, node, nodeName_, True)
# end class securityGroup


class rules(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, rule=None):
        if rule is None:
            self.rule = []
        else:
            self.rule = rule
    def factory(*args_, **kwargs_):
        if rules.subclass:
            return rules.subclass(*args_, **kwargs_)
        else:
            return rules(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_rule(self): return self.rule
    def set_rule(self, rule): self.rule = rule
    def add_rule(self, value): self.rule.append(value)
    def insert_rule(self, index, value): self.rule[index] = value
    def hasContent_(self):
        if (
            self.rule
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='rules', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='rules')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='rules'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='rules', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for rule_ in self.rule:
            rule_.export(outfile, level, namespace_, name_='rule', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='rules'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('rule=[\n')
        level += 1
        for rule_ in self.rule:
            showIndent(outfile, level)
            outfile.write('model_.rule(\n')
            rule_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'rule':
            obj_ = rule.factory()
            obj_.build(child_)
            self.rule.append(obj_)
# end class rules


class rule(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, direction=None, parentUri=None, portRange=None, protocol=None, source=None, uri=None):
        super(rule, self).__init__(created, dbId, digest, lastModified, name, )
        self.direction = direction
        self.parentUri = parentUri
        self.portRange = portRange
        self.protocol = protocol
        self.source = source
        self.uri = uri
    def factory(*args_, **kwargs_):
        if rule.subclass:
            return rule.subclass(*args_, **kwargs_)
        else:
            return rule(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_direction(self): return self.direction
    def set_direction(self, direction): self.direction = direction
    def get_parentUri(self): return self.parentUri
    def set_parentUri(self, parentUri): self.parentUri = parentUri
    def get_portRange(self): return self.portRange
    def set_portRange(self, portRange): self.portRange = portRange
    def get_protocol(self): return self.protocol
    def set_protocol(self, protocol): self.protocol = protocol
    def get_source(self): return self.source
    def set_source(self, source): self.source = source
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def hasContent_(self):
        if (
            self.direction is not None or
            self.parentUri is not None or
            self.portRange is not None or
            self.protocol is not None or
            self.source is not None or
            self.uri is not None or
            super(rule, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='rule', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='rule')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='rule'):
        super(rule, self).exportAttributes(outfile, level, already_processed, namespace_, name_='rule')
    def exportChildren(self, outfile, level, namespace_='', name_='rule', fromsubclass_=False, pretty_print=True):
        super(rule, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.direction is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdirection>%s</%sdirection>%s' % (namespace_, self.gds_format_string(quote_xml(self.direction).encode(ExternalEncoding), input_name='direction'), namespace_, eol_))
        if self.parentUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparentUri>%s</%sparentUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.parentUri).encode(ExternalEncoding), input_name='parentUri'), namespace_, eol_))
        if self.portRange is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sportRange>%s</%sportRange>%s' % (namespace_, self.gds_format_string(quote_xml(self.portRange).encode(ExternalEncoding), input_name='portRange'), namespace_, eol_))
        if self.protocol is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprotocol>%s</%sprotocol>%s' % (namespace_, self.gds_format_string(quote_xml(self.protocol).encode(ExternalEncoding), input_name='protocol'), namespace_, eol_))
        if self.source is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssource>%s</%ssource>%s' % (namespace_, self.gds_format_string(quote_xml(self.source).encode(ExternalEncoding), input_name='source'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='rule'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(rule, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(rule, self).exportLiteralChildren(outfile, level, name_)
        if self.direction is not None:
            showIndent(outfile, level)
            outfile.write('direction=%s,\n' % quote_python(self.direction).encode(ExternalEncoding))
        if self.parentUri is not None:
            showIndent(outfile, level)
            outfile.write('parentUri=%s,\n' % quote_python(self.parentUri).encode(ExternalEncoding))
        if self.portRange is not None:
            showIndent(outfile, level)
            outfile.write('portRange=%s,\n' % quote_python(self.portRange).encode(ExternalEncoding))
        if self.protocol is not None:
            showIndent(outfile, level)
            outfile.write('protocol=%s,\n' % quote_python(self.protocol).encode(ExternalEncoding))
        if self.source is not None:
            showIndent(outfile, level)
            outfile.write('source=%s,\n' % quote_python(self.source).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(rule, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'direction':
            direction_ = child_.text
            direction_ = self.gds_validate_string(direction_, node, 'direction')
            self.direction = direction_
        elif nodeName_ == 'parentUri':
            parentUri_ = child_.text
            parentUri_ = self.gds_validate_string(parentUri_, node, 'parentUri')
            self.parentUri = parentUri_
        elif nodeName_ == 'portRange':
            portRange_ = child_.text
            portRange_ = self.gds_validate_string(portRange_, node, 'portRange')
            self.portRange = portRange_
        elif nodeName_ == 'protocol':
            protocol_ = child_.text
            protocol_ = self.gds_validate_string(protocol_, node, 'protocol')
            self.protocol = protocol_
        elif nodeName_ == 'source':
            source_ = child_.text
            source_ = self.gds_validate_string(source_, node, 'source')
            self.source = source_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(rule, self).buildChildren(child_, node, nodeName_, True)
# end class rule


class networkZone(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, description=None, layers=None, parentUri=None, securityGroup=None, uri=None):
        super(networkZone, self).__init__(created, dbId, digest, lastModified, name, )
        self.description = description
        if layers is None:
            self.layers = []
        else:
            self.layers = layers
        self.parentUri = parentUri
        self.securityGroup = securityGroup
        self.uri = uri
    def factory(*args_, **kwargs_):
        if networkZone.subclass:
            return networkZone.subclass(*args_, **kwargs_)
        else:
            return networkZone(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_layers(self): return self.layers
    def set_layers(self, layers): self.layers = layers
    def add_layers(self, value): self.layers.append(value)
    def insert_layers(self, index, value): self.layers[index] = value
    def get_parentUri(self): return self.parentUri
    def set_parentUri(self, parentUri): self.parentUri = parentUri
    def get_securityGroup(self): return self.securityGroup
    def set_securityGroup(self, securityGroup): self.securityGroup = securityGroup
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def hasContent_(self):
        if (
            self.description is not None or
            self.layers or
            self.parentUri is not None or
            self.securityGroup is not None or
            self.uri is not None or
            super(networkZone, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='networkZone', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='networkZone')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='networkZone'):
        super(networkZone, self).exportAttributes(outfile, level, already_processed, namespace_, name_='networkZone')
    def exportChildren(self, outfile, level, namespace_='', name_='networkZone', fromsubclass_=False, pretty_print=True):
        super(networkZone, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_, eol_))
        for layers_ in self.layers:
            layers_.export(outfile, level, namespace_, name_='layers', pretty_print=pretty_print)
        if self.parentUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparentUri>%s</%sparentUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.parentUri).encode(ExternalEncoding), input_name='parentUri'), namespace_, eol_))
        if self.securityGroup is not None:
            self.securityGroup.export(outfile, level, namespace_, name_='securityGroup', pretty_print=pretty_print)
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='networkZone'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(networkZone, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(networkZone, self).exportLiteralChildren(outfile, level, name_)
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('layers=[\n')
        level += 1
        for layers_ in self.layers:
            showIndent(outfile, level)
            outfile.write('model_.blueprintLayer(\n')
            layers_.exportLiteral(outfile, level, name_='blueprintLayer')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.parentUri is not None:
            showIndent(outfile, level)
            outfile.write('parentUri=%s,\n' % quote_python(self.parentUri).encode(ExternalEncoding))
        if self.securityGroup is not None:
            showIndent(outfile, level)
            outfile.write('securityGroup=model_.securityGroup(\n')
            self.securityGroup.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(networkZone, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'layers':
            obj_ = blueprintLayer.factory()
            obj_.build(child_)
            self.layers.append(obj_)
        elif nodeName_ == 'parentUri':
            parentUri_ = child_.text
            parentUri_ = self.gds_validate_string(parentUri_, node, 'parentUri')
            self.parentUri = parentUri_
        elif nodeName_ == 'securityGroup':
            obj_ = securityGroup.factory()
            obj_.build(child_)
            self.securityGroup = obj_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(networkZone, self).buildChildren(child_, node, nodeName_, True)
# end class networkZone


class productAccess(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, allowed=None, cryptAlgo=None, email=None, expires=None, licenseContents=None, licenseKey=None, machineId=None, type_=None, uri=None):
        super(productAccess, self).__init__(created, dbId, digest, lastModified, name, )
        self.allowed = allowed
        self.cryptAlgo = cryptAlgo
        self.email = email
        if isinstance(expires, basestring):
            initvalue_ = datetime_.datetime.strptime(expires, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = expires
        self.expires = initvalue_
        self.licenseContents = licenseContents
        self.licenseKey = licenseKey
        self.machineId = machineId
        self.type_ = type_
        self.uri = uri
    def factory(*args_, **kwargs_):
        if productAccess.subclass:
            return productAccess.subclass(*args_, **kwargs_)
        else:
            return productAccess(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_allowed(self): return self.allowed
    def set_allowed(self, allowed): self.allowed = allowed
    def get_cryptAlgo(self): return self.cryptAlgo
    def set_cryptAlgo(self, cryptAlgo): self.cryptAlgo = cryptAlgo
    def get_email(self): return self.email
    def set_email(self, email): self.email = email
    def get_expires(self): return self.expires
    def set_expires(self, expires): self.expires = expires
    def get_licenseContents(self): return self.licenseContents
    def set_licenseContents(self, licenseContents): self.licenseContents = licenseContents
    def get_licenseKey(self): return self.licenseKey
    def set_licenseKey(self, licenseKey): self.licenseKey = licenseKey
    def get_machineId(self): return self.machineId
    def set_machineId(self, machineId): self.machineId = machineId
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def hasContent_(self):
        if (
            self.allowed is not None or
            self.cryptAlgo is not None or
            self.email is not None or
            self.expires is not None or
            self.licenseContents is not None or
            self.licenseKey is not None or
            self.machineId is not None or
            self.type_ is not None or
            self.uri is not None or
            super(productAccess, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='productAccess', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='productAccess')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='productAccess'):
        super(productAccess, self).exportAttributes(outfile, level, already_processed, namespace_, name_='productAccess')
    def exportChildren(self, outfile, level, namespace_='', name_='productAccess', fromsubclass_=False, pretty_print=True):
        super(productAccess, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.allowed is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sallowed>%s</%sallowed>%s' % (namespace_, self.gds_format_boolean(self.allowed, input_name='allowed'), namespace_, eol_))
        if self.cryptAlgo is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scryptAlgo>%s</%scryptAlgo>%s' % (namespace_, self.gds_format_integer(self.cryptAlgo, input_name='cryptAlgo'), namespace_, eol_))
        if self.email is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%semail>%s</%semail>%s' % (namespace_, self.gds_format_string(quote_xml(self.email).encode(ExternalEncoding), input_name='email'), namespace_, eol_))
        if self.expires is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sexpires>%s</%sexpires>%s' % (namespace_, self.gds_format_datetime(self.expires, input_name='expires'), namespace_, eol_))
        if self.licenseContents is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slicenseContents>%s</%slicenseContents>%s' % (namespace_, self.gds_format_string(quote_xml(self.licenseContents).encode(ExternalEncoding), input_name='licenseContents'), namespace_, eol_))
        if self.licenseKey is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slicenseKey>%s</%slicenseKey>%s' % (namespace_, self.gds_format_string(quote_xml(self.licenseKey).encode(ExternalEncoding), input_name='licenseKey'), namespace_, eol_))
        if self.machineId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smachineId>%s</%smachineId>%s' % (namespace_, self.gds_format_string(quote_xml(self.machineId).encode(ExternalEncoding), input_name='machineId'), namespace_, eol_))
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='productAccess'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(productAccess, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(productAccess, self).exportLiteralChildren(outfile, level, name_)
        if self.allowed is not None:
            showIndent(outfile, level)
            outfile.write('allowed=%s,\n' % self.allowed)
        if self.cryptAlgo is not None:
            showIndent(outfile, level)
            outfile.write('cryptAlgo=%d,\n' % self.cryptAlgo)
        if self.email is not None:
            showIndent(outfile, level)
            outfile.write('email=%s,\n' % quote_python(self.email).encode(ExternalEncoding))
        if self.expires is not None:
            showIndent(outfile, level)
            outfile.write('expires=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.expires, input_name='expires'))
        if self.licenseContents is not None:
            showIndent(outfile, level)
            outfile.write('licenseContents=%s,\n' % quote_python(self.licenseContents).encode(ExternalEncoding))
        if self.licenseKey is not None:
            showIndent(outfile, level)
            outfile.write('licenseKey=%s,\n' % quote_python(self.licenseKey).encode(ExternalEncoding))
        if self.machineId is not None:
            showIndent(outfile, level)
            outfile.write('machineId=%s,\n' % quote_python(self.machineId).encode(ExternalEncoding))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(productAccess, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'allowed':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'allowed')
            self.allowed = ival_
        elif nodeName_ == 'cryptAlgo':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'cryptAlgo')
            self.cryptAlgo = ival_
        elif nodeName_ == 'email':
            email_ = child_.text
            email_ = self.gds_validate_string(email_, node, 'email')
            self.email = email_
        elif nodeName_ == 'expires':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.expires = dval_
        elif nodeName_ == 'licenseContents':
            licenseContents_ = child_.text
            licenseContents_ = self.gds_validate_string(licenseContents_, node, 'licenseContents')
            self.licenseContents = licenseContents_
        elif nodeName_ == 'licenseKey':
            licenseKey_ = child_.text
            licenseKey_ = self.gds_validate_string(licenseKey_, node, 'licenseKey')
            self.licenseKey = licenseKey_
        elif nodeName_ == 'machineId':
            machineId_ = child_.text
            machineId_ = self.gds_validate_string(machineId_, node, 'machineId')
            self.machineId = machineId_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(productAccess, self).buildChildren(child_, node, nodeName_, True)
# end class productAccess


class ranking(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, applianceURI=None, rank=None, uri=None):
        super(ranking, self).__init__(created, dbId, digest, lastModified, name, )
        self.applianceURI = applianceURI
        self.rank = rank
        self.uri = uri
    def factory(*args_, **kwargs_):
        if ranking.subclass:
            return ranking.subclass(*args_, **kwargs_)
        else:
            return ranking(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_applianceURI(self): return self.applianceURI
    def set_applianceURI(self, applianceURI): self.applianceURI = applianceURI
    def get_rank(self): return self.rank
    def set_rank(self, rank): self.rank = rank
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def hasContent_(self):
        if (
            self.applianceURI is not None or
            self.rank is not None or
            self.uri is not None or
            super(ranking, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ranking', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ranking')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ranking'):
        super(ranking, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ranking')
    def exportChildren(self, outfile, level, namespace_='', name_='ranking', fromsubclass_=False, pretty_print=True):
        super(ranking, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.applianceURI is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sapplianceURI>%s</%sapplianceURI>%s' % (namespace_, self.gds_format_string(quote_xml(self.applianceURI).encode(ExternalEncoding), input_name='applianceURI'), namespace_, eol_))
        if self.rank is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srank>%s</%srank>%s' % (namespace_, self.gds_format_integer(self.rank, input_name='rank'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='ranking'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(ranking, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ranking, self).exportLiteralChildren(outfile, level, name_)
        if self.applianceURI is not None:
            showIndent(outfile, level)
            outfile.write('applianceURI=%s,\n' % quote_python(self.applianceURI).encode(ExternalEncoding))
        if self.rank is not None:
            showIndent(outfile, level)
            outfile.write('rank=%d,\n' % self.rank)
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ranking, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'applianceURI':
            applianceURI_ = child_.text
            applianceURI_ = self.gds_validate_string(applianceURI_, node, 'applianceURI')
            self.applianceURI = applianceURI_
        elif nodeName_ == 'rank':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'rank')
            self.rank = ival_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(ranking, self).buildChildren(child_, node, nodeName_, True)
# end class ranking


class role(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, description=None, entitlements=None):
        super(role, self).__init__(created, dbId, digest, lastModified, name, )
        self.description = description
        self.entitlements = entitlements
    def factory(*args_, **kwargs_):
        if role.subclass:
            return role.subclass(*args_, **kwargs_)
        else:
            return role(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_entitlements(self): return self.entitlements
    def set_entitlements(self, entitlements): self.entitlements = entitlements
    def hasContent_(self):
        if (
            self.description is not None or
            self.entitlements is not None or
            super(role, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='role', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='role')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='role'):
        super(role, self).exportAttributes(outfile, level, already_processed, namespace_, name_='role')
    def exportChildren(self, outfile, level, namespace_='', name_='role', fromsubclass_=False, pretty_print=True):
        super(role, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_, eol_))
        if self.entitlements is not None:
            self.entitlements.export(outfile, level, namespace_, name_='entitlements', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='role'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(role, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(role, self).exportLiteralChildren(outfile, level, name_)
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        if self.entitlements is not None:
            showIndent(outfile, level)
            outfile.write('entitlements=model_.entitlements(\n')
            self.entitlements.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(role, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'entitlements':
            obj_ = entitlements.factory()
            obj_.build(child_)
            self.entitlements = obj_
        super(role, self).buildChildren(child_, node, nodeName_, True)
# end class role


class entitlements(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, entitlement=None):
        if entitlement is None:
            self.entitlement = []
        else:
            self.entitlement = entitlement
    def factory(*args_, **kwargs_):
        if entitlements.subclass:
            return entitlements.subclass(*args_, **kwargs_)
        else:
            return entitlements(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_entitlement(self): return self.entitlement
    def set_entitlement(self, entitlement): self.entitlement = entitlement
    def add_entitlement(self, value): self.entitlement.append(value)
    def insert_entitlement(self, index, value): self.entitlement[index] = value
    def hasContent_(self):
        if (
            self.entitlement
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='entitlements', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='entitlements')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='entitlements'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='entitlements', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for entitlement_ in self.entitlement:
            entitlement_.export(outfile, level, namespace_, name_='entitlement', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='entitlements'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('entitlement=[\n')
        level += 1
        for entitlement_ in self.entitlement:
            showIndent(outfile, level)
            outfile.write('model_.entitlement(\n')
            entitlement_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'entitlement':
            obj_ = entitlement.factory()
            obj_.build(child_)
            self.entitlement.append(obj_)
# end class entitlements


class entitlement(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, description=None, name=None):
        self.description = description
        self.name = name
    def factory(*args_, **kwargs_):
        if entitlement.subclass:
            return entitlement.subclass(*args_, **kwargs_)
        else:
            return entitlement(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def hasContent_(self):
        if (
            self.description is not None or
            self.name is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='entitlement', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='entitlement')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='entitlement'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='entitlement', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_, eol_))
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name).encode(ExternalEncoding), input_name='name'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='entitlement'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
# end class entitlement


class tag(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, uri=None):
        super(tag, self).__init__(created, dbId, digest, lastModified, name, )
        self.uri = uri
    def factory(*args_, **kwargs_):
        if tag.subclass:
            return tag.subclass(*args_, **kwargs_)
        else:
            return tag(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def hasContent_(self):
        if (
            self.uri is not None or
            super(tag, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='tag', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='tag')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='tag'):
        super(tag, self).exportAttributes(outfile, level, already_processed, namespace_, name_='tag')
    def exportChildren(self, outfile, level, namespace_='', name_='tag', fromsubclass_=False, pretty_print=True):
        super(tag, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='tag'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(tag, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(tag, self).exportLiteralChildren(outfile, level, name_)
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(tag, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(tag, self).buildChildren(child_, node, nodeName_, True)
# end class tag


class userResourcesRights(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, apiAccess=None, apiKeysQuota=None, baseApiKeysUri=None, builderAccess=None, canCreateWorkspace=None, canMigrate=None, canProvision=None, galleryAccess=None, orgResourcesAccessRightsUri=None, uri=None, user=None, vAppAccess=None):
        super(userResourcesRights, self).__init__(created, dbId, digest, lastModified, name, )
        self.apiAccess = apiAccess
        self.apiKeysQuota = apiKeysQuota
        self.baseApiKeysUri = baseApiKeysUri
        self.builderAccess = builderAccess
        self.canCreateWorkspace = canCreateWorkspace
        self.canMigrate = canMigrate
        self.canProvision = canProvision
        self.galleryAccess = galleryAccess
        self.orgResourcesAccessRightsUri = orgResourcesAccessRightsUri
        self.uri = uri
        self.user = user
        self.vAppAccess = vAppAccess
    def factory(*args_, **kwargs_):
        if userResourcesRights.subclass:
            return userResourcesRights.subclass(*args_, **kwargs_)
        else:
            return userResourcesRights(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_apiAccess(self): return self.apiAccess
    def set_apiAccess(self, apiAccess): self.apiAccess = apiAccess
    def get_apiKeysQuota(self): return self.apiKeysQuota
    def set_apiKeysQuota(self, apiKeysQuota): self.apiKeysQuota = apiKeysQuota
    def get_baseApiKeysUri(self): return self.baseApiKeysUri
    def set_baseApiKeysUri(self, baseApiKeysUri): self.baseApiKeysUri = baseApiKeysUri
    def get_builderAccess(self): return self.builderAccess
    def set_builderAccess(self, builderAccess): self.builderAccess = builderAccess
    def get_canCreateWorkspace(self): return self.canCreateWorkspace
    def set_canCreateWorkspace(self, canCreateWorkspace): self.canCreateWorkspace = canCreateWorkspace
    def get_canMigrate(self): return self.canMigrate
    def set_canMigrate(self, canMigrate): self.canMigrate = canMigrate
    def get_canProvision(self): return self.canProvision
    def set_canProvision(self, canProvision): self.canProvision = canProvision
    def get_galleryAccess(self): return self.galleryAccess
    def set_galleryAccess(self, galleryAccess): self.galleryAccess = galleryAccess
    def get_orgResourcesAccessRightsUri(self): return self.orgResourcesAccessRightsUri
    def set_orgResourcesAccessRightsUri(self, orgResourcesAccessRightsUri): self.orgResourcesAccessRightsUri = orgResourcesAccessRightsUri
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_user(self): return self.user
    def set_user(self, user): self.user = user
    def get_vAppAccess(self): return self.vAppAccess
    def set_vAppAccess(self, vAppAccess): self.vAppAccess = vAppAccess
    def hasContent_(self):
        if (
            self.apiAccess is not None or
            self.apiKeysQuota is not None or
            self.baseApiKeysUri is not None or
            self.builderAccess is not None or
            self.canCreateWorkspace is not None or
            self.canMigrate is not None or
            self.canProvision is not None or
            self.galleryAccess is not None or
            self.orgResourcesAccessRightsUri is not None or
            self.uri is not None or
            self.user is not None or
            self.vAppAccess is not None or
            super(userResourcesRights, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='userResourcesRights', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='userResourcesRights')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='userResourcesRights'):
        super(userResourcesRights, self).exportAttributes(outfile, level, already_processed, namespace_, name_='userResourcesRights')
    def exportChildren(self, outfile, level, namespace_='', name_='userResourcesRights', fromsubclass_=False, pretty_print=True):
        super(userResourcesRights, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.apiAccess is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sapiAccess>%s</%sapiAccess>%s' % (namespace_, self.gds_format_boolean(self.apiAccess, input_name='apiAccess'), namespace_, eol_))
        if self.apiKeysQuota is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sapiKeysQuota>%s</%sapiKeysQuota>%s' % (namespace_, self.gds_format_integer(self.apiKeysQuota, input_name='apiKeysQuota'), namespace_, eol_))
        if self.baseApiKeysUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseApiKeysUri>%s</%sbaseApiKeysUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseApiKeysUri).encode(ExternalEncoding), input_name='baseApiKeysUri'), namespace_, eol_))
        if self.builderAccess is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbuilderAccess>%s</%sbuilderAccess>%s' % (namespace_, self.gds_format_boolean(self.builderAccess, input_name='builderAccess'), namespace_, eol_))
        if self.canCreateWorkspace is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scanCreateWorkspace>%s</%scanCreateWorkspace>%s' % (namespace_, self.gds_format_boolean(self.canCreateWorkspace, input_name='canCreateWorkspace'), namespace_, eol_))
        if self.canMigrate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scanMigrate>%s</%scanMigrate>%s' % (namespace_, self.gds_format_boolean(self.canMigrate, input_name='canMigrate'), namespace_, eol_))
        if self.canProvision is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scanProvision>%s</%scanProvision>%s' % (namespace_, self.gds_format_boolean(self.canProvision, input_name='canProvision'), namespace_, eol_))
        if self.galleryAccess is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgalleryAccess>%s</%sgalleryAccess>%s' % (namespace_, self.gds_format_boolean(self.galleryAccess, input_name='galleryAccess'), namespace_, eol_))
        if self.orgResourcesAccessRightsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorgResourcesAccessRightsUri>%s</%sorgResourcesAccessRightsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.orgResourcesAccessRightsUri).encode(ExternalEncoding), input_name='orgResourcesAccessRightsUri'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
        if self.user is not None:
            self.user.export(outfile, level, namespace_, name_='user', pretty_print=pretty_print)
        if self.vAppAccess is not None:
            self.vAppAccess.export(outfile, level, namespace_, name_='vAppAccess', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='userResourcesRights'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(userResourcesRights, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(userResourcesRights, self).exportLiteralChildren(outfile, level, name_)
        if self.apiAccess is not None:
            showIndent(outfile, level)
            outfile.write('apiAccess=%s,\n' % self.apiAccess)
        if self.apiKeysQuota is not None:
            showIndent(outfile, level)
            outfile.write('apiKeysQuota=%d,\n' % self.apiKeysQuota)
        if self.baseApiKeysUri is not None:
            showIndent(outfile, level)
            outfile.write('baseApiKeysUri=%s,\n' % quote_python(self.baseApiKeysUri).encode(ExternalEncoding))
        if self.builderAccess is not None:
            showIndent(outfile, level)
            outfile.write('builderAccess=%s,\n' % self.builderAccess)
        if self.canCreateWorkspace is not None:
            showIndent(outfile, level)
            outfile.write('canCreateWorkspace=%s,\n' % self.canCreateWorkspace)
        if self.canMigrate is not None:
            showIndent(outfile, level)
            outfile.write('canMigrate=%s,\n' % self.canMigrate)
        if self.canProvision is not None:
            showIndent(outfile, level)
            outfile.write('canProvision=%s,\n' % self.canProvision)
        if self.galleryAccess is not None:
            showIndent(outfile, level)
            outfile.write('galleryAccess=%s,\n' % self.galleryAccess)
        if self.orgResourcesAccessRightsUri is not None:
            showIndent(outfile, level)
            outfile.write('orgResourcesAccessRightsUri=%s,\n' % quote_python(self.orgResourcesAccessRightsUri).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.user is not None:
            showIndent(outfile, level)
            outfile.write('user=model_.user(\n')
            self.user.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.vAppAccess is not None:
            showIndent(outfile, level)
            outfile.write('vAppAccess=model_.vAppAccess(\n')
            self.vAppAccess.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(userResourcesRights, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'apiAccess':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'apiAccess')
            self.apiAccess = ival_
        elif nodeName_ == 'apiKeysQuota':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'apiKeysQuota')
            self.apiKeysQuota = ival_
        elif nodeName_ == 'baseApiKeysUri':
            baseApiKeysUri_ = child_.text
            baseApiKeysUri_ = self.gds_validate_string(baseApiKeysUri_, node, 'baseApiKeysUri')
            self.baseApiKeysUri = baseApiKeysUri_
        elif nodeName_ == 'builderAccess':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'builderAccess')
            self.builderAccess = ival_
        elif nodeName_ == 'canCreateWorkspace':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'canCreateWorkspace')
            self.canCreateWorkspace = ival_
        elif nodeName_ == 'canMigrate':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'canMigrate')
            self.canMigrate = ival_
        elif nodeName_ == 'canProvision':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'canProvision')
            self.canProvision = ival_
        elif nodeName_ == 'galleryAccess':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'galleryAccess')
            self.galleryAccess = ival_
        elif nodeName_ == 'orgResourcesAccessRightsUri':
            orgResourcesAccessRightsUri_ = child_.text
            orgResourcesAccessRightsUri_ = self.gds_validate_string(orgResourcesAccessRightsUri_, node, 'orgResourcesAccessRightsUri')
            self.orgResourcesAccessRightsUri = orgResourcesAccessRightsUri_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'user':
            obj_ = user.factory()
            obj_.build(child_)
            self.user = obj_
        elif nodeName_ == 'vAppAccess':
            obj_ = vAppAccess.factory()
            obj_.build(child_)
            self.vAppAccess = obj_
        super(userResourcesRights, self).buildChildren(child_, node, nodeName_, True)
# end class userResourcesRights


class vAppAccess(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, allowed=None, cryptAlgo=None, expires=None, licenseContents=None, licenseKey=None, machineId=None, uri=None):
        super(vAppAccess, self).__init__(created, dbId, digest, lastModified, name, )
        self.allowed = allowed
        self.cryptAlgo = cryptAlgo
        if isinstance(expires, basestring):
            initvalue_ = datetime_.datetime.strptime(expires, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = expires
        self.expires = initvalue_
        self.licenseContents = licenseContents
        self.licenseKey = licenseKey
        self.machineId = machineId
        self.uri = uri
    def factory(*args_, **kwargs_):
        if vAppAccess.subclass:
            return vAppAccess.subclass(*args_, **kwargs_)
        else:
            return vAppAccess(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_allowed(self): return self.allowed
    def set_allowed(self, allowed): self.allowed = allowed
    def get_cryptAlgo(self): return self.cryptAlgo
    def set_cryptAlgo(self, cryptAlgo): self.cryptAlgo = cryptAlgo
    def get_expires(self): return self.expires
    def set_expires(self, expires): self.expires = expires
    def get_licenseContents(self): return self.licenseContents
    def set_licenseContents(self, licenseContents): self.licenseContents = licenseContents
    def get_licenseKey(self): return self.licenseKey
    def set_licenseKey(self, licenseKey): self.licenseKey = licenseKey
    def get_machineId(self): return self.machineId
    def set_machineId(self, machineId): self.machineId = machineId
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def hasContent_(self):
        if (
            self.allowed is not None or
            self.cryptAlgo is not None or
            self.expires is not None or
            self.licenseContents is not None or
            self.licenseKey is not None or
            self.machineId is not None or
            self.uri is not None or
            super(vAppAccess, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='vAppAccess', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='vAppAccess')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='vAppAccess'):
        super(vAppAccess, self).exportAttributes(outfile, level, already_processed, namespace_, name_='vAppAccess')
    def exportChildren(self, outfile, level, namespace_='', name_='vAppAccess', fromsubclass_=False, pretty_print=True):
        super(vAppAccess, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.allowed is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sallowed>%s</%sallowed>%s' % (namespace_, self.gds_format_boolean(self.allowed, input_name='allowed'), namespace_, eol_))
        if self.cryptAlgo is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scryptAlgo>%s</%scryptAlgo>%s' % (namespace_, self.gds_format_integer(self.cryptAlgo, input_name='cryptAlgo'), namespace_, eol_))
        if self.expires is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sexpires>%s</%sexpires>%s' % (namespace_, self.gds_format_datetime(self.expires, input_name='expires'), namespace_, eol_))
        if self.licenseContents is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slicenseContents>%s</%slicenseContents>%s' % (namespace_, self.gds_format_string(quote_xml(self.licenseContents).encode(ExternalEncoding), input_name='licenseContents'), namespace_, eol_))
        if self.licenseKey is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slicenseKey>%s</%slicenseKey>%s' % (namespace_, self.gds_format_string(quote_xml(self.licenseKey).encode(ExternalEncoding), input_name='licenseKey'), namespace_, eol_))
        if self.machineId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smachineId>%s</%smachineId>%s' % (namespace_, self.gds_format_string(quote_xml(self.machineId).encode(ExternalEncoding), input_name='machineId'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='vAppAccess'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(vAppAccess, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(vAppAccess, self).exportLiteralChildren(outfile, level, name_)
        if self.allowed is not None:
            showIndent(outfile, level)
            outfile.write('allowed=%s,\n' % self.allowed)
        if self.cryptAlgo is not None:
            showIndent(outfile, level)
            outfile.write('cryptAlgo=%d,\n' % self.cryptAlgo)
        if self.expires is not None:
            showIndent(outfile, level)
            outfile.write('expires=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.expires, input_name='expires'))
        if self.licenseContents is not None:
            showIndent(outfile, level)
            outfile.write('licenseContents=%s,\n' % quote_python(self.licenseContents).encode(ExternalEncoding))
        if self.licenseKey is not None:
            showIndent(outfile, level)
            outfile.write('licenseKey=%s,\n' % quote_python(self.licenseKey).encode(ExternalEncoding))
        if self.machineId is not None:
            showIndent(outfile, level)
            outfile.write('machineId=%s,\n' % quote_python(self.machineId).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(vAppAccess, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'allowed':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'allowed')
            self.allowed = ival_
        elif nodeName_ == 'cryptAlgo':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'cryptAlgo')
            self.cryptAlgo = ival_
        elif nodeName_ == 'expires':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.expires = dval_
        elif nodeName_ == 'licenseContents':
            licenseContents_ = child_.text
            licenseContents_ = self.gds_validate_string(licenseContents_, node, 'licenseContents')
            self.licenseContents = licenseContents_
        elif nodeName_ == 'licenseKey':
            licenseKey_ = child_.text
            licenseKey_ = self.gds_validate_string(licenseKey_, node, 'licenseKey')
            self.licenseKey = licenseKey_
        elif nodeName_ == 'machineId':
            machineId_ = child_.text
            machineId_ = self.gds_validate_string(machineId_, node, 'machineId')
            self.machineId = machineId_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(vAppAccess, self).buildChildren(child_, node, nodeName_, True)
# end class vAppAccess


class credAccountResources(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, resources=None):
        self.resources = resources
    def factory(*args_, **kwargs_):
        if credAccountResources.subclass:
            return credAccountResources.subclass(*args_, **kwargs_)
        else:
            return credAccountResources(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_resources(self): return self.resources
    def set_resources(self, resources): self.resources = resources
    def hasContent_(self):
        if (
            self.resources is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='credAccountResources', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='credAccountResources')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='credAccountResources'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='credAccountResources', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.resources is not None:
            self.resources.export(outfile, level, namespace_, name_='resources', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='credAccountResources'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.resources is not None:
            showIndent(outfile, level)
            outfile.write('resources=model_.resources(\n')
            self.resources.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'resources':
            obj_ = resources.factory()
            obj_.build(child_)
            self.resources = obj_
# end class credAccountResources


class resources(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, resource=None):
        if resource is None:
            self.resource = []
        else:
            self.resource = resource
    def factory(*args_, **kwargs_):
        if resources.subclass:
            return resources.subclass(*args_, **kwargs_)
        else:
            return resources(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_resource(self): return self.resource
    def set_resource(self, resource): self.resource = resource
    def add_resource(self, value): self.resource.append(value)
    def insert_resource(self, index, value): self.resource[index] = value
    def hasContent_(self):
        if (
            self.resource
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='resources', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='resources')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='resources'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='resources', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for resource_ in self.resource:
            resource_.export(outfile, level, namespace_, name_='resource', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='resources'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('resource=[\n')
        level += 1
        for resource_ in self.resource:
            showIndent(outfile, level)
            outfile.write('model_.credAccountResource(\n')
            resource_.exportLiteral(outfile, level, name_='credAccountResource')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'resource':
            obj_ = credAccountResource.factory()
            obj_.build(child_)
            self.resource.append(obj_)
# end class resources


class credAccountResource(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, key=None, type_=None, value=None):
        self.key = key
        self.type_ = type_
        self.value = value
    def factory(*args_, **kwargs_):
        if credAccountResource.subclass:
            return credAccountResource.subclass(*args_, **kwargs_)
        else:
            return credAccountResource(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_key(self): return self.key
    def set_key(self, key): self.key = key
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def hasContent_(self):
        if (
            self.key is not None or
            self.type_ is not None or
            self.value is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='credAccountResource', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='credAccountResource')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='credAccountResource'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='credAccountResource', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.key is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skey>%s</%skey>%s' % (namespace_, self.gds_format_string(quote_xml(self.key).encode(ExternalEncoding), input_name='key'), namespace_, eol_))
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_string(quote_xml(self.value).encode(ExternalEncoding), input_name='value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='credAccountResource'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.key is not None:
            showIndent(outfile, level)
            outfile.write('key=%s,\n' % quote_python(self.key).encode(ExternalEncoding))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'key':
            key_ = child_.text
            key_ = self.gds_validate_string(key_, node, 'key')
            self.key = key_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
# end class credAccountResource


class localizedMessage(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, message=None, messageId=None, parameters=None):
        self.message = message
        self.messageId = messageId
        self.parameters = parameters
    def factory(*args_, **kwargs_):
        if localizedMessage.subclass:
            return localizedMessage.subclass(*args_, **kwargs_)
        else:
            return localizedMessage(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_message(self): return self.message
    def set_message(self, message): self.message = message
    def get_messageId(self): return self.messageId
    def set_messageId(self, messageId): self.messageId = messageId
    def get_parameters(self): return self.parameters
    def set_parameters(self, parameters): self.parameters = parameters
    def hasContent_(self):
        if (
            self.message is not None or
            self.messageId is not None or
            self.parameters is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='localizedMessage', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='localizedMessage')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='localizedMessage'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='localizedMessage', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.message is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smessage>%s</%smessage>%s' % (namespace_, self.gds_format_string(quote_xml(self.message).encode(ExternalEncoding), input_name='message'), namespace_, eol_))
        if self.messageId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smessageId>%s</%smessageId>%s' % (namespace_, self.gds_format_string(quote_xml(self.messageId).encode(ExternalEncoding), input_name='messageId'), namespace_, eol_))
        if self.parameters is not None:
            self.parameters.export(outfile, level, namespace_, name_='parameters', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='localizedMessage'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.message is not None:
            showIndent(outfile, level)
            outfile.write('message=%s,\n' % quote_python(self.message).encode(ExternalEncoding))
        if self.messageId is not None:
            showIndent(outfile, level)
            outfile.write('messageId=%s,\n' % quote_python(self.messageId).encode(ExternalEncoding))
        if self.parameters is not None:
            showIndent(outfile, level)
            outfile.write('parameters=model_.parameters(\n')
            self.parameters.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'message':
            message_ = child_.text
            message_ = self.gds_validate_string(message_, node, 'message')
            self.message = message_
        elif nodeName_ == 'messageId':
            messageId_ = child_.text
            messageId_ = self.gds_validate_string(messageId_, node, 'messageId')
            self.messageId = messageId_
        elif nodeName_ == 'parameters':
            obj_ = parameters.factory()
            obj_.build(child_)
            self.parameters = obj_
# end class localizedMessage


class parameters(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, parameters=None):
        if parameters is None:
            self.parameters = []
        else:
            self.parameters = parameters
    def factory(*args_, **kwargs_):
        if parameters.subclass:
            return parameters.subclass(*args_, **kwargs_)
        else:
            return parameters(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_parameters(self): return self.parameters
    def set_parameters(self, parameters): self.parameters = parameters
    def add_parameters(self, value): self.parameters.append(value)
    def insert_parameters(self, index, value): self.parameters[index] = value
    def hasContent_(self):
        if (
            self.parameters
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='parameters', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='parameters')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='parameters'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='parameters', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for parameters_ in self.parameters:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparameters>%s</%sparameters>%s' % (namespace_, self.gds_format_string(quote_xml(parameters_).encode(ExternalEncoding), input_name='parameters'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='parameters'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('parameters=[\n')
        level += 1
        for parameters_ in self.parameters:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(parameters_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'parameters':
            parameters_ = child_.text
            parameters_ = self.gds_validate_string(parameters_, node, 'parameters')
            self.parameters.append(parameters_)
# end class parameters


class statDataPoints(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, statDataPoint=None):
        if statDataPoint is None:
            self.statDataPoint = []
        else:
            self.statDataPoint = statDataPoint
    def factory(*args_, **kwargs_):
        if statDataPoints.subclass:
            return statDataPoints.subclass(*args_, **kwargs_)
        else:
            return statDataPoints(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_statDataPoint(self): return self.statDataPoint
    def set_statDataPoint(self, statDataPoint): self.statDataPoint = statDataPoint
    def add_statDataPoint(self, value): self.statDataPoint.append(value)
    def insert_statDataPoint(self, index, value): self.statDataPoint[index] = value
    def hasContent_(self):
        if (
            self.statDataPoint
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='statDataPoints', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='statDataPoints')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='statDataPoints'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='statDataPoints', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for statDataPoint_ in self.statDataPoint:
            statDataPoint_.export(outfile, level, namespace_, name_='statDataPoint', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='statDataPoints'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('statDataPoint=[\n')
        level += 1
        for statDataPoint_ in self.statDataPoint:
            showIndent(outfile, level)
            outfile.write('model_.statDataPoint(\n')
            statDataPoint_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'statDataPoint':
            obj_ = statDataPoint.factory()
            obj_.build(child_)
            self.statDataPoint.append(obj_)
# end class statDataPoints


class statDataPoint(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, date=None, distribArch=None, distribName=None, distribVersion=None, endDate=None, errorMessage=None, message=None, nb=None, percentage=None, startDate=None, total=None, type_=None, userCrmId=None, version=None):
        super(statDataPoint, self).__init__(created, dbId, digest, lastModified, name, )
        if isinstance(date, basestring):
            initvalue_ = datetime_.datetime.strptime(date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = date
        self.date = initvalue_
        self.distribArch = distribArch
        self.distribName = distribName
        self.distribVersion = distribVersion
        if isinstance(endDate, basestring):
            initvalue_ = datetime_.datetime.strptime(endDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = endDate
        self.endDate = initvalue_
        self.errorMessage = errorMessage
        self.message = message
        self.nb = nb
        self.percentage = percentage
        if isinstance(startDate, basestring):
            initvalue_ = datetime_.datetime.strptime(startDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = startDate
        self.startDate = initvalue_
        self.total = total
        self.type_ = type_
        self.userCrmId = userCrmId
        self.version = version
    def factory(*args_, **kwargs_):
        if statDataPoint.subclass:
            return statDataPoint.subclass(*args_, **kwargs_)
        else:
            return statDataPoint(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_date(self): return self.date
    def set_date(self, date): self.date = date
    def get_distribArch(self): return self.distribArch
    def set_distribArch(self, distribArch): self.distribArch = distribArch
    def get_distribName(self): return self.distribName
    def set_distribName(self, distribName): self.distribName = distribName
    def get_distribVersion(self): return self.distribVersion
    def set_distribVersion(self, distribVersion): self.distribVersion = distribVersion
    def get_endDate(self): return self.endDate
    def set_endDate(self, endDate): self.endDate = endDate
    def get_errorMessage(self): return self.errorMessage
    def set_errorMessage(self, errorMessage): self.errorMessage = errorMessage
    def get_message(self): return self.message
    def set_message(self, message): self.message = message
    def get_nb(self): return self.nb
    def set_nb(self, nb): self.nb = nb
    def get_percentage(self): return self.percentage
    def set_percentage(self, percentage): self.percentage = percentage
    def get_startDate(self): return self.startDate
    def set_startDate(self, startDate): self.startDate = startDate
    def get_total(self): return self.total
    def set_total(self, total): self.total = total
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_userCrmId(self): return self.userCrmId
    def set_userCrmId(self, userCrmId): self.userCrmId = userCrmId
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def hasContent_(self):
        if (
            self.date is not None or
            self.distribArch is not None or
            self.distribName is not None or
            self.distribVersion is not None or
            self.endDate is not None or
            self.errorMessage is not None or
            self.message is not None or
            self.nb is not None or
            self.percentage is not None or
            self.startDate is not None or
            self.total is not None or
            self.type_ is not None or
            self.userCrmId is not None or
            self.version is not None or
            super(statDataPoint, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='statDataPoint', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='statDataPoint')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='statDataPoint'):
        super(statDataPoint, self).exportAttributes(outfile, level, already_processed, namespace_, name_='statDataPoint')
    def exportChildren(self, outfile, level, namespace_='', name_='statDataPoint', fromsubclass_=False, pretty_print=True):
        super(statDataPoint, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.date is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdate>%s</%sdate>%s' % (namespace_, self.gds_format_datetime(self.date, input_name='date'), namespace_, eol_))
        if self.distribArch is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdistribArch>%s</%sdistribArch>%s' % (namespace_, self.gds_format_string(quote_xml(self.distribArch).encode(ExternalEncoding), input_name='distribArch'), namespace_, eol_))
        if self.distribName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdistribName>%s</%sdistribName>%s' % (namespace_, self.gds_format_string(quote_xml(self.distribName).encode(ExternalEncoding), input_name='distribName'), namespace_, eol_))
        if self.distribVersion is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdistribVersion>%s</%sdistribVersion>%s' % (namespace_, self.gds_format_string(quote_xml(self.distribVersion).encode(ExternalEncoding), input_name='distribVersion'), namespace_, eol_))
        if self.endDate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sendDate>%s</%sendDate>%s' % (namespace_, self.gds_format_datetime(self.endDate, input_name='endDate'), namespace_, eol_))
        if self.errorMessage is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serrorMessage>%s</%serrorMessage>%s' % (namespace_, self.gds_format_string(quote_xml(self.errorMessage).encode(ExternalEncoding), input_name='errorMessage'), namespace_, eol_))
        if self.message is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smessage>%s</%smessage>%s' % (namespace_, self.gds_format_string(quote_xml(self.message).encode(ExternalEncoding), input_name='message'), namespace_, eol_))
        if self.nb is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snb>%s</%snb>%s' % (namespace_, self.gds_format_integer(self.nb, input_name='nb'), namespace_, eol_))
        if self.percentage is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spercentage>%s</%spercentage>%s' % (namespace_, self.gds_format_float(self.percentage, input_name='percentage'), namespace_, eol_))
        if self.startDate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstartDate>%s</%sstartDate>%s' % (namespace_, self.gds_format_datetime(self.startDate, input_name='startDate'), namespace_, eol_))
        if self.total is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stotal>%s</%stotal>%s' % (namespace_, self.gds_format_integer(self.total, input_name='total'), namespace_, eol_))
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.userCrmId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suserCrmId>%s</%suserCrmId>%s' % (namespace_, self.gds_format_string(quote_xml(self.userCrmId).encode(ExternalEncoding), input_name='userCrmId'), namespace_, eol_))
        if self.version is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sversion>%s</%sversion>%s' % (namespace_, self.gds_format_string(quote_xml(self.version).encode(ExternalEncoding), input_name='version'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='statDataPoint'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(statDataPoint, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(statDataPoint, self).exportLiteralChildren(outfile, level, name_)
        if self.date is not None:
            showIndent(outfile, level)
            outfile.write('date=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.date, input_name='date'))
        if self.distribArch is not None:
            showIndent(outfile, level)
            outfile.write('distribArch=%s,\n' % quote_python(self.distribArch).encode(ExternalEncoding))
        if self.distribName is not None:
            showIndent(outfile, level)
            outfile.write('distribName=%s,\n' % quote_python(self.distribName).encode(ExternalEncoding))
        if self.distribVersion is not None:
            showIndent(outfile, level)
            outfile.write('distribVersion=%s,\n' % quote_python(self.distribVersion).encode(ExternalEncoding))
        if self.endDate is not None:
            showIndent(outfile, level)
            outfile.write('endDate=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.endDate, input_name='endDate'))
        if self.errorMessage is not None:
            showIndent(outfile, level)
            outfile.write('errorMessage=%s,\n' % quote_python(self.errorMessage).encode(ExternalEncoding))
        if self.message is not None:
            showIndent(outfile, level)
            outfile.write('message=%s,\n' % quote_python(self.message).encode(ExternalEncoding))
        if self.nb is not None:
            showIndent(outfile, level)
            outfile.write('nb=%d,\n' % self.nb)
        if self.percentage is not None:
            showIndent(outfile, level)
            outfile.write('percentage=%f,\n' % self.percentage)
        if self.startDate is not None:
            showIndent(outfile, level)
            outfile.write('startDate=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.startDate, input_name='startDate'))
        if self.total is not None:
            showIndent(outfile, level)
            outfile.write('total=%d,\n' % self.total)
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.userCrmId is not None:
            showIndent(outfile, level)
            outfile.write('userCrmId=%s,\n' % quote_python(self.userCrmId).encode(ExternalEncoding))
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version=%s,\n' % quote_python(self.version).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(statDataPoint, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.date = dval_
        elif nodeName_ == 'distribArch':
            distribArch_ = child_.text
            distribArch_ = self.gds_validate_string(distribArch_, node, 'distribArch')
            self.distribArch = distribArch_
        elif nodeName_ == 'distribName':
            distribName_ = child_.text
            distribName_ = self.gds_validate_string(distribName_, node, 'distribName')
            self.distribName = distribName_
        elif nodeName_ == 'distribVersion':
            distribVersion_ = child_.text
            distribVersion_ = self.gds_validate_string(distribVersion_, node, 'distribVersion')
            self.distribVersion = distribVersion_
        elif nodeName_ == 'endDate':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.endDate = dval_
        elif nodeName_ == 'errorMessage':
            errorMessage_ = child_.text
            errorMessage_ = self.gds_validate_string(errorMessage_, node, 'errorMessage')
            self.errorMessage = errorMessage_
        elif nodeName_ == 'message':
            message_ = child_.text
            message_ = self.gds_validate_string(message_, node, 'message')
            self.message = message_
        elif nodeName_ == 'nb':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'nb')
            self.nb = ival_
        elif nodeName_ == 'percentage':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'percentage')
            self.percentage = fval_
        elif nodeName_ == 'startDate':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.startDate = dval_
        elif nodeName_ == 'total':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'total')
            self.total = ival_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'userCrmId':
            userCrmId_ = child_.text
            userCrmId_ = self.gds_validate_string(userCrmId_, node, 'userCrmId')
            self.userCrmId = userCrmId_
        elif nodeName_ == 'version':
            version_ = child_.text
            version_ = self.gds_validate_string(version_, node, 'version')
            self.version = version_
        super(statDataPoint, self).buildChildren(child_, node, nodeName_, True)
# end class statDataPoint


class uForgeObjects(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, total=None, extensiontype_=None):
        self.total = total
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if uForgeObjects.subclass:
            return uForgeObjects.subclass(*args_, **kwargs_)
        else:
            return uForgeObjects(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_total(self): return self.total
    def set_total(self, total): self.total = total
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.total is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='uForgeObjects', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='uForgeObjects')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='uForgeObjects'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='uForgeObjects', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.total is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stotal>%s</%stotal>%s' % (namespace_, self.gds_format_integer(self.total, input_name='total'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='uForgeObjects'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.total is not None:
            showIndent(outfile, level)
            outfile.write('total=%d,\n' % self.total)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'total':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'total')
            self.total = ival_
# end class uForgeObjects


class publishImage(image):
    subclass = None
    superclass = image
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, md5sum=None, mimeType=None, sha256sum=None, size=None, status=None, uploaded=None, uploadedTime=None, applianceUri=None, basePublishImagesUri=None, completeInstalledSize=None, completeSize=None, compress=None, credAccount=None, disableRootPassword=None, downloadKey=None, downloadUri=None, ebs=None, ebsVolumeSize=None, fileExtension=None, fileName=None, fileSize=None, format=None, fullName=None, imageCreated=None, installProfile=None, orgUri=None, pkgsUri=None, publicAccess=None, registeredCredAccount=None, revision=None, simulated=None, statusUri=None, tag=None, updateTools=None, uri=None, version=None, vmDiskSize=None, vmMemorySize=None, cloudId=None, imageUri=None, instances=None, instancesUri=None, publishLocation=None):
        super(publishImage, self).__init__(created, dbId, digest, lastModified, name, md5sum, mimeType, sha256sum, size, status, uploaded, uploadedTime, applianceUri, basePublishImagesUri, completeInstalledSize, completeSize, compress, credAccount, disableRootPassword, downloadKey, downloadUri, ebs, ebsVolumeSize, fileExtension, fileName, fileSize, format, fullName, imageCreated, installProfile, orgUri, pkgsUri, publicAccess, registeredCredAccount, revision, simulated, statusUri, tag, updateTools, uri, version, vmDiskSize, vmMemorySize, )
        self.cloudId = cloudId
        self.imageUri = imageUri
        if instances is None:
            self.instances = []
        else:
            self.instances = instances
        self.instancesUri = instancesUri
        self.publishLocation = publishLocation
    def factory(*args_, **kwargs_):
        if publishImage.subclass:
            return publishImage.subclass(*args_, **kwargs_)
        else:
            return publishImage(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_cloudId(self): return self.cloudId
    def set_cloudId(self, cloudId): self.cloudId = cloudId
    def get_imageUri(self): return self.imageUri
    def set_imageUri(self, imageUri): self.imageUri = imageUri
    def get_instances(self): return self.instances
    def set_instances(self, instances): self.instances = instances
    def add_instances(self, value): self.instances.append(value)
    def insert_instances(self, index, value): self.instances[index] = value
    def get_instancesUri(self): return self.instancesUri
    def set_instancesUri(self, instancesUri): self.instancesUri = instancesUri
    def get_publishLocation(self): return self.publishLocation
    def set_publishLocation(self, publishLocation): self.publishLocation = publishLocation
    def hasContent_(self):
        if (
            self.cloudId is not None or
            self.imageUri is not None or
            self.instances or
            self.instancesUri is not None or
            self.publishLocation is not None or
            super(publishImage, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='publishImage', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='publishImage')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='publishImage'):
        super(publishImage, self).exportAttributes(outfile, level, already_processed, namespace_, name_='publishImage')
    def exportChildren(self, outfile, level, namespace_='', name_='publishImage', fromsubclass_=False, pretty_print=True):
        super(publishImage, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cloudId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scloudId>%s</%scloudId>%s' % (namespace_, self.gds_format_string(quote_xml(self.cloudId).encode(ExternalEncoding), input_name='cloudId'), namespace_, eol_))
        if self.imageUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%simageUri>%s</%simageUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.imageUri).encode(ExternalEncoding), input_name='imageUri'), namespace_, eol_))
        for instances_ in self.instances:
            instances_.export(outfile, level, namespace_, name_='instances', pretty_print=pretty_print)
        if self.instancesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinstancesUri>%s</%sinstancesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.instancesUri).encode(ExternalEncoding), input_name='instancesUri'), namespace_, eol_))
        if self.publishLocation is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spublishLocation>%s</%spublishLocation>%s' % (namespace_, self.gds_format_string(quote_xml(self.publishLocation).encode(ExternalEncoding), input_name='publishLocation'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='publishImage'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(publishImage, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(publishImage, self).exportLiteralChildren(outfile, level, name_)
        if self.cloudId is not None:
            showIndent(outfile, level)
            outfile.write('cloudId=%s,\n' % quote_python(self.cloudId).encode(ExternalEncoding))
        if self.imageUri is not None:
            showIndent(outfile, level)
            outfile.write('imageUri=%s,\n' % quote_python(self.imageUri).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('instances=[\n')
        level += 1
        for instances_ in self.instances:
            showIndent(outfile, level)
            outfile.write('model_.instance(\n')
            instances_.exportLiteral(outfile, level, name_='instance')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.instancesUri is not None:
            showIndent(outfile, level)
            outfile.write('instancesUri=%s,\n' % quote_python(self.instancesUri).encode(ExternalEncoding))
        if self.publishLocation is not None:
            showIndent(outfile, level)
            outfile.write('publishLocation=%s,\n' % quote_python(self.publishLocation).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(publishImage, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'cloudId':
            cloudId_ = child_.text
            cloudId_ = self.gds_validate_string(cloudId_, node, 'cloudId')
            self.cloudId = cloudId_
        elif nodeName_ == 'imageUri':
            imageUri_ = child_.text
            imageUri_ = self.gds_validate_string(imageUri_, node, 'imageUri')
            self.imageUri = imageUri_
        elif nodeName_ == 'instances':
            class_obj_ = self.get_class_obj_(child_, instance)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.instances.append(obj_)
        elif nodeName_ == 'instancesUri':
            instancesUri_ = child_.text
            instancesUri_ = self.gds_validate_string(instancesUri_, node, 'instancesUri')
            self.instancesUri = instancesUri_
        elif nodeName_ == 'publishLocation':
            publishLocation_ = child_.text
            publishLocation_ = self.gds_validate_string(publishLocation_, node, 'publishLocation')
            self.publishLocation = publishLocation_
        super(publishImage, self).buildChildren(child_, node, nodeName_, True)
# end class publishImage


class instance(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, consoleUrl=None, credAccount=None, hardware=None, hostname=None, installProfile=None, instanceId=None, nics=None, parentUri=None, state=None, stateMsg=None, statesUri=None, status=None, statusUri=None, tag=None, templateName=None, templateUri=None, type_=None, uri=None, extensiontype_=None):
        super(instance, self).__init__(created, dbId, digest, lastModified, name, extensiontype_, )
        self.consoleUrl = consoleUrl
        self.credAccount = credAccount
        self.hardware = hardware
        self.hostname = hostname
        self.installProfile = installProfile
        self.instanceId = instanceId
        self.nics = nics
        self.parentUri = parentUri
        self.state = state
        self.stateMsg = stateMsg
        self.statesUri = statesUri
        self.status = status
        self.statusUri = statusUri
        self.tag = tag
        self.templateName = templateName
        self.templateUri = templateUri
        self.type_ = type_
        self.uri = uri
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if instance.subclass:
            return instance.subclass(*args_, **kwargs_)
        else:
            return instance(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_consoleUrl(self): return self.consoleUrl
    def set_consoleUrl(self, consoleUrl): self.consoleUrl = consoleUrl
    def get_credAccount(self): return self.credAccount
    def set_credAccount(self, credAccount): self.credAccount = credAccount
    def get_hardware(self): return self.hardware
    def set_hardware(self, hardware): self.hardware = hardware
    def get_hostname(self): return self.hostname
    def set_hostname(self, hostname): self.hostname = hostname
    def get_installProfile(self): return self.installProfile
    def set_installProfile(self, installProfile): self.installProfile = installProfile
    def get_instanceId(self): return self.instanceId
    def set_instanceId(self, instanceId): self.instanceId = instanceId
    def get_nics(self): return self.nics
    def set_nics(self, nics): self.nics = nics
    def get_parentUri(self): return self.parentUri
    def set_parentUri(self, parentUri): self.parentUri = parentUri
    def get_state(self): return self.state
    def set_state(self, state): self.state = state
    def get_stateMsg(self): return self.stateMsg
    def set_stateMsg(self, stateMsg): self.stateMsg = stateMsg
    def get_statesUri(self): return self.statesUri
    def set_statesUri(self, statesUri): self.statesUri = statesUri
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_statusUri(self): return self.statusUri
    def set_statusUri(self, statusUri): self.statusUri = statusUri
    def get_tag(self): return self.tag
    def set_tag(self, tag): self.tag = tag
    def get_templateName(self): return self.templateName
    def set_templateName(self, templateName): self.templateName = templateName
    def get_templateUri(self): return self.templateUri
    def set_templateUri(self, templateUri): self.templateUri = templateUri
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.consoleUrl is not None or
            self.credAccount is not None or
            self.hardware is not None or
            self.hostname is not None or
            self.installProfile is not None or
            self.instanceId is not None or
            self.nics is not None or
            self.parentUri is not None or
            self.state is not None or
            self.stateMsg is not None or
            self.statesUri is not None or
            self.status is not None or
            self.statusUri is not None or
            self.tag is not None or
            self.templateName is not None or
            self.templateUri is not None or
            self.type_ is not None or
            self.uri is not None or
            super(instance, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='instance', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='instance')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='instance'):
        super(instance, self).exportAttributes(outfile, level, already_processed, namespace_, name_='instance')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='instance', fromsubclass_=False, pretty_print=True):
        super(instance, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.consoleUrl is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sconsoleUrl>%s</%sconsoleUrl>%s' % (namespace_, self.gds_format_string(quote_xml(self.consoleUrl).encode(ExternalEncoding), input_name='consoleUrl'), namespace_, eol_))
        if self.credAccount is not None:
            self.credAccount.export(outfile, level, namespace_, name_='credAccount', pretty_print=pretty_print)
        if self.hardware is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shardware>%s</%shardware>%s' % (namespace_, self.gds_format_string(quote_xml(self.hardware).encode(ExternalEncoding), input_name='hardware'), namespace_, eol_))
        if self.hostname is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shostname>%s</%shostname>%s' % (namespace_, self.gds_format_string(quote_xml(self.hostname).encode(ExternalEncoding), input_name='hostname'), namespace_, eol_))
        if self.installProfile is not None:
            self.installProfile.export(outfile, level, namespace_, name_='installProfile', pretty_print=pretty_print)
        if self.instanceId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinstanceId>%s</%sinstanceId>%s' % (namespace_, self.gds_format_string(quote_xml(self.instanceId).encode(ExternalEncoding), input_name='instanceId'), namespace_, eol_))
        if self.nics is not None:
            self.nics.export(outfile, level, namespace_, name_='nics', pretty_print=pretty_print)
        if self.parentUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparentUri>%s</%sparentUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.parentUri).encode(ExternalEncoding), input_name='parentUri'), namespace_, eol_))
        if self.state is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstate>%s</%sstate>%s' % (namespace_, self.gds_format_string(quote_xml(self.state).encode(ExternalEncoding), input_name='state'), namespace_, eol_))
        if self.stateMsg is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstateMsg>%s</%sstateMsg>%s' % (namespace_, self.gds_format_string(quote_xml(self.stateMsg).encode(ExternalEncoding), input_name='stateMsg'), namespace_, eol_))
        if self.statesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstatesUri>%s</%sstatesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.statesUri).encode(ExternalEncoding), input_name='statesUri'), namespace_, eol_))
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status', pretty_print=pretty_print)
        if self.statusUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstatusUri>%s</%sstatusUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.statusUri).encode(ExternalEncoding), input_name='statusUri'), namespace_, eol_))
        if self.tag is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stag>%s</%stag>%s' % (namespace_, self.gds_format_string(quote_xml(self.tag).encode(ExternalEncoding), input_name='tag'), namespace_, eol_))
        if self.templateName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stemplateName>%s</%stemplateName>%s' % (namespace_, self.gds_format_string(quote_xml(self.templateName).encode(ExternalEncoding), input_name='templateName'), namespace_, eol_))
        if self.templateUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stemplateUri>%s</%stemplateUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.templateUri).encode(ExternalEncoding), input_name='templateUri'), namespace_, eol_))
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='instance'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(instance, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(instance, self).exportLiteralChildren(outfile, level, name_)
        if self.consoleUrl is not None:
            showIndent(outfile, level)
            outfile.write('consoleUrl=%s,\n' % quote_python(self.consoleUrl).encode(ExternalEncoding))
        if self.credAccount is not None:
            showIndent(outfile, level)
            outfile.write('credAccount=model_.credAccount(\n')
            self.credAccount.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.hardware is not None:
            showIndent(outfile, level)
            outfile.write('hardware=%s,\n' % quote_python(self.hardware).encode(ExternalEncoding))
        if self.hostname is not None:
            showIndent(outfile, level)
            outfile.write('hostname=%s,\n' % quote_python(self.hostname).encode(ExternalEncoding))
        if self.installProfile is not None:
            showIndent(outfile, level)
            outfile.write('installProfile=model_.installProfile(\n')
            self.installProfile.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.instanceId is not None:
            showIndent(outfile, level)
            outfile.write('instanceId=%s,\n' % quote_python(self.instanceId).encode(ExternalEncoding))
        if self.nics is not None:
            showIndent(outfile, level)
            outfile.write('nics=model_.nics(\n')
            self.nics.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.parentUri is not None:
            showIndent(outfile, level)
            outfile.write('parentUri=%s,\n' % quote_python(self.parentUri).encode(ExternalEncoding))
        if self.state is not None:
            showIndent(outfile, level)
            outfile.write('state=%s,\n' % quote_python(self.state).encode(ExternalEncoding))
        if self.stateMsg is not None:
            showIndent(outfile, level)
            outfile.write('stateMsg=%s,\n' % quote_python(self.stateMsg).encode(ExternalEncoding))
        if self.statesUri is not None:
            showIndent(outfile, level)
            outfile.write('statesUri=%s,\n' % quote_python(self.statesUri).encode(ExternalEncoding))
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.statusUri is not None:
            showIndent(outfile, level)
            outfile.write('statusUri=%s,\n' % quote_python(self.statusUri).encode(ExternalEncoding))
        if self.tag is not None:
            showIndent(outfile, level)
            outfile.write('tag=%s,\n' % quote_python(self.tag).encode(ExternalEncoding))
        if self.templateName is not None:
            showIndent(outfile, level)
            outfile.write('templateName=%s,\n' % quote_python(self.templateName).encode(ExternalEncoding))
        if self.templateUri is not None:
            showIndent(outfile, level)
            outfile.write('templateUri=%s,\n' % quote_python(self.templateUri).encode(ExternalEncoding))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(instance, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'consoleUrl':
            consoleUrl_ = child_.text
            consoleUrl_ = self.gds_validate_string(consoleUrl_, node, 'consoleUrl')
            self.consoleUrl = consoleUrl_
        elif nodeName_ == 'credAccount':
            obj_ = credAccount.factory()
            obj_.build(child_)
            self.credAccount = obj_
        elif nodeName_ == 'hardware':
            hardware_ = child_.text
            hardware_ = self.gds_validate_string(hardware_, node, 'hardware')
            self.hardware = hardware_
        elif nodeName_ == 'hostname':
            hostname_ = child_.text
            hostname_ = self.gds_validate_string(hostname_, node, 'hostname')
            self.hostname = hostname_
        elif nodeName_ == 'installProfile':
            obj_ = installProfile.factory()
            obj_.build(child_)
            self.installProfile = obj_
        elif nodeName_ == 'instanceId':
            instanceId_ = child_.text
            instanceId_ = self.gds_validate_string(instanceId_, node, 'instanceId')
            self.instanceId = instanceId_
        elif nodeName_ == 'nics':
            obj_ = nics.factory()
            obj_.build(child_)
            self.nics = obj_
        elif nodeName_ == 'parentUri':
            parentUri_ = child_.text
            parentUri_ = self.gds_validate_string(parentUri_, node, 'parentUri')
            self.parentUri = parentUri_
        elif nodeName_ == 'state':
            state_ = child_.text
            state_ = self.gds_validate_string(state_, node, 'state')
            self.state = state_
        elif nodeName_ == 'stateMsg':
            stateMsg_ = child_.text
            stateMsg_ = self.gds_validate_string(stateMsg_, node, 'stateMsg')
            self.stateMsg = stateMsg_
        elif nodeName_ == 'statesUri':
            statesUri_ = child_.text
            statesUri_ = self.gds_validate_string(statesUri_, node, 'statesUri')
            self.statesUri = statesUri_
        elif nodeName_ == 'status':
            obj_ = opStatus.factory()
            obj_.build(child_)
            self.status = obj_
        elif nodeName_ == 'statusUri':
            statusUri_ = child_.text
            statusUri_ = self.gds_validate_string(statusUri_, node, 'statusUri')
            self.statusUri = statusUri_
        elif nodeName_ == 'tag':
            tag_ = child_.text
            tag_ = self.gds_validate_string(tag_, node, 'tag')
            self.tag = tag_
        elif nodeName_ == 'templateName':
            templateName_ = child_.text
            templateName_ = self.gds_validate_string(templateName_, node, 'templateName')
            self.templateName = templateName_
        elif nodeName_ == 'templateUri':
            templateUri_ = child_.text
            templateUri_ = self.gds_validate_string(templateUri_, node, 'templateUri')
            self.templateUri = templateUri_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(instance, self).buildChildren(child_, node, nodeName_, True)
# end class instance


class comment(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, abuseUri=None, abused=None, loginName=None, message=None, nbAbused=None, photo=None, replies=None, replyUri=None, timestamp=None, uri=None):
        super(comment, self).__init__(created, dbId, digest, lastModified, name, )
        self.abuseUri = abuseUri
        self.abused = abused
        self.loginName = loginName
        self.message = message
        self.nbAbused = nbAbused
        self.photo = photo
        self.replies = replies
        self.replyUri = replyUri
        self.timestamp = timestamp
        self.uri = uri
    def factory(*args_, **kwargs_):
        if comment.subclass:
            return comment.subclass(*args_, **kwargs_)
        else:
            return comment(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_abuseUri(self): return self.abuseUri
    def set_abuseUri(self, abuseUri): self.abuseUri = abuseUri
    def get_abused(self): return self.abused
    def set_abused(self, abused): self.abused = abused
    def get_loginName(self): return self.loginName
    def set_loginName(self, loginName): self.loginName = loginName
    def get_message(self): return self.message
    def set_message(self, message): self.message = message
    def get_nbAbused(self): return self.nbAbused
    def set_nbAbused(self, nbAbused): self.nbAbused = nbAbused
    def get_photo(self): return self.photo
    def set_photo(self, photo): self.photo = photo
    def get_replies(self): return self.replies
    def set_replies(self, replies): self.replies = replies
    def get_replyUri(self): return self.replyUri
    def set_replyUri(self, replyUri): self.replyUri = replyUri
    def get_timestamp(self): return self.timestamp
    def set_timestamp(self, timestamp): self.timestamp = timestamp
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def hasContent_(self):
        if (
            self.abuseUri is not None or
            self.abused is not None or
            self.loginName is not None or
            self.message is not None or
            self.nbAbused is not None or
            self.photo is not None or
            self.replies is not None or
            self.replyUri is not None or
            self.timestamp is not None or
            self.uri is not None or
            super(comment, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='comment', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='comment')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='comment'):
        super(comment, self).exportAttributes(outfile, level, already_processed, namespace_, name_='comment')
    def exportChildren(self, outfile, level, namespace_='', name_='comment', fromsubclass_=False, pretty_print=True):
        super(comment, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.abuseUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sabuseUri>%s</%sabuseUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.abuseUri).encode(ExternalEncoding), input_name='abuseUri'), namespace_, eol_))
        if self.abused is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sabused>%s</%sabused>%s' % (namespace_, self.gds_format_boolean(self.abused, input_name='abused'), namespace_, eol_))
        if self.loginName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sloginName>%s</%sloginName>%s' % (namespace_, self.gds_format_string(quote_xml(self.loginName).encode(ExternalEncoding), input_name='loginName'), namespace_, eol_))
        if self.message is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smessage>%s</%smessage>%s' % (namespace_, self.gds_format_string(quote_xml(self.message).encode(ExternalEncoding), input_name='message'), namespace_, eol_))
        if self.nbAbused is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snbAbused>%s</%snbAbused>%s' % (namespace_, self.gds_format_integer(self.nbAbused, input_name='nbAbused'), namespace_, eol_))
        if self.photo is not None:
            self.photo.export(outfile, level, namespace_, name_='photo', pretty_print=pretty_print)
        if self.replies is not None:
            self.replies.export(outfile, level, namespace_, name_='replies', pretty_print=pretty_print)
        if self.replyUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sreplyUri>%s</%sreplyUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.replyUri).encode(ExternalEncoding), input_name='replyUri'), namespace_, eol_))
        if self.timestamp is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stimestamp>%s</%stimestamp>%s' % (namespace_, self.gds_format_string(quote_xml(self.timestamp).encode(ExternalEncoding), input_name='timestamp'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='comment'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(comment, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(comment, self).exportLiteralChildren(outfile, level, name_)
        if self.abuseUri is not None:
            showIndent(outfile, level)
            outfile.write('abuseUri=%s,\n' % quote_python(self.abuseUri).encode(ExternalEncoding))
        if self.abused is not None:
            showIndent(outfile, level)
            outfile.write('abused=%s,\n' % self.abused)
        if self.loginName is not None:
            showIndent(outfile, level)
            outfile.write('loginName=%s,\n' % quote_python(self.loginName).encode(ExternalEncoding))
        if self.message is not None:
            showIndent(outfile, level)
            outfile.write('message=%s,\n' % quote_python(self.message).encode(ExternalEncoding))
        if self.nbAbused is not None:
            showIndent(outfile, level)
            outfile.write('nbAbused=%d,\n' % self.nbAbused)
        if self.photo is not None:
            showIndent(outfile, level)
            outfile.write('photo=model_.logo(\n')
            self.photo.exportLiteral(outfile, level, name_='photo')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.replies is not None:
            showIndent(outfile, level)
            outfile.write('replies=model_.replies(\n')
            self.replies.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.replyUri is not None:
            showIndent(outfile, level)
            outfile.write('replyUri=%s,\n' % quote_python(self.replyUri).encode(ExternalEncoding))
        if self.timestamp is not None:
            showIndent(outfile, level)
            outfile.write('timestamp=%s,\n' % quote_python(self.timestamp).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(comment, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'abuseUri':
            abuseUri_ = child_.text
            abuseUri_ = self.gds_validate_string(abuseUri_, node, 'abuseUri')
            self.abuseUri = abuseUri_
        elif nodeName_ == 'abused':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'abused')
            self.abused = ival_
        elif nodeName_ == 'loginName':
            loginName_ = child_.text
            loginName_ = self.gds_validate_string(loginName_, node, 'loginName')
            self.loginName = loginName_
        elif nodeName_ == 'message':
            message_ = child_.text
            message_ = self.gds_validate_string(message_, node, 'message')
            self.message = message_
        elif nodeName_ == 'nbAbused':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'nbAbused')
            self.nbAbused = ival_
        elif nodeName_ == 'photo':
            obj_ = logo.factory()
            obj_.build(child_)
            self.photo = obj_
        elif nodeName_ == 'replies':
            obj_ = replies.factory()
            obj_.build(child_)
            self.replies = obj_
        elif nodeName_ == 'replyUri':
            replyUri_ = child_.text
            replyUri_ = self.gds_validate_string(replyUri_, node, 'replyUri')
            self.replyUri = replyUri_
        elif nodeName_ == 'timestamp':
            timestamp_ = child_.text
            timestamp_ = self.gds_validate_string(timestamp_, node, 'timestamp')
            self.timestamp = timestamp_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(comment, self).buildChildren(child_, node, nodeName_, True)
# end class comment


class replies(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, comment=None):
        if comment is None:
            self.comment = []
        else:
            self.comment = comment
    def factory(*args_, **kwargs_):
        if replies.subclass:
            return replies.subclass(*args_, **kwargs_)
        else:
            return replies(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_comment(self): return self.comment
    def set_comment(self, comment): self.comment = comment
    def add_comment(self, value): self.comment.append(value)
    def insert_comment(self, index, value): self.comment[index] = value
    def hasContent_(self):
        if (
            self.comment
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='replies', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='replies')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='replies'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='replies', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for comment_ in self.comment:
            comment_.export(outfile, level, namespace_, name_='comment', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='replies'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('comment=[\n')
        level += 1
        for comment_ in self.comment:
            showIndent(outfile, level)
            outfile.write('model_.comment(\n')
            comment_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'comment':
            obj_ = comment.factory()
            obj_.build(child_)
            self.comment.append(obj_)
# end class replies


class instanceStatus(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None):
        super(instanceStatus, self).__init__(created, dbId, digest, lastModified, name, )
        pass
    def factory(*args_, **kwargs_):
        if instanceStatus.subclass:
            return instanceStatus.subclass(*args_, **kwargs_)
        else:
            return instanceStatus(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(instanceStatus, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='instanceStatus', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='instanceStatus')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='instanceStatus'):
        super(instanceStatus, self).exportAttributes(outfile, level, already_processed, namespace_, name_='instanceStatus')
    def exportChildren(self, outfile, level, namespace_='', name_='instanceStatus', fromsubclass_=False, pretty_print=True):
        super(instanceStatus, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='instanceStatus'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(instanceStatus, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(instanceStatus, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(instanceStatus, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(instanceStatus, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class instanceStatus


class encryptUtils(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        pass
    def factory(*args_, **kwargs_):
        if encryptUtils.subclass:
            return encryptUtils.subclass(*args_, **kwargs_)
        else:
            return encryptUtils(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='encryptUtils', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='encryptUtils')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='encryptUtils'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='encryptUtils', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='encryptUtils'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class encryptUtils


class accountType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        pass
    def factory(*args_, **kwargs_):
        if accountType.subclass:
            return accountType.subclass(*args_, **kwargs_)
        else:
            return accountType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='accountType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='accountType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='accountType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='accountType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='accountType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class accountType


class keyboardSettings(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, uri=None):
        super(keyboardSettings, self).__init__(created, dbId, digest, lastModified, name, )
        self.uri = uri
    def factory(*args_, **kwargs_):
        if keyboardSettings.subclass:
            return keyboardSettings.subclass(*args_, **kwargs_)
        else:
            return keyboardSettings(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def hasContent_(self):
        if (
            self.uri is not None or
            super(keyboardSettings, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='keyboardSettings', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='keyboardSettings')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='keyboardSettings'):
        super(keyboardSettings, self).exportAttributes(outfile, level, already_processed, namespace_, name_='keyboardSettings')
    def exportChildren(self, outfile, level, namespace_='', name_='keyboardSettings', fromsubclass_=False, pretty_print=True):
        super(keyboardSettings, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='keyboardSettings'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(keyboardSettings, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(keyboardSettings, self).exportLiteralChildren(outfile, level, name_)
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(keyboardSettings, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(keyboardSettings, self).buildChildren(child_, node, nodeName_, True)
# end class keyboardSettings


class distributions(uForgeObjects):
    subclass = None
    superclass = uForgeObjects
    def __init__(self, total=None, distribution=None):
        super(distributions, self).__init__(total, )
        if distribution is None:
            self.distribution = []
        else:
            self.distribution = distribution
    def factory(*args_, **kwargs_):
        if distributions.subclass:
            return distributions.subclass(*args_, **kwargs_)
        else:
            return distributions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_distribution(self): return self.distribution
    def set_distribution(self, distribution): self.distribution = distribution
    def add_distribution(self, value): self.distribution.append(value)
    def insert_distribution(self, index, value): self.distribution[index] = value
    def hasContent_(self):
        if (
            self.distribution or
            super(distributions, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='distributions', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='distributions')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='distributions'):
        super(distributions, self).exportAttributes(outfile, level, already_processed, namespace_, name_='distributions')
    def exportChildren(self, outfile, level, namespace_='', name_='distributions', fromsubclass_=False, pretty_print=True):
        super(distributions, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for distribution_ in self.distribution:
            distribution_.export(outfile, level, namespace_, name_='distribution', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='distributions'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(distributions, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(distributions, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('distribution=[\n')
        level += 1
        for distribution_ in self.distribution:
            showIndent(outfile, level)
            outfile.write('model_.distribution(\n')
            distribution_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(distributions, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'distribution':
            obj_ = distribution.factory()
            obj_.build(child_)
            self.distribution.append(obj_)
        super(distributions, self).buildChildren(child_, node, nodeName_, True)
# end class distributions


class orgSubscription(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, applianceLimit=None, memberLimit=None, projectLimit=None, renewalDate=None, softwareLibraryLimit=None, totalStorageLimit=None, uri=None):
        super(orgSubscription, self).__init__(created, dbId, digest, lastModified, name, )
        self.applianceLimit = applianceLimit
        self.memberLimit = memberLimit
        self.projectLimit = projectLimit
        if isinstance(renewalDate, basestring):
            initvalue_ = datetime_.datetime.strptime(renewalDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = renewalDate
        self.renewalDate = initvalue_
        self.softwareLibraryLimit = softwareLibraryLimit
        self.totalStorageLimit = totalStorageLimit
        self.uri = uri
    def factory(*args_, **kwargs_):
        if orgSubscription.subclass:
            return orgSubscription.subclass(*args_, **kwargs_)
        else:
            return orgSubscription(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_applianceLimit(self): return self.applianceLimit
    def set_applianceLimit(self, applianceLimit): self.applianceLimit = applianceLimit
    def get_memberLimit(self): return self.memberLimit
    def set_memberLimit(self, memberLimit): self.memberLimit = memberLimit
    def get_projectLimit(self): return self.projectLimit
    def set_projectLimit(self, projectLimit): self.projectLimit = projectLimit
    def get_renewalDate(self): return self.renewalDate
    def set_renewalDate(self, renewalDate): self.renewalDate = renewalDate
    def get_softwareLibraryLimit(self): return self.softwareLibraryLimit
    def set_softwareLibraryLimit(self, softwareLibraryLimit): self.softwareLibraryLimit = softwareLibraryLimit
    def get_totalStorageLimit(self): return self.totalStorageLimit
    def set_totalStorageLimit(self, totalStorageLimit): self.totalStorageLimit = totalStorageLimit
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def hasContent_(self):
        if (
            self.applianceLimit is not None or
            self.memberLimit is not None or
            self.projectLimit is not None or
            self.renewalDate is not None or
            self.softwareLibraryLimit is not None or
            self.totalStorageLimit is not None or
            self.uri is not None or
            super(orgSubscription, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='orgSubscription', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='orgSubscription')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='orgSubscription'):
        super(orgSubscription, self).exportAttributes(outfile, level, already_processed, namespace_, name_='orgSubscription')
    def exportChildren(self, outfile, level, namespace_='', name_='orgSubscription', fromsubclass_=False, pretty_print=True):
        super(orgSubscription, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.applianceLimit is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sapplianceLimit>%s</%sapplianceLimit>%s' % (namespace_, self.gds_format_integer(self.applianceLimit, input_name='applianceLimit'), namespace_, eol_))
        if self.memberLimit is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smemberLimit>%s</%smemberLimit>%s' % (namespace_, self.gds_format_integer(self.memberLimit, input_name='memberLimit'), namespace_, eol_))
        if self.projectLimit is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprojectLimit>%s</%sprojectLimit>%s' % (namespace_, self.gds_format_integer(self.projectLimit, input_name='projectLimit'), namespace_, eol_))
        if self.renewalDate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srenewalDate>%s</%srenewalDate>%s' % (namespace_, self.gds_format_datetime(self.renewalDate, input_name='renewalDate'), namespace_, eol_))
        if self.softwareLibraryLimit is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssoftwareLibraryLimit>%s</%ssoftwareLibraryLimit>%s' % (namespace_, self.gds_format_integer(self.softwareLibraryLimit, input_name='softwareLibraryLimit'), namespace_, eol_))
        if self.totalStorageLimit is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stotalStorageLimit>%s</%stotalStorageLimit>%s' % (namespace_, self.gds_format_integer(self.totalStorageLimit, input_name='totalStorageLimit'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='orgSubscription'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(orgSubscription, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(orgSubscription, self).exportLiteralChildren(outfile, level, name_)
        if self.applianceLimit is not None:
            showIndent(outfile, level)
            outfile.write('applianceLimit=%d,\n' % self.applianceLimit)
        if self.memberLimit is not None:
            showIndent(outfile, level)
            outfile.write('memberLimit=%d,\n' % self.memberLimit)
        if self.projectLimit is not None:
            showIndent(outfile, level)
            outfile.write('projectLimit=%d,\n' % self.projectLimit)
        if self.renewalDate is not None:
            showIndent(outfile, level)
            outfile.write('renewalDate=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.renewalDate, input_name='renewalDate'))
        if self.softwareLibraryLimit is not None:
            showIndent(outfile, level)
            outfile.write('softwareLibraryLimit=%d,\n' % self.softwareLibraryLimit)
        if self.totalStorageLimit is not None:
            showIndent(outfile, level)
            outfile.write('totalStorageLimit=%d,\n' % self.totalStorageLimit)
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(orgSubscription, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'applianceLimit':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'applianceLimit')
            self.applianceLimit = ival_
        elif nodeName_ == 'memberLimit':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'memberLimit')
            self.memberLimit = ival_
        elif nodeName_ == 'projectLimit':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'projectLimit')
            self.projectLimit = ival_
        elif nodeName_ == 'renewalDate':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.renewalDate = dval_
        elif nodeName_ == 'softwareLibraryLimit':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'softwareLibraryLimit')
            self.softwareLibraryLimit = ival_
        elif nodeName_ == 'totalStorageLimit':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'totalStorageLimit')
            self.totalStorageLimit = ival_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(orgSubscription, self).buildChildren(child_, node, nodeName_, True)
# end class orgSubscription


class scannedInstances(uForgeObjects):
    subclass = None
    superclass = uForgeObjects
    def __init__(self, total=None, scannedInstance=None):
        super(scannedInstances, self).__init__(total, )
        if scannedInstance is None:
            self.scannedInstance = []
        else:
            self.scannedInstance = scannedInstance
    def factory(*args_, **kwargs_):
        if scannedInstances.subclass:
            return scannedInstances.subclass(*args_, **kwargs_)
        else:
            return scannedInstances(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_scannedInstance(self): return self.scannedInstance
    def set_scannedInstance(self, scannedInstance): self.scannedInstance = scannedInstance
    def add_scannedInstance(self, value): self.scannedInstance.append(value)
    def insert_scannedInstance(self, index, value): self.scannedInstance[index] = value
    def hasContent_(self):
        if (
            self.scannedInstance or
            super(scannedInstances, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='scannedInstances', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='scannedInstances')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='scannedInstances'):
        super(scannedInstances, self).exportAttributes(outfile, level, already_processed, namespace_, name_='scannedInstances')
    def exportChildren(self, outfile, level, namespace_='', name_='scannedInstances', fromsubclass_=False, pretty_print=True):
        super(scannedInstances, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for scannedInstance_ in self.scannedInstance:
            scannedInstance_.export(outfile, level, namespace_, name_='scannedInstance', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='scannedInstances'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(scannedInstances, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(scannedInstances, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('scannedInstance=[\n')
        level += 1
        for scannedInstance_ in self.scannedInstance:
            showIndent(outfile, level)
            outfile.write('model_.scannedInstance(\n')
            scannedInstance_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(scannedInstances, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'scannedInstance':
            obj_ = scannedInstance.factory()
            obj_.build(child_)
            self.scannedInstance.append(obj_)
        super(scannedInstances, self).buildChildren(child_, node, nodeName_, True)
# end class scannedInstances


class scannedInstance(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, distribution=None, group=None, parentUri=None, platformType=None, ramSize=None, scans=None, scansUri=None, totalScans=None, uri=None):
        super(scannedInstance, self).__init__(created, dbId, digest, lastModified, name, )
        self.distribution = distribution
        self.group = group
        self.parentUri = parentUri
        self.platformType = platformType
        self.ramSize = ramSize
        self.scans = scans
        self.scansUri = scansUri
        self.totalScans = totalScans
        self.uri = uri
    def factory(*args_, **kwargs_):
        if scannedInstance.subclass:
            return scannedInstance.subclass(*args_, **kwargs_)
        else:
            return scannedInstance(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_distribution(self): return self.distribution
    def set_distribution(self, distribution): self.distribution = distribution
    def get_group(self): return self.group
    def set_group(self, group): self.group = group
    def get_parentUri(self): return self.parentUri
    def set_parentUri(self, parentUri): self.parentUri = parentUri
    def get_platformType(self): return self.platformType
    def set_platformType(self, platformType): self.platformType = platformType
    def get_ramSize(self): return self.ramSize
    def set_ramSize(self, ramSize): self.ramSize = ramSize
    def get_scans(self): return self.scans
    def set_scans(self, scans): self.scans = scans
    def get_scansUri(self): return self.scansUri
    def set_scansUri(self, scansUri): self.scansUri = scansUri
    def get_totalScans(self): return self.totalScans
    def set_totalScans(self, totalScans): self.totalScans = totalScans
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def hasContent_(self):
        if (
            self.distribution is not None or
            self.group is not None or
            self.parentUri is not None or
            self.platformType is not None or
            self.ramSize is not None or
            self.scans is not None or
            self.scansUri is not None or
            self.totalScans is not None or
            self.uri is not None or
            super(scannedInstance, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='scannedInstance', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='scannedInstance')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='scannedInstance'):
        super(scannedInstance, self).exportAttributes(outfile, level, already_processed, namespace_, name_='scannedInstance')
    def exportChildren(self, outfile, level, namespace_='', name_='scannedInstance', fromsubclass_=False, pretty_print=True):
        super(scannedInstance, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.distribution is not None:
            self.distribution.export(outfile, level, namespace_, name_='distribution', pretty_print=pretty_print)
        if self.group is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgroup>%s</%sgroup>%s' % (namespace_, self.gds_format_string(quote_xml(self.group).encode(ExternalEncoding), input_name='group'), namespace_, eol_))
        if self.parentUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparentUri>%s</%sparentUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.parentUri).encode(ExternalEncoding), input_name='parentUri'), namespace_, eol_))
        if self.platformType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%splatformType>%s</%splatformType>%s' % (namespace_, self.gds_format_string(quote_xml(self.platformType).encode(ExternalEncoding), input_name='platformType'), namespace_, eol_))
        if self.ramSize is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sramSize>%s</%sramSize>%s' % (namespace_, self.gds_format_integer(self.ramSize, input_name='ramSize'), namespace_, eol_))
        if self.scans is not None:
            self.scans.export(outfile, level, namespace_, name_='scans', pretty_print=pretty_print)
        if self.scansUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sscansUri>%s</%sscansUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.scansUri).encode(ExternalEncoding), input_name='scansUri'), namespace_, eol_))
        if self.totalScans is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stotalScans>%s</%stotalScans>%s' % (namespace_, self.gds_format_integer(self.totalScans, input_name='totalScans'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='scannedInstance'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(scannedInstance, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(scannedInstance, self).exportLiteralChildren(outfile, level, name_)
        if self.distribution is not None:
            showIndent(outfile, level)
            outfile.write('distribution=model_.distribution(\n')
            self.distribution.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.group is not None:
            showIndent(outfile, level)
            outfile.write('group=%s,\n' % quote_python(self.group).encode(ExternalEncoding))
        if self.parentUri is not None:
            showIndent(outfile, level)
            outfile.write('parentUri=%s,\n' % quote_python(self.parentUri).encode(ExternalEncoding))
        if self.platformType is not None:
            showIndent(outfile, level)
            outfile.write('platformType=%s,\n' % quote_python(self.platformType).encode(ExternalEncoding))
        if self.ramSize is not None:
            showIndent(outfile, level)
            outfile.write('ramSize=%d,\n' % self.ramSize)
        if self.scans is not None:
            showIndent(outfile, level)
            outfile.write('scans=model_.scans(\n')
            self.scans.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.scansUri is not None:
            showIndent(outfile, level)
            outfile.write('scansUri=%s,\n' % quote_python(self.scansUri).encode(ExternalEncoding))
        if self.totalScans is not None:
            showIndent(outfile, level)
            outfile.write('totalScans=%d,\n' % self.totalScans)
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(scannedInstance, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'distribution':
            obj_ = distribution.factory()
            obj_.build(child_)
            self.distribution = obj_
        elif nodeName_ == 'group':
            group_ = child_.text
            group_ = self.gds_validate_string(group_, node, 'group')
            self.group = group_
        elif nodeName_ == 'parentUri':
            parentUri_ = child_.text
            parentUri_ = self.gds_validate_string(parentUri_, node, 'parentUri')
            self.parentUri = parentUri_
        elif nodeName_ == 'platformType':
            platformType_ = child_.text
            platformType_ = self.gds_validate_string(platformType_, node, 'platformType')
            self.platformType = platformType_
        elif nodeName_ == 'ramSize':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'ramSize')
            self.ramSize = ival_
        elif nodeName_ == 'scans':
            obj_ = scans.factory()
            obj_.build(child_)
            self.scans = obj_
        elif nodeName_ == 'scansUri':
            scansUri_ = child_.text
            scansUri_ = self.gds_validate_string(scansUri_, node, 'scansUri')
            self.scansUri = scansUri_
        elif nodeName_ == 'totalScans':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'totalScans')
            self.totalScans = ival_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(scannedInstance, self).buildChildren(child_, node, nodeName_, True)
# end class scannedInstance


class scans(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, scan=None):
        if scan is None:
            self.scan = []
        else:
            self.scan = scan
    def factory(*args_, **kwargs_):
        if scans.subclass:
            return scans.subclass(*args_, **kwargs_)
        else:
            return scans(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_scan(self): return self.scan
    def set_scan(self, scan): self.scan = scan
    def add_scan(self, value): self.scan.append(value)
    def insert_scan(self, index, value): self.scan[index] = value
    def hasContent_(self):
        if (
            self.scan
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='scans', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='scans')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='scans'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='scans', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for scan_ in self.scan:
            scan_.export(outfile, level, namespace_, name_='scan', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='scans'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('scan=[\n')
        level += 1
        for scan_ in self.scan:
            showIndent(outfile, level)
            outfile.write('model_.scan(\n')
            scan_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'scan':
            obj_ = scan.factory()
            obj_.build(child_)
            self.scan.append(obj_)
# end class scans


class scan(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, binariesExtracted=None, binariesReceived=None, error=None, errorMsg=None, scannedFiles=None, filesUri=None, images=None, imagesUri=None, importsUri=None, installProfile=None, installProfileUri=None, overlayCrc=None, overlayImported=None, overlayPath=None, overlayUri=None, packages=None, packagesUri=None, rejected=None, scanRelativeDate=None, scanned=None, scannedInstanceUri=None, status=None, totalFilesAdded=None, totalFilesDeleted=None, totalFilesModified=None, totalPackages=None, uncompressedBinarySize=None, uri=None, validated=None):
        super(scan, self).__init__(created, dbId, digest, lastModified, name, )
        self.binariesExtracted = binariesExtracted
        self.binariesReceived = binariesReceived
        self.error = error
        self.errorMsg = errorMsg
        self.scannedFiles = scannedFiles
        self.filesUri = filesUri
        self.images = images
        self.imagesUri = imagesUri
        self.importsUri = importsUri
        self.installProfile = installProfile
        self.installProfileUri = installProfileUri
        self.overlayCrc = overlayCrc
        self.overlayImported = overlayImported
        self.overlayPath = overlayPath
        self.overlayUri = overlayUri
        self.packages = packages
        self.packagesUri = packagesUri
        self.rejected = rejected
        self.scanRelativeDate = scanRelativeDate
        self.scanned = scanned
        self.scannedInstanceUri = scannedInstanceUri
        self.status = status
        self.totalFilesAdded = totalFilesAdded
        self.totalFilesDeleted = totalFilesDeleted
        self.totalFilesModified = totalFilesModified
        self.totalPackages = totalPackages
        self.uncompressedBinarySize = uncompressedBinarySize
        self.uri = uri
        self.validated = validated
    def factory(*args_, **kwargs_):
        if scan.subclass:
            return scan.subclass(*args_, **kwargs_)
        else:
            return scan(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_binariesExtracted(self): return self.binariesExtracted
    def set_binariesExtracted(self, binariesExtracted): self.binariesExtracted = binariesExtracted
    def get_binariesReceived(self): return self.binariesReceived
    def set_binariesReceived(self, binariesReceived): self.binariesReceived = binariesReceived
    def get_error(self): return self.error
    def set_error(self, error): self.error = error
    def get_errorMsg(self): return self.errorMsg
    def set_errorMsg(self, errorMsg): self.errorMsg = errorMsg
    def get_scannedFiles(self): return self.scannedFiles
    def set_scannedFiles(self, scannedFiles): self.scannedFiles = scannedFiles
    def get_filesUri(self): return self.filesUri
    def set_filesUri(self, filesUri): self.filesUri = filesUri
    def get_images(self): return self.images
    def set_images(self, images): self.images = images
    def get_imagesUri(self): return self.imagesUri
    def set_imagesUri(self, imagesUri): self.imagesUri = imagesUri
    def get_importsUri(self): return self.importsUri
    def set_importsUri(self, importsUri): self.importsUri = importsUri
    def get_installProfile(self): return self.installProfile
    def set_installProfile(self, installProfile): self.installProfile = installProfile
    def get_installProfileUri(self): return self.installProfileUri
    def set_installProfileUri(self, installProfileUri): self.installProfileUri = installProfileUri
    def get_overlayCrc(self): return self.overlayCrc
    def set_overlayCrc(self, overlayCrc): self.overlayCrc = overlayCrc
    def get_overlayImported(self): return self.overlayImported
    def set_overlayImported(self, overlayImported): self.overlayImported = overlayImported
    def get_overlayPath(self): return self.overlayPath
    def set_overlayPath(self, overlayPath): self.overlayPath = overlayPath
    def get_overlayUri(self): return self.overlayUri
    def set_overlayUri(self, overlayUri): self.overlayUri = overlayUri
    def get_packages(self): return self.packages
    def set_packages(self, packages): self.packages = packages
    def get_packagesUri(self): return self.packagesUri
    def set_packagesUri(self, packagesUri): self.packagesUri = packagesUri
    def get_rejected(self): return self.rejected
    def set_rejected(self, rejected): self.rejected = rejected
    def get_scanRelativeDate(self): return self.scanRelativeDate
    def set_scanRelativeDate(self, scanRelativeDate): self.scanRelativeDate = scanRelativeDate
    def get_scanned(self): return self.scanned
    def set_scanned(self, scanned): self.scanned = scanned
    def get_scannedInstanceUri(self): return self.scannedInstanceUri
    def set_scannedInstanceUri(self, scannedInstanceUri): self.scannedInstanceUri = scannedInstanceUri
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_totalFilesAdded(self): return self.totalFilesAdded
    def set_totalFilesAdded(self, totalFilesAdded): self.totalFilesAdded = totalFilesAdded
    def get_totalFilesDeleted(self): return self.totalFilesDeleted
    def set_totalFilesDeleted(self, totalFilesDeleted): self.totalFilesDeleted = totalFilesDeleted
    def get_totalFilesModified(self): return self.totalFilesModified
    def set_totalFilesModified(self, totalFilesModified): self.totalFilesModified = totalFilesModified
    def get_totalPackages(self): return self.totalPackages
    def set_totalPackages(self, totalPackages): self.totalPackages = totalPackages
    def get_uncompressedBinarySize(self): return self.uncompressedBinarySize
    def set_uncompressedBinarySize(self, uncompressedBinarySize): self.uncompressedBinarySize = uncompressedBinarySize
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_validated(self): return self.validated
    def set_validated(self, validated): self.validated = validated
    def hasContent_(self):
        if (
            self.binariesExtracted is not None or
            self.binariesReceived is not None or
            self.error is not None or
            self.errorMsg is not None or
            self.scannedFiles is not None or
            self.filesUri is not None or
            self.images is not None or
            self.imagesUri is not None or
            self.importsUri is not None or
            self.installProfile is not None or
            self.installProfileUri is not None or
            self.overlayCrc is not None or
            self.overlayImported is not None or
            self.overlayPath is not None or
            self.overlayUri is not None or
            self.packages is not None or
            self.packagesUri is not None or
            self.rejected is not None or
            self.scanRelativeDate is not None or
            self.scanned is not None or
            self.scannedInstanceUri is not None or
            self.status is not None or
            self.totalFilesAdded is not None or
            self.totalFilesDeleted is not None or
            self.totalFilesModified is not None or
            self.totalPackages is not None or
            self.uncompressedBinarySize is not None or
            self.uri is not None or
            self.validated is not None or
            super(scan, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='scan', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='scan')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='scan'):
        super(scan, self).exportAttributes(outfile, level, already_processed, namespace_, name_='scan')
    def exportChildren(self, outfile, level, namespace_='', name_='scan', fromsubclass_=False, pretty_print=True):
        super(scan, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.binariesExtracted is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbinariesExtracted>%s</%sbinariesExtracted>%s' % (namespace_, self.gds_format_boolean(self.binariesExtracted, input_name='binariesExtracted'), namespace_, eol_))
        if self.binariesReceived is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbinariesReceived>%s</%sbinariesReceived>%s' % (namespace_, self.gds_format_boolean(self.binariesReceived, input_name='binariesReceived'), namespace_, eol_))
        if self.error is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serror>%s</%serror>%s' % (namespace_, self.gds_format_boolean(self.error, input_name='error'), namespace_, eol_))
        if self.errorMsg is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%serrorMsg>%s</%serrorMsg>%s' % (namespace_, self.gds_format_string(quote_xml(self.errorMsg).encode(ExternalEncoding), input_name='errorMsg'), namespace_, eol_))
        if self.scannedFiles is not None:
            self.scannedFiles.export(outfile, level, namespace_, name_='scannedFiles', pretty_print=pretty_print)
        if self.filesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfilesUri>%s</%sfilesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.filesUri).encode(ExternalEncoding), input_name='filesUri'), namespace_, eol_))
        if self.images is not None:
            self.images.export(outfile, level, namespace_, name_='images', pretty_print=pretty_print)
        if self.imagesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%simagesUri>%s</%simagesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.imagesUri).encode(ExternalEncoding), input_name='imagesUri'), namespace_, eol_))
        if self.importsUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%simportsUri>%s</%simportsUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.importsUri).encode(ExternalEncoding), input_name='importsUri'), namespace_, eol_))
        if self.installProfile is not None:
            self.installProfile.export(outfile, level, namespace_, name_='installProfile', pretty_print=pretty_print)
        if self.installProfileUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinstallProfileUri>%s</%sinstallProfileUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.installProfileUri).encode(ExternalEncoding), input_name='installProfileUri'), namespace_, eol_))
        if self.overlayCrc is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soverlayCrc>%s</%soverlayCrc>%s' % (namespace_, self.gds_format_string(quote_xml(self.overlayCrc).encode(ExternalEncoding), input_name='overlayCrc'), namespace_, eol_))
        if self.overlayImported is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soverlayImported>%s</%soverlayImported>%s' % (namespace_, self.gds_format_boolean(self.overlayImported, input_name='overlayImported'), namespace_, eol_))
        if self.overlayPath is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soverlayPath>%s</%soverlayPath>%s' % (namespace_, self.gds_format_string(quote_xml(self.overlayPath).encode(ExternalEncoding), input_name='overlayPath'), namespace_, eol_))
        if self.overlayUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soverlayUri>%s</%soverlayUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.overlayUri).encode(ExternalEncoding), input_name='overlayUri'), namespace_, eol_))
        if self.packages is not None:
            self.packages.export(outfile, level, namespace_, name_='packages', pretty_print=pretty_print)
        if self.packagesUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spackagesUri>%s</%spackagesUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.packagesUri).encode(ExternalEncoding), input_name='packagesUri'), namespace_, eol_))
        if self.rejected is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srejected>%s</%srejected>%s' % (namespace_, self.gds_format_boolean(self.rejected, input_name='rejected'), namespace_, eol_))
        if self.scanRelativeDate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sscanRelativeDate>%s</%sscanRelativeDate>%s' % (namespace_, self.gds_format_string(quote_xml(self.scanRelativeDate).encode(ExternalEncoding), input_name='scanRelativeDate'), namespace_, eol_))
        if self.scanned is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sscanned>%s</%sscanned>%s' % (namespace_, self.gds_format_boolean(self.scanned, input_name='scanned'), namespace_, eol_))
        if self.scannedInstanceUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sscannedInstanceUri>%s</%sscannedInstanceUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.scannedInstanceUri).encode(ExternalEncoding), input_name='scannedInstanceUri'), namespace_, eol_))
        if self.status is not None:
            self.status.export(outfile, level, namespace_, name_='status', pretty_print=pretty_print)
        if self.totalFilesAdded is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stotalFilesAdded>%s</%stotalFilesAdded>%s' % (namespace_, self.gds_format_integer(self.totalFilesAdded, input_name='totalFilesAdded'), namespace_, eol_))
        if self.totalFilesDeleted is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stotalFilesDeleted>%s</%stotalFilesDeleted>%s' % (namespace_, self.gds_format_integer(self.totalFilesDeleted, input_name='totalFilesDeleted'), namespace_, eol_))
        if self.totalFilesModified is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stotalFilesModified>%s</%stotalFilesModified>%s' % (namespace_, self.gds_format_integer(self.totalFilesModified, input_name='totalFilesModified'), namespace_, eol_))
        if self.totalPackages is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stotalPackages>%s</%stotalPackages>%s' % (namespace_, self.gds_format_integer(self.totalPackages, input_name='totalPackages'), namespace_, eol_))
        if self.uncompressedBinarySize is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suncompressedBinarySize>%s</%suncompressedBinarySize>%s' % (namespace_, self.gds_format_integer(self.uncompressedBinarySize, input_name='uncompressedBinarySize'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
        if self.validated is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalidated>%s</%svalidated>%s' % (namespace_, self.gds_format_boolean(self.validated, input_name='validated'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='scan'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(scan, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(scan, self).exportLiteralChildren(outfile, level, name_)
        if self.binariesExtracted is not None:
            showIndent(outfile, level)
            outfile.write('binariesExtracted=%s,\n' % self.binariesExtracted)
        if self.binariesReceived is not None:
            showIndent(outfile, level)
            outfile.write('binariesReceived=%s,\n' % self.binariesReceived)
        if self.error is not None:
            showIndent(outfile, level)
            outfile.write('error=%s,\n' % self.error)
        if self.errorMsg is not None:
            showIndent(outfile, level)
            outfile.write('errorMsg=%s,\n' % quote_python(self.errorMsg).encode(ExternalEncoding))
        if self.scannedFiles is not None:
            showIndent(outfile, level)
            outfile.write('scannedFiles=model_.scannedFiles(\n')
            self.scannedFiles.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.filesUri is not None:
            showIndent(outfile, level)
            outfile.write('filesUri=%s,\n' % quote_python(self.filesUri).encode(ExternalEncoding))
        if self.images is not None:
            showIndent(outfile, level)
            outfile.write('images=model_.images(\n')
            self.images.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.imagesUri is not None:
            showIndent(outfile, level)
            outfile.write('imagesUri=%s,\n' % quote_python(self.imagesUri).encode(ExternalEncoding))
        if self.importsUri is not None:
            showIndent(outfile, level)
            outfile.write('importsUri=%s,\n' % quote_python(self.importsUri).encode(ExternalEncoding))
        if self.installProfile is not None:
            showIndent(outfile, level)
            outfile.write('installProfile=model_.installProfile(\n')
            self.installProfile.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.installProfileUri is not None:
            showIndent(outfile, level)
            outfile.write('installProfileUri=%s,\n' % quote_python(self.installProfileUri).encode(ExternalEncoding))
        if self.overlayCrc is not None:
            showIndent(outfile, level)
            outfile.write('overlayCrc=%s,\n' % quote_python(self.overlayCrc).encode(ExternalEncoding))
        if self.overlayImported is not None:
            showIndent(outfile, level)
            outfile.write('overlayImported=%s,\n' % self.overlayImported)
        if self.overlayPath is not None:
            showIndent(outfile, level)
            outfile.write('overlayPath=%s,\n' % quote_python(self.overlayPath).encode(ExternalEncoding))
        if self.overlayUri is not None:
            showIndent(outfile, level)
            outfile.write('overlayUri=%s,\n' % quote_python(self.overlayUri).encode(ExternalEncoding))
        if self.packages is not None:
            showIndent(outfile, level)
            outfile.write('packages=model_.packages(\n')
            self.packages.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.packagesUri is not None:
            showIndent(outfile, level)
            outfile.write('packagesUri=%s,\n' % quote_python(self.packagesUri).encode(ExternalEncoding))
        if self.rejected is not None:
            showIndent(outfile, level)
            outfile.write('rejected=%s,\n' % self.rejected)
        if self.scanRelativeDate is not None:
            showIndent(outfile, level)
            outfile.write('scanRelativeDate=%s,\n' % quote_python(self.scanRelativeDate).encode(ExternalEncoding))
        if self.scanned is not None:
            showIndent(outfile, level)
            outfile.write('scanned=%s,\n' % self.scanned)
        if self.scannedInstanceUri is not None:
            showIndent(outfile, level)
            outfile.write('scannedInstanceUri=%s,\n' % quote_python(self.scannedInstanceUri).encode(ExternalEncoding))
        if self.status is not None:
            showIndent(outfile, level)
            outfile.write('status=model_.status(\n')
            self.status.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.totalFilesAdded is not None:
            showIndent(outfile, level)
            outfile.write('totalFilesAdded=%d,\n' % self.totalFilesAdded)
        if self.totalFilesDeleted is not None:
            showIndent(outfile, level)
            outfile.write('totalFilesDeleted=%d,\n' % self.totalFilesDeleted)
        if self.totalFilesModified is not None:
            showIndent(outfile, level)
            outfile.write('totalFilesModified=%d,\n' % self.totalFilesModified)
        if self.totalPackages is not None:
            showIndent(outfile, level)
            outfile.write('totalPackages=%d,\n' % self.totalPackages)
        if self.uncompressedBinarySize is not None:
            showIndent(outfile, level)
            outfile.write('uncompressedBinarySize=%d,\n' % self.uncompressedBinarySize)
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.validated is not None:
            showIndent(outfile, level)
            outfile.write('validated=%s,\n' % self.validated)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(scan, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'binariesExtracted':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'binariesExtracted')
            self.binariesExtracted = ival_
        elif nodeName_ == 'binariesReceived':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'binariesReceived')
            self.binariesReceived = ival_
        elif nodeName_ == 'error':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'error')
            self.error = ival_
        elif nodeName_ == 'errorMsg':
            errorMsg_ = child_.text
            errorMsg_ = self.gds_validate_string(errorMsg_, node, 'errorMsg')
            self.errorMsg = errorMsg_
        elif nodeName_ == 'scannedFiles':
            obj_ = scannedFiles.factory()
            obj_.build(child_)
            self.scannedFiles = obj_
        elif nodeName_ == 'filesUri':
            filesUri_ = child_.text
            filesUri_ = self.gds_validate_string(filesUri_, node, 'filesUri')
            self.filesUri = filesUri_
        elif nodeName_ == 'images':
            obj_ = images.factory()
            obj_.build(child_)
            self.images = obj_
        elif nodeName_ == 'imagesUri':
            imagesUri_ = child_.text
            imagesUri_ = self.gds_validate_string(imagesUri_, node, 'imagesUri')
            self.imagesUri = imagesUri_
        elif nodeName_ == 'importsUri':
            importsUri_ = child_.text
            importsUri_ = self.gds_validate_string(importsUri_, node, 'importsUri')
            self.importsUri = importsUri_
        elif nodeName_ == 'installProfile':
            obj_ = installProfile.factory()
            obj_.build(child_)
            self.installProfile = obj_
        elif nodeName_ == 'installProfileUri':
            installProfileUri_ = child_.text
            installProfileUri_ = self.gds_validate_string(installProfileUri_, node, 'installProfileUri')
            self.installProfileUri = installProfileUri_
        elif nodeName_ == 'overlayCrc':
            overlayCrc_ = child_.text
            overlayCrc_ = self.gds_validate_string(overlayCrc_, node, 'overlayCrc')
            self.overlayCrc = overlayCrc_
        elif nodeName_ == 'overlayImported':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'overlayImported')
            self.overlayImported = ival_
        elif nodeName_ == 'overlayPath':
            overlayPath_ = child_.text
            overlayPath_ = self.gds_validate_string(overlayPath_, node, 'overlayPath')
            self.overlayPath = overlayPath_
        elif nodeName_ == 'overlayUri':
            overlayUri_ = child_.text
            overlayUri_ = self.gds_validate_string(overlayUri_, node, 'overlayUri')
            self.overlayUri = overlayUri_
        elif nodeName_ == 'packages':
            obj_ = packages.factory()
            obj_.build(child_)
            self.packages = obj_
        elif nodeName_ == 'packagesUri':
            packagesUri_ = child_.text
            packagesUri_ = self.gds_validate_string(packagesUri_, node, 'packagesUri')
            self.packagesUri = packagesUri_
        elif nodeName_ == 'rejected':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'rejected')
            self.rejected = ival_
        elif nodeName_ == 'scanRelativeDate':
            scanRelativeDate_ = child_.text
            scanRelativeDate_ = self.gds_validate_string(scanRelativeDate_, node, 'scanRelativeDate')
            self.scanRelativeDate = scanRelativeDate_
        elif nodeName_ == 'scanned':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'scanned')
            self.scanned = ival_
        elif nodeName_ == 'scannedInstanceUri':
            scannedInstanceUri_ = child_.text
            scannedInstanceUri_ = self.gds_validate_string(scannedInstanceUri_, node, 'scannedInstanceUri')
            self.scannedInstanceUri = scannedInstanceUri_
        elif nodeName_ == 'status':
            obj_ = opStatus.factory()
            obj_.build(child_)
            self.status = obj_
        elif nodeName_ == 'totalFilesAdded':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'totalFilesAdded')
            self.totalFilesAdded = ival_
        elif nodeName_ == 'totalFilesDeleted':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'totalFilesDeleted')
            self.totalFilesDeleted = ival_
        elif nodeName_ == 'totalFilesModified':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'totalFilesModified')
            self.totalFilesModified = ival_
        elif nodeName_ == 'totalPackages':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'totalPackages')
            self.totalPackages = ival_
        elif nodeName_ == 'uncompressedBinarySize':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'uncompressedBinarySize')
            self.uncompressedBinarySize = ival_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'validated':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'validated')
            self.validated = ival_
        super(scan, self).buildChildren(child_, node, nodeName_, True)
# end class scan


class scannedFiles(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, scannedFile=None):
        if scannedFile is None:
            self.scannedFile = []
        else:
            self.scannedFile = scannedFile
    def factory(*args_, **kwargs_):
        if scannedFiles.subclass:
            return scannedFiles.subclass(*args_, **kwargs_)
        else:
            return scannedFiles(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_scannedFile(self): return self.scannedFile
    def set_scannedFile(self, scannedFile): self.scannedFile = scannedFile
    def add_scannedFile(self, value): self.scannedFile.append(value)
    def insert_scannedFile(self, index, value): self.scannedFile[index] = value
    def hasContent_(self):
        if (
            self.scannedFile
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='scannedFiles', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='scannedFiles')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='scannedFiles'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='scannedFiles', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for scannedFile_ in self.scannedFile:
            scannedFile_.export(outfile, level, namespace_, name_='scannedFile', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='scannedFiles'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('scannedFile=[\n')
        level += 1
        for scannedFile_ in self.scannedFile:
            showIndent(outfile, level)
            outfile.write('model_.scannedFile(\n')
            scannedFile_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'scannedFile':
            obj_ = scannedFile.factory()
            obj_.build(child_)
            self.scannedFile.append(obj_)
# end class scannedFiles


class packages(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, package=None):
        if package is None:
            self.package = []
        else:
            self.package = package
    def factory(*args_, **kwargs_):
        if packages.subclass:
            return packages.subclass(*args_, **kwargs_)
        else:
            return packages(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_package(self): return self.package
    def set_package(self, package): self.package = package
    def add_package(self, value): self.package.append(value)
    def insert_package(self, index, value): self.package[index] = value
    def hasContent_(self):
        if (
            self.package
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='packages', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='packages')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='packages'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='packages', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for package_ in self.package:
            package_.export(outfile, level, namespace_, name_='package', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='packages'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('package=[\n')
        level += 1
        for package_ in self.package:
            showIndent(outfile, level)
            outfile.write('model_.scannedPkg(\n')
            package_.exportLiteral(outfile, level, name_='scannedPkg')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'package':
            obj_ = scannedPkg.factory()
            obj_.build(child_)
            self.package.append(obj_)
# end class packages


class fileEntry(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, checksum=None, directory=None, fullPath=None, group=None, linkTarget=None, owner=None, parentUri=None, permissions=None, scannedInstanceId=None, size=None, subEntries=None, uri=None, extensiontype_=None):
        super(fileEntry, self).__init__(created, dbId, digest, lastModified, name, extensiontype_, )
        self.checksum = checksum
        self.directory = directory
        self.fullPath = fullPath
        self.group = group
        self.linkTarget = linkTarget
        self.owner = owner
        self.parentUri = parentUri
        self.permissions = permissions
        self.scannedInstanceId = scannedInstanceId
        self.size = size
        self.subEntries = subEntries
        self.uri = uri
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if fileEntry.subclass:
            return fileEntry.subclass(*args_, **kwargs_)
        else:
            return fileEntry(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_checksum(self): return self.checksum
    def set_checksum(self, checksum): self.checksum = checksum
    def get_directory(self): return self.directory
    def set_directory(self, directory): self.directory = directory
    def get_fullPath(self): return self.fullPath
    def set_fullPath(self, fullPath): self.fullPath = fullPath
    def get_group(self): return self.group
    def set_group(self, group): self.group = group
    def get_linkTarget(self): return self.linkTarget
    def set_linkTarget(self, linkTarget): self.linkTarget = linkTarget
    def get_owner(self): return self.owner
    def set_owner(self, owner): self.owner = owner
    def get_parentUri(self): return self.parentUri
    def set_parentUri(self, parentUri): self.parentUri = parentUri
    def get_permissions(self): return self.permissions
    def set_permissions(self, permissions): self.permissions = permissions
    def get_scannedInstanceId(self): return self.scannedInstanceId
    def set_scannedInstanceId(self, scannedInstanceId): self.scannedInstanceId = scannedInstanceId
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    def get_subEntries(self): return self.subEntries
    def set_subEntries(self, subEntries): self.subEntries = subEntries
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.checksum is not None or
            self.directory is not None or
            self.fullPath is not None or
            self.group is not None or
            self.linkTarget is not None or
            self.owner is not None or
            self.parentUri is not None or
            self.permissions is not None or
            self.scannedInstanceId is not None or
            self.size is not None or
            self.subEntries is not None or
            self.uri is not None or
            super(fileEntry, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='fileEntry', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='fileEntry')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='fileEntry'):
        super(fileEntry, self).exportAttributes(outfile, level, already_processed, namespace_, name_='fileEntry')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='fileEntry', fromsubclass_=False, pretty_print=True):
        super(fileEntry, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.checksum is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%schecksum>%s</%schecksum>%s' % (namespace_, self.gds_format_string(quote_xml(self.checksum).encode(ExternalEncoding), input_name='checksum'), namespace_, eol_))
        if self.directory is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdirectory>%s</%sdirectory>%s' % (namespace_, self.gds_format_boolean(self.directory, input_name='directory'), namespace_, eol_))
        if self.fullPath is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfullPath>%s</%sfullPath>%s' % (namespace_, self.gds_format_string(quote_xml(self.fullPath).encode(ExternalEncoding), input_name='fullPath'), namespace_, eol_))
        if self.group is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgroup>%s</%sgroup>%s' % (namespace_, self.gds_format_string(quote_xml(self.group).encode(ExternalEncoding), input_name='group'), namespace_, eol_))
        if self.linkTarget is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slinkTarget>%s</%slinkTarget>%s' % (namespace_, self.gds_format_string(quote_xml(self.linkTarget).encode(ExternalEncoding), input_name='linkTarget'), namespace_, eol_))
        if self.owner is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sowner>%s</%sowner>%s' % (namespace_, self.gds_format_string(quote_xml(self.owner).encode(ExternalEncoding), input_name='owner'), namespace_, eol_))
        if self.parentUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparentUri>%s</%sparentUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.parentUri).encode(ExternalEncoding), input_name='parentUri'), namespace_, eol_))
        if self.permissions is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spermissions>%s</%spermissions>%s' % (namespace_, self.gds_format_string(quote_xml(self.permissions).encode(ExternalEncoding), input_name='permissions'), namespace_, eol_))
        if self.scannedInstanceId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sscannedInstanceId>%s</%sscannedInstanceId>%s' % (namespace_, self.gds_format_integer(self.scannedInstanceId, input_name='scannedInstanceId'), namespace_, eol_))
        if self.size is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssize>%s</%ssize>%s' % (namespace_, self.gds_format_integer(self.size, input_name='size'), namespace_, eol_))
        if self.subEntries is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssubEntries>%s</%ssubEntries>%s' % (namespace_, self.gds_format_integer(self.subEntries, input_name='subEntries'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='fileEntry'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(fileEntry, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(fileEntry, self).exportLiteralChildren(outfile, level, name_)
        if self.checksum is not None:
            showIndent(outfile, level)
            outfile.write('checksum=%s,\n' % quote_python(self.checksum).encode(ExternalEncoding))
        if self.directory is not None:
            showIndent(outfile, level)
            outfile.write('directory=%s,\n' % self.directory)
        if self.fullPath is not None:
            showIndent(outfile, level)
            outfile.write('fullPath=%s,\n' % quote_python(self.fullPath).encode(ExternalEncoding))
        if self.group is not None:
            showIndent(outfile, level)
            outfile.write('group=%s,\n' % quote_python(self.group).encode(ExternalEncoding))
        if self.linkTarget is not None:
            showIndent(outfile, level)
            outfile.write('linkTarget=%s,\n' % quote_python(self.linkTarget).encode(ExternalEncoding))
        if self.owner is not None:
            showIndent(outfile, level)
            outfile.write('owner=%s,\n' % quote_python(self.owner).encode(ExternalEncoding))
        if self.parentUri is not None:
            showIndent(outfile, level)
            outfile.write('parentUri=%s,\n' % quote_python(self.parentUri).encode(ExternalEncoding))
        if self.permissions is not None:
            showIndent(outfile, level)
            outfile.write('permissions=%s,\n' % quote_python(self.permissions).encode(ExternalEncoding))
        if self.scannedInstanceId is not None:
            showIndent(outfile, level)
            outfile.write('scannedInstanceId=%d,\n' % self.scannedInstanceId)
        if self.size is not None:
            showIndent(outfile, level)
            outfile.write('size=%d,\n' % self.size)
        if self.subEntries is not None:
            showIndent(outfile, level)
            outfile.write('subEntries=%d,\n' % self.subEntries)
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(fileEntry, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'checksum':
            checksum_ = child_.text
            checksum_ = self.gds_validate_string(checksum_, node, 'checksum')
            self.checksum = checksum_
        elif nodeName_ == 'directory':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'directory')
            self.directory = ival_
        elif nodeName_ == 'fullPath':
            fullPath_ = child_.text
            fullPath_ = self.gds_validate_string(fullPath_, node, 'fullPath')
            self.fullPath = fullPath_
        elif nodeName_ == 'group':
            group_ = child_.text
            group_ = self.gds_validate_string(group_, node, 'group')
            self.group = group_
        elif nodeName_ == 'linkTarget':
            linkTarget_ = child_.text
            linkTarget_ = self.gds_validate_string(linkTarget_, node, 'linkTarget')
            self.linkTarget = linkTarget_
        elif nodeName_ == 'owner':
            owner_ = child_.text
            owner_ = self.gds_validate_string(owner_, node, 'owner')
            self.owner = owner_
        elif nodeName_ == 'parentUri':
            parentUri_ = child_.text
            parentUri_ = self.gds_validate_string(parentUri_, node, 'parentUri')
            self.parentUri = parentUri_
        elif nodeName_ == 'permissions':
            permissions_ = child_.text
            permissions_ = self.gds_validate_string(permissions_, node, 'permissions')
            self.permissions = permissions_
        elif nodeName_ == 'scannedInstanceId':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'scannedInstanceId')
            self.scannedInstanceId = ival_
        elif nodeName_ == 'size':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'size')
            self.size = ival_
        elif nodeName_ == 'subEntries':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'subEntries')
            self.subEntries = ival_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        super(fileEntry, self).buildChildren(child_, node, nodeName_, True)
# end class fileEntry


class modifiedFiles(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, modifiedFile=None):
        if modifiedFile is None:
            self.modifiedFile = []
        else:
            self.modifiedFile = modifiedFile
    def factory(*args_, **kwargs_):
        if modifiedFiles.subclass:
            return modifiedFiles.subclass(*args_, **kwargs_)
        else:
            return modifiedFiles(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_modifiedFile(self): return self.modifiedFile
    def set_modifiedFile(self, modifiedFile): self.modifiedFile = modifiedFile
    def add_modifiedFile(self, value): self.modifiedFile.append(value)
    def insert_modifiedFile(self, index, value): self.modifiedFile[index] = value
    def hasContent_(self):
        if (
            self.modifiedFile
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='modifiedFiles', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='modifiedFiles')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='modifiedFiles'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='modifiedFiles', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for modifiedFile_ in self.modifiedFile:
            modifiedFile_.export(outfile, level, namespace_, name_='modifiedFile', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='modifiedFiles'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('modifiedFile=[\n')
        level += 1
        for modifiedFile_ in self.modifiedFile:
            showIndent(outfile, level)
            outfile.write('model_.scannedFile(\n')
            modifiedFile_.exportLiteral(outfile, level, name_='scannedFile')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'modifiedFile':
            obj_ = scannedFile.factory()
            obj_.build(child_)
            self.modifiedFile.append(obj_)
# end class modifiedFiles


class notModifiedFiles(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, notModifiedFile=None):
        if notModifiedFile is None:
            self.notModifiedFile = []
        else:
            self.notModifiedFile = notModifiedFile
    def factory(*args_, **kwargs_):
        if notModifiedFiles.subclass:
            return notModifiedFiles.subclass(*args_, **kwargs_)
        else:
            return notModifiedFiles(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_notModifiedFile(self): return self.notModifiedFile
    def set_notModifiedFile(self, notModifiedFile): self.notModifiedFile = notModifiedFile
    def add_notModifiedFile(self, value): self.notModifiedFile.append(value)
    def insert_notModifiedFile(self, index, value): self.notModifiedFile[index] = value
    def hasContent_(self):
        if (
            self.notModifiedFile
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='notModifiedFiles', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='notModifiedFiles')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='notModifiedFiles'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='notModifiedFiles', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for notModifiedFile_ in self.notModifiedFile:
            notModifiedFile_.export(outfile, level, namespace_, name_='notModifiedFile', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='notModifiedFiles'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('notModifiedFile=[\n')
        level += 1
        for notModifiedFile_ in self.notModifiedFile:
            showIndent(outfile, level)
            outfile.write('model_.scannedFile(\n')
            notModifiedFile_.exportLiteral(outfile, level, name_='scannedFile')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'notModifiedFile':
            obj_ = scannedFile.factory()
            obj_.build(child_)
            self.notModifiedFile.append(obj_)
# end class notModifiedFiles


class pkg(uForgeUploadObject):
    subclass = None
    superclass = uForgeUploadObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, md5sum=None, mimeType=None, sha256sum=None, size=None, status=None, uploaded=None, uploadedTime=None, arch=None, binaryUri=None, extract=None, fullName=None, install=None, installLocation=None, isDefault=None, isLanguage=None, origName=None, params=None, parentUri=None, pkgBuildDate=None, pkgFileDate=None, release=None, shortTag=None, sticky=None, type_=None, uri=None, version=None, extensiontype_=None):
        super(pkg, self).__init__(created, dbId, digest, lastModified, name, md5sum, mimeType, sha256sum, size, status, uploaded, uploadedTime, extensiontype_, )
        self.arch = arch
        self.binaryUri = binaryUri
        self.extract = extract
        self.fullName = fullName
        self.install = install
        self.installLocation = installLocation
        self.isDefault = isDefault
        self.isLanguage = isLanguage
        self.origName = origName
        self.params = params
        self.parentUri = parentUri
        if isinstance(pkgBuildDate, basestring):
            initvalue_ = datetime_.datetime.strptime(pkgBuildDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = pkgBuildDate
        self.pkgBuildDate = initvalue_
        if isinstance(pkgFileDate, basestring):
            initvalue_ = datetime_.datetime.strptime(pkgFileDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = pkgFileDate
        self.pkgFileDate = initvalue_
        self.release = release
        self.shortTag = shortTag
        self.sticky = sticky
        self.type_ = type_
        self.uri = uri
        self.version = version
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if pkg.subclass:
            return pkg.subclass(*args_, **kwargs_)
        else:
            return pkg(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_arch(self): return self.arch
    def set_arch(self, arch): self.arch = arch
    def get_binaryUri(self): return self.binaryUri
    def set_binaryUri(self, binaryUri): self.binaryUri = binaryUri
    def get_extract(self): return self.extract
    def set_extract(self, extract): self.extract = extract
    def get_fullName(self): return self.fullName
    def set_fullName(self, fullName): self.fullName = fullName
    def get_install(self): return self.install
    def set_install(self, install): self.install = install
    def get_installLocation(self): return self.installLocation
    def set_installLocation(self, installLocation): self.installLocation = installLocation
    def get_isDefault(self): return self.isDefault
    def set_isDefault(self, isDefault): self.isDefault = isDefault
    def get_isLanguage(self): return self.isLanguage
    def set_isLanguage(self, isLanguage): self.isLanguage = isLanguage
    def get_origName(self): return self.origName
    def set_origName(self, origName): self.origName = origName
    def get_params(self): return self.params
    def set_params(self, params): self.params = params
    def get_parentUri(self): return self.parentUri
    def set_parentUri(self, parentUri): self.parentUri = parentUri
    def get_pkgBuildDate(self): return self.pkgBuildDate
    def set_pkgBuildDate(self, pkgBuildDate): self.pkgBuildDate = pkgBuildDate
    def get_pkgFileDate(self): return self.pkgFileDate
    def set_pkgFileDate(self, pkgFileDate): self.pkgFileDate = pkgFileDate
    def get_release(self): return self.release
    def set_release(self, release): self.release = release
    def get_shortTag(self): return self.shortTag
    def set_shortTag(self, shortTag): self.shortTag = shortTag
    def get_sticky(self): return self.sticky
    def set_sticky(self, sticky): self.sticky = sticky
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.arch is not None or
            self.binaryUri is not None or
            self.extract is not None or
            self.fullName is not None or
            self.install is not None or
            self.installLocation is not None or
            self.isDefault is not None or
            self.isLanguage is not None or
            self.origName is not None or
            self.params is not None or
            self.parentUri is not None or
            self.pkgBuildDate is not None or
            self.pkgFileDate is not None or
            self.release is not None or
            self.shortTag is not None or
            self.sticky is not None or
            self.type_ is not None or
            self.uri is not None or
            self.version is not None or
            super(pkg, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='pkg', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='pkg')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='pkg'):
        super(pkg, self).exportAttributes(outfile, level, already_processed, namespace_, name_='pkg')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='pkg', fromsubclass_=False, pretty_print=True):
        super(pkg, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.arch is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sarch>%s</%sarch>%s' % (namespace_, self.gds_format_string(quote_xml(self.arch).encode(ExternalEncoding), input_name='arch'), namespace_, eol_))
        if self.binaryUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbinaryUri>%s</%sbinaryUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.binaryUri).encode(ExternalEncoding), input_name='binaryUri'), namespace_, eol_))
        if self.extract is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sextract>%s</%sextract>%s' % (namespace_, self.gds_format_boolean(self.extract, input_name='extract'), namespace_, eol_))
        if self.fullName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfullName>%s</%sfullName>%s' % (namespace_, self.gds_format_string(quote_xml(self.fullName).encode(ExternalEncoding), input_name='fullName'), namespace_, eol_))
        if self.install is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinstall>%s</%sinstall>%s' % (namespace_, self.gds_format_boolean(self.install, input_name='install'), namespace_, eol_))
        if self.installLocation is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sinstallLocation>%s</%sinstallLocation>%s' % (namespace_, self.gds_format_string(quote_xml(self.installLocation).encode(ExternalEncoding), input_name='installLocation'), namespace_, eol_))
        if self.isDefault is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sisDefault>%s</%sisDefault>%s' % (namespace_, self.gds_format_boolean(self.isDefault, input_name='isDefault'), namespace_, eol_))
        if self.isLanguage is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sisLanguage>%s</%sisLanguage>%s' % (namespace_, self.gds_format_boolean(self.isLanguage, input_name='isLanguage'), namespace_, eol_))
        if self.origName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorigName>%s</%sorigName>%s' % (namespace_, self.gds_format_string(quote_xml(self.origName).encode(ExternalEncoding), input_name='origName'), namespace_, eol_))
        if self.params is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparams>%s</%sparams>%s' % (namespace_, self.gds_format_string(quote_xml(self.params).encode(ExternalEncoding), input_name='params'), namespace_, eol_))
        if self.parentUri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sparentUri>%s</%sparentUri>%s' % (namespace_, self.gds_format_string(quote_xml(self.parentUri).encode(ExternalEncoding), input_name='parentUri'), namespace_, eol_))
        if self.pkgBuildDate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spkgBuildDate>%s</%spkgBuildDate>%s' % (namespace_, self.gds_format_datetime(self.pkgBuildDate, input_name='pkgBuildDate'), namespace_, eol_))
        if self.pkgFileDate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spkgFileDate>%s</%spkgFileDate>%s' % (namespace_, self.gds_format_datetime(self.pkgFileDate, input_name='pkgFileDate'), namespace_, eol_))
        if self.release is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srelease>%s</%srelease>%s' % (namespace_, self.gds_format_string(quote_xml(self.release).encode(ExternalEncoding), input_name='release'), namespace_, eol_))
        if self.shortTag is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sshortTag>%s</%sshortTag>%s' % (namespace_, self.gds_format_string(quote_xml(self.shortTag).encode(ExternalEncoding), input_name='shortTag'), namespace_, eol_))
        if self.sticky is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssticky>%s</%ssticky>%s' % (namespace_, self.gds_format_boolean(self.sticky, input_name='sticky'), namespace_, eol_))
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
        if self.uri is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%suri>%s</%suri>%s' % (namespace_, self.gds_format_string(quote_xml(self.uri).encode(ExternalEncoding), input_name='uri'), namespace_, eol_))
        if self.version is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sversion>%s</%sversion>%s' % (namespace_, self.gds_format_string(quote_xml(self.version).encode(ExternalEncoding), input_name='version'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='pkg'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(pkg, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(pkg, self).exportLiteralChildren(outfile, level, name_)
        if self.arch is not None:
            showIndent(outfile, level)
            outfile.write('arch=%s,\n' % quote_python(self.arch).encode(ExternalEncoding))
        if self.binaryUri is not None:
            showIndent(outfile, level)
            outfile.write('binaryUri=%s,\n' % quote_python(self.binaryUri).encode(ExternalEncoding))
        if self.extract is not None:
            showIndent(outfile, level)
            outfile.write('extract=%s,\n' % self.extract)
        if self.fullName is not None:
            showIndent(outfile, level)
            outfile.write('fullName=%s,\n' % quote_python(self.fullName).encode(ExternalEncoding))
        if self.install is not None:
            showIndent(outfile, level)
            outfile.write('install=%s,\n' % self.install)
        if self.installLocation is not None:
            showIndent(outfile, level)
            outfile.write('installLocation=%s,\n' % quote_python(self.installLocation).encode(ExternalEncoding))
        if self.isDefault is not None:
            showIndent(outfile, level)
            outfile.write('isDefault=%s,\n' % self.isDefault)
        if self.isLanguage is not None:
            showIndent(outfile, level)
            outfile.write('isLanguage=%s,\n' % self.isLanguage)
        if self.origName is not None:
            showIndent(outfile, level)
            outfile.write('origName=%s,\n' % quote_python(self.origName).encode(ExternalEncoding))
        if self.params is not None:
            showIndent(outfile, level)
            outfile.write('params=%s,\n' % quote_python(self.params).encode(ExternalEncoding))
        if self.parentUri is not None:
            showIndent(outfile, level)
            outfile.write('parentUri=%s,\n' % quote_python(self.parentUri).encode(ExternalEncoding))
        if self.pkgBuildDate is not None:
            showIndent(outfile, level)
            outfile.write('pkgBuildDate=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.pkgBuildDate, input_name='pkgBuildDate'))
        if self.pkgFileDate is not None:
            showIndent(outfile, level)
            outfile.write('pkgFileDate=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.pkgFileDate, input_name='pkgFileDate'))
        if self.release is not None:
            showIndent(outfile, level)
            outfile.write('release=%s,\n' % quote_python(self.release).encode(ExternalEncoding))
        if self.shortTag is not None:
            showIndent(outfile, level)
            outfile.write('shortTag=%s,\n' % quote_python(self.shortTag).encode(ExternalEncoding))
        if self.sticky is not None:
            showIndent(outfile, level)
            outfile.write('sticky=%s,\n' % self.sticky)
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
        if self.uri is not None:
            showIndent(outfile, level)
            outfile.write('uri=%s,\n' % quote_python(self.uri).encode(ExternalEncoding))
        if self.version is not None:
            showIndent(outfile, level)
            outfile.write('version=%s,\n' % quote_python(self.version).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(pkg, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'arch':
            arch_ = child_.text
            arch_ = self.gds_validate_string(arch_, node, 'arch')
            self.arch = arch_
        elif nodeName_ == 'binaryUri':
            binaryUri_ = child_.text
            binaryUri_ = self.gds_validate_string(binaryUri_, node, 'binaryUri')
            self.binaryUri = binaryUri_
        elif nodeName_ == 'extract':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'extract')
            self.extract = ival_
        elif nodeName_ == 'fullName':
            fullName_ = child_.text
            fullName_ = self.gds_validate_string(fullName_, node, 'fullName')
            self.fullName = fullName_
        elif nodeName_ == 'install':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'install')
            self.install = ival_
        elif nodeName_ == 'installLocation':
            installLocation_ = child_.text
            installLocation_ = self.gds_validate_string(installLocation_, node, 'installLocation')
            self.installLocation = installLocation_
        elif nodeName_ == 'isDefault':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'isDefault')
            self.isDefault = ival_
        elif nodeName_ == 'isLanguage':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'isLanguage')
            self.isLanguage = ival_
        elif nodeName_ == 'origName':
            origName_ = child_.text
            origName_ = self.gds_validate_string(origName_, node, 'origName')
            self.origName = origName_
        elif nodeName_ == 'params':
            params_ = child_.text
            params_ = self.gds_validate_string(params_, node, 'params')
            self.params = params_
        elif nodeName_ == 'parentUri':
            parentUri_ = child_.text
            parentUri_ = self.gds_validate_string(parentUri_, node, 'parentUri')
            self.parentUri = parentUri_
        elif nodeName_ == 'pkgBuildDate':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.pkgBuildDate = dval_
        elif nodeName_ == 'pkgFileDate':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.pkgFileDate = dval_
        elif nodeName_ == 'release':
            release_ = child_.text
            release_ = self.gds_validate_string(release_, node, 'release')
            self.release = release_
        elif nodeName_ == 'shortTag':
            shortTag_ = child_.text
            shortTag_ = self.gds_validate_string(shortTag_, node, 'shortTag')
            self.shortTag = shortTag_
        elif nodeName_ == 'sticky':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'sticky')
            self.sticky = ival_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        elif nodeName_ == 'uri':
            uri_ = child_.text
            uri_ = self.gds_validate_string(uri_, node, 'uri')
            self.uri = uri_
        elif nodeName_ == 'version':
            version_ = child_.text
            version_ = self.gds_validate_string(version_, node, 'version')
            self.version = version_
        super(pkg, self).buildChildren(child_, node, nodeName_, True)
# end class pkg


class pkgUpdateInfoList(uForgeObjects):
    subclass = None
    superclass = uForgeObjects
    def __init__(self, total=None, pkgUpdateInfo=None):
        super(pkgUpdateInfoList, self).__init__(total, )
        if pkgUpdateInfo is None:
            self.pkgUpdateInfo = []
        else:
            self.pkgUpdateInfo = pkgUpdateInfo
    def factory(*args_, **kwargs_):
        if pkgUpdateInfoList.subclass:
            return pkgUpdateInfoList.subclass(*args_, **kwargs_)
        else:
            return pkgUpdateInfoList(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_pkgUpdateInfo(self): return self.pkgUpdateInfo
    def set_pkgUpdateInfo(self, pkgUpdateInfo): self.pkgUpdateInfo = pkgUpdateInfo
    def add_pkgUpdateInfo(self, value): self.pkgUpdateInfo.append(value)
    def insert_pkgUpdateInfo(self, index, value): self.pkgUpdateInfo[index] = value
    def hasContent_(self):
        if (
            self.pkgUpdateInfo or
            super(pkgUpdateInfoList, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='pkgUpdateInfoList', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='pkgUpdateInfoList')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='pkgUpdateInfoList'):
        super(pkgUpdateInfoList, self).exportAttributes(outfile, level, already_processed, namespace_, name_='pkgUpdateInfoList')
    def exportChildren(self, outfile, level, namespace_='', name_='pkgUpdateInfoList', fromsubclass_=False, pretty_print=True):
        super(pkgUpdateInfoList, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for pkgUpdateInfo_ in self.pkgUpdateInfo:
            pkgUpdateInfo_.export(outfile, level, namespace_, name_='pkgUpdateInfo', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='pkgUpdateInfoList'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(pkgUpdateInfoList, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(pkgUpdateInfoList, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('pkgUpdateInfo=[\n')
        level += 1
        for pkgUpdateInfo_ in self.pkgUpdateInfo:
            showIndent(outfile, level)
            outfile.write('model_.pkgUpdateInfo(\n')
            pkgUpdateInfo_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(pkgUpdateInfoList, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'pkgUpdateInfo':
            obj_ = pkgUpdateInfo.factory()
            obj_.build(child_)
            self.pkgUpdateInfo.append(obj_)
        super(pkgUpdateInfoList, self).buildChildren(child_, node, nodeName_, True)
# end class pkgUpdateInfoList


class pkgUpdateInfo(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, date=None, description=None, source=None, sourceId=None, type_=None):
        super(pkgUpdateInfo, self).__init__(created, dbId, digest, lastModified, name, )
        if isinstance(date, basestring):
            initvalue_ = datetime_.datetime.strptime(date, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = date
        self.date = initvalue_
        self.description = description
        self.source = source
        self.sourceId = sourceId
        self.type_ = type_
    def factory(*args_, **kwargs_):
        if pkgUpdateInfo.subclass:
            return pkgUpdateInfo.subclass(*args_, **kwargs_)
        else:
            return pkgUpdateInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_date(self): return self.date
    def set_date(self, date): self.date = date
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_source(self): return self.source
    def set_source(self, source): self.source = source
    def get_sourceId(self): return self.sourceId
    def set_sourceId(self, sourceId): self.sourceId = sourceId
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def hasContent_(self):
        if (
            self.date is not None or
            self.description is not None or
            self.source is not None or
            self.sourceId is not None or
            self.type_ is not None or
            super(pkgUpdateInfo, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='pkgUpdateInfo', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='pkgUpdateInfo')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='pkgUpdateInfo'):
        super(pkgUpdateInfo, self).exportAttributes(outfile, level, already_processed, namespace_, name_='pkgUpdateInfo')
    def exportChildren(self, outfile, level, namespace_='', name_='pkgUpdateInfo', fromsubclass_=False, pretty_print=True):
        super(pkgUpdateInfo, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.date is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdate>%s</%sdate>%s' % (namespace_, self.gds_format_datetime(self.date, input_name='date'), namespace_, eol_))
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_, eol_))
        if self.source is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssource>%s</%ssource>%s' % (namespace_, self.gds_format_string(quote_xml(self.source).encode(ExternalEncoding), input_name='source'), namespace_, eol_))
        if self.sourceId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssourceId>%s</%ssourceId>%s' % (namespace_, self.gds_format_string(quote_xml(self.sourceId).encode(ExternalEncoding), input_name='sourceId'), namespace_, eol_))
        if self.type_ is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stype>%s</%stype>%s' % (namespace_, self.gds_format_string(quote_xml(self.type_).encode(ExternalEncoding), input_name='type'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='pkgUpdateInfo'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(pkgUpdateInfo, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(pkgUpdateInfo, self).exportLiteralChildren(outfile, level, name_)
        if self.date is not None:
            showIndent(outfile, level)
            outfile.write('date=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.date, input_name='date'))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        if self.source is not None:
            showIndent(outfile, level)
            outfile.write('source=%s,\n' % quote_python(self.source).encode(ExternalEncoding))
        if self.sourceId is not None:
            showIndent(outfile, level)
            outfile.write('sourceId=%s,\n' % quote_python(self.sourceId).encode(ExternalEncoding))
        if self.type_ is not None:
            showIndent(outfile, level)
            outfile.write('type_=%s,\n' % quote_python(self.type_).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(pkgUpdateInfo, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'date':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.date = dval_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'source':
            source_ = child_.text
            source_ = self.gds_validate_string(source_, node, 'source')
            self.source = source_
        elif nodeName_ == 'sourceId':
            sourceId_ = child_.text
            sourceId_ = self.gds_validate_string(sourceId_, node, 'sourceId')
            self.sourceId = sourceId_
        elif nodeName_ == 'type':
            type_ = child_.text
            type_ = self.gds_validate_string(type_, node, 'type')
            self.type_ = type_
        super(pkgUpdateInfo, self).buildChildren(child_, node, nodeName_, True)
# end class pkgUpdateInfo


class referrals(uForgeObjects):
    subclass = None
    superclass = uForgeObjects
    def __init__(self, total=None, msg=None, referral=None):
        super(referrals, self).__init__(total, )
        self.msg = msg
        if referral is None:
            self.referral = []
        else:
            self.referral = referral
    def factory(*args_, **kwargs_):
        if referrals.subclass:
            return referrals.subclass(*args_, **kwargs_)
        else:
            return referrals(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_msg(self): return self.msg
    def set_msg(self, msg): self.msg = msg
    def get_referral(self): return self.referral
    def set_referral(self, referral): self.referral = referral
    def add_referral(self, value): self.referral.append(value)
    def insert_referral(self, index, value): self.referral[index] = value
    def hasContent_(self):
        if (
            self.msg is not None or
            self.referral or
            super(referrals, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='referrals', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='referrals')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='referrals'):
        super(referrals, self).exportAttributes(outfile, level, already_processed, namespace_, name_='referrals')
    def exportChildren(self, outfile, level, namespace_='', name_='referrals', fromsubclass_=False, pretty_print=True):
        super(referrals, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.msg is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smsg>%s</%smsg>%s' % (namespace_, self.gds_format_string(quote_xml(self.msg).encode(ExternalEncoding), input_name='msg'), namespace_, eol_))
        for referral_ in self.referral:
            referral_.export(outfile, level, namespace_, name_='referral', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='referrals'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(referrals, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(referrals, self).exportLiteralChildren(outfile, level, name_)
        if self.msg is not None:
            showIndent(outfile, level)
            outfile.write('msg=%s,\n' % quote_python(self.msg).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('referral=[\n')
        level += 1
        for referral_ in self.referral:
            showIndent(outfile, level)
            outfile.write('model_.referral(\n')
            referral_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(referrals, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'msg':
            msg_ = child_.text
            msg_ = self.gds_validate_string(msg_, node, 'msg')
            self.msg = msg_
        elif nodeName_ == 'referral':
            class_obj_ = self.get_class_obj_(child_, referral)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.referral.append(obj_)
        super(referrals, self).buildChildren(child_, node, nodeName_, True)
# end class referrals


class referral(uForgeObject):
    subclass = None
    superclass = uForgeObject
    def __init__(self, created=None, dbId=None, digest=None, lastModified=None, name=None, accepted=None, declined=None, msg=None, parentUri=None, uri=None, user=None, userEmail=None, userLogin=None, extensiontype_=None):
        super(referral, self).__init__(created, dbId, digest, lastModified, name, extensiontype_, )
        self.accepted = accepted
        self.declined = declined
   