from functools import reduce
from typing import Dict, List, Tuple

from faststream.types import SettingField


def parse_cli_args(*args: str) -> Tuple[str, Dict[str, SettingField]]:
    """Parses command line arguments.

    Args:
        *args: Command line arguments as strings.

    Returns:
        A tuple containing the application name and a dictionary of additional keyword arguments.
    !!! note

        The above docstring is autogenerated by docstring-gen library (https://docstring-gen.airt.ai)
    """
    extra_kwargs: Dict[str, SettingField] = {}

    k: str = ""
    v: SettingField

    field_args: List[str] = []
    app = ""
    for item in reduce(
        lambda acc, x: acc + x.split("="),  # type: ignore
        args,
        [],
    ) + ["-"]:
        if ":" in item:
            app = item

        else:
            if "-" in item:
                if k:
                    k = k.strip().lstrip("-").replace("-", "_")

                    if len(field_args) == 0:
                        v = not k.startswith("no_")
                    elif len(field_args) == 1:
                        v = field_args[0]
                    else:
                        v = field_args

                    key = remove_prefix(k, "no_")
                    if (exists := extra_kwargs.get(key)) is not None:
                        if not isinstance(exists, list):
                            v = [exists, v]
                        else:
                            v = exists + [v]

                    extra_kwargs[key] = v
                    field_args = []

                k = item

            else:
                field_args.append(item)

    return app, extra_kwargs


def remove_prefix(text: str, prefix: str) -> str:
    """Removes a prefix from a given text.

    Python 3.8 compatibility function

    Args:
        text (str): The text from which the prefix will be removed.
        prefix (str): The prefix to be removed from the text.

    Returns:
        str: The text with the prefix removed. If the text does not start with the prefix, the original text is returned.
    !!! note

        The above docstring is autogenerated by docstring-gen library (https://docstring-gen.airt.ai)
    """
    if text.startswith(prefix):
        return text[len(prefix) :]
    return text
