from __future__ import annotations

from datetime import datetime, timedelta
from typing import Mapping, Optional, Tuple, Sequence, Union

from xotless.types import TEq, TOrd
from .types import Result

ProcedureIndex = int

class Program:
    def __init__(self, capacity: int = None) -> None: ...
    @property
    def procedure_index(self) -> ProcedureIndex: ...
    def copy(self) -> Program: ...
    def add_identity_procedure(
        self, index: ProcedureIndex, proc: ProcedureIndex
    ) -> None: ...
    def add_undefined_procedure(
        self, index: ProcedureIndex, title: str = None
    ) -> None: ...
    def add_constant_procedure(
        self, index: ProcedureIndex, value: float = None
    ) -> None: ...
    def add_getattr_procedure(self, index: ProcedureIndex, attr: str) -> None: ...
    def add_varname_procedure(
        self, index: ProcedureIndex, varname: str, default: float
    ) -> None: ...
    def add_formula_procedure(
        self, index: ProcedureIndex, code: str, procedures: Sequence[ProcedureIndex]
    ) -> None: ...
    def add_ceil_procedure(self, index: ProcedureIndex, proc: ProcedureIndex) -> None: ...
    def add_floor_procedure(
        self, index: ProcedureIndex, proc: ProcedureIndex
    ) -> None: ...
    def add_round_procedure(
        self, index: ProcedureIndex, digits: int, proc: ProcedureIndex
    ) -> None: ...
    def add_setenv_procedure(
        self, index: ProcedureIndex, env: Mapping[str, float], proc: ProcedureIndex
    ) -> None: ...
    def add_setfallback_procedure(
        self, index: ProcedureIndex, env: Mapping[str, float], proc: ProcedureIndex
    ) -> None: ...
    def add_branching_procedure_with_validity_pred(
        self,
        index: ProcedureIndex,
        branches: Sequence[Tuple[datetime, datetime, ProcedureIndex]],
        otherwise: Optional[ProcedureIndex],
        backtrack: bool,
    ) -> None: ...
    def add_branching_procedure_with_execution_pred(
        self,
        index: ProcedureIndex,
        branches: Sequence[Tuple[datetime, datetime, ProcedureIndex]],
        otherwise: Optional[ProcedureIndex],
        backtrack: bool,
    ) -> None: ...
    def add_branching_procedure_with_quantity_pred(
        self,
        index: ProcedureIndex,
        branches: Sequence[Tuple[float, float, ProcedureIndex]],
        otherwise: Optional[ProcedureIndex],
        backtrack: bool,
    ) -> None: ...
    def add_branching_procedure_with_match_attr_pred(
        self,
        index: ProcedureIndex,
        branches: Sequence[Tuple[str, TEq, ProcedureIndex]],
        otherwise: Optional[ProcedureIndex],
        backtrack: bool,
    ) -> None: ...
    def add_branching_procedure_with_attr_in_range_pred(
        self,
        index: ProcedureIndex,
        branches: Sequence[Tuple[str, TOrd, TOrd, ProcedureIndex]],
        otherwise: Optional[ProcedureIndex],
        backtrack: bool,
    ) -> None: ...
    def add_matrix_procedure(
        self, index: ProcedureIndex, matrix: MatrixProcedure
    ) -> None: ...
    def execute(self, demand: UnitaryDemand, undefined: Result) -> Result: ...
    def execute_many(
        self, demand: Sequence[UnitaryDemand], undefined: Result
    ) -> Sequence[Result]: ...

class ExternalObject:
    def __init__(self, name: str, id: int) -> None: ...
    @classmethod
    def from_tuple(cls, desc: ExternalObjectDesc) -> ExternalObject: ...
    @classmethod
    def from_reference_string(cls, refstr: str) -> ExternalObject: ...

ExternalObjectDesc = Tuple[str, int]
Value = Union[datetime, timedelta, float, str, ExternalObject, ExternalObjectDesc]

class UnitaryDemand:
    def __init__(
        self,
        date: datetime,
        quantity: float,
        start_date: datetime,
        attrs: Mapping[str, Value],
    ) -> None: ...
    @classmethod
    def default(cls) -> UnitaryDemand: ...
    def attr(self, attr: str) -> Optional[Value]: ...
    def replace_attr(self, attr: str, value: Value) -> UnitaryDemand: ...

class NullDemand: ...

class MatrixProcedure:
    def add_row(self, row: MatrixRow, result: float): ...

class MatrixRow:
    def add_condition_demand_date_in_range(self, start: datetime, end: datetime): ...
    def add_condition_demand_date_is(self, date: datetime): ...
    def add_condition_start_date_in_range(self, start: datetime, end: datetime): ...
    def add_condition_start_date_is(self, date: datetime): ...
    def add_condition_quantity_in_range(self, min_: float, max_: float): ...
    def add_condition_quantity_is(self, quantity: float): ...
    def add_condition_attr_in_range(self, attr: str, lower: Value, upper: Value): ...
    def add_condition_attr_is(self, attr: str, value: Value): ...
