# -*- coding: utf-8 -*-
# Generated by Django 1.11.7 on 2017-12-22 14:18
from __future__ import unicode_literals

import django.db.models.deletion
import django.utils.timezone
import djgeojson.fields
from django.conf import settings
from django.conf import settings
from django.contrib.sites.models import Site
from django.db import migrations, models


# Functions from the following migrations need manual copying.
# Move them and any dependencies into this file, then update the
# RunPython operations to refer to the local versions:
# mainapp.migrations.0012_site

class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('sites', '0002_alter_domain_unique'),
    ]

    operations = [
        migrations.CreateModel(
            name='AgendaItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('key', models.CharField(max_length=20)),
                ('position', models.IntegerField()),
                ('public', models.NullBooleanField()),
            ],
            options={
                'ordering': ['position'],
            },
        ),
        migrations.CreateModel(
            name='Body',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('oparl_id', models.CharField(blank=True, max_length=2000, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('deleted', models.BooleanField(default=False)),
                ('name', models.CharField(max_length=200)),
                ('short_name', models.CharField(max_length=50)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Committee',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('oparl_id', models.CharField(blank=True, max_length=2000, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('deleted', models.BooleanField(default=False)),
                ('name', models.CharField(max_length=200)),
                ('short_name', models.CharField(max_length=50)),
                ('body', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mainapp.Body')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CommitteeMembership',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('oparl_id', models.CharField(blank=True, max_length=2000, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('deleted', models.BooleanField(default=False)),
                ('start', models.DateField()),
                ('end', models.DateField()),
                ('role', models.CharField(max_length=200)),
                ('committee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mainapp.Committee')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Department',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('oparl_id', models.CharField(blank=True, max_length=2000, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('deleted', models.BooleanField(default=False)),
                ('name', models.CharField(max_length=200)),
                ('short_name', models.CharField(max_length=50)),
                ('body', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mainapp.Body')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='File',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('oparl_id', models.CharField(blank=True, max_length=2000, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('deleted', models.BooleanField(default=False)),
                ('storage_filename', models.CharField(max_length=256)),
                ('displayed_filename', models.CharField(max_length=256)),
                ('legal_date', models.DateField()),
                ('filesize', models.IntegerField()),
                ('parsed_text', models.TextField(blank=True, null=True)),
                ('license', models.CharField(blank=True, max_length=200, null=True)),
                ('description', models.TextField(blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='LegislativeTerm',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('oparl_id', models.CharField(blank=True, max_length=2000, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('deleted', models.BooleanField(default=False)),
                ('name', models.CharField(max_length=200)),
                ('start_date', models.DateField()),
                ('end_date', models.DateField()),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Location',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('oparl_id', models.CharField(blank=True, max_length=2000, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('deleted', models.BooleanField(default=False)),
                ('displayed_name', models.CharField(max_length=1000)),
                ('description', models.TextField(blank=True, null=True)),
                ('is_official', models.BooleanField()),
                ('osm_id', models.BigIntegerField(blank=True, null=True)),
                ('geometry', djgeojson.fields.GeometryField(default=None)),
                ('bodies', models.ManyToManyField(blank=True, to='mainapp.Body')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Meeting',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('oparl_id', models.CharField(blank=True, max_length=2000, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('deleted', models.BooleanField(default=False)),
                ('name', models.CharField(max_length=1000)),
                ('cancelled', models.BooleanField()),
                ('start', models.DateTimeField()),
                ('end', models.DateTimeField()),
                ('public', models.IntegerField(blank=True, choices=[(0, 'unknown'), (1, 'public'), (2, 'not public'), (3, 'splitted')], default=0)),
                ('auxiliary_files', models.ManyToManyField(blank=True, related_name='meeting_auxiliary_files', to='mainapp.File')),
                ('committees', models.ManyToManyField(blank=True, to='mainapp.Committee')),
                ('invitation', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='meeting_invitation', to='mainapp.File')),
                ('locations', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='mainapp.Location')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MeetingSeries',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('oparl_id', models.CharField(blank=True, max_length=2000, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('deleted', models.BooleanField(default=False)),
                ('name', models.CharField(max_length=1000)),
                ('description', models.TextField(blank=True, null=True)),
                ('is_regular', models.BooleanField()),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Paper',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('oparl_id', models.CharField(blank=True, max_length=2000, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('deleted', models.BooleanField(default=False)),
                ('reference_number', models.CharField(max_length=50)),
                ('name', models.CharField(max_length=200)),
                ('short_name', models.CharField(max_length=50)),
                ('description', models.TextField(blank=True, null=True)),
                ('is_change_request_of', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='mainapp.Paper')),
                ('submitter_committee', models.ManyToManyField(to='mainapp.Committee')),
                ('submitter_department', models.ManyToManyField(to='mainapp.Department')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ParliamentaryGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('oparl_id', models.CharField(blank=True, max_length=2000, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('deleted', models.BooleanField(default=False)),
                ('name', models.CharField(max_length=200)),
                ('start', models.DateField()),
                ('end', models.DateField()),
                ('short_name', models.CharField(max_length=20)),
                ('body', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mainapp.Body')),
                ('legislative_terms', models.ManyToManyField(blank=True, to='mainapp.LegislativeTerm')),
                ('location', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='mainapp.Location')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ParliamentaryGroupMembership',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('oparl_id', models.CharField(blank=True, max_length=2000, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('deleted', models.BooleanField(default=False)),
                ('start', models.DateField()),
                ('end', models.DateField()),
                ('role', models.CharField(max_length=200)),
                ('parliamentary_group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mainapp.ParliamentaryGroup')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Person',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('oparl_id', models.CharField(blank=True, max_length=2000, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('deleted', models.BooleanField(default=False)),
                ('name', models.CharField(max_length=100)),
                ('given_name', models.CharField(max_length=50)),
                ('family_name', models.CharField(max_length=50)),
                ('location', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='mainapp.Location')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SearchPoi',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('oparl_id', models.CharField(blank=True, max_length=2000, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('deleted', models.BooleanField(default=False)),
                ('displayed_name', models.CharField(max_length=1000)),
                ('osm_id', models.BigIntegerField(blank=True, null=True)),
                ('osm_amenity', models.CharField(max_length=1000, null=True)),
                ('geometry', djgeojson.fields.GeometryField(null=True)),
                ('exclude_from_search', models.BooleanField(default=False)),
                ('bodies', models.ManyToManyField(blank=True, to='mainapp.Body')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SearchStreet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('oparl_id', models.CharField(blank=True, max_length=2000, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('deleted', models.BooleanField(default=False)),
                ('displayed_name', models.CharField(max_length=1000)),
                ('osm_id', models.BigIntegerField(blank=True, null=True)),
                ('exclude_from_search', models.BooleanField(default=False)),
                ('bodies', models.ManyToManyField(blank=True, to='mainapp.Body')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='parliamentarygroupmembership',
            name='person',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mainapp.Person'),
        ),
        migrations.AddField(
            model_name='paper',
            name='submitter_parliamentary_groups',
            field=models.ManyToManyField(blank=True, to='mainapp.ParliamentaryGroup'),
        ),
        migrations.AddField(
            model_name='paper',
            name='submitter_persons',
            field=models.ManyToManyField(blank=True, to='mainapp.Person'),
        ),
        migrations.AddField(
            model_name='meeting',
            name='meeting_series',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='mainapp.MeetingSeries'),
        ),
        migrations.AddField(
            model_name='meeting',
            name='persons',
            field=models.ManyToManyField(blank=True, to='mainapp.Person'),
        ),
        migrations.AddField(
            model_name='meeting',
            name='results_protocol',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='meeting_results_protocol', to='mainapp.File'),
        ),
        migrations.AddField(
            model_name='meeting',
            name='verbatim_protocol',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='meeting_verbatim_protocol', to='mainapp.File'),
        ),
        migrations.AddField(
            model_name='file',
            name='locations',
            field=models.ManyToManyField(blank=True, to='mainapp.Location'),
        ),
        migrations.AddField(
            model_name='file',
            name='paper',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='mainapp.Paper'),
        ),
        migrations.AddField(
            model_name='department',
            name='location',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='mainapp.Location'),
        ),
        migrations.AddField(
            model_name='committeemembership',
            name='person',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mainapp.Person'),
        ),
        migrations.AddField(
            model_name='committee',
            name='legislative_terms',
            field=models.ManyToManyField(blank=True, to='mainapp.LegislativeTerm'),
        ),
        migrations.AddField(
            model_name='committee',
            name='location',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='mainapp.Location'),
        ),
        migrations.AddField(
            model_name='body',
            name='center',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='body_center', to='mainapp.Location'),
        ),
        migrations.AddField(
            model_name='body',
            name='legislative_terms',
            field=models.ManyToManyField(blank=True, to='mainapp.LegislativeTerm'),
        ),
        migrations.AddField(
            model_name='body',
            name='outline',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='body_outline', to='mainapp.Location'),
        ),
        migrations.AddField(
            model_name='agendaitem',
            name='meeting',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mainapp.Meeting'),
        ),
        migrations.AddField(
            model_name='agendaitem',
            name='paper',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='mainapp.Paper'),
        ),
        migrations.AddField(
            model_name='agendaitem',
            name='title',
            field=models.CharField(default='', max_length=1000),
            preserve_default=False,
        ),
        migrations.AlterUniqueTogether(
            name='agendaitem',
            unique_together=set([('meeting', 'position')]),
        ),
        migrations.RemoveField(
            model_name='location',
            name='displayed_name',
        ),
        migrations.AddField(
            model_name='legislativeterm',
            name='short_name',
            field=models.CharField(default='', max_length=200),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='location',
            name='name',
            field=models.CharField(default='', max_length=200),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='location',
            name='short_name',
            field=models.CharField(default='', max_length=50),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='meeting',
            name='short_name',
            field=models.CharField(default='', max_length=50),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='meeting',
            name='name',
            field=models.CharField(max_length=200),
        ),
        migrations.AlterField(
            model_name='parliamentarygroup',
            name='short_name',
            field=models.CharField(max_length=50),
        ),
        migrations.CreateModel(
            name='DepartmentMembership',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('oparl_id', models.CharField(blank=True, max_length=2000, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('deleted', models.BooleanField(default=False)),
                ('start', models.DateField()),
                ('end', models.DateField()),
                ('role', models.CharField(max_length=200)),
                ('department', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mainapp.Department')),
                ('person', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mainapp.Person')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.RenameField(
            model_name='paper',
            old_name='submitter_committee',
            new_name='submitter_committees',
        ),
        migrations.AlterField(
            model_name='paper',
            name='submitter_committees',
            field=models.ManyToManyField(blank=True, to='mainapp.Committee'),
        ),
        migrations.RenameField(
            model_name='paper',
            old_name='submitter_department',
            new_name='submitter_departments',
        ),
        migrations.AlterField(
            model_name='paper',
            name='submitter_departments',
            field=models.ManyToManyField(blank=True, to='mainapp.Department'),
        ),
        migrations.AlterModelOptions(
            name='agendaitem',
            options={'ordering': ['meeting', 'position']},
        ),
        migrations.RenameField(
            model_name='paper',
            old_name='is_change_request_of',
            new_name='change_request_of',
        ),
        migrations.RenameField(
            model_name='legislativeterm',
            old_name='end_date',
            new_name='end',
        ),
        migrations.RenameField(
            model_name='legislativeterm',
            old_name='start_date',
            new_name='start',
        ),
        migrations.AddField(
            model_name='committee',
            name='end',
            field=models.DateField(default=django.utils.timezone.now),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='committee',
            name='start',
            field=models.DateField(default=django.utils.timezone.now),
            preserve_default=False,
        ),
        migrations.RenameField(
            model_name='meeting',
            old_name='locations',
            new_name='location',
        ),
        migrations.CreateModel(
            name='UserProfile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('phone', models.PositiveIntegerField(blank=True, null=True)),
                ('completion_level', models.PositiveSmallIntegerField(default=0, verbose_name='Profile completion percentage')),
                ('email_is_verified', models.BooleanField(default=False, verbose_name='Email is verified')),
                ('personal_info_is_completed', models.BooleanField(default=False, verbose_name='Personal info completed')),
                ('user', models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='profile', to=settings.AUTH_USER_MODEL, verbose_name='User')),
            ],
            options={
                'verbose_name_plural': 'User profiles',
                'verbose_name': 'User profile',
            },
        ),
        migrations.AddField(
            model_name='meetingseries',
            name='short_name',
            field=models.CharField(blank=True, max_length=200, null=True),
        ),
        migrations.AddField(
            model_name='file',
            name='mime_type',
            field=models.CharField(default='FIXME', max_length=255),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='file',
            name='name',
            field=models.CharField(default='FIXME', max_length=200),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='file',
            name='displayed_filename',
            field=models.CharField(max_length=200),
        ),
        migrations.AlterField(
            model_name='file',
            name='storage_filename',
            field=models.CharField(max_length=200),
        ),
        migrations.AlterField(
            model_name='committee',
            name='end',
            field=models.DateField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name='parliamentarygroup',
            name='end',
            field=models.DateField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name='committee',
            name='start',
            field=models.DateField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name='parliamentarygroup',
            name='start',
            field=models.DateField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name='meeting',
            name='end',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name='file',
            name='legal_date',
            field=models.DateField(blank=True, null=True),
        ),
        migrations.RemoveField(
            model_name='meeting',
            name='meeting_series',
        ),
        migrations.AlterField(
            model_name='body',
            name='oparl_id',
            field=models.CharField(blank=True, max_length=255, null=True, unique=True),
        ),
        migrations.AlterField(
            model_name='committee',
            name='oparl_id',
            field=models.CharField(blank=True, max_length=255, null=True, unique=True),
        ),
        migrations.AlterField(
            model_name='committeemembership',
            name='oparl_id',
            field=models.CharField(blank=True, max_length=255, null=True, unique=True),
        ),
        migrations.AlterField(
            model_name='department',
            name='oparl_id',
            field=models.CharField(blank=True, max_length=255, null=True, unique=True),
        ),
        migrations.AlterField(
            model_name='departmentmembership',
            name='oparl_id',
            field=models.CharField(blank=True, max_length=255, null=True, unique=True),
        ),
        migrations.AlterField(
            model_name='file',
            name='oparl_id',
            field=models.CharField(blank=True, max_length=255, null=True, unique=True),
        ),
        migrations.AlterField(
            model_name='legislativeterm',
            name='oparl_id',
            field=models.CharField(blank=True, max_length=255, null=True, unique=True),
        ),
        migrations.AlterField(
            model_name='location',
            name='oparl_id',
            field=models.CharField(blank=True, max_length=255, null=True, unique=True),
        ),
        migrations.AlterField(
            model_name='meeting',
            name='oparl_id',
            field=models.CharField(blank=True, max_length=255, null=True, unique=True),
        ),
        migrations.AlterField(
            model_name='paper',
            name='oparl_id',
            field=models.CharField(blank=True, max_length=255, null=True, unique=True),
        ),
        migrations.RemoveField(
            model_name='parliamentarygroup',
            name='body',
        ),
        migrations.AlterField(
            model_name='parliamentarygroup',
            name='oparl_id',
            field=models.CharField(blank=True, max_length=255, null=True, unique=True),
        ),
        migrations.AlterField(
            model_name='parliamentarygroupmembership',
            name='oparl_id',
            field=models.CharField(blank=True, max_length=255, null=True, unique=True),
        ),
        migrations.AlterField(
            model_name='person',
            name='oparl_id',
            field=models.CharField(blank=True, max_length=255, null=True, unique=True),
        ),
        migrations.AlterField(
            model_name='searchpoi',
            name='oparl_id',
            field=models.CharField(blank=True, max_length=255, null=True, unique=True),
        ),
        migrations.AlterField(
            model_name='searchstreet',
            name='oparl_id',
            field=models.CharField(blank=True, max_length=255, null=True, unique=True),
        ),
        migrations.DeleteModel(
            name='MeetingSeries',
        ),
        migrations.AlterField(
            model_name='departmentmembership',
            name='end',
            field=models.DateField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name='departmentmembership',
            name='start',
            field=models.DateField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name='parliamentarygroupmembership',
            name='end',
            field=models.DateField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name='committeemembership',
            name='end',
            field=models.DateField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='paper',
            name='legal_date',
            field=models.DateField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='paper',
            name='main_file',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='paper_main_file', to='mainapp.File'),
        ),
        migrations.AlterField(
            model_name='paper',
            name='name',
            field=models.CharField(max_length=300),
        ),
        migrations.RemoveField(
            model_name='file',
            name='paper',
        ),
        migrations.AddField(
            model_name='agendaitem',
            name='oparl_id',
            field=models.CharField(blank=True, max_length=255, null=True, unique=True),
        ),
        migrations.AddField(
            model_name='paper',
            name='files',
            field=models.ManyToManyField(blank=True, to='mainapp.File'),
        ),
        migrations.AlterField(
            model_name='committeemembership',
            name='start',
            field=models.DateField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name='parliamentarygroupmembership',
            name='start',
            field=models.DateField(blank=True, null=True),
        ),
        migrations.CreateModel(
            name='UserAlert',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('last_match', models.DateTimeField(null=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('search_string', models.TextField(default='')),
            ],
        ),
        migrations.RemoveField(
            model_name='userprofile',
            name='completion_level',
        ),
        migrations.RemoveField(
            model_name='userprofile',
            name='personal_info_is_completed',
        ),
        migrations.RemoveField(
            model_name='userprofile',
            name='phone',
        ),
        migrations.AlterField(
            model_name='agendaitem',
            name='title',
            field=models.CharField(max_length=2000),
        ),
        migrations.AlterField(
            model_name='agendaitem',
            name='title',
            field=models.TextField(),
        ),
        migrations.CreateModel(
            name='PaperType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('paper_type', models.CharField(max_length=200, unique=True)),
            ],
        ),
        migrations.AddField(
            model_name='paper',
            name='paper_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='mainapp.PaperType'),
        ),
        migrations.AlterField(
            model_name='paper',
            name='reference_number',
            field=models.CharField(blank=True, max_length=50, null=True),
        ),
        migrations.AddField(
            model_name='agendaitem',
            name='deleted',
            field=models.BooleanField(default=False),
        ),
        migrations.AlterUniqueTogether(
            name='agendaitem',
            unique_together=set([]),
        ),
        migrations.AlterField(
            model_name='paper',
            name='reference_number',
            field=models.CharField(default='[Deleted]', max_length=50),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='agendaitem',
            name='created',
            field=models.DateTimeField(auto_now_add=True, default=django.utils.timezone.now),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='agendaitem',
            name='modified',
            field=models.DateTimeField(auto_now=True),
        ),
        migrations.CreateModel(
            name='Consultation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('oparl_id', models.CharField(blank=True, max_length=255, null=True, unique=True)),
                ('title', models.TextField(blank=True, null=True)),
                ('authoritative', models.NullBooleanField()),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('deleted', models.BooleanField(default=False)),
                ('meeting', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='mainapp.Meeting')),
                ('paper', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='mainapp.Paper')),
                ('role', models.CharField(blank=True, max_length=200, null=True)),
            ],
        ),
        migrations.RemoveField(
            model_name='agendaitem',
            name='paper',
        ),
        migrations.AddField(
            model_name='agendaitem',
            name='auxiliary_file',
            field=models.ManyToManyField(blank=True, related_name='auxiliary_file', to='mainapp.File'),
        ),
        migrations.AddField(
            model_name='agendaitem',
            name='end',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='agendaitem',
            name='resolution_file',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='resolution_file', to='mainapp.File'),
        ),
        migrations.AddField(
            model_name='agendaitem',
            name='resolution_text',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='agendaitem',
            name='result',
            field=models.CharField(blank=True, max_length=200, null=True),
        ),
        migrations.AddField(
            model_name='agendaitem',
            name='start',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='agendaitem',
            name='consultation',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='mainapp.Consultation'),
        ),
        migrations.RemoveField(
            model_name='userprofile',
            name='email_is_verified',
        ),
        migrations.CreateModel(
            name='Organization',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('oparl_id', models.CharField(blank=True, max_length=255, null=True, unique=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('deleted', models.BooleanField(default=False)),
                ('name', models.CharField(max_length=200)),
                ('short_name', models.CharField(max_length=50)),
                ('start', models.DateField(blank=True, null=True)),
                ('end', models.DateField(blank=True, null=True)),
                ('color', models.CharField(blank=True, max_length=6, null=True)),
                ('logo', models.CharField(blank=True, max_length=255, null=True)),
                ('body', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mainapp.Body')),
                ('legislative_terms', models.ManyToManyField(blank=True, to='mainapp.LegislativeTerm')),
                ('location', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='mainapp.Location')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='OrganizationMembership',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('oparl_id', models.CharField(blank=True, max_length=255, null=True, unique=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('deleted', models.BooleanField(default=False)),
                ('start', models.DateField(blank=True, null=True)),
                ('end', models.DateField(blank=True, null=True)),
                ('role', models.CharField(blank=True, max_length=200, null=True)),
                ('organization', models.ForeignKey(default=1, on_delete=django.db.models.deletion.CASCADE, to='mainapp.Organization')),
                ('person', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mainapp.Person')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.RemoveField(
            model_name='committee',
            name='body',
        ),
        migrations.RemoveField(
            model_name='committee',
            name='legislative_terms',
        ),
        migrations.RemoveField(
            model_name='committee',
            name='location',
        ),
        migrations.RemoveField(
            model_name='committeemembership',
            name='committee',
        ),
        migrations.RemoveField(
            model_name='committeemembership',
            name='person',
        ),
        migrations.RemoveField(
            model_name='department',
            name='body',
        ),
        migrations.RemoveField(
            model_name='department',
            name='location',
        ),
        migrations.RemoveField(
            model_name='departmentmembership',
            name='department',
        ),
        migrations.RemoveField(
            model_name='departmentmembership',
            name='person',
        ),
        migrations.RemoveField(
            model_name='parliamentarygroup',
            name='legislative_terms',
        ),
        migrations.RemoveField(
            model_name='parliamentarygroup',
            name='location',
        ),
        migrations.RemoveField(
            model_name='parliamentarygroupmembership',
            name='parliamentary_group',
        ),
        migrations.RemoveField(
            model_name='parliamentarygroupmembership',
            name='person',
        ),
        migrations.RenameField(
            model_name='paper',
            old_name='submitter_persons',
            new_name='persons',
        ),
        migrations.RemoveField(
            model_name='meeting',
            name='committees',
        ),
        migrations.RemoveField(
            model_name='paper',
            name='submitter_committees',
        ),
        migrations.RemoveField(
            model_name='paper',
            name='submitter_departments',
        ),
        migrations.RemoveField(
            model_name='paper',
            name='submitter_parliamentary_groups',
        ),
        migrations.DeleteModel(
            name='Committee',
        ),
        migrations.DeleteModel(
            name='CommitteeMembership',
        ),
        migrations.DeleteModel(
            name='Department',
        ),
        migrations.DeleteModel(
            name='DepartmentMembership',
        ),
        migrations.DeleteModel(
            name='ParliamentaryGroup',
        ),
        migrations.DeleteModel(
            name='ParliamentaryGroupMembership',
        ),
        migrations.AddField(
            model_name='meeting',
            name='organizations',
            field=models.ManyToManyField(blank=True, to='mainapp.Organization'),
        ),
        migrations.AddField(
            model_name='paper',
            name='organizations',
            field=models.ManyToManyField(blank=True, to='mainapp.Organization'),
        ),
        migrations.CreateModel(
            name='OrganizationType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200, null=True)),
            ],
        ),
        migrations.AddField(
            model_name='organization',
            name='organization_type',
            field=models.ForeignKey(default=1, on_delete=django.db.models.deletion.CASCADE, to='mainapp.OrganizationType'),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='consultation',
            name='organizations',
            field=models.ManyToManyField(blank=True, to='mainapp.Organization'),
        ),
        migrations.AddField(
            model_name='file',
            name='page_count',
            field=models.IntegerField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name='agendaitem',
            name='key',
            field=models.CharField(blank=True, max_length=20, null=True),
        ),
        migrations.AlterField(
            model_name='body',
            name='name',
            field=models.TextField(),
        ),
        migrations.AlterField(
            model_name='legislativeterm',
            name='name',
            field=models.TextField(),
        ),
        migrations.AlterField(
            model_name='legislativeterm',
            name='short_name',
            field=models.CharField(max_length=50),
        ),
        migrations.AlterField(
            model_name='location',
            name='name',
            field=models.TextField(),
        ),
        migrations.AlterField(
            model_name='meeting',
            name='name',
            field=models.TextField(),
        ),
        migrations.AlterField(
            model_name='organization',
            name='name',
            field=models.TextField(),
        ),
        migrations.AlterField(
            model_name='paper',
            name='name',
            field=models.TextField(),
        ),
        migrations.AddField(
            model_name='file',
            name='mentioned_persons',
            field=models.ManyToManyField(blank=True, to='mainapp.Person'),
        ),
    ]
