"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/Lambdas/CheckStateMachineStatus/CheckStateMachineStatus.lambda.ts
var CheckStateMachineStatus_lambda_exports = {};
__export(CheckStateMachineStatus_lambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(CheckStateMachineStatus_lambda_exports);

// src/Lambdas/CheckStateMachineStatus/HelperFunctions/CheckStateMachineExecutions.ts
var import_client_sfn = require("@aws-sdk/client-sfn");
var sfnClient = new import_client_sfn.SFNClient({ region: "us-east-2" });
var listExecutions = async (stateMachineArn) => {
  const command = new import_client_sfn.ListExecutionsCommand({ stateMachineArn });
  try {
    const response = await sfnClient.send(command);
    return response.executions;
  } catch (err) {
    return [];
  }
};
async function getExecutionHistory(executionArn) {
  const params = {
    executionArn,
    reverseOrder: true
  };
  const command = new import_client_sfn.GetExecutionHistoryCommand(params);
  const history = await sfnClient.send(command);
  for (const event of history.events) {
    if (event.type === import_client_sfn.HistoryEventType.ExecutionSucceeded) {
      let outputJson = JSON.parse(event.executionSucceededEventDetails.output || "{}");
      if (outputJson.ImageBuildInformation.Image.OutputResources.Amis.length > 0) {
        let amiId = outputJson.ImageBuildInformation.Image.OutputResources.Amis[0].Image;
        return amiId;
      } else {
        return "";
      }
    }
  }
  return "";
}

// src/Lambdas/CheckStateMachineStatus/CheckStateMachineStatus.lambda.ts
var STATUS_SUCCEEDED = "SUCCEEDED";
var STATUS_FAILED = "FAILED";
var region = process.env.AWS_REGION;
var handler = async (event, context) => {
  const stateMachineArn = event.ResourceProperties.StateMachineArn;
  const imagePipelineArn = event.ResourceProperties.ImagePipelineArn;
  const executionName = event.RequestId;
  console.log("Context is invoked with:" + JSON.stringify(context));
  console.log("Lambda is invoked with:" + JSON.stringify(event));
  console.log("Resource properties: " + JSON.stringify(event.ResourceProperties));
  console.log("State Machine ARN: " + stateMachineArn);
  console.log("Image Pipeline ARN: " + imagePipelineArn);
  console.log("REGION: " + region);
  let response = {
    IsComplete: true,
    Data: {
      AmiId: ""
    }
  };
  try {
    const executions = await listExecutions(stateMachineArn);
    const filteredExecutions = executions.filter((execution) => execution.name.includes(executionName));
    const executionArnArray = filteredExecutions.map((execution) => execution.executionArn);
    const executionArn = executionArnArray.length > 0 ? executionArnArray[0] : "";
    const debugImagePipeline = event.ResourceProperties.DebugImagePipeline;
    console.log("Execution ARN: " + executionArn);
    if (!filteredExecutions.length || debugImagePipeline === "true") {
      return response;
    }
    const executionStatus = filteredExecutions.map((execution) => execution.status);
    if (executionStatus.includes(STATUS_SUCCEEDED)) {
      const amiId = await getExecutionHistory(executionArn);
      response.Data = {
        AmiId: amiId
      };
    } else if (executionStatus.includes(STATUS_FAILED)) {
      throw new Error("Execution failed");
    } else {
      console.log("No succeeded or failed executions found yet.");
      response = {
        IsComplete: false
      };
    }
  } catch (error) {
    console.log("Error: " + error);
    throw error;
  }
  return response;
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
