"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/Lambdas/ImageBuilderUpdateSsm/ImageBuilderUpdateSsm.lambda.ts
var ImageBuilderUpdateSsm_lambda_exports = {};
__export(ImageBuilderUpdateSsm_lambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(ImageBuilderUpdateSsm_lambda_exports);
var import_client_ssm = require("@aws-sdk/client-ssm");
var region = process.env.AWS_REGION;
var ssmClient = new import_client_ssm.SSMClient({ region });
var ssmParameterName = process.env.SSM_PATH || "";
var handler = async (event, context) => {
  console.info("Printing event:", event);
  console.info("Printing context:", context);
  await processSnsEvent(event);
  return;
};
async function processSnsEvent(event) {
  for (const record of event.Records) {
    const eventMessage = record.Sns.Message;
    const messageJson = JSON.parse(eventMessage);
    const imageState = messageJson.state.status;
    if (imageState === "AVAILABLE") {
      console.info("Image is available");
      const recipeName = messageJson.name;
      for (const ami of messageJson.outputResources.amis) {
        console.info("AMI ID:", ami.image);
        const putParameterCommand = new import_client_ssm.PutParameterCommand({
          Name: ssmParameterName,
          Description: "Latest AMI ID",
          Value: ami.image,
          Type: "String",
          Overwrite: true,
          Tier: "Standard"
        });
        const response = await ssmClient.send(putParameterCommand);
        console.info("SSM Updated:", response);
        const addTagsToResourceCommand = new import_client_ssm.AddTagsToResourceCommand({
          ResourceType: "Parameter",
          ResourceId: ssmParameterName,
          Tags: [
            {
              Key: "Source",
              Value: "EC2 Image Builder"
            },
            {
              Key: "AMI_REGION",
              Value: ami.region
            },
            {
              Key: "AMI_ID",
              Value: ami.image
            },
            {
              Key: "AMI_NAME",
              Value: ami.name
            },
            {
              Key: "RECIPE_NAME",
              Value: recipeName
            },
            {
              Key: "SOURCE_PIPELINE_ARN",
              Value: messageJson.sourcePipelineArn
            }
          ]
        });
        await ssmClient.send(addTagsToResourceCommand);
      }
    }
  }
  return;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
