import { parseXmlBody as parseBody, parseXmlErrorBody as parseErrorBody } from "@aws-sdk/core";
import { HttpRequest as __HttpRequest } from "@smithy/protocol-http";
import { collectBody, expectNonNull as __expectNonNull, expectString as __expectString, extendedEncodeURIComponent as __extendedEncodeURIComponent, getArrayIfSingleItem as __getArrayIfSingleItem, parseBoolean as __parseBoolean, parseRfc3339DateTimeWithOffset as __parseRfc3339DateTimeWithOffset, serializeDateTime as __serializeDateTime, serializeFloat as __serializeFloat, strictParseFloat as __strictParseFloat, strictParseInt32 as __strictParseInt32, strictParseLong as __strictParseLong, withBaseException, } from "@smithy/smithy-client";
import { v4 as generateIdempotencyToken } from "uuid";
import { EC2ServiceException as __BaseException } from "../models/EC2ServiceException";
export const se_AcceptAddressTransferCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AcceptAddressTransferRequest(input, context),
        [_A]: _AAT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AcceptCapacityReservationBillingOwnershipCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AcceptCapacityReservationBillingOwnershipRequest(input, context),
        [_A]: _ACRBO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AcceptReservedInstancesExchangeQuoteCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AcceptReservedInstancesExchangeQuoteRequest(input, context),
        [_A]: _ARIEQ,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AcceptTransitGatewayMulticastDomainAssociationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AcceptTransitGatewayMulticastDomainAssociationsRequest(input, context),
        [_A]: _ATGMDA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AcceptTransitGatewayPeeringAttachmentCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AcceptTransitGatewayPeeringAttachmentRequest(input, context),
        [_A]: _ATGPA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AcceptTransitGatewayVpcAttachmentCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AcceptTransitGatewayVpcAttachmentRequest(input, context),
        [_A]: _ATGVA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AcceptVpcEndpointConnectionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AcceptVpcEndpointConnectionsRequest(input, context),
        [_A]: _AVEC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AcceptVpcPeeringConnectionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AcceptVpcPeeringConnectionRequest(input, context),
        [_A]: _AVPC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AdvertiseByoipCidrCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AdvertiseByoipCidrRequest(input, context),
        [_A]: _ABC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AllocateAddressCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AllocateAddressRequest(input, context),
        [_A]: _AA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AllocateHostsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AllocateHostsRequest(input, context),
        [_A]: _AH,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AllocateIpamPoolCidrCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AllocateIpamPoolCidrRequest(input, context),
        [_A]: _AIPC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ApplySecurityGroupsToClientVpnTargetNetworkCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ApplySecurityGroupsToClientVpnTargetNetworkRequest(input, context),
        [_A]: _ASGTCVTN,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AssignIpv6AddressesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AssignIpv6AddressesRequest(input, context),
        [_A]: _AIA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AssignPrivateIpAddressesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AssignPrivateIpAddressesRequest(input, context),
        [_A]: _APIA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AssignPrivateNatGatewayAddressCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AssignPrivateNatGatewayAddressRequest(input, context),
        [_A]: _APNGA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AssociateAddressCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AssociateAddressRequest(input, context),
        [_A]: _AAs,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AssociateCapacityReservationBillingOwnerCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AssociateCapacityReservationBillingOwnerRequest(input, context),
        [_A]: _ACRBOs,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AssociateClientVpnTargetNetworkCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AssociateClientVpnTargetNetworkRequest(input, context),
        [_A]: _ACVTN,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AssociateDhcpOptionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AssociateDhcpOptionsRequest(input, context),
        [_A]: _ADO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AssociateEnclaveCertificateIamRoleCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AssociateEnclaveCertificateIamRoleRequest(input, context),
        [_A]: _AECIR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AssociateIamInstanceProfileCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AssociateIamInstanceProfileRequest(input, context),
        [_A]: _AIIP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AssociateInstanceEventWindowCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AssociateInstanceEventWindowRequest(input, context),
        [_A]: _AIEW,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AssociateIpamByoasnCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AssociateIpamByoasnRequest(input, context),
        [_A]: _AIB,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AssociateIpamResourceDiscoveryCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AssociateIpamResourceDiscoveryRequest(input, context),
        [_A]: _AIRD,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AssociateNatGatewayAddressCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AssociateNatGatewayAddressRequest(input, context),
        [_A]: _ANGA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AssociateRouteServerCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AssociateRouteServerRequest(input, context),
        [_A]: _ARS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AssociateRouteTableCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AssociateRouteTableRequest(input, context),
        [_A]: _ART,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AssociateSecurityGroupVpcCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AssociateSecurityGroupVpcRequest(input, context),
        [_A]: _ASGV,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AssociateSubnetCidrBlockCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AssociateSubnetCidrBlockRequest(input, context),
        [_A]: _ASCB,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AssociateTransitGatewayMulticastDomainCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AssociateTransitGatewayMulticastDomainRequest(input, context),
        [_A]: _ATGMD,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AssociateTransitGatewayPolicyTableCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AssociateTransitGatewayPolicyTableRequest(input, context),
        [_A]: _ATGPT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AssociateTransitGatewayRouteTableCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AssociateTransitGatewayRouteTableRequest(input, context),
        [_A]: _ATGRT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AssociateTrunkInterfaceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AssociateTrunkInterfaceRequest(input, context),
        [_A]: _ATI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AssociateVpcCidrBlockCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AssociateVpcCidrBlockRequest(input, context),
        [_A]: _AVCB,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AttachClassicLinkVpcCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AttachClassicLinkVpcRequest(input, context),
        [_A]: _ACLV,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AttachInternetGatewayCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AttachInternetGatewayRequest(input, context),
        [_A]: _AIG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AttachNetworkInterfaceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AttachNetworkInterfaceRequest(input, context),
        [_A]: _ANI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AttachVerifiedAccessTrustProviderCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AttachVerifiedAccessTrustProviderRequest(input, context),
        [_A]: _AVATP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AttachVolumeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AttachVolumeRequest(input, context),
        [_A]: _AV,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AttachVpnGatewayCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AttachVpnGatewayRequest(input, context),
        [_A]: _AVG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AuthorizeClientVpnIngressCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AuthorizeClientVpnIngressRequest(input, context),
        [_A]: _ACVI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AuthorizeSecurityGroupEgressCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AuthorizeSecurityGroupEgressRequest(input, context),
        [_A]: _ASGE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AuthorizeSecurityGroupIngressCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AuthorizeSecurityGroupIngressRequest(input, context),
        [_A]: _ASGI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_BundleInstanceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_BundleInstanceRequest(input, context),
        [_A]: _BI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CancelBundleTaskCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CancelBundleTaskRequest(input, context),
        [_A]: _CBT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CancelCapacityReservationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CancelCapacityReservationRequest(input, context),
        [_A]: _CCR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CancelCapacityReservationFleetsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CancelCapacityReservationFleetsRequest(input, context),
        [_A]: _CCRF,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CancelConversionTaskCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CancelConversionRequest(input, context),
        [_A]: _CCT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CancelDeclarativePoliciesReportCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CancelDeclarativePoliciesReportRequest(input, context),
        [_A]: _CDPR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CancelExportTaskCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CancelExportTaskRequest(input, context),
        [_A]: _CET,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CancelImageLaunchPermissionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CancelImageLaunchPermissionRequest(input, context),
        [_A]: _CILP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CancelImportTaskCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CancelImportTaskRequest(input, context),
        [_A]: _CIT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CancelReservedInstancesListingCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CancelReservedInstancesListingRequest(input, context),
        [_A]: _CRIL,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CancelSpotFleetRequestsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CancelSpotFleetRequestsRequest(input, context),
        [_A]: _CSFR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CancelSpotInstanceRequestsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CancelSpotInstanceRequestsRequest(input, context),
        [_A]: _CSIR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ConfirmProductInstanceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ConfirmProductInstanceRequest(input, context),
        [_A]: _CPI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CopyFpgaImageCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CopyFpgaImageRequest(input, context),
        [_A]: _CFI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CopyImageCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CopyImageRequest(input, context),
        [_A]: _CI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CopySnapshotCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CopySnapshotRequest(input, context),
        [_A]: _CS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateCapacityReservationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateCapacityReservationRequest(input, context),
        [_A]: _CCRr,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateCapacityReservationBySplittingCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateCapacityReservationBySplittingRequest(input, context),
        [_A]: _CCRBS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateCapacityReservationFleetCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateCapacityReservationFleetRequest(input, context),
        [_A]: _CCRFr,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateCarrierGatewayCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateCarrierGatewayRequest(input, context),
        [_A]: _CCG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateClientVpnEndpointCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateClientVpnEndpointRequest(input, context),
        [_A]: _CCVE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateClientVpnRouteCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateClientVpnRouteRequest(input, context),
        [_A]: _CCVR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateCoipCidrCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateCoipCidrRequest(input, context),
        [_A]: _CCC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateCoipPoolCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateCoipPoolRequest(input, context),
        [_A]: _CCP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateCustomerGatewayCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateCustomerGatewayRequest(input, context),
        [_A]: _CCGr,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateDefaultSubnetCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateDefaultSubnetRequest(input, context),
        [_A]: _CDS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateDefaultVpcCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateDefaultVpcRequest(input, context),
        [_A]: _CDV,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateDelegateMacVolumeOwnershipTaskCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateDelegateMacVolumeOwnershipTaskRequest(input, context),
        [_A]: _CDMVOT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateDhcpOptionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateDhcpOptionsRequest(input, context),
        [_A]: _CDO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateEgressOnlyInternetGatewayCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateEgressOnlyInternetGatewayRequest(input, context),
        [_A]: _CEOIG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateFleetCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateFleetRequest(input, context),
        [_A]: _CF,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateFlowLogsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateFlowLogsRequest(input, context),
        [_A]: _CFL,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateFpgaImageCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateFpgaImageRequest(input, context),
        [_A]: _CFIr,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateImageCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateImageRequest(input, context),
        [_A]: _CIr,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateImageUsageReportCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateImageUsageReportRequest(input, context),
        [_A]: _CIUR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateInstanceConnectEndpointCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateInstanceConnectEndpointRequest(input, context),
        [_A]: _CICE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateInstanceEventWindowCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateInstanceEventWindowRequest(input, context),
        [_A]: _CIEW,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateInstanceExportTaskCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateInstanceExportTaskRequest(input, context),
        [_A]: _CIET,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateInternetGatewayCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateInternetGatewayRequest(input, context),
        [_A]: _CIG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateIpamCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateIpamRequest(input, context),
        [_A]: _CIre,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateIpamExternalResourceVerificationTokenCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateIpamExternalResourceVerificationTokenRequest(input, context),
        [_A]: _CIERVT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateIpamPoolCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateIpamPoolRequest(input, context),
        [_A]: _CIP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateIpamResourceDiscoveryCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateIpamResourceDiscoveryRequest(input, context),
        [_A]: _CIRD,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateIpamScopeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateIpamScopeRequest(input, context),
        [_A]: _CIS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateKeyPairCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateKeyPairRequest(input, context),
        [_A]: _CKP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateLaunchTemplateCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateLaunchTemplateRequest(input, context),
        [_A]: _CLT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateLaunchTemplateVersionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateLaunchTemplateVersionRequest(input, context),
        [_A]: _CLTV,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateLocalGatewayRouteCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateLocalGatewayRouteRequest(input, context),
        [_A]: _CLGR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateLocalGatewayRouteTableCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateLocalGatewayRouteTableRequest(input, context),
        [_A]: _CLGRT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest(input, context),
        [_A]: _CLGRTVIGA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateLocalGatewayRouteTableVpcAssociationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateLocalGatewayRouteTableVpcAssociationRequest(input, context),
        [_A]: _CLGRTVA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateLocalGatewayVirtualInterfaceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateLocalGatewayVirtualInterfaceRequest(input, context),
        [_A]: _CLGVI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateLocalGatewayVirtualInterfaceGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateLocalGatewayVirtualInterfaceGroupRequest(input, context),
        [_A]: _CLGVIG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateMacSystemIntegrityProtectionModificationTaskCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateMacSystemIntegrityProtectionModificationTaskRequest(input, context),
        [_A]: _CMSIPMT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateManagedPrefixListCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateManagedPrefixListRequest(input, context),
        [_A]: _CMPL,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateNatGatewayCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateNatGatewayRequest(input, context),
        [_A]: _CNG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateNetworkAclCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateNetworkAclRequest(input, context),
        [_A]: _CNA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateNetworkAclEntryCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateNetworkAclEntryRequest(input, context),
        [_A]: _CNAE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateNetworkInsightsAccessScopeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateNetworkInsightsAccessScopeRequest(input, context),
        [_A]: _CNIAS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateNetworkInsightsPathCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateNetworkInsightsPathRequest(input, context),
        [_A]: _CNIP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateNetworkInterfaceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateNetworkInterfaceRequest(input, context),
        [_A]: _CNI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateNetworkInterfacePermissionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateNetworkInterfacePermissionRequest(input, context),
        [_A]: _CNIPr,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreatePlacementGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreatePlacementGroupRequest(input, context),
        [_A]: _CPG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreatePublicIpv4PoolCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreatePublicIpv4PoolRequest(input, context),
        [_A]: _CPIP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateReplaceRootVolumeTaskCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateReplaceRootVolumeTaskRequest(input, context),
        [_A]: _CRRVT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateReservedInstancesListingCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateReservedInstancesListingRequest(input, context),
        [_A]: _CRILr,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateRestoreImageTaskCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateRestoreImageTaskRequest(input, context),
        [_A]: _CRIT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateRouteCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateRouteRequest(input, context),
        [_A]: _CR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateRouteServerCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateRouteServerRequest(input, context),
        [_A]: _CRS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateRouteServerEndpointCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateRouteServerEndpointRequest(input, context),
        [_A]: _CRSE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateRouteServerPeerCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateRouteServerPeerRequest(input, context),
        [_A]: _CRSP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateRouteTableCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateRouteTableRequest(input, context),
        [_A]: _CRT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateSecurityGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateSecurityGroupRequest(input, context),
        [_A]: _CSG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateSnapshotCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateSnapshotRequest(input, context),
        [_A]: _CSr,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateSnapshotsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateSnapshotsRequest(input, context),
        [_A]: _CSre,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateSpotDatafeedSubscriptionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateSpotDatafeedSubscriptionRequest(input, context),
        [_A]: _CSDS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateStoreImageTaskCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateStoreImageTaskRequest(input, context),
        [_A]: _CSIT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateSubnetCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateSubnetRequest(input, context),
        [_A]: _CSrea,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateSubnetCidrReservationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateSubnetCidrReservationRequest(input, context),
        [_A]: _CSCR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateTagsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateTagsRequest(input, context),
        [_A]: _CT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateTrafficMirrorFilterCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateTrafficMirrorFilterRequest(input, context),
        [_A]: _CTMF,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateTrafficMirrorFilterRuleCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateTrafficMirrorFilterRuleRequest(input, context),
        [_A]: _CTMFR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateTrafficMirrorSessionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateTrafficMirrorSessionRequest(input, context),
        [_A]: _CTMS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateTrafficMirrorTargetCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateTrafficMirrorTargetRequest(input, context),
        [_A]: _CTMT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateTransitGatewayCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateTransitGatewayRequest(input, context),
        [_A]: _CTG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateTransitGatewayConnectCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateTransitGatewayConnectRequest(input, context),
        [_A]: _CTGC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateTransitGatewayConnectPeerCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateTransitGatewayConnectPeerRequest(input, context),
        [_A]: _CTGCP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateTransitGatewayMulticastDomainCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateTransitGatewayMulticastDomainRequest(input, context),
        [_A]: _CTGMD,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateTransitGatewayPeeringAttachmentCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateTransitGatewayPeeringAttachmentRequest(input, context),
        [_A]: _CTGPA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateTransitGatewayPolicyTableCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateTransitGatewayPolicyTableRequest(input, context),
        [_A]: _CTGPT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateTransitGatewayPrefixListReferenceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateTransitGatewayPrefixListReferenceRequest(input, context),
        [_A]: _CTGPLR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateTransitGatewayRouteCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateTransitGatewayRouteRequest(input, context),
        [_A]: _CTGR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateTransitGatewayRouteTableCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateTransitGatewayRouteTableRequest(input, context),
        [_A]: _CTGRT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateTransitGatewayRouteTableAnnouncementCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateTransitGatewayRouteTableAnnouncementRequest(input, context),
        [_A]: _CTGRTA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateTransitGatewayVpcAttachmentCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateTransitGatewayVpcAttachmentRequest(input, context),
        [_A]: _CTGVA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateVerifiedAccessEndpointCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateVerifiedAccessEndpointRequest(input, context),
        [_A]: _CVAE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateVerifiedAccessGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateVerifiedAccessGroupRequest(input, context),
        [_A]: _CVAG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateVerifiedAccessInstanceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateVerifiedAccessInstanceRequest(input, context),
        [_A]: _CVAI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateVerifiedAccessTrustProviderCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateVerifiedAccessTrustProviderRequest(input, context),
        [_A]: _CVATP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateVolumeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateVolumeRequest(input, context),
        [_A]: _CV,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateVpcCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateVpcRequest(input, context),
        [_A]: _CVr,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateVpcBlockPublicAccessExclusionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateVpcBlockPublicAccessExclusionRequest(input, context),
        [_A]: _CVBPAE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateVpcEndpointCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateVpcEndpointRequest(input, context),
        [_A]: _CVE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateVpcEndpointConnectionNotificationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateVpcEndpointConnectionNotificationRequest(input, context),
        [_A]: _CVECN,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateVpcEndpointServiceConfigurationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateVpcEndpointServiceConfigurationRequest(input, context),
        [_A]: _CVESC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateVpcPeeringConnectionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateVpcPeeringConnectionRequest(input, context),
        [_A]: _CVPC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateVpnConnectionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateVpnConnectionRequest(input, context),
        [_A]: _CVC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateVpnConnectionRouteCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateVpnConnectionRouteRequest(input, context),
        [_A]: _CVCR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateVpnGatewayCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateVpnGatewayRequest(input, context),
        [_A]: _CVG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteCarrierGatewayCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteCarrierGatewayRequest(input, context),
        [_A]: _DCG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteClientVpnEndpointCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteClientVpnEndpointRequest(input, context),
        [_A]: _DCVE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteClientVpnRouteCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteClientVpnRouteRequest(input, context),
        [_A]: _DCVR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteCoipCidrCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteCoipCidrRequest(input, context),
        [_A]: _DCC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteCoipPoolCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteCoipPoolRequest(input, context),
        [_A]: _DCP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteCustomerGatewayCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteCustomerGatewayRequest(input, context),
        [_A]: _DCGe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteDhcpOptionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteDhcpOptionsRequest(input, context),
        [_A]: _DDO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteEgressOnlyInternetGatewayCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteEgressOnlyInternetGatewayRequest(input, context),
        [_A]: _DEOIG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteFleetsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteFleetsRequest(input, context),
        [_A]: _DF,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteFlowLogsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteFlowLogsRequest(input, context),
        [_A]: _DFL,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteFpgaImageCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteFpgaImageRequest(input, context),
        [_A]: _DFI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteImageUsageReportCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteImageUsageReportRequest(input, context),
        [_A]: _DIUR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteInstanceConnectEndpointCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteInstanceConnectEndpointRequest(input, context),
        [_A]: _DICE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteInstanceEventWindowCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteInstanceEventWindowRequest(input, context),
        [_A]: _DIEW,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteInternetGatewayCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteInternetGatewayRequest(input, context),
        [_A]: _DIG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteIpamCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteIpamRequest(input, context),
        [_A]: _DI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteIpamExternalResourceVerificationTokenCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteIpamExternalResourceVerificationTokenRequest(input, context),
        [_A]: _DIERVT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteIpamPoolCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteIpamPoolRequest(input, context),
        [_A]: _DIP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteIpamResourceDiscoveryCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteIpamResourceDiscoveryRequest(input, context),
        [_A]: _DIRD,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteIpamScopeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteIpamScopeRequest(input, context),
        [_A]: _DIS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteKeyPairCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteKeyPairRequest(input, context),
        [_A]: _DKP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteLaunchTemplateCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteLaunchTemplateRequest(input, context),
        [_A]: _DLT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteLaunchTemplateVersionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteLaunchTemplateVersionsRequest(input, context),
        [_A]: _DLTV,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteLocalGatewayRouteCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteLocalGatewayRouteRequest(input, context),
        [_A]: _DLGR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteLocalGatewayRouteTableCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteLocalGatewayRouteTableRequest(input, context),
        [_A]: _DLGRT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest(input, context),
        [_A]: _DLGRTVIGA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteLocalGatewayRouteTableVpcAssociationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteLocalGatewayRouteTableVpcAssociationRequest(input, context),
        [_A]: _DLGRTVA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteLocalGatewayVirtualInterfaceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteLocalGatewayVirtualInterfaceRequest(input, context),
        [_A]: _DLGVI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteLocalGatewayVirtualInterfaceGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteLocalGatewayVirtualInterfaceGroupRequest(input, context),
        [_A]: _DLGVIG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteManagedPrefixListCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteManagedPrefixListRequest(input, context),
        [_A]: _DMPL,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteNatGatewayCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteNatGatewayRequest(input, context),
        [_A]: _DNG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteNetworkAclCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteNetworkAclRequest(input, context),
        [_A]: _DNA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteNetworkAclEntryCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteNetworkAclEntryRequest(input, context),
        [_A]: _DNAE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteNetworkInsightsAccessScopeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteNetworkInsightsAccessScopeRequest(input, context),
        [_A]: _DNIAS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteNetworkInsightsAccessScopeAnalysisCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteNetworkInsightsAccessScopeAnalysisRequest(input, context),
        [_A]: _DNIASA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteNetworkInsightsAnalysisCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteNetworkInsightsAnalysisRequest(input, context),
        [_A]: _DNIA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteNetworkInsightsPathCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteNetworkInsightsPathRequest(input, context),
        [_A]: _DNIP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteNetworkInterfaceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteNetworkInterfaceRequest(input, context),
        [_A]: _DNI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteNetworkInterfacePermissionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteNetworkInterfacePermissionRequest(input, context),
        [_A]: _DNIPe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeletePlacementGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeletePlacementGroupRequest(input, context),
        [_A]: _DPG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeletePublicIpv4PoolCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeletePublicIpv4PoolRequest(input, context),
        [_A]: _DPIP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteQueuedReservedInstancesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteQueuedReservedInstancesRequest(input, context),
        [_A]: _DQRI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteRouteCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteRouteRequest(input, context),
        [_A]: _DR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteRouteServerCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteRouteServerRequest(input, context),
        [_A]: _DRS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteRouteServerEndpointCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteRouteServerEndpointRequest(input, context),
        [_A]: _DRSE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteRouteServerPeerCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteRouteServerPeerRequest(input, context),
        [_A]: _DRSP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteRouteTableCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteRouteTableRequest(input, context),
        [_A]: _DRT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteSecurityGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteSecurityGroupRequest(input, context),
        [_A]: _DSG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteSnapshotCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteSnapshotRequest(input, context),
        [_A]: _DS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteSpotDatafeedSubscriptionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteSpotDatafeedSubscriptionRequest(input, context),
        [_A]: _DSDS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteSubnetCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteSubnetRequest(input, context),
        [_A]: _DSe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteSubnetCidrReservationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteSubnetCidrReservationRequest(input, context),
        [_A]: _DSCR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteTagsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteTagsRequest(input, context),
        [_A]: _DT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteTrafficMirrorFilterCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteTrafficMirrorFilterRequest(input, context),
        [_A]: _DTMF,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteTrafficMirrorFilterRuleCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteTrafficMirrorFilterRuleRequest(input, context),
        [_A]: _DTMFR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteTrafficMirrorSessionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteTrafficMirrorSessionRequest(input, context),
        [_A]: _DTMS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteTrafficMirrorTargetCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteTrafficMirrorTargetRequest(input, context),
        [_A]: _DTMT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteTransitGatewayCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteTransitGatewayRequest(input, context),
        [_A]: _DTG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteTransitGatewayConnectCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteTransitGatewayConnectRequest(input, context),
        [_A]: _DTGC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteTransitGatewayConnectPeerCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteTransitGatewayConnectPeerRequest(input, context),
        [_A]: _DTGCP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteTransitGatewayMulticastDomainCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteTransitGatewayMulticastDomainRequest(input, context),
        [_A]: _DTGMD,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteTransitGatewayPeeringAttachmentCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteTransitGatewayPeeringAttachmentRequest(input, context),
        [_A]: _DTGPA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteTransitGatewayPolicyTableCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteTransitGatewayPolicyTableRequest(input, context),
        [_A]: _DTGPT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteTransitGatewayPrefixListReferenceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteTransitGatewayPrefixListReferenceRequest(input, context),
        [_A]: _DTGPLR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteTransitGatewayRouteCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteTransitGatewayRouteRequest(input, context),
        [_A]: _DTGR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteTransitGatewayRouteTableCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteTransitGatewayRouteTableRequest(input, context),
        [_A]: _DTGRT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteTransitGatewayRouteTableAnnouncementCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteTransitGatewayRouteTableAnnouncementRequest(input, context),
        [_A]: _DTGRTA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteTransitGatewayVpcAttachmentCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteTransitGatewayVpcAttachmentRequest(input, context),
        [_A]: _DTGVA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteVerifiedAccessEndpointCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteVerifiedAccessEndpointRequest(input, context),
        [_A]: _DVAE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteVerifiedAccessGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteVerifiedAccessGroupRequest(input, context),
        [_A]: _DVAG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteVerifiedAccessInstanceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteVerifiedAccessInstanceRequest(input, context),
        [_A]: _DVAI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteVerifiedAccessTrustProviderCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteVerifiedAccessTrustProviderRequest(input, context),
        [_A]: _DVATP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteVolumeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteVolumeRequest(input, context),
        [_A]: _DV,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteVpcCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteVpcRequest(input, context),
        [_A]: _DVe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteVpcBlockPublicAccessExclusionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteVpcBlockPublicAccessExclusionRequest(input, context),
        [_A]: _DVBPAE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteVpcEndpointConnectionNotificationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteVpcEndpointConnectionNotificationsRequest(input, context),
        [_A]: _DVECN,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteVpcEndpointsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteVpcEndpointsRequest(input, context),
        [_A]: _DVE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteVpcEndpointServiceConfigurationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteVpcEndpointServiceConfigurationsRequest(input, context),
        [_A]: _DVESC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteVpcPeeringConnectionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteVpcPeeringConnectionRequest(input, context),
        [_A]: _DVPC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteVpnConnectionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteVpnConnectionRequest(input, context),
        [_A]: _DVC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteVpnConnectionRouteCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteVpnConnectionRouteRequest(input, context),
        [_A]: _DVCR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteVpnGatewayCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteVpnGatewayRequest(input, context),
        [_A]: _DVG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeprovisionByoipCidrCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeprovisionByoipCidrRequest(input, context),
        [_A]: _DBC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeprovisionIpamByoasnCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeprovisionIpamByoasnRequest(input, context),
        [_A]: _DIB,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeprovisionIpamPoolCidrCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeprovisionIpamPoolCidrRequest(input, context),
        [_A]: _DIPC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeprovisionPublicIpv4PoolCidrCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeprovisionPublicIpv4PoolCidrRequest(input, context),
        [_A]: _DPIPC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeregisterImageCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeregisterImageRequest(input, context),
        [_A]: _DIe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeregisterInstanceEventNotificationAttributesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeregisterInstanceEventNotificationAttributesRequest(input, context),
        [_A]: _DIENA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeregisterTransitGatewayMulticastGroupMembersCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeregisterTransitGatewayMulticastGroupMembersRequest(input, context),
        [_A]: _DTGMGM,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeregisterTransitGatewayMulticastGroupSourcesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeregisterTransitGatewayMulticastGroupSourcesRequest(input, context),
        [_A]: _DTGMGS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeAccountAttributesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeAccountAttributesRequest(input, context),
        [_A]: _DAA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeAddressesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeAddressesRequest(input, context),
        [_A]: _DA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeAddressesAttributeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeAddressesAttributeRequest(input, context),
        [_A]: _DAAe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeAddressTransfersCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeAddressTransfersRequest(input, context),
        [_A]: _DAT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeAggregateIdFormatCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeAggregateIdFormatRequest(input, context),
        [_A]: _DAIF,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeAvailabilityZonesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeAvailabilityZonesRequest(input, context),
        [_A]: _DAZ,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeAwsNetworkPerformanceMetricSubscriptionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeAwsNetworkPerformanceMetricSubscriptionsRequest(input, context),
        [_A]: _DANPMS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeBundleTasksCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeBundleTasksRequest(input, context),
        [_A]: _DBT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeByoipCidrsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeByoipCidrsRequest(input, context),
        [_A]: _DBCe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeCapacityBlockExtensionHistoryCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeCapacityBlockExtensionHistoryRequest(input, context),
        [_A]: _DCBEH,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeCapacityBlockExtensionOfferingsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeCapacityBlockExtensionOfferingsRequest(input, context),
        [_A]: _DCBEO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeCapacityBlockOfferingsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeCapacityBlockOfferingsRequest(input, context),
        [_A]: _DCBO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeCapacityBlocksCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeCapacityBlocksRequest(input, context),
        [_A]: _DCB,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeCapacityBlockStatusCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeCapacityBlockStatusRequest(input, context),
        [_A]: _DCBS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeCapacityReservationBillingRequestsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeCapacityReservationBillingRequestsRequest(input, context),
        [_A]: _DCRBR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeCapacityReservationFleetsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeCapacityReservationFleetsRequest(input, context),
        [_A]: _DCRF,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeCapacityReservationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeCapacityReservationsRequest(input, context),
        [_A]: _DCR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeCarrierGatewaysCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeCarrierGatewaysRequest(input, context),
        [_A]: _DCGes,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeClassicLinkInstancesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeClassicLinkInstancesRequest(input, context),
        [_A]: _DCLI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeClientVpnAuthorizationRulesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeClientVpnAuthorizationRulesRequest(input, context),
        [_A]: _DCVAR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeClientVpnConnectionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeClientVpnConnectionsRequest(input, context),
        [_A]: _DCVC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeClientVpnEndpointsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeClientVpnEndpointsRequest(input, context),
        [_A]: _DCVEe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeClientVpnRoutesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeClientVpnRoutesRequest(input, context),
        [_A]: _DCVRe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeClientVpnTargetNetworksCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeClientVpnTargetNetworksRequest(input, context),
        [_A]: _DCVTN,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeCoipPoolsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeCoipPoolsRequest(input, context),
        [_A]: _DCPe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeConversionTasksCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeConversionTasksRequest(input, context),
        [_A]: _DCT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeCustomerGatewaysCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeCustomerGatewaysRequest(input, context),
        [_A]: _DCGesc,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDeclarativePoliciesReportsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDeclarativePoliciesReportsRequest(input, context),
        [_A]: _DDPR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDhcpOptionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDhcpOptionsRequest(input, context),
        [_A]: _DDOe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeEgressOnlyInternetGatewaysCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeEgressOnlyInternetGatewaysRequest(input, context),
        [_A]: _DEOIGe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeElasticGpusCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeElasticGpusRequest(input, context),
        [_A]: _DEG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeExportImageTasksCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeExportImageTasksRequest(input, context),
        [_A]: _DEIT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeExportTasksCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeExportTasksRequest(input, context),
        [_A]: _DET,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeFastLaunchImagesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeFastLaunchImagesRequest(input, context),
        [_A]: _DFLI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeFastSnapshotRestoresCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeFastSnapshotRestoresRequest(input, context),
        [_A]: _DFSR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeFleetHistoryCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeFleetHistoryRequest(input, context),
        [_A]: _DFH,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeFleetInstancesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeFleetInstancesRequest(input, context),
        [_A]: _DFIe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeFleetsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeFleetsRequest(input, context),
        [_A]: _DFe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeFlowLogsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeFlowLogsRequest(input, context),
        [_A]: _DFLe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeFpgaImageAttributeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeFpgaImageAttributeRequest(input, context),
        [_A]: _DFIA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeFpgaImagesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeFpgaImagesRequest(input, context),
        [_A]: _DFIes,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeHostReservationOfferingsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeHostReservationOfferingsRequest(input, context),
        [_A]: _DHRO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeHostReservationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeHostReservationsRequest(input, context),
        [_A]: _DHR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeHostsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeHostsRequest(input, context),
        [_A]: _DH,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeIamInstanceProfileAssociationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeIamInstanceProfileAssociationsRequest(input, context),
        [_A]: _DIIPA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeIdentityIdFormatCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeIdentityIdFormatRequest(input, context),
        [_A]: _DIIF,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeIdFormatCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeIdFormatRequest(input, context),
        [_A]: _DIF,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeImageAttributeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeImageAttributeRequest(input, context),
        [_A]: _DIA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeImageReferencesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeImageReferencesRequest(input, context),
        [_A]: _DIR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeImagesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeImagesRequest(input, context),
        [_A]: _DIes,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeImageUsageReportEntriesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeImageUsageReportEntriesRequest(input, context),
        [_A]: _DIURE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeImageUsageReportsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeImageUsageReportsRequest(input, context),
        [_A]: _DIURe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeImportImageTasksCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeImportImageTasksRequest(input, context),
        [_A]: _DIIT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeImportSnapshotTasksCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeImportSnapshotTasksRequest(input, context),
        [_A]: _DIST,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeInstanceAttributeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeInstanceAttributeRequest(input, context),
        [_A]: _DIAe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeInstanceConnectEndpointsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeInstanceConnectEndpointsRequest(input, context),
        [_A]: _DICEe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeInstanceCreditSpecificationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeInstanceCreditSpecificationsRequest(input, context),
        [_A]: _DICS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeInstanceEventNotificationAttributesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeInstanceEventNotificationAttributesRequest(input, context),
        [_A]: _DIENAe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeInstanceEventWindowsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeInstanceEventWindowsRequest(input, context),
        [_A]: _DIEWe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeInstanceImageMetadataCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeInstanceImageMetadataRequest(input, context),
        [_A]: _DIIM,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeInstancesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeInstancesRequest(input, context),
        [_A]: _DIesc,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeInstanceStatusCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeInstanceStatusRequest(input, context),
        [_A]: _DISe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeInstanceTopologyCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeInstanceTopologyRequest(input, context),
        [_A]: _DIT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeInstanceTypeOfferingsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeInstanceTypeOfferingsRequest(input, context),
        [_A]: _DITO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeInstanceTypesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeInstanceTypesRequest(input, context),
        [_A]: _DITe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeInternetGatewaysCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeInternetGatewaysRequest(input, context),
        [_A]: _DIGe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeIpamByoasnCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeIpamByoasnRequest(input, context),
        [_A]: _DIBe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeIpamExternalResourceVerificationTokensCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeIpamExternalResourceVerificationTokensRequest(input, context),
        [_A]: _DIERVTe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeIpamPoolsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeIpamPoolsRequest(input, context),
        [_A]: _DIPe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeIpamResourceDiscoveriesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeIpamResourceDiscoveriesRequest(input, context),
        [_A]: _DIRDe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeIpamResourceDiscoveryAssociationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeIpamResourceDiscoveryAssociationsRequest(input, context),
        [_A]: _DIRDA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeIpamsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeIpamsRequest(input, context),
        [_A]: _DIescr,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeIpamScopesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeIpamScopesRequest(input, context),
        [_A]: _DISes,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeIpv6PoolsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeIpv6PoolsRequest(input, context),
        [_A]: _DIPes,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeKeyPairsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeKeyPairsRequest(input, context),
        [_A]: _DKPe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeLaunchTemplatesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeLaunchTemplatesRequest(input, context),
        [_A]: _DLTe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeLaunchTemplateVersionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeLaunchTemplateVersionsRequest(input, context),
        [_A]: _DLTVe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeLocalGatewayRouteTablesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeLocalGatewayRouteTablesRequest(input, context),
        [_A]: _DLGRTe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest(input, context),
        [_A]: _DLGRTVIGAe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeLocalGatewayRouteTableVpcAssociationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeLocalGatewayRouteTableVpcAssociationsRequest(input, context),
        [_A]: _DLGRTVAe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeLocalGatewaysCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeLocalGatewaysRequest(input, context),
        [_A]: _DLG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeLocalGatewayVirtualInterfaceGroupsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeLocalGatewayVirtualInterfaceGroupsRequest(input, context),
        [_A]: _DLGVIGe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeLocalGatewayVirtualInterfacesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeLocalGatewayVirtualInterfacesRequest(input, context),
        [_A]: _DLGVIe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeLockedSnapshotsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeLockedSnapshotsRequest(input, context),
        [_A]: _DLS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeMacHostsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeMacHostsRequest(input, context),
        [_A]: _DMH,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeMacModificationTasksCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeMacModificationTasksRequest(input, context),
        [_A]: _DMMT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeManagedPrefixListsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeManagedPrefixListsRequest(input, context),
        [_A]: _DMPLe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeMovingAddressesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeMovingAddressesRequest(input, context),
        [_A]: _DMA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeNatGatewaysCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeNatGatewaysRequest(input, context),
        [_A]: _DNGe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeNetworkAclsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeNetworkAclsRequest(input, context),
        [_A]: _DNAe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeNetworkInsightsAccessScopeAnalysesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeNetworkInsightsAccessScopeAnalysesRequest(input, context),
        [_A]: _DNIASAe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeNetworkInsightsAccessScopesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeNetworkInsightsAccessScopesRequest(input, context),
        [_A]: _DNIASe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeNetworkInsightsAnalysesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeNetworkInsightsAnalysesRequest(input, context),
        [_A]: _DNIAe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeNetworkInsightsPathsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeNetworkInsightsPathsRequest(input, context),
        [_A]: _DNIPes,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeNetworkInterfaceAttributeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeNetworkInterfaceAttributeRequest(input, context),
        [_A]: _DNIAes,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeNetworkInterfacePermissionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeNetworkInterfacePermissionsRequest(input, context),
        [_A]: _DNIPesc,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeNetworkInterfacesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeNetworkInterfacesRequest(input, context),
        [_A]: _DNIe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeOutpostLagsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeOutpostLagsRequest(input, context),
        [_A]: _DOL,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribePlacementGroupsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribePlacementGroupsRequest(input, context),
        [_A]: _DPGe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribePrefixListsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribePrefixListsRequest(input, context),
        [_A]: _DPL,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribePrincipalIdFormatCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribePrincipalIdFormatRequest(input, context),
        [_A]: _DPIF,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribePublicIpv4PoolsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribePublicIpv4PoolsRequest(input, context),
        [_A]: _DPIPe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeRegionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeRegionsRequest(input, context),
        [_A]: _DRe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeReplaceRootVolumeTasksCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeReplaceRootVolumeTasksRequest(input, context),
        [_A]: _DRRVT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeReservedInstancesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeReservedInstancesRequest(input, context),
        [_A]: _DRI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeReservedInstancesListingsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeReservedInstancesListingsRequest(input, context),
        [_A]: _DRIL,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeReservedInstancesModificationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeReservedInstancesModificationsRequest(input, context),
        [_A]: _DRIM,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeReservedInstancesOfferingsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeReservedInstancesOfferingsRequest(input, context),
        [_A]: _DRIO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeRouteServerEndpointsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeRouteServerEndpointsRequest(input, context),
        [_A]: _DRSEe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeRouteServerPeersCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeRouteServerPeersRequest(input, context),
        [_A]: _DRSPe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeRouteServersCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeRouteServersRequest(input, context),
        [_A]: _DRSe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeRouteTablesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeRouteTablesRequest(input, context),
        [_A]: _DRTe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeScheduledInstanceAvailabilityCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeScheduledInstanceAvailabilityRequest(input, context),
        [_A]: _DSIA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeScheduledInstancesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeScheduledInstancesRequest(input, context),
        [_A]: _DSI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeSecurityGroupReferencesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeSecurityGroupReferencesRequest(input, context),
        [_A]: _DSGR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeSecurityGroupRulesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeSecurityGroupRulesRequest(input, context),
        [_A]: _DSGRe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeSecurityGroupsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeSecurityGroupsRequest(input, context),
        [_A]: _DSGe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeSecurityGroupVpcAssociationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeSecurityGroupVpcAssociationsRequest(input, context),
        [_A]: _DSGVA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeServiceLinkVirtualInterfacesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeServiceLinkVirtualInterfacesRequest(input, context),
        [_A]: _DSLVI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeSnapshotAttributeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeSnapshotAttributeRequest(input, context),
        [_A]: _DSA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeSnapshotsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeSnapshotsRequest(input, context),
        [_A]: _DSes,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeSnapshotTierStatusCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeSnapshotTierStatusRequest(input, context),
        [_A]: _DSTS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeSpotDatafeedSubscriptionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeSpotDatafeedSubscriptionRequest(input, context),
        [_A]: _DSDSe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeSpotFleetInstancesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeSpotFleetInstancesRequest(input, context),
        [_A]: _DSFI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeSpotFleetRequestHistoryCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeSpotFleetRequestHistoryRequest(input, context),
        [_A]: _DSFRH,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeSpotFleetRequestsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeSpotFleetRequestsRequest(input, context),
        [_A]: _DSFR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeSpotInstanceRequestsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeSpotInstanceRequestsRequest(input, context),
        [_A]: _DSIR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeSpotPriceHistoryCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeSpotPriceHistoryRequest(input, context),
        [_A]: _DSPH,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeStaleSecurityGroupsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeStaleSecurityGroupsRequest(input, context),
        [_A]: _DSSG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeStoreImageTasksCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeStoreImageTasksRequest(input, context),
        [_A]: _DSIT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeSubnetsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeSubnetsRequest(input, context),
        [_A]: _DSesc,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeTagsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeTagsRequest(input, context),
        [_A]: _DTe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeTrafficMirrorFilterRulesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeTrafficMirrorFilterRulesRequest(input, context),
        [_A]: _DTMFRe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeTrafficMirrorFiltersCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeTrafficMirrorFiltersRequest(input, context),
        [_A]: _DTMFe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeTrafficMirrorSessionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeTrafficMirrorSessionsRequest(input, context),
        [_A]: _DTMSe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeTrafficMirrorTargetsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeTrafficMirrorTargetsRequest(input, context),
        [_A]: _DTMTe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeTransitGatewayAttachmentsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeTransitGatewayAttachmentsRequest(input, context),
        [_A]: _DTGA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeTransitGatewayConnectPeersCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeTransitGatewayConnectPeersRequest(input, context),
        [_A]: _DTGCPe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeTransitGatewayConnectsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeTransitGatewayConnectsRequest(input, context),
        [_A]: _DTGCe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeTransitGatewayMulticastDomainsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeTransitGatewayMulticastDomainsRequest(input, context),
        [_A]: _DTGMDe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeTransitGatewayPeeringAttachmentsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeTransitGatewayPeeringAttachmentsRequest(input, context),
        [_A]: _DTGPAe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeTransitGatewayPolicyTablesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeTransitGatewayPolicyTablesRequest(input, context),
        [_A]: _DTGPTe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeTransitGatewayRouteTableAnnouncementsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeTransitGatewayRouteTableAnnouncementsRequest(input, context),
        [_A]: _DTGRTAe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeTransitGatewayRouteTablesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeTransitGatewayRouteTablesRequest(input, context),
        [_A]: _DTGRTe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeTransitGatewaysCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeTransitGatewaysRequest(input, context),
        [_A]: _DTGe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeTransitGatewayVpcAttachmentsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeTransitGatewayVpcAttachmentsRequest(input, context),
        [_A]: _DTGVAe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeTrunkInterfaceAssociationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeTrunkInterfaceAssociationsRequest(input, context),
        [_A]: _DTIA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeVerifiedAccessEndpointsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeVerifiedAccessEndpointsRequest(input, context),
        [_A]: _DVAEe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeVerifiedAccessGroupsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeVerifiedAccessGroupsRequest(input, context),
        [_A]: _DVAGe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeVerifiedAccessInstanceLoggingConfigurationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeVerifiedAccessInstanceLoggingConfigurationsRequest(input, context),
        [_A]: _DVAILC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeVerifiedAccessInstancesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeVerifiedAccessInstancesRequest(input, context),
        [_A]: _DVAIe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeVerifiedAccessTrustProvidersCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeVerifiedAccessTrustProvidersRequest(input, context),
        [_A]: _DVATPe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeVolumeAttributeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeVolumeAttributeRequest(input, context),
        [_A]: _DVA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeVolumesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeVolumesRequest(input, context),
        [_A]: _DVes,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeVolumesModificationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeVolumesModificationsRequest(input, context),
        [_A]: _DVM,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeVolumeStatusCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeVolumeStatusRequest(input, context),
        [_A]: _DVS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeVpcAttributeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeVpcAttributeRequest(input, context),
        [_A]: _DVAe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeVpcBlockPublicAccessExclusionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeVpcBlockPublicAccessExclusionsRequest(input, context),
        [_A]: _DVBPAEe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeVpcBlockPublicAccessOptionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeVpcBlockPublicAccessOptionsRequest(input, context),
        [_A]: _DVBPAO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeVpcClassicLinkCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeVpcClassicLinkRequest(input, context),
        [_A]: _DVCL,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeVpcClassicLinkDnsSupportCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeVpcClassicLinkDnsSupportRequest(input, context),
        [_A]: _DVCLDS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeVpcEndpointAssociationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeVpcEndpointAssociationsRequest(input, context),
        [_A]: _DVEA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeVpcEndpointConnectionNotificationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeVpcEndpointConnectionNotificationsRequest(input, context),
        [_A]: _DVECNe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeVpcEndpointConnectionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeVpcEndpointConnectionsRequest(input, context),
        [_A]: _DVEC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeVpcEndpointsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeVpcEndpointsRequest(input, context),
        [_A]: _DVEe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeVpcEndpointServiceConfigurationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeVpcEndpointServiceConfigurationsRequest(input, context),
        [_A]: _DVESCe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeVpcEndpointServicePermissionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeVpcEndpointServicePermissionsRequest(input, context),
        [_A]: _DVESP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeVpcEndpointServicesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeVpcEndpointServicesRequest(input, context),
        [_A]: _DVES,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeVpcPeeringConnectionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeVpcPeeringConnectionsRequest(input, context),
        [_A]: _DVPCe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeVpcsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeVpcsRequest(input, context),
        [_A]: _DVesc,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeVpnConnectionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeVpnConnectionsRequest(input, context),
        [_A]: _DVCe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeVpnGatewaysCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeVpnGatewaysRequest(input, context),
        [_A]: _DVGe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DetachClassicLinkVpcCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DetachClassicLinkVpcRequest(input, context),
        [_A]: _DCLV,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DetachInternetGatewayCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DetachInternetGatewayRequest(input, context),
        [_A]: _DIGet,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DetachNetworkInterfaceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DetachNetworkInterfaceRequest(input, context),
        [_A]: _DNIet,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DetachVerifiedAccessTrustProviderCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DetachVerifiedAccessTrustProviderRequest(input, context),
        [_A]: _DVATPet,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DetachVolumeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DetachVolumeRequest(input, context),
        [_A]: _DVet,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DetachVpnGatewayCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DetachVpnGatewayRequest(input, context),
        [_A]: _DVGet,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisableAddressTransferCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisableAddressTransferRequest(input, context),
        [_A]: _DATi,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisableAllowedImagesSettingsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisableAllowedImagesSettingsRequest(input, context),
        [_A]: _DAIS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisableAwsNetworkPerformanceMetricSubscriptionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisableAwsNetworkPerformanceMetricSubscriptionRequest(input, context),
        [_A]: _DANPMSi,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisableEbsEncryptionByDefaultCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisableEbsEncryptionByDefaultRequest(input, context),
        [_A]: _DEEBD,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisableFastLaunchCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisableFastLaunchRequest(input, context),
        [_A]: _DFLi,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisableFastSnapshotRestoresCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisableFastSnapshotRestoresRequest(input, context),
        [_A]: _DFSRi,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisableImageCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisableImageRequest(input, context),
        [_A]: _DIi,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisableImageBlockPublicAccessCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisableImageBlockPublicAccessRequest(input, context),
        [_A]: _DIBPA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisableImageDeprecationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisableImageDeprecationRequest(input, context),
        [_A]: _DID,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisableImageDeregistrationProtectionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisableImageDeregistrationProtectionRequest(input, context),
        [_A]: _DIDP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisableIpamOrganizationAdminAccountCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisableIpamOrganizationAdminAccountRequest(input, context),
        [_A]: _DIOAA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisableRouteServerPropagationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisableRouteServerPropagationRequest(input, context),
        [_A]: _DRSPi,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisableSerialConsoleAccessCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisableSerialConsoleAccessRequest(input, context),
        [_A]: _DSCA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisableSnapshotBlockPublicAccessCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisableSnapshotBlockPublicAccessRequest(input, context),
        [_A]: _DSBPA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisableTransitGatewayRouteTablePropagationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisableTransitGatewayRouteTablePropagationRequest(input, context),
        [_A]: _DTGRTP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisableVgwRoutePropagationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisableVgwRoutePropagationRequest(input, context),
        [_A]: _DVRP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisableVpcClassicLinkCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisableVpcClassicLinkRequest(input, context),
        [_A]: _DVCLi,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisableVpcClassicLinkDnsSupportCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisableVpcClassicLinkDnsSupportRequest(input, context),
        [_A]: _DVCLDSi,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisassociateAddressCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisassociateAddressRequest(input, context),
        [_A]: _DAi,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisassociateCapacityReservationBillingOwnerCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisassociateCapacityReservationBillingOwnerRequest(input, context),
        [_A]: _DCRBO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisassociateClientVpnTargetNetworkCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisassociateClientVpnTargetNetworkRequest(input, context),
        [_A]: _DCVTNi,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisassociateEnclaveCertificateIamRoleCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisassociateEnclaveCertificateIamRoleRequest(input, context),
        [_A]: _DECIR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisassociateIamInstanceProfileCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisassociateIamInstanceProfileRequest(input, context),
        [_A]: _DIIP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisassociateInstanceEventWindowCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisassociateInstanceEventWindowRequest(input, context),
        [_A]: _DIEWi,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisassociateIpamByoasnCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisassociateIpamByoasnRequest(input, context),
        [_A]: _DIBi,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisassociateIpamResourceDiscoveryCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisassociateIpamResourceDiscoveryRequest(input, context),
        [_A]: _DIRDi,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisassociateNatGatewayAddressCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisassociateNatGatewayAddressRequest(input, context),
        [_A]: _DNGA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisassociateRouteServerCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisassociateRouteServerRequest(input, context),
        [_A]: _DRSi,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisassociateRouteTableCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisassociateRouteTableRequest(input, context),
        [_A]: _DRTi,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisassociateSecurityGroupVpcCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisassociateSecurityGroupVpcRequest(input, context),
        [_A]: _DSGV,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisassociateSubnetCidrBlockCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisassociateSubnetCidrBlockRequest(input, context),
        [_A]: _DSCB,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisassociateTransitGatewayMulticastDomainCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisassociateTransitGatewayMulticastDomainRequest(input, context),
        [_A]: _DTGMDi,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisassociateTransitGatewayPolicyTableCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisassociateTransitGatewayPolicyTableRequest(input, context),
        [_A]: _DTGPTi,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisassociateTransitGatewayRouteTableCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisassociateTransitGatewayRouteTableRequest(input, context),
        [_A]: _DTGRTi,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisassociateTrunkInterfaceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisassociateTrunkInterfaceRequest(input, context),
        [_A]: _DTI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisassociateVpcCidrBlockCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisassociateVpcCidrBlockRequest(input, context),
        [_A]: _DVCB,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_EnableAddressTransferCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_EnableAddressTransferRequest(input, context),
        [_A]: _EAT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_EnableAllowedImagesSettingsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_EnableAllowedImagesSettingsRequest(input, context),
        [_A]: _EAIS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_EnableAwsNetworkPerformanceMetricSubscriptionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_EnableAwsNetworkPerformanceMetricSubscriptionRequest(input, context),
        [_A]: _EANPMS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_EnableEbsEncryptionByDefaultCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_EnableEbsEncryptionByDefaultRequest(input, context),
        [_A]: _EEEBD,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_EnableFastLaunchCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_EnableFastLaunchRequest(input, context),
        [_A]: _EFL,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_EnableFastSnapshotRestoresCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_EnableFastSnapshotRestoresRequest(input, context),
        [_A]: _EFSR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_EnableImageCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_EnableImageRequest(input, context),
        [_A]: _EI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_EnableImageBlockPublicAccessCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_EnableImageBlockPublicAccessRequest(input, context),
        [_A]: _EIBPA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_EnableImageDeprecationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_EnableImageDeprecationRequest(input, context),
        [_A]: _EID,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_EnableImageDeregistrationProtectionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_EnableImageDeregistrationProtectionRequest(input, context),
        [_A]: _EIDP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_EnableIpamOrganizationAdminAccountCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_EnableIpamOrganizationAdminAccountRequest(input, context),
        [_A]: _EIOAA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_EnableReachabilityAnalyzerOrganizationSharingCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_EnableReachabilityAnalyzerOrganizationSharingRequest(input, context),
        [_A]: _ERAOS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_EnableRouteServerPropagationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_EnableRouteServerPropagationRequest(input, context),
        [_A]: _ERSP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_EnableSerialConsoleAccessCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_EnableSerialConsoleAccessRequest(input, context),
        [_A]: _ESCA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_EnableSnapshotBlockPublicAccessCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_EnableSnapshotBlockPublicAccessRequest(input, context),
        [_A]: _ESBPA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_EnableTransitGatewayRouteTablePropagationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_EnableTransitGatewayRouteTablePropagationRequest(input, context),
        [_A]: _ETGRTP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_EnableVgwRoutePropagationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_EnableVgwRoutePropagationRequest(input, context),
        [_A]: _EVRP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_EnableVolumeIOCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_EnableVolumeIORequest(input, context),
        [_A]: _EVIO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_EnableVpcClassicLinkCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_EnableVpcClassicLinkRequest(input, context),
        [_A]: _EVCL,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_EnableVpcClassicLinkDnsSupportCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_EnableVpcClassicLinkDnsSupportRequest(input, context),
        [_A]: _EVCLDS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ExportClientVpnClientCertificateRevocationListCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ExportClientVpnClientCertificateRevocationListRequest(input, context),
        [_A]: _ECVCCRL,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ExportClientVpnClientConfigurationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ExportClientVpnClientConfigurationRequest(input, context),
        [_A]: _ECVCC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ExportImageCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ExportImageRequest(input, context),
        [_A]: _EIx,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ExportTransitGatewayRoutesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ExportTransitGatewayRoutesRequest(input, context),
        [_A]: _ETGR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ExportVerifiedAccessInstanceClientConfigurationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ExportVerifiedAccessInstanceClientConfigurationRequest(input, context),
        [_A]: _EVAICC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetActiveVpnTunnelStatusCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetActiveVpnTunnelStatusRequest(input, context),
        [_A]: _GAVTS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetAllowedImagesSettingsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetAllowedImagesSettingsRequest(input, context),
        [_A]: _GAIS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetAssociatedEnclaveCertificateIamRolesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetAssociatedEnclaveCertificateIamRolesRequest(input, context),
        [_A]: _GAECIR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetAssociatedIpv6PoolCidrsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetAssociatedIpv6PoolCidrsRequest(input, context),
        [_A]: _GAIPC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetAwsNetworkPerformanceDataCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetAwsNetworkPerformanceDataRequest(input, context),
        [_A]: _GANPD,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetCapacityReservationUsageCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetCapacityReservationUsageRequest(input, context),
        [_A]: _GCRU,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetCoipPoolUsageCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetCoipPoolUsageRequest(input, context),
        [_A]: _GCPU,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetConsoleOutputCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetConsoleOutputRequest(input, context),
        [_A]: _GCO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetConsoleScreenshotCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetConsoleScreenshotRequest(input, context),
        [_A]: _GCS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetDeclarativePoliciesReportSummaryCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetDeclarativePoliciesReportSummaryRequest(input, context),
        [_A]: _GDPRS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetDefaultCreditSpecificationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetDefaultCreditSpecificationRequest(input, context),
        [_A]: _GDCS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetEbsDefaultKmsKeyIdCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetEbsDefaultKmsKeyIdRequest(input, context),
        [_A]: _GEDKKI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetEbsEncryptionByDefaultCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetEbsEncryptionByDefaultRequest(input, context),
        [_A]: _GEEBD,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetFlowLogsIntegrationTemplateCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetFlowLogsIntegrationTemplateRequest(input, context),
        [_A]: _GFLIT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetGroupsForCapacityReservationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetGroupsForCapacityReservationRequest(input, context),
        [_A]: _GGFCR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetHostReservationPurchasePreviewCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetHostReservationPurchasePreviewRequest(input, context),
        [_A]: _GHRPP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetImageBlockPublicAccessStateCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetImageBlockPublicAccessStateRequest(input, context),
        [_A]: _GIBPAS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetInstanceMetadataDefaultsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetInstanceMetadataDefaultsRequest(input, context),
        [_A]: _GIMD,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetInstanceTpmEkPubCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetInstanceTpmEkPubRequest(input, context),
        [_A]: _GITEP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetInstanceTypesFromInstanceRequirementsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetInstanceTypesFromInstanceRequirementsRequest(input, context),
        [_A]: _GITFIR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetInstanceUefiDataCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetInstanceUefiDataRequest(input, context),
        [_A]: _GIUD,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetIpamAddressHistoryCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetIpamAddressHistoryRequest(input, context),
        [_A]: _GIAH,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetIpamDiscoveredAccountsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetIpamDiscoveredAccountsRequest(input, context),
        [_A]: _GIDA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetIpamDiscoveredPublicAddressesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetIpamDiscoveredPublicAddressesRequest(input, context),
        [_A]: _GIDPA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetIpamDiscoveredResourceCidrsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetIpamDiscoveredResourceCidrsRequest(input, context),
        [_A]: _GIDRC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetIpamPoolAllocationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetIpamPoolAllocationsRequest(input, context),
        [_A]: _GIPA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetIpamPoolCidrsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetIpamPoolCidrsRequest(input, context),
        [_A]: _GIPC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetIpamResourceCidrsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetIpamResourceCidrsRequest(input, context),
        [_A]: _GIRC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetLaunchTemplateDataCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetLaunchTemplateDataRequest(input, context),
        [_A]: _GLTD,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetManagedPrefixListAssociationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetManagedPrefixListAssociationsRequest(input, context),
        [_A]: _GMPLA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetManagedPrefixListEntriesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetManagedPrefixListEntriesRequest(input, context),
        [_A]: _GMPLE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetNetworkInsightsAccessScopeAnalysisFindingsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetNetworkInsightsAccessScopeAnalysisFindingsRequest(input, context),
        [_A]: _GNIASAF,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetNetworkInsightsAccessScopeContentCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetNetworkInsightsAccessScopeContentRequest(input, context),
        [_A]: _GNIASC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetPasswordDataCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetPasswordDataRequest(input, context),
        [_A]: _GPD,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetReservedInstancesExchangeQuoteCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetReservedInstancesExchangeQuoteRequest(input, context),
        [_A]: _GRIEQ,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetRouteServerAssociationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetRouteServerAssociationsRequest(input, context),
        [_A]: _GRSA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetRouteServerPropagationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetRouteServerPropagationsRequest(input, context),
        [_A]: _GRSP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetRouteServerRoutingDatabaseCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetRouteServerRoutingDatabaseRequest(input, context),
        [_A]: _GRSRD,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetSecurityGroupsForVpcCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetSecurityGroupsForVpcRequest(input, context),
        [_A]: _GSGFV,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetSerialConsoleAccessStatusCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetSerialConsoleAccessStatusRequest(input, context),
        [_A]: _GSCAS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetSnapshotBlockPublicAccessStateCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetSnapshotBlockPublicAccessStateRequest(input, context),
        [_A]: _GSBPAS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetSpotPlacementScoresCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetSpotPlacementScoresRequest(input, context),
        [_A]: _GSPS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetSubnetCidrReservationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetSubnetCidrReservationsRequest(input, context),
        [_A]: _GSCR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetTransitGatewayAttachmentPropagationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetTransitGatewayAttachmentPropagationsRequest(input, context),
        [_A]: _GTGAP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetTransitGatewayMulticastDomainAssociationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetTransitGatewayMulticastDomainAssociationsRequest(input, context),
        [_A]: _GTGMDA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetTransitGatewayPolicyTableAssociationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetTransitGatewayPolicyTableAssociationsRequest(input, context),
        [_A]: _GTGPTA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetTransitGatewayPolicyTableEntriesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetTransitGatewayPolicyTableEntriesRequest(input, context),
        [_A]: _GTGPTE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetTransitGatewayPrefixListReferencesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetTransitGatewayPrefixListReferencesRequest(input, context),
        [_A]: _GTGPLR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetTransitGatewayRouteTableAssociationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetTransitGatewayRouteTableAssociationsRequest(input, context),
        [_A]: _GTGRTA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetTransitGatewayRouteTablePropagationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetTransitGatewayRouteTablePropagationsRequest(input, context),
        [_A]: _GTGRTP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetVerifiedAccessEndpointPolicyCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetVerifiedAccessEndpointPolicyRequest(input, context),
        [_A]: _GVAEP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetVerifiedAccessEndpointTargetsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetVerifiedAccessEndpointTargetsRequest(input, context),
        [_A]: _GVAET,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetVerifiedAccessGroupPolicyCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetVerifiedAccessGroupPolicyRequest(input, context),
        [_A]: _GVAGP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetVpnConnectionDeviceSampleConfigurationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetVpnConnectionDeviceSampleConfigurationRequest(input, context),
        [_A]: _GVCDSC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetVpnConnectionDeviceTypesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetVpnConnectionDeviceTypesRequest(input, context),
        [_A]: _GVCDT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetVpnTunnelReplacementStatusCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_GetVpnTunnelReplacementStatusRequest(input, context),
        [_A]: _GVTRS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ImportClientVpnClientCertificateRevocationListCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ImportClientVpnClientCertificateRevocationListRequest(input, context),
        [_A]: _ICVCCRL,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ImportImageCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ImportImageRequest(input, context),
        [_A]: _II,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ImportInstanceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ImportInstanceRequest(input, context),
        [_A]: _IIm,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ImportKeyPairCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ImportKeyPairRequest(input, context),
        [_A]: _IKP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ImportSnapshotCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ImportSnapshotRequest(input, context),
        [_A]: _IS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ImportVolumeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ImportVolumeRequest(input, context),
        [_A]: _IV,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListImagesInRecycleBinCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ListImagesInRecycleBinRequest(input, context),
        [_A]: _LIIRB,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListSnapshotsInRecycleBinCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ListSnapshotsInRecycleBinRequest(input, context),
        [_A]: _LSIRB,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_LockSnapshotCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_LockSnapshotRequest(input, context),
        [_A]: _LS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyAddressAttributeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyAddressAttributeRequest(input, context),
        [_A]: _MAA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyAvailabilityZoneGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyAvailabilityZoneGroupRequest(input, context),
        [_A]: _MAZG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyCapacityReservationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyCapacityReservationRequest(input, context),
        [_A]: _MCR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyCapacityReservationFleetCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyCapacityReservationFleetRequest(input, context),
        [_A]: _MCRF,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyClientVpnEndpointCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyClientVpnEndpointRequest(input, context),
        [_A]: _MCVE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyDefaultCreditSpecificationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyDefaultCreditSpecificationRequest(input, context),
        [_A]: _MDCS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyEbsDefaultKmsKeyIdCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyEbsDefaultKmsKeyIdRequest(input, context),
        [_A]: _MEDKKI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyFleetCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyFleetRequest(input, context),
        [_A]: _MF,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyFpgaImageAttributeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyFpgaImageAttributeRequest(input, context),
        [_A]: _MFIA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyHostsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyHostsRequest(input, context),
        [_A]: _MH,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyIdentityIdFormatCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyIdentityIdFormatRequest(input, context),
        [_A]: _MIIF,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyIdFormatCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyIdFormatRequest(input, context),
        [_A]: _MIF,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyImageAttributeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyImageAttributeRequest(input, context),
        [_A]: _MIA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyInstanceAttributeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyInstanceAttributeRequest(input, context),
        [_A]: _MIAo,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyInstanceCapacityReservationAttributesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyInstanceCapacityReservationAttributesRequest(input, context),
        [_A]: _MICRA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyInstanceConnectEndpointCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyInstanceConnectEndpointRequest(input, context),
        [_A]: _MICE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyInstanceCpuOptionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyInstanceCpuOptionsRequest(input, context),
        [_A]: _MICO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyInstanceCreditSpecificationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyInstanceCreditSpecificationRequest(input, context),
        [_A]: _MICS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyInstanceEventStartTimeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyInstanceEventStartTimeRequest(input, context),
        [_A]: _MIEST,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyInstanceEventWindowCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyInstanceEventWindowRequest(input, context),
        [_A]: _MIEW,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyInstanceMaintenanceOptionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyInstanceMaintenanceOptionsRequest(input, context),
        [_A]: _MIMO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyInstanceMetadataDefaultsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyInstanceMetadataDefaultsRequest(input, context),
        [_A]: _MIMD,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyInstanceMetadataOptionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyInstanceMetadataOptionsRequest(input, context),
        [_A]: _MIMOo,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyInstanceNetworkPerformanceOptionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyInstanceNetworkPerformanceRequest(input, context),
        [_A]: _MINPO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyInstancePlacementCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyInstancePlacementRequest(input, context),
        [_A]: _MIP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyIpamCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyIpamRequest(input, context),
        [_A]: _MI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyIpamPoolCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyIpamPoolRequest(input, context),
        [_A]: _MIPo,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyIpamResourceCidrCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyIpamResourceCidrRequest(input, context),
        [_A]: _MIRC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyIpamResourceDiscoveryCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyIpamResourceDiscoveryRequest(input, context),
        [_A]: _MIRD,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyIpamScopeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyIpamScopeRequest(input, context),
        [_A]: _MIS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyLaunchTemplateCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyLaunchTemplateRequest(input, context),
        [_A]: _MLT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyLocalGatewayRouteCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyLocalGatewayRouteRequest(input, context),
        [_A]: _MLGR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyManagedPrefixListCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyManagedPrefixListRequest(input, context),
        [_A]: _MMPL,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyNetworkInterfaceAttributeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyNetworkInterfaceAttributeRequest(input, context),
        [_A]: _MNIA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyPrivateDnsNameOptionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyPrivateDnsNameOptionsRequest(input, context),
        [_A]: _MPDNO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyPublicIpDnsNameOptionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyPublicIpDnsNameOptionsRequest(input, context),
        [_A]: _MPIDNO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyReservedInstancesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyReservedInstancesRequest(input, context),
        [_A]: _MRI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyRouteServerCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyRouteServerRequest(input, context),
        [_A]: _MRS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifySecurityGroupRulesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifySecurityGroupRulesRequest(input, context),
        [_A]: _MSGR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifySnapshotAttributeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifySnapshotAttributeRequest(input, context),
        [_A]: _MSA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifySnapshotTierCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifySnapshotTierRequest(input, context),
        [_A]: _MST,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifySpotFleetRequestCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifySpotFleetRequestRequest(input, context),
        [_A]: _MSFR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifySubnetAttributeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifySubnetAttributeRequest(input, context),
        [_A]: _MSAo,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyTrafficMirrorFilterNetworkServicesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyTrafficMirrorFilterNetworkServicesRequest(input, context),
        [_A]: _MTMFNS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyTrafficMirrorFilterRuleCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyTrafficMirrorFilterRuleRequest(input, context),
        [_A]: _MTMFR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyTrafficMirrorSessionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyTrafficMirrorSessionRequest(input, context),
        [_A]: _MTMS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyTransitGatewayCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyTransitGatewayRequest(input, context),
        [_A]: _MTG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyTransitGatewayPrefixListReferenceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyTransitGatewayPrefixListReferenceRequest(input, context),
        [_A]: _MTGPLR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyTransitGatewayVpcAttachmentCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyTransitGatewayVpcAttachmentRequest(input, context),
        [_A]: _MTGVA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyVerifiedAccessEndpointCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyVerifiedAccessEndpointRequest(input, context),
        [_A]: _MVAE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyVerifiedAccessEndpointPolicyCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyVerifiedAccessEndpointPolicyRequest(input, context),
        [_A]: _MVAEP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyVerifiedAccessGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyVerifiedAccessGroupRequest(input, context),
        [_A]: _MVAG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyVerifiedAccessGroupPolicyCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyVerifiedAccessGroupPolicyRequest(input, context),
        [_A]: _MVAGP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyVerifiedAccessInstanceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyVerifiedAccessInstanceRequest(input, context),
        [_A]: _MVAI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyVerifiedAccessInstanceLoggingConfigurationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyVerifiedAccessInstanceLoggingConfigurationRequest(input, context),
        [_A]: _MVAILC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyVerifiedAccessTrustProviderCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyVerifiedAccessTrustProviderRequest(input, context),
        [_A]: _MVATP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyVolumeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyVolumeRequest(input, context),
        [_A]: _MV,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyVolumeAttributeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyVolumeAttributeRequest(input, context),
        [_A]: _MVA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyVpcAttributeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyVpcAttributeRequest(input, context),
        [_A]: _MVAo,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyVpcBlockPublicAccessExclusionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyVpcBlockPublicAccessExclusionRequest(input, context),
        [_A]: _MVBPAE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyVpcBlockPublicAccessOptionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyVpcBlockPublicAccessOptionsRequest(input, context),
        [_A]: _MVBPAO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyVpcEndpointCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyVpcEndpointRequest(input, context),
        [_A]: _MVE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyVpcEndpointConnectionNotificationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyVpcEndpointConnectionNotificationRequest(input, context),
        [_A]: _MVECN,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyVpcEndpointServiceConfigurationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyVpcEndpointServiceConfigurationRequest(input, context),
        [_A]: _MVESC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyVpcEndpointServicePayerResponsibilityCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyVpcEndpointServicePayerResponsibilityRequest(input, context),
        [_A]: _MVESPR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyVpcEndpointServicePermissionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyVpcEndpointServicePermissionsRequest(input, context),
        [_A]: _MVESP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyVpcPeeringConnectionOptionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyVpcPeeringConnectionOptionsRequest(input, context),
        [_A]: _MVPCO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyVpcTenancyCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyVpcTenancyRequest(input, context),
        [_A]: _MVT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyVpnConnectionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyVpnConnectionRequest(input, context),
        [_A]: _MVC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyVpnConnectionOptionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyVpnConnectionOptionsRequest(input, context),
        [_A]: _MVCO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyVpnTunnelCertificateCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyVpnTunnelCertificateRequest(input, context),
        [_A]: _MVTC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyVpnTunnelOptionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyVpnTunnelOptionsRequest(input, context),
        [_A]: _MVTO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_MonitorInstancesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_MonitorInstancesRequest(input, context),
        [_A]: _MIo,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_MoveAddressToVpcCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_MoveAddressToVpcRequest(input, context),
        [_A]: _MATV,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_MoveByoipCidrToIpamCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_MoveByoipCidrToIpamRequest(input, context),
        [_A]: _MBCTI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_MoveCapacityReservationInstancesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_MoveCapacityReservationInstancesRequest(input, context),
        [_A]: _MCRI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ProvisionByoipCidrCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ProvisionByoipCidrRequest(input, context),
        [_A]: _PBC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ProvisionIpamByoasnCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ProvisionIpamByoasnRequest(input, context),
        [_A]: _PIB,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ProvisionIpamPoolCidrCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ProvisionIpamPoolCidrRequest(input, context),
        [_A]: _PIPC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ProvisionPublicIpv4PoolCidrCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ProvisionPublicIpv4PoolCidrRequest(input, context),
        [_A]: _PPIPC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_PurchaseCapacityBlockCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_PurchaseCapacityBlockRequest(input, context),
        [_A]: _PCB,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_PurchaseCapacityBlockExtensionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_PurchaseCapacityBlockExtensionRequest(input, context),
        [_A]: _PCBE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_PurchaseHostReservationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_PurchaseHostReservationRequest(input, context),
        [_A]: _PHR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_PurchaseReservedInstancesOfferingCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_PurchaseReservedInstancesOfferingRequest(input, context),
        [_A]: _PRIO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_PurchaseScheduledInstancesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_PurchaseScheduledInstancesRequest(input, context),
        [_A]: _PSI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RebootInstancesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RebootInstancesRequest(input, context),
        [_A]: _RI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RegisterImageCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RegisterImageRequest(input, context),
        [_A]: _RIe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RegisterInstanceEventNotificationAttributesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RegisterInstanceEventNotificationAttributesRequest(input, context),
        [_A]: _RIENA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RegisterTransitGatewayMulticastGroupMembersCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RegisterTransitGatewayMulticastGroupMembersRequest(input, context),
        [_A]: _RTGMGM,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RegisterTransitGatewayMulticastGroupSourcesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RegisterTransitGatewayMulticastGroupSourcesRequest(input, context),
        [_A]: _RTGMGS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RejectCapacityReservationBillingOwnershipCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RejectCapacityReservationBillingOwnershipRequest(input, context),
        [_A]: _RCRBO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RejectTransitGatewayMulticastDomainAssociationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RejectTransitGatewayMulticastDomainAssociationsRequest(input, context),
        [_A]: _RTGMDA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RejectTransitGatewayPeeringAttachmentCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RejectTransitGatewayPeeringAttachmentRequest(input, context),
        [_A]: _RTGPA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RejectTransitGatewayVpcAttachmentCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RejectTransitGatewayVpcAttachmentRequest(input, context),
        [_A]: _RTGVA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RejectVpcEndpointConnectionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RejectVpcEndpointConnectionsRequest(input, context),
        [_A]: _RVEC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RejectVpcPeeringConnectionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RejectVpcPeeringConnectionRequest(input, context),
        [_A]: _RVPC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ReleaseAddressCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ReleaseAddressRequest(input, context),
        [_A]: _RA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ReleaseHostsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ReleaseHostsRequest(input, context),
        [_A]: _RH,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ReleaseIpamPoolAllocationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ReleaseIpamPoolAllocationRequest(input, context),
        [_A]: _RIPA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ReplaceIamInstanceProfileAssociationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ReplaceIamInstanceProfileAssociationRequest(input, context),
        [_A]: _RIIPA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ReplaceImageCriteriaInAllowedImagesSettingsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ReplaceImageCriteriaInAllowedImagesSettingsRequest(input, context),
        [_A]: _RICIAIS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ReplaceNetworkAclAssociationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ReplaceNetworkAclAssociationRequest(input, context),
        [_A]: _RNAA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ReplaceNetworkAclEntryCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ReplaceNetworkAclEntryRequest(input, context),
        [_A]: _RNAE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ReplaceRouteCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ReplaceRouteRequest(input, context),
        [_A]: _RR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ReplaceRouteTableAssociationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ReplaceRouteTableAssociationRequest(input, context),
        [_A]: _RRTA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ReplaceTransitGatewayRouteCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ReplaceTransitGatewayRouteRequest(input, context),
        [_A]: _RTGR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ReplaceVpnTunnelCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ReplaceVpnTunnelRequest(input, context),
        [_A]: _RVT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ReportInstanceStatusCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ReportInstanceStatusRequest(input, context),
        [_A]: _RIS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RequestSpotFleetCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RequestSpotFleetRequest(input, context),
        [_A]: _RSF,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RequestSpotInstancesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RequestSpotInstancesRequest(input, context),
        [_A]: _RSI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ResetAddressAttributeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ResetAddressAttributeRequest(input, context),
        [_A]: _RAA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ResetEbsDefaultKmsKeyIdCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ResetEbsDefaultKmsKeyIdRequest(input, context),
        [_A]: _REDKKI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ResetFpgaImageAttributeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ResetFpgaImageAttributeRequest(input, context),
        [_A]: _RFIA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ResetImageAttributeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ResetImageAttributeRequest(input, context),
        [_A]: _RIA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ResetInstanceAttributeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ResetInstanceAttributeRequest(input, context),
        [_A]: _RIAe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ResetNetworkInterfaceAttributeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ResetNetworkInterfaceAttributeRequest(input, context),
        [_A]: _RNIA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ResetSnapshotAttributeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ResetSnapshotAttributeRequest(input, context),
        [_A]: _RSA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RestoreAddressToClassicCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RestoreAddressToClassicRequest(input, context),
        [_A]: _RATC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RestoreImageFromRecycleBinCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RestoreImageFromRecycleBinRequest(input, context),
        [_A]: _RIFRB,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RestoreManagedPrefixListVersionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RestoreManagedPrefixListVersionRequest(input, context),
        [_A]: _RMPLV,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RestoreSnapshotFromRecycleBinCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RestoreSnapshotFromRecycleBinRequest(input, context),
        [_A]: _RSFRB,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RestoreSnapshotTierCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RestoreSnapshotTierRequest(input, context),
        [_A]: _RST,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RevokeClientVpnIngressCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RevokeClientVpnIngressRequest(input, context),
        [_A]: _RCVI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RevokeSecurityGroupEgressCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RevokeSecurityGroupEgressRequest(input, context),
        [_A]: _RSGE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RevokeSecurityGroupIngressCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RevokeSecurityGroupIngressRequest(input, context),
        [_A]: _RSGI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RunInstancesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RunInstancesRequest(input, context),
        [_A]: _RIu,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RunScheduledInstancesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RunScheduledInstancesRequest(input, context),
        [_A]: _RSIu,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_SearchLocalGatewayRoutesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_SearchLocalGatewayRoutesRequest(input, context),
        [_A]: _SLGR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_SearchTransitGatewayMulticastGroupsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_SearchTransitGatewayMulticastGroupsRequest(input, context),
        [_A]: _STGMG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_SearchTransitGatewayRoutesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_SearchTransitGatewayRoutesRequest(input, context),
        [_A]: _STGR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_SendDiagnosticInterruptCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_SendDiagnosticInterruptRequest(input, context),
        [_A]: _SDI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_StartDeclarativePoliciesReportCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_StartDeclarativePoliciesReportRequest(input, context),
        [_A]: _SDPR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_StartInstancesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_StartInstancesRequest(input, context),
        [_A]: _SI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_StartNetworkInsightsAccessScopeAnalysisCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_StartNetworkInsightsAccessScopeAnalysisRequest(input, context),
        [_A]: _SNIASA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_StartNetworkInsightsAnalysisCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_StartNetworkInsightsAnalysisRequest(input, context),
        [_A]: _SNIA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_StartVpcEndpointServicePrivateDnsVerificationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_StartVpcEndpointServicePrivateDnsVerificationRequest(input, context),
        [_A]: _SVESPDV,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_StopInstancesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_StopInstancesRequest(input, context),
        [_A]: _SIt,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_TerminateClientVpnConnectionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_TerminateClientVpnConnectionsRequest(input, context),
        [_A]: _TCVC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_TerminateInstancesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_TerminateInstancesRequest(input, context),
        [_A]: _TI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UnassignIpv6AddressesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_UnassignIpv6AddressesRequest(input, context),
        [_A]: _UIA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UnassignPrivateIpAddressesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_UnassignPrivateIpAddressesRequest(input, context),
        [_A]: _UPIA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UnassignPrivateNatGatewayAddressCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_UnassignPrivateNatGatewayAddressRequest(input, context),
        [_A]: _UPNGA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UnlockSnapshotCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_UnlockSnapshotRequest(input, context),
        [_A]: _US,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UnmonitorInstancesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_UnmonitorInstancesRequest(input, context),
        [_A]: _UI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UpdateSecurityGroupRuleDescriptionsEgressCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_UpdateSecurityGroupRuleDescriptionsEgressRequest(input, context),
        [_A]: _USGRDE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UpdateSecurityGroupRuleDescriptionsIngressCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_UpdateSecurityGroupRuleDescriptionsIngressRequest(input, context),
        [_A]: _USGRDI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_WithdrawByoipCidrCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_WithdrawByoipCidrRequest(input, context),
        [_A]: _WBC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const de_AcceptAddressTransferCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AcceptAddressTransferResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AcceptCapacityReservationBillingOwnershipCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AcceptCapacityReservationBillingOwnershipResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AcceptReservedInstancesExchangeQuoteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AcceptReservedInstancesExchangeQuoteResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AcceptTransitGatewayMulticastDomainAssociationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AcceptTransitGatewayMulticastDomainAssociationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AcceptTransitGatewayPeeringAttachmentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AcceptTransitGatewayPeeringAttachmentResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AcceptTransitGatewayVpcAttachmentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AcceptTransitGatewayVpcAttachmentResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AcceptVpcEndpointConnectionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AcceptVpcEndpointConnectionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AcceptVpcPeeringConnectionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AcceptVpcPeeringConnectionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AdvertiseByoipCidrCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AdvertiseByoipCidrResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AllocateAddressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AllocateAddressResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AllocateHostsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AllocateHostsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AllocateIpamPoolCidrCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AllocateIpamPoolCidrResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ApplySecurityGroupsToClientVpnTargetNetworkCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ApplySecurityGroupsToClientVpnTargetNetworkResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AssignIpv6AddressesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AssignIpv6AddressesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AssignPrivateIpAddressesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AssignPrivateIpAddressesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AssignPrivateNatGatewayAddressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AssignPrivateNatGatewayAddressResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AssociateAddressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AssociateAddressResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AssociateCapacityReservationBillingOwnerCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AssociateCapacityReservationBillingOwnerResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AssociateClientVpnTargetNetworkCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AssociateClientVpnTargetNetworkResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AssociateDhcpOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_AssociateEnclaveCertificateIamRoleCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AssociateEnclaveCertificateIamRoleResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AssociateIamInstanceProfileCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AssociateIamInstanceProfileResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AssociateInstanceEventWindowCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AssociateInstanceEventWindowResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AssociateIpamByoasnCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AssociateIpamByoasnResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AssociateIpamResourceDiscoveryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AssociateIpamResourceDiscoveryResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AssociateNatGatewayAddressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AssociateNatGatewayAddressResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AssociateRouteServerCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AssociateRouteServerResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AssociateRouteTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AssociateRouteTableResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AssociateSecurityGroupVpcCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AssociateSecurityGroupVpcResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AssociateSubnetCidrBlockCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AssociateSubnetCidrBlockResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AssociateTransitGatewayMulticastDomainCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AssociateTransitGatewayMulticastDomainResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AssociateTransitGatewayPolicyTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AssociateTransitGatewayPolicyTableResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AssociateTransitGatewayRouteTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AssociateTransitGatewayRouteTableResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AssociateTrunkInterfaceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AssociateTrunkInterfaceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AssociateVpcCidrBlockCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AssociateVpcCidrBlockResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AttachClassicLinkVpcCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AttachClassicLinkVpcResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AttachInternetGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_AttachNetworkInterfaceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AttachNetworkInterfaceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AttachVerifiedAccessTrustProviderCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AttachVerifiedAccessTrustProviderResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AttachVolumeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_VolumeAttachment(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AttachVpnGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AttachVpnGatewayResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AuthorizeClientVpnIngressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AuthorizeClientVpnIngressResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AuthorizeSecurityGroupEgressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AuthorizeSecurityGroupEgressResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AuthorizeSecurityGroupIngressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AuthorizeSecurityGroupIngressResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_BundleInstanceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_BundleInstanceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CancelBundleTaskCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CancelBundleTaskResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CancelCapacityReservationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CancelCapacityReservationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CancelCapacityReservationFleetsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CancelCapacityReservationFleetsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CancelConversionTaskCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_CancelDeclarativePoliciesReportCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CancelDeclarativePoliciesReportResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CancelExportTaskCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_CancelImageLaunchPermissionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CancelImageLaunchPermissionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CancelImportTaskCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CancelImportTaskResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CancelReservedInstancesListingCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CancelReservedInstancesListingResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CancelSpotFleetRequestsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CancelSpotFleetRequestsResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CancelSpotInstanceRequestsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CancelSpotInstanceRequestsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ConfirmProductInstanceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ConfirmProductInstanceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CopyFpgaImageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CopyFpgaImageResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CopyImageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CopyImageResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CopySnapshotCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CopySnapshotResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateCapacityReservationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateCapacityReservationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateCapacityReservationBySplittingCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateCapacityReservationBySplittingResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateCapacityReservationFleetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateCapacityReservationFleetResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateCarrierGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateCarrierGatewayResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateClientVpnEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateClientVpnEndpointResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateClientVpnRouteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateClientVpnRouteResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateCoipCidrCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateCoipCidrResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateCoipPoolCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateCoipPoolResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateCustomerGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateCustomerGatewayResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateDefaultSubnetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateDefaultSubnetResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateDefaultVpcCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateDefaultVpcResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateDelegateMacVolumeOwnershipTaskCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateDelegateMacVolumeOwnershipTaskResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateDhcpOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateDhcpOptionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateEgressOnlyInternetGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateEgressOnlyInternetGatewayResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateFleetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateFleetResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateFlowLogsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateFlowLogsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateFpgaImageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateFpgaImageResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateImageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateImageResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateImageUsageReportCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateImageUsageReportResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateInstanceConnectEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateInstanceConnectEndpointResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateInstanceEventWindowCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateInstanceEventWindowResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateInstanceExportTaskCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateInstanceExportTaskResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateInternetGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateInternetGatewayResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateIpamCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateIpamResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateIpamExternalResourceVerificationTokenCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateIpamExternalResourceVerificationTokenResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateIpamPoolCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateIpamPoolResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateIpamResourceDiscoveryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateIpamResourceDiscoveryResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateIpamScopeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateIpamScopeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateKeyPairCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_KeyPair(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateLaunchTemplateCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateLaunchTemplateResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateLaunchTemplateVersionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateLaunchTemplateVersionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateLocalGatewayRouteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateLocalGatewayRouteResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateLocalGatewayRouteTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateLocalGatewayRouteTableResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateLocalGatewayRouteTableVpcAssociationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateLocalGatewayRouteTableVpcAssociationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateLocalGatewayVirtualInterfaceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateLocalGatewayVirtualInterfaceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateLocalGatewayVirtualInterfaceGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateLocalGatewayVirtualInterfaceGroupResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateMacSystemIntegrityProtectionModificationTaskCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateMacSystemIntegrityProtectionModificationTaskResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateManagedPrefixListCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateManagedPrefixListResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateNatGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateNatGatewayResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateNetworkAclCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateNetworkAclResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateNetworkAclEntryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_CreateNetworkInsightsAccessScopeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateNetworkInsightsAccessScopeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateNetworkInsightsPathCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateNetworkInsightsPathResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateNetworkInterfaceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateNetworkInterfaceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateNetworkInterfacePermissionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateNetworkInterfacePermissionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreatePlacementGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreatePlacementGroupResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreatePublicIpv4PoolCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreatePublicIpv4PoolResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateReplaceRootVolumeTaskCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateReplaceRootVolumeTaskResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateReservedInstancesListingCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateReservedInstancesListingResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateRestoreImageTaskCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateRestoreImageTaskResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateRouteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateRouteResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateRouteServerCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateRouteServerResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateRouteServerEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateRouteServerEndpointResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateRouteServerPeerCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateRouteServerPeerResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateRouteTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateRouteTableResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateSecurityGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateSecurityGroupResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateSnapshotCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_Snapshot(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateSnapshotsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateSnapshotsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateSpotDatafeedSubscriptionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateSpotDatafeedSubscriptionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateStoreImageTaskCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateStoreImageTaskResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateSubnetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateSubnetResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateSubnetCidrReservationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateSubnetCidrReservationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateTagsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_CreateTrafficMirrorFilterCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateTrafficMirrorFilterResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateTrafficMirrorFilterRuleCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateTrafficMirrorFilterRuleResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateTrafficMirrorSessionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateTrafficMirrorSessionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateTrafficMirrorTargetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateTrafficMirrorTargetResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateTransitGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateTransitGatewayResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateTransitGatewayConnectCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateTransitGatewayConnectResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateTransitGatewayConnectPeerCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateTransitGatewayConnectPeerResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateTransitGatewayMulticastDomainCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateTransitGatewayMulticastDomainResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateTransitGatewayPeeringAttachmentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateTransitGatewayPeeringAttachmentResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateTransitGatewayPolicyTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateTransitGatewayPolicyTableResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateTransitGatewayPrefixListReferenceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateTransitGatewayPrefixListReferenceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateTransitGatewayRouteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateTransitGatewayRouteResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateTransitGatewayRouteTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateTransitGatewayRouteTableResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateTransitGatewayRouteTableAnnouncementCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateTransitGatewayRouteTableAnnouncementResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateTransitGatewayVpcAttachmentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateTransitGatewayVpcAttachmentResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateVerifiedAccessEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateVerifiedAccessEndpointResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateVerifiedAccessGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateVerifiedAccessGroupResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateVerifiedAccessInstanceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateVerifiedAccessInstanceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateVerifiedAccessTrustProviderCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateVerifiedAccessTrustProviderResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateVolumeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_Volume(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateVpcCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateVpcResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateVpcBlockPublicAccessExclusionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateVpcBlockPublicAccessExclusionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateVpcEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateVpcEndpointResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateVpcEndpointConnectionNotificationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateVpcEndpointConnectionNotificationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateVpcEndpointServiceConfigurationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateVpcEndpointServiceConfigurationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateVpcPeeringConnectionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateVpcPeeringConnectionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateVpnConnectionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateVpnConnectionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateVpnConnectionRouteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_CreateVpnGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateVpnGatewayResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteCarrierGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteCarrierGatewayResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteClientVpnEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteClientVpnEndpointResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteClientVpnRouteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteClientVpnRouteResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteCoipCidrCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteCoipCidrResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteCoipPoolCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteCoipPoolResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteCustomerGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DeleteDhcpOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DeleteEgressOnlyInternetGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteEgressOnlyInternetGatewayResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteFleetsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteFleetsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteFlowLogsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteFlowLogsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteFpgaImageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteFpgaImageResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteImageUsageReportCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteImageUsageReportResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteInstanceConnectEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteInstanceConnectEndpointResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteInstanceEventWindowCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteInstanceEventWindowResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteInternetGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DeleteIpamCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteIpamResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteIpamExternalResourceVerificationTokenCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteIpamExternalResourceVerificationTokenResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteIpamPoolCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteIpamPoolResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteIpamResourceDiscoveryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteIpamResourceDiscoveryResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteIpamScopeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteIpamScopeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteKeyPairCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteKeyPairResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteLaunchTemplateCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteLaunchTemplateResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteLaunchTemplateVersionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteLaunchTemplateVersionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteLocalGatewayRouteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteLocalGatewayRouteResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteLocalGatewayRouteTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteLocalGatewayRouteTableResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteLocalGatewayRouteTableVpcAssociationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteLocalGatewayRouteTableVpcAssociationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteLocalGatewayVirtualInterfaceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteLocalGatewayVirtualInterfaceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteLocalGatewayVirtualInterfaceGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteLocalGatewayVirtualInterfaceGroupResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteManagedPrefixListCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteManagedPrefixListResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteNatGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteNatGatewayResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteNetworkAclCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DeleteNetworkAclEntryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DeleteNetworkInsightsAccessScopeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteNetworkInsightsAccessScopeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteNetworkInsightsAccessScopeAnalysisCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteNetworkInsightsAccessScopeAnalysisResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteNetworkInsightsAnalysisCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteNetworkInsightsAnalysisResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteNetworkInsightsPathCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteNetworkInsightsPathResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteNetworkInterfaceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DeleteNetworkInterfacePermissionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteNetworkInterfacePermissionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeletePlacementGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DeletePublicIpv4PoolCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeletePublicIpv4PoolResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteQueuedReservedInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteQueuedReservedInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteRouteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DeleteRouteServerCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteRouteServerResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteRouteServerEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteRouteServerEndpointResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteRouteServerPeerCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteRouteServerPeerResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteRouteTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DeleteSecurityGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteSecurityGroupResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteSnapshotCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DeleteSpotDatafeedSubscriptionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DeleteSubnetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DeleteSubnetCidrReservationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteSubnetCidrReservationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteTagsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DeleteTrafficMirrorFilterCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteTrafficMirrorFilterResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteTrafficMirrorFilterRuleCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteTrafficMirrorFilterRuleResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteTrafficMirrorSessionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteTrafficMirrorSessionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteTrafficMirrorTargetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteTrafficMirrorTargetResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteTransitGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteTransitGatewayResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteTransitGatewayConnectCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteTransitGatewayConnectResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteTransitGatewayConnectPeerCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteTransitGatewayConnectPeerResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteTransitGatewayMulticastDomainCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteTransitGatewayMulticastDomainResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteTransitGatewayPeeringAttachmentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteTransitGatewayPeeringAttachmentResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteTransitGatewayPolicyTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteTransitGatewayPolicyTableResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteTransitGatewayPrefixListReferenceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteTransitGatewayPrefixListReferenceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteTransitGatewayRouteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteTransitGatewayRouteResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteTransitGatewayRouteTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteTransitGatewayRouteTableResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteTransitGatewayRouteTableAnnouncementCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteTransitGatewayRouteTableAnnouncementResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteTransitGatewayVpcAttachmentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteTransitGatewayVpcAttachmentResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteVerifiedAccessEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteVerifiedAccessEndpointResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteVerifiedAccessGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteVerifiedAccessGroupResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteVerifiedAccessInstanceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteVerifiedAccessInstanceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteVerifiedAccessTrustProviderCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteVerifiedAccessTrustProviderResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteVolumeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DeleteVpcCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DeleteVpcBlockPublicAccessExclusionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteVpcBlockPublicAccessExclusionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteVpcEndpointConnectionNotificationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteVpcEndpointConnectionNotificationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteVpcEndpointsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteVpcEndpointsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteVpcEndpointServiceConfigurationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteVpcEndpointServiceConfigurationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteVpcPeeringConnectionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteVpcPeeringConnectionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteVpnConnectionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DeleteVpnConnectionRouteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DeleteVpnGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DeprovisionByoipCidrCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeprovisionByoipCidrResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeprovisionIpamByoasnCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeprovisionIpamByoasnResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeprovisionIpamPoolCidrCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeprovisionIpamPoolCidrResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeprovisionPublicIpv4PoolCidrCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeprovisionPublicIpv4PoolCidrResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeregisterImageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeregisterImageResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeregisterInstanceEventNotificationAttributesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeregisterInstanceEventNotificationAttributesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeregisterTransitGatewayMulticastGroupMembersCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeregisterTransitGatewayMulticastGroupMembersResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeregisterTransitGatewayMulticastGroupSourcesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeregisterTransitGatewayMulticastGroupSourcesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeAccountAttributesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeAccountAttributesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeAddressesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeAddressesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeAddressesAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeAddressesAttributeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeAddressTransfersCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeAddressTransfersResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeAggregateIdFormatCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeAggregateIdFormatResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeAvailabilityZonesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeAvailabilityZonesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeAwsNetworkPerformanceMetricSubscriptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeAwsNetworkPerformanceMetricSubscriptionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeBundleTasksCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeBundleTasksResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeByoipCidrsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeByoipCidrsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeCapacityBlockExtensionHistoryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeCapacityBlockExtensionHistoryResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeCapacityBlockExtensionOfferingsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeCapacityBlockExtensionOfferingsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeCapacityBlockOfferingsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeCapacityBlockOfferingsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeCapacityBlocksCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeCapacityBlocksResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeCapacityBlockStatusCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeCapacityBlockStatusResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeCapacityReservationBillingRequestsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeCapacityReservationBillingRequestsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeCapacityReservationFleetsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeCapacityReservationFleetsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeCapacityReservationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeCapacityReservationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeCarrierGatewaysCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeCarrierGatewaysResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeClassicLinkInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeClassicLinkInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeClientVpnAuthorizationRulesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeClientVpnAuthorizationRulesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeClientVpnConnectionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeClientVpnConnectionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeClientVpnEndpointsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeClientVpnEndpointsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeClientVpnRoutesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeClientVpnRoutesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeClientVpnTargetNetworksCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeClientVpnTargetNetworksResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeCoipPoolsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeCoipPoolsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeConversionTasksCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeConversionTasksResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeCustomerGatewaysCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeCustomerGatewaysResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDeclarativePoliciesReportsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeDeclarativePoliciesReportsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDhcpOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeDhcpOptionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeEgressOnlyInternetGatewaysCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeEgressOnlyInternetGatewaysResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeElasticGpusCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeElasticGpusResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeExportImageTasksCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeExportImageTasksResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeExportTasksCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeExportTasksResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeFastLaunchImagesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeFastLaunchImagesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeFastSnapshotRestoresCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeFastSnapshotRestoresResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeFleetHistoryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeFleetHistoryResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeFleetInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeFleetInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeFleetsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeFleetsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeFlowLogsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeFlowLogsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeFpgaImageAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeFpgaImageAttributeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeFpgaImagesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeFpgaImagesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeHostReservationOfferingsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeHostReservationOfferingsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeHostReservationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeHostReservationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeHostsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeHostsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeIamInstanceProfileAssociationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeIamInstanceProfileAssociationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeIdentityIdFormatCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeIdentityIdFormatResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeIdFormatCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeIdFormatResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeImageAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ImageAttribute(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeImageReferencesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeImageReferencesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeImagesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeImagesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeImageUsageReportEntriesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeImageUsageReportEntriesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeImageUsageReportsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeImageUsageReportsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeImportImageTasksCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeImportImageTasksResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeImportSnapshotTasksCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeImportSnapshotTasksResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeInstanceAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_InstanceAttribute(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeInstanceConnectEndpointsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeInstanceConnectEndpointsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeInstanceCreditSpecificationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeInstanceCreditSpecificationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeInstanceEventNotificationAttributesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeInstanceEventNotificationAttributesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeInstanceEventWindowsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeInstanceEventWindowsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeInstanceImageMetadataCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeInstanceImageMetadataResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeInstanceStatusCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeInstanceStatusResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeInstanceTopologyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeInstanceTopologyResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeInstanceTypeOfferingsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeInstanceTypeOfferingsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeInstanceTypesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeInstanceTypesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeInternetGatewaysCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeInternetGatewaysResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeIpamByoasnCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeIpamByoasnResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeIpamExternalResourceVerificationTokensCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeIpamExternalResourceVerificationTokensResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeIpamPoolsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeIpamPoolsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeIpamResourceDiscoveriesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeIpamResourceDiscoveriesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeIpamResourceDiscoveryAssociationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeIpamResourceDiscoveryAssociationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeIpamsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeIpamsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeIpamScopesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeIpamScopesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeIpv6PoolsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeIpv6PoolsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeKeyPairsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeKeyPairsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeLaunchTemplatesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeLaunchTemplatesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeLaunchTemplateVersionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeLaunchTemplateVersionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeLocalGatewayRouteTablesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeLocalGatewayRouteTablesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeLocalGatewayRouteTableVpcAssociationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeLocalGatewayRouteTableVpcAssociationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeLocalGatewaysCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeLocalGatewaysResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeLocalGatewayVirtualInterfaceGroupsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeLocalGatewayVirtualInterfaceGroupsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeLocalGatewayVirtualInterfacesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeLocalGatewayVirtualInterfacesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeLockedSnapshotsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeLockedSnapshotsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeMacHostsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeMacHostsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeMacModificationTasksCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeMacModificationTasksResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeManagedPrefixListsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeManagedPrefixListsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeMovingAddressesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeMovingAddressesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeNatGatewaysCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeNatGatewaysResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeNetworkAclsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeNetworkAclsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeNetworkInsightsAccessScopeAnalysesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeNetworkInsightsAccessScopeAnalysesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeNetworkInsightsAccessScopesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeNetworkInsightsAccessScopesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeNetworkInsightsAnalysesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeNetworkInsightsAnalysesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeNetworkInsightsPathsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeNetworkInsightsPathsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeNetworkInterfaceAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeNetworkInterfaceAttributeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeNetworkInterfacePermissionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeNetworkInterfacePermissionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeNetworkInterfacesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeNetworkInterfacesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeOutpostLagsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeOutpostLagsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribePlacementGroupsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribePlacementGroupsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribePrefixListsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribePrefixListsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribePrincipalIdFormatCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribePrincipalIdFormatResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribePublicIpv4PoolsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribePublicIpv4PoolsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeRegionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeRegionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeReplaceRootVolumeTasksCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeReplaceRootVolumeTasksResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeReservedInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeReservedInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeReservedInstancesListingsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeReservedInstancesListingsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeReservedInstancesModificationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeReservedInstancesModificationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeReservedInstancesOfferingsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeReservedInstancesOfferingsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeRouteServerEndpointsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeRouteServerEndpointsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeRouteServerPeersCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeRouteServerPeersResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeRouteServersCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeRouteServersResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeRouteTablesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeRouteTablesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeScheduledInstanceAvailabilityCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeScheduledInstanceAvailabilityResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeScheduledInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeScheduledInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeSecurityGroupReferencesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeSecurityGroupReferencesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeSecurityGroupRulesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeSecurityGroupRulesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeSecurityGroupsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeSecurityGroupsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeSecurityGroupVpcAssociationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeSecurityGroupVpcAssociationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeServiceLinkVirtualInterfacesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeServiceLinkVirtualInterfacesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeSnapshotAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeSnapshotAttributeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeSnapshotsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeSnapshotsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeSnapshotTierStatusCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeSnapshotTierStatusResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeSpotDatafeedSubscriptionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeSpotDatafeedSubscriptionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeSpotFleetInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeSpotFleetInstancesResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeSpotFleetRequestHistoryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeSpotFleetRequestHistoryResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeSpotFleetRequestsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeSpotFleetRequestsResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeSpotInstanceRequestsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeSpotInstanceRequestsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeSpotPriceHistoryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeSpotPriceHistoryResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeStaleSecurityGroupsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeStaleSecurityGroupsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeStoreImageTasksCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeStoreImageTasksResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeSubnetsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeSubnetsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeTagsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeTagsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeTrafficMirrorFilterRulesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeTrafficMirrorFilterRulesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeTrafficMirrorFiltersCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeTrafficMirrorFiltersResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeTrafficMirrorSessionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeTrafficMirrorSessionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeTrafficMirrorTargetsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeTrafficMirrorTargetsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeTransitGatewayAttachmentsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeTransitGatewayAttachmentsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeTransitGatewayConnectPeersCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeTransitGatewayConnectPeersResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeTransitGatewayConnectsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeTransitGatewayConnectsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeTransitGatewayMulticastDomainsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeTransitGatewayMulticastDomainsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeTransitGatewayPeeringAttachmentsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeTransitGatewayPeeringAttachmentsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeTransitGatewayPolicyTablesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeTransitGatewayPolicyTablesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeTransitGatewayRouteTableAnnouncementsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeTransitGatewayRouteTableAnnouncementsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeTransitGatewayRouteTablesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeTransitGatewayRouteTablesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeTransitGatewaysCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeTransitGatewaysResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeTransitGatewayVpcAttachmentsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeTransitGatewayVpcAttachmentsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeTrunkInterfaceAssociationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeTrunkInterfaceAssociationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeVerifiedAccessEndpointsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeVerifiedAccessEndpointsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeVerifiedAccessGroupsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeVerifiedAccessGroupsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeVerifiedAccessInstanceLoggingConfigurationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeVerifiedAccessInstanceLoggingConfigurationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeVerifiedAccessInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeVerifiedAccessInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeVerifiedAccessTrustProvidersCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeVerifiedAccessTrustProvidersResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeVolumeAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeVolumeAttributeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeVolumesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeVolumesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeVolumesModificationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeVolumesModificationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeVolumeStatusCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeVolumeStatusResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeVpcAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeVpcAttributeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeVpcBlockPublicAccessExclusionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeVpcBlockPublicAccessExclusionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeVpcBlockPublicAccessOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeVpcBlockPublicAccessOptionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeVpcClassicLinkCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeVpcClassicLinkResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeVpcClassicLinkDnsSupportCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeVpcClassicLinkDnsSupportResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeVpcEndpointAssociationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeVpcEndpointAssociationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeVpcEndpointConnectionNotificationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeVpcEndpointConnectionNotificationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeVpcEndpointConnectionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeVpcEndpointConnectionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeVpcEndpointsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeVpcEndpointsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeVpcEndpointServiceConfigurationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeVpcEndpointServiceConfigurationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeVpcEndpointServicePermissionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeVpcEndpointServicePermissionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeVpcEndpointServicesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeVpcEndpointServicesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeVpcPeeringConnectionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeVpcPeeringConnectionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeVpcsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeVpcsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeVpnConnectionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeVpnConnectionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeVpnGatewaysCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeVpnGatewaysResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DetachClassicLinkVpcCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DetachClassicLinkVpcResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DetachInternetGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DetachNetworkInterfaceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DetachVerifiedAccessTrustProviderCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DetachVerifiedAccessTrustProviderResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DetachVolumeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_VolumeAttachment(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DetachVpnGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DisableAddressTransferCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisableAddressTransferResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisableAllowedImagesSettingsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisableAllowedImagesSettingsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisableAwsNetworkPerformanceMetricSubscriptionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisableAwsNetworkPerformanceMetricSubscriptionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisableEbsEncryptionByDefaultCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisableEbsEncryptionByDefaultResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisableFastLaunchCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisableFastLaunchResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisableFastSnapshotRestoresCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisableFastSnapshotRestoresResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisableImageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisableImageResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisableImageBlockPublicAccessCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisableImageBlockPublicAccessResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisableImageDeprecationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisableImageDeprecationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisableImageDeregistrationProtectionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisableImageDeregistrationProtectionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisableIpamOrganizationAdminAccountCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisableIpamOrganizationAdminAccountResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisableRouteServerPropagationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisableRouteServerPropagationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisableSerialConsoleAccessCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisableSerialConsoleAccessResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisableSnapshotBlockPublicAccessCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisableSnapshotBlockPublicAccessResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisableTransitGatewayRouteTablePropagationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisableTransitGatewayRouteTablePropagationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisableVgwRoutePropagationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DisableVpcClassicLinkCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisableVpcClassicLinkResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisableVpcClassicLinkDnsSupportCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisableVpcClassicLinkDnsSupportResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisassociateAddressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DisassociateCapacityReservationBillingOwnerCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisassociateCapacityReservationBillingOwnerResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisassociateClientVpnTargetNetworkCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisassociateClientVpnTargetNetworkResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisassociateEnclaveCertificateIamRoleCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisassociateEnclaveCertificateIamRoleResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisassociateIamInstanceProfileCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisassociateIamInstanceProfileResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisassociateInstanceEventWindowCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisassociateInstanceEventWindowResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisassociateIpamByoasnCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisassociateIpamByoasnResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisassociateIpamResourceDiscoveryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisassociateIpamResourceDiscoveryResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisassociateNatGatewayAddressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisassociateNatGatewayAddressResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisassociateRouteServerCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisassociateRouteServerResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisassociateRouteTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DisassociateSecurityGroupVpcCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisassociateSecurityGroupVpcResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisassociateSubnetCidrBlockCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisassociateSubnetCidrBlockResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisassociateTransitGatewayMulticastDomainCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisassociateTransitGatewayMulticastDomainResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisassociateTransitGatewayPolicyTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisassociateTransitGatewayPolicyTableResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisassociateTransitGatewayRouteTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisassociateTransitGatewayRouteTableResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisassociateTrunkInterfaceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisassociateTrunkInterfaceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisassociateVpcCidrBlockCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisassociateVpcCidrBlockResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_EnableAddressTransferCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_EnableAddressTransferResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_EnableAllowedImagesSettingsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_EnableAllowedImagesSettingsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_EnableAwsNetworkPerformanceMetricSubscriptionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_EnableAwsNetworkPerformanceMetricSubscriptionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_EnableEbsEncryptionByDefaultCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_EnableEbsEncryptionByDefaultResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_EnableFastLaunchCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_EnableFastLaunchResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_EnableFastSnapshotRestoresCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_EnableFastSnapshotRestoresResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_EnableImageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_EnableImageResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_EnableImageBlockPublicAccessCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_EnableImageBlockPublicAccessResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_EnableImageDeprecationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_EnableImageDeprecationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_EnableImageDeregistrationProtectionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_EnableImageDeregistrationProtectionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_EnableIpamOrganizationAdminAccountCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_EnableIpamOrganizationAdminAccountResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_EnableReachabilityAnalyzerOrganizationSharingCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_EnableReachabilityAnalyzerOrganizationSharingResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_EnableRouteServerPropagationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_EnableRouteServerPropagationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_EnableSerialConsoleAccessCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_EnableSerialConsoleAccessResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_EnableSnapshotBlockPublicAccessCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_EnableSnapshotBlockPublicAccessResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_EnableTransitGatewayRouteTablePropagationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_EnableTransitGatewayRouteTablePropagationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_EnableVgwRoutePropagationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_EnableVolumeIOCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_EnableVpcClassicLinkCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_EnableVpcClassicLinkResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_EnableVpcClassicLinkDnsSupportCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_EnableVpcClassicLinkDnsSupportResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ExportClientVpnClientCertificateRevocationListCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ExportClientVpnClientCertificateRevocationListResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ExportClientVpnClientConfigurationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ExportClientVpnClientConfigurationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ExportImageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ExportImageResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ExportTransitGatewayRoutesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ExportTransitGatewayRoutesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ExportVerifiedAccessInstanceClientConfigurationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ExportVerifiedAccessInstanceClientConfigurationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetActiveVpnTunnelStatusCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetActiveVpnTunnelStatusResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetAllowedImagesSettingsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetAllowedImagesSettingsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetAssociatedEnclaveCertificateIamRolesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetAssociatedEnclaveCertificateIamRolesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetAssociatedIpv6PoolCidrsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetAssociatedIpv6PoolCidrsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetAwsNetworkPerformanceDataCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetAwsNetworkPerformanceDataResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetCapacityReservationUsageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetCapacityReservationUsageResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetCoipPoolUsageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetCoipPoolUsageResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetConsoleOutputCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetConsoleOutputResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetConsoleScreenshotCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetConsoleScreenshotResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetDeclarativePoliciesReportSummaryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetDeclarativePoliciesReportSummaryResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetDefaultCreditSpecificationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetDefaultCreditSpecificationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetEbsDefaultKmsKeyIdCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetEbsDefaultKmsKeyIdResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetEbsEncryptionByDefaultCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetEbsEncryptionByDefaultResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetFlowLogsIntegrationTemplateCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetFlowLogsIntegrationTemplateResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetGroupsForCapacityReservationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetGroupsForCapacityReservationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetHostReservationPurchasePreviewCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetHostReservationPurchasePreviewResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetImageBlockPublicAccessStateCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetImageBlockPublicAccessStateResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetInstanceMetadataDefaultsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetInstanceMetadataDefaultsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetInstanceTpmEkPubCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetInstanceTpmEkPubResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetInstanceTypesFromInstanceRequirementsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetInstanceTypesFromInstanceRequirementsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetInstanceUefiDataCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetInstanceUefiDataResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetIpamAddressHistoryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetIpamAddressHistoryResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetIpamDiscoveredAccountsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetIpamDiscoveredAccountsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetIpamDiscoveredPublicAddressesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetIpamDiscoveredPublicAddressesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetIpamDiscoveredResourceCidrsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetIpamDiscoveredResourceCidrsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetIpamPoolAllocationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetIpamPoolAllocationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetIpamPoolCidrsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetIpamPoolCidrsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetIpamResourceCidrsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetIpamResourceCidrsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetLaunchTemplateDataCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetLaunchTemplateDataResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetManagedPrefixListAssociationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetManagedPrefixListAssociationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetManagedPrefixListEntriesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetManagedPrefixListEntriesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetNetworkInsightsAccessScopeAnalysisFindingsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetNetworkInsightsAccessScopeAnalysisFindingsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetNetworkInsightsAccessScopeContentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetNetworkInsightsAccessScopeContentResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetPasswordDataCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetPasswordDataResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetReservedInstancesExchangeQuoteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetReservedInstancesExchangeQuoteResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetRouteServerAssociationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetRouteServerAssociationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetRouteServerPropagationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetRouteServerPropagationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetRouteServerRoutingDatabaseCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetRouteServerRoutingDatabaseResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetSecurityGroupsForVpcCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetSecurityGroupsForVpcResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetSerialConsoleAccessStatusCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetSerialConsoleAccessStatusResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetSnapshotBlockPublicAccessStateCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetSnapshotBlockPublicAccessStateResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetSpotPlacementScoresCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetSpotPlacementScoresResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetSubnetCidrReservationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetSubnetCidrReservationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetTransitGatewayAttachmentPropagationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetTransitGatewayAttachmentPropagationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetTransitGatewayMulticastDomainAssociationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetTransitGatewayMulticastDomainAssociationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetTransitGatewayPolicyTableAssociationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetTransitGatewayPolicyTableAssociationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetTransitGatewayPolicyTableEntriesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetTransitGatewayPolicyTableEntriesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetTransitGatewayPrefixListReferencesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetTransitGatewayPrefixListReferencesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetTransitGatewayRouteTableAssociationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetTransitGatewayRouteTableAssociationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetTransitGatewayRouteTablePropagationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetTransitGatewayRouteTablePropagationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetVerifiedAccessEndpointPolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetVerifiedAccessEndpointPolicyResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetVerifiedAccessEndpointTargetsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetVerifiedAccessEndpointTargetsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetVerifiedAccessGroupPolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetVerifiedAccessGroupPolicyResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetVpnConnectionDeviceSampleConfigurationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetVpnConnectionDeviceSampleConfigurationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetVpnConnectionDeviceTypesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetVpnConnectionDeviceTypesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_GetVpnTunnelReplacementStatusCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetVpnTunnelReplacementStatusResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ImportClientVpnClientCertificateRevocationListCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ImportClientVpnClientCertificateRevocationListResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ImportImageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ImportImageResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ImportInstanceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ImportInstanceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ImportKeyPairCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ImportKeyPairResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ImportSnapshotCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ImportSnapshotResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ImportVolumeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ImportVolumeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ListImagesInRecycleBinCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ListImagesInRecycleBinResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ListSnapshotsInRecycleBinCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ListSnapshotsInRecycleBinResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_LockSnapshotCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_LockSnapshotResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyAddressAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyAddressAttributeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyAvailabilityZoneGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyAvailabilityZoneGroupResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyCapacityReservationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyCapacityReservationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyCapacityReservationFleetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyCapacityReservationFleetResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyClientVpnEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyClientVpnEndpointResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyDefaultCreditSpecificationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyDefaultCreditSpecificationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyEbsDefaultKmsKeyIdCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyEbsDefaultKmsKeyIdResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyFleetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyFleetResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyFpgaImageAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyFpgaImageAttributeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyHostsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyHostsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyIdentityIdFormatCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_ModifyIdFormatCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_ModifyImageAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_ModifyInstanceAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_ModifyInstanceCapacityReservationAttributesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyInstanceCapacityReservationAttributesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyInstanceConnectEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyInstanceConnectEndpointResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyInstanceCpuOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyInstanceCpuOptionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyInstanceCreditSpecificationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyInstanceCreditSpecificationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyInstanceEventStartTimeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyInstanceEventStartTimeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyInstanceEventWindowCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyInstanceEventWindowResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyInstanceMaintenanceOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyInstanceMaintenanceOptionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyInstanceMetadataDefaultsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyInstanceMetadataDefaultsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyInstanceMetadataOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyInstanceMetadataOptionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyInstanceNetworkPerformanceOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyInstanceNetworkPerformanceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyInstancePlacementCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyInstancePlacementResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyIpamCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyIpamResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyIpamPoolCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyIpamPoolResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyIpamResourceCidrCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyIpamResourceCidrResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyIpamResourceDiscoveryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyIpamResourceDiscoveryResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyIpamScopeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyIpamScopeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyLaunchTemplateCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyLaunchTemplateResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyLocalGatewayRouteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyLocalGatewayRouteResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyManagedPrefixListCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyManagedPrefixListResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyNetworkInterfaceAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_ModifyPrivateDnsNameOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyPrivateDnsNameOptionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyPublicIpDnsNameOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyPublicIpDnsNameOptionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyReservedInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyReservedInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyRouteServerCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyRouteServerResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifySecurityGroupRulesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifySecurityGroupRulesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifySnapshotAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_ModifySnapshotTierCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifySnapshotTierResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifySpotFleetRequestCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifySpotFleetRequestResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifySubnetAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_ModifyTrafficMirrorFilterNetworkServicesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyTrafficMirrorFilterNetworkServicesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyTrafficMirrorFilterRuleCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyTrafficMirrorFilterRuleResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyTrafficMirrorSessionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyTrafficMirrorSessionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyTransitGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyTransitGatewayResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyTransitGatewayPrefixListReferenceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyTransitGatewayPrefixListReferenceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyTransitGatewayVpcAttachmentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyTransitGatewayVpcAttachmentResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyVerifiedAccessEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyVerifiedAccessEndpointResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyVerifiedAccessEndpointPolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyVerifiedAccessEndpointPolicyResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyVerifiedAccessGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyVerifiedAccessGroupResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyVerifiedAccessGroupPolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyVerifiedAccessGroupPolicyResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyVerifiedAccessInstanceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyVerifiedAccessInstanceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyVerifiedAccessInstanceLoggingConfigurationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyVerifiedAccessInstanceLoggingConfigurationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyVerifiedAccessTrustProviderCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyVerifiedAccessTrustProviderResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyVolumeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyVolumeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyVolumeAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_ModifyVpcAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_ModifyVpcBlockPublicAccessExclusionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyVpcBlockPublicAccessExclusionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyVpcBlockPublicAccessOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyVpcBlockPublicAccessOptionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyVpcEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyVpcEndpointResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyVpcEndpointConnectionNotificationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyVpcEndpointConnectionNotificationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyVpcEndpointServiceConfigurationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyVpcEndpointServiceConfigurationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyVpcEndpointServicePayerResponsibilityCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyVpcEndpointServicePayerResponsibilityResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyVpcEndpointServicePermissionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyVpcEndpointServicePermissionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyVpcPeeringConnectionOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyVpcPeeringConnectionOptionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyVpcTenancyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyVpcTenancyResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyVpnConnectionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyVpnConnectionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyVpnConnectionOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyVpnConnectionOptionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyVpnTunnelCertificateCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyVpnTunnelCertificateResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyVpnTunnelOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyVpnTunnelOptionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_MonitorInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_MonitorInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_MoveAddressToVpcCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_MoveAddressToVpcResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_MoveByoipCidrToIpamCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_MoveByoipCidrToIpamResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_MoveCapacityReservationInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_MoveCapacityReservationInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ProvisionByoipCidrCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ProvisionByoipCidrResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ProvisionIpamByoasnCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ProvisionIpamByoasnResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ProvisionIpamPoolCidrCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ProvisionIpamPoolCidrResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ProvisionPublicIpv4PoolCidrCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ProvisionPublicIpv4PoolCidrResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_PurchaseCapacityBlockCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_PurchaseCapacityBlockResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_PurchaseCapacityBlockExtensionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_PurchaseCapacityBlockExtensionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_PurchaseHostReservationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_PurchaseHostReservationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_PurchaseReservedInstancesOfferingCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_PurchaseReservedInstancesOfferingResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_PurchaseScheduledInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_PurchaseScheduledInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RebootInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_RegisterImageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RegisterImageResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RegisterInstanceEventNotificationAttributesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RegisterInstanceEventNotificationAttributesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RegisterTransitGatewayMulticastGroupMembersCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RegisterTransitGatewayMulticastGroupMembersResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RegisterTransitGatewayMulticastGroupSourcesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RegisterTransitGatewayMulticastGroupSourcesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RejectCapacityReservationBillingOwnershipCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RejectCapacityReservationBillingOwnershipResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RejectTransitGatewayMulticastDomainAssociationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RejectTransitGatewayMulticastDomainAssociationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RejectTransitGatewayPeeringAttachmentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RejectTransitGatewayPeeringAttachmentResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RejectTransitGatewayVpcAttachmentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RejectTransitGatewayVpcAttachmentResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RejectVpcEndpointConnectionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RejectVpcEndpointConnectionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RejectVpcPeeringConnectionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RejectVpcPeeringConnectionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ReleaseAddressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_ReleaseHostsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ReleaseHostsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ReleaseIpamPoolAllocationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ReleaseIpamPoolAllocationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ReplaceIamInstanceProfileAssociationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ReplaceIamInstanceProfileAssociationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ReplaceImageCriteriaInAllowedImagesSettingsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ReplaceImageCriteriaInAllowedImagesSettingsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ReplaceNetworkAclAssociationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ReplaceNetworkAclAssociationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ReplaceNetworkAclEntryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_ReplaceRouteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_ReplaceRouteTableAssociationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ReplaceRouteTableAssociationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ReplaceTransitGatewayRouteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ReplaceTransitGatewayRouteResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ReplaceVpnTunnelCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ReplaceVpnTunnelResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ReportInstanceStatusCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_RequestSpotFleetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RequestSpotFleetResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RequestSpotInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RequestSpotInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ResetAddressAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ResetAddressAttributeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ResetEbsDefaultKmsKeyIdCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ResetEbsDefaultKmsKeyIdResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ResetFpgaImageAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ResetFpgaImageAttributeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ResetImageAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_ResetInstanceAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_ResetNetworkInterfaceAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_ResetSnapshotAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_RestoreAddressToClassicCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RestoreAddressToClassicResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RestoreImageFromRecycleBinCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RestoreImageFromRecycleBinResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RestoreManagedPrefixListVersionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RestoreManagedPrefixListVersionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RestoreSnapshotFromRecycleBinCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RestoreSnapshotFromRecycleBinResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RestoreSnapshotTierCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RestoreSnapshotTierResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RevokeClientVpnIngressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RevokeClientVpnIngressResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RevokeSecurityGroupEgressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RevokeSecurityGroupEgressResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RevokeSecurityGroupIngressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RevokeSecurityGroupIngressResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RunInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_Reservation(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RunScheduledInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RunScheduledInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_SearchLocalGatewayRoutesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_SearchLocalGatewayRoutesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_SearchTransitGatewayMulticastGroupsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_SearchTransitGatewayMulticastGroupsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_SearchTransitGatewayRoutesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_SearchTransitGatewayRoutesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_SendDiagnosticInterruptCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_StartDeclarativePoliciesReportCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_StartDeclarativePoliciesReportResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_StartInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_StartInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_StartNetworkInsightsAccessScopeAnalysisCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_StartNetworkInsightsAccessScopeAnalysisResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_StartNetworkInsightsAnalysisCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_StartNetworkInsightsAnalysisResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_StartVpcEndpointServicePrivateDnsVerificationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_StartVpcEndpointServicePrivateDnsVerificationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_StopInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_StopInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_TerminateClientVpnConnectionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_TerminateClientVpnConnectionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_TerminateInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_TerminateInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_UnassignIpv6AddressesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_UnassignIpv6AddressesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_UnassignPrivateIpAddressesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_UnassignPrivateNatGatewayAddressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_UnassignPrivateNatGatewayAddressResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_UnlockSnapshotCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_UnlockSnapshotResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_UnmonitorInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_UnmonitorInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_UpdateSecurityGroupRuleDescriptionsEgressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_UpdateSecurityGroupRuleDescriptionsEgressResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_UpdateSecurityGroupRuleDescriptionsIngressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_UpdateSecurityGroupRuleDescriptionsIngressResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_WithdrawByoipCidrCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_WithdrawByoipCidrResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_CommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    return throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        errorCode,
    });
};
const se_AcceleratorCount = (input, context) => {
    const entries = {};
    if (input[_M] != null) {
        entries[_M] = input[_M];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_AcceleratorCountRequest = (input, context) => {
    const entries = {};
    if (input[_M] != null) {
        entries[_M] = input[_M];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_AcceleratorManufacturerSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_AcceleratorNameSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_AcceleratorTotalMemoryMiB = (input, context) => {
    const entries = {};
    if (input[_M] != null) {
        entries[_M] = input[_M];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_AcceleratorTotalMemoryMiBRequest = (input, context) => {
    const entries = {};
    if (input[_M] != null) {
        entries[_M] = input[_M];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_AcceleratorTypeSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_AcceptAddressTransferRequest = (input, context) => {
    const entries = {};
    if (input[_Ad] != null) {
        entries[_Ad] = input[_Ad];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_AcceptCapacityReservationBillingOwnershipRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_CRI] != null) {
        entries[_CRI] = input[_CRI];
    }
    return entries;
};
const se_AcceptReservedInstancesExchangeQuoteRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_RII] != null) {
        const memberEntries = se_ReservedInstanceIdSet(input[_RII], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ReservedInstanceId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_TC] != null) {
        const memberEntries = se_TargetConfigurationRequestSet(input[_TC], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TargetConfiguration.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_AcceptTransitGatewayMulticastDomainAssociationsRequest = (input, context) => {
    const entries = {};
    if (input[_TGMDI] != null) {
        entries[_TGMDI] = input[_TGMDI];
    }
    if (input[_TGAI] != null) {
        entries[_TGAI] = input[_TGAI];
    }
    if (input[_SIu] != null) {
        const memberEntries = se_ValueStringList(input[_SIu], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SubnetIds.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_AcceptTransitGatewayPeeringAttachmentRequest = (input, context) => {
    const entries = {};
    if (input[_TGAI] != null) {
        entries[_TGAI] = input[_TGAI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_AcceptTransitGatewayVpcAttachmentRequest = (input, context) => {
    const entries = {};
    if (input[_TGAI] != null) {
        entries[_TGAI] = input[_TGAI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_AcceptVpcEndpointConnectionsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_SIe] != null) {
        entries[_SIe] = input[_SIe];
    }
    if (input[_VEI] != null) {
        const memberEntries = se_VpcEndpointIdList(input[_VEI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpcEndpointId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_AcceptVpcPeeringConnectionRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_VPCI] != null) {
        entries[_VPCI] = input[_VPCI];
    }
    return entries;
};
const se_AccessScopePathListRequest = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_AccessScopePathRequest(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Item.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_AccessScopePathRequest = (input, context) => {
    const entries = {};
    if (input[_S] != null) {
        const memberEntries = se_PathStatementRequest(input[_S], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Source.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_D] != null) {
        const memberEntries = se_PathStatementRequest(input[_D], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Destination.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_TR] != null) {
        const memberEntries = se_ThroughResourcesStatementRequestList(input[_TR], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ThroughResource.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_AccountAttributeNameStringList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`AttributeName.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_AddIpamOperatingRegion = (input, context) => {
    const entries = {};
    if (input[_RN] != null) {
        entries[_RN] = input[_RN];
    }
    return entries;
};
const se_AddIpamOperatingRegionSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_AddIpamOperatingRegion(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Member.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_AddIpamOrganizationalUnitExclusion = (input, context) => {
    const entries = {};
    if (input[_OEP] != null) {
        entries[_OEP] = input[_OEP];
    }
    return entries;
};
const se_AddIpamOrganizationalUnitExclusionSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_AddIpamOrganizationalUnitExclusion(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Member.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_AddPrefixListEntries = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_AddPrefixListEntry(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Member.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_AddPrefixListEntry = (input, context) => {
    const entries = {};
    if (input[_C] != null) {
        entries[_C] = input[_C];
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    return entries;
};
const se_AdvertiseByoipCidrRequest = (input, context) => {
    const entries = {};
    if (input[_C] != null) {
        entries[_C] = input[_C];
    }
    if (input[_As] != null) {
        entries[_As] = input[_As];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_NBG] != null) {
        entries[_NBG] = input[_NBG];
    }
    return entries;
};
const se_AllocateAddressRequest = (input, context) => {
    const entries = {};
    if (input[_Do] != null) {
        entries[_Do] = input[_Do];
    }
    if (input[_Ad] != null) {
        entries[_Ad] = input[_Ad];
    }
    if (input[_PIP] != null) {
        entries[_PIP] = input[_PIP];
    }
    if (input[_NBG] != null) {
        entries[_NBG] = input[_NBG];
    }
    if (input[_COIP] != null) {
        entries[_COIP] = input[_COIP];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_IPI] != null) {
        entries[_IPI] = input[_IPI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_AllocateHostsRequest = (input, context) => {
    const entries = {};
    if (input[_IF] != null) {
        entries[_IF] = input[_IF];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_HR] != null) {
        entries[_HR] = input[_HR];
    }
    if (input[_OA] != null) {
        entries[_OA] = input[_OA];
    }
    if (input[_HM] != null) {
        entries[_HM] = input[_HM];
    }
    if (input[_AI] != null) {
        const memberEntries = se_AssetIdList(input[_AI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `AssetId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_AZI] != null) {
        entries[_AZI] = input[_AZI];
    }
    if (input[_AP] != null) {
        entries[_AP] = input[_AP];
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_IT] != null) {
        entries[_IT] = input[_IT];
    }
    if (input[_Q] != null) {
        entries[_Q] = input[_Q];
    }
    if (input[_AZ] != null) {
        entries[_AZ] = input[_AZ];
    }
    return entries;
};
const se_AllocateIpamPoolCidrRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IPI] != null) {
        entries[_IPI] = input[_IPI];
    }
    if (input[_C] != null) {
        entries[_C] = input[_C];
    }
    if (input[_NL] != null) {
        entries[_NL] = input[_NL];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_PNC] != null) {
        entries[_PNC] = input[_PNC];
    }
    if (input[_AC] != null) {
        const memberEntries = se_IpamPoolAllocationAllowedCidrs(input[_AC], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `AllowedCidr.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DC] != null) {
        const memberEntries = se_IpamPoolAllocationDisallowedCidrs(input[_DC], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DisallowedCidr.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_AllocationIdList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`AllocationId.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_AllocationIds = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_AllowedInstanceTypeSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_ApplySecurityGroupsToClientVpnTargetNetworkRequest = (input, context) => {
    const entries = {};
    if (input[_CVEI] != null) {
        entries[_CVEI] = input[_CVEI];
    }
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    if (input[_SGI] != null) {
        const memberEntries = se_ClientVpnSecurityGroupIdSet(input[_SGI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SecurityGroupId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_ArchitectureTypeSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_ArnList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_AsnAuthorizationContext = (input, context) => {
    const entries = {};
    if (input[_Me] != null) {
        entries[_Me] = input[_Me];
    }
    if (input[_Si] != null) {
        entries[_Si] = input[_Si];
    }
    return entries;
};
const se_AssetIdList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Member.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_AssignIpv6AddressesRequest = (input, context) => {
    const entries = {};
    if (input[_IPC] != null) {
        entries[_IPC] = input[_IPC];
    }
    if (input[_IP] != null) {
        const memberEntries = se_IpPrefixList(input[_IP], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Ipv6Prefix.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NII] != null) {
        entries[_NII] = input[_NII];
    }
    if (input[_IA] != null) {
        const memberEntries = se_Ipv6AddressList(input[_IA], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Ipv6Addresses.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_IAC] != null) {
        entries[_IAC] = input[_IAC];
    }
    return entries;
};
const se_AssignPrivateIpAddressesRequest = (input, context) => {
    const entries = {};
    if (input[_IPp] != null) {
        const memberEntries = se_IpPrefixList(input[_IPp], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Ipv4Prefix.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_IPCp] != null) {
        entries[_IPCp] = input[_IPCp];
    }
    if (input[_NII] != null) {
        entries[_NII] = input[_NII];
    }
    if (input[_PIA] != null) {
        const memberEntries = se_PrivateIpAddressStringList(input[_PIA], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `PrivateIpAddress.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_SPIAC] != null) {
        entries[_SPIAC] = input[_SPIAC];
    }
    if (input[_AR] != null) {
        entries[_AR] = input[_AR];
    }
    return entries;
};
const se_AssignPrivateNatGatewayAddressRequest = (input, context) => {
    const entries = {};
    if (input[_NGI] != null) {
        entries[_NGI] = input[_NGI];
    }
    if (input[_PIA] != null) {
        const memberEntries = se_IpList(input[_PIA], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `PrivateIpAddress.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_PIAC] != null) {
        entries[_PIAC] = input[_PIAC];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_AssociateAddressRequest = (input, context) => {
    const entries = {};
    if (input[_AIl] != null) {
        entries[_AIl] = input[_AIl];
    }
    if (input[_IIn] != null) {
        entries[_IIn] = input[_IIn];
    }
    if (input[_PI] != null) {
        entries[_PI] = input[_PI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_NII] != null) {
        entries[_NII] = input[_NII];
    }
    if (input[_PIAr] != null) {
        entries[_PIAr] = input[_PIAr];
    }
    if (input[_ARl] != null) {
        entries[_ARl] = input[_ARl];
    }
    return entries;
};
const se_AssociateCapacityReservationBillingOwnerRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_CRI] != null) {
        entries[_CRI] = input[_CRI];
    }
    if (input[_URBOI] != null) {
        entries[_URBOI] = input[_URBOI];
    }
    return entries;
};
const se_AssociateClientVpnTargetNetworkRequest = (input, context) => {
    const entries = {};
    if (input[_CVEI] != null) {
        entries[_CVEI] = input[_CVEI];
    }
    if (input[_SIub] != null) {
        entries[_SIub] = input[_SIub];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_AssociateDhcpOptionsRequest = (input, context) => {
    const entries = {};
    if (input[_DOI] != null) {
        entries[_DOI] = input[_DOI];
    }
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_AssociateEnclaveCertificateIamRoleRequest = (input, context) => {
    const entries = {};
    if (input[_CA] != null) {
        entries[_CA] = input[_CA];
    }
    if (input[_RAo] != null) {
        entries[_RAo] = input[_RAo];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_AssociateIamInstanceProfileRequest = (input, context) => {
    const entries = {};
    if (input[_IIP] != null) {
        const memberEntries = se_IamInstanceProfileSpecification(input[_IIP], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `IamInstanceProfile.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_IIn] != null) {
        entries[_IIn] = input[_IIn];
    }
    return entries;
};
const se_AssociateInstanceEventWindowRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IEWI] != null) {
        entries[_IEWI] = input[_IEWI];
    }
    if (input[_AT] != null) {
        const memberEntries = se_InstanceEventWindowAssociationRequest(input[_AT], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `AssociationTarget.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_AssociateIpamByoasnRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_As] != null) {
        entries[_As] = input[_As];
    }
    if (input[_C] != null) {
        entries[_C] = input[_C];
    }
    return entries;
};
const se_AssociateIpamResourceDiscoveryRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IIp] != null) {
        entries[_IIp] = input[_IIp];
    }
    if (input[_IRDI] != null) {
        entries[_IRDI] = input[_IRDI];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    return entries;
};
const se_AssociateNatGatewayAddressRequest = (input, context) => {
    const entries = {};
    if (input[_NGI] != null) {
        entries[_NGI] = input[_NGI];
    }
    if (input[_AIll] != null) {
        const memberEntries = se_AllocationIdList(input[_AIll], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `AllocationId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_PIA] != null) {
        const memberEntries = se_IpList(input[_PIA], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `PrivateIpAddress.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_AssociateRouteServerRequest = (input, context) => {
    const entries = {};
    if (input[_RSIo] != null) {
        entries[_RSIo] = input[_RSIo];
    }
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_AssociateRouteTableRequest = (input, context) => {
    const entries = {};
    if (input[_GI] != null) {
        entries[_GI] = input[_GI];
    }
    if (input[_PIP] != null) {
        entries[_PIP] = input[_PIP];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_SIub] != null) {
        entries[_SIub] = input[_SIub];
    }
    if (input[_RTI] != null) {
        entries[_RTI] = input[_RTI];
    }
    return entries;
};
const se_AssociateSecurityGroupVpcRequest = (input, context) => {
    const entries = {};
    if (input[_GIr] != null) {
        entries[_GIr] = input[_GIr];
    }
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_AssociateSubnetCidrBlockRequest = (input, context) => {
    const entries = {};
    if (input[_IIPI] != null) {
        entries[_IIPI] = input[_IIPI];
    }
    if (input[_INL] != null) {
        entries[_INL] = input[_INL];
    }
    if (input[_SIub] != null) {
        entries[_SIub] = input[_SIub];
    }
    if (input[_ICB] != null) {
        entries[_ICB] = input[_ICB];
    }
    return entries;
};
const se_AssociateTransitGatewayMulticastDomainRequest = (input, context) => {
    const entries = {};
    if (input[_TGMDI] != null) {
        entries[_TGMDI] = input[_TGMDI];
    }
    if (input[_TGAI] != null) {
        entries[_TGAI] = input[_TGAI];
    }
    if (input[_SIu] != null) {
        const memberEntries = se_TransitGatewaySubnetIdList(input[_SIu], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SubnetIds.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_AssociateTransitGatewayPolicyTableRequest = (input, context) => {
    const entries = {};
    if (input[_TGPTI] != null) {
        entries[_TGPTI] = input[_TGPTI];
    }
    if (input[_TGAI] != null) {
        entries[_TGAI] = input[_TGAI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_AssociateTransitGatewayRouteTableRequest = (input, context) => {
    const entries = {};
    if (input[_TGRTI] != null) {
        entries[_TGRTI] = input[_TGRTI];
    }
    if (input[_TGAI] != null) {
        entries[_TGAI] = input[_TGAI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_AssociateTrunkInterfaceRequest = (input, context) => {
    const entries = {};
    if (input[_BII] != null) {
        entries[_BII] = input[_BII];
    }
    if (input[_TII] != null) {
        entries[_TII] = input[_TII];
    }
    if (input[_VIl] != null) {
        entries[_VIl] = input[_VIl];
    }
    if (input[_GK] != null) {
        entries[_GK] = input[_GK];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_AssociateVpcCidrBlockRequest = (input, context) => {
    const entries = {};
    if (input[_CB] != null) {
        entries[_CB] = input[_CB];
    }
    if (input[_ICBNBG] != null) {
        entries[_ICBNBG] = input[_ICBNBG];
    }
    if (input[_IPpv] != null) {
        entries[_IPpv] = input[_IPpv];
    }
    if (input[_ICB] != null) {
        entries[_ICB] = input[_ICB];
    }
    if (input[_IIPIp] != null) {
        entries[_IIPIp] = input[_IIPIp];
    }
    if (input[_INLp] != null) {
        entries[_INLp] = input[_INLp];
    }
    if (input[_IIPI] != null) {
        entries[_IIPI] = input[_IIPI];
    }
    if (input[_INL] != null) {
        entries[_INL] = input[_INL];
    }
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    if (input[_APICB] != null) {
        entries[_APICB] = input[_APICB];
    }
    return entries;
};
const se_AssociationIdList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`AssociationId.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_AthenaIntegration = (input, context) => {
    const entries = {};
    if (input[_IRSDA] != null) {
        entries[_IRSDA] = input[_IRSDA];
    }
    if (input[_PLF] != null) {
        entries[_PLF] = input[_PLF];
    }
    if (input[_PSD] != null) {
        entries[_PSD] = __serializeDateTime(input[_PSD]);
    }
    if (input[_PED] != null) {
        entries[_PED] = __serializeDateTime(input[_PED]);
    }
    return entries;
};
const se_AthenaIntegrationsSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_AthenaIntegration(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Item.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_AttachClassicLinkVpcRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IIn] != null) {
        entries[_IIn] = input[_IIn];
    }
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    if (input[_G] != null) {
        const memberEntries = se_GroupIdStringList(input[_G], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SecurityGroupId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_AttachInternetGatewayRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IGI] != null) {
        entries[_IGI] = input[_IGI];
    }
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    return entries;
};
const se_AttachNetworkInterfaceRequest = (input, context) => {
    const entries = {};
    if (input[_NCI] != null) {
        entries[_NCI] = input[_NCI];
    }
    if (input[_ESS] != null) {
        const memberEntries = se_EnaSrdSpecification(input[_ESS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `EnaSrdSpecification.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_EQC] != null) {
        entries[_EQC] = input[_EQC];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_NII] != null) {
        entries[_NII] = input[_NII];
    }
    if (input[_IIn] != null) {
        entries[_IIn] = input[_IIn];
    }
    if (input[_DIev] != null) {
        entries[_DIev] = input[_DIev];
    }
    return entries;
};
const se_AttachVerifiedAccessTrustProviderRequest = (input, context) => {
    const entries = {};
    if (input[_VAII] != null) {
        entries[_VAII] = input[_VAII];
    }
    if (input[_VATPI] != null) {
        entries[_VATPI] = input[_VATPI];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_AttachVolumeRequest = (input, context) => {
    const entries = {};
    if (input[_Dev] != null) {
        entries[_Dev] = input[_Dev];
    }
    if (input[_IIn] != null) {
        entries[_IIn] = input[_IIn];
    }
    if (input[_VIo] != null) {
        entries[_VIo] = input[_VIo];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_AttachVpnGatewayRequest = (input, context) => {
    const entries = {};
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    if (input[_VGI] != null) {
        entries[_VGI] = input[_VGI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_AttributeBooleanValue = (input, context) => {
    const entries = {};
    if (input[_Va] != null) {
        entries[_Va] = input[_Va];
    }
    return entries;
};
const se_AttributeValue = (input, context) => {
    const entries = {};
    if (input[_Va] != null) {
        entries[_Va] = input[_Va];
    }
    return entries;
};
const se_AuthorizeClientVpnIngressRequest = (input, context) => {
    const entries = {};
    if (input[_CVEI] != null) {
        entries[_CVEI] = input[_CVEI];
    }
    if (input[_TNC] != null) {
        entries[_TNC] = input[_TNC];
    }
    if (input[_AGI] != null) {
        entries[_AGI] = input[_AGI];
    }
    if (input[_AAG] != null) {
        entries[_AAG] = input[_AAG];
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_AuthorizeSecurityGroupEgressRequest = (input, context) => {
    const entries = {};
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_GIr] != null) {
        entries[_GIr] = input[_GIr];
    }
    if (input[_SSGN] != null) {
        entries[_SSGN] = input[_SSGN];
    }
    if (input[_SSGOI] != null) {
        entries[_SSGOI] = input[_SSGOI];
    }
    if (input[_IPpr] != null) {
        entries[_IPpr] = input[_IPpr];
    }
    if (input[_FP] != null) {
        entries[_FP] = input[_FP];
    }
    if (input[_TP] != null) {
        entries[_TP] = input[_TP];
    }
    if (input[_CIi] != null) {
        entries[_CIi] = input[_CIi];
    }
    if (input[_IPpe] != null) {
        const memberEntries = se_IpPermissionList(input[_IPpe], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `IpPermissions.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_AuthorizeSecurityGroupIngressRequest = (input, context) => {
    const entries = {};
    if (input[_CIi] != null) {
        entries[_CIi] = input[_CIi];
    }
    if (input[_FP] != null) {
        entries[_FP] = input[_FP];
    }
    if (input[_GIr] != null) {
        entries[_GIr] = input[_GIr];
    }
    if (input[_GN] != null) {
        entries[_GN] = input[_GN];
    }
    if (input[_IPpe] != null) {
        const memberEntries = se_IpPermissionList(input[_IPpe], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `IpPermissions.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_IPpr] != null) {
        entries[_IPpr] = input[_IPpr];
    }
    if (input[_SSGN] != null) {
        entries[_SSGN] = input[_SSGN];
    }
    if (input[_SSGOI] != null) {
        entries[_SSGOI] = input[_SSGOI];
    }
    if (input[_TP] != null) {
        entries[_TP] = input[_TP];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_AvailabilityZoneStringList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`AvailabilityZone.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_BaselineEbsBandwidthMbps = (input, context) => {
    const entries = {};
    if (input[_M] != null) {
        entries[_M] = input[_M];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_BaselineEbsBandwidthMbpsRequest = (input, context) => {
    const entries = {};
    if (input[_M] != null) {
        entries[_M] = input[_M];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_BaselinePerformanceFactors = (input, context) => {
    const entries = {};
    if (input[_Cp] != null) {
        const memberEntries = se_CpuPerformanceFactor(input[_Cp], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Cpu.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_BaselinePerformanceFactorsRequest = (input, context) => {
    const entries = {};
    if (input[_Cp] != null) {
        const memberEntries = se_CpuPerformanceFactorRequest(input[_Cp], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Cpu.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_BillingProductList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_BlobAttributeValue = (input, context) => {
    const entries = {};
    if (input[_Va] != null) {
        entries[_Va] = context.base64Encoder(input[_Va]);
    }
    return entries;
};
const se_BlockDeviceMapping = (input, context) => {
    const entries = {};
    if (input[_E] != null) {
        const memberEntries = se_EbsBlockDevice(input[_E], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Ebs.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_ND] != null) {
        entries[_ND] = input[_ND];
    }
    if (input[_DN] != null) {
        entries[_DN] = input[_DN];
    }
    if (input[_VN] != null) {
        entries[_VN] = input[_VN];
    }
    return entries;
};
const se_BlockDeviceMappingList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_BlockDeviceMapping(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Item.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_BlockDeviceMappingRequestList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_BlockDeviceMapping(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`BlockDeviceMapping.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_BundleIdStringList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`BundleId.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_BundleInstanceRequest = (input, context) => {
    const entries = {};
    if (input[_IIn] != null) {
        entries[_IIn] = input[_IIn];
    }
    if (input[_St] != null) {
        const memberEntries = se_Storage(input[_St], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Storage.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CancelBundleTaskRequest = (input, context) => {
    const entries = {};
    if (input[_BIu] != null) {
        entries[_BIu] = input[_BIu];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CancelCapacityReservationFleetsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_CRFI] != null) {
        const memberEntries = se_CapacityReservationFleetIdSet(input[_CRFI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `CapacityReservationFleetId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CancelCapacityReservationRequest = (input, context) => {
    const entries = {};
    if (input[_CRI] != null) {
        entries[_CRI] = input[_CRI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CancelConversionRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_CTI] != null) {
        entries[_CTI] = input[_CTI];
    }
    if (input[_RM] != null) {
        entries[_RM] = input[_RM];
    }
    return entries;
};
const se_CancelDeclarativePoliciesReportRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_RIep] != null) {
        entries[_RIep] = input[_RIep];
    }
    return entries;
};
const se_CancelExportTaskRequest = (input, context) => {
    const entries = {};
    if (input[_ETI] != null) {
        entries[_ETI] = input[_ETI];
    }
    return entries;
};
const se_CancelImageLaunchPermissionRequest = (input, context) => {
    const entries = {};
    if (input[_IIma] != null) {
        entries[_IIma] = input[_IIma];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CancelImportTaskRequest = (input, context) => {
    const entries = {};
    if (input[_CRa] != null) {
        entries[_CRa] = input[_CRa];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_ITI] != null) {
        entries[_ITI] = input[_ITI];
    }
    return entries;
};
const se_CancelReservedInstancesListingRequest = (input, context) => {
    const entries = {};
    if (input[_RILI] != null) {
        entries[_RILI] = input[_RILI];
    }
    return entries;
};
const se_CancelSpotFleetRequestsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_SFRI] != null) {
        const memberEntries = se_SpotFleetRequestIdList(input[_SFRI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SpotFleetRequestId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_TI] != null) {
        entries[_TI] = input[_TI];
    }
    return entries;
};
const se_CancelSpotInstanceRequestsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_SIRI] != null) {
        const memberEntries = se_SpotInstanceRequestIdList(input[_SIRI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SpotInstanceRequestId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CapacityBlockIds = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_CapacityReservationFleetIdSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_CapacityReservationIdSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_CapacityReservationOptionsRequest = (input, context) => {
    const entries = {};
    if (input[_USs] != null) {
        entries[_USs] = input[_USs];
    }
    return entries;
};
const se_CapacityReservationSpecification = (input, context) => {
    const entries = {};
    if (input[_CRP] != null) {
        entries[_CRP] = input[_CRP];
    }
    if (input[_CRTa] != null) {
        const memberEntries = se_CapacityReservationTarget(input[_CRTa], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `CapacityReservationTarget.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CapacityReservationTarget = (input, context) => {
    const entries = {};
    if (input[_CRI] != null) {
        entries[_CRI] = input[_CRI];
    }
    if (input[_CRRGA] != null) {
        entries[_CRRGA] = input[_CRRGA];
    }
    return entries;
};
const se_CarrierGatewayIdSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Member.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_CertificateAuthenticationRequest = (input, context) => {
    const entries = {};
    if (input[_CRCCA] != null) {
        entries[_CRCCA] = input[_CRCCA];
    }
    return entries;
};
const se_CidrAuthorizationContext = (input, context) => {
    const entries = {};
    if (input[_Me] != null) {
        entries[_Me] = input[_Me];
    }
    if (input[_Si] != null) {
        entries[_Si] = input[_Si];
    }
    return entries;
};
const se_ClassicLoadBalancer = (input, context) => {
    const entries = {};
    if (input[_N] != null) {
        entries[_N] = input[_N];
    }
    return entries;
};
const se_ClassicLoadBalancers = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_ClassicLoadBalancer(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Item.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_ClassicLoadBalancersConfig = (input, context) => {
    const entries = {};
    if (input[_CLB] != null) {
        const memberEntries = se_ClassicLoadBalancers(input[_CLB], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ClassicLoadBalancers.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_ClientConnectOptions = (input, context) => {
    const entries = {};
    if (input[_En] != null) {
        entries[_En] = input[_En];
    }
    if (input[_LFA] != null) {
        entries[_LFA] = input[_LFA];
    }
    return entries;
};
const se_ClientData = (input, context) => {
    const entries = {};
    if (input[_Co] != null) {
        entries[_Co] = input[_Co];
    }
    if (input[_UE] != null) {
        entries[_UE] = __serializeDateTime(input[_UE]);
    }
    if (input[_USp] != null) {
        entries[_USp] = __serializeFloat(input[_USp]);
    }
    if (input[_USpl] != null) {
        entries[_USpl] = __serializeDateTime(input[_USpl]);
    }
    return entries;
};
const se_ClientLoginBannerOptions = (input, context) => {
    const entries = {};
    if (input[_En] != null) {
        entries[_En] = input[_En];
    }
    if (input[_BT] != null) {
        entries[_BT] = input[_BT];
    }
    return entries;
};
const se_ClientRouteEnforcementOptions = (input, context) => {
    const entries = {};
    if (input[_Enf] != null) {
        entries[_Enf] = input[_Enf];
    }
    return entries;
};
const se_ClientVpnAuthenticationRequest = (input, context) => {
    const entries = {};
    if (input[_T] != null) {
        entries[_T] = input[_T];
    }
    if (input[_AD] != null) {
        const memberEntries = se_DirectoryServiceAuthenticationRequest(input[_AD], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ActiveDirectory.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MA] != null) {
        const memberEntries = se_CertificateAuthenticationRequest(input[_MA], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `MutualAuthentication.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_FA] != null) {
        const memberEntries = se_FederatedAuthenticationRequest(input[_FA], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `FederatedAuthentication.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_ClientVpnAuthenticationRequestList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_ClientVpnAuthenticationRequest(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Member.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_ClientVpnEndpointIdList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_ClientVpnSecurityGroupIdSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_CloudWatchLogOptionsSpecification = (input, context) => {
    const entries = {};
    if (input[_LE] != null) {
        entries[_LE] = input[_LE];
    }
    if (input[_LGA] != null) {
        entries[_LGA] = input[_LGA];
    }
    if (input[_LOF] != null) {
        entries[_LOF] = input[_LOF];
    }
    return entries;
};
const se_CoipPoolIdSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_ConfirmProductInstanceRequest = (input, context) => {
    const entries = {};
    if (input[_IIn] != null) {
        entries[_IIn] = input[_IIn];
    }
    if (input[_PC] != null) {
        entries[_PC] = input[_PC];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_ConnectionLogOptions = (input, context) => {
    const entries = {};
    if (input[_En] != null) {
        entries[_En] = input[_En];
    }
    if (input[_CLG] != null) {
        entries[_CLG] = input[_CLG];
    }
    if (input[_CLS] != null) {
        entries[_CLS] = input[_CLS];
    }
    return entries;
};
const se_ConnectionNotificationIdsList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_ConnectionTrackingSpecificationRequest = (input, context) => {
    const entries = {};
    if (input[_TET] != null) {
        entries[_TET] = input[_TET];
    }
    if (input[_UST] != null) {
        entries[_UST] = input[_UST];
    }
    if (input[_UT] != null) {
        entries[_UT] = input[_UT];
    }
    return entries;
};
const se_ConversionIdStringList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_CopyFpgaImageRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_SFII] != null) {
        entries[_SFII] = input[_SFII];
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_N] != null) {
        entries[_N] = input[_N];
    }
    if (input[_SR] != null) {
        entries[_SR] = input[_SR];
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    return entries;
};
const se_CopyImageRequest = (input, context) => {
    const entries = {};
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_Enc] != null) {
        entries[_Enc] = input[_Enc];
    }
    if (input[_KKI] != null) {
        entries[_KKI] = input[_KKI];
    }
    if (input[_N] != null) {
        entries[_N] = input[_N];
    }
    if (input[_SII] != null) {
        entries[_SII] = input[_SII];
    }
    if (input[_SR] != null) {
        entries[_SR] = input[_SR];
    }
    if (input[_DOA] != null) {
        entries[_DOA] = input[_DOA];
    }
    if (input[_CITo] != null) {
        entries[_CITo] = input[_CITo];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_SCCDM] != null) {
        entries[_SCCDM] = input[_SCCDM];
    }
    if (input[_DAZe] != null) {
        entries[_DAZe] = input[_DAZe];
    }
    if (input[_DAZI] != null) {
        entries[_DAZI] = input[_DAZI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CopySnapshotRequest = (input, context) => {
    const entries = {};
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_DOA] != null) {
        entries[_DOA] = input[_DOA];
    }
    if (input[_DRes] != null) {
        entries[_DRes] = input[_DRes];
    }
    if (input[_Enc] != null) {
        entries[_Enc] = input[_Enc];
    }
    if (input[_KKI] != null) {
        entries[_KKI] = input[_KKI];
    }
    if (input[_PU] != null) {
        entries[_PU] = input[_PU];
    }
    if (input[_SR] != null) {
        entries[_SR] = input[_SR];
    }
    if (input[_SSI] != null) {
        entries[_SSI] = input[_SSI];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_CDM] != null) {
        entries[_CDM] = input[_CDM];
    }
    if (input[_DAZe] != null) {
        entries[_DAZe] = input[_DAZe];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CpuManufacturerSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_CpuOptionsRequest = (input, context) => {
    const entries = {};
    if (input[_CC] != null) {
        entries[_CC] = input[_CC];
    }
    if (input[_TPC] != null) {
        entries[_TPC] = input[_TPC];
    }
    if (input[_ASS] != null) {
        entries[_ASS] = input[_ASS];
    }
    return entries;
};
const se_CpuPerformanceFactor = (input, context) => {
    const entries = {};
    if (input[_R] != null) {
        const memberEntries = se_PerformanceFactorReferenceSet(input[_R], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ReferenceSet.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CpuPerformanceFactorRequest = (input, context) => {
    const entries = {};
    if (input[_R] != null) {
        const memberEntries = se_PerformanceFactorReferenceSetRequest(input[_R], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Reference.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateCapacityReservationBySplittingRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_SCRI] != null) {
        entries[_SCRI] = input[_SCRI];
    }
    if (input[_IC] != null) {
        entries[_IC] = input[_IC];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateCapacityReservationFleetRequest = (input, context) => {
    const entries = {};
    if (input[_AS] != null) {
        entries[_AS] = input[_AS];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_ITS] != null) {
        const memberEntries = se_ReservationFleetInstanceSpecificationList(input[_ITS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InstanceTypeSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Te] != null) {
        entries[_Te] = input[_Te];
    }
    if (input[_TTC] != null) {
        entries[_TTC] = input[_TTC];
    }
    if (input[_ED] != null) {
        entries[_ED] = __serializeDateTime(input[_ED]);
    }
    if (input[_IMC] != null) {
        entries[_IMC] = input[_IMC];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateCapacityReservationRequest = (input, context) => {
    const entries = {};
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_IT] != null) {
        entries[_IT] = input[_IT];
    }
    if (input[_IPn] != null) {
        entries[_IPn] = input[_IPn];
    }
    if (input[_AZ] != null) {
        entries[_AZ] = input[_AZ];
    }
    if (input[_AZI] != null) {
        entries[_AZI] = input[_AZI];
    }
    if (input[_Te] != null) {
        entries[_Te] = input[_Te];
    }
    if (input[_IC] != null) {
        entries[_IC] = input[_IC];
    }
    if (input[_EO] != null) {
        entries[_EO] = input[_EO];
    }
    if (input[_ES] != null) {
        entries[_ES] = input[_ES];
    }
    if (input[_ED] != null) {
        entries[_ED] = __serializeDateTime(input[_ED]);
    }
    if (input[_EDT] != null) {
        entries[_EDT] = input[_EDT];
    }
    if (input[_IMC] != null) {
        entries[_IMC] = input[_IMC];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecifications.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_OA] != null) {
        entries[_OA] = input[_OA];
    }
    if (input[_PGA] != null) {
        entries[_PGA] = input[_PGA];
    }
    if (input[_SD] != null) {
        entries[_SD] = __serializeDateTime(input[_SD]);
    }
    if (input[_CD] != null) {
        entries[_CD] = input[_CD];
    }
    if (input[_DP] != null) {
        entries[_DP] = input[_DP];
    }
    return entries;
};
const se_CreateCarrierGatewayRequest = (input, context) => {
    const entries = {};
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    return entries;
};
const se_CreateClientVpnEndpointRequest = (input, context) => {
    const entries = {};
    if (input[_CCB] != null) {
        entries[_CCB] = input[_CCB];
    }
    if (input[_SCA] != null) {
        entries[_SCA] = input[_SCA];
    }
    if (input[_AO] != null) {
        const memberEntries = se_ClientVpnAuthenticationRequestList(input[_AO], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Authentication.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_CLO] != null) {
        const memberEntries = se_ConnectionLogOptions(input[_CLO], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ConnectionLogOptions.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_DSn] != null) {
        const memberEntries = se_ValueStringList(input[_DSn], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DnsServers.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_TPr] != null) {
        entries[_TPr] = input[_TPr];
    }
    if (input[_VP] != null) {
        entries[_VP] = input[_VP];
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_ST] != null) {
        entries[_ST] = input[_ST];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_SGI] != null) {
        const memberEntries = se_ClientVpnSecurityGroupIdSet(input[_SGI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SecurityGroupId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    if (input[_SSP] != null) {
        entries[_SSP] = input[_SSP];
    }
    if (input[_CCO] != null) {
        const memberEntries = se_ClientConnectOptions(input[_CCO], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ClientConnectOptions.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_STH] != null) {
        entries[_STH] = input[_STH];
    }
    if (input[_CLBO] != null) {
        const memberEntries = se_ClientLoginBannerOptions(input[_CLBO], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ClientLoginBannerOptions.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_CREO] != null) {
        const memberEntries = se_ClientRouteEnforcementOptions(input[_CREO], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ClientRouteEnforcementOptions.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_DOST] != null) {
        entries[_DOST] = input[_DOST];
    }
    if (input[_EIAT] != null) {
        entries[_EIAT] = input[_EIAT];
    }
    if (input[_TIAT] != null) {
        entries[_TIAT] = input[_TIAT];
    }
    return entries;
};
const se_CreateClientVpnRouteRequest = (input, context) => {
    const entries = {};
    if (input[_CVEI] != null) {
        entries[_CVEI] = input[_CVEI];
    }
    if (input[_DCBe] != null) {
        entries[_DCBe] = input[_DCBe];
    }
    if (input[_TVSI] != null) {
        entries[_TVSI] = input[_TVSI];
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateCoipCidrRequest = (input, context) => {
    const entries = {};
    if (input[_C] != null) {
        entries[_C] = input[_C];
    }
    if (input[_CPIo] != null) {
        entries[_CPIo] = input[_CPIo];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateCoipPoolRequest = (input, context) => {
    const entries = {};
    if (input[_LGRTI] != null) {
        entries[_LGRTI] = input[_LGRTI];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateCustomerGatewayRequest = (input, context) => {
    const entries = {};
    if (input[_BA] != null) {
        entries[_BA] = input[_BA];
    }
    if (input[_PI] != null) {
        entries[_PI] = input[_PI];
    }
    if (input[_CA] != null) {
        entries[_CA] = input[_CA];
    }
    if (input[_T] != null) {
        entries[_T] = input[_T];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DN] != null) {
        entries[_DN] = input[_DN];
    }
    if (input[_IAp] != null) {
        entries[_IAp] = input[_IAp];
    }
    if (input[_BAE] != null) {
        entries[_BAE] = input[_BAE];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateDefaultSubnetRequest = (input, context) => {
    const entries = {};
    if (input[_AZ] != null) {
        entries[_AZ] = input[_AZ];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IN] != null) {
        entries[_IN] = input[_IN];
    }
    if (input[_AZI] != null) {
        entries[_AZI] = input[_AZI];
    }
    return entries;
};
const se_CreateDefaultVpcRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateDelegateMacVolumeOwnershipTaskRequest = (input, context) => {
    const entries = {};
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IIn] != null) {
        entries[_IIn] = input[_IIn];
    }
    if (input[_MC] != null) {
        entries[_MC] = input[_MC];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateDhcpOptionsRequest = (input, context) => {
    const entries = {};
    if (input[_DCh] != null) {
        const memberEntries = se_NewDhcpConfigurationList(input[_DCh], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DhcpConfiguration.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateEgressOnlyInternetGatewayRequest = (input, context) => {
    const entries = {};
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateFleetRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_SO] != null) {
        const memberEntries = se_SpotOptionsRequest(input[_SO], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SpotOptions.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_ODO] != null) {
        const memberEntries = se_OnDemandOptionsRequest(input[_ODO], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `OnDemandOptions.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_ECTP] != null) {
        entries[_ECTP] = input[_ECTP];
    }
    if (input[_LTC] != null) {
        const memberEntries = se_FleetLaunchTemplateConfigListRequest(input[_LTC], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `LaunchTemplateConfigs.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_TCS] != null) {
        const memberEntries = se_TargetCapacitySpecificationRequest(input[_TCS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TargetCapacitySpecification.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_TIWE] != null) {
        entries[_TIWE] = input[_TIWE];
    }
    if (input[_T] != null) {
        entries[_T] = input[_T];
    }
    if (input[_VF] != null) {
        entries[_VF] = __serializeDateTime(input[_VF]);
    }
    if (input[_VU] != null) {
        entries[_VU] = __serializeDateTime(input[_VU]);
    }
    if (input[_RUI] != null) {
        entries[_RUI] = input[_RUI];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Con] != null) {
        entries[_Con] = input[_Con];
    }
    return entries;
};
const se_CreateFlowLogsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_DLPA] != null) {
        entries[_DLPA] = input[_DLPA];
    }
    if (input[_DCAR] != null) {
        entries[_DCAR] = input[_DCAR];
    }
    if (input[_LGN] != null) {
        entries[_LGN] = input[_LGN];
    }
    if (input[_RIes] != null) {
        const memberEntries = se_FlowLogResourceIds(input[_RIes], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ResourceId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_RT] != null) {
        entries[_RT] = input[_RT];
    }
    if (input[_TT] != null) {
        entries[_TT] = input[_TT];
    }
    if (input[_LDT] != null) {
        entries[_LDT] = input[_LDT];
    }
    if (input[_LD] != null) {
        entries[_LD] = input[_LD];
    }
    if (input[_LF] != null) {
        entries[_LF] = input[_LF];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MAI] != null) {
        entries[_MAI] = input[_MAI];
    }
    if (input[_DO] != null) {
        const memberEntries = se_DestinationOptionsRequest(input[_DO], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DestinationOptions.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateFpgaImageRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_ISL] != null) {
        const memberEntries = se_StorageLocation(input[_ISL], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InputStorageLocation.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_LSL] != null) {
        const memberEntries = se_StorageLocation(input[_LSL], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `LogsStorageLocation.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_N] != null) {
        entries[_N] = input[_N];
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateImageRequest = (input, context) => {
    const entries = {};
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_SL] != null) {
        entries[_SL] = input[_SL];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IIn] != null) {
        entries[_IIn] = input[_IIn];
    }
    if (input[_N] != null) {
        entries[_N] = input[_N];
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_NR] != null) {
        entries[_NR] = input[_NR];
    }
    if (input[_BDM] != null) {
        const memberEntries = se_BlockDeviceMappingRequestList(input[_BDM], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `BlockDeviceMapping.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateImageUsageReportRequest = (input, context) => {
    const entries = {};
    if (input[_IIma] != null) {
        entries[_IIma] = input[_IIma];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_RTe] != null) {
        const memberEntries = se_ImageUsageResourceTypeRequestList(input[_RTe], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ResourceType.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_AIc] != null) {
        const memberEntries = se_ImageUsageReportUserIdStringList(input[_AIc], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `AccountId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateInstanceConnectEndpointRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_SIub] != null) {
        entries[_SIub] = input[_SIub];
    }
    if (input[_SGI] != null) {
        const memberEntries = se_SecurityGroupIdStringListRequest(input[_SGI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SecurityGroupId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_PCI] != null) {
        entries[_PCI] = input[_PCI];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_IAT] != null) {
        entries[_IAT] = input[_IAT];
    }
    return entries;
};
const se_CreateInstanceEventWindowRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_N] != null) {
        entries[_N] = input[_N];
    }
    if (input[_TRi] != null) {
        const memberEntries = se_InstanceEventWindowTimeRangeRequestSet(input[_TRi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TimeRange.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_CE] != null) {
        entries[_CE] = input[_CE];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateInstanceExportTaskRequest = (input, context) => {
    const entries = {};
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_IIn] != null) {
        entries[_IIn] = input[_IIn];
    }
    if (input[_TE] != null) {
        entries[_TE] = input[_TE];
    }
    if (input[_ETST] != null) {
        const memberEntries = se_ExportToS3TaskSpecification(input[_ETST], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ExportToS3.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateInternetGatewayRequest = (input, context) => {
    const entries = {};
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateIpamExternalResourceVerificationTokenRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IIp] != null) {
        entries[_IIp] = input[_IIp];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    return entries;
};
const se_CreateIpamPoolRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_ISI] != null) {
        entries[_ISI] = input[_ISI];
    }
    if (input[_L] != null) {
        entries[_L] = input[_L];
    }
    if (input[_SIPI] != null) {
        entries[_SIPI] = input[_SIPI];
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_AF] != null) {
        entries[_AF] = input[_AF];
    }
    if (input[_AIu] != null) {
        entries[_AIu] = input[_AIu];
    }
    if (input[_PA] != null) {
        entries[_PA] = input[_PA];
    }
    if (input[_AMNL] != null) {
        entries[_AMNL] = input[_AMNL];
    }
    if (input[_AMNLl] != null) {
        entries[_AMNLl] = input[_AMNLl];
    }
    if (input[_ADNL] != null) {
        entries[_ADNL] = input[_ADNL];
    }
    if (input[_ARTl] != null) {
        const memberEntries = se_RequestIpamResourceTagList(input[_ARTl], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `AllocationResourceTag.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_ASw] != null) {
        entries[_ASw] = input[_ASw];
    }
    if (input[_PIS] != null) {
        entries[_PIS] = input[_PIS];
    }
    if (input[_SRo] != null) {
        const memberEntries = se_IpamPoolSourceResourceRequest(input[_SRo], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SourceResource.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateIpamRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_OR] != null) {
        const memberEntries = se_AddIpamOperatingRegionSet(input[_OR], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `OperatingRegion.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_Ti] != null) {
        entries[_Ti] = input[_Ti];
    }
    if (input[_EPG] != null) {
        entries[_EPG] = input[_EPG];
    }
    if (input[_MAe] != null) {
        entries[_MAe] = input[_MAe];
    }
    return entries;
};
const se_CreateIpamResourceDiscoveryRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_OR] != null) {
        const memberEntries = se_AddIpamOperatingRegionSet(input[_OR], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `OperatingRegion.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    return entries;
};
const se_CreateIpamScopeRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IIp] != null) {
        entries[_IIp] = input[_IIp];
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    return entries;
};
const se_CreateKeyPairRequest = (input, context) => {
    const entries = {};
    if (input[_KN] != null) {
        entries[_KN] = input[_KN];
    }
    if (input[_KT] != null) {
        entries[_KT] = input[_KT];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_KF] != null) {
        entries[_KF] = input[_KF];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateLaunchTemplateRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_LTN] != null) {
        entries[_LTN] = input[_LTN];
    }
    if (input[_VD] != null) {
        entries[_VD] = input[_VD];
    }
    if (input[_LTD] != null) {
        const memberEntries = se_RequestLaunchTemplateData(input[_LTD], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `LaunchTemplateData.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_O] != null) {
        const memberEntries = se_OperatorRequest(input[_O], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Operator.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateLaunchTemplateVersionRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_LTI] != null) {
        entries[_LTI] = input[_LTI];
    }
    if (input[_LTN] != null) {
        entries[_LTN] = input[_LTN];
    }
    if (input[_SV] != null) {
        entries[_SV] = input[_SV];
    }
    if (input[_VD] != null) {
        entries[_VD] = input[_VD];
    }
    if (input[_LTD] != null) {
        const memberEntries = se_RequestLaunchTemplateData(input[_LTD], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `LaunchTemplateData.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_RAe] != null) {
        entries[_RAe] = input[_RAe];
    }
    return entries;
};
const se_CreateLocalGatewayRouteRequest = (input, context) => {
    const entries = {};
    if (input[_DCBe] != null) {
        entries[_DCBe] = input[_DCBe];
    }
    if (input[_LGRTI] != null) {
        entries[_LGRTI] = input[_LGRTI];
    }
    if (input[_LGVIGI] != null) {
        entries[_LGVIGI] = input[_LGVIGI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_NII] != null) {
        entries[_NII] = input[_NII];
    }
    if (input[_DPLI] != null) {
        entries[_DPLI] = input[_DPLI];
    }
    return entries;
};
const se_CreateLocalGatewayRouteTableRequest = (input, context) => {
    const entries = {};
    if (input[_LGI] != null) {
        entries[_LGI] = input[_LGI];
    }
    if (input[_Mo] != null) {
        entries[_Mo] = input[_Mo];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest = (input, context) => {
    const entries = {};
    if (input[_LGRTI] != null) {
        entries[_LGRTI] = input[_LGRTI];
    }
    if (input[_LGVIGI] != null) {
        entries[_LGVIGI] = input[_LGVIGI];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateLocalGatewayRouteTableVpcAssociationRequest = (input, context) => {
    const entries = {};
    if (input[_LGRTI] != null) {
        entries[_LGRTI] = input[_LGRTI];
    }
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateLocalGatewayVirtualInterfaceGroupRequest = (input, context) => {
    const entries = {};
    if (input[_LGI] != null) {
        entries[_LGI] = input[_LGI];
    }
    if (input[_LBA] != null) {
        entries[_LBA] = input[_LBA];
    }
    if (input[_LBAE] != null) {
        entries[_LBAE] = input[_LBAE];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateLocalGatewayVirtualInterfaceRequest = (input, context) => {
    const entries = {};
    if (input[_LGVIGI] != null) {
        entries[_LGVIGI] = input[_LGVIGI];
    }
    if (input[_OLI] != null) {
        entries[_OLI] = input[_OLI];
    }
    if (input[_Vl] != null) {
        entries[_Vl] = input[_Vl];
    }
    if (input[_LA] != null) {
        entries[_LA] = input[_LA];
    }
    if (input[_PAe] != null) {
        entries[_PAe] = input[_PAe];
    }
    if (input[_PBA] != null) {
        entries[_PBA] = input[_PBA];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_PBAE] != null) {
        entries[_PBAE] = input[_PBAE];
    }
    return entries;
};
const se_CreateMacSystemIntegrityProtectionModificationTaskRequest = (input, context) => {
    const entries = {};
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IIn] != null) {
        entries[_IIn] = input[_IIn];
    }
    if (input[_MC] != null) {
        entries[_MC] = input[_MC];
    }
    if (input[_MSIPC] != null) {
        const memberEntries = se_MacSystemIntegrityProtectionConfigurationRequest(input[_MSIPC], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `MacSystemIntegrityProtectionConfiguration.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MSIPS] != null) {
        entries[_MSIPS] = input[_MSIPS];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateManagedPrefixListRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_PLN] != null) {
        entries[_PLN] = input[_PLN];
    }
    if (input[_Ent] != null) {
        const memberEntries = se_AddPrefixListEntries(input[_Ent], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Entry.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_ME] != null) {
        entries[_ME] = input[_ME];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_AF] != null) {
        entries[_AF] = input[_AF];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    return entries;
};
const se_CreateNatGatewayRequest = (input, context) => {
    const entries = {};
    if (input[_AIl] != null) {
        entries[_AIl] = input[_AIl];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_SIub] != null) {
        entries[_SIub] = input[_SIub];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_CTo] != null) {
        entries[_CTo] = input[_CTo];
    }
    if (input[_PIAr] != null) {
        entries[_PIAr] = input[_PIAr];
    }
    if (input[_SAI] != null) {
        const memberEntries = se_AllocationIdList(input[_SAI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SecondaryAllocationId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_SPIA] != null) {
        const memberEntries = se_IpList(input[_SPIA], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SecondaryPrivateIpAddress.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_SPIAC] != null) {
        entries[_SPIAC] = input[_SPIAC];
    }
    return entries;
};
const se_CreateNetworkAclEntryRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_NAI] != null) {
        entries[_NAI] = input[_NAI];
    }
    if (input[_RNu] != null) {
        entries[_RNu] = input[_RNu];
    }
    if (input[_P] != null) {
        entries[_P] = input[_P];
    }
    if (input[_RAu] != null) {
        entries[_RAu] = input[_RAu];
    }
    if (input[_Eg] != null) {
        entries[_Eg] = input[_Eg];
    }
    if (input[_CB] != null) {
        entries[_CB] = input[_CB];
    }
    if (input[_ICB] != null) {
        entries[_ICB] = input[_ICB];
    }
    if (input[_ITC] != null) {
        const memberEntries = se_IcmpTypeCode(input[_ITC], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Icmp.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_PR] != null) {
        const memberEntries = se_PortRange(input[_PR], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `PortRange.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateNetworkAclRequest = (input, context) => {
    const entries = {};
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    return entries;
};
const se_CreateNetworkInsightsAccessScopeRequest = (input, context) => {
    const entries = {};
    if (input[_MP] != null) {
        const memberEntries = se_AccessScopePathListRequest(input[_MP], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `MatchPath.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_EP] != null) {
        const memberEntries = se_AccessScopePathListRequest(input[_EP], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ExcludePath.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateNetworkInsightsPathRequest = (input, context) => {
    const entries = {};
    if (input[_SIo] != null) {
        entries[_SIo] = input[_SIo];
    }
    if (input[_DIest] != null) {
        entries[_DIest] = input[_DIest];
    }
    if (input[_S] != null) {
        entries[_S] = input[_S];
    }
    if (input[_D] != null) {
        entries[_D] = input[_D];
    }
    if (input[_P] != null) {
        entries[_P] = input[_P];
    }
    if (input[_DPe] != null) {
        entries[_DPe] = input[_DPe];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_FAS] != null) {
        const memberEntries = se_PathRequestFilter(input[_FAS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `FilterAtSource.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_FAD] != null) {
        const memberEntries = se_PathRequestFilter(input[_FAD], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `FilterAtDestination.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateNetworkInterfacePermissionRequest = (input, context) => {
    const entries = {};
    if (input[_NII] != null) {
        entries[_NII] = input[_NII];
    }
    if (input[_AAI] != null) {
        entries[_AAI] = input[_AAI];
    }
    if (input[_ASw] != null) {
        entries[_ASw] = input[_ASw];
    }
    if (input[_Pe] != null) {
        entries[_Pe] = input[_Pe];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateNetworkInterfaceRequest = (input, context) => {
    const entries = {};
    if (input[_IPp] != null) {
        const memberEntries = se_Ipv4PrefixList(input[_IPp], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Ipv4Prefix.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_IPCp] != null) {
        entries[_IPCp] = input[_IPCp];
    }
    if (input[_IP] != null) {
        const memberEntries = se_Ipv6PrefixList(input[_IP], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Ipv6Prefix.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_IPC] != null) {
        entries[_IPC] = input[_IPC];
    }
    if (input[_ITn] != null) {
        entries[_ITn] = input[_ITn];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_EPI] != null) {
        entries[_EPI] = input[_EPI];
    }
    if (input[_CTS] != null) {
        const memberEntries = se_ConnectionTrackingSpecificationRequest(input[_CTS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ConnectionTrackingSpecification.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_O] != null) {
        const memberEntries = se_OperatorRequest(input[_O], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Operator.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_SIub] != null) {
        entries[_SIub] = input[_SIub];
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_PIAr] != null) {
        entries[_PIAr] = input[_PIAr];
    }
    if (input[_G] != null) {
        const memberEntries = se_SecurityGroupIdStringList(input[_G], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SecurityGroupId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_PIA] != null) {
        const memberEntries = se_PrivateIpAddressSpecificationList(input[_PIA], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `PrivateIpAddresses.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_SPIAC] != null) {
        entries[_SPIAC] = input[_SPIAC];
    }
    if (input[_IA] != null) {
        const memberEntries = se_InstanceIpv6AddressList(input[_IA], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Ipv6Addresses.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_IAC] != null) {
        entries[_IAC] = input[_IAC];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreatePlacementGroupRequest = (input, context) => {
    const entries = {};
    if (input[_PCa] != null) {
        entries[_PCa] = input[_PCa];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_SLp] != null) {
        entries[_SLp] = input[_SLp];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_GN] != null) {
        entries[_GN] = input[_GN];
    }
    if (input[_Str] != null) {
        entries[_Str] = input[_Str];
    }
    return entries;
};
const se_CreatePublicIpv4PoolRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NBG] != null) {
        entries[_NBG] = input[_NBG];
    }
    return entries;
};
const se_CreateReplaceRootVolumeTaskRequest = (input, context) => {
    const entries = {};
    if (input[_IIn] != null) {
        entries[_IIn] = input[_IIn];
    }
    if (input[_SIn] != null) {
        entries[_SIn] = input[_SIn];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_IIma] != null) {
        entries[_IIma] = input[_IIma];
    }
    if (input[_DRRV] != null) {
        entries[_DRRV] = input[_DRRV];
    }
    if (input[_VIR] != null) {
        entries[_VIR] = input[_VIR];
    }
    return entries;
};
const se_CreateReservedInstancesListingRequest = (input, context) => {
    const entries = {};
    if (input[_RIIe] != null) {
        entries[_RIIe] = input[_RIIe];
    }
    if (input[_IC] != null) {
        entries[_IC] = input[_IC];
    }
    if (input[_PS] != null) {
        const memberEntries = se_PriceScheduleSpecificationList(input[_PS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `PriceSchedules.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    return entries;
};
const se_CreateRestoreImageTaskRequest = (input, context) => {
    const entries = {};
    if (input[_B] != null) {
        entries[_B] = input[_B];
    }
    if (input[_OK] != null) {
        entries[_OK] = input[_OK];
    }
    if (input[_N] != null) {
        entries[_N] = input[_N];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateRouteRequest = (input, context) => {
    const entries = {};
    if (input[_DPLI] != null) {
        entries[_DPLI] = input[_DPLI];
    }
    if (input[_VEIp] != null) {
        entries[_VEIp] = input[_VEIp];
    }
    if (input[_TGI] != null) {
        entries[_TGI] = input[_TGI];
    }
    if (input[_LGI] != null) {
        entries[_LGI] = input[_LGI];
    }
    if (input[_CGI] != null) {
        entries[_CGI] = input[_CGI];
    }
    if (input[_CNAo] != null) {
        entries[_CNAo] = input[_CNAo];
    }
    if (input[_ONA] != null) {
        entries[_ONA] = input[_ONA];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_RTI] != null) {
        entries[_RTI] = input[_RTI];
    }
    if (input[_DCBe] != null) {
        entries[_DCBe] = input[_DCBe];
    }
    if (input[_GI] != null) {
        entries[_GI] = input[_GI];
    }
    if (input[_DICB] != null) {
        entries[_DICB] = input[_DICB];
    }
    if (input[_EOIGI] != null) {
        entries[_EOIGI] = input[_EOIGI];
    }
    if (input[_IIn] != null) {
        entries[_IIn] = input[_IIn];
    }
    if (input[_NII] != null) {
        entries[_NII] = input[_NII];
    }
    if (input[_VPCI] != null) {
        entries[_VPCI] = input[_VPCI];
    }
    if (input[_NGI] != null) {
        entries[_NGI] = input[_NGI];
    }
    return entries;
};
const se_CreateRouteServerEndpointRequest = (input, context) => {
    const entries = {};
    if (input[_RSIo] != null) {
        entries[_RSIo] = input[_RSIo];
    }
    if (input[_SIub] != null) {
        entries[_SIub] = input[_SIub];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateRouteServerPeerRequest = (input, context) => {
    const entries = {};
    if (input[_RSEI] != null) {
        entries[_RSEI] = input[_RSEI];
    }
    if (input[_PAe] != null) {
        entries[_PAe] = input[_PAe];
    }
    if (input[_BO] != null) {
        const memberEntries = se_RouteServerBgpOptionsRequest(input[_BO], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `BgpOptions.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateRouteServerRequest = (input, context) => {
    const entries = {};
    if (input[_ASA] != null) {
        entries[_ASA] = input[_ASA];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_PRe] != null) {
        entries[_PRe] = input[_PRe];
    }
    if (input[_PRD] != null) {
        entries[_PRD] = input[_PRD];
    }
    if (input[_SNE] != null) {
        entries[_SNE] = input[_SNE];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateRouteTableRequest = (input, context) => {
    const entries = {};
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    return entries;
};
const se_CreateSecurityGroupRequest = (input, context) => {
    const entries = {};
    if (input[_De] != null) {
        entries[_GD] = input[_De];
    }
    if (input[_GN] != null) {
        entries[_GN] = input[_GN];
    }
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateSnapshotRequest = (input, context) => {
    const entries = {};
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_OA] != null) {
        entries[_OA] = input[_OA];
    }
    if (input[_VIo] != null) {
        entries[_VIo] = input[_VIo];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Lo] != null) {
        entries[_Lo] = input[_Lo];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateSnapshotsRequest = (input, context) => {
    const entries = {};
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_ISn] != null) {
        const memberEntries = se_InstanceSpecification(input[_ISn], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InstanceSpecification.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_OA] != null) {
        entries[_OA] = input[_OA];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_CTFS] != null) {
        entries[_CTFS] = input[_CTFS];
    }
    if (input[_Lo] != null) {
        entries[_Lo] = input[_Lo];
    }
    return entries;
};
const se_CreateSpotDatafeedSubscriptionRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_B] != null) {
        entries[_B] = input[_B];
    }
    if (input[_Pr] != null) {
        entries[_Pr] = input[_Pr];
    }
    return entries;
};
const se_CreateStoreImageTaskRequest = (input, context) => {
    const entries = {};
    if (input[_IIma] != null) {
        entries[_IIma] = input[_IIma];
    }
    if (input[_B] != null) {
        entries[_B] = input[_B];
    }
    if (input[_SOT] != null) {
        const memberEntries = se_S3ObjectTagList(input[_SOT], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `S3ObjectTag.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateSubnetCidrReservationRequest = (input, context) => {
    const entries = {};
    if (input[_SIub] != null) {
        entries[_SIub] = input[_SIub];
    }
    if (input[_C] != null) {
        entries[_C] = input[_C];
    }
    if (input[_RTes] != null) {
        entries[_RTes] = input[_RTes];
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateSubnetRequest = (input, context) => {
    const entries = {};
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_AZ] != null) {
        entries[_AZ] = input[_AZ];
    }
    if (input[_AZI] != null) {
        entries[_AZI] = input[_AZI];
    }
    if (input[_CB] != null) {
        entries[_CB] = input[_CB];
    }
    if (input[_ICB] != null) {
        entries[_ICB] = input[_ICB];
    }
    if (input[_OA] != null) {
        entries[_OA] = input[_OA];
    }
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    if (input[_IN] != null) {
        entries[_IN] = input[_IN];
    }
    if (input[_IIPIp] != null) {
        entries[_IIPIp] = input[_IIPIp];
    }
    if (input[_INLp] != null) {
        entries[_INLp] = input[_INLp];
    }
    if (input[_IIPI] != null) {
        entries[_IIPI] = input[_IIPI];
    }
    if (input[_INL] != null) {
        entries[_INL] = input[_INL];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateTagsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Re] != null) {
        const memberEntries = se_ResourceIdList(input[_Re], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ResourceId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Ta] != null) {
        const memberEntries = se_TagList(input[_Ta], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tag.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateTrafficMirrorFilterRequest = (input, context) => {
    const entries = {};
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    return entries;
};
const se_CreateTrafficMirrorFilterRuleRequest = (input, context) => {
    const entries = {};
    if (input[_TMFI] != null) {
        entries[_TMFI] = input[_TMFI];
    }
    if (input[_TD] != null) {
        entries[_TD] = input[_TD];
    }
    if (input[_RNu] != null) {
        entries[_RNu] = input[_RNu];
    }
    if (input[_RAu] != null) {
        entries[_RAu] = input[_RAu];
    }
    if (input[_DPR] != null) {
        const memberEntries = se_TrafficMirrorPortRangeRequest(input[_DPR], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DestinationPortRange.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_SPR] != null) {
        const memberEntries = se_TrafficMirrorPortRangeRequest(input[_SPR], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SourcePortRange.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_P] != null) {
        entries[_P] = input[_P];
    }
    if (input[_DCBe] != null) {
        entries[_DCBe] = input[_DCBe];
    }
    if (input[_SCB] != null) {
        entries[_SCB] = input[_SCB];
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateTrafficMirrorSessionRequest = (input, context) => {
    const entries = {};
    if (input[_NII] != null) {
        entries[_NII] = input[_NII];
    }
    if (input[_TMTI] != null) {
        entries[_TMTI] = input[_TMTI];
    }
    if (input[_TMFI] != null) {
        entries[_TMFI] = input[_TMFI];
    }
    if (input[_PL] != null) {
        entries[_PL] = input[_PL];
    }
    if (input[_SN] != null) {
        entries[_SN] = input[_SN];
    }
    if (input[_VNI] != null) {
        entries[_VNI] = input[_VNI];
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    return entries;
};
const se_CreateTrafficMirrorTargetRequest = (input, context) => {
    const entries = {};
    if (input[_NII] != null) {
        entries[_NII] = input[_NII];
    }
    if (input[_NLBA] != null) {
        entries[_NLBA] = input[_NLBA];
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_GLBEI] != null) {
        entries[_GLBEI] = input[_GLBEI];
    }
    return entries;
};
const se_CreateTransitGatewayConnectPeerRequest = (input, context) => {
    const entries = {};
    if (input[_TGAI] != null) {
        entries[_TGAI] = input[_TGAI];
    }
    if (input[_TGA] != null) {
        entries[_TGA] = input[_TGA];
    }
    if (input[_PAe] != null) {
        entries[_PAe] = input[_PAe];
    }
    if (input[_BO] != null) {
        const memberEntries = se_TransitGatewayConnectRequestBgpOptions(input[_BO], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `BgpOptions.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_ICBn] != null) {
        const memberEntries = se_InsideCidrBlocksStringList(input[_ICBn], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InsideCidrBlocks.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateTransitGatewayConnectRequest = (input, context) => {
    const entries = {};
    if (input[_TTGAI] != null) {
        entries[_TTGAI] = input[_TTGAI];
    }
    if (input[_Op] != null) {
        const memberEntries = se_CreateTransitGatewayConnectRequestOptions(input[_Op], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Options.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateTransitGatewayConnectRequestOptions = (input, context) => {
    const entries = {};
    if (input[_P] != null) {
        entries[_P] = input[_P];
    }
    return entries;
};
const se_CreateTransitGatewayMulticastDomainRequest = (input, context) => {
    const entries = {};
    if (input[_TGI] != null) {
        entries[_TGI] = input[_TGI];
    }
    if (input[_Op] != null) {
        const memberEntries = se_CreateTransitGatewayMulticastDomainRequestOptions(input[_Op], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Options.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateTransitGatewayMulticastDomainRequestOptions = (input, context) => {
    const entries = {};
    if (input[_ISg] != null) {
        entries[_ISg] = input[_ISg];
    }
    if (input[_SSS] != null) {
        entries[_SSS] = input[_SSS];
    }
    if (input[_AASA] != null) {
        entries[_AASA] = input[_AASA];
    }
    return entries;
};
const se_CreateTransitGatewayPeeringAttachmentRequest = (input, context) => {
    const entries = {};
    if (input[_TGI] != null) {
        entries[_TGI] = input[_TGI];
    }
    if (input[_PTGI] != null) {
        entries[_PTGI] = input[_PTGI];
    }
    if (input[_PAI] != null) {
        entries[_PAI] = input[_PAI];
    }
    if (input[_PRee] != null) {
        entries[_PRee] = input[_PRee];
    }
    if (input[_Op] != null) {
        const memberEntries = se_CreateTransitGatewayPeeringAttachmentRequestOptions(input[_Op], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Options.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateTransitGatewayPeeringAttachmentRequestOptions = (input, context) => {
    const entries = {};
    if (input[_DRy] != null) {
        entries[_DRy] = input[_DRy];
    }
    return entries;
};
const se_CreateTransitGatewayPolicyTableRequest = (input, context) => {
    const entries = {};
    if (input[_TGI] != null) {
        entries[_TGI] = input[_TGI];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecifications.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateTransitGatewayPrefixListReferenceRequest = (input, context) => {
    const entries = {};
    if (input[_TGRTI] != null) {
        entries[_TGRTI] = input[_TGRTI];
    }
    if (input[_PLI] != null) {
        entries[_PLI] = input[_PLI];
    }
    if (input[_TGAI] != null) {
        entries[_TGAI] = input[_TGAI];
    }
    if (input[_Bl] != null) {
        entries[_Bl] = input[_Bl];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateTransitGatewayRequest = (input, context) => {
    const entries = {};
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_Op] != null) {
        const memberEntries = se_TransitGatewayRequestOptions(input[_Op], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Options.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateTransitGatewayRouteRequest = (input, context) => {
    const entries = {};
    if (input[_DCBe] != null) {
        entries[_DCBe] = input[_DCBe];
    }
    if (input[_TGRTI] != null) {
        entries[_TGRTI] = input[_TGRTI];
    }
    if (input[_TGAI] != null) {
        entries[_TGAI] = input[_TGAI];
    }
    if (input[_Bl] != null) {
        entries[_Bl] = input[_Bl];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateTransitGatewayRouteTableAnnouncementRequest = (input, context) => {
    const entries = {};
    if (input[_TGRTI] != null) {
        entries[_TGRTI] = input[_TGRTI];
    }
    if (input[_PAIe] != null) {
        entries[_PAIe] = input[_PAIe];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateTransitGatewayRouteTableRequest = (input, context) => {
    const entries = {};
    if (input[_TGI] != null) {
        entries[_TGI] = input[_TGI];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecifications.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateTransitGatewayVpcAttachmentRequest = (input, context) => {
    const entries = {};
    if (input[_TGI] != null) {
        entries[_TGI] = input[_TGI];
    }
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    if (input[_SIu] != null) {
        const memberEntries = se_TransitGatewaySubnetIdList(input[_SIu], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SubnetIds.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Op] != null) {
        const memberEntries = se_CreateTransitGatewayVpcAttachmentRequestOptions(input[_Op], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Options.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecifications.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateTransitGatewayVpcAttachmentRequestOptions = (input, context) => {
    const entries = {};
    if (input[_DSns] != null) {
        entries[_DSns] = input[_DSns];
    }
    if (input[_SGRS] != null) {
        entries[_SGRS] = input[_SGRS];
    }
    if (input[_ISp] != null) {
        entries[_ISp] = input[_ISp];
    }
    if (input[_AMS] != null) {
        entries[_AMS] = input[_AMS];
    }
    return entries;
};
const se_CreateVerifiedAccessEndpointCidrOptions = (input, context) => {
    const entries = {};
    if (input[_P] != null) {
        entries[_P] = input[_P];
    }
    if (input[_SIu] != null) {
        const memberEntries = se_CreateVerifiedAccessEndpointSubnetIdList(input[_SIu], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SubnetId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_C] != null) {
        entries[_C] = input[_C];
    }
    if (input[_PRo] != null) {
        const memberEntries = se_CreateVerifiedAccessEndpointPortRangeList(input[_PRo], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `PortRange.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateVerifiedAccessEndpointEniOptions = (input, context) => {
    const entries = {};
    if (input[_NII] != null) {
        entries[_NII] = input[_NII];
    }
    if (input[_P] != null) {
        entries[_P] = input[_P];
    }
    if (input[_Po] != null) {
        entries[_Po] = input[_Po];
    }
    if (input[_PRo] != null) {
        const memberEntries = se_CreateVerifiedAccessEndpointPortRangeList(input[_PRo], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `PortRange.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateVerifiedAccessEndpointLoadBalancerOptions = (input, context) => {
    const entries = {};
    if (input[_P] != null) {
        entries[_P] = input[_P];
    }
    if (input[_Po] != null) {
        entries[_Po] = input[_Po];
    }
    if (input[_LBAo] != null) {
        entries[_LBAo] = input[_LBAo];
    }
    if (input[_SIu] != null) {
        const memberEntries = se_CreateVerifiedAccessEndpointSubnetIdList(input[_SIu], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SubnetId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_PRo] != null) {
        const memberEntries = se_CreateVerifiedAccessEndpointPortRangeList(input[_PRo], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `PortRange.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateVerifiedAccessEndpointPortRange = (input, context) => {
    const entries = {};
    if (input[_FP] != null) {
        entries[_FP] = input[_FP];
    }
    if (input[_TP] != null) {
        entries[_TP] = input[_TP];
    }
    return entries;
};
const se_CreateVerifiedAccessEndpointPortRangeList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_CreateVerifiedAccessEndpointPortRange(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Item.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_CreateVerifiedAccessEndpointRdsOptions = (input, context) => {
    const entries = {};
    if (input[_P] != null) {
        entries[_P] = input[_P];
    }
    if (input[_Po] != null) {
        entries[_Po] = input[_Po];
    }
    if (input[_RDIA] != null) {
        entries[_RDIA] = input[_RDIA];
    }
    if (input[_RDCA] != null) {
        entries[_RDCA] = input[_RDCA];
    }
    if (input[_RDPA] != null) {
        entries[_RDPA] = input[_RDPA];
    }
    if (input[_RE] != null) {
        entries[_RE] = input[_RE];
    }
    if (input[_SIu] != null) {
        const memberEntries = se_CreateVerifiedAccessEndpointSubnetIdList(input[_SIu], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SubnetId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateVerifiedAccessEndpointRequest = (input, context) => {
    const entries = {};
    if (input[_VAGI] != null) {
        entries[_VAGI] = input[_VAGI];
    }
    if (input[_ET] != null) {
        entries[_ET] = input[_ET];
    }
    if (input[_ATt] != null) {
        entries[_ATt] = input[_ATt];
    }
    if (input[_DCA] != null) {
        entries[_DCA] = input[_DCA];
    }
    if (input[_ADp] != null) {
        entries[_ADp] = input[_ADp];
    }
    if (input[_EDP] != null) {
        entries[_EDP] = input[_EDP];
    }
    if (input[_SGI] != null) {
        const memberEntries = se_SecurityGroupIdList(input[_SGI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SecurityGroupId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_LBO] != null) {
        const memberEntries = se_CreateVerifiedAccessEndpointLoadBalancerOptions(input[_LBO], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `LoadBalancerOptions.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_NIO] != null) {
        const memberEntries = se_CreateVerifiedAccessEndpointEniOptions(input[_NIO], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `NetworkInterfaceOptions.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_PD] != null) {
        entries[_PD] = input[_PD];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_SS] != null) {
        const memberEntries = se_VerifiedAccessSseSpecificationRequest(input[_SS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SseSpecification.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_RO] != null) {
        const memberEntries = se_CreateVerifiedAccessEndpointRdsOptions(input[_RO], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `RdsOptions.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_CO] != null) {
        const memberEntries = se_CreateVerifiedAccessEndpointCidrOptions(input[_CO], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `CidrOptions.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateVerifiedAccessEndpointSubnetIdList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_CreateVerifiedAccessGroupRequest = (input, context) => {
    const entries = {};
    if (input[_VAII] != null) {
        entries[_VAII] = input[_VAII];
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_PD] != null) {
        entries[_PD] = input[_PD];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_SS] != null) {
        const memberEntries = se_VerifiedAccessSseSpecificationRequest(input[_SS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SseSpecification.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateVerifiedAccessInstanceRequest = (input, context) => {
    const entries = {};
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_FIPSE] != null) {
        entries[_FIPSE] = input[_FIPSE];
    }
    if (input[_CECSD] != null) {
        entries[_CECSD] = input[_CECSD];
    }
    return entries;
};
const se_CreateVerifiedAccessNativeApplicationOidcOptions = (input, context) => {
    const entries = {};
    if (input[_PSKE] != null) {
        entries[_PSKE] = input[_PSKE];
    }
    if (input[_I] != null) {
        entries[_I] = input[_I];
    }
    if (input[_AE] != null) {
        entries[_AE] = input[_AE];
    }
    if (input[_TEo] != null) {
        entries[_TEo] = input[_TEo];
    }
    if (input[_UIE] != null) {
        entries[_UIE] = input[_UIE];
    }
    if (input[_CIl] != null) {
        entries[_CIl] = input[_CIl];
    }
    if (input[_CSl] != null) {
        entries[_CSl] = input[_CSl];
    }
    if (input[_Sc] != null) {
        entries[_Sc] = input[_Sc];
    }
    return entries;
};
const se_CreateVerifiedAccessTrustProviderDeviceOptions = (input, context) => {
    const entries = {};
    if (input[_TIe] != null) {
        entries[_TIe] = input[_TIe];
    }
    if (input[_PSKU] != null) {
        entries[_PSKU] = input[_PSKU];
    }
    return entries;
};
const se_CreateVerifiedAccessTrustProviderOidcOptions = (input, context) => {
    const entries = {};
    if (input[_I] != null) {
        entries[_I] = input[_I];
    }
    if (input[_AE] != null) {
        entries[_AE] = input[_AE];
    }
    if (input[_TEo] != null) {
        entries[_TEo] = input[_TEo];
    }
    if (input[_UIE] != null) {
        entries[_UIE] = input[_UIE];
    }
    if (input[_CIl] != null) {
        entries[_CIl] = input[_CIl];
    }
    if (input[_CSl] != null) {
        entries[_CSl] = input[_CSl];
    }
    if (input[_Sc] != null) {
        entries[_Sc] = input[_Sc];
    }
    return entries;
};
const se_CreateVerifiedAccessTrustProviderRequest = (input, context) => {
    const entries = {};
    if (input[_TPT] != null) {
        entries[_TPT] = input[_TPT];
    }
    if (input[_UTPT] != null) {
        entries[_UTPT] = input[_UTPT];
    }
    if (input[_DTPT] != null) {
        entries[_DTPT] = input[_DTPT];
    }
    if (input[_OO] != null) {
        const memberEntries = se_CreateVerifiedAccessTrustProviderOidcOptions(input[_OO], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `OidcOptions.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_DOe] != null) {
        const memberEntries = se_CreateVerifiedAccessTrustProviderDeviceOptions(input[_DOe], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DeviceOptions.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_PRN] != null) {
        entries[_PRN] = input[_PRN];
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_SS] != null) {
        const memberEntries = se_VerifiedAccessSseSpecificationRequest(input[_SS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SseSpecification.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_NAOO] != null) {
        const memberEntries = se_CreateVerifiedAccessNativeApplicationOidcOptions(input[_NAOO], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `NativeApplicationOidcOptions.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateVolumePermission = (input, context) => {
    const entries = {};
    if (input[_UIs] != null) {
        entries[_UIs] = input[_UIs];
    }
    if (input[_Gr] != null) {
        entries[_Gr] = input[_Gr];
    }
    return entries;
};
const se_CreateVolumePermissionList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_CreateVolumePermission(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Item.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_CreateVolumePermissionModifications = (input, context) => {
    const entries = {};
    if (input[_Add] != null) {
        const memberEntries = se_CreateVolumePermissionList(input[_Add], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Add.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Rem] != null) {
        const memberEntries = se_CreateVolumePermissionList(input[_Rem], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Remove.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateVolumeRequest = (input, context) => {
    const entries = {};
    if (input[_AZ] != null) {
        entries[_AZ] = input[_AZ];
    }
    if (input[_AZI] != null) {
        entries[_AZI] = input[_AZI];
    }
    if (input[_Enc] != null) {
        entries[_Enc] = input[_Enc];
    }
    if (input[_Io] != null) {
        entries[_Io] = input[_Io];
    }
    if (input[_KKI] != null) {
        entries[_KKI] = input[_KKI];
    }
    if (input[_OA] != null) {
        entries[_OA] = input[_OA];
    }
    if (input[_Siz] != null) {
        entries[_Siz] = input[_Siz];
    }
    if (input[_SIn] != null) {
        entries[_SIn] = input[_SIn];
    }
    if (input[_VT] != null) {
        entries[_VT] = input[_VT];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MAE] != null) {
        entries[_MAE] = input[_MAE];
    }
    if (input[_Th] != null) {
        entries[_Th] = input[_Th];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_VIR] != null) {
        entries[_VIR] = input[_VIR];
    }
    if (input[_O] != null) {
        const memberEntries = se_OperatorRequest(input[_O], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Operator.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreateVpcBlockPublicAccessExclusionRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_SIub] != null) {
        entries[_SIub] = input[_SIub];
    }
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    if (input[_IGEM] != null) {
        entries[_IGEM] = input[_IGEM];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateVpcEndpointConnectionNotificationRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_SIe] != null) {
        entries[_SIe] = input[_SIe];
    }
    if (input[_VEIp] != null) {
        entries[_VEIp] = input[_VEIp];
    }
    if (input[_CNAon] != null) {
        entries[_CNAon] = input[_CNAon];
    }
    if (input[_CEo] != null) {
        const memberEntries = se_ValueStringList(input[_CEo], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ConnectionEvents.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    return entries;
};
const se_CreateVpcEndpointRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_VET] != null) {
        entries[_VET] = input[_VET];
    }
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    if (input[_SNe] != null) {
        entries[_SNe] = input[_SNe];
    }
    if (input[_PD] != null) {
        entries[_PD] = input[_PD];
    }
    if (input[_RTIo] != null) {
        const memberEntries = se_VpcEndpointRouteTableIdList(input[_RTIo], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `RouteTableId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_SIu] != null) {
        const memberEntries = se_VpcEndpointSubnetIdList(input[_SIu], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SubnetId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_SGI] != null) {
        const memberEntries = se_VpcEndpointSecurityGroupIdList(input[_SGI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SecurityGroupId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_IAT] != null) {
        entries[_IAT] = input[_IAT];
    }
    if (input[_DOn] != null) {
        const memberEntries = se_DnsOptionsSpecification(input[_DOn], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DnsOptions.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_PDE] != null) {
        entries[_PDE] = input[_PDE];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_SC] != null) {
        const memberEntries = se_SubnetConfigurationsList(input[_SC], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SubnetConfiguration.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_SNA] != null) {
        entries[_SNA] = input[_SNA];
    }
    if (input[_RCA] != null) {
        entries[_RCA] = input[_RCA];
    }
    if (input[_SRe] != null) {
        entries[_SRe] = input[_SRe];
    }
    return entries;
};
const se_CreateVpcEndpointServiceConfigurationRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_ARc] != null) {
        entries[_ARc] = input[_ARc];
    }
    if (input[_PDN] != null) {
        entries[_PDN] = input[_PDN];
    }
    if (input[_NLBAe] != null) {
        const memberEntries = se_ValueStringList(input[_NLBAe], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `NetworkLoadBalancerArn.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_GLBA] != null) {
        const memberEntries = se_ValueStringList(input[_GLBA], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `GatewayLoadBalancerArn.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_SIAT] != null) {
        const memberEntries = se_ValueStringList(input[_SIAT], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SupportedIpAddressType.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_SRu] != null) {
        const memberEntries = se_ValueStringList(input[_SRu], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SupportedRegion.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateVpcPeeringConnectionRequest = (input, context) => {
    const entries = {};
    if (input[_PRee] != null) {
        entries[_PRee] = input[_PRee];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    if (input[_PVI] != null) {
        entries[_PVI] = input[_PVI];
    }
    if (input[_POI] != null) {
        entries[_POI] = input[_POI];
    }
    return entries;
};
const se_CreateVpcRequest = (input, context) => {
    const entries = {};
    if (input[_CB] != null) {
        entries[_CB] = input[_CB];
    }
    if (input[_IPpv] != null) {
        entries[_IPpv] = input[_IPpv];
    }
    if (input[_ICB] != null) {
        entries[_ICB] = input[_ICB];
    }
    if (input[_IIPIp] != null) {
        entries[_IIPIp] = input[_IIPIp];
    }
    if (input[_INLp] != null) {
        entries[_INLp] = input[_INLp];
    }
    if (input[_IIPI] != null) {
        entries[_IIPI] = input[_IIPI];
    }
    if (input[_INL] != null) {
        entries[_INL] = input[_INL];
    }
    if (input[_ICBNBG] != null) {
        entries[_ICBNBG] = input[_ICBNBG];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_ITns] != null) {
        entries[_ITns] = input[_ITns];
    }
    if (input[_APICB] != null) {
        entries[_APICB] = input[_APICB];
    }
    return entries;
};
const se_CreateVpnConnectionRequest = (input, context) => {
    const entries = {};
    if (input[_CGIu] != null) {
        entries[_CGIu] = input[_CGIu];
    }
    if (input[_T] != null) {
        entries[_T] = input[_T];
    }
    if (input[_VGI] != null) {
        entries[_VGI] = input[_VGI];
    }
    if (input[_TGI] != null) {
        entries[_TGI] = input[_TGI];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_PSKS] != null) {
        entries[_PSKS] = input[_PSKS];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Op] != null) {
        const memberEntries = se_VpnConnectionOptionsSpecification(input[_Op], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Options.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateVpnConnectionRouteRequest = (input, context) => {
    const entries = {};
    if (input[_DCBe] != null) {
        entries[_DCBe] = input[_DCBe];
    }
    if (input[_VCI] != null) {
        entries[_VCI] = input[_VCI];
    }
    return entries;
};
const se_CreateVpnGatewayRequest = (input, context) => {
    const entries = {};
    if (input[_AZ] != null) {
        entries[_AZ] = input[_AZ];
    }
    if (input[_T] != null) {
        entries[_T] = input[_T];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_ASA] != null) {
        entries[_ASA] = input[_ASA];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_CreationDateConditionRequest = (input, context) => {
    const entries = {};
    if (input[_MDSC] != null) {
        entries[_MDSC] = input[_MDSC];
    }
    return entries;
};
const se_CreditSpecificationRequest = (input, context) => {
    const entries = {};
    if (input[_CCp] != null) {
        entries[_CCp] = input[_CCp];
    }
    return entries;
};
const se_CustomerGatewayIdStringList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`CustomerGatewayId.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_DataQueries = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_DataQuery(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Member.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_DataQuery = (input, context) => {
    const entries = {};
    if (input[_Id] != null) {
        entries[_Id] = input[_Id];
    }
    if (input[_S] != null) {
        entries[_S] = input[_S];
    }
    if (input[_D] != null) {
        entries[_D] = input[_D];
    }
    if (input[_Met] != null) {
        entries[_Met] = input[_Met];
    }
    if (input[_Sta] != null) {
        entries[_Sta] = input[_Sta];
    }
    if (input[_Per] != null) {
        entries[_Per] = input[_Per];
    }
    return entries;
};
const se_DedicatedHostIdList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_DeleteCarrierGatewayRequest = (input, context) => {
    const entries = {};
    if (input[_CGI] != null) {
        entries[_CGI] = input[_CGI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteClientVpnEndpointRequest = (input, context) => {
    const entries = {};
    if (input[_CVEI] != null) {
        entries[_CVEI] = input[_CVEI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteClientVpnRouteRequest = (input, context) => {
    const entries = {};
    if (input[_CVEI] != null) {
        entries[_CVEI] = input[_CVEI];
    }
    if (input[_TVSI] != null) {
        entries[_TVSI] = input[_TVSI];
    }
    if (input[_DCBe] != null) {
        entries[_DCBe] = input[_DCBe];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteCoipCidrRequest = (input, context) => {
    const entries = {};
    if (input[_C] != null) {
        entries[_C] = input[_C];
    }
    if (input[_CPIo] != null) {
        entries[_CPIo] = input[_CPIo];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteCoipPoolRequest = (input, context) => {
    const entries = {};
    if (input[_CPIo] != null) {
        entries[_CPIo] = input[_CPIo];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteCustomerGatewayRequest = (input, context) => {
    const entries = {};
    if (input[_CGIu] != null) {
        entries[_CGIu] = input[_CGIu];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteDhcpOptionsRequest = (input, context) => {
    const entries = {};
    if (input[_DOI] != null) {
        entries[_DOI] = input[_DOI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteEgressOnlyInternetGatewayRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_EOIGI] != null) {
        entries[_EOIGI] = input[_EOIGI];
    }
    return entries;
};
const se_DeleteFleetsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_FI] != null) {
        const memberEntries = se_FleetIdSet(input[_FI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `FleetId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_TI] != null) {
        entries[_TI] = input[_TI];
    }
    return entries;
};
const se_DeleteFlowLogsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_FLI] != null) {
        const memberEntries = se_FlowLogIdList(input[_FLI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `FlowLogId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DeleteFpgaImageRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_FII] != null) {
        entries[_FII] = input[_FII];
    }
    return entries;
};
const se_DeleteImageUsageReportRequest = (input, context) => {
    const entries = {};
    if (input[_RIep] != null) {
        entries[_RIep] = input[_RIep];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteInstanceConnectEndpointRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_ICEI] != null) {
        entries[_ICEI] = input[_ICEI];
    }
    return entries;
};
const se_DeleteInstanceEventWindowRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_FD] != null) {
        entries[_FD] = input[_FD];
    }
    if (input[_IEWI] != null) {
        entries[_IEWI] = input[_IEWI];
    }
    return entries;
};
const se_DeleteInternetGatewayRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IGI] != null) {
        entries[_IGI] = input[_IGI];
    }
    return entries;
};
const se_DeleteIpamExternalResourceVerificationTokenRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IERVTI] != null) {
        entries[_IERVTI] = input[_IERVTI];
    }
    return entries;
};
const se_DeleteIpamPoolRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IPI] != null) {
        entries[_IPI] = input[_IPI];
    }
    if (input[_Ca] != null) {
        entries[_Ca] = input[_Ca];
    }
    return entries;
};
const se_DeleteIpamRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IIp] != null) {
        entries[_IIp] = input[_IIp];
    }
    if (input[_Ca] != null) {
        entries[_Ca] = input[_Ca];
    }
    return entries;
};
const se_DeleteIpamResourceDiscoveryRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IRDI] != null) {
        entries[_IRDI] = input[_IRDI];
    }
    return entries;
};
const se_DeleteIpamScopeRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_ISI] != null) {
        entries[_ISI] = input[_ISI];
    }
    return entries;
};
const se_DeleteKeyPairRequest = (input, context) => {
    const entries = {};
    if (input[_KN] != null) {
        entries[_KN] = input[_KN];
    }
    if (input[_KPI] != null) {
        entries[_KPI] = input[_KPI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteLaunchTemplateRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_LTI] != null) {
        entries[_LTI] = input[_LTI];
    }
    if (input[_LTN] != null) {
        entries[_LTN] = input[_LTN];
    }
    return entries;
};
const se_DeleteLaunchTemplateVersionsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_LTI] != null) {
        entries[_LTI] = input[_LTI];
    }
    if (input[_LTN] != null) {
        entries[_LTN] = input[_LTN];
    }
    if (input[_Ve] != null) {
        const memberEntries = se_VersionStringList(input[_Ve], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `LaunchTemplateVersion.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DeleteLocalGatewayRouteRequest = (input, context) => {
    const entries = {};
    if (input[_DCBe] != null) {
        entries[_DCBe] = input[_DCBe];
    }
    if (input[_LGRTI] != null) {
        entries[_LGRTI] = input[_LGRTI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_DPLI] != null) {
        entries[_DPLI] = input[_DPLI];
    }
    return entries;
};
const se_DeleteLocalGatewayRouteTableRequest = (input, context) => {
    const entries = {};
    if (input[_LGRTI] != null) {
        entries[_LGRTI] = input[_LGRTI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest = (input, context) => {
    const entries = {};
    if (input[_LGRTVIGAI] != null) {
        entries[_LGRTVIGAI] = input[_LGRTVIGAI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteLocalGatewayRouteTableVpcAssociationRequest = (input, context) => {
    const entries = {};
    if (input[_LGRTVAI] != null) {
        entries[_LGRTVAI] = input[_LGRTVAI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteLocalGatewayVirtualInterfaceGroupRequest = (input, context) => {
    const entries = {};
    if (input[_LGVIGI] != null) {
        entries[_LGVIGI] = input[_LGVIGI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteLocalGatewayVirtualInterfaceRequest = (input, context) => {
    const entries = {};
    if (input[_LGVII] != null) {
        entries[_LGVII] = input[_LGVII];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteManagedPrefixListRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_PLI] != null) {
        entries[_PLI] = input[_PLI];
    }
    return entries;
};
const se_DeleteNatGatewayRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_NGI] != null) {
        entries[_NGI] = input[_NGI];
    }
    return entries;
};
const se_DeleteNetworkAclEntryRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_NAI] != null) {
        entries[_NAI] = input[_NAI];
    }
    if (input[_RNu] != null) {
        entries[_RNu] = input[_RNu];
    }
    if (input[_Eg] != null) {
        entries[_Eg] = input[_Eg];
    }
    return entries;
};
const se_DeleteNetworkAclRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_NAI] != null) {
        entries[_NAI] = input[_NAI];
    }
    return entries;
};
const se_DeleteNetworkInsightsAccessScopeAnalysisRequest = (input, context) => {
    const entries = {};
    if (input[_NIASAI] != null) {
        entries[_NIASAI] = input[_NIASAI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteNetworkInsightsAccessScopeRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_NIASI] != null) {
        entries[_NIASI] = input[_NIASI];
    }
    return entries;
};
const se_DeleteNetworkInsightsAnalysisRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_NIAI] != null) {
        entries[_NIAI] = input[_NIAI];
    }
    return entries;
};
const se_DeleteNetworkInsightsPathRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_NIPI] != null) {
        entries[_NIPI] = input[_NIPI];
    }
    return entries;
};
const se_DeleteNetworkInterfacePermissionRequest = (input, context) => {
    const entries = {};
    if (input[_NIPIe] != null) {
        entries[_NIPIe] = input[_NIPIe];
    }
    if (input[_F] != null) {
        entries[_F] = input[_F];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteNetworkInterfaceRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_NII] != null) {
        entries[_NII] = input[_NII];
    }
    return entries;
};
const se_DeletePlacementGroupRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_GN] != null) {
        entries[_GN] = input[_GN];
    }
    return entries;
};
const se_DeletePublicIpv4PoolRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_PIo] != null) {
        entries[_PIo] = input[_PIo];
    }
    if (input[_NBG] != null) {
        entries[_NBG] = input[_NBG];
    }
    return entries;
};
const se_DeleteQueuedReservedInstancesIdList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_DeleteQueuedReservedInstancesRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_RIIes] != null) {
        const memberEntries = se_DeleteQueuedReservedInstancesIdList(input[_RIIes], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ReservedInstancesId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DeleteRouteRequest = (input, context) => {
    const entries = {};
    if (input[_DPLI] != null) {
        entries[_DPLI] = input[_DPLI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_RTI] != null) {
        entries[_RTI] = input[_RTI];
    }
    if (input[_DCBe] != null) {
        entries[_DCBe] = input[_DCBe];
    }
    if (input[_DICB] != null) {
        entries[_DICB] = input[_DICB];
    }
    return entries;
};
const se_DeleteRouteServerEndpointRequest = (input, context) => {
    const entries = {};
    if (input[_RSEI] != null) {
        entries[_RSEI] = input[_RSEI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteRouteServerPeerRequest = (input, context) => {
    const entries = {};
    if (input[_RSPI] != null) {
        entries[_RSPI] = input[_RSPI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteRouteServerRequest = (input, context) => {
    const entries = {};
    if (input[_RSIo] != null) {
        entries[_RSIo] = input[_RSIo];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteRouteTableRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_RTI] != null) {
        entries[_RTI] = input[_RTI];
    }
    return entries;
};
const se_DeleteSecurityGroupRequest = (input, context) => {
    const entries = {};
    if (input[_GIr] != null) {
        entries[_GIr] = input[_GIr];
    }
    if (input[_GN] != null) {
        entries[_GN] = input[_GN];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteSnapshotRequest = (input, context) => {
    const entries = {};
    if (input[_SIn] != null) {
        entries[_SIn] = input[_SIn];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteSpotDatafeedSubscriptionRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteSubnetCidrReservationRequest = (input, context) => {
    const entries = {};
    if (input[_SCRIu] != null) {
        entries[_SCRIu] = input[_SCRIu];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteSubnetRequest = (input, context) => {
    const entries = {};
    if (input[_SIub] != null) {
        entries[_SIub] = input[_SIub];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteTagsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Re] != null) {
        const memberEntries = se_ResourceIdList(input[_Re], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ResourceId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Ta] != null) {
        const memberEntries = se_TagList(input[_Ta], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tag.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DeleteTrafficMirrorFilterRequest = (input, context) => {
    const entries = {};
    if (input[_TMFI] != null) {
        entries[_TMFI] = input[_TMFI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteTrafficMirrorFilterRuleRequest = (input, context) => {
    const entries = {};
    if (input[_TMFRI] != null) {
        entries[_TMFRI] = input[_TMFRI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteTrafficMirrorSessionRequest = (input, context) => {
    const entries = {};
    if (input[_TMSI] != null) {
        entries[_TMSI] = input[_TMSI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteTrafficMirrorTargetRequest = (input, context) => {
    const entries = {};
    if (input[_TMTI] != null) {
        entries[_TMTI] = input[_TMTI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteTransitGatewayConnectPeerRequest = (input, context) => {
    const entries = {};
    if (input[_TGCPI] != null) {
        entries[_TGCPI] = input[_TGCPI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteTransitGatewayConnectRequest = (input, context) => {
    const entries = {};
    if (input[_TGAI] != null) {
        entries[_TGAI] = input[_TGAI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteTransitGatewayMulticastDomainRequest = (input, context) => {
    const entries = {};
    if (input[_TGMDI] != null) {
        entries[_TGMDI] = input[_TGMDI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteTransitGatewayPeeringAttachmentRequest = (input, context) => {
    const entries = {};
    if (input[_TGAI] != null) {
        entries[_TGAI] = input[_TGAI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteTransitGatewayPolicyTableRequest = (input, context) => {
    const entries = {};
    if (input[_TGPTI] != null) {
        entries[_TGPTI] = input[_TGPTI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteTransitGatewayPrefixListReferenceRequest = (input, context) => {
    const entries = {};
    if (input[_TGRTI] != null) {
        entries[_TGRTI] = input[_TGRTI];
    }
    if (input[_PLI] != null) {
        entries[_PLI] = input[_PLI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteTransitGatewayRequest = (input, context) => {
    const entries = {};
    if (input[_TGI] != null) {
        entries[_TGI] = input[_TGI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteTransitGatewayRouteRequest = (input, context) => {
    const entries = {};
    if (input[_TGRTI] != null) {
        entries[_TGRTI] = input[_TGRTI];
    }
    if (input[_DCBe] != null) {
        entries[_DCBe] = input[_DCBe];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteTransitGatewayRouteTableAnnouncementRequest = (input, context) => {
    const entries = {};
    if (input[_TGRTAI] != null) {
        entries[_TGRTAI] = input[_TGRTAI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteTransitGatewayRouteTableRequest = (input, context) => {
    const entries = {};
    if (input[_TGRTI] != null) {
        entries[_TGRTI] = input[_TGRTI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteTransitGatewayVpcAttachmentRequest = (input, context) => {
    const entries = {};
    if (input[_TGAI] != null) {
        entries[_TGAI] = input[_TGAI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteVerifiedAccessEndpointRequest = (input, context) => {
    const entries = {};
    if (input[_VAEI] != null) {
        entries[_VAEI] = input[_VAEI];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteVerifiedAccessGroupRequest = (input, context) => {
    const entries = {};
    if (input[_VAGI] != null) {
        entries[_VAGI] = input[_VAGI];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteVerifiedAccessInstanceRequest = (input, context) => {
    const entries = {};
    if (input[_VAII] != null) {
        entries[_VAII] = input[_VAII];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    return entries;
};
const se_DeleteVerifiedAccessTrustProviderRequest = (input, context) => {
    const entries = {};
    if (input[_VATPI] != null) {
        entries[_VATPI] = input[_VATPI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    return entries;
};
const se_DeleteVolumeRequest = (input, context) => {
    const entries = {};
    if (input[_VIo] != null) {
        entries[_VIo] = input[_VIo];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteVpcBlockPublicAccessExclusionRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_EIxc] != null) {
        entries[_EIxc] = input[_EIxc];
    }
    return entries;
};
const se_DeleteVpcEndpointConnectionNotificationsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_CNIo] != null) {
        const memberEntries = se_ConnectionNotificationIdsList(input[_CNIo], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ConnectionNotificationId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DeleteVpcEndpointServiceConfigurationsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_SIer] != null) {
        const memberEntries = se_VpcEndpointServiceIdList(input[_SIer], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ServiceId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DeleteVpcEndpointsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_VEI] != null) {
        const memberEntries = se_VpcEndpointIdList(input[_VEI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpcEndpointId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DeleteVpcPeeringConnectionRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_VPCI] != null) {
        entries[_VPCI] = input[_VPCI];
    }
    return entries;
};
const se_DeleteVpcRequest = (input, context) => {
    const entries = {};
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteVpnConnectionRequest = (input, context) => {
    const entries = {};
    if (input[_VCI] != null) {
        entries[_VCI] = input[_VCI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeleteVpnConnectionRouteRequest = (input, context) => {
    const entries = {};
    if (input[_DCBe] != null) {
        entries[_DCBe] = input[_DCBe];
    }
    if (input[_VCI] != null) {
        entries[_VCI] = input[_VCI];
    }
    return entries;
};
const se_DeleteVpnGatewayRequest = (input, context) => {
    const entries = {};
    if (input[_VGI] != null) {
        entries[_VGI] = input[_VGI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeprecationTimeConditionRequest = (input, context) => {
    const entries = {};
    if (input[_MDSD] != null) {
        entries[_MDSD] = input[_MDSD];
    }
    return entries;
};
const se_DeprovisionByoipCidrRequest = (input, context) => {
    const entries = {};
    if (input[_C] != null) {
        entries[_C] = input[_C];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeprovisionIpamByoasnRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IIp] != null) {
        entries[_IIp] = input[_IIp];
    }
    if (input[_As] != null) {
        entries[_As] = input[_As];
    }
    return entries;
};
const se_DeprovisionIpamPoolCidrRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IPI] != null) {
        entries[_IPI] = input[_IPI];
    }
    if (input[_C] != null) {
        entries[_C] = input[_C];
    }
    return entries;
};
const se_DeprovisionPublicIpv4PoolCidrRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_PIo] != null) {
        entries[_PIo] = input[_PIo];
    }
    if (input[_C] != null) {
        entries[_C] = input[_C];
    }
    return entries;
};
const se_DeregisterImageRequest = (input, context) => {
    const entries = {};
    if (input[_IIma] != null) {
        entries[_IIma] = input[_IIma];
    }
    if (input[_DAS] != null) {
        entries[_DAS] = input[_DAS];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeregisterInstanceEventNotificationAttributesRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_ITA] != null) {
        const memberEntries = se_DeregisterInstanceTagAttributeRequest(input[_ITA], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InstanceTagAttribute.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DeregisterInstanceTagAttributeRequest = (input, context) => {
    const entries = {};
    if (input[_IATOI] != null) {
        entries[_IATOI] = input[_IATOI];
    }
    if (input[_ITK] != null) {
        const memberEntries = se_InstanceTagKeySet(input[_ITK], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InstanceTagKey.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DeregisterTransitGatewayMulticastGroupMembersRequest = (input, context) => {
    const entries = {};
    if (input[_TGMDI] != null) {
        entries[_TGMDI] = input[_TGMDI];
    }
    if (input[_GIA] != null) {
        entries[_GIA] = input[_GIA];
    }
    if (input[_NIIe] != null) {
        const memberEntries = se_TransitGatewayNetworkInterfaceIdList(input[_NIIe], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `NetworkInterfaceIds.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DeregisterTransitGatewayMulticastGroupSourcesRequest = (input, context) => {
    const entries = {};
    if (input[_TGMDI] != null) {
        entries[_TGMDI] = input[_TGMDI];
    }
    if (input[_GIA] != null) {
        entries[_GIA] = input[_GIA];
    }
    if (input[_NIIe] != null) {
        const memberEntries = se_TransitGatewayNetworkInterfaceIdList(input[_NIIe], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `NetworkInterfaceIds.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeAccountAttributesRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_AN] != null) {
        const memberEntries = se_AccountAttributeNameStringList(input[_AN], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `AttributeName.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeAddressesAttributeRequest = (input, context) => {
    const entries = {};
    if (input[_AIll] != null) {
        const memberEntries = se_AllocationIds(input[_AIll], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `AllocationId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_At] != null) {
        entries[_At] = input[_At];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeAddressesRequest = (input, context) => {
    const entries = {};
    if (input[_PIu] != null) {
        const memberEntries = se_PublicIpStringList(input[_PIu], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `PublicIp.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_AIll] != null) {
        const memberEntries = se_AllocationIdList(input[_AIll], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `AllocationId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeAddressTransfersRequest = (input, context) => {
    const entries = {};
    if (input[_AIll] != null) {
        const memberEntries = se_AllocationIdList(input[_AIll], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `AllocationId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeAggregateIdFormatRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeAvailabilityZonesRequest = (input, context) => {
    const entries = {};
    if (input[_ZN] != null) {
        const memberEntries = se_ZoneNameStringList(input[_ZN], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ZoneName.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_ZI] != null) {
        const memberEntries = se_ZoneIdStringList(input[_ZI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ZoneId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_AAZ] != null) {
        entries[_AAZ] = input[_AAZ];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeAwsNetworkPerformanceMetricSubscriptionsRequest = (input, context) => {
    const entries = {};
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeBundleTasksRequest = (input, context) => {
    const entries = {};
    if (input[_BIun] != null) {
        const memberEntries = se_BundleIdStringList(input[_BIun], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `BundleId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeByoipCidrsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeCapacityBlockExtensionHistoryRequest = (input, context) => {
    const entries = {};
    if (input[_CRIa] != null) {
        const memberEntries = se_CapacityReservationIdSet(input[_CRIa], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `CapacityReservationId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeCapacityBlockExtensionOfferingsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_CBEDH] != null) {
        entries[_CBEDH] = input[_CBEDH];
    }
    if (input[_CRI] != null) {
        entries[_CRI] = input[_CRI];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeCapacityBlockOfferingsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IT] != null) {
        entries[_IT] = input[_IT];
    }
    if (input[_IC] != null) {
        entries[_IC] = input[_IC];
    }
    if (input[_SDR] != null) {
        entries[_SDR] = __serializeDateTime(input[_SDR]);
    }
    if (input[_EDR] != null) {
        entries[_EDR] = __serializeDateTime(input[_EDR]);
    }
    if (input[_CDH] != null) {
        entries[_CDH] = input[_CDH];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_UTl] != null) {
        entries[_UTl] = input[_UTl];
    }
    if (input[_UC] != null) {
        entries[_UC] = input[_UC];
    }
    return entries;
};
const se_DescribeCapacityBlocksRequest = (input, context) => {
    const entries = {};
    if (input[_CBI] != null) {
        const memberEntries = se_CapacityBlockIds(input[_CBI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `CapacityBlockId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeCapacityBlockStatusRequest = (input, context) => {
    const entries = {};
    if (input[_CBI] != null) {
        const memberEntries = se_CapacityBlockIds(input[_CBI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `CapacityBlockId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeCapacityReservationBillingRequestsRequest = (input, context) => {
    const entries = {};
    if (input[_CRIa] != null) {
        const memberEntries = se_CapacityReservationIdSet(input[_CRIa], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `CapacityReservationId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Ro] != null) {
        entries[_Ro] = input[_Ro];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeCapacityReservationFleetsRequest = (input, context) => {
    const entries = {};
    if (input[_CRFI] != null) {
        const memberEntries = se_CapacityReservationFleetIdSet(input[_CRFI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `CapacityReservationFleetId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeCapacityReservationsRequest = (input, context) => {
    const entries = {};
    if (input[_CRIa] != null) {
        const memberEntries = se_CapacityReservationIdSet(input[_CRIa], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `CapacityReservationId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeCarrierGatewaysRequest = (input, context) => {
    const entries = {};
    if (input[_CGIa] != null) {
        const memberEntries = se_CarrierGatewayIdSet(input[_CGIa], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `CarrierGatewayId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeClassicLinkInstancesRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IIns] != null) {
        const memberEntries = se_InstanceIdStringList(input[_IIns], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InstanceId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeClientVpnAuthorizationRulesRequest = (input, context) => {
    const entries = {};
    if (input[_CVEI] != null) {
        entries[_CVEI] = input[_CVEI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeClientVpnConnectionsRequest = (input, context) => {
    const entries = {};
    if (input[_CVEI] != null) {
        entries[_CVEI] = input[_CVEI];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeClientVpnEndpointsRequest = (input, context) => {
    const entries = {};
    if (input[_CVEIl] != null) {
        const memberEntries = se_ClientVpnEndpointIdList(input[_CVEIl], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ClientVpnEndpointId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeClientVpnRoutesRequest = (input, context) => {
    const entries = {};
    if (input[_CVEI] != null) {
        entries[_CVEI] = input[_CVEI];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeClientVpnTargetNetworksRequest = (input, context) => {
    const entries = {};
    if (input[_CVEI] != null) {
        entries[_CVEI] = input[_CVEI];
    }
    if (input[_AIs] != null) {
        const memberEntries = se_ValueStringList(input[_AIs], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `AssociationIds.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeCoipPoolsRequest = (input, context) => {
    const entries = {};
    if (input[_PIoo] != null) {
        const memberEntries = se_CoipPoolIdSet(input[_PIoo], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `PoolId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeConversionTasksRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_CTIo] != null) {
        const memberEntries = se_ConversionIdStringList(input[_CTIo], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ConversionTaskId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeCustomerGatewaysRequest = (input, context) => {
    const entries = {};
    if (input[_CGIus] != null) {
        const memberEntries = se_CustomerGatewayIdStringList(input[_CGIus], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `CustomerGatewayId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeDeclarativePoliciesReportsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_RIepo] != null) {
        const memberEntries = se_ValueStringList(input[_RIepo], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ReportId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeDhcpOptionsRequest = (input, context) => {
    const entries = {};
    if (input[_DOIh] != null) {
        const memberEntries = se_DhcpOptionsIdStringList(input[_DOIh], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DhcpOptionsId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeEgressOnlyInternetGatewaysRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_EOIGIg] != null) {
        const memberEntries = se_EgressOnlyInternetGatewayIdList(input[_EOIGIg], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `EgressOnlyInternetGatewayId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeElasticGpusRequest = (input, context) => {
    const entries = {};
    if (input[_EGI] != null) {
        const memberEntries = se_ElasticGpuIdSet(input[_EGI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ElasticGpuId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeExportImageTasksRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_EITI] != null) {
        const memberEntries = se_ExportImageTaskIdList(input[_EITI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ExportImageTaskId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeExportTasksRequest = (input, context) => {
    const entries = {};
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_ETIx] != null) {
        const memberEntries = se_ExportTaskIdStringList(input[_ETIx], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ExportTaskId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeFastLaunchImagesRequest = (input, context) => {
    const entries = {};
    if (input[_IImag] != null) {
        const memberEntries = se_FastLaunchImageIdList(input[_IImag], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ImageId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeFastSnapshotRestoresRequest = (input, context) => {
    const entries = {};
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeFleetHistoryRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_ETv] != null) {
        entries[_ETv] = input[_ETv];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_FIl] != null) {
        entries[_FIl] = input[_FIl];
    }
    if (input[_STt] != null) {
        entries[_STt] = __serializeDateTime(input[_STt]);
    }
    return entries;
};
const se_DescribeFleetInstancesRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_FIl] != null) {
        entries[_FIl] = input[_FIl];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeFleetsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_FI] != null) {
        const memberEntries = se_FleetIdSet(input[_FI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `FleetId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeFlowLogsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fil] != null) {
        const memberEntries = se_FilterList(input[_Fil], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_FLI] != null) {
        const memberEntries = se_FlowLogIdList(input[_FLI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `FlowLogId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeFpgaImageAttributeRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_FII] != null) {
        entries[_FII] = input[_FII];
    }
    if (input[_At] != null) {
        entries[_At] = input[_At];
    }
    return entries;
};
const se_DescribeFpgaImagesRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_FIIp] != null) {
        const memberEntries = se_FpgaImageIdList(input[_FIIp], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `FpgaImageId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Ow] != null) {
        const memberEntries = se_OwnerStringList(input[_Ow], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Owner.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeHostReservationOfferingsRequest = (input, context) => {
    const entries = {};
    if (input[_Fil] != null) {
        const memberEntries = se_FilterList(input[_Fil], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MD] != null) {
        entries[_MD] = input[_MD];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_MDi] != null) {
        entries[_MDi] = input[_MDi];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_OI] != null) {
        entries[_OI] = input[_OI];
    }
    return entries;
};
const se_DescribeHostReservationsRequest = (input, context) => {
    const entries = {};
    if (input[_Fil] != null) {
        const memberEntries = se_FilterList(input[_Fil], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_HRIS] != null) {
        const memberEntries = se_HostReservationIdSet(input[_HRIS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `HostReservationIdSet.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeHostsRequest = (input, context) => {
    const entries = {};
    if (input[_HI] != null) {
        const memberEntries = se_RequestHostIdList(input[_HI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `HostId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Fil] != null) {
        const memberEntries = se_FilterList(input[_Fil], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeIamInstanceProfileAssociationsRequest = (input, context) => {
    const entries = {};
    if (input[_AIs] != null) {
        const memberEntries = se_AssociationIdList(input[_AIs], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `AssociationId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeIdentityIdFormatRequest = (input, context) => {
    const entries = {};
    if (input[_Res] != null) {
        entries[_Res] = input[_Res];
    }
    if (input[_PAr] != null) {
        entries[_PAr] = input[_PAr];
    }
    return entries;
};
const se_DescribeIdFormatRequest = (input, context) => {
    const entries = {};
    if (input[_Res] != null) {
        entries[_Res] = input[_Res];
    }
    return entries;
};
const se_DescribeImageAttributeRequest = (input, context) => {
    const entries = {};
    if (input[_At] != null) {
        entries[_At] = input[_At];
    }
    if (input[_IIma] != null) {
        entries[_IIma] = input[_IIma];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeImageReferencesImageIdStringList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Member.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_DescribeImageReferencesRequest = (input, context) => {
    const entries = {};
    if (input[_IImag] != null) {
        const memberEntries = se_DescribeImageReferencesImageIdStringList(input[_IImag], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ImageId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_IART] != null) {
        entries[_IART] = input[_IART];
    }
    if (input[_RTe] != null) {
        const memberEntries = se_ResourceTypeRequestList(input[_RTe], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ResourceType.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeImagesRequest = (input, context) => {
    const entries = {};
    if (input[_EU] != null) {
        const memberEntries = se_ExecutableByStringList(input[_EU], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ExecutableBy.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_IImag] != null) {
        const memberEntries = se_ImageIdStringList(input[_IImag], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ImageId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Ow] != null) {
        const memberEntries = se_OwnerStringList(input[_Ow], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Owner.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_ID] != null) {
        entries[_ID] = input[_ID];
    }
    if (input[_IDn] != null) {
        entries[_IDn] = input[_IDn];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeImageUsageReportEntriesRequest = (input, context) => {
    const entries = {};
    if (input[_IImag] != null) {
        const memberEntries = se_DescribeImageUsageReportsImageIdStringList(input[_IImag], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ImageId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_RIepo] != null) {
        const memberEntries = se_ImageUsageReportIdStringList(input[_RIepo], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ReportId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeImageUsageReportsImageIdStringList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Member.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_DescribeImageUsageReportsRequest = (input, context) => {
    const entries = {};
    if (input[_IImag] != null) {
        const memberEntries = se_DescribeImageUsageReportsImageIdStringList(input[_IImag], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ImageId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_RIepo] != null) {
        const memberEntries = se_ImageUsageReportIdStringList(input[_RIepo], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ReportId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeImportImageTasksRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_ITIm] != null) {
        const memberEntries = se_ImportTaskIdList(input[_ITIm], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ImportTaskId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeImportSnapshotTasksRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_ITIm] != null) {
        const memberEntries = se_ImportSnapshotTaskIdList(input[_ITIm], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ImportTaskId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeInstanceAttributeRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IIn] != null) {
        entries[_IIn] = input[_IIn];
    }
    if (input[_At] != null) {
        entries[_At] = input[_At];
    }
    return entries;
};
const se_DescribeInstanceConnectEndpointsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_ICEIn] != null) {
        const memberEntries = se_ValueStringList(input[_ICEIn], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InstanceConnectEndpointId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeInstanceCreditSpecificationsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_IIns] != null) {
        const memberEntries = se_InstanceIdStringList(input[_IIns], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InstanceId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeInstanceEventNotificationAttributesRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeInstanceEventWindowsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IEWIn] != null) {
        const memberEntries = se_InstanceEventWindowIdSet(input[_IEWIn], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InstanceEventWindowId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeInstanceImageMetadataRequest = (input, context) => {
    const entries = {};
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_IIns] != null) {
        const memberEntries = se_InstanceIdStringList(input[_IIns], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InstanceId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeInstancesRequest = (input, context) => {
    const entries = {};
    if (input[_IIns] != null) {
        const memberEntries = se_InstanceIdStringList(input[_IIns], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InstanceId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeInstanceStatusRequest = (input, context) => {
    const entries = {};
    if (input[_IIns] != null) {
        const memberEntries = se_InstanceIdStringList(input[_IIns], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InstanceId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_IAI] != null) {
        entries[_IAI] = input[_IAI];
    }
    return entries;
};
const se_DescribeInstanceTopologyGroupNameSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Member.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_DescribeInstanceTopologyInstanceIdSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Member.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_DescribeInstanceTopologyRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_IIns] != null) {
        const memberEntries = se_DescribeInstanceTopologyInstanceIdSet(input[_IIns], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InstanceId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_GNr] != null) {
        const memberEntries = se_DescribeInstanceTopologyGroupNameSet(input[_GNr], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `GroupName.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeInstanceTypeOfferingsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_LT] != null) {
        entries[_LT] = input[_LT];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeInstanceTypesRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_ITnst] != null) {
        const memberEntries = se_RequestInstanceTypeList(input[_ITnst], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InstanceType.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeInternetGatewaysRequest = (input, context) => {
    const entries = {};
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IGIn] != null) {
        const memberEntries = se_InternetGatewayIdList(input[_IGIn], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InternetGatewayId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeIpamByoasnRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeIpamExternalResourceVerificationTokensRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_IERVTIp] != null) {
        const memberEntries = se_ValueStringList(input[_IERVTIp], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `IpamExternalResourceVerificationTokenId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeIpamPoolsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_IPIp] != null) {
        const memberEntries = se_ValueStringList(input[_IPIp], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `IpamPoolId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeIpamResourceDiscoveriesRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IRDIp] != null) {
        const memberEntries = se_ValueStringList(input[_IRDIp], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `IpamResourceDiscoveryId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeIpamResourceDiscoveryAssociationsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IRDAI] != null) {
        const memberEntries = se_ValueStringList(input[_IRDAI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `IpamResourceDiscoveryAssociationId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeIpamScopesRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_ISIp] != null) {
        const memberEntries = se_ValueStringList(input[_ISIp], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `IpamScopeId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeIpamsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_IIpa] != null) {
        const memberEntries = se_ValueStringList(input[_IIpa], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `IpamId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeIpv6PoolsRequest = (input, context) => {
    const entries = {};
    if (input[_PIoo] != null) {
        const memberEntries = se_Ipv6PoolIdList(input[_PIoo], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `PoolId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeKeyPairsRequest = (input, context) => {
    const entries = {};
    if (input[_KNe] != null) {
        const memberEntries = se_KeyNameStringList(input[_KNe], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `KeyName.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_KPIe] != null) {
        const memberEntries = se_KeyPairIdStringList(input[_KPIe], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `KeyPairId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_IPK] != null) {
        entries[_IPK] = input[_IPK];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeLaunchTemplatesRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_LTIa] != null) {
        const memberEntries = se_LaunchTemplateIdStringList(input[_LTIa], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `LaunchTemplateId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_LTNa] != null) {
        const memberEntries = se_LaunchTemplateNameStringList(input[_LTNa], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `LaunchTemplateName.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeLaunchTemplateVersionsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_LTI] != null) {
        entries[_LTI] = input[_LTI];
    }
    if (input[_LTN] != null) {
        entries[_LTN] = input[_LTN];
    }
    if (input[_Ve] != null) {
        const memberEntries = se_VersionStringList(input[_Ve], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `LaunchTemplateVersion.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MVi] != null) {
        entries[_MVi] = input[_MVi];
    }
    if (input[_MVa] != null) {
        entries[_MVa] = input[_MVa];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_RAe] != null) {
        entries[_RAe] = input[_RAe];
    }
    return entries;
};
const se_DescribeLocalGatewayRouteTablesRequest = (input, context) => {
    const entries = {};
    if (input[_LGRTIo] != null) {
        const memberEntries = se_LocalGatewayRouteTableIdSet(input[_LGRTIo], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `LocalGatewayRouteTableId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest = (input, context) => {
    const entries = {};
    if (input[_LGRTVIGAIo] != null) {
        const memberEntries = se_LocalGatewayRouteTableVirtualInterfaceGroupAssociationIdSet(input[_LGRTVIGAIo], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `LocalGatewayRouteTableVirtualInterfaceGroupAssociationId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeLocalGatewayRouteTableVpcAssociationsRequest = (input, context) => {
    const entries = {};
    if (input[_LGRTVAIo] != null) {
        const memberEntries = se_LocalGatewayRouteTableVpcAssociationIdSet(input[_LGRTVAIo], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `LocalGatewayRouteTableVpcAssociationId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeLocalGatewaysRequest = (input, context) => {
    const entries = {};
    if (input[_LGIo] != null) {
        const memberEntries = se_LocalGatewayIdSet(input[_LGIo], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `LocalGatewayId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeLocalGatewayVirtualInterfaceGroupsRequest = (input, context) => {
    const entries = {};
    if (input[_LGVIGIo] != null) {
        const memberEntries = se_LocalGatewayVirtualInterfaceGroupIdSet(input[_LGVIGIo], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `LocalGatewayVirtualInterfaceGroupId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeLocalGatewayVirtualInterfacesRequest = (input, context) => {
    const entries = {};
    if (input[_LGVIIo] != null) {
        const memberEntries = se_LocalGatewayVirtualInterfaceIdSet(input[_LGVIIo], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `LocalGatewayVirtualInterfaceId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeLockedSnapshotsRequest = (input, context) => {
    const entries = {};
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_SIna] != null) {
        const memberEntries = se_SnapshotIdStringList(input[_SIna], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SnapshotId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeMacHostsRequest = (input, context) => {
    const entries = {};
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_HI] != null) {
        const memberEntries = se_RequestHostIdList(input[_HI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `HostId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeMacModificationTasksRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MMTI] != null) {
        const memberEntries = se_MacModificationTaskIdList(input[_MMTI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `MacModificationTaskId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeManagedPrefixListsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_PLIr] != null) {
        const memberEntries = se_ValueStringList(input[_PLIr], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `PrefixListId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeMovingAddressesRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_PIu] != null) {
        const memberEntries = se_ValueStringList(input[_PIu], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `PublicIp.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeNatGatewaysRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fil] != null) {
        const memberEntries = se_FilterList(input[_Fil], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NGIa] != null) {
        const memberEntries = se_NatGatewayIdStringList(input[_NGIa], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `NatGatewayId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeNetworkAclsRequest = (input, context) => {
    const entries = {};
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_NAIe] != null) {
        const memberEntries = se_NetworkAclIdStringList(input[_NAIe], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `NetworkAclId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeNetworkInsightsAccessScopeAnalysesRequest = (input, context) => {
    const entries = {};
    if (input[_NIASAIe] != null) {
        const memberEntries = se_NetworkInsightsAccessScopeAnalysisIdList(input[_NIASAIe], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `NetworkInsightsAccessScopeAnalysisId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NIASI] != null) {
        entries[_NIASI] = input[_NIASI];
    }
    if (input[_ASTB] != null) {
        entries[_ASTB] = __serializeDateTime(input[_ASTB]);
    }
    if (input[_ASTE] != null) {
        entries[_ASTE] = __serializeDateTime(input[_ASTE]);
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeNetworkInsightsAccessScopesRequest = (input, context) => {
    const entries = {};
    if (input[_NIASIe] != null) {
        const memberEntries = se_NetworkInsightsAccessScopeIdList(input[_NIASIe], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `NetworkInsightsAccessScopeId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeNetworkInsightsAnalysesRequest = (input, context) => {
    const entries = {};
    if (input[_NIAIe] != null) {
        const memberEntries = se_NetworkInsightsAnalysisIdList(input[_NIAIe], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `NetworkInsightsAnalysisId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NIPI] != null) {
        entries[_NIPI] = input[_NIPI];
    }
    if (input[_AST] != null) {
        entries[_AST] = __serializeDateTime(input[_AST]);
    }
    if (input[_AET] != null) {
        entries[_AET] = __serializeDateTime(input[_AET]);
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeNetworkInsightsPathsRequest = (input, context) => {
    const entries = {};
    if (input[_NIPIet] != null) {
        const memberEntries = se_NetworkInsightsPathIdList(input[_NIPIet], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `NetworkInsightsPathId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeNetworkInterfaceAttributeRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_NII] != null) {
        entries[_NII] = input[_NII];
    }
    if (input[_At] != null) {
        entries[_At] = input[_At];
    }
    return entries;
};
const se_DescribeNetworkInterfacePermissionsRequest = (input, context) => {
    const entries = {};
    if (input[_NIPIetw] != null) {
        const memberEntries = se_NetworkInterfacePermissionIdList(input[_NIPIetw], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `NetworkInterfacePermissionId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeNetworkInterfacesRequest = (input, context) => {
    const entries = {};
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_NIIe] != null) {
        const memberEntries = se_NetworkInterfaceIdList(input[_NIIe], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `NetworkInterfaceId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeOutpostLagsRequest = (input, context) => {
    const entries = {};
    if (input[_OLIu] != null) {
        const memberEntries = se_OutpostLagIdSet(input[_OLIu], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `OutpostLagId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribePlacementGroupsRequest = (input, context) => {
    const entries = {};
    if (input[_GIro] != null) {
        const memberEntries = se_PlacementGroupIdStringList(input[_GIro], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `GroupId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_GNr] != null) {
        const memberEntries = se_PlacementGroupStringList(input[_GNr], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `GroupName.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribePrefixListsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_PLIr] != null) {
        const memberEntries = se_PrefixListResourceIdStringList(input[_PLIr], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `PrefixListId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribePrincipalIdFormatRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Re] != null) {
        const memberEntries = se_ResourceList(input[_Re], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Resource.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribePublicIpv4PoolsRequest = (input, context) => {
    const entries = {};
    if (input[_PIoo] != null) {
        const memberEntries = se_PublicIpv4PoolIdStringList(input[_PIoo], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `PoolId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeRegionsRequest = (input, context) => {
    const entries = {};
    if (input[_RNe] != null) {
        const memberEntries = se_RegionNameStringList(input[_RNe], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `RegionName.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_ARll] != null) {
        entries[_ARll] = input[_ARll];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeReplaceRootVolumeTasksRequest = (input, context) => {
    const entries = {};
    if (input[_RRVTI] != null) {
        const memberEntries = se_ReplaceRootVolumeTaskIds(input[_RRVTI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ReplaceRootVolumeTaskId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeReservedInstancesListingsRequest = (input, context) => {
    const entries = {};
    if (input[_RIIe] != null) {
        entries[_RIIe] = input[_RIIe];
    }
    if (input[_RILI] != null) {
        entries[_RILI] = input[_RILI];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeReservedInstancesModificationsRequest = (input, context) => {
    const entries = {};
    if (input[_RIMI] != null) {
        const memberEntries = se_ReservedInstancesModificationIdStringList(input[_RIMI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ReservedInstancesModificationId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeReservedInstancesOfferingsRequest = (input, context) => {
    const entries = {};
    if (input[_AZ] != null) {
        entries[_AZ] = input[_AZ];
    }
    if (input[_IM] != null) {
        entries[_IM] = input[_IM];
    }
    if (input[_IT] != null) {
        entries[_IT] = input[_IT];
    }
    if (input[_MD] != null) {
        entries[_MD] = input[_MD];
    }
    if (input[_MIC] != null) {
        entries[_MIC] = input[_MIC];
    }
    if (input[_MDi] != null) {
        entries[_MDi] = input[_MDi];
    }
    if (input[_OC] != null) {
        entries[_OC] = input[_OC];
    }
    if (input[_PDr] != null) {
        entries[_PDr] = input[_PDr];
    }
    if (input[_RIOI] != null) {
        const memberEntries = se_ReservedInstancesOfferingIdStringList(input[_RIOI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ReservedInstancesOfferingId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_AZI] != null) {
        entries[_AZI] = input[_AZI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_ITns] != null) {
        entries[_ITns] = input[_ITns];
    }
    if (input[_OT] != null) {
        entries[_OT] = input[_OT];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeReservedInstancesRequest = (input, context) => {
    const entries = {};
    if (input[_OC] != null) {
        entries[_OC] = input[_OC];
    }
    if (input[_RIIes] != null) {
        const memberEntries = se_ReservedInstancesIdStringList(input[_RIIes], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ReservedInstancesId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_OT] != null) {
        entries[_OT] = input[_OT];
    }
    return entries;
};
const se_DescribeRouteServerEndpointsRequest = (input, context) => {
    const entries = {};
    if (input[_RSEIo] != null) {
        const memberEntries = se_RouteServerEndpointIdsList(input[_RSEIo], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `RouteServerEndpointId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeRouteServerPeersRequest = (input, context) => {
    const entries = {};
    if (input[_RSPIo] != null) {
        const memberEntries = se_RouteServerPeerIdsList(input[_RSPIo], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `RouteServerPeerId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeRouteServersRequest = (input, context) => {
    const entries = {};
    if (input[_RSIou] != null) {
        const memberEntries = se_RouteServerIdsList(input[_RSIou], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `RouteServerId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeRouteTablesRequest = (input, context) => {
    const entries = {};
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_RTIo] != null) {
        const memberEntries = se_RouteTableIdStringList(input[_RTIo], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `RouteTableId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeScheduledInstanceAvailabilityRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_FSSTR] != null) {
        const memberEntries = se_SlotDateTimeRangeRequest(input[_FSSTR], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `FirstSlotStartTimeRange.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_MSDIH] != null) {
        entries[_MSDIH] = input[_MSDIH];
    }
    if (input[_MSDIHi] != null) {
        entries[_MSDIHi] = input[_MSDIHi];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_Rec] != null) {
        const memberEntries = se_ScheduledInstanceRecurrenceRequest(input[_Rec], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Recurrence.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeScheduledInstancesRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_SIIc] != null) {
        const memberEntries = se_ScheduledInstanceIdRequestSet(input[_SIIc], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ScheduledInstanceId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_SSTR] != null) {
        const memberEntries = se_SlotStartTimeRangeRequest(input[_SSTR], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SlotStartTimeRange.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeSecurityGroupReferencesRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_GIr] != null) {
        const memberEntries = se_GroupIds(input[_GIr], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `GroupId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeSecurityGroupRulesRequest = (input, context) => {
    const entries = {};
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_SGRI] != null) {
        const memberEntries = se_SecurityGroupRuleIdList(input[_SGRI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SecurityGroupRuleId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeSecurityGroupsRequest = (input, context) => {
    const entries = {};
    if (input[_GIro] != null) {
        const memberEntries = se_GroupIdStringList(input[_GIro], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `GroupId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_GNr] != null) {
        const memberEntries = se_GroupNameStringList(input[_GNr], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `GroupName.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeSecurityGroupVpcAssociationsRequest = (input, context) => {
    const entries = {};
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeServiceLinkVirtualInterfacesRequest = (input, context) => {
    const entries = {};
    if (input[_SLVII] != null) {
        const memberEntries = se_ServiceLinkVirtualInterfaceIdSet(input[_SLVII], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ServiceLinkVirtualInterfaceId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeSnapshotAttributeRequest = (input, context) => {
    const entries = {};
    if (input[_At] != null) {
        entries[_At] = input[_At];
    }
    if (input[_SIn] != null) {
        entries[_SIn] = input[_SIn];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeSnapshotsRequest = (input, context) => {
    const entries = {};
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_OIw] != null) {
        const memberEntries = se_OwnerStringList(input[_OIw], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Owner.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_RBUI] != null) {
        const memberEntries = se_RestorableByStringList(input[_RBUI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `RestorableBy.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_SIna] != null) {
        const memberEntries = se_SnapshotIdStringList(input[_SIna], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SnapshotId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeSnapshotTierStatusRequest = (input, context) => {
    const entries = {};
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeSpotDatafeedSubscriptionRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeSpotFleetInstancesRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_SFRIp] != null) {
        entries[_SFRIp] = input[_SFRIp];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeSpotFleetRequestHistoryRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_SFRIp] != null) {
        entries[_SFRIp] = input[_SFRIp];
    }
    if (input[_ETv] != null) {
        entries[_ETv] = input[_ETv];
    }
    if (input[_STt] != null) {
        entries[_STt] = __serializeDateTime(input[_STt]);
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeSpotFleetRequestsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_SFRI] != null) {
        const memberEntries = se_SpotFleetRequestIdList(input[_SFRI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SpotFleetRequestId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeSpotInstanceRequestsRequest = (input, context) => {
    const entries = {};
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_SIRI] != null) {
        const memberEntries = se_SpotInstanceRequestIdList(input[_SIRI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SpotInstanceRequestId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeSpotPriceHistoryRequest = (input, context) => {
    const entries = {};
    if (input[_AZI] != null) {
        entries[_AZI] = input[_AZI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_STt] != null) {
        entries[_STt] = __serializeDateTime(input[_STt]);
    }
    if (input[_ETn] != null) {
        entries[_ETn] = __serializeDateTime(input[_ETn]);
    }
    if (input[_ITnst] != null) {
        const memberEntries = se_InstanceTypeList(input[_ITnst], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InstanceType.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_PDro] != null) {
        const memberEntries = se_ProductDescriptionList(input[_PDro], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ProductDescription.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_AZ] != null) {
        entries[_AZ] = input[_AZ];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeStaleSecurityGroupsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    return entries;
};
const se_DescribeStoreImageTasksRequest = (input, context) => {
    const entries = {};
    if (input[_IImag] != null) {
        const memberEntries = se_ImageIdList(input[_IImag], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ImageId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeSubnetsRequest = (input, context) => {
    const entries = {};
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_SIu] != null) {
        const memberEntries = se_SubnetIdStringList(input[_SIu], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SubnetId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeTagsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeTrafficMirrorFilterRulesRequest = (input, context) => {
    const entries = {};
    if (input[_TMFRIr] != null) {
        const memberEntries = se_TrafficMirrorFilterRuleIdList(input[_TMFRIr], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TrafficMirrorFilterRuleId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_TMFI] != null) {
        entries[_TMFI] = input[_TMFI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeTrafficMirrorFiltersRequest = (input, context) => {
    const entries = {};
    if (input[_TMFIr] != null) {
        const memberEntries = se_TrafficMirrorFilterIdList(input[_TMFIr], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TrafficMirrorFilterId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeTrafficMirrorSessionsRequest = (input, context) => {
    const entries = {};
    if (input[_TMSIr] != null) {
        const memberEntries = se_TrafficMirrorSessionIdList(input[_TMSIr], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TrafficMirrorSessionId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeTrafficMirrorTargetsRequest = (input, context) => {
    const entries = {};
    if (input[_TMTIr] != null) {
        const memberEntries = se_TrafficMirrorTargetIdList(input[_TMTIr], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TrafficMirrorTargetId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeTransitGatewayAttachmentsRequest = (input, context) => {
    const entries = {};
    if (input[_TGAIr] != null) {
        const memberEntries = se_TransitGatewayAttachmentIdStringList(input[_TGAIr], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TransitGatewayAttachmentIds.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeTransitGatewayConnectPeersRequest = (input, context) => {
    const entries = {};
    if (input[_TGCPIr] != null) {
        const memberEntries = se_TransitGatewayConnectPeerIdStringList(input[_TGCPIr], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TransitGatewayConnectPeerIds.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeTransitGatewayConnectsRequest = (input, context) => {
    const entries = {};
    if (input[_TGAIr] != null) {
        const memberEntries = se_TransitGatewayAttachmentIdStringList(input[_TGAIr], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TransitGatewayAttachmentIds.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeTransitGatewayMulticastDomainsRequest = (input, context) => {
    const entries = {};
    if (input[_TGMDIr] != null) {
        const memberEntries = se_TransitGatewayMulticastDomainIdStringList(input[_TGMDIr], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TransitGatewayMulticastDomainIds.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeTransitGatewayPeeringAttachmentsRequest = (input, context) => {
    const entries = {};
    if (input[_TGAIr] != null) {
        const memberEntries = se_TransitGatewayAttachmentIdStringList(input[_TGAIr], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TransitGatewayAttachmentIds.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeTransitGatewayPolicyTablesRequest = (input, context) => {
    const entries = {};
    if (input[_TGPTIr] != null) {
        const memberEntries = se_TransitGatewayPolicyTableIdStringList(input[_TGPTIr], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TransitGatewayPolicyTableIds.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeTransitGatewayRouteTableAnnouncementsRequest = (input, context) => {
    const entries = {};
    if (input[_TGRTAIr] != null) {
        const memberEntries = se_TransitGatewayRouteTableAnnouncementIdStringList(input[_TGRTAIr], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TransitGatewayRouteTableAnnouncementIds.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeTransitGatewayRouteTablesRequest = (input, context) => {
    const entries = {};
    if (input[_TGRTIr] != null) {
        const memberEntries = se_TransitGatewayRouteTableIdStringList(input[_TGRTIr], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TransitGatewayRouteTableIds.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeTransitGatewaysRequest = (input, context) => {
    const entries = {};
    if (input[_TGIr] != null) {
        const memberEntries = se_TransitGatewayIdStringList(input[_TGIr], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TransitGatewayIds.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeTransitGatewayVpcAttachmentsRequest = (input, context) => {
    const entries = {};
    if (input[_TGAIr] != null) {
        const memberEntries = se_TransitGatewayAttachmentIdStringList(input[_TGAIr], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TransitGatewayAttachmentIds.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeTrunkInterfaceAssociationsRequest = (input, context) => {
    const entries = {};
    if (input[_AIs] != null) {
        const memberEntries = se_TrunkInterfaceAssociationIdList(input[_AIs], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `AssociationId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeVerifiedAccessEndpointsRequest = (input, context) => {
    const entries = {};
    if (input[_VAEIe] != null) {
        const memberEntries = se_VerifiedAccessEndpointIdList(input[_VAEIe], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VerifiedAccessEndpointId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_VAII] != null) {
        entries[_VAII] = input[_VAII];
    }
    if (input[_VAGI] != null) {
        entries[_VAGI] = input[_VAGI];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeVerifiedAccessGroupsRequest = (input, context) => {
    const entries = {};
    if (input[_VAGIe] != null) {
        const memberEntries = se_VerifiedAccessGroupIdList(input[_VAGIe], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VerifiedAccessGroupId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_VAII] != null) {
        entries[_VAII] = input[_VAII];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeVerifiedAccessInstanceLoggingConfigurationsRequest = (input, context) => {
    const entries = {};
    if (input[_VAIIe] != null) {
        const memberEntries = se_VerifiedAccessInstanceIdList(input[_VAIIe], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VerifiedAccessInstanceId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeVerifiedAccessInstancesRequest = (input, context) => {
    const entries = {};
    if (input[_VAIIe] != null) {
        const memberEntries = se_VerifiedAccessInstanceIdList(input[_VAIIe], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VerifiedAccessInstanceId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeVerifiedAccessTrustProvidersRequest = (input, context) => {
    const entries = {};
    if (input[_VATPIe] != null) {
        const memberEntries = se_VerifiedAccessTrustProviderIdList(input[_VATPIe], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VerifiedAccessTrustProviderId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeVolumeAttributeRequest = (input, context) => {
    const entries = {};
    if (input[_At] != null) {
        entries[_At] = input[_At];
    }
    if (input[_VIo] != null) {
        entries[_VIo] = input[_VIo];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeVolumesModificationsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_VIol] != null) {
        const memberEntries = se_VolumeIdStringList(input[_VIol], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VolumeId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeVolumesRequest = (input, context) => {
    const entries = {};
    if (input[_VIol] != null) {
        const memberEntries = se_VolumeIdStringList(input[_VIol], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VolumeId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeVolumeStatusRequest = (input, context) => {
    const entries = {};
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_VIol] != null) {
        const memberEntries = se_VolumeIdStringList(input[_VIol], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VolumeId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeVpcAttributeRequest = (input, context) => {
    const entries = {};
    if (input[_At] != null) {
        entries[_At] = input[_At];
    }
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeVpcBlockPublicAccessExclusionsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_EIxcl] != null) {
        const memberEntries = se_VpcBlockPublicAccessExclusionIdList(input[_EIxcl], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ExclusionId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeVpcBlockPublicAccessOptionsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeVpcClassicLinkDnsSupportRequest = (input, context) => {
    const entries = {};
    if (input[_VIp] != null) {
        const memberEntries = se_VpcClassicLinkIdList(input[_VIp], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpcIds.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeVpcClassicLinkRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_VIp] != null) {
        const memberEntries = se_VpcClassicLinkIdList(input[_VIp], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpcId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeVpcEndpointAssociationsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_VEI] != null) {
        const memberEntries = se_VpcEndpointIdList(input[_VEI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpcEndpointId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeVpcEndpointConnectionNotificationsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_CNIon] != null) {
        entries[_CNIon] = input[_CNIon];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeVpcEndpointConnectionsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeVpcEndpointServiceConfigurationsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_SIer] != null) {
        const memberEntries = se_VpcEndpointServiceIdList(input[_SIer], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ServiceId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeVpcEndpointServicePermissionsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_SIe] != null) {
        entries[_SIe] = input[_SIe];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeVpcEndpointServicesRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_SNer] != null) {
        const memberEntries = se_ValueStringList(input[_SNer], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ServiceName.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_SRer] != null) {
        const memberEntries = se_ValueStringList(input[_SRer], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ServiceRegion.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeVpcEndpointsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_VEI] != null) {
        const memberEntries = se_VpcEndpointIdList(input[_VEI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpcEndpointId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_DescribeVpcPeeringConnectionsRequest = (input, context) => {
    const entries = {};
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_VPCIp] != null) {
        const memberEntries = se_VpcPeeringConnectionIdList(input[_VPCIp], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpcPeeringConnectionId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeVpcsRequest = (input, context) => {
    const entries = {};
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_VIp] != null) {
        const memberEntries = se_VpcIdStringList(input[_VIp], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpcId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeVpnConnectionsRequest = (input, context) => {
    const entries = {};
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_VCIp] != null) {
        const memberEntries = se_VpnConnectionIdStringList(input[_VCIp], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpnConnectionId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DescribeVpnGatewaysRequest = (input, context) => {
    const entries = {};
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_VGIp] != null) {
        const memberEntries = se_VpnGatewayIdStringList(input[_VGIp], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpnGatewayId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DestinationOptionsRequest = (input, context) => {
    const entries = {};
    if (input[_FF] != null) {
        entries[_FF] = input[_FF];
    }
    if (input[_HCP] != null) {
        entries[_HCP] = input[_HCP];
    }
    if (input[_PHP] != null) {
        entries[_PHP] = input[_PHP];
    }
    return entries;
};
const se_DetachClassicLinkVpcRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IIn] != null) {
        entries[_IIn] = input[_IIn];
    }
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    return entries;
};
const se_DetachInternetGatewayRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IGI] != null) {
        entries[_IGI] = input[_IGI];
    }
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    return entries;
};
const se_DetachNetworkInterfaceRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_AIt] != null) {
        entries[_AIt] = input[_AIt];
    }
    if (input[_F] != null) {
        entries[_F] = input[_F];
    }
    return entries;
};
const se_DetachVerifiedAccessTrustProviderRequest = (input, context) => {
    const entries = {};
    if (input[_VAII] != null) {
        entries[_VAII] = input[_VAII];
    }
    if (input[_VATPI] != null) {
        entries[_VATPI] = input[_VATPI];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DetachVolumeRequest = (input, context) => {
    const entries = {};
    if (input[_Dev] != null) {
        entries[_Dev] = input[_Dev];
    }
    if (input[_F] != null) {
        entries[_F] = input[_F];
    }
    if (input[_IIn] != null) {
        entries[_IIn] = input[_IIn];
    }
    if (input[_VIo] != null) {
        entries[_VIo] = input[_VIo];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DetachVpnGatewayRequest = (input, context) => {
    const entries = {};
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    if (input[_VGI] != null) {
        entries[_VGI] = input[_VGI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DhcpOptionsIdStringList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`DhcpOptionsId.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_DirectoryServiceAuthenticationRequest = (input, context) => {
    const entries = {};
    if (input[_DIir] != null) {
        entries[_DIir] = input[_DIir];
    }
    return entries;
};
const se_DisableAddressTransferRequest = (input, context) => {
    const entries = {};
    if (input[_AIl] != null) {
        entries[_AIl] = input[_AIl];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DisableAllowedImagesSettingsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DisableAwsNetworkPerformanceMetricSubscriptionRequest = (input, context) => {
    const entries = {};
    if (input[_S] != null) {
        entries[_S] = input[_S];
    }
    if (input[_D] != null) {
        entries[_D] = input[_D];
    }
    if (input[_Met] != null) {
        entries[_Met] = input[_Met];
    }
    if (input[_Sta] != null) {
        entries[_Sta] = input[_Sta];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DisableEbsEncryptionByDefaultRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DisableFastLaunchRequest = (input, context) => {
    const entries = {};
    if (input[_IIma] != null) {
        entries[_IIma] = input[_IIma];
    }
    if (input[_F] != null) {
        entries[_F] = input[_F];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DisableFastSnapshotRestoresRequest = (input, context) => {
    const entries = {};
    if (input[_AZv] != null) {
        const memberEntries = se_AvailabilityZoneStringList(input[_AZv], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `AvailabilityZone.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_SSIo] != null) {
        const memberEntries = se_SnapshotIdStringList(input[_SSIo], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SourceSnapshotId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DisableImageBlockPublicAccessRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DisableImageDeprecationRequest = (input, context) => {
    const entries = {};
    if (input[_IIma] != null) {
        entries[_IIma] = input[_IIma];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DisableImageDeregistrationProtectionRequest = (input, context) => {
    const entries = {};
    if (input[_IIma] != null) {
        entries[_IIma] = input[_IIma];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DisableImageRequest = (input, context) => {
    const entries = {};
    if (input[_IIma] != null) {
        entries[_IIma] = input[_IIma];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DisableIpamOrganizationAdminAccountRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_DAAI] != null) {
        entries[_DAAI] = input[_DAAI];
    }
    return entries;
};
const se_DisableRouteServerPropagationRequest = (input, context) => {
    const entries = {};
    if (input[_RSIo] != null) {
        entries[_RSIo] = input[_RSIo];
    }
    if (input[_RTI] != null) {
        entries[_RTI] = input[_RTI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DisableSerialConsoleAccessRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DisableSnapshotBlockPublicAccessRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DisableTransitGatewayRouteTablePropagationRequest = (input, context) => {
    const entries = {};
    if (input[_TGRTI] != null) {
        entries[_TGRTI] = input[_TGRTI];
    }
    if (input[_TGAI] != null) {
        entries[_TGAI] = input[_TGAI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_TGRTAI] != null) {
        entries[_TGRTAI] = input[_TGRTAI];
    }
    return entries;
};
const se_DisableVgwRoutePropagationRequest = (input, context) => {
    const entries = {};
    if (input[_GI] != null) {
        entries[_GI] = input[_GI];
    }
    if (input[_RTI] != null) {
        entries[_RTI] = input[_RTI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DisableVpcClassicLinkDnsSupportRequest = (input, context) => {
    const entries = {};
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    return entries;
};
const se_DisableVpcClassicLinkRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    return entries;
};
const se_DisassociateAddressRequest = (input, context) => {
    const entries = {};
    if (input[_AIss] != null) {
        entries[_AIss] = input[_AIss];
    }
    if (input[_PI] != null) {
        entries[_PI] = input[_PI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DisassociateCapacityReservationBillingOwnerRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_CRI] != null) {
        entries[_CRI] = input[_CRI];
    }
    if (input[_URBOI] != null) {
        entries[_URBOI] = input[_URBOI];
    }
    return entries;
};
const se_DisassociateClientVpnTargetNetworkRequest = (input, context) => {
    const entries = {};
    if (input[_CVEI] != null) {
        entries[_CVEI] = input[_CVEI];
    }
    if (input[_AIss] != null) {
        entries[_AIss] = input[_AIss];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DisassociateEnclaveCertificateIamRoleRequest = (input, context) => {
    const entries = {};
    if (input[_CA] != null) {
        entries[_CA] = input[_CA];
    }
    if (input[_RAo] != null) {
        entries[_RAo] = input[_RAo];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DisassociateIamInstanceProfileRequest = (input, context) => {
    const entries = {};
    if (input[_AIss] != null) {
        entries[_AIss] = input[_AIss];
    }
    return entries;
};
const se_DisassociateInstanceEventWindowRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IEWI] != null) {
        entries[_IEWI] = input[_IEWI];
    }
    if (input[_AT] != null) {
        const memberEntries = se_InstanceEventWindowDisassociationRequest(input[_AT], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `AssociationTarget.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DisassociateIpamByoasnRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_As] != null) {
        entries[_As] = input[_As];
    }
    if (input[_C] != null) {
        entries[_C] = input[_C];
    }
    return entries;
};
const se_DisassociateIpamResourceDiscoveryRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IRDAIp] != null) {
        entries[_IRDAIp] = input[_IRDAIp];
    }
    return entries;
};
const se_DisassociateNatGatewayAddressRequest = (input, context) => {
    const entries = {};
    if (input[_NGI] != null) {
        entries[_NGI] = input[_NGI];
    }
    if (input[_AIs] != null) {
        const memberEntries = se_EipAssociationIdList(input[_AIs], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `AssociationId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MDDS] != null) {
        entries[_MDDS] = input[_MDDS];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DisassociateRouteServerRequest = (input, context) => {
    const entries = {};
    if (input[_RSIo] != null) {
        entries[_RSIo] = input[_RSIo];
    }
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DisassociateRouteTableRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_AIss] != null) {
        entries[_AIss] = input[_AIss];
    }
    return entries;
};
const se_DisassociateSecurityGroupVpcRequest = (input, context) => {
    const entries = {};
    if (input[_GIr] != null) {
        entries[_GIr] = input[_GIr];
    }
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DisassociateSubnetCidrBlockRequest = (input, context) => {
    const entries = {};
    if (input[_AIss] != null) {
        entries[_AIss] = input[_AIss];
    }
    return entries;
};
const se_DisassociateTransitGatewayMulticastDomainRequest = (input, context) => {
    const entries = {};
    if (input[_TGMDI] != null) {
        entries[_TGMDI] = input[_TGMDI];
    }
    if (input[_TGAI] != null) {
        entries[_TGAI] = input[_TGAI];
    }
    if (input[_SIu] != null) {
        const memberEntries = se_TransitGatewaySubnetIdList(input[_SIu], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SubnetIds.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DisassociateTransitGatewayPolicyTableRequest = (input, context) => {
    const entries = {};
    if (input[_TGPTI] != null) {
        entries[_TGPTI] = input[_TGPTI];
    }
    if (input[_TGAI] != null) {
        entries[_TGAI] = input[_TGAI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DisassociateTransitGatewayRouteTableRequest = (input, context) => {
    const entries = {};
    if (input[_TGRTI] != null) {
        entries[_TGRTI] = input[_TGRTI];
    }
    if (input[_TGAI] != null) {
        entries[_TGAI] = input[_TGAI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DisassociateTrunkInterfaceRequest = (input, context) => {
    const entries = {};
    if (input[_AIss] != null) {
        entries[_AIss] = input[_AIss];
    }
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_DisassociateVpcCidrBlockRequest = (input, context) => {
    const entries = {};
    if (input[_AIss] != null) {
        entries[_AIss] = input[_AIss];
    }
    return entries;
};
const se_DiskImage = (input, context) => {
    const entries = {};
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_Im] != null) {
        const memberEntries = se_DiskImageDetail(input[_Im], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Image.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_Vo] != null) {
        const memberEntries = se_VolumeDetail(input[_Vo], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Volume.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DiskImageDetail = (input, context) => {
    const entries = {};
    if (input[_Fo] != null) {
        entries[_Fo] = input[_Fo];
    }
    if (input[_By] != null) {
        entries[_By] = input[_By];
    }
    if (input[_IMU] != null) {
        entries[_IMU] = input[_IMU];
    }
    return entries;
};
const se_DiskImageList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_DiskImage(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Member.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_DnsOptionsSpecification = (input, context) => {
    const entries = {};
    if (input[_DRIT] != null) {
        entries[_DRIT] = input[_DRIT];
    }
    if (input[_PDOFIRE] != null) {
        entries[_PDOFIRE] = input[_PDOFIRE];
    }
    return entries;
};
const se_DnsServersOptionsModifyStructure = (input, context) => {
    const entries = {};
    if (input[_CDSu] != null) {
        const memberEntries = se_ValueStringList(input[_CDSu], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `CustomDnsServers.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_En] != null) {
        entries[_En] = input[_En];
    }
    return entries;
};
const se_EbsBlockDevice = (input, context) => {
    const entries = {};
    if (input[_DOT] != null) {
        entries[_DOT] = input[_DOT];
    }
    if (input[_Io] != null) {
        entries[_Io] = input[_Io];
    }
    if (input[_SIn] != null) {
        entries[_SIn] = input[_SIn];
    }
    if (input[_VS] != null) {
        entries[_VS] = input[_VS];
    }
    if (input[_VT] != null) {
        entries[_VT] = input[_VT];
    }
    if (input[_KKI] != null) {
        entries[_KKI] = input[_KKI];
    }
    if (input[_Th] != null) {
        entries[_Th] = input[_Th];
    }
    if (input[_OA] != null) {
        entries[_OA] = input[_OA];
    }
    if (input[_AZ] != null) {
        entries[_AZ] = input[_AZ];
    }
    if (input[_Enc] != null) {
        entries[_Enc] = input[_Enc];
    }
    if (input[_VIR] != null) {
        entries[_VIR] = input[_VIR];
    }
    if (input[_AZI] != null) {
        entries[_AZI] = input[_AZI];
    }
    return entries;
};
const se_EbsInstanceBlockDeviceSpecification = (input, context) => {
    const entries = {};
    if (input[_VIo] != null) {
        entries[_VIo] = input[_VIo];
    }
    if (input[_DOT] != null) {
        entries[_DOT] = input[_DOT];
    }
    return entries;
};
const se_EgressOnlyInternetGatewayIdList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_EipAssociationIdList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_ElasticGpuIdSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_ElasticGpuSpecification = (input, context) => {
    const entries = {};
    if (input[_T] != null) {
        entries[_T] = input[_T];
    }
    return entries;
};
const se_ElasticGpuSpecificationList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_ElasticGpuSpecification(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`ElasticGpuSpecification.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_ElasticGpuSpecifications = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_ElasticGpuSpecification(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Item.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_ElasticInferenceAccelerator = (input, context) => {
    const entries = {};
    if (input[_T] != null) {
        entries[_T] = input[_T];
    }
    if (input[_Cou] != null) {
        entries[_Cou] = input[_Cou];
    }
    return entries;
};
const se_ElasticInferenceAccelerators = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_ElasticInferenceAccelerator(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Item.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_EnableAddressTransferRequest = (input, context) => {
    const entries = {};
    if (input[_AIl] != null) {
        entries[_AIl] = input[_AIl];
    }
    if (input[_TAI] != null) {
        entries[_TAI] = input[_TAI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_EnableAllowedImagesSettingsRequest = (input, context) => {
    const entries = {};
    if (input[_AISS] != null) {
        entries[_AISS] = input[_AISS];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_EnableAwsNetworkPerformanceMetricSubscriptionRequest = (input, context) => {
    const entries = {};
    if (input[_S] != null) {
        entries[_S] = input[_S];
    }
    if (input[_D] != null) {
        entries[_D] = input[_D];
    }
    if (input[_Met] != null) {
        entries[_Met] = input[_Met];
    }
    if (input[_Sta] != null) {
        entries[_Sta] = input[_Sta];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_EnableEbsEncryptionByDefaultRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_EnableFastLaunchRequest = (input, context) => {
    const entries = {};
    if (input[_IIma] != null) {
        entries[_IIma] = input[_IIma];
    }
    if (input[_RT] != null) {
        entries[_RT] = input[_RT];
    }
    if (input[_SCn] != null) {
        const memberEntries = se_FastLaunchSnapshotConfigurationRequest(input[_SCn], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SnapshotConfiguration.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_LTa] != null) {
        const memberEntries = se_FastLaunchLaunchTemplateSpecificationRequest(input[_LTa], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `LaunchTemplate.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MPL] != null) {
        entries[_MPL] = input[_MPL];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_EnableFastSnapshotRestoresRequest = (input, context) => {
    const entries = {};
    if (input[_AZv] != null) {
        const memberEntries = se_AvailabilityZoneStringList(input[_AZv], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `AvailabilityZone.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_SSIo] != null) {
        const memberEntries = se_SnapshotIdStringList(input[_SSIo], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SourceSnapshotId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_EnableImageBlockPublicAccessRequest = (input, context) => {
    const entries = {};
    if (input[_IBPAS] != null) {
        entries[_IBPAS] = input[_IBPAS];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_EnableImageDeprecationRequest = (input, context) => {
    const entries = {};
    if (input[_IIma] != null) {
        entries[_IIma] = input[_IIma];
    }
    if (input[_DAe] != null) {
        entries[_DAe] = __serializeDateTime(input[_DAe]);
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_EnableImageDeregistrationProtectionRequest = (input, context) => {
    const entries = {};
    if (input[_IIma] != null) {
        entries[_IIma] = input[_IIma];
    }
    if (input[_WC] != null) {
        entries[_WC] = input[_WC];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_EnableImageRequest = (input, context) => {
    const entries = {};
    if (input[_IIma] != null) {
        entries[_IIma] = input[_IIma];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_EnableIpamOrganizationAdminAccountRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_DAAI] != null) {
        entries[_DAAI] = input[_DAAI];
    }
    return entries;
};
const se_EnableReachabilityAnalyzerOrganizationSharingRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_EnableRouteServerPropagationRequest = (input, context) => {
    const entries = {};
    if (input[_RSIo] != null) {
        entries[_RSIo] = input[_RSIo];
    }
    if (input[_RTI] != null) {
        entries[_RTI] = input[_RTI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_EnableSerialConsoleAccessRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_EnableSnapshotBlockPublicAccessRequest = (input, context) => {
    const entries = {};
    if (input[_Stat] != null) {
        entries[_Stat] = input[_Stat];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_EnableTransitGatewayRouteTablePropagationRequest = (input, context) => {
    const entries = {};
    if (input[_TGRTI] != null) {
        entries[_TGRTI] = input[_TGRTI];
    }
    if (input[_TGAI] != null) {
        entries[_TGAI] = input[_TGAI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_TGRTAI] != null) {
        entries[_TGRTAI] = input[_TGRTAI];
    }
    return entries;
};
const se_EnableVgwRoutePropagationRequest = (input, context) => {
    const entries = {};
    if (input[_GI] != null) {
        entries[_GI] = input[_GI];
    }
    if (input[_RTI] != null) {
        entries[_RTI] = input[_RTI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_EnableVolumeIORequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_VIo] != null) {
        entries[_VIo] = input[_VIo];
    }
    return entries;
};
const se_EnableVpcClassicLinkDnsSupportRequest = (input, context) => {
    const entries = {};
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    return entries;
};
const se_EnableVpcClassicLinkRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    return entries;
};
const se_EnaSrdSpecification = (input, context) => {
    const entries = {};
    if (input[_ESE] != null) {
        entries[_ESE] = input[_ESE];
    }
    if (input[_ESUS] != null) {
        const memberEntries = se_EnaSrdUdpSpecification(input[_ESUS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `EnaSrdUdpSpecification.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_EnaSrdSpecificationRequest = (input, context) => {
    const entries = {};
    if (input[_ESE] != null) {
        entries[_ESE] = input[_ESE];
    }
    if (input[_ESUS] != null) {
        const memberEntries = se_EnaSrdUdpSpecificationRequest(input[_ESUS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `EnaSrdUdpSpecification.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_EnaSrdUdpSpecification = (input, context) => {
    const entries = {};
    if (input[_ESUE] != null) {
        entries[_ESUE] = input[_ESUE];
    }
    return entries;
};
const se_EnaSrdUdpSpecificationRequest = (input, context) => {
    const entries = {};
    if (input[_ESUE] != null) {
        entries[_ESUE] = input[_ESUE];
    }
    return entries;
};
const se_EnclaveOptionsRequest = (input, context) => {
    const entries = {};
    if (input[_En] != null) {
        entries[_En] = input[_En];
    }
    return entries;
};
const se_ExcludedInstanceTypeSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_ExecutableByStringList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`ExecutableBy.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_ExportClientVpnClientCertificateRevocationListRequest = (input, context) => {
    const entries = {};
    if (input[_CVEI] != null) {
        entries[_CVEI] = input[_CVEI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_ExportClientVpnClientConfigurationRequest = (input, context) => {
    const entries = {};
    if (input[_CVEI] != null) {
        entries[_CVEI] = input[_CVEI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_ExportImageRequest = (input, context) => {
    const entries = {};
    if (input[_CTl] === undefined) {
        input[_CTl] = generateIdempotencyToken();
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_DIFi] != null) {
        entries[_DIFi] = input[_DIFi];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IIma] != null) {
        entries[_IIma] = input[_IIma];
    }
    if (input[_SEL] != null) {
        const memberEntries = se_ExportTaskS3LocationRequest(input[_SEL], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `S3ExportLocation.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_RNo] != null) {
        entries[_RNo] = input[_RNo];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_ExportImageTaskIdList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`ExportImageTaskId.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_ExportTaskIdStringList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`ExportTaskId.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_ExportTaskS3LocationRequest = (input, context) => {
    const entries = {};
    if (input[_SB] != null) {
        entries[_SB] = input[_SB];
    }
    if (input[_SP] != null) {
        entries[_SP] = input[_SP];
    }
    return entries;
};
const se_ExportToS3TaskSpecification = (input, context) => {
    const entries = {};
    if (input[_DIFi] != null) {
        entries[_DIFi] = input[_DIFi];
    }
    if (input[_CFo] != null) {
        entries[_CFo] = input[_CFo];
    }
    if (input[_SB] != null) {
        entries[_SB] = input[_SB];
    }
    if (input[_SP] != null) {
        entries[_SP] = input[_SP];
    }
    return entries;
};
const se_ExportTransitGatewayRoutesRequest = (input, context) => {
    const entries = {};
    if (input[_TGRTI] != null) {
        entries[_TGRTI] = input[_TGRTI];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_SB] != null) {
        entries[_SB] = input[_SB];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_ExportVerifiedAccessInstanceClientConfigurationRequest = (input, context) => {
    const entries = {};
    if (input[_VAII] != null) {
        entries[_VAII] = input[_VAII];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_FastLaunchImageIdList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`ImageId.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_FastLaunchLaunchTemplateSpecificationRequest = (input, context) => {
    const entries = {};
    if (input[_LTI] != null) {
        entries[_LTI] = input[_LTI];
    }
    if (input[_LTN] != null) {
        entries[_LTN] = input[_LTN];
    }
    if (input[_V] != null) {
        entries[_V] = input[_V];
    }
    return entries;
};
const se_FastLaunchSnapshotConfigurationRequest = (input, context) => {
    const entries = {};
    if (input[_TRC] != null) {
        entries[_TRC] = input[_TRC];
    }
    return entries;
};
const se_FederatedAuthenticationRequest = (input, context) => {
    const entries = {};
    if (input[_SAMLPA] != null) {
        entries[_SAMLPA] = input[_SAMLPA];
    }
    if (input[_SSSAMLPA] != null) {
        entries[_SSSAMLPA] = input[_SSSAMLPA];
    }
    return entries;
};
const se_Filter = (input, context) => {
    const entries = {};
    if (input[_N] != null) {
        entries[_N] = input[_N];
    }
    if (input[_Val] != null) {
        const memberEntries = se_ValueStringList(input[_Val], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Value.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_FilterList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_Filter(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Filter.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_FleetBlockDeviceMappingRequest = (input, context) => {
    const entries = {};
    if (input[_DN] != null) {
        entries[_DN] = input[_DN];
    }
    if (input[_VN] != null) {
        entries[_VN] = input[_VN];
    }
    if (input[_E] != null) {
        const memberEntries = se_FleetEbsBlockDeviceRequest(input[_E], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Ebs.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_ND] != null) {
        entries[_ND] = input[_ND];
    }
    return entries;
};
const se_FleetBlockDeviceMappingRequestList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_FleetBlockDeviceMappingRequest(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`BlockDeviceMapping.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_FleetEbsBlockDeviceRequest = (input, context) => {
    const entries = {};
    if (input[_Enc] != null) {
        entries[_Enc] = input[_Enc];
    }
    if (input[_DOT] != null) {
        entries[_DOT] = input[_DOT];
    }
    if (input[_Io] != null) {
        entries[_Io] = input[_Io];
    }
    if (input[_Th] != null) {
        entries[_Th] = input[_Th];
    }
    if (input[_KKI] != null) {
        entries[_KKI] = input[_KKI];
    }
    if (input[_SIn] != null) {
        entries[_SIn] = input[_SIn];
    }
    if (input[_VS] != null) {
        entries[_VS] = input[_VS];
    }
    if (input[_VT] != null) {
        entries[_VT] = input[_VT];
    }
    return entries;
};
const se_FleetIdSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Member.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_FleetLaunchTemplateConfigListRequest = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_FleetLaunchTemplateConfigRequest(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Item.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_FleetLaunchTemplateConfigRequest = (input, context) => {
    const entries = {};
    if (input[_LTS] != null) {
        const memberEntries = se_FleetLaunchTemplateSpecificationRequest(input[_LTS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `LaunchTemplateSpecification.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_Ov] != null) {
        const memberEntries = se_FleetLaunchTemplateOverridesListRequest(input[_Ov], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Overrides.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_FleetLaunchTemplateOverridesListRequest = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_FleetLaunchTemplateOverridesRequest(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Item.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_FleetLaunchTemplateOverridesRequest = (input, context) => {
    const entries = {};
    if (input[_IT] != null) {
        entries[_IT] = input[_IT];
    }
    if (input[_MPa] != null) {
        entries[_MPa] = input[_MPa];
    }
    if (input[_SIub] != null) {
        entries[_SIub] = input[_SIub];
    }
    if (input[_AZ] != null) {
        entries[_AZ] = input[_AZ];
    }
    if (input[_WCe] != null) {
        entries[_WCe] = __serializeFloat(input[_WCe]);
    }
    if (input[_Pri] != null) {
        entries[_Pri] = __serializeFloat(input[_Pri]);
    }
    if (input[_Pl] != null) {
        const memberEntries = se_Placement(input[_Pl], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Placement.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_BDM] != null) {
        const memberEntries = se_FleetBlockDeviceMappingRequestList(input[_BDM], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `BlockDeviceMapping.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_IR] != null) {
        const memberEntries = se_InstanceRequirementsRequest(input[_IR], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InstanceRequirements.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_IIma] != null) {
        entries[_IIma] = input[_IIma];
    }
    return entries;
};
const se_FleetLaunchTemplateSpecification = (input, context) => {
    const entries = {};
    if (input[_LTI] != null) {
        entries[_LTI] = input[_LTI];
    }
    if (input[_LTN] != null) {
        entries[_LTN] = input[_LTN];
    }
    if (input[_V] != null) {
        entries[_V] = input[_V];
    }
    return entries;
};
const se_FleetLaunchTemplateSpecificationRequest = (input, context) => {
    const entries = {};
    if (input[_LTI] != null) {
        entries[_LTI] = input[_LTI];
    }
    if (input[_LTN] != null) {
        entries[_LTN] = input[_LTN];
    }
    if (input[_V] != null) {
        entries[_V] = input[_V];
    }
    return entries;
};
const se_FleetSpotCapacityRebalanceRequest = (input, context) => {
    const entries = {};
    if (input[_RS] != null) {
        entries[_RS] = input[_RS];
    }
    if (input[_TDe] != null) {
        entries[_TDe] = input[_TDe];
    }
    return entries;
};
const se_FleetSpotMaintenanceStrategiesRequest = (input, context) => {
    const entries = {};
    if (input[_CRap] != null) {
        const memberEntries = se_FleetSpotCapacityRebalanceRequest(input[_CRap], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `CapacityRebalance.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_FlowLogIdList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_FlowLogResourceIds = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_FpgaImageIdList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_GetActiveVpnTunnelStatusRequest = (input, context) => {
    const entries = {};
    if (input[_VCI] != null) {
        entries[_VCI] = input[_VCI];
    }
    if (input[_VTOIA] != null) {
        entries[_VTOIA] = input[_VTOIA];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetAllowedImagesSettingsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetAssociatedEnclaveCertificateIamRolesRequest = (input, context) => {
    const entries = {};
    if (input[_CA] != null) {
        entries[_CA] = input[_CA];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetAssociatedIpv6PoolCidrsRequest = (input, context) => {
    const entries = {};
    if (input[_PIo] != null) {
        entries[_PIo] = input[_PIo];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetAwsNetworkPerformanceDataRequest = (input, context) => {
    const entries = {};
    if (input[_DQ] != null) {
        const memberEntries = se_DataQueries(input[_DQ], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DataQuery.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_STt] != null) {
        entries[_STt] = __serializeDateTime(input[_STt]);
    }
    if (input[_ETn] != null) {
        entries[_ETn] = __serializeDateTime(input[_ETn]);
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetCapacityReservationUsageRequest = (input, context) => {
    const entries = {};
    if (input[_CRI] != null) {
        entries[_CRI] = input[_CRI];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetCoipPoolUsageRequest = (input, context) => {
    const entries = {};
    if (input[_PIo] != null) {
        entries[_PIo] = input[_PIo];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetConsoleOutputRequest = (input, context) => {
    const entries = {};
    if (input[_IIn] != null) {
        entries[_IIn] = input[_IIn];
    }
    if (input[_La] != null) {
        entries[_La] = input[_La];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetConsoleScreenshotRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IIn] != null) {
        entries[_IIn] = input[_IIn];
    }
    if (input[_WU] != null) {
        entries[_WU] = input[_WU];
    }
    return entries;
};
const se_GetDeclarativePoliciesReportSummaryRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_RIep] != null) {
        entries[_RIep] = input[_RIep];
    }
    return entries;
};
const se_GetDefaultCreditSpecificationRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IF] != null) {
        entries[_IF] = input[_IF];
    }
    return entries;
};
const se_GetEbsDefaultKmsKeyIdRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetEbsEncryptionByDefaultRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetFlowLogsIntegrationTemplateRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_FLIl] != null) {
        entries[_FLIl] = input[_FLIl];
    }
    if (input[_CDSDA] != null) {
        entries[_CDSDA] = input[_CDSDA];
    }
    if (input[_ISnt] != null) {
        const memberEntries = se_IntegrateServices(input[_ISnt], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `IntegrateService.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_GetGroupsForCapacityReservationRequest = (input, context) => {
    const entries = {};
    if (input[_CRI] != null) {
        entries[_CRI] = input[_CRI];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetHostReservationPurchasePreviewRequest = (input, context) => {
    const entries = {};
    if (input[_HIS] != null) {
        const memberEntries = se_RequestHostIdSet(input[_HIS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `HostIdSet.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_OI] != null) {
        entries[_OI] = input[_OI];
    }
    return entries;
};
const se_GetImageBlockPublicAccessStateRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetInstanceMetadataDefaultsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetInstanceTpmEkPubRequest = (input, context) => {
    const entries = {};
    if (input[_IIn] != null) {
        entries[_IIn] = input[_IIn];
    }
    if (input[_KT] != null) {
        entries[_KT] = input[_KT];
    }
    if (input[_KF] != null) {
        entries[_KF] = input[_KF];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetInstanceTypesFromInstanceRequirementsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_ATr] != null) {
        const memberEntries = se_ArchitectureTypeSet(input[_ATr], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ArchitectureType.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_VTi] != null) {
        const memberEntries = se_VirtualizationTypeSet(input[_VTi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VirtualizationType.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_IR] != null) {
        const memberEntries = se_InstanceRequirementsRequest(input[_IR], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InstanceRequirements.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_Con] != null) {
        entries[_Con] = input[_Con];
    }
    return entries;
};
const se_GetInstanceUefiDataRequest = (input, context) => {
    const entries = {};
    if (input[_IIn] != null) {
        entries[_IIn] = input[_IIn];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetIpamAddressHistoryRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_C] != null) {
        entries[_C] = input[_C];
    }
    if (input[_ISI] != null) {
        entries[_ISI] = input[_ISI];
    }
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    if (input[_STt] != null) {
        entries[_STt] = __serializeDateTime(input[_STt]);
    }
    if (input[_ETn] != null) {
        entries[_ETn] = __serializeDateTime(input[_ETn]);
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_GetIpamDiscoveredAccountsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IRDI] != null) {
        entries[_IRDI] = input[_IRDI];
    }
    if (input[_DRi] != null) {
        entries[_DRi] = input[_DRi];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_GetIpamDiscoveredPublicAddressesRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IRDI] != null) {
        entries[_IRDI] = input[_IRDI];
    }
    if (input[_ARd] != null) {
        entries[_ARd] = input[_ARd];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_GetIpamDiscoveredResourceCidrsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IRDI] != null) {
        entries[_IRDI] = input[_IRDI];
    }
    if (input[_RRe] != null) {
        entries[_RRe] = input[_RRe];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_GetIpamPoolAllocationsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IPI] != null) {
        entries[_IPI] = input[_IPI];
    }
    if (input[_IPAI] != null) {
        entries[_IPAI] = input[_IPAI];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_GetIpamPoolCidrsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IPI] != null) {
        entries[_IPI] = input[_IPI];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_GetIpamResourceCidrsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_ISI] != null) {
        entries[_ISI] = input[_ISI];
    }
    if (input[_IPI] != null) {
        entries[_IPI] = input[_IPI];
    }
    if (input[_RIeso] != null) {
        entries[_RIeso] = input[_RIeso];
    }
    if (input[_RT] != null) {
        entries[_RT] = input[_RT];
    }
    if (input[_RTeso] != null) {
        const memberEntries = se_RequestIpamResourceTag(input[_RTeso], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ResourceTag.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_ROe] != null) {
        entries[_ROe] = input[_ROe];
    }
    return entries;
};
const se_GetLaunchTemplateDataRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_IIn] != null) {
        entries[_IIn] = input[_IIn];
    }
    return entries;
};
const se_GetManagedPrefixListAssociationsRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_PLI] != null) {
        entries[_PLI] = input[_PLI];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_GetManagedPrefixListEntriesRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_PLI] != null) {
        entries[_PLI] = input[_PLI];
    }
    if (input[_TV] != null) {
        entries[_TV] = input[_TV];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_GetNetworkInsightsAccessScopeAnalysisFindingsRequest = (input, context) => {
    const entries = {};
    if (input[_NIASAI] != null) {
        entries[_NIASAI] = input[_NIASAI];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetNetworkInsightsAccessScopeContentRequest = (input, context) => {
    const entries = {};
    if (input[_NIASI] != null) {
        entries[_NIASI] = input[_NIASI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetPasswordDataRequest = (input, context) => {
    const entries = {};
    if (input[_IIn] != null) {
        entries[_IIn] = input[_IIn];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetReservedInstancesExchangeQuoteRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_RII] != null) {
        const memberEntries = se_ReservedInstanceIdSet(input[_RII], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ReservedInstanceId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_TC] != null) {
        const memberEntries = se_TargetConfigurationRequestSet(input[_TC], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TargetConfiguration.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_GetRouteServerAssociationsRequest = (input, context) => {
    const entries = {};
    if (input[_RSIo] != null) {
        entries[_RSIo] = input[_RSIo];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetRouteServerPropagationsRequest = (input, context) => {
    const entries = {};
    if (input[_RSIo] != null) {
        entries[_RSIo] = input[_RSIo];
    }
    if (input[_RTI] != null) {
        entries[_RTI] = input[_RTI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetRouteServerRoutingDatabaseRequest = (input, context) => {
    const entries = {};
    if (input[_RSIo] != null) {
        entries[_RSIo] = input[_RSIo];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_GetSecurityGroupsForVpcRequest = (input, context) => {
    const entries = {};
    if (input[_VI] != null) {
        entries[_VI] = input[_VI];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetSerialConsoleAccessStatusRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetSnapshotBlockPublicAccessStateRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetSpotPlacementScoresRequest = (input, context) => {
    const entries = {};
    if (input[_ITnst] != null) {
        const memberEntries = se_InstanceTypes(input[_ITnst], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InstanceType.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_TCa] != null) {
        entries[_TCa] = input[_TCa];
    }
    if (input[_TCUT] != null) {
        entries[_TCUT] = input[_TCUT];
    }
    if (input[_SAZ] != null) {
        entries[_SAZ] = input[_SAZ];
    }
    if (input[_RNe] != null) {
        const memberEntries = se_RegionNames(input[_RNe], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `RegionName.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_IRWM] != null) {
        const memberEntries = se_InstanceRequirementsWithMetadataRequest(input[_IRWM], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InstanceRequirementsWithMetadata.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    return entries;
};
const se_GetSubnetCidrReservationsRequest = (input, context) => {
    const entries = {};
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_SIub] != null) {
        entries[_SIub] = input[_SIub];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_GetTransitGatewayAttachmentPropagationsRequest = (input, context) => {
    const entries = {};
    if (input[_TGAI] != null) {
        entries[_TGAI] = input[_TGAI];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetTransitGatewayMulticastDomainAssociationsRequest = (input, context) => {
    const entries = {};
    if (input[_TGMDI] != null) {
        entries[_TGMDI] = input[_TGMDI];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetTransitGatewayPolicyTableAssociationsRequest = (input, context) => {
    const entries = {};
    if (input[_TGPTI] != null) {
        entries[_TGPTI] = input[_TGPTI];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetTransitGatewayPolicyTableEntriesRequest = (input, context) => {
    const entries = {};
    if (input[_TGPTI] != null) {
        entries[_TGPTI] = input[_TGPTI];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetTransitGatewayPrefixListReferencesRequest = (input, context) => {
    const entries = {};
    if (input[_TGRTI] != null) {
        entries[_TGRTI] = input[_TGRTI];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetTransitGatewayRouteTableAssociationsRequest = (input, context) => {
    const entries = {};
    if (input[_TGRTI] != null) {
        entries[_TGRTI] = input[_TGRTI];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetTransitGatewayRouteTablePropagationsRequest = (input, context) => {
    const entries = {};
    if (input[_TGRTI] != null) {
        entries[_TGRTI] = input[_TGRTI];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filter.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetVerifiedAccessEndpointPolicyRequest = (input, context) => {
    const entries = {};
    if (input[_VAEI] != null) {
        entries[_VAEI] = input[_VAEI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetVerifiedAccessEndpointTargetsRequest = (input, context) => {
    const entries = {};
    if (input[_VAEI] != null) {
        entries[_VAEI] = input[_VAEI];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetVerifiedAccessGroupPolicyRequest = (input, context) => {
    const entries = {};
    if (input[_VAGI] != null) {
        entries[_VAGI] = input[_VAGI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetVpnConnectionDeviceSampleConfigurationRequest = (input, context) => {
    const entries = {};
    if (input[_VCI] != null) {
        entries[_VCI] = input[_VCI];
    }
    if (input[_VCDTI] != null) {
        entries[_VCDTI] = input[_VCDTI];
    }
    if (input[_IKEV] != null) {
        entries[_IKEV] = input[_IKEV];
    }
    if (input[_STa] != null) {
        entries[_STa] = input[_STa];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetVpnConnectionDeviceTypesRequest = (input, context) => {
    const entries = {};
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GetVpnTunnelReplacementStatusRequest = (input, context) => {
    const entries = {};
    if (input[_VCI] != null) {
        entries[_VCI] = input[_VCI];
    }
    if (input[_VTOIA] != null) {
        entries[_VTOIA] = input[_VTOIA];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_GroupIdentifier = (input, context) => {
    const entries = {};
    if (input[_GIr] != null) {
        entries[_GIr] = input[_GIr];
    }
    if (input[_GN] != null) {
        entries[_GN] = input[_GN];
    }
    return entries;
};
const se_GroupIdentifierList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_GroupIdentifier(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Item.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_GroupIds = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_GroupIdStringList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`GroupId.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_GroupNameStringList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`GroupName.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_HibernationOptionsRequest = (input, context) => {
    const entries = {};
    if (input[_Conf] != null) {
        entries[_Conf] = input[_Conf];
    }
    return entries;
};
const se_HostReservationIdSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_IamInstanceProfileSpecification = (input, context) => {
    const entries = {};
    if (input[_Ar] != null) {
        entries[_Ar] = input[_Ar];
    }
    if (input[_N] != null) {
        entries[_N] = input[_N];
    }
    return entries;
};
const se_IcmpTypeCode = (input, context) => {
    const entries = {};
    if (input[_Cod] != null) {
        entries[_Cod] = input[_Cod];
    }
    if (input[_T] != null) {
        entries[_T] = input[_T];
    }
    return entries;
};
const se_IKEVersionsRequestList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_IKEVersionsRequestListValue(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Item.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_IKEVersionsRequestListValue = (input, context) => {
    const entries = {};
    if (input[_Va] != null) {
        entries[_Va] = input[_Va];
    }
    return entries;
};
const se_ImageCriterionRequest = (input, context) => {
    const entries = {};
    if (input[_IPm] != null) {
        const memberEntries = se_ImageProviderRequestList(input[_IPm], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ImageProvider.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_MPC] != null) {
        const memberEntries = se_MarketplaceProductCodeRequestList(input[_MPC], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `MarketplaceProductCode.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_INm] != null) {
        const memberEntries = se_ImageNameRequestList(input[_INm], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ImageName.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DTC] != null) {
        const memberEntries = se_DeprecationTimeConditionRequest(input[_DTC], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DeprecationTimeCondition.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_CDC] != null) {
        const memberEntries = se_CreationDateConditionRequest(input[_CDC], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `CreationDateCondition.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_ImageCriterionRequestList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_ImageCriterionRequest(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`ImageCriterion.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_ImageDiskContainer = (input, context) => {
    const entries = {};
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_DN] != null) {
        entries[_DN] = input[_DN];
    }
    if (input[_Fo] != null) {
        entries[_Fo] = input[_Fo];
    }
    if (input[_SIn] != null) {
        entries[_SIn] = input[_SIn];
    }
    if (input[_U] != null) {
        entries[_U] = input[_U];
    }
    if (input[_UB] != null) {
        const memberEntries = se_UserBucket(input[_UB], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `UserBucket.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_ImageDiskContainerList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_ImageDiskContainer(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Item.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_ImageIdList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_ImageIdStringList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`ImageId.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_ImageNameRequestList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_ImageProviderRequestList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_ImageUsageReportIdStringList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Member.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_ImageUsageReportUserIdStringList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`UserId.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_ImageUsageResourceTypeOptionRequest = (input, context) => {
    const entries = {};
    if (input[_ON] != null) {
        entries[_ON] = input[_ON];
    }
    if (input[_OV] != null) {
        const memberEntries = se_ImageUsageResourceTypeOptionValuesList(input[_OV], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `OptionValue.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_ImageUsageResourceTypeOptionRequestList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_ImageUsageResourceTypeOptionRequest(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Member.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_ImageUsageResourceTypeOptionValuesList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_ImageUsageResourceTypeRequest = (input, context) => {
    const entries = {};
    if (input[_RT] != null) {
        entries[_RT] = input[_RT];
    }
    if (input[_RTO] != null) {
        const memberEntries = se_ImageUsageResourceTypeOptionRequestList(input[_RTO], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ResourceTypeOption.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_ImageUsageResourceTypeRequestList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_ImageUsageResourceTypeRequest(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Member.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_ImportClientVpnClientCertificateRevocationListRequest = (input, context) => {
    const entries = {};
    if (input[_CVEI] != null) {
        entries[_CVEI] = input[_CVEI];
    }
    if (input[_CRL] != null) {
        entries[_CRL] = input[_CRL];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    return entries;
};
const se_ImportImageLicenseConfigurationRequest = (input, context) => {
    const entries = {};
    if (input[_LCA] != null) {
        entries[_LCA] = input[_LCA];
    }
    return entries;
};
const se_ImportImageLicenseSpecificationListRequest = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_ImportImageLicenseConfigurationRequest(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Item.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_ImportImageRequest = (input, context) => {
    const entries = {};
    if (input[_Arc] != null) {
        entries[_Arc] = input[_Arc];
    }
    if (input[_CDl] != null) {
        const memberEntries = se_ClientData(input[_CDl], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ClientData.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_DCi] != null) {
        const memberEntries = se_ImageDiskContainerList(input[_DCi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DiskContainer.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Enc] != null) {
        entries[_Enc] = input[_Enc];
    }
    if (input[_H] != null) {
        entries[_H] = input[_H];
    }
    if (input[_KKI] != null) {
        entries[_KKI] = input[_KKI];
    }
    if (input[_LTi] != null) {
        entries[_LTi] = input[_LTi];
    }
    if (input[_Pla] != null) {
        entries[_Pla] = input[_Pla];
    }
    if (input[_RNo] != null) {
        entries[_RNo] = input[_RNo];
    }
    if (input[_LSi] != null) {
        const memberEntries = se_ImportImageLicenseSpecificationListRequest(input[_LSi], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `LicenseSpecifications.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_UO] != null) {
        entries[_UO] = input[_UO];
    }
    if (input[_BM] != null) {
        entries[_BM] = input[_BM];
    }
    return entries;
};
const se_ImportInstanceLaunchSpecification = (input, context) => {
    const entries = {};
    if (input[_Arc] != null) {
        entries[_Arc] = input[_Arc];
    }
    if (input[_GNr] != null) {
        const memberEntries = se_SecurityGroupStringList(input[_GNr], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `GroupName.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_GIro] != null) {
        const memberEntries = se_SecurityGroupIdStringList(input[_GIro], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `GroupId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_AId] != null) {
        entries[_AId] = input[_AId];
    }
    if (input[_UD] != null) {
        const memberEntries = se_UserData(input[_UD], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `UserData.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_IT] != null) {
        entries[_IT] = input[_IT];
    }
    if (input[_Pl] != null) {
        const memberEntries = se_Placement(input[_Pl], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Placement.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_Mon] != null) {
        entries[_Mon] = input[_Mon];
    }
    if (input[_SIub] != null) {
        entries[_SIub] = input[_SIub];
    }
    if (input[_IISB] != null) {
        entries[_IISB] = input[_IISB];
    }
    if (input[_PIAr] != null) {
        entries[_PIAr] = input[_PIAr];
    }
    return entries;
};
const se_ImportInstanceRequest = (input, context) => {
    const entries = {};
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_LSa] != null) {
        const memberEntries = se_ImportInstanceLaunchSpecification(input[_LSa], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `LaunchSpecification.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_DIis] != null) {
        const memberEntries = se_DiskImageList(input[_DIis], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DiskImage.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_Pla] != null) {
        entries[_Pla] = input[_Pla];
    }
    return entries;
};
const se_ImportKeyPairRequest = (input, context) => {
    const entries = {};
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_KN] != null) {
        entries[_KN] = input[_KN];
    }
    if (input[_PKM] != null) {
        entries[_PKM] = context.base64Encoder(input[_PKM]);
    }
    return entries;
};
const se_ImportSnapshotRequest = (input, context) => {
    const entries = {};
    if (input[_CDl] != null) {
        const memberEntries = se_ClientData(input[_CDl], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ClientData.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_CTl] != null) {
        entries[_CTl] = input[_CTl];
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_DCis] != null) {
        const memberEntries = se_SnapshotDiskContainer(input[_DCis], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DiskContainer.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_Enc] != null) {
        entries[_Enc] = input[_Enc];
    }
    if (input[_KKI] != null) {
        entries[_KKI] = input[_KKI];
    }
    if (input[_RNo] != null) {
        entries[_RNo] = input[_RNo];
    }
    if (input[_TS] != null) {
        const memberEntries = se_TagSpecificationList(input[_TS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_ImportSnapshotTaskIdList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`ImportTaskId.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_ImportTaskIdList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`ImportTaskId.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_ImportVolumeRequest = (input, context) => {
    const entries = {};
    if (input[_AZI] != null) {
        entries[_AZI] = input[_AZI];
    }
    if (input[_DRr] != null) {
        entries[_DRr] = input[_DRr];
    }
    if (input[_AZ] != null) {
        entries[_AZ] = input[_AZ];
    }
    if (input[_Im] != null) {
        const memberEntries = se_DiskImageDetail(input[_Im], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Image.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_Vo] != null) {
        const memberEntries = se_VolumeDetail(input[_Vo], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Volume.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_InsideCidrBlocksStringList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_InstanceBlockDeviceMappingSpecification = (input, context) => {
    const entries = {};
    if (input[_DN] != null) {
        entries[_DN] = input[_DN];
    }
    if (input[_E] != null) {
        const memberEntries = se_EbsInstanceBlockDeviceSpecification(input[_E], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Ebs.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_VN] != null) {
        entries[_VN] = input[_VN];
    }
    if (input[_ND] != null) {
        entries[_ND] = input[_ND];
    }
    return entries;
};
const se_InstanceBlockDeviceMappingSpecificationList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_InstanceBlockDeviceMappingSpecification(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Item.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_InstanceCreditSpecificationListRequest = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_InstanceCreditSpecificationRequest(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Item.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_InstanceCreditSpecificationRequest = (input, context) => {
    const entries = {};
    if (input[_IIn] != null) {
        entries[_IIn] = input[_IIn];
    }
    if (input[_CCp] != null) {
        entries[_CCp] = input[_CCp];
    }
    return entries;
};
const se_InstanceEventWindowAssociationRequest = (input, context) => {
    const entries = {};
    if (input[_IIns] != null) {
        const memberEntries = se_InstanceIdList(input[_IIns], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InstanceId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_ITnsta] != null) {
        const memberEntries = se_TagList(input[_ITnsta], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InstanceTag.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DHI] != null) {
        const memberEntries = se_DedicatedHostIdList(input[_DHI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DedicatedHostId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_InstanceEventWindowDisassociationRequest = (input, context) => {
    const entries = {};
    if (input[_IIns] != null) {
        const memberEntries = se_InstanceIdList(input[_IIns], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InstanceId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_ITnsta] != null) {
        const memberEntries = se_TagList(input[_ITnsta], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InstanceTag.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_DHI] != null) {
        const memberEntries = se_DedicatedHostIdList(input[_DHI], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DedicatedHostId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_InstanceEventWindowIdSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`InstanceEventWindowId.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_InstanceEventWindowTimeRangeRequest = (input, context) => {
    const entries = {};
    if (input[_SWD] != null) {
        entries[_SWD] = input[_SWD];
    }
    if (input[_SH] != null) {
        entries[_SH] = input[_SH];
    }
    if (input[_EWD] != null) {
        entries[_EWD] = input[_EWD];
    }
    if (input[_EH] != null) {
        entries[_EH] = input[_EH];
    }
    return entries;
};
const se_InstanceEventWindowTimeRangeRequestSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_InstanceEventWindowTimeRangeRequest(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Member.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_InstanceGenerationSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_InstanceIdList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_InstanceIdStringList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`InstanceId.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_InstanceIpv6Address = (input, context) => {
    const entries = {};
    if (input[_IApv] != null) {
        entries[_IApv] = input[_IApv];
    }
    if (input[_IPIs] != null) {
        entries[_IPIs] = input[_IPIs];
    }
    return entries;
};
const se_InstanceIpv6AddressList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_InstanceIpv6Address(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Item.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_InstanceIpv6AddressListRequest = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_InstanceIpv6AddressRequest(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`InstanceIpv6Address.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_InstanceIpv6AddressRequest = (input, context) => {
    const entries = {};
    if (input[_IApv] != null) {
        entries[_IApv] = input[_IApv];
    }
    return entries;
};
const se_InstanceMaintenanceOptionsRequest = (input, context) => {
    const entries = {};
    if (input[_ARu] != null) {
        entries[_ARu] = input[_ARu];
    }
    return entries;
};
const se_InstanceMarketOptionsRequest = (input, context) => {
    const entries = {};
    if (input[_MT] != null) {
        entries[_MT] = input[_MT];
    }
    if (input[_SO] != null) {
        const memberEntries = se_SpotMarketOptions(input[_SO], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SpotOptions.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_InstanceMetadataOptionsRequest = (input, context) => {
    const entries = {};
    if (input[_HT] != null) {
        entries[_HT] = input[_HT];
    }
    if (input[_HPRHL] != null) {
        entries[_HPRHL] = input[_HPRHL];
    }
    if (input[_HE] != null) {
        entries[_HE] = input[_HE];
    }
    if (input[_HPI] != null) {
        entries[_HPI] = input[_HPI];
    }
    if (input[_IMT] != null) {
        entries[_IMT] = input[_IMT];
    }
    return entries;
};
const se_InstanceNetworkInterfaceSpecification = (input, context) => {
    const entries = {};
    if (input[_APIAs] != null) {
        entries[_APIAs] = input[_APIAs];
    }
    if (input[_DOT] != null) {
        entries[_DOT] = input[_DOT];
    }
    if (input[_De] != null) {
        entries[_De] = input[_De];
    }
    if (input[_DIev] != null) {
        entries[_DIev] = input[_DIev];
    }
    if (input[_G] != null) {
        const memberEntries = se_SecurityGroupIdStringList(input[_G], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SecurityGroupId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_IAC] != null) {
        entries[_IAC] = input[_IAC];
    }
    if (input[_IA] != null) {
        const memberEntries = se_InstanceIpv6AddressList(input[_IA], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Ipv6Addresses.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_NII] != null) {
        entries[_NII] = input[_NII];
    }
    if (input[_PIAr] != null) {
        entries[_PIAr] = input[_PIAr];
    }
    if (input[_PIA] != null) {
        const memberEntries = se_PrivateIpAddressSpecificationList(input[_PIA], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `PrivateIpAddresses.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_SPIAC] != null) {
        entries[_SPIAC] = input[_SPIAC];
    }
    if (input[_SIub] != null) {
        entries[_SIub] = input[_SIub];
    }
    if (input[_ACIA] != null) {
        entries[_ACIA] = input[_ACIA];
    }
    if (input[_ITn] != null) {
        entries[_ITn] = input[_ITn];
    }
    if (input[_NCI] != null) {
        entries[_NCI] = input[_NCI];
    }
    if (input[_IPp] != null) {
        const memberEntries = se_Ipv4PrefixList(input[_IPp], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Ipv4Prefix.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_IPCp] != null) {
        entries[_IPCp] = input[_IPCp];
    }
    if (input[_IP] != null) {
        const memberEntries = se_Ipv6PrefixList(input[_IP], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Ipv6Prefix.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input[_IPC] != null) {
        entries[_IPC] = input[_IPC];
    }
    if (input[_PIr] != null) {
        entries[_PIr] = input[_PIr];
    }
    if (input[_ESS] != null) {
        const memberEntries = se_EnaSrdSpecificationRequest(input[_ESS], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `EnaSrdSpecification.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_CTS] != null) {
        const memberEntries = se_Connect