import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { AssignPrivateIpAddressesRequest, AssignPrivateIpAddressesResult } from "../models/models_0";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link AssignPrivateIpAddressesCommand}.
 */
export interface AssignPrivateIpAddressesCommandInput extends AssignPrivateIpAddressesRequest {
}
/**
 * @public
 *
 * The output of {@link AssignPrivateIpAddressesCommand}.
 */
export interface AssignPrivateIpAddressesCommandOutput extends AssignPrivateIpAddressesResult, __MetadataBearer {
}
declare const AssignPrivateIpAddressesCommand_base: {
    new (input: AssignPrivateIpAddressesCommandInput): import("@smithy/smithy-client").CommandImpl<AssignPrivateIpAddressesCommandInput, AssignPrivateIpAddressesCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: AssignPrivateIpAddressesCommandInput): import("@smithy/smithy-client").CommandImpl<AssignPrivateIpAddressesCommandInput, AssignPrivateIpAddressesCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Assigns the specified secondary private IP addresses to the specified network
 *             interface.</p>
 *          <p>You can specify specific secondary IP addresses, or you can specify the number of
 *             secondary IP addresses to be automatically assigned from the subnet's CIDR block range.
 *             The number of secondary IP addresses that you can assign to an instance varies by
 *             instance type. For more information about Elastic IP addresses, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
 *                 Addresses</a> in the <i>Amazon EC2 User Guide</i>.</p>
 *          <p>When you move a secondary private IP address to another network interface, any Elastic
 *             IP address that is associated with the IP address is also moved.</p>
 *          <p>Remapping an IP address is an asynchronous operation. When you move an IP address from
 *             one network interface to another, check
 *                 <code>network/interfaces/macs/mac/local-ipv4s</code> in the instance metadata to
 *             confirm that the remapping is complete.</p>
 *          <p>You must specify either the IP addresses or the IP address count in the
 *             request.</p>
 *          <p>You can optionally use Prefix Delegation on the network interface. You must specify
 *             either the IPv4 Prefix Delegation prefixes, or the IPv4 Prefix Delegation count. For
 *             information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html"> Assigning prefixes to network
 *                 interfaces</a> in the <i>Amazon EC2 User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, AssignPrivateIpAddressesCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, AssignPrivateIpAddressesCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * // import type { EC2ClientConfig } from "@aws-sdk/client-ec2";
 * const config = {}; // type is EC2ClientConfig
 * const client = new EC2Client(config);
 * const input = { // AssignPrivateIpAddressesRequest
 *   Ipv4Prefixes: [ // IpPrefixList
 *     "STRING_VALUE",
 *   ],
 *   Ipv4PrefixCount: Number("int"),
 *   NetworkInterfaceId: "STRING_VALUE", // required
 *   PrivateIpAddresses: [ // PrivateIpAddressStringList
 *     "STRING_VALUE",
 *   ],
 *   SecondaryPrivateIpAddressCount: Number("int"),
 *   AllowReassignment: true || false,
 * };
 * const command = new AssignPrivateIpAddressesCommand(input);
 * const response = await client.send(command);
 * // { // AssignPrivateIpAddressesResult
 * //   NetworkInterfaceId: "STRING_VALUE",
 * //   AssignedPrivateIpAddresses: [ // AssignedPrivateIpAddressList
 * //     { // AssignedPrivateIpAddress
 * //       PrivateIpAddress: "STRING_VALUE",
 * //     },
 * //   ],
 * //   AssignedIpv4Prefixes: [ // Ipv4PrefixesList
 * //     { // Ipv4PrefixSpecification
 * //       Ipv4Prefix: "STRING_VALUE",
 * //     },
 * //   ],
 * // };
 *
 * ```
 *
 * @param AssignPrivateIpAddressesCommandInput - {@link AssignPrivateIpAddressesCommandInput}
 * @returns {@link AssignPrivateIpAddressesCommandOutput}
 * @see {@link AssignPrivateIpAddressesCommandInput} for command's `input` shape.
 * @see {@link AssignPrivateIpAddressesCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @example To assign a specific secondary private IP address to an interface
 * ```javascript
 * // This example assigns the specified secondary private IP address to the specified network interface.
 * const input = {
 *   NetworkInterfaceId: "eni-e5aa89a3",
 *   PrivateIpAddresses: [
 *     "10.0.0.82"
 *   ]
 * };
 * const command = new AssignPrivateIpAddressesCommand(input);
 * const response = await client.send(command);
 * /* response is
 * { /* metadata only *\/ }
 * *\/
 * ```
 *
 * @example To assign secondary private IP addresses that Amazon EC2 selects to an interface
 * ```javascript
 * // This example assigns two secondary private IP addresses to the specified network interface. Amazon EC2 automatically assigns these IP addresses from the available IP addresses in the CIDR block range of the subnet the network interface is associated with.
 * const input = {
 *   NetworkInterfaceId: "eni-e5aa89a3",
 *   SecondaryPrivateIpAddressCount: 2
 * };
 * const command = new AssignPrivateIpAddressesCommand(input);
 * const response = await client.send(command);
 * /* response is
 * { /* metadata only *\/ }
 * *\/
 * ```
 *
 * @public
 */
export declare class AssignPrivateIpAddressesCommand extends AssignPrivateIpAddressesCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: AssignPrivateIpAddressesRequest;
            output: AssignPrivateIpAddressesResult;
        };
        sdk: {
            input: AssignPrivateIpAddressesCommandInput;
            output: AssignPrivateIpAddressesCommandOutput;
        };
    };
}
