import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateRouteServerPeerRequest, CreateRouteServerPeerResult } from "../models/models_2";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link CreateRouteServerPeerCommand}.
 */
export interface CreateRouteServerPeerCommandInput extends CreateRouteServerPeerRequest {
}
/**
 * @public
 *
 * The output of {@link CreateRouteServerPeerCommand}.
 */
export interface CreateRouteServerPeerCommandOutput extends CreateRouteServerPeerResult, __MetadataBearer {
}
declare const CreateRouteServerPeerCommand_base: {
    new (input: CreateRouteServerPeerCommandInput): import("@smithy/smithy-client").CommandImpl<CreateRouteServerPeerCommandInput, CreateRouteServerPeerCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: CreateRouteServerPeerCommandInput): import("@smithy/smithy-client").CommandImpl<CreateRouteServerPeerCommandInput, CreateRouteServerPeerCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Creates a new BGP peer for a specified route server endpoint.</p>
 *          <p>A route server peer is a session between a route server endpoint and the device deployed in Amazon Web Services (such as a firewall appliance or other network security function running on an EC2 instance). The device must meet these requirements:</p>
 *          <ul>
 *             <li>
 *                <p>Have an elastic network interface in the VPC</p>
 *             </li>
 *             <li>
 *                <p>Support BGP (Border Gateway Protocol)</p>
 *             </li>
 *             <li>
 *                <p>Can initiate BGP sessions</p>
 *             </li>
 *          </ul>
 *          <p>For more information see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/dynamic-routing-route-server.html">Dynamic routing in your VPC with VPC Route Server</a> in the <i>Amazon VPC User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, CreateRouteServerPeerCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, CreateRouteServerPeerCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * // import type { EC2ClientConfig } from "@aws-sdk/client-ec2";
 * const config = {}; // type is EC2ClientConfig
 * const client = new EC2Client(config);
 * const input = { // CreateRouteServerPeerRequest
 *   RouteServerEndpointId: "STRING_VALUE", // required
 *   PeerAddress: "STRING_VALUE", // required
 *   BgpOptions: { // RouteServerBgpOptionsRequest
 *     PeerAsn: Number("long"), // required
 *     PeerLivenessDetection: "bfd" || "bgp-keepalive",
 *   },
 *   DryRun: true || false,
 *   TagSpecifications: [ // TagSpecificationList
 *     { // TagSpecification
 *       ResourceType: "capacity-reservation" || "client-vpn-endpoint" || "customer-gateway" || "carrier-gateway" || "coip-pool" || "declarative-policies-report" || "dedicated-host" || "dhcp-options" || "egress-only-internet-gateway" || "elastic-ip" || "elastic-gpu" || "export-image-task" || "export-instance-task" || "fleet" || "fpga-image" || "host-reservation" || "image" || "image-usage-report" || "import-image-task" || "import-snapshot-task" || "instance" || "instance-event-window" || "internet-gateway" || "ipam" || "ipam-pool" || "ipam-scope" || "ipv4pool-ec2" || "ipv6pool-ec2" || "key-pair" || "launch-template" || "local-gateway" || "local-gateway-route-table" || "local-gateway-virtual-interface" || "local-gateway-virtual-interface-group" || "local-gateway-route-table-vpc-association" || "local-gateway-route-table-virtual-interface-group-association" || "natgateway" || "network-acl" || "network-interface" || "network-insights-analysis" || "network-insights-path" || "network-insights-access-scope" || "network-insights-access-scope-analysis" || "outpost-lag" || "placement-group" || "prefix-list" || "replace-root-volume-task" || "reserved-instances" || "route-table" || "security-group" || "security-group-rule" || "service-link-virtual-interface" || "snapshot" || "spot-fleet-request" || "spot-instances-request" || "subnet" || "subnet-cidr-reservation" || "traffic-mirror-filter" || "traffic-mirror-session" || "traffic-mirror-target" || "transit-gateway" || "transit-gateway-attachment" || "transit-gateway-connect-peer" || "transit-gateway-multicast-domain" || "transit-gateway-policy-table" || "transit-gateway-route-table" || "transit-gateway-route-table-announcement" || "volume" || "vpc" || "vpc-endpoint" || "vpc-endpoint-connection" || "vpc-endpoint-service" || "vpc-endpoint-service-permission" || "vpc-peering-connection" || "vpn-connection" || "vpn-gateway" || "vpc-flow-log" || "capacity-reservation-fleet" || "traffic-mirror-filter-rule" || "vpc-endpoint-connection-device-type" || "verified-access-instance" || "verified-access-group" || "verified-access-endpoint" || "verified-access-policy" || "verified-access-trust-provider" || "vpn-connection-device-type" || "vpc-block-public-access-exclusion" || "route-server" || "route-server-endpoint" || "route-server-peer" || "ipam-resource-discovery" || "ipam-resource-discovery-association" || "instance-connect-endpoint" || "verified-access-endpoint-target" || "ipam-external-resource-verification-token" || "capacity-block" || "mac-modification-task",
 *       Tags: [ // TagList
 *         { // Tag
 *           Key: "STRING_VALUE",
 *           Value: "STRING_VALUE",
 *         },
 *       ],
 *     },
 *   ],
 * };
 * const command = new CreateRouteServerPeerCommand(input);
 * const response = await client.send(command);
 * // { // CreateRouteServerPeerResult
 * //   RouteServerPeer: { // RouteServerPeer
 * //     RouteServerPeerId: "STRING_VALUE",
 * //     RouteServerEndpointId: "STRING_VALUE",
 * //     RouteServerId: "STRING_VALUE",
 * //     VpcId: "STRING_VALUE",
 * //     SubnetId: "STRING_VALUE",
 * //     State: "pending" || "available" || "deleting" || "deleted" || "failing" || "failed",
 * //     FailureReason: "STRING_VALUE",
 * //     EndpointEniId: "STRING_VALUE",
 * //     EndpointEniAddress: "STRING_VALUE",
 * //     PeerAddress: "STRING_VALUE",
 * //     BgpOptions: { // RouteServerBgpOptions
 * //       PeerAsn: Number("long"),
 * //       PeerLivenessDetection: "bfd" || "bgp-keepalive",
 * //     },
 * //     BgpStatus: { // RouteServerBgpStatus
 * //       Status: "up" || "down",
 * //     },
 * //     BfdStatus: { // RouteServerBfdStatus
 * //       Status: "up" || "down",
 * //     },
 * //     Tags: [ // TagList
 * //       { // Tag
 * //         Key: "STRING_VALUE",
 * //         Value: "STRING_VALUE",
 * //       },
 * //     ],
 * //   },
 * // };
 *
 * ```
 *
 * @param CreateRouteServerPeerCommandInput - {@link CreateRouteServerPeerCommandInput}
 * @returns {@link CreateRouteServerPeerCommandOutput}
 * @see {@link CreateRouteServerPeerCommandInput} for command's `input` shape.
 * @see {@link CreateRouteServerPeerCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class CreateRouteServerPeerCommand extends CreateRouteServerPeerCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: CreateRouteServerPeerRequest;
            output: CreateRouteServerPeerResult;
        };
        sdk: {
            input: CreateRouteServerPeerCommandInput;
            output: CreateRouteServerPeerCommandOutput;
        };
    };
}
