import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeSnapshotAttributeRequest, DescribeSnapshotAttributeResult } from "../models/models_5";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DescribeSnapshotAttributeCommand}.
 */
export interface DescribeSnapshotAttributeCommandInput extends DescribeSnapshotAttributeRequest {
}
/**
 * @public
 *
 * The output of {@link DescribeSnapshotAttributeCommand}.
 */
export interface DescribeSnapshotAttributeCommandOutput extends DescribeSnapshotAttributeResult, __MetadataBearer {
}
declare const DescribeSnapshotAttributeCommand_base: {
    new (input: DescribeSnapshotAttributeCommandInput): import("@smithy/smithy-client").CommandImpl<DescribeSnapshotAttributeCommandInput, DescribeSnapshotAttributeCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: DescribeSnapshotAttributeCommandInput): import("@smithy/smithy-client").CommandImpl<DescribeSnapshotAttributeCommandInput, DescribeSnapshotAttributeCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Describes the specified attribute of the specified snapshot. You can specify only one
 *       attribute at a time.</p>
 *          <p>For more information about EBS snapshots, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-snapshots.html">Amazon EBS snapshots</a> in the <i>Amazon EBS User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DescribeSnapshotAttributeCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DescribeSnapshotAttributeCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * // import type { EC2ClientConfig } from "@aws-sdk/client-ec2";
 * const config = {}; // type is EC2ClientConfig
 * const client = new EC2Client(config);
 * const input = { // DescribeSnapshotAttributeRequest
 *   Attribute: "productCodes" || "createVolumePermission", // required
 *   SnapshotId: "STRING_VALUE", // required
 *   DryRun: true || false,
 * };
 * const command = new DescribeSnapshotAttributeCommand(input);
 * const response = await client.send(command);
 * // { // DescribeSnapshotAttributeResult
 * //   ProductCodes: [ // ProductCodeList
 * //     { // ProductCode
 * //       ProductCodeId: "STRING_VALUE",
 * //       ProductCodeType: "devpay" || "marketplace",
 * //     },
 * //   ],
 * //   SnapshotId: "STRING_VALUE",
 * //   CreateVolumePermissions: [ // CreateVolumePermissionList
 * //     { // CreateVolumePermission
 * //       UserId: "STRING_VALUE",
 * //       Group: "all",
 * //     },
 * //   ],
 * // };
 *
 * ```
 *
 * @param DescribeSnapshotAttributeCommandInput - {@link DescribeSnapshotAttributeCommandInput}
 * @returns {@link DescribeSnapshotAttributeCommandOutput}
 * @see {@link DescribeSnapshotAttributeCommandInput} for command's `input` shape.
 * @see {@link DescribeSnapshotAttributeCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @example To describe snapshot attributes
 * ```javascript
 * // This example describes the ``createVolumePermission`` attribute on a snapshot with the snapshot ID of ``snap-066877671789bd71b``.
 * const input = {
 *   Attribute: "createVolumePermission",
 *   SnapshotId: "snap-066877671789bd71b"
 * };
 * const command = new DescribeSnapshotAttributeCommand(input);
 * const response = await client.send(command);
 * /* response is
 * {
 *   CreateVolumePermissions:   [],
 *   SnapshotId: "snap-066877671789bd71b"
 * }
 * *\/
 * ```
 *
 * @public
 */
export declare class DescribeSnapshotAttributeCommand extends DescribeSnapshotAttributeCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DescribeSnapshotAttributeRequest;
            output: DescribeSnapshotAttributeResult;
        };
        sdk: {
            input: DescribeSnapshotAttributeCommandInput;
            output: DescribeSnapshotAttributeCommandOutput;
        };
    };
}
