import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { GetTransitGatewayPolicyTableEntriesRequest, GetTransitGatewayPolicyTableEntriesResult } from "../models/models_7";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link GetTransitGatewayPolicyTableEntriesCommand}.
 */
export interface GetTransitGatewayPolicyTableEntriesCommandInput extends GetTransitGatewayPolicyTableEntriesRequest {
}
/**
 * @public
 *
 * The output of {@link GetTransitGatewayPolicyTableEntriesCommand}.
 */
export interface GetTransitGatewayPolicyTableEntriesCommandOutput extends GetTransitGatewayPolicyTableEntriesResult, __MetadataBearer {
}
declare const GetTransitGatewayPolicyTableEntriesCommand_base: {
    new (input: GetTransitGatewayPolicyTableEntriesCommandInput): import("@smithy/smithy-client").CommandImpl<GetTransitGatewayPolicyTableEntriesCommandInput, GetTransitGatewayPolicyTableEntriesCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: GetTransitGatewayPolicyTableEntriesCommandInput): import("@smithy/smithy-client").CommandImpl<GetTransitGatewayPolicyTableEntriesCommandInput, GetTransitGatewayPolicyTableEntriesCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Returns a list of transit gateway policy table entries.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, GetTransitGatewayPolicyTableEntriesCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, GetTransitGatewayPolicyTableEntriesCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * // import type { EC2ClientConfig } from "@aws-sdk/client-ec2";
 * const config = {}; // type is EC2ClientConfig
 * const client = new EC2Client(config);
 * const input = { // GetTransitGatewayPolicyTableEntriesRequest
 *   TransitGatewayPolicyTableId: "STRING_VALUE", // required
 *   Filters: [ // FilterList
 *     { // Filter
 *       Name: "STRING_VALUE",
 *       Values: [ // ValueStringList
 *         "STRING_VALUE",
 *       ],
 *     },
 *   ],
 *   MaxResults: Number("int"),
 *   NextToken: "STRING_VALUE",
 *   DryRun: true || false,
 * };
 * const command = new GetTransitGatewayPolicyTableEntriesCommand(input);
 * const response = await client.send(command);
 * // { // GetTransitGatewayPolicyTableEntriesResult
 * //   TransitGatewayPolicyTableEntries: [ // TransitGatewayPolicyTableEntryList
 * //     { // TransitGatewayPolicyTableEntry
 * //       PolicyRuleNumber: "STRING_VALUE",
 * //       PolicyRule: { // TransitGatewayPolicyRule
 * //         SourceCidrBlock: "STRING_VALUE",
 * //         SourcePortRange: "STRING_VALUE",
 * //         DestinationCidrBlock: "STRING_VALUE",
 * //         DestinationPortRange: "STRING_VALUE",
 * //         Protocol: "STRING_VALUE",
 * //         MetaData: { // TransitGatewayPolicyRuleMetaData
 * //           MetaDataKey: "STRING_VALUE",
 * //           MetaDataValue: "STRING_VALUE",
 * //         },
 * //       },
 * //       TargetRouteTableId: "STRING_VALUE",
 * //     },
 * //   ],
 * // };
 *
 * ```
 *
 * @param GetTransitGatewayPolicyTableEntriesCommandInput - {@link GetTransitGatewayPolicyTableEntriesCommandInput}
 * @returns {@link GetTransitGatewayPolicyTableEntriesCommandOutput}
 * @see {@link GetTransitGatewayPolicyTableEntriesCommandInput} for command's `input` shape.
 * @see {@link GetTransitGatewayPolicyTableEntriesCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class GetTransitGatewayPolicyTableEntriesCommand extends GetTransitGatewayPolicyTableEntriesCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: GetTransitGatewayPolicyTableEntriesRequest;
            output: GetTransitGatewayPolicyTableEntriesResult;
        };
        sdk: {
            input: GetTransitGatewayPolicyTableEntriesCommandInput;
            output: GetTransitGatewayPolicyTableEntriesCommandOutput;
        };
    };
}
