import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { PurchaseReservedInstancesOfferingRequest, PurchaseReservedInstancesOfferingResult } from "../models/models_8";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link PurchaseReservedInstancesOfferingCommand}.
 */
export interface PurchaseReservedInstancesOfferingCommandInput extends PurchaseReservedInstancesOfferingRequest {
}
/**
 * @public
 *
 * The output of {@link PurchaseReservedInstancesOfferingCommand}.
 */
export interface PurchaseReservedInstancesOfferingCommandOutput extends PurchaseReservedInstancesOfferingResult, __MetadataBearer {
}
declare const PurchaseReservedInstancesOfferingCommand_base: {
    new (input: PurchaseReservedInstancesOfferingCommandInput): import("@smithy/smithy-client").CommandImpl<PurchaseReservedInstancesOfferingCommandInput, PurchaseReservedInstancesOfferingCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: PurchaseReservedInstancesOfferingCommandInput): import("@smithy/smithy-client").CommandImpl<PurchaseReservedInstancesOfferingCommandInput, PurchaseReservedInstancesOfferingCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Purchases a Reserved Instance for use with your account. With Reserved Instances, you pay
 *       a lower hourly rate compared to On-Demand instance pricing.</p>
 *          <p>Use <a>DescribeReservedInstancesOfferings</a> to get a list of Reserved
 *       Instance offerings that match your specifications. After you've purchased a Reserved Instance,
 *       you can check for your new Reserved Instance with <a>DescribeReservedInstances</a>.</p>
 *          <p>To queue a purchase for a future date and time, specify a purchase time. If you do not
 *       specify a purchase time, the default is the current time.</p>
 *          <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-on-demand-reserved-instances.html">Reserved
 *         Instances</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Sell in the Reserved Instance
 *         Marketplace</a> in the <i>Amazon EC2 User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, PurchaseReservedInstancesOfferingCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, PurchaseReservedInstancesOfferingCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * // import type { EC2ClientConfig } from "@aws-sdk/client-ec2";
 * const config = {}; // type is EC2ClientConfig
 * const client = new EC2Client(config);
 * const input = { // PurchaseReservedInstancesOfferingRequest
 *   InstanceCount: Number("int"), // required
 *   ReservedInstancesOfferingId: "STRING_VALUE", // required
 *   PurchaseTime: new Date("TIMESTAMP"),
 *   DryRun: true || false,
 *   LimitPrice: { // ReservedInstanceLimitPrice
 *     Amount: Number("double"),
 *     CurrencyCode: "USD",
 *   },
 * };
 * const command = new PurchaseReservedInstancesOfferingCommand(input);
 * const response = await client.send(command);
 * // { // PurchaseReservedInstancesOfferingResult
 * //   ReservedInstancesId: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param PurchaseReservedInstancesOfferingCommandInput - {@link PurchaseReservedInstancesOfferingCommandInput}
 * @returns {@link PurchaseReservedInstancesOfferingCommandOutput}
 * @see {@link PurchaseReservedInstancesOfferingCommandInput} for command's `input` shape.
 * @see {@link PurchaseReservedInstancesOfferingCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class PurchaseReservedInstancesOfferingCommand extends PurchaseReservedInstancesOfferingCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: PurchaseReservedInstancesOfferingRequest;
            output: PurchaseReservedInstancesOfferingResult;
        };
        sdk: {
            input: PurchaseReservedInstancesOfferingCommandInput;
            output: PurchaseReservedInstancesOfferingCommandOutput;
        };
    };
}
