import { HttpHandlerOptions as __HttpHandlerOptions } from "@smithy/types";
import { CancelKeyDeletionCommandInput, CancelKeyDeletionCommandOutput } from "./commands/CancelKeyDeletionCommand";
import { ConnectCustomKeyStoreCommandInput, ConnectCustomKeyStoreCommandOutput } from "./commands/ConnectCustomKeyStoreCommand";
import { CreateAliasCommandInput, CreateAliasCommandOutput } from "./commands/CreateAliasCommand";
import { CreateCustomKeyStoreCommandInput, CreateCustomKeyStoreCommandOutput } from "./commands/CreateCustomKeyStoreCommand";
import { CreateGrantCommandInput, CreateGrantCommandOutput } from "./commands/CreateGrantCommand";
import { CreateKeyCommandInput, CreateKeyCommandOutput } from "./commands/CreateKeyCommand";
import { DecryptCommandInput, DecryptCommandOutput } from "./commands/DecryptCommand";
import { DeleteAliasCommandInput, DeleteAliasCommandOutput } from "./commands/DeleteAliasCommand";
import { DeleteCustomKeyStoreCommandInput, DeleteCustomKeyStoreCommandOutput } from "./commands/DeleteCustomKeyStoreCommand";
import { DeleteImportedKeyMaterialCommandInput, DeleteImportedKeyMaterialCommandOutput } from "./commands/DeleteImportedKeyMaterialCommand";
import { DeriveSharedSecretCommandInput, DeriveSharedSecretCommandOutput } from "./commands/DeriveSharedSecretCommand";
import { DescribeCustomKeyStoresCommandInput, DescribeCustomKeyStoresCommandOutput } from "./commands/DescribeCustomKeyStoresCommand";
import { DescribeKeyCommandInput, DescribeKeyCommandOutput } from "./commands/DescribeKeyCommand";
import { DisableKeyCommandInput, DisableKeyCommandOutput } from "./commands/DisableKeyCommand";
import { DisableKeyRotationCommandInput, DisableKeyRotationCommandOutput } from "./commands/DisableKeyRotationCommand";
import { DisconnectCustomKeyStoreCommandInput, DisconnectCustomKeyStoreCommandOutput } from "./commands/DisconnectCustomKeyStoreCommand";
import { EnableKeyCommandInput, EnableKeyCommandOutput } from "./commands/EnableKeyCommand";
import { EnableKeyRotationCommandInput, EnableKeyRotationCommandOutput } from "./commands/EnableKeyRotationCommand";
import { EncryptCommandInput, EncryptCommandOutput } from "./commands/EncryptCommand";
import { GenerateDataKeyCommandInput, GenerateDataKeyCommandOutput } from "./commands/GenerateDataKeyCommand";
import { GenerateDataKeyPairCommandInput, GenerateDataKeyPairCommandOutput } from "./commands/GenerateDataKeyPairCommand";
import { GenerateDataKeyPairWithoutPlaintextCommandInput, GenerateDataKeyPairWithoutPlaintextCommandOutput } from "./commands/GenerateDataKeyPairWithoutPlaintextCommand";
import { GenerateDataKeyWithoutPlaintextCommandInput, GenerateDataKeyWithoutPlaintextCommandOutput } from "./commands/GenerateDataKeyWithoutPlaintextCommand";
import { GenerateMacCommandInput, GenerateMacCommandOutput } from "./commands/GenerateMacCommand";
import { GenerateRandomCommandInput, GenerateRandomCommandOutput } from "./commands/GenerateRandomCommand";
import { GetKeyPolicyCommandInput, GetKeyPolicyCommandOutput } from "./commands/GetKeyPolicyCommand";
import { GetKeyRotationStatusCommandInput, GetKeyRotationStatusCommandOutput } from "./commands/GetKeyRotationStatusCommand";
import { GetParametersForImportCommandInput, GetParametersForImportCommandOutput } from "./commands/GetParametersForImportCommand";
import { GetPublicKeyCommandInput, GetPublicKeyCommandOutput } from "./commands/GetPublicKeyCommand";
import { ImportKeyMaterialCommandInput, ImportKeyMaterialCommandOutput } from "./commands/ImportKeyMaterialCommand";
import { ListAliasesCommandInput, ListAliasesCommandOutput } from "./commands/ListAliasesCommand";
import { ListGrantsCommandInput, ListGrantsCommandOutput } from "./commands/ListGrantsCommand";
import { ListKeyPoliciesCommandInput, ListKeyPoliciesCommandOutput } from "./commands/ListKeyPoliciesCommand";
import { ListKeyRotationsCommandInput, ListKeyRotationsCommandOutput } from "./commands/ListKeyRotationsCommand";
import { ListKeysCommandInput, ListKeysCommandOutput } from "./commands/ListKeysCommand";
import { ListResourceTagsCommandInput, ListResourceTagsCommandOutput } from "./commands/ListResourceTagsCommand";
import { ListRetirableGrantsCommandInput, ListRetirableGrantsCommandOutput } from "./commands/ListRetirableGrantsCommand";
import { PutKeyPolicyCommandInput, PutKeyPolicyCommandOutput } from "./commands/PutKeyPolicyCommand";
import { ReEncryptCommandInput, ReEncryptCommandOutput } from "./commands/ReEncryptCommand";
import { ReplicateKeyCommandInput, ReplicateKeyCommandOutput } from "./commands/ReplicateKeyCommand";
import { RetireGrantCommandInput, RetireGrantCommandOutput } from "./commands/RetireGrantCommand";
import { RevokeGrantCommandInput, RevokeGrantCommandOutput } from "./commands/RevokeGrantCommand";
import { RotateKeyOnDemandCommandInput, RotateKeyOnDemandCommandOutput } from "./commands/RotateKeyOnDemandCommand";
import { ScheduleKeyDeletionCommandInput, ScheduleKeyDeletionCommandOutput } from "./commands/ScheduleKeyDeletionCommand";
import { SignCommandInput, SignCommandOutput } from "./commands/SignCommand";
import { TagResourceCommandInput, TagResourceCommandOutput } from "./commands/TagResourceCommand";
import { UntagResourceCommandInput, UntagResourceCommandOutput } from "./commands/UntagResourceCommand";
import { UpdateAliasCommandInput, UpdateAliasCommandOutput } from "./commands/UpdateAliasCommand";
import { UpdateCustomKeyStoreCommandInput, UpdateCustomKeyStoreCommandOutput } from "./commands/UpdateCustomKeyStoreCommand";
import { UpdateKeyDescriptionCommandInput, UpdateKeyDescriptionCommandOutput } from "./commands/UpdateKeyDescriptionCommand";
import { UpdatePrimaryRegionCommandInput, UpdatePrimaryRegionCommandOutput } from "./commands/UpdatePrimaryRegionCommand";
import { VerifyCommandInput, VerifyCommandOutput } from "./commands/VerifyCommand";
import { VerifyMacCommandInput, VerifyMacCommandOutput } from "./commands/VerifyMacCommand";
import { KMSClient } from "./KMSClient";
export interface KMS {
    /**
     * @see {@link CancelKeyDeletionCommand}
     */
    cancelKeyDeletion(args: CancelKeyDeletionCommandInput, options?: __HttpHandlerOptions): Promise<CancelKeyDeletionCommandOutput>;
    cancelKeyDeletion(args: CancelKeyDeletionCommandInput, cb: (err: any, data?: CancelKeyDeletionCommandOutput) => void): void;
    cancelKeyDeletion(args: CancelKeyDeletionCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CancelKeyDeletionCommandOutput) => void): void;
    /**
     * @see {@link ConnectCustomKeyStoreCommand}
     */
    connectCustomKeyStore(args: ConnectCustomKeyStoreCommandInput, options?: __HttpHandlerOptions): Promise<ConnectCustomKeyStoreCommandOutput>;
    connectCustomKeyStore(args: ConnectCustomKeyStoreCommandInput, cb: (err: any, data?: ConnectCustomKeyStoreCommandOutput) => void): void;
    connectCustomKeyStore(args: ConnectCustomKeyStoreCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ConnectCustomKeyStoreCommandOutput) => void): void;
    /**
     * @see {@link CreateAliasCommand}
     */
    createAlias(args: CreateAliasCommandInput, options?: __HttpHandlerOptions): Promise<CreateAliasCommandOutput>;
    createAlias(args: CreateAliasCommandInput, cb: (err: any, data?: CreateAliasCommandOutput) => void): void;
    createAlias(args: CreateAliasCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreateAliasCommandOutput) => void): void;
    /**
     * @see {@link CreateCustomKeyStoreCommand}
     */
    createCustomKeyStore(args: CreateCustomKeyStoreCommandInput, options?: __HttpHandlerOptions): Promise<CreateCustomKeyStoreCommandOutput>;
    createCustomKeyStore(args: CreateCustomKeyStoreCommandInput, cb: (err: any, data?: CreateCustomKeyStoreCommandOutput) => void): void;
    createCustomKeyStore(args: CreateCustomKeyStoreCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreateCustomKeyStoreCommandOutput) => void): void;
    /**
     * @see {@link CreateGrantCommand}
     */
    createGrant(args: CreateGrantCommandInput, options?: __HttpHandlerOptions): Promise<CreateGrantCommandOutput>;
    createGrant(args: CreateGrantCommandInput, cb: (err: any, data?: CreateGrantCommandOutput) => void): void;
    createGrant(args: CreateGrantCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreateGrantCommandOutput) => void): void;
    /**
     * @see {@link CreateKeyCommand}
     */
    createKey(): Promise<CreateKeyCommandOutput>;
    createKey(args: CreateKeyCommandInput, options?: __HttpHandlerOptions): Promise<CreateKeyCommandOutput>;
    createKey(args: CreateKeyCommandInput, cb: (err: any, data?: CreateKeyCommandOutput) => void): void;
    createKey(args: CreateKeyCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreateKeyCommandOutput) => void): void;
    /**
     * @see {@link DecryptCommand}
     */
    decrypt(args: DecryptCommandInput, options?: __HttpHandlerOptions): Promise<DecryptCommandOutput>;
    decrypt(args: DecryptCommandInput, cb: (err: any, data?: DecryptCommandOutput) => void): void;
    decrypt(args: DecryptCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DecryptCommandOutput) => void): void;
    /**
     * @see {@link DeleteAliasCommand}
     */
    deleteAlias(args: DeleteAliasCommandInput, options?: __HttpHandlerOptions): Promise<DeleteAliasCommandOutput>;
    deleteAlias(args: DeleteAliasCommandInput, cb: (err: any, data?: DeleteAliasCommandOutput) => void): void;
    deleteAlias(args: DeleteAliasCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteAliasCommandOutput) => void): void;
    /**
     * @see {@link DeleteCustomKeyStoreCommand}
     */
    deleteCustomKeyStore(args: DeleteCustomKeyStoreCommandInput, options?: __HttpHandlerOptions): Promise<DeleteCustomKeyStoreCommandOutput>;
    deleteCustomKeyStore(args: DeleteCustomKeyStoreCommandInput, cb: (err: any, data?: DeleteCustomKeyStoreCommandOutput) => void): void;
    deleteCustomKeyStore(args: DeleteCustomKeyStoreCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteCustomKeyStoreCommandOutput) => void): void;
    /**
     * @see {@link DeleteImportedKeyMaterialCommand}
     */
    deleteImportedKeyMaterial(args: DeleteImportedKeyMaterialCommandInput, options?: __HttpHandlerOptions): Promise<DeleteImportedKeyMaterialCommandOutput>;
    deleteImportedKeyMaterial(args: DeleteImportedKeyMaterialCommandInput, cb: (err: any, data?: DeleteImportedKeyMaterialCommandOutput) => void): void;
    deleteImportedKeyMaterial(args: DeleteImportedKeyMaterialCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteImportedKeyMaterialCommandOutput) => void): void;
    /**
     * @see {@link DeriveSharedSecretCommand}
     */
    deriveSharedSecret(args: DeriveSharedSecretCommandInput, options?: __HttpHandlerOptions): Promise<DeriveSharedSecretCommandOutput>;
    deriveSharedSecret(args: DeriveSharedSecretCommandInput, cb: (err: any, data?: DeriveSharedSecretCommandOutput) => void): void;
    deriveSharedSecret(args: DeriveSharedSecretCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeriveSharedSecretCommandOutput) => void): void;
    /**
     * @see {@link DescribeCustomKeyStoresCommand}
     */
    describeCustomKeyStores(): Promise<DescribeCustomKeyStoresCommandOutput>;
    describeCustomKeyStores(args: DescribeCustomKeyStoresCommandInput, options?: __HttpHandlerOptions): Promise<DescribeCustomKeyStoresCommandOutput>;
    describeCustomKeyStores(args: DescribeCustomKeyStoresCommandInput, cb: (err: any, data?: DescribeCustomKeyStoresCommandOutput) => void): void;
    describeCustomKeyStores(args: DescribeCustomKeyStoresCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DescribeCustomKeyStoresCommandOutput) => void): void;
    /**
     * @see {@link DescribeKeyCommand}
     */
    describeKey(args: DescribeKeyCommandInput, options?: __HttpHandlerOptions): Promise<DescribeKeyCommandOutput>;
    describeKey(args: DescribeKeyCommandInput, cb: (err: any, data?: DescribeKeyCommandOutput) => void): void;
    describeKey(args: DescribeKeyCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DescribeKeyCommandOutput) => void): void;
    /**
     * @see {@link DisableKeyCommand}
     */
    disableKey(args: DisableKeyCommandInput, options?: __HttpHandlerOptions): Promise<DisableKeyCommandOutput>;
    disableKey(args: DisableKeyCommandInput, cb: (err: any, data?: DisableKeyCommandOutput) => void): void;
    disableKey(args: DisableKeyCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DisableKeyCommandOutput) => void): void;
    /**
     * @see {@link DisableKeyRotationCommand}
     */
    disableKeyRotation(args: DisableKeyRotationCommandInput, options?: __HttpHandlerOptions): Promise<DisableKeyRotationCommandOutput>;
    disableKeyRotation(args: DisableKeyRotationCommandInput, cb: (err: any, data?: DisableKeyRotationCommandOutput) => void): void;
    disableKeyRotation(args: DisableKeyRotationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DisableKeyRotationCommandOutput) => void): void;
    /**
     * @see {@link DisconnectCustomKeyStoreCommand}
     */
    disconnectCustomKeyStore(args: DisconnectCustomKeyStoreCommandInput, options?: __HttpHandlerOptions): Promise<DisconnectCustomKeyStoreCommandOutput>;
    disconnectCustomKeyStore(args: DisconnectCustomKeyStoreCommandInput, cb: (err: any, data?: DisconnectCustomKeyStoreCommandOutput) => void): void;
    disconnectCustomKeyStore(args: DisconnectCustomKeyStoreCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DisconnectCustomKeyStoreCommandOutput) => void): void;
    /**
     * @see {@link EnableKeyCommand}
     */
    enableKey(args: EnableKeyCommandInput, options?: __HttpHandlerOptions): Promise<EnableKeyCommandOutput>;
    enableKey(args: EnableKeyCommandInput, cb: (err: any, data?: EnableKeyCommandOutput) => void): void;
    enableKey(args: EnableKeyCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: EnableKeyCommandOutput) => void): void;
    /**
     * @see {@link EnableKeyRotationCommand}
     */
    enableKeyRotation(args: EnableKeyRotationCommandInput, options?: __HttpHandlerOptions): Promise<EnableKeyRotationCommandOutput>;
    enableKeyRotation(args: EnableKeyRotationCommandInput, cb: (err: any, data?: EnableKeyRotationCommandOutput) => void): void;
    enableKeyRotation(args: EnableKeyRotationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: EnableKeyRotationCommandOutput) => void): void;
    /**
     * @see {@link EncryptCommand}
     */
    encrypt(args: EncryptCommandInput, options?: __HttpHandlerOptions): Promise<EncryptCommandOutput>;
    encrypt(args: EncryptCommandInput, cb: (err: any, data?: EncryptCommandOutput) => void): void;
    encrypt(args: EncryptCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: EncryptCommandOutput) => void): void;
    /**
     * @see {@link GenerateDataKeyCommand}
     */
    generateDataKey(args: GenerateDataKeyCommandInput, options?: __HttpHandlerOptions): Promise<GenerateDataKeyCommandOutput>;
    generateDataKey(args: GenerateDataKeyCommandInput, cb: (err: any, data?: GenerateDataKeyCommandOutput) => void): void;
    generateDataKey(args: GenerateDataKeyCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GenerateDataKeyCommandOutput) => void): void;
    /**
     * @see {@link GenerateDataKeyPairCommand}
     */
    generateDataKeyPair(args: GenerateDataKeyPairCommandInput, options?: __HttpHandlerOptions): Promise<GenerateDataKeyPairCommandOutput>;
    generateDataKeyPair(args: GenerateDataKeyPairCommandInput, cb: (err: any, data?: GenerateDataKeyPairCommandOutput) => void): void;
    generateDataKeyPair(args: GenerateDataKeyPairCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GenerateDataKeyPairCommandOutput) => void): void;
    /**
     * @see {@link GenerateDataKeyPairWithoutPlaintextCommand}
     */
    generateDataKeyPairWithoutPlaintext(args: GenerateDataKeyPairWithoutPlaintextCommandInput, options?: __HttpHandlerOptions): Promise<GenerateDataKeyPairWithoutPlaintextCommandOutput>;
    generateDataKeyPairWithoutPlaintext(args: GenerateDataKeyPairWithoutPlaintextCommandInput, cb: (err: any, data?: GenerateDataKeyPairWithoutPlaintextCommandOutput) => void): void;
    generateDataKeyPairWithoutPlaintext(args: GenerateDataKeyPairWithoutPlaintextCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GenerateDataKeyPairWithoutPlaintextCommandOutput) => void): void;
    /**
     * @see {@link GenerateDataKeyWithoutPlaintextCommand}
     */
    generateDataKeyWithoutPlaintext(args: GenerateDataKeyWithoutPlaintextCommandInput, options?: __HttpHandlerOptions): Promise<GenerateDataKeyWithoutPlaintextCommandOutput>;
    generateDataKeyWithoutPlaintext(args: GenerateDataKeyWithoutPlaintextCommandInput, cb: (err: any, data?: GenerateDataKeyWithoutPlaintextCommandOutput) => void): void;
    generateDataKeyWithoutPlaintext(args: GenerateDataKeyWithoutPlaintextCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GenerateDataKeyWithoutPlaintextCommandOutput) => void): void;
    /**
     * @see {@link GenerateMacCommand}
     */
    generateMac(args: GenerateMacCommandInput, options?: __HttpHandlerOptions): Promise<GenerateMacCommandOutput>;
    generateMac(args: GenerateMacCommandInput, cb: (err: any, data?: GenerateMacCommandOutput) => void): void;
    generateMac(args: GenerateMacCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GenerateMacCommandOutput) => void): void;
    /**
     * @see {@link GenerateRandomCommand}
     */
    generateRandom(): Promise<GenerateRandomCommandOutput>;
    generateRandom(args: GenerateRandomCommandInput, options?: __HttpHandlerOptions): Promise<GenerateRandomCommandOutput>;
    generateRandom(args: GenerateRandomCommandInput, cb: (err: any, data?: GenerateRandomCommandOutput) => void): void;
    generateRandom(args: GenerateRandomCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GenerateRandomCommandOutput) => void): void;
    /**
     * @see {@link GetKeyPolicyCommand}
     */
    getKeyPolicy(args: GetKeyPolicyCommandInput, options?: __HttpHandlerOptions): Promise<GetKeyPolicyCommandOutput>;
    getKeyPolicy(args: GetKeyPolicyCommandInput, cb: (err: any, data?: GetKeyPolicyCommandOutput) => void): void;
    getKeyPolicy(args: GetKeyPolicyCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetKeyPolicyCommandOutput) => void): void;
    /**
     * @see {@link GetKeyRotationStatusCommand}
     */
    getKeyRotationStatus(args: GetKeyRotationStatusCommandInput, options?: __HttpHandlerOptions): Promise<GetKeyRotationStatusCommandOutput>;
    getKeyRotationStatus(args: GetKeyRotationStatusCommandInput, cb: (err: any, data?: GetKeyRotationStatusCommandOutput) => void): void;
    getKeyRotationStatus(args: GetKeyRotationStatusCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetKeyRotationStatusCommandOutput) => void): void;
    /**
     * @see {@link GetParametersForImportCommand}
     */
    getParametersForImport(args: GetParametersForImportCommandInput, options?: __HttpHandlerOptions): Promise<GetParametersForImportCommandOutput>;
    getParametersForImport(args: GetParametersForImportCommandInput, cb: (err: any, data?: GetParametersForImportCommandOutput) => void): void;
    getParametersForImport(args: GetParametersForImportCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetParametersForImportCommandOutput) => void): void;
    /**
     * @see {@link GetPublicKeyCommand}
     */
    getPublicKey(args: GetPublicKeyCommandInput, options?: __HttpHandlerOptions): Promise<GetPublicKeyCommandOutput>;
    getPublicKey(args: GetPublicKeyCommandInput, cb: (err: any, data?: GetPublicKeyCommandOutput) => void): void;
    getPublicKey(args: GetPublicKeyCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetPublicKeyCommandOutput) => void): void;
    /**
     * @see {@link ImportKeyMaterialCommand}
     */
    importKeyMaterial(args: ImportKeyMaterialCommandInput, options?: __HttpHandlerOptions): Promise<ImportKeyMaterialCommandOutput>;
    importKeyMaterial(args: ImportKeyMaterialCommandInput, cb: (err: any, data?: ImportKeyMaterialCommandOutput) => void): void;
    importKeyMaterial(args: ImportKeyMaterialCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ImportKeyMaterialCommandOutput) => void): void;
    /**
     * @see {@link ListAliasesCommand}
     */
    listAliases(): Promise<ListAliasesCommandOutput>;
    listAliases(args: ListAliasesCommandInput, options?: __HttpHandlerOptions): Promise<ListAliasesCommandOutput>;
    listAliases(args: ListAliasesCommandInput, cb: (err: any, data?: ListAliasesCommandOutput) => void): void;
    listAliases(args: ListAliasesCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListAliasesCommandOutput) => void): void;
    /**
     * @see {@link ListGrantsCommand}
     */
    listGrants(args: ListGrantsCommandInput, options?: __HttpHandlerOptions): Promise<ListGrantsCommandOutput>;
    listGrants(args: ListGrantsCommandInput, cb: (err: any, data?: ListGrantsCommandOutput) => void): void;
    listGrants(args: ListGrantsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListGrantsCommandOutput) => void): void;
    /**
     * @see {@link ListKeyPoliciesCommand}
     */
    listKeyPolicies(args: ListKeyPoliciesCommandInput, options?: __HttpHandlerOptions): Promise<ListKeyPoliciesCommandOutput>;
    listKeyPolicies(args: ListKeyPoliciesCommandInput, cb: (err: any, data?: ListKeyPoliciesCommandOutput) => void): void;
    listKeyPolicies(args: ListKeyPoliciesCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListKeyPoliciesCommandOutput) => void): void;
    /**
     * @see {@link ListKeyRotationsCommand}
     */
    listKeyRotations(args: ListKeyRotationsCommandInput, options?: __HttpHandlerOptions): Promise<ListKeyRotationsCommandOutput>;
    listKeyRotations(args: ListKeyRotationsCommandInput, cb: (err: any, data?: ListKeyRotationsCommandOutput) => void): void;
    listKeyRotations(args: ListKeyRotationsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListKeyRotationsCommandOutput) => void): void;
    /**
     * @see {@link ListKeysCommand}
     */
    listKeys(): Promise<ListKeysCommandOutput>;
    listKeys(args: ListKeysCommandInput, options?: __HttpHandlerOptions): Promise<ListKeysCommandOutput>;
    listKeys(args: ListKeysCommandInput, cb: (err: any, data?: ListKeysCommandOutput) => void): void;
    listKeys(args: ListKeysCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListKeysCommandOutput) => void): void;
    /**
     * @see {@link ListResourceTagsCommand}
     */
    listResourceTags(args: ListResourceTagsCommandInput, options?: __HttpHandlerOptions): Promise<ListResourceTagsCommandOutput>;
    listResourceTags(args: ListResourceTagsCommandInput, cb: (err: any, data?: ListResourceTagsCommandOutput) => void): void;
    listResourceTags(args: ListResourceTagsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListResourceTagsCommandOutput) => void): void;
    /**
     * @see {@link ListRetirableGrantsCommand}
     */
    listRetirableGrants(args: ListRetirableGrantsCommandInput, options?: __HttpHandlerOptions): Promise<ListRetirableGrantsCommandOutput>;
    listRetirableGrants(args: ListRetirableGrantsCommandInput, cb: (err: any, data?: ListRetirableGrantsCommandOutput) => void): void;
    listRetirableGrants(args: ListRetirableGrantsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListRetirableGrantsCommandOutput) => void): void;
    /**
     * @see {@link PutKeyPolicyCommand}
     */
    putKeyPolicy(args: PutKeyPolicyCommandInput, options?: __HttpHandlerOptions): Promise<PutKeyPolicyCommandOutput>;
    putKeyPolicy(args: PutKeyPolicyCommandInput, cb: (err: any, data?: PutKeyPolicyCommandOutput) => void): void;
    putKeyPolicy(args: PutKeyPolicyCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: PutKeyPolicyCommandOutput) => void): void;
    /**
     * @see {@link ReEncryptCommand}
     */
    reEncrypt(args: ReEncryptCommandInput, options?: __HttpHandlerOptions): Promise<ReEncryptCommandOutput>;
    reEncrypt(args: ReEncryptCommandInput, cb: (err: any, data?: ReEncryptCommandOutput) => void): void;
    reEncrypt(args: ReEncryptCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ReEncryptCommandOutput) => void): void;
    /**
     * @see {@link ReplicateKeyCommand}
     */
    replicateKey(args: ReplicateKeyCommandInput, options?: __HttpHandlerOptions): Promise<ReplicateKeyCommandOutput>;
    replicateKey(args: ReplicateKeyCommandInput, cb: (err: any, data?: ReplicateKeyCommandOutput) => void): void;
    replicateKey(args: ReplicateKeyCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ReplicateKeyCommandOutput) => void): void;
    /**
     * @see {@link RetireGrantCommand}
     */
    retireGrant(): Promise<RetireGrantCommandOutput>;
    retireGrant(args: RetireGrantCommandInput, options?: __HttpHandlerOptions): Promise<RetireGrantCommandOutput>;
    retireGrant(args: RetireGrantCommandInput, cb: (err: any, data?: RetireGrantCommandOutput) => void): void;
    retireGrant(args: RetireGrantCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: RetireGrantCommandOutput) => void): void;
    /**
     * @see {@link RevokeGrantCommand}
     */
    revokeGrant(args: RevokeGrantCommandInput, options?: __HttpHandlerOptions): Promise<RevokeGrantCommandOutput>;
    revokeGrant(args: RevokeGrantCommandInput, cb: (err: any, data?: RevokeGrantCommandOutput) => void): void;
    revokeGrant(args: RevokeGrantCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: RevokeGrantCommandOutput) => void): void;
    /**
     * @see {@link RotateKeyOnDemandCommand}
     */
    rotateKeyOnDemand(args: RotateKeyOnDemandCommandInput, options?: __HttpHandlerOptions): Promise<RotateKeyOnDemandCommandOutput>;
    rotateKeyOnDemand(args: RotateKeyOnDemandCommandInput, cb: (err: any, data?: RotateKeyOnDemandCommandOutput) => void): void;
    rotateKeyOnDemand(args: RotateKeyOnDemandCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: RotateKeyOnDemandCommandOutput) => void): void;
    /**
     * @see {@link ScheduleKeyDeletionCommand}
     */
    scheduleKeyDeletion(args: ScheduleKeyDeletionCommandInput, options?: __HttpHandlerOptions): Promise<ScheduleKeyDeletionCommandOutput>;
    scheduleKeyDeletion(args: ScheduleKeyDeletionCommandInput, cb: (err: any, data?: ScheduleKeyDeletionCommandOutput) => void): void;
    scheduleKeyDeletion(args: ScheduleKeyDeletionCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ScheduleKeyDeletionCommandOutput) => void): void;
    /**
     * @see {@link SignCommand}
     */
    sign(args: SignCommandInput, options?: __HttpHandlerOptions): Promise<SignCommandOutput>;
    sign(args: SignCommandInput, cb: (err: any, data?: SignCommandOutput) => void): void;
    sign(args: SignCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: SignCommandOutput) => void): void;
    /**
     * @see {@link TagResourceCommand}
     */
    tagResource(args: TagResourceCommandInput, options?: __HttpHandlerOptions): Promise<TagResourceCommandOutput>;
    tagResource(args: TagResourceCommandInput, cb: (err: any, data?: TagResourceCommandOutput) => void): void;
    tagResource(args: TagResourceCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: TagResourceCommandOutput) => void): void;
    /**
     * @see {@link UntagResourceCommand}
     */
    untagResource(args: UntagResourceCommandInput, options?: __HttpHandlerOptions): Promise<UntagResourceCommandOutput>;
    untagResource(args: UntagResourceCommandInput, cb: (err: any, data?: UntagResourceCommandOutput) => void): void;
    untagResource(args: UntagResourceCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UntagResourceCommandOutput) => void): void;
    /**
     * @see {@link UpdateAliasCommand}
     */
    updateAlias(args: UpdateAliasCommandInput, options?: __HttpHandlerOptions): Promise<UpdateAliasCommandOutput>;
    updateAlias(args: UpdateAliasCommandInput, cb: (err: any, data?: UpdateAliasCommandOutput) => void): void;
    updateAlias(args: UpdateAliasCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateAliasCommandOutput) => void): void;
    /**
     * @see {@link UpdateCustomKeyStoreCommand}
     */
    updateCustomKeyStore(args: UpdateCustomKeyStoreCommandInput, options?: __HttpHandlerOptions): Promise<UpdateCustomKeyStoreCommandOutput>;
    updateCustomKeyStore(args: UpdateCustomKeyStoreCommandInput, cb: (err: any, data?: UpdateCustomKeyStoreCommandOutput) => void): void;
    updateCustomKeyStore(args: UpdateCustomKeyStoreCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateCustomKeyStoreCommandOutput) => void): void;
    /**
     * @see {@link UpdateKeyDescriptionCommand}
     */
    updateKeyDescription(args: UpdateKeyDescriptionCommandInput, options?: __HttpHandlerOptions): Promise<UpdateKeyDescriptionCommandOutput>;
    updateKeyDescription(args: UpdateKeyDescriptionCommandInput, cb: (err: any, data?: UpdateKeyDescriptionCommandOutput) => void): void;
    updateKeyDescription(args: UpdateKeyDescriptionCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateKeyDescriptionCommandOutput) => void): void;
    /**
     * @see {@link UpdatePrimaryRegionCommand}
     */
    updatePrimaryRegion(args: UpdatePrimaryRegionCommandInput, options?: __HttpHandlerOptions): Promise<UpdatePrimaryRegionCommandOutput>;
    updatePrimaryRegion(args: UpdatePrimaryRegionCommandInput, cb: (err: any, data?: UpdatePrimaryRegionCommandOutput) => void): void;
    updatePrimaryRegion(args: UpdatePrimaryRegionCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdatePrimaryRegionCommandOutput) => void): void;
    /**
     * @see {@link VerifyCommand}
     */
    verify(args: VerifyCommandInput, options?: __HttpHandlerOptions): Promise<VerifyCommandOutput>;
    verify(args: VerifyCommandInput, cb: (err: any, data?: VerifyCommandOutput) => void): void;
    verify(args: VerifyCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: VerifyCommandOutput) => void): void;
    /**
     * @see {@link VerifyMacCommand}
     */
    verifyMac(args: VerifyMacCommandInput, options?: __HttpHandlerOptions): Promise<VerifyMacCommandOutput>;
    verifyMac(args: VerifyMacCommandInput, cb: (err: any, data?: VerifyMacCommandOutput) => void): void;
    verifyMac(args: VerifyMacCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: VerifyMacCommandOutput) => void): void;
}
/**
 * <fullname>Key Management Service</fullname>
 *          <p>Key Management Service (KMS) is an encryption and key management web service. This guide describes
 *       the KMS operations that you can call programmatically. For general information about KMS,
 *       see the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/">
 *                <i>Key Management Service Developer Guide</i>
 *             </a>.</p>
 *          <note>
 *             <p>KMS has replaced the term <i>customer master key (CMK)</i> with <i>Key Management Service key</i>
 *   and <i>KMS key</i>. The concept has not changed. To prevent breaking changes, KMS is keeping some variations of this term.</p>
 *             <p>Amazon Web Services provides SDKs that consist of libraries and sample code for various programming
 *         languages and platforms (Java, Rust, Python, Ruby, .Net, macOS, Android, etc.). The SDKs
 *         provide a convenient way to create programmatic access to KMS and other Amazon Web Services services.
 *         For example, the SDKs take care of tasks such as signing requests (see below), managing
 *         errors, and retrying requests automatically. For more information about the Amazon Web Services SDKs,
 *         including how to download and install them, see <a href="http://aws.amazon.com/tools/">Tools
 *           for Amazon Web Services</a>.</p>
 *          </note>
 *          <p>We recommend that you use the Amazon Web Services SDKs to make programmatic API calls to KMS.</p>
 *          <p>If you need to use FIPS 140-2 validated cryptographic modules when communicating with
 *       Amazon Web Services, use one of the FIPS endpoints in your preferred Amazon Web Services Region. If you need communicate
 *       over IPv6, use the dual-stack endpoint in your preferred Amazon Web Services Region. For more information
 *       see <a href="https://docs.aws.amazon.com/general/latest/gr/kms.html#kms_region">Service
 *         endpoints</a> in the Key Management Service topic of the <i>Amazon Web Services General Reference</i> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/ipv6-kms.html">Dual-stack endpoint
 *         support</a> in the KMS Developer Guide.</p>
 *          <p>All KMS API calls must be signed and be transmitted using Transport Layer Security
 *       (TLS). KMS recommends you always use the latest supported TLS version. Clients must also
 *       support cipher suites with Perfect Forward Secrecy (PFS) such as Ephemeral Diffie-Hellman
 *       (DHE) or Elliptic Curve Ephemeral Diffie-Hellman (ECDHE). Most modern systems such as Java 7
 *       and later support these modes.</p>
 *          <p>
 *             <b>Signing Requests</b>
 *          </p>
 *          <p>Requests must be signed using an access key ID and a secret access key. We strongly
 *       recommend that you do not use your Amazon Web Services account root access key ID and secret access key for
 *       everyday work. You can use the access key ID and secret access key for an IAM user or you
 *       can use the Security Token Service (STS) to generate temporary security credentials and use those to sign
 *       requests. </p>
 *          <p>All KMS requests must be signed with <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.</p>
 *          <p>
 *             <b>Logging API Requests</b>
 *          </p>
 *          <p>KMS supports CloudTrail, a service that logs Amazon Web Services API calls and related events for your
 *       Amazon Web Services account and delivers them to an Amazon S3 bucket that you specify. By using the
 *       information collected by CloudTrail, you can determine what requests were made to KMS, who made
 *       the request, when it was made, and so on. To learn more about CloudTrail, including how to turn it
 *       on and find your log files, see the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/">CloudTrail User Guide</a>.</p>
 *          <p>
 *             <b>Additional Resources</b>
 *          </p>
 *          <p>For more information about credentials and request signing, see the following:</p>
 *          <ul>
 *             <li>
 *                <p>
 *                   <a href="https://docs.aws.amazon.com/general/latest/gr/aws-security-credentials.html">Amazon Web Services
 *             Security Credentials</a> - This topic provides general information about the types
 *           of credentials used to access Amazon Web Services.</p>
 *             </li>
 *             <li>
 *                <p>
 *                   <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp.html">Temporary
 *             Security Credentials</a> - This section of the <i>IAM User Guide</i>
 *           describes how to create and use temporary security credentials.</p>
 *             </li>
 *             <li>
 *                <p>
 *                   <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version
 *             4 Signing Process</a> - This set of topics walks you through the process of signing
 *           a request using an access key ID and a secret access key.</p>
 *             </li>
 *          </ul>
 *          <p>
 *             <b>Commonly Used API Operations</b>
 *          </p>
 *          <p>Of the API operations discussed in this guide, the following will prove the most useful
 *       for most applications. You will likely perform operations other than these, such as creating
 *       keys and assigning policies, by using the console.</p>
 *          <ul>
 *             <li>
 *                <p>
 *                   <a>Encrypt</a>
 *                </p>
 *             </li>
 *             <li>
 *                <p>
 *                   <a>Decrypt</a>
 *                </p>
 *             </li>
 *             <li>
 *                <p>
 *                   <a>GenerateDataKey</a>
 *                </p>
 *             </li>
 *             <li>
 *                <p>
 *                   <a>GenerateDataKeyWithoutPlaintext</a>
 *                </p>
 *             </li>
 *          </ul>
 * @public
 */
export declare class KMS extends KMSClient implements KMS {
}
