import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { DeleteActivityInput, DeleteActivityOutput } from "../models/models_0";
import { ServiceInputTypes, ServiceOutputTypes, SFNClientResolvedConfig } from "../SFNClient";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DeleteActivityCommand}.
 */
export interface DeleteActivityCommandInput extends DeleteActivityInput {
}
/**
 * @public
 *
 * The output of {@link DeleteActivityCommand}.
 */
export interface DeleteActivityCommandOutput extends DeleteActivityOutput, __MetadataBearer {
}
declare const DeleteActivityCommand_base: {
    new (input: DeleteActivityCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteActivityCommandInput, DeleteActivityCommandOutput, SFNClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: DeleteActivityCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteActivityCommandInput, DeleteActivityCommandOutput, SFNClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Deletes an activity.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { SFNClient, DeleteActivityCommand } from "@aws-sdk/client-sfn"; // ES Modules import
 * // const { SFNClient, DeleteActivityCommand } = require("@aws-sdk/client-sfn"); // CommonJS import
 * // import type { SFNClientConfig } from "@aws-sdk/client-sfn";
 * const config = {}; // type is SFNClientConfig
 * const client = new SFNClient(config);
 * const input = { // DeleteActivityInput
 *   activityArn: "STRING_VALUE", // required
 * };
 * const command = new DeleteActivityCommand(input);
 * const response = await client.send(command);
 * // {};
 *
 * ```
 *
 * @param DeleteActivityCommandInput - {@link DeleteActivityCommandInput}
 * @returns {@link DeleteActivityCommandOutput}
 * @see {@link DeleteActivityCommandInput} for command's `input` shape.
 * @see {@link DeleteActivityCommandOutput} for command's `response` shape.
 * @see {@link SFNClientResolvedConfig | config} for SFNClient's `config` shape.
 *
 * @throws {@link InvalidArn} (client fault)
 *  <p>The provided Amazon Resource Name (ARN) is not valid.</p>
 *
 * @throws {@link SFNServiceException}
 * <p>Base exception class for all service exceptions from SFN service.</p>
 *
 *
 * @public
 */
export declare class DeleteActivityCommand extends DeleteActivityCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DeleteActivityInput;
            output: {};
        };
        sdk: {
            input: DeleteActivityCommandInput;
            output: DeleteActivityCommandOutput;
        };
    };
}
