import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_ListEndpointsByPlatformApplicationCommand, se_ListEndpointsByPlatformApplicationCommand, } from "../protocols/Aws_query";
export { $Command };
export class ListEndpointsByPlatformApplicationCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSimpleNotificationService", "ListEndpointsByPlatformApplication", {})
    .n("SNSClient", "ListEndpointsByPlatformApplicationCommand")
    .f(void 0, void 0)
    .ser(se_ListEndpointsByPlatformApplicationCommand)
    .de(de_ListEndpointsByPlatformApplicationCommand)
    .build() {
}
