import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { DescribeInstancePatchStatesForPatchGroupResultFilterSensitiveLog, } from "../models/models_0";
import { de_DescribeInstancePatchStatesForPatchGroupCommand, se_DescribeInstancePatchStatesForPatchGroupCommand, } from "../protocols/Aws_json1_1";
export { $Command };
export class DescribeInstancePatchStatesForPatchGroupCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSSM", "DescribeInstancePatchStatesForPatchGroup", {})
    .n("SSMClient", "DescribeInstancePatchStatesForPatchGroupCommand")
    .f(void 0, DescribeInstancePatchStatesForPatchGroupResultFilterSensitiveLog)
    .ser(se_DescribeInstancePatchStatesForPatchGroupCommand)
    .de(de_DescribeInstancePatchStatesForPatchGroupCommand)
    .build() {
}
