import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { GetParameterResultFilterSensitiveLog } from "../models/models_1";
import { de_GetParameterCommand, se_GetParameterCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class GetParameterCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSSM", "GetParameter", {})
    .n("SSMClient", "GetParameterCommand")
    .f(void 0, GetParameterResultFilterSensitiveLog)
    .ser(se_GetParameterCommand)
    .de(de_GetParameterCommand)
    .build() {
}
