import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { GetParametersByPathResultFilterSensitiveLog, } from "../models/models_1";
import { de_GetParametersByPathCommand, se_GetParametersByPathCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class GetParametersByPathCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSSM", "GetParametersByPath", {})
    .n("SSMClient", "GetParametersByPathCommand")
    .f(void 0, GetParametersByPathResultFilterSensitiveLog)
    .ser(se_GetParametersByPathCommand)
    .de(de_GetParametersByPathCommand)
    .build() {
}
