"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsManagedPolicy = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iam_floyd_1 = require("./iam-floyd");
/**
 * Provides all AWS managed policies.
 *
 * To get the name, access the static properties of this class, e.g. `AwsManagedPolicy.ReadOnlyAccess`.
 *
 *  To get an `aws_iam.IManagedPolicy` object, call the methods on an instance of the class, e.g. `new AwsManagedPolicy().ReadOnlyAccess()`.
 */
class AwsManagedPolicy extends iam_floyd_1.AwsManagedPolicy {
    /** Allow Access Analyzer to analyze resource metadata */
    AccessAnalyzerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AccessAnalyzerServiceRolePolicy);
    }
    /** Provides full access to AWS services and resources. */
    AdministratorAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AdministratorAccess);
    }
    /** Grants account administrative permissions while explicitly allowing direct access to resources needed by Amplify applications. */
    AdministratorAccessAmplify() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AdministratorAccessAmplify);
    }
    /** Grants account administrative permissions. Explicitly allows developers and administrators to gain direct access to resources they need to manage AWS Elastic Beanstalk applications */
    AdministratorAccessAWSElasticBeanstalk() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AdministratorAccessAWSElasticBeanstalk);
    }
    /** Provides ReadOnly permissions required by the Amazon AI Operations Assistant to do analysis on customer AWS resources during investigations. */
    AIOpsAssistantPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AIOpsAssistantPolicy);
    }
    /** Grants full access to Amazon AI Operations service and its required permissions via AWS console. It also includes permissions to use identity-aware console sessions. */
    AIOpsConsoleAdminPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AIOpsConsoleAdminPolicy);
    }
    /** Grants access to the Amazon AI Operations APIs for creating, updating, and deleting investigations, investigation events, and investigation resources. It also includes ReadOnly access to all AI Operations APIs and to use identity-aware sessions. */
    AIOpsOperatorAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AIOpsOperatorAccess);
    }
    /** Grants ReadOnly permissions to the Amazon AI Operations service and its required resources. */
    AIOpsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AIOpsReadOnlyAccess);
    }
    /** Provide device setup access to AlexaForBusiness services */
    AlexaForBusinessDeviceSetup() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AlexaForBusinessDeviceSetup);
    }
    /** Grants full access to AlexaForBusiness resources and access to related AWS Services */
    AlexaForBusinessFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AlexaForBusinessFullAccess);
    }
    /** Provide gateway execution access to AlexaForBusiness services */
    AlexaForBusinessGatewayExecution() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AlexaForBusinessGatewayExecution);
    }
    /** Provide access to Lifesize AVS devices */
    AlexaForBusinessLifesizeDelegatedAccessPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AlexaForBusinessLifesizeDelegatedAccessPolicy);
    }
    /** This policy enables Alexa for Business to perform automated tasks scheduled by your network profiles. */
    AlexaForBusinessNetworkProfileServicePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AlexaForBusinessNetworkProfileServicePolicy);
    }
    /** Provide access to Poly AVS devices */
    AlexaForBusinessPolyDelegatedAccessPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AlexaForBusinessPolyDelegatedAccessPolicy);
    }
    /** Provide read only access to AlexaForBusiness services */
    AlexaForBusinessReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AlexaForBusinessReadOnlyAccess);
    }
    /** Provides full access to create/edit/delete APIs in Amazon API Gateway via the AWS Management Console. */
    AmazonAPIGatewayAdministrator() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAPIGatewayAdministrator);
    }
    /** Provides full access to invoke APIs in Amazon API Gateway. */
    AmazonAPIGatewayInvokeFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAPIGatewayInvokeFullAccess);
    }
    /** Allows API Gateway to push logs to user's account. */
    AmazonAPIGatewayPushToCloudWatchLogs() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAPIGatewayPushToCloudWatchLogs);
    }
    /** Provides full access to Amazon AppFlow and access to AWS services supported as flow source or destination (S3 and Redshift). Also provides access to KMS for encryption */
    AmazonAppFlowFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAppFlowFullAccess);
    }
    /** Provides read only access to Amazon Appflow flows */
    AmazonAppFlowReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAppFlowReadOnlyAccess);
    }
    /** Provides full access to Amazon AppStream via the AWS Management Console. */
    AmazonAppStreamFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAppStreamFullAccess);
    }
    /** Amazon AppStream 2.0 access to AWS Certificate Manager Private CA in customer accounts for certificate-based authentication */
    AmazonAppStreamPCAAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAppStreamPCAAccess);
    }
    /** Provides read only access to Amazon AppStream via the AWS Management Console. */
    AmazonAppStreamReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAppStreamReadOnlyAccess);
    }
    /** Default policy for Amazon AppStream service role. */
    AmazonAppStreamServiceAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAppStreamServiceAccess);
    }
    /** Provide full access to Amazon Athena and scoped access to the dependencies needed to enable querying, writing results, and data management. */
    AmazonAthenaFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAthenaFullAccess);
    }
    /** Provides access to perform all operations Amazon Augmented AI resources, including FlowDefinitions, HumanTaskUis and HumanLoops. Does not allow access for creating FlowDefinitions against the public-crowd Workteam. */
    AmazonAugmentedAIFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAugmentedAIFullAccess);
    }
    /** Provides access to perform all operations on HumanLoops. */
    AmazonAugmentedAIHumanLoopFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAugmentedAIHumanLoopFullAccess);
    }
    /** Provides access to perform all operations Amazon Augmented AI resources, including FlowDefinitions, HumanTaskUis and HumanLoops. Also provides access to those operations of services that are integrated with Amazon Augmented AI. */
    AmazonAugmentedAIIntegratedAPIAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAugmentedAIIntegratedAPIAccess);
    }
    /** Provides console full administrative access to Aurora DSQL */
    AmazonAuroraDSQLConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAuroraDSQLConsoleFullAccess);
    }
    /** Provides full administrative access to Aurora DSQL */
    AmazonAuroraDSQLFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAuroraDSQLFullAccess);
    }
    /** Provides read only access to Aurora DSQL */
    AmazonAuroraDSQLReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonAuroraDSQLReadOnlyAccess);
    }
    /** Provides Bedrock Model inference permission to Bedrock agent core memory */
    AmazonBedrockAgentCoreMemoryBedrockModelInferenceExecutionRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonBedrockAgentCoreMemoryBedrockModelInferenceExecutionRolePolicy);
    }
    /** Provides full access to Amazon Bedrock as well as limited access to related services that are required by it */
    AmazonBedrockFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonBedrockFullAccess);
    }
    /** Provides limited access to Amazon Bedrock as well as to related services that are required by it */
    AmazonBedrockLimitedAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonBedrockLimitedAccess);
    }
    /** Provides limited access to Amazon Bedrock Marketplace as well as to related services that are required by it */
    AmazonBedrockMarketplaceAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonBedrockMarketplaceAccess);
    }
    /** Provides read only access to Amazon Bedrock */
    AmazonBedrockReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonBedrockReadOnly);
    }
    /** Defines the maximum permissions of IAM roles that Amazon Bedrock Studio creates for operating Amazon Bedrock Studio resources. */
    AmazonBedrockStudioPermissionsBoundary() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonBedrockStudioPermissionsBoundary);
    }
    /** Provides full access to Amazon Braket via the AWS Management Console and SDK. Also provides access to related services (e.g., S3, logs). */
    AmazonBraketFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonBraketFullAccess);
    }
    /** Grants access to AWS Services and resources necessary for executing an Amazon Braket Job including S3, Cloudwatch, IAM and Braket */
    AmazonBraketJobsExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonBraketJobsExecutionPolicy);
    }
    /** Allows Amazon Braket to create and manage AWS resources on your behalf */
    AmazonBraketServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonBraketServiceRolePolicy);
    }
    /** Provides full access to Amazon Chime Admin Console via the AWS Management Console. */
    AmazonChimeFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonChimeFullAccess);
    }
    /** Provides read only access to Amazon Chime Admin Console via the AWS Management Console. */
    AmazonChimeReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonChimeReadOnly);
    }
    /** Provides access to Amazon Chime SDK operations */
    AmazonChimeSDK() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonChimeSDK);
    }
    /** Managed Policy For Amazon Chime SDK MediaPipelines Service Linked Role */
    AmazonChimeSDKMediaPipelinesServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonChimeSDKMediaPipelinesServiceLinkedRolePolicy);
    }
    /** Allows Amazon Chime SDK Messaging to access AWS resources and enable messaging functionality */
    AmazonChimeSDKMessagingServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonChimeSDKMessagingServiceRolePolicy);
    }
    /** Enables access to AWS Resources used or managed by Amazon Chime */
    AmazonChimeServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonChimeServiceRolePolicy);
    }
    /** Allows Amazon Chime to access Amazon Transcribe and Amazon Transcribe Medical on your behalf */
    AmazonChimeTranscriptionServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonChimeTranscriptionServiceLinkedRolePolicy);
    }
    /** Provides user management access to Amazon Chime Admin Console via the AWS Management Console. */
    AmazonChimeUserManagement() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonChimeUserManagement);
    }
    /** Managed policy for Service Linked Role for Amazon Chime VoiceConnector */
    AmazonChimeVoiceConnectorServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonChimeVoiceConnectorServiceLinkedRolePolicy);
    }
    /** Provides full access to Amazon Cloud Directory Service. */
    AmazonCloudDirectoryFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCloudDirectoryFullAccess);
    }
    /** Provides read only access to Amazon Cloud Directory Service. */
    AmazonCloudDirectoryReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCloudDirectoryReadOnlyAccess);
    }
    /** Provides full only access to Amazon CloudWatch Evidently. Also provides access to related Amazon S3, Amazon SNS, Amazon CloudWatch, and other related services. */
    AmazonCloudWatchEvidentlyFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCloudWatchEvidentlyFullAccess);
    }
    /** Provides read only access to Amazon CloudWatch Evidently */
    AmazonCloudWatchEvidentlyReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCloudWatchEvidentlyReadOnlyAccess);
    }
    /** Allows CloudWatch Evidently Service to manage associated AWS Resources on behalf of the customer */
    AmazonCloudWatchEvidentlyServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCloudWatchEvidentlyServiceRolePolicy);
    }
    /** Grants full access permissions for the Amazon CloudWatch RUM service */
    AmazonCloudWatchRUMFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCloudWatchRUMFullAccess);
    }
    /** Grants read only permissions for the Amazon CloudWatch RUM service */
    AmazonCloudWatchRUMReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCloudWatchRUMReadOnlyAccess);
    }
    /** Grants permission to Amazon CloudWatch RUM Service to publish monitoring data to other relevant AWS services */
    AmazonCloudWatchRUMServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCloudWatchRUMServiceRolePolicy);
    }
    /** Provides full access to Amazon CodeCatalyst */
    AmazonCodeCatalystFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCodeCatalystFullAccess);
    }
    /** Provides read only access to Amazon CodeCatalyst */
    AmazonCodeCatalystReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCodeCatalystReadOnlyAccess);
    }
    /** Allows Amazon CodeCatalyst to create, update, and resolve AWS Support cases on your behalf. */
    AmazonCodeCatalystSupportAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCodeCatalystSupportAccess);
    }
    /** Provides access required by Amazon CodeGuru Profiler agent. */
    AmazonCodeGuruProfilerAgentAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCodeGuruProfilerAgentAccess);
    }
    /** Provides full access to Amazon CodeGuru Profiler. */
    AmazonCodeGuruProfilerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCodeGuruProfilerFullAccess);
    }
    /** Provides read only access to Amazon CodeGuru Profiler. */
    AmazonCodeGuruProfilerReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCodeGuruProfilerReadOnlyAccess);
    }
    /** Grants full access to Amazon CodeGuru Reviewer and scoped access to required dependencies. */
    AmazonCodeGuruReviewerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCodeGuruReviewerFullAccess);
    }
    /** Provides read only access to Amazon CodeGuru Reviewer. */
    AmazonCodeGuruReviewerReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCodeGuruReviewerReadOnlyAccess);
    }
    /** A service-linked role required for Amazon CodeGuru Reviewer to access resources on your behalf. */
    AmazonCodeGuruReviewerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCodeGuruReviewerServiceRolePolicy);
    }
    /** Provides full access to Amazon CodeGuru Security. */
    AmazonCodeGuruSecurityFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCodeGuruSecurityFullAccess);
    }
    /** Provides access required for working with Amazon CodeGuru Security scans. */
    AmazonCodeGuruSecurityScanAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCodeGuruSecurityScanAccess);
    }
    /** Provides access to Amazon Cognito APIs to support developer authenticated identities from your authentication backend. */
    AmazonCognitoDeveloperAuthenticatedIdentities() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCognitoDeveloperAuthenticatedIdentities);
    }
    /** Allows Amazon Cognito User Pools service to use your SES identities for email sending */
    AmazonCognitoIdpEmailServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCognitoIdpEmailServiceRolePolicy);
    }
    /** Enables access to AWS Services and Resources used or managed by Amazon Cognito User Pools */
    AmazonCognitoIdpServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCognitoIdpServiceRolePolicy);
    }
    /** Provides administrative access to existing Amazon Cognito resources. You will need AWS account admin privileges to create new Cognito resources. */
    AmazonCognitoPowerUser() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCognitoPowerUser);
    }
    /** Provides read only access to Amazon Cognito resources. */
    AmazonCognitoReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCognitoReadOnly);
    }
    /** This policy defines the set of permissions allowed for unauthenticated identities for Cognito Identity Pools. This policy is not intended to be used as a stand alone permission policy. It is used as a guardrail against overly permissive policies attached for roles in an identity pool. Do not attach this policy to any roles, as Cognito Identity Service will automatically include it as a scoped down policy when creating credentials. The privileges to temporarily access other AWS resources through the enhanced flow will now be defined by the intersection of the role associated with the identity of the unauthenticated user provided by a service, and the privileges given in this managed policy that is owned by Cognito. */
    AmazonCognitoUnAuthedIdentitiesSessionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCognitoUnAuthedIdentitiesSessionPolicy);
    }
    /** This policy defines the set of permissions allowed for unauthenticated identities for Cognito Identity Pools. This does not need to be attached to your unauth role, as Cognito Identity Service will automatically include it as a scoped down policy when creating credentials. The privileges to temporarily access other AWS resources through the enhanced flow will now be defined by the intersection of the role associated with the identity of the unauthenticated user provided by a service, and the privileges given in this managed policy that is owned by Cognito. */
    AmazonCognitoUnauthenticatedIdentities() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonCognitoUnauthenticatedIdentities);
    }
    /** The purpose of this policy is to grant permissions to AWS Connect users required to use Connect resources. This policy provides full access to AWS Connect resources via the Connect Console and public APIs */
    AmazonConnectFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonConnectFullAccess);
    }
    /** Policy for Amazon Connect Campaigns service linked role */
    AmazonConnectCampaignsServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonConnectCampaignsServiceLinkedRolePolicy);
    }
    /** Grants permission to view the Amazon Connect instances in your AWS account. */
    AmazonConnectReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonConnectReadOnlyAccess);
    }
    /** Allows Amazon Connect to create and manage AWS resources on your behalf. */
    AmazonConnectServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonConnectServiceLinkedRolePolicy);
    }
    /** Allows Amazon Connect to synchronize AWS resources across regions on your behalf. */
    AmazonConnectSynchronizationServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonConnectSynchronizationServiceRolePolicy);
    }
    /** Provides full access to Amazon Connect Voice ID */
    AmazonConnectVoiceIDFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonConnectVoiceIDFullAccess);
    }
    /** Provides permissions to consume Amazon Bedrock models, including invoking Amazon Bedrock application inference profile created for particular Amazon DataZone domain. */
    AmazonDataZoneBedrockModelConsumptionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDataZoneBedrockModelConsumptionPolicy);
    }
    /** Provides permissions to manage Amazon Bedrock model access, including creating, tagging and deleting application inference profiles. */
    AmazonDataZoneBedrockModelManagementPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDataZoneBedrockModelManagementPolicy);
    }
    /** Default policy for the Amazon DataZone's DomainExecutionRole service role. This role is used by Amazon DataZone to catalog, discover, govern, share, and analyze data in the Amazon DataZone domain. */
    AmazonDataZoneDomainExecutionRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDataZoneDomainExecutionRolePolicy);
    }
    /** Amazon DataZone creates IAM roles for Environments to perform data analytics actions, and uses this policy when creating these roles to define the boundary of their permissions. */
    AmazonDataZoneEnvironmentRolePermissionsBoundary() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDataZoneEnvironmentRolePermissionsBoundary);
    }
    /** Provides full access to Amazon DataZone via the AWS Management Console as well as limited access to related services that are required by it. */
    AmazonDataZoneFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDataZoneFullAccess);
    }
    /** Provides full access to Amazon DataZone, but does not allow the management of domains, users, or associated accounts. */
    AmazonDataZoneFullUserAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDataZoneFullUserAccess);
    }
    /** The policy grants permissions to allow Amazon DataZone to enable publishing and access grants to data. */
    AmazonDataZoneGlueManageAccessRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDataZoneGlueManageAccessRolePolicy);
    }
    /** Amazon DataZone is a data management service that enables you to catalog, discover, govern, share, and analyze your data. With Amazon DataZone, you can share and access your data across accounts and supported regions. Amazon DataZone simplifies your experience across AWS services, including, but not limited to, Amazon Redshift, Amazon Athena, AWS Glue, and AWS Lake Formation. */
    AmazonDataZoneRedshiftGlueProvisioningPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDataZoneRedshiftGlueProvisioningPolicy);
    }
    /** This policy gives Amazon DataZone permissions to publish Amazon Redshift data to the catalog. It also gives Amazon DataZone permissions to grant access or revoke access to Amazon Redshift or Amazon Redshift Serverless published assets in the catalog. */
    AmazonDataZoneRedshiftManageAccessRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDataZoneRedshiftManageAccessRolePolicy);
    }
    /** The AmazonDataZoneSageMakerEnvironmentRolePermissionsBoundary policy is the list of permissions that are permitted on an execution role created in a SageMaker environment provisioned by Amazon DataZone. */
    AmazonDataZoneSageMakerEnvironmentRolePermissionsBoundary() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDataZoneSageMakerEnvironmentRolePermissionsBoundary);
    }
    /** The AmazonDataZoneSageMakerManageAccessRolePolicy policy grants Amazon DataZone the permissions required to grant user access to various resources in the SageMaker environment. */
    AmazonDataZoneSageMakerManageAccessRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDataZoneSageMakerManageAccessRolePolicy);
    }
    /** The AmazonDataZoneSageMakerProvisioningRolePolicy policy grants Amazon DataZone the permissions required to interoperate with Amazon SageMaker. */
    AmazonDataZoneSageMakerProvisioningRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDataZoneSageMakerProvisioningRolePolicy);
    }
    /**  Provides full access to Amazon Detective service and scoped access to the console UI dependencies */
    AmazonDetectiveFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDetectiveFullAccess);
    }
    /** Provides investigator access to Amazon Detective service and scoped access to the console UI dependencies. This policy grants permission to dive into Detective for investigation purposes and limited write access to Guardduty. */
    AmazonDetectiveInvestigatorAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDetectiveInvestigatorAccess);
    }
    /** Provides member access to Amazon Detective service and scoped access to the console UI dependencies. */
    AmazonDetectiveMemberAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDetectiveMemberAccess);
    }
    /** Provides Organizations access to manage Delegated administrator for Amazon Detective and scoped access to the console UI dependencies. This also grants permission to create a service-linked role for Detective. */
    AmazonDetectiveOrganizationsAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDetectiveOrganizationsAccess);
    }
    /** Allows Amazon Detective to make service calls on your behalf */
    AmazonDetectiveServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDetectiveServiceLinkedRolePolicy);
    }
    /** The policy grants full-access to the DevOps Guru console. */
    AmazonDevOpsGuruConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDevOpsGuruConsoleFullAccess);
    }
    /** Provides full access to Amazon DevOps Guru. */
    AmazonDevOpsGuruFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDevOpsGuruFullAccess);
    }
    /** Provide access to enable and manage Amazon DevOps Guru within an organization. */
    AmazonDevOpsGuruOrganizationsAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDevOpsGuruOrganizationsAccess);
    }
    /** Provides read only access to Amazon DevOps Guru Console. */
    AmazonDevOpsGuruReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDevOpsGuruReadOnlyAccess);
    }
    /** A service-linked role required for Amazon DevOpsGuru to access your resources. */
    AmazonDevOpsGuruServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDevOpsGuruServiceRolePolicy);
    }
    /** Provides access to upload DMS replication logs to cloudwatch logs in customer account. */
    AmazonDMSCloudWatchLogsRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDMSCloudWatchLogsRole);
    }
    /** Provides access to manage S3 settings for Redshift endpoints for DMS. */
    AmazonDMSRedshiftS3Role() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDMSRedshiftS3Role);
    }
    /** Provides access to manage VPC settings for AWS managed customer configurations */
    AmazonDMSVPCManagementRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDMSVPCManagementRole);
    }
    /** Allows Amazon DocumentDB-Elastic to manage AWS resources on your behalf. */
    AmazonDocDBElasticServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDocDBElasticServiceRolePolicy);
    }
    /** Provides full access to manage Amazon DocumentDB with MongoDB compatibility using the AWS Management Console. Note this policy also grants full access to publish on all SNS topics within the account, permissions to create and edit Amazon EC2 instances and VPC configurations, permissions to view and list keys on Amazon KMS, and full access to Amazon RDS and Amazon Neptune. */
    AmazonDocDBConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDocDBConsoleFullAccess);
    }
    /** Provides full access to Amazon DocumentDB Elastic Clusters and other required permissions for its dependencies including EC2, KMS, SecretsManager, CloudWatch and IAM. */
    AmazonDocDBElasticFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDocDBElasticFullAccess);
    }
    /** Provides read-only access to Amazon DocDB-Elastic and CloudWatch metrics. */
    AmazonDocDBElasticReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDocDBElasticReadOnlyAccess);
    }
    /** Provides full access to Amazon DocumentDB with MongoDB compatibility. Note this policy also grants full access to publish on all SNS topics within the account and full access to Amazon RDS and Amazon Neptune. */
    AmazonDocDBFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDocDBFullAccess);
    }
    /** Provides read-only access to Amazon DocumentDB with MongoDB compatibility. Note that this policy also grants access to Amazon RDS and Amazon Neptune resources. */
    AmazonDocDBReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDocDBReadOnlyAccess);
    }
    /** Provides access to manage VPC settings for Amazon managed customer configurations */
    AmazonDRSVPCManagement() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDRSVPCManagement);
    }
    /** Provides full access to Amazon DynamoDB via the AWS Management Console. */
    AmazonDynamoDBFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDynamoDBFullAccess);
    }
    /** Provides full access to Amazon DynamoDB */
    AmazonDynamoDBFullAccessV2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDynamoDBFullAccessV2);
    }
    /** This policy is on a deprecation path. See documentation for guidance: https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DynamoDBPipeline.html. Provides full access to Amazon DynamoDB including Export/Import using AWS Data Pipeline via the AWS Management Console. */
    AmazonDynamoDBFullAccesswithDataPipeline() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDynamoDBFullAccesswithDataPipeline);
    }
    /** Provides read only access to Amazon DynamoDB via the AWS Management Console. */
    AmazonDynamoDBReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonDynamoDBReadOnlyAccess);
    }
    /** IAM Policy that allows the CSI driver service account to make calls to related services such as EC2 on your behalf. */
    AmazonEBSCSIDriverPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEBSCSIDriverPolicy);
    }
    /** Provides administrative access to Amazon ECR resources */
    AmazonEC2ContainerRegistryFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2ContainerRegistryFullAccess);
    }
    /** Provides full access to Amazon EC2 Container Registry repositories, but does not allow repository deletion or policy changes. */
    AmazonEC2ContainerRegistryPowerUser() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2ContainerRegistryPowerUser);
    }
    /** Provides access to pull images from Amazon EC2 Container Registry repositories. */
    AmazonEC2ContainerRegistryPullOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2ContainerRegistryPullOnly);
    }
    /** Provides read-only access to Amazon EC2 Container Registry repositories. */
    AmazonEC2ContainerRegistryReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2ContainerRegistryReadOnly);
    }
    /**   Policy to enable Task Autoscaling for Amazon EC2 Container Service */
    AmazonEC2ContainerServiceAutoscaleRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2ContainerServiceAutoscaleRole);
    }
    /** Policy to enable CloudWatch Events for EC2 Container Service */
    AmazonEC2ContainerServiceEventsRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2ContainerServiceEventsRole);
    }
    /** Default policy for the Amazon EC2 Role for Amazon EC2 Container Service. */
    AmazonEC2ContainerServiceforEC2Role() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2ContainerServiceforEC2Role);
    }
    /** Default policy for Amazon ECS service role. */
    AmazonEC2ContainerServiceRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2ContainerServiceRole);
    }
    /** Provides full access to Amazon EC2 via the AWS Management Console. */
    AmazonEC2FullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2FullAccess);
    }
    /** Provides read-only access to scan all supported resource types for relevant data when using DescribeImageReferences. */
    AmazonEC2ImageReferencesAccessPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2ImageReferencesAccessPolicy);
    }
    /** Provides read only access to Amazon EC2 via the AWS Management Console. */
    AmazonEC2ReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2ReadOnlyAccess);
    }
    /** Provides EC2 access to S3 bucket to download revision. This role is needed by the CodeDeploy agent on EC2 instances. */
    AmazonEC2RoleforAWSCodeDeploy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2RoleforAWSCodeDeploy);
    }
    /** Provides EC2 limited access to S3 bucket to download revision. This role is needed by the CodeDeploy agent on EC2 instances. */
    AmazonEC2RoleforAWSCodeDeployLimited() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2RoleforAWSCodeDeployLimited);
    }
    /** Default policy for the Amazon EC2 Role for Data Pipeline service role. */
    AmazonEC2RoleforDataPipelineRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2RoleforDataPipelineRole);
    }
    /** This policy will soon be deprecated. Please use AmazonSSMManagedInstanceCore policy to enable AWS Systems Manager service core functionality on EC2 instances. For more information see https://docs.aws.amazon.com/systems-manager/latest/userguide/setup-instance-profile.html */
    AmazonEC2RoleforSSM() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2RoleforSSM);
    }
    /** Managed policy for the Amazon LaunchWizard service role for EC2 */
    AmazonEC2RolePolicyForLaunchWizard() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2RolePolicyForLaunchWizard);
    }
    /** Policy to enable Autoscaling for Amazon EC2 Spot Fleet */
    AmazonEC2SpotFleetAutoscaleRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2SpotFleetAutoscaleRole);
    }
    /** Allows EC2 Spot Fleet to request, terminate and tag Spot Instances on your behalf. */
    AmazonEC2SpotFleetTaggingRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEC2SpotFleetTaggingRole);
    }
    /** Provides administrative access to Amazon ECS resources and enables ECS features through access to other AWS service resources, including VPCs, Auto Scaling groups, and CloudFormation stacks. */
    AmazonECSFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonECSFullAccess);
    }
    /** Policy to enable Amazon ECS Compute to manage your EC2 instances and related resources as part of ECS managed instances */
    AmazonECSComputeServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonECSComputeServiceRolePolicy);
    }
    /** Provides access to other AWS service resources required to manage load balancers associated with ECS workloads on your behalf. */
    AmazonECSInfrastructureRolePolicyForLoadBalancers() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonECSInfrastructureRolePolicyForLoadBalancers);
    }
    /** Provides administrative access to Private Certificate Authority, AWS Secrets Manager and other AWS Services required to manage ECS Service Connect TLS features on your behalf. */
    AmazonECSInfrastructureRolePolicyForServiceConnectTransportLayerSecurity() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonECSInfrastructureRolePolicyForServiceConnectTransportLayerSecurity);
    }
    /** Provides access to other AWS service resources required to manage volumes associated with ECS workloads on your behalf. */
    AmazonECSInfrastructureRolePolicyForVolumes() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonECSInfrastructureRolePolicyForVolumes);
    }
    /** Provides access to other AWS service resources required to manage VPC Lattice feature in ECS workloads on your behalf. */
    AmazonECSInfrastructureRolePolicyForVpcLattice() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonECSInfrastructureRolePolicyForVpcLattice);
    }
    /** Policy to enable Amazon ECS to manage your cluster. */
    AmazonECSServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonECSServiceRolePolicy);
    }
    /** Provides access to other AWS service resources that are required to run Amazon ECS tasks */
    AmazonECSTaskExecutionRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonECSTaskExecutionRolePolicy);
    }
    /** Provides management access to EFS resources and read access to EC2 */
    AmazonEFSCSIDriverPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEFSCSIDriverPolicy);
    }
    /** This policy provides the Amazon VPC CNI Plugin (amazon-vpc-cni-k8s) the permissions it requires to modify the IP address configuration on your EKS worker nodes. This permission set allows the CNI to list, describe, and modify Elastic Network Interfaces on your behalf. More information on the AWS VPC CNI Plugin is available here: https://github.com/aws/amazon-vpc-cni-k8s */
    AmazonEKSCNIPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSCNIPolicy);
    }
    /** Policy attached to the EKS Cluster Role that grants permissions to manage the cluster's block storage resources. */
    AmazonEKSBlockStoragePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSBlockStoragePolicy);
    }
    /** This policy provides Kubernetes the permissions it requires to manage resources on your behalf. Kubernetes requires Ec2:CreateTags permissions to place identifying information on EC2 resources including but not limited to Instances, Security Groups, and Elastic Network Interfaces. */
    AmazonEKSClusterPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSClusterPolicy);
    }
    /** Policy attached to the EKS Cluster Role that grants permissions to manage the cluster's compute resources. */
    AmazonEKSComputePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSComputePolicy);
    }
    /** This policy allows Amazon EKS to manage AWS resources for EKS connector */
    AmazonEKSConnectorServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSConnectorServiceRolePolicy);
    }
    /** Provides read only access to view the dashboard in the Amazon EKS console. The dashboard aggregates information about multiple clusters and related resources using AWS Organizations. */
    AmazonEKSDashboardConsoleReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSDashboardConsoleReadOnly);
    }
    /** This policy enables the Amazon EKS Dashboard to access and display organization-wide information. The policy allows the EKS Dashboard service to gather information about your AWS Organizations structure and accounts. */
    AmazonEKSDashboardServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSDashboardServiceRolePolicy);
    }
    /** Provides access to other AWS service resources that are required to run Amazon EKS pods on AWS Fargate */
    AmazonEKSFargatePodExecutionRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSFargatePodExecutionRolePolicy);
    }
    /** This policy grants necessary permissions to Amazon EKS to run fargate tasks */
    AmazonEKSForFargateServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSForFargateServiceRolePolicy);
    }
    /** Policy attached to the EKS Cluster Role that grants permissions to manage the cluster's load balancing resources. */
    AmazonEKSLoadBalancingPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSLoadBalancingPolicy);
    }
    /** This policy provides permissions to EKS local cluster's control-plane instances running in your account to manage resources on your behalf. */
    AmazonEKSLocalOutpostClusterPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSLocalOutpostClusterPolicy);
    }
    /** Allows Amazon EKS Local to call AWS services on your behalf. */
    AmazonEKSLocalOutpostServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSLocalOutpostServiceRolePolicy);
    }
    /** Policy attached to the EKS Cluster Role that grants permissions to manage the cluster's networking resources. */
    AmazonEKSNetworkingPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSNetworkingPolicy);
    }
    /** This policy allows Amazon Elastic Container Service for Kubernetes to create and manage the necessary resources to operate EKS Clusters. */
    AmazonEKSServicePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSServicePolicy);
    }
    /** A Service-Linked Role required for Amazon EKS to call AWS services on your behalf. */
    AmazonEKSServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSServiceRolePolicy);
    }
    /** Policy used by VPC Resource Controller to manage ENI and IPs for worker nodes. */
    AmazonEKSVPCResourceController() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSVPCResourceController);
    }
    /** This policy allows Amazon EKS worker nodes to connect to Amazon EKS Clusters. */
    AmazonEKSWorkerNodeMinimalPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSWorkerNodeMinimalPolicy);
    }
    /** This policy allows Amazon EKS worker nodes to connect to Amazon EKS Clusters. */
    AmazonEKSWorkerNodePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEKSWorkerNodePolicy);
    }
    /** Provides full access to Amazon ElastiCache via the AWS Management Console. */
    AmazonElastiCacheFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElastiCacheFullAccess);
    }
    /** Provides read only access to Amazon ElastiCache via the AWS Management Console. */
    AmazonElastiCacheReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElastiCacheReadOnlyAccess);
    }
    /** Provides administrative access to Amazon ECR Public resources */
    AmazonElasticContainerRegistryPublicFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticContainerRegistryPublicFullAccess);
    }
    /** Provides full access to Amazon ECR Public repositories, but does not allow repository deletion or policy changes. */
    AmazonElasticContainerRegistryPublicPowerUser() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticContainerRegistryPublicPowerUser);
    }
    /** Provides read-only access to Amazon ECR Public repositories. */
    AmazonElasticContainerRegistryPublicReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticContainerRegistryPublicReadOnly);
    }
    /** Provides root client access to an Amazon EFS file system */
    AmazonElasticFileSystemClientFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticFileSystemClientFullAccess);
    }
    /** Provides read only client access to an Amazon EFS file system */
    AmazonElasticFileSystemClientReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticFileSystemClientReadOnlyAccess);
    }
    /** Provides read and write client access to an Amazon EFS file system */
    AmazonElasticFileSystemClientReadWriteAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticFileSystemClientReadWriteAccess);
    }
    /** Provides full access to Amazon EFS via the AWS Management Console. */
    AmazonElasticFileSystemFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticFileSystemFullAccess);
    }
    /** Provides read only access to Amazon EFS via the AWS Management Console. */
    AmazonElasticFileSystemReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticFileSystemReadOnlyAccess);
    }
    /** Allows Amazon Elastic File System to manage AWS resources on your behalf */
    AmazonElasticFileSystemServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticFileSystemServiceRolePolicy);
    }
    /** Allows customers to use AWS Systems Manager to automatically manage Amazon EFS utilities (amazon-efs-utils) package on their EC2 instances, and use CloudWatchLog to get EFS file system mount success/failure notifications. */
    AmazonElasticFileSystemsUtils() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticFileSystemsUtils);
    }
    /** Default policy for the Amazon Elastic MapReduce Editors service role. */
    AmazonElasticMapReduceEditorsRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticMapReduceEditorsRole);
    }
    /** Amazon Elastic MapReduce for Auto Scaling. Role to allow Auto Scaling to add and remove instances from your EMR cluster. */
    AmazonElasticMapReduceforAutoScalingRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticMapReduceforAutoScalingRole);
    }
    /** Default policy for the Amazon Elastic MapReduce for EC2 service role. */
    AmazonElasticMapReduceforEC2Role() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticMapReduceforEC2Role);
    }
    /** This policy is on a deprecation path. See documentation for guidance: https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-iam-policies.html. Provides full access to Amazon Elastic MapReduce and underlying services that it requires such as EC2 and S3 */
    AmazonElasticMapReduceFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticMapReduceFullAccess);
    }
    /** Policy to allow EMR to create, describe and delete EC2 placement groups. */
    AmazonElasticMapReducePlacementGroupPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticMapReducePlacementGroupPolicy);
    }
    /** Provides read only access to Amazon Elastic MapReduce via the AWS Management Console. */
    AmazonElasticMapReduceReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticMapReduceReadOnlyAccess);
    }
    /** This policy is on a deprecation path. See documentation for guidance: https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-iam-policies.html.  Default policy for the Amazon Elastic MapReduce service role. */
    AmazonElasticMapReduceRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticMapReduceRole);
    }
    /** Allow Amazon Elasticsearch Service to access other AWS services such as EC2 Networking APIs on your behalf. */
    AmazonElasticsearchServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticsearchServiceRolePolicy);
    }
    /** Grants users full access to Elastic Transcoder and the access to associated services that is required for full Elastic Transcoder functionality. */
    AmazonElasticTranscoderFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticTranscoderFullAccess);
    }
    /** Grants users permission to change presets, submit jobs, and view Elastic Transcoder settings. This policy also grants some read-only access to some other services required to use the Elastic Transcode console, including S3, IAM, and SNS. */
    AmazonElasticTranscoderJobsSubmitter() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticTranscoderJobsSubmitter);
    }
    /** Grants users read-only access to Elastic Transcoder and list access to related services. */
    AmazonElasticTranscoderReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticTranscoderReadOnlyAccess);
    }
    /** Default policy for the Amazon Elastic Transcoder service role. */
    AmazonElasticTranscoderRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonElasticTranscoderRole);
    }
    /** Allows the actions that EMR requires to terminate and delete AWS EC2 resources if the EMR Service role has lost that ability. */
    AmazonEMRCleanupPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEMRCleanupPolicy);
    }
    /** Allows access to other AWS service resources that are required to run Amazon EMR */
    AmazonEMRContainersServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEMRContainersServiceRolePolicy);
    }
    /** Provides full access to Amazon EMR */
    AmazonEMRFullAccessPolicyV2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEMRFullAccessPolicyV2);
    }
    /** Provides read only access to Amazon EMR and the associated CloudWatch Metrics. */
    AmazonEMRReadOnlyAccessPolicyV2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEMRReadOnlyAccessPolicyV2);
    }
    /** Allows access to other AWS service resources that are required to run Amazon EMRServerless */
    AmazonEMRServerlessServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEMRServerlessServiceRolePolicy);
    }
    /** This policy is used for the Amazon EMR Service Role and should NOT be used for any other IAM users or roles in your account. The policy grants permissions to create and manage resources associated with EMR and related services necessary for the operation of your EMR cluster. */
    AmazonEMRServicePolicyV2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEMRServicePolicyV2);
    }
    /** Provides limited access to the Amazon Cognito configuration service. */
    AmazonESCognitoAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonESCognitoAccess);
    }
    /** Provides full access to the Amazon ES configuration service. */
    AmazonESFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonESFullAccess);
    }
    /** Provides read-only access to the Amazon ES configuration service. */
    AmazonESReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonESReadOnlyAccess);
    }
    /** Allows EventBridge to access Secret Manager resources on your behalf. */
    AmazonEventBridgeApiDestinationsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEventBridgeApiDestinationsServiceRolePolicy);
    }
    /** Provides full access to Amazon EventBridge. */
    AmazonEventBridgeFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEventBridgeFullAccess);
    }
    /** Provides full access to Amazon EventBridge Pipes. */
    AmazonEventBridgePipesFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEventBridgePipesFullAccess);
    }
    /** Provides read-only and operator (ability to Stop and Start running Pipes) access to Amazon EventBridge Pipes. */
    AmazonEventBridgePipesOperatorAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEventBridgePipesOperatorAccess);
    }
    /** Provides read-only access to Amazon EventBridge Pipes. */
    AmazonEventBridgePipesReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEventBridgePipesReadOnlyAccess);
    }
    /** Provides read only access to Amazon EventBridge. */
    AmazonEventBridgeReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEventBridgeReadOnlyAccess);
    }
    /** The AmazonEventBridgeSchedulerFullAccess managed policy grants permissions to use all EventBridge Scheduler actions for schedules, and schedule groups. */
    AmazonEventBridgeSchedulerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEventBridgeSchedulerFullAccess);
    }
    /** The AmazonEventBridgeSchedulerReadOnlyAccess managed policy grants read-only permissions to view details about your schedules and schedule groups */
    AmazonEventBridgeSchedulerReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEventBridgeSchedulerReadOnlyAccess);
    }
    /** Provides full access to Amazon EventBridge Schemas. */
    AmazonEventBridgeSchemasFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEventBridgeSchemasFullAccess);
    }
    /** Provides read only access to Amazon EventBridge Schemas. */
    AmazonEventBridgeSchemasReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEventBridgeSchemasReadOnlyAccess);
    }
    /** Grants permissions to Managed Rules created by Amazon EventBridge schemas. */
    AmazonEventBridgeSchemasServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEventBridgeSchemasServiceRolePolicy);
    }
    /** Grants permissions to EVS to manage resources on your behalf */
    AmazonEVSServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonEVSServiceRolePolicy);
    }
    /** Policy to enable AWS FIS to manage monitoring and resource selection for experiments. */
    AmazonFISServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonFISServiceRolePolicy);
    }
    /** Gives access to all actions for Amazon Forecast */
    AmazonForecastFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonForecastFullAccess);
    }
    /** Gives access to all actions for Amazon Fraud Detector */
    AmazonFraudDetectorFullAccessPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonFraudDetectorFullAccessPolicy);
    }
    /** Full Access Policy for Amazon FreeRTOS */
    AmazonFreeRTOSFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonFreeRTOSFullAccess);
    }
    /** Allows user to access Amazon FreeRTOS OTA Update */
    AmazonFreeRTOSOTAUpdate() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonFreeRTOSOTAUpdate);
    }
    /** Provides full access to Amazon FSx and access to related AWS services via the AWS Management Console. */
    AmazonFSxConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonFSxConsoleFullAccess);
    }
    /** Provides read only access to Amazon FSx and access to related AWS services via the AWS Management Console. */
    AmazonFSxConsoleReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonFSxConsoleReadOnlyAccess);
    }
    /** Provides full access to Amazon FSx and access to related AWS services. */
    AmazonFSxFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonFSxFullAccess);
    }
    /** Provides read only access to Amazon FSx. */
    AmazonFSxReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonFSxReadOnlyAccess);
    }
    /** Allows Amazon FSx to manage AWS resources on your behalf */
    AmazonFSxServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonFSxServiceRolePolicy);
    }
    /** Provides full access to Amazon Glacier via the AWS Management Console. */
    AmazonGlacierFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonGlacierFullAccess);
    }
    /** Provides read only access to Amazon Glacier via the AWS Management Console. */
    AmazonGlacierReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonGlacierReadOnlyAccess);
    }
    /** This policy grants access to Amazon Athena and the dependencies needed to enable querying and writing results to s3 from the Amazon Athena plugin in Amazon Grafana. */
    AmazonGrafanaAthenaAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonGrafanaAthenaAccess);
    }
    /** This policy grants access to Amazon CloudWatch and the dependencies needed to use CloudWatch as a datasource within Amazon Managed Grafana. */
    AmazonGrafanaCloudWatchAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonGrafanaCloudWatchAccess);
    }
    /** This policy grants scoped access to Amazon Redshift and the dependencies needed to use the Amazon Redshift plugin in Amazon Grafana. */
    AmazonGrafanaRedshiftAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonGrafanaRedshiftAccess);
    }
    /** Provides access to AWS Resources managed or used by Amazon Grafana. */
    AmazonGrafanaServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonGrafanaServiceLinkedRolePolicy);
    }
    /** Provides full access to use Amazon GuardDuty. */
    AmazonGuardDutyFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonGuardDutyFullAccess);
    }
    /** Provides full access to use Amazon GuardDuty */
    AmazonGuardDutyFullAccessV2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonGuardDutyFullAccessV2);
    }
    /** GuardDuty malware protection uses the service-linked role (SLR) named AWSServiceRoleForAmazonGuardDutyMalwareProtection. This service-linked role allows GuardDuty malware protection to perform agent-less scans to detect malware. It allows GuardDuty to create snapshots in your account, and share the snapshots with the GuardDuty service account to scan for malware. It evaluates these shared snapshots and includes the retrieved EC2 instance metadata in the GuardDuty Malware Protection findings. The AWSServiceRoleForAmazonGuardDutyMalwareProtection service-linked role trusts the malware-protection.guardduty.amazonaws.com service to assume the role. */
    AmazonGuardDutyMalwareProtectionServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonGuardDutyMalwareProtectionServiceRolePolicy);
    }
    /** Provides read only access to Amazon GuardDuty resources */
    AmazonGuardDutyReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonGuardDutyReadOnlyAccess);
    }
    /** Enable access to AWS Resources used or managed by Amazon Guard Duty */
    AmazonGuardDutyServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonGuardDutyServiceRolePolicy);
    }
    /** Provides full access to Amazon HealthLake service. */
    AmazonHealthLakeFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonHealthLakeFullAccess);
    }
    /** Provides read only access to Amazon HealthLake service. */
    AmazonHealthLakeReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonHealthLakeReadOnlyAccess);
    }
    /** Provides full access to Honeycode via the AWS Management Console and the SDK. */
    AmazonHoneycodeFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonHoneycodeFullAccess);
    }
    /** Provides read only access to Honeycode via the AWS Management Console and the SDK. */
    AmazonHoneycodeReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonHoneycodeReadOnlyAccess);
    }
    /** A service-linked role required for Amazon Honeycode to access your resources. */
    AmazonHoneycodeServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonHoneycodeServiceRolePolicy);
    }
    /** Provides full access to Honeycode Team Association via the AWS Management Console and the SDK. */
    AmazonHoneycodeTeamAssociationFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonHoneycodeTeamAssociationFullAccess);
    }
    /** Provides read only access to Honeycode Team Association via the AWS Management Console and the SDK. */
    AmazonHoneycodeTeamAssociationReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonHoneycodeTeamAssociationReadOnlyAccess);
    }
    /** Provides full access to Honeycode Workbook via the AWS Management Console and the SDK. */
    AmazonHoneycodeWorkbookFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonHoneycodeWorkbookFullAccess);
    }
    /** Provides read only access to Honeycode Workbook via the AWS Management Console and the SDK. */
    AmazonHoneycodeWorkbookReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonHoneycodeWorkbookReadOnlyAccess);
    }
    /** Grants Amazon Inspector access to AWS Services needed to perform agent-less security assessments */
    AmazonInspector2AgentlessServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonInspector2AgentlessServiceRolePolicy);
    }
    /** Provides full access to Amazon Inspector and access to other related services such as organizations. */
    AmazonInspector2FullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonInspector2FullAccess);
    }
    /** Provides full access to Amazon Inspector and access to other related services such as organizations with restrictive organizational access. */
    AmazonInspector2FullAccessV2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonInspector2FullAccessV2);
    }
    /** This is a managed policy that customer should attach to their roles to communicate with inspector service for CIS scans */
    AmazonInspector2ManagedCisPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonInspector2ManagedCisPolicy);
    }
    /** Provides read only access to the Amazon inspector2 service and relevant support services */
    AmazonInspector2ReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonInspector2ReadOnlyAccess);
    }
    /** Grants Amazon Inspector access to AWS Services needed to perform security assessments */
    AmazonInspector2ServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonInspector2ServiceRolePolicy);
    }
    /** Provides full access to Amazon Inspector. */
    AmazonInspectorFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonInspectorFullAccess);
    }
    /** Provides read only access to Amazon Inspector. */
    AmazonInspectorReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonInspectorReadOnlyAccess);
    }
    /** Grants Amazon Inspector access to AWS Services needed to perform security assessments */
    AmazonInspectorServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonInspectorServiceRolePolicy);
    }
    /** Provides full access to Amazon Kendra via the AWS Management Console. */
    AmazonKendraFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonKendraFullAccess);
    }
    /** Provides read only access to Amazon Kendra via the AWS Management Console. */
    AmazonKendraReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonKendraReadOnlyAccess);
    }
    /** Provide full access to Amazon Keyspaces */
    AmazonKeyspacesFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonKeyspacesFullAccess);
    }
    /** Provide read only access to Amazon Keyspaces */
    AmazonKeyspacesReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonKeyspacesReadOnlyAccess);
    }
    /** Provide read only access to Amazon Keyspaces and related AWS services. */
    AmazonKeyspacesReadOnlyAccessV2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonKeyspacesReadOnlyAccessV2);
    }
    /** Provides full access to Amazon Kinesis Analytics via the AWS Management Console. */
    AmazonKinesisAnalyticsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonKinesisAnalyticsFullAccess);
    }
    /** Provides read-only access to Amazon Kinesis Analytics via the AWS Management Console. */
    AmazonKinesisAnalyticsReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonKinesisAnalyticsReadOnly);
    }
    /** Provides full access to all Amazon Kinesis Firehose Delivery Streams. */
    AmazonKinesisFirehoseFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonKinesisFirehoseFullAccess);
    }
    /** Provides read only access to all Amazon Kinesis Firehose Delivery Streams. */
    AmazonKinesisFirehoseReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonKinesisFirehoseReadOnlyAccess);
    }
    /** Provides full access to all streams via the AWS Management Console. */
    AmazonKinesisFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonKinesisFullAccess);
    }
    /** Provides read only access to all streams via the AWS Management Console. */
    AmazonKinesisReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonKinesisReadOnlyAccess);
    }
    /** Provides full access to Amazon Kinesis Video Streams via the AWS Management Console. */
    AmazonKinesisVideoStreamsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonKinesisVideoStreamsFullAccess);
    }
    /** Provides read only access to AWS Kinesis Video Streams via the AWS Management Console. */
    AmazonKinesisVideoStreamsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonKinesisVideoStreamsReadOnlyAccess);
    }
    /** Full access to AWS Launch wizard and other required services. */
    AmazonLaunchWizardFullAccessV2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLaunchWizardFullAccessV2);
    }
    /** This policy allows customers to call Lex runtime from channels */
    AmazonLexChannelsAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLexChannelsAccess);
    }
    /** Provides full access to Amazon Lex via the AWS Management Console.  Also provides access to create Lex Service Linked Roles and grant Lex permissions to invoke a limited set of Lambda functions. */
    AmazonLexFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLexFullAccess);
    }
    /** Provides read-only access to Amazon Lex. */
    AmazonLexReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLexReadOnly);
    }
    /** Allows Amazon Lex to replicate Lex resources across regions on your behalf. */
    AmazonLexReplicationPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLexReplicationPolicy);
    }
    /** Provides access to Amazon Lex conversational APIs. */
    AmazonLexRunBotsOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLexRunBotsOnly);
    }
    /** Provides Lex V2 bots access to call other AWS services on your behalf. */
    AmazonLexV2BotPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLexV2BotPolicy);
    }
    /** Provides full access to Amazon Lookout for Equipment operations */
    AmazonLookoutEquipmentFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLookoutEquipmentFullAccess);
    }
    /** Provides read only access to Amazon Lookout for Equipments */
    AmazonLookoutEquipmentReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLookoutEquipmentReadOnlyAccess);
    }
    /** Gives access to all actions for Amazon Lookout for Metrics */
    AmazonLookoutMetricsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLookoutMetricsFullAccess);
    }
    /** Gives access to all read-only actions for Amazon Lookout for Metrics */
    AmazonLookoutMetricsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLookoutMetricsReadOnlyAccess);
    }
    /** Provides full access to Amazon Lookout for Vision and scoped access to required service and console dependencies. */
    AmazonLookoutVisionConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLookoutVisionConsoleFullAccess);
    }
    /** Provides read only access to Amazon Lookout for Vision and scoped access to required service and console dependencies. */
    AmazonLookoutVisionConsoleReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLookoutVisionConsoleReadOnlyAccess);
    }
    /** Provides full access to Amazon Lookout for Vision and scoped access to required dependencies. */
    AmazonLookoutVisionFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLookoutVisionFullAccess);
    }
    /** Provides read only access to Amazon Lookout for Vision and scoped access to required dependencies. */
    AmazonLookoutVisionReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonLookoutVisionReadOnlyAccess);
    }
    /** Grants users permission to request Amazon Machine Learning batch predictions. */
    AmazonMachineLearningBatchPredictionsAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMachineLearningBatchPredictionsAccess);
    }
    /** Provides create access for non-prediction Amazon Machine Learning resources. */
    AmazonMachineLearningCreateOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMachineLearningCreateOnlyAccess);
    }
    /** Provides full access to Amazon Machine Learning resources. */
    AmazonMachineLearningFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMachineLearningFullAccess);
    }
    /** Grants users permission to create and delete the real-time endpoint for Amazon Machine Learning models. */
    AmazonMachineLearningManageRealTimeEndpointOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMachineLearningManageRealTimeEndpointOnlyAccess);
    }
    /** Provides read only access to Amazon Machine Learning resources. */
    AmazonMachineLearningReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMachineLearningReadOnlyAccess);
    }
    /** Grants users permission to request Amazon Machine Learning real-time predictions. */
    AmazonMachineLearningRealTimePredictionOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMachineLearningRealTimePredictionOnlyAccess);
    }
    /** Allows Machine Learning to configure and use your Redshift Clusters and S3 Staging Locations for Redshift Data Source. */
    AmazonMachineLearningRoleforRedshiftDataSourceV3() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMachineLearningRoleforRedshiftDataSourceV3);
    }
    /** Provides full access to Amazon Macie. */
    AmazonMacieFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMacieFullAccess);
    }
    /** Grants permission to create the service-linked role of Amazon Macie. */
    AmazonMacieHandshakeRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMacieHandshakeRole);
    }
    /** Provides readonly access to Amazon Macie. */
    AmazonMacieReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMacieReadOnlyAccess);
    }
    /** Grants Macie read-only access to resource dependencies in your account in order to enable data analysis. */
    AmazonMacieServiceRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMacieServiceRole);
    }
    /** Service linked role for Amazon Macie */
    AmazonMacieServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMacieServiceRolePolicy);
    }
    /** Provides full access to Amazon Managed Blockchain via the AWS Management Console */
    AmazonManagedBlockchainConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonManagedBlockchainConsoleFullAccess);
    }
    /** Provides full access to Amazon Managed Blockchain. */
    AmazonManagedBlockchainFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonManagedBlockchainFullAccess);
    }
    /** Provides read-only access to Amazon Managed Blockchain. */
    AmazonManagedBlockchainReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonManagedBlockchainReadOnlyAccess);
    }
    /** Enables access to AWS Services and Resources used or managed by Amazon Managed Blockchain */
    AmazonManagedBlockchainServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonManagedBlockchainServiceRolePolicy);
    }
    /** Provide full access to Amazon Managed Apache Cassandra Service */
    AmazonMCSFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMCSFullAccess);
    }
    /** Provide read only access to Amazon Managed Apache Cassandra Service */
    AmazonMCSReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMCSReadOnlyAccess);
    }
    /** Provides full access to all APIs in Amazon Mechanical Turk. */
    AmazonMechanicalTurkFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMechanicalTurkFullAccess);
    }
    /** Provides access to read only APIs in Amazon Mechanical Turk. */
    AmazonMechanicalTurkReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMechanicalTurkReadOnly);
    }
    /** Provides full access to Amazon MemoryDB via the AWS Management Console. */
    AmazonMemoryDBFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMemoryDBFullAccess);
    }
    /** Provides read only access to Amazon MemoryDB via the AWS Management Console. */
    AmazonMemoryDBReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMemoryDBReadOnlyAccess);
    }
    /** Provides read only access to all reports including financial data for all application resources. */
    AmazonMobileAnalyticsFinancialReportAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMobileAnalyticsFinancialReportAccess);
    }
    /** Provides full access to all application resources. */
    AmazonMobileAnalyticsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMobileAnalyticsFullAccess);
    }
    /** Provides read only access to non financial reports for all application resources. */
    AmazonMobileAnalyticsNonFinancialReportAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMobileAnalyticsNonFinancialReportAccess);
    }
    /** Provides write only access to put event data for all application resources. (Recommended for SDK integration) */
    AmazonMobileAnalyticsWriteOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMobileAnalyticsWriteOnlyAccess);
    }
    /** Provides full access to manage Amazon Monitron */
    AmazonMonitronFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMonitronFullAccess);
    }
    /** Provides full access to AmazonMQ via our API/SDK. */
    AmazonMQApiFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMQApiFullAccess);
    }
    /** Provides read only access to AmazonMQ via our API/SDK. */
    AmazonMQApiReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMQApiReadOnlyAccess);
    }
    /** Provides full access to AmazonMQ via the AWS Management Console. */
    AmazonMQFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMQFullAccess);
    }
    /** Provides read only access to AmazonMQ via the AWS Management Console. */
    AmazonMQReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMQReadOnlyAccess);
    }
    /** Service Linked Role Policy for AWS Amazon MQ */
    AmazonMQServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMQServiceRolePolicy);
    }
    /** Provide readonly access to Amazon MSK Connect */
    AmazonMSKConnectReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMSKConnectReadOnlyAccess);
    }
    /** Provide full access to Amazon MSK and other required permissions for its dependencies. */
    AmazonMSKFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMSKFullAccess);
    }
    /** Provide readonly access to Amazon MSK */
    AmazonMSKReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMSKReadOnlyAccess);
    }
    /** The Service Linked Role used by Amazon Managed Workflows for Apache Airflow. */
    AmazonMWAAServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonMWAAServiceRolePolicy);
    }
    /** This policy grants access to resources needed by Nimble Studio Launch Profile workers. Attach this policy to EC2 instances created by Nimble Studio Builder. */
    AmazonNimbleStudioLaunchProfileWorker() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonNimbleStudioLaunchProfileWorker);
    }
    /** This policy grants access to Amazon Nimble Studio resources associated with the studio admin and related studio resources in other services. Attach this policy to the Admin role associated with your studio. */
    AmazonNimbleStudioStudioAdmin() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonNimbleStudioStudioAdmin);
    }
    /** This policy grants access to Amazon Nimble Studio resources associated with the studio user and related studio resources in other services. Attach this policy to the User role associated with your studio. */
    AmazonNimbleStudioStudioUser() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonNimbleStudioStudioUser);
    }
    /** Allows Oracle Database@AWS to manage AWS resources on your behalf. */
    AmazonODBServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonODBServiceRolePolicy);
    }
    /** Provides full access to Amazon Omics and other required AWS Services. This policy allows the user to view and accept RAM share invitations to access resources outside of the user's AWS account. */
    AmazonOmicsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOmicsFullAccess);
    }
    /** Provide read only access to Amazon Omics */
    AmazonOmicsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOmicsReadOnlyAccess);
    }
    /** This policy grants administrative permissions that allow access to all Amazon One Enterprise resources and operations. */
    AmazonOneEnterpriseFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOneEnterpriseFullAccess);
    }
    /** This policy grants limited read and write permissions that allow device installation and activation. */
    AmazonOneEnterpriseInstallerAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOneEnterpriseInstallerAccess);
    }
    /** This policy grants read only permissions to all Amazon One Enterprise resources and operations. */
    AmazonOneEnterpriseReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOneEnterpriseReadOnlyAccess);
    }
    /** Provides access to Amazon OpenSearch Dashboards Service to access other AWS services such as CloudWatch on your behalf */
    AmazonOpenSearchDashboardsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOpenSearchDashboardsServiceRolePolicy);
    }
    /** Allows OpenSearch DirectQuery Service to access AWS Glue APIs for creating resources on your behalf. */
    AmazonOpenSearchDirectQueryGlueCreateAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOpenSearchDirectQueryGlueCreateAccess);
    }
    /** Allows Amazon OpenSearch Ingestion to access other AWS services on your behalf. */
    AmazonOpenSearchIngestionFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOpenSearchIngestionFullAccess);
    }
    /** Provides read only access to the Amazon OpenSearch Ingestion Service */
    AmazonOpenSearchIngestionReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOpenSearchIngestionReadOnlyAccess);
    }
    /** Allows Amazon OpenSearch Ingestion Service to access other AWS services on your behalf. */
    AmazonOpenSearchIngestionServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOpenSearchIngestionServiceRolePolicy);
    }
    /** Allow Amazon OpenSearch Serverless to access other AWS services such as CloudWatch APIs on your behalf. */
    AmazonOpenSearchServerlessServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOpenSearchServerlessServiceRolePolicy);
    }
    /** Provides access to the Amazon Cognito configuration service. */
    AmazonOpenSearchServiceCognitoAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOpenSearchServiceCognitoAccess);
    }
    /** Provides full access to the Amazon OpenSearch Service configuration service. */
    AmazonOpenSearchServiceFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOpenSearchServiceFullAccess);
    }
    /** Provides read-only access to the Amazon OpenSearch Service configuration service. */
    AmazonOpenSearchServiceReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOpenSearchServiceReadOnlyAccess);
    }
    /** Allow Amazon OpenSearch Service to access other AWS services such as EC2 Networking APIs on your behalf. */
    AmazonOpenSearchServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonOpenSearchServiceRolePolicy);
    }
    /** Provides full access to Amazon Personalize via the AWS Management Console and SDK. Also provides select access to related services (e.g., S3, CloudWatch). */
    AmazonPersonalizeFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonPersonalizeFullAccess);
    }
    /** Grants full access to Amazon Polly service and resources. */
    AmazonPollyFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonPollyFullAccess);
    }
    /** Grants read-only access to Amazon Polly resources. */
    AmazonPollyReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonPollyReadOnlyAccess);
    }
    /** Grants full access to AWS Managed Prometheus resources in the AWS console */
    AmazonPrometheusConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonPrometheusConsoleFullAccess);
    }
    /** Grants full access to AWS Managed Prometheus resources */
    AmazonPrometheusFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonPrometheusFullAccess);
    }
    /** Grants access to run queries against AWS Managed Prometheus resources */
    AmazonPrometheusQueryAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonPrometheusQueryAccess);
    }
    /** Grants write only access to AWS Managed Prometheus workspaces */
    AmazonPrometheusRemoteWriteAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonPrometheusRemoteWriteAccess);
    }
    /** Provides access to AWS Resources managed or used by Amazon Managed Service for Prometheus Collector */
    AmazonPrometheusScraperServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonPrometheusScraperServiceRolePolicy);
    }
    /** Provides developer access to enable interactions with Amazon Q */
    AmazonQDeveloperAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonQDeveloperAccess);
    }
    /** Provides full access to enable interactions with Amazon Q */
    AmazonQFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonQFullAccess);
    }
    /** Provides full access to Amazon QLDB via the AWS Management Console. */
    AmazonQLDBConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonQLDBConsoleFullAccess);
    }
    /** Provides full access to Amazon QLDB via the service API. */
    AmazonQLDBFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonQLDBFullAccess);
    }
    /** Provides read only access to Amazon QLDB. */
    AmazonQLDBReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonQLDBReadOnly);
    }
    /** Allows Amazon RDS to manage AWS resources on your behalf. */
    AmazonRDSBetaServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRDSBetaServiceRolePolicy);
    }
    /** Allows Amazon RDS Custom to perform various automation actions and database management tasks through an EC2 instance profile. */
    AmazonRDSCustomInstanceProfileRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRDSCustomInstanceProfileRolePolicy);
    }
    /** Amazon RDS Custom Preview Service Role Policy */
    AmazonRDSCustomPreviewServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRDSCustomPreviewServiceRolePolicy);
    }
    /** Allows Amazon RDS Custom to manage AWS resources on your behalf. */
    AmazonRDSCustomServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRDSCustomServiceRolePolicy);
    }
    /** Allows full access to use the RDS data APIs, secret store APIs for RDS database credentials, and DB console query management APIs to execute SQL statements on Aurora Serverless clusters in the AWS account. */
    AmazonRDSDataFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRDSDataFullAccess);
    }
    /** Allow RDS to access Directory Service Managed AD on behalf of the customer for domain-joined SQL Server DB instances. */
    AmazonRDSDirectoryServiceAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRDSDirectoryServiceAccess);
    }
    /** Provides access to Cloudwatch for RDS Enhanced Monitoring */
    AmazonRDSEnhancedMonitoringRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRDSEnhancedMonitoringRole);
    }
    /** Provides full access to Amazon RDS via the AWS Management Console. */
    AmazonRDSFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRDSFullAccess);
    }
    /** Provides full access to RDS Performance Insights via the AWS Management Console */
    AmazonRDSPerformanceInsightsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRDSPerformanceInsightsFullAccess);
    }
    /** Read-Only policy for RDS Performance Insights */
    AmazonRDSPerformanceInsightsReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRDSPerformanceInsightsReadOnly);
    }
    /** Amazon RDS Preview Service Role Policy */
    AmazonRDSPreviewServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRDSPreviewServiceRolePolicy);
    }
    /** Provides read only access to Amazon RDS via the AWS Management Console. */
    AmazonRDSReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRDSReadOnlyAccess);
    }
    /** Allows Amazon RDS to manage AWS resources on your behalf. */
    AmazonRDSServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRDSServiceRolePolicy);
    }
    /** This policy includes permissions to run SQL commands to copy, load, unload, query, and analyze data on Amazon Redshift. The policy also grants permissions to run select statements for related services, such as Amazon S3, Amazon CloudWatch logs, Amazon SageMaker, or AWS Glue. */
    AmazonRedshiftAllCommandsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRedshiftAllCommandsFullAccess);
    }
    /** This policy provides full access to Amazon Redshift Data APIs. This policy also grants scoped access to other required services. */
    AmazonRedshiftDataFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRedshiftDataFullAccess);
    }
    /** Provides full access to Amazon Redshift via the AWS Management Console. */
    AmazonRedshiftFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRedshiftFullAccess);
    }
    /** Provides full access to the Amazon Redshift Query Editor and to saved queries via the AWS Management Console. */
    AmazonRedshiftQueryEditor() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRedshiftQueryEditor);
    }
    /** Grants full access to the Amazon Redshift Query Editor V2 operations and resources. This policy also grants access to other required services. This includes permissions to list the Amazon Redshift clusters, read keys and aliases in AWS KMS and manage the Query Editor V2 secrets in AWS Secrets Manager. */
    AmazonRedshiftQueryEditorV2FullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRedshiftQueryEditorV2FullAccess);
    }
    /** Grants the ability to work with Amazon Redshift Query Editor V2 without sharing resources. The granted principal can only read, update and delete its own resources but cannot share them. This policy also grants access to other required services. This includes permissions to list the Amazon Redshift clusters and manage the Query Editor V2 secrets of the principal in AWS Secrets Manager. */
    AmazonRedshiftQueryEditorV2NoSharing() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRedshiftQueryEditorV2NoSharing);
    }
    /** Grants the ability to work with Amazon Redshift Query Editor V2 with limited sharing of resources. The granted principal can read, write and share its own resources. The granted principal can read the resources shared with its team but cannot update them. This policy also grants access to other required services. This includes permissions to list the Amazon Redshift clusters and manage the Query Editor V2 secrets of the principal in AWS Secrets Manager. */
    AmazonRedshiftQueryEditorV2ReadSharing() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRedshiftQueryEditorV2ReadSharing);
    }
    /** Grants the ability to work with Amazon Redshift Query Editor V2 with sharing of resources. The granted principal can read, write and share its own resources. The granted principal can read and update the resources shared with its team. This policy also grants access to other required services. This includes permissions to list the Amazon Redshift clusters and manage the Query Editor V2 secrets of the principal in AWS Secrets Manager. */
    AmazonRedshiftQueryEditorV2ReadWriteSharing() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRedshiftQueryEditorV2ReadWriteSharing);
    }
    /** Provides read only access to Amazon Redshift via the AWS Management Console. */
    AmazonRedshiftReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRedshiftReadOnlyAccess);
    }
    /** Allows Amazon Redshift to call AWS services on your behalf */
    AmazonRedshiftServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRedshiftServiceLinkedRolePolicy);
    }
    /** This policy specifies rekognition and s3 permissions required by Amazon Rekognition Custom Labels feature. */
    AmazonRekognitionCustomLabelsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRekognitionCustomLabelsFullAccess);
    }
    /** Access to all Amazon Rekognition APIs */
    AmazonRekognitionFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRekognitionFullAccess);
    }
    /** Access to all Read rekognition APIs */
    AmazonRekognitionReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRekognitionReadOnlyAccess);
    }
    /** Allows Rekognition to call AWS services on your behalf. */
    AmazonRekognitionServiceRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRekognitionServiceRole);
    }
    /** Provides full access to all Route 53 Auto Naming actions. */
    AmazonRoute53AutoNamingFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53AutoNamingFullAccess);
    }
    /** Provides read-only access to all Route 53 Auto Naming actions. */
    AmazonRoute53AutoNamingReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53AutoNamingReadOnlyAccess);
    }
    /** Provides registrant level access to Route 53 Auto Naming actions. */
    AmazonRoute53AutoNamingRegistrantAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53AutoNamingRegistrantAccess);
    }
    /** Provides full access to all Route53 Domains actions and Create Hosted Zone to allow Hosted Zone creation as part of domain registrations. */
    AmazonRoute53DomainsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53DomainsFullAccess);
    }
    /** Provides access to Route53 Domains list and actions. */
    AmazonRoute53DomainsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53DomainsReadOnlyAccess);
    }
    /** Provides full access to all Amazon Route 53 via the AWS Management Console. */
    AmazonRoute53FullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53FullAccess);
    }
    /** This policy grants full access to Amazon Route 53 Profile resources. */
    AmazonRoute53ProfilesFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53ProfilesFullAccess);
    }
    /** This policy grants read-only access to Amazon Route 53 Profile resources. */
    AmazonRoute53ProfilesReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53ProfilesReadOnlyAccess);
    }
    /** Provides read only access to all Amazon Route 53 via the AWS Management Console. */
    AmazonRoute53ReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53ReadOnlyAccess);
    }
    /** Provides full access to Amazon Route 53 Recovery Cluster */
    AmazonRoute53RecoveryClusterFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53RecoveryClusterFullAccess);
    }
    /** Provides read only access to Amazon Route 53 Recovery Cluster */
    AmazonRoute53RecoveryClusterReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53RecoveryClusterReadOnlyAccess);
    }
    /** Provides full access to Amazon Route 53 Recovery Control Config */
    AmazonRoute53RecoveryControlConfigFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53RecoveryControlConfigFullAccess);
    }
    /** Provides read only access to Amazon Route 53 Recovery Control Config */
    AmazonRoute53RecoveryControlConfigReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53RecoveryControlConfigReadOnlyAccess);
    }
    /** Provides full access to Amazon Route 53 Recovery Readiness */
    AmazonRoute53RecoveryReadinessFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53RecoveryReadinessFullAccess);
    }
    /** Provides read only access to Amazon Route 53 Recovery Readiness */
    AmazonRoute53RecoveryReadinessReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53RecoveryReadinessReadOnlyAccess);
    }
    /** Full access policy for Route 53 Resolver */
    AmazonRoute53ResolverFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53ResolverFullAccess);
    }
    /** Read only policy for Route 53 Resolver */
    AmazonRoute53ResolverReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonRoute53ResolverReadOnlyAccess);
    }
    /** Provides full access to all buckets via the AWS Management Console. */
    AmazonS3FullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonS3FullAccess);
    }
    /** Provides AWS Lambda functions permissions to interact with Amazon S3 Object Lambda. Also grants Lambda permissions to write to CloudWatch Logs. */
    AmazonS3ObjectLambdaExecutionRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonS3ObjectLambdaExecutionRolePolicy);
    }
    /** Provides full access to Amazon S3 on Outposts via the AWS Management Console. */
    AmazonS3OutpostsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonS3OutpostsFullAccess);
    }
    /** Provides read only access to Amazon S3 on Outposts via the AWS Management Console. */
    AmazonS3OutpostsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonS3OutpostsReadOnlyAccess);
    }
    /** Provides read only access to all buckets via the AWS Management Console. */
    AmazonS3ReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonS3ReadOnlyAccess);
    }
    /** Provides full access to all S3 table buckets. */
    AmazonS3TablesFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonS3TablesFullAccess);
    }
    /** This managed policy grants AWS Lake Formation permissions to act on all table buckets, namespaces, and tables within the account. */
    AmazonS3TablesLakeFormationServiceRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonS3TablesLakeFormationServiceRole);
    }
    /** Provides read only access to all S3 table buckets. */
    AmazonS3TablesReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonS3TablesReadOnlyAccess);
    }
    /** Service role policy used by the AWS Service Catalog service to provision products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including CodePipeline, CodeBuild, CodeCommit, Glue, CloudFormation, etc,. */
    AmazonSageMakerAdminServiceCatalogProductsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerAdminServiceCatalogProductsServiceRolePolicy);
    }
    /** Provides permissions for Amazon SageMaker Canvas to use AI services to support ready to use AI solutions. This policy will add more mutating permissions for services as Amazon SageMaker Canvas adds support. */
    AmazonSageMakerCanvasAIServicesAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerCanvasAIServicesAccess);
    }
    /** This policy grants permissions to use Amazon Bedrock in SageMaker Canvas by providing access to downstream services such as S3. */
    AmazonSageMakerCanvasBedrockAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerCanvasBedrockAccess);
    }
    /** Provides full access to Amazon SageMaker resources and operations for data preparation in Canvas. The policy also provides select access to related services (e.g., S3, IAM, KMS, RDS, CloudWatch Logs, Redshift, Athena, Glue, EventBridge, Secrets Manager). This policy should be attached to the Amazon SageMaker Domain/User Profile execution role. */
    AmazonSageMakerCanvasDataPrepFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerCanvasDataPrepFullAccess);
    }
    /** Allows Amazon SageMaker Canvas to create, manage and view endpoint details for endpoints created through Canvas. Allows Amazon SageMaker Canvas to retrieve endpoint invocation metrics from CloudWatch. */
    AmazonSageMakerCanvasDirectDeployAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerCanvasDirectDeployAccess);
    }
    /** This policy grants permissions to Amazon EMR Serverless for services such as S3, used by Amazon SageMaker Canvas for large data processing. */
    AmazonSageMakerCanvasEMRServerlessExecutionRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerCanvasEMRServerlessExecutionRolePolicy);
    }
    /** This policy grants permissions commonly needed to use SageMaker Canvas with Amazon Forecast. */
    AmazonSageMakerCanvasForecastAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerCanvasForecastAccess);
    }
    /** Provides full access to Amazon SageMaker Canvas resources and operations. The policy also provides select access to related services (e.g., S3, IAM, VPC, ECR, CloudWatch Logs, Redshift, Secrets Manager, and Forecast). This policy should be attached to the Amazon SageMaker Domain/User Profile execution role. */
    AmazonSageMakerCanvasFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerCanvasFullAccess);
    }
    /** Provides permissions for Amazon SageMaker Canvas to use the SageMaker Data Science Assistant service. The Data Science Assistant currently uses both Amazon SageMaker and Amazon Q Developer to process user prompts. */
    AmazonSageMakerCanvasSMDataScienceAssistantAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerCanvasSMDataScienceAssistantAccess);
    }
    /** This policy grants permissions commonly needed to use Amazon SageMaker Cluster. */
    AmazonSageMakerClusterInstanceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerClusterInstanceRolePolicy);
    }
    /** Managed policy for Service Linked Role for Amazon SageMaker Core Services */
    AmazonSageMakerCoreServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerCoreServiceRolePolicy);
    }
    /** Provides permissions necessary for SageMaker Edge to create and manage a device fleet for the customer using the default cloud connection. */
    AmazonSageMakerEdgeDeviceFleetPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerEdgeDeviceFleetPolicy);
    }
    /** Provides permissions required to enable the offline store for an Amazon SageMaker FeatureStore feature group. */
    AmazonSageMakerFeatureStoreAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerFeatureStoreAccess);
    }
    /** Provides full access to Amazon SageMaker via the AWS Management Console and SDK. Also provides select access to related services (e.g., S3, ECR, CloudWatch Logs). */
    AmazonSageMakerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerFullAccess);
    }
    /** This policy provide access to services that are commonly needed to use SageMaker geospatial. */
    AmazonSageMakerGeospatialExecutionRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerGeospatialExecutionRole);
    }
    /** This policy grants permissions that allow full access to Amazon SageMaker Geospatial through the AWS Management Console and SDK. */
    AmazonSageMakerGeospatialFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerGeospatialFullAccess);
    }
    /** Provides access to AWS services that are required to run SageMaker GroundTruth Labeling job */
    AmazonSageMakerGroundTruthExecution() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerGroundTruthExecution);
    }
    /** This policy provides administrative privileges required for setting up SageMaker HyperPod observability. It enables access to Amazon Managed Prometheus, Amazon Managed Grafana and EKS Addons. The policy also includes broad access to Grafana HTTP APIs through ServiceAccountTokens across all Amazon Managed Grafana workspaces in your account. */
    AmazonSageMakerHyperPodObservabilityAdminAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerHyperPodObservabilityAdminAccess);
    }
    /** This policy grants permissions to Amazon SageMaker HyperPod to related AWS services such as Amazon EKS, Amazon CloudWatch etc. */
    AmazonSageMakerHyperPodServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerHyperPodServiceRolePolicy);
    }
    /** This policy provides administrative permissions required to set up the SageMaker HyperPod training operator. It enables access to Amazon SageMaker HyperPod and EKS add-ons. The policy includes permissions to describe the SageMaker HyperPod resources in your account. */
    AmazonSageMakerHyperPodTrainingOperatorAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerHyperPodTrainingOperatorAccess);
    }
    /** Provides access to create Amazon Augmented AI FlowDefinition resources against any Workteam. */
    AmazonSageMakerMechanicalTurkAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerMechanicalTurkAccess);
    }
    /** This AWS managed policy grants permissions needed to use all Amazon SageMaker Governance features. The policy also provides select access to related services (e.g., S3, KMS). */
    AmazonSageMakerModelGovernanceUseAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerModelGovernanceUseAccess);
    }
    /** This is a new managed policy for Model Registry in Sagemaker. This policy is a standalone policy that can be attached to the user role to access Model Registry related functionalities in Sagemaker. */
    AmazonSageMakerModelRegistryFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerModelRegistryFullAccess);
    }
    /** Managed policy for Service Linked Role for Amazon SageMaker Notebooks */
    AmazonSageMakerNotebooksServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerNotebooksServiceRolePolicy);
    }
    /** Enables Amazon SageMaker partner app users to access applications, list available applications, launch application web UIs, and connect via the application SDK. */
    AmazonSageMakerPartnerAppsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerPartnerAppsFullAccess);
    }
    /** Service role policy used by the AWS APIGateway within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including Lambda and others. */
    AmazonSageMakerPartnerServiceCatalogProductsApiGatewayServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerPartnerServiceCatalogProductsApiGatewayServiceRolePolicy);
    }
    /** Service role policy used by the AWS CloudFormation within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including Lambda, APIGateway and others. */
    AmazonSageMakerPartnerServiceCatalogProductsCloudFormationServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerPartnerServiceCatalogProductsCloudFormationServiceRolePolicy);
    }
    /** Service role policy used by the AWS Lambda within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including Secrets Manager and others. */
    AmazonSageMakerPartnerServiceCatalogProductsLambdaServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerPartnerServiceCatalogProductsLambdaServiceRolePolicy);
    }
    /** This Amazon Managed Policy grants permissions commonly needed for use with Callback steps and Lambda steps in SageMaker Model Building Pipelines. It is added to the AmazonSageMaker-ExecutionRole that can be created when setting up SageMaker Studio. It can also be attached to any other role that will be used for authoring or executing pipelines. */
    AmazonSageMakerPipelinesIntegrations() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerPipelinesIntegrations);
    }
    /** This policy will be used By SageMaker Unified Studios to create VPC related resources for QuickSight */
    AmazonSageMakerQuickSightVPCPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerQuickSightVPCPolicy);
    }
    /** Provides read only access to Amazon SageMaker via the AWS Management Console and SDK. */
    AmazonSageMakerReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerReadOnly);
    }
    /** Service role policy used by the AWS APIGateway within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including CloudWatch Logs and others. */
    AmazonSageMakerServiceCatalogProductsApiGatewayServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsApiGatewayServiceRolePolicy);
    }
    /** Service role policy used by the AWS CloudFormation within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including SageMaker and others. */
    AmazonSageMakerServiceCatalogProductsCloudformationServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsCloudformationServiceRolePolicy);
    }
    /** Service role policy used by the AWS CodeBuild within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including CodePipeline, CodeBuild and others. */
    AmazonSageMakerServiceCatalogProductsCodeBuildServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsCodeBuildServiceRolePolicy);
    }
    /** Service role policy used by the AWS CodePipeline within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including CodePipeline, CodeBuild and others. */
    AmazonSageMakerServiceCatalogProductsCodePipelineServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsCodePipelineServiceRolePolicy);
    }
    /** Service role policy used by the AWS CloudWatch Events within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including CodePipeline and others. */
    AmazonSageMakerServiceCatalogProductsEventsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsEventsServiceRolePolicy);
    }
    /** Service role policy used by the AWS Firehose within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including Firehose and others. */
    AmazonSageMakerServiceCatalogProductsFirehoseServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsFirehoseServiceRolePolicy);
    }
    /** Service role policy used by the AWS Glue within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including Glue, S3 and others. */
    AmazonSageMakerServiceCatalogProductsGlueServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsGlueServiceRolePolicy);
    }
    /** Service role policy used by the AWS Lambda within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including ECR, S3 and others. */
    AmazonSageMakerServiceCatalogProductsLambdaServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsLambdaServiceRolePolicy);
    }
    /** This Amazon Managed Policy provides the necessary permissions to create and manage SageMaker Training Plans. It allows users to create Training Plans and Reserved Capacities, describe existing Training Plans, and perform search and listing operations. */
    AmazonSageMakerTrainingPlanCreateAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSageMakerTrainingPlanCreateAccess);
    }
    /** Provides full access to Amazon Security Lake and related services needed to administer Security Lake. */
    AmazonSecurityLakeAdministrator() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSecurityLakeAdministrator);
    }
    /** Policy for Amazon SecurityLake meta store manager lambda which allows the access to cloudwatch, S3, Glue and SQS. */
    AmazonSecurityLakeMetastoreManager() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSecurityLakeMetastoreManager);
    }
    /** Amazon Security Lake creates IAM roles for third-party custom sources to write data to a data lake and for third-party subscribers to consume data from a data lake, and uses this policy when creating these roles to define the boundary of their permissions. */
    AmazonSecurityLakePermissionsBoundary() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSecurityLakePermissionsBoundary);
    }
    /** Provides full access to Amazon SES via the AWS Management Console. */
    AmazonSESFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSESFullAccess);
    }
    /** Provides read only access to Amazon SES via the AWS Management Console. */
    AmazonSESReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSESReadOnlyAccess);
    }
    /** Allows SES to publish Amazon CloudWatch basic monitoring metrics on behalf of your SES resources */
    AmazonSESServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSESServiceRolePolicy);
    }
    /** Provides full access to Amazon SNS via the AWS Management Console. */
    AmazonSNSFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSNSFullAccess);
    }
    /** Provides read only access to Amazon SNS via the AWS Management Console. */
    AmazonSNSReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSNSReadOnlyAccess);
    }
    /** Default policy for Amazon SNS service role. */
    AmazonSNSRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSNSRole);
    }
    /** Provides full access to Amazon SQS via the AWS Management Console. */
    AmazonSQSFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSQSFullAccess);
    }
    /** Provides read only access to Amazon SQS via the AWS Management Console. */
    AmazonSQSReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSQSReadOnlyAccess);
    }
    /** Provides access to view automation executions and send approval decisions to automation waiting for approval */
    AmazonSSMAutomationApproverAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSSMAutomationApproverAccess);
    }
    /** Provides permissions for EC2 Automation service to execute activities defined within Automation documents */
    AmazonSSMAutomationRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSSMAutomationRole);
    }
    /** This policy allows SSM Agent to access Directory Service on behalf of the customer for domain-join the managed instance. */
    AmazonSSMDirectoryServiceAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSSMDirectoryServiceAccess);
    }
    /** Provides full access to Amazon SSM. */
    AmazonSSMFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSSMFullAccess);
    }
    /**  Service Role to be used for EC2 Maintenance Window */
    AmazonSSMMaintenanceWindowRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSSMMaintenanceWindowRole);
    }
    /** This policy enables AWS Systems Manager functionality on EC2 instances. */
    AmazonSSMManagedEC2InstanceDefaultPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSSMManagedEC2InstanceDefaultPolicy);
    }
    /** The policy for Amazon EC2 Role to enable AWS Systems Manager service core functionality. */
    AmazonSSMManagedInstanceCore() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSSMManagedInstanceCore);
    }
    /** Provide access to child instances for patch association operation. */
    AmazonSSMPatchAssociation() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSSMPatchAssociation);
    }
    /** Provides read only access to Amazon SSM. */
    AmazonSSMReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSSMReadOnlyAccess);
    }
    /** Provides access to AWS Resources managed or used by Amazon SSM */
    AmazonSSMServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonSSMServiceRolePolicy);
    }
    /** Access to all Amazon Textract APIs */
    AmazonTextractFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonTextractFullAccess);
    }
    /** Allows Textract to call AWS services on your behalf. */
    AmazonTextractServiceRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonTextractServiceRole);
    }
    /** Provides full access to manage Amazon Timestream using the AWS Management Console. Note that this policy also grants permissions for certain KMS operations, and operations to manage your saved queries. If using Customer managed CMK, please refer to documentation for additional permissions needed. */
    AmazonTimestreamConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonTimestreamConsoleFullAccess);
    }
    /** Provides full access to Amazon Timestream. Note that this policy also grants certain KMS operation access. If using Customer managed CMK, please refer to documentation for additional permissions needed. */
    AmazonTimestreamFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonTimestreamFullAccess);
    }
    /** Provides full administrative access to create, update, delete and list Amazon Timestream InfluxDB instances and create and list parameter groups. Please refer to documentation for additional permissions needed. */
    AmazonTimestreamInfluxDBFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonTimestreamInfluxDBFullAccess);
    }
    /** Provides administrative access to manage Amazon Timestream InfluxDB instances and parameter groups except marketplace operations. */
    AmazonTimestreamInfluxDBFullAccessWithoutMarketplaceAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonTimestreamInfluxDBFullAccessWithoutMarketplaceAccess);
    }
    /** Provides full administrative access to create, update, delete and list Amazon Timestream InfluxDB instances and create and list parameter groups. Please refer to documentation for additional permissions needed. */
    AmazonTimestreamInfluxDBServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonTimestreamInfluxDBServiceRolePolicy);
    }
    /** Provides read only access to Amazon Timestream. Policy also provides permission to cancel any running query. If using Customer managed CMK, please refer to documentation for additional permissions needed. */
    AmazonTimestreamReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonTimestreamReadOnlyAccess);
    }
    /** Provides full access to Amazon Transcribe operations */
    AmazonTranscribeFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonTranscribeFullAccess);
    }
    /** Provides access to read only operation for Amazon Transcribe */
    AmazonTranscribeReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonTranscribeReadOnlyAccess);
    }
    /** Provides full access to Verified Permissions */
    AmazonVerifiedPermissionsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonVerifiedPermissionsFullAccess);
    }
    /** Provides read-only access to the Verified Permissions service. */
    AmazonVerifiedPermissionsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonVerifiedPermissionsReadOnlyAccess);
    }
    /** Provides access to create network interfaces and attach them to cross-account resources */
    AmazonVPCCrossAccountNetworkInterfaceOperations() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonVPCCrossAccountNetworkInterfaceOperations);
    }
    /** Provides full access to Amazon VPC via the AWS Management Console. */
    AmazonVPCFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonVPCFullAccess);
    }
    /** Provides permissions to describe AWS resources, run Network Access Analyzer, and create or delete tags on Network Insights Access Scope and Network Insights Access Scope Analysis. */
    AmazonVPCNetworkAccessAnalyzerFullAccessPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonVPCNetworkAccessAnalyzerFullAccessPolicy);
    }
    /** Provides permissions to describe AWS resources, run Reachability Analyzer, and create or delete tags on Network Insights Path and Network Insights Analysis. */
    AmazonVPCReachabilityAnalyzerFullAccessPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonVPCReachabilityAnalyzerFullAccessPolicy);
    }
    /** This policy is attached to the role IAMRoleForReachabilityAnalyzerCrossAccountResourceAccess. This role is deployed to the member accounts in an organization when the management account enables trusted access for Reachability Analyzer. It provides permissions to view resources from across your organization using the Reachability Analyzer console. */
    AmazonVPCReachabilityAnalyzerPathComponentReadPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonVPCReachabilityAnalyzerPathComponentReadPolicy);
    }
    /** Provides read only access to Amazon VPC via the AWS Management Console. */
    AmazonVPCReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonVPCReadOnlyAccess);
    }
    /** Provides full access to Amazon WorkDocs via the AWS Management Console */
    AmazonWorkDocsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkDocsFullAccess);
    }
    /** Provides read only access to Amazon WorkDocs via the AWS Management Console */
    AmazonWorkDocsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkDocsReadOnlyAccess);
    }
    /** Enables access to AWS Services and Resources used or managed by Amazon WorkMail Events */
    AmazonWorkMailEventsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkMailEventsServiceRolePolicy);
    }
    /** Provides full access to WorkMail, Directory Service, SES, EC2 and read access to KMS metadata. */
    AmazonWorkMailFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkMailFullAccess);
    }
    /** Full access to the WorkMail Message Flow APIs */
    AmazonWorkMailMessageFlowFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkMailMessageFlowFullAccess);
    }
    /** Read only access to WorkMail messages for the GetRawMessageContent API */
    AmazonWorkMailMessageFlowReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkMailMessageFlowReadOnlyAccess);
    }
    /** Provides read only access to WorkMail and SES. */
    AmazonWorkMailReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkMailReadOnlyAccess);
    }
    /** Provides access to Amazon WorkSpaces administrative actions via AWS SDK and CLI. */
    AmazonWorkSpacesAdmin() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkSpacesAdmin);
    }
    /** Provides administrator access for packaging an application in Amazon WorkSpaces Application Manager. */
    AmazonWorkSpacesApplicationManagerAdminAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkSpacesApplicationManagerAdminAccess);
    }
    /** This managed policy provides full administrative access to AWS Certificate Manager Private CA resources in your AWS account for certificate-based authentication. */
    AmazonWorkspacesPCAAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkspacesPCAAccess);
    }
    /** This policy provides AWS WorkSpaces service access to required customer account resources for launching Workspaces Pools */
    AmazonWorkSpacesPoolServiceAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkSpacesPoolServiceAccess);
    }
    /** Provides read-only access to Amazon WorkSpaces Secure Browser and its dependencies through the AWS Management Console, SDK, and CLI. */
    AmazonWorkSpacesSecureBrowserReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkSpacesSecureBrowserReadOnly);
    }
    /** Provides access to Amazon WorkSpaces backend service to perform Workspace Self Service actions */
    AmazonWorkSpacesSelfServiceAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkSpacesSelfServiceAccess);
    }
    /** Provides customer account access to AWS WorkSpaces service for launching a Workspace. */
    AmazonWorkSpacesServiceAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkSpacesServiceAccess);
    }
    /** Provides full access to Amazon WorkSpaces Thin Client as well as limited access to required related services */
    AmazonWorkSpacesThinClientFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkSpacesThinClientFullAccess);
    }
    /** Enables access to AWS Services and Resources used or managed by Amazon WorkSpaces Thin Client Monitoring */
    AmazonWorkSpacesThinClientMonitoringServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkSpacesThinClientMonitoringServiceRolePolicy);
    }
    /** Provides read-only access to Amazon WorkSpaces Thin Client and its dependencies */
    AmazonWorkSpacesThinClientReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkSpacesThinClientReadOnlyAccess);
    }
    /** Provides read-only access to Amazon WorkSpaces Web and its dependencies through the AWS Management Console, SDK, and CLI. */
    AmazonWorkSpacesWebReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkSpacesWebReadOnly);
    }
    /** Enables access to AWS Services and Resources used or managed by Amazon WorkSpaces Web */
    AmazonWorkSpacesWebServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonWorkSpacesWebServiceRolePolicy);
    }
    /** Provides full access to Amazon Zocalo. */
    AmazonZocaloFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonZocaloFullAccess);
    }
    /** Provides read only access to Amazon Zocalo */
    AmazonZocaloReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmazonZocaloReadOnlyAccess);
    }
    /** Provides Amplify full access permissions to deploy Amplify backend resources (AWS AppSync, Amazon Cognito, Amazon S3 and other related services) via the AWS Cloud Development Kit (AWS CDK) */
    AmplifyBackendDeployFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AmplifyBackendDeployFullAccess);
    }
    /** Allows API Gateway to manage associated AWS Resources on behalf of the customer. */
    APIGatewayServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.APIGatewayServiceRolePolicy);
    }
    /** Allows AppIntegrations to manage AppFlow resources and publish CloudWatch metric data on your behalf. */
    AppIntegrationsServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AppIntegrationsServiceLinkedRolePolicy);
    }
    /** Policy to enable Application Autoscaling for Amazon AppStream */
    ApplicationAutoScalingForAmazonAppStreamAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ApplicationAutoScalingForAmazonAppStreamAccess);
    }
    /** Enables access to AWS Services and Resources used or managed by Application Discovery Service Continuous Export feature */
    ApplicationDiscoveryServiceContinuousExportServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ApplicationDiscoveryServiceContinuousExportServiceRolePolicy);
    }
    /** Allows AWS AppRunner Networking to manage related AWS resources on your behalf. */
    AppRunnerNetworkingServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AppRunnerNetworkingServiceRolePolicy);
    }
    /** Allows AWS AppRunner to manage related AWS resources on your behalf. */
    AppRunnerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AppRunnerServiceRolePolicy);
    }
    /** Allows AppStudio to manage associated AWS resources on your behalf. */
    AppStudioServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AppStudioServiceRolePolicy);
    }
    /** Policy for Amazon Aurora DSQL Service Linked Role */
    AuroraDsqlServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AuroraDsqlServiceLinkedRolePolicy);
    }
    /** Provides full access to Auto Scaling via the AWS Management Console. */
    AutoScalingConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AutoScalingConsoleFullAccess);
    }
    /** Provides read-only access to Auto Scaling via the AWS Management Console. */
    AutoScalingConsoleReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AutoScalingConsoleReadOnlyAccess);
    }
    /** Provides full access to Auto Scaling. */
    AutoScalingFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AutoScalingFullAccess);
    }
    /** Default policy for the AutoScaling Notification Access service role. */
    AutoScalingNotificationAccessRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AutoScalingNotificationAccessRole);
    }
    /** Provides read-only access to Auto Scaling. */
    AutoScalingReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AutoScalingReadOnlyAccess);
    }
    /** Enables access to AWS Services and Resources used or managed by Auto Scaling */
    AutoScalingServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AutoScalingServiceRolePolicy);
    }
    /** Default policy for AWS Config service role. Provides permissions required for AWS Config to track changes to your AWS resources. */
    AWSConfigRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSConfigRole);
    }
    /** Provides permissions to access the SSM Diagnosis S3 bucket for diagnosis and remediation of issues. */
    AWSSSMAutomationDiagnosisBucketPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSMAutomationDiagnosisBucketPolicy);
    }
    /** Provide permission for Diagnosing issues with SSM services by executing activities defined within Automation Documents, primarily used for running the Automation documents in a cross-account cross-region setup by triggering child automations within member accounts. */
    AWSSSMDiagnosisAutomationAdministrationRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSMDiagnosisAutomationAdministrationRolePolicy);
    }
    /** Provide permission for Diagnosing issues with SSM services by executing activities defined within Automation Documents, primarily used for running the Automation documents in a target account/region setup by diagnosing SSM service health across all nodes. */
    AWSSSMDiagnosisAutomationExecutionRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSMDiagnosisAutomationExecutionRolePolicy);
    }
    /** Provides permissions for operational accounts to diagnose unmanaged nodes by providing Organisation specific permissions required by SSM automation to pull the list of member accounts within a root of an Organisation to trigger cross-account cross-region execution by allowing assuming Execution roles in target account/region. */
    AWSSSMDiagnosisAutomationOperationalAccountAdministrationRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSMDiagnosisAutomationOperationalAccountAdministrationRolePolicy);
    }
    /** Provide permission for Remediating issues with SSM services by executing activities defined within Automation Documents, primarily used for running the Automation documents in a cross-account cross-region setup by triggering child automations within member accounts. */
    AWSSSMRemediationAutomationAdministrationRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSMRemediationAutomationAdministrationRolePolicy);
    }
    /** Provides permissions for Remediating issues with SSM services by executing activities defined within Automation Documents, primarily used for running the Automation documents in a target account/region setup by remediating SSM services health across all nodes. */
    AWSSSMRemediationAutomationExecutionRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSMRemediationAutomationExecutionRolePolicy);
    }
    /** Provides permissions for operational accounts to Remediate unmanaged nodes by providing Organisation specific permissions required by SSM automation to pull the list of member accounts within a root of an Organisation to trigger cross-account cross-region execution by allowing assuming Execution roles in target account/region. */
    AWSSSMRemediationAutomationOperationalAccountAdministrationRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSMRemediationAutomationOperationalAccountAdministrationRolePolicy);
    }
    /** Allows users to access the Account Activity page. */
    AWSAccountActivityAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAccountActivityAccess);
    }
    /** Provides full access to AWS Account Management. */
    AWSAccountManagementFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAccountManagementFullAccess);
    }
    /** Provides read-only access to AWS Account Management */
    AWSAccountManagementReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAccountManagementReadOnlyAccess);
    }
    /** Allows users to access the Account Usage Report page. */
    AWSAccountUsageReportAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAccountUsageReportAccess);
    }
    /** Provides access for the Discovery Agentless Connector to register with AWS Application Discovery Service. */
    AWSAgentlessDiscoveryService() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAgentlessDiscoveryService);
    }
    /** Provides full access to the AWS AppFabric service and read only access to dependent services such as S3, Kinesis, KMS. */
    AWSAppFabricFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppFabricFullAccess);
    }
    /** Provides read only access to the AWS AppFabric */
    AWSAppFabricReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppFabricReadOnlyAccess);
    }
    /** Provides AppFabric access to AWS resources on your behalf */
    AWSAppFabricServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppFabricServiceRolePolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access AppStream and CloudWatch. */
    AWSApplicationAutoscalingAppStreamFleetPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingAppStreamFleetPolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access Cassandra and CloudWatch. */
    AWSApplicationAutoscalingCassandraTablePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingCassandraTablePolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access Comprehend and CloudWatch. */
    AWSApplicationAutoscalingComprehendEndpointPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingComprehendEndpointPolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access APIGateway and CloudWatch for custom resource scaling */
    AWSApplicationAutoScalingCustomResourcePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoScalingCustomResourcePolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access DynamoDB and CloudWatch. */
    AWSApplicationAutoscalingDynamoDBTablePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingDynamoDBTablePolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access EC2 Spot Fleet and CloudWatch. */
    AWSApplicationAutoscalingEC2SpotFleetRequestPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingEC2SpotFleetRequestPolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access EC2 Container Service and CloudWatch. */
    AWSApplicationAutoscalingECSServicePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingECSServicePolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access Amazon ElastiCache and Amazon CloudWatch. */
    AWSApplicationAutoscalingElastiCacheRGPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingElastiCacheRGPolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access Elastic Map Reduce and CloudWatch. */
    AWSApplicationAutoscalingEMRInstanceGroupPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingEMRInstanceGroupPolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access Managed Streaming for Apache Kafka and CloudWatch. */
    AWSApplicationAutoscalingKafkaClusterPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingKafkaClusterPolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access Lambda and CloudWatch. */
    AWSApplicationAutoscalingLambdaConcurrencyPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingLambdaConcurrencyPolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access Amazon Neptune and Amazon CloudWatch. */
    AWSApplicationAutoscalingNeptuneClusterPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingNeptuneClusterPolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access RDS and CloudWatch. */
    AWSApplicationAutoscalingRDSClusterPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingRDSClusterPolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access SageMaker and CloudWatch. */
    AWSApplicationAutoscalingSageMakerEndpointPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingSageMakerEndpointPolicy);
    }
    /** Policy granting permissions to Application Auto Scaling to access Amazon WorkSpaces and Amazon CloudWatch. */
    AWSApplicationAutoscalingWorkSpacesPoolPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationAutoscalingWorkSpacesPoolPolicy);
    }
    /** Provides access for the Discovery Agent to register with AWS Application Discovery Service. */
    AWSApplicationDiscoveryAgentAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationDiscoveryAgentAccess);
    }
    /** Allows Application Discovery Service Agentless Collectors to auto update, register, and communicate with Application Discovery Service */
    AWSApplicationDiscoveryAgentlessCollectorAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationDiscoveryAgentlessCollectorAccess);
    }
    /** Provides full access to view and tag Configuration Items maintained by the AWS Application Discovery Service */
    AWSApplicationDiscoveryServiceFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationDiscoveryServiceFullAccess);
    }
    /** This policy allows installing the AWS Replication Agent, which is used with AWS Application Migration Service (MGN) to migrate external servers to AWS. Attach this policy to your IAM users or roles whose credentials you provide when installing the AWS Replication Agent. */
    AWSApplicationMigrationAgentInstallationPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationMigrationAgentInstallationPolicy);
    }
    /** This policy allows installing and using the AWS Replication Agent, which is used with AWS Application Migration Service (MGN) to migrate external servers to AWS. Attach this policy to your IAM users or roles whose credentials you provide when installing the AWS Replication Agent. */
    AWSApplicationMigrationAgentPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationMigrationAgentPolicy);
    }
    /** This policy allows using the AWS Replication Agent, which is used with AWS Application Migration Service (MGN) to migrate external servers to AWS. We do not recommend that you attach this policy to your IAM users or roles. */
    AWSApplicationMigrationAgentPolicyV2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationMigrationAgentPolicyV2);
    }
    /** This policy allows the Application Migration Service (MGN) Conversion Server, which are EC2 instances launched by Application Migration Service, to communicate with the MGN service. An IAM role with this policy is attached (as an EC2 Instance Profile) by MGN to the MGN Conversion Servers, which are automatically launched and terminated by MGN, when needed. We do not recommend that you attach this policy to your IAM users or roles. MGN Conversion Servers are used by Application Migration Service when users choose to launch Test or Cutover instances using the MGN console, CLI, or API. */
    AWSApplicationMigrationConversionServerPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationMigrationConversionServerPolicy);
    }
    /** This policy provides Amazon EC2 operations required to use Application Migration Service (MGN) to launch the migrated servers as EC2 instances. Attach this policy to your IAM users or roles. */
    AWSApplicationMigrationEC2Access() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationMigrationEC2Access);
    }
    /** This policy provides permissions to all public APIs of AWS Application Migration Service (MGN), as well as permissions to read KMS key information. Attach this policy to your IAM users or roles. */
    AWSApplicationMigrationFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationMigrationFullAccess);
    }
    /** This policy allows AWS Application Migration Service (MGN) to send meta-data about the progress of servers being migrated using MGN to AWS Migration Hub (MGH). MGN automatically creates an IAM role with this policy attached, and assumes this role. We do not recommend that you attach this policy to your IAM users or roles. */
    AWSApplicationMigrationMGHAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationMigrationMGHAccess);
    }
    /** This policy provides permissions to all read-only public APIs of Application Migration Service (MGN), as well as some read-only APIs of other AWS services that are required in order to make full read-only use of the MGN console. Attach this policy to your IAM users or roles. */
    AWSApplicationMigrationReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationMigrationReadOnlyAccess);
    }
    /** This policy allows the Application Migration Service (MGN) Replication Servers, which are EC2 instances launched by Application Migration Service - to communicate with the MGN service, and to create EBS snapshots in your AWS account. An IAM role with this policy is attached (as an EC2 Instance Profile) by Application Migration Service to the MGN Replication Servers which are automatically launched and terminated by MGN, as needed. MGN Replication Servers are used to facilitate data replication from your external servers to AWS, as part of the migration process managed using MGN. We do not recommend that you attach this policy to your IAM users or roles. */
    AWSApplicationMigrationReplicationServerPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationMigrationReplicationServerPolicy);
    }
    /** This policy allows installing and using the AWS Replication Agent, which is used by AWS Application Migration Service (AWS MGN) to migrate source servers that run on EC2 (cross-Region or cross-AZ). An IAM role with this policy should be attached (as an EC2 Instance Profile) to the EC2 Instances. */
    AWSApplicationMigrationServiceEc2InstancePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationMigrationServiceEc2InstancePolicy);
    }
    /** Allows AWS application Migration Service to create and manage AWS resources on your behalf. */
    AWSApplicationMigrationServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationMigrationServiceRolePolicy);
    }
    /** This policy provides access to Amazon SSM operations required to use Application Migration Service (MGN) to execute custom post migration command SSM documents. Attach this policy to your IAM users or roles. */
    AWSApplicationMigrationSSMAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationMigrationSSMAccess);
    }
    /** This policy allows installing and using the AWS VCenter Client, which is used with AWS Application Migration Service (MGN) to migrate external servers to AWS. Attach this policy to your IAM users or roles whose credentials you provide when installing the AWS VCenter Client. */
    AWSApplicationMigrationVCenterClientPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSApplicationMigrationVCenterClientPolicy);
    }
    /** App Mesh Envoy policy for accessing Virtual Node configuration. */
    AWSAppMeshEnvoyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppMeshEnvoyAccess);
    }
    /** Provides full access to the AWS App Mesh APIs and Management Console. */
    AWSAppMeshFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppMeshFullAccess);
    }
    /** App Mesh Preview Envoy policy for accessing Virtual Node configuration. */
    AWSAppMeshPreviewEnvoyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppMeshPreviewEnvoyAccess);
    }
    /** Enables access to AWS Services and Resources used or managed by AWS App Mesh */
    AWSAppMeshPreviewServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppMeshPreviewServiceRolePolicy);
    }
    /** Provides read-only access to the AWS App Mesh APIs and Management Console. */
    AWSAppMeshReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppMeshReadOnly);
    }
    /** Enables access to AWS Services and Resources used or managed by AWS AppMesh */
    AWSAppMeshServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppMeshServiceRolePolicy);
    }
    /** Grants permissions to all App Runner actions. */
    AWSAppRunnerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppRunnerFullAccess);
    }
    /** Grants permissions to list and view details about App Runner resources. */
    AWSAppRunnerReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppRunnerReadOnlyAccess);
    }
    /** AWS App Runner service policy that grants read permissions to Amazon ECR resources in the customer's account. Use it in a role that is passed to App Runner when creating or updating an App Runner service. */
    AWSAppRunnerServicePolicyForECRAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppRunnerServicePolicyForECRAccess);
    }
    /** Provides administrative access to the AppSync service, though not enough to access via the console. */
    AWSAppSyncAdministrator() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppSyncAdministrator);
    }
    /** Provides full invoking access to the AppSync service - both through the console and independently */
    AWSAppSyncInvokeFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppSyncInvokeFullAccess);
    }
    /** Allows AppSync to push logs to user's CloudWatch account. */
    AWSAppSyncPushToCloudWatchLogs() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppSyncPushToCloudWatchLogs);
    }
    /** Provides access to create, update, and query the schema. */
    AWSAppSyncSchemaAuthor() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppSyncSchemaAuthor);
    }
    /** Enables access to AWS services and resources used or managed by AppSync */
    AWSAppSyncServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAppSyncServiceRolePolicy);
    }
    /** Allows AWS Artifact read-only access to operations in AWS Organizations. */
    AWSArtifactAccountSync() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSArtifactAccountSync);
    }
    /** This policy grants full permissions to list, download, accept, and terminate AWS Artifact agreements. It also includes permissions to list and enable AWS service access in the Organization service, as well as describe the organization details. Additionally, the policy provides the ability to check if the required service-linked role exists and creates one if it doesn't */
    AWSArtifactAgreementsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSArtifactAgreementsFullAccess);
    }
    /** This policy grants read-only access to list the AWS Artifact service agreements and to download the accepted agreements.. It also includes permissions to list as well as describe the organization details. Additionally, the policy provides the ability to check if the required service-linked role exists. */
    AWSArtifactAgreementsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSArtifactAgreementsReadOnlyAccess);
    }
    /** Provides read-only access to the AWS Artifact service reports. */
    AWSArtifactReportsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSArtifactReportsReadOnlyAccess);
    }
    /** Allows AWS Artifact to gather information about an organization via AWS Organizations service. */
    AWSArtifactServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSArtifactServiceRolePolicy);
    }
    /** Provides administrative access to enable or disable AWS Audit Manager, update settings, and manage assessments, controls, and frameworks */
    AWSAuditManagerAdministratorAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAuditManagerAdministratorAccess);
    }
    /** Enables access to AWS Services and Resources used or managed by AWS Audit Manager */
    AWSAuditManagerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAuditManagerServiceRolePolicy);
    }
    /** Policy granting permissions to AWS Auto Scaling to periodically forecast capacity and generate scheduled scaling actions for Auto Scaling groups in a scaling plan */
    AWSAutoScalingPlansEC2AutoScalingPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSAutoScalingPlansEC2AutoScalingPolicy);
    }
    /** This policy grants permissions for users to create controls and frameworks that define their expectations for AWS Backup resources and activities, and to audit AWS Backup resources and activities against their defined controls and frameworks. This policy grants permissions to AWS Config and similar services to describe user expectations perform the audits. This policy also grants permissions to deliver audit reports to S3 and similar services, and enables users to find and open their audit reports. */
    AWSBackupAuditAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupAuditAccess);
    }
    /** This policy allows the AWS Backint agent to complete backup data transfer with AWS Backup Storage plane. Attach this policy to roles assumed by EC2 Instances running SAP HANA with the Backint agent. */
    AWSBackupDataTransferAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupDataTransferAccess);
    }
    /** This policy is for backup administrators, granting full access to AWS Backup operations, including creating or editing backup plans, assigning AWS resources to backup plans, deleting backups, and restoring backups. */
    AWSBackupFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupFullAccess);
    }
    /** Provides AWS BackupGateway permission to sync the metadata of Virtual Machines on your behalf */
    AWSBackupGatewayServiceRolePolicyForVirtualMachineMetadataSync() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupGatewayServiceRolePolicyForVirtualMachineMetadataSync);
    }
    /** This policy grants users permissions to assign AWS resources to backup plans, create on-demand backups, and restore backups. This policy does not allow the user to create or edit backup plans or to delete scheduled backups after they are created. */
    AWSBackupOperatorAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupOperatorAccess);
    }
    /** This policy is for backup administators who use cross-account backup management to manage backups for the organization. */
    AWSBackupOrganizationAdminAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupOrganizationAdminAccess);
    }
    /** Provides AWS Backup permission to restore a backup of SAP HANA on Amazon EC2 */
    AWSBackupRestoreAccessForSAPHANA() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupRestoreAccessForSAPHANA);
    }
    /** The search operator role has access to create backup indexes, create searches of backup metadata that has been indexed. This policy contains the necessary permissions for these search operator functions. */
    AWSBackupSearchOperatorAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupSearchOperatorAccess);
    }
    /** Provides AWS Backup permission to create backups on your behalf across AWS services */
    AWSBackupServiceLinkedRolePolicyForBackup() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupServiceLinkedRolePolicyForBackup);
    }
    /** Provides AWS Backup permission to create backups on your behalf across AWS services */
    AWSBackupServiceLinkedRolePolicyForBackupTest() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupServiceLinkedRolePolicyForBackupTest);
    }
    /** Provides AWS Backup permission to create backups on your behalf across AWS services */
    AWSBackupServiceRolePolicyForBackup() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupServiceRolePolicyForBackup);
    }
    /** Policy containing permissions necessary for AWS Backup to index recovery points. */
    AWSBackupServiceRolePolicyForIndexing() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupServiceRolePolicyForIndexing);
    }
    /** Policy containing permissions necessary for AWS Backup to restore individual items in a recovery point */
    AWSBackupServiceRolePolicyForItemRestores() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupServiceRolePolicyForItemRestores);
    }
    /** Provides AWS Backup permission to perform restores on your behalf across AWS services. This policy includes permissions to create and delete AWS resources, such as EBS volumes, RDS instances, and EFS file systems, which are part of the restore process. */
    AWSBackupServiceRolePolicyForRestores() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupServiceRolePolicyForRestores);
    }
    /** Policy containing permissions necessary for AWS Backup to backup data in any S3 bucket. This includes read access to all S3 objects and any decrypt access for all KMS keys. */
    AWSBackupServiceRolePolicyForS3Backup() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupServiceRolePolicyForS3Backup);
    }
    /** Policy containing permissions necessary for AWS Backup to restore a S3 backup to a bucket. This includes read/write permissions to all S3 buckets, and permissions to GenerateDataKey and DescribeKey for all KMS keys. */
    AWSBackupServiceRolePolicyForS3Restore() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBackupServiceRolePolicyForS3Restore);
    }
    /** Provides full access for AWS Batch resources. */
    AWSBatchFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBatchFullAccess);
    }
    /** Policy to enable CloudWatch Event Target for AWS Batch Job Submission */
    AWSBatchServiceEventTargetRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBatchServiceEventTargetRole);
    }
    /** Policy for AWS Batch service role which allows access to related services including EC2, Autoscaling, EC2 Container service and Cloudwatch Logs. */
    AWSBatchServiceRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBatchServiceRole);
    }
    /** Provides access for AWS Batch to queue and manage Amazon SageMaker workloads */
    AWSBatchServiceRolePolicyForSageMaker() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBatchServiceRolePolicyForSageMaker);
    }
    /** A service linked role to provide Billing and Cost Management Data Exports access to AWS service data for exporting the data to a target location, such as Amazon S3, on behalf of a customer. */
    AWSBCMDataExportsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBCMDataExportsServiceRolePolicy);
    }
    /** Use the AWSBillingConductorFullAccess managed policy to allow complete access to AWS Billing Conductor (ABC) console and APIs. This policy allows users to list, create and delete ABC resources. */
    AWSBillingConductorFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBillingConductorFullAccess);
    }
    /** Use the AWSBillingConductorReadOnlyAccess managed policy to allow read only access to AWS Billing Conductor (ABC) console and APIs. This policy grants permission to view and list all ABC resources. It does not include the ability to create or delete resources. */
    AWSBillingConductorReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBillingConductorReadOnlyAccess);
    }
    /** Allows users to view bills on the Billing Console. */
    AWSBillingReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBillingReadOnlyAccess);
    }
    /** Allows billing service to validate access to billing view data for derived billing views */
    AWSBillingServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBillingServiceRolePolicy);
    }
    /** This policy gives permissions to control AWS resources. For example, to start and stop EC2 or RDS instances by executing AWS Systems Manager (SSM) scripts. */
    AWSBudgetsActionsRolePolicyForResourceAdministrationWithSSM() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBudgetsActionsRolePolicyForResourceAdministrationWithSSM);
    }
    /** Provides full access to AWS Budgets Actions including using Budgets Actions to control states of running AWS resources via AWS Management Console */
    AWSBudgetsActionsWithAWSResourceControlAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBudgetsActionsWithAWSResourceControlAccess);
    }
    /** Provides read only access to AWS Budgets Console via the AWS Management Console. */
    AWSBudgetsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBudgetsReadOnlyAccess);
    }
    /** This IAM policy grants users full access to the AWS BugBust console */
    AWSBugBustFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBugBustFullAccess);
    }
    /** This IAM policy grants users access to participate in AWS BugBust events */
    AWSBugBustPlayerAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBugBustPlayerAccess);
    }
    /** Grants permissions to AWS BugBust to access resources on your behalf */
    AWSBugBustServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSBugBustServiceRolePolicy);
    }
    /** Provides full access to AWS Certificate Manager (ACM) */
    AWSCertificateManagerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCertificateManagerFullAccess);
    }
    /** Provides auditor access to AWS Certificate Manager Private Certificate Authority */
    AWSCertificateManagerPrivateCAAuditor() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCertificateManagerPrivateCAAuditor);
    }
    /** Provides full access to AWS Certificate Manager Private Certificate Authority */
    AWSCertificateManagerPrivateCAFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCertificateManagerPrivateCAFullAccess);
    }
    /** Provides privileged certificate user access to AWS Certificate Manager Private Certificate Authority */
    AWSCertificateManagerPrivateCAPrivilegedUser() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCertificateManagerPrivateCAPrivilegedUser);
    }
    /** Provides read only access to AWS Certificate Manager Private Certificate Authority */
    AWSCertificateManagerPrivateCAReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCertificateManagerPrivateCAReadOnly);
    }
    /** Provides certificate user access to AWS Certificate Manager Private Certificate Authority */
    AWSCertificateManagerPrivateCAUser() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCertificateManagerPrivateCAUser);
    }
    /** Provides read only access to AWS Certificate Manager (ACM). */
    AWSCertificateManagerReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCertificateManagerReadOnly);
    }
    /** The Service Linked Role used by AWS Chatbot. */
    AWSChatbotServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSChatbotServiceLinkedRolePolicy);
    }
    /** Allows full access to AWS Clean Rooms resources and access to related AWS Services. */
    AWSCleanRoomsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCleanRoomsFullAccess);
    }
    /** Allows full access to AWS Clean Rooms resources except for querying in a collaboration and access to related AWS Services. */
    AWSCleanRoomsFullAccessNoQuerying() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCleanRoomsFullAccessNoQuerying);
    }
    /** Allows full access to AWS Clean Rooms ML resources and access to related AWS Services. */
    AWSCleanRoomsMLFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCleanRoomsMLFullAccess);
    }
    /** Allows read-only access to AWS Clean Rooms ML resources and read-only access to related AWS Clean Rooms resources */
    AWSCleanRoomsMLReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCleanRoomsMLReadOnlyAccess);
    }
    /** Allows read-only access to AWS Clean Rooms resources and read-only access to related AWS Glue and Amazon CloudWatch Logs resources. */
    AWSCleanRoomsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCleanRoomsReadOnlyAccess);
    }
    /** Provides administrator access to AWS Cloud9. */
    AWSCloud9Administrator() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloud9Administrator);
    }
    /** Provides the ability to be invited into AWS Cloud9 shared development environments. */
    AWSCloud9EnvironmentMember() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloud9EnvironmentMember);
    }
    /** Service Linked Role Policy for AWS Cloud9 */
    AWSCloud9ServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloud9ServiceRolePolicy);
    }
    /** This policy will be used to attach a role on a InstanceProfile which will allow Cloud9 to use the SSM Session Manager to connect to the instance */
    AWSCloud9SSMInstanceProfile() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloud9SSMInstanceProfile);
    }
    /** Provides permission to create AWS Cloud9 development environments and to manage owned environments. */
    AWSCloud9User() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloud9User);
    }
    /** Provides full access to AWS CloudFormation. */
    AWSCloudFormationFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudFormationFullAccess);
    }
    /** Provides access to AWS CloudFormation via the AWS Management Console. */
    AWSCloudFormationReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudFormationReadOnlyAccess);
    }
    /** Grants CloudFront Logger write permissions to CloudWatch Logs. */
    AWSCloudFrontLogger() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudFrontLogger);
    }
    /** Allows CloudFront to manage EC2 Elastic Network Interfaces and Security Groups on your behalf. */
    AWSCloudFrontVPCOriginServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudFrontVPCOriginServiceRolePolicy);
    }
    /** Provides full access to all CloudHSM resources. */
    AWSCloudHSMFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudHSMFullAccess);
    }
    /** Provides read only access to all CloudHSM resources. */
    AWSCloudHSMReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudHSMReadOnlyAccess);
    }
    /** Default policy for the AWS CloudHSM service role. */
    AWSCloudHSMRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudHSMRole);
    }
    /** Provides access to AWS Cloud Map discovery API. */
    AWSCloudMapDiscoverInstanceAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudMapDiscoverInstanceAccess);
    }
    /** Provides full access to all AWS Cloud Map actions. */
    AWSCloudMapFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudMapFullAccess);
    }
    /** Provides read-only access to all AWS Cloud Map actions. */
    AWSCloudMapReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudMapReadOnlyAccess);
    }
    /** Provides registrant level access to AWS Cloud Map actions. */
    AWSCloudMapRegisterInstanceAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudMapRegisterInstanceAccess);
    }
    /** Grants using AWS CloudShell with all features */
    AWSCloudShellFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudShellFullAccess);
    }
    /** Provides full access to AWS CloudTrail. */
    AWSCloudTrailFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudTrailFullAccess);
    }
    /** Provides read only access to AWS CloudTrail. */
    AWSCloudTrailReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudTrailReadOnlyAccess);
    }
    /** This policy is used by the service-linked role named AWSServiceRoleForCloudWatchAlarms_ActionSSMIncidents. CloudWatch uses this service-linked role to perform AWS System Manager Incident Manager actions when a CloudWatch alarm goes in to ALARM state. This policy grants permission to start incidents on your behalf. */
    AWSCloudWatchAlarmsActionSSMIncidentsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCloudWatchAlarmsActionSSMIncidentsServiceRolePolicy);
    }
    /** Provides full access to AWS CodeArtifact via the AWS Management Console. */
    AWSCodeArtifactAdminAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeArtifactAdminAccess);
    }
    /** Provides read only access to AWS CodeArtifact via the AWS Management Console. */
    AWSCodeArtifactReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeArtifactReadOnlyAccess);
    }
    /** Provides full access to AWS CodeBuild via the AWS Management Console. Also attach AmazonS3ReadOnlyAccess to provide access to download build artifacts, and attach IAMFullAccess to create and manage the service role for CodeBuild. */
    AWSCodeBuildAdminAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeBuildAdminAccess);
    }
    /** Provides access to AWS CodeBuild via the AWS Management Console, but does not allow CodeBuild project administration. Also attach AmazonS3ReadOnlyAccess to provide access to download build artifacts. */
    AWSCodeBuildDeveloperAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeBuildDeveloperAccess);
    }
    /** Provides read only access to AWS CodeBuild via the AWS Management Console. Also attach AmazonS3ReadOnlyAccess to provide access to download build artifacts. */
    AWSCodeBuildReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeBuildReadOnlyAccess);
    }
    /** Provides full access to AWS CodeCommit via the AWS Management Console. */
    AWSCodeCommitFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeCommitFullAccess);
    }
    /** Provides full access to AWS CodeCommit repositories, but does not allow repository deletion. */
    AWSCodeCommitPowerUser() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeCommitPowerUser);
    }
    /** Provides read only access to AWS CodeCommit via the AWS Management Console. */
    AWSCodeCommitReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeCommitReadOnly);
    }
    /** Provides access to register and deploy a revision. */
    AWSCodeDeployDeployerAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeDeployDeployerAccess);
    }
    /** Provides full access to CodeDeploy resources. */
    AWSCodeDeployFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeDeployFullAccess);
    }
    /** Provides read only access to CodeDeploy resources. */
    AWSCodeDeployReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeDeployReadOnlyAccess);
    }
    /** Provides CodeDeploy service access to expand tags and interact with Auto Scaling on your behalf. */
    AWSCodeDeployRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeDeployRole);
    }
    /** Provides CodeDeploy service access to invoke Lambda function on your behalf to perform blue/green deployment through CloudFormation. */
    AWSCodeDeployRoleForCloudFormation() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeDeployRoleForCloudFormation);
    }
    /** Provides CodeDeploy service wide access to perform an ECS blue/green deployment on your behalf. Grants full access to support services, such as  full access to read all S3 objects, invoke all Lambda functions, publish to all SNS topics within the account and update all ECS services. */
    AWSCodeDeployRoleForECS() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeDeployRoleForECS);
    }
    /**  Provides CodeDeploy service limited access to perform an ECS blue/green deployment on your behalf. */
    AWSCodeDeployRoleForECSLimited() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeDeployRoleForECSLimited);
    }
    /** Provides CodeDeploy service access to perform a Lambda deployment on your behalf. */
    AWSCodeDeployRoleForLambda() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeDeployRoleForLambda);
    }
    /** Provides CodeDeploy service limited access to perform a Lambda deployment on your behalf. */
    AWSCodeDeployRoleForLambdaLimited() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeDeployRoleForLambdaLimited);
    }
    /** Provides full access to AWS CodePipeline via the AWS Management Console. */
    AWSCodePipelineFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodePipelineFullAccess);
    }
    /** Provides read only access to AWS CodePipeline via the AWS Management Console. */
    AWSCodePipelineReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodePipelineReadOnlyAccess);
    }
    /** Provides access to view and approve manual changes for all pipelines */
    AWSCodePipelineApproverAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodePipelineApproverAccess);
    }
    /** Provides access for custom actions to poll for jobs details (including temporary credentials) and report status updates to AWS CodePipeline. */
    AWSCodePipelineCustomActionAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodePipelineCustomActionAccess);
    }
    /** Provides full access to AWS CodeStar via the AWS Management Console. */
    AWSCodeStarFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeStarFullAccess);
    }
    /** Allows AWS CodeStar Notifications to access Amazon CloudWatch Events on your behalf */
    AWSCodeStarNotificationsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeStarNotificationsServiceRolePolicy);
    }
    /** DO NOT USE -  AWS CodeStar Service Role Policy which grants administrative privileges in order for CodeStar to manage IAM and other service resources on behalf of the customer. */
    AWSCodeStarServiceRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCodeStarServiceRole);
    }
    /** Denies access to certain actions, applied by the AWS team in the event that an IAM user's credentials have been compromised or exposed publicly.  Do NOT remove this policy.  Instead, please follow the instructions specified in the email sent to you regarding this event. */
    AWSCompromisedKeyQuarantine() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCompromisedKeyQuarantine);
    }
    /** Denies access to certain actions, applied by the AWS team in the event that an IAM user's credentials have been compromised or exposed publicly. Do NOT remove this policy. Instead, please follow the instructions specified in the support case created for you regarding this event. */
    AWSCompromisedKeyQuarantineV2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCompromisedKeyQuarantineV2);
    }
    /** Denies access to certain actions, applied by AWS in the event that an IAM user's credentials have been compromised or exposed publicly. The policy aims to limit the potential damage that may be caused by fraud-related activity leading to unauthorized charges, while not impacting the existing resources. Do NOT remove this policy. Instead, please follow the instructions specified in the support case created for you regarding this event. */
    AWSCompromisedKeyQuarantineV3() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCompromisedKeyQuarantineV3);
    }
    /** Allows Config to call AWS services and deploy config resources across organization */
    AWSConfigMultiAccountSetupPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSConfigMultiAccountSetupPolicy);
    }
    /** Allows AWS Config to remediate noncompliant resources on your behalf. */
    AWSConfigRemediationServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSConfigRemediationServiceRolePolicy);
    }
    /** Allows AWS Config to call read-only AWS Organizations APIs */
    AWSConfigRoleForOrganizations() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSConfigRoleForOrganizations);
    }
    /** Allows an AWS Lambda function to access the AWS Config API and the configuration snapshots that AWS Config delivers periodically to Amazon S3. This access is required by functions that evaluate configuration changes for custom Config rules. */
    AWSConfigRulesExecutionRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSConfigRulesExecutionRole);
    }
    /** Allows Config to call AWS services and collect resource configurations on your behalf. */
    AWSConfigServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSConfigServiceRolePolicy);
    }
    /** Provides access to use AWS Config, including searching by tags on resources, and reading all tags. This does not provide permission to configure AWS Config, which requires administrative privileges. */
    AWSConfigUserAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSConfigUserAccess);
    }
    /** Enables broad read/write access to ALL EC2 objects, read/write access to S3 buckets starting with 'import-to-ec2-', and the ability to list all S3 buckets, for the AWS Connector to import VMs on your behalf. */
    AWSConnector() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSConnector);
    }
    /** Allows AWS Control Tower to call AWS services that provide automated account configuration and centralized governance on your behalf. */
    AWSControlTowerAccountServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSControlTowerAccountServiceRolePolicy);
    }
    /** Provides access to AWS Resources managed or used by AWS Control Tower */
    AWSControlTowerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSControlTowerServiceRolePolicy);
    }
    /** Grants permissions to to describe the organization of the account, create S3 buckets for the MAP program and apply tags to it, create a Cost and Usage Report, and describe Cost and Usage Report definitions. */
    AWSCostAndUsageReportAutomationPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSCostAndUsageReportAutomationPolicy);
    }
    /** Gives Data Grant owners access to AWS Data Exchange actions using the AWS Management Console and SDK. */
    AWSDataExchangeDataGrantOwnerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataExchangeDataGrantOwnerFullAccess);
    }
    /** Gives Data Grant receiver access to AWS Data Exchange actions using the AWS Management Console and SDK. */
    AWSDataExchangeDataGrantReceiverFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataExchangeDataGrantReceiverFullAccess);
    }
    /** Grants full access to AWS Data Exchange and AWS Marketplace actions using the AWS Management Console and SDK. It also provides select access to related services needed to take full advantage of AWS Data Exchange. */
    AWSDataExchangeFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataExchangeFullAccess);
    }
    /** Grants data provider access to AWS Data Exchange and AWS Marketplace actions using the AWS Management Console and SDK. It also provides select access to related services needed to take full advantage of AWS Data Exchange. */
    AWSDataExchangeProviderFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataExchangeProviderFullAccess);
    }
    /** Grants read-only access to AWS Data Exchange and AWS Marketplace actions using the AWS Management Console and SDK. */
    AWSDataExchangeReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataExchangeReadOnly);
    }
    /** Allows AWS Data Exchange to access AWS Services and Resources used or managed by AWS Data Exchange for license management. */
    AWSDataExchangeServiceRolePolicyForLicenseManagement() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataExchangeServiceRolePolicyForLicenseManagement);
    }
    /** Allows AWS Data Exchange to read data about your AWS Organization to determine eligibility for AWS Data Exchange data grants license distribution. */
    AWSDataExchangeServiceRolePolicyForOrganizationDiscovery() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataExchangeServiceRolePolicyForOrganizationDiscovery);
    }
    /** Grants data subscriber access to AWS Data Exchange and AWS Marketplace actions using the AWS Management Console and SDK. It also provides select access to related services needed to take full advantage of AWS Data Exchange. */
    AWSDataExchangeSubscriberFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataExchangeSubscriberFullAccess);
    }
    /** Provides appropriate permissions to AWS Data Lifecycle Manager to take actions on AWS resources */
    AWSDataLifecycleManagerServiceRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataLifecycleManagerServiceRole);
    }
    /** Provides appropriate permissions to AWS Data Lifecycle Manager to take actions on AWS resources for AMI Management */
    AWSDataLifecycleManagerServiceRoleForAMIManagement() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataLifecycleManagerServiceRoleForAMIManagement);
    }
    /** Provides Amazon Data Lifecycle Manager permission to perform the Systems Manager actions required to run pre and post scripts on all Amazon EC2 instances. */
    AWSDataLifecycleManagerSSMFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataLifecycleManagerSSMFullAccess);
    }
    /** Provides full access to Data Pipeline, list access for S3, DynamoDB, Redshift, RDS, SNS, and IAM roles, and passRole access for default Roles. */
    AWSDataPipelineFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataPipelineFullAccess);
    }
    /** Provides full access to Data Pipeline, list access for S3, DynamoDB, Redshift, RDS, SNS, and IAM roles, and passRole access for default Roles. */
    AWSDataPipelinePowerUser() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataPipelinePowerUser);
    }
    /** Allows DataSync Discovery to integrate with other AWS services on your behalf. */
    AWSDataSyncDiscoveryServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataSyncDiscoveryServiceRolePolicy);
    }
    /** Provides full access to AWS DataSync and minimal access to its dependencies */
    AWSDataSyncFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataSyncFullAccess);
    }
    /** Provides read-only access to AWS DataSync */
    AWSDataSyncReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataSyncReadOnlyAccess);
    }
    /** Allows DataSync to integrate with other AWS services on your behalf */
    AWSDataSyncServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDataSyncServiceRolePolicy);
    }
    /** Provides AWS Deadline Cloud workers with access to run tasks on a farm. */
    AWSDeadlineCloudFleetWorker() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeadlineCloudFleetWorker);
    }
    /** Provides user workstation access to AWS Deadline Cloud farms with limited Read-Only permissions to call other necessary services. Attach this policy to the user role associated with your studio. */
    AWSDeadlineCloudUserAccessFarms() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeadlineCloudUserAccessFarms);
    }
    /** Provides user workstation access to AWS Deadline Cloud fleets with limited Read-Only permissions to call other necessary services. Attach this policy to the user role associated with your studio. */
    AWSDeadlineCloudUserAccessFleets() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeadlineCloudUserAccessFleets);
    }
    /** Provides user workstation access to AWS Deadline Cloud jobs with limited Read-Only permissions to call other necessary services. Attach this policy to the user role associated with your studio. */
    AWSDeadlineCloudUserAccessJobs() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeadlineCloudUserAccessJobs);
    }
    /** Provides user workstation access to AWS Deadline Cloud queues with limited Read-Only permissions to call other necessary services. Attach this policy to the user role associated with your studio. */
    AWSDeadlineCloudUserAccessQueues() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeadlineCloudUserAccessQueues);
    }
    /** Provides access for AWS Deadline Cloud worker hosts to join a fleet in a farm. */
    AWSDeadlineCloudWorkerHost() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeadlineCloudWorkerHost);
    }
    /** This policy specifies permissions required by DeepLens Administrative lambda functions that run on a DeepLens device */
    AWSDeepLensLambdaFunctionAccessPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeepLensLambdaFunctionAccessPolicy);
    }
    /** Grants AWS DeepLens access to AWS Services, resources and roles needed by DeepLens and its dependencies including IoT, S3, GreenGrass and AWS Lambda. */
    AWSDeepLensServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeepLensServiceRolePolicy);
    }
    /** DeepRacer admin access to all actions including toggling between multiuser and single user mode. */
    AWSDeepRacerAccountAdminAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeepRacerAccountAdminAccess);
    }
    /** Allows CloudFormation to create and manage AWS stacks and resources on your behalf. */
    AWSDeepRacerCloudFormationAccessPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeepRacerCloudFormationAccessPolicy);
    }
    /** DeepRacer MultiUser Default user access to use deepracer in multi-user mode */
    AWSDeepRacerDefaultMultiUserAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeepRacerDefaultMultiUserAccess);
    }
    /** Provides full access to AWS DeepRacer. Also provides select access to related services (e.g., S3). */
    AWSDeepRacerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeepRacerFullAccess);
    }
    /** Allows RoboMaker to create required resources and call AWS services on your behalf. */
    AWSDeepRacerRoboMakerAccessPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeepRacerRoboMakerAccessPolicy);
    }
    /** Allows DeepRacer to create required resources and call AWS services on your behalf. */
    AWSDeepRacerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeepRacerServiceRolePolicy);
    }
    /** Deny all access. */
    AWSDenyAll() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDenyAll);
    }
    /** Provides full access to all AWS Device Farm operations. */
    AWSDeviceFarmFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeviceFarmFullAccess);
    }
    /** Grant permissions to AWS Device Farm to call EC2 Network APIs on your behalf. */
    AWSDeviceFarmServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeviceFarmServiceRolePolicy);
    }
    /** Grant permissions to AWS Device Farm to call EC2 APIs on your behalf. */
    AWSDeviceFarmTestGridServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDeviceFarmTestGridServiceRolePolicy);
    }
    /** Provides full access to AWS Direct Connect via the AWS Management Console. */
    AWSDirectConnectFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDirectConnectFullAccess);
    }
    /** Provides read only access to AWS Direct Connect via the AWS Management Console. */
    AWSDirectConnectReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDirectConnectReadOnlyAccess);
    }
    /** Provides AWS Direct Connect permission to create and manage AWS resources on your behalf. */
    AWSDirectConnectServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDirectConnectServiceRolePolicy);
    }
    /** Provides full access to AWS Directory Service Data. */
    AWSDirectoryServiceDataFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDirectoryServiceDataFullAccess);
    }
    /** Provides read-only access to AWS Directory Service Data */
    AWSDirectoryServiceDataReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDirectoryServiceDataReadOnlyAccess);
    }
    /** Provides full access to AWS Directory Service. */
    AWSDirectoryServiceFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDirectoryServiceFullAccess);
    }
    /** Provides read only access to AWS Directory Service. */
    AWSDirectoryServiceReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDirectoryServiceReadOnlyAccess);
    }
    /** Policy for the Directory Service Service Linked Role */
    AWSDirectoryServiceServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDirectoryServiceServiceRolePolicy);
    }
    /** Provides write access to AWS resources required for AWS Discovery Continuous Export */
    AWSDiscoveryContinuousExportFirehosePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDiscoveryContinuousExportFirehosePolicy);
    }
    /** Allows DMS Fleet Advisor to manage CloudWatch metrics on your behalf. */
    AWSDMSFleetAdvisorServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDMSFleetAdvisorServiceRolePolicy);
    }
    /** Grants AWS DMS Serverless permissions to create and manage DMS resources in your account on your behalf */
    AWSDMSServerlessServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSDMSServerlessServiceRolePolicy);
    }
    /** Allows EC2 CapacityReservation Fleet service to manage Capacity Reservations */
    AWSEC2CapacityReservationFleetRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSEC2CapacityReservationFleetRolePolicy);
    }
    /** Allows EC2 Fleet to launch and manage instances. */
    AWSEC2FleetServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSEC2FleetServiceRolePolicy);
    }
    /** Allows EC2 Spot Fleet to launch and manage spot fleet instances */
    AWSEC2SpotFleetServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSEC2SpotFleetServiceRolePolicy);
    }
    /** Allows EC2 Spot to launch and manage spot instances */
    AWSEC2SpotServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSEC2SpotServiceRolePolicy);
    }
    /** This policy is attached to the IAM role that's attached to your Amazon EC2 Windows Instances to enable the Amazon EC2 VSS solution to create and add tags to Amazon Machine Images (AMI) and EBS Snapshots. */
    AWSEC2VssSnapshotPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSEC2VssSnapshotPolicy);
    }
    /** Enables access to AWS services and resources used or managed by AWS ECR pull through cache */
    AWSECRPullThroughCacheServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSECRPullThroughCacheServiceRolePolicy);
    }
    /** Provide the instance in your custom platform builder environment permission to launch EC2 instance, create EBS snapshot and AMI, stream logs to Amazon CloudWatch Logs, and store artifacts in Amazon S3. */
    AWSElasticBeanstalkCustomPlatformforEC2Role() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkCustomPlatformforEC2Role);
    }
    /** AWS Elastic Beanstalk Service policy for Health Monitoring system */
    AWSElasticBeanstalkEnhancedHealth() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkEnhancedHealth);
    }
    /** AWS Elastic Beanstalk Service Role policy that grants limited permissions to update your resources on your behalf for maintenance purposes. */
    AWSElasticBeanstalkMaintenance() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkMaintenance);
    }
    /** This policy is for the AWS Elastic Beanstalk service role used to perform managed updates of Elastic Beanstalk environments. This policy should not be attached to other users or roles. The policy grants broad permissions to create and manage resources across a number of AWS services including AutoScaling, EC2, ECS, Elastic Load Balancing and CloudFormation.  This policy also allows passing of any IAM role usable with those services. */
    AWSElasticBeanstalkManagedUpdatesCustomerRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkManagedUpdatesCustomerRolePolicy);
    }
    /** AWS Elastic Beanstalk Service Role policy that grants limited permissions to managed updates. */
    AWSElasticBeanstalkManagedUpdatesServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkManagedUpdatesServiceRolePolicy);
    }
    /** Provide the instances in your multicontainer Docker environment access to use the Amazon EC2 Container Service to manage container deployment tasks. */
    AWSElasticBeanstalkMulticontainerDocker() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkMulticontainerDocker);
    }
    /** Grants read-only permissions. Explicitly allows operators to gain direct access to retrieve information about resources related to AWS Elastic Beanstalk applications. */
    AWSElasticBeanstalkReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkReadOnly);
    }
    /** AWSElasticBeanstalkRoleCore (Elastic Beanstalk operations role) Allows core operation of a web service environment. */
    AWSElasticBeanstalkRoleCore() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkRoleCore);
    }
    /** (Elastic Beanstalk operations role) Allows an environment to manage Amazon CloudWatch Logs log groups. */
    AWSElasticBeanstalkRoleCWL() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkRoleCWL);
    }
    /** (Elastic Beanstalk operations role) Allows a multicontainer Docker environment to manage Amazon ECS clusters. */
    AWSElasticBeanstalkRoleECS() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkRoleECS);
    }
    /** (Elastic Beanstalk operations role) Allows an environment to integrate an Amazon RDS instance. */
    AWSElasticBeanstalkRoleRDS() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkRoleRDS);
    }
    /** (Elastic Beanstalk operations role) Allows an environment to enable Amazon SNS topic integration. */
    AWSElasticBeanstalkRoleSNS() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkRoleSNS);
    }
    /** (Elastic Beanstalk operations role) Allows a worker environment tier to create an Amazon DynamoDB table and an Amazon SQS queue. */
    AWSElasticBeanstalkRoleWorkerTier() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkRoleWorkerTier);
    }
    /** This policy is on a deprecation path. See documentation for guidance: https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-servicerole.html. AWS Elastic Beanstalk Service role policy which grants permissions to create & manage resources (i.e.: AutoScaling, EC2, S3, CloudFormation, ELB, etc.) on your behalf. */
    AWSElasticBeanstalkService() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkService);
    }
    /** AWS Elastic Beanstalk Service Linked Role policy which grants permissions to create & manage resources (i.e.: AutoScaling, EC2, S3, CloudFormation, ELB, etc.) on your behalf. */
    AWSElasticBeanstalkServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkServiceRolePolicy);
    }
    /** Provide the instances in your web server environment access to upload log files to Amazon S3. */
    AWSElasticBeanstalkWebTier() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkWebTier);
    }
    /** Provide the instances in your worker environment access to upload log files to Amazon S3, to use Amazon SQS to monitor your application's job queue, to use Amazon DynamoDB to perform leader election, and to Amazon CloudWatch to publish metrics for health monitoring. */
    AWSElasticBeanstalkWorkerTier() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticBeanstalkWorkerTier);
    }
    /** This policy allows installing the AWS Replication Agent, which is used with AWS Elastic Disaster Recovery (DRS) to recover external servers to AWS. Attach this policy to your IAM users or roles whose credentials you provide during the installation step of the AWS Replication Agent. */
    AWSElasticDisasterRecoveryAgentInstallationPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryAgentInstallationPolicy);
    }
    /** This policy allows using the AWS Replication Agent, which is used with AWS Elastic Disaster Recovery (DRS) to recover source servers to AWS. We do not recommend that you attach this policy to your IAM users or roles. */
    AWSElasticDisasterRecoveryAgentPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryAgentPolicy);
    }
    /** This policy provides full access to all public APIs of AWS Elastic Disaster Recovery (DRS), as well as permissions to read KMS key, License Manager, Resource Groups, Elastic Load Balancing, IAM, and EC2 information. Attach this policy to your IAM users or roles. */
    AWSElasticDisasterRecoveryConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryConsoleFullAccess);
    }
    /** This policy provides full access to all public APIs of AWS Elastic Disaster Recovery (AWS DRS), as well as all public APIs in other AWS services used by AWS DRS Console. Attach this policy to your users or roles. */
    AWSElasticDisasterRecoveryConsoleFullAccessV2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryConsoleFullAccessV2);
    }
    /** This policy is attached to the AWS Elastic Disaster Recovery Conversion server's instance role. This policy allows Elastic Disaster Recovery (DRS) Conversion Servers, which are EC2 instances launched by Elastic Disaster Recovery, to communicate with the DRS service. An IAM role with this policy is attached (as an EC2 Instance Profile) by DRS to the DRS Conversion Servers, which are automatically launched and terminated by DRS, when needed. We do not recommend that you attach this policy to your IAM users or roles. DRS Conversion Servers are used by Elastic Disaster Recovery when users choose to recover source servers using the DRS console, CLI, or API. */
    AWSElasticDisasterRecoveryConversionServerPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryConversionServerPolicy);
    }
    /** This policy allows AWS Elastic Disaster Recovery (DRS) to support cross-account replication and cross-account failback. */
    AWSElasticDisasterRecoveryCrossAccountReplicationPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryCrossAccountReplicationPolicy);
    }
    /** This policy allows installing and using the AWS Replication Agent, which is used by AWS Elastic Disaster Recovery (DRS) to recover source servers that run on EC2 (cross-region or cross-AZ). An IAM role with this policy should be attached (as an EC2 Instance Profile) to the EC2 Instances. */
    AWSElasticDisasterRecoveryEc2InstancePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryEc2InstancePolicy);
    }
    /** You can attach the AWSElasticDisasterRecoveryFailbackInstallationPolicy policy to your IAM identities.  This policy allows installing the Elastic Disaster Recovery Failback Client, which is used to failback Recovery Instances back to your original source infrastructure. Attach this policy to your IAM users or roles whose credentials you provide when running the Elastic Disaster Recovery Failback Client. */
    AWSElasticDisasterRecoveryFailbackInstallationPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryFailbackInstallationPolicy);
    }
    /** This policy allows using the Elastic Disaster Recovery Failback Client, which is used to failback Recovery Instances back to your original source infrastructure. We do not recommend that you attach this policy to your IAM users or roles. */
    AWSElasticDisasterRecoveryFailbackPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryFailbackPolicy);
    }
    /** This policy allows you to use Amazon SSM and additional services required permissions to run post-launch actions in AWS Elastic Disaster Recovery (AWS DRS). Attach this policy to your IAM roles or users. */
    AWSElasticDisasterRecoveryLaunchActionsPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryLaunchActionsPolicy);
    }
    /** This policy allows AWS Elastic Disaster Recovery (DRS) to support network replication. */
    AWSElasticDisasterRecoveryNetworkReplicationPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryNetworkReplicationPolicy);
    }
    /** You can attach the AWSElasticDisasterRecoveryReadOnlyAccess policy to your IAM identities.  This policy provides permissions to all read-only public APIs of Elastic Disaster Recovery (DRS), as well as some read-only APIs of other AWS services that are required in order to make full read-only use of the DRS console. Attach this policy to your IAM users or roles. */
    AWSElasticDisasterRecoveryReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryReadOnlyAccess);
    }
    /** This policy is attached to the instance role of Elastic Disaster Recovery's Recovery Instance.  This policy allows the Elastic Disaster Recovery (DRS) Recovery Instance, which are EC2 instances launched by Elastic Disaster Recovery - to communicate with the DRS service, and to be able to failback to their original source infrastructure. An IAM role with this policy is attached (as an EC2 Instance Profile) by Elastic Disaster Recovery to the DRS Recovery Instances. We do not recommend that you attach this policy to your IAM users or roles. */
    AWSElasticDisasterRecoveryRecoveryInstancePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryRecoveryInstancePolicy);
    }
    /** This policy is attached to the Elastic Disaster Recovery Replication server's instance role. This policy allows the Elastic Disaster Recovery (DRS) Replication Servers, which are EC2 instances launched by Elastic Disaster Recovery - to communicate with the DRS service, and to create EBS snapshots in your AWS account. An IAM role with this policy is attached (as an EC2 Instance Profile) by Elastic Disaster Recovery to the DRS Replication Servers which are automatically launched and terminated by DRS, as needed. DRS Replication Servers are used to facilitate data replication from your external servers to AWS, as part of the recovery process managed by DRS. We do not recommend that you attach this policy to your IAM users or roles. */
    AWSElasticDisasterRecoveryReplicationServerPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryReplicationServerPolicy);
    }
    /** This policy allows Elastic Disaster Recovery to manage AWS resources on your behalf. */
    AWSElasticDisasterRecoveryServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryServiceRolePolicy);
    }
    /** This policy allows read-only access to AWS Elastic Disaster Recovery (DRS) resources such as source servers and jobs. It also allows creating a converted snapshot and sharing that EBS snapshot with a specific account. */
    AWSElasticDisasterRecoveryStagingAccountPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryStagingAccountPolicy);
    }
    /** This policy is used by AWS Elastic Disaster Recovery (DRS) to recover source servers into a separate target account and to allow failing back. We do not recommend that you attach this policy to your IAM users or roles. */
    AWSElasticDisasterRecoveryStagingAccountPolicyV2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticDisasterRecoveryStagingAccountPolicyV2);
    }
    /** Service Linked Role Policy for AWS Elastic Load Balancing Control Plane - Classic */
    AWSElasticLoadBalancingClassicServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticLoadBalancingClassicServiceRolePolicy);
    }
    /** Service Linked Role Policy for AWS Elastic Load Balancing Control Plane */
    AWSElasticLoadBalancingServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElasticLoadBalancingServiceRolePolicy);
    }
    /** Provides full access to AWS Elemental MediaConnect resources. */
    AWSElementalMediaConnectFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaConnectFullAccess);
    }
    /** Provides read-only access to AWS Elemental MediaConnect resources. */
    AWSElementalMediaConnectReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaConnectReadOnlyAccess);
    }
    /** Provides full access to AWS Elemental MediaConvert via the AWS Management Console and SDK. */
    AWSElementalMediaConvertFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaConvertFullAccess);
    }
    /** Provides read only access to AWS Elemental MediaConvert via the AWS Management Console and SDK. */
    AWSElementalMediaConvertReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaConvertReadOnly);
    }
    /** Provides full access to AWS Elemental MediaLive resources */
    AWSElementalMediaLiveFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaLiveFullAccess);
    }
    /** Provides read only access to AWS Elemental MediaLive resources */
    AWSElementalMediaLiveReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaLiveReadOnly);
    }
    /** Provides full access to AWS Elemental MediaPackage resources */
    AWSElementalMediaPackageFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaPackageFullAccess);
    }
    /** Provides read only access to AWS Elemental MediaPackage resources */
    AWSElementalMediaPackageReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaPackageReadOnly);
    }
    /** Provides full access to AWS Elemental MediaPackageV2 resources. */
    AWSElementalMediaPackageV2FullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaPackageV2FullAccess);
    }
    /** Provides read-only access to AWS Elemental MediaPackageV2 resources. */
    AWSElementalMediaPackageV2ReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaPackageV2ReadOnly);
    }
    /** Provides full read and write access to all MediaStore APIs */
    AWSElementalMediaStoreFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaStoreFullAccess);
    }
    /** Provides read-only permissions for MediaStore APIs */
    AWSElementalMediaStoreReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaStoreReadOnly);
    }
    /** Provides full access to AWS Elemental MediaTailor resources */
    AWSElementalMediaTailorFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaTailorFullAccess);
    }
    /** Provides read only access to AWS Elemental MediaTailor resources */
    AWSElementalMediaTailorReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSElementalMediaTailorReadOnly);
    }
    /** Policy to enable enhanced classic networking management feature. */
    AWSEnhancedClassicNetworkingMangementPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSEnhancedClassicNetworkingMangementPolicy);
    }
    /** Provides console full access to AWS Entity Resolution and related services. */
    AWSEntityResolutionConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSEntityResolutionConsoleFullAccess);
    }
    /** Provides read-only access to AWS Entity Resolution via the AWS Management Console. */
    AWSEntityResolutionConsoleReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSEntityResolutionConsoleReadOnlyAccess);
    }
    /** This policy grants the Fault Injection Simulator Service permission in EC2 and other required services to perform FIS actions. */
    AWSFaultInjectionSimulatorEC2Access() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSFaultInjectionSimulatorEC2Access);
    }
    /** This policy grants the Fault Injection Simulator Service permission in ECS and other required services to perform FIS actions. */
    AWSFaultInjectionSimulatorECSAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSFaultInjectionSimulatorECSAccess);
    }
    /** This policy grants the Fault Injection Simulator Service permission in EKS and other required services to perform FIS actions. */
    AWSFaultInjectionSimulatorEKSAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSFaultInjectionSimulatorEKSAccess);
    }
    /** This policy grants the Fault Injection Simulator Service permission in EC2 networking and other required services to perform FIS actions. */
    AWSFaultInjectionSimulatorNetworkAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSFaultInjectionSimulatorNetworkAccess);
    }
    /** This policy grants the Fault Injection Simulator Service permission in RDS and other required services to perform FIS actions. */
    AWSFaultInjectionSimulatorRDSAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSFaultInjectionSimulatorRDSAccess);
    }
    /** This policy grants the Fault Injection Simulator Service permission in SSM and other required services to perform FIS actions. */
    AWSFaultInjectionSimulatorSSMAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSFaultInjectionSimulatorSSMAccess);
    }
    /** Policy to enable access to AWS Service and Resources used or managed by Amazon FinSpace */
    AWSFinSpaceServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSFinSpaceServiceRolePolicy);
    }
    /** Full access for AWS FM Administrator */
    AWSFMAdminFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSFMAdminFullAccess);
    }
    /** Read only access for AWS FM Administrator that allows monitoring AWS FM operations */
    AWSFMAdminReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSFMAdminReadOnlyAccess);
    }
    /** Provides read only access to AWS WAF actions for AWS Firewall Manager member accounts */
    AWSFMMemberReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSFMMemberReadOnlyAccess);
    }
    /** Managed policy for AWS For Wordpress Plugin */
    AWSForWordPressPluginPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSForWordPressPluginPolicy);
    }
    /** Policy which allows AWS Code Connections to sync content from your git repository */
    AWSGitSyncServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGitSyncServiceRolePolicy);
    }
    /** Policy granting permissions to AWS Global Accelerator to manage EC2 Elastic Network Interfaces and Security Groups. */
    AWSGlobalAcceleratorSLRPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGlobalAcceleratorSLRPolicy);
    }
    /** Provides full access to AWS Glue via the AWS Management Console */
    AWSGlueConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGlueConsoleFullAccess);
    }
    /** Provides full access to AWS Glue via the AWS Management Console and access to sagemaker notebook instances. */
    AWSGlueConsoleSageMakerNotebookFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGlueConsoleSageMakerNotebookFullAccess);
    }
    /** Provides full access to AWS Glue DataBrew via the AWS Management Console. Also provides select access to related services (e.g., S3, KMS, Glue). */
    AwsGlueDataBrewFullAccessPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AwsGlueDataBrewFullAccessPolicy);
    }
    /** This policy grants permission to glue to perform action on user's glue data catalog, this policy also provides permission to ec2 actions to allow glue to create ENI to connect to resources in the VPC, also allow glue to access registered data in lakeformation and permission to access user's cloudwatch */
    AWSGlueDataBrewServiceRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGlueDataBrewServiceRole);
    }
    /** Provides full access to the AWS Glue Schema Registry Service */
    AWSGlueSchemaRegistryFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGlueSchemaRegistryFullAccess);
    }
    /** Provides readonly access to the AWS Glue Schema Registry Service */
    AWSGlueSchemaRegistryReadonlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGlueSchemaRegistryReadonlyAccess);
    }
    /** Policy for AWS Glue service role which allows customer to manage notebook server */
    AWSGlueServiceNotebookRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGlueServiceNotebookRole);
    }
    /** Policy for AWS Glue service role which allows access to related services including EC2, S3, and Cloudwatch Logs */
    AWSGlueServiceRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGlueServiceRole);
    }
    /** Provides permissions that allows users to create and use only the notebook sessions that are associated with the user. This policy also includes permissions to explicitly allow users to pass a restricted Glue session role. */
    AwsGlueSessionUserRestrictedNotebookPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AwsGlueSessionUserRestrictedNotebookPolicy);
    }
    /** Provides full access to all AWS Glue resources except for sessions. Allows users to create and use only the notebook sessions that are associated with the user. This policy also includes other permissions needed by AWS Glue to manage Glue resources in other AWS services. */
    AwsGlueSessionUserRestrictedNotebookServiceRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AwsGlueSessionUserRestrictedNotebookServiceRole);
    }
    /** Provides permissions that allows users to create and use only the interactive sessions that are associated with the user. This policy also includes permissions to explicitly allow users to pass a restricted Glue session role. */
    AwsGlueSessionUserRestrictedPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AwsGlueSessionUserRestrictedPolicy);
    }
    /** Provides full access to all AWS Glue resources except for sessions. Allows users to create and use only the interactive sessions that are associated with the user. This policy also includes other permissions needed by AWS Glue to manage Glue resources in other AWS services */
    AwsGlueSessionUserRestrictedServiceRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AwsGlueSessionUserRestrictedServiceRole);
    }
    /** Provides access within Amazon Grafana to create and manage workspaces for the entire organization. */
    AWSGrafanaAccountAdministrator() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGrafanaAccountAdministrator);
    }
    /** Access to read only operations in Amazon Grafana. */
    AWSGrafanaConsoleReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGrafanaConsoleReadOnlyAccess);
    }
    /** Provides only the ability to update user and group permissions for AWS Grafana workspaces. */
    AWSGrafanaWorkspacePermissionManagement() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGrafanaWorkspacePermissionManagement);
    }
    /** Provides ability to update IAM Identity Center (IdC) user and group permissions for Amazon Managed Grafana workspaces. */
    AWSGrafanaWorkspacePermissionManagementV2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGrafanaWorkspacePermissionManagementV2);
    }
    /** This policy gives full access to the AWS Greengrass configuration, management and deployment actions */
    AWSGreengrassFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGreengrassFullAccess);
    }
    /** This policy gives read only access to the AWS Greengrass configuration, management and deployment actions */
    AWSGreengrassReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGreengrassReadOnlyAccess);
    }
    /** Policy for AWS Greengrass service role which allows access to related services including AWS Lambda and AWS IoT thing shadows. */
    AWSGreengrassResourceAccessRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGreengrassResourceAccessRolePolicy);
    }
    /** Provides the Dataflow Endpoint Instance permissions to use the AWS Ground Station Agent */
    AWSGroundStationAgentInstancePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSGroundStationAgentInstancePolicy);
    }
    /** Allows AWS Health to enable the Health event processor feature. */
    AWSHealthEventProcessorServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSHealthEventProcessorServiceRolePolicy);
    }
    /** Allows full access to the AWS Health Apis and Notifications and the Personal Health Dashboard */
    AWSHealthFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSHealthFullAccess);
    }
    /** Provides full access to AWS Health Imaging service. */
    AWSHealthImagingFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSHealthImagingFullAccess);
    }
    /** Provides read only access to AWS Health Imaging service. */
    AWSHealthImagingReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSHealthImagingReadOnlyAccess);
    }
    /** Provides the list of actions that are allowed for roles assumed with the IAM Identity Center identity context. AWS Security Token Service (AWS STS) automatically attaches this policy to assumed roles. The identity context is passed as ProvidedContext. */
    AWSIAMIdentityCenterAllowListForIdentityContext() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIAMIdentityCenterAllowListForIdentityContext);
    }
    /** Grants full access to the Identity Sync service */
    AWSIdentitySyncFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIdentitySyncFullAccess);
    }
    /** Read only access to the Identity Sync service */
    AWSIdentitySyncReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIdentitySyncReadOnlyAccess);
    }
    /** Provides full access to all AWS Image Builder actions and resource scoped access to related AWS services. */
    AWSImageBuilderFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSImageBuilderFullAccess);
    }
    /** Provides read only access to all AWS Image Builder actions. */
    AWSImageBuilderReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSImageBuilderReadOnlyAccess);
    }
    /** Provides read and write access to the jobs created under the AWS account. */
    AWSImportExportFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSImportExportFullAccess);
    }
    /** Provides read only access to the jobs created under the AWS account. */
    AWSImportExportReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSImportExportReadOnlyAccess);
    }
    /** Grants Incident Manager permissions to call other AWS services as a part of managing an incident. */
    AWSIncidentManagerIncidentAccessServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIncidentManagerIncidentAccessServiceRolePolicy);
    }
    /** This policy grants permissions to start, view, and update incidents with full access to custom timeline events & related items. Assign this policy to users who will create and resolve incidents. */
    AWSIncidentManagerResolverAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIncidentManagerResolverAccess);
    }
    /** This policy grants Incident Manager permission to manage incident records and related resources on your behalf. */
    AWSIncidentManagerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIncidentManagerServiceRolePolicy);
    }
    /** Provides full access to IoT Analytics. */
    AWSIoTAnalyticsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTAnalyticsFullAccess);
    }
    /** Provides read only access to IoT Analytics. */
    AWSIoTAnalyticsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTAnalyticsReadOnlyAccess);
    }
    /** This policy gives full access to the AWS IoT configuration actions */
    AWSIoTConfigAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTConfigAccess);
    }
    /** This policy gives read only access to the AWS IoT configuration actions */
    AWSIoTConfigReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTConfigReadOnlyAccess);
    }
    /** This policy gives full access to the AWS IoT messaging actions */
    AWSIoTDataAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTDataAccess);
    }
    /** Provides write access to IoT thing groups and read access to IoT Certificates for execution of ADD_THINGS_TO_THING_GROUP mitigation action */
    AWSIoTDeviceDefenderAddThingsToThingGroupMitigationAction() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTDeviceDefenderAddThingsToThingGroupMitigationAction);
    }
    /** Provides read access for IoT and related resources */
    AWSIoTDeviceDefenderAudit() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTDeviceDefenderAudit);
    }
    /** Provides access for enabling IoT logging for execution of ENABLE_IOT_LOGGING mitigation action */
    AWSIoTDeviceDefenderEnableIoTLoggingMitigationAction() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTDeviceDefenderEnableIoTLoggingMitigationAction);
    }
    /** Provides messages publish access to SNS topic for execution of PUBLISH_FINDING_TO_SNS mitigation action */
    AWSIoTDeviceDefenderPublishFindingsToSNSMitigationAction() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTDeviceDefenderPublishFindingsToSNSMitigationAction);
    }
    /** Provides write access to IoT policies for execution of REPLACE_DEFAULT_POLICY_VERSION mitigation action */
    AWSIoTDeviceDefenderReplaceDefaultPolicyMitigationAction() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTDeviceDefenderReplaceDefaultPolicyMitigationAction);
    }
    /** Provides write access to IoT CA certificates for execution of  UPDATE_CA_CERTIFICATE mitigation action */
    AWSIoTDeviceDefenderUpdateCACertMitigationAction() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTDeviceDefenderUpdateCACertMitigationAction);
    }
    /** Provides write access to IoT certificates for execution of UPDATE_DEVICE_CERTIFICATE mitigation action */
    AWSIoTDeviceDefenderUpdateDeviceCertMitigationAction() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTDeviceDefenderUpdateDeviceCertMitigationAction);
    }
    /** Allows AWS IoT Device Tester to run the FreeRTOS qualification suite by allowing access to services including IoT, S3, and IAM */
    AWSIoTDeviceTesterForFreeRTOSFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTDeviceTesterForFreeRTOSFullAccess);
    }
    /** Allows AWS IoT Device Tester to run the AWS Greengrass qualification suite by allowing access to related services including Lambda, IoT, API Gateway, IAM */
    AWSIoTDeviceTesterForGreengrassFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTDeviceTesterForGreengrassFullAccess);
    }
    /** Provides full access to IoT Events. */
    AWSIoTEventsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTEventsFullAccess);
    }
    /** Provides read only access to IoT Events. */
    AWSIoTEventsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTEventsReadOnlyAccess);
    }
    /** Federation access for IoT Fleet Hub applications */
    AWSIoTFleetHubFederationAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTFleetHubFederationAccess);
    }
    /** Grants permissions to AWS Resources and metaData used or managed by AWSIoTFleetwise for auxiliary features */
    AWSIoTFleetwiseServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTFleetwiseServiceRolePolicy);
    }
    /** This policy gives full access to the AWS IoT configuration and messaging actions */
    AWSIoTFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTFullAccess);
    }
    /** Allows creation of Amazon CloudWatch Log groups and streaming logs to the groups */
    AWSIoTLogging() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTLogging);
    }
    /** Provides full access to managed integrations for AWS IoT Device Management and related services. */
    AWSIoTManagedIntegrationsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTManagedIntegrationsFullAccess);
    }
    /** Provides managed integrations for AWS IoT Device Management permission to publish logs and metrics on your behalf. */
    AWSIoTManagedIntegrationsRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTManagedIntegrationsRolePolicy);
    }
    /** Allows access to create AWS IoT Job and describe the AWS code signer job */
    AWSIoTOTAUpdate() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTOTAUpdate);
    }
    /** Allows access to all AWS services supported in AWS IoT Rule Actions */
    AWSIoTRuleActions() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTRuleActions);
    }
    /** Provides full access to manage AWS IoT SiteWise using the AWS Management Console. Note this policy also grants access to create and list data stores used with AWS IoT SiteWise (e.g. AWS IoT Analytics), access to list and view AWS IoT Greengrass resources, list and modify AWS Secrets Manager secrets, retrieve AWS IoT thing shadows, list resources with specific tags, and create and use a service-linked role for AWS IoT SiteWise. */
    AWSIoTSiteWiseConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTSiteWiseConsoleFullAccess);
    }
    /** Provides full access to IoT SiteWise. */
    AWSIoTSiteWiseFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTSiteWiseFullAccess);
    }
    /** This policy grants permissions to access AWS IoT SiteWise assets and asset data, create AWS IoT SiteWise Monitor resources, and list AWS SSO users. */
    AWSIoTSiteWiseMonitorPortalAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTSiteWiseMonitorPortalAccess);
    }
    /** This role grants AWS IoT SiteWise monitor permissions to access your AWS IoT SiteWise assets & asset properties, and create AWS IoT Sitewise projects, dashboards & access policies through AWS IoT SiteWise portals. */
    AWSIoTSiteWiseMonitorServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTSiteWiseMonitorServiceRolePolicy);
    }
    /** Provides read only access to IoT SiteWise. */
    AWSIoTSiteWiseReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTSiteWiseReadOnlyAccess);
    }
    /** This policy allows users to register things at bulk using AWS IoT StartThingRegistrationTask API */
    AWSIoTThingsRegistration() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTThingsRegistration);
    }
    /** Allows AWS IoT TwinMaker to call other AWS services and to sync their resources on your behalf. */
    AWSIoTTwinMakerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTTwinMakerServiceRolePolicy);
    }
    /** Allows the associated identity data access to AWS IoT Wireless devices. */
    AWSIoTWirelessDataAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTWirelessDataAccess);
    }
    /** Allows the associated identity full access to all AWS IoT Wireless operations. */
    AWSIoTWirelessFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTWirelessFullAccess);
    }
    /** Provides IoT Wireless full access to publish to IoT Rules Engine on your behalf. */
    AWSIoTWirelessFullPublishAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTWirelessFullPublishAccess);
    }
    /** Allows the associated identity access to create, list and describe IoT Certificates */
    AWSIoTWirelessGatewayCertManager() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTWirelessGatewayCertManager);
    }
    /** Allows the associated identity to create Amazon CloudWatch Logs groups and stream logs to the groups. */
    AWSIoTWirelessLogging() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTWirelessLogging);
    }
    /** Allows the associated identity read only access to AWS IoT wireless. */
    AWSIoTWirelessReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIoTWirelessReadOnlyAccess);
    }
    /** Allows VPC IP Address Manager to access VPC resources and integrate with AWS Organizations on your behalf. */
    AWSIPAMServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIPAMServiceRolePolicy);
    }
    /** Used by AWS IQ to execute payment requests on behalf of a customer */
    AWSIQContractServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIQContractServiceRolePolicy);
    }
    /** Provides full access to AWS IQ */
    AWSIQFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIQFullAccess);
    }
    /** Allows AWS IQ to manage the role assumed by AWS IQ experts. */
    AWSIQPermissionServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSIQPermissionServiceRolePolicy);
    }
    /** Enables access to AWS services and resources required for AWS KMS custom key stores */
    AWSKeyManagementServiceCustomKeyStoresServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSKeyManagementServiceCustomKeyStoresServiceRolePolicy);
    }
    /** Enables AWS KMS to synchronize the shared properties of multi-Region keys. */
    AWSKeyManagementServiceMultiRegionKeysServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSKeyManagementServiceMultiRegionKeysServiceRolePolicy);
    }
    /** Provides access to AWS Key Management Service (KMS). */
    AWSKeyManagementServicePowerUser() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSKeyManagementServicePowerUser);
    }
    /** Provides cross account access to Glue resources via Lake Formation. Also grants read access to other required services such as organizations and resource access manager */
    AWSLakeFormationCrossAccountManager() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLakeFormationCrossAccountManager);
    }
    /** Grants administrative access to AWS Lake Formation and related services, such as AWS Glue, to manage data lakes */
    AWSLakeFormationDataAdmin() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLakeFormationDataAdmin);
    }
    /** Grants full access to AWS Lambda service, AWS Lambda console features, and other related AWS services. */
    AWSLambdaFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLambdaFullAccess);
    }
    /** Grants read-only access to AWS Lambda service, AWS Lambda console features, and other related AWS services. */
    AWSLambdaReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLambdaReadOnlyAccess);
    }
    /** Provides write permissions to CloudWatch Logs. */
    AWSLambdaBasicExecutionRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLambdaBasicExecutionRole);
    }
    /** Provides list and read access to DynamoDB streams and write permissions to CloudWatch logs. */
    AWSLambdaDynamoDBExecutionRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLambdaDynamoDBExecutionRole);
    }
    /** Provides minimum permissions for a Lambda function to manage ENIs (create, describe, delete) used by a VPC-enabled Lambda Function. */
    AWSLambdaENIManagementAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLambdaENIManagementAccess);
    }
    /** Provides Put, Get access to S3 and full access to CloudWatch Logs. */
    AWSLambdaExecute() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLambdaExecute);
    }
    /** Provides read access to DynamoDB Streams. */
    AWSLambdaInvocationDynamoDB() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLambdaInvocationDynamoDB);
    }
    /** Provides list and read access to Kinesis streams and write permissions to CloudWatch logs. */
    AWSLambdaKinesisExecutionRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLambdaKinesisExecutionRole);
    }
    /** Provides permissions required to access MSK Cluster within a VPC, manage ENIs (create, describe, delete) in the VPC and write permissions to CloudWatch Logs. */
    AWSLambdaMSKExecutionRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLambdaMSKExecutionRole);
    }
    /** Grants Lambda Replicator necessary permissions to replicate functions across regions */
    AWSLambdaReplicator() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLambdaReplicator);
    }
    /** Default policy for AWS Lambda service role. */
    AWSLambdaRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLambdaRole);
    }
    /** Provides receive message, delete message, and read attribute access to SQS queues, and write permissions to CloudWatch logs. */
    AWSLambdaSQSQueueExecutionRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLambdaSQSQueueExecutionRole);
    }
    /** Provides minimum permissions for a Lambda function to execute while accessing a resource within a VPC - create, describe, delete network interfaces and write permissions to CloudWatch Logs. */
    AWSLambdaVPCAccessExecutionRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLambdaVPCAccessExecutionRole);
    }
    /** Provides permissions to allow access to the AWS License Manager API actions required to consume upon licenses that the user has entitlements. */
    AWSLicenseManagerConsumptionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLicenseManagerConsumptionPolicy);
    }
    /** Allows AWS License Manager Linux Subscriptions Service to manage resources on your behalf. */
    AWSLicenseManagerLinuxSubscriptionsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLicenseManagerLinuxSubscriptionsServiceRolePolicy);
    }
    /** AWS License Manager service master account role policy */
    AWSLicenseManagerMasterAccountRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLicenseManagerMasterAccountRolePolicy);
    }
    /** AWS License Manager service member account role policy */
    AWSLicenseManagerMemberAccountRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLicenseManagerMemberAccountRolePolicy);
    }
    /** AWS License Manager service default role policy */
    AWSLicenseManagerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLicenseManagerServiceRolePolicy);
    }
    /** Allows AWS License Manager User Subscriptions Service to manage resources on your behalf. */
    AWSLicenseManagerUserSubscriptionsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSLicenseManagerUserSubscriptionsServiceRolePolicy);
    }
    /** Allows AWS M2 to manage AWS resources on your behalf. */
    AWSM2ServicePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSM2ServicePolicy);
    }
    /** Allows AWS Managed Services to read the values of the tags on AWS resources */
    AWSManagedServicesContactsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSManagedServicesContactsServiceRolePolicy);
    }
    /** AWS Managed Services - policy to manage detective controls infrastructure */
    AWSManagedServicesDetectiveControlsConfigServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSManagedServicesDetectiveControlsConfigServiceRolePolicy);
    }
    /** AWS Managed Services policy to enable AMS event processor feature. */
    AWSManagedServicesEventsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSManagedServicesEventsServiceRolePolicy);
    }
    /** Allows Amazon's AWS Managed Service's Self Service Reporting feature to read AWS Organization data on your behalf to enable organization level aggregated reporting */
    AWSManagedServicesSelfServiceReportingServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSManagedServicesSelfServiceReportingServiceRolePolicy);
    }
    /** Allows AWS Managed Services to manage deployment toolkit on your behalf. */
    AWSManagedServicesDeploymentToolkitPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSManagedServicesDeploymentToolkitPolicy);
    }
    /** Provides full access to configure and customize the AWS Management Console */
    AWSManagementConsoleAdministratorAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSManagementConsoleAdministratorAccess);
    }
    /** Grants access to essential AWS Management Console features and user experience (UX) capabilities for non-administrative users. */
    AWSManagementConsoleBasicUserAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSManagementConsoleBasicUserAccess);
    }
    /** Allows AWS Marketplace to copy your Amazon Machine Images (AMIs) in order to list them on AWS Marketplace */
    AWSMarketplaceAmiIngestion() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceAmiIngestion);
    }
    /** Allows AWS Marketplace to create and manage seller deployment parameters for the products that you subscribe to on AWS Marketplace. */
    AWSMarketplaceDeploymentServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceDeploymentServiceRolePolicy);
    }
    /** Provides the ability to subscribe and unsubscribe to AWS Marketplace software, allows users to manage Marketplace software instances from the Marketplace 'Your Software' page, and provides administrative access to EC2. */
    AWSMarketplaceFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceFullAccess);
    }
    /** Provides read access to AWS Marketplace Entitlements */
    AWSMarketplaceGetEntitlements() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceGetEntitlements);
    }
    /** Enables access to AWS Services and Resources used or managed by AWS Marketplace for license management. */
    AWSMarketplaceLicenseManagementServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceLicenseManagementServiceRolePolicy);
    }
    /** Provides the ability to subscribe and unsubscribe to AWS Marketplace software */
    AWSMarketplaceManageSubscriptions() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceManageSubscriptions);
    }
    /** Provides full access to AWS Marketplace Metering. */
    AWSMarketplaceMeteringFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceMeteringFullAccess);
    }
    /** Provides permissions to register a resource and track usage through AWS Marketplace Metering Service. */
    AWSMarketplaceMeteringRegisterUsage() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceMeteringRegisterUsage);
    }
    /** Provides full access to all administrative actions for an AWS Marketplace eProcurement integration. */
    AWSMarketplaceProcurementSystemAdminFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceProcurementSystemAdminFullAccess);
    }
    /** Enables access for AWS Marketplace services to purchase order management. */
    AWSMarketplacePurchaseOrdersServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplacePurchaseOrdersServiceRolePolicy);
    }
    /** Provides the ability to review AWS Marketplace subscriptions */
    AWSMarketplaceReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceReadOnly);
    }
    /** Enables access to AWS Services and Resources used or managed by AWS Marketplace for Resale Authorization. */
    AWSMarketplaceResaleAuthorizationServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceResaleAuthorizationServiceRolePolicy);
    }
    /** Provides full access to all seller operations on the AWS Marketplace and other AWS services such as AMI management. */
    AWSMarketplaceSellerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceSellerFullAccess);
    }
    /** Provides sellers access to Offers and Agreements management activities. */
    AWSMarketplaceSellerOfferManagement() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceSellerOfferManagement);
    }
    /** Provides sellers full access to AWS Marketplace Management Products page and other AWS services such as AMI management. */
    AWSMarketplaceSellerProductsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceSellerProductsFullAccess);
    }
    /** Provide sellers read-only access to AWS Marketplace Management Products page. */
    AWSMarketplaceSellerProductsReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMarketplaceSellerProductsReadOnly);
    }
    /** The default policy that enables access to AWS Services and Resources used or managed by MediaConnect. */
    AWSMediaConnectServicePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMediaConnectServicePolicy);
    }
    /** Allows MediaLive Anywhere to create and manage AWS resources on your behalf. */
    AWSMediaLiveAnywhereServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMediaLiveAnywhereServiceRolePolicy);
    }
    /** Enable access to AWS Resources used or managed by MediaTailor */
    AWSMediaTailorServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMediaTailorServiceRolePolicy);
    }
    /** Policy allows AWSMigrationHubService to call AWSApplicationDiscoveryService on behalf of the customer. */
    AWSMigrationHubDiscoveryAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubDiscoveryAccess);
    }
    /** Policy for Database Migration Service to assume role in customer's account to call Migration Hub */
    AWSMigrationHubDMSAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubDMSAccess);
    }
    /** Managed policy to provide the customer access to the Migration Hub Service */
    AWSMigrationHubFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubFullAccess);
    }
    /** Provides limited access to AWS Migration Hub, AWS Application Discovery Service, Amazon Simple Storage Service and AWS Secrets Manager. This policy also grants full access to AWS Migration Hub Orchestrator service. */
    AWSMigrationHubOrchestratorConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubOrchestratorConsoleFullAccess);
    }
    /** This policy needs to be attached for SAP and MGN migrated instance for our service to orchestrate instances by downloading scripts from S3 and to fetch secret values inside EC2 instance. */
    AWSMigrationHubOrchestratorInstanceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubOrchestratorInstanceRolePolicy);
    }
    /** Provides limited access to Amazon Simple Storage Service, AWS Secrets Manager and Plugin related actions for AWS Migration Hub Orchestrator. */
    AWSMigrationHubOrchestratorPlugin() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubOrchestratorPlugin);
    }
    /** Provides permissions necessary for Migration Hub Orchestrator to migrate and modernize your on-premises workloads */
    AWSMigrationHubOrchestratorServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubOrchestratorServiceRolePolicy);
    }
    /** Grants full access to AWS Migration Hub Refactor Spaces and other AWS related services except AWS Transit Gateway and EC2 security groups not required when using environments without a network bridge. This policy also excludes permissions required for AWS Lambda and AWS Resource Access Manager as they can be scoped down based on tags. */
    AWSMigrationHubRefactorSpacesEnvironmentsWithoutBridgesFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubRefactorSpacesEnvironmentsWithoutBridgesFullAccess);
    }
    /** Use in the IAM service role passed to the SSM Automation document AWSRefactorSpaces-CreateResources to grant permissions required to run the automation. The policy grants read/write access to EC2 tags in order to track automation progress. When the Refactor Spaces environment's network bridge is enabled, the automation also adds the environment's security group to the EC2 instance to permit traffic from other Refactor Spaces services in the environment. The policy also grants access to the Application Migration Service's post launch actions SSM parameters. */
    AWSMigrationHubRefactorSpacesSSMAutomationPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubRefactorSpacesSSMAutomationPolicy);
    }
    /** Grants full access to AWS MigrationHub Refactor Spaces, AWS MigrationHub Refactor Spaces console features and other related AWS services except permissions required for AWS Lambda and AWS Resource Access Manager as they can be scoped down based on tags. */
    AWSMigrationHubRefactorSpacesFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubRefactorSpacesFullAccess);
    }
    /** Provides access to AWS Resources managed or used by AWS Migration Hub Refactor Spaces. */
    AWSMigrationHubRefactorSpacesServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubRefactorSpacesServiceRolePolicy);
    }
    /** Policy for Server Migration Service to assume role in customer's account to call Migration Hub */
    AWSMigrationHubSMSAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubSMSAccess);
    }
    /** Grants permissions to allow communication with the AWS Migration Hub Strategy Recommendations service, read/write access to S3 buckets related to the service, Amazon API Gateway access to upload logs and metrics to AWS, AWS Secrets Manager access to fetch credentials, and any related services. */
    AWSMigrationHubStrategyCollector() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubStrategyCollector);
    }
    /** Grants full access to the AWS Migration Hub Strategy Recommendations service and access to related AWS services through the AWS Management Console. */
    AWSMigrationHubStrategyConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubStrategyConsoleFullAccess);
    }
    /** Enable access to AWS Resources used or managed by AWS Migration Hub Strategy Recommendations service. */
    AWSMigrationHubStrategyServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMigrationHubStrategyServiceRolePolicy);
    }
    /** Grants permissions to Amazon MSK Replicator to replicate data between MSK Clusters. */
    AWSMSKReplicatorExecutionRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSMSKReplicatorExecutionRole);
    }
    /** Grants full access to AWS Network Firewall service, including permissions to create, configure, manage, and delete firewall resources, policies, and rule groups. Additionally includes permissions to modify VPC endpoints, S3 bucket policies, CloudWatch Logs configurations, and create service-linked roles for Network Firewall and log delivery services */
    AWSNetworkFirewallFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSNetworkFirewallFullAccess);
    }
    /** Provides read-only access to AWS Network Firewall resources via the AWS Management Console, CLI, and SDKs. This policy allows users to view and monitor firewall configurations, policies, rule groups, and associated resources, without the ability to make changes. */
    AWSNetworkFirewallReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSNetworkFirewallReadOnlyAccess);
    }
    /** Allow AWSNetworkFirewall to create and manage necessary resources for your Firewalls. */
    AWSNetworkFirewallServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSNetworkFirewallServiceRolePolicy);
    }
    /** Allow NetworkManager to access resources associated with your Core Network */
    AWSNetworkManagerCloudWANServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSNetworkManagerCloudWANServiceRolePolicy);
    }
    /** Provides full access to Amazon NetworkManager via the AWS Management Console. */
    AWSNetworkManagerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSNetworkManagerFullAccess);
    }
    /** Provides read only access to Amazon NetworkManager via the AWS Management Console. */
    AWSNetworkManagerReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSNetworkManagerReadOnlyAccess);
    }
    /** Allow NetworkManager to access resources associated with your Global Networks */
    AWSNetworkManagerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSNetworkManagerServiceRolePolicy);
    }
    /** Service-linked role permissions for CloudWatch Logs centralization */
    AWSObservabilityAdminLogsCentralizationServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSObservabilityAdminLogsCentralizationServiceRolePolicy);
    }
    /** Provides access to manage AWS Config Configuration Recorder, manage AWS Config Configuration Aggregator, create AWS Config Service Linked Role for Configuration Recorder functionality, consume recorder configuration data, and read AWS Organizations data for organizational features. */
    AWSObservabilityAdminServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSObservabilityAdminServiceRolePolicy);
    }
    /** Provides access to manage AWS Config recorder resource and telemetry settings on AWS resources including logs, metrics. */
    AWSObservabilityAdminTelemetryEnablementServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSObservabilityAdminTelemetryEnablementServiceRolePolicy);
    }
    /** Provides full access to AWS Organizations. */
    AWSOrganizationsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSOrganizationsFullAccess);
    }
    /** Provides read-only access to AWS Organizations. */
    AWSOrganizationsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSOrganizationsReadOnlyAccess);
    }
    /** A policy to allow AWS Organizations to share trust with other approved AWS Services for the purpose of simplifying customer configuration. */
    AWSOrganizationsServiceTrustPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSOrganizationsServiceTrustPolicy);
    }
    /** This policy grants permissions that allow you to install an Outpost server on your on-premises network. */
    AWSOutpostsAuthorizeServerPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSOutpostsAuthorizeServerPolicy);
    }
    /** Service Linked Role policy to enable access to AWS resources managed by AWS Outposts */
    AWSOutpostsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSOutpostsServiceRolePolicy);
    }
    /** Allows AWS IoT software on an AWS Panorama Appliance to upload logs to Amazon CloudWatch. */
    AWSPanoramaApplianceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPanoramaApplianceRolePolicy);
    }
    /** Allows an AWS Panorama Appliance to upload logs to Amazon CloudWatch, and to get objects from Amazon S3 access points created for use with AWS Panorama. */
    AWSPanoramaApplianceServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPanoramaApplianceServiceRolePolicy);
    }
    /** Provides full access to AWS Panorama */
    AWSPanoramaFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPanoramaFullAccess);
    }
    /** Allows an AWS Lambda function on an AWS Panorama Appliance to manage resources in Panorama, upload logs and metrics to Amazon CloudWatch, and to manage objects in buckets created for use with Panorama. */
    AWSPanoramaGreengrassGroupRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPanoramaGreengrassGroupRolePolicy);
    }
    /** Allows Amazon SageMaker to manage objects in buckets created for use with AWS Panorama. */
    AWSPanoramaSageMakerRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPanoramaSageMakerRolePolicy);
    }
    /** Allows AWS Panorama to manage resources in AWS IoT, AWS Secrets Manager and AWS Panorama. */
    AWSPanoramaServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPanoramaServiceLinkedRolePolicy);
    }
    /** Allows AWS Panorama to manage resources in Amazon S3, AWS IoT, AWS IoT GreenGrass, AWS Lambda, Amazon SageMaker, and Amazon CloudWatch Logs, and to pass service roles to AWS IoT, AWS IoT GreenGrass, and Amazon SageMaker. */
    AWSPanoramaServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPanoramaServiceRolePolicy);
    }
    /** Provides full access to AWS Partner Central and related AWS Services. */
    AWSPartnerCentralFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPartnerCentralFullAccess);
    }
    /** Provides necessary access for opportunity management activities. */
    AWSPartnerCentralOpportunityManagement() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPartnerCentralOpportunityManagement);
    }
    /** Provides necessary access for developer testing in the Sandbox catalog. */
    AWSPartnerCentralSandboxFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPartnerCentralSandboxFullAccess);
    }
    /** Provides access to the ResourceSnapshotJob to read a resource and snapshot it in the target engagement. */
    AWSPartnerCentralSellingResourceSnapshotJobExecutionRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPartnerCentralSellingResourceSnapshotJobExecutionRolePolicy);
    }
    /** This policy can be used to grant read-only access to APIs that can read service metadata for services in your AWS account. You can use this policy to provide your partners in the Partner-Led Support Program with access to the services specified in the permissions details section below. */
    AWSPartnerLedSupportReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPartnerLedSupportReadOnlyAccess);
    }
    /** Grants permission to AWS PCS compute nodes to connect to AWS PCS clusters. */
    AWSPCSComputeNodePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPCSComputeNodePolicy);
    }
    /** Grants permissions to PCS to manage resources on your behalf. */
    AWSPCSServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPCSServiceRolePolicy);
    }
    /** Provides full access to AWS Price List Service. */
    AWSPriceListServiceFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPriceListServiceFullAccess);
    }
    /** Provides auditor access to AWS Private Certificate Authority */
    AWSPrivateCAAuditor() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPrivateCAAuditor);
    }
    /** Grants essential permissions for the AWS Private CA Connector for Kubernetes. */
    AWSPrivateCAConnectorForKubernetesPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPrivateCAConnectorForKubernetesPolicy);
    }
    /** Provides full access to AWS Private Certificate Authority */
    AWSPrivateCAFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPrivateCAFullAccess);
    }
    /** Provides privileged certificate user access to AWS Private Certificate Authority */
    AWSPrivateCAPrivilegedUser() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPrivateCAPrivilegedUser);
    }
    /** Provides read only access to AWS Private Certificate Authority */
    AWSPrivateCAReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPrivateCAReadOnly);
    }
    /** Provides certificate user access to AWS Private Certificate Authority */
    AWSPrivateCAUser() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPrivateCAUser);
    }
    /** Provides full access to all administrative actions for an AWS Private Marketplace. */
    AWSPrivateMarketplaceAdminFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPrivateMarketplaceAdminFullAccess);
    }
    /** Provides access to creating requests in an AWS Private Marketplace. */
    AWSPrivateMarketplaceRequests() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPrivateMarketplaceRequests);
    }
    /** Allows AWS Private Networks Service to manage resources on behalf of the customer. */
    AWSPrivateNetworksServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPrivateNetworksServiceRolePolicy);
    }
    /** Permissions CodeBuild needs to run a build for AWS Proton CodeBuild Provisioning. */
    AWSProtonCodeBuildProvisioningBasicAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSProtonCodeBuildProvisioningBasicAccess);
    }
    /** Allows AWS Proton to manage Proton resource provisioning using CodeBuild and other AWS services on your behalf. */
    AWSProtonCodeBuildProvisioningServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSProtonCodeBuildProvisioningServiceRolePolicy);
    }
    /** Provides access to the AWS Proton APIs and Management Console, but does not allow administration of Proton templates or environments. */
    AWSProtonDeveloperAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSProtonDeveloperAccess);
    }
    /** Provides full access to the AWS Proton APIs and Management Console. In addition to these permissions, access to Amazon S3 is also needed to register template bundles from your S3 buckets, as well as access to Amazon IAM to create and manage the service roles for Proton. */
    AWSProtonFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSProtonFullAccess);
    }
    /** Provides read only access to the AWS Proton APIs and Management Console. */
    AWSProtonReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSProtonReadOnlyAccess);
    }
    /** Policy which allows AWS Proton to sync your service, environment and component definitions from your git repository to AWS Proton. */
    AWSProtonServiceGitSyncServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSProtonServiceGitSyncServiceRolePolicy);
    }
    /** Policy which allows AWS Proton to sync your git repository contents to Proton or sync Proton contents to your git repositories. */
    AWSProtonSyncServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSProtonSyncServiceRolePolicy);
    }
    /** Grants permissions to view and modify purchase orders on billing console */
    AWSPurchaseOrdersServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSPurchaseOrdersServiceRolePolicy);
    }
    /** The AWSQuickSetupCFGCPacksPermissionsBoundary policy defines the list of permissions that are permitted in an IAM role created by Quick Setup. Quick Setup uses a role created with this policy to deploy AWS Config conformance packs. */
    AWSQuickSetupCFGCPacksPermissionsBoundary() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupCFGCPacksPermissionsBoundary);
    }
    /** Provides permissions for AWS Systems Manager Quick Setup to deploy multiple configuration types. These configuration types create IAM roles and automations that configure frequently used Amazon Web Services services and features with recommended best practices. */
    AWSQuickSetupDeploymentRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupDeploymentRolePolicy);
    }
    /** The AWSQuickSetupDevOpsGuruPermissionsBoundary policy defines the list of permissions that are permitted in an IAM role created by Quick Setup. Quick Setup uses a role created with this policy to enable and configure Amazon DevOps Guru. This policy also provides permissions to enable Systems Manager Explorer. */
    AWSQuickSetupDevOpsGuruPermissionsBoundary() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupDevOpsGuruPermissionsBoundary);
    }
    /** QuickSetup creates IAM roles which enable it to configure the Systems Manager Distributor feature on your behalf, and uses this policy when creating such roles to define the boundary of their permissions. */
    AWSQuickSetupDistributorPermissionsBoundary() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupDistributorPermissionsBoundary);
    }
    /** This policy grants permissions that allow Systems Manager to run the AWSQuickSetupType-EnableAREX Automation runbook, which enables AWS Resource Explorer for use with Systems Manager. */
    AWSQuickSetupEnableAREXExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupEnableAREXExecutionPolicy);
    }
    /** This policy grants permissions that allow principals to run the AWSQuickSetupType-EnableDHMC Automation runbook, which enables Default Host Management Configuration. */
    AWSQuickSetupEnableDHMCExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupEnableDHMCExecutionPolicy);
    }
    /** This policy allows Quick Setup to deploy the configuration type required to set up just-in-time node access. */
    AWSQuickSetupJITNADeploymentRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupJITNADeploymentRolePolicy);
    }
    /** This policy grants administrative permissions that allow Systems Manager to create a default IAM instance profile for the Quick Setup capability and attach it to Amazon EC2 instances that don't already have an instance. profile attached. */
    AWSQuickSetupManagedInstanceProfileExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupManagedInstanceProfileExecutionPolicy);
    }
    /** This policy provides permissions to enable just-in-time node access for Systems Manager. */
    AWSQuickSetupManageJITNAResourcesExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupManageJITNAResourcesExecutionPolicy);
    }
    /** Provides read-only permissions to access patch baselines that have been configured by an administrator in the current AWS account or organization using Quick Setup. */
    AWSQuickSetupPatchPolicyBaselineAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupPatchPolicyBaselineAccess);
    }
    /** Provides permissions that allow Quick Setup to create resources associated with a patch policy configuration. */
    AWSQuickSetupPatchPolicyDeploymentRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupPatchPolicyDeploymentRolePolicy);
    }
    /** QuickSetup creates IAM roles which enable it to configure the Systems Manager Patch Manager feature on your behalf, and uses this policy when creating such roles to define the boundary of their permissions. */
    AWSQuickSetupPatchPolicyPermissionsBoundary() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupPatchPolicyPermissionsBoundary);
    }
    /** The AWSQuickSetupSchedulerPermissionsBoundary policy defines the list of permissions that are permitted in an IAM role created by Quick Setup. Quick Setup uses a role created with this policy to enable and configure scheduled operations on Amazon EC2 instances and other resources. */
    AWSQuickSetupSchedulerPermissionsBoundary() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupSchedulerPermissionsBoundary);
    }
    /** This policy grants administrative permssions that allow Quick Setup to create resources that are used during the Systems Manager onboarding process. */
    AWSQuickSetupSSMDeploymentRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupSSMDeploymentRolePolicy);
    }
    /** This policy grants permissions for listing all S3 buckets in an account; and for managing and retrieving information about specific buckets in the principal account that are managed through AWS CloudFormation templates. */
    AWSQuickSetupSSMDeploymentS3BucketRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupSSMDeploymentS3BucketRolePolicy);
    }
    /** Quick Setup creates IAM roles which enable it to configure the Host Manager Quick Setup type on your behalf, and uses this policy when creating such roles to define the boundary of their permissions. */
    AWSQuickSetupSSMHostMgmtPermissionsBoundary() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupSSMHostMgmtPermissionsBoundary);
    }
    /** The policy grants administrative permissions that allow Quick Setup to run the a AWS CloudFormation custom resource on lifecycle events during Quick Setup deployment in Systems Manager. */
    AWSQuickSetupSSMLifecycleManagementExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupSSMLifecycleManagementExecutionPolicy);
    }
    /** This policy grants permissions that allow Systems Manager to create prerequisites such as IAM roles required for Systems Manager onboarding. */
    AWSQuickSetupSSMManageResourcesExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupSSMManageResourcesExecutionPolicy);
    }
    /** This policy grants permissions that allow principals to run the AWSQuickSetupType-StartSSMAssociations Automation runbook, which starts State Manager Associations. */
    AWSQuickSetupStartSSMAssociationsExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupStartSSMAssociationsExecutionPolicy);
    }
    /** The managed policy AWSQuickSetupStartStopInstancesExecutionPolicy provides permissions for Quick Setup to start and stop Amazon EC2 instances on a schedule. This policy is used with the Quick Setup scheduler configuration type. */
    AWSQuickSetupStartStopInstancesExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSetupStartStopInstancesExecutionPolicy);
    }
    /** Provides the set of permissions required to perform QuickSight Asset Bundle Export Operations */
    AWSQuickSightAssetBundleExportPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSightAssetBundleExportPolicy);
    }
    /** Provides the set of permissions required to perform QuickSight Asset Bundle Import Operations */
    AWSQuickSightAssetBundleImportPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSightAssetBundleImportPolicy);
    }
    /** Quicksight access to Athena API and S3 buckets used for Athena query results */
    AWSQuicksightAthenaAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuicksightAthenaAccess);
    }
    /** Allow QuickSight to describe the RDS resources */
    AWSQuickSightDescribeRDS() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSightDescribeRDS);
    }
    /** Allow QuickSight to describe Redshift resources */
    AWSQuickSightDescribeRedshift() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSightDescribeRedshift);
    }
    /** Provides access to Amazon Elasticsearch resources from Amazon QuickSight */
    AWSQuickSightElasticsearchPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSightElasticsearchPolicy);
    }
    /** Give QuickSight read-only access to IoT Analytics datasets */
    AWSQuickSightIoTAnalyticsAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSightIoTAnalyticsAccess);
    }
    /** Allow QuickSight to list IAM entities */
    AWSQuickSightListIAM() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSightListIAM);
    }
    /** Provides access to Amazon OpenSearch resources from Amazon QuickSight */
    AWSQuicksightOpenSearchPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuicksightOpenSearchPolicy);
    }
    /** Provides access to Amazon SageMaker resources from Amazon QuickSight */
    AWSQuickSightSageMakerPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSightSageMakerPolicy);
    }
    /** Policy used by QuickSight to create secrets in AWS Secrets Manager and to attach resource policies on existing QuickSight secrets. */
    AWSQuickSightSecretsManagerWriteAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSightSecretsManagerWriteAccess);
    }
    /** Policy used by QuickSight to create secrets in AWS Secrets Manager and to attach resource policies on existing QuickSight secrets. */
    AWSQuickSightSecretsManagerWritePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSightSecretsManagerWritePolicy);
    }
    /** AWS QuickSight access to AWS Timestream APIs. Customers can attach this policy to AWS QuickSight role to allow retrieval of data and metadata. */
    AWSQuickSightTimestreamPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSQuickSightTimestreamPolicy);
    }
    /** Allows VPC Reachability Analyzer to access AWS resources and integrate with AWS Organizations on your behalf. */
    AWSReachabilityAnalyzerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSReachabilityAnalyzerServiceRolePolicy);
    }
    /** This policy grants permission to use AWS services with the AWS Toolkit for .NET Refactoring extension for Microsoft Visual Studio. It is intended to be attached to a local AWS profile. The policy allows uploading application artifacts and downloading the resulting artifacts from Amazon S3. It allows building applications into a container image using AWS CodeBuild and storing and retrieving the images from Amazon Elastic Container Registry (Amazon ECR). And it allows deployment of the application to container services on AWS such as Amazon Elastic Container Service (Amazon ECS), optional creation of VPC resources, optional connection to existing infrastructure such as AWS Directory Service, and other related services. */
    AWSRefactoringToolkitFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSRefactoringToolkitFullAccess);
    }
    /** This policy is intended to be used by Amazon ECS Tasks created for testing applications in AWS using the AWS Toolkit for .NET Refactoring extension for Microsoft Visual Studio. The policy grants access to download application artifacts from Amazon S3, communicate the status of the Task using AWS Systems Manager, and other required services. */
    AWSRefactoringToolkitSidecarPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSRefactoringToolkitSidecarPolicy);
    }
    /** Provides re:Post Private access to publish CloudWatch metrics data */
    AWSrePostPrivateCloudWatchAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSrePostPrivateCloudWatchAccess);
    }
    /** This policy allows the re:Post Space service to create, manage, and resolve Support cases that are created through the Space application. */
    AWSRepostSpaceSupportOperationsPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSRepostSpaceSupportOperationsPolicy);
    }
    /** Policy for AWS Resilience Hub service role which allows access to other AWS services in order to execute assessment. */
    AWSResilienceHubAsssessmentExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSResilienceHubAsssessmentExecutionPolicy);
    }
    /** Provides full access to AWS Resource Access Manager */
    AWSResourceAccessManagerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSResourceAccessManagerFullAccess);
    }
    /** Provides read only access to AWS Resource Access Manager. */
    AWSResourceAccessManagerReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSResourceAccessManagerReadOnlyAccess);
    }
    /** Provides access to AWS Resource Access Manager APIs needed by a resource share participant. */
    AWSResourceAccessManagerResourceShareParticipantAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSResourceAccessManagerResourceShareParticipantAccess);
    }
    /** Policy containing Read-only AWS Resource Access Manager access to customers' Organizations structure. It also contains IAM permissions to self-delete the role. */
    AWSResourceAccessManagerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSResourceAccessManagerServiceRolePolicy);
    }
    /** This policy grants administrative permissions to access Resource Explorer resources and grants read-only permissions to other AWS services to support this access. */
    AWSResourceExplorerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSResourceExplorerFullAccess);
    }
    /** This policy grants administrative permissions to Resource Explorer and grants read-only permissions to other AWS services to support this access. The AWS Organizations administrator needs these permissions to setup and manage multi-account search in the console. */
    AWSResourceExplorerOrganizationsAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSResourceExplorerOrganizationsAccess);
    }
    /** This policy grants read-only permissions to search for and view Resource Explorer resources and grants read-only permissions to other AWS services to support this access. */
    AWSResourceExplorerReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSResourceExplorerReadOnlyAccess);
    }
    /** Allows Resource Explorer to view resources and CloudTrail events on your behalf to index your resources for search. */
    AWSResourceExplorerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSResourceExplorerServiceRolePolicy);
    }
    /** This is the read only policy for AWS Resource Groups */
    AWSResourceGroupsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSResourceGroupsReadOnlyAccess);
    }
    /** Provides full access to AWS RoboMaker via the AWS Management Console and SDK. Also provides select access to related services (e.g., S3, IAM). */
    AWSRoboMakerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSRoboMakerFullAccess);
    }
    /** Provides read only access to AWS RoboMaker via the AWS Management Console and SDK */
    AWSRoboMakerReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSRoboMakerReadOnlyAccess);
    }
    /** RoboMaker service policy */
    AWSRoboMakerServicePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSRoboMakerServicePolicy);
    }
    /** RoboMaker service policy */
    AWSRoboMakerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSRoboMakerServiceRolePolicy);
    }
    /** Provides all permissions to IAM Roles Anywhere resources, including but not limited to: CreateProfile, DeleteTrustAnchor, DisableCRL, ResetNotificationSettings. */
    AWSRolesAnywhereFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSRolesAnywhereFullAccess);
    }
    /** Provides read-only permissions to IAM Roles Anywhere resources, including but not limited to: GetTrustAnchor, ListProfiles, GetCRL. There will be no other permissions for other services included in this policy. */
    AWSRolesAnywhereReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSRolesAnywhereReadOnly);
    }
    /** Allows IAM Roles Anywhere to publish service/usage metrics to CloudWatch and check the status of Private Certificate Authorities on your behalf. */
    AWSRolesAnywhereServicePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSRolesAnywhereServicePolicy);
    }
    /** Allow Amazon S3 on Outposts service to manage EC2 network resources on your behalf. */
    AWSS3OnOutpostsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSS3OnOutpostsServiceRolePolicy);
    }
    /** Provides full access to Savings Plans service */
    AWSSavingsPlansFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSavingsPlansFullAccess);
    }
    /** Provides read only access to Savings Plans service */
    AWSSavingsPlansReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSavingsPlansReadOnlyAccess);
    }
    /** Provides full access to use AWS Security Hub. */
    AWSSecurityHubFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSecurityHubFullAccess);
    }
    /** Grants permission to enable and manage AWS Security Hub within an organization. Includes enabling the service across the organization, and determining the delegated administrator account for the service. */
    AWSSecurityHubOrganizationsAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSecurityHubOrganizationsAccess);
    }
    /** Provides read only access to AWS Security Hub resources */
    AWSSecurityHubReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSecurityHubReadOnlyAccess);
    }
    /** A service-linked role required for AWS Security Hub to access your resources. */
    AWSSecurityHubServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSecurityHubServiceRolePolicy);
    }
    /** This policy allows Security Hub to manage AWS Config rules and Security Hub resources in your organization and on your behalf. */
    AWSSecurityHubV2ServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSecurityHubV2ServiceRolePolicy);
    }
    /** Policy provides customers with Read and Write permissions to case resources that are created through the Security Incident Response service. */
    AWSSecurityIncidentResponseCaseFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSecurityIncidentResponseCaseFullAccess);
    }
    /** Policy provides customers with Read and Write permissions to all resources associated to the Security Incident Response service. */
    AWSSecurityIncidentResponseFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSecurityIncidentResponseFullAccess);
    }
    /** Policy provides customers with Read-only permissions to all resources associated to the Security Incident Response service. Permission includes access to GetCaseAttachmentDownloadUrl as well for the ability to get case attachment download URLs. */
    AWSSecurityIncidentResponseReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSecurityIncidentResponseReadOnlyAccess);
    }
    /** Provides access to AWS Resources managed or used by Security Incident Response */
    AWSSecurityIncidentResponseServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSecurityIncidentResponseServiceRolePolicy);
    }
    /** Provides access to AWS Security Incident Response to continuously monitor your environment for security threats, tune security services to reduce alert noise, and gather information to investigate potential incidents. */
    AWSSecurityIncidentResponseTriageServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSecurityIncidentResponseTriageServiceRolePolicy);
    }
    /** Provides full access to service catalog admin capabilities */
    AWSServiceCatalogAdminFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceCatalogAdminFullAccess);
    }
    /** Provides read-only access to Service Catalog admin capabilities */
    AWSServiceCatalogAdminReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceCatalogAdminReadOnlyAccess);
    }
    /** Provides full access to Service Catalog App Registry capabilities */
    AWSServiceCatalogAppRegistryFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceCatalogAppRegistryFullAccess);
    }
    /** Provides read-only access to Service Catalog App Registry capabilites */
    AWSServiceCatalogAppRegistryReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceCatalogAppRegistryReadOnlyAccess);
    }
    /** Allows Service Catalog AppRegistry to manage Resource Groups on your behalf */
    AWSServiceCatalogAppRegistryServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceCatalogAppRegistryServiceRolePolicy);
    }
    /** Provides full access to service catalog enduser capabilities */
    AWSServiceCatalogEndUserFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceCatalogEndUserFullAccess);
    }
    /** Provides read-only access to Service Catalog end-user capabilities */
    AWSServiceCatalogEndUserReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceCatalogEndUserReadOnlyAccess);
    }
    /** A Service Linked Role Policy for AWS ServiceCatalog to sync with AWS Organizations organization structure */
    AWSServiceCatalogOrgsDataSyncServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceCatalogOrgsDataSyncServiceRolePolicy);
    }
    /** A Service Linked Role for AWS ServiceCatalog to sync Provisioning Artifacts from source repositories */
    AWSServiceCatalogSyncServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceCatalogSyncServiceRolePolicy);
    }
    /** Permissions required for managing nodegroups in the customer's account. These policies related to management of the following resources: AutoscalingGroups, SecurityGroups, LaunchTemplates and InstanceProfiles. */
    AWSServiceRoleForAmazonEKSNodegroup() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForAmazonEKSNodegroup);
    }
    /** This Service Linked Role provides Amazon Q Developer ability to provide usage information. */
    AWSServiceRoleForAmazonQDeveloper() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForAmazonQDeveloper);
    }
    /** This Service-Linked Role provides AWS Transform with the ability to provide usage information. */
    AWSServiceRoleForAWSTransform() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForAWSTransform);
    }
    /** Provides access to Systems Manager resources used by CloudWatch Alarms */
    AWSServiceRoleForCloudWatchAlarmsActionSSMServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForCloudWatchAlarmsActionSSMServiceRolePolicy);
    }
    /** Allows CloudWatch to access RDS Performance Insights metrics on your behalf */
    AWSServiceRoleForCloudWatchMetricsDbPerfInsightsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForCloudWatchMetricsDbPerfInsightsServiceRolePolicy);
    }
    /** A service-linked role required for Amazon CodeGuru Profiler to send notifications on your behalf. */
    AWSServiceRoleForCodeGuruProfiler() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForCodeGuruProfiler);
    }
    /** This role grants permissions to CodeWhisperer to access data in your account to calculate billing, provides access to create and access security reports in Amazon CodeGuru, and emit data to CloudWatch. */
    AWSServiceRoleForCodeWhispererPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForCodeWhispererPolicy);
    }
    /** Allows EC2 Scheduled Instances to launch and manage spot instances. */
    AWSServiceRoleForEC2ScheduledInstances() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForEC2ScheduledInstances);
    }
    /** AWS GroundStation uses this service-linked role to invoke EC2 to find public IPv4 addresses */
    AWSServiceRoleForGroundStationDataflowEndpointGroupPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForGroundStationDataflowEndpointGroupPolicy);
    }
    /** Allows EC2ImageBuilder to call AWS services on your behalf. */
    AWSServiceRoleForImageBuilder() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForImageBuilder);
    }
    /** Allows AWS IoT SiteWise to provision and manage gateways as well as query data. The policy includes required AWS Greengrass permissions for deploying to groups, AWS Lambda permissions for creating and updating service-prefixed functions, and AWS IoT Analytics permissions for querying data from datastores. */
    AWSServiceRoleForIoTSiteWise() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForIoTSiteWise);
    }
    /** Allows Log Delivery service to deliver logs by calling log destination on your behalf. */
    AWSServiceRoleForLogDeliveryPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForLogDeliveryPolicy);
    }
    /** Grants Amazon Monitron permissions to manage AWS resources, including AWS SSO user assignment on your behalf. */
    AWSServiceRoleForMonitronPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForMonitronPolicy);
    }
    /** Provides Cloudwatch access to publish operational and usage metrics and logs for Amazon Neptune */
    AWSServiceRoleForNeptuneGraphPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForNeptuneGraphPolicy);
    }
    /** Provides permissions to describe and update Private Marketplace resources and describe AWS Organizations */
    AWSServiceRoleForPrivateMarketplaceAdminPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForPrivateMarketplaceAdminPolicy);
    }
    /** Policy for Procurement Insights to obtain Organization Account details */
    AWSServiceRoleForProcurementInsightsPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForProcurementInsightsPolicy);
    }
    /** Provides access to AWS services and resources necessary to migrate service instances into AWS including EC2, S3 and Cloudformation. */
    AWSServiceRoleForSMS() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForSMS);
    }
    /** Provides access to the User Subscriptions service to your Identity Center resources to automatically update your subscriptions. */
    AWSServiceRoleForUserSubscriptions() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRoleForUserSubscriptions);
    }
    /** Provides AWS Backup permissions to create compliance reports on your behalf */
    AWSServiceRolePolicyForBackupReports() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRolePolicyForBackupReports);
    }
    /** This policy contains permissions for testing restores and for cleaning up resources created during tests. */
    AWSServiceRolePolicyForBackupRestoreTesting() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRolePolicyForBackupRestoreTesting);
    }
    /** This managed policy provides administrative access to Amazon WorkSpaces to manage EC2 instances in your AWS account */
    AWSServiceRolePolicyForWorkspacesInstances() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSServiceRolePolicyForWorkspacesInstances);
    }
    /** Provides the AWS DDoS Response Team with limited access to your AWS account to assist with DDoS attack mitigation during a high-severity event. */
    AWSShieldDRTAccessPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSShieldDRTAccessPolicy);
    }
    /** Allows AWS Shield to access AWS resources on your behalf to provide DDoS protection. */
    AWSShieldServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSShieldServiceRolePolicy);
    }
    /** Provides access to publish metrics and provide insights for your social message sending. */
    AWSSocialMessagingServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSocialMessagingServiceRolePolicy);
    }
    /** Provides AWS Systems Manager for SAP with the permissions needed to manage and integrate SAP software with AWS. */
    AWSSSMForSAPServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSMForSAPServiceLinkedRolePolicy);
    }
    /** Policy for Service Linked Role AWSServiceRoleForAmazonSSM_OpsInsights */
    AWSSSMOpsInsightsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSMOpsInsightsServiceRolePolicy);
    }
    /** Administrator access for SSO Directory */
    AWSSSODirectoryAdministrator() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSODirectoryAdministrator);
    }
    /** ReadOnly access for SSO Directory */
    AWSSSODirectoryReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSODirectoryReadOnly);
    }
    /** Provides access within AWS SSO to manage AWS Organizations master and member accounts and cloud application */
    AWSSSOMasterAccountAdministrator() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSOMasterAccountAdministrator);
    }
    /** Provides access within AWS SSO to manage AWS Organizations member accounts and cloud application */
    AWSSSOMemberAccountAdministrator() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSOMemberAccountAdministrator);
    }
    /** Provides read only access to AWS SSO configurations. */
    AWSSSOReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSOReadOnly);
    }
    /** Grants AWS SSO permissions to manage AWS resources, including IAM roles, policies and SAML IdP on your behalf. */
    AWSSSOServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSSOServiceRolePolicy);
    }
    /** An access policy for providing a user/role/etc access to the AWS StepFunctions console. For a full console experience, in addition to this policy, a user may need iam:PassRole permission on other IAM roles that can be assumed by the service. */
    AWSStepFunctionsConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSStepFunctionsConsoleFullAccess);
    }
    /** An access policy for providing a user/role/etc access to the AWS StepFunctions API. For full access, in addition to this policy, a user MUST have iam:PassRole permission on at least one IAM role that can be assumed by the service. */
    AWSStepFunctionsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSStepFunctionsFullAccess);
    }
    /** An access policy for providing a user/role/etc read only access to the AWS StepFunctions service. */
    AWSStepFunctionsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSStepFunctionsReadOnlyAccess);
    }
    /** Provides full access to AWS Storage Gateway via the AWS Management Console. */
    AWSStorageGatewayFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSStorageGatewayFullAccess);
    }
    /** Provides access to AWS Storage Gateway via the AWS Management Console. */
    AWSStorageGatewayReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSStorageGatewayReadOnlyAccess);
    }
    /** Service-linked role used by AWS Storage Gateway to enable integration of other AWS services with Storage Gateway. */
    AWSStorageGatewayServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSStorageGatewayServiceRolePolicy);
    }
    /** AWSSupplyChainFederationAdminAccess provides AWS Supply Chain federated users access to the AWS Supply Chain application, including the required permissions to perform actions within the AWS Supply Chain application. The policy provides administrative permissions over IAM Identity Center users and groups and is attached to a role created by AWS Supply Chain on your behalf. You shouldn't attach AWSSupplyChainFederationAdminAccess policy to any other IAM entities. */
    AWSSupplyChainFederationAdminAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSupplyChainFederationAdminAccess);
    }
    /** Allows users to access the AWS Support Center. */
    AWSSupportAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSupportAccess);
    }
    /** Provides full access to the AWS Support App and other required services, such as AWS Support and Service Quotas. This policy includes permissions to use the supporting services so that the user can contact AWS Support for support cases, change service quotas, and create the relevant service-linked roles. */
    AWSSupportAppFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSupportAppFullAccess);
    }
    /** Provides read-only access to the AWS Support App. */
    AWSSupportAppReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSupportAppReadOnlyAccess);
    }
    /** Provides full access to supportplans. */
    AWSSupportPlansFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSupportPlansFullAccess);
    }
    /** Provides read-only access to supportplans. */
    AWSSupportPlansReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSupportPlansReadOnlyAccess);
    }
    /** Allows AWS Support to access AWS resources to provide billing, administrative, and support services. */
    AWSSupportServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSupportServiceRolePolicy);
    }
    /** Grants AWS Systems Manager (SSM) permission to discover AWS account information. */
    AWSSystemsManagerAccountDiscoveryServicePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSystemsManagerAccountDiscoveryServicePolicy);
    }
    /** Provides access to AWS resources managed or used by the AWS Systems Manager change management framework. */
    AWSSystemsManagerChangeManagementServicePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSystemsManagerChangeManagementServicePolicy);
    }
    /** Provides permissions for AWS Systems Manager Quick Setup to enable and configure AWS Config configuration recording. */
    AWSSystemsManagerEnableConfigRecordingExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSystemsManagerEnableConfigRecordingExecutionPolicy);
    }
    /** This policy grants administrative permissions for enabling Explorer, a capability of AWS Systems Manager. This includes permissions to update related Systems Manager service settings, and to create a service-linked role for Systems Manager. */
    AWSSystemsManagerEnableExplorerExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSystemsManagerEnableExplorerExecutionPolicy);
    }
    /** Provides full access to AWS Systems Manager for SAP service */
    AWSSystemsManagerForSAPFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSystemsManagerForSAPFullAccess);
    }
    /** Provides read only access to AWS Systems Manager for SAP service */
    AWSSystemsManagerForSAPReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSystemsManagerForSAPReadOnlyAccess);
    }
    /** Provides access to AWS resources managed or used by the AWS Systems Manager just in time access framework. */
    AWSSystemsManagerJustInTimeAccessServicePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSystemsManagerJustInTimeAccessServicePolicy);
    }
    /** The managed policy AWSSystemsManagerJustInTimeAccessTokenPolicy allows Systems Manager to generate access tokens used for just-in-time node access. */
    AWSSystemsManagerJustInTimeAccessTokenPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSystemsManagerJustInTimeAccessTokenPolicy);
    }
    /** The managed policy AWSSystemsManagerJustInTimeAccessTokenSessionPolicy allows Systems Manager to apply scoped down permissions to a just-in-time node access session once it is started. */
    AWSSystemsManagerJustInTimeAccessTokenSessionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSystemsManagerJustInTimeAccessTokenSessionPolicy);
    }
    /** This policy allows Systems Manager to share a deny-access policy for just-in-time node access from the delegated administrator account to member accounts, and replicate the policy to multiple Regions. */
    AWSSystemsManagerJustInTimeNodeAccessRolePropagationPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSystemsManagerJustInTimeNodeAccessRolePropagationPolicy);
    }
    /** Permissions required to collect information about a user for Just-In-Time-Node-Access notifications. */
    AWSSystemsManagerNotificationsServicePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSystemsManagerNotificationsServicePolicy);
    }
    /** IAM role for SSM Explorer to manage OpsData related operations */
    AWSSystemsManagerOpsDataSyncServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSSystemsManagerOpsDataSyncServiceRolePolicy);
    }
    /** This policy grants the AWS Portal Asset Server the necessary permissions required for normal operation. */
    AWSThinkboxAssetServerPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSThinkboxAssetServerPolicy);
    }
    /** This policy grants AWS Thinkbox's Deadline software full access to multiple AWS services as required for AWS Portal administration. This includes access to create arbitrary tags on several EC2 resource types. */
    AWSThinkboxAWSPortalAdminPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSThinkboxAWSPortalAdminPolicy);
    }
    /** This policy grants the AWS Portal Gateway machine the necessary permissions required for normal operation. */
    AWSThinkboxAWSPortalGatewayPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSThinkboxAWSPortalGatewayPolicy);
    }
    /** This policy grants the Deadline Workers in AWS Portal the necessary permissions required for normal operation. */
    AWSThinkboxAWSPortalWorkerPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSThinkboxAWSPortalWorkerPolicy);
    }
    /** Grants permissions required for the operation of AWS Thinkbox's Deadline Resource Tracker.  This includes full access to some EC2 actions, including DeleteFleets and CancelSpotFleetRequests. */
    AWSThinkboxDeadlineResourceTrackerAccessPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSThinkboxDeadlineResourceTrackerAccessPolicy);
    }
    /** Grants permissions required to create, destroy, and administer AWS Thinkbox's Deadline Resource Tracker. */
    AWSThinkboxDeadlineResourceTrackerAdminPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSThinkboxDeadlineResourceTrackerAdminPolicy);
    }
    /** Grants permissions required for AWS Thinkbox's Deadline Spot Event Plugin.  This includes permission to request, modify, and cancel a spot fleet, as well as limited PassRole permission. */
    AWSThinkboxDeadlineSpotEventPluginAdminPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSThinkboxDeadlineSpotEventPluginAdminPolicy);
    }
    /** Grant permissions required for an EC2 instance running AWS Thinkbox Deadline Spot Event Plugin Worker software. */
    AWSThinkboxDeadlineSpotEventPluginWorkerPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSThinkboxDeadlineSpotEventPluginWorkerPolicy);
    }
    /** Provides full access to AWS Transfer via the AWS Management Console */
    AWSTransferConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSTransferConsoleFullAccess);
    }
    /** Provides full access to AWS Transfer Service. */
    AWSTransferFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSTransferFullAccess);
    }
    /** Allows AWS Transfer full access to create log streams and groups and put log events to your account */
    AWSTransferLoggingAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSTransferLoggingAccess);
    }
    /** Provide readonly access to AWS Transfer services. */
    AWSTransferReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSTransferReadOnlyAccess);
    }
    /** Enables the AWS Transform service to deploy transformed .NET applications by creating and managing AWS resources. This policy grants permissions to provision infrastructure, manage compute resources, and configure deployment settings across various AWS services. */
    AWSTransformApplicationDeploymentPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSTransformApplicationDeploymentPolicy);
    }
    /** Provides full access to AWS Trusted Advisor Priority. This policy also enables the user to add Trusted Advisor as a trusted service with AWS Organizations and to specify delegated administrator accounts for Trusted Advisor Priority. */
    AWSTrustedAdvisorPriorityFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSTrustedAdvisorPriorityFullAccess);
    }
    /** Provides read-only access to AWS Trusted Advisor Priority. This includes permission to view the delegated administrator accounts. */
    AWSTrustedAdvisorPriorityReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSTrustedAdvisorPriorityReadOnlyAccess);
    }
    /** Service Policy for Trusted Advisor Multi-account Reporting */
    AWSTrustedAdvisorReportingServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSTrustedAdvisorReportingServiceRolePolicy);
    }
    /** Access for the AWS Trusted Advisor Service to help reduce cost, increase performance, and improve security of your AWS environment. */
    AWSTrustedAdvisorServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSTrustedAdvisorServiceRolePolicy);
    }
    /** Allows AWS User Notifications to call AWS services on your behalf. */
    AWSUserNotificationsServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSUserNotificationsServiceLinkedRolePolicy);
    }
    /** Provides full access for viewing entitled Vendor Insights resources and managing Vendor Insights subscriptions */
    AWSVendorInsightsAssessorFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSVendorInsightsAssessorFullAccess);
    }
    /** Provides read-only access for viewing entitled Vendor Insights resources */
    AWSVendorInsightsAssessorReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSVendorInsightsAssessorReadOnly);
    }
    /** Provides full access for creating and managing the Vendor Insights resources */
    AWSVendorInsightsVendorFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSVendorInsightsVendorFullAccess);
    }
    /** Provides read-only access for viewing the Vendor Insights resources */
    AWSVendorInsightsVendorReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSVendorInsightsVendorReadOnly);
    }
    /** Allows VPC Lattice to access AWS resources on your behalf. */
    AWSVpcLatticeServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSVpcLatticeServiceRolePolicy);
    }
    /** Allow Site-to-Site VPN to create and manage resources related to your VPN Connections. */
    AWSVPCS2SVpnServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSVPCS2SVpnServiceRolePolicy);
    }
    /** Allow VPC Transit Gateway to create and manage necessary resources for your Transit Gateway VPC Attachments. */
    AWSVPCTransitGatewayServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSVPCTransitGatewayServiceRolePolicy);
    }
    /** Policy to enable AWS Verified Access service to provision endpoints on your behalf */
    AWSVPCVerifiedAccessServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSVPCVerifiedAccessServiceRolePolicy);
    }
    /** Provides full access to AWS WAF via the AWS Management Console. Note that this policy also grants permissions to list and update Amazon CloudFront distributions, permissions to view load balancers on AWS Elastic Load Balancing, permissions to view Amazon API Gateway REST APIs and stages, permissions to list and view Amazon CloudWatch metrics, and permissions to view regions enabled within the account. */
    AWSWAFConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSWAFConsoleFullAccess);
    }
    /** Provides read-only access to AWS WAF via the AWS Management Console. Note that this policy also grants permissions to list Amazon CloudFront distributions, permissions to view load balancers on AWS Elastic Load Balancing, permissions to view Amazon API Gateway REST APIs and stages, permissions to list and view Amazon CloudWatch metrics, and permissions to view regions enabled within the account. */
    AWSWAFConsoleReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSWAFConsoleReadOnlyAccess);
    }
    /** Provides full access to AWS WAF actions. */
    AWSWAFFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSWAFFullAccess);
    }
    /** Provides read only access to AWS WAF actions. */
    AWSWAFReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSWAFReadOnlyAccess);
    }
    /** Allows WellArchitected to access AWS services and resources that relate to WellArchitected resources on behalf of customers. */
    AWSWellArchitectedDiscoveryServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSWellArchitectedDiscoveryServiceRolePolicy);
    }
    /** Allows Well-Architected to access Organizations on your behalf. */
    AWSWellArchitectedOrganizationsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSWellArchitectedOrganizationsServiceRolePolicy);
    }
    /** This policy grants full administrative permissions to the Wickr service, including the Wickr administrative functions under the AWS Management Console. */
    AWSWickrFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSWickrFullAccess);
    }
    /** Provides capabilities to manage Observability Access Manager links and establish sharing of X-Ray traces */
    AWSXrayCrossAccountSharingConfiguration() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSXrayCrossAccountSharingConfiguration);
    }
    /** Allow the AWS X-Ray Daemon to relay raw trace segments data to the service's API and retrieve sampling data (rules, targets, etc.) to be used by the X-Ray SDK. */
    AWSXRayDaemonWriteAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSXRayDaemonWriteAccess);
    }
    /** AWS X-Ray full access managed policy */
    AWSXrayFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSXrayFullAccess);
    }
    /** AWS X-Ray read only managed policy */
    AWSXrayReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSXrayReadOnlyAccess);
    }
    /** AWS X-Ray write only managed policy */
    AWSXrayWriteOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSXrayWriteOnlyAccess);
    }
    /** Provides administrative access for ARC zonal shift practice runs, and access to CloudWatch alarm statuses to monitor practice runs. */
    AWSZonalAutoshiftPracticeRunSLRPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSZonalAutoshiftPracticeRunSLRPolicy);
    }
    /** Provides read-only access to the APIs needed to support zone-group access-management for organizations. */
    AWSZoneGroupAccessManagementServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.AWSZoneGroupAccessManagementServiceRolePolicy);
    }
    /** Provides access for the AWS Batch service to manage the required resources, including Amazon EC2 and Amazon ECS resources. */
    BatchServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.BatchServiceRolePolicy);
    }
    /** Provides full access to Bedrock AgentCore as well as limited access to related services */
    BedrockAgentCoreFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.BedrockAgentCoreFullAccess);
    }
    /** Grants permissions for billing and cost management. This includes viewing account usage and viewing and modifying budgets and payment methods. */
    Billing() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.Billing);
    }
    /** Allows Budgets to verify access to Billing Views shared across account boundaries. */
    BudgetsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.BudgetsServiceRolePolicy);
    }
    /** Amazon Certificate Manager Service Role Policy */
    CertificateManagerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CertificateManagerServiceRolePolicy);
    }
    /** Policy to enable AWS Client VPN to manage your Client VPN endpoint connections. */
    ClientVPNServiceConnectionsRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ClientVPNServiceConnectionsRolePolicy);
    }
    /** Policy to enable AWS Client VPN to manage your Client VPN endpoints. */
    ClientVPNServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ClientVPNServiceRolePolicy);
    }
    /** Service Role for CloudFormation StackSets (Organization Master Account) */
    CloudFormationStackSetsOrgAdminServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudFormationStackSetsOrgAdminServiceRolePolicy);
    }
    /** Service Role for CloudFormation StackSets (Organization Member Account) */
    CloudFormationStackSetsOrgMemberServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudFormationStackSetsOrgMemberServiceRolePolicy);
    }
    /** Provides full access to the CloudFront console plus the ability to list Amazon S3 buckets via the AWS Management Console. */
    CloudFrontFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudFrontFullAccess);
    }
    /** Provides access to CloudFront distribution configuration information and list distributions via the AWS Management Console. */
    CloudFrontReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudFrontReadOnlyAccess);
    }
    /** Enables access to AWS resources used or managed by CloudHSM */
    CloudHSMServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudHSMServiceRolePolicy);
    }
    /** Provides full access to the Amazon CloudSearch configuration service. */
    CloudSearchFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudSearchFullAccess);
    }
    /** Provides read only access to the Amazon CloudSearch configuration service. */
    CloudSearchReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudSearchReadOnlyAccess);
    }
    /** This service linked role allows CloudTrail to get and add resource tags to the resource owner's CloudTrail events. */
    CloudTrailEventContext() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudTrailEventContext);
    }
    /** Permission policy for CloudTrail ServiceLinkedRole */
    CloudTrailServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudTrailServiceRolePolicy);
    }
    /** Allows CloudWatch to assume CloudWatch-CrossAccountSharing roles in remote accounts on behalf of the current account in order to display data cross-account, cross-region */
    CloudWatchCrossAccountAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchCrossAccountAccess);
    }
    /** Provides read-only access to CloudWatch alarms and metrics as well as EC2 metadata. Provides access to Stop, Terminate and Reboot EC2 instances. */
    CloudWatchActionsEC2Access() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchActionsEC2Access);
    }
    /** Full permissions required to use AmazonCloudWatchAgent. */
    CloudWatchAgentAdminPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchAgentAdminPolicy);
    }
    /** Permissions required to use AmazonCloudWatchAgent on servers */
    CloudWatchAgentServerPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchAgentServerPolicy);
    }
    /** Provides full access to CloudWatch Application Insights and required dependencies. */
    CloudWatchApplicationInsightsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchApplicationInsightsFullAccess);
    }
    /** Provides read only access to CloudWatch Application Insights. */
    CloudWatchApplicationInsightsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchApplicationInsightsReadOnlyAccess);
    }
    /** Cloudwatch Application Insights Service Linked Role Policy */
    CloudwatchApplicationInsightsServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudwatchApplicationInsightsServiceLinkedRolePolicy);
    }
    /** Provide full access to CloudWatch Application Signals service and scoped access to the dependencies needed to use and operate this service. */
    CloudWatchApplicationSignalsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchApplicationSignalsFullAccess);
    }
    /** Provides read only access to CloudWatch Application Signals service and scoped access to the dependencies needed to use this service */
    CloudWatchApplicationSignalsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchApplicationSignalsReadOnlyAccess);
    }
    /** Policy grants permission to CloudWatch Application Signals to collect monitoring and tagging data from other relevant AWS services. */
    CloudWatchApplicationSignalsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchApplicationSignalsServiceRolePolicy);
    }
    /** Provides access to the non-CloudWatch APIs used to display CloudWatch Automatic Dashboards, including the contents of objects such as Lambda functions */
    CloudWatchAutomaticDashboardsAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchAutomaticDashboardsAccess);
    }
    /** Provides capabilities to manage Observability Access Manager links and establish sharing of CloudWatch resources */
    CloudWatchCrossAccountSharingConfiguration() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchCrossAccountSharingConfiguration);
    }
    /** Allows built-in targets in Amazon CloudWatch Events to perform EC2 actions on your behalf. */
    CloudWatchEventsBuiltInTargetExecutionAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchEventsBuiltInTargetExecutionAccess);
    }
    /** Provides full access to Amazon CloudWatch Events. */
    CloudWatchEventsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchEventsFullAccess);
    }
    /** Allows Amazon CloudWatch Events to relay events to the streams in AWS Kinesis Streams in your account. */
    CloudWatchEventsInvocationAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchEventsInvocationAccess);
    }
    /** Provides read only access to Amazon CloudWatch Events. */
    CloudWatchEventsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchEventsReadOnlyAccess);
    }
    /** Allow AWS CloudWatch to execute actions on your behalf configured through alarms and events. */
    CloudWatchEventsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchEventsServiceRolePolicy);
    }
    /** Provides full access to CloudWatch. */
    CloudWatchFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchFullAccess);
    }
    /** Provides full access to CloudWatch. */
    CloudWatchFullAccessV2() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchFullAccessV2);
    }
    /** Provides full access to actions for working with Amazon CloudWatch Internet Monitor. Also provides access to other services, such as Amazon CloudWatch, Amazon EC2, Amazon CloudFront, Amazon WorkSpaces, and Elastic Load Balancing, that are necessary to use the Internet Monitor service for monitoring and storing information about application traffic. */
    CloudWatchInternetMonitorFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchInternetMonitorFullAccess);
    }
    /** Provides read only access to actions for working with Amazon CloudWatch Internet Monitor. Also provides access to other services in Amazon CloudWatch, including policies to retrieve information on CloudWatch metrics and to manage log queries, that are necessary to use the Internet Monitor service for monitoring and storing information about application traffic. */
    CloudWatchInternetMonitorReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchInternetMonitorReadOnlyAccess);
    }
    /** Allows Internet Monitor to access EC2, Workspaces, and CloudFront resources, and other required services on your behalf. */
    CloudWatchInternetMonitorServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchInternetMonitorServiceRolePolicy);
    }
    /** Provides write access to X-Ray and CloudWatch Application Signals log group. */
    CloudWatchLambdaApplicationSignalsExecutionRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchLambdaApplicationSignalsExecutionRolePolicy);
    }
    /** Policy required for the Lambda Insights Extension */
    CloudWatchLambdaInsightsExecutionRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchLambdaInsightsExecutionRolePolicy);
    }
    /** Provides capabilities to manage Observability Access Manager links and establish sharing of CloudWatch Logs resources */
    CloudWatchLogsCrossAccountSharingConfiguration() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchLogsCrossAccountSharingConfiguration);
    }
    /** Provides full access to CloudWatch Logs */
    CloudWatchLogsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchLogsFullAccess);
    }
    /** Provides read only access to CloudWatch Logs */
    CloudWatchLogsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchLogsReadOnlyAccess);
    }
    /** You can use this policy in IAM roles that are attached to Amazon EC2 and Amazon EKS instance resources to send telemetry reports (metrics) to a Network Flow Monitor endpoint. */
    CloudWatchNetworkFlowMonitorAgentPublishPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchNetworkFlowMonitorAgentPublishPolicy);
    }
    /** You can't attach CloudWatchNetworkFlowMonitorServiceRolePolicy to your IAM entities. This policy is attached to a service-linked role named AWSServiceRoleForNetworkFlowMonitor, which publishes network telemetry aggregation results, collected by Network Flow Monitor agents, to CloudWatch. It also allows the service to use AWS Organizations to get information for multi-account scenarios. */
    CloudWatchNetworkFlowMonitorServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchNetworkFlowMonitorServiceRolePolicy);
    }
    /** You can't attach CloudWatchNetworkFlowMonitorTopologyServiceRolePolicy to your IAM entities. This policy is attached to a service-linked role named AWSServiceRoleForNetworkFlowMonitor_Topology, which generates topology snapshots of resources used by Network Flow Monitor in your account. */
    CloudWatchNetworkFlowMonitorTopologyServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchNetworkFlowMonitorTopologyServiceRolePolicy);
    }
    /** Allows CloudWatch Network Monitor to access and manage EC2 and VPC resources, publish data to CloudWatch and access other required services on your behalf. */
    CloudWatchNetworkMonitorServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchNetworkMonitorServiceRolePolicy);
    }
    /** This policy provides user access to view OpenSearch dashboards on the CloudWatch Logs console. */
    CloudWatchOpenSearchDashboardAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchOpenSearchDashboardAccess);
    }
    /** This policy provides user access to create integration with OpenSearch to create, update, delete or view dashboards on the CloudWatch Logs console. */
    CloudWatchOpenSearchDashboardsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchOpenSearchDashboardsFullAccess);
    }
    /** Provides read only access to CloudWatch. */
    CloudWatchReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchReadOnlyAccess);
    }
    /** Provides full access to CloudWatch Synthetics. */
    CloudWatchSyntheticsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchSyntheticsFullAccess);
    }
    /** Provides read only access to CloudWatch Synthetics. */
    CloudWatchSyntheticsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CloudWatchSyntheticsReadOnlyAccess);
    }
    /** Policy for AWS Comprehend service role which allows access to S3 resources for data access */
    ComprehendDataAccessRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ComprehendDataAccessRolePolicy);
    }
    /** Provides full access to Amazon Comprehend. */
    ComprehendFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ComprehendFullAccess);
    }
    /** Provides full access to Amazon Comprehend Medical */
    ComprehendMedicalFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ComprehendMedicalFullAccess);
    }
    /** Provides read-only access to Amazon Comprehend. */
    ComprehendReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ComprehendReadOnly);
    }
    /** Provides read only access to ComputeOptimizer. */
    ComputeOptimizerReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ComputeOptimizerReadOnlyAccess);
    }
    /** Allows ComputeOptimizer to call AWS services and collect workload details on your behalf. */
    ComputeOptimizerServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ComputeOptimizerServiceRolePolicy);
    }
    /** Policy needed for AWSConfig to create conformance packs */
    ConfigConformsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ConfigConformsServiceRolePolicy);
    }
    /** This managed policy provides admin access to Cost Optimization Hub. */
    CostOptimizationHubAdminAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CostOptimizationHubAdminAccess);
    }
    /** This managed policy provides read-only access to Cost Optimization Hub. */
    CostOptimizationHubReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CostOptimizationHubReadOnlyAccess);
    }
    /** Allows Cost Optimization Hub to retrieve organization information and collect optimization-related data and metadata. */
    CostOptimizationHubServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CostOptimizationHubServiceRolePolicy);
    }
    /** Allows Amazon Connect Customer Profiles to access AWS services and resources on your behalf. */
    CustomerProfilesServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.CustomerProfilesServiceLinkedRolePolicy);
    }
    /** Grants full access permissions to AWS services and actions required to set up and configure AWS database services. */
    DatabaseAdministrator() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.DatabaseAdministrator);
    }
    /** Grants permissions to AWS data analytics services. */
    DataScientist() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.DataScientist);
    }
    /** This policy allows DAX to create and manage Network interface, Security group, Subnet and Vpc on behalf of customer */
    DAXServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.DAXServiceRolePolicy);
    }
    /** Provides access to read-only APIs needed to run EC2 Declarative Policies Account Status Report. */
    DeclarativePoliciesEC2Report() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.DeclarativePoliciesEC2Report);
    }
    /** Permissions required to support Amazon CloudWatch Contributor Insights for Amazon DynamoDB. */
    DynamoDBCloudWatchContributorInsightsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.DynamoDBCloudWatchContributorInsightsServiceRolePolicy);
    }
    /** Provide AWS DynamoDB access to KinesisDataStreams */
    DynamoDBKinesisReplicationServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.DynamoDBKinesisReplicationServiceRolePolicy);
    }
    /** Permissions required by DynamoDB for cross-region data replication */
    DynamoDBReplicationServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.DynamoDBReplicationServiceRolePolicy);
    }
    /** This policy grants full access to EC2 Fast Launch actions */
    EC2FastLaunchFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.EC2FastLaunchFullAccess);
    }
    /** Policy grants ec2fastlaunch to prepare and manage preprovisioned snapshots in customer's account & publish related metrics. */
    EC2FastLaunchServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.EC2FastLaunchServiceRolePolicy);
    }
    /** Policy granting permissions to EC2 Fleet to launch instances in the future. */
    EC2FleetTimeShiftableServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.EC2FleetTimeShiftableServiceRolePolicy);
    }
    /** Permissions need by EC2 Image Builder to perform a cross account distribution. */
    Ec2ImageBuilderCrossAccountDistributionAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.Ec2ImageBuilderCrossAccountDistributionAccess);
    }
    /** The EC2ImageBuilderLifecycleExecutionPolicy policy grants permissions for Image Builder to perform actions such as deprecate or delete Image Builder image resources and their underlying resources (AMIs, snapshots) to support automated rules for image lifecycle management tasks. */
    EC2ImageBuilderLifecycleExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.EC2ImageBuilderLifecycleExecutionPolicy);
    }
    /** Allows customers to call EC2 Instance Connect to publish ephemeral keys to their EC2 instances and connect via ssh or the EC2 Instance Connect CLI. */
    EC2InstanceConnect() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.EC2InstanceConnect);
    }
    /** EC2 Instance Connect endpoint policy to manage EC2 Instance Connect endpoints created by the customer */
    Ec2InstanceConnectEndpoint() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.Ec2InstanceConnectEndpoint);
    }
    /** EC2 Instance profile for Image Builder service. */
    EC2InstanceProfileForImageBuilder() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.EC2InstanceProfileForImageBuilder);
    }
    /** EC2 Instance profile for building container images with EC2 Image Builder. This policy grants the user broad permissions to upload ECR images. */
    EC2InstanceProfileForImageBuilderECRContainerBuilds() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.EC2InstanceProfileForImageBuilderECRContainerBuilds);
    }
    /** Enables access to AWS Services and Resources used or managed by ECR Replication */
    ECRReplicationServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ECRReplicationServiceRolePolicy);
    }
    /** Allows actions to be performed when using AWS ECR repository creation templates */
    ECRTemplateServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ECRTemplateServiceRolePolicy);
    }
    /** This policy allows ElastiCache to manage AWS resources on your behalf as necessary for managing your cache */
    ElastiCacheServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ElastiCacheServiceRolePolicy);
    }
    /** Provides full access to Amazon ElasticLoadBalancing, and limited access to other services necessary to provide ElasticLoadBalancing features. */
    ElasticLoadBalancingFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ElasticLoadBalancingFullAccess);
    }
    /** Provides read only access to Amazon ElasticLoadBalancing and dependent services */
    ElasticLoadBalancingReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ElasticLoadBalancingReadOnly);
    }
    /** Access to view purchased assets and download related software and kickstart files */
    ElementalActivationsDownloadSoftwareAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ElementalActivationsDownloadSoftwareAccess);
    }
    /** Full access to view and take action on Elemental Appliances and Software purchased assets */
    ElementalActivationsFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ElementalActivationsFullAccess);
    }
    /** Access to view purchased assets and generate software licenses for pending activations */
    ElementalActivationsGenerateLicenses() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ElementalActivationsGenerateLicenses);
    }
    /** Read-only access to the detailed list of purchased assets associated to the AWS account of the user */
    ElementalActivationsReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ElementalActivationsReadOnlyAccess);
    }
    /** Full access to view and take action on Elemental Appliances and Software quotes and orders */
    ElementalAppliancesSoftwareFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ElementalAppliancesSoftwareFullAccess);
    }
    /** Read-only access to view Elemental Appliances and Software quotes and orders */
    ElementalAppliancesSoftwareReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ElementalAppliancesSoftwareReadOnlyAccess);
    }
    /** Full access to view and take action on Elemental Appliance and Software support cases and product support content */
    ElementalSupportCenterFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ElementalSupportCenterFullAccess);
    }
    /** This policy grants read-only permissions that allow the WAL service for Amazon EMR to find and return the status of a cluster */
    EMRDescribeClusterPolicyForEMRWAL() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.EMRDescribeClusterPolicyForEMRWAL);
    }
    /** Access policy to allow FM service linked role to perform FM-related actions on FM-managed resources within a customer AWS Organization account. */
    FMSServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.FMSServiceRolePolicy);
    }
    /** Allows Amazon FSx to delete its Service Linked Roles for Amazon S3 access */
    FSxDeleteServiceLinkedRoleAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.FSxDeleteServiceLinkedRoleAccess);
    }
    /** Grants the required permissions for compute actions in an Amazon GameLift container fleet, including access to dependencies such as Amazon S3. */
    GameLiftContainerFleetPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.GameLiftContainerFleetPolicy);
    }
    /** Policy to allow Gamelift GameServerGroups to manage customer resources */
    GameLiftGameServerGroupPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.GameLiftGameServerGroupPolicy);
    }
    /** This managed policy grants permission to connect with Amazon Q and utilize the features in the GitLab Duo with Amazon Q integration. */
    GitLabDuoWithAmazonQPermissionsPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.GitLabDuoWithAmazonQPermissionsPolicy);
    }
    /** Allow GlobalAccelerator Users full Access to all APIs */
    GlobalAcceleratorFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.GlobalAcceleratorFullAccess);
    }
    /** Allow GlobalAccelerator Users Access to Read Only APIs */
    GlobalAcceleratorReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.GlobalAcceleratorReadOnlyAccess);
    }
    /** Provides read access to the Greengrass OTA Update artifacts in all Greengrass regions */
    GreengrassOTAUpdateArtifactAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.GreengrassOTAUpdateArtifactAccess);
    }
    /** AWS Health policy to enable Organizational View feature */
    HealthOrganizationsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.HealthOrganizationsServiceRolePolicy);
    }
    /** This policy grants access to read all access information provided by IAM access advisor such as service last accessed information. */
    IAMAccessAdvisorReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IAMAccessAdvisorReadOnly);
    }
    /** Provides full access to IAM Access Analyzer */
    IAMAccessAnalyzerFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IAMAccessAnalyzerFullAccess);
    }
    /** Provides read only access to IAM Access Analyzer resources */
    IAMAccessAnalyzerReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IAMAccessAnalyzerReadOnlyAccess);
    }
    /** Provides access required to check the presence of root user credentials such as root user password and root user access keys using the Security Token Service (STS) AssumeRoot API. Use this managed policy only with the STS AssumeRoot action. */
    IAMAuditRootUserCredentials() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IAMAuditRootUserCredentials);
    }
    /** Provides access required to create a root user password using the Security Token Service (STS) AssumeRoot API.  Use this managed policy only with the STS AssumeRoot action. */
    IAMCreateRootUserPassword() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IAMCreateRootUserPassword);
    }
    /** Provides access required to delete all root user credentials such as root password and root access keys using the Security Token Service (STS) AssumeRoot API.  Use this managed policy only with the STS AssumeRoot action. */
    IAMDeleteRootUserCredentials() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IAMDeleteRootUserCredentials);
    }
    /** Provides full access to IAM via the AWS Management Console. */
    IAMFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IAMFullAccess);
    }
    /** Provides read only access to IAM via the AWS Management Console. */
    IAMReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IAMReadOnlyAccess);
    }
    /** Allows an IAM user to manage their own Service Specific Credentials. */
    IAMSelfManageServiceSpecificCredentials() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IAMSelfManageServiceSpecificCredentials);
    }
    /** Provides the ability for an IAM user to change their own password. */
    IAMUserChangePassword() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IAMUserChangePassword);
    }
    /** Provides the ability for an IAM user to manage their own SSH keys. */
    IAMUserSSHKeys() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IAMUserSSHKeys);
    }
    /** Provides full access to Interactive Video Service (IVS), Also included permissions for dependent services, needed for full access to the ivs console. */
    IVSFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IVSFullAccess);
    }
    /** Provides read-only access to IVS Low-Latency and Real-Time streaming APIs */
    IVSReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IVSReadOnlyAccess);
    }
    /** Service Linked Role to perform S3 PutObject to recording IVS live streams */
    IVSRecordToS3() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.IVSRecordToS3);
    }
    /** This policy grants Kafka Connect permission to manage AWS resources on your behalf. */
    KafkaConnectServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.KafkaConnectServiceRolePolicy);
    }
    /** IAM service linked role policy for Kafka. */
    KafkaServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.KafkaServiceRolePolicy);
    }
    /** Grants the required permissions to Amazon Keyspaces for Change Data Capture */
    KeyspacesCDCServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.KeyspacesCDCServiceRolePolicy);
    }
    /** Permissions required by Keyspaces for cross-region data replication */
    KeyspacesReplicationServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.KeyspacesReplicationServiceRolePolicy);
    }
    /** Policy to grant temporary data access to Lake Formation resources */
    LakeFormationDataAccessServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.LakeFormationDataAccessServiceRolePolicy);
    }
    /** Policy for AWS Lex Bot use case */
    LexBotPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.LexBotPolicy);
    }
    /** Policy for AWS Lex Channel use case */
    LexChannelPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.LexChannelPolicy);
    }
    /** AWS Lightsail service linked role policy which grants permissions to export resources */
    LightsailExportAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.LightsailExportAccess);
    }
    /** This policy grants permission to register MediaConnect Gateway Instances to a MediaConnect Gateway. */
    MediaConnectGatewayInstanceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.MediaConnectGatewayInstanceRolePolicy);
    }
    /** Allows MediaPackage to publish logs to CloudWatch */
    MediaPackageServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.MediaPackageServiceRolePolicy);
    }
    /** This policy allows MemoryDB to manage AWS resources on your behalf as necessary for managing your resources. */
    MemoryDBServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.MemoryDBServiceRolePolicy);
    }
    /** Policy for Database Migration Service to assume role in customer's account to call Migration Hub */
    MigrationHubDMSAccessServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.MigrationHubDMSAccessServiceRolePolicy);
    }
    /** Allows Migration Hub to call Application Discovery Service on your behalf */
    MigrationHubServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.MigrationHubServiceRolePolicy);
    }
    /** Policy for Server Migration Service to assume role in customer's account to call Migration Hub */
    MigrationHubSMSAccessServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.MigrationHubSMSAccessServiceRolePolicy);
    }
    /** Policy for AWS Monitron service linked role granting access to required customer resources. */
    MonitronServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.MonitronServiceRolePolicy);
    }
    /** Provides full access to Multi-party approval. This policy also includes related permissions to AWS Organizations and AWS IAM Identity for managing approval teams and identity sources. */
    MultiPartyApprovalFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.MultiPartyApprovalFullAccess);
    }
    /** Provides read-only access to Multi-party approval. This policy also includes related read permission to AWS Organizations and AWS IAM Identity for approval teams and identity sources. */
    MultiPartyApprovalReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.MultiPartyApprovalReadOnlyAccess);
    }
    /** Provides full access to manage Amazon Neptune using the AWS Console. Note this policy also grants full access to publish on all SNS topics within the account, permissions to create and edit Amazon EC2 instances and VPC configurations, permissions to view and list keys on Amazon KMS, and full access to Amazon RDS. For more information, see https://aws.amazon.com/neptune/faqs/. */
    NeptuneConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.NeptuneConsoleFullAccess);
    }
    /** Provides full access to Amazon Neptune. Note this policy also grants full access to publish on all SNS topics within the account and full access to Amazon RDS. For more information, see https://aws.amazon.com/neptune/faqs/. */
    NeptuneFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.NeptuneFullAccess);
    }
    /** Provides read only access to all Amazon Neptune Analytics resources along with read only permissions for dependent services. */
    NeptuneGraphReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.NeptuneGraphReadOnlyAccess);
    }
    /** Provides read only access to Amazon Neptune. Note that this policy also grants access to Amazon RDS resources. For more information, see https://aws.amazon.com/neptune/faqs/. */
    NeptuneReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.NeptuneReadOnlyAccess);
    }
    /** Grants full access permissions to AWS services and actions required to set up and configure AWS network resources. */
    NetworkAdministrator() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.NetworkAdministrator);
    }
    /** Provides permissions for the AWS Shield network security director service linked role to assess specified environments. */
    NetworkSecurityDirectorServiceLinkedRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.NetworkSecurityDirectorServiceLinkedRolePolicy);
    }
    /** Provides full access to CloudWatch Observability Access Manager */
    OAMFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.OAMFullAccess);
    }
    /** Provides Read Only access to CloudWatch Observability Access Manager */
    OAMReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.OAMReadOnlyAccess);
    }
    /** Allows Amazon OpenSearch Ingestion to describe network resources and write service metrics to cloudwatch */
    OpensearchIngestionSelfManagedVpcePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.OpensearchIngestionSelfManagedVpcePolicy);
    }
    /** Provides access to associate and dissociate partner central users with IAM roles */
    PartnerCentralAccountManagementUserRoleAssociation() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.PartnerCentralAccountManagementUserRoleAssociation);
    }
    /** Provides full access to AWS services and resources, but does not allow management of Users and groups. */
    PowerUserAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.PowerUserAccess);
    }
    /** Grants permissions to AWS Services and Resources used or managed by Amazon Q Apps. */
    QAppsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.QAppsServiceRolePolicy);
    }
    /** Grants permissions to QBusiness to call QuickSight APIs for the QuickSight plugin */
    QBusinessQuicksightPluginPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.QBusinessQuicksightPluginPolicy);
    }
    /** Grants permissions to AWS Services and Resources used or managed by Amazon Q */
    QBusinessServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.QBusinessServiceRolePolicy);
    }
    /** Policy used by QuickSight team to access customer data produced by S3 Storage Management Analytics. */
    QuickSightAccessForS3StorageManagementAnalyticsReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.QuickSightAccessForS3StorageManagementAnalyticsReadOnly);
    }
    /** Default policy for the Amazon RDS service role. */
    RDSCloudHsmAuthorizationRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.RDSCloudHsmAuthorizationRole);
    }
    /** Provides read-only access to AWS services and resources. */
    ReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ReadOnlyAccess);
    }
    /** Provides full access to Resource Groups and Tag Editor. */
    ResourceGroupsandTagEditorFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ResourceGroupsandTagEditorFullAccess);
    }
    /** Provides access to use Resource Groups and Tag Editor, but does not allow editing of tags via the Tag Editor. */
    ResourceGroupsandTagEditorReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ResourceGroupsandTagEditorReadOnlyAccess);
    }
    /** Allows AWS Resource Groups to query the AWS services that own your resources to keep the group up-to-date */
    ResourceGroupsServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ResourceGroupsServiceRolePolicy);
    }
    /** Provides permissions to tag and untag all the resources supported by Resource Groups Tagging API. This policy also grants the permissions required to retrieve all tagged, or previously tagged, resources through the Resource Groups Tagging API. */
    ResourceGroupsTaggingAPITagUntagSupportedResources() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ResourceGroupsTaggingAPITagUntagSupportedResources);
    }
    /** Allows the OpenShift Amazon EBS Container Storage Interface (CSI) Driver Operator to install and maintain the Amazon EBS CSI driver on a Red Hat OpenShift Service on AWS (ROSA) cluster. The Amazon EBS CSI driver allows ROSA clusters to manage the lifecycle of Amazon EBS volumes for persistent volumes. */
    ROSAAmazonEBSCSIDriverOperatorPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ROSAAmazonEBSCSIDriverOperatorPolicy);
    }
    /** Allows the OpenShift Cloud Network Config Controller Operator to provision and manage networking resources for use by the Red Hat OpenShift Service on AWS (ROSA) cluster networking overlay. The OpenShift Cloud Network Operator interfaces with AWS APIs on behalf of the network plugins via CustomResourceDefinitions. The operator uses these policy permissions to manage private IP addresses for Amazon EC2 instances as part of the ROSA cluster. */
    ROSACloudNetworkConfigOperatorPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ROSACloudNetworkConfigOperatorPolicy);
    }
    /** Allows Red Hat OpenShift Service on AWS (ROSA) control plane to manage ROSA cluster Amazon EC2 and Amazon Route 53 resources. */
    ROSAControlPlaneOperatorPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ROSAControlPlaneOperatorPolicy);
    }
    /** Allows the OpenShift Image Registry Operator to provision and manage Amazon S3 buckets and objects for use by the Red Hat OpenShift Service on AWS (ROSA) in-cluster image registry to satisfy ROSA storage requirements. The OpenShift Image Registry Operator installs and maintains the internal registry of a Red Hat OpenShift cluster. */
    ROSAImageRegistryOperatorPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ROSAImageRegistryOperatorPolicy);
    }
    /** Allows the OpenShift Ingress Operator to provision and manage load balancers and domain name system (DNS) configurations for Red Hat OpenShift Service on AWS (ROSA) clusters. The policy allows read access to tag values, which the operator filters for Route 53 resources to discover hosted zones. */
    ROSAIngressOperatorPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ROSAIngressOperatorPolicy);
    }
    /** Allows the Red Hat OpenShift Service on AWS (ROSA) installer to manage AWS resources that support ROSA cluster installation. This includes managing instance profiles for ROSA worker nodes. */
    ROSAInstallerPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ROSAInstallerPolicy);
    }
    /** Allows the built-in ROSA AWS Encryption Provider to manage AWS Key Management Service (KMS) keys to support etcd data encryption using a customer provided AWS KMS key. The policy allows encryption and decryption of data using KMS keys. */
    ROSAKMSProviderPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ROSAKMSProviderPolicy);
    }
    /** Allows the ROSA Kubernetes controller to manage Amazon EC2, Elastic Load Balancing (ELB), and AWS Key Management Service (KMS) resources for a ROSA cluster. */
    ROSAKubeControllerPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ROSAKubeControllerPolicy);
    }
    /** This policy provides the permissions required to manage the Red Hat OpenShift Service on AWS (ROSA) subscription. */
    ROSAManageSubscription() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ROSAManageSubscription);
    }
    /** Allows Red Hat OpenShift Service on AWS (ROSA) to manage cluster EC2 instances as worker nodes, including permission to configure security groups and tag instances and volumes. This policy also allows for the use of EC2 instances with disk encryption provided by AWS Key Management Service (KMS) keys. */
    ROSANodePoolManagementPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ROSANodePoolManagementPolicy);
    }
    /** Allows the Red Hat OpenShift Service on AWS (ROSA) installer to configure VPC Endpoints and Security Groups. Intended to be used on a shared VPC. */
    ROSASharedVPCEndpointPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ROSASharedVPCEndpointPolicy);
    }
    /** Allows the Red Hat OpenShift Service on AWS (ROSA) installer to configure Route53 records. Intended to be used on a shared VPC. */
    ROSASharedVPCRoute53Policy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ROSASharedVPCRoute53Policy);
    }
    /** Provides ROSA site reliability engineering (SRE) the permissions needed to initially observe, diagnose, and support AWS resources associated with Red Hat OpenShift Service on AWS (ROSA) clusters, including the ability to change ROSA cluster node state. */
    ROSASRESupportPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ROSASRESupportPolicy);
    }
    /** Allows Red Hat OpenShift Service on AWS (ROSA) worker nodes in your account read-only access to Amazon EC2 instances and AWS Regions for compute node lifecycle management. */
    ROSAWorkerInstancePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ROSAWorkerInstancePolicy);
    }
    /** Service Linked Role Policy for Route 53 Recovery Readiness */
    Route53RecoveryReadinessServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.Route53RecoveryReadinessServiceRolePolicy);
    }
    /** Enables access to AWS Services and Resources used or managed by Route53 Resolver */
    Route53ResolverServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.Route53ResolverServiceRolePolicy);
    }
    /** Enables access to AWS Services and Resources used or managed by S3 Storage Lens */
    S3StorageLensServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.S3StorageLensServiceRolePolicy);
    }
    /** Provides access required to unlock a S3 bucket policy using the Security Token Service (STS) AssumeRoot API. Use this managed policy only with the STS AssumeRoot action. */
    S3UnlockBucketPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.S3UnlockBucketPolicy);
    }
    /** Provides initial administrative and individual setup privileges for Amazon SageMaker Unified Studio via the AWS Management Console and SDK. Allows launching of SageMaker Unified Studio Portal. */
    SageMakerStudioAdminIAMConsolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioAdminIAMConsolePolicy);
    }
    /** Administrative execution policy for using IAM roles with SageMaker Unified Studio. Allows admins to provision, manage and access resources in your account (excluding access to data resources) for IAM-based usage of SageMaker Unified Studio. */
    SageMakerStudioAdminIAMDefaultExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioAdminIAMDefaultExecutionPolicy);
    }
    /** Administrative execution policy for using IAM roles with SageMaker Unified Studio. Allows admins to provision, manage and access resources in the local account (including broad access to all APIs in data services like S3, Glue, CloudWatch Logs, and others) for IAM-based usage of SageMaker Unified Studio. */
    SageMakerStudioAdminIAMPermissiveExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioAdminIAMPermissiveExecutionPolicy);
    }
    /** This IAM policy grants an IAM role full access to AWS Glue Data Catalog (metadata) and Amazon S3 (actual data) for data lake operations, with access scoped by account, and role tags. */
    SageMakerStudioAdminProjectUserRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioAdminProjectUserRolePolicy);
    }
    /** Allows Amazon Bedrock Agents to access Amazon Bedrock models and other resources attached to an agent in SageMaker Studio. */
    SageMakerStudioBedrockAgentServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioBedrockAgentServiceRolePolicy);
    }
    /** Provides access to an Amazon Bedrock chat agent app's configuration and Amazon Bedrock agent in SageMaker Studio. */
    SageMakerStudioBedrockChatAgentUserRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioBedrockChatAgentUserRolePolicy);
    }
    /** Allows Amazon Bedrock to access Amazon Bedrock models and datasets for evaluation jobs in SageMaker Studio. */
    SageMakerStudioBedrockEvaluationJobServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioBedrockEvaluationJobServiceRolePolicy);
    }
    /** Allows Amazon Bedrock Flows to access Amazon Bedrock models and other resources attached to a flow in SageMaker Studio. */
    SageMakerStudioBedrockFlowServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioBedrockFlowServiceRolePolicy);
    }
    /** Allows AWS Lambda to access an Amazon Bedrock function component's configuration in SageMaker Studio. */
    SageMakerStudioBedrockFunctionExecutionRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioBedrockFunctionExecutionRolePolicy);
    }
    /** Provides access to configure vector stores and Amazon Bedrock knowledge bases in SageMaker Studio. */
    SageMakerStudioBedrockKnowledgeBaseCustomResourcePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioBedrockKnowledgeBaseCustomResourcePolicy);
    }
    /** Allows Amazon Bedrock Knowledge Bases to access Amazon Bedrock models and data sources in SageMaker Studio. */
    SageMakerStudioBedrockKnowledgeBaseServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioBedrockKnowledgeBaseServiceRolePolicy);
    }
    /** Provides access to an Amazon Bedrock prompt and its configuration in SageMaker Studio. */
    SageMakerStudioBedrockPromptUserRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioBedrockPromptUserRolePolicy);
    }
    /** This policy is used by Amazon SageMaker Studio to catalog, discover, govern, share, and analyze data in the Amazon SageMaker Studio domain. */
    SageMakerStudioDomainExecutionRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioDomainExecutionRolePolicy);
    }
    /** Service role for domain level actions in the portal that are performed by Amazon SageMaker Studio. */
    SageMakerStudioDomainServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioDomainServiceRolePolicy);
    }
    /** Amazon SageMaker Studio creates IAM roles for projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the permissions related to EMR. */
    SageMakerStudioEMRInstanceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioEMRInstanceRolePolicy);
    }
    /** Amazon SageMaker Studio creates IAM roles for projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the permissions related to EMR. */
    SageMakerStudioEMRServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioEMRServiceRolePolicy);
    }
    /** This policy provides full access to Amazon SageMaker Unified Studio via the Amazon SageMaker management console. */
    SageMakerStudioFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioFullAccess);
    }
    /** Amazon SageMaker Studio uses this policy to provision and manage resources in your account. */
    SageMakerStudioProjectProvisioningRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioProjectProvisioningRolePolicy);
    }
    /** Amazon SageMaker Studio creates IAM roles for projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the permissions related to SageMaker. */
    SageMakerStudioProjectRoleMachineLearningPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioProjectRoleMachineLearningPolicy);
    }
    /** Amazon SageMaker creates IAM roles for Projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the boundary of their permissions. */
    SageMakerStudioProjectUserRolePermissionsBoundary() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioProjectUserRolePermissionsBoundary);
    }
    /** Amazon SageMaker Studio creates IAM roles for projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the permissions. */
    SageMakerStudioProjectUserRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioProjectUserRolePolicy);
    }
    /** Amazon SageMaker Studio uses this policy when running query executions on federated connections. */
    SageMakerStudioQueryExecutionRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioQueryExecutionRolePolicy);
    }
    /** Provides individual setup privileges for Amazon SageMaker Unified Studio via the AWS Management Console and SDK. Allows launching of SageMaker Unified Studio Portal. */
    SageMakerStudioUserIAMConsolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioUserIAMConsolePolicy);
    }
    /** Execution policy for using IAM roles with SageMaker Unified Studio. Allows users to access resources in the local account (excluding access to data resources) for IAM-based usage of SageMaker Unified Studio. */
    SageMakerStudioUserIAMDefaultExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioUserIAMDefaultExecutionPolicy);
    }
    /** Execution policy for using IAM roles with SageMaker Unified Studio. Allows users to access resources in your account (including broad access to all APIs in data services like S3, Glue, CloudWatch Logs, and others) for IAM-based usage of SageMaker Unified Studio. */
    SageMakerStudioUserIAMPermissiveExecutionPolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SageMakerStudioUserIAMPermissiveExecutionPolicy);
    }
    /** Provides read/write access to AWS Secrets Manager via the AWS Management Console. Note: this exludes IAM actions, so combine with IAMFullAccess if rotation configuration is required. */
    SecretsManagerReadWrite() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SecretsManagerReadWrite);
    }
    /** The security audit template grants access to read security configuration metadata. It is useful for software that audits the configuration of an AWS account. */
    SecurityAudit() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SecurityAudit);
    }
    /** Provides access to manage resources created by Security Lake. */
    SecurityLakeResourceManagementServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SecurityLakeResourceManagementServiceRolePolicy);
    }
    /** This policy grants permissions to operate the Amazon Security Lake service on your behalf */
    SecurityLakeServiceLinkedRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SecurityLakeServiceLinkedRole);
    }
    /** Permissions to allow the AWS Server Migration Connector to migrate VMs to EC2. Allows communication with the AWS Server Migration Service, read/write access to S3 buckets starting with 'sms-b-' and 'import-to-ec2-' as well as the buckets used for AWS Server Migration Connector upgrade, AWS Server Migration Connector registration with AWS, and metrics upload to AWS. */
    ServerMigrationConnector() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ServerMigrationConnector);
    }
    /** Required permissions to use all features of the Server Migration Service Console */
    ServerMigrationServiceConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ServerMigrationServiceConsoleFullAccess);
    }
    /** Permissions to allow the AWS Server Migration Service to create and update relevant AWS resources into the customer's AWS account for launching migrated servers and applications. */
    ServerMigrationServiceLaunchRole() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ServerMigrationServiceLaunchRole);
    }
    /** Permissions to allow the AWS SMS to run used data validation script and send script success/failure back to SMS */
    ServerMigrationServiceRoleForInstanceValidation() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ServerMigrationServiceRoleForInstanceValidation);
    }
    /** Provides full access to Service Quotas */
    ServiceQuotasFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ServiceQuotasFullAccess);
    }
    /** Provides read only access to Service Quotas */
    ServiceQuotasReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ServiceQuotasReadOnlyAccess);
    }
    /** Allows Service Quotas to create support cases on your behalf */
    ServiceQuotasServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ServiceQuotasServiceRolePolicy);
    }
    /** Provides full access to the Simple Workflow configuration service. */
    SimpleWorkflowFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SimpleWorkflowFullAccess);
    }
    /** Allows SMSVoice to publish metrics to CloudWatch on your behalf */
    SMSVoiceServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SMSVoiceServiceRolePolicy);
    }
    /** Allows split cost allocation data to retrieve AWS Organizations information, if applicable, and collect telemetry data for the split cost allocation data services that the customer has opted in to. */
    SplitCostAllocationDataServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SplitCostAllocationDataServiceRolePolicy);
    }
    /** Provides access required to unlock a SQS queue policy using the Security Token Service (STS) AssumeRoot API. Use this managed policy only with the STS AssumeRoot action. */
    SQSUnlockQueuePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SQSUnlockQueuePolicy);
    }
    /** Provides permissions to check Quick Setup configuration health, ensure consistent use of parameters and provisioned resources, and remediate resources when drift is detected. */
    SSMQuickSetupRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SSMQuickSetupRolePolicy);
    }
    /** This policy grants permissions to troubleshoot and resolve issues in an AWS account. This policy also enables the user to contact AWS support to create and manage cases. */
    SupportUser() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SupportUser);
    }
    /** Grants full access permissions necessary for resources required for application and development operations. */
    SystemAdministrator() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.SystemAdministrator);
    }
    /** Provides full access to Amazon Translate. */
    TranslateFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.TranslateFullAccess);
    }
    /** Provides read-only access to Amazon Translate. */
    TranslateReadOnly() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.TranslateReadOnly);
    }
    /** This policy grants permissions to view resources and basic metadata across all AWS services. */
    ViewOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.ViewOnlyAccess);
    }
    /** Default policy for the VM Import/Export service role, for customers using the AWS Connector. The VM Import/Export service assumes a role with this policy to fulfill virtual machine migration requests from the AWS Connector virtual appliance. (Note that the AWS Connector uses the "AWSConnector" managed policy to issue requests on the customer's behalf to the VM Import/Export service.) Provides the ability to create AMIs and EBS snapshots, modify EBS snapshot attributes, make "Describe*" calls on EC2 objects, and read from S3 buckets starting with 'import-to-ec2-'. */
    VMImportExportRoleForAWSConnector() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.VMImportExportRoleForAWSConnector);
    }
    /** Provides full access to Amazon VPC Lattice and access to dependency services. */
    VPCLatticeFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.VPCLatticeFullAccess);
    }
    /** Provides read-only access to Amazon VPC Lattice via the AWS Management Console, and limited access to dependency services. */
    VPCLatticeReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.VPCLatticeReadOnlyAccess);
    }
    /** Provides access to invoking Amazon VPC Lattice services. */
    VPCLatticeServicesInvokeAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.VPCLatticeServicesInvokeAccess);
    }
    /** Creating SLR to write customer's logs to a firehose stream */
    WAFLoggingServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.WAFLoggingServiceRolePolicy);
    }
    /** Creating SLR to write customer's logs to a firehose stream */
    WAFRegionalLoggingServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.WAFRegionalLoggingServiceRolePolicy);
    }
    /** This policy creates a service-linked role that allows AWS WAF to write logs to Amazon Kinesis Data Firehose. */
    WAFV2LoggingServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.WAFV2LoggingServiceRolePolicy);
    }
    /** Provides full access to AWS Well-Architected Tool via the AWS Management Console */
    WellArchitectedConsoleFullAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.WellArchitectedConsoleFullAccess);
    }
    /** Provides read-only access to AWS Well-Architected Tool via the AWS Management Console */
    WellArchitectedConsoleReadOnlyAccess() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.WellArchitectedConsoleReadOnlyAccess);
    }
    /** Enables access to AWS Services and Resources used or managed by Amazon WorkLink */
    WorkLinkServiceRolePolicy() {
        return aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName(iam_floyd_1.AwsManagedPolicy.WorkLinkServiceRolePolicy);
    }
}
exports.AwsManagedPolicy = AwsManagedPolicy;
//# sourceMappingURL=data:application/json;base64,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