/** Provides names of all AWS managed policies. */
export declare class AwsManagedPolicy {
    /** Allow Access Analyzer to analyze resource metadata */
    static AccessAnalyzerServiceRolePolicy: string;
    /** Provides full access to AWS services and resources. */
    static AdministratorAccess: string;
    /** Grants account administrative permissions while explicitly allowing direct access to resources needed by Amplify applications. */
    static AdministratorAccessAmplify: string;
    /** Grants account administrative permissions. Explicitly allows developers and administrators to gain direct access to resources they need to manage AWS Elastic Beanstalk applications */
    static AdministratorAccessAWSElasticBeanstalk: string;
    /** Provides ReadOnly permissions required by the Amazon AI Operations Assistant to do analysis on customer AWS resources during investigations. */
    static AIOpsAssistantPolicy: string;
    /** Grants full access to Amazon AI Operations service and its required permissions via AWS console. It also includes permissions to use identity-aware console sessions. */
    static AIOpsConsoleAdminPolicy: string;
    /** Grants access to the Amazon AI Operations APIs for creating, updating, and deleting investigations, investigation events, and investigation resources. It also includes ReadOnly access to all AI Operations APIs and to use identity-aware sessions. */
    static AIOpsOperatorAccess: string;
    /** Grants ReadOnly permissions to the Amazon AI Operations service and its required resources. */
    static AIOpsReadOnlyAccess: string;
    /** Provide device setup access to AlexaForBusiness services */
    static AlexaForBusinessDeviceSetup: string;
    /** Grants full access to AlexaForBusiness resources and access to related AWS Services */
    static AlexaForBusinessFullAccess: string;
    /** Provide gateway execution access to AlexaForBusiness services */
    static AlexaForBusinessGatewayExecution: string;
    /** Provide access to Lifesize AVS devices */
    static AlexaForBusinessLifesizeDelegatedAccessPolicy: string;
    /** This policy enables Alexa for Business to perform automated tasks scheduled by your network profiles. */
    static AlexaForBusinessNetworkProfileServicePolicy: string;
    /** Provide access to Poly AVS devices */
    static AlexaForBusinessPolyDelegatedAccessPolicy: string;
    /** Provide read only access to AlexaForBusiness services */
    static AlexaForBusinessReadOnlyAccess: string;
    /** Provides full access to create/edit/delete APIs in Amazon API Gateway via the AWS Management Console. */
    static AmazonAPIGatewayAdministrator: string;
    /** Provides full access to invoke APIs in Amazon API Gateway. */
    static AmazonAPIGatewayInvokeFullAccess: string;
    /** Allows API Gateway to push logs to user's account. */
    static AmazonAPIGatewayPushToCloudWatchLogs: string;
    /** Provides full access to Amazon AppFlow and access to AWS services supported as flow source or destination (S3 and Redshift). Also provides access to KMS for encryption */
    static AmazonAppFlowFullAccess: string;
    /** Provides read only access to Amazon Appflow flows */
    static AmazonAppFlowReadOnlyAccess: string;
    /** Provides full access to Amazon AppStream via the AWS Management Console. */
    static AmazonAppStreamFullAccess: string;
    /** Amazon AppStream 2.0 access to AWS Certificate Manager Private CA in customer accounts for certificate-based authentication */
    static AmazonAppStreamPCAAccess: string;
    /** Provides read only access to Amazon AppStream via the AWS Management Console. */
    static AmazonAppStreamReadOnlyAccess: string;
    /** Default policy for Amazon AppStream service role. */
    static AmazonAppStreamServiceAccess: string;
    /** Provide full access to Amazon Athena and scoped access to the dependencies needed to enable querying, writing results, and data management. */
    static AmazonAthenaFullAccess: string;
    /** Provides access to perform all operations Amazon Augmented AI resources, including FlowDefinitions, HumanTaskUis and HumanLoops. Does not allow access for creating FlowDefinitions against the public-crowd Workteam. */
    static AmazonAugmentedAIFullAccess: string;
    /** Provides access to perform all operations on HumanLoops. */
    static AmazonAugmentedAIHumanLoopFullAccess: string;
    /** Provides access to perform all operations Amazon Augmented AI resources, including FlowDefinitions, HumanTaskUis and HumanLoops. Also provides access to those operations of services that are integrated with Amazon Augmented AI. */
    static AmazonAugmentedAIIntegratedAPIAccess: string;
    /** Provides console full administrative access to Aurora DSQL */
    static AmazonAuroraDSQLConsoleFullAccess: string;
    /** Provides full administrative access to Aurora DSQL */
    static AmazonAuroraDSQLFullAccess: string;
    /** Provides read only access to Aurora DSQL */
    static AmazonAuroraDSQLReadOnlyAccess: string;
    /** Provides Bedrock Model inference permission to Bedrock agent core memory */
    static AmazonBedrockAgentCoreMemoryBedrockModelInferenceExecutionRolePolicy: string;
    /** Provides full access to Amazon Bedrock as well as limited access to related services that are required by it */
    static AmazonBedrockFullAccess: string;
    /** Provides limited access to Amazon Bedrock as well as to related services that are required by it */
    static AmazonBedrockLimitedAccess: string;
    /** Provides limited access to Amazon Bedrock Marketplace as well as to related services that are required by it */
    static AmazonBedrockMarketplaceAccess: string;
    /** Provides read only access to Amazon Bedrock */
    static AmazonBedrockReadOnly: string;
    /** Defines the maximum permissions of IAM roles that Amazon Bedrock Studio creates for operating Amazon Bedrock Studio resources. */
    static AmazonBedrockStudioPermissionsBoundary: string;
    /** Provides full access to Amazon Braket via the AWS Management Console and SDK. Also provides access to related services (e.g., S3, logs). */
    static AmazonBraketFullAccess: string;
    /** Grants access to AWS Services and resources necessary for executing an Amazon Braket Job including S3, Cloudwatch, IAM and Braket */
    static AmazonBraketJobsExecutionPolicy: string;
    /** Allows Amazon Braket to create and manage AWS resources on your behalf */
    static AmazonBraketServiceRolePolicy: string;
    /** Provides full access to Amazon Chime Admin Console via the AWS Management Console. */
    static AmazonChimeFullAccess: string;
    /** Provides read only access to Amazon Chime Admin Console via the AWS Management Console. */
    static AmazonChimeReadOnly: string;
    /** Provides access to Amazon Chime SDK operations */
    static AmazonChimeSDK: string;
    /** Managed Policy For Amazon Chime SDK MediaPipelines Service Linked Role */
    static AmazonChimeSDKMediaPipelinesServiceLinkedRolePolicy: string;
    /** Allows Amazon Chime SDK Messaging to access AWS resources and enable messaging functionality */
    static AmazonChimeSDKMessagingServiceRolePolicy: string;
    /** Enables access to AWS Resources used or managed by Amazon Chime */
    static AmazonChimeServiceRolePolicy: string;
    /** Allows Amazon Chime to access Amazon Transcribe and Amazon Transcribe Medical on your behalf */
    static AmazonChimeTranscriptionServiceLinkedRolePolicy: string;
    /** Provides user management access to Amazon Chime Admin Console via the AWS Management Console. */
    static AmazonChimeUserManagement: string;
    /** Managed policy for Service Linked Role for Amazon Chime VoiceConnector */
    static AmazonChimeVoiceConnectorServiceLinkedRolePolicy: string;
    /** Provides full access to Amazon Cloud Directory Service. */
    static AmazonCloudDirectoryFullAccess: string;
    /** Provides read only access to Amazon Cloud Directory Service. */
    static AmazonCloudDirectoryReadOnlyAccess: string;
    /** Provides full only access to Amazon CloudWatch Evidently. Also provides access to related Amazon S3, Amazon SNS, Amazon CloudWatch, and other related services. */
    static AmazonCloudWatchEvidentlyFullAccess: string;
    /** Provides read only access to Amazon CloudWatch Evidently */
    static AmazonCloudWatchEvidentlyReadOnlyAccess: string;
    /** Allows CloudWatch Evidently Service to manage associated AWS Resources on behalf of the customer */
    static AmazonCloudWatchEvidentlyServiceRolePolicy: string;
    /** Grants full access permissions for the Amazon CloudWatch RUM service */
    static AmazonCloudWatchRUMFullAccess: string;
    /** Grants read only permissions for the Amazon CloudWatch RUM service */
    static AmazonCloudWatchRUMReadOnlyAccess: string;
    /** Grants permission to Amazon CloudWatch RUM Service to publish monitoring data to other relevant AWS services */
    static AmazonCloudWatchRUMServiceRolePolicy: string;
    /** Provides full access to Amazon CodeCatalyst */
    static AmazonCodeCatalystFullAccess: string;
    /** Provides read only access to Amazon CodeCatalyst */
    static AmazonCodeCatalystReadOnlyAccess: string;
    /** Allows Amazon CodeCatalyst to create, update, and resolve AWS Support cases on your behalf. */
    static AmazonCodeCatalystSupportAccess: string;
    /** Provides access required by Amazon CodeGuru Profiler agent. */
    static AmazonCodeGuruProfilerAgentAccess: string;
    /** Provides full access to Amazon CodeGuru Profiler. */
    static AmazonCodeGuruProfilerFullAccess: string;
    /** Provides read only access to Amazon CodeGuru Profiler. */
    static AmazonCodeGuruProfilerReadOnlyAccess: string;
    /** Grants full access to Amazon CodeGuru Reviewer and scoped access to required dependencies. */
    static AmazonCodeGuruReviewerFullAccess: string;
    /** Provides read only access to Amazon CodeGuru Reviewer. */
    static AmazonCodeGuruReviewerReadOnlyAccess: string;
    /** A service-linked role required for Amazon CodeGuru Reviewer to access resources on your behalf. */
    static AmazonCodeGuruReviewerServiceRolePolicy: string;
    /** Provides full access to Amazon CodeGuru Security. */
    static AmazonCodeGuruSecurityFullAccess: string;
    /** Provides access required for working with Amazon CodeGuru Security scans. */
    static AmazonCodeGuruSecurityScanAccess: string;
    /** Provides access to Amazon Cognito APIs to support developer authenticated identities from your authentication backend. */
    static AmazonCognitoDeveloperAuthenticatedIdentities: string;
    /** Allows Amazon Cognito User Pools service to use your SES identities for email sending */
    static AmazonCognitoIdpEmailServiceRolePolicy: string;
    /** Enables access to AWS Services and Resources used or managed by Amazon Cognito User Pools */
    static AmazonCognitoIdpServiceRolePolicy: string;
    /** Provides administrative access to existing Amazon Cognito resources. You will need AWS account admin privileges to create new Cognito resources. */
    static AmazonCognitoPowerUser: string;
    /** Provides read only access to Amazon Cognito resources. */
    static AmazonCognitoReadOnly: string;
    /** This policy defines the set of permissions allowed for unauthenticated identities for Cognito Identity Pools. This policy is not intended to be used as a stand alone permission policy. It is used as a guardrail against overly permissive policies attached for roles in an identity pool. Do not attach this policy to any roles, as Cognito Identity Service will automatically include it as a scoped down policy when creating credentials. The privileges to temporarily access other AWS resources through the enhanced flow will now be defined by the intersection of the role associated with the identity of the unauthenticated user provided by a service, and the privileges given in this managed policy that is owned by Cognito. */
    static AmazonCognitoUnAuthedIdentitiesSessionPolicy: string;
    /** This policy defines the set of permissions allowed for unauthenticated identities for Cognito Identity Pools. This does not need to be attached to your unauth role, as Cognito Identity Service will automatically include it as a scoped down policy when creating credentials. The privileges to temporarily access other AWS resources through the enhanced flow will now be defined by the intersection of the role associated with the identity of the unauthenticated user provided by a service, and the privileges given in this managed policy that is owned by Cognito. */
    static AmazonCognitoUnauthenticatedIdentities: string;
    /** The purpose of this policy is to grant permissions to AWS Connect users required to use Connect resources. This policy provides full access to AWS Connect resources via the Connect Console and public APIs */
    static AmazonConnectFullAccess: string;
    /** Policy for Amazon Connect Campaigns service linked role */
    static AmazonConnectCampaignsServiceLinkedRolePolicy: string;
    /** Grants permission to view the Amazon Connect instances in your AWS account. */
    static AmazonConnectReadOnlyAccess: string;
    /** Allows Amazon Connect to create and manage AWS resources on your behalf. */
    static AmazonConnectServiceLinkedRolePolicy: string;
    /** Allows Amazon Connect to synchronize AWS resources across regions on your behalf. */
    static AmazonConnectSynchronizationServiceRolePolicy: string;
    /** Provides full access to Amazon Connect Voice ID */
    static AmazonConnectVoiceIDFullAccess: string;
    /** Provides permissions to consume Amazon Bedrock models, including invoking Amazon Bedrock application inference profile created for particular Amazon DataZone domain. */
    static AmazonDataZoneBedrockModelConsumptionPolicy: string;
    /** Provides permissions to manage Amazon Bedrock model access, including creating, tagging and deleting application inference profiles. */
    static AmazonDataZoneBedrockModelManagementPolicy: string;
    /** Default policy for the Amazon DataZone's DomainExecutionRole service role. This role is used by Amazon DataZone to catalog, discover, govern, share, and analyze data in the Amazon DataZone domain. */
    static AmazonDataZoneDomainExecutionRolePolicy: string;
    /** Amazon DataZone creates IAM roles for Environments to perform data analytics actions, and uses this policy when creating these roles to define the boundary of their permissions. */
    static AmazonDataZoneEnvironmentRolePermissionsBoundary: string;
    /** Provides full access to Amazon DataZone via the AWS Management Console as well as limited access to related services that are required by it. */
    static AmazonDataZoneFullAccess: string;
    /** Provides full access to Amazon DataZone, but does not allow the management of domains, users, or associated accounts. */
    static AmazonDataZoneFullUserAccess: string;
    /** The policy grants permissions to allow Amazon DataZone to enable publishing and access grants to data. */
    static AmazonDataZoneGlueManageAccessRolePolicy: string;
    /** Amazon DataZone is a data management service that enables you to catalog, discover, govern, share, and analyze your data. With Amazon DataZone, you can share and access your data across accounts and supported regions. Amazon DataZone simplifies your experience across AWS services, including, but not limited to, Amazon Redshift, Amazon Athena, AWS Glue, and AWS Lake Formation. */
    static AmazonDataZoneRedshiftGlueProvisioningPolicy: string;
    /** This policy gives Amazon DataZone permissions to publish Amazon Redshift data to the catalog. It also gives Amazon DataZone permissions to grant access or revoke access to Amazon Redshift or Amazon Redshift Serverless published assets in the catalog. */
    static AmazonDataZoneRedshiftManageAccessRolePolicy: string;
    /** The AmazonDataZoneSageMakerEnvironmentRolePermissionsBoundary policy is the list of permissions that are permitted on an execution role created in a SageMaker environment provisioned by Amazon DataZone. */
    static AmazonDataZoneSageMakerEnvironmentRolePermissionsBoundary: string;
    /** The AmazonDataZoneSageMakerManageAccessRolePolicy policy grants Amazon DataZone the permissions required to grant user access to various resources in the SageMaker environment. */
    static AmazonDataZoneSageMakerManageAccessRolePolicy: string;
    /** The AmazonDataZoneSageMakerProvisioningRolePolicy policy grants Amazon DataZone the permissions required to interoperate with Amazon SageMaker. */
    static AmazonDataZoneSageMakerProvisioningRolePolicy: string;
    /**  Provides full access to Amazon Detective service and scoped access to the console UI dependencies */
    static AmazonDetectiveFullAccess: string;
    /** Provides investigator access to Amazon Detective service and scoped access to the console UI dependencies. This policy grants permission to dive into Detective for investigation purposes and limited write access to Guardduty. */
    static AmazonDetectiveInvestigatorAccess: string;
    /** Provides member access to Amazon Detective service and scoped access to the console UI dependencies. */
    static AmazonDetectiveMemberAccess: string;
    /** Provides Organizations access to manage Delegated administrator for Amazon Detective and scoped access to the console UI dependencies. This also grants permission to create a service-linked role for Detective. */
    static AmazonDetectiveOrganizationsAccess: string;
    /** Allows Amazon Detective to make service calls on your behalf */
    static AmazonDetectiveServiceLinkedRolePolicy: string;
    /** The policy grants full-access to the DevOps Guru console. */
    static AmazonDevOpsGuruConsoleFullAccess: string;
    /** Provides full access to Amazon DevOps Guru. */
    static AmazonDevOpsGuruFullAccess: string;
    /** Provide access to enable and manage Amazon DevOps Guru within an organization. */
    static AmazonDevOpsGuruOrganizationsAccess: string;
    /** Provides read only access to Amazon DevOps Guru Console. */
    static AmazonDevOpsGuruReadOnlyAccess: string;
    /** A service-linked role required for Amazon DevOpsGuru to access your resources. */
    static AmazonDevOpsGuruServiceRolePolicy: string;
    /** Provides access to upload DMS replication logs to cloudwatch logs in customer account. */
    static AmazonDMSCloudWatchLogsRole: string;
    /** Provides access to manage S3 settings for Redshift endpoints for DMS. */
    static AmazonDMSRedshiftS3Role: string;
    /** Provides access to manage VPC settings for AWS managed customer configurations */
    static AmazonDMSVPCManagementRole: string;
    /** Allows Amazon DocumentDB-Elastic to manage AWS resources on your behalf. */
    static AmazonDocDBElasticServiceRolePolicy: string;
    /** Provides full access to manage Amazon DocumentDB with MongoDB compatibility using the AWS Management Console. Note this policy also grants full access to publish on all SNS topics within the account, permissions to create and edit Amazon EC2 instances and VPC configurations, permissions to view and list keys on Amazon KMS, and full access to Amazon RDS and Amazon Neptune. */
    static AmazonDocDBConsoleFullAccess: string;
    /** Provides full access to Amazon DocumentDB Elastic Clusters and other required permissions for its dependencies including EC2, KMS, SecretsManager, CloudWatch and IAM. */
    static AmazonDocDBElasticFullAccess: string;
    /** Provides read-only access to Amazon DocDB-Elastic and CloudWatch metrics. */
    static AmazonDocDBElasticReadOnlyAccess: string;
    /** Provides full access to Amazon DocumentDB with MongoDB compatibility. Note this policy also grants full access to publish on all SNS topics within the account and full access to Amazon RDS and Amazon Neptune. */
    static AmazonDocDBFullAccess: string;
    /** Provides read-only access to Amazon DocumentDB with MongoDB compatibility. Note that this policy also grants access to Amazon RDS and Amazon Neptune resources. */
    static AmazonDocDBReadOnlyAccess: string;
    /** Provides access to manage VPC settings for Amazon managed customer configurations */
    static AmazonDRSVPCManagement: string;
    /** Provides full access to Amazon DynamoDB via the AWS Management Console. */
    static AmazonDynamoDBFullAccess: string;
    /** Provides full access to Amazon DynamoDB */
    static AmazonDynamoDBFullAccessV2: string;
    /** This policy is on a deprecation path. See documentation for guidance: https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DynamoDBPipeline.html. Provides full access to Amazon DynamoDB including Export/Import using AWS Data Pipeline via the AWS Management Console. */
    static AmazonDynamoDBFullAccesswithDataPipeline: string;
    /** Provides read only access to Amazon DynamoDB via the AWS Management Console. */
    static AmazonDynamoDBReadOnlyAccess: string;
    /** IAM Policy that allows the CSI driver service account to make calls to related services such as EC2 on your behalf. */
    static AmazonEBSCSIDriverPolicy: string;
    /** Provides administrative access to Amazon ECR resources */
    static AmazonEC2ContainerRegistryFullAccess: string;
    /** Provides full access to Amazon EC2 Container Registry repositories, but does not allow repository deletion or policy changes. */
    static AmazonEC2ContainerRegistryPowerUser: string;
    /** Provides access to pull images from Amazon EC2 Container Registry repositories. */
    static AmazonEC2ContainerRegistryPullOnly: string;
    /** Provides read-only access to Amazon EC2 Container Registry repositories. */
    static AmazonEC2ContainerRegistryReadOnly: string;
    /**   Policy to enable Task Autoscaling for Amazon EC2 Container Service */
    static AmazonEC2ContainerServiceAutoscaleRole: string;
    /** Policy to enable CloudWatch Events for EC2 Container Service */
    static AmazonEC2ContainerServiceEventsRole: string;
    /** Default policy for the Amazon EC2 Role for Amazon EC2 Container Service. */
    static AmazonEC2ContainerServiceforEC2Role: string;
    /** Default policy for Amazon ECS service role. */
    static AmazonEC2ContainerServiceRole: string;
    /** Provides full access to Amazon EC2 via the AWS Management Console. */
    static AmazonEC2FullAccess: string;
    /** Provides read-only access to scan all supported resource types for relevant data when using DescribeImageReferences. */
    static AmazonEC2ImageReferencesAccessPolicy: string;
    /** Provides read only access to Amazon EC2 via the AWS Management Console. */
    static AmazonEC2ReadOnlyAccess: string;
    /** Provides EC2 access to S3 bucket to download revision. This role is needed by the CodeDeploy agent on EC2 instances. */
    static AmazonEC2RoleforAWSCodeDeploy: string;
    /** Provides EC2 limited access to S3 bucket to download revision. This role is needed by the CodeDeploy agent on EC2 instances. */
    static AmazonEC2RoleforAWSCodeDeployLimited: string;
    /** Default policy for the Amazon EC2 Role for Data Pipeline service role. */
    static AmazonEC2RoleforDataPipelineRole: string;
    /** This policy will soon be deprecated. Please use AmazonSSMManagedInstanceCore policy to enable AWS Systems Manager service core functionality on EC2 instances. For more information see https://docs.aws.amazon.com/systems-manager/latest/userguide/setup-instance-profile.html */
    static AmazonEC2RoleforSSM: string;
    /** Managed policy for the Amazon LaunchWizard service role for EC2 */
    static AmazonEC2RolePolicyForLaunchWizard: string;
    /** Policy to enable Autoscaling for Amazon EC2 Spot Fleet */
    static AmazonEC2SpotFleetAutoscaleRole: string;
    /** Allows EC2 Spot Fleet to request, terminate and tag Spot Instances on your behalf. */
    static AmazonEC2SpotFleetTaggingRole: string;
    /** Provides administrative access to Amazon ECS resources and enables ECS features through access to other AWS service resources, including VPCs, Auto Scaling groups, and CloudFormation stacks. */
    static AmazonECSFullAccess: string;
    /** Policy to enable Amazon ECS Compute to manage your EC2 instances and related resources as part of ECS managed instances */
    static AmazonECSComputeServiceRolePolicy: string;
    /** Provides access to other AWS service resources required to manage load balancers associated with ECS workloads on your behalf. */
    static AmazonECSInfrastructureRolePolicyForLoadBalancers: string;
    /** Provides administrative access to Private Certificate Authority, AWS Secrets Manager and other AWS Services required to manage ECS Service Connect TLS features on your behalf. */
    static AmazonECSInfrastructureRolePolicyForServiceConnectTransportLayerSecurity: string;
    /** Provides access to other AWS service resources required to manage volumes associated with ECS workloads on your behalf. */
    static AmazonECSInfrastructureRolePolicyForVolumes: string;
    /** Provides access to other AWS service resources required to manage VPC Lattice feature in ECS workloads on your behalf. */
    static AmazonECSInfrastructureRolePolicyForVpcLattice: string;
    /** Policy to enable Amazon ECS to manage your cluster. */
    static AmazonECSServiceRolePolicy: string;
    /** Provides access to other AWS service resources that are required to run Amazon ECS tasks */
    static AmazonECSTaskExecutionRolePolicy: string;
    /** Provides management access to EFS resources and read access to EC2 */
    static AmazonEFSCSIDriverPolicy: string;
    /** This policy provides the Amazon VPC CNI Plugin (amazon-vpc-cni-k8s) the permissions it requires to modify the IP address configuration on your EKS worker nodes. This permission set allows the CNI to list, describe, and modify Elastic Network Interfaces on your behalf. More information on the AWS VPC CNI Plugin is available here: https://github.com/aws/amazon-vpc-cni-k8s */
    static AmazonEKSCNIPolicy: string;
    /** Policy attached to the EKS Cluster Role that grants permissions to manage the cluster's block storage resources. */
    static AmazonEKSBlockStoragePolicy: string;
    /** This policy provides Kubernetes the permissions it requires to manage resources on your behalf. Kubernetes requires Ec2:CreateTags permissions to place identifying information on EC2 resources including but not limited to Instances, Security Groups, and Elastic Network Interfaces. */
    static AmazonEKSClusterPolicy: string;
    /** Policy attached to the EKS Cluster Role that grants permissions to manage the cluster's compute resources. */
    static AmazonEKSComputePolicy: string;
    /** This policy allows Amazon EKS to manage AWS resources for EKS connector */
    static AmazonEKSConnectorServiceRolePolicy: string;
    /** Provides read only access to view the dashboard in the Amazon EKS console. The dashboard aggregates information about multiple clusters and related resources using AWS Organizations. */
    static AmazonEKSDashboardConsoleReadOnly: string;
    /** This policy enables the Amazon EKS Dashboard to access and display organization-wide information. The policy allows the EKS Dashboard service to gather information about your AWS Organizations structure and accounts. */
    static AmazonEKSDashboardServiceRolePolicy: string;
    /** Provides access to other AWS service resources that are required to run Amazon EKS pods on AWS Fargate */
    static AmazonEKSFargatePodExecutionRolePolicy: string;
    /** This policy grants necessary permissions to Amazon EKS to run fargate tasks */
    static AmazonEKSForFargateServiceRolePolicy: string;
    /** Policy attached to the EKS Cluster Role that grants permissions to manage the cluster's load balancing resources. */
    static AmazonEKSLoadBalancingPolicy: string;
    /** This policy provides permissions to EKS local cluster's control-plane instances running in your account to manage resources on your behalf. */
    static AmazonEKSLocalOutpostClusterPolicy: string;
    /** Allows Amazon EKS Local to call AWS services on your behalf. */
    static AmazonEKSLocalOutpostServiceRolePolicy: string;
    /** Policy attached to the EKS Cluster Role that grants permissions to manage the cluster's networking resources. */
    static AmazonEKSNetworkingPolicy: string;
    /** This policy allows Amazon Elastic Container Service for Kubernetes to create and manage the necessary resources to operate EKS Clusters. */
    static AmazonEKSServicePolicy: string;
    /** A Service-Linked Role required for Amazon EKS to call AWS services on your behalf. */
    static AmazonEKSServiceRolePolicy: string;
    /** Policy used by VPC Resource Controller to manage ENI and IPs for worker nodes. */
    static AmazonEKSVPCResourceController: string;
    /** This policy allows Amazon EKS worker nodes to connect to Amazon EKS Clusters. */
    static AmazonEKSWorkerNodeMinimalPolicy: string;
    /** This policy allows Amazon EKS worker nodes to connect to Amazon EKS Clusters. */
    static AmazonEKSWorkerNodePolicy: string;
    /** Provides full access to Amazon ElastiCache via the AWS Management Console. */
    static AmazonElastiCacheFullAccess: string;
    /** Provides read only access to Amazon ElastiCache via the AWS Management Console. */
    static AmazonElastiCacheReadOnlyAccess: string;
    /** Provides administrative access to Amazon ECR Public resources */
    static AmazonElasticContainerRegistryPublicFullAccess: string;
    /** Provides full access to Amazon ECR Public repositories, but does not allow repository deletion or policy changes. */
    static AmazonElasticContainerRegistryPublicPowerUser: string;
    /** Provides read-only access to Amazon ECR Public repositories. */
    static AmazonElasticContainerRegistryPublicReadOnly: string;
    /** Provides root client access to an Amazon EFS file system */
    static AmazonElasticFileSystemClientFullAccess: string;
    /** Provides read only client access to an Amazon EFS file system */
    static AmazonElasticFileSystemClientReadOnlyAccess: string;
    /** Provides read and write client access to an Amazon EFS file system */
    static AmazonElasticFileSystemClientReadWriteAccess: string;
    /** Provides full access to Amazon EFS via the AWS Management Console. */
    static AmazonElasticFileSystemFullAccess: string;
    /** Provides read only access to Amazon EFS via the AWS Management Console. */
    static AmazonElasticFileSystemReadOnlyAccess: string;
    /** Allows Amazon Elastic File System to manage AWS resources on your behalf */
    static AmazonElasticFileSystemServiceRolePolicy: string;
    /** Allows customers to use AWS Systems Manager to automatically manage Amazon EFS utilities (amazon-efs-utils) package on their EC2 instances, and use CloudWatchLog to get EFS file system mount success/failure notifications. */
    static AmazonElasticFileSystemsUtils: string;
    /** Default policy for the Amazon Elastic MapReduce Editors service role. */
    static AmazonElasticMapReduceEditorsRole: string;
    /** Amazon Elastic MapReduce for Auto Scaling. Role to allow Auto Scaling to add and remove instances from your EMR cluster. */
    static AmazonElasticMapReduceforAutoScalingRole: string;
    /** Default policy for the Amazon Elastic MapReduce for EC2 service role. */
    static AmazonElasticMapReduceforEC2Role: string;
    /** This policy is on a deprecation path. See documentation for guidance: https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-iam-policies.html. Provides full access to Amazon Elastic MapReduce and underlying services that it requires such as EC2 and S3 */
    static AmazonElasticMapReduceFullAccess: string;
    /** Policy to allow EMR to create, describe and delete EC2 placement groups. */
    static AmazonElasticMapReducePlacementGroupPolicy: string;
    /** Provides read only access to Amazon Elastic MapReduce via the AWS Management Console. */
    static AmazonElasticMapReduceReadOnlyAccess: string;
    /** This policy is on a deprecation path. See documentation for guidance: https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-iam-policies.html.  Default policy for the Amazon Elastic MapReduce service role. */
    static AmazonElasticMapReduceRole: string;
    /** Allow Amazon Elasticsearch Service to access other AWS services such as EC2 Networking APIs on your behalf. */
    static AmazonElasticsearchServiceRolePolicy: string;
    /** Grants users full access to Elastic Transcoder and the access to associated services that is required for full Elastic Transcoder functionality. */
    static AmazonElasticTranscoderFullAccess: string;
    /** Grants users permission to change presets, submit jobs, and view Elastic Transcoder settings. This policy also grants some read-only access to some other services required to use the Elastic Transcode console, including S3, IAM, and SNS. */
    static AmazonElasticTranscoderJobsSubmitter: string;
    /** Grants users read-only access to Elastic Transcoder and list access to related services. */
    static AmazonElasticTranscoderReadOnlyAccess: string;
    /** Default policy for the Amazon Elastic Transcoder service role. */
    static AmazonElasticTranscoderRole: string;
    /** Allows the actions that EMR requires to terminate and delete AWS EC2 resources if the EMR Service role has lost that ability. */
    static AmazonEMRCleanupPolicy: string;
    /** Allows access to other AWS service resources that are required to run Amazon EMR */
    static AmazonEMRContainersServiceRolePolicy: string;
    /** Provides full access to Amazon EMR */
    static AmazonEMRFullAccessPolicyV2: string;
    /** Provides read only access to Amazon EMR and the associated CloudWatch Metrics. */
    static AmazonEMRReadOnlyAccessPolicyV2: string;
    /** Allows access to other AWS service resources that are required to run Amazon EMRServerless */
    static AmazonEMRServerlessServiceRolePolicy: string;
    /** This policy is used for the Amazon EMR Service Role and should NOT be used for any other IAM users or roles in your account. The policy grants permissions to create and manage resources associated with EMR and related services necessary for the operation of your EMR cluster. */
    static AmazonEMRServicePolicyV2: string;
    /** Provides limited access to the Amazon Cognito configuration service. */
    static AmazonESCognitoAccess: string;
    /** Provides full access to the Amazon ES configuration service. */
    static AmazonESFullAccess: string;
    /** Provides read-only access to the Amazon ES configuration service. */
    static AmazonESReadOnlyAccess: string;
    /** Allows EventBridge to access Secret Manager resources on your behalf. */
    static AmazonEventBridgeApiDestinationsServiceRolePolicy: string;
    /** Provides full access to Amazon EventBridge. */
    static AmazonEventBridgeFullAccess: string;
    /** Provides full access to Amazon EventBridge Pipes. */
    static AmazonEventBridgePipesFullAccess: string;
    /** Provides read-only and operator (ability to Stop and Start running Pipes) access to Amazon EventBridge Pipes. */
    static AmazonEventBridgePipesOperatorAccess: string;
    /** Provides read-only access to Amazon EventBridge Pipes. */
    static AmazonEventBridgePipesReadOnlyAccess: string;
    /** Provides read only access to Amazon EventBridge. */
    static AmazonEventBridgeReadOnlyAccess: string;
    /** The AmazonEventBridgeSchedulerFullAccess managed policy grants permissions to use all EventBridge Scheduler actions for schedules, and schedule groups. */
    static AmazonEventBridgeSchedulerFullAccess: string;
    /** The AmazonEventBridgeSchedulerReadOnlyAccess managed policy grants read-only permissions to view details about your schedules and schedule groups */
    static AmazonEventBridgeSchedulerReadOnlyAccess: string;
    /** Provides full access to Amazon EventBridge Schemas. */
    static AmazonEventBridgeSchemasFullAccess: string;
    /** Provides read only access to Amazon EventBridge Schemas. */
    static AmazonEventBridgeSchemasReadOnlyAccess: string;
    /** Grants permissions to Managed Rules created by Amazon EventBridge schemas. */
    static AmazonEventBridgeSchemasServiceRolePolicy: string;
    /** Grants permissions to EVS to manage resources on your behalf */
    static AmazonEVSServiceRolePolicy: string;
    /** Policy to enable AWS FIS to manage monitoring and resource selection for experiments. */
    static AmazonFISServiceRolePolicy: string;
    /** Gives access to all actions for Amazon Forecast */
    static AmazonForecastFullAccess: string;
    /** Gives access to all actions for Amazon Fraud Detector */
    static AmazonFraudDetectorFullAccessPolicy: string;
    /** Full Access Policy for Amazon FreeRTOS */
    static AmazonFreeRTOSFullAccess: string;
    /** Allows user to access Amazon FreeRTOS OTA Update */
    static AmazonFreeRTOSOTAUpdate: string;
    /** Provides full access to Amazon FSx and access to related AWS services via the AWS Management Console. */
    static AmazonFSxConsoleFullAccess: string;
    /** Provides read only access to Amazon FSx and access to related AWS services via the AWS Management Console. */
    static AmazonFSxConsoleReadOnlyAccess: string;
    /** Provides full access to Amazon FSx and access to related AWS services. */
    static AmazonFSxFullAccess: string;
    /** Provides read only access to Amazon FSx. */
    static AmazonFSxReadOnlyAccess: string;
    /** Allows Amazon FSx to manage AWS resources on your behalf */
    static AmazonFSxServiceRolePolicy: string;
    /** Provides full access to Amazon Glacier via the AWS Management Console. */
    static AmazonGlacierFullAccess: string;
    /** Provides read only access to Amazon Glacier via the AWS Management Console. */
    static AmazonGlacierReadOnlyAccess: string;
    /** This policy grants access to Amazon Athena and the dependencies needed to enable querying and writing results to s3 from the Amazon Athena plugin in Amazon Grafana. */
    static AmazonGrafanaAthenaAccess: string;
    /** This policy grants access to Amazon CloudWatch and the dependencies needed to use CloudWatch as a datasource within Amazon Managed Grafana. */
    static AmazonGrafanaCloudWatchAccess: string;
    /** This policy grants scoped access to Amazon Redshift and the dependencies needed to use the Amazon Redshift plugin in Amazon Grafana. */
    static AmazonGrafanaRedshiftAccess: string;
    /** Provides access to AWS Resources managed or used by Amazon Grafana. */
    static AmazonGrafanaServiceLinkedRolePolicy: string;
    /** Provides full access to use Amazon GuardDuty. */
    static AmazonGuardDutyFullAccess: string;
    /** Provides full access to use Amazon GuardDuty */
    static AmazonGuardDutyFullAccessV2: string;
    /** GuardDuty malware protection uses the service-linked role (SLR) named AWSServiceRoleForAmazonGuardDutyMalwareProtection. This service-linked role allows GuardDuty malware protection to perform agent-less scans to detect malware. It allows GuardDuty to create snapshots in your account, and share the snapshots with the GuardDuty service account to scan for malware. It evaluates these shared snapshots and includes the retrieved EC2 instance metadata in the GuardDuty Malware Protection findings. The AWSServiceRoleForAmazonGuardDutyMalwareProtection service-linked role trusts the malware-protection.guardduty.amazonaws.com service to assume the role. */
    static AmazonGuardDutyMalwareProtectionServiceRolePolicy: string;
    /** Provides read only access to Amazon GuardDuty resources */
    static AmazonGuardDutyReadOnlyAccess: string;
    /** Enable access to AWS Resources used or managed by Amazon Guard Duty */
    static AmazonGuardDutyServiceRolePolicy: string;
    /** Provides full access to Amazon HealthLake service. */
    static AmazonHealthLakeFullAccess: string;
    /** Provides read only access to Amazon HealthLake service. */
    static AmazonHealthLakeReadOnlyAccess: string;
    /** Provides full access to Honeycode via the AWS Management Console and the SDK. */
    static AmazonHoneycodeFullAccess: string;
    /** Provides read only access to Honeycode via the AWS Management Console and the SDK. */
    static AmazonHoneycodeReadOnlyAccess: string;
    /** A service-linked role required for Amazon Honeycode to access your resources. */
    static AmazonHoneycodeServiceRolePolicy: string;
    /** Provides full access to Honeycode Team Association via the AWS Management Console and the SDK. */
    static AmazonHoneycodeTeamAssociationFullAccess: string;
    /** Provides read only access to Honeycode Team Association via the AWS Management Console and the SDK. */
    static AmazonHoneycodeTeamAssociationReadOnlyAccess: string;
    /** Provides full access to Honeycode Workbook via the AWS Management Console and the SDK. */
    static AmazonHoneycodeWorkbookFullAccess: string;
    /** Provides read only access to Honeycode Workbook via the AWS Management Console and the SDK. */
    static AmazonHoneycodeWorkbookReadOnlyAccess: string;
    /** Grants Amazon Inspector access to AWS Services needed to perform agent-less security assessments */
    static AmazonInspector2AgentlessServiceRolePolicy: string;
    /** Provides full access to Amazon Inspector and access to other related services such as organizations. */
    static AmazonInspector2FullAccess: string;
    /** Provides full access to Amazon Inspector and access to other related services such as organizations with restrictive organizational access. */
    static AmazonInspector2FullAccessV2: string;
    /** This is a managed policy that customer should attach to their roles to communicate with inspector service for CIS scans */
    static AmazonInspector2ManagedCisPolicy: string;
    /** Provides read only access to the Amazon inspector2 service and relevant support services */
    static AmazonInspector2ReadOnlyAccess: string;
    /** Grants Amazon Inspector access to AWS Services needed to perform security assessments */
    static AmazonInspector2ServiceRolePolicy: string;
    /** Provides full access to Amazon Inspector. */
    static AmazonInspectorFullAccess: string;
    /** Provides read only access to Amazon Inspector. */
    static AmazonInspectorReadOnlyAccess: string;
    /** Grants Amazon Inspector access to AWS Services needed to perform security assessments */
    static AmazonInspectorServiceRolePolicy: string;
    /** Provides full access to Amazon Kendra via the AWS Management Console. */
    static AmazonKendraFullAccess: string;
    /** Provides read only access to Amazon Kendra via the AWS Management Console. */
    static AmazonKendraReadOnlyAccess: string;
    /** Provide full access to Amazon Keyspaces */
    static AmazonKeyspacesFullAccess: string;
    /** Provide read only access to Amazon Keyspaces */
    static AmazonKeyspacesReadOnlyAccess: string;
    /** Provide read only access to Amazon Keyspaces and related AWS services. */
    static AmazonKeyspacesReadOnlyAccessV2: string;
    /** Provides full access to Amazon Kinesis Analytics via the AWS Management Console. */
    static AmazonKinesisAnalyticsFullAccess: string;
    /** Provides read-only access to Amazon Kinesis Analytics via the AWS Management Console. */
    static AmazonKinesisAnalyticsReadOnly: string;
    /** Provides full access to all Amazon Kinesis Firehose Delivery Streams. */
    static AmazonKinesisFirehoseFullAccess: string;
    /** Provides read only access to all Amazon Kinesis Firehose Delivery Streams. */
    static AmazonKinesisFirehoseReadOnlyAccess: string;
    /** Provides full access to all streams via the AWS Management Console. */
    static AmazonKinesisFullAccess: string;
    /** Provides read only access to all streams via the AWS Management Console. */
    static AmazonKinesisReadOnlyAccess: string;
    /** Provides full access to Amazon Kinesis Video Streams via the AWS Management Console. */
    static AmazonKinesisVideoStreamsFullAccess: string;
    /** Provides read only access to AWS Kinesis Video Streams via the AWS Management Console. */
    static AmazonKinesisVideoStreamsReadOnlyAccess: string;
    /** Full access to AWS Launch wizard and other required services. */
    static AmazonLaunchWizardFullAccessV2: string;
    /** This policy allows customers to call Lex runtime from channels */
    static AmazonLexChannelsAccess: string;
    /** Provides full access to Amazon Lex via the AWS Management Console.  Also provides access to create Lex Service Linked Roles and grant Lex permissions to invoke a limited set of Lambda functions. */
    static AmazonLexFullAccess: string;
    /** Provides read-only access to Amazon Lex. */
    static AmazonLexReadOnly: string;
    /** Allows Amazon Lex to replicate Lex resources across regions on your behalf. */
    static AmazonLexReplicationPolicy: string;
    /** Provides access to Amazon Lex conversational APIs. */
    static AmazonLexRunBotsOnly: string;
    /** Provides Lex V2 bots access to call other AWS services on your behalf. */
    static AmazonLexV2BotPolicy: string;
    /** Provides full access to Amazon Lookout for Equipment operations */
    static AmazonLookoutEquipmentFullAccess: string;
    /** Provides read only access to Amazon Lookout for Equipments */
    static AmazonLookoutEquipmentReadOnlyAccess: string;
    /** Gives access to all actions for Amazon Lookout for Metrics */
    static AmazonLookoutMetricsFullAccess: string;
    /** Gives access to all read-only actions for Amazon Lookout for Metrics */
    static AmazonLookoutMetricsReadOnlyAccess: string;
    /** Provides full access to Amazon Lookout for Vision and scoped access to required service and console dependencies. */
    static AmazonLookoutVisionConsoleFullAccess: string;
    /** Provides read only access to Amazon Lookout for Vision and scoped access to required service and console dependencies. */
    static AmazonLookoutVisionConsoleReadOnlyAccess: string;
    /** Provides full access to Amazon Lookout for Vision and scoped access to required dependencies. */
    static AmazonLookoutVisionFullAccess: string;
    /** Provides read only access to Amazon Lookout for Vision and scoped access to required dependencies. */
    static AmazonLookoutVisionReadOnlyAccess: string;
    /** Grants users permission to request Amazon Machine Learning batch predictions. */
    static AmazonMachineLearningBatchPredictionsAccess: string;
    /** Provides create access for non-prediction Amazon Machine Learning resources. */
    static AmazonMachineLearningCreateOnlyAccess: string;
    /** Provides full access to Amazon Machine Learning resources. */
    static AmazonMachineLearningFullAccess: string;
    /** Grants users permission to create and delete the real-time endpoint for Amazon Machine Learning models. */
    static AmazonMachineLearningManageRealTimeEndpointOnlyAccess: string;
    /** Provides read only access to Amazon Machine Learning resources. */
    static AmazonMachineLearningReadOnlyAccess: string;
    /** Grants users permission to request Amazon Machine Learning real-time predictions. */
    static AmazonMachineLearningRealTimePredictionOnlyAccess: string;
    /** Allows Machine Learning to configure and use your Redshift Clusters and S3 Staging Locations for Redshift Data Source. */
    static AmazonMachineLearningRoleforRedshiftDataSourceV3: string;
    /** Provides full access to Amazon Macie. */
    static AmazonMacieFullAccess: string;
    /** Grants permission to create the service-linked role of Amazon Macie. */
    static AmazonMacieHandshakeRole: string;
    /** Provides readonly access to Amazon Macie. */
    static AmazonMacieReadOnlyAccess: string;
    /** Grants Macie read-only access to resource dependencies in your account in order to enable data analysis. */
    static AmazonMacieServiceRole: string;
    /** Service linked role for Amazon Macie */
    static AmazonMacieServiceRolePolicy: string;
    /** Provides full access to Amazon Managed Blockchain via the AWS Management Console */
    static AmazonManagedBlockchainConsoleFullAccess: string;
    /** Provides full access to Amazon Managed Blockchain. */
    static AmazonManagedBlockchainFullAccess: string;
    /** Provides read-only access to Amazon Managed Blockchain. */
    static AmazonManagedBlockchainReadOnlyAccess: string;
    /** Enables access to AWS Services and Resources used or managed by Amazon Managed Blockchain */
    static AmazonManagedBlockchainServiceRolePolicy: string;
    /** Provide full access to Amazon Managed Apache Cassandra Service */
    static AmazonMCSFullAccess: string;
    /** Provide read only access to Amazon Managed Apache Cassandra Service */
    static AmazonMCSReadOnlyAccess: string;
    /** Provides full access to all APIs in Amazon Mechanical Turk. */
    static AmazonMechanicalTurkFullAccess: string;
    /** Provides access to read only APIs in Amazon Mechanical Turk. */
    static AmazonMechanicalTurkReadOnly: string;
    /** Provides full access to Amazon MemoryDB via the AWS Management Console. */
    static AmazonMemoryDBFullAccess: string;
    /** Provides read only access to Amazon MemoryDB via the AWS Management Console. */
    static AmazonMemoryDBReadOnlyAccess: string;
    /** Provides read only access to all reports including financial data for all application resources. */
    static AmazonMobileAnalyticsFinancialReportAccess: string;
    /** Provides full access to all application resources. */
    static AmazonMobileAnalyticsFullAccess: string;
    /** Provides read only access to non financial reports for all application resources. */
    static AmazonMobileAnalyticsNonFinancialReportAccess: string;
    /** Provides write only access to put event data for all application resources. (Recommended for SDK integration) */
    static AmazonMobileAnalyticsWriteOnlyAccess: string;
    /** Provides full access to manage Amazon Monitron */
    static AmazonMonitronFullAccess: string;
    /** Provides full access to AmazonMQ via our API/SDK. */
    static AmazonMQApiFullAccess: string;
    /** Provides read only access to AmazonMQ via our API/SDK. */
    static AmazonMQApiReadOnlyAccess: string;
    /** Provides full access to AmazonMQ via the AWS Management Console. */
    static AmazonMQFullAccess: string;
    /** Provides read only access to AmazonMQ via the AWS Management Console. */
    static AmazonMQReadOnlyAccess: string;
    /** Service Linked Role Policy for AWS Amazon MQ */
    static AmazonMQServiceRolePolicy: string;
    /** Provide readonly access to Amazon MSK Connect */
    static AmazonMSKConnectReadOnlyAccess: string;
    /** Provide full access to Amazon MSK and other required permissions for its dependencies. */
    static AmazonMSKFullAccess: string;
    /** Provide readonly access to Amazon MSK */
    static AmazonMSKReadOnlyAccess: string;
    /** The Service Linked Role used by Amazon Managed Workflows for Apache Airflow. */
    static AmazonMWAAServiceRolePolicy: string;
    /** This policy grants access to resources needed by Nimble Studio Launch Profile workers. Attach this policy to EC2 instances created by Nimble Studio Builder. */
    static AmazonNimbleStudioLaunchProfileWorker: string;
    /** This policy grants access to Amazon Nimble Studio resources associated with the studio admin and related studio resources in other services. Attach this policy to the Admin role associated with your studio. */
    static AmazonNimbleStudioStudioAdmin: string;
    /** This policy grants access to Amazon Nimble Studio resources associated with the studio user and related studio resources in other services. Attach this policy to the User role associated with your studio. */
    static AmazonNimbleStudioStudioUser: string;
    /** Allows Oracle Database@AWS to manage AWS resources on your behalf. */
    static AmazonODBServiceRolePolicy: string;
    /** Provides full access to Amazon Omics and other required AWS Services. This policy allows the user to view and accept RAM share invitations to access resources outside of the user's AWS account. */
    static AmazonOmicsFullAccess: string;
    /** Provide read only access to Amazon Omics */
    static AmazonOmicsReadOnlyAccess: string;
    /** This policy grants administrative permissions that allow access to all Amazon One Enterprise resources and operations. */
    static AmazonOneEnterpriseFullAccess: string;
    /** This policy grants limited read and write permissions that allow device installation and activation. */
    static AmazonOneEnterpriseInstallerAccess: string;
    /** This policy grants read only permissions to all Amazon One Enterprise resources and operations. */
    static AmazonOneEnterpriseReadOnlyAccess: string;
    /** Provides access to Amazon OpenSearch Dashboards Service to access other AWS services such as CloudWatch on your behalf */
    static AmazonOpenSearchDashboardsServiceRolePolicy: string;
    /** Allows OpenSearch DirectQuery Service to access AWS Glue APIs for creating resources on your behalf. */
    static AmazonOpenSearchDirectQueryGlueCreateAccess: string;
    /** Allows Amazon OpenSearch Ingestion to access other AWS services on your behalf. */
    static AmazonOpenSearchIngestionFullAccess: string;
    /** Provides read only access to the Amazon OpenSearch Ingestion Service */
    static AmazonOpenSearchIngestionReadOnlyAccess: string;
    /** Allows Amazon OpenSearch Ingestion Service to access other AWS services on your behalf. */
    static AmazonOpenSearchIngestionServiceRolePolicy: string;
    /** Allow Amazon OpenSearch Serverless to access other AWS services such as CloudWatch APIs on your behalf. */
    static AmazonOpenSearchServerlessServiceRolePolicy: string;
    /** Provides access to the Amazon Cognito configuration service. */
    static AmazonOpenSearchServiceCognitoAccess: string;
    /** Provides full access to the Amazon OpenSearch Service configuration service. */
    static AmazonOpenSearchServiceFullAccess: string;
    /** Provides read-only access to the Amazon OpenSearch Service configuration service. */
    static AmazonOpenSearchServiceReadOnlyAccess: string;
    /** Allow Amazon OpenSearch Service to access other AWS services such as EC2 Networking APIs on your behalf. */
    static AmazonOpenSearchServiceRolePolicy: string;
    /** Provides full access to Amazon Personalize via the AWS Management Console and SDK. Also provides select access to related services (e.g., S3, CloudWatch). */
    static AmazonPersonalizeFullAccess: string;
    /** Grants full access to Amazon Polly service and resources. */
    static AmazonPollyFullAccess: string;
    /** Grants read-only access to Amazon Polly resources. */
    static AmazonPollyReadOnlyAccess: string;
    /** Grants full access to AWS Managed Prometheus resources in the AWS console */
    static AmazonPrometheusConsoleFullAccess: string;
    /** Grants full access to AWS Managed Prometheus resources */
    static AmazonPrometheusFullAccess: string;
    /** Grants access to run queries against AWS Managed Prometheus resources */
    static AmazonPrometheusQueryAccess: string;
    /** Grants write only access to AWS Managed Prometheus workspaces */
    static AmazonPrometheusRemoteWriteAccess: string;
    /** Provides access to AWS Resources managed or used by Amazon Managed Service for Prometheus Collector */
    static AmazonPrometheusScraperServiceRolePolicy: string;
    /** Provides developer access to enable interactions with Amazon Q */
    static AmazonQDeveloperAccess: string;
    /** Provides full access to enable interactions with Amazon Q */
    static AmazonQFullAccess: string;
    /** Provides full access to Amazon QLDB via the AWS Management Console. */
    static AmazonQLDBConsoleFullAccess: string;
    /** Provides full access to Amazon QLDB via the service API. */
    static AmazonQLDBFullAccess: string;
    /** Provides read only access to Amazon QLDB. */
    static AmazonQLDBReadOnly: string;
    /** Allows Amazon RDS to manage AWS resources on your behalf. */
    static AmazonRDSBetaServiceRolePolicy: string;
    /** Allows Amazon RDS Custom to perform various automation actions and database management tasks through an EC2 instance profile. */
    static AmazonRDSCustomInstanceProfileRolePolicy: string;
    /** Amazon RDS Custom Preview Service Role Policy */
    static AmazonRDSCustomPreviewServiceRolePolicy: string;
    /** Allows Amazon RDS Custom to manage AWS resources on your behalf. */
    static AmazonRDSCustomServiceRolePolicy: string;
    /** Allows full access to use the RDS data APIs, secret store APIs for RDS database credentials, and DB console query management APIs to execute SQL statements on Aurora Serverless clusters in the AWS account. */
    static AmazonRDSDataFullAccess: string;
    /** Allow RDS to access Directory Service Managed AD on behalf of the customer for domain-joined SQL Server DB instances. */
    static AmazonRDSDirectoryServiceAccess: string;
    /** Provides access to Cloudwatch for RDS Enhanced Monitoring */
    static AmazonRDSEnhancedMonitoringRole: string;
    /** Provides full access to Amazon RDS via the AWS Management Console. */
    static AmazonRDSFullAccess: string;
    /** Provides full access to RDS Performance Insights via the AWS Management Console */
    static AmazonRDSPerformanceInsightsFullAccess: string;
    /** Read-Only policy for RDS Performance Insights */
    static AmazonRDSPerformanceInsightsReadOnly: string;
    /** Amazon RDS Preview Service Role Policy */
    static AmazonRDSPreviewServiceRolePolicy: string;
    /** Provides read only access to Amazon RDS via the AWS Management Console. */
    static AmazonRDSReadOnlyAccess: string;
    /** Allows Amazon RDS to manage AWS resources on your behalf. */
    static AmazonRDSServiceRolePolicy: string;
    /** This policy includes permissions to run SQL commands to copy, load, unload, query, and analyze data on Amazon Redshift. The policy also grants permissions to run select statements for related services, such as Amazon S3, Amazon CloudWatch logs, Amazon SageMaker, or AWS Glue. */
    static AmazonRedshiftAllCommandsFullAccess: string;
    /** This policy provides full access to Amazon Redshift Data APIs. This policy also grants scoped access to other required services. */
    static AmazonRedshiftDataFullAccess: string;
    /** Provides full access to Amazon Redshift via the AWS Management Console. */
    static AmazonRedshiftFullAccess: string;
    /** Provides full access to the Amazon Redshift Query Editor and to saved queries via the AWS Management Console. */
    static AmazonRedshiftQueryEditor: string;
    /** Grants full access to the Amazon Redshift Query Editor V2 operations and resources. This policy also grants access to other required services. This includes permissions to list the Amazon Redshift clusters, read keys and aliases in AWS KMS and manage the Query Editor V2 secrets in AWS Secrets Manager. */
    static AmazonRedshiftQueryEditorV2FullAccess: string;
    /** Grants the ability to work with Amazon Redshift Query Editor V2 without sharing resources. The granted principal can only read, update and delete its own resources but cannot share them. This policy also grants access to other required services. This includes permissions to list the Amazon Redshift clusters and manage the Query Editor V2 secrets of the principal in AWS Secrets Manager. */
    static AmazonRedshiftQueryEditorV2NoSharing: string;
    /** Grants the ability to work with Amazon Redshift Query Editor V2 with limited sharing of resources. The granted principal can read, write and share its own resources. The granted principal can read the resources shared with its team but cannot update them. This policy also grants access to other required services. This includes permissions to list the Amazon Redshift clusters and manage the Query Editor V2 secrets of the principal in AWS Secrets Manager. */
    static AmazonRedshiftQueryEditorV2ReadSharing: string;
    /** Grants the ability to work with Amazon Redshift Query Editor V2 with sharing of resources. The granted principal can read, write and share its own resources. The granted principal can read and update the resources shared with its team. This policy also grants access to other required services. This includes permissions to list the Amazon Redshift clusters and manage the Query Editor V2 secrets of the principal in AWS Secrets Manager. */
    static AmazonRedshiftQueryEditorV2ReadWriteSharing: string;
    /** Provides read only access to Amazon Redshift via the AWS Management Console. */
    static AmazonRedshiftReadOnlyAccess: string;
    /** Allows Amazon Redshift to call AWS services on your behalf */
    static AmazonRedshiftServiceLinkedRolePolicy: string;
    /** This policy specifies rekognition and s3 permissions required by Amazon Rekognition Custom Labels feature. */
    static AmazonRekognitionCustomLabelsFullAccess: string;
    /** Access to all Amazon Rekognition APIs */
    static AmazonRekognitionFullAccess: string;
    /** Access to all Read rekognition APIs */
    static AmazonRekognitionReadOnlyAccess: string;
    /** Allows Rekognition to call AWS services on your behalf. */
    static AmazonRekognitionServiceRole: string;
    /** Provides full access to all Route 53 Auto Naming actions. */
    static AmazonRoute53AutoNamingFullAccess: string;
    /** Provides read-only access to all Route 53 Auto Naming actions. */
    static AmazonRoute53AutoNamingReadOnlyAccess: string;
    /** Provides registrant level access to Route 53 Auto Naming actions. */
    static AmazonRoute53AutoNamingRegistrantAccess: string;
    /** Provides full access to all Route53 Domains actions and Create Hosted Zone to allow Hosted Zone creation as part of domain registrations. */
    static AmazonRoute53DomainsFullAccess: string;
    /** Provides access to Route53 Domains list and actions. */
    static AmazonRoute53DomainsReadOnlyAccess: string;
    /** Provides full access to all Amazon Route 53 via the AWS Management Console. */
    static AmazonRoute53FullAccess: string;
    /** This policy grants full access to Amazon Route 53 Profile resources. */
    static AmazonRoute53ProfilesFullAccess: string;
    /** This policy grants read-only access to Amazon Route 53 Profile resources. */
    static AmazonRoute53ProfilesReadOnlyAccess: string;
    /** Provides read only access to all Amazon Route 53 via the AWS Management Console. */
    static AmazonRoute53ReadOnlyAccess: string;
    /** Provides full access to Amazon Route 53 Recovery Cluster */
    static AmazonRoute53RecoveryClusterFullAccess: string;
    /** Provides read only access to Amazon Route 53 Recovery Cluster */
    static AmazonRoute53RecoveryClusterReadOnlyAccess: string;
    /** Provides full access to Amazon Route 53 Recovery Control Config */
    static AmazonRoute53RecoveryControlConfigFullAccess: string;
    /** Provides read only access to Amazon Route 53 Recovery Control Config */
    static AmazonRoute53RecoveryControlConfigReadOnlyAccess: string;
    /** Provides full access to Amazon Route 53 Recovery Readiness */
    static AmazonRoute53RecoveryReadinessFullAccess: string;
    /** Provides read only access to Amazon Route 53 Recovery Readiness */
    static AmazonRoute53RecoveryReadinessReadOnlyAccess: string;
    /** Full access policy for Route 53 Resolver */
    static AmazonRoute53ResolverFullAccess: string;
    /** Read only policy for Route 53 Resolver */
    static AmazonRoute53ResolverReadOnlyAccess: string;
    /** Provides full access to all buckets via the AWS Management Console. */
    static AmazonS3FullAccess: string;
    /** Provides AWS Lambda functions permissions to interact with Amazon S3 Object Lambda. Also grants Lambda permissions to write to CloudWatch Logs. */
    static AmazonS3ObjectLambdaExecutionRolePolicy: string;
    /** Provides full access to Amazon S3 on Outposts via the AWS Management Console. */
    static AmazonS3OutpostsFullAccess: string;
    /** Provides read only access to Amazon S3 on Outposts via the AWS Management Console. */
    static AmazonS3OutpostsReadOnlyAccess: string;
    /** Provides read only access to all buckets via the AWS Management Console. */
    static AmazonS3ReadOnlyAccess: string;
    /** Provides full access to all S3 table buckets. */
    static AmazonS3TablesFullAccess: string;
    /** This managed policy grants AWS Lake Formation permissions to act on all table buckets, namespaces, and tables within the account. */
    static AmazonS3TablesLakeFormationServiceRole: string;
    /** Provides read only access to all S3 table buckets. */
    static AmazonS3TablesReadOnlyAccess: string;
    /** Service role policy used by the AWS Service Catalog service to provision products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including CodePipeline, CodeBuild, CodeCommit, Glue, CloudFormation, etc,. */
    static AmazonSageMakerAdminServiceCatalogProductsServiceRolePolicy: string;
    /** Provides permissions for Amazon SageMaker Canvas to use AI services to support ready to use AI solutions. This policy will add more mutating permissions for services as Amazon SageMaker Canvas adds support. */
    static AmazonSageMakerCanvasAIServicesAccess: string;
    /** This policy grants permissions to use Amazon Bedrock in SageMaker Canvas by providing access to downstream services such as S3. */
    static AmazonSageMakerCanvasBedrockAccess: string;
    /** Provides full access to Amazon SageMaker resources and operations for data preparation in Canvas. The policy also provides select access to related services (e.g., S3, IAM, KMS, RDS, CloudWatch Logs, Redshift, Athena, Glue, EventBridge, Secrets Manager). This policy should be attached to the Amazon SageMaker Domain/User Profile execution role. */
    static AmazonSageMakerCanvasDataPrepFullAccess: string;
    /** Allows Amazon SageMaker Canvas to create, manage and view endpoint details for endpoints created through Canvas. Allows Amazon SageMaker Canvas to retrieve endpoint invocation metrics from CloudWatch. */
    static AmazonSageMakerCanvasDirectDeployAccess: string;
    /** This policy grants permissions to Amazon EMR Serverless for services such as S3, used by Amazon SageMaker Canvas for large data processing. */
    static AmazonSageMakerCanvasEMRServerlessExecutionRolePolicy: string;
    /** This policy grants permissions commonly needed to use SageMaker Canvas with Amazon Forecast. */
    static AmazonSageMakerCanvasForecastAccess: string;
    /** Provides full access to Amazon SageMaker Canvas resources and operations. The policy also provides select access to related services (e.g., S3, IAM, VPC, ECR, CloudWatch Logs, Redshift, Secrets Manager, and Forecast). This policy should be attached to the Amazon SageMaker Domain/User Profile execution role. */
    static AmazonSageMakerCanvasFullAccess: string;
    /** Provides permissions for Amazon SageMaker Canvas to use the SageMaker Data Science Assistant service. The Data Science Assistant currently uses both Amazon SageMaker and Amazon Q Developer to process user prompts. */
    static AmazonSageMakerCanvasSMDataScienceAssistantAccess: string;
    /** This policy grants permissions commonly needed to use Amazon SageMaker Cluster. */
    static AmazonSageMakerClusterInstanceRolePolicy: string;
    /** Managed policy for Service Linked Role for Amazon SageMaker Core Services */
    static AmazonSageMakerCoreServiceRolePolicy: string;
    /** Provides permissions necessary for SageMaker Edge to create and manage a device fleet for the customer using the default cloud connection. */
    static AmazonSageMakerEdgeDeviceFleetPolicy: string;
    /** Provides permissions required to enable the offline store for an Amazon SageMaker FeatureStore feature group. */
    static AmazonSageMakerFeatureStoreAccess: string;
    /** Provides full access to Amazon SageMaker via the AWS Management Console and SDK. Also provides select access to related services (e.g., S3, ECR, CloudWatch Logs). */
    static AmazonSageMakerFullAccess: string;
    /** This policy provide access to services that are commonly needed to use SageMaker geospatial. */
    static AmazonSageMakerGeospatialExecutionRole: string;
    /** This policy grants permissions that allow full access to Amazon SageMaker Geospatial through the AWS Management Console and SDK. */
    static AmazonSageMakerGeospatialFullAccess: string;
    /** Provides access to AWS services that are required to run SageMaker GroundTruth Labeling job */
    static AmazonSageMakerGroundTruthExecution: string;
    /** This policy provides administrative privileges required for setting up SageMaker HyperPod observability. It enables access to Amazon Managed Prometheus, Amazon Managed Grafana and EKS Addons. The policy also includes broad access to Grafana HTTP APIs through ServiceAccountTokens across all Amazon Managed Grafana workspaces in your account. */
    static AmazonSageMakerHyperPodObservabilityAdminAccess: string;
    /** This policy grants permissions to Amazon SageMaker HyperPod to related AWS services such as Amazon EKS, Amazon CloudWatch etc. */
    static AmazonSageMakerHyperPodServiceRolePolicy: string;
    /** This policy provides administrative permissions required to set up the SageMaker HyperPod training operator. It enables access to Amazon SageMaker HyperPod and EKS add-ons. The policy includes permissions to describe the SageMaker HyperPod resources in your account. */
    static AmazonSageMakerHyperPodTrainingOperatorAccess: string;
    /** Provides access to create Amazon Augmented AI FlowDefinition resources against any Workteam. */
    static AmazonSageMakerMechanicalTurkAccess: string;
    /** This AWS managed policy grants permissions needed to use all Amazon SageMaker Governance features. The policy also provides select access to related services (e.g., S3, KMS). */
    static AmazonSageMakerModelGovernanceUseAccess: string;
    /** This is a new managed policy for Model Registry in Sagemaker. This policy is a standalone policy that can be attached to the user role to access Model Registry related functionalities in Sagemaker. */
    static AmazonSageMakerModelRegistryFullAccess: string;
    /** Managed policy for Service Linked Role for Amazon SageMaker Notebooks */
    static AmazonSageMakerNotebooksServiceRolePolicy: string;
    /** Enables Amazon SageMaker partner app users to access applications, list available applications, launch application web UIs, and connect via the application SDK. */
    static AmazonSageMakerPartnerAppsFullAccess: string;
    /** Service role policy used by the AWS APIGateway within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including Lambda and others. */
    static AmazonSageMakerPartnerServiceCatalogProductsApiGatewayServiceRolePolicy: string;
    /** Service role policy used by the AWS CloudFormation within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including Lambda, APIGateway and others. */
    static AmazonSageMakerPartnerServiceCatalogProductsCloudFormationServiceRolePolicy: string;
    /** Service role policy used by the AWS Lambda within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including Secrets Manager and others. */
    static AmazonSageMakerPartnerServiceCatalogProductsLambdaServiceRolePolicy: string;
    /** This Amazon Managed Policy grants permissions commonly needed for use with Callback steps and Lambda steps in SageMaker Model Building Pipelines. It is added to the AmazonSageMaker-ExecutionRole that can be created when setting up SageMaker Studio. It can also be attached to any other role that will be used for authoring or executing pipelines. */
    static AmazonSageMakerPipelinesIntegrations: string;
    /** This policy will be used By SageMaker Unified Studios to create VPC related resources for QuickSight */
    static AmazonSageMakerQuickSightVPCPolicy: string;
    /** Provides read only access to Amazon SageMaker via the AWS Management Console and SDK. */
    static AmazonSageMakerReadOnly: string;
    /** Service role policy used by the AWS APIGateway within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including CloudWatch Logs and others. */
    static AmazonSageMakerServiceCatalogProductsApiGatewayServiceRolePolicy: string;
    /** Service role policy used by the AWS CloudFormation within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including SageMaker and others. */
    static AmazonSageMakerServiceCatalogProductsCloudformationServiceRolePolicy: string;
    /** Service role policy used by the AWS CodeBuild within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including CodePipeline, CodeBuild and others. */
    static AmazonSageMakerServiceCatalogProductsCodeBuildServiceRolePolicy: string;
    /** Service role policy used by the AWS CodePipeline within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including CodePipeline, CodeBuild and others. */
    static AmazonSageMakerServiceCatalogProductsCodePipelineServiceRolePolicy: string;
    /** Service role policy used by the AWS CloudWatch Events within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including CodePipeline and others. */
    static AmazonSageMakerServiceCatalogProductsEventsServiceRolePolicy: string;
    /** Service role policy used by the AWS Firehose within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including Firehose and others. */
    static AmazonSageMakerServiceCatalogProductsFirehoseServiceRolePolicy: string;
    /** Service role policy used by the AWS Glue within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including Glue, S3 and others. */
    static AmazonSageMakerServiceCatalogProductsGlueServiceRolePolicy: string;
    /** Service role policy used by the AWS Lambda within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including ECR, S3 and others. */
    static AmazonSageMakerServiceCatalogProductsLambdaServiceRolePolicy: string;
    /** This Amazon Managed Policy provides the necessary permissions to create and manage SageMaker Training Plans. It allows users to create Training Plans and Reserved Capacities, describe existing Training Plans, and perform search and listing operations. */
    static AmazonSageMakerTrainingPlanCreateAccess: string;
    /** Provides full access to Amazon Security Lake and related services needed to administer Security Lake. */
    static AmazonSecurityLakeAdministrator: string;
    /** Policy for Amazon SecurityLake meta store manager lambda which allows the access to cloudwatch, S3, Glue and SQS. */
    static AmazonSecurityLakeMetastoreManager: string;
    /** Amazon Security Lake creates IAM roles for third-party custom sources to write data to a data lake and for third-party subscribers to consume data from a data lake, and uses this policy when creating these roles to define the boundary of their permissions. */
    static AmazonSecurityLakePermissionsBoundary: string;
    /** Provides full access to Amazon SES via the AWS Management Console. */
    static AmazonSESFullAccess: string;
    /** Provides read only access to Amazon SES via the AWS Management Console. */
    static AmazonSESReadOnlyAccess: string;
    /** Allows SES to publish Amazon CloudWatch basic monitoring metrics on behalf of your SES resources */
    static AmazonSESServiceRolePolicy: string;
    /** Provides full access to Amazon SNS via the AWS Management Console. */
    static AmazonSNSFullAccess: string;
    /** Provides read only access to Amazon SNS via the AWS Management Console. */
    static AmazonSNSReadOnlyAccess: string;
    /** Default policy for Amazon SNS service role. */
    static AmazonSNSRole: string;
    /** Provides full access to Amazon SQS via the AWS Management Console. */
    static AmazonSQSFullAccess: string;
    /** Provides read only access to Amazon SQS via the AWS Management Console. */
    static AmazonSQSReadOnlyAccess: string;
    /** Provides access to view automation executions and send approval decisions to automation waiting for approval */
    static AmazonSSMAutomationApproverAccess: string;
    /** Provides permissions for EC2 Automation service to execute activities defined within Automation documents */
    static AmazonSSMAutomationRole: string;
    /** This policy allows SSM Agent to access Directory Service on behalf of the customer for domain-join the managed instance. */
    static AmazonSSMDirectoryServiceAccess: string;
    /** Provides full access to Amazon SSM. */
    static AmazonSSMFullAccess: string;
    /**  Service Role to be used for EC2 Maintenance Window */
    static AmazonSSMMaintenanceWindowRole: string;
    /** This policy enables AWS Systems Manager functionality on EC2 instances. */
    static AmazonSSMManagedEC2InstanceDefaultPolicy: string;
    /** The policy for Amazon EC2 Role to enable AWS Systems Manager service core functionality. */
    static AmazonSSMManagedInstanceCore: string;
    /** Provide access to child instances for patch association operation. */
    static AmazonSSMPatchAssociation: string;
    /** Provides read only access to Amazon SSM. */
    static AmazonSSMReadOnlyAccess: string;
    /** Provides access to AWS Resources managed or used by Amazon SSM */
    static AmazonSSMServiceRolePolicy: string;
    /** Access to all Amazon Textract APIs */
    static AmazonTextractFullAccess: string;
    /** Allows Textract to call AWS services on your behalf. */
    static AmazonTextractServiceRole: string;
    /** Provides full access to manage Amazon Timestream using the AWS Management Console. Note that this policy also grants permissions for certain KMS operations, and operations to manage your saved queries. If using Customer managed CMK, please refer to documentation for additional permissions needed. */
    static AmazonTimestreamConsoleFullAccess: string;
    /** Provides full access to Amazon Timestream. Note that this policy also grants certain KMS operation access. If using Customer managed CMK, please refer to documentation for additional permissions needed. */
    static AmazonTimestreamFullAccess: string;
    /** Provides full administrative access to create, update, delete and list Amazon Timestream InfluxDB instances and create and list parameter groups. Please refer to documentation for additional permissions needed. */
    static AmazonTimestreamInfluxDBFullAccess: string;
    /** Provides administrative access to manage Amazon Timestream InfluxDB instances and parameter groups except marketplace operations. */
    static AmazonTimestreamInfluxDBFullAccessWithoutMarketplaceAccess: string;
    /** Provides full administrative access to create, update, delete and list Amazon Timestream InfluxDB instances and create and list parameter groups. Please refer to documentation for additional permissions needed. */
    static AmazonTimestreamInfluxDBServiceRolePolicy: string;
    /** Provides read only access to Amazon Timestream. Policy also provides permission to cancel any running query. If using Customer managed CMK, please refer to documentation for additional permissions needed. */
    static AmazonTimestreamReadOnlyAccess: string;
    /** Provides full access to Amazon Transcribe operations */
    static AmazonTranscribeFullAccess: string;
    /** Provides access to read only operation for Amazon Transcribe */
    static AmazonTranscribeReadOnlyAccess: string;
    /** Provides full access to Verified Permissions */
    static AmazonVerifiedPermissionsFullAccess: string;
    /** Provides read-only access to the Verified Permissions service. */
    static AmazonVerifiedPermissionsReadOnlyAccess: string;
    /** Provides access to create network interfaces and attach them to cross-account resources */
    static AmazonVPCCrossAccountNetworkInterfaceOperations: string;
    /** Provides full access to Amazon VPC via the AWS Management Console. */
    static AmazonVPCFullAccess: string;
    /** Provides permissions to describe AWS resources, run Network Access Analyzer, and create or delete tags on Network Insights Access Scope and Network Insights Access Scope Analysis. */
    static AmazonVPCNetworkAccessAnalyzerFullAccessPolicy: string;
    /** Provides permissions to describe AWS resources, run Reachability Analyzer, and create or delete tags on Network Insights Path and Network Insights Analysis. */
    static AmazonVPCReachabilityAnalyzerFullAccessPolicy: string;
    /** This policy is attached to the role IAMRoleForReachabilityAnalyzerCrossAccountResourceAccess. This role is deployed to the member accounts in an organization when the management account enables trusted access for Reachability Analyzer. It provides permissions to view resources from across your organization using the Reachability Analyzer console. */
    static AmazonVPCReachabilityAnalyzerPathComponentReadPolicy: string;
    /** Provides read only access to Amazon VPC via the AWS Management Console. */
    static AmazonVPCReadOnlyAccess: string;
    /** Provides full access to Amazon WorkDocs via the AWS Management Console */
    static AmazonWorkDocsFullAccess: string;
    /** Provides read only access to Amazon WorkDocs via the AWS Management Console */
    static AmazonWorkDocsReadOnlyAccess: string;
    /** Enables access to AWS Services and Resources used or managed by Amazon WorkMail Events */
    static AmazonWorkMailEventsServiceRolePolicy: string;
    /** Provides full access to WorkMail, Directory Service, SES, EC2 and read access to KMS metadata. */
    static AmazonWorkMailFullAccess: string;
    /** Full access to the WorkMail Message Flow APIs */
    static AmazonWorkMailMessageFlowFullAccess: string;
    /** Read only access to WorkMail messages for the GetRawMessageContent API */
    static AmazonWorkMailMessageFlowReadOnlyAccess: string;
    /** Provides read only access to WorkMail and SES. */
    static AmazonWorkMailReadOnlyAccess: string;
    /** Provides access to Amazon WorkSpaces administrative actions via AWS SDK and CLI. */
    static AmazonWorkSpacesAdmin: string;
    /** Provides administrator access for packaging an application in Amazon WorkSpaces Application Manager. */
    static AmazonWorkSpacesApplicationManagerAdminAccess: string;
    /** This managed policy provides full administrative access to AWS Certificate Manager Private CA resources in your AWS account for certificate-based authentication. */
    static AmazonWorkspacesPCAAccess: string;
    /** This policy provides AWS WorkSpaces service access to required customer account resources for launching Workspaces Pools */
    static AmazonWorkSpacesPoolServiceAccess: string;
    /** Provides read-only access to Amazon WorkSpaces Secure Browser and its dependencies through the AWS Management Console, SDK, and CLI. */
    static AmazonWorkSpacesSecureBrowserReadOnly: string;
    /** Provides access to Amazon WorkSpaces backend service to perform Workspace Self Service actions */
    static AmazonWorkSpacesSelfServiceAccess: string;
    /** Provides customer account access to AWS WorkSpaces service for launching a Workspace. */
    static AmazonWorkSpacesServiceAccess: string;
    /** Provides full access to Amazon WorkSpaces Thin Client as well as limited access to required related services */
    static AmazonWorkSpacesThinClientFullAccess: string;
    /** Enables access to AWS Services and Resources used or managed by Amazon WorkSpaces Thin Client Monitoring */
    static AmazonWorkSpacesThinClientMonitoringServiceRolePolicy: string;
    /** Provides read-only access to Amazon WorkSpaces Thin Client and its dependencies */
    static AmazonWorkSpacesThinClientReadOnlyAccess: string;
    /** Provides read-only access to Amazon WorkSpaces Web and its dependencies through the AWS Management Console, SDK, and CLI. */
    static AmazonWorkSpacesWebReadOnly: string;
    /** Enables access to AWS Services and Resources used or managed by Amazon WorkSpaces Web */
    static AmazonWorkSpacesWebServiceRolePolicy: string;
    /** Provides full access to Amazon Zocalo. */
    static AmazonZocaloFullAccess: string;
    /** Provides read only access to Amazon Zocalo */
    static AmazonZocaloReadOnlyAccess: string;
    /** Provides Amplify full access permissions to deploy Amplify backend resources (AWS AppSync, Amazon Cognito, Amazon S3 and other related services) via the AWS Cloud Development Kit (AWS CDK) */
    static AmplifyBackendDeployFullAccess: string;
    /** Allows API Gateway to manage associated AWS Resources on behalf of the customer. */
    static APIGatewayServiceRolePolicy: string;
    /** Allows AppIntegrations to manage AppFlow resources and publish CloudWatch metric data on your behalf. */
    static AppIntegrationsServiceLinkedRolePolicy: string;
    /** Policy to enable Application Autoscaling for Amazon AppStream */
    static ApplicationAutoScalingForAmazonAppStreamAccess: string;
    /** Enables access to AWS Services and Resources used or managed by Application Discovery Service Continuous Export feature */
    static ApplicationDiscoveryServiceContinuousExportServiceRolePolicy: string;
    /** Allows AWS AppRunner Networking to manage related AWS resources on your behalf. */
    static AppRunnerNetworkingServiceRolePolicy: string;
    /** Allows AWS AppRunner to manage related AWS resources on your behalf. */
    static AppRunnerServiceRolePolicy: string;
    /** Allows AppStudio to manage associated AWS resources on your behalf. */
    static AppStudioServiceRolePolicy: string;
    /** Policy for Amazon Aurora DSQL Service Linked Role */
    static AuroraDsqlServiceLinkedRolePolicy: string;
    /** Provides full access to Auto Scaling via the AWS Management Console. */
    static AutoScalingConsoleFullAccess: string;
    /** Provides read-only access to Auto Scaling via the AWS Management Console. */
    static AutoScalingConsoleReadOnlyAccess: string;
    /** Provides full access to Auto Scaling. */
    static AutoScalingFullAccess: string;
    /** Default policy for the AutoScaling Notification Access service role. */
    static AutoScalingNotificationAccessRole: string;
    /** Provides read-only access to Auto Scaling. */
    static AutoScalingReadOnlyAccess: string;
    /** Enables access to AWS Services and Resources used or managed by Auto Scaling */
    static AutoScalingServiceRolePolicy: string;
    /** Default policy for AWS Config service role. Provides permissions required for AWS Config to track changes to your AWS resources. */
    static AWSConfigRole: string;
    /** Provides permissions to access the SSM Diagnosis S3 bucket for diagnosis and remediation of issues. */
    static AWSSSMAutomationDiagnosisBucketPolicy: string;
    /** Provide permission for Diagnosing issues with SSM services by executing activities defined within Automation Documents, primarily used for running the Automation documents in a cross-account cross-region setup by triggering child automations within member accounts. */
    static AWSSSMDiagnosisAutomationAdministrationRolePolicy: string;
    /** Provide permission for Diagnosing issues with SSM services by executing activities defined within Automation Documents, primarily used for running the Automation documents in a target account/region setup by diagnosing SSM service health across all nodes. */
    static AWSSSMDiagnosisAutomationExecutionRolePolicy: string;
    /** Provides permissions for operational accounts to diagnose unmanaged nodes by providing Organisation specific permissions required by SSM automation to pull the list of member accounts within a root of an Organisation to trigger cross-account cross-region execution by allowing assuming Execution roles in target account/region. */
    static AWSSSMDiagnosisAutomationOperationalAccountAdministrationRolePolicy: string;
    /** Provide permission for Remediating issues with SSM services by executing activities defined within Automation Documents, primarily used for running the Automation documents in a cross-account cross-region setup by triggering child automations within member accounts. */
    static AWSSSMRemediationAutomationAdministrationRolePolicy: string;
    /** Provides permissions for Remediating issues with SSM services by executing activities defined within Automation Documents, primarily used for running the Automation documents in a target account/region setup by remediating SSM services health across all nodes. */
    static AWSSSMRemediationAutomationExecutionRolePolicy: string;
    /** Provides permissions for operational accounts to Remediate unmanaged nodes by providing Organisation specific permissions required by SSM automation to pull the list of member accounts within a root of an Organisation to trigger cross-account cross-region execution by allowing assuming Execution roles in target account/region. */
    static AWSSSMRemediationAutomationOperationalAccountAdministrationRolePolicy: string;
    /** Allows users to access the Account Activity page. */
    static AWSAccountActivityAccess: string;
    /** Provides full access to AWS Account Management. */
    static AWSAccountManagementFullAccess: string;
    /** Provides read-only access to AWS Account Management */
    static AWSAccountManagementReadOnlyAccess: string;
    /** Allows users to access the Account Usage Report page. */
    static AWSAccountUsageReportAccess: string;
    /** Provides access for the Discovery Agentless Connector to register with AWS Application Discovery Service. */
    static AWSAgentlessDiscoveryService: string;
    /** Provides full access to the AWS AppFabric service and read only access to dependent services such as S3, Kinesis, KMS. */
    static AWSAppFabricFullAccess: string;
    /** Provides read only access to the AWS AppFabric */
    static AWSAppFabricReadOnlyAccess: string;
    /** Provides AppFabric access to AWS resources on your behalf */
    static AWSAppFabricServiceRolePolicy: string;
    /** Policy granting permissions to Application Auto Scaling to access AppStream and CloudWatch. */
    static AWSApplicationAutoscalingAppStreamFleetPolicy: string;
    /** Policy granting permissions to Application Auto Scaling to access Cassandra and CloudWatch. */
    static AWSApplicationAutoscalingCassandraTablePolicy: string;
    /** Policy granting permissions to Application Auto Scaling to access Comprehend and CloudWatch. */
    static AWSApplicationAutoscalingComprehendEndpointPolicy: string;
    /** Policy granting permissions to Application Auto Scaling to access APIGateway and CloudWatch for custom resource scaling */
    static AWSApplicationAutoScalingCustomResourcePolicy: string;
    /** Policy granting permissions to Application Auto Scaling to access DynamoDB and CloudWatch. */
    static AWSApplicationAutoscalingDynamoDBTablePolicy: string;
    /** Policy granting permissions to Application Auto Scaling to access EC2 Spot Fleet and CloudWatch. */
    static AWSApplicationAutoscalingEC2SpotFleetRequestPolicy: string;
    /** Policy granting permissions to Application Auto Scaling to access EC2 Container Service and CloudWatch. */
    static AWSApplicationAutoscalingECSServicePolicy: string;
    /** Policy granting permissions to Application Auto Scaling to access Amazon ElastiCache and Amazon CloudWatch. */
    static AWSApplicationAutoscalingElastiCacheRGPolicy: string;
    /** Policy granting permissions to Application Auto Scaling to access Elastic Map Reduce and CloudWatch. */
    static AWSApplicationAutoscalingEMRInstanceGroupPolicy: string;
    /** Policy granting permissions to Application Auto Scaling to access Managed Streaming for Apache Kafka and CloudWatch. */
    static AWSApplicationAutoscalingKafkaClusterPolicy: string;
    /** Policy granting permissions to Application Auto Scaling to access Lambda and CloudWatch. */
    static AWSApplicationAutoscalingLambdaConcurrencyPolicy: string;
    /** Policy granting permissions to Application Auto Scaling to access Amazon Neptune and Amazon CloudWatch. */
    static AWSApplicationAutoscalingNeptuneClusterPolicy: string;
    /** Policy granting permissions to Application Auto Scaling to access RDS and CloudWatch. */
    static AWSApplicationAutoscalingRDSClusterPolicy: string;
    /** Policy granting permissions to Application Auto Scaling to access SageMaker and CloudWatch. */
    static AWSApplicationAutoscalingSageMakerEndpointPolicy: string;
    /** Policy granting permissions to Application Auto Scaling to access Amazon WorkSpaces and Amazon CloudWatch. */
    static AWSApplicationAutoscalingWorkSpacesPoolPolicy: string;
    /** Provides access for the Discovery Agent to register with AWS Application Discovery Service. */
    static AWSApplicationDiscoveryAgentAccess: string;
    /** Allows Application Discovery Service Agentless Collectors to auto update, register, and communicate with Application Discovery Service */
    static AWSApplicationDiscoveryAgentlessCollectorAccess: string;
    /** Provides full access to view and tag Configuration Items maintained by the AWS Application Discovery Service */
    static AWSApplicationDiscoveryServiceFullAccess: string;
    /** This policy allows installing the AWS Replication Agent, which is used with AWS Application Migration Service (MGN) to migrate external servers to AWS. Attach this policy to your IAM users or roles whose credentials you provide when installing the AWS Replication Agent. */
    static AWSApplicationMigrationAgentInstallationPolicy: string;
    /** This policy allows installing and using the AWS Replication Agent, which is used with AWS Application Migration Service (MGN) to migrate external servers to AWS. Attach this policy to your IAM users or roles whose credentials you provide when installing the AWS Replication Agent. */
    static AWSApplicationMigrationAgentPolicy: string;
    /** This policy allows using the AWS Replication Agent, which is used with AWS Application Migration Service (MGN) to migrate external servers to AWS. We do not recommend that you attach this policy to your IAM users or roles. */
    static AWSApplicationMigrationAgentPolicyV2: string;
    /** This policy allows the Application Migration Service (MGN) Conversion Server, which are EC2 instances launched by Application Migration Service, to communicate with the MGN service. An IAM role with this policy is attached (as an EC2 Instance Profile) by MGN to the MGN Conversion Servers, which are automatically launched and terminated by MGN, when needed. We do not recommend that you attach this policy to your IAM users or roles. MGN Conversion Servers are used by Application Migration Service when users choose to launch Test or Cutover instances using the MGN console, CLI, or API. */
    static AWSApplicationMigrationConversionServerPolicy: string;
    /** This policy provides Amazon EC2 operations required to use Application Migration Service (MGN) to launch the migrated servers as EC2 instances. Attach this policy to your IAM users or roles. */
    static AWSApplicationMigrationEC2Access: string;
    /** This policy provides permissions to all public APIs of AWS Application Migration Service (MGN), as well as permissions to read KMS key information. Attach this policy to your IAM users or roles. */
    static AWSApplicationMigrationFullAccess: string;
    /** This policy allows AWS Application Migration Service (MGN) to send meta-data about the progress of servers being migrated using MGN to AWS Migration Hub (MGH). MGN automatically creates an IAM role with this policy attached, and assumes this role. We do not recommend that you attach this policy to your IAM users or roles. */
    static AWSApplicationMigrationMGHAccess: string;
    /** This policy provides permissions to all read-only public APIs of Application Migration Service (MGN), as well as some read-only APIs of other AWS services that are required in order to make full read-only use of the MGN console. Attach this policy to your IAM users or roles. */
    static AWSApplicationMigrationReadOnlyAccess: string;
    /** This policy allows the Application Migration Service (MGN) Replication Servers, which are EC2 instances launched by Application Migration Service - to communicate with the MGN service, and to create EBS snapshots in your AWS account. An IAM role with this policy is attached (as an EC2 Instance Profile) by Application Migration Service to the MGN Replication Servers which are automatically launched and terminated by MGN, as needed. MGN Replication Servers are used to facilitate data replication from your external servers to AWS, as part of the migration process managed using MGN. We do not recommend that you attach this policy to your IAM users or roles. */
    static AWSApplicationMigrationReplicationServerPolicy: string;
    /** This policy allows installing and using the AWS Replication Agent, which is used by AWS Application Migration Service (AWS MGN) to migrate source servers that run on EC2 (cross-Region or cross-AZ). An IAM role with this policy should be attached (as an EC2 Instance Profile) to the EC2 Instances. */
    static AWSApplicationMigrationServiceEc2InstancePolicy: string;
    /** Allows AWS application Migration Service to create and manage AWS resources on your behalf. */
    static AWSApplicationMigrationServiceRolePolicy: string;
    /** This policy provides access to Amazon SSM operations required to use Application Migration Service (MGN) to execute custom post migration command SSM documents. Attach this policy to your IAM users or roles. */
    static AWSApplicationMigrationSSMAccess: string;
    /** This policy allows installing and using the AWS VCenter Client, which is used with AWS Application Migration Service (MGN) to migrate external servers to AWS. Attach this policy to your IAM users or roles whose credentials you provide when installing the AWS VCenter Client. */
    static AWSApplicationMigrationVCenterClientPolicy: string;
    /** App Mesh Envoy policy for accessing Virtual Node configuration. */
    static AWSAppMeshEnvoyAccess: string;
    /** Provides full access to the AWS App Mesh APIs and Management Console. */
    static AWSAppMeshFullAccess: string;
    /** App Mesh Preview Envoy policy for accessing Virtual Node configuration. */
    static AWSAppMeshPreviewEnvoyAccess: string;
    /** Enables access to AWS Services and Resources used or managed by AWS App Mesh */
    static AWSAppMeshPreviewServiceRolePolicy: string;
    /** Provides read-only access to the AWS App Mesh APIs and Management Console. */
    static AWSAppMeshReadOnly: string;
    /** Enables access to AWS Services and Resources used or managed by AWS AppMesh */
    static AWSAppMeshServiceRolePolicy: string;
    /** Grants permissions to all App Runner actions. */
    static AWSAppRunnerFullAccess: string;
    /** Grants permissions to list and view details about App Runner resources. */
    static AWSAppRunnerReadOnlyAccess: string;
    /** AWS App Runner service policy that grants read permissions to Amazon ECR resources in the customer's account. Use it in a role that is passed to App Runner when creating or updating an App Runner service. */
    static AWSAppRunnerServicePolicyForECRAccess: string;
    /** Provides administrative access to the AppSync service, though not enough to access via the console. */
    static AWSAppSyncAdministrator: string;
    /** Provides full invoking access to the AppSync service - both through the console and independently */
    static AWSAppSyncInvokeFullAccess: string;
    /** Allows AppSync to push logs to user's CloudWatch account. */
    static AWSAppSyncPushToCloudWatchLogs: string;
    /** Provides access to create, update, and query the schema. */
    static AWSAppSyncSchemaAuthor: string;
    /** Enables access to AWS services and resources used or managed by AppSync */
    static AWSAppSyncServiceRolePolicy: string;
    /** Allows AWS Artifact read-only access to operations in AWS Organizations. */
    static AWSArtifactAccountSync: string;
    /** This policy grants full permissions to list, download, accept, and terminate AWS Artifact agreements. It also includes permissions to list and enable AWS service access in the Organization service, as well as describe the organization details. Additionally, the policy provides the ability to check if the required service-linked role exists and creates one if it doesn't */
    static AWSArtifactAgreementsFullAccess: string;
    /** This policy grants read-only access to list the AWS Artifact service agreements and to download the accepted agreements.. It also includes permissions to list as well as describe the organization details. Additionally, the policy provides the ability to check if the required service-linked role exists. */
    static AWSArtifactAgreementsReadOnlyAccess: string;
    /** Provides read-only access to the AWS Artifact service reports. */
    static AWSArtifactReportsReadOnlyAccess: string;
    /** Allows AWS Artifact to gather information about an organization via AWS Organizations service. */
    static AWSArtifactServiceRolePolicy: string;
    /** Provides administrative access to enable or disable AWS Audit Manager, update settings, and manage assessments, controls, and frameworks */
    static AWSAuditManagerAdministratorAccess: string;
    /** Enables access to AWS Services and Resources used or managed by AWS Audit Manager */
    static AWSAuditManagerServiceRolePolicy: string;
    /** Policy granting permissions to AWS Auto Scaling to periodically forecast capacity and generate scheduled scaling actions for Auto Scaling groups in a scaling plan */
    static AWSAutoScalingPlansEC2AutoScalingPolicy: string;
    /** This policy grants permissions for users to create controls and frameworks that define their expectations for AWS Backup resources and activities, and to audit AWS Backup resources and activities against their defined controls and frameworks. This policy grants permissions to AWS Config and similar services to describe user expectations perform the audits. This policy also grants permissions to deliver audit reports to S3 and similar services, and enables users to find and open their audit reports. */
    static AWSBackupAuditAccess: string;
    /** This policy allows the AWS Backint agent to complete backup data transfer with AWS Backup Storage plane. Attach this policy to roles assumed by EC2 Instances running SAP HANA with the Backint agent. */
    static AWSBackupDataTransferAccess: string;
    /** This policy is for backup administrators, granting full access to AWS Backup operations, including creating or editing backup plans, assigning AWS resources to backup plans, deleting backups, and restoring backups. */
    static AWSBackupFullAccess: string;
    /** Provides AWS BackupGateway permission to sync the metadata of Virtual Machines on your behalf */
    static AWSBackupGatewayServiceRolePolicyForVirtualMachineMetadataSync: string;
    /** This policy grants users permissions to assign AWS resources to backup plans, create on-demand backups, and restore backups. This policy does not allow the user to create or edit backup plans or to delete scheduled backups after they are created. */
    static AWSBackupOperatorAccess: string;
    /** This policy is for backup administators who use cross-account backup management to manage backups for the organization. */
    static AWSBackupOrganizationAdminAccess: string;
    /** Provides AWS Backup permission to restore a backup of SAP HANA on Amazon EC2 */
    static AWSBackupRestoreAccessForSAPHANA: string;
    /** The search operator role has access to create backup indexes, create searches of backup metadata that has been indexed. This policy contains the necessary permissions for these search operator functions. */
    static AWSBackupSearchOperatorAccess: string;
    /** Provides AWS Backup permission to create backups on your behalf across AWS services */
    static AWSBackupServiceLinkedRolePolicyForBackup: string;
    /** Provides AWS Backup permission to create backups on your behalf across AWS services */
    static AWSBackupServiceLinkedRolePolicyForBackupTest: string;
    /** Provides AWS Backup permission to create backups on your behalf across AWS services */
    static AWSBackupServiceRolePolicyForBackup: string;
    /** Policy containing permissions necessary for AWS Backup to index recovery points. */
    static AWSBackupServiceRolePolicyForIndexing: string;
    /** Policy containing permissions necessary for AWS Backup to restore individual items in a recovery point */
    static AWSBackupServiceRolePolicyForItemRestores: string;
    /** Provides AWS Backup permission to perform restores on your behalf across AWS services. This policy includes permissions to create and delete AWS resources, such as EBS volumes, RDS instances, and EFS file systems, which are part of the restore process. */
    static AWSBackupServiceRolePolicyForRestores: string;
    /** Policy containing permissions necessary for AWS Backup to backup data in any S3 bucket. This includes read access to all S3 objects and any decrypt access for all KMS keys. */
    static AWSBackupServiceRolePolicyForS3Backup: string;
    /** Policy containing permissions necessary for AWS Backup to restore a S3 backup to a bucket. This includes read/write permissions to all S3 buckets, and permissions to GenerateDataKey and DescribeKey for all KMS keys. */
    static AWSBackupServiceRolePolicyForS3Restore: string;
    /** Provides full access for AWS Batch resources. */
    static AWSBatchFullAccess: string;
    /** Policy to enable CloudWatch Event Target for AWS Batch Job Submission */
    static AWSBatchServiceEventTargetRole: string;
    /** Policy for AWS Batch service role which allows access to related services including EC2, Autoscaling, EC2 Container service and Cloudwatch Logs. */
    static AWSBatchServiceRole: string;
    /** Provides access for AWS Batch to queue and manage Amazon SageMaker workloads */
    static AWSBatchServiceRolePolicyForSageMaker: string;
    /** A service linked role to provide Billing and Cost Management Data Exports access to AWS service data for exporting the data to a target location, such as Amazon S3, on behalf of a customer. */
    static AWSBCMDataExportsServiceRolePolicy: string;
    /** Use the AWSBillingConductorFullAccess managed policy to allow complete access to AWS Billing Conductor (ABC) console and APIs. This policy allows users to list, create and delete ABC resources. */
    static AWSBillingConductorFullAccess: string;
    /** Use the AWSBillingConductorReadOnlyAccess managed policy to allow read only access to AWS Billing Conductor (ABC) console and APIs. This policy grants permission to view and list all ABC resources. It does not include the ability to create or delete resources. */
    static AWSBillingConductorReadOnlyAccess: string;
    /** Allows users to view bills on the Billing Console. */
    static AWSBillingReadOnlyAccess: string;
    /** Allows billing service to validate access to billing view data for derived billing views */
    static AWSBillingServiceRolePolicy: string;
    /** This policy gives permissions to control AWS resources. For example, to start and stop EC2 or RDS instances by executing AWS Systems Manager (SSM) scripts. */
    static AWSBudgetsActionsRolePolicyForResourceAdministrationWithSSM: string;
    /** Provides full access to AWS Budgets Actions including using Budgets Actions to control states of running AWS resources via AWS Management Console */
    static AWSBudgetsActionsWithAWSResourceControlAccess: string;
    /** Provides read only access to AWS Budgets Console via the AWS Management Console. */
    static AWSBudgetsReadOnlyAccess: string;
    /** This IAM policy grants users full access to the AWS BugBust console */
    static AWSBugBustFullAccess: string;
    /** This IAM policy grants users access to participate in AWS BugBust events */
    static AWSBugBustPlayerAccess: string;
    /** Grants permissions to AWS BugBust to access resources on your behalf */
    static AWSBugBustServiceRolePolicy: string;
    /** Provides full access to AWS Certificate Manager (ACM) */
    static AWSCertificateManagerFullAccess: string;
    /** Provides auditor access to AWS Certificate Manager Private Certificate Authority */
    static AWSCertificateManagerPrivateCAAuditor: string;
    /** Provides full access to AWS Certificate Manager Private Certificate Authority */
    static AWSCertificateManagerPrivateCAFullAccess: string;
    /** Provides privileged certificate user access to AWS Certificate Manager Private Certificate Authority */
    static AWSCertificateManagerPrivateCAPrivilegedUser: string;
    /** Provides read only access to AWS Certificate Manager Private Certificate Authority */
    static AWSCertificateManagerPrivateCAReadOnly: string;
    /** Provides certificate user access to AWS Certificate Manager Private Certificate Authority */
    static AWSCertificateManagerPrivateCAUser: string;
    /** Provides read only access to AWS Certificate Manager (ACM). */
    static AWSCertificateManagerReadOnly: string;
    /** The Service Linked Role used by AWS Chatbot. */
    static AWSChatbotServiceLinkedRolePolicy: string;
    /** Allows full access to AWS Clean Rooms resources and access to related AWS Services. */
    static AWSCleanRoomsFullAccess: string;
    /** Allows full access to AWS Clean Rooms resources except for querying in a collaboration and access to related AWS Services. */
    static AWSCleanRoomsFullAccessNoQuerying: string;
    /** Allows full access to AWS Clean Rooms ML resources and access to related AWS Services. */
    static AWSCleanRoomsMLFullAccess: string;
    /** Allows read-only access to AWS Clean Rooms ML resources and read-only access to related AWS Clean Rooms resources */
    static AWSCleanRoomsMLReadOnlyAccess: string;
    /** Allows read-only access to AWS Clean Rooms resources and read-only access to related AWS Glue and Amazon CloudWatch Logs resources. */
    static AWSCleanRoomsReadOnlyAccess: string;
    /** Provides administrator access to AWS Cloud9. */
    static AWSCloud9Administrator: string;
    /** Provides the ability to be invited into AWS Cloud9 shared development environments. */
    static AWSCloud9EnvironmentMember: string;
    /** Service Linked Role Policy for AWS Cloud9 */
    static AWSCloud9ServiceRolePolicy: string;
    /** This policy will be used to attach a role on a InstanceProfile which will allow Cloud9 to use the SSM Session Manager to connect to the instance */
    static AWSCloud9SSMInstanceProfile: string;
    /** Provides permission to create AWS Cloud9 development environments and to manage owned environments. */
    static AWSCloud9User: string;
    /** Provides full access to AWS CloudFormation. */
    static AWSCloudFormationFullAccess: string;
    /** Provides access to AWS CloudFormation via the AWS Management Console. */
    static AWSCloudFormationReadOnlyAccess: string;
    /** Grants CloudFront Logger write permissions to CloudWatch Logs. */
    static AWSCloudFrontLogger: string;
    /** Allows CloudFront to manage EC2 Elastic Network Interfaces and Security Groups on your behalf. */
    static AWSCloudFrontVPCOriginServiceRolePolicy: string;
    /** Provides full access to all CloudHSM resources. */
    static AWSCloudHSMFullAccess: string;
    /** Provides read only access to all CloudHSM resources. */
    static AWSCloudHSMReadOnlyAccess: string;
    /** Default policy for the AWS CloudHSM service role. */
    static AWSCloudHSMRole: string;
    /** Provides access to AWS Cloud Map discovery API. */
    static AWSCloudMapDiscoverInstanceAccess: string;
    /** Provides full access to all AWS Cloud Map actions. */
    static AWSCloudMapFullAccess: string;
    /** Provides read-only access to all AWS Cloud Map actions. */
    static AWSCloudMapReadOnlyAccess: string;
    /** Provides registrant level access to AWS Cloud Map actions. */
    static AWSCloudMapRegisterInstanceAccess: string;
    /** Grants using AWS CloudShell with all features */
    static AWSCloudShellFullAccess: string;
    /** Provides full access to AWS CloudTrail. */
    static AWSCloudTrailFullAccess: string;
    /** Provides read only access to AWS CloudTrail. */
    static AWSCloudTrailReadOnlyAccess: string;
    /** This policy is used by the service-linked role named AWSServiceRoleForCloudWatchAlarms_ActionSSMIncidents. CloudWatch uses this service-linked role to perform AWS System Manager Incident Manager actions when a CloudWatch alarm goes in to ALARM state. This policy grants permission to start incidents on your behalf. */
    static AWSCloudWatchAlarmsActionSSMIncidentsServiceRolePolicy: string;
    /** Provides full access to AWS CodeArtifact via the AWS Management Console. */
    static AWSCodeArtifactAdminAccess: string;
    /** Provides read only access to AWS CodeArtifact via the AWS Management Console. */
    static AWSCodeArtifactReadOnlyAccess: string;
    /** Provides full access to AWS CodeBuild via the AWS Management Console. Also attach AmazonS3ReadOnlyAccess to provide access to download build artifacts, and attach IAMFullAccess to create and manage the service role for CodeBuild. */
    static AWSCodeBuildAdminAccess: string;
    /** Provides access to AWS CodeBuild via the AWS Management Console, but does not allow CodeBuild project administration. Also attach AmazonS3ReadOnlyAccess to provide access to download build artifacts. */
    static AWSCodeBuildDeveloperAccess: string;
    /** Provides read only access to AWS CodeBuild via the AWS Management Console. Also attach AmazonS3ReadOnlyAccess to provide access to download build artifacts. */
    static AWSCodeBuildReadOnlyAccess: string;
    /** Provides full access to AWS CodeCommit via the AWS Management Console. */
    static AWSCodeCommitFullAccess: string;
    /** Provides full access to AWS CodeCommit repositories, but does not allow repository deletion. */
    static AWSCodeCommitPowerUser: string;
    /** Provides read only access to AWS CodeCommit via the AWS Management Console. */
    static AWSCodeCommitReadOnly: string;
    /** Provides access to register and deploy a revision. */
    static AWSCodeDeployDeployerAccess: string;
    /** Provides full access to CodeDeploy resources. */
    static AWSCodeDeployFullAccess: string;
    /** Provides read only access to CodeDeploy resources. */
    static AWSCodeDeployReadOnlyAccess: string;
    /** Provides CodeDeploy service access to expand tags and interact with Auto Scaling on your behalf. */
    static AWSCodeDeployRole: string;
    /** Provides CodeDeploy service access to invoke Lambda function on your behalf to perform blue/green deployment through CloudFormation. */
    static AWSCodeDeployRoleForCloudFormation: string;
    /** Provides CodeDeploy service wide access to perform an ECS blue/green deployment on your behalf. Grants full access to support services, such as  full access to read all S3 objects, invoke all Lambda functions, publish to all SNS topics within the account and update all ECS services. */
    static AWSCodeDeployRoleForECS: string;
    /**  Provides CodeDeploy service limited access to perform an ECS blue/green deployment on your behalf. */
    static AWSCodeDeployRoleForECSLimited: string;
    /** Provides CodeDeploy service access to perform a Lambda deployment on your behalf. */
    static AWSCodeDeployRoleForLambda: string;
    /** Provides CodeDeploy service limited access to perform a Lambda deployment on your behalf. */
    static AWSCodeDeployRoleForLambdaLimited: string;
    /** Provides full access to AWS CodePipeline via the AWS Management Console. */
    static AWSCodePipelineFullAccess: string;
    /** Provides read only access to AWS CodePipeline via the AWS Management Console. */
    static AWSCodePipelineReadOnlyAccess: string;
    /** Provides access to view and approve manual changes for all pipelines */
    static AWSCodePipelineApproverAccess: string;
    /** Provides access for custom actions to poll for jobs details (including temporary credentials) and report status updates to AWS CodePipeline. */
    static AWSCodePipelineCustomActionAccess: string;
    /** Provides full access to AWS CodeStar via the AWS Management Console. */
    static AWSCodeStarFullAccess: string;
    /** Allows AWS CodeStar Notifications to access Amazon CloudWatch Events on your behalf */
    static AWSCodeStarNotificationsServiceRolePolicy: string;
    /** DO NOT USE -  AWS CodeStar Service Role Policy which grants administrative privileges in order for CodeStar to manage IAM and other service resources on behalf of the customer. */
    static AWSCodeStarServiceRole: string;
    /** Denies access to certain actions, applied by the AWS team in the event that an IAM user's credentials have been compromised or exposed publicly.  Do NOT remove this policy.  Instead, please follow the instructions specified in the email sent to you regarding this event. */
    static AWSCompromisedKeyQuarantine: string;
    /** Denies access to certain actions, applied by the AWS team in the event that an IAM user's credentials have been compromised or exposed publicly. Do NOT remove this policy. Instead, please follow the instructions specified in the support case created for you regarding this event. */
    static AWSCompromisedKeyQuarantineV2: string;
    /** Denies access to certain actions, applied by AWS in the event that an IAM user's credentials have been compromised or exposed publicly. The policy aims to limit the potential damage that may be caused by fraud-related activity leading to unauthorized charges, while not impacting the existing resources. Do NOT remove this policy. Instead, please follow the instructions specified in the support case created for you regarding this event. */
    static AWSCompromisedKeyQuarantineV3: string;
    /** Allows Config to call AWS services and deploy config resources across organization */
    static AWSConfigMultiAccountSetupPolicy: string;
    /** Allows AWS Config to remediate noncompliant resources on your behalf. */
    static AWSConfigRemediationServiceRolePolicy: string;
    /** Allows AWS Config to call read-only AWS Organizations APIs */
    static AWSConfigRoleForOrganizations: string;
    /** Allows an AWS Lambda function to access the AWS Config API and the configuration snapshots that AWS Config delivers periodically to Amazon S3. This access is required by functions that evaluate configuration changes for custom Config rules. */
    static AWSConfigRulesExecutionRole: string;
    /** Allows Config to call AWS services and collect resource configurations on your behalf. */
    static AWSConfigServiceRolePolicy: string;
    /** Provides access to use AWS Config, including searching by tags on resources, and reading all tags. This does not provide permission to configure AWS Config, which requires administrative privileges. */
    static AWSConfigUserAccess: string;
    /** Enables broad read/write access to ALL EC2 objects, read/write access to S3 buckets starting with 'import-to-ec2-', and the ability to list all S3 buckets, for the AWS Connector to import VMs on your behalf. */
    static AWSConnector: string;
    /** Allows AWS Control Tower to call AWS services that provide automated account configuration and centralized governance on your behalf. */
    static AWSControlTowerAccountServiceRolePolicy: string;
    /** Provides access to AWS Resources managed or used by AWS Control Tower */
    static AWSControlTowerServiceRolePolicy: string;
    /** Grants permissions to to describe the organization of the account, create S3 buckets for the MAP program and apply tags to it, create a Cost and Usage Report, and describe Cost and Usage Report definitions. */
    static AWSCostAndUsageReportAutomationPolicy: string;
    /** Gives Data Grant owners access to AWS Data Exchange actions using the AWS Management Console and SDK. */
    static AWSDataExchangeDataGrantOwnerFullAccess: string;
    /** Gives Data Grant receiver access to AWS Data Exchange actions using the AWS Management Console and SDK. */
    static AWSDataExchangeDataGrantReceiverFullAccess: string;
    /** Grants full access to AWS Data Exchange and AWS Marketplace actions using the AWS Management Console and SDK. It also provides select access to related services needed to take full advantage of AWS Data Exchange. */
    static AWSDataExchangeFullAccess: string;
    /** Grants data provider access to AWS Data Exchange and AWS Marketplace actions using the AWS Management Console and SDK. It also provides select access to related services needed to take full advantage of AWS Data Exchange. */
    static AWSDataExchangeProviderFullAccess: string;
    /** Grants read-only access to AWS Data Exchange and AWS Marketplace actions using the AWS Management Console and SDK. */
    static AWSDataExchangeReadOnly: string;
    /** Allows AWS Data Exchange to access AWS Services and Resources used or managed by AWS Data Exchange for license management. */
    static AWSDataExchangeServiceRolePolicyForLicenseManagement: string;
    /** Allows AWS Data Exchange to read data about your AWS Organization to determine eligibility for AWS Data Exchange data grants license distribution. */
    static AWSDataExchangeServiceRolePolicyForOrganizationDiscovery: string;
    /** Grants data subscriber access to AWS Data Exchange and AWS Marketplace actions using the AWS Management Console and SDK. It also provides select access to related services needed to take full advantage of AWS Data Exchange. */
    static AWSDataExchangeSubscriberFullAccess: string;
    /** Provides appropriate permissions to AWS Data Lifecycle Manager to take actions on AWS resources */
    static AWSDataLifecycleManagerServiceRole: string;
    /** Provides appropriate permissions to AWS Data Lifecycle Manager to take actions on AWS resources for AMI Management */
    static AWSDataLifecycleManagerServiceRoleForAMIManagement: string;
    /** Provides Amazon Data Lifecycle Manager permission to perform the Systems Manager actions required to run pre and post scripts on all Amazon EC2 instances. */
    static AWSDataLifecycleManagerSSMFullAccess: string;
    /** Provides full access to Data Pipeline, list access for S3, DynamoDB, Redshift, RDS, SNS, and IAM roles, and passRole access for default Roles. */
    static AWSDataPipelineFullAccess: string;
    /** Provides full access to Data Pipeline, list access for S3, DynamoDB, Redshift, RDS, SNS, and IAM roles, and passRole access for default Roles. */
    static AWSDataPipelinePowerUser: string;
    /** Allows DataSync Discovery to integrate with other AWS services on your behalf. */
    static AWSDataSyncDiscoveryServiceRolePolicy: string;
    /** Provides full access to AWS DataSync and minimal access to its dependencies */
    static AWSDataSyncFullAccess: string;
    /** Provides read-only access to AWS DataSync */
    static AWSDataSyncReadOnlyAccess: string;
    /** Allows DataSync to integrate with other AWS services on your behalf */
    static AWSDataSyncServiceRolePolicy: string;
    /** Provides AWS Deadline Cloud workers with access to run tasks on a farm. */
    static AWSDeadlineCloudFleetWorker: string;
    /** Provides user workstation access to AWS Deadline Cloud farms with limited Read-Only permissions to call other necessary services. Attach this policy to the user role associated with your studio. */
    static AWSDeadlineCloudUserAccessFarms: string;
    /** Provides user workstation access to AWS Deadline Cloud fleets with limited Read-Only permissions to call other necessary services. Attach this policy to the user role associated with your studio. */
    static AWSDeadlineCloudUserAccessFleets: string;
    /** Provides user workstation access to AWS Deadline Cloud jobs with limited Read-Only permissions to call other necessary services. Attach this policy to the user role associated with your studio. */
    static AWSDeadlineCloudUserAccessJobs: string;
    /** Provides user workstation access to AWS Deadline Cloud queues with limited Read-Only permissions to call other necessary services. Attach this policy to the user role associated with your studio. */
    static AWSDeadlineCloudUserAccessQueues: string;
    /** Provides access for AWS Deadline Cloud worker hosts to join a fleet in a farm. */
    static AWSDeadlineCloudWorkerHost: string;
    /** This policy specifies permissions required by DeepLens Administrative lambda functions that run on a DeepLens device */
    static AWSDeepLensLambdaFunctionAccessPolicy: string;
    /** Grants AWS DeepLens access to AWS Services, resources and roles needed by DeepLens and its dependencies including IoT, S3, GreenGrass and AWS Lambda. */
    static AWSDeepLensServiceRolePolicy: string;
    /** DeepRacer admin access to all actions including toggling between multiuser and single user mode. */
    static AWSDeepRacerAccountAdminAccess: string;
    /** Allows CloudFormation to create and manage AWS stacks and resources on your behalf. */
    static AWSDeepRacerCloudFormationAccessPolicy: string;
    /** DeepRacer MultiUser Default user access to use deepracer in multi-user mode */
    static AWSDeepRacerDefaultMultiUserAccess: string;
    /** Provides full access to AWS DeepRacer. Also provides select access to related services (e.g., S3). */
    static AWSDeepRacerFullAccess: string;
    /** Allows RoboMaker to create required resources and call AWS services on your behalf. */
    static AWSDeepRacerRoboMakerAccessPolicy: string;
    /** Allows DeepRacer to create required resources and call AWS services on your behalf. */
    static AWSDeepRacerServiceRolePolicy: string;
    /** Deny all access. */
    static AWSDenyAll: string;
    /** Provides full access to all AWS Device Farm operations. */
    static AWSDeviceFarmFullAccess: string;
    /** Grant permissions to AWS Device Farm to call EC2 Network APIs on your behalf. */
    static AWSDeviceFarmServiceRolePolicy: string;
    /** Grant permissions to AWS Device Farm to call EC2 APIs on your behalf. */
    static AWSDeviceFarmTestGridServiceRolePolicy: string;
    /** Provides full access to AWS Direct Connect via the AWS Management Console. */
    static AWSDirectConnectFullAccess: string;
    /** Provides read only access to AWS Direct Connect via the AWS Management Console. */
    static AWSDirectConnectReadOnlyAccess: string;
    /** Provides AWS Direct Connect permission to create and manage AWS resources on your behalf. */
    static AWSDirectConnectServiceRolePolicy: string;
    /** Provides full access to AWS Directory Service Data. */
    static AWSDirectoryServiceDataFullAccess: string;
    /** Provides read-only access to AWS Directory Service Data */
    static AWSDirectoryServiceDataReadOnlyAccess: string;
    /** Provides full access to AWS Directory Service. */
    static AWSDirectoryServiceFullAccess: string;
    /** Provides read only access to AWS Directory Service. */
    static AWSDirectoryServiceReadOnlyAccess: string;
    /** Policy for the Directory Service Service Linked Role */
    static AWSDirectoryServiceServiceRolePolicy: string;
    /** Provides write access to AWS resources required for AWS Discovery Continuous Export */
    static AWSDiscoveryContinuousExportFirehosePolicy: string;
    /** Allows DMS Fleet Advisor to manage CloudWatch metrics on your behalf. */
    static AWSDMSFleetAdvisorServiceRolePolicy: string;
    /** Grants AWS DMS Serverless permissions to create and manage DMS resources in your account on your behalf */
    static AWSDMSServerlessServiceRolePolicy: string;
    /** Allows EC2 CapacityReservation Fleet service to manage Capacity Reservations */
    static AWSEC2CapacityReservationFleetRolePolicy: string;
    /** Allows EC2 Fleet to launch and manage instances. */
    static AWSEC2FleetServiceRolePolicy: string;
    /** Allows EC2 Spot Fleet to launch and manage spot fleet instances */
    static AWSEC2SpotFleetServiceRolePolicy: string;
    /** Allows EC2 Spot to launch and manage spot instances */
    static AWSEC2SpotServiceRolePolicy: string;
    /** This policy is attached to the IAM role that's attached to your Amazon EC2 Windows Instances to enable the Amazon EC2 VSS solution to create and add tags to Amazon Machine Images (AMI) and EBS Snapshots. */
    static AWSEC2VssSnapshotPolicy: string;
    /** Enables access to AWS services and resources used or managed by AWS ECR pull through cache */
    static AWSECRPullThroughCacheServiceRolePolicy: string;
    /** Provide the instance in your custom platform builder environment permission to launch EC2 instance, create EBS snapshot and AMI, stream logs to Amazon CloudWatch Logs, and store artifacts in Amazon S3. */
    static AWSElasticBeanstalkCustomPlatformforEC2Role: string;
    /** AWS Elastic Beanstalk Service policy for Health Monitoring system */
    static AWSElasticBeanstalkEnhancedHealth: string;
    /** AWS Elastic Beanstalk Service Role policy that grants limited permissions to update your resources on your behalf for maintenance purposes. */
    static AWSElasticBeanstalkMaintenance: string;
    /** This policy is for the AWS Elastic Beanstalk service role used to perform managed updates of Elastic Beanstalk environments. This policy should not be attached to other users or roles. The policy grants broad permissions to create and manage resources across a number of AWS services including AutoScaling, EC2, ECS, Elastic Load Balancing and CloudFormation.  This policy also allows passing of any IAM role usable with those services. */
    static AWSElasticBeanstalkManagedUpdatesCustomerRolePolicy: string;
    /** AWS Elastic Beanstalk Service Role policy that grants limited permissions to managed updates. */
    static AWSElasticBeanstalkManagedUpdatesServiceRolePolicy: string;
    /** Provide the instances in your multicontainer Docker environment access to use the Amazon EC2 Container Service to manage container deployment tasks. */
    static AWSElasticBeanstalkMulticontainerDocker: string;
    /** Grants read-only permissions. Explicitly allows operators to gain direct access to retrieve information about resources related to AWS Elastic Beanstalk applications. */
    static AWSElasticBeanstalkReadOnly: string;
    /** AWSElasticBeanstalkRoleCore (Elastic Beanstalk operations role) Allows core operation of a web service environment. */
    static AWSElasticBeanstalkRoleCore: string;
    /** (Elastic Beanstalk operations role) Allows an environment to manage Amazon CloudWatch Logs log groups. */
    static AWSElasticBeanstalkRoleCWL: string;
    /** (Elastic Beanstalk operations role) Allows a multicontainer Docker environment to manage Amazon ECS clusters. */
    static AWSElasticBeanstalkRoleECS: string;
    /** (Elastic Beanstalk operations role) Allows an environment to integrate an Amazon RDS instance. */
    static AWSElasticBeanstalkRoleRDS: string;
    /** (Elastic Beanstalk operations role) Allows an environment to enable Amazon SNS topic integration. */
    static AWSElasticBeanstalkRoleSNS: string;
    /** (Elastic Beanstalk operations role) Allows a worker environment tier to create an Amazon DynamoDB table and an Amazon SQS queue. */
    static AWSElasticBeanstalkRoleWorkerTier: string;
    /** This policy is on a deprecation path. See documentation for guidance: https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-servicerole.html. AWS Elastic Beanstalk Service role policy which grants permissions to create & manage resources (i.e.: AutoScaling, EC2, S3, CloudFormation, ELB, etc.) on your behalf. */
    static AWSElasticBeanstalkService: string;
    /** AWS Elastic Beanstalk Service Linked Role policy which grants permissions to create & manage resources (i.e.: AutoScaling, EC2, S3, CloudFormation, ELB, etc.) on your behalf. */
    static AWSElasticBeanstalkServiceRolePolicy: string;
    /** Provide the instances in your web server environment access to upload log files to Amazon S3. */
    static AWSElasticBeanstalkWebTier: string;
    /** Provide the instances in your worker environment access to upload log files to Amazon S3, to use Amazon SQS to monitor your application's job queue, to use Amazon DynamoDB to perform leader election, and to Amazon CloudWatch to publish metrics for health monitoring. */
    static AWSElasticBeanstalkWorkerTier: string;
    /** This policy allows installing the AWS Replication Agent, which is used with AWS Elastic Disaster Recovery (DRS) to recover external servers to AWS. Attach this policy to your IAM users or roles whose credentials you provide during the installation step of the AWS Replication Agent. */
    static AWSElasticDisasterRecoveryAgentInstallationPolicy: string;
    /** This policy allows using the AWS Replication Agent, which is used with AWS Elastic Disaster Recovery (DRS) to recover source servers to AWS. We do not recommend that you attach this policy to your IAM users or roles. */
    static AWSElasticDisasterRecoveryAgentPolicy: string;
    /** This policy provides full access to all public APIs of AWS Elastic Disaster Recovery (DRS), as well as permissions to read KMS key, License Manager, Resource Groups, Elastic Load Balancing, IAM, and EC2 information. Attach this policy to your IAM users or roles. */
    static AWSElasticDisasterRecoveryConsoleFullAccess: string;
    /** This policy provides full access to all public APIs of AWS Elastic Disaster Recovery (AWS DRS), as well as all public APIs in other AWS services used by AWS DRS Console. Attach this policy to your users or roles. */
    static AWSElasticDisasterRecoveryConsoleFullAccessV2: string;
    /** This policy is attached to the AWS Elastic Disaster Recovery Conversion server's instance role. This policy allows Elastic Disaster Recovery (DRS) Conversion Servers, which are EC2 instances launched by Elastic Disaster Recovery, to communicate with the DRS service. An IAM role with this policy is attached (as an EC2 Instance Profile) by DRS to the DRS Conversion Servers, which are automatically launched and terminated by DRS, when needed. We do not recommend that you attach this policy to your IAM users or roles. DRS Conversion Servers are used by Elastic Disaster Recovery when users choose to recover source servers using the DRS console, CLI, or API. */
    static AWSElasticDisasterRecoveryConversionServerPolicy: string;
    /** This policy allows AWS Elastic Disaster Recovery (DRS) to support cross-account replication and cross-account failback. */
    static AWSElasticDisasterRecoveryCrossAccountReplicationPolicy: string;
    /** This policy allows installing and using the AWS Replication Agent, which is used by AWS Elastic Disaster Recovery (DRS) to recover source servers that run on EC2 (cross-region or cross-AZ). An IAM role with this policy should be attached (as an EC2 Instance Profile) to the EC2 Instances. */
    static AWSElasticDisasterRecoveryEc2InstancePolicy: string;
    /** You can attach the AWSElasticDisasterRecoveryFailbackInstallationPolicy policy to your IAM identities.  This policy allows installing the Elastic Disaster Recovery Failback Client, which is used to failback Recovery Instances back to your original source infrastructure. Attach this policy to your IAM users or roles whose credentials you provide when running the Elastic Disaster Recovery Failback Client. */
    static AWSElasticDisasterRecoveryFailbackInstallationPolicy: string;
    /** This policy allows using the Elastic Disaster Recovery Failback Client, which is used to failback Recovery Instances back to your original source infrastructure. We do not recommend that you attach this policy to your IAM users or roles. */
    static AWSElasticDisasterRecoveryFailbackPolicy: string;
    /** This policy allows you to use Amazon SSM and additional services required permissions to run post-launch actions in AWS Elastic Disaster Recovery (AWS DRS). Attach this policy to your IAM roles or users. */
    static AWSElasticDisasterRecoveryLaunchActionsPolicy: string;
    /** This policy allows AWS Elastic Disaster Recovery (DRS) to support network replication. */
    static AWSElasticDisasterRecoveryNetworkReplicationPolicy: string;
    /** You can attach the AWSElasticDisasterRecoveryReadOnlyAccess policy to your IAM identities.  This policy provides permissions to all read-only public APIs of Elastic Disaster Recovery (DRS), as well as some read-only APIs of other AWS services that are required in order to make full read-only use of the DRS console. Attach this policy to your IAM users or roles. */
    static AWSElasticDisasterRecoveryReadOnlyAccess: string;
    /** This policy is attached to the instance role of Elastic Disaster Recovery's Recovery Instance.  This policy allows the Elastic Disaster Recovery (DRS) Recovery Instance, which are EC2 instances launched by Elastic Disaster Recovery - to communicate with the DRS service, and to be able to failback to their original source infrastructure. An IAM role with this policy is attached (as an EC2 Instance Profile) by Elastic Disaster Recovery to the DRS Recovery Instances. We do not recommend that you attach this policy to your IAM users or roles. */
    static AWSElasticDisasterRecoveryRecoveryInstancePolicy: string;
    /** This policy is attached to the Elastic Disaster Recovery Replication server's instance role. This policy allows the Elastic Disaster Recovery (DRS) Replication Servers, which are EC2 instances launched by Elastic Disaster Recovery - to communicate with the DRS service, and to create EBS snapshots in your AWS account. An IAM role with this policy is attached (as an EC2 Instance Profile) by Elastic Disaster Recovery to the DRS Replication Servers which are automatically launched and terminated by DRS, as needed. DRS Replication Servers are used to facilitate data replication from your external servers to AWS, as part of the recovery process managed by DRS. We do not recommend that you attach this policy to your IAM users or roles. */
    static AWSElasticDisasterRecoveryReplicationServerPolicy: string;
    /** This policy allows Elastic Disaster Recovery to manage AWS resources on your behalf. */
    static AWSElasticDisasterRecoveryServiceRolePolicy: string;
    /** This policy allows read-only access to AWS Elastic Disaster Recovery (DRS) resources such as source servers and jobs. It also allows creating a converted snapshot and sharing that EBS snapshot with a specific account. */
    static AWSElasticDisasterRecoveryStagingAccountPolicy: string;
    /** This policy is used by AWS Elastic Disaster Recovery (DRS) to recover source servers into a separate target account and to allow failing back. We do not recommend that you attach this policy to your IAM users or roles. */
    static AWSElasticDisasterRecoveryStagingAccountPolicyV2: string;
    /** Service Linked Role Policy for AWS Elastic Load Balancing Control Plane - Classic */
    static AWSElasticLoadBalancingClassicServiceRolePolicy: string;
    /** Service Linked Role Policy for AWS Elastic Load Balancing Control Plane */
    static AWSElasticLoadBalancingServiceRolePolicy: string;
    /** Provides full access to AWS Elemental MediaConnect resources. */
    static AWSElementalMediaConnectFullAccess: string;
    /** Provides read-only access to AWS Elemental MediaConnect resources. */
    static AWSElementalMediaConnectReadOnlyAccess: string;
    /** Provides full access to AWS Elemental MediaConvert via the AWS Management Console and SDK. */
    static AWSElementalMediaConvertFullAccess: string;
    /** Provides read only access to AWS Elemental MediaConvert via the AWS Management Console and SDK. */
    static AWSElementalMediaConvertReadOnly: string;
    /** Provides full access to AWS Elemental MediaLive resources */
    static AWSElementalMediaLiveFullAccess: string;
    /** Provides read only access to AWS Elemental MediaLive resources */
    static AWSElementalMediaLiveReadOnly: string;
    /** Provides full access to AWS Elemental MediaPackage resources */
    static AWSElementalMediaPackageFullAccess: string;
    /** Provides read only access to AWS Elemental MediaPackage resources */
    static AWSElementalMediaPackageReadOnly: string;
    /** Provides full access to AWS Elemental MediaPackageV2 resources. */
    static AWSElementalMediaPackageV2FullAccess: string;
    /** Provides read-only access to AWS Elemental MediaPackageV2 resources. */
    static AWSElementalMediaPackageV2ReadOnly: string;
    /** Provides full read and write access to all MediaStore APIs */
    static AWSElementalMediaStoreFullAccess: string;
    /** Provides read-only permissions for MediaStore APIs */
    static AWSElementalMediaStoreReadOnly: string;
    /** Provides full access to AWS Elemental MediaTailor resources */
    static AWSElementalMediaTailorFullAccess: string;
    /** Provides read only access to AWS Elemental MediaTailor resources */
    static AWSElementalMediaTailorReadOnly: string;
    /** Policy to enable enhanced classic networking management feature. */
    static AWSEnhancedClassicNetworkingMangementPolicy: string;
    /** Provides console full access to AWS Entity Resolution and related services. */
    static AWSEntityResolutionConsoleFullAccess: string;
    /** Provides read-only access to AWS Entity Resolution via the AWS Management Console. */
    static AWSEntityResolutionConsoleReadOnlyAccess: string;
    /** This policy grants the Fault Injection Simulator Service permission in EC2 and other required services to perform FIS actions. */
    static AWSFaultInjectionSimulatorEC2Access: string;
    /** This policy grants the Fault Injection Simulator Service permission in ECS and other required services to perform FIS actions. */
    static AWSFaultInjectionSimulatorECSAccess: string;
    /** This policy grants the Fault Injection Simulator Service permission in EKS and other required services to perform FIS actions. */
    static AWSFaultInjectionSimulatorEKSAccess: string;
    /** This policy grants the Fault Injection Simulator Service permission in EC2 networking and other required services to perform FIS actions. */
    static AWSFaultInjectionSimulatorNetworkAccess: string;
    /** This policy grants the Fault Injection Simulator Service permission in RDS and other required services to perform FIS actions. */
    static AWSFaultInjectionSimulatorRDSAccess: string;
    /** This policy grants the Fault Injection Simulator Service permission in SSM and other required services to perform FIS actions. */
    static AWSFaultInjectionSimulatorSSMAccess: string;
    /** Policy to enable access to AWS Service and Resources used or managed by Amazon FinSpace */
    static AWSFinSpaceServiceRolePolicy: string;
    /** Full access for AWS FM Administrator */
    static AWSFMAdminFullAccess: string;
    /** Read only access for AWS FM Administrator that allows monitoring AWS FM operations */
    static AWSFMAdminReadOnlyAccess: string;
    /** Provides read only access to AWS WAF actions for AWS Firewall Manager member accounts */
    static AWSFMMemberReadOnlyAccess: string;
    /** Managed policy for AWS For Wordpress Plugin */
    static AWSForWordPressPluginPolicy: string;
    /** Policy which allows AWS Code Connections to sync content from your git repository */
    static AWSGitSyncServiceRolePolicy: string;
    /** Policy granting permissions to AWS Global Accelerator to manage EC2 Elastic Network Interfaces and Security Groups. */
    static AWSGlobalAcceleratorSLRPolicy: string;
    /** Provides full access to AWS Glue via the AWS Management Console */
    static AWSGlueConsoleFullAccess: string;
    /** Provides full access to AWS Glue via the AWS Management Console and access to sagemaker notebook instances. */
    static AWSGlueConsoleSageMakerNotebookFullAccess: string;
    /** Provides full access to AWS Glue DataBrew via the AWS Management Console. Also provides select access to related services (e.g., S3, KMS, Glue). */
    static AwsGlueDataBrewFullAccessPolicy: string;
    /** This policy grants permission to glue to perform action on user's glue data catalog, this policy also provides permission to ec2 actions to allow glue to create ENI to connect to resources in the VPC, also allow glue to access registered data in lakeformation and permission to access user's cloudwatch */
    static AWSGlueDataBrewServiceRole: string;
    /** Provides full access to the AWS Glue Schema Registry Service */
    static AWSGlueSchemaRegistryFullAccess: string;
    /** Provides readonly access to the AWS Glue Schema Registry Service */
    static AWSGlueSchemaRegistryReadonlyAccess: string;
    /** Policy for AWS Glue service role which allows customer to manage notebook server */
    static AWSGlueServiceNotebookRole: string;
    /** Policy for AWS Glue service role which allows access to related services including EC2, S3, and Cloudwatch Logs */
    static AWSGlueServiceRole: string;
    /** Provides permissions that allows users to create and use only the notebook sessions that are associated with the user. This policy also includes permissions to explicitly allow users to pass a restricted Glue session role. */
    static AwsGlueSessionUserRestrictedNotebookPolicy: string;
    /** Provides full access to all AWS Glue resources except for sessions. Allows users to create and use only the notebook sessions that are associated with the user. This policy also includes other permissions needed by AWS Glue to manage Glue resources in other AWS services. */
    static AwsGlueSessionUserRestrictedNotebookServiceRole: string;
    /** Provides permissions that allows users to create and use only the interactive sessions that are associated with the user. This policy also includes permissions to explicitly allow users to pass a restricted Glue session role. */
    static AwsGlueSessionUserRestrictedPolicy: string;
    /** Provides full access to all AWS Glue resources except for sessions. Allows users to create and use only the interactive sessions that are associated with the user. This policy also includes other permissions needed by AWS Glue to manage Glue resources in other AWS services */
    static AwsGlueSessionUserRestrictedServiceRole: string;
    /** Provides access within Amazon Grafana to create and manage workspaces for the entire organization. */
    static AWSGrafanaAccountAdministrator: string;
    /** Access to read only operations in Amazon Grafana. */
    static AWSGrafanaConsoleReadOnlyAccess: string;
    /** Provides only the ability to update user and group permissions for AWS Grafana workspaces. */
    static AWSGrafanaWorkspacePermissionManagement: string;
    /** Provides ability to update IAM Identity Center (IdC) user and group permissions for Amazon Managed Grafana workspaces. */
    static AWSGrafanaWorkspacePermissionManagementV2: string;
    /** This policy gives full access to the AWS Greengrass configuration, management and deployment actions */
    static AWSGreengrassFullAccess: string;
    /** This policy gives read only access to the AWS Greengrass configuration, management and deployment actions */
    static AWSGreengrassReadOnlyAccess: string;
    /** Policy for AWS Greengrass service role which allows access to related services including AWS Lambda and AWS IoT thing shadows. */
    static AWSGreengrassResourceAccessRolePolicy: string;
    /** Provides the Dataflow Endpoint Instance permissions to use the AWS Ground Station Agent */
    static AWSGroundStationAgentInstancePolicy: string;
    /** Allows AWS Health to enable the Health event processor feature. */
    static AWSHealthEventProcessorServiceRolePolicy: string;
    /** Allows full access to the AWS Health Apis and Notifications and the Personal Health Dashboard */
    static AWSHealthFullAccess: string;
    /** Provides full access to AWS Health Imaging service. */
    static AWSHealthImagingFullAccess: string;
    /** Provides read only access to AWS Health Imaging service. */
    static AWSHealthImagingReadOnlyAccess: string;
    /** Provides the list of actions that are allowed for roles assumed with the IAM Identity Center identity context. AWS Security Token Service (AWS STS) automatically attaches this policy to assumed roles. The identity context is passed as ProvidedContext. */
    static AWSIAMIdentityCenterAllowListForIdentityContext: string;
    /** Grants full access to the Identity Sync service */
    static AWSIdentitySyncFullAccess: string;
    /** Read only access to the Identity Sync service */
    static AWSIdentitySyncReadOnlyAccess: string;
    /** Provides full access to all AWS Image Builder actions and resource scoped access to related AWS services. */
    static AWSImageBuilderFullAccess: string;
    /** Provides read only access to all AWS Image Builder actions. */
    static AWSImageBuilderReadOnlyAccess: string;
    /** Provides read and write access to the jobs created under the AWS account. */
    static AWSImportExportFullAccess: string;
    /** Provides read only access to the jobs created under the AWS account. */
    static AWSImportExportReadOnlyAccess: string;
    /** Grants Incident Manager permissions to call other AWS services as a part of managing an incident. */
    static AWSIncidentManagerIncidentAccessServiceRolePolicy: string;
    /** This policy grants permissions to start, view, and update incidents with full access to custom timeline events & related items. Assign this policy to users who will create and resolve incidents. */
    static AWSIncidentManagerResolverAccess: string;
    /** This policy grants Incident Manager permission to manage incident records and related resources on your behalf. */
    static AWSIncidentManagerServiceRolePolicy: string;
    /** Provides full access to IoT Analytics. */
    static AWSIoTAnalyticsFullAccess: string;
    /** Provides read only access to IoT Analytics. */
    static AWSIoTAnalyticsReadOnlyAccess: string;
    /** This policy gives full access to the AWS IoT configuration actions */
    static AWSIoTConfigAccess: string;
    /** This policy gives read only access to the AWS IoT configuration actions */
    static AWSIoTConfigReadOnlyAccess: string;
    /** This policy gives full access to the AWS IoT messaging actions */
    static AWSIoTDataAccess: string;
    /** Provides write access to IoT thing groups and read access to IoT Certificates for execution of ADD_THINGS_TO_THING_GROUP mitigation action */
    static AWSIoTDeviceDefenderAddThingsToThingGroupMitigationAction: string;
    /** Provides read access for IoT and related resources */
    static AWSIoTDeviceDefenderAudit: string;
    /** Provides access for enabling IoT logging for execution of ENABLE_IOT_LOGGING mitigation action */
    static AWSIoTDeviceDefenderEnableIoTLoggingMitigationAction: string;
    /** Provides messages publish access to SNS topic for execution of PUBLISH_FINDING_TO_SNS mitigation action */
    static AWSIoTDeviceDefenderPublishFindingsToSNSMitigationAction: string;
    /** Provides write access to IoT policies for execution of REPLACE_DEFAULT_POLICY_VERSION mitigation action */
    static AWSIoTDeviceDefenderReplaceDefaultPolicyMitigationAction: string;
    /** Provides write access to IoT CA certificates for execution of  UPDATE_CA_CERTIFICATE mitigation action */
    static AWSIoTDeviceDefenderUpdateCACertMitigationAction: string;
    /** Provides write access to IoT certificates for execution of UPDATE_DEVICE_CERTIFICATE mitigation action */
    static AWSIoTDeviceDefenderUpdateDeviceCertMitigationAction: string;
    /** Allows AWS IoT Device Tester to run the FreeRTOS qualification suite by allowing access to services including IoT, S3, and IAM */
    static AWSIoTDeviceTesterForFreeRTOSFullAccess: string;
    /** Allows AWS IoT Device Tester to run the AWS Greengrass qualification suite by allowing access to related services including Lambda, IoT, API Gateway, IAM */
    static AWSIoTDeviceTesterForGreengrassFullAccess: string;
    /** Provides full access to IoT Events. */
    static AWSIoTEventsFullAccess: string;
    /** Provides read only access to IoT Events. */
    static AWSIoTEventsReadOnlyAccess: string;
    /** Federation access for IoT Fleet Hub applications */
    static AWSIoTFleetHubFederationAccess: string;
    /** Grants permissions to AWS Resources and metaData used or managed by AWSIoTFleetwise for auxiliary features */
    static AWSIoTFleetwiseServiceRolePolicy: string;
    /** This policy gives full access to the AWS IoT configuration and messaging actions */
    static AWSIoTFullAccess: string;
    /** Allows creation of Amazon CloudWatch Log groups and streaming logs to the groups */
    static AWSIoTLogging: string;
    /** Provides full access to managed integrations for AWS IoT Device Management and related services. */
    static AWSIoTManagedIntegrationsFullAccess: string;
    /** Provides managed integrations for AWS IoT Device Management permission to publish logs and metrics on your behalf. */
    static AWSIoTManagedIntegrationsRolePolicy: string;
    /** Allows access to create AWS IoT Job and describe the AWS code signer job */
    static AWSIoTOTAUpdate: string;
    /** Allows access to all AWS services supported in AWS IoT Rule Actions */
    static AWSIoTRuleActions: string;
    /** Provides full access to manage AWS IoT SiteWise using the AWS Management Console. Note this policy also grants access to create and list data stores used with AWS IoT SiteWise (e.g. AWS IoT Analytics), access to list and view AWS IoT Greengrass resources, list and modify AWS Secrets Manager secrets, retrieve AWS IoT thing shadows, list resources with specific tags, and create and use a service-linked role for AWS IoT SiteWise. */
    static AWSIoTSiteWiseConsoleFullAccess: string;
    /** Provides full access to IoT SiteWise. */
    static AWSIoTSiteWiseFullAccess: string;
    /** This policy grants permissions to access AWS IoT SiteWise assets and asset data, create AWS IoT SiteWise Monitor resources, and list AWS SSO users. */
    static AWSIoTSiteWiseMonitorPortalAccess: string;
    /** This role grants AWS IoT SiteWise monitor permissions to access your AWS IoT SiteWise assets & asset properties, and create AWS IoT Sitewise projects, dashboards & access policies through AWS IoT SiteWise portals. */
    static AWSIoTSiteWiseMonitorServiceRolePolicy: string;
    /** Provides read only access to IoT SiteWise. */
    static AWSIoTSiteWiseReadOnlyAccess: string;
    /** This policy allows users to register things at bulk using AWS IoT StartThingRegistrationTask API */
    static AWSIoTThingsRegistration: string;
    /** Allows AWS IoT TwinMaker to call other AWS services and to sync their resources on your behalf. */
    static AWSIoTTwinMakerServiceRolePolicy: string;
    /** Allows the associated identity data access to AWS IoT Wireless devices. */
    static AWSIoTWirelessDataAccess: string;
    /** Allows the associated identity full access to all AWS IoT Wireless operations. */
    static AWSIoTWirelessFullAccess: string;
    /** Provides IoT Wireless full access to publish to IoT Rules Engine on your behalf. */
    static AWSIoTWirelessFullPublishAccess: string;
    /** Allows the associated identity access to create, list and describe IoT Certificates */
    static AWSIoTWirelessGatewayCertManager: string;
    /** Allows the associated identity to create Amazon CloudWatch Logs groups and stream logs to the groups. */
    static AWSIoTWirelessLogging: string;
    /** Allows the associated identity read only access to AWS IoT wireless. */
    static AWSIoTWirelessReadOnlyAccess: string;
    /** Allows VPC IP Address Manager to access VPC resources and integrate with AWS Organizations on your behalf. */
    static AWSIPAMServiceRolePolicy: string;
    /** Used by AWS IQ to execute payment requests on behalf of a customer */
    static AWSIQContractServiceRolePolicy: string;
    /** Provides full access to AWS IQ */
    static AWSIQFullAccess: string;
    /** Allows AWS IQ to manage the role assumed by AWS IQ experts. */
    static AWSIQPermissionServiceRolePolicy: string;
    /** Enables access to AWS services and resources required for AWS KMS custom key stores */
    static AWSKeyManagementServiceCustomKeyStoresServiceRolePolicy: string;
    /** Enables AWS KMS to synchronize the shared properties of multi-Region keys. */
    static AWSKeyManagementServiceMultiRegionKeysServiceRolePolicy: string;
    /** Provides access to AWS Key Management Service (KMS). */
    static AWSKeyManagementServicePowerUser: string;
    /** Provides cross account access to Glue resources via Lake Formation. Also grants read access to other required services such as organizations and resource access manager */
    static AWSLakeFormationCrossAccountManager: string;
    /** Grants administrative access to AWS Lake Formation and related services, such as AWS Glue, to manage data lakes */
    static AWSLakeFormationDataAdmin: string;
    /** Grants full access to AWS Lambda service, AWS Lambda console features, and other related AWS services. */
    static AWSLambdaFullAccess: string;
    /** Grants read-only access to AWS Lambda service, AWS Lambda console features, and other related AWS services. */
    static AWSLambdaReadOnlyAccess: string;
    /** Provides write permissions to CloudWatch Logs. */
    static AWSLambdaBasicExecutionRole: string;
    /** Provides list and read access to DynamoDB streams and write permissions to CloudWatch logs. */
    static AWSLambdaDynamoDBExecutionRole: string;
    /** Provides minimum permissions for a Lambda function to manage ENIs (create, describe, delete) used by a VPC-enabled Lambda Function. */
    static AWSLambdaENIManagementAccess: string;
    /** Provides Put, Get access to S3 and full access to CloudWatch Logs. */
    static AWSLambdaExecute: string;
    /** Provides read access to DynamoDB Streams. */
    static AWSLambdaInvocationDynamoDB: string;
    /** Provides list and read access to Kinesis streams and write permissions to CloudWatch logs. */
    static AWSLambdaKinesisExecutionRole: string;
    /** Provides permissions required to access MSK Cluster within a VPC, manage ENIs (create, describe, delete) in the VPC and write permissions to CloudWatch Logs. */
    static AWSLambdaMSKExecutionRole: string;
    /** Grants Lambda Replicator necessary permissions to replicate functions across regions */
    static AWSLambdaReplicator: string;
    /** Default policy for AWS Lambda service role. */
    static AWSLambdaRole: string;
    /** Provides receive message, delete message, and read attribute access to SQS queues, and write permissions to CloudWatch logs. */
    static AWSLambdaSQSQueueExecutionRole: string;
    /** Provides minimum permissions for a Lambda function to execute while accessing a resource within a VPC - create, describe, delete network interfaces and write permissions to CloudWatch Logs. */
    static AWSLambdaVPCAccessExecutionRole: string;
    /** Provides permissions to allow access to the AWS License Manager API actions required to consume upon licenses that the user has entitlements. */
    static AWSLicenseManagerConsumptionPolicy: string;
    /** Allows AWS License Manager Linux Subscriptions Service to manage resources on your behalf. */
    static AWSLicenseManagerLinuxSubscriptionsServiceRolePolicy: string;
    /** AWS License Manager service master account role policy */
    static AWSLicenseManagerMasterAccountRolePolicy: string;
    /** AWS License Manager service member account role policy */
    static AWSLicenseManagerMemberAccountRolePolicy: string;
    /** AWS License Manager service default role policy */
    static AWSLicenseManagerServiceRolePolicy: string;
    /** Allows AWS License Manager User Subscriptions Service to manage resources on your behalf. */
    static AWSLicenseManagerUserSubscriptionsServiceRolePolicy: string;
    /** Allows AWS M2 to manage AWS resources on your behalf. */
    static AWSM2ServicePolicy: string;
    /** Allows AWS Managed Services to read the values of the tags on AWS resources */
    static AWSManagedServicesContactsServiceRolePolicy: string;
    /** AWS Managed Services - policy to manage detective controls infrastructure */
    static AWSManagedServicesDetectiveControlsConfigServiceRolePolicy: string;
    /** AWS Managed Services policy to enable AMS event processor feature. */
    static AWSManagedServicesEventsServiceRolePolicy: string;
    /** Allows Amazon's AWS Managed Service's Self Service Reporting feature to read AWS Organization data on your behalf to enable organization level aggregated reporting */
    static AWSManagedServicesSelfServiceReportingServiceRolePolicy: string;
    /** Allows AWS Managed Services to manage deployment toolkit on your behalf. */
    static AWSManagedServicesDeploymentToolkitPolicy: string;
    /** Provides full access to configure and customize the AWS Management Console */
    static AWSManagementConsoleAdministratorAccess: string;
    /** Grants access to essential AWS Management Console features and user experience (UX) capabilities for non-administrative users. */
    static AWSManagementConsoleBasicUserAccess: string;
    /** Allows AWS Marketplace to copy your Amazon Machine Images (AMIs) in order to list them on AWS Marketplace */
    static AWSMarketplaceAmiIngestion: string;
    /** Allows AWS Marketplace to create and manage seller deployment parameters for the products that you subscribe to on AWS Marketplace. */
    static AWSMarketplaceDeploymentServiceRolePolicy: string;
    /** Provides the ability to subscribe and unsubscribe to AWS Marketplace software, allows users to manage Marketplace software instances from the Marketplace 'Your Software' page, and provides administrative access to EC2. */
    static AWSMarketplaceFullAccess: string;
    /** Provides read access to AWS Marketplace Entitlements */
    static AWSMarketplaceGetEntitlements: string;
    /** Enables access to AWS Services and Resources used or managed by AWS Marketplace for license management. */
    static AWSMarketplaceLicenseManagementServiceRolePolicy: string;
    /** Provides the ability to subscribe and unsubscribe to AWS Marketplace software */
    static AWSMarketplaceManageSubscriptions: string;
    /** Provides full access to AWS Marketplace Metering. */
    static AWSMarketplaceMeteringFullAccess: string;
    /** Provides permissions to register a resource and track usage through AWS Marketplace Metering Service. */
    static AWSMarketplaceMeteringRegisterUsage: string;
    /** Provides full access to all administrative actions for an AWS Marketplace eProcurement integration. */
    static AWSMarketplaceProcurementSystemAdminFullAccess: string;
    /** Enables access for AWS Marketplace services to purchase order management. */
    static AWSMarketplacePurchaseOrdersServiceRolePolicy: string;
    /** Provides the ability to review AWS Marketplace subscriptions */
    static AWSMarketplaceReadOnly: string;
    /** Enables access to AWS Services and Resources used or managed by AWS Marketplace for Resale Authorization. */
    static AWSMarketplaceResaleAuthorizationServiceRolePolicy: string;
    /** Provides full access to all seller operations on the AWS Marketplace and other AWS services such as AMI management. */
    static AWSMarketplaceSellerFullAccess: string;
    /** Provides sellers access to Offers and Agreements management activities. */
    static AWSMarketplaceSellerOfferManagement: string;
    /** Provides sellers full access to AWS Marketplace Management Products page and other AWS services such as AMI management. */
    static AWSMarketplaceSellerProductsFullAccess: string;
    /** Provide sellers read-only access to AWS Marketplace Management Products page. */
    static AWSMarketplaceSellerProductsReadOnly: string;
    /** The default policy that enables access to AWS Services and Resources used or managed by MediaConnect. */
    static AWSMediaConnectServicePolicy: string;
    /** Allows MediaLive Anywhere to create and manage AWS resources on your behalf. */
    static AWSMediaLiveAnywhereServiceRolePolicy: string;
    /** Enable access to AWS Resources used or managed by MediaTailor */
    static AWSMediaTailorServiceRolePolicy: string;
    /** Policy allows AWSMigrationHubService to call AWSApplicationDiscoveryService on behalf of the customer. */
    static AWSMigrationHubDiscoveryAccess: string;
    /** Policy for Database Migration Service to assume role in customer's account to call Migration Hub */
    static AWSMigrationHubDMSAccess: string;
    /** Managed policy to provide the customer access to the Migration Hub Service */
    static AWSMigrationHubFullAccess: string;
    /** Provides limited access to AWS Migration Hub, AWS Application Discovery Service, Amazon Simple Storage Service and AWS Secrets Manager. This policy also grants full access to AWS Migration Hub Orchestrator service. */
    static AWSMigrationHubOrchestratorConsoleFullAccess: string;
    /** This policy needs to be attached for SAP and MGN migrated instance for our service to orchestrate instances by downloading scripts from S3 and to fetch secret values inside EC2 instance. */
    static AWSMigrationHubOrchestratorInstanceRolePolicy: string;
    /** Provides limited access to Amazon Simple Storage Service, AWS Secrets Manager and Plugin related actions for AWS Migration Hub Orchestrator. */
    static AWSMigrationHubOrchestratorPlugin: string;
    /** Provides permissions necessary for Migration Hub Orchestrator to migrate and modernize your on-premises workloads */
    static AWSMigrationHubOrchestratorServiceRolePolicy: string;
    /** Grants full access to AWS Migration Hub Refactor Spaces and other AWS related services except AWS Transit Gateway and EC2 security groups not required when using environments without a network bridge. This policy also excludes permissions required for AWS Lambda and AWS Resource Access Manager as they can be scoped down based on tags. */
    static AWSMigrationHubRefactorSpacesEnvironmentsWithoutBridgesFullAccess: string;
    /** Use in the IAM service role passed to the SSM Automation document AWSRefactorSpaces-CreateResources to grant permissions required to run the automation. The policy grants read/write access to EC2 tags in order to track automation progress. When the Refactor Spaces environment's network bridge is enabled, the automation also adds the environment's security group to the EC2 instance to permit traffic from other Refactor Spaces services in the environment. The policy also grants access to the Application Migration Service's post launch actions SSM parameters. */
    static AWSMigrationHubRefactorSpacesSSMAutomationPolicy: string;
    /** Grants full access to AWS MigrationHub Refactor Spaces, AWS MigrationHub Refactor Spaces console features and other related AWS services except permissions required for AWS Lambda and AWS Resource Access Manager as they can be scoped down based on tags. */
    static AWSMigrationHubRefactorSpacesFullAccess: string;
    /** Provides access to AWS Resources managed or used by AWS Migration Hub Refactor Spaces. */
    static AWSMigrationHubRefactorSpacesServiceRolePolicy: string;
    /** Policy for Server Migration Service to assume role in customer's account to call Migration Hub */
    static AWSMigrationHubSMSAccess: string;
    /** Grants permissions to allow communication with the AWS Migration Hub Strategy Recommendations service, read/write access to S3 buckets related to the service, Amazon API Gateway access to upload logs and metrics to AWS, AWS Secrets Manager access to fetch credentials, and any related services. */
    static AWSMigrationHubStrategyCollector: string;
    /** Grants full access to the AWS Migration Hub Strategy Recommendations service and access to related AWS services through the AWS Management Console. */
    static AWSMigrationHubStrategyConsoleFullAccess: string;
    /** Enable access to AWS Resources used or managed by AWS Migration Hub Strategy Recommendations service. */
    static AWSMigrationHubStrategyServiceRolePolicy: string;
    /** Grants permissions to Amazon MSK Replicator to replicate data between MSK Clusters. */
    static AWSMSKReplicatorExecutionRole: string;
    /** Grants full access to AWS Network Firewall service, including permissions to create, configure, manage, and delete firewall resources, policies, and rule groups. Additionally includes permissions to modify VPC endpoints, S3 bucket policies, CloudWatch Logs configurations, and create service-linked roles for Network Firewall and log delivery services */
    static AWSNetworkFirewallFullAccess: string;
    /** Provides read-only access to AWS Network Firewall resources via the AWS Management Console, CLI, and SDKs. This policy allows users to view and monitor firewall configurations, policies, rule groups, and associated resources, without the ability to make changes. */
    static AWSNetworkFirewallReadOnlyAccess: string;
    /** Allow AWSNetworkFirewall to create and manage necessary resources for your Firewalls. */
    static AWSNetworkFirewallServiceRolePolicy: string;
    /** Allow NetworkManager to access resources associated with your Core Network */
    static AWSNetworkManagerCloudWANServiceRolePolicy: string;
    /** Provides full access to Amazon NetworkManager via the AWS Management Console. */
    static AWSNetworkManagerFullAccess: string;
    /** Provides read only access to Amazon NetworkManager via the AWS Management Console. */
    static AWSNetworkManagerReadOnlyAccess: string;
    /** Allow NetworkManager to access resources associated with your Global Networks */
    static AWSNetworkManagerServiceRolePolicy: string;
    /** Service-linked role permissions for CloudWatch Logs centralization */
    static AWSObservabilityAdminLogsCentralizationServiceRolePolicy: string;
    /** Provides access to manage AWS Config Configuration Recorder, manage AWS Config Configuration Aggregator, create AWS Config Service Linked Role for Configuration Recorder functionality, consume recorder configuration data, and read AWS Organizations data for organizational features. */
    static AWSObservabilityAdminServiceRolePolicy: string;
    /** Provides access to manage AWS Config recorder resource and telemetry settings on AWS resources including logs, metrics. */
    static AWSObservabilityAdminTelemetryEnablementServiceRolePolicy: string;
    /** Provides full access to AWS Organizations. */
    static AWSOrganizationsFullAccess: string;
    /** Provides read-only access to AWS Organizations. */
    static AWSOrganizationsReadOnlyAccess: string;
    /** A policy to allow AWS Organizations to share trust with other approved AWS Services for the purpose of simplifying customer configuration. */
    static AWSOrganizationsServiceTrustPolicy: string;
    /** This policy grants permissions that allow you to install an Outpost server on your on-premises network. */
    static AWSOutpostsAuthorizeServerPolicy: string;
    /** Service Linked Role policy to enable access to AWS resources managed by AWS Outposts */
    static AWSOutpostsServiceRolePolicy: string;
    /** Allows AWS IoT software on an AWS Panorama Appliance to upload logs to Amazon CloudWatch. */
    static AWSPanoramaApplianceRolePolicy: string;
    /** Allows an AWS Panorama Appliance to upload logs to Amazon CloudWatch, and to get objects from Amazon S3 access points created for use with AWS Panorama. */
    static AWSPanoramaApplianceServiceRolePolicy: string;
    /** Provides full access to AWS Panorama */
    static AWSPanoramaFullAccess: string;
    /** Allows an AWS Lambda function on an AWS Panorama Appliance to manage resources in Panorama, upload logs and metrics to Amazon CloudWatch, and to manage objects in buckets created for use with Panorama. */
    static AWSPanoramaGreengrassGroupRolePolicy: string;
    /** Allows Amazon SageMaker to manage objects in buckets created for use with AWS Panorama. */
    static AWSPanoramaSageMakerRolePolicy: string;
    /** Allows AWS Panorama to manage resources in AWS IoT, AWS Secrets Manager and AWS Panorama. */
    static AWSPanoramaServiceLinkedRolePolicy: string;
    /** Allows AWS Panorama to manage resources in Amazon S3, AWS IoT, AWS IoT GreenGrass, AWS Lambda, Amazon SageMaker, and Amazon CloudWatch Logs, and to pass service roles to AWS IoT, AWS IoT GreenGrass, and Amazon SageMaker. */
    static AWSPanoramaServiceRolePolicy: string;
    /** Provides full access to AWS Partner Central and related AWS Services. */
    static AWSPartnerCentralFullAccess: string;
    /** Provides necessary access for opportunity management activities. */
    static AWSPartnerCentralOpportunityManagement: string;
    /** Provides necessary access for developer testing in the Sandbox catalog. */
    static AWSPartnerCentralSandboxFullAccess: string;
    /** Provides access to the ResourceSnapshotJob to read a resource and snapshot it in the target engagement. */
    static AWSPartnerCentralSellingResourceSnapshotJobExecutionRolePolicy: string;
    /** This policy can be used to grant read-only access to APIs that can read service metadata for services in your AWS account. You can use this policy to provide your partners in the Partner-Led Support Program with access to the services specified in the permissions details section below. */
    static AWSPartnerLedSupportReadOnlyAccess: string;
    /** Grants permission to AWS PCS compute nodes to connect to AWS PCS clusters. */
    static AWSPCSComputeNodePolicy: string;
    /** Grants permissions to PCS to manage resources on your behalf. */
    static AWSPCSServiceRolePolicy: string;
    /** Provides full access to AWS Price List Service. */
    static AWSPriceListServiceFullAccess: string;
    /** Provides auditor access to AWS Private Certificate Authority */
    static AWSPrivateCAAuditor: string;
    /** Grants essential permissions for the AWS Private CA Connector for Kubernetes. */
    static AWSPrivateCAConnectorForKubernetesPolicy: string;
    /** Provides full access to AWS Private Certificate Authority */
    static AWSPrivateCAFullAccess: string;
    /** Provides privileged certificate user access to AWS Private Certificate Authority */
    static AWSPrivateCAPrivilegedUser: string;
    /** Provides read only access to AWS Private Certificate Authority */
    static AWSPrivateCAReadOnly: string;
    /** Provides certificate user access to AWS Private Certificate Authority */
    static AWSPrivateCAUser: string;
    /** Provides full access to all administrative actions for an AWS Private Marketplace. */
    static AWSPrivateMarketplaceAdminFullAccess: string;
    /** Provides access to creating requests in an AWS Private Marketplace. */
    static AWSPrivateMarketplaceRequests: string;
    /** Allows AWS Private Networks Service to manage resources on behalf of the customer. */
    static AWSPrivateNetworksServiceRolePolicy: string;
    /** Permissions CodeBuild needs to run a build for AWS Proton CodeBuild Provisioning. */
    static AWSProtonCodeBuildProvisioningBasicAccess: string;
    /** Allows AWS Proton to manage Proton resource provisioning using CodeBuild and other AWS services on your behalf. */
    static AWSProtonCodeBuildProvisioningServiceRolePolicy: string;
    /** Provides access to the AWS Proton APIs and Management Console, but does not allow administration of Proton templates or environments. */
    static AWSProtonDeveloperAccess: string;
    /** Provides full access to the AWS Proton APIs and Management Console. In addition to these permissions, access to Amazon S3 is also needed to register template bundles from your S3 buckets, as well as access to Amazon IAM to create and manage the service roles for Proton. */
    static AWSProtonFullAccess: string;
    /** Provides read only access to the AWS Proton APIs and Management Console. */
    static AWSProtonReadOnlyAccess: string;
    /** Policy which allows AWS Proton to sync your service, environment and component definitions from your git repository to AWS Proton. */
    static AWSProtonServiceGitSyncServiceRolePolicy: string;
    /** Policy which allows AWS Proton to sync your git repository contents to Proton or sync Proton contents to your git repositories. */
    static AWSProtonSyncServiceRolePolicy: string;
    /** Grants permissions to view and modify purchase orders on billing console */
    static AWSPurchaseOrdersServiceRolePolicy: string;
    /** The AWSQuickSetupCFGCPacksPermissionsBoundary policy defines the list of permissions that are permitted in an IAM role created by Quick Setup. Quick Setup uses a role created with this policy to deploy AWS Config conformance packs. */
    static AWSQuickSetupCFGCPacksPermissionsBoundary: string;
    /** Provides permissions for AWS Systems Manager Quick Setup to deploy multiple configuration types. These configuration types create IAM roles and automations that configure frequently used Amazon Web Services services and features with recommended best practices. */
    static AWSQuickSetupDeploymentRolePolicy: string;
    /** The AWSQuickSetupDevOpsGuruPermissionsBoundary policy defines the list of permissions that are permitted in an IAM role created by Quick Setup. Quick Setup uses a role created with this policy to enable and configure Amazon DevOps Guru. This policy also provides permissions to enable Systems Manager Explorer. */
    static AWSQuickSetupDevOpsGuruPermissionsBoundary: string;
    /** QuickSetup creates IAM roles which enable it to configure the Systems Manager Distributor feature on your behalf, and uses this policy when creating such roles to define the boundary of their permissions. */
    static AWSQuickSetupDistributorPermissionsBoundary: string;
    /** This policy grants permissions that allow Systems Manager to run the AWSQuickSetupType-EnableAREX Automation runbook, which enables AWS Resource Explorer for use with Systems Manager. */
    static AWSQuickSetupEnableAREXExecutionPolicy: string;
    /** This policy grants permissions that allow principals to run the AWSQuickSetupType-EnableDHMC Automation runbook, which enables Default Host Management Configuration. */
    static AWSQuickSetupEnableDHMCExecutionPolicy: string;
    /** This policy allows Quick Setup to deploy the configuration type required to set up just-in-time node access. */
    static AWSQuickSetupJITNADeploymentRolePolicy: string;
    /** This policy grants administrative permissions that allow Systems Manager to create a default IAM instance profile for the Quick Setup capability and attach it to Amazon EC2 instances that don't already have an instance. profile attached. */
    static AWSQuickSetupManagedInstanceProfileExecutionPolicy: string;
    /** This policy provides permissions to enable just-in-time node access for Systems Manager. */
    static AWSQuickSetupManageJITNAResourcesExecutionPolicy: string;
    /** Provides read-only permissions to access patch baselines that have been configured by an administrator in the current AWS account or organization using Quick Setup. */
    static AWSQuickSetupPatchPolicyBaselineAccess: string;
    /** Provides permissions that allow Quick Setup to create resources associated with a patch policy configuration. */
    static AWSQuickSetupPatchPolicyDeploymentRolePolicy: string;
    /** QuickSetup creates IAM roles which enable it to configure the Systems Manager Patch Manager feature on your behalf, and uses this policy when creating such roles to define the boundary of their permissions. */
    static AWSQuickSetupPatchPolicyPermissionsBoundary: string;
    /** The AWSQuickSetupSchedulerPermissionsBoundary policy defines the list of permissions that are permitted in an IAM role created by Quick Setup. Quick Setup uses a role created with this policy to enable and configure scheduled operations on Amazon EC2 instances and other resources. */
    static AWSQuickSetupSchedulerPermissionsBoundary: string;
    /** This policy grants administrative permssions that allow Quick Setup to create resources that are used during the Systems Manager onboarding process. */
    static AWSQuickSetupSSMDeploymentRolePolicy: string;
    /** This policy grants permissions for listing all S3 buckets in an account; and for managing and retrieving information about specific buckets in the principal account that are managed through AWS CloudFormation templates. */
    static AWSQuickSetupSSMDeploymentS3BucketRolePolicy: string;
    /** Quick Setup creates IAM roles which enable it to configure the Host Manager Quick Setup type on your behalf, and uses this policy when creating such roles to define the boundary of their permissions. */
    static AWSQuickSetupSSMHostMgmtPermissionsBoundary: string;
    /** The policy grants administrative permissions that allow Quick Setup to run the a AWS CloudFormation custom resource on lifecycle events during Quick Setup deployment in Systems Manager. */
    static AWSQuickSetupSSMLifecycleManagementExecutionPolicy: string;
    /** This policy grants permissions that allow Systems Manager to create prerequisites such as IAM roles required for Systems Manager onboarding. */
    static AWSQuickSetupSSMManageResourcesExecutionPolicy: string;
    /** This policy grants permissions that allow principals to run the AWSQuickSetupType-StartSSMAssociations Automation runbook, which starts State Manager Associations. */
    static AWSQuickSetupStartSSMAssociationsExecutionPolicy: string;
    /** The managed policy AWSQuickSetupStartStopInstancesExecutionPolicy provides permissions for Quick Setup to start and stop Amazon EC2 instances on a schedule. This policy is used with the Quick Setup scheduler configuration type. */
    static AWSQuickSetupStartStopInstancesExecutionPolicy: string;
    /** Provides the set of permissions required to perform QuickSight Asset Bundle Export Operations */
    static AWSQuickSightAssetBundleExportPolicy: string;
    /** Provides the set of permissions required to perform QuickSight Asset Bundle Import Operations */
    static AWSQuickSightAssetBundleImportPolicy: string;
    /** Quicksight access to Athena API and S3 buckets used for Athena query results */
    static AWSQuicksightAthenaAccess: string;
    /** Allow QuickSight to describe the RDS resources */
    static AWSQuickSightDescribeRDS: string;
    /** Allow QuickSight to describe Redshift resources */
    static AWSQuickSightDescribeRedshift: string;
    /** Provides access to Amazon Elasticsearch resources from Amazon QuickSight */
    static AWSQuickSightElasticsearchPolicy: string;
    /** Give QuickSight read-only access to IoT Analytics datasets */
    static AWSQuickSightIoTAnalyticsAccess: string;
    /** Allow QuickSight to list IAM entities */
    static AWSQuickSightListIAM: string;
    /** Provides access to Amazon OpenSearch resources from Amazon QuickSight */
    static AWSQuicksightOpenSearchPolicy: string;
    /** Provides access to Amazon SageMaker resources from Amazon QuickSight */
    static AWSQuickSightSageMakerPolicy: string;
    /** Policy used by QuickSight to create secrets in AWS Secrets Manager and to attach resource policies on existing QuickSight secrets. */
    static AWSQuickSightSecretsManagerWriteAccess: string;
    /** Policy used by QuickSight to create secrets in AWS Secrets Manager and to attach resource policies on existing QuickSight secrets. */
    static AWSQuickSightSecretsManagerWritePolicy: string;
    /** AWS QuickSight access to AWS Timestream APIs. Customers can attach this policy to AWS QuickSight role to allow retrieval of data and metadata. */
    static AWSQuickSightTimestreamPolicy: string;
    /** Allows VPC Reachability Analyzer to access AWS resources and integrate with AWS Organizations on your behalf. */
    static AWSReachabilityAnalyzerServiceRolePolicy: string;
    /** This policy grants permission to use AWS services with the AWS Toolkit for .NET Refactoring extension for Microsoft Visual Studio. It is intended to be attached to a local AWS profile. The policy allows uploading application artifacts and downloading the resulting artifacts from Amazon S3. It allows building applications into a container image using AWS CodeBuild and storing and retrieving the images from Amazon Elastic Container Registry (Amazon ECR). And it allows deployment of the application to container services on AWS such as Amazon Elastic Container Service (Amazon ECS), optional creation of VPC resources, optional connection to existing infrastructure such as AWS Directory Service, and other related services. */
    static AWSRefactoringToolkitFullAccess: string;
    /** This policy is intended to be used by Amazon ECS Tasks created for testing applications in AWS using the AWS Toolkit for .NET Refactoring extension for Microsoft Visual Studio. The policy grants access to download application artifacts from Amazon S3, communicate the status of the Task using AWS Systems Manager, and other required services. */
    static AWSRefactoringToolkitSidecarPolicy: string;
    /** Provides re:Post Private access to publish CloudWatch metrics data */
    static AWSrePostPrivateCloudWatchAccess: string;
    /** This policy allows the re:Post Space service to create, manage, and resolve Support cases that are created through the Space application. */
    static AWSRepostSpaceSupportOperationsPolicy: string;
    /** Policy for AWS Resilience Hub service role which allows access to other AWS services in order to execute assessment. */
    static AWSResilienceHubAsssessmentExecutionPolicy: string;
    /** Provides full access to AWS Resource Access Manager */
    static AWSResourceAccessManagerFullAccess: string;
    /** Provides read only access to AWS Resource Access Manager. */
    static AWSResourceAccessManagerReadOnlyAccess: string;
    /** Provides access to AWS Resource Access Manager APIs needed by a resource share participant. */
    static AWSResourceAccessManagerResourceShareParticipantAccess: string;
    /** Policy containing Read-only AWS Resource Access Manager access to customers' Organizations structure. It also contains IAM permissions to self-delete the role. */
    static AWSResourceAccessManagerServiceRolePolicy: string;
    /** This policy grants administrative permissions to access Resource Explorer resources and grants read-only permissions to other AWS services to support this access. */
    static AWSResourceExplorerFullAccess: string;
    /** This policy grants administrative permissions to Resource Explorer and grants read-only permissions to other AWS services to support this access. The AWS Organizations administrator needs these permissions to setup and manage multi-account search in the console. */
    static AWSResourceExplorerOrganizationsAccess: string;
    /** This policy grants read-only permissions to search for and view Resource Explorer resources and grants read-only permissions to other AWS services to support this access. */
    static AWSResourceExplorerReadOnlyAccess: string;
    /** Allows Resource Explorer to view resources and CloudTrail events on your behalf to index your resources for search. */
    static AWSResourceExplorerServiceRolePolicy: string;
    /** This is the read only policy for AWS Resource Groups */
    static AWSResourceGroupsReadOnlyAccess: string;
    /** Provides full access to AWS RoboMaker via the AWS Management Console and SDK. Also provides select access to related services (e.g., S3, IAM). */
    static AWSRoboMakerFullAccess: string;
    /** Provides read only access to AWS RoboMaker via the AWS Management Console and SDK */
    static AWSRoboMakerReadOnlyAccess: string;
    /** RoboMaker service policy */
    static AWSRoboMakerServicePolicy: string;
    /** RoboMaker service policy */
    static AWSRoboMakerServiceRolePolicy: string;
    /** Provides all permissions to IAM Roles Anywhere resources, including but not limited to: CreateProfile, DeleteTrustAnchor, DisableCRL, ResetNotificationSettings. */
    static AWSRolesAnywhereFullAccess: string;
    /** Provides read-only permissions to IAM Roles Anywhere resources, including but not limited to: GetTrustAnchor, ListProfiles, GetCRL. There will be no other permissions for other services included in this policy. */
    static AWSRolesAnywhereReadOnly: string;
    /** Allows IAM Roles Anywhere to publish service/usage metrics to CloudWatch and check the status of Private Certificate Authorities on your behalf. */
    static AWSRolesAnywhereServicePolicy: string;
    /** Allow Amazon S3 on Outposts service to manage EC2 network resources on your behalf. */
    static AWSS3OnOutpostsServiceRolePolicy: string;
    /** Provides full access to Savings Plans service */
    static AWSSavingsPlansFullAccess: string;
    /** Provides read only access to Savings Plans service */
    static AWSSavingsPlansReadOnlyAccess: string;
    /** Provides full access to use AWS Security Hub. */
    static AWSSecurityHubFullAccess: string;
    /** Grants permission to enable and manage AWS Security Hub within an organization. Includes enabling the service across the organization, and determining the delegated administrator account for the service. */
    static AWSSecurityHubOrganizationsAccess: string;
    /** Provides read only access to AWS Security Hub resources */
    static AWSSecurityHubReadOnlyAccess: string;
    /** A service-linked role required for AWS Security Hub to access your resources. */
    static AWSSecurityHubServiceRolePolicy: string;
    /** This policy allows Security Hub to manage AWS Config rules and Security Hub resources in your organization and on your behalf. */
    static AWSSecurityHubV2ServiceRolePolicy: string;
    /** Policy provides customers with Read and Write permissions to case resources that are created through the Security Incident Response service. */
    static AWSSecurityIncidentResponseCaseFullAccess: string;
    /** Policy provides customers with Read and Write permissions to all resources associated to the Security Incident Response service. */
    static AWSSecurityIncidentResponseFullAccess: string;
    /** Policy provides customers with Read-only permissions to all resources associated to the Security Incident Response service. Permission includes access to GetCaseAttachmentDownloadUrl as well for the ability to get case attachment download URLs. */
    static AWSSecurityIncidentResponseReadOnlyAccess: string;
    /** Provides access to AWS Resources managed or used by Security Incident Response */
    static AWSSecurityIncidentResponseServiceRolePolicy: string;
    /** Provides access to AWS Security Incident Response to continuously monitor your environment for security threats, tune security services to reduce alert noise, and gather information to investigate potential incidents. */
    static AWSSecurityIncidentResponseTriageServiceRolePolicy: string;
    /** Provides full access to service catalog admin capabilities */
    static AWSServiceCatalogAdminFullAccess: string;
    /** Provides read-only access to Service Catalog admin capabilities */
    static AWSServiceCatalogAdminReadOnlyAccess: string;
    /** Provides full access to Service Catalog App Registry capabilities */
    static AWSServiceCatalogAppRegistryFullAccess: string;
    /** Provides read-only access to Service Catalog App Registry capabilites */
    static AWSServiceCatalogAppRegistryReadOnlyAccess: string;
    /** Allows Service Catalog AppRegistry to manage Resource Groups on your behalf */
    static AWSServiceCatalogAppRegistryServiceRolePolicy: string;
    /** Provides full access to service catalog enduser capabilities */
    static AWSServiceCatalogEndUserFullAccess: string;
    /** Provides read-only access to Service Catalog end-user capabilities */
    static AWSServiceCatalogEndUserReadOnlyAccess: string;
    /** A Service Linked Role Policy for AWS ServiceCatalog to sync with AWS Organizations organization structure */
    static AWSServiceCatalogOrgsDataSyncServiceRolePolicy: string;
    /** A Service Linked Role for AWS ServiceCatalog to sync Provisioning Artifacts from source repositories */
    static AWSServiceCatalogSyncServiceRolePolicy: string;
    /** Permissions required for managing nodegroups in the customer's account. These policies related to management of the following resources: AutoscalingGroups, SecurityGroups, LaunchTemplates and InstanceProfiles. */
    static AWSServiceRoleForAmazonEKSNodegroup: string;
    /** This Service Linked Role provides Amazon Q Developer ability to provide usage information. */
    static AWSServiceRoleForAmazonQDeveloper: string;
    /** This Service-Linked Role provides AWS Transform with the ability to provide usage information. */
    static AWSServiceRoleForAWSTransform: string;
    /** Provides access to Systems Manager resources used by CloudWatch Alarms */
    static AWSServiceRoleForCloudWatchAlarmsActionSSMServiceRolePolicy: string;
    /** Allows CloudWatch to access RDS Performance Insights metrics on your behalf */
    static AWSServiceRoleForCloudWatchMetricsDbPerfInsightsServiceRolePolicy: string;
    /** A service-linked role required for Amazon CodeGuru Profiler to send notifications on your behalf. */
    static AWSServiceRoleForCodeGuruProfiler: string;
    /** This role grants permissions to CodeWhisperer to access data in your account to calculate billing, provides access to create and access security reports in Amazon CodeGuru, and emit data to CloudWatch. */
    static AWSServiceRoleForCodeWhispererPolicy: string;
    /** Allows EC2 Scheduled Instances to launch and manage spot instances. */
    static AWSServiceRoleForEC2ScheduledInstances: string;
    /** AWS GroundStation uses this service-linked role to invoke EC2 to find public IPv4 addresses */
    static AWSServiceRoleForGroundStationDataflowEndpointGroupPolicy: string;
    /** Allows EC2ImageBuilder to call AWS services on your behalf. */
    static AWSServiceRoleForImageBuilder: string;
    /** Allows AWS IoT SiteWise to provision and manage gateways as well as query data. The policy includes required AWS Greengrass permissions for deploying to groups, AWS Lambda permissions for creating and updating service-prefixed functions, and AWS IoT Analytics permissions for querying data from datastores. */
    static AWSServiceRoleForIoTSiteWise: string;
    /** Allows Log Delivery service to deliver logs by calling log destination on your behalf. */
    static AWSServiceRoleForLogDeliveryPolicy: string;
    /** Grants Amazon Monitron permissions to manage AWS resources, including AWS SSO user assignment on your behalf. */
    static AWSServiceRoleForMonitronPolicy: string;
    /** Provides Cloudwatch access to publish operational and usage metrics and logs for Amazon Neptune */
    static AWSServiceRoleForNeptuneGraphPolicy: string;
    /** Provides permissions to describe and update Private Marketplace resources and describe AWS Organizations */
    static AWSServiceRoleForPrivateMarketplaceAdminPolicy: string;
    /** Policy for Procurement Insights to obtain Organization Account details */
    static AWSServiceRoleForProcurementInsightsPolicy: string;
    /** Provides access to AWS services and resources necessary to migrate service instances into AWS including EC2, S3 and Cloudformation. */
    static AWSServiceRoleForSMS: string;
    /** Provides access to the User Subscriptions service to your Identity Center resources to automatically update your subscriptions. */
    static AWSServiceRoleForUserSubscriptions: string;
    /** Provides AWS Backup permissions to create compliance reports on your behalf */
    static AWSServiceRolePolicyForBackupReports: string;
    /** This policy contains permissions for testing restores and for cleaning up resources created during tests. */
    static AWSServiceRolePolicyForBackupRestoreTesting: string;
    /** This managed policy provides administrative access to Amazon WorkSpaces to manage EC2 instances in your AWS account */
    static AWSServiceRolePolicyForWorkspacesInstances: string;
    /** Provides the AWS DDoS Response Team with limited access to your AWS account to assist with DDoS attack mitigation during a high-severity event. */
    static AWSShieldDRTAccessPolicy: string;
    /** Allows AWS Shield to access AWS resources on your behalf to provide DDoS protection. */
    static AWSShieldServiceRolePolicy: string;
    /** Provides access to publish metrics and provide insights for your social message sending. */
    static AWSSocialMessagingServiceRolePolicy: string;
    /** Provides AWS Systems Manager for SAP with the permissions needed to manage and integrate SAP software with AWS. */
    static AWSSSMForSAPServiceLinkedRolePolicy: string;
    /** Policy for Service Linked Role AWSServiceRoleForAmazonSSM_OpsInsights */
    static AWSSSMOpsInsightsServiceRolePolicy: string;
    /** Administrator access for SSO Directory */
    static AWSSSODirectoryAdministrator: string;
    /** ReadOnly access for SSO Directory */
    static AWSSSODirectoryReadOnly: string;
    /** Provides access within AWS SSO to manage AWS Organizations master and member accounts and cloud application */
    static AWSSSOMasterAccountAdministrator: string;
    /** Provides access within AWS SSO to manage AWS Organizations member accounts and cloud application */
    static AWSSSOMemberAccountAdministrator: string;
    /** Provides read only access to AWS SSO configurations. */
    static AWSSSOReadOnly: string;
    /** Grants AWS SSO permissions to manage AWS resources, including IAM roles, policies and SAML IdP on your behalf. */
    static AWSSSOServiceRolePolicy: string;
    /** An access policy for providing a user/role/etc access to the AWS StepFunctions console. For a full console experience, in addition to this policy, a user may need iam:PassRole permission on other IAM roles that can be assumed by the service. */
    static AWSStepFunctionsConsoleFullAccess: string;
    /** An access policy for providing a user/role/etc access to the AWS StepFunctions API. For full access, in addition to this policy, a user MUST have iam:PassRole permission on at least one IAM role that can be assumed by the service. */
    static AWSStepFunctionsFullAccess: string;
    /** An access policy for providing a user/role/etc read only access to the AWS StepFunctions service. */
    static AWSStepFunctionsReadOnlyAccess: string;
    /** Provides full access to AWS Storage Gateway via the AWS Management Console. */
    static AWSStorageGatewayFullAccess: string;
    /** Provides access to AWS Storage Gateway via the AWS Management Console. */
    static AWSStorageGatewayReadOnlyAccess: string;
    /** Service-linked role used by AWS Storage Gateway to enable integration of other AWS services with Storage Gateway. */
    static AWSStorageGatewayServiceRolePolicy: string;
    /** AWSSupplyChainFederationAdminAccess provides AWS Supply Chain federated users access to the AWS Supply Chain application, including the required permissions to perform actions within the AWS Supply Chain application. The policy provides administrative permissions over IAM Identity Center users and groups and is attached to a role created by AWS Supply Chain on your behalf. You shouldn't attach AWSSupplyChainFederationAdminAccess policy to any other IAM entities. */
    static AWSSupplyChainFederationAdminAccess: string;
    /** Allows users to access the AWS Support Center. */
    static AWSSupportAccess: string;
    /** Provides full access to the AWS Support App and other required services, such as AWS Support and Service Quotas. This policy includes permissions to use the supporting services so that the user can contact AWS Support for support cases, change service quotas, and create the relevant service-linked roles. */
    static AWSSupportAppFullAccess: string;
    /** Provides read-only access to the AWS Support App. */
    static AWSSupportAppReadOnlyAccess: string;
    /** Provides full access to supportplans. */
    static AWSSupportPlansFullAccess: string;
    /** Provides read-only access to supportplans. */
    static AWSSupportPlansReadOnlyAccess: string;
    /** Allows AWS Support to access AWS resources to provide billing, administrative, and support services. */
    static AWSSupportServiceRolePolicy: string;
    /** Grants AWS Systems Manager (SSM) permission to discover AWS account information. */
    static AWSSystemsManagerAccountDiscoveryServicePolicy: string;
    /** Provides access to AWS resources managed or used by the AWS Systems Manager change management framework. */
    static AWSSystemsManagerChangeManagementServicePolicy: string;
    /** Provides permissions for AWS Systems Manager Quick Setup to enable and configure AWS Config configuration recording. */
    static AWSSystemsManagerEnableConfigRecordingExecutionPolicy: string;
    /** This policy grants administrative permissions for enabling Explorer, a capability of AWS Systems Manager. This includes permissions to update related Systems Manager service settings, and to create a service-linked role for Systems Manager. */
    static AWSSystemsManagerEnableExplorerExecutionPolicy: string;
    /** Provides full access to AWS Systems Manager for SAP service */
    static AWSSystemsManagerForSAPFullAccess: string;
    /** Provides read only access to AWS Systems Manager for SAP service */
    static AWSSystemsManagerForSAPReadOnlyAccess: string;
    /** Provides access to AWS resources managed or used by the AWS Systems Manager just in time access framework. */
    static AWSSystemsManagerJustInTimeAccessServicePolicy: string;
    /** The managed policy AWSSystemsManagerJustInTimeAccessTokenPolicy allows Systems Manager to generate access tokens used for just-in-time node access. */
    static AWSSystemsManagerJustInTimeAccessTokenPolicy: string;
    /** The managed policy AWSSystemsManagerJustInTimeAccessTokenSessionPolicy allows Systems Manager to apply scoped down permissions to a just-in-time node access session once it is started. */
    static AWSSystemsManagerJustInTimeAccessTokenSessionPolicy: string;
    /** This policy allows Systems Manager to share a deny-access policy for just-in-time node access from the delegated administrator account to member accounts, and replicate the policy to multiple Regions. */
    static AWSSystemsManagerJustInTimeNodeAccessRolePropagationPolicy: string;
    /** Permissions required to collect information about a user for Just-In-Time-Node-Access notifications. */
    static AWSSystemsManagerNotificationsServicePolicy: string;
    /** IAM role for SSM Explorer to manage OpsData related operations */
    static AWSSystemsManagerOpsDataSyncServiceRolePolicy: string;
    /** This policy grants the AWS Portal Asset Server the necessary permissions required for normal operation. */
    static AWSThinkboxAssetServerPolicy: string;
    /** This policy grants AWS Thinkbox's Deadline software full access to multiple AWS services as required for AWS Portal administration. This includes access to create arbitrary tags on several EC2 resource types. */
    static AWSThinkboxAWSPortalAdminPolicy: string;
    /** This policy grants the AWS Portal Gateway machine the necessary permissions required for normal operation. */
    static AWSThinkboxAWSPortalGatewayPolicy: string;
    /** This policy grants the Deadline Workers in AWS Portal the necessary permissions required for normal operation. */
    static AWSThinkboxAWSPortalWorkerPolicy: string;
    /** Grants permissions required for the operation of AWS Thinkbox's Deadline Resource Tracker.  This includes full access to some EC2 actions, including DeleteFleets and CancelSpotFleetRequests. */
    static AWSThinkboxDeadlineResourceTrackerAccessPolicy: string;
    /** Grants permissions required to create, destroy, and administer AWS Thinkbox's Deadline Resource Tracker. */
    static AWSThinkboxDeadlineResourceTrackerAdminPolicy: string;
    /** Grants permissions required for AWS Thinkbox's Deadline Spot Event Plugin.  This includes permission to request, modify, and cancel a spot fleet, as well as limited PassRole permission. */
    static AWSThinkboxDeadlineSpotEventPluginAdminPolicy: string;
    /** Grant permissions required for an EC2 instance running AWS Thinkbox Deadline Spot Event Plugin Worker software. */
    static AWSThinkboxDeadlineSpotEventPluginWorkerPolicy: string;
    /** Provides full access to AWS Transfer via the AWS Management Console */
    static AWSTransferConsoleFullAccess: string;
    /** Provides full access to AWS Transfer Service. */
    static AWSTransferFullAccess: string;
    /** Allows AWS Transfer full access to create log streams and groups and put log events to your account */
    static AWSTransferLoggingAccess: string;
    /** Provide readonly access to AWS Transfer services. */
    static AWSTransferReadOnlyAccess: string;
    /** Enables the AWS Transform service to deploy transformed .NET applications by creating and managing AWS resources. This policy grants permissions to provision infrastructure, manage compute resources, and configure deployment settings across various AWS services. */
    static AWSTransformApplicationDeploymentPolicy: string;
    /** Provides full access to AWS Trusted Advisor Priority. This policy also enables the user to add Trusted Advisor as a trusted service with AWS Organizations and to specify delegated administrator accounts for Trusted Advisor Priority. */
    static AWSTrustedAdvisorPriorityFullAccess: string;
    /** Provides read-only access to AWS Trusted Advisor Priority. This includes permission to view the delegated administrator accounts. */
    static AWSTrustedAdvisorPriorityReadOnlyAccess: string;
    /** Service Policy for Trusted Advisor Multi-account Reporting */
    static AWSTrustedAdvisorReportingServiceRolePolicy: string;
    /** Access for the AWS Trusted Advisor Service to help reduce cost, increase performance, and improve security of your AWS environment. */
    static AWSTrustedAdvisorServiceRolePolicy: string;
    /** Allows AWS User Notifications to call AWS services on your behalf. */
    static AWSUserNotificationsServiceLinkedRolePolicy: string;
    /** Provides full access for viewing entitled Vendor Insights resources and managing Vendor Insights subscriptions */
    static AWSVendorInsightsAssessorFullAccess: string;
    /** Provides read-only access for viewing entitled Vendor Insights resources */
    static AWSVendorInsightsAssessorReadOnly: string;
    /** Provides full access for creating and managing the Vendor Insights resources */
    static AWSVendorInsightsVendorFullAccess: string;
    /** Provides read-only access for viewing the Vendor Insights resources */
    static AWSVendorInsightsVendorReadOnly: string;
    /** Allows VPC Lattice to access AWS resources on your behalf. */
    static AWSVpcLatticeServiceRolePolicy: string;
    /** Allow Site-to-Site VPN to create and manage resources related to your VPN Connections. */
    static AWSVPCS2SVpnServiceRolePolicy: string;
    /** Allow VPC Transit Gateway to create and manage necessary resources for your Transit Gateway VPC Attachments. */
    static AWSVPCTransitGatewayServiceRolePolicy: string;
    /** Policy to enable AWS Verified Access service to provision endpoints on your behalf */
    static AWSVPCVerifiedAccessServiceRolePolicy: string;
    /** Provides full access to AWS WAF via the AWS Management Console. Note that this policy also grants permissions to list and update Amazon CloudFront distributions, permissions to view load balancers on AWS Elastic Load Balancing, permissions to view Amazon API Gateway REST APIs and stages, permissions to list and view Amazon CloudWatch metrics, and permissions to view regions enabled within the account. */
    static AWSWAFConsoleFullAccess: string;
    /** Provides read-only access to AWS WAF via the AWS Management Console. Note that this policy also grants permissions to list Amazon CloudFront distributions, permissions to view load balancers on AWS Elastic Load Balancing, permissions to view Amazon API Gateway REST APIs and stages, permissions to list and view Amazon CloudWatch metrics, and permissions to view regions enabled within the account. */
    static AWSWAFConsoleReadOnlyAccess: string;
    /** Provides full access to AWS WAF actions. */
    static AWSWAFFullAccess: string;
    /** Provides read only access to AWS WAF actions. */
    static AWSWAFReadOnlyAccess: string;
    /** Allows WellArchitected to access AWS services and resources that relate to WellArchitected resources on behalf of customers. */
    static AWSWellArchitectedDiscoveryServiceRolePolicy: string;
    /** Allows Well-Architected to access Organizations on your behalf. */
    static AWSWellArchitectedOrganizationsServiceRolePolicy: string;
    /** This policy grants full administrative permissions to the Wickr service, including the Wickr administrative functions under the AWS Management Console. */
    static AWSWickrFullAccess: string;
    /** Provides capabilities to manage Observability Access Manager links and establish sharing of X-Ray traces */
    static AWSXrayCrossAccountSharingConfiguration: string;
    /** Allow the AWS X-Ray Daemon to relay raw trace segments data to the service's API and retrieve sampling data (rules, targets, etc.) to be used by the X-Ray SDK. */
    static AWSXRayDaemonWriteAccess: string;
    /** AWS X-Ray full access managed policy */
    static AWSXrayFullAccess: string;
    /** AWS X-Ray read only managed policy */
    static AWSXrayReadOnlyAccess: string;
    /** AWS X-Ray write only managed policy */
    static AWSXrayWriteOnlyAccess: string;
    /** Provides administrative access for ARC zonal shift practice runs, and access to CloudWatch alarm statuses to monitor practice runs. */
    static AWSZonalAutoshiftPracticeRunSLRPolicy: string;
    /** Provides read-only access to the APIs needed to support zone-group access-management for organizations. */
    static AWSZoneGroupAccessManagementServiceRolePolicy: string;
    /** Provides access for the AWS Batch service to manage the required resources, including Amazon EC2 and Amazon ECS resources. */
    static BatchServiceRolePolicy: string;
    /** Provides full access to Bedrock AgentCore as well as limited access to related services */
    static BedrockAgentCoreFullAccess: string;
    /** Grants permissions for billing and cost management. This includes viewing account usage and viewing and modifying budgets and payment methods. */
    static Billing: string;
    /** Allows Budgets to verify access to Billing Views shared across account boundaries. */
    static BudgetsServiceRolePolicy: string;
    /** Amazon Certificate Manager Service Role Policy */
    static CertificateManagerServiceRolePolicy: string;
    /** Policy to enable AWS Client VPN to manage your Client VPN endpoint connections. */
    static ClientVPNServiceConnectionsRolePolicy: string;
    /** Policy to enable AWS Client VPN to manage your Client VPN endpoints. */
    static ClientVPNServiceRolePolicy: string;
    /** Service Role for CloudFormation StackSets (Organization Master Account) */
    static CloudFormationStackSetsOrgAdminServiceRolePolicy: string;
    /** Service Role for CloudFormation StackSets (Organization Member Account) */
    static CloudFormationStackSetsOrgMemberServiceRolePolicy: string;
    /** Provides full access to the CloudFront console plus the ability to list Amazon S3 buckets via the AWS Management Console. */
    static CloudFrontFullAccess: string;
    /** Provides access to CloudFront distribution configuration information and list distributions via the AWS Management Console. */
    static CloudFrontReadOnlyAccess: string;
    /** Enables access to AWS resources used or managed by CloudHSM */
    static CloudHSMServiceRolePolicy: string;
    /** Provides full access to the Amazon CloudSearch configuration service. */
    static CloudSearchFullAccess: string;
    /** Provides read only access to the Amazon CloudSearch configuration service. */
    static CloudSearchReadOnlyAccess: string;
    /** This service linked role allows CloudTrail to get and add resource tags to the resource owner's CloudTrail events. */
    static CloudTrailEventContext: string;
    /** Permission policy for CloudTrail ServiceLinkedRole */
    static CloudTrailServiceRolePolicy: string;
    /** Allows CloudWatch to assume CloudWatch-CrossAccountSharing roles in remote accounts on behalf of the current account in order to display data cross-account, cross-region */
    static CloudWatchCrossAccountAccess: string;
    /** Provides read-only access to CloudWatch alarms and metrics as well as EC2 metadata. Provides access to Stop, Terminate and Reboot EC2 instances. */
    static CloudWatchActionsEC2Access: string;
    /** Full permissions required to use AmazonCloudWatchAgent. */
    static CloudWatchAgentAdminPolicy: string;
    /** Permissions required to use AmazonCloudWatchAgent on servers */
    static CloudWatchAgentServerPolicy: string;
    /** Provides full access to CloudWatch Application Insights and required dependencies. */
    static CloudWatchApplicationInsightsFullAccess: string;
    /** Provides read only access to CloudWatch Application Insights. */
    static CloudWatchApplicationInsightsReadOnlyAccess: string;
    /** Cloudwatch Application Insights Service Linked Role Policy */
    static CloudwatchApplicationInsightsServiceLinkedRolePolicy: string;
    /** Provide full access to CloudWatch Application Signals service and scoped access to the dependencies needed to use and operate this service. */
    static CloudWatchApplicationSignalsFullAccess: string;
    /** Provides read only access to CloudWatch Application Signals service and scoped access to the dependencies needed to use this service */
    static CloudWatchApplicationSignalsReadOnlyAccess: string;
    /** Policy grants permission to CloudWatch Application Signals to collect monitoring and tagging data from other relevant AWS services. */
    static CloudWatchApplicationSignalsServiceRolePolicy: string;
    /** Provides access to the non-CloudWatch APIs used to display CloudWatch Automatic Dashboards, including the contents of objects such as Lambda functions */
    static CloudWatchAutomaticDashboardsAccess: string;
    /** Provides capabilities to manage Observability Access Manager links and establish sharing of CloudWatch resources */
    static CloudWatchCrossAccountSharingConfiguration: string;
    /** Allows built-in targets in Amazon CloudWatch Events to perform EC2 actions on your behalf. */
    static CloudWatchEventsBuiltInTargetExecutionAccess: string;
    /** Provides full access to Amazon CloudWatch Events. */
    static CloudWatchEventsFullAccess: string;
    /** Allows Amazon CloudWatch Events to relay events to the streams in AWS Kinesis Streams in your account. */
    static CloudWatchEventsInvocationAccess: string;
    /** Provides read only access to Amazon CloudWatch Events. */
    static CloudWatchEventsReadOnlyAccess: string;
    /** Allow AWS CloudWatch to execute actions on your behalf configured through alarms and events. */
    static CloudWatchEventsServiceRolePolicy: string;
    /** Provides full access to CloudWatch. */
    static CloudWatchFullAccess: string;
    /** Provides full access to CloudWatch. */
    static CloudWatchFullAccessV2: string;
    /** Provides full access to actions for working with Amazon CloudWatch Internet Monitor. Also provides access to other services, such as Amazon CloudWatch, Amazon EC2, Amazon CloudFront, Amazon WorkSpaces, and Elastic Load Balancing, that are necessary to use the Internet Monitor service for monitoring and storing information about application traffic. */
    static CloudWatchInternetMonitorFullAccess: string;
    /** Provides read only access to actions for working with Amazon CloudWatch Internet Monitor. Also provides access to other services in Amazon CloudWatch, including policies to retrieve information on CloudWatch metrics and to manage log queries, that are necessary to use the Internet Monitor service for monitoring and storing information about application traffic. */
    static CloudWatchInternetMonitorReadOnlyAccess: string;
    /** Allows Internet Monitor to access EC2, Workspaces, and CloudFront resources, and other required services on your behalf. */
    static CloudWatchInternetMonitorServiceRolePolicy: string;
    /** Provides write access to X-Ray and CloudWatch Application Signals log group. */
    static CloudWatchLambdaApplicationSignalsExecutionRolePolicy: string;
    /** Policy required for the Lambda Insights Extension */
    static CloudWatchLambdaInsightsExecutionRolePolicy: string;
    /** Provides capabilities to manage Observability Access Manager links and establish sharing of CloudWatch Logs resources */
    static CloudWatchLogsCrossAccountSharingConfiguration: string;
    /** Provides full access to CloudWatch Logs */
    static CloudWatchLogsFullAccess: string;
    /** Provides read only access to CloudWatch Logs */
    static CloudWatchLogsReadOnlyAccess: string;
    /** You can use this policy in IAM roles that are attached to Amazon EC2 and Amazon EKS instance resources to send telemetry reports (metrics) to a Network Flow Monitor endpoint. */
    static CloudWatchNetworkFlowMonitorAgentPublishPolicy: string;
    /** You can't attach CloudWatchNetworkFlowMonitorServiceRolePolicy to your IAM entities. This policy is attached to a service-linked role named AWSServiceRoleForNetworkFlowMonitor, which publishes network telemetry aggregation results, collected by Network Flow Monitor agents, to CloudWatch. It also allows the service to use AWS Organizations to get information for multi-account scenarios. */
    static CloudWatchNetworkFlowMonitorServiceRolePolicy: string;
    /** You can't attach CloudWatchNetworkFlowMonitorTopologyServiceRolePolicy to your IAM entities. This policy is attached to a service-linked role named AWSServiceRoleForNetworkFlowMonitor_Topology, which generates topology snapshots of resources used by Network Flow Monitor in your account. */
    static CloudWatchNetworkFlowMonitorTopologyServiceRolePolicy: string;
    /** Allows CloudWatch Network Monitor to access and manage EC2 and VPC resources, publish data to CloudWatch and access other required services on your behalf. */
    static CloudWatchNetworkMonitorServiceRolePolicy: string;
    /** This policy provides user access to view OpenSearch dashboards on the CloudWatch Logs console. */
    static CloudWatchOpenSearchDashboardAccess: string;
    /** This policy provides user access to create integration with OpenSearch to create, update, delete or view dashboards on the CloudWatch Logs console. */
    static CloudWatchOpenSearchDashboardsFullAccess: string;
    /** Provides read only access to CloudWatch. */
    static CloudWatchReadOnlyAccess: string;
    /** Provides full access to CloudWatch Synthetics. */
    static CloudWatchSyntheticsFullAccess: string;
    /** Provides read only access to CloudWatch Synthetics. */
    static CloudWatchSyntheticsReadOnlyAccess: string;
    /** Policy for AWS Comprehend service role which allows access to S3 resources for data access */
    static ComprehendDataAccessRolePolicy: string;
    /** Provides full access to Amazon Comprehend. */
    static ComprehendFullAccess: string;
    /** Provides full access to Amazon Comprehend Medical */
    static ComprehendMedicalFullAccess: string;
    /** Provides read-only access to Amazon Comprehend. */
    static ComprehendReadOnly: string;
    /** Provides read only access to ComputeOptimizer. */
    static ComputeOptimizerReadOnlyAccess: string;
    /** Allows ComputeOptimizer to call AWS services and collect workload details on your behalf. */
    static ComputeOptimizerServiceRolePolicy: string;
    /** Policy needed for AWSConfig to create conformance packs */
    static ConfigConformsServiceRolePolicy: string;
    /** This managed policy provides admin access to Cost Optimization Hub. */
    static CostOptimizationHubAdminAccess: string;
    /** This managed policy provides read-only access to Cost Optimization Hub. */
    static CostOptimizationHubReadOnlyAccess: string;
    /** Allows Cost Optimization Hub to retrieve organization information and collect optimization-related data and metadata. */
    static CostOptimizationHubServiceRolePolicy: string;
    /** Allows Amazon Connect Customer Profiles to access AWS services and resources on your behalf. */
    static CustomerProfilesServiceLinkedRolePolicy: string;
    /** Grants full access permissions to AWS services and actions required to set up and configure AWS database services. */
    static DatabaseAdministrator: string;
    /** Grants permissions to AWS data analytics services. */
    static DataScientist: string;
    /** This policy allows DAX to create and manage Network interface, Security group, Subnet and Vpc on behalf of customer */
    static DAXServiceRolePolicy: string;
    /** Provides access to read-only APIs needed to run EC2 Declarative Policies Account Status Report. */
    static DeclarativePoliciesEC2Report: string;
    /** Permissions required to support Amazon CloudWatch Contributor Insights for Amazon DynamoDB. */
    static DynamoDBCloudWatchContributorInsightsServiceRolePolicy: string;
    /** Provide AWS DynamoDB access to KinesisDataStreams */
    static DynamoDBKinesisReplicationServiceRolePolicy: string;
    /** Permissions required by DynamoDB for cross-region data replication */
    static DynamoDBReplicationServiceRolePolicy: string;
    /** This policy grants full access to EC2 Fast Launch actions */
    static EC2FastLaunchFullAccess: string;
    /** Policy grants ec2fastlaunch to prepare and manage preprovisioned snapshots in customer's account & publish related metrics. */
    static EC2FastLaunchServiceRolePolicy: string;
    /** Policy granting permissions to EC2 Fleet to launch instances in the future. */
    static EC2FleetTimeShiftableServiceRolePolicy: string;
    /** Permissions need by EC2 Image Builder to perform a cross account distribution. */
    static Ec2ImageBuilderCrossAccountDistributionAccess: string;
    /** The EC2ImageBuilderLifecycleExecutionPolicy policy grants permissions for Image Builder to perform actions such as deprecate or delete Image Builder image resources and their underlying resources (AMIs, snapshots) to support automated rules for image lifecycle management tasks. */
    static EC2ImageBuilderLifecycleExecutionPolicy: string;
    /** Allows customers to call EC2 Instance Connect to publish ephemeral keys to their EC2 instances and connect via ssh or the EC2 Instance Connect CLI. */
    static EC2InstanceConnect: string;
    /** EC2 Instance Connect endpoint policy to manage EC2 Instance Connect endpoints created by the customer */
    static Ec2InstanceConnectEndpoint: string;
    /** EC2 Instance profile for Image Builder service. */
    static EC2InstanceProfileForImageBuilder: string;
    /** EC2 Instance profile for building container images with EC2 Image Builder. This policy grants the user broad permissions to upload ECR images. */
    static EC2InstanceProfileForImageBuilderECRContainerBuilds: string;
    /** Enables access to AWS Services and Resources used or managed by ECR Replication */
    static ECRReplicationServiceRolePolicy: string;
    /** Allows actions to be performed when using AWS ECR repository creation templates */
    static ECRTemplateServiceRolePolicy: string;
    /** This policy allows ElastiCache to manage AWS resources on your behalf as necessary for managing your cache */
    static ElastiCacheServiceRolePolicy: string;
    /** Provides full access to Amazon ElasticLoadBalancing, and limited access to other services necessary to provide ElasticLoadBalancing features. */
    static ElasticLoadBalancingFullAccess: string;
    /** Provides read only access to Amazon ElasticLoadBalancing and dependent services */
    static ElasticLoadBalancingReadOnly: string;
    /** Access to view purchased assets and download related software and kickstart files */
    static ElementalActivationsDownloadSoftwareAccess: string;
    /** Full access to view and take action on Elemental Appliances and Software purchased assets */
    static ElementalActivationsFullAccess: string;
    /** Access to view purchased assets and generate software licenses for pending activations */
    static ElementalActivationsGenerateLicenses: string;
    /** Read-only access to the detailed list of purchased assets associated to the AWS account of the user */
    static ElementalActivationsReadOnlyAccess: string;
    /** Full access to view and take action on Elemental Appliances and Software quotes and orders */
    static ElementalAppliancesSoftwareFullAccess: string;
    /** Read-only access to view Elemental Appliances and Software quotes and orders */
    static ElementalAppliancesSoftwareReadOnlyAccess: string;
    /** Full access to view and take action on Elemental Appliance and Software support cases and product support content */
    static ElementalSupportCenterFullAccess: string;
    /** This policy grants read-only permissions that allow the WAL service for Amazon EMR to find and return the status of a cluster */
    static EMRDescribeClusterPolicyForEMRWAL: string;
    /** Access policy to allow FM service linked role to perform FM-related actions on FM-managed resources within a customer AWS Organization account. */
    static FMSServiceRolePolicy: string;
    /** Allows Amazon FSx to delete its Service Linked Roles for Amazon S3 access */
    static FSxDeleteServiceLinkedRoleAccess: string;
    /** Grants the required permissions for compute actions in an Amazon GameLift container fleet, including access to dependencies such as Amazon S3. */
    static GameLiftContainerFleetPolicy: string;
    /** Policy to allow Gamelift GameServerGroups to manage customer resources */
    static GameLiftGameServerGroupPolicy: string;
    /** This managed policy grants permission to connect with Amazon Q and utilize the features in the GitLab Duo with Amazon Q integration. */
    static GitLabDuoWithAmazonQPermissionsPolicy: string;
    /** Allow GlobalAccelerator Users full Access to all APIs */
    static GlobalAcceleratorFullAccess: string;
    /** Allow GlobalAccelerator Users Access to Read Only APIs */
    static GlobalAcceleratorReadOnlyAccess: string;
    /** Provides read access to the Greengrass OTA Update artifacts in all Greengrass regions */
    static GreengrassOTAUpdateArtifactAccess: string;
    /** AWS Health policy to enable Organizational View feature */
    static HealthOrganizationsServiceRolePolicy: string;
    /** This policy grants access to read all access information provided by IAM access advisor such as service last accessed information. */
    static IAMAccessAdvisorReadOnly: string;
    /** Provides full access to IAM Access Analyzer */
    static IAMAccessAnalyzerFullAccess: string;
    /** Provides read only access to IAM Access Analyzer resources */
    static IAMAccessAnalyzerReadOnlyAccess: string;
    /** Provides access required to check the presence of root user credentials such as root user password and root user access keys using the Security Token Service (STS) AssumeRoot API. Use this managed policy only with the STS AssumeRoot action. */
    static IAMAuditRootUserCredentials: string;
    /** Provides access required to create a root user password using the Security Token Service (STS) AssumeRoot API.  Use this managed policy only with the STS AssumeRoot action. */
    static IAMCreateRootUserPassword: string;
    /** Provides access required to delete all root user credentials such as root password and root access keys using the Security Token Service (STS) AssumeRoot API.  Use this managed policy only with the STS AssumeRoot action. */
    static IAMDeleteRootUserCredentials: string;
    /** Provides full access to IAM via the AWS Management Console. */
    static IAMFullAccess: string;
    /** Provides read only access to IAM via the AWS Management Console. */
    static IAMReadOnlyAccess: string;
    /** Allows an IAM user to manage their own Service Specific Credentials. */
    static IAMSelfManageServiceSpecificCredentials: string;
    /** Provides the ability for an IAM user to change their own password. */
    static IAMUserChangePassword: string;
    /** Provides the ability for an IAM user to manage their own SSH keys. */
    static IAMUserSSHKeys: string;
    /** Provides full access to Interactive Video Service (IVS), Also included permissions for dependent services, needed for full access to the ivs console. */
    static IVSFullAccess: string;
    /** Provides read-only access to IVS Low-Latency and Real-Time streaming APIs */
    static IVSReadOnlyAccess: string;
    /** Service Linked Role to perform S3 PutObject to recording IVS live streams */
    static IVSRecordToS3: string;
    /** This policy grants Kafka Connect permission to manage AWS resources on your behalf. */
    static KafkaConnectServiceRolePolicy: string;
    /** IAM service linked role policy for Kafka. */
    static KafkaServiceRolePolicy: string;
    /** Grants the required permissions to Amazon Keyspaces for Change Data Capture */
    static KeyspacesCDCServiceRolePolicy: string;
    /** Permissions required by Keyspaces for cross-region data replication */
    static KeyspacesReplicationServiceRolePolicy: string;
    /** Policy to grant temporary data access to Lake Formation resources */
    static LakeFormationDataAccessServiceRolePolicy: string;
    /** Policy for AWS Lex Bot use case */
    static LexBotPolicy: string;
    /** Policy for AWS Lex Channel use case */
    static LexChannelPolicy: string;
    /** AWS Lightsail service linked role policy which grants permissions to export resources */
    static LightsailExportAccess: string;
    /** This policy grants permission to register MediaConnect Gateway Instances to a MediaConnect Gateway. */
    static MediaConnectGatewayInstanceRolePolicy: string;
    /** Allows MediaPackage to publish logs to CloudWatch */
    static MediaPackageServiceRolePolicy: string;
    /** This policy allows MemoryDB to manage AWS resources on your behalf as necessary for managing your resources. */
    static MemoryDBServiceRolePolicy: string;
    /** Policy for Database Migration Service to assume role in customer's account to call Migration Hub */
    static MigrationHubDMSAccessServiceRolePolicy: string;
    /** Allows Migration Hub to call Application Discovery Service on your behalf */
    static MigrationHubServiceRolePolicy: string;
    /** Policy for Server Migration Service to assume role in customer's account to call Migration Hub */
    static MigrationHubSMSAccessServiceRolePolicy: string;
    /** Policy for AWS Monitron service linked role granting access to required customer resources. */
    static MonitronServiceRolePolicy: string;
    /** Provides full access to Multi-party approval. This policy also includes related permissions to AWS Organizations and AWS IAM Identity for managing approval teams and identity sources. */
    static MultiPartyApprovalFullAccess: string;
    /** Provides read-only access to Multi-party approval. This policy also includes related read permission to AWS Organizations and AWS IAM Identity for approval teams and identity sources. */
    static MultiPartyApprovalReadOnlyAccess: string;
    /** Provides full access to manage Amazon Neptune using the AWS Console. Note this policy also grants full access to publish on all SNS topics within the account, permissions to create and edit Amazon EC2 instances and VPC configurations, permissions to view and list keys on Amazon KMS, and full access to Amazon RDS. For more information, see https://aws.amazon.com/neptune/faqs/. */
    static NeptuneConsoleFullAccess: string;
    /** Provides full access to Amazon Neptune. Note this policy also grants full access to publish on all SNS topics within the account and full access to Amazon RDS. For more information, see https://aws.amazon.com/neptune/faqs/. */
    static NeptuneFullAccess: string;
    /** Provides read only access to all Amazon Neptune Analytics resources along with read only permissions for dependent services. */
    static NeptuneGraphReadOnlyAccess: string;
    /** Provides read only access to Amazon Neptune. Note that this policy also grants access to Amazon RDS resources. For more information, see https://aws.amazon.com/neptune/faqs/. */
    static NeptuneReadOnlyAccess: string;
    /** Grants full access permissions to AWS services and actions required to set up and configure AWS network resources. */
    static NetworkAdministrator: string;
    /** Provides permissions for the AWS Shield network security director service linked role to assess specified environments. */
    static NetworkSecurityDirectorServiceLinkedRolePolicy: string;
    /** Provides full access to CloudWatch Observability Access Manager */
    static OAMFullAccess: string;
    /** Provides Read Only access to CloudWatch Observability Access Manager */
    static OAMReadOnlyAccess: string;
    /** Allows Amazon OpenSearch Ingestion to describe network resources and write service metrics to cloudwatch */
    static OpensearchIngestionSelfManagedVpcePolicy: string;
    /** Provides access to associate and dissociate partner central users with IAM roles */
    static PartnerCentralAccountManagementUserRoleAssociation: string;
    /** Provides full access to AWS services and resources, but does not allow management of Users and groups. */
    static PowerUserAccess: string;
    /** Grants permissions to AWS Services and Resources used or managed by Amazon Q Apps. */
    static QAppsServiceRolePolicy: string;
    /** Grants permissions to QBusiness to call QuickSight APIs for the QuickSight plugin */
    static QBusinessQuicksightPluginPolicy: string;
    /** Grants permissions to AWS Services and Resources used or managed by Amazon Q */
    static QBusinessServiceRolePolicy: string;
    /** Policy used by QuickSight team to access customer data produced by S3 Storage Management Analytics. */
    static QuickSightAccessForS3StorageManagementAnalyticsReadOnly: string;
    /** Default policy for the Amazon RDS service role. */
    static RDSCloudHsmAuthorizationRole: string;
    /** Provides read-only access to AWS services and resources. */
    static ReadOnlyAccess: string;
    /** Provides full access to Resource Groups and Tag Editor. */
    static ResourceGroupsandTagEditorFullAccess: string;
    /** Provides access to use Resource Groups and Tag Editor, but does not allow editing of tags via the Tag Editor. */
    static ResourceGroupsandTagEditorReadOnlyAccess: string;
    /** Allows AWS Resource Groups to query the AWS services that own your resources to keep the group up-to-date */
    static ResourceGroupsServiceRolePolicy: string;
    /** Provides permissions to tag and untag all the resources supported by Resource Groups Tagging API. This policy also grants the permissions required to retrieve all tagged, or previously tagged, resources through the Resource Groups Tagging API. */
    static ResourceGroupsTaggingAPITagUntagSupportedResources: string;
    /** Allows the OpenShift Amazon EBS Container Storage Interface (CSI) Driver Operator to install and maintain the Amazon EBS CSI driver on a Red Hat OpenShift Service on AWS (ROSA) cluster. The Amazon EBS CSI driver allows ROSA clusters to manage the lifecycle of Amazon EBS volumes for persistent volumes. */
    static ROSAAmazonEBSCSIDriverOperatorPolicy: string;
    /** Allows the OpenShift Cloud Network Config Controller Operator to provision and manage networking resources for use by the Red Hat OpenShift Service on AWS (ROSA) cluster networking overlay. The OpenShift Cloud Network Operator interfaces with AWS APIs on behalf of the network plugins via CustomResourceDefinitions. The operator uses these policy permissions to manage private IP addresses for Amazon EC2 instances as part of the ROSA cluster. */
    static ROSACloudNetworkConfigOperatorPolicy: string;
    /** Allows Red Hat OpenShift Service on AWS (ROSA) control plane to manage ROSA cluster Amazon EC2 and Amazon Route 53 resources. */
    static ROSAControlPlaneOperatorPolicy: string;
    /** Allows the OpenShift Image Registry Operator to provision and manage Amazon S3 buckets and objects for use by the Red Hat OpenShift Service on AWS (ROSA) in-cluster image registry to satisfy ROSA storage requirements. The OpenShift Image Registry Operator installs and maintains the internal registry of a Red Hat OpenShift cluster. */
    static ROSAImageRegistryOperatorPolicy: string;
    /** Allows the OpenShift Ingress Operator to provision and manage load balancers and domain name system (DNS) configurations for Red Hat OpenShift Service on AWS (ROSA) clusters. The policy allows read access to tag values, which the operator filters for Route 53 resources to discover hosted zones. */
    static ROSAIngressOperatorPolicy: string;
    /** Allows the Red Hat OpenShift Service on AWS (ROSA) installer to manage AWS resources that support ROSA cluster installation. This includes managing instance profiles for ROSA worker nodes. */
    static ROSAInstallerPolicy: string;
    /** Allows the built-in ROSA AWS Encryption Provider to manage AWS Key Management Service (KMS) keys to support etcd data encryption using a customer provided AWS KMS key. The policy allows encryption and decryption of data using KMS keys. */
    static ROSAKMSProviderPolicy: string;
    /** Allows the ROSA Kubernetes controller to manage Amazon EC2, Elastic Load Balancing (ELB), and AWS Key Management Service (KMS) resources for a ROSA cluster. */
    static ROSAKubeControllerPolicy: string;
    /** This policy provides the permissions required to manage the Red Hat OpenShift Service on AWS (ROSA) subscription. */
    static ROSAManageSubscription: string;
    /** Allows Red Hat OpenShift Service on AWS (ROSA) to manage cluster EC2 instances as worker nodes, including permission to configure security groups and tag instances and volumes. This policy also allows for the use of EC2 instances with disk encryption provided by AWS Key Management Service (KMS) keys. */
    static ROSANodePoolManagementPolicy: string;
    /** Allows the Red Hat OpenShift Service on AWS (ROSA) installer to configure VPC Endpoints and Security Groups. Intended to be used on a shared VPC. */
    static ROSASharedVPCEndpointPolicy: string;
    /** Allows the Red Hat OpenShift Service on AWS (ROSA) installer to configure Route53 records. Intended to be used on a shared VPC. */
    static ROSASharedVPCRoute53Policy: string;
    /** Provides ROSA site reliability engineering (SRE) the permissions needed to initially observe, diagnose, and support AWS resources associated with Red Hat OpenShift Service on AWS (ROSA) clusters, including the ability to change ROSA cluster node state. */
    static ROSASRESupportPolicy: string;
    /** Allows Red Hat OpenShift Service on AWS (ROSA) worker nodes in your account read-only access to Amazon EC2 instances and AWS Regions for compute node lifecycle management. */
    static ROSAWorkerInstancePolicy: string;
    /** Service Linked Role Policy for Route 53 Recovery Readiness */
    static Route53RecoveryReadinessServiceRolePolicy: string;
    /** Enables access to AWS Services and Resources used or managed by Route53 Resolver */
    static Route53ResolverServiceRolePolicy: string;
    /** Enables access to AWS Services and Resources used or managed by S3 Storage Lens */
    static S3StorageLensServiceRolePolicy: string;
    /** Provides access required to unlock a S3 bucket policy using the Security Token Service (STS) AssumeRoot API. Use this managed policy only with the STS AssumeRoot action. */
    static S3UnlockBucketPolicy: string;
    /** Provides initial administrative and individual setup privileges for Amazon SageMaker Unified Studio via the AWS Management Console and SDK. Allows launching of SageMaker Unified Studio Portal. */
    static SageMakerStudioAdminIAMConsolePolicy: string;
    /** Administrative execution policy for using IAM roles with SageMaker Unified Studio. Allows admins to provision, manage and access resources in your account (excluding access to data resources) for IAM-based usage of SageMaker Unified Studio. */
    static SageMakerStudioAdminIAMDefaultExecutionPolicy: string;
    /** Administrative execution policy for using IAM roles with SageMaker Unified Studio. Allows admins to provision, manage and access resources in the local account (including broad access to all APIs in data services like S3, Glue, CloudWatch Logs, and others) for IAM-based usage of SageMaker Unified Studio. */
    static SageMakerStudioAdminIAMPermissiveExecutionPolicy: string;
    /** This IAM policy grants an IAM role full access to AWS Glue Data Catalog (metadata) and Amazon S3 (actual data) for data lake operations, with access scoped by account, and role tags. */
    static SageMakerStudioAdminProjectUserRolePolicy: string;
    /** Allows Amazon Bedrock Agents to access Amazon Bedrock models and other resources attached to an agent in SageMaker Studio. */
    static SageMakerStudioBedrockAgentServiceRolePolicy: string;
    /** Provides access to an Amazon Bedrock chat agent app's configuration and Amazon Bedrock agent in SageMaker Studio. */
    static SageMakerStudioBedrockChatAgentUserRolePolicy: string;
    /** Allows Amazon Bedrock to access Amazon Bedrock models and datasets for evaluation jobs in SageMaker Studio. */
    static SageMakerStudioBedrockEvaluationJobServiceRolePolicy: string;
    /** Allows Amazon Bedrock Flows to access Amazon Bedrock models and other resources attached to a flow in SageMaker Studio. */
    static SageMakerStudioBedrockFlowServiceRolePolicy: string;
    /** Allows AWS Lambda to access an Amazon Bedrock function component's configuration in SageMaker Studio. */
    static SageMakerStudioBedrockFunctionExecutionRolePolicy: string;
    /** Provides access to configure vector stores and Amazon Bedrock knowledge bases in SageMaker Studio. */
    static SageMakerStudioBedrockKnowledgeBaseCustomResourcePolicy: string;
    /** Allows Amazon Bedrock Knowledge Bases to access Amazon Bedrock models and data sources in SageMaker Studio. */
    static SageMakerStudioBedrockKnowledgeBaseServiceRolePolicy: string;
    /** Provides access to an Amazon Bedrock prompt and its configuration in SageMaker Studio. */
    static SageMakerStudioBedrockPromptUserRolePolicy: string;
    /** This policy is used by Amazon SageMaker Studio to catalog, discover, govern, share, and analyze data in the Amazon SageMaker Studio domain. */
    static SageMakerStudioDomainExecutionRolePolicy: string;
    /** Service role for domain level actions in the portal that are performed by Amazon SageMaker Studio. */
    static SageMakerStudioDomainServiceRolePolicy: string;
    /** Amazon SageMaker Studio creates IAM roles for projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the permissions related to EMR. */
    static SageMakerStudioEMRInstanceRolePolicy: string;
    /** Amazon SageMaker Studio creates IAM roles for projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the permissions related to EMR. */
    static SageMakerStudioEMRServiceRolePolicy: string;
    /** This policy provides full access to Amazon SageMaker Unified Studio via the Amazon SageMaker management console. */
    static SageMakerStudioFullAccess: string;
    /** Amazon SageMaker Studio uses this policy to provision and manage resources in your account. */
    static SageMakerStudioProjectProvisioningRolePolicy: string;
    /** Amazon SageMaker Studio creates IAM roles for projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the permissions related to SageMaker. */
    static SageMakerStudioProjectRoleMachineLearningPolicy: string;
    /** Amazon SageMaker creates IAM roles for Projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the boundary of their permissions. */
    static SageMakerStudioProjectUserRolePermissionsBoundary: string;
    /** Amazon SageMaker Studio creates IAM roles for projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the permissions. */
    static SageMakerStudioProjectUserRolePolicy: string;
    /** Amazon SageMaker Studio uses this policy when running query executions on federated connections. */
    static SageMakerStudioQueryExecutionRolePolicy: string;
    /** Provides individual setup privileges for Amazon SageMaker Unified Studio via the AWS Management Console and SDK. Allows launching of SageMaker Unified Studio Portal. */
    static SageMakerStudioUserIAMConsolePolicy: string;
    /** Execution policy for using IAM roles with SageMaker Unified Studio. Allows users to access resources in the local account (excluding access to data resources) for IAM-based usage of SageMaker Unified Studio. */
    static SageMakerStudioUserIAMDefaultExecutionPolicy: string;
    /** Execution policy for using IAM roles with SageMaker Unified Studio. Allows users to access resources in your account (including broad access to all APIs in data services like S3, Glue, CloudWatch Logs, and others) for IAM-based usage of SageMaker Unified Studio. */
    static SageMakerStudioUserIAMPermissiveExecutionPolicy: string;
    /** Provides read/write access to AWS Secrets Manager via the AWS Management Console. Note: this exludes IAM actions, so combine with IAMFullAccess if rotation configuration is required. */
    static SecretsManagerReadWrite: string;
    /** The security audit template grants access to read security configuration metadata. It is useful for software that audits the configuration of an AWS account. */
    static SecurityAudit: string;
    /** Provides access to manage resources created by Security Lake. */
    static SecurityLakeResourceManagementServiceRolePolicy: string;
    /** This policy grants permissions to operate the Amazon Security Lake service on your behalf */
    static SecurityLakeServiceLinkedRole: string;
    /** Permissions to allow the AWS Server Migration Connector to migrate VMs to EC2. Allows communication with the AWS Server Migration Service, read/write access to S3 buckets starting with 'sms-b-' and 'import-to-ec2-' as well as the buckets used for AWS Server Migration Connector upgrade, AWS Server Migration Connector registration with AWS, and metrics upload to AWS. */
    static ServerMigrationConnector: string;
    /** Required permissions to use all features of the Server Migration Service Console */
    static ServerMigrationServiceConsoleFullAccess: string;
    /** Permissions to allow the AWS Server Migration Service to create and update relevant AWS resources into the customer's AWS account for launching migrated servers and applications. */
    static ServerMigrationServiceLaunchRole: string;
    /** Permissions to allow the AWS SMS to run used data validation script and send script success/failure back to SMS */
    static ServerMigrationServiceRoleForInstanceValidation: string;
    /** Provides full access to Service Quotas */
    static ServiceQuotasFullAccess: string;
    /** Provides read only access to Service Quotas */
    static ServiceQuotasReadOnlyAccess: string;
    /** Allows Service Quotas to create support cases on your behalf */
    static ServiceQuotasServiceRolePolicy: string;
    /** Provides full access to the Simple Workflow configuration service. */
    static SimpleWorkflowFullAccess: string;
    /** Allows SMSVoice to publish metrics to CloudWatch on your behalf */
    static SMSVoiceServiceRolePolicy: string;
    /** Allows split cost allocation data to retrieve AWS Organizations information, if applicable, and collect telemetry data for the split cost allocation data services that the customer has opted in to. */
    static SplitCostAllocationDataServiceRolePolicy: string;
    /** Provides access required to unlock a SQS queue policy using the Security Token Service (STS) AssumeRoot API. Use this managed policy only with the STS AssumeRoot action. */
    static SQSUnlockQueuePolicy: string;
    /** Provides permissions to check Quick Setup configuration health, ensure consistent use of parameters and provisioned resources, and remediate resources when drift is detected. */
    static SSMQuickSetupRolePolicy: string;
    /** This policy grants permissions to troubleshoot and resolve issues in an AWS account. This policy also enables the user to contact AWS support to create and manage cases. */
    static SupportUser: string;
    /** Grants full access permissions necessary for resources required for application and development operations. */
    static SystemAdministrator: string;
    /** Provides full access to Amazon Translate. */
    static TranslateFullAccess: string;
    /** Provides read-only access to Amazon Translate. */
    static TranslateReadOnly: string;
    /** This policy grants permissions to view resources and basic metadata across all AWS services. */
    static ViewOnlyAccess: string;
    /** Default policy for the VM Import/Export service role, for customers using the AWS Connector. The VM Import/Export service assumes a role with this policy to fulfill virtual machine migration requests from the AWS Connector virtual appliance. (Note that the AWS Connector uses the "AWSConnector" managed policy to issue requests on the customer's behalf to the VM Import/Export service.) Provides the ability to create AMIs and EBS snapshots, modify EBS snapshot attributes, make "Describe*" calls on EC2 objects, and read from S3 buckets starting with 'import-to-ec2-'. */
    static VMImportExportRoleForAWSConnector: string;
    /** Provides full access to Amazon VPC Lattice and access to dependency services. */
    static VPCLatticeFullAccess: string;
    /** Provides read-only access to Amazon VPC Lattice via the AWS Management Console, and limited access to dependency services. */
    static VPCLatticeReadOnlyAccess: string;
    /** Provides access to invoking Amazon VPC Lattice services. */
    static VPCLatticeServicesInvokeAccess: string;
    /** Creating SLR to write customer's logs to a firehose stream */
    static WAFLoggingServiceRolePolicy: string;
    /** Creating SLR to write customer's logs to a firehose stream */
    static WAFRegionalLoggingServiceRolePolicy: string;
    /** This policy creates a service-linked role that allows AWS WAF to write logs to Amazon Kinesis Data Firehose. */
    static WAFV2LoggingServiceRolePolicy: string;
    /** Provides full access to AWS Well-Architected Tool via the AWS Management Console */
    static WellArchitectedConsoleFullAccess: string;
    /** Provides read-only access to AWS Well-Architected Tool via the AWS Management Console */
    static WellArchitectedConsoleReadOnlyAccess: string;
    /** Enables access to AWS Services and Resources used or managed by Amazon WorkLink */
    static WorkLinkServiceRolePolicy: string;
}
type ExcludePrototype<T> = Exclude<keyof T, 'prototype'>;
export type AwsManagedPolicyName = ExcludePrototype<typeof AwsManagedPolicy>;
export {};
