"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsManagedPolicy = void 0;
/** Provides names of all AWS managed policies. */
class AwsManagedPolicy {
}
exports.AwsManagedPolicy = AwsManagedPolicy;
/** Allow Access Analyzer to analyze resource metadata */
AwsManagedPolicy.AccessAnalyzerServiceRolePolicy = 'aws-service-role/AccessAnalyzerServiceRolePolicy';
/** Provides full access to AWS services and resources. */
AwsManagedPolicy.AdministratorAccess = 'AdministratorAccess';
/** Grants account administrative permissions while explicitly allowing direct access to resources needed by Amplify applications. */
AwsManagedPolicy.AdministratorAccessAmplify = 'AdministratorAccess-Amplify';
/** Grants account administrative permissions. Explicitly allows developers and administrators to gain direct access to resources they need to manage AWS Elastic Beanstalk applications */
AwsManagedPolicy.AdministratorAccessAWSElasticBeanstalk = 'AdministratorAccess-AWSElasticBeanstalk';
/** Provides ReadOnly permissions required by the Amazon AI Operations Assistant to do analysis on customer AWS resources during investigations. */
AwsManagedPolicy.AIOpsAssistantPolicy = 'AIOpsAssistantPolicy';
/** Grants full access to Amazon AI Operations service and its required permissions via AWS console. It also includes permissions to use identity-aware console sessions. */
AwsManagedPolicy.AIOpsConsoleAdminPolicy = 'AIOpsConsoleAdminPolicy';
/** Grants access to the Amazon AI Operations APIs for creating, updating, and deleting investigations, investigation events, and investigation resources. It also includes ReadOnly access to all AI Operations APIs and to use identity-aware sessions. */
AwsManagedPolicy.AIOpsOperatorAccess = 'AIOpsOperatorAccess';
/** Grants ReadOnly permissions to the Amazon AI Operations service and its required resources. */
AwsManagedPolicy.AIOpsReadOnlyAccess = 'AIOpsReadOnlyAccess';
/** Provide device setup access to AlexaForBusiness services */
AwsManagedPolicy.AlexaForBusinessDeviceSetup = 'AlexaForBusinessDeviceSetup';
/** Grants full access to AlexaForBusiness resources and access to related AWS Services */
AwsManagedPolicy.AlexaForBusinessFullAccess = 'AlexaForBusinessFullAccess';
/** Provide gateway execution access to AlexaForBusiness services */
AwsManagedPolicy.AlexaForBusinessGatewayExecution = 'AlexaForBusinessGatewayExecution';
/** Provide access to Lifesize AVS devices */
AwsManagedPolicy.AlexaForBusinessLifesizeDelegatedAccessPolicy = 'AlexaForBusinessLifesizeDelegatedAccessPolicy';
/** This policy enables Alexa for Business to perform automated tasks scheduled by your network profiles. */
AwsManagedPolicy.AlexaForBusinessNetworkProfileServicePolicy = 'aws-service-role/AlexaForBusinessNetworkProfileServicePolicy';
/** Provide access to Poly AVS devices */
AwsManagedPolicy.AlexaForBusinessPolyDelegatedAccessPolicy = 'AlexaForBusinessPolyDelegatedAccessPolicy';
/** Provide read only access to AlexaForBusiness services */
AwsManagedPolicy.AlexaForBusinessReadOnlyAccess = 'AlexaForBusinessReadOnlyAccess';
/** Provides full access to create/edit/delete APIs in Amazon API Gateway via the AWS Management Console. */
AwsManagedPolicy.AmazonAPIGatewayAdministrator = 'AmazonAPIGatewayAdministrator';
/** Provides full access to invoke APIs in Amazon API Gateway. */
AwsManagedPolicy.AmazonAPIGatewayInvokeFullAccess = 'AmazonAPIGatewayInvokeFullAccess';
/** Allows API Gateway to push logs to user's account. */
AwsManagedPolicy.AmazonAPIGatewayPushToCloudWatchLogs = 'service-role/AmazonAPIGatewayPushToCloudWatchLogs';
/** Provides full access to Amazon AppFlow and access to AWS services supported as flow source or destination (S3 and Redshift). Also provides access to KMS for encryption */
AwsManagedPolicy.AmazonAppFlowFullAccess = 'AmazonAppFlowFullAccess';
/** Provides read only access to Amazon Appflow flows */
AwsManagedPolicy.AmazonAppFlowReadOnlyAccess = 'AmazonAppFlowReadOnlyAccess';
/** Provides full access to Amazon AppStream via the AWS Management Console. */
AwsManagedPolicy.AmazonAppStreamFullAccess = 'AmazonAppStreamFullAccess';
/** Amazon AppStream 2.0 access to AWS Certificate Manager Private CA in customer accounts for certificate-based authentication */
AwsManagedPolicy.AmazonAppStreamPCAAccess = 'service-role/AmazonAppStreamPCAAccess';
/** Provides read only access to Amazon AppStream via the AWS Management Console. */
AwsManagedPolicy.AmazonAppStreamReadOnlyAccess = 'AmazonAppStreamReadOnlyAccess';
/** Default policy for Amazon AppStream service role. */
AwsManagedPolicy.AmazonAppStreamServiceAccess = 'service-role/AmazonAppStreamServiceAccess';
/** Provide full access to Amazon Athena and scoped access to the dependencies needed to enable querying, writing results, and data management. */
AwsManagedPolicy.AmazonAthenaFullAccess = 'AmazonAthenaFullAccess';
/** Provides access to perform all operations Amazon Augmented AI resources, including FlowDefinitions, HumanTaskUis and HumanLoops. Does not allow access for creating FlowDefinitions against the public-crowd Workteam. */
AwsManagedPolicy.AmazonAugmentedAIFullAccess = 'AmazonAugmentedAIFullAccess';
/** Provides access to perform all operations on HumanLoops. */
AwsManagedPolicy.AmazonAugmentedAIHumanLoopFullAccess = 'AmazonAugmentedAIHumanLoopFullAccess';
/** Provides access to perform all operations Amazon Augmented AI resources, including FlowDefinitions, HumanTaskUis and HumanLoops. Also provides access to those operations of services that are integrated with Amazon Augmented AI. */
AwsManagedPolicy.AmazonAugmentedAIIntegratedAPIAccess = 'AmazonAugmentedAIIntegratedAPIAccess';
/** Provides console full administrative access to Aurora DSQL */
AwsManagedPolicy.AmazonAuroraDSQLConsoleFullAccess = 'AmazonAuroraDSQLConsoleFullAccess';
/** Provides full administrative access to Aurora DSQL */
AwsManagedPolicy.AmazonAuroraDSQLFullAccess = 'AmazonAuroraDSQLFullAccess';
/** Provides read only access to Aurora DSQL */
AwsManagedPolicy.AmazonAuroraDSQLReadOnlyAccess = 'AmazonAuroraDSQLReadOnlyAccess';
/** Provides Bedrock Model inference permission to Bedrock agent core memory */
AwsManagedPolicy.AmazonBedrockAgentCoreMemoryBedrockModelInferenceExecutionRolePolicy = 'AmazonBedrockAgentCoreMemoryBedrockModelInferenceExecutionRolePolicy';
/** Provides full access to Amazon Bedrock as well as limited access to related services that are required by it */
AwsManagedPolicy.AmazonBedrockFullAccess = 'AmazonBedrockFullAccess';
/** Provides limited access to Amazon Bedrock as well as to related services that are required by it */
AwsManagedPolicy.AmazonBedrockLimitedAccess = 'AmazonBedrockLimitedAccess';
/** Provides limited access to Amazon Bedrock Marketplace as well as to related services that are required by it */
AwsManagedPolicy.AmazonBedrockMarketplaceAccess = 'AmazonBedrockMarketplaceAccess';
/** Provides read only access to Amazon Bedrock */
AwsManagedPolicy.AmazonBedrockReadOnly = 'AmazonBedrockReadOnly';
/** Defines the maximum permissions of IAM roles that Amazon Bedrock Studio creates for operating Amazon Bedrock Studio resources. */
AwsManagedPolicy.AmazonBedrockStudioPermissionsBoundary = 'AmazonBedrockStudioPermissionsBoundary';
/** Provides full access to Amazon Braket via the AWS Management Console and SDK. Also provides access to related services (e.g., S3, logs). */
AwsManagedPolicy.AmazonBraketFullAccess = 'AmazonBraketFullAccess';
/** Grants access to AWS Services and resources necessary for executing an Amazon Braket Job including S3, Cloudwatch, IAM and Braket */
AwsManagedPolicy.AmazonBraketJobsExecutionPolicy = 'AmazonBraketJobsExecutionPolicy';
/** Allows Amazon Braket to create and manage AWS resources on your behalf */
AwsManagedPolicy.AmazonBraketServiceRolePolicy = 'aws-service-role/AmazonBraketServiceRolePolicy';
/** Provides full access to Amazon Chime Admin Console via the AWS Management Console. */
AwsManagedPolicy.AmazonChimeFullAccess = 'AmazonChimeFullAccess';
/** Provides read only access to Amazon Chime Admin Console via the AWS Management Console. */
AwsManagedPolicy.AmazonChimeReadOnly = 'AmazonChimeReadOnly';
/** Provides access to Amazon Chime SDK operations */
AwsManagedPolicy.AmazonChimeSDK = 'AmazonChimeSDK';
/** Managed Policy For Amazon Chime SDK MediaPipelines Service Linked Role */
AwsManagedPolicy.AmazonChimeSDKMediaPipelinesServiceLinkedRolePolicy = 'aws-service-role/AmazonChimeSDKMediaPipelinesServiceLinkedRolePolicy';
/** Allows Amazon Chime SDK Messaging to access AWS resources and enable messaging functionality */
AwsManagedPolicy.AmazonChimeSDKMessagingServiceRolePolicy = 'aws-service-role/AmazonChimeSDKMessagingServiceRolePolicy';
/** Enables access to AWS Resources used or managed by Amazon Chime */
AwsManagedPolicy.AmazonChimeServiceRolePolicy = 'aws-service-role/AmazonChimeServiceRolePolicy';
/** Allows Amazon Chime to access Amazon Transcribe and Amazon Transcribe Medical on your behalf */
AwsManagedPolicy.AmazonChimeTranscriptionServiceLinkedRolePolicy = 'aws-service-role/AmazonChimeTranscriptionServiceLinkedRolePolicy';
/** Provides user management access to Amazon Chime Admin Console via the AWS Management Console. */
AwsManagedPolicy.AmazonChimeUserManagement = 'AmazonChimeUserManagement';
/** Managed policy for Service Linked Role for Amazon Chime VoiceConnector */
AwsManagedPolicy.AmazonChimeVoiceConnectorServiceLinkedRolePolicy = 'aws-service-role/AmazonChimeVoiceConnectorServiceLinkedRolePolicy';
/** Provides full access to Amazon Cloud Directory Service. */
AwsManagedPolicy.AmazonCloudDirectoryFullAccess = 'AmazonCloudDirectoryFullAccess';
/** Provides read only access to Amazon Cloud Directory Service. */
AwsManagedPolicy.AmazonCloudDirectoryReadOnlyAccess = 'AmazonCloudDirectoryReadOnlyAccess';
/** Provides full only access to Amazon CloudWatch Evidently. Also provides access to related Amazon S3, Amazon SNS, Amazon CloudWatch, and other related services. */
AwsManagedPolicy.AmazonCloudWatchEvidentlyFullAccess = 'AmazonCloudWatchEvidentlyFullAccess';
/** Provides read only access to Amazon CloudWatch Evidently */
AwsManagedPolicy.AmazonCloudWatchEvidentlyReadOnlyAccess = 'AmazonCloudWatchEvidentlyReadOnlyAccess';
/** Allows CloudWatch Evidently Service to manage associated AWS Resources on behalf of the customer */
AwsManagedPolicy.AmazonCloudWatchEvidentlyServiceRolePolicy = 'aws-service-role/AmazonCloudWatchEvidentlyServiceRolePolicy';
/** Grants full access permissions for the Amazon CloudWatch RUM service */
AwsManagedPolicy.AmazonCloudWatchRUMFullAccess = 'AmazonCloudWatchRUMFullAccess';
/** Grants read only permissions for the Amazon CloudWatch RUM service */
AwsManagedPolicy.AmazonCloudWatchRUMReadOnlyAccess = 'AmazonCloudWatchRUMReadOnlyAccess';
/** Grants permission to Amazon CloudWatch RUM Service to publish monitoring data to other relevant AWS services */
AwsManagedPolicy.AmazonCloudWatchRUMServiceRolePolicy = 'aws-service-role/AmazonCloudWatchRUMServiceRolePolicy';
/** Provides full access to Amazon CodeCatalyst */
AwsManagedPolicy.AmazonCodeCatalystFullAccess = 'AmazonCodeCatalystFullAccess';
/** Provides read only access to Amazon CodeCatalyst */
AwsManagedPolicy.AmazonCodeCatalystReadOnlyAccess = 'AmazonCodeCatalystReadOnlyAccess';
/** Allows Amazon CodeCatalyst to create, update, and resolve AWS Support cases on your behalf. */
AwsManagedPolicy.AmazonCodeCatalystSupportAccess = 'service-role/AmazonCodeCatalystSupportAccess';
/** Provides access required by Amazon CodeGuru Profiler agent. */
AwsManagedPolicy.AmazonCodeGuruProfilerAgentAccess = 'AmazonCodeGuruProfilerAgentAccess';
/** Provides full access to Amazon CodeGuru Profiler. */
AwsManagedPolicy.AmazonCodeGuruProfilerFullAccess = 'AmazonCodeGuruProfilerFullAccess';
/** Provides read only access to Amazon CodeGuru Profiler. */
AwsManagedPolicy.AmazonCodeGuruProfilerReadOnlyAccess = 'AmazonCodeGuruProfilerReadOnlyAccess';
/** Grants full access to Amazon CodeGuru Reviewer and scoped access to required dependencies. */
AwsManagedPolicy.AmazonCodeGuruReviewerFullAccess = 'AmazonCodeGuruReviewerFullAccess';
/** Provides read only access to Amazon CodeGuru Reviewer. */
AwsManagedPolicy.AmazonCodeGuruReviewerReadOnlyAccess = 'AmazonCodeGuruReviewerReadOnlyAccess';
/** A service-linked role required for Amazon CodeGuru Reviewer to access resources on your behalf. */
AwsManagedPolicy.AmazonCodeGuruReviewerServiceRolePolicy = 'aws-service-role/AmazonCodeGuruReviewerServiceRolePolicy';
/** Provides full access to Amazon CodeGuru Security. */
AwsManagedPolicy.AmazonCodeGuruSecurityFullAccess = 'AmazonCodeGuruSecurityFullAccess';
/** Provides access required for working with Amazon CodeGuru Security scans. */
AwsManagedPolicy.AmazonCodeGuruSecurityScanAccess = 'AmazonCodeGuruSecurityScanAccess';
/** Provides access to Amazon Cognito APIs to support developer authenticated identities from your authentication backend. */
AwsManagedPolicy.AmazonCognitoDeveloperAuthenticatedIdentities = 'AmazonCognitoDeveloperAuthenticatedIdentities';
/** Allows Amazon Cognito User Pools service to use your SES identities for email sending */
AwsManagedPolicy.AmazonCognitoIdpEmailServiceRolePolicy = 'aws-service-role/AmazonCognitoIdpEmailServiceRolePolicy';
/** Enables access to AWS Services and Resources used or managed by Amazon Cognito User Pools */
AwsManagedPolicy.AmazonCognitoIdpServiceRolePolicy = 'aws-service-role/AmazonCognitoIdpServiceRolePolicy';
/** Provides administrative access to existing Amazon Cognito resources. You will need AWS account admin privileges to create new Cognito resources. */
AwsManagedPolicy.AmazonCognitoPowerUser = 'AmazonCognitoPowerUser';
/** Provides read only access to Amazon Cognito resources. */
AwsManagedPolicy.AmazonCognitoReadOnly = 'AmazonCognitoReadOnly';
/** This policy defines the set of permissions allowed for unauthenticated identities for Cognito Identity Pools. This policy is not intended to be used as a stand alone permission policy. It is used as a guardrail against overly permissive policies attached for roles in an identity pool. Do not attach this policy to any roles, as Cognito Identity Service will automatically include it as a scoped down policy when creating credentials. The privileges to temporarily access other AWS resources through the enhanced flow will now be defined by the intersection of the role associated with the identity of the unauthenticated user provided by a service, and the privileges given in this managed policy that is owned by Cognito. */
AwsManagedPolicy.AmazonCognitoUnAuthedIdentitiesSessionPolicy = 'AmazonCognitoUnAuthedIdentitiesSessionPolicy';
/** This policy defines the set of permissions allowed for unauthenticated identities for Cognito Identity Pools. This does not need to be attached to your unauth role, as Cognito Identity Service will automatically include it as a scoped down policy when creating credentials. The privileges to temporarily access other AWS resources through the enhanced flow will now be defined by the intersection of the role associated with the identity of the unauthenticated user provided by a service, and the privileges given in this managed policy that is owned by Cognito. */
AwsManagedPolicy.AmazonCognitoUnauthenticatedIdentities = 'AmazonCognitoUnauthenticatedIdentities';
/** The purpose of this policy is to grant permissions to AWS Connect users required to use Connect resources. This policy provides full access to AWS Connect resources via the Connect Console and public APIs */
AwsManagedPolicy.AmazonConnectFullAccess = 'AmazonConnect_FullAccess';
/** Policy for Amazon Connect Campaigns service linked role */
AwsManagedPolicy.AmazonConnectCampaignsServiceLinkedRolePolicy = 'aws-service-role/AmazonConnectCampaignsServiceLinkedRolePolicy';
/** Grants permission to view the Amazon Connect instances in your AWS account. */
AwsManagedPolicy.AmazonConnectReadOnlyAccess = 'AmazonConnectReadOnlyAccess';
/** Allows Amazon Connect to create and manage AWS resources on your behalf. */
AwsManagedPolicy.AmazonConnectServiceLinkedRolePolicy = 'aws-service-role/AmazonConnectServiceLinkedRolePolicy';
/** Allows Amazon Connect to synchronize AWS resources across regions on your behalf. */
AwsManagedPolicy.AmazonConnectSynchronizationServiceRolePolicy = 'aws-service-role/AmazonConnectSynchronizationServiceRolePolicy';
/** Provides full access to Amazon Connect Voice ID */
AwsManagedPolicy.AmazonConnectVoiceIDFullAccess = 'AmazonConnectVoiceIDFullAccess';
/** Provides permissions to consume Amazon Bedrock models, including invoking Amazon Bedrock application inference profile created for particular Amazon DataZone domain. */
AwsManagedPolicy.AmazonDataZoneBedrockModelConsumptionPolicy = 'service-role/AmazonDataZoneBedrockModelConsumptionPolicy';
/** Provides permissions to manage Amazon Bedrock model access, including creating, tagging and deleting application inference profiles. */
AwsManagedPolicy.AmazonDataZoneBedrockModelManagementPolicy = 'service-role/AmazonDataZoneBedrockModelManagementPolicy';
/** Default policy for the Amazon DataZone's DomainExecutionRole service role. This role is used by Amazon DataZone to catalog, discover, govern, share, and analyze data in the Amazon DataZone domain. */
AwsManagedPolicy.AmazonDataZoneDomainExecutionRolePolicy = 'service-role/AmazonDataZoneDomainExecutionRolePolicy';
/** Amazon DataZone creates IAM roles for Environments to perform data analytics actions, and uses this policy when creating these roles to define the boundary of their permissions. */
AwsManagedPolicy.AmazonDataZoneEnvironmentRolePermissionsBoundary = 'AmazonDataZoneEnvironmentRolePermissionsBoundary';
/** Provides full access to Amazon DataZone via the AWS Management Console as well as limited access to related services that are required by it. */
AwsManagedPolicy.AmazonDataZoneFullAccess = 'AmazonDataZoneFullAccess';
/** Provides full access to Amazon DataZone, but does not allow the management of domains, users, or associated accounts. */
AwsManagedPolicy.AmazonDataZoneFullUserAccess = 'AmazonDataZoneFullUserAccess';
/** The policy grants permissions to allow Amazon DataZone to enable publishing and access grants to data. */
AwsManagedPolicy.AmazonDataZoneGlueManageAccessRolePolicy = 'service-role/AmazonDataZoneGlueManageAccessRolePolicy';
/** Amazon DataZone is a data management service that enables you to catalog, discover, govern, share, and analyze your data. With Amazon DataZone, you can share and access your data across accounts and supported regions. Amazon DataZone simplifies your experience across AWS services, including, but not limited to, Amazon Redshift, Amazon Athena, AWS Glue, and AWS Lake Formation. */
AwsManagedPolicy.AmazonDataZoneRedshiftGlueProvisioningPolicy = 'AmazonDataZoneRedshiftGlueProvisioningPolicy';
/** This policy gives Amazon DataZone permissions to publish Amazon Redshift data to the catalog. It also gives Amazon DataZone permissions to grant access or revoke access to Amazon Redshift or Amazon Redshift Serverless published assets in the catalog. */
AwsManagedPolicy.AmazonDataZoneRedshiftManageAccessRolePolicy = 'service-role/AmazonDataZoneRedshiftManageAccessRolePolicy';
/** The AmazonDataZoneSageMakerEnvironmentRolePermissionsBoundary policy is the list of permissions that are permitted on an execution role created in a SageMaker environment provisioned by Amazon DataZone. */
AwsManagedPolicy.AmazonDataZoneSageMakerEnvironmentRolePermissionsBoundary = 'AmazonDataZoneSageMakerEnvironmentRolePermissionsBoundary';
/** The AmazonDataZoneSageMakerManageAccessRolePolicy policy grants Amazon DataZone the permissions required to grant user access to various resources in the SageMaker environment. */
AwsManagedPolicy.AmazonDataZoneSageMakerManageAccessRolePolicy = 'AmazonDataZoneSageMakerManageAccessRolePolicy';
/** The AmazonDataZoneSageMakerProvisioningRolePolicy policy grants Amazon DataZone the permissions required to interoperate with Amazon SageMaker. */
AwsManagedPolicy.AmazonDataZoneSageMakerProvisioningRolePolicy = 'AmazonDataZoneSageMakerProvisioningRolePolicy';
/**  Provides full access to Amazon Detective service and scoped access to the console UI dependencies */
AwsManagedPolicy.AmazonDetectiveFullAccess = 'AmazonDetectiveFullAccess';
/** Provides investigator access to Amazon Detective service and scoped access to the console UI dependencies. This policy grants permission to dive into Detective for investigation purposes and limited write access to Guardduty. */
AwsManagedPolicy.AmazonDetectiveInvestigatorAccess = 'AmazonDetectiveInvestigatorAccess';
/** Provides member access to Amazon Detective service and scoped access to the console UI dependencies. */
AwsManagedPolicy.AmazonDetectiveMemberAccess = 'AmazonDetectiveMemberAccess';
/** Provides Organizations access to manage Delegated administrator for Amazon Detective and scoped access to the console UI dependencies. This also grants permission to create a service-linked role for Detective. */
AwsManagedPolicy.AmazonDetectiveOrganizationsAccess = 'AmazonDetectiveOrganizationsAccess';
/** Allows Amazon Detective to make service calls on your behalf */
AwsManagedPolicy.AmazonDetectiveServiceLinkedRolePolicy = 'aws-service-role/AmazonDetectiveServiceLinkedRolePolicy';
/** The policy grants full-access to the DevOps Guru console. */
AwsManagedPolicy.AmazonDevOpsGuruConsoleFullAccess = 'AmazonDevOpsGuruConsoleFullAccess';
/** Provides full access to Amazon DevOps Guru. */
AwsManagedPolicy.AmazonDevOpsGuruFullAccess = 'AmazonDevOpsGuruFullAccess';
/** Provide access to enable and manage Amazon DevOps Guru within an organization. */
AwsManagedPolicy.AmazonDevOpsGuruOrganizationsAccess = 'AmazonDevOpsGuruOrganizationsAccess';
/** Provides read only access to Amazon DevOps Guru Console. */
AwsManagedPolicy.AmazonDevOpsGuruReadOnlyAccess = 'AmazonDevOpsGuruReadOnlyAccess';
/** A service-linked role required for Amazon DevOpsGuru to access your resources. */
AwsManagedPolicy.AmazonDevOpsGuruServiceRolePolicy = 'aws-service-role/AmazonDevOpsGuruServiceRolePolicy';
/** Provides access to upload DMS replication logs to cloudwatch logs in customer account. */
AwsManagedPolicy.AmazonDMSCloudWatchLogsRole = 'service-role/AmazonDMSCloudWatchLogsRole';
/** Provides access to manage S3 settings for Redshift endpoints for DMS. */
AwsManagedPolicy.AmazonDMSRedshiftS3Role = 'service-role/AmazonDMSRedshiftS3Role';
/** Provides access to manage VPC settings for AWS managed customer configurations */
AwsManagedPolicy.AmazonDMSVPCManagementRole = 'service-role/AmazonDMSVPCManagementRole';
/** Allows Amazon DocumentDB-Elastic to manage AWS resources on your behalf. */
AwsManagedPolicy.AmazonDocDBElasticServiceRolePolicy = 'aws-service-role/AmazonDocDB-ElasticServiceRolePolicy';
/** Provides full access to manage Amazon DocumentDB with MongoDB compatibility using the AWS Management Console. Note this policy also grants full access to publish on all SNS topics within the account, permissions to create and edit Amazon EC2 instances and VPC configurations, permissions to view and list keys on Amazon KMS, and full access to Amazon RDS and Amazon Neptune. */
AwsManagedPolicy.AmazonDocDBConsoleFullAccess = 'AmazonDocDBConsoleFullAccess';
/** Provides full access to Amazon DocumentDB Elastic Clusters and other required permissions for its dependencies including EC2, KMS, SecretsManager, CloudWatch and IAM. */
AwsManagedPolicy.AmazonDocDBElasticFullAccess = 'AmazonDocDBElasticFullAccess';
/** Provides read-only access to Amazon DocDB-Elastic and CloudWatch metrics. */
AwsManagedPolicy.AmazonDocDBElasticReadOnlyAccess = 'AmazonDocDBElasticReadOnlyAccess';
/** Provides full access to Amazon DocumentDB with MongoDB compatibility. Note this policy also grants full access to publish on all SNS topics within the account and full access to Amazon RDS and Amazon Neptune. */
AwsManagedPolicy.AmazonDocDBFullAccess = 'AmazonDocDBFullAccess';
/** Provides read-only access to Amazon DocumentDB with MongoDB compatibility. Note that this policy also grants access to Amazon RDS and Amazon Neptune resources. */
AwsManagedPolicy.AmazonDocDBReadOnlyAccess = 'AmazonDocDBReadOnlyAccess';
/** Provides access to manage VPC settings for Amazon managed customer configurations */
AwsManagedPolicy.AmazonDRSVPCManagement = 'AmazonDRSVPCManagement';
/** Provides full access to Amazon DynamoDB via the AWS Management Console. */
AwsManagedPolicy.AmazonDynamoDBFullAccess = 'AmazonDynamoDBFullAccess';
/** Provides full access to Amazon DynamoDB */
AwsManagedPolicy.AmazonDynamoDBFullAccessV2 = 'AmazonDynamoDBFullAccess_v2';
/** This policy is on a deprecation path. See documentation for guidance: https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DynamoDBPipeline.html. Provides full access to Amazon DynamoDB including Export/Import using AWS Data Pipeline via the AWS Management Console. */
AwsManagedPolicy.AmazonDynamoDBFullAccesswithDataPipeline = 'AmazonDynamoDBFullAccesswithDataPipeline';
/** Provides read only access to Amazon DynamoDB via the AWS Management Console. */
AwsManagedPolicy.AmazonDynamoDBReadOnlyAccess = 'AmazonDynamoDBReadOnlyAccess';
/** IAM Policy that allows the CSI driver service account to make calls to related services such as EC2 on your behalf. */
AwsManagedPolicy.AmazonEBSCSIDriverPolicy = 'service-role/AmazonEBSCSIDriverPolicy';
/** Provides administrative access to Amazon ECR resources */
AwsManagedPolicy.AmazonEC2ContainerRegistryFullAccess = 'AmazonEC2ContainerRegistryFullAccess';
/** Provides full access to Amazon EC2 Container Registry repositories, but does not allow repository deletion or policy changes. */
AwsManagedPolicy.AmazonEC2ContainerRegistryPowerUser = 'AmazonEC2ContainerRegistryPowerUser';
/** Provides access to pull images from Amazon EC2 Container Registry repositories. */
AwsManagedPolicy.AmazonEC2ContainerRegistryPullOnly = 'AmazonEC2ContainerRegistryPullOnly';
/** Provides read-only access to Amazon EC2 Container Registry repositories. */
AwsManagedPolicy.AmazonEC2ContainerRegistryReadOnly = 'AmazonEC2ContainerRegistryReadOnly';
/**   Policy to enable Task Autoscaling for Amazon EC2 Container Service */
AwsManagedPolicy.AmazonEC2ContainerServiceAutoscaleRole = 'service-role/AmazonEC2ContainerServiceAutoscaleRole';
/** Policy to enable CloudWatch Events for EC2 Container Service */
AwsManagedPolicy.AmazonEC2ContainerServiceEventsRole = 'service-role/AmazonEC2ContainerServiceEventsRole';
/** Default policy for the Amazon EC2 Role for Amazon EC2 Container Service. */
AwsManagedPolicy.AmazonEC2ContainerServiceforEC2Role = 'service-role/AmazonEC2ContainerServiceforEC2Role';
/** Default policy for Amazon ECS service role. */
AwsManagedPolicy.AmazonEC2ContainerServiceRole = 'service-role/AmazonEC2ContainerServiceRole';
/** Provides full access to Amazon EC2 via the AWS Management Console. */
AwsManagedPolicy.AmazonEC2FullAccess = 'AmazonEC2FullAccess';
/** Provides read-only access to scan all supported resource types for relevant data when using DescribeImageReferences. */
AwsManagedPolicy.AmazonEC2ImageReferencesAccessPolicy = 'AmazonEC2ImageReferencesAccessPolicy';
/** Provides read only access to Amazon EC2 via the AWS Management Console. */
AwsManagedPolicy.AmazonEC2ReadOnlyAccess = 'AmazonEC2ReadOnlyAccess';
/** Provides EC2 access to S3 bucket to download revision. This role is needed by the CodeDeploy agent on EC2 instances. */
AwsManagedPolicy.AmazonEC2RoleforAWSCodeDeploy = 'service-role/AmazonEC2RoleforAWSCodeDeploy';
/** Provides EC2 limited access to S3 bucket to download revision. This role is needed by the CodeDeploy agent on EC2 instances. */
AwsManagedPolicy.AmazonEC2RoleforAWSCodeDeployLimited = 'service-role/AmazonEC2RoleforAWSCodeDeployLimited';
/** Default policy for the Amazon EC2 Role for Data Pipeline service role. */
AwsManagedPolicy.AmazonEC2RoleforDataPipelineRole = 'service-role/AmazonEC2RoleforDataPipelineRole';
/** This policy will soon be deprecated. Please use AmazonSSMManagedInstanceCore policy to enable AWS Systems Manager service core functionality on EC2 instances. For more information see https://docs.aws.amazon.com/systems-manager/latest/userguide/setup-instance-profile.html */
AwsManagedPolicy.AmazonEC2RoleforSSM = 'service-role/AmazonEC2RoleforSSM';
/** Managed policy for the Amazon LaunchWizard service role for EC2 */
AwsManagedPolicy.AmazonEC2RolePolicyForLaunchWizard = 'AmazonEC2RolePolicyForLaunchWizard';
/** Policy to enable Autoscaling for Amazon EC2 Spot Fleet */
AwsManagedPolicy.AmazonEC2SpotFleetAutoscaleRole = 'service-role/AmazonEC2SpotFleetAutoscaleRole';
/** Allows EC2 Spot Fleet to request, terminate and tag Spot Instances on your behalf. */
AwsManagedPolicy.AmazonEC2SpotFleetTaggingRole = 'service-role/AmazonEC2SpotFleetTaggingRole';
/** Provides administrative access to Amazon ECS resources and enables ECS features through access to other AWS service resources, including VPCs, Auto Scaling groups, and CloudFormation stacks. */
AwsManagedPolicy.AmazonECSFullAccess = 'AmazonECS_FullAccess';
/** Policy to enable Amazon ECS Compute to manage your EC2 instances and related resources as part of ECS managed instances */
AwsManagedPolicy.AmazonECSComputeServiceRolePolicy = 'aws-service-role/AmazonECSComputeServiceRolePolicy';
/** Provides access to other AWS service resources required to manage load balancers associated with ECS workloads on your behalf. */
AwsManagedPolicy.AmazonECSInfrastructureRolePolicyForLoadBalancers = 'AmazonECSInfrastructureRolePolicyForLoadBalancers';
/** Provides administrative access to Private Certificate Authority, AWS Secrets Manager and other AWS Services required to manage ECS Service Connect TLS features on your behalf. */
AwsManagedPolicy.AmazonECSInfrastructureRolePolicyForServiceConnectTransportLayerSecurity = 'service-role/AmazonECSInfrastructureRolePolicyForServiceConnectTransportLayerSecurity';
/** Provides access to other AWS service resources required to manage volumes associated with ECS workloads on your behalf. */
AwsManagedPolicy.AmazonECSInfrastructureRolePolicyForVolumes = 'service-role/AmazonECSInfrastructureRolePolicyForVolumes';
/** Provides access to other AWS service resources required to manage VPC Lattice feature in ECS workloads on your behalf. */
AwsManagedPolicy.AmazonECSInfrastructureRolePolicyForVpcLattice = 'AmazonECSInfrastructureRolePolicyForVpcLattice';
/** Policy to enable Amazon ECS to manage your cluster. */
AwsManagedPolicy.AmazonECSServiceRolePolicy = 'aws-service-role/AmazonECSServiceRolePolicy';
/** Provides access to other AWS service resources that are required to run Amazon ECS tasks */
AwsManagedPolicy.AmazonECSTaskExecutionRolePolicy = 'service-role/AmazonECSTaskExecutionRolePolicy';
/** Provides management access to EFS resources and read access to EC2 */
AwsManagedPolicy.AmazonEFSCSIDriverPolicy = 'service-role/AmazonEFSCSIDriverPolicy';
/** This policy provides the Amazon VPC CNI Plugin (amazon-vpc-cni-k8s) the permissions it requires to modify the IP address configuration on your EKS worker nodes. This permission set allows the CNI to list, describe, and modify Elastic Network Interfaces on your behalf. More information on the AWS VPC CNI Plugin is available here: https://github.com/aws/amazon-vpc-cni-k8s */
AwsManagedPolicy.AmazonEKSCNIPolicy = 'AmazonEKS_CNI_Policy';
/** Policy attached to the EKS Cluster Role that grants permissions to manage the cluster's block storage resources. */
AwsManagedPolicy.AmazonEKSBlockStoragePolicy = 'AmazonEKSBlockStoragePolicy';
/** This policy provides Kubernetes the permissions it requires to manage resources on your behalf. Kubernetes requires Ec2:CreateTags permissions to place identifying information on EC2 resources including but not limited to Instances, Security Groups, and Elastic Network Interfaces. */
AwsManagedPolicy.AmazonEKSClusterPolicy = 'AmazonEKSClusterPolicy';
/** Policy attached to the EKS Cluster Role that grants permissions to manage the cluster's compute resources. */
AwsManagedPolicy.AmazonEKSComputePolicy = 'AmazonEKSComputePolicy';
/** This policy allows Amazon EKS to manage AWS resources for EKS connector */
AwsManagedPolicy.AmazonEKSConnectorServiceRolePolicy = 'aws-service-role/AmazonEKSConnectorServiceRolePolicy';
/** Provides read only access to view the dashboard in the Amazon EKS console. The dashboard aggregates information about multiple clusters and related resources using AWS Organizations. */
AwsManagedPolicy.AmazonEKSDashboardConsoleReadOnly = 'AmazonEKSDashboardConsoleReadOnly';
/** This policy enables the Amazon EKS Dashboard to access and display organization-wide information. The policy allows the EKS Dashboard service to gather information about your AWS Organizations structure and accounts. */
AwsManagedPolicy.AmazonEKSDashboardServiceRolePolicy = 'aws-service-role/AmazonEKSDashboardServiceRolePolicy';
/** Provides access to other AWS service resources that are required to run Amazon EKS pods on AWS Fargate */
AwsManagedPolicy.AmazonEKSFargatePodExecutionRolePolicy = 'AmazonEKSFargatePodExecutionRolePolicy';
/** This policy grants necessary permissions to Amazon EKS to run fargate tasks */
AwsManagedPolicy.AmazonEKSForFargateServiceRolePolicy = 'aws-service-role/AmazonEKSForFargateServiceRolePolicy';
/** Policy attached to the EKS Cluster Role that grants permissions to manage the cluster's load balancing resources. */
AwsManagedPolicy.AmazonEKSLoadBalancingPolicy = 'AmazonEKSLoadBalancingPolicy';
/** This policy provides permissions to EKS local cluster's control-plane instances running in your account to manage resources on your behalf. */
AwsManagedPolicy.AmazonEKSLocalOutpostClusterPolicy = 'AmazonEKSLocalOutpostClusterPolicy';
/** Allows Amazon EKS Local to call AWS services on your behalf. */
AwsManagedPolicy.AmazonEKSLocalOutpostServiceRolePolicy = 'aws-service-role/AmazonEKSLocalOutpostServiceRolePolicy';
/** Policy attached to the EKS Cluster Role that grants permissions to manage the cluster's networking resources. */
AwsManagedPolicy.AmazonEKSNetworkingPolicy = 'AmazonEKSNetworkingPolicy';
/** This policy allows Amazon Elastic Container Service for Kubernetes to create and manage the necessary resources to operate EKS Clusters. */
AwsManagedPolicy.AmazonEKSServicePolicy = 'AmazonEKSServicePolicy';
/** A Service-Linked Role required for Amazon EKS to call AWS services on your behalf. */
AwsManagedPolicy.AmazonEKSServiceRolePolicy = 'aws-service-role/AmazonEKSServiceRolePolicy';
/** Policy used by VPC Resource Controller to manage ENI and IPs for worker nodes. */
AwsManagedPolicy.AmazonEKSVPCResourceController = 'AmazonEKSVPCResourceController';
/** This policy allows Amazon EKS worker nodes to connect to Amazon EKS Clusters. */
AwsManagedPolicy.AmazonEKSWorkerNodeMinimalPolicy = 'AmazonEKSWorkerNodeMinimalPolicy';
/** This policy allows Amazon EKS worker nodes to connect to Amazon EKS Clusters. */
AwsManagedPolicy.AmazonEKSWorkerNodePolicy = 'AmazonEKSWorkerNodePolicy';
/** Provides full access to Amazon ElastiCache via the AWS Management Console. */
AwsManagedPolicy.AmazonElastiCacheFullAccess = 'AmazonElastiCacheFullAccess';
/** Provides read only access to Amazon ElastiCache via the AWS Management Console. */
AwsManagedPolicy.AmazonElastiCacheReadOnlyAccess = 'AmazonElastiCacheReadOnlyAccess';
/** Provides administrative access to Amazon ECR Public resources */
AwsManagedPolicy.AmazonElasticContainerRegistryPublicFullAccess = 'AmazonElasticContainerRegistryPublicFullAccess';
/** Provides full access to Amazon ECR Public repositories, but does not allow repository deletion or policy changes. */
AwsManagedPolicy.AmazonElasticContainerRegistryPublicPowerUser = 'AmazonElasticContainerRegistryPublicPowerUser';
/** Provides read-only access to Amazon ECR Public repositories. */
AwsManagedPolicy.AmazonElasticContainerRegistryPublicReadOnly = 'AmazonElasticContainerRegistryPublicReadOnly';
/** Provides root client access to an Amazon EFS file system */
AwsManagedPolicy.AmazonElasticFileSystemClientFullAccess = 'AmazonElasticFileSystemClientFullAccess';
/** Provides read only client access to an Amazon EFS file system */
AwsManagedPolicy.AmazonElasticFileSystemClientReadOnlyAccess = 'AmazonElasticFileSystemClientReadOnlyAccess';
/** Provides read and write client access to an Amazon EFS file system */
AwsManagedPolicy.AmazonElasticFileSystemClientReadWriteAccess = 'AmazonElasticFileSystemClientReadWriteAccess';
/** Provides full access to Amazon EFS via the AWS Management Console. */
AwsManagedPolicy.AmazonElasticFileSystemFullAccess = 'AmazonElasticFileSystemFullAccess';
/** Provides read only access to Amazon EFS via the AWS Management Console. */
AwsManagedPolicy.AmazonElasticFileSystemReadOnlyAccess = 'AmazonElasticFileSystemReadOnlyAccess';
/** Allows Amazon Elastic File System to manage AWS resources on your behalf */
AwsManagedPolicy.AmazonElasticFileSystemServiceRolePolicy = 'aws-service-role/AmazonElasticFileSystemServiceRolePolicy';
/** Allows customers to use AWS Systems Manager to automatically manage Amazon EFS utilities (amazon-efs-utils) package on their EC2 instances, and use CloudWatchLog to get EFS file system mount success/failure notifications. */
AwsManagedPolicy.AmazonElasticFileSystemsUtils = 'AmazonElasticFileSystemsUtils';
/** Default policy for the Amazon Elastic MapReduce Editors service role. */
AwsManagedPolicy.AmazonElasticMapReduceEditorsRole = 'service-role/AmazonElasticMapReduceEditorsRole';
/** Amazon Elastic MapReduce for Auto Scaling. Role to allow Auto Scaling to add and remove instances from your EMR cluster. */
AwsManagedPolicy.AmazonElasticMapReduceforAutoScalingRole = 'service-role/AmazonElasticMapReduceforAutoScalingRole';
/** Default policy for the Amazon Elastic MapReduce for EC2 service role. */
AwsManagedPolicy.AmazonElasticMapReduceforEC2Role = 'service-role/AmazonElasticMapReduceforEC2Role';
/** This policy is on a deprecation path. See documentation for guidance: https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-iam-policies.html. Provides full access to Amazon Elastic MapReduce and underlying services that it requires such as EC2 and S3 */
AwsManagedPolicy.AmazonElasticMapReduceFullAccess = 'AmazonElasticMapReduceFullAccess';
/** Policy to allow EMR to create, describe and delete EC2 placement groups. */
AwsManagedPolicy.AmazonElasticMapReducePlacementGroupPolicy = 'AmazonElasticMapReducePlacementGroupPolicy';
/** Provides read only access to Amazon Elastic MapReduce via the AWS Management Console. */
AwsManagedPolicy.AmazonElasticMapReduceReadOnlyAccess = 'AmazonElasticMapReduceReadOnlyAccess';
/** This policy is on a deprecation path. See documentation for guidance: https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-iam-policies.html.  Default policy for the Amazon Elastic MapReduce service role. */
AwsManagedPolicy.AmazonElasticMapReduceRole = 'service-role/AmazonElasticMapReduceRole';
/** Allow Amazon Elasticsearch Service to access other AWS services such as EC2 Networking APIs on your behalf. */
AwsManagedPolicy.AmazonElasticsearchServiceRolePolicy = 'aws-service-role/AmazonElasticsearchServiceRolePolicy';
/** Grants users full access to Elastic Transcoder and the access to associated services that is required for full Elastic Transcoder functionality. */
AwsManagedPolicy.AmazonElasticTranscoderFullAccess = 'AmazonElasticTranscoder_FullAccess';
/** Grants users permission to change presets, submit jobs, and view Elastic Transcoder settings. This policy also grants some read-only access to some other services required to use the Elastic Transcode console, including S3, IAM, and SNS. */
AwsManagedPolicy.AmazonElasticTranscoderJobsSubmitter = 'AmazonElasticTranscoder_JobsSubmitter';
/** Grants users read-only access to Elastic Transcoder and list access to related services. */
AwsManagedPolicy.AmazonElasticTranscoderReadOnlyAccess = 'AmazonElasticTranscoder_ReadOnlyAccess';
/** Default policy for the Amazon Elastic Transcoder service role. */
AwsManagedPolicy.AmazonElasticTranscoderRole = 'service-role/AmazonElasticTranscoderRole';
/** Allows the actions that EMR requires to terminate and delete AWS EC2 resources if the EMR Service role has lost that ability. */
AwsManagedPolicy.AmazonEMRCleanupPolicy = 'aws-service-role/AmazonEMRCleanupPolicy';
/** Allows access to other AWS service resources that are required to run Amazon EMR */
AwsManagedPolicy.AmazonEMRContainersServiceRolePolicy = 'aws-service-role/AmazonEMRContainersServiceRolePolicy';
/** Provides full access to Amazon EMR */
AwsManagedPolicy.AmazonEMRFullAccessPolicyV2 = 'AmazonEMRFullAccessPolicy_v2';
/** Provides read only access to Amazon EMR and the associated CloudWatch Metrics. */
AwsManagedPolicy.AmazonEMRReadOnlyAccessPolicyV2 = 'AmazonEMRReadOnlyAccessPolicy_v2';
/** Allows access to other AWS service resources that are required to run Amazon EMRServerless */
AwsManagedPolicy.AmazonEMRServerlessServiceRolePolicy = 'aws-service-role/AmazonEMRServerlessServiceRolePolicy';
/** This policy is used for the Amazon EMR Service Role and should NOT be used for any other IAM users or roles in your account. The policy grants permissions to create and manage resources associated with EMR and related services necessary for the operation of your EMR cluster. */
AwsManagedPolicy.AmazonEMRServicePolicyV2 = 'service-role/AmazonEMRServicePolicy_v2';
/** Provides limited access to the Amazon Cognito configuration service. */
AwsManagedPolicy.AmazonESCognitoAccess = 'AmazonESCognitoAccess';
/** Provides full access to the Amazon ES configuration service. */
AwsManagedPolicy.AmazonESFullAccess = 'AmazonESFullAccess';
/** Provides read-only access to the Amazon ES configuration service. */
AwsManagedPolicy.AmazonESReadOnlyAccess = 'AmazonESReadOnlyAccess';
/** Allows EventBridge to access Secret Manager resources on your behalf. */
AwsManagedPolicy.AmazonEventBridgeApiDestinationsServiceRolePolicy = 'aws-service-role/AmazonEventBridgeApiDestinationsServiceRolePolicy';
/** Provides full access to Amazon EventBridge. */
AwsManagedPolicy.AmazonEventBridgeFullAccess = 'AmazonEventBridgeFullAccess';
/** Provides full access to Amazon EventBridge Pipes. */
AwsManagedPolicy.AmazonEventBridgePipesFullAccess = 'AmazonEventBridgePipesFullAccess';
/** Provides read-only and operator (ability to Stop and Start running Pipes) access to Amazon EventBridge Pipes. */
AwsManagedPolicy.AmazonEventBridgePipesOperatorAccess = 'AmazonEventBridgePipesOperatorAccess';
/** Provides read-only access to Amazon EventBridge Pipes. */
AwsManagedPolicy.AmazonEventBridgePipesReadOnlyAccess = 'AmazonEventBridgePipesReadOnlyAccess';
/** Provides read only access to Amazon EventBridge. */
AwsManagedPolicy.AmazonEventBridgeReadOnlyAccess = 'AmazonEventBridgeReadOnlyAccess';
/** The AmazonEventBridgeSchedulerFullAccess managed policy grants permissions to use all EventBridge Scheduler actions for schedules, and schedule groups. */
AwsManagedPolicy.AmazonEventBridgeSchedulerFullAccess = 'AmazonEventBridgeSchedulerFullAccess';
/** The AmazonEventBridgeSchedulerReadOnlyAccess managed policy grants read-only permissions to view details about your schedules and schedule groups */
AwsManagedPolicy.AmazonEventBridgeSchedulerReadOnlyAccess = 'AmazonEventBridgeSchedulerReadOnlyAccess';
/** Provides full access to Amazon EventBridge Schemas. */
AwsManagedPolicy.AmazonEventBridgeSchemasFullAccess = 'AmazonEventBridgeSchemasFullAccess';
/** Provides read only access to Amazon EventBridge Schemas. */
AwsManagedPolicy.AmazonEventBridgeSchemasReadOnlyAccess = 'AmazonEventBridgeSchemasReadOnlyAccess';
/** Grants permissions to Managed Rules created by Amazon EventBridge schemas. */
AwsManagedPolicy.AmazonEventBridgeSchemasServiceRolePolicy = 'aws-service-role/AmazonEventBridgeSchemasServiceRolePolicy';
/** Grants permissions to EVS to manage resources on your behalf */
AwsManagedPolicy.AmazonEVSServiceRolePolicy = 'aws-service-role/AmazonEVSServiceRolePolicy';
/** Policy to enable AWS FIS to manage monitoring and resource selection for experiments. */
AwsManagedPolicy.AmazonFISServiceRolePolicy = 'aws-service-role/AmazonFISServiceRolePolicy';
/** Gives access to all actions for Amazon Forecast */
AwsManagedPolicy.AmazonForecastFullAccess = 'AmazonForecastFullAccess';
/** Gives access to all actions for Amazon Fraud Detector */
AwsManagedPolicy.AmazonFraudDetectorFullAccessPolicy = 'AmazonFraudDetectorFullAccessPolicy';
/** Full Access Policy for Amazon FreeRTOS */
AwsManagedPolicy.AmazonFreeRTOSFullAccess = 'AmazonFreeRTOSFullAccess';
/** Allows user to access Amazon FreeRTOS OTA Update */
AwsManagedPolicy.AmazonFreeRTOSOTAUpdate = 'service-role/AmazonFreeRTOSOTAUpdate';
/** Provides full access to Amazon FSx and access to related AWS services via the AWS Management Console. */
AwsManagedPolicy.AmazonFSxConsoleFullAccess = 'AmazonFSxConsoleFullAccess';
/** Provides read only access to Amazon FSx and access to related AWS services via the AWS Management Console. */
AwsManagedPolicy.AmazonFSxConsoleReadOnlyAccess = 'AmazonFSxConsoleReadOnlyAccess';
/** Provides full access to Amazon FSx and access to related AWS services. */
AwsManagedPolicy.AmazonFSxFullAccess = 'AmazonFSxFullAccess';
/** Provides read only access to Amazon FSx. */
AwsManagedPolicy.AmazonFSxReadOnlyAccess = 'AmazonFSxReadOnlyAccess';
/** Allows Amazon FSx to manage AWS resources on your behalf */
AwsManagedPolicy.AmazonFSxServiceRolePolicy = 'aws-service-role/AmazonFSxServiceRolePolicy';
/** Provides full access to Amazon Glacier via the AWS Management Console. */
AwsManagedPolicy.AmazonGlacierFullAccess = 'AmazonGlacierFullAccess';
/** Provides read only access to Amazon Glacier via the AWS Management Console. */
AwsManagedPolicy.AmazonGlacierReadOnlyAccess = 'AmazonGlacierReadOnlyAccess';
/** This policy grants access to Amazon Athena and the dependencies needed to enable querying and writing results to s3 from the Amazon Athena plugin in Amazon Grafana. */
AwsManagedPolicy.AmazonGrafanaAthenaAccess = 'service-role/AmazonGrafanaAthenaAccess';
/** This policy grants access to Amazon CloudWatch and the dependencies needed to use CloudWatch as a datasource within Amazon Managed Grafana. */
AwsManagedPolicy.AmazonGrafanaCloudWatchAccess = 'service-role/AmazonGrafanaCloudWatchAccess';
/** This policy grants scoped access to Amazon Redshift and the dependencies needed to use the Amazon Redshift plugin in Amazon Grafana. */
AwsManagedPolicy.AmazonGrafanaRedshiftAccess = 'service-role/AmazonGrafanaRedshiftAccess';
/** Provides access to AWS Resources managed or used by Amazon Grafana. */
AwsManagedPolicy.AmazonGrafanaServiceLinkedRolePolicy = 'aws-service-role/AmazonGrafanaServiceLinkedRolePolicy';
/** Provides full access to use Amazon GuardDuty. */
AwsManagedPolicy.AmazonGuardDutyFullAccess = 'AmazonGuardDutyFullAccess';
/** Provides full access to use Amazon GuardDuty */
AwsManagedPolicy.AmazonGuardDutyFullAccessV2 = 'AmazonGuardDutyFullAccess_v2';
/** GuardDuty malware protection uses the service-linked role (SLR) named AWSServiceRoleForAmazonGuardDutyMalwareProtection. This service-linked role allows GuardDuty malware protection to perform agent-less scans to detect malware. It allows GuardDuty to create snapshots in your account, and share the snapshots with the GuardDuty service account to scan for malware. It evaluates these shared snapshots and includes the retrieved EC2 instance metadata in the GuardDuty Malware Protection findings. The AWSServiceRoleForAmazonGuardDutyMalwareProtection service-linked role trusts the malware-protection.guardduty.amazonaws.com service to assume the role. */
AwsManagedPolicy.AmazonGuardDutyMalwareProtectionServiceRolePolicy = 'aws-service-role/AmazonGuardDutyMalwareProtectionServiceRolePolicy';
/** Provides read only access to Amazon GuardDuty resources */
AwsManagedPolicy.AmazonGuardDutyReadOnlyAccess = 'AmazonGuardDutyReadOnlyAccess';
/** Enable access to AWS Resources used or managed by Amazon Guard Duty */
AwsManagedPolicy.AmazonGuardDutyServiceRolePolicy = 'aws-service-role/AmazonGuardDutyServiceRolePolicy';
/** Provides full access to Amazon HealthLake service. */
AwsManagedPolicy.AmazonHealthLakeFullAccess = 'AmazonHealthLakeFullAccess';
/** Provides read only access to Amazon HealthLake service. */
AwsManagedPolicy.AmazonHealthLakeReadOnlyAccess = 'AmazonHealthLakeReadOnlyAccess';
/** Provides full access to Honeycode via the AWS Management Console and the SDK. */
AwsManagedPolicy.AmazonHoneycodeFullAccess = 'AmazonHoneycodeFullAccess';
/** Provides read only access to Honeycode via the AWS Management Console and the SDK. */
AwsManagedPolicy.AmazonHoneycodeReadOnlyAccess = 'AmazonHoneycodeReadOnlyAccess';
/** A service-linked role required for Amazon Honeycode to access your resources. */
AwsManagedPolicy.AmazonHoneycodeServiceRolePolicy = 'aws-service-role/AmazonHoneycodeServiceRolePolicy';
/** Provides full access to Honeycode Team Association via the AWS Management Console and the SDK. */
AwsManagedPolicy.AmazonHoneycodeTeamAssociationFullAccess = 'AmazonHoneycodeTeamAssociationFullAccess';
/** Provides read only access to Honeycode Team Association via the AWS Management Console and the SDK. */
AwsManagedPolicy.AmazonHoneycodeTeamAssociationReadOnlyAccess = 'AmazonHoneycodeTeamAssociationReadOnlyAccess';
/** Provides full access to Honeycode Workbook via the AWS Management Console and the SDK. */
AwsManagedPolicy.AmazonHoneycodeWorkbookFullAccess = 'AmazonHoneycodeWorkbookFullAccess';
/** Provides read only access to Honeycode Workbook via the AWS Management Console and the SDK. */
AwsManagedPolicy.AmazonHoneycodeWorkbookReadOnlyAccess = 'AmazonHoneycodeWorkbookReadOnlyAccess';
/** Grants Amazon Inspector access to AWS Services needed to perform agent-less security assessments */
AwsManagedPolicy.AmazonInspector2AgentlessServiceRolePolicy = 'aws-service-role/AmazonInspector2AgentlessServiceRolePolicy';
/** Provides full access to Amazon Inspector and access to other related services such as organizations. */
AwsManagedPolicy.AmazonInspector2FullAccess = 'AmazonInspector2FullAccess';
/** Provides full access to Amazon Inspector and access to other related services such as organizations with restrictive organizational access. */
AwsManagedPolicy.AmazonInspector2FullAccessV2 = 'AmazonInspector2FullAccess_v2';
/** This is a managed policy that customer should attach to their roles to communicate with inspector service for CIS scans */
AwsManagedPolicy.AmazonInspector2ManagedCisPolicy = 'AmazonInspector2ManagedCisPolicy';
/** Provides read only access to the Amazon inspector2 service and relevant support services */
AwsManagedPolicy.AmazonInspector2ReadOnlyAccess = 'AmazonInspector2ReadOnlyAccess';
/** Grants Amazon Inspector access to AWS Services needed to perform security assessments */
AwsManagedPolicy.AmazonInspector2ServiceRolePolicy = 'aws-service-role/AmazonInspector2ServiceRolePolicy';
/** Provides full access to Amazon Inspector. */
AwsManagedPolicy.AmazonInspectorFullAccess = 'AmazonInspectorFullAccess';
/** Provides read only access to Amazon Inspector. */
AwsManagedPolicy.AmazonInspectorReadOnlyAccess = 'AmazonInspectorReadOnlyAccess';
/** Grants Amazon Inspector access to AWS Services needed to perform security assessments */
AwsManagedPolicy.AmazonInspectorServiceRolePolicy = 'aws-service-role/AmazonInspectorServiceRolePolicy';
/** Provides full access to Amazon Kendra via the AWS Management Console. */
AwsManagedPolicy.AmazonKendraFullAccess = 'AmazonKendraFullAccess';
/** Provides read only access to Amazon Kendra via the AWS Management Console. */
AwsManagedPolicy.AmazonKendraReadOnlyAccess = 'AmazonKendraReadOnlyAccess';
/** Provide full access to Amazon Keyspaces */
AwsManagedPolicy.AmazonKeyspacesFullAccess = 'AmazonKeyspacesFullAccess';
/** Provide read only access to Amazon Keyspaces */
AwsManagedPolicy.AmazonKeyspacesReadOnlyAccess = 'AmazonKeyspacesReadOnlyAccess';
/** Provide read only access to Amazon Keyspaces and related AWS services. */
AwsManagedPolicy.AmazonKeyspacesReadOnlyAccessV2 = 'AmazonKeyspacesReadOnlyAccess_v2';
/** Provides full access to Amazon Kinesis Analytics via the AWS Management Console. */
AwsManagedPolicy.AmazonKinesisAnalyticsFullAccess = 'AmazonKinesisAnalyticsFullAccess';
/** Provides read-only access to Amazon Kinesis Analytics via the AWS Management Console. */
AwsManagedPolicy.AmazonKinesisAnalyticsReadOnly = 'AmazonKinesisAnalyticsReadOnly';
/** Provides full access to all Amazon Kinesis Firehose Delivery Streams. */
AwsManagedPolicy.AmazonKinesisFirehoseFullAccess = 'AmazonKinesisFirehoseFullAccess';
/** Provides read only access to all Amazon Kinesis Firehose Delivery Streams. */
AwsManagedPolicy.AmazonKinesisFirehoseReadOnlyAccess = 'AmazonKinesisFirehoseReadOnlyAccess';
/** Provides full access to all streams via the AWS Management Console. */
AwsManagedPolicy.AmazonKinesisFullAccess = 'AmazonKinesisFullAccess';
/** Provides read only access to all streams via the AWS Management Console. */
AwsManagedPolicy.AmazonKinesisReadOnlyAccess = 'AmazonKinesisReadOnlyAccess';
/** Provides full access to Amazon Kinesis Video Streams via the AWS Management Console. */
AwsManagedPolicy.AmazonKinesisVideoStreamsFullAccess = 'AmazonKinesisVideoStreamsFullAccess';
/** Provides read only access to AWS Kinesis Video Streams via the AWS Management Console. */
AwsManagedPolicy.AmazonKinesisVideoStreamsReadOnlyAccess = 'AmazonKinesisVideoStreamsReadOnlyAccess';
/** Full access to AWS Launch wizard and other required services. */
AwsManagedPolicy.AmazonLaunchWizardFullAccessV2 = 'AmazonLaunchWizardFullAccessV2';
/** This policy allows customers to call Lex runtime from channels */
AwsManagedPolicy.AmazonLexChannelsAccess = 'aws-service-role/AmazonLexChannelsAccess';
/** Provides full access to Amazon Lex via the AWS Management Console.  Also provides access to create Lex Service Linked Roles and grant Lex permissions to invoke a limited set of Lambda functions. */
AwsManagedPolicy.AmazonLexFullAccess = 'AmazonLexFullAccess';
/** Provides read-only access to Amazon Lex. */
AwsManagedPolicy.AmazonLexReadOnly = 'AmazonLexReadOnly';
/** Allows Amazon Lex to replicate Lex resources across regions on your behalf. */
AwsManagedPolicy.AmazonLexReplicationPolicy = 'aws-service-role/AmazonLexReplicationPolicy';
/** Provides access to Amazon Lex conversational APIs. */
AwsManagedPolicy.AmazonLexRunBotsOnly = 'AmazonLexRunBotsOnly';
/** Provides Lex V2 bots access to call other AWS services on your behalf. */
AwsManagedPolicy.AmazonLexV2BotPolicy = 'aws-service-role/AmazonLexV2BotPolicy';
/** Provides full access to Amazon Lookout for Equipment operations */
AwsManagedPolicy.AmazonLookoutEquipmentFullAccess = 'AmazonLookoutEquipmentFullAccess';
/** Provides read only access to Amazon Lookout for Equipments */
AwsManagedPolicy.AmazonLookoutEquipmentReadOnlyAccess = 'AmazonLookoutEquipmentReadOnlyAccess';
/** Gives access to all actions for Amazon Lookout for Metrics */
AwsManagedPolicy.AmazonLookoutMetricsFullAccess = 'AmazonLookoutMetricsFullAccess';
/** Gives access to all read-only actions for Amazon Lookout for Metrics */
AwsManagedPolicy.AmazonLookoutMetricsReadOnlyAccess = 'AmazonLookoutMetricsReadOnlyAccess';
/** Provides full access to Amazon Lookout for Vision and scoped access to required service and console dependencies. */
AwsManagedPolicy.AmazonLookoutVisionConsoleFullAccess = 'AmazonLookoutVisionConsoleFullAccess';
/** Provides read only access to Amazon Lookout for Vision and scoped access to required service and console dependencies. */
AwsManagedPolicy.AmazonLookoutVisionConsoleReadOnlyAccess = 'AmazonLookoutVisionConsoleReadOnlyAccess';
/** Provides full access to Amazon Lookout for Vision and scoped access to required dependencies. */
AwsManagedPolicy.AmazonLookoutVisionFullAccess = 'AmazonLookoutVisionFullAccess';
/** Provides read only access to Amazon Lookout for Vision and scoped access to required dependencies. */
AwsManagedPolicy.AmazonLookoutVisionReadOnlyAccess = 'AmazonLookoutVisionReadOnlyAccess';
/** Grants users permission to request Amazon Machine Learning batch predictions. */
AwsManagedPolicy.AmazonMachineLearningBatchPredictionsAccess = 'AmazonMachineLearningBatchPredictionsAccess';
/** Provides create access for non-prediction Amazon Machine Learning resources. */
AwsManagedPolicy.AmazonMachineLearningCreateOnlyAccess = 'AmazonMachineLearningCreateOnlyAccess';
/** Provides full access to Amazon Machine Learning resources. */
AwsManagedPolicy.AmazonMachineLearningFullAccess = 'AmazonMachineLearningFullAccess';
/** Grants users permission to create and delete the real-time endpoint for Amazon Machine Learning models. */
AwsManagedPolicy.AmazonMachineLearningManageRealTimeEndpointOnlyAccess = 'AmazonMachineLearningManageRealTimeEndpointOnlyAccess';
/** Provides read only access to Amazon Machine Learning resources. */
AwsManagedPolicy.AmazonMachineLearningReadOnlyAccess = 'AmazonMachineLearningReadOnlyAccess';
/** Grants users permission to request Amazon Machine Learning real-time predictions. */
AwsManagedPolicy.AmazonMachineLearningRealTimePredictionOnlyAccess = 'AmazonMachineLearningRealTimePredictionOnlyAccess';
/** Allows Machine Learning to configure and use your Redshift Clusters and S3 Staging Locations for Redshift Data Source. */
AwsManagedPolicy.AmazonMachineLearningRoleforRedshiftDataSourceV3 = 'service-role/AmazonMachineLearningRoleforRedshiftDataSourceV3';
/** Provides full access to Amazon Macie. */
AwsManagedPolicy.AmazonMacieFullAccess = 'AmazonMacieFullAccess';
/** Grants permission to create the service-linked role of Amazon Macie. */
AwsManagedPolicy.AmazonMacieHandshakeRole = 'service-role/AmazonMacieHandshakeRole';
/** Provides readonly access to Amazon Macie. */
AwsManagedPolicy.AmazonMacieReadOnlyAccess = 'AmazonMacieReadOnlyAccess';
/** Grants Macie read-only access to resource dependencies in your account in order to enable data analysis. */
AwsManagedPolicy.AmazonMacieServiceRole = 'service-role/AmazonMacieServiceRole';
/** Service linked role for Amazon Macie */
AwsManagedPolicy.AmazonMacieServiceRolePolicy = 'aws-service-role/AmazonMacieServiceRolePolicy';
/** Provides full access to Amazon Managed Blockchain via the AWS Management Console */
AwsManagedPolicy.AmazonManagedBlockchainConsoleFullAccess = 'AmazonManagedBlockchainConsoleFullAccess';
/** Provides full access to Amazon Managed Blockchain. */
AwsManagedPolicy.AmazonManagedBlockchainFullAccess = 'AmazonManagedBlockchainFullAccess';
/** Provides read-only access to Amazon Managed Blockchain. */
AwsManagedPolicy.AmazonManagedBlockchainReadOnlyAccess = 'AmazonManagedBlockchainReadOnlyAccess';
/** Enables access to AWS Services and Resources used or managed by Amazon Managed Blockchain */
AwsManagedPolicy.AmazonManagedBlockchainServiceRolePolicy = 'aws-service-role/AmazonManagedBlockchainServiceRolePolicy';
/** Provide full access to Amazon Managed Apache Cassandra Service */
AwsManagedPolicy.AmazonMCSFullAccess = 'AmazonMCSFullAccess';
/** Provide read only access to Amazon Managed Apache Cassandra Service */
AwsManagedPolicy.AmazonMCSReadOnlyAccess = 'AmazonMCSReadOnlyAccess';
/** Provides full access to all APIs in Amazon Mechanical Turk. */
AwsManagedPolicy.AmazonMechanicalTurkFullAccess = 'AmazonMechanicalTurkFullAccess';
/** Provides access to read only APIs in Amazon Mechanical Turk. */
AwsManagedPolicy.AmazonMechanicalTurkReadOnly = 'AmazonMechanicalTurkReadOnly';
/** Provides full access to Amazon MemoryDB via the AWS Management Console. */
AwsManagedPolicy.AmazonMemoryDBFullAccess = 'AmazonMemoryDBFullAccess';
/** Provides read only access to Amazon MemoryDB via the AWS Management Console. */
AwsManagedPolicy.AmazonMemoryDBReadOnlyAccess = 'AmazonMemoryDBReadOnlyAccess';
/** Provides read only access to all reports including financial data for all application resources. */
AwsManagedPolicy.AmazonMobileAnalyticsFinancialReportAccess = 'AmazonMobileAnalyticsFinancialReportAccess';
/** Provides full access to all application resources. */
AwsManagedPolicy.AmazonMobileAnalyticsFullAccess = 'AmazonMobileAnalyticsFullAccess';
/** Provides read only access to non financial reports for all application resources. */
AwsManagedPolicy.AmazonMobileAnalyticsNonFinancialReportAccess = 'AmazonMobileAnalyticsNon-financialReportAccess';
/** Provides write only access to put event data for all application resources. (Recommended for SDK integration) */
AwsManagedPolicy.AmazonMobileAnalyticsWriteOnlyAccess = 'AmazonMobileAnalyticsWriteOnlyAccess';
/** Provides full access to manage Amazon Monitron */
AwsManagedPolicy.AmazonMonitronFullAccess = 'AmazonMonitronFullAccess';
/** Provides full access to AmazonMQ via our API/SDK. */
AwsManagedPolicy.AmazonMQApiFullAccess = 'AmazonMQApiFullAccess';
/** Provides read only access to AmazonMQ via our API/SDK. */
AwsManagedPolicy.AmazonMQApiReadOnlyAccess = 'AmazonMQApiReadOnlyAccess';
/** Provides full access to AmazonMQ via the AWS Management Console. */
AwsManagedPolicy.AmazonMQFullAccess = 'AmazonMQFullAccess';
/** Provides read only access to AmazonMQ via the AWS Management Console. */
AwsManagedPolicy.AmazonMQReadOnlyAccess = 'AmazonMQReadOnlyAccess';
/** Service Linked Role Policy for AWS Amazon MQ */
AwsManagedPolicy.AmazonMQServiceRolePolicy = 'aws-service-role/AmazonMQServiceRolePolicy';
/** Provide readonly access to Amazon MSK Connect */
AwsManagedPolicy.AmazonMSKConnectReadOnlyAccess = 'AmazonMSKConnectReadOnlyAccess';
/** Provide full access to Amazon MSK and other required permissions for its dependencies. */
AwsManagedPolicy.AmazonMSKFullAccess = 'AmazonMSKFullAccess';
/** Provide readonly access to Amazon MSK */
AwsManagedPolicy.AmazonMSKReadOnlyAccess = 'AmazonMSKReadOnlyAccess';
/** The Service Linked Role used by Amazon Managed Workflows for Apache Airflow. */
AwsManagedPolicy.AmazonMWAAServiceRolePolicy = 'aws-service-role/AmazonMWAAServiceRolePolicy';
/** This policy grants access to resources needed by Nimble Studio Launch Profile workers. Attach this policy to EC2 instances created by Nimble Studio Builder. */
AwsManagedPolicy.AmazonNimbleStudioLaunchProfileWorker = 'AmazonNimbleStudio-LaunchProfileWorker';
/** This policy grants access to Amazon Nimble Studio resources associated with the studio admin and related studio resources in other services. Attach this policy to the Admin role associated with your studio. */
AwsManagedPolicy.AmazonNimbleStudioStudioAdmin = 'AmazonNimbleStudio-StudioAdmin';
/** This policy grants access to Amazon Nimble Studio resources associated with the studio user and related studio resources in other services. Attach this policy to the User role associated with your studio. */
AwsManagedPolicy.AmazonNimbleStudioStudioUser = 'AmazonNimbleStudio-StudioUser';
/** Allows Oracle Database@AWS to manage AWS resources on your behalf. */
AwsManagedPolicy.AmazonODBServiceRolePolicy = 'aws-service-role/AmazonODBServiceRolePolicy';
/** Provides full access to Amazon Omics and other required AWS Services. This policy allows the user to view and accept RAM share invitations to access resources outside of the user's AWS account. */
AwsManagedPolicy.AmazonOmicsFullAccess = 'AmazonOmicsFullAccess';
/** Provide read only access to Amazon Omics */
AwsManagedPolicy.AmazonOmicsReadOnlyAccess = 'AmazonOmicsReadOnlyAccess';
/** This policy grants administrative permissions that allow access to all Amazon One Enterprise resources and operations. */
AwsManagedPolicy.AmazonOneEnterpriseFullAccess = 'AmazonOneEnterpriseFullAccess';
/** This policy grants limited read and write permissions that allow device installation and activation. */
AwsManagedPolicy.AmazonOneEnterpriseInstallerAccess = 'AmazonOneEnterpriseInstallerAccess';
/** This policy grants read only permissions to all Amazon One Enterprise resources and operations. */
AwsManagedPolicy.AmazonOneEnterpriseReadOnlyAccess = 'AmazonOneEnterpriseReadOnlyAccess';
/** Provides access to Amazon OpenSearch Dashboards Service to access other AWS services such as CloudWatch on your behalf */
AwsManagedPolicy.AmazonOpenSearchDashboardsServiceRolePolicy = 'aws-service-role/AmazonOpenSearchDashboardsServiceRolePolicy';
/** Allows OpenSearch DirectQuery Service to access AWS Glue APIs for creating resources on your behalf. */
AwsManagedPolicy.AmazonOpenSearchDirectQueryGlueCreateAccess = 'AmazonOpenSearchDirectQueryGlueCreateAccess';
/** Allows Amazon OpenSearch Ingestion to access other AWS services on your behalf. */
AwsManagedPolicy.AmazonOpenSearchIngestionFullAccess = 'AmazonOpenSearchIngestionFullAccess';
/** Provides read only access to the Amazon OpenSearch Ingestion Service */
AwsManagedPolicy.AmazonOpenSearchIngestionReadOnlyAccess = 'AmazonOpenSearchIngestionReadOnlyAccess';
/** Allows Amazon OpenSearch Ingestion Service to access other AWS services on your behalf. */
AwsManagedPolicy.AmazonOpenSearchIngestionServiceRolePolicy = 'aws-service-role/AmazonOpenSearchIngestionServiceRolePolicy';
/** Allow Amazon OpenSearch Serverless to access other AWS services such as CloudWatch APIs on your behalf. */
AwsManagedPolicy.AmazonOpenSearchServerlessServiceRolePolicy = 'aws-service-role/AmazonOpenSearchServerlessServiceRolePolicy';
/** Provides access to the Amazon Cognito configuration service. */
AwsManagedPolicy.AmazonOpenSearchServiceCognitoAccess = 'AmazonOpenSearchServiceCognitoAccess';
/** Provides full access to the Amazon OpenSearch Service configuration service. */
AwsManagedPolicy.AmazonOpenSearchServiceFullAccess = 'AmazonOpenSearchServiceFullAccess';
/** Provides read-only access to the Amazon OpenSearch Service configuration service. */
AwsManagedPolicy.AmazonOpenSearchServiceReadOnlyAccess = 'AmazonOpenSearchServiceReadOnlyAccess';
/** Allow Amazon OpenSearch Service to access other AWS services such as EC2 Networking APIs on your behalf. */
AwsManagedPolicy.AmazonOpenSearchServiceRolePolicy = 'aws-service-role/AmazonOpenSearchServiceRolePolicy';
/** Provides full access to Amazon Personalize via the AWS Management Console and SDK. Also provides select access to related services (e.g., S3, CloudWatch). */
AwsManagedPolicy.AmazonPersonalizeFullAccess = 'service-role/AmazonPersonalizeFullAccess';
/** Grants full access to Amazon Polly service and resources. */
AwsManagedPolicy.AmazonPollyFullAccess = 'AmazonPollyFullAccess';
/** Grants read-only access to Amazon Polly resources. */
AwsManagedPolicy.AmazonPollyReadOnlyAccess = 'AmazonPollyReadOnlyAccess';
/** Grants full access to AWS Managed Prometheus resources in the AWS console */
AwsManagedPolicy.AmazonPrometheusConsoleFullAccess = 'AmazonPrometheusConsoleFullAccess';
/** Grants full access to AWS Managed Prometheus resources */
AwsManagedPolicy.AmazonPrometheusFullAccess = 'AmazonPrometheusFullAccess';
/** Grants access to run queries against AWS Managed Prometheus resources */
AwsManagedPolicy.AmazonPrometheusQueryAccess = 'AmazonPrometheusQueryAccess';
/** Grants write only access to AWS Managed Prometheus workspaces */
AwsManagedPolicy.AmazonPrometheusRemoteWriteAccess = 'AmazonPrometheusRemoteWriteAccess';
/** Provides access to AWS Resources managed or used by Amazon Managed Service for Prometheus Collector */
AwsManagedPolicy.AmazonPrometheusScraperServiceRolePolicy = 'aws-service-role/AmazonPrometheusScraperServiceRolePolicy';
/** Provides developer access to enable interactions with Amazon Q */
AwsManagedPolicy.AmazonQDeveloperAccess = 'AmazonQDeveloperAccess';
/** Provides full access to enable interactions with Amazon Q */
AwsManagedPolicy.AmazonQFullAccess = 'AmazonQFullAccess';
/** Provides full access to Amazon QLDB via the AWS Management Console. */
AwsManagedPolicy.AmazonQLDBConsoleFullAccess = 'AmazonQLDBConsoleFullAccess';
/** Provides full access to Amazon QLDB via the service API. */
AwsManagedPolicy.AmazonQLDBFullAccess = 'AmazonQLDBFullAccess';
/** Provides read only access to Amazon QLDB. */
AwsManagedPolicy.AmazonQLDBReadOnly = 'AmazonQLDBReadOnly';
/** Allows Amazon RDS to manage AWS resources on your behalf. */
AwsManagedPolicy.AmazonRDSBetaServiceRolePolicy = 'aws-service-role/AmazonRDSBetaServiceRolePolicy';
/** Allows Amazon RDS Custom to perform various automation actions and database management tasks through an EC2 instance profile. */
AwsManagedPolicy.AmazonRDSCustomInstanceProfileRolePolicy = 'AmazonRDSCustomInstanceProfileRolePolicy';
/** Amazon RDS Custom Preview Service Role Policy */
AwsManagedPolicy.AmazonRDSCustomPreviewServiceRolePolicy = 'aws-service-role/AmazonRDSCustomPreviewServiceRolePolicy';
/** Allows Amazon RDS Custom to manage AWS resources on your behalf. */
AwsManagedPolicy.AmazonRDSCustomServiceRolePolicy = 'aws-service-role/AmazonRDSCustomServiceRolePolicy';
/** Allows full access to use the RDS data APIs, secret store APIs for RDS database credentials, and DB console query management APIs to execute SQL statements on Aurora Serverless clusters in the AWS account. */
AwsManagedPolicy.AmazonRDSDataFullAccess = 'AmazonRDSDataFullAccess';
/** Allow RDS to access Directory Service Managed AD on behalf of the customer for domain-joined SQL Server DB instances. */
AwsManagedPolicy.AmazonRDSDirectoryServiceAccess = 'service-role/AmazonRDSDirectoryServiceAccess';
/** Provides access to Cloudwatch for RDS Enhanced Monitoring */
AwsManagedPolicy.AmazonRDSEnhancedMonitoringRole = 'service-role/AmazonRDSEnhancedMonitoringRole';
/** Provides full access to Amazon RDS via the AWS Management Console. */
AwsManagedPolicy.AmazonRDSFullAccess = 'AmazonRDSFullAccess';
/** Provides full access to RDS Performance Insights via the AWS Management Console */
AwsManagedPolicy.AmazonRDSPerformanceInsightsFullAccess = 'AmazonRDSPerformanceInsightsFullAccess';
/** Read-Only policy for RDS Performance Insights */
AwsManagedPolicy.AmazonRDSPerformanceInsightsReadOnly = 'AmazonRDSPerformanceInsightsReadOnly';
/** Amazon RDS Preview Service Role Policy */
AwsManagedPolicy.AmazonRDSPreviewServiceRolePolicy = 'aws-service-role/AmazonRDSPreviewServiceRolePolicy';
/** Provides read only access to Amazon RDS via the AWS Management Console. */
AwsManagedPolicy.AmazonRDSReadOnlyAccess = 'AmazonRDSReadOnlyAccess';
/** Allows Amazon RDS to manage AWS resources on your behalf. */
AwsManagedPolicy.AmazonRDSServiceRolePolicy = 'aws-service-role/AmazonRDSServiceRolePolicy';
/** This policy includes permissions to run SQL commands to copy, load, unload, query, and analyze data on Amazon Redshift. The policy also grants permissions to run select statements for related services, such as Amazon S3, Amazon CloudWatch logs, Amazon SageMaker, or AWS Glue. */
AwsManagedPolicy.AmazonRedshiftAllCommandsFullAccess = 'AmazonRedshiftAllCommandsFullAccess';
/** This policy provides full access to Amazon Redshift Data APIs. This policy also grants scoped access to other required services. */
AwsManagedPolicy.AmazonRedshiftDataFullAccess = 'AmazonRedshiftDataFullAccess';
/** Provides full access to Amazon Redshift via the AWS Management Console. */
AwsManagedPolicy.AmazonRedshiftFullAccess = 'AmazonRedshiftFullAccess';
/** Provides full access to the Amazon Redshift Query Editor and to saved queries via the AWS Management Console. */
AwsManagedPolicy.AmazonRedshiftQueryEditor = 'AmazonRedshiftQueryEditor';
/** Grants full access to the Amazon Redshift Query Editor V2 operations and resources. This policy also grants access to other required services. This includes permissions to list the Amazon Redshift clusters, read keys and aliases in AWS KMS and manage the Query Editor V2 secrets in AWS Secrets Manager. */
AwsManagedPolicy.AmazonRedshiftQueryEditorV2FullAccess = 'AmazonRedshiftQueryEditorV2FullAccess';
/** Grants the ability to work with Amazon Redshift Query Editor V2 without sharing resources. The granted principal can only read, update and delete its own resources but cannot share them. This policy also grants access to other required services. This includes permissions to list the Amazon Redshift clusters and manage the Query Editor V2 secrets of the principal in AWS Secrets Manager. */
AwsManagedPolicy.AmazonRedshiftQueryEditorV2NoSharing = 'AmazonRedshiftQueryEditorV2NoSharing';
/** Grants the ability to work with Amazon Redshift Query Editor V2 with limited sharing of resources. The granted principal can read, write and share its own resources. The granted principal can read the resources shared with its team but cannot update them. This policy also grants access to other required services. This includes permissions to list the Amazon Redshift clusters and manage the Query Editor V2 secrets of the principal in AWS Secrets Manager. */
AwsManagedPolicy.AmazonRedshiftQueryEditorV2ReadSharing = 'AmazonRedshiftQueryEditorV2ReadSharing';
/** Grants the ability to work with Amazon Redshift Query Editor V2 with sharing of resources. The granted principal can read, write and share its own resources. The granted principal can read and update the resources shared with its team. This policy also grants access to other required services. This includes permissions to list the Amazon Redshift clusters and manage the Query Editor V2 secrets of the principal in AWS Secrets Manager. */
AwsManagedPolicy.AmazonRedshiftQueryEditorV2ReadWriteSharing = 'AmazonRedshiftQueryEditorV2ReadWriteSharing';
/** Provides read only access to Amazon Redshift via the AWS Management Console. */
AwsManagedPolicy.AmazonRedshiftReadOnlyAccess = 'AmazonRedshiftReadOnlyAccess';
/** Allows Amazon Redshift to call AWS services on your behalf */
AwsManagedPolicy.AmazonRedshiftServiceLinkedRolePolicy = 'aws-service-role/AmazonRedshiftServiceLinkedRolePolicy';
/** This policy specifies rekognition and s3 permissions required by Amazon Rekognition Custom Labels feature. */
AwsManagedPolicy.AmazonRekognitionCustomLabelsFullAccess = 'AmazonRekognitionCustomLabelsFullAccess';
/** Access to all Amazon Rekognition APIs */
AwsManagedPolicy.AmazonRekognitionFullAccess = 'AmazonRekognitionFullAccess';
/** Access to all Read rekognition APIs */
AwsManagedPolicy.AmazonRekognitionReadOnlyAccess = 'AmazonRekognitionReadOnlyAccess';
/** Allows Rekognition to call AWS services on your behalf. */
AwsManagedPolicy.AmazonRekognitionServiceRole = 'service-role/AmazonRekognitionServiceRole';
/** Provides full access to all Route 53 Auto Naming actions. */
AwsManagedPolicy.AmazonRoute53AutoNamingFullAccess = 'AmazonRoute53AutoNamingFullAccess';
/** Provides read-only access to all Route 53 Auto Naming actions. */
AwsManagedPolicy.AmazonRoute53AutoNamingReadOnlyAccess = 'AmazonRoute53AutoNamingReadOnlyAccess';
/** Provides registrant level access to Route 53 Auto Naming actions. */
AwsManagedPolicy.AmazonRoute53AutoNamingRegistrantAccess = 'AmazonRoute53AutoNamingRegistrantAccess';
/** Provides full access to all Route53 Domains actions and Create Hosted Zone to allow Hosted Zone creation as part of domain registrations. */
AwsManagedPolicy.AmazonRoute53DomainsFullAccess = 'AmazonRoute53DomainsFullAccess';
/** Provides access to Route53 Domains list and actions. */
AwsManagedPolicy.AmazonRoute53DomainsReadOnlyAccess = 'AmazonRoute53DomainsReadOnlyAccess';
/** Provides full access to all Amazon Route 53 via the AWS Management Console. */
AwsManagedPolicy.AmazonRoute53FullAccess = 'AmazonRoute53FullAccess';
/** This policy grants full access to Amazon Route 53 Profile resources. */
AwsManagedPolicy.AmazonRoute53ProfilesFullAccess = 'AmazonRoute53ProfilesFullAccess';
/** This policy grants read-only access to Amazon Route 53 Profile resources. */
AwsManagedPolicy.AmazonRoute53ProfilesReadOnlyAccess = 'AmazonRoute53ProfilesReadOnlyAccess';
/** Provides read only access to all Amazon Route 53 via the AWS Management Console. */
AwsManagedPolicy.AmazonRoute53ReadOnlyAccess = 'AmazonRoute53ReadOnlyAccess';
/** Provides full access to Amazon Route 53 Recovery Cluster */
AwsManagedPolicy.AmazonRoute53RecoveryClusterFullAccess = 'AmazonRoute53RecoveryClusterFullAccess';
/** Provides read only access to Amazon Route 53 Recovery Cluster */
AwsManagedPolicy.AmazonRoute53RecoveryClusterReadOnlyAccess = 'AmazonRoute53RecoveryClusterReadOnlyAccess';
/** Provides full access to Amazon Route 53 Recovery Control Config */
AwsManagedPolicy.AmazonRoute53RecoveryControlConfigFullAccess = 'AmazonRoute53RecoveryControlConfigFullAccess';
/** Provides read only access to Amazon Route 53 Recovery Control Config */
AwsManagedPolicy.AmazonRoute53RecoveryControlConfigReadOnlyAccess = 'AmazonRoute53RecoveryControlConfigReadOnlyAccess';
/** Provides full access to Amazon Route 53 Recovery Readiness */
AwsManagedPolicy.AmazonRoute53RecoveryReadinessFullAccess = 'AmazonRoute53RecoveryReadinessFullAccess';
/** Provides read only access to Amazon Route 53 Recovery Readiness */
AwsManagedPolicy.AmazonRoute53RecoveryReadinessReadOnlyAccess = 'AmazonRoute53RecoveryReadinessReadOnlyAccess';
/** Full access policy for Route 53 Resolver */
AwsManagedPolicy.AmazonRoute53ResolverFullAccess = 'AmazonRoute53ResolverFullAccess';
/** Read only policy for Route 53 Resolver */
AwsManagedPolicy.AmazonRoute53ResolverReadOnlyAccess = 'AmazonRoute53ResolverReadOnlyAccess';
/** Provides full access to all buckets via the AWS Management Console. */
AwsManagedPolicy.AmazonS3FullAccess = 'AmazonS3FullAccess';
/** Provides AWS Lambda functions permissions to interact with Amazon S3 Object Lambda. Also grants Lambda permissions to write to CloudWatch Logs. */
AwsManagedPolicy.AmazonS3ObjectLambdaExecutionRolePolicy = 'service-role/AmazonS3ObjectLambdaExecutionRolePolicy';
/** Provides full access to Amazon S3 on Outposts via the AWS Management Console. */
AwsManagedPolicy.AmazonS3OutpostsFullAccess = 'AmazonS3OutpostsFullAccess';
/** Provides read only access to Amazon S3 on Outposts via the AWS Management Console. */
AwsManagedPolicy.AmazonS3OutpostsReadOnlyAccess = 'AmazonS3OutpostsReadOnlyAccess';
/** Provides read only access to all buckets via the AWS Management Console. */
AwsManagedPolicy.AmazonS3ReadOnlyAccess = 'AmazonS3ReadOnlyAccess';
/** Provides full access to all S3 table buckets. */
AwsManagedPolicy.AmazonS3TablesFullAccess = 'AmazonS3TablesFullAccess';
/** This managed policy grants AWS Lake Formation permissions to act on all table buckets, namespaces, and tables within the account. */
AwsManagedPolicy.AmazonS3TablesLakeFormationServiceRole = 'service-role/AmazonS3TablesLakeFormationServiceRole';
/** Provides read only access to all S3 table buckets. */
AwsManagedPolicy.AmazonS3TablesReadOnlyAccess = 'AmazonS3TablesReadOnlyAccess';
/** Service role policy used by the AWS Service Catalog service to provision products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including CodePipeline, CodeBuild, CodeCommit, Glue, CloudFormation, etc,. */
AwsManagedPolicy.AmazonSageMakerAdminServiceCatalogProductsServiceRolePolicy = 'AmazonSageMakerAdmin-ServiceCatalogProductsServiceRolePolicy';
/** Provides permissions for Amazon SageMaker Canvas to use AI services to support ready to use AI solutions. This policy will add more mutating permissions for services as Amazon SageMaker Canvas adds support. */
AwsManagedPolicy.AmazonSageMakerCanvasAIServicesAccess = 'AmazonSageMakerCanvasAIServicesAccess';
/** This policy grants permissions to use Amazon Bedrock in SageMaker Canvas by providing access to downstream services such as S3. */
AwsManagedPolicy.AmazonSageMakerCanvasBedrockAccess = 'AmazonSageMakerCanvasBedrockAccess';
/** Provides full access to Amazon SageMaker resources and operations for data preparation in Canvas. The policy also provides select access to related services (e.g., S3, IAM, KMS, RDS, CloudWatch Logs, Redshift, Athena, Glue, EventBridge, Secrets Manager). This policy should be attached to the Amazon SageMaker Domain/User Profile execution role. */
AwsManagedPolicy.AmazonSageMakerCanvasDataPrepFullAccess = 'AmazonSageMakerCanvasDataPrepFullAccess';
/** Allows Amazon SageMaker Canvas to create, manage and view endpoint details for endpoints created through Canvas. Allows Amazon SageMaker Canvas to retrieve endpoint invocation metrics from CloudWatch. */
AwsManagedPolicy.AmazonSageMakerCanvasDirectDeployAccess = 'service-role/AmazonSageMakerCanvasDirectDeployAccess';
/** This policy grants permissions to Amazon EMR Serverless for services such as S3, used by Amazon SageMaker Canvas for large data processing. */
AwsManagedPolicy.AmazonSageMakerCanvasEMRServerlessExecutionRolePolicy = 'AmazonSageMakerCanvasEMRServerlessExecutionRolePolicy';
/** This policy grants permissions commonly needed to use SageMaker Canvas with Amazon Forecast. */
AwsManagedPolicy.AmazonSageMakerCanvasForecastAccess = 'service-role/AmazonSageMakerCanvasForecastAccess';
/** Provides full access to Amazon SageMaker Canvas resources and operations. The policy also provides select access to related services (e.g., S3, IAM, VPC, ECR, CloudWatch Logs, Redshift, Secrets Manager, and Forecast). This policy should be attached to the Amazon SageMaker Domain/User Profile execution role. */
AwsManagedPolicy.AmazonSageMakerCanvasFullAccess = 'AmazonSageMakerCanvasFullAccess';
/** Provides permissions for Amazon SageMaker Canvas to use the SageMaker Data Science Assistant service. The Data Science Assistant currently uses both Amazon SageMaker and Amazon Q Developer to process user prompts. */
AwsManagedPolicy.AmazonSageMakerCanvasSMDataScienceAssistantAccess = 'AmazonSageMakerCanvasSMDataScienceAssistantAccess';
/** This policy grants permissions commonly needed to use Amazon SageMaker Cluster. */
AwsManagedPolicy.AmazonSageMakerClusterInstanceRolePolicy = 'AmazonSageMakerClusterInstanceRolePolicy';
/** Managed policy for Service Linked Role for Amazon SageMaker Core Services */
AwsManagedPolicy.AmazonSageMakerCoreServiceRolePolicy = 'aws-service-role/AmazonSageMakerCoreServiceRolePolicy';
/** Provides permissions necessary for SageMaker Edge to create and manage a device fleet for the customer using the default cloud connection. */
AwsManagedPolicy.AmazonSageMakerEdgeDeviceFleetPolicy = 'service-role/AmazonSageMakerEdgeDeviceFleetPolicy';
/** Provides permissions required to enable the offline store for an Amazon SageMaker FeatureStore feature group. */
AwsManagedPolicy.AmazonSageMakerFeatureStoreAccess = 'AmazonSageMakerFeatureStoreAccess';
/** Provides full access to Amazon SageMaker via the AWS Management Console and SDK. Also provides select access to related services (e.g., S3, ECR, CloudWatch Logs). */
AwsManagedPolicy.AmazonSageMakerFullAccess = 'AmazonSageMakerFullAccess';
/** This policy provide access to services that are commonly needed to use SageMaker geospatial. */
AwsManagedPolicy.AmazonSageMakerGeospatialExecutionRole = 'service-role/AmazonSageMakerGeospatialExecutionRole';
/** This policy grants permissions that allow full access to Amazon SageMaker Geospatial through the AWS Management Console and SDK. */
AwsManagedPolicy.AmazonSageMakerGeospatialFullAccess = 'service-role/AmazonSageMakerGeospatialFullAccess';
/** Provides access to AWS services that are required to run SageMaker GroundTruth Labeling job */
AwsManagedPolicy.AmazonSageMakerGroundTruthExecution = 'AmazonSageMakerGroundTruthExecution';
/** This policy provides administrative privileges required for setting up SageMaker HyperPod observability. It enables access to Amazon Managed Prometheus, Amazon Managed Grafana and EKS Addons. The policy also includes broad access to Grafana HTTP APIs through ServiceAccountTokens across all Amazon Managed Grafana workspaces in your account. */
AwsManagedPolicy.AmazonSageMakerHyperPodObservabilityAdminAccess = 'AmazonSageMakerHyperPodObservabilityAdminAccess';
/** This policy grants permissions to Amazon SageMaker HyperPod to related AWS services such as Amazon EKS, Amazon CloudWatch etc. */
AwsManagedPolicy.AmazonSageMakerHyperPodServiceRolePolicy = 'aws-service-role/AmazonSageMakerHyperPodServiceRolePolicy';
/** This policy provides administrative permissions required to set up the SageMaker HyperPod training operator. It enables access to Amazon SageMaker HyperPod and EKS add-ons. The policy includes permissions to describe the SageMaker HyperPod resources in your account. */
AwsManagedPolicy.AmazonSageMakerHyperPodTrainingOperatorAccess = 'AmazonSageMakerHyperPodTrainingOperatorAccess';
/** Provides access to create Amazon Augmented AI FlowDefinition resources against any Workteam. */
AwsManagedPolicy.AmazonSageMakerMechanicalTurkAccess = 'AmazonSageMakerMechanicalTurkAccess';
/** This AWS managed policy grants permissions needed to use all Amazon SageMaker Governance features. The policy also provides select access to related services (e.g., S3, KMS). */
AwsManagedPolicy.AmazonSageMakerModelGovernanceUseAccess = 'AmazonSageMakerModelGovernanceUseAccess';
/** This is a new managed policy for Model Registry in Sagemaker. This policy is a standalone policy that can be attached to the user role to access Model Registry related functionalities in Sagemaker. */
AwsManagedPolicy.AmazonSageMakerModelRegistryFullAccess = 'AmazonSageMakerModelRegistryFullAccess';
/** Managed policy for Service Linked Role for Amazon SageMaker Notebooks */
AwsManagedPolicy.AmazonSageMakerNotebooksServiceRolePolicy = 'aws-service-role/AmazonSageMakerNotebooksServiceRolePolicy';
/** Enables Amazon SageMaker partner app users to access applications, list available applications, launch application web UIs, and connect via the application SDK. */
AwsManagedPolicy.AmazonSageMakerPartnerAppsFullAccess = 'AmazonSageMakerPartnerAppsFullAccess';
/** Service role policy used by the AWS APIGateway within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including Lambda and others. */
AwsManagedPolicy.AmazonSageMakerPartnerServiceCatalogProductsApiGatewayServiceRolePolicy = 'service-role/AmazonSageMakerPartnerServiceCatalogProductsApiGatewayServiceRolePolicy';
/** Service role policy used by the AWS CloudFormation within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including Lambda, APIGateway and others. */
AwsManagedPolicy.AmazonSageMakerPartnerServiceCatalogProductsCloudFormationServiceRolePolicy = 'service-role/AmazonSageMakerPartnerServiceCatalogProductsCloudFormationServiceRolePolicy';
/** Service role policy used by the AWS Lambda within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including Secrets Manager and others. */
AwsManagedPolicy.AmazonSageMakerPartnerServiceCatalogProductsLambdaServiceRolePolicy = 'service-role/AmazonSageMakerPartnerServiceCatalogProductsLambdaServiceRolePolicy';
/** This Amazon Managed Policy grants permissions commonly needed for use with Callback steps and Lambda steps in SageMaker Model Building Pipelines. It is added to the AmazonSageMaker-ExecutionRole that can be created when setting up SageMaker Studio. It can also be attached to any other role that will be used for authoring or executing pipelines. */
AwsManagedPolicy.AmazonSageMakerPipelinesIntegrations = 'AmazonSageMakerPipelinesIntegrations';
/** This policy will be used By SageMaker Unified Studios to create VPC related resources for QuickSight */
AwsManagedPolicy.AmazonSageMakerQuickSightVPCPolicy = 'service-role/AmazonSageMakerQuickSightVPCPolicy';
/** Provides read only access to Amazon SageMaker via the AWS Management Console and SDK. */
AwsManagedPolicy.AmazonSageMakerReadOnly = 'AmazonSageMakerReadOnly';
/** Service role policy used by the AWS APIGateway within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including CloudWatch Logs and others. */
AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsApiGatewayServiceRolePolicy = 'service-role/AmazonSageMakerServiceCatalogProductsApiGatewayServiceRolePolicy';
/** Service role policy used by the AWS CloudFormation within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including SageMaker and others. */
AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsCloudformationServiceRolePolicy = 'service-role/AmazonSageMakerServiceCatalogProductsCloudformationServiceRolePolicy';
/** Service role policy used by the AWS CodeBuild within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including CodePipeline, CodeBuild and others. */
AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsCodeBuildServiceRolePolicy = 'AmazonSageMakerServiceCatalogProductsCodeBuildServiceRolePolicy';
/** Service role policy used by the AWS CodePipeline within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including CodePipeline, CodeBuild and others. */
AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsCodePipelineServiceRolePolicy = 'service-role/AmazonSageMakerServiceCatalogProductsCodePipelineServiceRolePolicy';
/** Service role policy used by the AWS CloudWatch Events within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a subset of related services including CodePipeline and others. */
AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsEventsServiceRolePolicy = 'service-role/AmazonSageMakerServiceCatalogProductsEventsServiceRolePolicy';
/** Service role policy used by the AWS Firehose within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including Firehose and others. */
AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsFirehoseServiceRolePolicy = 'service-role/AmazonSageMakerServiceCatalogProductsFirehoseServiceRolePolicy';
/** Service role policy used by the AWS Glue within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including Glue, S3 and others. */
AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsGlueServiceRolePolicy = 'service-role/AmazonSageMakerServiceCatalogProductsGlueServiceRolePolicy';
/** Service role policy used by the AWS Lambda within the AWS ServiceCatalog provisioned products from Amazon SageMaker portfolio of products. Grants permissions to a set of related services including ECR, S3 and others. */
AwsManagedPolicy.AmazonSageMakerServiceCatalogProductsLambdaServiceRolePolicy = 'service-role/AmazonSageMakerServiceCatalogProductsLambdaServiceRolePolicy';
/** This Amazon Managed Policy provides the necessary permissions to create and manage SageMaker Training Plans. It allows users to create Training Plans and Reserved Capacities, describe existing Training Plans, and perform search and listing operations. */
AwsManagedPolicy.AmazonSageMakerTrainingPlanCreateAccess = 'AmazonSageMakerTrainingPlanCreateAccess';
/** Provides full access to Amazon Security Lake and related services needed to administer Security Lake. */
AwsManagedPolicy.AmazonSecurityLakeAdministrator = 'AmazonSecurityLakeAdministrator';
/** Policy for Amazon SecurityLake meta store manager lambda which allows the access to cloudwatch, S3, Glue and SQS. */
AwsManagedPolicy.AmazonSecurityLakeMetastoreManager = 'service-role/AmazonSecurityLakeMetastoreManager';
/** Amazon Security Lake creates IAM roles for third-party custom sources to write data to a data lake and for third-party subscribers to consume data from a data lake, and uses this policy when creating these roles to define the boundary of their permissions. */
AwsManagedPolicy.AmazonSecurityLakePermissionsBoundary = 'AmazonSecurityLakePermissionsBoundary';
/** Provides full access to Amazon SES via the AWS Management Console. */
AwsManagedPolicy.AmazonSESFullAccess = 'AmazonSESFullAccess';
/** Provides read only access to Amazon SES via the AWS Management Console. */
AwsManagedPolicy.AmazonSESReadOnlyAccess = 'AmazonSESReadOnlyAccess';
/** Allows SES to publish Amazon CloudWatch basic monitoring metrics on behalf of your SES resources */
AwsManagedPolicy.AmazonSESServiceRolePolicy = 'aws-service-role/AmazonSESServiceRolePolicy';
/** Provides full access to Amazon SNS via the AWS Management Console. */
AwsManagedPolicy.AmazonSNSFullAccess = 'AmazonSNSFullAccess';
/** Provides read only access to Amazon SNS via the AWS Management Console. */
AwsManagedPolicy.AmazonSNSReadOnlyAccess = 'AmazonSNSReadOnlyAccess';
/** Default policy for Amazon SNS service role. */
AwsManagedPolicy.AmazonSNSRole = 'service-role/AmazonSNSRole';
/** Provides full access to Amazon SQS via the AWS Management Console. */
AwsManagedPolicy.AmazonSQSFullAccess = 'AmazonSQSFullAccess';
/** Provides read only access to Amazon SQS via the AWS Management Console. */
AwsManagedPolicy.AmazonSQSReadOnlyAccess = 'AmazonSQSReadOnlyAccess';
/** Provides access to view automation executions and send approval decisions to automation waiting for approval */
AwsManagedPolicy.AmazonSSMAutomationApproverAccess = 'AmazonSSMAutomationApproverAccess';
/** Provides permissions for EC2 Automation service to execute activities defined within Automation documents */
AwsManagedPolicy.AmazonSSMAutomationRole = 'service-role/AmazonSSMAutomationRole';
/** This policy allows SSM Agent to access Directory Service on behalf of the customer for domain-join the managed instance. */
AwsManagedPolicy.AmazonSSMDirectoryServiceAccess = 'AmazonSSMDirectoryServiceAccess';
/** Provides full access to Amazon SSM. */
AwsManagedPolicy.AmazonSSMFullAccess = 'AmazonSSMFullAccess';
/**  Service Role to be used for EC2 Maintenance Window */
AwsManagedPolicy.AmazonSSMMaintenanceWindowRole = 'service-role/AmazonSSMMaintenanceWindowRole';
/** This policy enables AWS Systems Manager functionality on EC2 instances. */
AwsManagedPolicy.AmazonSSMManagedEC2InstanceDefaultPolicy = 'AmazonSSMManagedEC2InstanceDefaultPolicy';
/** The policy for Amazon EC2 Role to enable AWS Systems Manager service core functionality. */
AwsManagedPolicy.AmazonSSMManagedInstanceCore = 'AmazonSSMManagedInstanceCore';
/** Provide access to child instances for patch association operation. */
AwsManagedPolicy.AmazonSSMPatchAssociation = 'AmazonSSMPatchAssociation';
/** Provides read only access to Amazon SSM. */
AwsManagedPolicy.AmazonSSMReadOnlyAccess = 'AmazonSSMReadOnlyAccess';
/** Provides access to AWS Resources managed or used by Amazon SSM */
AwsManagedPolicy.AmazonSSMServiceRolePolicy = 'aws-service-role/AmazonSSMServiceRolePolicy';
/** Access to all Amazon Textract APIs */
AwsManagedPolicy.AmazonTextractFullAccess = 'AmazonTextractFullAccess';
/** Allows Textract to call AWS services on your behalf. */
AwsManagedPolicy.AmazonTextractServiceRole = 'service-role/AmazonTextractServiceRole';
/** Provides full access to manage Amazon Timestream using the AWS Management Console. Note that this policy also grants permissions for certain KMS operations, and operations to manage your saved queries. If using Customer managed CMK, please refer to documentation for additional permissions needed. */
AwsManagedPolicy.AmazonTimestreamConsoleFullAccess = 'AmazonTimestreamConsoleFullAccess';
/** Provides full access to Amazon Timestream. Note that this policy also grants certain KMS operation access. If using Customer managed CMK, please refer to documentation for additional permissions needed. */
AwsManagedPolicy.AmazonTimestreamFullAccess = 'AmazonTimestreamFullAccess';
/** Provides full administrative access to create, update, delete and list Amazon Timestream InfluxDB instances and create and list parameter groups. Please refer to documentation for additional permissions needed. */
AwsManagedPolicy.AmazonTimestreamInfluxDBFullAccess = 'AmazonTimestreamInfluxDBFullAccess';
/** Provides administrative access to manage Amazon Timestream InfluxDB instances and parameter groups except marketplace operations. */
AwsManagedPolicy.AmazonTimestreamInfluxDBFullAccessWithoutMarketplaceAccess = 'AmazonTimestreamInfluxDBFullAccessWithoutMarketplaceAccess';
/** Provides full administrative access to create, update, delete and list Amazon Timestream InfluxDB instances and create and list parameter groups. Please refer to documentation for additional permissions needed. */
AwsManagedPolicy.AmazonTimestreamInfluxDBServiceRolePolicy = 'aws-service-role/AmazonTimestreamInfluxDBServiceRolePolicy';
/** Provides read only access to Amazon Timestream. Policy also provides permission to cancel any running query. If using Customer managed CMK, please refer to documentation for additional permissions needed. */
AwsManagedPolicy.AmazonTimestreamReadOnlyAccess = 'AmazonTimestreamReadOnlyAccess';
/** Provides full access to Amazon Transcribe operations */
AwsManagedPolicy.AmazonTranscribeFullAccess = 'AmazonTranscribeFullAccess';
/** Provides access to read only operation for Amazon Transcribe */
AwsManagedPolicy.AmazonTranscribeReadOnlyAccess = 'AmazonTranscribeReadOnlyAccess';
/** Provides full access to Verified Permissions */
AwsManagedPolicy.AmazonVerifiedPermissionsFullAccess = 'AmazonVerifiedPermissionsFullAccess';
/** Provides read-only access to the Verified Permissions service. */
AwsManagedPolicy.AmazonVerifiedPermissionsReadOnlyAccess = 'AmazonVerifiedPermissionsReadOnlyAccess';
/** Provides access to create network interfaces and attach them to cross-account resources */
AwsManagedPolicy.AmazonVPCCrossAccountNetworkInterfaceOperations = 'AmazonVPCCrossAccountNetworkInterfaceOperations';
/** Provides full access to Amazon VPC via the AWS Management Console. */
AwsManagedPolicy.AmazonVPCFullAccess = 'AmazonVPCFullAccess';
/** Provides permissions to describe AWS resources, run Network Access Analyzer, and create or delete tags on Network Insights Access Scope and Network Insights Access Scope Analysis. */
AwsManagedPolicy.AmazonVPCNetworkAccessAnalyzerFullAccessPolicy = 'AmazonVPCNetworkAccessAnalyzerFullAccessPolicy';
/** Provides permissions to describe AWS resources, run Reachability Analyzer, and create or delete tags on Network Insights Path and Network Insights Analysis. */
AwsManagedPolicy.AmazonVPCReachabilityAnalyzerFullAccessPolicy = 'AmazonVPCReachabilityAnalyzerFullAccessPolicy';
/** This policy is attached to the role IAMRoleForReachabilityAnalyzerCrossAccountResourceAccess. This role is deployed to the member accounts in an organization when the management account enables trusted access for Reachability Analyzer. It provides permissions to view resources from across your organization using the Reachability Analyzer console. */
AwsManagedPolicy.AmazonVPCReachabilityAnalyzerPathComponentReadPolicy = 'AmazonVPCReachabilityAnalyzerPathComponentReadPolicy';
/** Provides read only access to Amazon VPC via the AWS Management Console. */
AwsManagedPolicy.AmazonVPCReadOnlyAccess = 'AmazonVPCReadOnlyAccess';
/** Provides full access to Amazon WorkDocs via the AWS Management Console */
AwsManagedPolicy.AmazonWorkDocsFullAccess = 'AmazonWorkDocsFullAccess';
/** Provides read only access to Amazon WorkDocs via the AWS Management Console */
AwsManagedPolicy.AmazonWorkDocsReadOnlyAccess = 'AmazonWorkDocsReadOnlyAccess';
/** Enables access to AWS Services and Resources used or managed by Amazon WorkMail Events */
AwsManagedPolicy.AmazonWorkMailEventsServiceRolePolicy = 'aws-service-role/AmazonWorkMailEventsServiceRolePolicy';
/** Provides full access to WorkMail, Directory Service, SES, EC2 and read access to KMS metadata. */
AwsManagedPolicy.AmazonWorkMailFullAccess = 'AmazonWorkMailFullAccess';
/** Full access to the WorkMail Message Flow APIs */
AwsManagedPolicy.AmazonWorkMailMessageFlowFullAccess = 'AmazonWorkMailMessageFlowFullAccess';
/** Read only access to WorkMail messages for the GetRawMessageContent API */
AwsManagedPolicy.AmazonWorkMailMessageFlowReadOnlyAccess = 'AmazonWorkMailMessageFlowReadOnlyAccess';
/** Provides read only access to WorkMail and SES. */
AwsManagedPolicy.AmazonWorkMailReadOnlyAccess = 'AmazonWorkMailReadOnlyAccess';
/** Provides access to Amazon WorkSpaces administrative actions via AWS SDK and CLI. */
AwsManagedPolicy.AmazonWorkSpacesAdmin = 'AmazonWorkSpacesAdmin';
/** Provides administrator access for packaging an application in Amazon WorkSpaces Application Manager. */
AwsManagedPolicy.AmazonWorkSpacesApplicationManagerAdminAccess = 'AmazonWorkSpacesApplicationManagerAdminAccess';
/** This managed policy provides full administrative access to AWS Certificate Manager Private CA resources in your AWS account for certificate-based authentication. */
AwsManagedPolicy.AmazonWorkspacesPCAAccess = 'AmazonWorkspacesPCAAccess';
/** This policy provides AWS WorkSpaces service access to required customer account resources for launching Workspaces Pools */
AwsManagedPolicy.AmazonWorkSpacesPoolServiceAccess = 'AmazonWorkSpacesPoolServiceAccess';
/** Provides read-only access to Amazon WorkSpaces Secure Browser and its dependencies through the AWS Management Console, SDK, and CLI. */
AwsManagedPolicy.AmazonWorkSpacesSecureBrowserReadOnly = 'AmazonWorkSpacesSecureBrowserReadOnly';
/** Provides access to Amazon WorkSpaces backend service to perform Workspace Self Service actions */
AwsManagedPolicy.AmazonWorkSpacesSelfServiceAccess = 'AmazonWorkSpacesSelfServiceAccess';
/** Provides customer account access to AWS WorkSpaces service for launching a Workspace. */
AwsManagedPolicy.AmazonWorkSpacesServiceAccess = 'AmazonWorkSpacesServiceAccess';
/** Provides full access to Amazon WorkSpaces Thin Client as well as limited access to required related services */
AwsManagedPolicy.AmazonWorkSpacesThinClientFullAccess = 'AmazonWorkSpacesThinClientFullAccess';
/** Enables access to AWS Services and Resources used or managed by Amazon WorkSpaces Thin Client Monitoring */
AwsManagedPolicy.AmazonWorkSpacesThinClientMonitoringServiceRolePolicy = 'aws-service-role/AmazonWorkSpacesThinClientMonitoringServiceRolePolicy';
/** Provides read-only access to Amazon WorkSpaces Thin Client and its dependencies */
AwsManagedPolicy.AmazonWorkSpacesThinClientReadOnlyAccess = 'AmazonWorkSpacesThinClientReadOnlyAccess';
/** Provides read-only access to Amazon WorkSpaces Web and its dependencies through the AWS Management Console, SDK, and CLI. */
AwsManagedPolicy.AmazonWorkSpacesWebReadOnly = 'AmazonWorkSpacesWebReadOnly';
/** Enables access to AWS Services and Resources used or managed by Amazon WorkSpaces Web */
AwsManagedPolicy.AmazonWorkSpacesWebServiceRolePolicy = 'aws-service-role/AmazonWorkSpacesWebServiceRolePolicy';
/** Provides full access to Amazon Zocalo. */
AwsManagedPolicy.AmazonZocaloFullAccess = 'AmazonZocaloFullAccess';
/** Provides read only access to Amazon Zocalo */
AwsManagedPolicy.AmazonZocaloReadOnlyAccess = 'AmazonZocaloReadOnlyAccess';
/** Provides Amplify full access permissions to deploy Amplify backend resources (AWS AppSync, Amazon Cognito, Amazon S3 and other related services) via the AWS Cloud Development Kit (AWS CDK) */
AwsManagedPolicy.AmplifyBackendDeployFullAccess = 'service-role/AmplifyBackendDeployFullAccess';
/** Allows API Gateway to manage associated AWS Resources on behalf of the customer. */
AwsManagedPolicy.APIGatewayServiceRolePolicy = 'aws-service-role/APIGatewayServiceRolePolicy';
/** Allows AppIntegrations to manage AppFlow resources and publish CloudWatch metric data on your behalf. */
AwsManagedPolicy.AppIntegrationsServiceLinkedRolePolicy = 'aws-service-role/AppIntegrationsServiceLinkedRolePolicy';
/** Policy to enable Application Autoscaling for Amazon AppStream */
AwsManagedPolicy.ApplicationAutoScalingForAmazonAppStreamAccess = 'service-role/ApplicationAutoScalingForAmazonAppStreamAccess';
/** Enables access to AWS Services and Resources used or managed by Application Discovery Service Continuous Export feature */
AwsManagedPolicy.ApplicationDiscoveryServiceContinuousExportServiceRolePolicy = 'aws-service-role/ApplicationDiscoveryServiceContinuousExportServiceRolePolicy';
/** Allows AWS AppRunner Networking to manage related AWS resources on your behalf. */
AwsManagedPolicy.AppRunnerNetworkingServiceRolePolicy = 'aws-service-role/AppRunnerNetworkingServiceRolePolicy';
/** Allows AWS AppRunner to manage related AWS resources on your behalf. */
AwsManagedPolicy.AppRunnerServiceRolePolicy = 'aws-service-role/AppRunnerServiceRolePolicy';
/** Allows AppStudio to manage associated AWS resources on your behalf. */
AwsManagedPolicy.AppStudioServiceRolePolicy = 'aws-service-role/AppStudioServiceRolePolicy';
/** Policy for Amazon Aurora DSQL Service Linked Role */
AwsManagedPolicy.AuroraDsqlServiceLinkedRolePolicy = 'aws-service-role/AuroraDsqlServiceLinkedRolePolicy';
/** Provides full access to Auto Scaling via the AWS Management Console. */
AwsManagedPolicy.AutoScalingConsoleFullAccess = 'AutoScalingConsoleFullAccess';
/** Provides read-only access to Auto Scaling via the AWS Management Console. */
AwsManagedPolicy.AutoScalingConsoleReadOnlyAccess = 'AutoScalingConsoleReadOnlyAccess';
/** Provides full access to Auto Scaling. */
AwsManagedPolicy.AutoScalingFullAccess = 'AutoScalingFullAccess';
/** Default policy for the AutoScaling Notification Access service role. */
AwsManagedPolicy.AutoScalingNotificationAccessRole = 'service-role/AutoScalingNotificationAccessRole';
/** Provides read-only access to Auto Scaling. */
AwsManagedPolicy.AutoScalingReadOnlyAccess = 'AutoScalingReadOnlyAccess';
/** Enables access to AWS Services and Resources used or managed by Auto Scaling */
AwsManagedPolicy.AutoScalingServiceRolePolicy = 'aws-service-role/AutoScalingServiceRolePolicy';
/** Default policy for AWS Config service role. Provides permissions required for AWS Config to track changes to your AWS resources. */
AwsManagedPolicy.AWSConfigRole = 'service-role/AWS_ConfigRole';
/** Provides permissions to access the SSM Diagnosis S3 bucket for diagnosis and remediation of issues. */
AwsManagedPolicy.AWSSSMAutomationDiagnosisBucketPolicy = 'AWS-SSM-Automation-DiagnosisBucketPolicy';
/** Provide permission for Diagnosing issues with SSM services by executing activities defined within Automation Documents, primarily used for running the Automation documents in a cross-account cross-region setup by triggering child automations within member accounts. */
AwsManagedPolicy.AWSSSMDiagnosisAutomationAdministrationRolePolicy = 'AWS-SSM-DiagnosisAutomation-AdministrationRolePolicy';
/** Provide permission for Diagnosing issues with SSM services by executing activities defined within Automation Documents, primarily used for running the Automation documents in a target account/region setup by diagnosing SSM service health across all nodes. */
AwsManagedPolicy.AWSSSMDiagnosisAutomationExecutionRolePolicy = 'AWS-SSM-DiagnosisAutomation-ExecutionRolePolicy';
/** Provides permissions for operational accounts to diagnose unmanaged nodes by providing Organisation specific permissions required by SSM automation to pull the list of member accounts within a root of an Organisation to trigger cross-account cross-region execution by allowing assuming Execution roles in target account/region. */
AwsManagedPolicy.AWSSSMDiagnosisAutomationOperationalAccountAdministrationRolePolicy = 'AWS-SSM-DiagnosisAutomation-OperationalAccountAdministrationRolePolicy';
/** Provide permission for Remediating issues with SSM services by executing activities defined within Automation Documents, primarily used for running the Automation documents in a cross-account cross-region setup by triggering child automations within member accounts. */
AwsManagedPolicy.AWSSSMRemediationAutomationAdministrationRolePolicy = 'AWS-SSM-RemediationAutomation-AdministrationRolePolicy';
/** Provides permissions for Remediating issues with SSM services by executing activities defined within Automation Documents, primarily used for running the Automation documents in a target account/region setup by remediating SSM services health across all nodes. */
AwsManagedPolicy.AWSSSMRemediationAutomationExecutionRolePolicy = 'AWS-SSM-RemediationAutomation-ExecutionRolePolicy';
/** Provides permissions for operational accounts to Remediate unmanaged nodes by providing Organisation specific permissions required by SSM automation to pull the list of member accounts within a root of an Organisation to trigger cross-account cross-region execution by allowing assuming Execution roles in target account/region. */
AwsManagedPolicy.AWSSSMRemediationAutomationOperationalAccountAdministrationRolePolicy = 'AWS-SSM-RemediationAutomation-OperationalAccountAdministrationRolePolicy';
/** Allows users to access the Account Activity page. */
AwsManagedPolicy.AWSAccountActivityAccess = 'AWSAccountActivityAccess';
/** Provides full access to AWS Account Management. */
AwsManagedPolicy.AWSAccountManagementFullAccess = 'AWSAccountManagementFullAccess';
/** Provides read-only access to AWS Account Management */
AwsManagedPolicy.AWSAccountManagementReadOnlyAccess = 'AWSAccountManagementReadOnlyAccess';
/** Allows users to access the Account Usage Report page. */
AwsManagedPolicy.AWSAccountUsageReportAccess = 'AWSAccountUsageReportAccess';
/** Provides access for the Discovery Agentless Connector to register with AWS Application Discovery Service. */
AwsManagedPolicy.AWSAgentlessDiscoveryService = 'AWSAgentlessDiscoveryService';
/** Provides full access to the AWS AppFabric service and read only access to dependent services such as S3, Kinesis, KMS. */
AwsManagedPolicy.AWSAppFabricFullAccess = 'AWSAppFabricFullAccess';
/** Provides read only access to the AWS AppFabric */
AwsManagedPolicy.AWSAppFabricReadOnlyAccess = 'AWSAppFabricReadOnlyAccess';
/** Provides AppFabric access to AWS resources on your behalf */
AwsManagedPolicy.AWSAppFabricServiceRolePolicy = 'aws-service-role/AWSAppFabricServiceRolePolicy';
/** Policy granting permissions to Application Auto Scaling to access AppStream and CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingAppStreamFleetPolicy = 'aws-service-role/AWSApplicationAutoscalingAppStreamFleetPolicy';
/** Policy granting permissions to Application Auto Scaling to access Cassandra and CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingCassandraTablePolicy = 'aws-service-role/AWSApplicationAutoscalingCassandraTablePolicy';
/** Policy granting permissions to Application Auto Scaling to access Comprehend and CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingComprehendEndpointPolicy = 'aws-service-role/AWSApplicationAutoscalingComprehendEndpointPolicy';
/** Policy granting permissions to Application Auto Scaling to access APIGateway and CloudWatch for custom resource scaling */
AwsManagedPolicy.AWSApplicationAutoScalingCustomResourcePolicy = 'aws-service-role/AWSApplicationAutoScalingCustomResourcePolicy';
/** Policy granting permissions to Application Auto Scaling to access DynamoDB and CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingDynamoDBTablePolicy = 'aws-service-role/AWSApplicationAutoscalingDynamoDBTablePolicy';
/** Policy granting permissions to Application Auto Scaling to access EC2 Spot Fleet and CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingEC2SpotFleetRequestPolicy = 'aws-service-role/AWSApplicationAutoscalingEC2SpotFleetRequestPolicy';
/** Policy granting permissions to Application Auto Scaling to access EC2 Container Service and CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingECSServicePolicy = 'aws-service-role/AWSApplicationAutoscalingECSServicePolicy';
/** Policy granting permissions to Application Auto Scaling to access Amazon ElastiCache and Amazon CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingElastiCacheRGPolicy = 'aws-service-role/AWSApplicationAutoscalingElastiCacheRGPolicy';
/** Policy granting permissions to Application Auto Scaling to access Elastic Map Reduce and CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingEMRInstanceGroupPolicy = 'aws-service-role/AWSApplicationAutoscalingEMRInstanceGroupPolicy';
/** Policy granting permissions to Application Auto Scaling to access Managed Streaming for Apache Kafka and CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingKafkaClusterPolicy = 'aws-service-role/AWSApplicationAutoscalingKafkaClusterPolicy';
/** Policy granting permissions to Application Auto Scaling to access Lambda and CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingLambdaConcurrencyPolicy = 'aws-service-role/AWSApplicationAutoscalingLambdaConcurrencyPolicy';
/** Policy granting permissions to Application Auto Scaling to access Amazon Neptune and Amazon CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingNeptuneClusterPolicy = 'aws-service-role/AWSApplicationAutoscalingNeptuneClusterPolicy';
/** Policy granting permissions to Application Auto Scaling to access RDS and CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingRDSClusterPolicy = 'aws-service-role/AWSApplicationAutoscalingRDSClusterPolicy';
/** Policy granting permissions to Application Auto Scaling to access SageMaker and CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingSageMakerEndpointPolicy = 'aws-service-role/AWSApplicationAutoscalingSageMakerEndpointPolicy';
/** Policy granting permissions to Application Auto Scaling to access Amazon WorkSpaces and Amazon CloudWatch. */
AwsManagedPolicy.AWSApplicationAutoscalingWorkSpacesPoolPolicy = 'aws-service-role/AWSApplicationAutoscalingWorkSpacesPoolPolicy';
/** Provides access for the Discovery Agent to register with AWS Application Discovery Service. */
AwsManagedPolicy.AWSApplicationDiscoveryAgentAccess = 'AWSApplicationDiscoveryAgentAccess';
/** Allows Application Discovery Service Agentless Collectors to auto update, register, and communicate with Application Discovery Service */
AwsManagedPolicy.AWSApplicationDiscoveryAgentlessCollectorAccess = 'AWSApplicationDiscoveryAgentlessCollectorAccess';
/** Provides full access to view and tag Configuration Items maintained by the AWS Application Discovery Service */
AwsManagedPolicy.AWSApplicationDiscoveryServiceFullAccess = 'AWSApplicationDiscoveryServiceFullAccess';
/** This policy allows installing the AWS Replication Agent, which is used with AWS Application Migration Service (MGN) to migrate external servers to AWS. Attach this policy to your IAM users or roles whose credentials you provide when installing the AWS Replication Agent. */
AwsManagedPolicy.AWSApplicationMigrationAgentInstallationPolicy = 'AWSApplicationMigrationAgentInstallationPolicy';
/** This policy allows installing and using the AWS Replication Agent, which is used with AWS Application Migration Service (MGN) to migrate external servers to AWS. Attach this policy to your IAM users or roles whose credentials you provide when installing the AWS Replication Agent. */
AwsManagedPolicy.AWSApplicationMigrationAgentPolicy = 'AWSApplicationMigrationAgentPolicy';
/** This policy allows using the AWS Replication Agent, which is used with AWS Application Migration Service (MGN) to migrate external servers to AWS. We do not recommend that you attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSApplicationMigrationAgentPolicyV2 = 'service-role/AWSApplicationMigrationAgentPolicy_v2';
/** This policy allows the Application Migration Service (MGN) Conversion Server, which are EC2 instances launched by Application Migration Service, to communicate with the MGN service. An IAM role with this policy is attached (as an EC2 Instance Profile) by MGN to the MGN Conversion Servers, which are automatically launched and terminated by MGN, when needed. We do not recommend that you attach this policy to your IAM users or roles. MGN Conversion Servers are used by Application Migration Service when users choose to launch Test or Cutover instances using the MGN console, CLI, or API. */
AwsManagedPolicy.AWSApplicationMigrationConversionServerPolicy = 'service-role/AWSApplicationMigrationConversionServerPolicy';
/** This policy provides Amazon EC2 operations required to use Application Migration Service (MGN) to launch the migrated servers as EC2 instances. Attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSApplicationMigrationEC2Access = 'AWSApplicationMigrationEC2Access';
/** This policy provides permissions to all public APIs of AWS Application Migration Service (MGN), as well as permissions to read KMS key information. Attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSApplicationMigrationFullAccess = 'AWSApplicationMigrationFullAccess';
/** This policy allows AWS Application Migration Service (MGN) to send meta-data about the progress of servers being migrated using MGN to AWS Migration Hub (MGH). MGN automatically creates an IAM role with this policy attached, and assumes this role. We do not recommend that you attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSApplicationMigrationMGHAccess = 'service-role/AWSApplicationMigrationMGHAccess';
/** This policy provides permissions to all read-only public APIs of Application Migration Service (MGN), as well as some read-only APIs of other AWS services that are required in order to make full read-only use of the MGN console. Attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSApplicationMigrationReadOnlyAccess = 'AWSApplicationMigrationReadOnlyAccess';
/** This policy allows the Application Migration Service (MGN) Replication Servers, which are EC2 instances launched by Application Migration Service - to communicate with the MGN service, and to create EBS snapshots in your AWS account. An IAM role with this policy is attached (as an EC2 Instance Profile) by Application Migration Service to the MGN Replication Servers which are automatically launched and terminated by MGN, as needed. MGN Replication Servers are used to facilitate data replication from your external servers to AWS, as part of the migration process managed using MGN. We do not recommend that you attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSApplicationMigrationReplicationServerPolicy = 'service-role/AWSApplicationMigrationReplicationServerPolicy';
/** This policy allows installing and using the AWS Replication Agent, which is used by AWS Application Migration Service (AWS MGN) to migrate source servers that run on EC2 (cross-Region or cross-AZ). An IAM role with this policy should be attached (as an EC2 Instance Profile) to the EC2 Instances. */
AwsManagedPolicy.AWSApplicationMigrationServiceEc2InstancePolicy = 'AWSApplicationMigrationServiceEc2InstancePolicy';
/** Allows AWS application Migration Service to create and manage AWS resources on your behalf. */
AwsManagedPolicy.AWSApplicationMigrationServiceRolePolicy = 'aws-service-role/AWSApplicationMigrationServiceRolePolicy';
/** This policy provides access to Amazon SSM operations required to use Application Migration Service (MGN) to execute custom post migration command SSM documents. Attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSApplicationMigrationSSMAccess = 'AWSApplicationMigrationSSMAccess';
/** This policy allows installing and using the AWS VCenter Client, which is used with AWS Application Migration Service (MGN) to migrate external servers to AWS. Attach this policy to your IAM users or roles whose credentials you provide when installing the AWS VCenter Client. */
AwsManagedPolicy.AWSApplicationMigrationVCenterClientPolicy = 'AWSApplicationMigrationVCenterClientPolicy';
/** App Mesh Envoy policy for accessing Virtual Node configuration. */
AwsManagedPolicy.AWSAppMeshEnvoyAccess = 'AWSAppMeshEnvoyAccess';
/** Provides full access to the AWS App Mesh APIs and Management Console. */
AwsManagedPolicy.AWSAppMeshFullAccess = 'AWSAppMeshFullAccess';
/** App Mesh Preview Envoy policy for accessing Virtual Node configuration. */
AwsManagedPolicy.AWSAppMeshPreviewEnvoyAccess = 'AWSAppMeshPreviewEnvoyAccess';
/** Enables access to AWS Services and Resources used or managed by AWS App Mesh */
AwsManagedPolicy.AWSAppMeshPreviewServiceRolePolicy = 'aws-service-role/AWSAppMeshPreviewServiceRolePolicy';
/** Provides read-only access to the AWS App Mesh APIs and Management Console. */
AwsManagedPolicy.AWSAppMeshReadOnly = 'AWSAppMeshReadOnly';
/** Enables access to AWS Services and Resources used or managed by AWS AppMesh */
AwsManagedPolicy.AWSAppMeshServiceRolePolicy = 'aws-service-role/AWSAppMeshServiceRolePolicy';
/** Grants permissions to all App Runner actions. */
AwsManagedPolicy.AWSAppRunnerFullAccess = 'AWSAppRunnerFullAccess';
/** Grants permissions to list and view details about App Runner resources. */
AwsManagedPolicy.AWSAppRunnerReadOnlyAccess = 'AWSAppRunnerReadOnlyAccess';
/** AWS App Runner service policy that grants read permissions to Amazon ECR resources in the customer's account. Use it in a role that is passed to App Runner when creating or updating an App Runner service. */
AwsManagedPolicy.AWSAppRunnerServicePolicyForECRAccess = 'service-role/AWSAppRunnerServicePolicyForECRAccess';
/** Provides administrative access to the AppSync service, though not enough to access via the console. */
AwsManagedPolicy.AWSAppSyncAdministrator = 'AWSAppSyncAdministrator';
/** Provides full invoking access to the AppSync service - both through the console and independently */
AwsManagedPolicy.AWSAppSyncInvokeFullAccess = 'AWSAppSyncInvokeFullAccess';
/** Allows AppSync to push logs to user's CloudWatch account. */
AwsManagedPolicy.AWSAppSyncPushToCloudWatchLogs = 'service-role/AWSAppSyncPushToCloudWatchLogs';
/** Provides access to create, update, and query the schema. */
AwsManagedPolicy.AWSAppSyncSchemaAuthor = 'AWSAppSyncSchemaAuthor';
/** Enables access to AWS services and resources used or managed by AppSync */
AwsManagedPolicy.AWSAppSyncServiceRolePolicy = 'aws-service-role/AWSAppSyncServiceRolePolicy';
/** Allows AWS Artifact read-only access to operations in AWS Organizations. */
AwsManagedPolicy.AWSArtifactAccountSync = 'service-role/AWSArtifactAccountSync';
/** This policy grants full permissions to list, download, accept, and terminate AWS Artifact agreements. It also includes permissions to list and enable AWS service access in the Organization service, as well as describe the organization details. Additionally, the policy provides the ability to check if the required service-linked role exists and creates one if it doesn't */
AwsManagedPolicy.AWSArtifactAgreementsFullAccess = 'AWSArtifactAgreementsFullAccess';
/** This policy grants read-only access to list the AWS Artifact service agreements and to download the accepted agreements.. It also includes permissions to list as well as describe the organization details. Additionally, the policy provides the ability to check if the required service-linked role exists. */
AwsManagedPolicy.AWSArtifactAgreementsReadOnlyAccess = 'AWSArtifactAgreementsReadOnlyAccess';
/** Provides read-only access to the AWS Artifact service reports. */
AwsManagedPolicy.AWSArtifactReportsReadOnlyAccess = 'AWSArtifactReportsReadOnlyAccess';
/** Allows AWS Artifact to gather information about an organization via AWS Organizations service. */
AwsManagedPolicy.AWSArtifactServiceRolePolicy = 'aws-service-role/AWSArtifactServiceRolePolicy';
/** Provides administrative access to enable or disable AWS Audit Manager, update settings, and manage assessments, controls, and frameworks */
AwsManagedPolicy.AWSAuditManagerAdministratorAccess = 'AWSAuditManagerAdministratorAccess';
/** Enables access to AWS Services and Resources used or managed by AWS Audit Manager */
AwsManagedPolicy.AWSAuditManagerServiceRolePolicy = 'aws-service-role/AWSAuditManagerServiceRolePolicy';
/** Policy granting permissions to AWS Auto Scaling to periodically forecast capacity and generate scheduled scaling actions for Auto Scaling groups in a scaling plan */
AwsManagedPolicy.AWSAutoScalingPlansEC2AutoScalingPolicy = 'aws-service-role/AWSAutoScalingPlansEC2AutoScalingPolicy';
/** This policy grants permissions for users to create controls and frameworks that define their expectations for AWS Backup resources and activities, and to audit AWS Backup resources and activities against their defined controls and frameworks. This policy grants permissions to AWS Config and similar services to describe user expectations perform the audits. This policy also grants permissions to deliver audit reports to S3 and similar services, and enables users to find and open their audit reports. */
AwsManagedPolicy.AWSBackupAuditAccess = 'AWSBackupAuditAccess';
/** This policy allows the AWS Backint agent to complete backup data transfer with AWS Backup Storage plane. Attach this policy to roles assumed by EC2 Instances running SAP HANA with the Backint agent. */
AwsManagedPolicy.AWSBackupDataTransferAccess = 'AWSBackupDataTransferAccess';
/** This policy is for backup administrators, granting full access to AWS Backup operations, including creating or editing backup plans, assigning AWS resources to backup plans, deleting backups, and restoring backups. */
AwsManagedPolicy.AWSBackupFullAccess = 'AWSBackupFullAccess';
/** Provides AWS BackupGateway permission to sync the metadata of Virtual Machines on your behalf */
AwsManagedPolicy.AWSBackupGatewayServiceRolePolicyForVirtualMachineMetadataSync = 'service-role/AWSBackupGatewayServiceRolePolicyForVirtualMachineMetadataSync';
/** This policy grants users permissions to assign AWS resources to backup plans, create on-demand backups, and restore backups. This policy does not allow the user to create or edit backup plans or to delete scheduled backups after they are created. */
AwsManagedPolicy.AWSBackupOperatorAccess = 'AWSBackupOperatorAccess';
/** This policy is for backup administators who use cross-account backup management to manage backups for the organization. */
AwsManagedPolicy.AWSBackupOrganizationAdminAccess = 'AWSBackupOrganizationAdminAccess';
/** Provides AWS Backup permission to restore a backup of SAP HANA on Amazon EC2 */
AwsManagedPolicy.AWSBackupRestoreAccessForSAPHANA = 'AWSBackupRestoreAccessForSAPHANA';
/** The search operator role has access to create backup indexes, create searches of backup metadata that has been indexed. This policy contains the necessary permissions for these search operator functions. */
AwsManagedPolicy.AWSBackupSearchOperatorAccess = 'AWSBackupSearchOperatorAccess';
/** Provides AWS Backup permission to create backups on your behalf across AWS services */
AwsManagedPolicy.AWSBackupServiceLinkedRolePolicyForBackup = 'aws-service-role/AWSBackupServiceLinkedRolePolicyForBackup';
/** Provides AWS Backup permission to create backups on your behalf across AWS services */
AwsManagedPolicy.AWSBackupServiceLinkedRolePolicyForBackupTest = 'aws-service-role/AWSBackupServiceLinkedRolePolicyForBackupTest';
/** Provides AWS Backup permission to create backups on your behalf across AWS services */
AwsManagedPolicy.AWSBackupServiceRolePolicyForBackup = 'service-role/AWSBackupServiceRolePolicyForBackup';
/** Policy containing permissions necessary for AWS Backup to index recovery points. */
AwsManagedPolicy.AWSBackupServiceRolePolicyForIndexing = 'AWSBackupServiceRolePolicyForIndexing';
/** Policy containing permissions necessary for AWS Backup to restore individual items in a recovery point */
AwsManagedPolicy.AWSBackupServiceRolePolicyForItemRestores = 'AWSBackupServiceRolePolicyForItemRestores';
/** Provides AWS Backup permission to perform restores on your behalf across AWS services. This policy includes permissions to create and delete AWS resources, such as EBS volumes, RDS instances, and EFS file systems, which are part of the restore process. */
AwsManagedPolicy.AWSBackupServiceRolePolicyForRestores = 'service-role/AWSBackupServiceRolePolicyForRestores';
/** Policy containing permissions necessary for AWS Backup to backup data in any S3 bucket. This includes read access to all S3 objects and any decrypt access for all KMS keys. */
AwsManagedPolicy.AWSBackupServiceRolePolicyForS3Backup = 'AWSBackupServiceRolePolicyForS3Backup';
/** Policy containing permissions necessary for AWS Backup to restore a S3 backup to a bucket. This includes read/write permissions to all S3 buckets, and permissions to GenerateDataKey and DescribeKey for all KMS keys. */
AwsManagedPolicy.AWSBackupServiceRolePolicyForS3Restore = 'AWSBackupServiceRolePolicyForS3Restore';
/** Provides full access for AWS Batch resources. */
AwsManagedPolicy.AWSBatchFullAccess = 'AWSBatchFullAccess';
/** Policy to enable CloudWatch Event Target for AWS Batch Job Submission */
AwsManagedPolicy.AWSBatchServiceEventTargetRole = 'service-role/AWSBatchServiceEventTargetRole';
/** Policy for AWS Batch service role which allows access to related services including EC2, Autoscaling, EC2 Container service and Cloudwatch Logs. */
AwsManagedPolicy.AWSBatchServiceRole = 'service-role/AWSBatchServiceRole';
/** Provides access for AWS Batch to queue and manage Amazon SageMaker workloads */
AwsManagedPolicy.AWSBatchServiceRolePolicyForSageMaker = 'aws-service-role/AWSBatchServiceRolePolicyForSageMaker';
/** A service linked role to provide Billing and Cost Management Data Exports access to AWS service data for exporting the data to a target location, such as Amazon S3, on behalf of a customer. */
AwsManagedPolicy.AWSBCMDataExportsServiceRolePolicy = 'aws-service-role/AWSBCMDataExportsServiceRolePolicy';
/** Use the AWSBillingConductorFullAccess managed policy to allow complete access to AWS Billing Conductor (ABC) console and APIs. This policy allows users to list, create and delete ABC resources. */
AwsManagedPolicy.AWSBillingConductorFullAccess = 'AWSBillingConductorFullAccess';
/** Use the AWSBillingConductorReadOnlyAccess managed policy to allow read only access to AWS Billing Conductor (ABC) console and APIs. This policy grants permission to view and list all ABC resources. It does not include the ability to create or delete resources. */
AwsManagedPolicy.AWSBillingConductorReadOnlyAccess = 'AWSBillingConductorReadOnlyAccess';
/** Allows users to view bills on the Billing Console. */
AwsManagedPolicy.AWSBillingReadOnlyAccess = 'AWSBillingReadOnlyAccess';
/** Allows billing service to validate access to billing view data for derived billing views */
AwsManagedPolicy.AWSBillingServiceRolePolicy = 'aws-service-role/AWSBillingServiceRolePolicy';
/** This policy gives permissions to control AWS resources. For example, to start and stop EC2 or RDS instances by executing AWS Systems Manager (SSM) scripts. */
AwsManagedPolicy.AWSBudgetsActionsRolePolicyForResourceAdministrationWithSSM = 'AWSBudgetsActions_RolePolicyForResourceAdministrationWithSSM';
/** Provides full access to AWS Budgets Actions including using Budgets Actions to control states of running AWS resources via AWS Management Console */
AwsManagedPolicy.AWSBudgetsActionsWithAWSResourceControlAccess = 'AWSBudgetsActionsWithAWSResourceControlAccess';
/** Provides read only access to AWS Budgets Console via the AWS Management Console. */
AwsManagedPolicy.AWSBudgetsReadOnlyAccess = 'AWSBudgetsReadOnlyAccess';
/** This IAM policy grants users full access to the AWS BugBust console */
AwsManagedPolicy.AWSBugBustFullAccess = 'AWSBugBustFullAccess';
/** This IAM policy grants users access to participate in AWS BugBust events */
AwsManagedPolicy.AWSBugBustPlayerAccess = 'AWSBugBustPlayerAccess';
/** Grants permissions to AWS BugBust to access resources on your behalf */
AwsManagedPolicy.AWSBugBustServiceRolePolicy = 'aws-service-role/AWSBugBustServiceRolePolicy';
/** Provides full access to AWS Certificate Manager (ACM) */
AwsManagedPolicy.AWSCertificateManagerFullAccess = 'AWSCertificateManagerFullAccess';
/** Provides auditor access to AWS Certificate Manager Private Certificate Authority */
AwsManagedPolicy.AWSCertificateManagerPrivateCAAuditor = 'AWSCertificateManagerPrivateCAAuditor';
/** Provides full access to AWS Certificate Manager Private Certificate Authority */
AwsManagedPolicy.AWSCertificateManagerPrivateCAFullAccess = 'AWSCertificateManagerPrivateCAFullAccess';
/** Provides privileged certificate user access to AWS Certificate Manager Private Certificate Authority */
AwsManagedPolicy.AWSCertificateManagerPrivateCAPrivilegedUser = 'AWSCertificateManagerPrivateCAPrivilegedUser';
/** Provides read only access to AWS Certificate Manager Private Certificate Authority */
AwsManagedPolicy.AWSCertificateManagerPrivateCAReadOnly = 'AWSCertificateManagerPrivateCAReadOnly';
/** Provides certificate user access to AWS Certificate Manager Private Certificate Authority */
AwsManagedPolicy.AWSCertificateManagerPrivateCAUser = 'AWSCertificateManagerPrivateCAUser';
/** Provides read only access to AWS Certificate Manager (ACM). */
AwsManagedPolicy.AWSCertificateManagerReadOnly = 'AWSCertificateManagerReadOnly';
/** The Service Linked Role used by AWS Chatbot. */
AwsManagedPolicy.AWSChatbotServiceLinkedRolePolicy = 'aws-service-role/AWSChatbotServiceLinkedRolePolicy';
/** Allows full access to AWS Clean Rooms resources and access to related AWS Services. */
AwsManagedPolicy.AWSCleanRoomsFullAccess = 'AWSCleanRoomsFullAccess';
/** Allows full access to AWS Clean Rooms resources except for querying in a collaboration and access to related AWS Services. */
AwsManagedPolicy.AWSCleanRoomsFullAccessNoQuerying = 'AWSCleanRoomsFullAccessNoQuerying';
/** Allows full access to AWS Clean Rooms ML resources and access to related AWS Services. */
AwsManagedPolicy.AWSCleanRoomsMLFullAccess = 'AWSCleanRoomsMLFullAccess';
/** Allows read-only access to AWS Clean Rooms ML resources and read-only access to related AWS Clean Rooms resources */
AwsManagedPolicy.AWSCleanRoomsMLReadOnlyAccess = 'AWSCleanRoomsMLReadOnlyAccess';
/** Allows read-only access to AWS Clean Rooms resources and read-only access to related AWS Glue and Amazon CloudWatch Logs resources. */
AwsManagedPolicy.AWSCleanRoomsReadOnlyAccess = 'AWSCleanRoomsReadOnlyAccess';
/** Provides administrator access to AWS Cloud9. */
AwsManagedPolicy.AWSCloud9Administrator = 'AWSCloud9Administrator';
/** Provides the ability to be invited into AWS Cloud9 shared development environments. */
AwsManagedPolicy.AWSCloud9EnvironmentMember = 'AWSCloud9EnvironmentMember';
/** Service Linked Role Policy for AWS Cloud9 */
AwsManagedPolicy.AWSCloud9ServiceRolePolicy = 'aws-service-role/AWSCloud9ServiceRolePolicy';
/** This policy will be used to attach a role on a InstanceProfile which will allow Cloud9 to use the SSM Session Manager to connect to the instance */
AwsManagedPolicy.AWSCloud9SSMInstanceProfile = 'AWSCloud9SSMInstanceProfile';
/** Provides permission to create AWS Cloud9 development environments and to manage owned environments. */
AwsManagedPolicy.AWSCloud9User = 'AWSCloud9User';
/** Provides full access to AWS CloudFormation. */
AwsManagedPolicy.AWSCloudFormationFullAccess = 'AWSCloudFormationFullAccess';
/** Provides access to AWS CloudFormation via the AWS Management Console. */
AwsManagedPolicy.AWSCloudFormationReadOnlyAccess = 'AWSCloudFormationReadOnlyAccess';
/** Grants CloudFront Logger write permissions to CloudWatch Logs. */
AwsManagedPolicy.AWSCloudFrontLogger = 'aws-service-role/AWSCloudFrontLogger';
/** Allows CloudFront to manage EC2 Elastic Network Interfaces and Security Groups on your behalf. */
AwsManagedPolicy.AWSCloudFrontVPCOriginServiceRolePolicy = 'aws-service-role/AWSCloudFrontVPCOriginServiceRolePolicy';
/** Provides full access to all CloudHSM resources. */
AwsManagedPolicy.AWSCloudHSMFullAccess = 'AWSCloudHSMFullAccess';
/** Provides read only access to all CloudHSM resources. */
AwsManagedPolicy.AWSCloudHSMReadOnlyAccess = 'AWSCloudHSMReadOnlyAccess';
/** Default policy for the AWS CloudHSM service role. */
AwsManagedPolicy.AWSCloudHSMRole = 'service-role/AWSCloudHSMRole';
/** Provides access to AWS Cloud Map discovery API. */
AwsManagedPolicy.AWSCloudMapDiscoverInstanceAccess = 'AWSCloudMapDiscoverInstanceAccess';
/** Provides full access to all AWS Cloud Map actions. */
AwsManagedPolicy.AWSCloudMapFullAccess = 'AWSCloudMapFullAccess';
/** Provides read-only access to all AWS Cloud Map actions. */
AwsManagedPolicy.AWSCloudMapReadOnlyAccess = 'AWSCloudMapReadOnlyAccess';
/** Provides registrant level access to AWS Cloud Map actions. */
AwsManagedPolicy.AWSCloudMapRegisterInstanceAccess = 'AWSCloudMapRegisterInstanceAccess';
/** Grants using AWS CloudShell with all features */
AwsManagedPolicy.AWSCloudShellFullAccess = 'AWSCloudShellFullAccess';
/** Provides full access to AWS CloudTrail. */
AwsManagedPolicy.AWSCloudTrailFullAccess = 'AWSCloudTrail_FullAccess';
/** Provides read only access to AWS CloudTrail. */
AwsManagedPolicy.AWSCloudTrailReadOnlyAccess = 'AWSCloudTrail_ReadOnlyAccess';
/** This policy is used by the service-linked role named AWSServiceRoleForCloudWatchAlarms_ActionSSMIncidents. CloudWatch uses this service-linked role to perform AWS System Manager Incident Manager actions when a CloudWatch alarm goes in to ALARM state. This policy grants permission to start incidents on your behalf. */
AwsManagedPolicy.AWSCloudWatchAlarmsActionSSMIncidentsServiceRolePolicy = 'aws-service-role/AWSCloudWatchAlarms_ActionSSMIncidentsServiceRolePolicy';
/** Provides full access to AWS CodeArtifact via the AWS Management Console. */
AwsManagedPolicy.AWSCodeArtifactAdminAccess = 'AWSCodeArtifactAdminAccess';
/** Provides read only access to AWS CodeArtifact via the AWS Management Console. */
AwsManagedPolicy.AWSCodeArtifactReadOnlyAccess = 'AWSCodeArtifactReadOnlyAccess';
/** Provides full access to AWS CodeBuild via the AWS Management Console. Also attach AmazonS3ReadOnlyAccess to provide access to download build artifacts, and attach IAMFullAccess to create and manage the service role for CodeBuild. */
AwsManagedPolicy.AWSCodeBuildAdminAccess = 'AWSCodeBuildAdminAccess';
/** Provides access to AWS CodeBuild via the AWS Management Console, but does not allow CodeBuild project administration. Also attach AmazonS3ReadOnlyAccess to provide access to download build artifacts. */
AwsManagedPolicy.AWSCodeBuildDeveloperAccess = 'AWSCodeBuildDeveloperAccess';
/** Provides read only access to AWS CodeBuild via the AWS Management Console. Also attach AmazonS3ReadOnlyAccess to provide access to download build artifacts. */
AwsManagedPolicy.AWSCodeBuildReadOnlyAccess = 'AWSCodeBuildReadOnlyAccess';
/** Provides full access to AWS CodeCommit via the AWS Management Console. */
AwsManagedPolicy.AWSCodeCommitFullAccess = 'AWSCodeCommitFullAccess';
/** Provides full access to AWS CodeCommit repositories, but does not allow repository deletion. */
AwsManagedPolicy.AWSCodeCommitPowerUser = 'AWSCodeCommitPowerUser';
/** Provides read only access to AWS CodeCommit via the AWS Management Console. */
AwsManagedPolicy.AWSCodeCommitReadOnly = 'AWSCodeCommitReadOnly';
/** Provides access to register and deploy a revision. */
AwsManagedPolicy.AWSCodeDeployDeployerAccess = 'AWSCodeDeployDeployerAccess';
/** Provides full access to CodeDeploy resources. */
AwsManagedPolicy.AWSCodeDeployFullAccess = 'AWSCodeDeployFullAccess';
/** Provides read only access to CodeDeploy resources. */
AwsManagedPolicy.AWSCodeDeployReadOnlyAccess = 'AWSCodeDeployReadOnlyAccess';
/** Provides CodeDeploy service access to expand tags and interact with Auto Scaling on your behalf. */
AwsManagedPolicy.AWSCodeDeployRole = 'service-role/AWSCodeDeployRole';
/** Provides CodeDeploy service access to invoke Lambda function on your behalf to perform blue/green deployment through CloudFormation. */
AwsManagedPolicy.AWSCodeDeployRoleForCloudFormation = 'service-role/AWSCodeDeployRoleForCloudFormation';
/** Provides CodeDeploy service wide access to perform an ECS blue/green deployment on your behalf. Grants full access to support services, such as  full access to read all S3 objects, invoke all Lambda functions, publish to all SNS topics within the account and update all ECS services. */
AwsManagedPolicy.AWSCodeDeployRoleForECS = 'AWSCodeDeployRoleForECS';
/**  Provides CodeDeploy service limited access to perform an ECS blue/green deployment on your behalf. */
AwsManagedPolicy.AWSCodeDeployRoleForECSLimited = 'AWSCodeDeployRoleForECSLimited';
/** Provides CodeDeploy service access to perform a Lambda deployment on your behalf. */
AwsManagedPolicy.AWSCodeDeployRoleForLambda = 'service-role/AWSCodeDeployRoleForLambda';
/** Provides CodeDeploy service limited access to perform a Lambda deployment on your behalf. */
AwsManagedPolicy.AWSCodeDeployRoleForLambdaLimited = 'service-role/AWSCodeDeployRoleForLambdaLimited';
/** Provides full access to AWS CodePipeline via the AWS Management Console. */
AwsManagedPolicy.AWSCodePipelineFullAccess = 'AWSCodePipeline_FullAccess';
/** Provides read only access to AWS CodePipeline via the AWS Management Console. */
AwsManagedPolicy.AWSCodePipelineReadOnlyAccess = 'AWSCodePipeline_ReadOnlyAccess';
/** Provides access to view and approve manual changes for all pipelines */
AwsManagedPolicy.AWSCodePipelineApproverAccess = 'AWSCodePipelineApproverAccess';
/** Provides access for custom actions to poll for jobs details (including temporary credentials) and report status updates to AWS CodePipeline. */
AwsManagedPolicy.AWSCodePipelineCustomActionAccess = 'AWSCodePipelineCustomActionAccess';
/** Provides full access to AWS CodeStar via the AWS Management Console. */
AwsManagedPolicy.AWSCodeStarFullAccess = 'AWSCodeStarFullAccess';
/** Allows AWS CodeStar Notifications to access Amazon CloudWatch Events on your behalf */
AwsManagedPolicy.AWSCodeStarNotificationsServiceRolePolicy = 'aws-service-role/AWSCodeStarNotificationsServiceRolePolicy';
/** DO NOT USE -  AWS CodeStar Service Role Policy which grants administrative privileges in order for CodeStar to manage IAM and other service resources on behalf of the customer. */
AwsManagedPolicy.AWSCodeStarServiceRole = 'service-role/AWSCodeStarServiceRole';
/** Denies access to certain actions, applied by the AWS team in the event that an IAM user's credentials have been compromised or exposed publicly.  Do NOT remove this policy.  Instead, please follow the instructions specified in the email sent to you regarding this event. */
AwsManagedPolicy.AWSCompromisedKeyQuarantine = 'AWSCompromisedKeyQuarantine';
/** Denies access to certain actions, applied by the AWS team in the event that an IAM user's credentials have been compromised or exposed publicly. Do NOT remove this policy. Instead, please follow the instructions specified in the support case created for you regarding this event. */
AwsManagedPolicy.AWSCompromisedKeyQuarantineV2 = 'AWSCompromisedKeyQuarantineV2';
/** Denies access to certain actions, applied by AWS in the event that an IAM user's credentials have been compromised or exposed publicly. The policy aims to limit the potential damage that may be caused by fraud-related activity leading to unauthorized charges, while not impacting the existing resources. Do NOT remove this policy. Instead, please follow the instructions specified in the support case created for you regarding this event. */
AwsManagedPolicy.AWSCompromisedKeyQuarantineV3 = 'AWSCompromisedKeyQuarantineV3';
/** Allows Config to call AWS services and deploy config resources across organization */
AwsManagedPolicy.AWSConfigMultiAccountSetupPolicy = 'aws-service-role/AWSConfigMultiAccountSetupPolicy';
/** Allows AWS Config to remediate noncompliant resources on your behalf. */
AwsManagedPolicy.AWSConfigRemediationServiceRolePolicy = 'aws-service-role/AWSConfigRemediationServiceRolePolicy';
/** Allows AWS Config to call read-only AWS Organizations APIs */
AwsManagedPolicy.AWSConfigRoleForOrganizations = 'service-role/AWSConfigRoleForOrganizations';
/** Allows an AWS Lambda function to access the AWS Config API and the configuration snapshots that AWS Config delivers periodically to Amazon S3. This access is required by functions that evaluate configuration changes for custom Config rules. */
AwsManagedPolicy.AWSConfigRulesExecutionRole = 'service-role/AWSConfigRulesExecutionRole';
/** Allows Config to call AWS services and collect resource configurations on your behalf. */
AwsManagedPolicy.AWSConfigServiceRolePolicy = 'aws-service-role/AWSConfigServiceRolePolicy';
/** Provides access to use AWS Config, including searching by tags on resources, and reading all tags. This does not provide permission to configure AWS Config, which requires administrative privileges. */
AwsManagedPolicy.AWSConfigUserAccess = 'AWSConfigUserAccess';
/** Enables broad read/write access to ALL EC2 objects, read/write access to S3 buckets starting with 'import-to-ec2-', and the ability to list all S3 buckets, for the AWS Connector to import VMs on your behalf. */
AwsManagedPolicy.AWSConnector = 'AWSConnector';
/** Allows AWS Control Tower to call AWS services that provide automated account configuration and centralized governance on your behalf. */
AwsManagedPolicy.AWSControlTowerAccountServiceRolePolicy = 'aws-service-role/AWSControlTowerAccountServiceRolePolicy';
/** Provides access to AWS Resources managed or used by AWS Control Tower */
AwsManagedPolicy.AWSControlTowerServiceRolePolicy = 'service-role/AWSControlTowerServiceRolePolicy';
/** Grants permissions to to describe the organization of the account, create S3 buckets for the MAP program and apply tags to it, create a Cost and Usage Report, and describe Cost and Usage Report definitions. */
AwsManagedPolicy.AWSCostAndUsageReportAutomationPolicy = 'service-role/AWSCostAndUsageReportAutomationPolicy';
/** Gives Data Grant owners access to AWS Data Exchange actions using the AWS Management Console and SDK. */
AwsManagedPolicy.AWSDataExchangeDataGrantOwnerFullAccess = 'AWSDataExchangeDataGrantOwnerFullAccess';
/** Gives Data Grant receiver access to AWS Data Exchange actions using the AWS Management Console and SDK. */
AwsManagedPolicy.AWSDataExchangeDataGrantReceiverFullAccess = 'AWSDataExchangeDataGrantReceiverFullAccess';
/** Grants full access to AWS Data Exchange and AWS Marketplace actions using the AWS Management Console and SDK. It also provides select access to related services needed to take full advantage of AWS Data Exchange. */
AwsManagedPolicy.AWSDataExchangeFullAccess = 'AWSDataExchangeFullAccess';
/** Grants data provider access to AWS Data Exchange and AWS Marketplace actions using the AWS Management Console and SDK. It also provides select access to related services needed to take full advantage of AWS Data Exchange. */
AwsManagedPolicy.AWSDataExchangeProviderFullAccess = 'AWSDataExchangeProviderFullAccess';
/** Grants read-only access to AWS Data Exchange and AWS Marketplace actions using the AWS Management Console and SDK. */
AwsManagedPolicy.AWSDataExchangeReadOnly = 'AWSDataExchangeReadOnly';
/** Allows AWS Data Exchange to access AWS Services and Resources used or managed by AWS Data Exchange for license management. */
AwsManagedPolicy.AWSDataExchangeServiceRolePolicyForLicenseManagement = 'aws-service-role/AWSDataExchangeServiceRolePolicyForLicenseManagement';
/** Allows AWS Data Exchange to read data about your AWS Organization to determine eligibility for AWS Data Exchange data grants license distribution. */
AwsManagedPolicy.AWSDataExchangeServiceRolePolicyForOrganizationDiscovery = 'aws-service-role/AWSDataExchangeServiceRolePolicyForOrganizationDiscovery';
/** Grants data subscriber access to AWS Data Exchange and AWS Marketplace actions using the AWS Management Console and SDK. It also provides select access to related services needed to take full advantage of AWS Data Exchange. */
AwsManagedPolicy.AWSDataExchangeSubscriberFullAccess = 'AWSDataExchangeSubscriberFullAccess';
/** Provides appropriate permissions to AWS Data Lifecycle Manager to take actions on AWS resources */
AwsManagedPolicy.AWSDataLifecycleManagerServiceRole = 'service-role/AWSDataLifecycleManagerServiceRole';
/** Provides appropriate permissions to AWS Data Lifecycle Manager to take actions on AWS resources for AMI Management */
AwsManagedPolicy.AWSDataLifecycleManagerServiceRoleForAMIManagement = 'service-role/AWSDataLifecycleManagerServiceRoleForAMIManagement';
/** Provides Amazon Data Lifecycle Manager permission to perform the Systems Manager actions required to run pre and post scripts on all Amazon EC2 instances. */
AwsManagedPolicy.AWSDataLifecycleManagerSSMFullAccess = 'service-role/AWSDataLifecycleManagerSSMFullAccess';
/** Provides full access to Data Pipeline, list access for S3, DynamoDB, Redshift, RDS, SNS, and IAM roles, and passRole access for default Roles. */
AwsManagedPolicy.AWSDataPipelineFullAccess = 'AWSDataPipeline_FullAccess';
/** Provides full access to Data Pipeline, list access for S3, DynamoDB, Redshift, RDS, SNS, and IAM roles, and passRole access for default Roles. */
AwsManagedPolicy.AWSDataPipelinePowerUser = 'AWSDataPipeline_PowerUser';
/** Allows DataSync Discovery to integrate with other AWS services on your behalf. */
AwsManagedPolicy.AWSDataSyncDiscoveryServiceRolePolicy = 'aws-service-role/AWSDataSyncDiscoveryServiceRolePolicy';
/** Provides full access to AWS DataSync and minimal access to its dependencies */
AwsManagedPolicy.AWSDataSyncFullAccess = 'AWSDataSyncFullAccess';
/** Provides read-only access to AWS DataSync */
AwsManagedPolicy.AWSDataSyncReadOnlyAccess = 'AWSDataSyncReadOnlyAccess';
/** Allows DataSync to integrate with other AWS services on your behalf */
AwsManagedPolicy.AWSDataSyncServiceRolePolicy = 'aws-service-role/AWSDataSyncServiceRolePolicy';
/** Provides AWS Deadline Cloud workers with access to run tasks on a farm. */
AwsManagedPolicy.AWSDeadlineCloudFleetWorker = 'AWSDeadlineCloud-FleetWorker';
/** Provides user workstation access to AWS Deadline Cloud farms with limited Read-Only permissions to call other necessary services. Attach this policy to the user role associated with your studio. */
AwsManagedPolicy.AWSDeadlineCloudUserAccessFarms = 'AWSDeadlineCloud-UserAccessFarms';
/** Provides user workstation access to AWS Deadline Cloud fleets with limited Read-Only permissions to call other necessary services. Attach this policy to the user role associated with your studio. */
AwsManagedPolicy.AWSDeadlineCloudUserAccessFleets = 'AWSDeadlineCloud-UserAccessFleets';
/** Provides user workstation access to AWS Deadline Cloud jobs with limited Read-Only permissions to call other necessary services. Attach this policy to the user role associated with your studio. */
AwsManagedPolicy.AWSDeadlineCloudUserAccessJobs = 'AWSDeadlineCloud-UserAccessJobs';
/** Provides user workstation access to AWS Deadline Cloud queues with limited Read-Only permissions to call other necessary services. Attach this policy to the user role associated with your studio. */
AwsManagedPolicy.AWSDeadlineCloudUserAccessQueues = 'AWSDeadlineCloud-UserAccessQueues';
/** Provides access for AWS Deadline Cloud worker hosts to join a fleet in a farm. */
AwsManagedPolicy.AWSDeadlineCloudWorkerHost = 'AWSDeadlineCloud-WorkerHost';
/** This policy specifies permissions required by DeepLens Administrative lambda functions that run on a DeepLens device */
AwsManagedPolicy.AWSDeepLensLambdaFunctionAccessPolicy = 'AWSDeepLensLambdaFunctionAccessPolicy';
/** Grants AWS DeepLens access to AWS Services, resources and roles needed by DeepLens and its dependencies including IoT, S3, GreenGrass and AWS Lambda. */
AwsManagedPolicy.AWSDeepLensServiceRolePolicy = 'service-role/AWSDeepLensServiceRolePolicy';
/** DeepRacer admin access to all actions including toggling between multiuser and single user mode. */
AwsManagedPolicy.AWSDeepRacerAccountAdminAccess = 'AWSDeepRacerAccountAdminAccess';
/** Allows CloudFormation to create and manage AWS stacks and resources on your behalf. */
AwsManagedPolicy.AWSDeepRacerCloudFormationAccessPolicy = 'AWSDeepRacerCloudFormationAccessPolicy';
/** DeepRacer MultiUser Default user access to use deepracer in multi-user mode */
AwsManagedPolicy.AWSDeepRacerDefaultMultiUserAccess = 'AWSDeepRacerDefaultMultiUserAccess';
/** Provides full access to AWS DeepRacer. Also provides select access to related services (e.g., S3). */
AwsManagedPolicy.AWSDeepRacerFullAccess = 'AWSDeepRacerFullAccess';
/** Allows RoboMaker to create required resources and call AWS services on your behalf. */
AwsManagedPolicy.AWSDeepRacerRoboMakerAccessPolicy = 'AWSDeepRacerRoboMakerAccessPolicy';
/** Allows DeepRacer to create required resources and call AWS services on your behalf. */
AwsManagedPolicy.AWSDeepRacerServiceRolePolicy = 'service-role/AWSDeepRacerServiceRolePolicy';
/** Deny all access. */
AwsManagedPolicy.AWSDenyAll = 'AWSDenyAll';
/** Provides full access to all AWS Device Farm operations. */
AwsManagedPolicy.AWSDeviceFarmFullAccess = 'AWSDeviceFarmFullAccess';
/** Grant permissions to AWS Device Farm to call EC2 Network APIs on your behalf. */
AwsManagedPolicy.AWSDeviceFarmServiceRolePolicy = 'aws-service-role/AWSDeviceFarmServiceRolePolicy';
/** Grant permissions to AWS Device Farm to call EC2 APIs on your behalf. */
AwsManagedPolicy.AWSDeviceFarmTestGridServiceRolePolicy = 'aws-service-role/AWSDeviceFarmTestGridServiceRolePolicy';
/** Provides full access to AWS Direct Connect via the AWS Management Console. */
AwsManagedPolicy.AWSDirectConnectFullAccess = 'AWSDirectConnectFullAccess';
/** Provides read only access to AWS Direct Connect via the AWS Management Console. */
AwsManagedPolicy.AWSDirectConnectReadOnlyAccess = 'AWSDirectConnectReadOnlyAccess';
/** Provides AWS Direct Connect permission to create and manage AWS resources on your behalf. */
AwsManagedPolicy.AWSDirectConnectServiceRolePolicy = 'aws-service-role/AWSDirectConnectServiceRolePolicy';
/** Provides full access to AWS Directory Service Data. */
AwsManagedPolicy.AWSDirectoryServiceDataFullAccess = 'AWSDirectoryServiceDataFullAccess';
/** Provides read-only access to AWS Directory Service Data */
AwsManagedPolicy.AWSDirectoryServiceDataReadOnlyAccess = 'AWSDirectoryServiceDataReadOnlyAccess';
/** Provides full access to AWS Directory Service. */
AwsManagedPolicy.AWSDirectoryServiceFullAccess = 'AWSDirectoryServiceFullAccess';
/** Provides read only access to AWS Directory Service. */
AwsManagedPolicy.AWSDirectoryServiceReadOnlyAccess = 'AWSDirectoryServiceReadOnlyAccess';
/** Policy for the Directory Service Service Linked Role */
AwsManagedPolicy.AWSDirectoryServiceServiceRolePolicy = 'aws-service-role/AWSDirectoryServiceServiceRolePolicy';
/** Provides write access to AWS resources required for AWS Discovery Continuous Export */
AwsManagedPolicy.AWSDiscoveryContinuousExportFirehosePolicy = 'AWSDiscoveryContinuousExportFirehosePolicy';
/** Allows DMS Fleet Advisor to manage CloudWatch metrics on your behalf. */
AwsManagedPolicy.AWSDMSFleetAdvisorServiceRolePolicy = 'aws-service-role/AWSDMSFleetAdvisorServiceRolePolicy';
/** Grants AWS DMS Serverless permissions to create and manage DMS resources in your account on your behalf */
AwsManagedPolicy.AWSDMSServerlessServiceRolePolicy = 'aws-service-role/AWSDMSServerlessServiceRolePolicy';
/** Allows EC2 CapacityReservation Fleet service to manage Capacity Reservations */
AwsManagedPolicy.AWSEC2CapacityReservationFleetRolePolicy = 'aws-service-role/AWSEC2CapacityReservationFleetRolePolicy';
/** Allows EC2 Fleet to launch and manage instances. */
AwsManagedPolicy.AWSEC2FleetServiceRolePolicy = 'aws-service-role/AWSEC2FleetServiceRolePolicy';
/** Allows EC2 Spot Fleet to launch and manage spot fleet instances */
AwsManagedPolicy.AWSEC2SpotFleetServiceRolePolicy = 'aws-service-role/AWSEC2SpotFleetServiceRolePolicy';
/** Allows EC2 Spot to launch and manage spot instances */
AwsManagedPolicy.AWSEC2SpotServiceRolePolicy = 'aws-service-role/AWSEC2SpotServiceRolePolicy';
/** This policy is attached to the IAM role that's attached to your Amazon EC2 Windows Instances to enable the Amazon EC2 VSS solution to create and add tags to Amazon Machine Images (AMI) and EBS Snapshots. */
AwsManagedPolicy.AWSEC2VssSnapshotPolicy = 'AWSEC2VssSnapshotPolicy';
/** Enables access to AWS services and resources used or managed by AWS ECR pull through cache */
AwsManagedPolicy.AWSECRPullThroughCacheServiceRolePolicy = 'aws-service-role/AWSECRPullThroughCache_ServiceRolePolicy';
/** Provide the instance in your custom platform builder environment permission to launch EC2 instance, create EBS snapshot and AMI, stream logs to Amazon CloudWatch Logs, and store artifacts in Amazon S3. */
AwsManagedPolicy.AWSElasticBeanstalkCustomPlatformforEC2Role = 'AWSElasticBeanstalkCustomPlatformforEC2Role';
/** AWS Elastic Beanstalk Service policy for Health Monitoring system */
AwsManagedPolicy.AWSElasticBeanstalkEnhancedHealth = 'service-role/AWSElasticBeanstalkEnhancedHealth';
/** AWS Elastic Beanstalk Service Role policy that grants limited permissions to update your resources on your behalf for maintenance purposes. */
AwsManagedPolicy.AWSElasticBeanstalkMaintenance = 'aws-service-role/AWSElasticBeanstalkMaintenance';
/** This policy is for the AWS Elastic Beanstalk service role used to perform managed updates of Elastic Beanstalk environments. This policy should not be attached to other users or roles. The policy grants broad permissions to create and manage resources across a number of AWS services including AutoScaling, EC2, ECS, Elastic Load Balancing and CloudFormation.  This policy also allows passing of any IAM role usable with those services. */
AwsManagedPolicy.AWSElasticBeanstalkManagedUpdatesCustomerRolePolicy = 'AWSElasticBeanstalkManagedUpdatesCustomerRolePolicy';
/** AWS Elastic Beanstalk Service Role policy that grants limited permissions to managed updates. */
AwsManagedPolicy.AWSElasticBeanstalkManagedUpdatesServiceRolePolicy = 'aws-service-role/AWSElasticBeanstalkManagedUpdatesServiceRolePolicy';
/** Provide the instances in your multicontainer Docker environment access to use the Amazon EC2 Container Service to manage container deployment tasks. */
AwsManagedPolicy.AWSElasticBeanstalkMulticontainerDocker = 'AWSElasticBeanstalkMulticontainerDocker';
/** Grants read-only permissions. Explicitly allows operators to gain direct access to retrieve information about resources related to AWS Elastic Beanstalk applications. */
AwsManagedPolicy.AWSElasticBeanstalkReadOnly = 'AWSElasticBeanstalkReadOnly';
/** AWSElasticBeanstalkRoleCore (Elastic Beanstalk operations role) Allows core operation of a web service environment. */
AwsManagedPolicy.AWSElasticBeanstalkRoleCore = 'service-role/AWSElasticBeanstalkRoleCore';
/** (Elastic Beanstalk operations role) Allows an environment to manage Amazon CloudWatch Logs log groups. */
AwsManagedPolicy.AWSElasticBeanstalkRoleCWL = 'service-role/AWSElasticBeanstalkRoleCWL';
/** (Elastic Beanstalk operations role) Allows a multicontainer Docker environment to manage Amazon ECS clusters. */
AwsManagedPolicy.AWSElasticBeanstalkRoleECS = 'service-role/AWSElasticBeanstalkRoleECS';
/** (Elastic Beanstalk operations role) Allows an environment to integrate an Amazon RDS instance. */
AwsManagedPolicy.AWSElasticBeanstalkRoleRDS = 'service-role/AWSElasticBeanstalkRoleRDS';
/** (Elastic Beanstalk operations role) Allows an environment to enable Amazon SNS topic integration. */
AwsManagedPolicy.AWSElasticBeanstalkRoleSNS = 'service-role/AWSElasticBeanstalkRoleSNS';
/** (Elastic Beanstalk operations role) Allows a worker environment tier to create an Amazon DynamoDB table and an Amazon SQS queue. */
AwsManagedPolicy.AWSElasticBeanstalkRoleWorkerTier = 'service-role/AWSElasticBeanstalkRoleWorkerTier';
/** This policy is on a deprecation path. See documentation for guidance: https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-servicerole.html. AWS Elastic Beanstalk Service role policy which grants permissions to create & manage resources (i.e.: AutoScaling, EC2, S3, CloudFormation, ELB, etc.) on your behalf. */
AwsManagedPolicy.AWSElasticBeanstalkService = 'service-role/AWSElasticBeanstalkService';
/** AWS Elastic Beanstalk Service Linked Role policy which grants permissions to create & manage resources (i.e.: AutoScaling, EC2, S3, CloudFormation, ELB, etc.) on your behalf. */
AwsManagedPolicy.AWSElasticBeanstalkServiceRolePolicy = 'aws-service-role/AWSElasticBeanstalkServiceRolePolicy';
/** Provide the instances in your web server environment access to upload log files to Amazon S3. */
AwsManagedPolicy.AWSElasticBeanstalkWebTier = 'AWSElasticBeanstalkWebTier';
/** Provide the instances in your worker environment access to upload log files to Amazon S3, to use Amazon SQS to monitor your application's job queue, to use Amazon DynamoDB to perform leader election, and to Amazon CloudWatch to publish metrics for health monitoring. */
AwsManagedPolicy.AWSElasticBeanstalkWorkerTier = 'AWSElasticBeanstalkWorkerTier';
/** This policy allows installing the AWS Replication Agent, which is used with AWS Elastic Disaster Recovery (DRS) to recover external servers to AWS. Attach this policy to your IAM users or roles whose credentials you provide during the installation step of the AWS Replication Agent. */
AwsManagedPolicy.AWSElasticDisasterRecoveryAgentInstallationPolicy = 'AWSElasticDisasterRecoveryAgentInstallationPolicy';
/** This policy allows using the AWS Replication Agent, which is used with AWS Elastic Disaster Recovery (DRS) to recover source servers to AWS. We do not recommend that you attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSElasticDisasterRecoveryAgentPolicy = 'service-role/AWSElasticDisasterRecoveryAgentPolicy';
/** This policy provides full access to all public APIs of AWS Elastic Disaster Recovery (DRS), as well as permissions to read KMS key, License Manager, Resource Groups, Elastic Load Balancing, IAM, and EC2 information. Attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSElasticDisasterRecoveryConsoleFullAccess = 'AWSElasticDisasterRecoveryConsoleFullAccess';
/** This policy provides full access to all public APIs of AWS Elastic Disaster Recovery (AWS DRS), as well as all public APIs in other AWS services used by AWS DRS Console. Attach this policy to your users or roles. */
AwsManagedPolicy.AWSElasticDisasterRecoveryConsoleFullAccessV2 = 'AWSElasticDisasterRecoveryConsoleFullAccess_v2';
/** This policy is attached to the AWS Elastic Disaster Recovery Conversion server's instance role. This policy allows Elastic Disaster Recovery (DRS) Conversion Servers, which are EC2 instances launched by Elastic Disaster Recovery, to communicate with the DRS service. An IAM role with this policy is attached (as an EC2 Instance Profile) by DRS to the DRS Conversion Servers, which are automatically launched and terminated by DRS, when needed. We do not recommend that you attach this policy to your IAM users or roles. DRS Conversion Servers are used by Elastic Disaster Recovery when users choose to recover source servers using the DRS console, CLI, or API. */
AwsManagedPolicy.AWSElasticDisasterRecoveryConversionServerPolicy = 'service-role/AWSElasticDisasterRecoveryConversionServerPolicy';
/** This policy allows AWS Elastic Disaster Recovery (DRS) to support cross-account replication and cross-account failback. */
AwsManagedPolicy.AWSElasticDisasterRecoveryCrossAccountReplicationPolicy = 'service-role/AWSElasticDisasterRecoveryCrossAccountReplicationPolicy';
/** This policy allows installing and using the AWS Replication Agent, which is used by AWS Elastic Disaster Recovery (DRS) to recover source servers that run on EC2 (cross-region or cross-AZ). An IAM role with this policy should be attached (as an EC2 Instance Profile) to the EC2 Instances. */
AwsManagedPolicy.AWSElasticDisasterRecoveryEc2InstancePolicy = 'service-role/AWSElasticDisasterRecoveryEc2InstancePolicy';
/** You can attach the AWSElasticDisasterRecoveryFailbackInstallationPolicy policy to your IAM identities.  This policy allows installing the Elastic Disaster Recovery Failback Client, which is used to failback Recovery Instances back to your original source infrastructure. Attach this policy to your IAM users or roles whose credentials you provide when running the Elastic Disaster Recovery Failback Client. */
AwsManagedPolicy.AWSElasticDisasterRecoveryFailbackInstallationPolicy = 'AWSElasticDisasterRecoveryFailbackInstallationPolicy';
/** This policy allows using the Elastic Disaster Recovery Failback Client, which is used to failback Recovery Instances back to your original source infrastructure. We do not recommend that you attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSElasticDisasterRecoveryFailbackPolicy = 'service-role/AWSElasticDisasterRecoveryFailbackPolicy';
/** This policy allows you to use Amazon SSM and additional services required permissions to run post-launch actions in AWS Elastic Disaster Recovery (AWS DRS). Attach this policy to your IAM roles or users. */
AwsManagedPolicy.AWSElasticDisasterRecoveryLaunchActionsPolicy = 'AWSElasticDisasterRecoveryLaunchActionsPolicy';
/** This policy allows AWS Elastic Disaster Recovery (DRS) to support network replication. */
AwsManagedPolicy.AWSElasticDisasterRecoveryNetworkReplicationPolicy = 'service-role/AWSElasticDisasterRecoveryNetworkReplicationPolicy';
/** You can attach the AWSElasticDisasterRecoveryReadOnlyAccess policy to your IAM identities.  This policy provides permissions to all read-only public APIs of Elastic Disaster Recovery (DRS), as well as some read-only APIs of other AWS services that are required in order to make full read-only use of the DRS console. Attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSElasticDisasterRecoveryReadOnlyAccess = 'AWSElasticDisasterRecoveryReadOnlyAccess';
/** This policy is attached to the instance role of Elastic Disaster Recovery's Recovery Instance.  This policy allows the Elastic Disaster Recovery (DRS) Recovery Instance, which are EC2 instances launched by Elastic Disaster Recovery - to communicate with the DRS service, and to be able to failback to their original source infrastructure. An IAM role with this policy is attached (as an EC2 Instance Profile) by Elastic Disaster Recovery to the DRS Recovery Instances. We do not recommend that you attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSElasticDisasterRecoveryRecoveryInstancePolicy = 'service-role/AWSElasticDisasterRecoveryRecoveryInstancePolicy';
/** This policy is attached to the Elastic Disaster Recovery Replication server's instance role. This policy allows the Elastic Disaster Recovery (DRS) Replication Servers, which are EC2 instances launched by Elastic Disaster Recovery - to communicate with the DRS service, and to create EBS snapshots in your AWS account. An IAM role with this policy is attached (as an EC2 Instance Profile) by Elastic Disaster Recovery to the DRS Replication Servers which are automatically launched and terminated by DRS, as needed. DRS Replication Servers are used to facilitate data replication from your external servers to AWS, as part of the recovery process managed by DRS. We do not recommend that you attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSElasticDisasterRecoveryReplicationServerPolicy = 'service-role/AWSElasticDisasterRecoveryReplicationServerPolicy';
/** This policy allows Elastic Disaster Recovery to manage AWS resources on your behalf. */
AwsManagedPolicy.AWSElasticDisasterRecoveryServiceRolePolicy = 'aws-service-role/AWSElasticDisasterRecoveryServiceRolePolicy';
/** This policy allows read-only access to AWS Elastic Disaster Recovery (DRS) resources such as source servers and jobs. It also allows creating a converted snapshot and sharing that EBS snapshot with a specific account. */
AwsManagedPolicy.AWSElasticDisasterRecoveryStagingAccountPolicy = 'service-role/AWSElasticDisasterRecoveryStagingAccountPolicy';
/** This policy is used by AWS Elastic Disaster Recovery (DRS) to recover source servers into a separate target account and to allow failing back. We do not recommend that you attach this policy to your IAM users or roles. */
AwsManagedPolicy.AWSElasticDisasterRecoveryStagingAccountPolicyV2 = 'service-role/AWSElasticDisasterRecoveryStagingAccountPolicy_v2';
/** Service Linked Role Policy for AWS Elastic Load Balancing Control Plane - Classic */
AwsManagedPolicy.AWSElasticLoadBalancingClassicServiceRolePolicy = 'aws-service-role/AWSElasticLoadBalancingClassicServiceRolePolicy';
/** Service Linked Role Policy for AWS Elastic Load Balancing Control Plane */
AwsManagedPolicy.AWSElasticLoadBalancingServiceRolePolicy = 'aws-service-role/AWSElasticLoadBalancingServiceRolePolicy';
/** Provides full access to AWS Elemental MediaConnect resources. */
AwsManagedPolicy.AWSElementalMediaConnectFullAccess = 'AWSElementalMediaConnectFullAccess';
/** Provides read-only access to AWS Elemental MediaConnect resources. */
AwsManagedPolicy.AWSElementalMediaConnectReadOnlyAccess = 'AWSElementalMediaConnectReadOnlyAccess';
/** Provides full access to AWS Elemental MediaConvert via the AWS Management Console and SDK. */
AwsManagedPolicy.AWSElementalMediaConvertFullAccess = 'AWSElementalMediaConvertFullAccess';
/** Provides read only access to AWS Elemental MediaConvert via the AWS Management Console and SDK. */
AwsManagedPolicy.AWSElementalMediaConvertReadOnly = 'AWSElementalMediaConvertReadOnly';
/** Provides full access to AWS Elemental MediaLive resources */
AwsManagedPolicy.AWSElementalMediaLiveFullAccess = 'AWSElementalMediaLiveFullAccess';
/** Provides read only access to AWS Elemental MediaLive resources */
AwsManagedPolicy.AWSElementalMediaLiveReadOnly = 'AWSElementalMediaLiveReadOnly';
/** Provides full access to AWS Elemental MediaPackage resources */
AwsManagedPolicy.AWSElementalMediaPackageFullAccess = 'AWSElementalMediaPackageFullAccess';
/** Provides read only access to AWS Elemental MediaPackage resources */
AwsManagedPolicy.AWSElementalMediaPackageReadOnly = 'AWSElementalMediaPackageReadOnly';
/** Provides full access to AWS Elemental MediaPackageV2 resources. */
AwsManagedPolicy.AWSElementalMediaPackageV2FullAccess = 'AWSElementalMediaPackageV2FullAccess';
/** Provides read-only access to AWS Elemental MediaPackageV2 resources. */
AwsManagedPolicy.AWSElementalMediaPackageV2ReadOnly = 'AWSElementalMediaPackageV2ReadOnly';
/** Provides full read and write access to all MediaStore APIs */
AwsManagedPolicy.AWSElementalMediaStoreFullAccess = 'AWSElementalMediaStoreFullAccess';
/** Provides read-only permissions for MediaStore APIs */
AwsManagedPolicy.AWSElementalMediaStoreReadOnly = 'AWSElementalMediaStoreReadOnly';
/** Provides full access to AWS Elemental MediaTailor resources */
AwsManagedPolicy.AWSElementalMediaTailorFullAccess = 'AWSElementalMediaTailorFullAccess';
/** Provides read only access to AWS Elemental MediaTailor resources */
AwsManagedPolicy.AWSElementalMediaTailorReadOnly = 'AWSElementalMediaTailorReadOnly';
/** Policy to enable enhanced classic networking management feature. */
AwsManagedPolicy.AWSEnhancedClassicNetworkingMangementPolicy = 'aws-service-role/AWSEnhancedClassicNetworkingMangementPolicy';
/** Provides console full access to AWS Entity Resolution and related services. */
AwsManagedPolicy.AWSEntityResolutionConsoleFullAccess = 'AWSEntityResolutionConsoleFullAccess';
/** Provides read-only access to AWS Entity Resolution via the AWS Management Console. */
AwsManagedPolicy.AWSEntityResolutionConsoleReadOnlyAccess = 'AWSEntityResolutionConsoleReadOnlyAccess';
/** This policy grants the Fault Injection Simulator Service permission in EC2 and other required services to perform FIS actions. */
AwsManagedPolicy.AWSFaultInjectionSimulatorEC2Access = 'service-role/AWSFaultInjectionSimulatorEC2Access';
/** This policy grants the Fault Injection Simulator Service permission in ECS and other required services to perform FIS actions. */
AwsManagedPolicy.AWSFaultInjectionSimulatorECSAccess = 'service-role/AWSFaultInjectionSimulatorECSAccess';
/** This policy grants the Fault Injection Simulator Service permission in EKS and other required services to perform FIS actions. */
AwsManagedPolicy.AWSFaultInjectionSimulatorEKSAccess = 'service-role/AWSFaultInjectionSimulatorEKSAccess';
/** This policy grants the Fault Injection Simulator Service permission in EC2 networking and other required services to perform FIS actions. */
AwsManagedPolicy.AWSFaultInjectionSimulatorNetworkAccess = 'service-role/AWSFaultInjectionSimulatorNetworkAccess';
/** This policy grants the Fault Injection Simulator Service permission in RDS and other required services to perform FIS actions. */
AwsManagedPolicy.AWSFaultInjectionSimulatorRDSAccess = 'service-role/AWSFaultInjectionSimulatorRDSAccess';
/** This policy grants the Fault Injection Simulator Service permission in SSM and other required services to perform FIS actions. */
AwsManagedPolicy.AWSFaultInjectionSimulatorSSMAccess = 'service-role/AWSFaultInjectionSimulatorSSMAccess';
/** Policy to enable access to AWS Service and Resources used or managed by Amazon FinSpace */
AwsManagedPolicy.AWSFinSpaceServiceRolePolicy = 'aws-service-role/AWSFinSpaceServiceRolePolicy';
/** Full access for AWS FM Administrator */
AwsManagedPolicy.AWSFMAdminFullAccess = 'AWSFMAdminFullAccess';
/** Read only access for AWS FM Administrator that allows monitoring AWS FM operations */
AwsManagedPolicy.AWSFMAdminReadOnlyAccess = 'AWSFMAdminReadOnlyAccess';
/** Provides read only access to AWS WAF actions for AWS Firewall Manager member accounts */
AwsManagedPolicy.AWSFMMemberReadOnlyAccess = 'AWSFMMemberReadOnlyAccess';
/** Managed policy for AWS For Wordpress Plugin */
AwsManagedPolicy.AWSForWordPressPluginPolicy = 'AWSForWordPressPluginPolicy';
/** Policy which allows AWS Code Connections to sync content from your git repository */
AwsManagedPolicy.AWSGitSyncServiceRolePolicy = 'aws-service-role/AWSGitSyncServiceRolePolicy';
/** Policy granting permissions to AWS Global Accelerator to manage EC2 Elastic Network Interfaces and Security Groups. */
AwsManagedPolicy.AWSGlobalAcceleratorSLRPolicy = 'aws-service-role/AWSGlobalAcceleratorSLRPolicy';
/** Provides full access to AWS Glue via the AWS Management Console */
AwsManagedPolicy.AWSGlueConsoleFullAccess = 'AWSGlueConsoleFullAccess';
/** Provides full access to AWS Glue via the AWS Management Console and access to sagemaker notebook instances. */
AwsManagedPolicy.AWSGlueConsoleSageMakerNotebookFullAccess = 'AWSGlueConsoleSageMakerNotebookFullAccess';
/** Provides full access to AWS Glue DataBrew via the AWS Management Console. Also provides select access to related services (e.g., S3, KMS, Glue). */
AwsManagedPolicy.AwsGlueDataBrewFullAccessPolicy = 'AwsGlueDataBrewFullAccessPolicy';
/** This policy grants permission to glue to perform action on user's glue data catalog, this policy also provides permission to ec2 actions to allow glue to create ENI to connect to resources in the VPC, also allow glue to access registered data in lakeformation and permission to access user's cloudwatch */
AwsManagedPolicy.AWSGlueDataBrewServiceRole = 'service-role/AWSGlueDataBrewServiceRole';
/** Provides full access to the AWS Glue Schema Registry Service */
AwsManagedPolicy.AWSGlueSchemaRegistryFullAccess = 'AWSGlueSchemaRegistryFullAccess';
/** Provides readonly access to the AWS Glue Schema Registry Service */
AwsManagedPolicy.AWSGlueSchemaRegistryReadonlyAccess = 'AWSGlueSchemaRegistryReadonlyAccess';
/** Policy for AWS Glue service role which allows customer to manage notebook server */
AwsManagedPolicy.AWSGlueServiceNotebookRole = 'service-role/AWSGlueServiceNotebookRole';
/** Policy for AWS Glue service role which allows access to related services including EC2, S3, and Cloudwatch Logs */
AwsManagedPolicy.AWSGlueServiceRole = 'service-role/AWSGlueServiceRole';
/** Provides permissions that allows users to create and use only the notebook sessions that are associated with the user. This policy also includes permissions to explicitly allow users to pass a restricted Glue session role. */
AwsManagedPolicy.AwsGlueSessionUserRestrictedNotebookPolicy = 'AwsGlueSessionUserRestrictedNotebookPolicy';
/** Provides full access to all AWS Glue resources except for sessions. Allows users to create and use only the notebook sessions that are associated with the user. This policy also includes other permissions needed by AWS Glue to manage Glue resources in other AWS services. */
AwsManagedPolicy.AwsGlueSessionUserRestrictedNotebookServiceRole = 'service-role/AwsGlueSessionUserRestrictedNotebookServiceRole';
/** Provides permissions that allows users to create and use only the interactive sessions that are associated with the user. This policy also includes permissions to explicitly allow users to pass a restricted Glue session role. */
AwsManagedPolicy.AwsGlueSessionUserRestrictedPolicy = 'AwsGlueSessionUserRestrictedPolicy';
/** Provides full access to all AWS Glue resources except for sessions. Allows users to create and use only the interactive sessions that are associated with the user. This policy also includes other permissions needed by AWS Glue to manage Glue resources in other AWS services */
AwsManagedPolicy.AwsGlueSessionUserRestrictedServiceRole = 'service-role/AwsGlueSessionUserRestrictedServiceRole';
/** Provides access within Amazon Grafana to create and manage workspaces for the entire organization. */
AwsManagedPolicy.AWSGrafanaAccountAdministrator = 'AWSGrafanaAccountAdministrator';
/** Access to read only operations in Amazon Grafana. */
AwsManagedPolicy.AWSGrafanaConsoleReadOnlyAccess = 'AWSGrafanaConsoleReadOnlyAccess';
/** Provides only the ability to update user and group permissions for AWS Grafana workspaces. */
AwsManagedPolicy.AWSGrafanaWorkspacePermissionManagement = 'AWSGrafanaWorkspacePermissionManagement';
/** Provides ability to update IAM Identity Center (IdC) user and group permissions for Amazon Managed Grafana workspaces. */
AwsManagedPolicy.AWSGrafanaWorkspacePermissionManagementV2 = 'AWSGrafanaWorkspacePermissionManagementV2';
/** This policy gives full access to the AWS Greengrass configuration, management and deployment actions */
AwsManagedPolicy.AWSGreengrassFullAccess = 'AWSGreengrassFullAccess';
/** This policy gives read only access to the AWS Greengrass configuration, management and deployment actions */
AwsManagedPolicy.AWSGreengrassReadOnlyAccess = 'AWSGreengrassReadOnlyAccess';
/** Policy for AWS Greengrass service role which allows access to related services including AWS Lambda and AWS IoT thing shadows. */
AwsManagedPolicy.AWSGreengrassResourceAccessRolePolicy = 'service-role/AWSGreengrassResourceAccessRolePolicy';
/** Provides the Dataflow Endpoint Instance permissions to use the AWS Ground Station Agent */
AwsManagedPolicy.AWSGroundStationAgentInstancePolicy = 'AWSGroundStationAgentInstancePolicy';
/** Allows AWS Health to enable the Health event processor feature. */
AwsManagedPolicy.AWSHealthEventProcessorServiceRolePolicy = 'aws-service-role/AWSHealth_EventProcessorServiceRolePolicy';
/** Allows full access to the AWS Health Apis and Notifications and the Personal Health Dashboard */
AwsManagedPolicy.AWSHealthFullAccess = 'AWSHealthFullAccess';
/** Provides full access to AWS Health Imaging service. */
AwsManagedPolicy.AWSHealthImagingFullAccess = 'AWSHealthImagingFullAccess';
/** Provides read only access to AWS Health Imaging service. */
AwsManagedPolicy.AWSHealthImagingReadOnlyAccess = 'AWSHealthImagingReadOnlyAccess';
/** Provides the list of actions that are allowed for roles assumed with the IAM Identity Center identity context. AWS Security Token Service (AWS STS) automatically attaches this policy to assumed roles. The identity context is passed as ProvidedContext. */
AwsManagedPolicy.AWSIAMIdentityCenterAllowListForIdentityContext = 'AWSIAMIdentityCenterAllowListForIdentityContext';
/** Grants full access to the Identity Sync service */
AwsManagedPolicy.AWSIdentitySyncFullAccess = 'AWSIdentitySyncFullAccess';
/** Read only access to the Identity Sync service */
AwsManagedPolicy.AWSIdentitySyncReadOnlyAccess = 'AWSIdentitySyncReadOnlyAccess';
/** Provides full access to all AWS Image Builder actions and resource scoped access to related AWS services. */
AwsManagedPolicy.AWSImageBuilderFullAccess = 'AWSImageBuilderFullAccess';
/** Provides read only access to all AWS Image Builder actions. */
AwsManagedPolicy.AWSImageBuilderReadOnlyAccess = 'AWSImageBuilderReadOnlyAccess';
/** Provides read and write access to the jobs created under the AWS account. */
AwsManagedPolicy.AWSImportExportFullAccess = 'AWSImportExportFullAccess';
/** Provides read only access to the jobs created under the AWS account. */
AwsManagedPolicy.AWSImportExportReadOnlyAccess = 'AWSImportExportReadOnlyAccess';
/** Grants Incident Manager permissions to call other AWS services as a part of managing an incident. */
AwsManagedPolicy.AWSIncidentManagerIncidentAccessServiceRolePolicy = 'AWSIncidentManagerIncidentAccessServiceRolePolicy';
/** This policy grants permissions to start, view, and update incidents with full access to custom timeline events & related items. Assign this policy to users who will create and resolve incidents. */
AwsManagedPolicy.AWSIncidentManagerResolverAccess = 'AWSIncidentManagerResolverAccess';
/** This policy grants Incident Manager permission to manage incident records and related resources on your behalf. */
AwsManagedPolicy.AWSIncidentManagerServiceRolePolicy = 'aws-service-role/AWSIncidentManagerServiceRolePolicy';
/** Provides full access to IoT Analytics. */
AwsManagedPolicy.AWSIoTAnalyticsFullAccess = 'AWSIoTAnalyticsFullAccess';
/** Provides read only access to IoT Analytics. */
AwsManagedPolicy.AWSIoTAnalyticsReadOnlyAccess = 'AWSIoTAnalyticsReadOnlyAccess';
/** This policy gives full access to the AWS IoT configuration actions */
AwsManagedPolicy.AWSIoTConfigAccess = 'AWSIoTConfigAccess';
/** This policy gives read only access to the AWS IoT configuration actions */
AwsManagedPolicy.AWSIoTConfigReadOnlyAccess = 'AWSIoTConfigReadOnlyAccess';
/** This policy gives full access to the AWS IoT messaging actions */
AwsManagedPolicy.AWSIoTDataAccess = 'AWSIoTDataAccess';
/** Provides write access to IoT thing groups and read access to IoT Certificates for execution of ADD_THINGS_TO_THING_GROUP mitigation action */
AwsManagedPolicy.AWSIoTDeviceDefenderAddThingsToThingGroupMitigationAction = 'service-role/AWSIoTDeviceDefenderAddThingsToThingGroupMitigationAction';
/** Provides read access for IoT and related resources */
AwsManagedPolicy.AWSIoTDeviceDefenderAudit = 'service-role/AWSIoTDeviceDefenderAudit';
/** Provides access for enabling IoT logging for execution of ENABLE_IOT_LOGGING mitigation action */
AwsManagedPolicy.AWSIoTDeviceDefenderEnableIoTLoggingMitigationAction = 'service-role/AWSIoTDeviceDefenderEnableIoTLoggingMitigationAction';
/** Provides messages publish access to SNS topic for execution of PUBLISH_FINDING_TO_SNS mitigation action */
AwsManagedPolicy.AWSIoTDeviceDefenderPublishFindingsToSNSMitigationAction = 'service-role/AWSIoTDeviceDefenderPublishFindingsToSNSMitigationAction';
/** Provides write access to IoT policies for execution of REPLACE_DEFAULT_POLICY_VERSION mitigation action */
AwsManagedPolicy.AWSIoTDeviceDefenderReplaceDefaultPolicyMitigationAction = 'service-role/AWSIoTDeviceDefenderReplaceDefaultPolicyMitigationAction';
/** Provides write access to IoT CA certificates for execution of  UPDATE_CA_CERTIFICATE mitigation action */
AwsManagedPolicy.AWSIoTDeviceDefenderUpdateCACertMitigationAction = 'service-role/AWSIoTDeviceDefenderUpdateCACertMitigationAction';
/** Provides write access to IoT certificates for execution of UPDATE_DEVICE_CERTIFICATE mitigation action */
AwsManagedPolicy.AWSIoTDeviceDefenderUpdateDeviceCertMitigationAction = 'service-role/AWSIoTDeviceDefenderUpdateDeviceCertMitigationAction';
/** Allows AWS IoT Device Tester to run the FreeRTOS qualification suite by allowing access to services including IoT, S3, and IAM */
AwsManagedPolicy.AWSIoTDeviceTesterForFreeRTOSFullAccess = 'AWSIoTDeviceTesterForFreeRTOSFullAccess';
/** Allows AWS IoT Device Tester to run the AWS Greengrass qualification suite by allowing access to related services including Lambda, IoT, API Gateway, IAM */
AwsManagedPolicy.AWSIoTDeviceTesterForGreengrassFullAccess = 'AWSIoTDeviceTesterForGreengrassFullAccess';
/** Provides full access to IoT Events. */
AwsManagedPolicy.AWSIoTEventsFullAccess = 'AWSIoTEventsFullAccess';
/** Provides read only access to IoT Events. */
AwsManagedPolicy.AWSIoTEventsReadOnlyAccess = 'AWSIoTEventsReadOnlyAccess';
/** Federation access for IoT Fleet Hub applications */
AwsManagedPolicy.AWSIoTFleetHubFederationAccess = 'service-role/AWSIoTFleetHubFederationAccess';
/** Grants permissions to AWS Resources and metaData used or managed by AWSIoTFleetwise for auxiliary features */
AwsManagedPolicy.AWSIoTFleetwiseServiceRolePolicy = 'aws-service-role/AWSIoTFleetwiseServiceRolePolicy';
/** This policy gives full access to the AWS IoT configuration and messaging actions */
AwsManagedPolicy.AWSIoTFullAccess = 'AWSIoTFullAccess';
/** Allows creation of Amazon CloudWatch Log groups and streaming logs to the groups */
AwsManagedPolicy.AWSIoTLogging = 'service-role/AWSIoTLogging';
/** Provides full access to managed integrations for AWS IoT Device Management and related services. */
AwsManagedPolicy.AWSIoTManagedIntegrationsFullAccess = 'AWSIoTManagedIntegrationsFullAccess';
/** Provides managed integrations for AWS IoT Device Management permission to publish logs and metrics on your behalf. */
AwsManagedPolicy.AWSIoTManagedIntegrationsRolePolicy = 'aws-service-role/AWSIoTManagedIntegrationsRolePolicy';
/** Allows access to create AWS IoT Job and describe the AWS code signer job */
AwsManagedPolicy.AWSIoTOTAUpdate = 'service-role/AWSIoTOTAUpdate';
/** Allows access to all AWS services supported in AWS IoT Rule Actions */
AwsManagedPolicy.AWSIoTRuleActions = 'service-role/AWSIoTRuleActions';
/** Provides full access to manage AWS IoT SiteWise using the AWS Management Console. Note this policy also grants access to create and list data stores used with AWS IoT SiteWise (e.g. AWS IoT Analytics), access to list and view AWS IoT Greengrass resources, list and modify AWS Secrets Manager secrets, retrieve AWS IoT thing shadows, list resources with specific tags, and create and use a service-linked role for AWS IoT SiteWise. */
AwsManagedPolicy.AWSIoTSiteWiseConsoleFullAccess = 'AWSIoTSiteWiseConsoleFullAccess';
/** Provides full access to IoT SiteWise. */
AwsManagedPolicy.AWSIoTSiteWiseFullAccess = 'AWSIoTSiteWiseFullAccess';
/** This policy grants permissions to access AWS IoT SiteWise assets and asset data, create AWS IoT SiteWise Monitor resources, and list AWS SSO users. */
AwsManagedPolicy.AWSIoTSiteWiseMonitorPortalAccess = 'service-role/AWSIoTSiteWiseMonitorPortalAccess';
/** This role grants AWS IoT SiteWise monitor permissions to access your AWS IoT SiteWise assets & asset properties, and create AWS IoT Sitewise projects, dashboards & access policies through AWS IoT SiteWise portals. */
AwsManagedPolicy.AWSIoTSiteWiseMonitorServiceRolePolicy = 'aws-service-role/AWSIoTSiteWiseMonitorServiceRolePolicy';
/** Provides read only access to IoT SiteWise. */
AwsManagedPolicy.AWSIoTSiteWiseReadOnlyAccess = 'AWSIoTSiteWiseReadOnlyAccess';
/** This policy allows users to register things at bulk using AWS IoT StartThingRegistrationTask API */
AwsManagedPolicy.AWSIoTThingsRegistration = 'service-role/AWSIoTThingsRegistration';
/** Allows AWS IoT TwinMaker to call other AWS services and to sync their resources on your behalf. */
AwsManagedPolicy.AWSIoTTwinMakerServiceRolePolicy = 'aws-service-role/AWSIoTTwinMakerServiceRolePolicy';
/** Allows the associated identity data access to AWS IoT Wireless devices. */
AwsManagedPolicy.AWSIoTWirelessDataAccess = 'AWSIoTWirelessDataAccess';
/** Allows the associated identity full access to all AWS IoT Wireless operations. */
AwsManagedPolicy.AWSIoTWirelessFullAccess = 'AWSIoTWirelessFullAccess';
/** Provides IoT Wireless full access to publish to IoT Rules Engine on your behalf. */
AwsManagedPolicy.AWSIoTWirelessFullPublishAccess = 'AWSIoTWirelessFullPublishAccess';
/** Allows the associated identity access to create, list and describe IoT Certificates */
AwsManagedPolicy.AWSIoTWirelessGatewayCertManager = 'AWSIoTWirelessGatewayCertManager';
/** Allows the associated identity to create Amazon CloudWatch Logs groups and stream logs to the groups. */
AwsManagedPolicy.AWSIoTWirelessLogging = 'AWSIoTWirelessLogging';
/** Allows the associated identity read only access to AWS IoT wireless. */
AwsManagedPolicy.AWSIoTWirelessReadOnlyAccess = 'AWSIoTWirelessReadOnlyAccess';
/** Allows VPC IP Address Manager to access VPC resources and integrate with AWS Organizations on your behalf. */
AwsManagedPolicy.AWSIPAMServiceRolePolicy = 'aws-service-role/AWSIPAMServiceRolePolicy';
/** Used by AWS IQ to execute payment requests on behalf of a customer */
AwsManagedPolicy.AWSIQContractServiceRolePolicy = 'aws-service-role/AWSIQContractServiceRolePolicy';
/** Provides full access to AWS IQ */
AwsManagedPolicy.AWSIQFullAccess = 'AWSIQFullAccess';
/** Allows AWS IQ to manage the role assumed by AWS IQ experts. */
AwsManagedPolicy.AWSIQPermissionServiceRolePolicy = 'aws-service-role/AWSIQPermissionServiceRolePolicy';
/** Enables access to AWS services and resources required for AWS KMS custom key stores */
AwsManagedPolicy.AWSKeyManagementServiceCustomKeyStoresServiceRolePolicy = 'aws-service-role/AWSKeyManagementServiceCustomKeyStoresServiceRolePolicy';
/** Enables AWS KMS to synchronize the shared properties of multi-Region keys. */
AwsManagedPolicy.AWSKeyManagementServiceMultiRegionKeysServiceRolePolicy = 'aws-service-role/AWSKeyManagementServiceMultiRegionKeysServiceRolePolicy';
/** Provides access to AWS Key Management Service (KMS). */
AwsManagedPolicy.AWSKeyManagementServicePowerUser = 'AWSKeyManagementServicePowerUser';
/** Provides cross account access to Glue resources via Lake Formation. Also grants read access to other required services such as organizations and resource access manager */
AwsManagedPolicy.AWSLakeFormationCrossAccountManager = 'AWSLakeFormationCrossAccountManager';
/** Grants administrative access to AWS Lake Formation and related services, such as AWS Glue, to manage data lakes */
AwsManagedPolicy.AWSLakeFormationDataAdmin = 'AWSLakeFormationDataAdmin';
/** Grants full access to AWS Lambda service, AWS Lambda console features, and other related AWS services. */
AwsManagedPolicy.AWSLambdaFullAccess = 'AWSLambda_FullAccess';
/** Grants read-only access to AWS Lambda service, AWS Lambda console features, and other related AWS services. */
AwsManagedPolicy.AWSLambdaReadOnlyAccess = 'AWSLambda_ReadOnlyAccess';
/** Provides write permissions to CloudWatch Logs. */
AwsManagedPolicy.AWSLambdaBasicExecutionRole = 'service-role/AWSLambdaBasicExecutionRole';
/** Provides list and read access to DynamoDB streams and write permissions to CloudWatch logs. */
AwsManagedPolicy.AWSLambdaDynamoDBExecutionRole = 'service-role/AWSLambdaDynamoDBExecutionRole';
/** Provides minimum permissions for a Lambda function to manage ENIs (create, describe, delete) used by a VPC-enabled Lambda Function. */
AwsManagedPolicy.AWSLambdaENIManagementAccess = 'service-role/AWSLambdaENIManagementAccess';
/** Provides Put, Get access to S3 and full access to CloudWatch Logs. */
AwsManagedPolicy.AWSLambdaExecute = 'AWSLambdaExecute';
/** Provides read access to DynamoDB Streams. */
AwsManagedPolicy.AWSLambdaInvocationDynamoDB = 'AWSLambdaInvocation-DynamoDB';
/** Provides list and read access to Kinesis streams and write permissions to CloudWatch logs. */
AwsManagedPolicy.AWSLambdaKinesisExecutionRole = 'service-role/AWSLambdaKinesisExecutionRole';
/** Provides permissions required to access MSK Cluster within a VPC, manage ENIs (create, describe, delete) in the VPC and write permissions to CloudWatch Logs. */
AwsManagedPolicy.AWSLambdaMSKExecutionRole = 'service-role/AWSLambdaMSKExecutionRole';
/** Grants Lambda Replicator necessary permissions to replicate functions across regions */
AwsManagedPolicy.AWSLambdaReplicator = 'aws-service-role/AWSLambdaReplicator';
/** Default policy for AWS Lambda service role. */
AwsManagedPolicy.AWSLambdaRole = 'service-role/AWSLambdaRole';
/** Provides receive message, delete message, and read attribute access to SQS queues, and write permissions to CloudWatch logs. */
AwsManagedPolicy.AWSLambdaSQSQueueExecutionRole = 'service-role/AWSLambdaSQSQueueExecutionRole';
/** Provides minimum permissions for a Lambda function to execute while accessing a resource within a VPC - create, describe, delete network interfaces and write permissions to CloudWatch Logs. */
AwsManagedPolicy.AWSLambdaVPCAccessExecutionRole = 'service-role/AWSLambdaVPCAccessExecutionRole';
/** Provides permissions to allow access to the AWS License Manager API actions required to consume upon licenses that the user has entitlements. */
AwsManagedPolicy.AWSLicenseManagerConsumptionPolicy = 'service-role/AWSLicenseManagerConsumptionPolicy';
/** Allows AWS License Manager Linux Subscriptions Service to manage resources on your behalf. */
AwsManagedPolicy.AWSLicenseManagerLinuxSubscriptionsServiceRolePolicy = 'aws-service-role/AWSLicenseManagerLinuxSubscriptionsServiceRolePolicy';
/** AWS License Manager service master account role policy */
AwsManagedPolicy.AWSLicenseManagerMasterAccountRolePolicy = 'aws-service-role/AWSLicenseManagerMasterAccountRolePolicy';
/** AWS License Manager service member account role policy */
AwsManagedPolicy.AWSLicenseManagerMemberAccountRolePolicy = 'aws-service-role/AWSLicenseManagerMemberAccountRolePolicy';
/** AWS License Manager service default role policy */
AwsManagedPolicy.AWSLicenseManagerServiceRolePolicy = 'aws-service-role/AWSLicenseManagerServiceRolePolicy';
/** Allows AWS License Manager User Subscriptions Service to manage resources on your behalf. */
AwsManagedPolicy.AWSLicenseManagerUserSubscriptionsServiceRolePolicy = 'aws-service-role/AWSLicenseManagerUserSubscriptionsServiceRolePolicy';
/** Allows AWS M2 to manage AWS resources on your behalf. */
AwsManagedPolicy.AWSM2ServicePolicy = 'aws-service-role/AWSM2ServicePolicy';
/** Allows AWS Managed Services to read the values of the tags on AWS resources */
AwsManagedPolicy.AWSManagedServicesContactsServiceRolePolicy = 'aws-service-role/AWSManagedServices_ContactsServiceRolePolicy';
/** AWS Managed Services - policy to manage detective controls infrastructure */
AwsManagedPolicy.AWSManagedServicesDetectiveControlsConfigServiceRolePolicy = 'aws-service-role/AWSManagedServices_DetectiveControlsConfig_ServiceRolePolicy';
/** AWS Managed Services policy to enable AMS event processor feature. */
AwsManagedPolicy.AWSManagedServicesEventsServiceRolePolicy = 'aws-service-role/AWSManagedServices_EventsServiceRolePolicy';
/** Allows Amazon's AWS Managed Service's Self Service Reporting feature to read AWS Organization data on your behalf to enable organization level aggregated reporting */
AwsManagedPolicy.AWSManagedServicesSelfServiceReportingServiceRolePolicy = 'aws-service-role/AWSManagedServices_SelfServiceReporting_ServiceRolePolicy';
/** Allows AWS Managed Services to manage deployment toolkit on your behalf. */
AwsManagedPolicy.AWSManagedServicesDeploymentToolkitPolicy = 'aws-service-role/AWSManagedServicesDeploymentToolkitPolicy';
/** Provides full access to configure and customize the AWS Management Console */
AwsManagedPolicy.AWSManagementConsoleAdministratorAccess = 'job-function/AWSManagementConsoleAdministratorAccess';
/** Grants access to essential AWS Management Console features and user experience (UX) capabilities for non-administrative users. */
AwsManagedPolicy.AWSManagementConsoleBasicUserAccess = 'AWSManagementConsoleBasicUserAccess';
/** Allows AWS Marketplace to copy your Amazon Machine Images (AMIs) in order to list them on AWS Marketplace */
AwsManagedPolicy.AWSMarketplaceAmiIngestion = 'AWSMarketplaceAmiIngestion';
/** Allows AWS Marketplace to create and manage seller deployment parameters for the products that you subscribe to on AWS Marketplace. */
AwsManagedPolicy.AWSMarketplaceDeploymentServiceRolePolicy = 'aws-service-role/AWSMarketplaceDeploymentServiceRolePolicy';
/** Provides the ability to subscribe and unsubscribe to AWS Marketplace software, allows users to manage Marketplace software instances from the Marketplace 'Your Software' page, and provides administrative access to EC2. */
AwsManagedPolicy.AWSMarketplaceFullAccess = 'AWSMarketplaceFullAccess';
/** Provides read access to AWS Marketplace Entitlements */
AwsManagedPolicy.AWSMarketplaceGetEntitlements = 'AWSMarketplaceGetEntitlements';
/** Enables access to AWS Services and Resources used or managed by AWS Marketplace for license management. */
AwsManagedPolicy.AWSMarketplaceLicenseManagementServiceRolePolicy = 'aws-service-role/AWSMarketplaceLicenseManagementServiceRolePolicy';
/** Provides the ability to subscribe and unsubscribe to AWS Marketplace software */
AwsManagedPolicy.AWSMarketplaceManageSubscriptions = 'AWSMarketplaceManageSubscriptions';
/** Provides full access to AWS Marketplace Metering. */
AwsManagedPolicy.AWSMarketplaceMeteringFullAccess = 'AWSMarketplaceMeteringFullAccess';
/** Provides permissions to register a resource and track usage through AWS Marketplace Metering Service. */
AwsManagedPolicy.AWSMarketplaceMeteringRegisterUsage = 'AWSMarketplaceMeteringRegisterUsage';
/** Provides full access to all administrative actions for an AWS Marketplace eProcurement integration. */
AwsManagedPolicy.AWSMarketplaceProcurementSystemAdminFullAccess = 'AWSMarketplaceProcurementSystemAdminFullAccess';
/** Enables access for AWS Marketplace services to purchase order management. */
AwsManagedPolicy.AWSMarketplacePurchaseOrdersServiceRolePolicy = 'aws-service-role/AWSMarketplacePurchaseOrdersServiceRolePolicy';
/** Provides the ability to review AWS Marketplace subscriptions */
AwsManagedPolicy.AWSMarketplaceReadOnly = 'AWSMarketplaceRead-only';
/** Enables access to AWS Services and Resources used or managed by AWS Marketplace for Resale Authorization. */
AwsManagedPolicy.AWSMarketplaceResaleAuthorizationServiceRolePolicy = 'aws-service-role/AWSMarketplaceResaleAuthorizationServiceRolePolicy';
/** Provides full access to all seller operations on the AWS Marketplace and other AWS services such as AMI management. */
AwsManagedPolicy.AWSMarketplaceSellerFullAccess = 'AWSMarketplaceSellerFullAccess';
/** Provides sellers access to Offers and Agreements management activities. */
AwsManagedPolicy.AWSMarketplaceSellerOfferManagement = 'AWSMarketplaceSellerOfferManagement';
/** Provides sellers full access to AWS Marketplace Management Products page and other AWS services such as AMI management. */
AwsManagedPolicy.AWSMarketplaceSellerProductsFullAccess = 'AWSMarketplaceSellerProductsFullAccess';
/** Provide sellers read-only access to AWS Marketplace Management Products page. */
AwsManagedPolicy.AWSMarketplaceSellerProductsReadOnly = 'AWSMarketplaceSellerProductsReadOnly';
/** The default policy that enables access to AWS Services and Resources used or managed by MediaConnect. */
AwsManagedPolicy.AWSMediaConnectServicePolicy = 'aws-service-role/AWSMediaConnectServicePolicy';
/** Allows MediaLive Anywhere to create and manage AWS resources on your behalf. */
AwsManagedPolicy.AWSMediaLiveAnywhereServiceRolePolicy = 'aws-service-role/AWSMediaLiveAnywhereServiceRolePolicy';
/** Enable access to AWS Resources used or managed by MediaTailor */
AwsManagedPolicy.AWSMediaTailorServiceRolePolicy = 'aws-service-role/AWSMediaTailorServiceRolePolicy';
/** Policy allows AWSMigrationHubService to call AWSApplicationDiscoveryService on behalf of the customer. */
AwsManagedPolicy.AWSMigrationHubDiscoveryAccess = 'service-role/AWSMigrationHubDiscoveryAccess';
/** Policy for Database Migration Service to assume role in customer's account to call Migration Hub */
AwsManagedPolicy.AWSMigrationHubDMSAccess = 'service-role/AWSMigrationHubDMSAccess';
/** Managed policy to provide the customer access to the Migration Hub Service */
AwsManagedPolicy.AWSMigrationHubFullAccess = 'AWSMigrationHubFullAccess';
/** Provides limited access to AWS Migration Hub, AWS Application Discovery Service, Amazon Simple Storage Service and AWS Secrets Manager. This policy also grants full access to AWS Migration Hub Orchestrator service. */
AwsManagedPolicy.AWSMigrationHubOrchestratorConsoleFullAccess = 'AWSMigrationHubOrchestratorConsoleFullAccess';
/** This policy needs to be attached for SAP and MGN migrated instance for our service to orchestrate instances by downloading scripts from S3 and to fetch secret values inside EC2 instance. */
AwsManagedPolicy.AWSMigrationHubOrchestratorInstanceRolePolicy = 'AWSMigrationHubOrchestratorInstanceRolePolicy';
/** Provides limited access to Amazon Simple Storage Service, AWS Secrets Manager and Plugin related actions for AWS Migration Hub Orchestrator. */
AwsManagedPolicy.AWSMigrationHubOrchestratorPlugin = 'AWSMigrationHubOrchestratorPlugin';
/** Provides permissions necessary for Migration Hub Orchestrator to migrate and modernize your on-premises workloads */
AwsManagedPolicy.AWSMigrationHubOrchestratorServiceRolePolicy = 'aws-service-role/AWSMigrationHubOrchestratorServiceRolePolicy';
/** Grants full access to AWS Migration Hub Refactor Spaces and other AWS related services except AWS Transit Gateway and EC2 security groups not required when using environments without a network bridge. This policy also excludes permissions required for AWS Lambda and AWS Resource Access Manager as they can be scoped down based on tags. */
AwsManagedPolicy.AWSMigrationHubRefactorSpacesEnvironmentsWithoutBridgesFullAccess = 'AWSMigrationHubRefactorSpaces-EnvironmentsWithoutBridgesFullAccess';
/** Use in the IAM service role passed to the SSM Automation document AWSRefactorSpaces-CreateResources to grant permissions required to run the automation. The policy grants read/write access to EC2 tags in order to track automation progress. When the Refactor Spaces environment's network bridge is enabled, the automation also adds the environment's security group to the EC2 instance to permit traffic from other Refactor Spaces services in the environment. The policy also grants access to the Application Migration Service's post launch actions SSM parameters. */
AwsManagedPolicy.AWSMigrationHubRefactorSpacesSSMAutomationPolicy = 'service-role/AWSMigrationHubRefactorSpaces-SSMAutomationPolicy';
/** Grants full access to AWS MigrationHub Refactor Spaces, AWS MigrationHub Refactor Spaces console features and other related AWS services except permissions required for AWS Lambda and AWS Resource Access Manager as they can be scoped down based on tags. */
AwsManagedPolicy.AWSMigrationHubRefactorSpacesFullAccess = 'AWSMigrationHubRefactorSpacesFullAccess';
/** Provides access to AWS Resources managed or used by AWS Migration Hub Refactor Spaces. */
AwsManagedPolicy.AWSMigrationHubRefactorSpacesServiceRolePolicy = 'aws-service-role/AWSMigrationHubRefactorSpacesServiceRolePolicy';
/** Policy for Server Migration Service to assume role in customer's account to call Migration Hub */
AwsManagedPolicy.AWSMigrationHubSMSAccess = 'service-role/AWSMigrationHubSMSAccess';
/** Grants permissions to allow communication with the AWS Migration Hub Strategy Recommendations service, read/write access to S3 buckets related to the service, Amazon API Gateway access to upload logs and metrics to AWS, AWS Secrets Manager access to fetch credentials, and any related services. */
AwsManagedPolicy.AWSMigrationHubStrategyCollector = 'AWSMigrationHubStrategyCollector';
/** Grants full access to the AWS Migration Hub Strategy Recommendations service and access to related AWS services through the AWS Management Console. */
AwsManagedPolicy.AWSMigrationHubStrategyConsoleFullAccess = 'AWSMigrationHubStrategyConsoleFullAccess';
/** Enable access to AWS Resources used or managed by AWS Migration Hub Strategy Recommendations service. */
AwsManagedPolicy.AWSMigrationHubStrategyServiceRolePolicy = 'aws-service-role/AWSMigrationHubStrategyServiceRolePolicy';
/** Grants permissions to Amazon MSK Replicator to replicate data between MSK Clusters. */
AwsManagedPolicy.AWSMSKReplicatorExecutionRole = 'service-role/AWSMSKReplicatorExecutionRole';
/** Grants full access to AWS Network Firewall service, including permissions to create, configure, manage, and delete firewall resources, policies, and rule groups. Additionally includes permissions to modify VPC endpoints, S3 bucket policies, CloudWatch Logs configurations, and create service-linked roles for Network Firewall and log delivery services */
AwsManagedPolicy.AWSNetworkFirewallFullAccess = 'AWSNetworkFirewallFullAccess';
/** Provides read-only access to AWS Network Firewall resources via the AWS Management Console, CLI, and SDKs. This policy allows users to view and monitor firewall configurations, policies, rule groups, and associated resources, without the ability to make changes. */
AwsManagedPolicy.AWSNetworkFirewallReadOnlyAccess = 'AWSNetworkFirewallReadOnlyAccess';
/** Allow AWSNetworkFirewall to create and manage necessary resources for your Firewalls. */
AwsManagedPolicy.AWSNetworkFirewallServiceRolePolicy = 'aws-service-role/AWSNetworkFirewallServiceRolePolicy';
/** Allow NetworkManager to access resources associated with your Core Network */
AwsManagedPolicy.AWSNetworkManagerCloudWANServiceRolePolicy = 'aws-service-role/AWSNetworkManagerCloudWANServiceRolePolicy';
/** Provides full access to Amazon NetworkManager via the AWS Management Console. */
AwsManagedPolicy.AWSNetworkManagerFullAccess = 'AWSNetworkManagerFullAccess';
/** Provides read only access to Amazon NetworkManager via the AWS Management Console. */
AwsManagedPolicy.AWSNetworkManagerReadOnlyAccess = 'AWSNetworkManagerReadOnlyAccess';
/** Allow NetworkManager to access resources associated with your Global Networks */
AwsManagedPolicy.AWSNetworkManagerServiceRolePolicy = 'aws-service-role/AWSNetworkManagerServiceRolePolicy';
/** Service-linked role permissions for CloudWatch Logs centralization */
AwsManagedPolicy.AWSObservabilityAdminLogsCentralizationServiceRolePolicy = 'aws-service-role/AWSObservabilityAdminLogsCentralizationServiceRolePolicy';
/** Provides access to manage AWS Config Configuration Recorder, manage AWS Config Configuration Aggregator, create AWS Config Service Linked Role for Configuration Recorder functionality, consume recorder configuration data, and read AWS Organizations data for organizational features. */
AwsManagedPolicy.AWSObservabilityAdminServiceRolePolicy = 'aws-service-role/AWSObservabilityAdminServiceRolePolicy';
/** Provides access to manage AWS Config recorder resource and telemetry settings on AWS resources including logs, metrics. */
AwsManagedPolicy.AWSObservabilityAdminTelemetryEnablementServiceRolePolicy = 'aws-service-role/AWSObservabilityAdminTelemetryEnablementServiceRolePolicy';
/** Provides full access to AWS Organizations. */
AwsManagedPolicy.AWSOrganizationsFullAccess = 'AWSOrganizationsFullAccess';
/** Provides read-only access to AWS Organizations. */
AwsManagedPolicy.AWSOrganizationsReadOnlyAccess = 'AWSOrganizationsReadOnlyAccess';
/** A policy to allow AWS Organizations to share trust with other approved AWS Services for the purpose of simplifying customer configuration. */
AwsManagedPolicy.AWSOrganizationsServiceTrustPolicy = 'aws-service-role/AWSOrganizationsServiceTrustPolicy';
/** This policy grants permissions that allow you to install an Outpost server on your on-premises network. */
AwsManagedPolicy.AWSOutpostsAuthorizeServerPolicy = 'AWSOutpostsAuthorizeServerPolicy';
/** Service Linked Role policy to enable access to AWS resources managed by AWS Outposts */
AwsManagedPolicy.AWSOutpostsServiceRolePolicy = 'aws-service-role/AWSOutpostsServiceRolePolicy';
/** Allows AWS IoT software on an AWS Panorama Appliance to upload logs to Amazon CloudWatch. */
AwsManagedPolicy.AWSPanoramaApplianceRolePolicy = 'service-role/AWSPanoramaApplianceRolePolicy';
/** Allows an AWS Panorama Appliance to upload logs to Amazon CloudWatch, and to get objects from Amazon S3 access points created for use with AWS Panorama. */
AwsManagedPolicy.AWSPanoramaApplianceServiceRolePolicy = 'service-role/AWSPanoramaApplianceServiceRolePolicy';
/** Provides full access to AWS Panorama */
AwsManagedPolicy.AWSPanoramaFullAccess = 'AWSPanoramaFullAccess';
/** Allows an AWS Lambda function on an AWS Panorama Appliance to manage resources in Panorama, upload logs and metrics to Amazon CloudWatch, and to manage objects in buckets created for use with Panorama. */
AwsManagedPolicy.AWSPanoramaGreengrassGroupRolePolicy = 'service-role/AWSPanoramaGreengrassGroupRolePolicy';
/** Allows Amazon SageMaker to manage objects in buckets created for use with AWS Panorama. */
AwsManagedPolicy.AWSPanoramaSageMakerRolePolicy = 'service-role/AWSPanoramaSageMakerRolePolicy';
/** Allows AWS Panorama to manage resources in AWS IoT, AWS Secrets Manager and AWS Panorama. */
AwsManagedPolicy.AWSPanoramaServiceLinkedRolePolicy = 'aws-service-role/AWSPanoramaServiceLinkedRolePolicy';
/** Allows AWS Panorama to manage resources in Amazon S3, AWS IoT, AWS IoT GreenGrass, AWS Lambda, Amazon SageMaker, and Amazon CloudWatch Logs, and to pass service roles to AWS IoT, AWS IoT GreenGrass, and Amazon SageMaker. */
AwsManagedPolicy.AWSPanoramaServiceRolePolicy = 'service-role/AWSPanoramaServiceRolePolicy';
/** Provides full access to AWS Partner Central and related AWS Services. */
AwsManagedPolicy.AWSPartnerCentralFullAccess = 'AWSPartnerCentralFullAccess';
/** Provides necessary access for opportunity management activities. */
AwsManagedPolicy.AWSPartnerCentralOpportunityManagement = 'AWSPartnerCentralOpportunityManagement';
/** Provides necessary access for developer testing in the Sandbox catalog. */
AwsManagedPolicy.AWSPartnerCentralSandboxFullAccess = 'AWSPartnerCentralSandboxFullAccess';
/** Provides access to the ResourceSnapshotJob to read a resource and snapshot it in the target engagement. */
AwsManagedPolicy.AWSPartnerCentralSellingResourceSnapshotJobExecutionRolePolicy = 'AWSPartnerCentralSellingResourceSnapshotJobExecutionRolePolicy';
/** This policy can be used to grant read-only access to APIs that can read service metadata for services in your AWS account. You can use this policy to provide your partners in the Partner-Led Support Program with access to the services specified in the permissions details section below. */
AwsManagedPolicy.AWSPartnerLedSupportReadOnlyAccess = 'AWSPartnerLedSupportReadOnlyAccess';
/** Grants permission to AWS PCS compute nodes to connect to AWS PCS clusters. */
AwsManagedPolicy.AWSPCSComputeNodePolicy = 'AWSPCSComputeNodePolicy';
/** Grants permissions to PCS to manage resources on your behalf. */
AwsManagedPolicy.AWSPCSServiceRolePolicy = 'aws-service-role/AWSPCSServiceRolePolicy';
/** Provides full access to AWS Price List Service. */
AwsManagedPolicy.AWSPriceListServiceFullAccess = 'AWSPriceListServiceFullAccess';
/** Provides auditor access to AWS Private Certificate Authority */
AwsManagedPolicy.AWSPrivateCAAuditor = 'AWSPrivateCAAuditor';
/** Grants essential permissions for the AWS Private CA Connector for Kubernetes. */
AwsManagedPolicy.AWSPrivateCAConnectorForKubernetesPolicy = 'AWSPrivateCAConnectorForKubernetesPolicy';
/** Provides full access to AWS Private Certificate Authority */
AwsManagedPolicy.AWSPrivateCAFullAccess = 'AWSPrivateCAFullAccess';
/** Provides privileged certificate user access to AWS Private Certificate Authority */
AwsManagedPolicy.AWSPrivateCAPrivilegedUser = 'AWSPrivateCAPrivilegedUser';
/** Provides read only access to AWS Private Certificate Authority */
AwsManagedPolicy.AWSPrivateCAReadOnly = 'AWSPrivateCAReadOnly';
/** Provides certificate user access to AWS Private Certificate Authority */
AwsManagedPolicy.AWSPrivateCAUser = 'AWSPrivateCAUser';
/** Provides full access to all administrative actions for an AWS Private Marketplace. */
AwsManagedPolicy.AWSPrivateMarketplaceAdminFullAccess = 'AWSPrivateMarketplaceAdminFullAccess';
/** Provides access to creating requests in an AWS Private Marketplace. */
AwsManagedPolicy.AWSPrivateMarketplaceRequests = 'AWSPrivateMarketplaceRequests';
/** Allows AWS Private Networks Service to manage resources on behalf of the customer. */
AwsManagedPolicy.AWSPrivateNetworksServiceRolePolicy = 'aws-service-role/AWSPrivateNetworksServiceRolePolicy';
/** Permissions CodeBuild needs to run a build for AWS Proton CodeBuild Provisioning. */
AwsManagedPolicy.AWSProtonCodeBuildProvisioningBasicAccess = 'AWSProtonCodeBuildProvisioningBasicAccess';
/** Allows AWS Proton to manage Proton resource provisioning using CodeBuild and other AWS services on your behalf. */
AwsManagedPolicy.AWSProtonCodeBuildProvisioningServiceRolePolicy = 'aws-service-role/AWSProtonCodeBuildProvisioningServiceRolePolicy';
/** Provides access to the AWS Proton APIs and Management Console, but does not allow administration of Proton templates or environments. */
AwsManagedPolicy.AWSProtonDeveloperAccess = 'AWSProtonDeveloperAccess';
/** Provides full access to the AWS Proton APIs and Management Console. In addition to these permissions, access to Amazon S3 is also needed to register template bundles from your S3 buckets, as well as access to Amazon IAM to create and manage the service roles for Proton. */
AwsManagedPolicy.AWSProtonFullAccess = 'AWSProtonFullAccess';
/** Provides read only access to the AWS Proton APIs and Management Console. */
AwsManagedPolicy.AWSProtonReadOnlyAccess = 'AWSProtonReadOnlyAccess';
/** Policy which allows AWS Proton to sync your service, environment and component definitions from your git repository to AWS Proton. */
AwsManagedPolicy.AWSProtonServiceGitSyncServiceRolePolicy = 'aws-service-role/AWSProtonServiceGitSyncServiceRolePolicy';
/** Policy which allows AWS Proton to sync your git repository contents to Proton or sync Proton contents to your git repositories. */
AwsManagedPolicy.AWSProtonSyncServiceRolePolicy = 'aws-service-role/AWSProtonSyncServiceRolePolicy';
/** Grants permissions to view and modify purchase orders on billing console */
AwsManagedPolicy.AWSPurchaseOrdersServiceRolePolicy = 'AWSPurchaseOrdersServiceRolePolicy';
/** The AWSQuickSetupCFGCPacksPermissionsBoundary policy defines the list of permissions that are permitted in an IAM role created by Quick Setup. Quick Setup uses a role created with this policy to deploy AWS Config conformance packs. */
AwsManagedPolicy.AWSQuickSetupCFGCPacksPermissionsBoundary = 'AWSQuickSetupCFGCPacksPermissionsBoundary';
/** Provides permissions for AWS Systems Manager Quick Setup to deploy multiple configuration types. These configuration types create IAM roles and automations that configure frequently used Amazon Web Services services and features with recommended best practices. */
AwsManagedPolicy.AWSQuickSetupDeploymentRolePolicy = 'AWSQuickSetupDeploymentRolePolicy';
/** The AWSQuickSetupDevOpsGuruPermissionsBoundary policy defines the list of permissions that are permitted in an IAM role created by Quick Setup. Quick Setup uses a role created with this policy to enable and configure Amazon DevOps Guru. This policy also provides permissions to enable Systems Manager Explorer. */
AwsManagedPolicy.AWSQuickSetupDevOpsGuruPermissionsBoundary = 'AWSQuickSetupDevOpsGuruPermissionsBoundary';
/** QuickSetup creates IAM roles which enable it to configure the Systems Manager Distributor feature on your behalf, and uses this policy when creating such roles to define the boundary of their permissions. */
AwsManagedPolicy.AWSQuickSetupDistributorPermissionsBoundary = 'AWSQuickSetupDistributorPermissionsBoundary';
/** This policy grants permissions that allow Systems Manager to run the AWSQuickSetupType-EnableAREX Automation runbook, which enables AWS Resource Explorer for use with Systems Manager. */
AwsManagedPolicy.AWSQuickSetupEnableAREXExecutionPolicy = 'AWSQuickSetupEnableAREXExecutionPolicy';
/** This policy grants permissions that allow principals to run the AWSQuickSetupType-EnableDHMC Automation runbook, which enables Default Host Management Configuration. */
AwsManagedPolicy.AWSQuickSetupEnableDHMCExecutionPolicy = 'AWSQuickSetupEnableDHMCExecutionPolicy';
/** This policy allows Quick Setup to deploy the configuration type required to set up just-in-time node access. */
AwsManagedPolicy.AWSQuickSetupJITNADeploymentRolePolicy = 'AWSQuickSetupJITNADeploymentRolePolicy';
/** This policy grants administrative permissions that allow Systems Manager to create a default IAM instance profile for the Quick Setup capability and attach it to Amazon EC2 instances that don't already have an instance. profile attached. */
AwsManagedPolicy.AWSQuickSetupManagedInstanceProfileExecutionPolicy = 'AWSQuickSetupManagedInstanceProfileExecutionPolicy';
/** This policy provides permissions to enable just-in-time node access for Systems Manager. */
AwsManagedPolicy.AWSQuickSetupManageJITNAResourcesExecutionPolicy = 'AWSQuickSetupManageJITNAResourcesExecutionPolicy';
/** Provides read-only permissions to access patch baselines that have been configured by an administrator in the current AWS account or organization using Quick Setup. */
AwsManagedPolicy.AWSQuickSetupPatchPolicyBaselineAccess = 'AWSQuickSetupPatchPolicyBaselineAccess';
/** Provides permissions that allow Quick Setup to create resources associated with a patch policy configuration. */
AwsManagedPolicy.AWSQuickSetupPatchPolicyDeploymentRolePolicy = 'AWSQuickSetupPatchPolicyDeploymentRolePolicy';
/** QuickSetup creates IAM roles which enable it to configure the Systems Manager Patch Manager feature on your behalf, and uses this policy when creating such roles to define the boundary of their permissions. */
AwsManagedPolicy.AWSQuickSetupPatchPolicyPermissionsBoundary = 'AWSQuickSetupPatchPolicyPermissionsBoundary';
/** The AWSQuickSetupSchedulerPermissionsBoundary policy defines the list of permissions that are permitted in an IAM role created by Quick Setup. Quick Setup uses a role created with this policy to enable and configure scheduled operations on Amazon EC2 instances and other resources. */
AwsManagedPolicy.AWSQuickSetupSchedulerPermissionsBoundary = 'AWSQuickSetupSchedulerPermissionsBoundary';
/** This policy grants administrative permssions that allow Quick Setup to create resources that are used during the Systems Manager onboarding process. */
AwsManagedPolicy.AWSQuickSetupSSMDeploymentRolePolicy = 'AWSQuickSetupSSMDeploymentRolePolicy';
/** This policy grants permissions for listing all S3 buckets in an account; and for managing and retrieving information about specific buckets in the principal account that are managed through AWS CloudFormation templates. */
AwsManagedPolicy.AWSQuickSetupSSMDeploymentS3BucketRolePolicy = 'AWSQuickSetupSSMDeploymentS3BucketRolePolicy';
/** Quick Setup creates IAM roles which enable it to configure the Host Manager Quick Setup type on your behalf, and uses this policy when creating such roles to define the boundary of their permissions. */
AwsManagedPolicy.AWSQuickSetupSSMHostMgmtPermissionsBoundary = 'AWSQuickSetupSSMHostMgmtPermissionsBoundary';
/** The policy grants administrative permissions that allow Quick Setup to run the a AWS CloudFormation custom resource on lifecycle events during Quick Setup deployment in Systems Manager. */
AwsManagedPolicy.AWSQuickSetupSSMLifecycleManagementExecutionPolicy = 'AWSQuickSetupSSMLifecycleManagementExecutionPolicy';
/** This policy grants permissions that allow Systems Manager to create prerequisites such as IAM roles required for Systems Manager onboarding. */
AwsManagedPolicy.AWSQuickSetupSSMManageResourcesExecutionPolicy = 'AWSQuickSetupSSMManageResourcesExecutionPolicy';
/** This policy grants permissions that allow principals to run the AWSQuickSetupType-StartSSMAssociations Automation runbook, which starts State Manager Associations. */
AwsManagedPolicy.AWSQuickSetupStartSSMAssociationsExecutionPolicy = 'AWSQuickSetupStartSSMAssociationsExecutionPolicy';
/** The managed policy AWSQuickSetupStartStopInstancesExecutionPolicy provides permissions for Quick Setup to start and stop Amazon EC2 instances on a schedule. This policy is used with the Quick Setup scheduler configuration type. */
AwsManagedPolicy.AWSQuickSetupStartStopInstancesExecutionPolicy = 'AWSQuickSetupStartStopInstancesExecutionPolicy';
/** Provides the set of permissions required to perform QuickSight Asset Bundle Export Operations */
AwsManagedPolicy.AWSQuickSightAssetBundleExportPolicy = 'AWSQuickSightAssetBundleExportPolicy';
/** Provides the set of permissions required to perform QuickSight Asset Bundle Import Operations */
AwsManagedPolicy.AWSQuickSightAssetBundleImportPolicy = 'AWSQuickSightAssetBundleImportPolicy';
/** Quicksight access to Athena API and S3 buckets used for Athena query results */
AwsManagedPolicy.AWSQuicksightAthenaAccess = 'service-role/AWSQuicksightAthenaAccess';
/** Allow QuickSight to describe the RDS resources */
AwsManagedPolicy.AWSQuickSightDescribeRDS = 'service-role/AWSQuickSightDescribeRDS';
/** Allow QuickSight to describe Redshift resources */
AwsManagedPolicy.AWSQuickSightDescribeRedshift = 'service-role/AWSQuickSightDescribeRedshift';
/** Provides access to Amazon Elasticsearch resources from Amazon QuickSight */
AwsManagedPolicy.AWSQuickSightElasticsearchPolicy = 'service-role/AWSQuickSightElasticsearchPolicy';
/** Give QuickSight read-only access to IoT Analytics datasets */
AwsManagedPolicy.AWSQuickSightIoTAnalyticsAccess = 'AWSQuickSightIoTAnalyticsAccess';
/** Allow QuickSight to list IAM entities */
AwsManagedPolicy.AWSQuickSightListIAM = 'service-role/AWSQuickSightListIAM';
/** Provides access to Amazon OpenSearch resources from Amazon QuickSight */
AwsManagedPolicy.AWSQuicksightOpenSearchPolicy = 'service-role/AWSQuicksightOpenSearchPolicy';
/** Provides access to Amazon SageMaker resources from Amazon QuickSight */
AwsManagedPolicy.AWSQuickSightSageMakerPolicy = 'service-role/AWSQuickSightSageMakerPolicy';
/** Policy used by QuickSight to create secrets in AWS Secrets Manager and to attach resource policies on existing QuickSight secrets. */
AwsManagedPolicy.AWSQuickSightSecretsManagerWriteAccess = 'service-role/AWSQuickSightSecretsManagerWriteAccess';
/** Policy used by QuickSight to create secrets in AWS Secrets Manager and to attach resource policies on existing QuickSight secrets. */
AwsManagedPolicy.AWSQuickSightSecretsManagerWritePolicy = 'AWSQuickSightSecretsManagerWritePolicy';
/** AWS QuickSight access to AWS Timestream APIs. Customers can attach this policy to AWS QuickSight role to allow retrieval of data and metadata. */
AwsManagedPolicy.AWSQuickSightTimestreamPolicy = 'service-role/AWSQuickSightTimestreamPolicy';
/** Allows VPC Reachability Analyzer to access AWS resources and integrate with AWS Organizations on your behalf. */
AwsManagedPolicy.AWSReachabilityAnalyzerServiceRolePolicy = 'aws-service-role/AWSReachabilityAnalyzerServiceRolePolicy';
/** This policy grants permission to use AWS services with the AWS Toolkit for .NET Refactoring extension for Microsoft Visual Studio. It is intended to be attached to a local AWS profile. The policy allows uploading application artifacts and downloading the resulting artifacts from Amazon S3. It allows building applications into a container image using AWS CodeBuild and storing and retrieving the images from Amazon Elastic Container Registry (Amazon ECR). And it allows deployment of the application to container services on AWS such as Amazon Elastic Container Service (Amazon ECS), optional creation of VPC resources, optional connection to existing infrastructure such as AWS Directory Service, and other related services. */
AwsManagedPolicy.AWSRefactoringToolkitFullAccess = 'AWSRefactoringToolkitFullAccess';
/** This policy is intended to be used by Amazon ECS Tasks created for testing applications in AWS using the AWS Toolkit for .NET Refactoring extension for Microsoft Visual Studio. The policy grants access to download application artifacts from Amazon S3, communicate the status of the Task using AWS Systems Manager, and other required services. */
AwsManagedPolicy.AWSRefactoringToolkitSidecarPolicy = 'AWSRefactoringToolkitSidecarPolicy';
/** Provides re:Post Private access to publish CloudWatch metrics data */
AwsManagedPolicy.AWSrePostPrivateCloudWatchAccess = 'aws-service-role/AWSrePostPrivateCloudWatchAccess';
/** This policy allows the re:Post Space service to create, manage, and resolve Support cases that are created through the Space application. */
AwsManagedPolicy.AWSRepostSpaceSupportOperationsPolicy = 'AWSRepostSpaceSupportOperationsPolicy';
/** Policy for AWS Resilience Hub service role which allows access to other AWS services in order to execute assessment. */
AwsManagedPolicy.AWSResilienceHubAsssessmentExecutionPolicy = 'AWSResilienceHubAsssessmentExecutionPolicy';
/** Provides full access to AWS Resource Access Manager */
AwsManagedPolicy.AWSResourceAccessManagerFullAccess = 'AWSResourceAccessManagerFullAccess';
/** Provides read only access to AWS Resource Access Manager. */
AwsManagedPolicy.AWSResourceAccessManagerReadOnlyAccess = 'AWSResourceAccessManagerReadOnlyAccess';
/** Provides access to AWS Resource Access Manager APIs needed by a resource share participant. */
AwsManagedPolicy.AWSResourceAccessManagerResourceShareParticipantAccess = 'AWSResourceAccessManagerResourceShareParticipantAccess';
/** Policy containing Read-only AWS Resource Access Manager access to customers' Organizations structure. It also contains IAM permissions to self-delete the role. */
AwsManagedPolicy.AWSResourceAccessManagerServiceRolePolicy = 'aws-service-role/AWSResourceAccessManagerServiceRolePolicy';
/** This policy grants administrative permissions to access Resource Explorer resources and grants read-only permissions to other AWS services to support this access. */
AwsManagedPolicy.AWSResourceExplorerFullAccess = 'AWSResourceExplorerFullAccess';
/** This policy grants administrative permissions to Resource Explorer and grants read-only permissions to other AWS services to support this access. The AWS Organizations administrator needs these permissions to setup and manage multi-account search in the console. */
AwsManagedPolicy.AWSResourceExplorerOrganizationsAccess = 'AWSResourceExplorerOrganizationsAccess';
/** This policy grants read-only permissions to search for and view Resource Explorer resources and grants read-only permissions to other AWS services to support this access. */
AwsManagedPolicy.AWSResourceExplorerReadOnlyAccess = 'AWSResourceExplorerReadOnlyAccess';
/** Allows Resource Explorer to view resources and CloudTrail events on your behalf to index your resources for search. */
AwsManagedPolicy.AWSResourceExplorerServiceRolePolicy = 'aws-service-role/AWSResourceExplorerServiceRolePolicy';
/** This is the read only policy for AWS Resource Groups */
AwsManagedPolicy.AWSResourceGroupsReadOnlyAccess = 'AWSResourceGroupsReadOnlyAccess';
/** Provides full access to AWS RoboMaker via the AWS Management Console and SDK. Also provides select access to related services (e.g., S3, IAM). */
AwsManagedPolicy.AWSRoboMakerFullAccess = 'AWSRoboMaker_FullAccess';
/** Provides read only access to AWS RoboMaker via the AWS Management Console and SDK */
AwsManagedPolicy.AWSRoboMakerReadOnlyAccess = 'AWSRoboMakerReadOnlyAccess';
/** RoboMaker service policy */
AwsManagedPolicy.AWSRoboMakerServicePolicy = 'aws-service-role/AWSRoboMakerServicePolicy';
/** RoboMaker service policy */
AwsManagedPolicy.AWSRoboMakerServiceRolePolicy = 'AWSRoboMakerServiceRolePolicy';
/** Provides all permissions to IAM Roles Anywhere resources, including but not limited to: CreateProfile, DeleteTrustAnchor, DisableCRL, ResetNotificationSettings. */
AwsManagedPolicy.AWSRolesAnywhereFullAccess = 'AWSRolesAnywhereFullAccess';
/** Provides read-only permissions to IAM Roles Anywhere resources, including but not limited to: GetTrustAnchor, ListProfiles, GetCRL. There will be no other permissions for other services included in this policy. */
AwsManagedPolicy.AWSRolesAnywhereReadOnly = 'AWSRolesAnywhereReadOnly';
/** Allows IAM Roles Anywhere to publish service/usage metrics to CloudWatch and check the status of Private Certificate Authorities on your behalf. */
AwsManagedPolicy.AWSRolesAnywhereServicePolicy = 'aws-service-role/AWSRolesAnywhereServicePolicy';
/** Allow Amazon S3 on Outposts service to manage EC2 network resources on your behalf. */
AwsManagedPolicy.AWSS3OnOutpostsServiceRolePolicy = 'aws-service-role/AWSS3OnOutpostsServiceRolePolicy';
/** Provides full access to Savings Plans service */
AwsManagedPolicy.AWSSavingsPlansFullAccess = 'AWSSavingsPlansFullAccess';
/** Provides read only access to Savings Plans service */
AwsManagedPolicy.AWSSavingsPlansReadOnlyAccess = 'AWSSavingsPlansReadOnlyAccess';
/** Provides full access to use AWS Security Hub. */
AwsManagedPolicy.AWSSecurityHubFullAccess = 'AWSSecurityHubFullAccess';
/** Grants permission to enable and manage AWS Security Hub within an organization. Includes enabling the service across the organization, and determining the delegated administrator account for the service. */
AwsManagedPolicy.AWSSecurityHubOrganizationsAccess = 'AWSSecurityHubOrganizationsAccess';
/** Provides read only access to AWS Security Hub resources */
AwsManagedPolicy.AWSSecurityHubReadOnlyAccess = 'AWSSecurityHubReadOnlyAccess';
/** A service-linked role required for AWS Security Hub to access your resources. */
AwsManagedPolicy.AWSSecurityHubServiceRolePolicy = 'aws-service-role/AWSSecurityHubServiceRolePolicy';
/** This policy allows Security Hub to manage AWS Config rules and Security Hub resources in your organization and on your behalf. */
AwsManagedPolicy.AWSSecurityHubV2ServiceRolePolicy = 'aws-service-role/AWSSecurityHubV2ServiceRolePolicy';
/** Policy provides customers with Read and Write permissions to case resources that are created through the Security Incident Response service. */
AwsManagedPolicy.AWSSecurityIncidentResponseCaseFullAccess = 'AWSSecurityIncidentResponseCaseFullAccess';
/** Policy provides customers with Read and Write permissions to all resources associated to the Security Incident Response service. */
AwsManagedPolicy.AWSSecurityIncidentResponseFullAccess = 'AWSSecurityIncidentResponseFullAccess';
/** Policy provides customers with Read-only permissions to all resources associated to the Security Incident Response service. Permission includes access to GetCaseAttachmentDownloadUrl as well for the ability to get case attachment download URLs. */
AwsManagedPolicy.AWSSecurityIncidentResponseReadOnlyAccess = 'AWSSecurityIncidentResponseReadOnlyAccess';
/** Provides access to AWS Resources managed or used by Security Incident Response */
AwsManagedPolicy.AWSSecurityIncidentResponseServiceRolePolicy = 'aws-service-role/AWSSecurityIncidentResponseServiceRolePolicy';
/** Provides access to AWS Security Incident Response to continuously monitor your environment for security threats, tune security services to reduce alert noise, and gather information to investigate potential incidents. */
AwsManagedPolicy.AWSSecurityIncidentResponseTriageServiceRolePolicy = 'aws-service-role/AWSSecurityIncidentResponseTriageServiceRolePolicy';
/** Provides full access to service catalog admin capabilities */
AwsManagedPolicy.AWSServiceCatalogAdminFullAccess = 'AWSServiceCatalogAdminFullAccess';
/** Provides read-only access to Service Catalog admin capabilities */
AwsManagedPolicy.AWSServiceCatalogAdminReadOnlyAccess = 'AWSServiceCatalogAdminReadOnlyAccess';
/** Provides full access to Service Catalog App Registry capabilities */
AwsManagedPolicy.AWSServiceCatalogAppRegistryFullAccess = 'AWSServiceCatalogAppRegistryFullAccess';
/** Provides read-only access to Service Catalog App Registry capabilites */
AwsManagedPolicy.AWSServiceCatalogAppRegistryReadOnlyAccess = 'AWSServiceCatalogAppRegistryReadOnlyAccess';
/** Allows Service Catalog AppRegistry to manage Resource Groups on your behalf */
AwsManagedPolicy.AWSServiceCatalogAppRegistryServiceRolePolicy = 'aws-service-role/AWSServiceCatalogAppRegistryServiceRolePolicy';
/** Provides full access to service catalog enduser capabilities */
AwsManagedPolicy.AWSServiceCatalogEndUserFullAccess = 'AWSServiceCatalogEndUserFullAccess';
/** Provides read-only access to Service Catalog end-user capabilities */
AwsManagedPolicy.AWSServiceCatalogEndUserReadOnlyAccess = 'AWSServiceCatalogEndUserReadOnlyAccess';
/** A Service Linked Role Policy for AWS ServiceCatalog to sync with AWS Organizations organization structure */
AwsManagedPolicy.AWSServiceCatalogOrgsDataSyncServiceRolePolicy = 'aws-service-role/AWSServiceCatalogOrgsDataSyncServiceRolePolicy';
/** A Service Linked Role for AWS ServiceCatalog to sync Provisioning Artifacts from source repositories */
AwsManagedPolicy.AWSServiceCatalogSyncServiceRolePolicy = 'aws-service-role/AWSServiceCatalogSyncServiceRolePolicy';
/** Permissions required for managing nodegroups in the customer's account. These policies related to management of the following resources: AutoscalingGroups, SecurityGroups, LaunchTemplates and InstanceProfiles. */
AwsManagedPolicy.AWSServiceRoleForAmazonEKSNodegroup = 'aws-service-role/AWSServiceRoleForAmazonEKSNodegroup';
/** This Service Linked Role provides Amazon Q Developer ability to provide usage information. */
AwsManagedPolicy.AWSServiceRoleForAmazonQDeveloper = 'aws-service-role/AWSServiceRoleForAmazonQDeveloper';
/** This Service-Linked Role provides AWS Transform with the ability to provide usage information. */
AwsManagedPolicy.AWSServiceRoleForAWSTransform = 'aws-service-role/AWSServiceRoleForAWSTransform';
/** Provides access to Systems Manager resources used by CloudWatch Alarms */
AwsManagedPolicy.AWSServiceRoleForCloudWatchAlarmsActionSSMServiceRolePolicy = 'aws-service-role/AWSServiceRoleForCloudWatchAlarmsActionSSMServiceRolePolicy';
/** Allows CloudWatch to access RDS Performance Insights metrics on your behalf */
AwsManagedPolicy.AWSServiceRoleForCloudWatchMetricsDbPerfInsightsServiceRolePolicy = 'aws-service-role/AWSServiceRoleForCloudWatchMetrics_DbPerfInsightsServiceRolePolicy';
/** A service-linked role required for Amazon CodeGuru Profiler to send notifications on your behalf. */
AwsManagedPolicy.AWSServiceRoleForCodeGuruProfiler = 'aws-service-role/AWSServiceRoleForCodeGuru-Profiler';
/** This role grants permissions to CodeWhisperer to access data in your account to calculate billing, provides access to create and access security reports in Amazon CodeGuru, and emit data to CloudWatch. */
AwsManagedPolicy.AWSServiceRoleForCodeWhispererPolicy = 'aws-service-role/AWSServiceRoleForCodeWhispererPolicy';
/** Allows EC2 Scheduled Instances to launch and manage spot instances. */
AwsManagedPolicy.AWSServiceRoleForEC2ScheduledInstances = 'aws-service-role/AWSServiceRoleForEC2ScheduledInstances';
/** AWS GroundStation uses this service-linked role to invoke EC2 to find public IPv4 addresses */
AwsManagedPolicy.AWSServiceRoleForGroundStationDataflowEndpointGroupPolicy = 'aws-service-role/AWSServiceRoleForGroundStationDataflowEndpointGroupPolicy';
/** Allows EC2ImageBuilder to call AWS services on your behalf. */
AwsManagedPolicy.AWSServiceRoleForImageBuilder = 'aws-service-role/AWSServiceRoleForImageBuilder';
/** Allows AWS IoT SiteWise to provision and manage gateways as well as query data. The policy includes required AWS Greengrass permissions for deploying to groups, AWS Lambda permissions for creating and updating service-prefixed functions, and AWS IoT Analytics permissions for querying data from datastores. */
AwsManagedPolicy.AWSServiceRoleForIoTSiteWise = 'aws-service-role/AWSServiceRoleForIoTSiteWise';
/** Allows Log Delivery service to deliver logs by calling log destination on your behalf. */
AwsManagedPolicy.AWSServiceRoleForLogDeliveryPolicy = 'aws-service-role/AWSServiceRoleForLogDeliveryPolicy';
/** Grants Amazon Monitron permissions to manage AWS resources, including AWS SSO user assignment on your behalf. */
AwsManagedPolicy.AWSServiceRoleForMonitronPolicy = 'aws-service-role/AWSServiceRoleForMonitronPolicy';
/** Provides Cloudwatch access to publish operational and usage metrics and logs for Amazon Neptune */
AwsManagedPolicy.AWSServiceRoleForNeptuneGraphPolicy = 'aws-service-role/AWSServiceRoleForNeptuneGraphPolicy';
/** Provides permissions to describe and update Private Marketplace resources and describe AWS Organizations */
AwsManagedPolicy.AWSServiceRoleForPrivateMarketplaceAdminPolicy = 'aws-service-role/AWSServiceRoleForPrivateMarketplaceAdminPolicy';
/** Policy for Procurement Insights to obtain Organization Account details */
AwsManagedPolicy.AWSServiceRoleForProcurementInsightsPolicy = 'aws-service-role/AWSServiceRoleForProcurementInsightsPolicy';
/** Provides access to AWS services and resources necessary to migrate service instances into AWS including EC2, S3 and Cloudformation. */
AwsManagedPolicy.AWSServiceRoleForSMS = 'aws-service-role/AWSServiceRoleForSMS';
/** Provides access to the User Subscriptions service to your Identity Center resources to automatically update your subscriptions. */
AwsManagedPolicy.AWSServiceRoleForUserSubscriptions = 'aws-service-role/AWSServiceRoleForUserSubscriptions';
/** Provides AWS Backup permissions to create compliance reports on your behalf */
AwsManagedPolicy.AWSServiceRolePolicyForBackupReports = 'aws-service-role/AWSServiceRolePolicyForBackupReports';
/** This policy contains permissions for testing restores and for cleaning up resources created during tests. */
AwsManagedPolicy.AWSServiceRolePolicyForBackupRestoreTesting = 'aws-service-role/AWSServiceRolePolicyForBackupRestoreTesting';
/** This managed policy provides administrative access to Amazon WorkSpaces to manage EC2 instances in your AWS account */
AwsManagedPolicy.AWSServiceRolePolicyForWorkspacesInstances = 'aws-service-role/AWSServiceRolePolicyForWorkspacesInstances';
/** Provides the AWS DDoS Response Team with limited access to your AWS account to assist with DDoS attack mitigation during a high-severity event. */
AwsManagedPolicy.AWSShieldDRTAccessPolicy = 'service-role/AWSShieldDRTAccessPolicy';
/** Allows AWS Shield to access AWS resources on your behalf to provide DDoS protection. */
AwsManagedPolicy.AWSShieldServiceRolePolicy = 'aws-service-role/AWSShieldServiceRolePolicy';
/** Provides access to publish metrics and provide insights for your social message sending. */
AwsManagedPolicy.AWSSocialMessagingServiceRolePolicy = 'aws-service-role/AWSSocialMessagingServiceRolePolicy';
/** Provides AWS Systems Manager for SAP with the permissions needed to manage and integrate SAP software with AWS. */
AwsManagedPolicy.AWSSSMForSAPServiceLinkedRolePolicy = 'aws-service-role/AWSSSMForSAPServiceLinkedRolePolicy';
/** Policy for Service Linked Role AWSServiceRoleForAmazonSSM_OpsInsights */
AwsManagedPolicy.AWSSSMOpsInsightsServiceRolePolicy = 'aws-service-role/AWSSSMOpsInsightsServiceRolePolicy';
/** Administrator access for SSO Directory */
AwsManagedPolicy.AWSSSODirectoryAdministrator = 'AWSSSODirectoryAdministrator';
/** ReadOnly access for SSO Directory */
AwsManagedPolicy.AWSSSODirectoryReadOnly = 'AWSSSODirectoryReadOnly';
/** Provides access within AWS SSO to manage AWS Organizations master and member accounts and cloud application */
AwsManagedPolicy.AWSSSOMasterAccountAdministrator = 'AWSSSOMasterAccountAdministrator';
/** Provides access within AWS SSO to manage AWS Organizations member accounts and cloud application */
AwsManagedPolicy.AWSSSOMemberAccountAdministrator = 'AWSSSOMemberAccountAdministrator';
/** Provides read only access to AWS SSO configurations. */
AwsManagedPolicy.AWSSSOReadOnly = 'AWSSSOReadOnly';
/** Grants AWS SSO permissions to manage AWS resources, including IAM roles, policies and SAML IdP on your behalf. */
AwsManagedPolicy.AWSSSOServiceRolePolicy = 'aws-service-role/AWSSSOServiceRolePolicy';
/** An access policy for providing a user/role/etc access to the AWS StepFunctions console. For a full console experience, in addition to this policy, a user may need iam:PassRole permission on other IAM roles that can be assumed by the service. */
AwsManagedPolicy.AWSStepFunctionsConsoleFullAccess = 'AWSStepFunctionsConsoleFullAccess';
/** An access policy for providing a user/role/etc access to the AWS StepFunctions API. For full access, in addition to this policy, a user MUST have iam:PassRole permission on at least one IAM role that can be assumed by the service. */
AwsManagedPolicy.AWSStepFunctionsFullAccess = 'AWSStepFunctionsFullAccess';
/** An access policy for providing a user/role/etc read only access to the AWS StepFunctions service. */
AwsManagedPolicy.AWSStepFunctionsReadOnlyAccess = 'AWSStepFunctionsReadOnlyAccess';
/** Provides full access to AWS Storage Gateway via the AWS Management Console. */
AwsManagedPolicy.AWSStorageGatewayFullAccess = 'AWSStorageGatewayFullAccess';
/** Provides access to AWS Storage Gateway via the AWS Management Console. */
AwsManagedPolicy.AWSStorageGatewayReadOnlyAccess = 'AWSStorageGatewayReadOnlyAccess';
/** Service-linked role used by AWS Storage Gateway to enable integration of other AWS services with Storage Gateway. */
AwsManagedPolicy.AWSStorageGatewayServiceRolePolicy = 'aws-service-role/AWSStorageGatewayServiceRolePolicy';
/** AWSSupplyChainFederationAdminAccess provides AWS Supply Chain federated users access to the AWS Supply Chain application, including the required permissions to perform actions within the AWS Supply Chain application. The policy provides administrative permissions over IAM Identity Center users and groups and is attached to a role created by AWS Supply Chain on your behalf. You shouldn't attach AWSSupplyChainFederationAdminAccess policy to any other IAM entities. */
AwsManagedPolicy.AWSSupplyChainFederationAdminAccess = 'service-role/AWSSupplyChainFederationAdminAccess';
/** Allows users to access the AWS Support Center. */
AwsManagedPolicy.AWSSupportAccess = 'AWSSupportAccess';
/** Provides full access to the AWS Support App and other required services, such as AWS Support and Service Quotas. This policy includes permissions to use the supporting services so that the user can contact AWS Support for support cases, change service quotas, and create the relevant service-linked roles. */
AwsManagedPolicy.AWSSupportAppFullAccess = 'AWSSupportAppFullAccess';
/** Provides read-only access to the AWS Support App. */
AwsManagedPolicy.AWSSupportAppReadOnlyAccess = 'AWSSupportAppReadOnlyAccess';
/** Provides full access to supportplans. */
AwsManagedPolicy.AWSSupportPlansFullAccess = 'AWSSupportPlansFullAccess';
/** Provides read-only access to supportplans. */
AwsManagedPolicy.AWSSupportPlansReadOnlyAccess = 'AWSSupportPlansReadOnlyAccess';
/** Allows AWS Support to access AWS resources to provide billing, administrative, and support services. */
AwsManagedPolicy.AWSSupportServiceRolePolicy = 'aws-service-role/AWSSupportServiceRolePolicy';
/** Grants AWS Systems Manager (SSM) permission to discover AWS account information. */
AwsManagedPolicy.AWSSystemsManagerAccountDiscoveryServicePolicy = 'aws-service-role/AWSSystemsManagerAccountDiscoveryServicePolicy';
/** Provides access to AWS resources managed or used by the AWS Systems Manager change management framework. */
AwsManagedPolicy.AWSSystemsManagerChangeManagementServicePolicy = 'aws-service-role/AWSSystemsManagerChangeManagementServicePolicy';
/** Provides permissions for AWS Systems Manager Quick Setup to enable and configure AWS Config configuration recording. */
AwsManagedPolicy.AWSSystemsManagerEnableConfigRecordingExecutionPolicy = 'AWSSystemsManagerEnableConfigRecordingExecutionPolicy';
/** This policy grants administrative permissions for enabling Explorer, a capability of AWS Systems Manager. This includes permissions to update related Systems Manager service settings, and to create a service-linked role for Systems Manager. */
AwsManagedPolicy.AWSSystemsManagerEnableExplorerExecutionPolicy = 'AWSSystemsManagerEnableExplorerExecutionPolicy';
/** Provides full access to AWS Systems Manager for SAP service */
AwsManagedPolicy.AWSSystemsManagerForSAPFullAccess = 'AWSSystemsManagerForSAPFullAccess';
/** Provides read only access to AWS Systems Manager for SAP service */
AwsManagedPolicy.AWSSystemsManagerForSAPReadOnlyAccess = 'AWSSystemsManagerForSAPReadOnlyAccess';
/** Provides access to AWS resources managed or used by the AWS Systems Manager just in time access framework. */
AwsManagedPolicy.AWSSystemsManagerJustInTimeAccessServicePolicy = 'aws-service-role/AWSSystemsManagerJustInTimeAccessServicePolicy';
/** The managed policy AWSSystemsManagerJustInTimeAccessTokenPolicy allows Systems Manager to generate access tokens used for just-in-time node access. */
AwsManagedPolicy.AWSSystemsManagerJustInTimeAccessTokenPolicy = 'AWSSystemsManagerJustInTimeAccessTokenPolicy';
/** The managed policy AWSSystemsManagerJustInTimeAccessTokenSessionPolicy allows Systems Manager to apply scoped down permissions to a just-in-time node access session once it is started. */
AwsManagedPolicy.AWSSystemsManagerJustInTimeAccessTokenSessionPolicy = 'AWSSystemsManagerJustInTimeAccessTokenSessionPolicy';
/** This policy allows Systems Manager to share a deny-access policy for just-in-time node access from the delegated administrator account to member accounts, and replicate the policy to multiple Regions. */
AwsManagedPolicy.AWSSystemsManagerJustInTimeNodeAccessRolePropagationPolicy = 'AWSSystemsManagerJustInTimeNodeAccessRolePropagationPolicy';
/** Permissions required to collect information about a user for Just-In-Time-Node-Access notifications. */
AwsManagedPolicy.AWSSystemsManagerNotificationsServicePolicy = 'aws-service-role/AWSSystemsManagerNotificationsServicePolicy';
/** IAM role for SSM Explorer to manage OpsData related operations */
AwsManagedPolicy.AWSSystemsManagerOpsDataSyncServiceRolePolicy = 'aws-service-role/AWSSystemsManagerOpsDataSyncServiceRolePolicy';
/** This policy grants the AWS Portal Asset Server the necessary permissions required for normal operation. */
AwsManagedPolicy.AWSThinkboxAssetServerPolicy = 'AWSThinkboxAssetServerPolicy';
/** This policy grants AWS Thinkbox's Deadline software full access to multiple AWS services as required for AWS Portal administration. This includes access to create arbitrary tags on several EC2 resource types. */
AwsManagedPolicy.AWSThinkboxAWSPortalAdminPolicy = 'AWSThinkboxAWSPortalAdminPolicy';
/** This policy grants the AWS Portal Gateway machine the necessary permissions required for normal operation. */
AwsManagedPolicy.AWSThinkboxAWSPortalGatewayPolicy = 'AWSThinkboxAWSPortalGatewayPolicy';
/** This policy grants the Deadline Workers in AWS Portal the necessary permissions required for normal operation. */
AwsManagedPolicy.AWSThinkboxAWSPortalWorkerPolicy = 'AWSThinkboxAWSPortalWorkerPolicy';
/** Grants permissions required for the operation of AWS Thinkbox's Deadline Resource Tracker.  This includes full access to some EC2 actions, including DeleteFleets and CancelSpotFleetRequests. */
AwsManagedPolicy.AWSThinkboxDeadlineResourceTrackerAccessPolicy = 'AWSThinkboxDeadlineResourceTrackerAccessPolicy';
/** Grants permissions required to create, destroy, and administer AWS Thinkbox's Deadline Resource Tracker. */
AwsManagedPolicy.AWSThinkboxDeadlineResourceTrackerAdminPolicy = 'AWSThinkboxDeadlineResourceTrackerAdminPolicy';
/** Grants permissions required for AWS Thinkbox's Deadline Spot Event Plugin.  This includes permission to request, modify, and cancel a spot fleet, as well as limited PassRole permission. */
AwsManagedPolicy.AWSThinkboxDeadlineSpotEventPluginAdminPolicy = 'AWSThinkboxDeadlineSpotEventPluginAdminPolicy';
/** Grant permissions required for an EC2 instance running AWS Thinkbox Deadline Spot Event Plugin Worker software. */
AwsManagedPolicy.AWSThinkboxDeadlineSpotEventPluginWorkerPolicy = 'AWSThinkboxDeadlineSpotEventPluginWorkerPolicy';
/** Provides full access to AWS Transfer via the AWS Management Console */
AwsManagedPolicy.AWSTransferConsoleFullAccess = 'AWSTransferConsoleFullAccess';
/** Provides full access to AWS Transfer Service. */
AwsManagedPolicy.AWSTransferFullAccess = 'AWSTransferFullAccess';
/** Allows AWS Transfer full access to create log streams and groups and put log events to your account */
AwsManagedPolicy.AWSTransferLoggingAccess = 'service-role/AWSTransferLoggingAccess';
/** Provide readonly access to AWS Transfer services. */
AwsManagedPolicy.AWSTransferReadOnlyAccess = 'AWSTransferReadOnlyAccess';
/** Enables the AWS Transform service to deploy transformed .NET applications by creating and managing AWS resources. This policy grants permissions to provision infrastructure, manage compute resources, and configure deployment settings across various AWS services. */
AwsManagedPolicy.AWSTransformApplicationDeploymentPolicy = 'service-role/AWSTransformApplicationDeploymentPolicy';
/** Provides full access to AWS Trusted Advisor Priority. This policy also enables the user to add Trusted Advisor as a trusted service with AWS Organizations and to specify delegated administrator accounts for Trusted Advisor Priority. */
AwsManagedPolicy.AWSTrustedAdvisorPriorityFullAccess = 'AWSTrustedAdvisorPriorityFullAccess';
/** Provides read-only access to AWS Trusted Advisor Priority. This includes permission to view the delegated administrator accounts. */
AwsManagedPolicy.AWSTrustedAdvisorPriorityReadOnlyAccess = 'AWSTrustedAdvisorPriorityReadOnlyAccess';
/** Service Policy for Trusted Advisor Multi-account Reporting */
AwsManagedPolicy.AWSTrustedAdvisorReportingServiceRolePolicy = 'aws-service-role/AWSTrustedAdvisorReportingServiceRolePolicy';
/** Access for the AWS Trusted Advisor Service to help reduce cost, increase performance, and improve security of your AWS environment. */
AwsManagedPolicy.AWSTrustedAdvisorServiceRolePolicy = 'aws-service-role/AWSTrustedAdvisorServiceRolePolicy';
/** Allows AWS User Notifications to call AWS services on your behalf. */
AwsManagedPolicy.AWSUserNotificationsServiceLinkedRolePolicy = 'aws-service-role/AWSUserNotificationsServiceLinkedRolePolicy';
/** Provides full access for viewing entitled Vendor Insights resources and managing Vendor Insights subscriptions */
AwsManagedPolicy.AWSVendorInsightsAssessorFullAccess = 'AWSVendorInsightsAssessorFullAccess';
/** Provides read-only access for viewing entitled Vendor Insights resources */
AwsManagedPolicy.AWSVendorInsightsAssessorReadOnly = 'AWSVendorInsightsAssessorReadOnly';
/** Provides full access for creating and managing the Vendor Insights resources */
AwsManagedPolicy.AWSVendorInsightsVendorFullAccess = 'AWSVendorInsightsVendorFullAccess';
/** Provides read-only access for viewing the Vendor Insights resources */
AwsManagedPolicy.AWSVendorInsightsVendorReadOnly = 'AWSVendorInsightsVendorReadOnly';
/** Allows VPC Lattice to access AWS resources on your behalf. */
AwsManagedPolicy.AWSVpcLatticeServiceRolePolicy = 'aws-service-role/AWSVpcLatticeServiceRolePolicy';
/** Allow Site-to-Site VPN to create and manage resources related to your VPN Connections. */
AwsManagedPolicy.AWSVPCS2SVpnServiceRolePolicy = 'aws-service-role/AWSVPCS2SVpnServiceRolePolicy';
/** Allow VPC Transit Gateway to create and manage necessary resources for your Transit Gateway VPC Attachments. */
AwsManagedPolicy.AWSVPCTransitGatewayServiceRolePolicy = 'aws-service-role/AWSVPCTransitGatewayServiceRolePolicy';
/** Policy to enable AWS Verified Access service to provision endpoints on your behalf */
AwsManagedPolicy.AWSVPCVerifiedAccessServiceRolePolicy = 'aws-service-role/AWSVPCVerifiedAccessServiceRolePolicy';
/** Provides full access to AWS WAF via the AWS Management Console. Note that this policy also grants permissions to list and update Amazon CloudFront distributions, permissions to view load balancers on AWS Elastic Load Balancing, permissions to view Amazon API Gateway REST APIs and stages, permissions to list and view Amazon CloudWatch metrics, and permissions to view regions enabled within the account. */
AwsManagedPolicy.AWSWAFConsoleFullAccess = 'AWSWAFConsoleFullAccess';
/** Provides read-only access to AWS WAF via the AWS Management Console. Note that this policy also grants permissions to list Amazon CloudFront distributions, permissions to view load balancers on AWS Elastic Load Balancing, permissions to view Amazon API Gateway REST APIs and stages, permissions to list and view Amazon CloudWatch metrics, and permissions to view regions enabled within the account. */
AwsManagedPolicy.AWSWAFConsoleReadOnlyAccess = 'AWSWAFConsoleReadOnlyAccess';
/** Provides full access to AWS WAF actions. */
AwsManagedPolicy.AWSWAFFullAccess = 'AWSWAFFullAccess';
/** Provides read only access to AWS WAF actions. */
AwsManagedPolicy.AWSWAFReadOnlyAccess = 'AWSWAFReadOnlyAccess';
/** Allows WellArchitected to access AWS services and resources that relate to WellArchitected resources on behalf of customers. */
AwsManagedPolicy.AWSWellArchitectedDiscoveryServiceRolePolicy = 'aws-service-role/AWSWellArchitectedDiscoveryServiceRolePolicy';
/** Allows Well-Architected to access Organizations on your behalf. */
AwsManagedPolicy.AWSWellArchitectedOrganizationsServiceRolePolicy = 'aws-service-role/AWSWellArchitectedOrganizationsServiceRolePolicy';
/** This policy grants full administrative permissions to the Wickr service, including the Wickr administrative functions under the AWS Management Console. */
AwsManagedPolicy.AWSWickrFullAccess = 'AWSWickrFullAccess';
/** Provides capabilities to manage Observability Access Manager links and establish sharing of X-Ray traces */
AwsManagedPolicy.AWSXrayCrossAccountSharingConfiguration = 'AWSXrayCrossAccountSharingConfiguration';
/** Allow the AWS X-Ray Daemon to relay raw trace segments data to the service's API and retrieve sampling data (rules, targets, etc.) to be used by the X-Ray SDK. */
AwsManagedPolicy.AWSXRayDaemonWriteAccess = 'AWSXRayDaemonWriteAccess';
/** AWS X-Ray full access managed policy */
AwsManagedPolicy.AWSXrayFullAccess = 'AWSXrayFullAccess';
/** AWS X-Ray read only managed policy */
AwsManagedPolicy.AWSXrayReadOnlyAccess = 'AWSXrayReadOnlyAccess';
/** AWS X-Ray write only managed policy */
AwsManagedPolicy.AWSXrayWriteOnlyAccess = 'AWSXrayWriteOnlyAccess';
/** Provides administrative access for ARC zonal shift practice runs, and access to CloudWatch alarm statuses to monitor practice runs. */
AwsManagedPolicy.AWSZonalAutoshiftPracticeRunSLRPolicy = 'aws-service-role/AWSZonalAutoshiftPracticeRunSLRPolicy';
/** Provides read-only access to the APIs needed to support zone-group access-management for organizations. */
AwsManagedPolicy.AWSZoneGroupAccessManagementServiceRolePolicy = 'aws-service-role/AWSZoneGroupAccessManagementServiceRolePolicy';
/** Provides access for the AWS Batch service to manage the required resources, including Amazon EC2 and Amazon ECS resources. */
AwsManagedPolicy.BatchServiceRolePolicy = 'aws-service-role/BatchServiceRolePolicy';
/** Provides full access to Bedrock AgentCore as well as limited access to related services */
AwsManagedPolicy.BedrockAgentCoreFullAccess = 'BedrockAgentCoreFullAccess';
/** Grants permissions for billing and cost management. This includes viewing account usage and viewing and modifying budgets and payment methods. */
AwsManagedPolicy.Billing = 'job-function/Billing';
/** Allows Budgets to verify access to Billing Views shared across account boundaries. */
AwsManagedPolicy.BudgetsServiceRolePolicy = 'aws-service-role/BudgetsServiceRolePolicy';
/** Amazon Certificate Manager Service Role Policy */
AwsManagedPolicy.CertificateManagerServiceRolePolicy = 'aws-service-role/CertificateManagerServiceRolePolicy';
/** Policy to enable AWS Client VPN to manage your Client VPN endpoint connections. */
AwsManagedPolicy.ClientVPNServiceConnectionsRolePolicy = 'aws-service-role/ClientVPNServiceConnectionsRolePolicy';
/** Policy to enable AWS Client VPN to manage your Client VPN endpoints. */
AwsManagedPolicy.ClientVPNServiceRolePolicy = 'aws-service-role/ClientVPNServiceRolePolicy';
/** Service Role for CloudFormation StackSets (Organization Master Account) */
AwsManagedPolicy.CloudFormationStackSetsOrgAdminServiceRolePolicy = 'aws-service-role/CloudFormationStackSetsOrgAdminServiceRolePolicy';
/** Service Role for CloudFormation StackSets (Organization Member Account) */
AwsManagedPolicy.CloudFormationStackSetsOrgMemberServiceRolePolicy = 'aws-service-role/CloudFormationStackSetsOrgMemberServiceRolePolicy';
/** Provides full access to the CloudFront console plus the ability to list Amazon S3 buckets via the AWS Management Console. */
AwsManagedPolicy.CloudFrontFullAccess = 'CloudFrontFullAccess';
/** Provides access to CloudFront distribution configuration information and list distributions via the AWS Management Console. */
AwsManagedPolicy.CloudFrontReadOnlyAccess = 'CloudFrontReadOnlyAccess';
/** Enables access to AWS resources used or managed by CloudHSM */
AwsManagedPolicy.CloudHSMServiceRolePolicy = 'aws-service-role/CloudHSMServiceRolePolicy';
/** Provides full access to the Amazon CloudSearch configuration service. */
AwsManagedPolicy.CloudSearchFullAccess = 'CloudSearchFullAccess';
/** Provides read only access to the Amazon CloudSearch configuration service. */
AwsManagedPolicy.CloudSearchReadOnlyAccess = 'CloudSearchReadOnlyAccess';
/** This service linked role allows CloudTrail to get and add resource tags to the resource owner's CloudTrail events. */
AwsManagedPolicy.CloudTrailEventContext = 'aws-service-role/CloudTrailEventContext';
/** Permission policy for CloudTrail ServiceLinkedRole */
AwsManagedPolicy.CloudTrailServiceRolePolicy = 'aws-service-role/CloudTrailServiceRolePolicy';
/** Allows CloudWatch to assume CloudWatch-CrossAccountSharing roles in remote accounts on behalf of the current account in order to display data cross-account, cross-region */
AwsManagedPolicy.CloudWatchCrossAccountAccess = 'aws-service-role/CloudWatch-CrossAccountAccess';
/** Provides read-only access to CloudWatch alarms and metrics as well as EC2 metadata. Provides access to Stop, Terminate and Reboot EC2 instances. */
AwsManagedPolicy.CloudWatchActionsEC2Access = 'CloudWatchActionsEC2Access';
/** Full permissions required to use AmazonCloudWatchAgent. */
AwsManagedPolicy.CloudWatchAgentAdminPolicy = 'CloudWatchAgentAdminPolicy';
/** Permissions required to use AmazonCloudWatchAgent on servers */
AwsManagedPolicy.CloudWatchAgentServerPolicy = 'CloudWatchAgentServerPolicy';
/** Provides full access to CloudWatch Application Insights and required dependencies. */
AwsManagedPolicy.CloudWatchApplicationInsightsFullAccess = 'CloudWatchApplicationInsightsFullAccess';
/** Provides read only access to CloudWatch Application Insights. */
AwsManagedPolicy.CloudWatchApplicationInsightsReadOnlyAccess = 'CloudWatchApplicationInsightsReadOnlyAccess';
/** Cloudwatch Application Insights Service Linked Role Policy */
AwsManagedPolicy.CloudwatchApplicationInsightsServiceLinkedRolePolicy = 'aws-service-role/CloudwatchApplicationInsightsServiceLinkedRolePolicy';
/** Provide full access to CloudWatch Application Signals service and scoped access to the dependencies needed to use and operate this service. */
AwsManagedPolicy.CloudWatchApplicationSignalsFullAccess = 'CloudWatchApplicationSignalsFullAccess';
/** Provides read only access to CloudWatch Application Signals service and scoped access to the dependencies needed to use this service */
AwsManagedPolicy.CloudWatchApplicationSignalsReadOnlyAccess = 'CloudWatchApplicationSignalsReadOnlyAccess';
/** Policy grants permission to CloudWatch Application Signals to collect monitoring and tagging data from other relevant AWS services. */
AwsManagedPolicy.CloudWatchApplicationSignalsServiceRolePolicy = 'aws-service-role/CloudWatchApplicationSignalsServiceRolePolicy';
/** Provides access to the non-CloudWatch APIs used to display CloudWatch Automatic Dashboards, including the contents of objects such as Lambda functions */
AwsManagedPolicy.CloudWatchAutomaticDashboardsAccess = 'CloudWatchAutomaticDashboardsAccess';
/** Provides capabilities to manage Observability Access Manager links and establish sharing of CloudWatch resources */
AwsManagedPolicy.CloudWatchCrossAccountSharingConfiguration = 'CloudWatchCrossAccountSharingConfiguration';
/** Allows built-in targets in Amazon CloudWatch Events to perform EC2 actions on your behalf. */
AwsManagedPolicy.CloudWatchEventsBuiltInTargetExecutionAccess = 'service-role/CloudWatchEventsBuiltInTargetExecutionAccess';
/** Provides full access to Amazon CloudWatch Events. */
AwsManagedPolicy.CloudWatchEventsFullAccess = 'CloudWatchEventsFullAccess';
/** Allows Amazon CloudWatch Events to relay events to the streams in AWS Kinesis Streams in your account. */
AwsManagedPolicy.CloudWatchEventsInvocationAccess = 'service-role/CloudWatchEventsInvocationAccess';
/** Provides read only access to Amazon CloudWatch Events. */
AwsManagedPolicy.CloudWatchEventsReadOnlyAccess = 'CloudWatchEventsReadOnlyAccess';
/** Allow AWS CloudWatch to execute actions on your behalf configured through alarms and events. */
AwsManagedPolicy.CloudWatchEventsServiceRolePolicy = 'aws-service-role/CloudWatchEventsServiceRolePolicy';
/** Provides full access to CloudWatch. */
AwsManagedPolicy.CloudWatchFullAccess = 'CloudWatchFullAccess';
/** Provides full access to CloudWatch. */
AwsManagedPolicy.CloudWatchFullAccessV2 = 'CloudWatchFullAccessV2';
/** Provides full access to actions for working with Amazon CloudWatch Internet Monitor. Also provides access to other services, such as Amazon CloudWatch, Amazon EC2, Amazon CloudFront, Amazon WorkSpaces, and Elastic Load Balancing, that are necessary to use the Internet Monitor service for monitoring and storing information about application traffic. */
AwsManagedPolicy.CloudWatchInternetMonitorFullAccess = 'CloudWatchInternetMonitorFullAccess';
/** Provides read only access to actions for working with Amazon CloudWatch Internet Monitor. Also provides access to other services in Amazon CloudWatch, including policies to retrieve information on CloudWatch metrics and to manage log queries, that are necessary to use the Internet Monitor service for monitoring and storing information about application traffic. */
AwsManagedPolicy.CloudWatchInternetMonitorReadOnlyAccess = 'CloudWatchInternetMonitorReadOnlyAccess';
/** Allows Internet Monitor to access EC2, Workspaces, and CloudFront resources, and other required services on your behalf. */
AwsManagedPolicy.CloudWatchInternetMonitorServiceRolePolicy = 'aws-service-role/CloudWatchInternetMonitorServiceRolePolicy';
/** Provides write access to X-Ray and CloudWatch Application Signals log group. */
AwsManagedPolicy.CloudWatchLambdaApplicationSignalsExecutionRolePolicy = 'CloudWatchLambdaApplicationSignalsExecutionRolePolicy';
/** Policy required for the Lambda Insights Extension */
AwsManagedPolicy.CloudWatchLambdaInsightsExecutionRolePolicy = 'CloudWatchLambdaInsightsExecutionRolePolicy';
/** Provides capabilities to manage Observability Access Manager links and establish sharing of CloudWatch Logs resources */
AwsManagedPolicy.CloudWatchLogsCrossAccountSharingConfiguration = 'CloudWatchLogsCrossAccountSharingConfiguration';
/** Provides full access to CloudWatch Logs */
AwsManagedPolicy.CloudWatchLogsFullAccess = 'CloudWatchLogsFullAccess';
/** Provides read only access to CloudWatch Logs */
AwsManagedPolicy.CloudWatchLogsReadOnlyAccess = 'CloudWatchLogsReadOnlyAccess';
/** You can use this policy in IAM roles that are attached to Amazon EC2 and Amazon EKS instance resources to send telemetry reports (metrics) to a Network Flow Monitor endpoint. */
AwsManagedPolicy.CloudWatchNetworkFlowMonitorAgentPublishPolicy = 'CloudWatchNetworkFlowMonitorAgentPublishPolicy';
/** You can't attach CloudWatchNetworkFlowMonitorServiceRolePolicy to your IAM entities. This policy is attached to a service-linked role named AWSServiceRoleForNetworkFlowMonitor, which publishes network telemetry aggregation results, collected by Network Flow Monitor agents, to CloudWatch. It also allows the service to use AWS Organizations to get information for multi-account scenarios. */
AwsManagedPolicy.CloudWatchNetworkFlowMonitorServiceRolePolicy = 'aws-service-role/CloudWatchNetworkFlowMonitorServiceRolePolicy';
/** You can't attach CloudWatchNetworkFlowMonitorTopologyServiceRolePolicy to your IAM entities. This policy is attached to a service-linked role named AWSServiceRoleForNetworkFlowMonitor_Topology, which generates topology snapshots of resources used by Network Flow Monitor in your account. */
AwsManagedPolicy.CloudWatchNetworkFlowMonitorTopologyServiceRolePolicy = 'aws-service-role/CloudWatchNetworkFlowMonitorTopologyServiceRolePolicy';
/** Allows CloudWatch Network Monitor to access and manage EC2 and VPC resources, publish data to CloudWatch and access other required services on your behalf. */
AwsManagedPolicy.CloudWatchNetworkMonitorServiceRolePolicy = 'aws-service-role/CloudWatchNetworkMonitorServiceRolePolicy';
/** This policy provides user access to view OpenSearch dashboards on the CloudWatch Logs console. */
AwsManagedPolicy.CloudWatchOpenSearchDashboardAccess = 'CloudWatchOpenSearchDashboardAccess';
/** This policy provides user access to create integration with OpenSearch to create, update, delete or view dashboards on the CloudWatch Logs console. */
AwsManagedPolicy.CloudWatchOpenSearchDashboardsFullAccess = 'CloudWatchOpenSearchDashboardsFullAccess';
/** Provides read only access to CloudWatch. */
AwsManagedPolicy.CloudWatchReadOnlyAccess = 'CloudWatchReadOnlyAccess';
/** Provides full access to CloudWatch Synthetics. */
AwsManagedPolicy.CloudWatchSyntheticsFullAccess = 'CloudWatchSyntheticsFullAccess';
/** Provides read only access to CloudWatch Synthetics. */
AwsManagedPolicy.CloudWatchSyntheticsReadOnlyAccess = 'CloudWatchSyntheticsReadOnlyAccess';
/** Policy for AWS Comprehend service role which allows access to S3 resources for data access */
AwsManagedPolicy.ComprehendDataAccessRolePolicy = 'service-role/ComprehendDataAccessRolePolicy';
/** Provides full access to Amazon Comprehend. */
AwsManagedPolicy.ComprehendFullAccess = 'ComprehendFullAccess';
/** Provides full access to Amazon Comprehend Medical */
AwsManagedPolicy.ComprehendMedicalFullAccess = 'ComprehendMedicalFullAccess';
/** Provides read-only access to Amazon Comprehend. */
AwsManagedPolicy.ComprehendReadOnly = 'ComprehendReadOnly';
/** Provides read only access to ComputeOptimizer. */
AwsManagedPolicy.ComputeOptimizerReadOnlyAccess = 'ComputeOptimizerReadOnlyAccess';
/** Allows ComputeOptimizer to call AWS services and collect workload details on your behalf. */
AwsManagedPolicy.ComputeOptimizerServiceRolePolicy = 'aws-service-role/ComputeOptimizerServiceRolePolicy';
/** Policy needed for AWSConfig to create conformance packs */
AwsManagedPolicy.ConfigConformsServiceRolePolicy = 'aws-service-role/ConfigConformsServiceRolePolicy';
/** This managed policy provides admin access to Cost Optimization Hub. */
AwsManagedPolicy.CostOptimizationHubAdminAccess = 'CostOptimizationHubAdminAccess';
/** This managed policy provides read-only access to Cost Optimization Hub. */
AwsManagedPolicy.CostOptimizationHubReadOnlyAccess = 'CostOptimizationHubReadOnlyAccess';
/** Allows Cost Optimization Hub to retrieve organization information and collect optimization-related data and metadata. */
AwsManagedPolicy.CostOptimizationHubServiceRolePolicy = 'aws-service-role/CostOptimizationHubServiceRolePolicy';
/** Allows Amazon Connect Customer Profiles to access AWS services and resources on your behalf. */
AwsManagedPolicy.CustomerProfilesServiceLinkedRolePolicy = 'aws-service-role/CustomerProfilesServiceLinkedRolePolicy';
/** Grants full access permissions to AWS services and actions required to set up and configure AWS database services. */
AwsManagedPolicy.DatabaseAdministrator = 'job-function/DatabaseAdministrator';
/** Grants permissions to AWS data analytics services. */
AwsManagedPolicy.DataScientist = 'job-function/DataScientist';
/** This policy allows DAX to create and manage Network interface, Security group, Subnet and Vpc on behalf of customer */
AwsManagedPolicy.DAXServiceRolePolicy = 'aws-service-role/DAXServiceRolePolicy';
/** Provides access to read-only APIs needed to run EC2 Declarative Policies Account Status Report. */
AwsManagedPolicy.DeclarativePoliciesEC2Report = 'aws-service-role/DeclarativePoliciesEC2Report';
/** Permissions required to support Amazon CloudWatch Contributor Insights for Amazon DynamoDB. */
AwsManagedPolicy.DynamoDBCloudWatchContributorInsightsServiceRolePolicy = 'aws-service-role/DynamoDBCloudWatchContributorInsightsServiceRolePolicy';
/** Provide AWS DynamoDB access to KinesisDataStreams */
AwsManagedPolicy.DynamoDBKinesisReplicationServiceRolePolicy = 'aws-service-role/DynamoDBKinesisReplicationServiceRolePolicy';
/** Permissions required by DynamoDB for cross-region data replication */
AwsManagedPolicy.DynamoDBReplicationServiceRolePolicy = 'aws-service-role/DynamoDBReplicationServiceRolePolicy';
/** This policy grants full access to EC2 Fast Launch actions */
AwsManagedPolicy.EC2FastLaunchFullAccess = 'EC2FastLaunchFullAccess';
/** Policy grants ec2fastlaunch to prepare and manage preprovisioned snapshots in customer's account & publish related metrics. */
AwsManagedPolicy.EC2FastLaunchServiceRolePolicy = 'aws-service-role/EC2FastLaunchServiceRolePolicy';
/** Policy granting permissions to EC2 Fleet to launch instances in the future. */
AwsManagedPolicy.EC2FleetTimeShiftableServiceRolePolicy = 'aws-service-role/EC2FleetTimeShiftableServiceRolePolicy';
/** Permissions need by EC2 Image Builder to perform a cross account distribution. */
AwsManagedPolicy.Ec2ImageBuilderCrossAccountDistributionAccess = 'Ec2ImageBuilderCrossAccountDistributionAccess';
/** The EC2ImageBuilderLifecycleExecutionPolicy policy grants permissions for Image Builder to perform actions such as deprecate or delete Image Builder image resources and their underlying resources (AMIs, snapshots) to support automated rules for image lifecycle management tasks. */
AwsManagedPolicy.EC2ImageBuilderLifecycleExecutionPolicy = 'service-role/EC2ImageBuilderLifecycleExecutionPolicy';
/** Allows customers to call EC2 Instance Connect to publish ephemeral keys to their EC2 instances and connect via ssh or the EC2 Instance Connect CLI. */
AwsManagedPolicy.EC2InstanceConnect = 'EC2InstanceConnect';
/** EC2 Instance Connect endpoint policy to manage EC2 Instance Connect endpoints created by the customer */
AwsManagedPolicy.Ec2InstanceConnectEndpoint = 'aws-service-role/Ec2InstanceConnectEndpoint';
/** EC2 Instance profile for Image Builder service. */
AwsManagedPolicy.EC2InstanceProfileForImageBuilder = 'EC2InstanceProfileForImageBuilder';
/** EC2 Instance profile for building container images with EC2 Image Builder. This policy grants the user broad permissions to upload ECR images. */
AwsManagedPolicy.EC2InstanceProfileForImageBuilderECRContainerBuilds = 'EC2InstanceProfileForImageBuilderECRContainerBuilds';
/** Enables access to AWS Services and Resources used or managed by ECR Replication */
AwsManagedPolicy.ECRReplicationServiceRolePolicy = 'aws-service-role/ECRReplicationServiceRolePolicy';
/** Allows actions to be performed when using AWS ECR repository creation templates */
AwsManagedPolicy.ECRTemplateServiceRolePolicy = 'aws-service-role/ECRTemplateServiceRolePolicy';
/** This policy allows ElastiCache to manage AWS resources on your behalf as necessary for managing your cache */
AwsManagedPolicy.ElastiCacheServiceRolePolicy = 'aws-service-role/ElastiCacheServiceRolePolicy';
/** Provides full access to Amazon ElasticLoadBalancing, and limited access to other services necessary to provide ElasticLoadBalancing features. */
AwsManagedPolicy.ElasticLoadBalancingFullAccess = 'ElasticLoadBalancingFullAccess';
/** Provides read only access to Amazon ElasticLoadBalancing and dependent services */
AwsManagedPolicy.ElasticLoadBalancingReadOnly = 'ElasticLoadBalancingReadOnly';
/** Access to view purchased assets and download related software and kickstart files */
AwsManagedPolicy.ElementalActivationsDownloadSoftwareAccess = 'ElementalActivationsDownloadSoftwareAccess';
/** Full access to view and take action on Elemental Appliances and Software purchased assets */
AwsManagedPolicy.ElementalActivationsFullAccess = 'ElementalActivationsFullAccess';
/** Access to view purchased assets and generate software licenses for pending activations */
AwsManagedPolicy.ElementalActivationsGenerateLicenses = 'ElementalActivationsGenerateLicenses';
/** Read-only access to the detailed list of purchased assets associated to the AWS account of the user */
AwsManagedPolicy.ElementalActivationsReadOnlyAccess = 'ElementalActivationsReadOnlyAccess';
/** Full access to view and take action on Elemental Appliances and Software quotes and orders */
AwsManagedPolicy.ElementalAppliancesSoftwareFullAccess = 'ElementalAppliancesSoftwareFullAccess';
/** Read-only access to view Elemental Appliances and Software quotes and orders */
AwsManagedPolicy.ElementalAppliancesSoftwareReadOnlyAccess = 'ElementalAppliancesSoftwareReadOnlyAccess';
/** Full access to view and take action on Elemental Appliance and Software support cases and product support content */
AwsManagedPolicy.ElementalSupportCenterFullAccess = 'ElementalSupportCenterFullAccess';
/** This policy grants read-only permissions that allow the WAL service for Amazon EMR to find and return the status of a cluster */
AwsManagedPolicy.EMRDescribeClusterPolicyForEMRWAL = 'aws-service-role/EMRDescribeClusterPolicyForEMRWAL';
/** Access policy to allow FM service linked role to perform FM-related actions on FM-managed resources within a customer AWS Organization account. */
AwsManagedPolicy.FMSServiceRolePolicy = 'aws-service-role/FMSServiceRolePolicy';
/** Allows Amazon FSx to delete its Service Linked Roles for Amazon S3 access */
AwsManagedPolicy.FSxDeleteServiceLinkedRoleAccess = 'aws-service-role/FSxDeleteServiceLinkedRoleAccess';
/** Grants the required permissions for compute actions in an Amazon GameLift container fleet, including access to dependencies such as Amazon S3. */
AwsManagedPolicy.GameLiftContainerFleetPolicy = 'GameLiftContainerFleetPolicy';
/** Policy to allow Gamelift GameServerGroups to manage customer resources */
AwsManagedPolicy.GameLiftGameServerGroupPolicy = 'GameLiftGameServerGroupPolicy';
/** This managed policy grants permission to connect with Amazon Q and utilize the features in the GitLab Duo with Amazon Q integration. */
AwsManagedPolicy.GitLabDuoWithAmazonQPermissionsPolicy = 'GitLabDuoWithAmazonQPermissionsPolicy';
/** Allow GlobalAccelerator Users full Access to all APIs */
AwsManagedPolicy.GlobalAcceleratorFullAccess = 'GlobalAcceleratorFullAccess';
/** Allow GlobalAccelerator Users Access to Read Only APIs */
AwsManagedPolicy.GlobalAcceleratorReadOnlyAccess = 'GlobalAcceleratorReadOnlyAccess';
/** Provides read access to the Greengrass OTA Update artifacts in all Greengrass regions */
AwsManagedPolicy.GreengrassOTAUpdateArtifactAccess = 'service-role/GreengrassOTAUpdateArtifactAccess';
/** AWS Health policy to enable Organizational View feature */
AwsManagedPolicy.HealthOrganizationsServiceRolePolicy = 'aws-service-role/Health_OrganizationsServiceRolePolicy';
/** This policy grants access to read all access information provided by IAM access advisor such as service last accessed information. */
AwsManagedPolicy.IAMAccessAdvisorReadOnly = 'IAMAccessAdvisorReadOnly';
/** Provides full access to IAM Access Analyzer */
AwsManagedPolicy.IAMAccessAnalyzerFullAccess = 'IAMAccessAnalyzerFullAccess';
/** Provides read only access to IAM Access Analyzer resources */
AwsManagedPolicy.IAMAccessAnalyzerReadOnlyAccess = 'IAMAccessAnalyzerReadOnlyAccess';
/** Provides access required to check the presence of root user credentials such as root user password and root user access keys using the Security Token Service (STS) AssumeRoot API. Use this managed policy only with the STS AssumeRoot action. */
AwsManagedPolicy.IAMAuditRootUserCredentials = 'root-task/IAMAuditRootUserCredentials';
/** Provides access required to create a root user password using the Security Token Service (STS) AssumeRoot API.  Use this managed policy only with the STS AssumeRoot action. */
AwsManagedPolicy.IAMCreateRootUserPassword = 'root-task/IAMCreateRootUserPassword';
/** Provides access required to delete all root user credentials such as root password and root access keys using the Security Token Service (STS) AssumeRoot API.  Use this managed policy only with the STS AssumeRoot action. */
AwsManagedPolicy.IAMDeleteRootUserCredentials = 'root-task/IAMDeleteRootUserCredentials';
/** Provides full access to IAM via the AWS Management Console. */
AwsManagedPolicy.IAMFullAccess = 'IAMFullAccess';
/** Provides read only access to IAM via the AWS Management Console. */
AwsManagedPolicy.IAMReadOnlyAccess = 'IAMReadOnlyAccess';
/** Allows an IAM user to manage their own Service Specific Credentials. */
AwsManagedPolicy.IAMSelfManageServiceSpecificCredentials = 'IAMSelfManageServiceSpecificCredentials';
/** Provides the ability for an IAM user to change their own password. */
AwsManagedPolicy.IAMUserChangePassword = 'IAMUserChangePassword';
/** Provides the ability for an IAM user to manage their own SSH keys. */
AwsManagedPolicy.IAMUserSSHKeys = 'IAMUserSSHKeys';
/** Provides full access to Interactive Video Service (IVS), Also included permissions for dependent services, needed for full access to the ivs console. */
AwsManagedPolicy.IVSFullAccess = 'IVSFullAccess';
/** Provides read-only access to IVS Low-Latency and Real-Time streaming APIs */
AwsManagedPolicy.IVSReadOnlyAccess = 'IVSReadOnlyAccess';
/** Service Linked Role to perform S3 PutObject to recording IVS live streams */
AwsManagedPolicy.IVSRecordToS3 = 'aws-service-role/IVSRecordToS3';
/** This policy grants Kafka Connect permission to manage AWS resources on your behalf. */
AwsManagedPolicy.KafkaConnectServiceRolePolicy = 'aws-service-role/KafkaConnectServiceRolePolicy';
/** IAM service linked role policy for Kafka. */
AwsManagedPolicy.KafkaServiceRolePolicy = 'aws-service-role/KafkaServiceRolePolicy';
/** Grants the required permissions to Amazon Keyspaces for Change Data Capture */
AwsManagedPolicy.KeyspacesCDCServiceRolePolicy = 'aws-service-role/KeyspacesCDCServiceRolePolicy';
/** Permissions required by Keyspaces for cross-region data replication */
AwsManagedPolicy.KeyspacesReplicationServiceRolePolicy = 'aws-service-role/KeyspacesReplicationServiceRolePolicy';
/** Policy to grant temporary data access to Lake Formation resources */
AwsManagedPolicy.LakeFormationDataAccessServiceRolePolicy = 'aws-service-role/LakeFormationDataAccessServiceRolePolicy';
/** Policy for AWS Lex Bot use case */
AwsManagedPolicy.LexBotPolicy = 'aws-service-role/LexBotPolicy';
/** Policy for AWS Lex Channel use case */
AwsManagedPolicy.LexChannelPolicy = 'aws-service-role/LexChannelPolicy';
/** AWS Lightsail service linked role policy which grants permissions to export resources */
AwsManagedPolicy.LightsailExportAccess = 'aws-service-role/LightsailExportAccess';
/** This policy grants permission to register MediaConnect Gateway Instances to a MediaConnect Gateway. */
AwsManagedPolicy.MediaConnectGatewayInstanceRolePolicy = 'MediaConnectGatewayInstanceRolePolicy';
/** Allows MediaPackage to publish logs to CloudWatch */
AwsManagedPolicy.MediaPackageServiceRolePolicy = 'aws-service-role/MediaPackageServiceRolePolicy';
/** This policy allows MemoryDB to manage AWS resources on your behalf as necessary for managing your resources. */
AwsManagedPolicy.MemoryDBServiceRolePolicy = 'aws-service-role/MemoryDBServiceRolePolicy';
/** Policy for Database Migration Service to assume role in customer's account to call Migration Hub */
AwsManagedPolicy.MigrationHubDMSAccessServiceRolePolicy = 'aws-service-role/MigrationHubDMSAccessServiceRolePolicy';
/** Allows Migration Hub to call Application Discovery Service on your behalf */
AwsManagedPolicy.MigrationHubServiceRolePolicy = 'aws-service-role/MigrationHubServiceRolePolicy';
/** Policy for Server Migration Service to assume role in customer's account to call Migration Hub */
AwsManagedPolicy.MigrationHubSMSAccessServiceRolePolicy = 'aws-service-role/MigrationHubSMSAccessServiceRolePolicy';
/** Policy for AWS Monitron service linked role granting access to required customer resources. */
AwsManagedPolicy.MonitronServiceRolePolicy = 'aws-service-role/MonitronServiceRolePolicy';
/** Provides full access to Multi-party approval. This policy also includes related permissions to AWS Organizations and AWS IAM Identity for managing approval teams and identity sources. */
AwsManagedPolicy.MultiPartyApprovalFullAccess = 'MultiPartyApprovalFullAccess';
/** Provides read-only access to Multi-party approval. This policy also includes related read permission to AWS Organizations and AWS IAM Identity for approval teams and identity sources. */
AwsManagedPolicy.MultiPartyApprovalReadOnlyAccess = 'MultiPartyApprovalReadOnlyAccess';
/** Provides full access to manage Amazon Neptune using the AWS Console. Note this policy also grants full access to publish on all SNS topics within the account, permissions to create and edit Amazon EC2 instances and VPC configurations, permissions to view and list keys on Amazon KMS, and full access to Amazon RDS. For more information, see https://aws.amazon.com/neptune/faqs/. */
AwsManagedPolicy.NeptuneConsoleFullAccess = 'NeptuneConsoleFullAccess';
/** Provides full access to Amazon Neptune. Note this policy also grants full access to publish on all SNS topics within the account and full access to Amazon RDS. For more information, see https://aws.amazon.com/neptune/faqs/. */
AwsManagedPolicy.NeptuneFullAccess = 'NeptuneFullAccess';
/** Provides read only access to all Amazon Neptune Analytics resources along with read only permissions for dependent services. */
AwsManagedPolicy.NeptuneGraphReadOnlyAccess = 'NeptuneGraphReadOnlyAccess';
/** Provides read only access to Amazon Neptune. Note that this policy also grants access to Amazon RDS resources. For more information, see https://aws.amazon.com/neptune/faqs/. */
AwsManagedPolicy.NeptuneReadOnlyAccess = 'NeptuneReadOnlyAccess';
/** Grants full access permissions to AWS services and actions required to set up and configure AWS network resources. */
AwsManagedPolicy.NetworkAdministrator = 'job-function/NetworkAdministrator';
/** Provides permissions for the AWS Shield network security director service linked role to assess specified environments. */
AwsManagedPolicy.NetworkSecurityDirectorServiceLinkedRolePolicy = 'aws-service-role/NetworkSecurityDirectorServiceLinkedRolePolicy';
/** Provides full access to CloudWatch Observability Access Manager */
AwsManagedPolicy.OAMFullAccess = 'OAMFullAccess';
/** Provides Read Only access to CloudWatch Observability Access Manager */
AwsManagedPolicy.OAMReadOnlyAccess = 'OAMReadOnlyAccess';
/** Allows Amazon OpenSearch Ingestion to describe network resources and write service metrics to cloudwatch */
AwsManagedPolicy.OpensearchIngestionSelfManagedVpcePolicy = 'aws-service-role/OpensearchIngestionSelfManagedVpcePolicy';
/** Provides access to associate and dissociate partner central users with IAM roles */
AwsManagedPolicy.PartnerCentralAccountManagementUserRoleAssociation = 'PartnerCentralAccountManagementUserRoleAssociation';
/** Provides full access to AWS services and resources, but does not allow management of Users and groups. */
AwsManagedPolicy.PowerUserAccess = 'PowerUserAccess';
/** Grants permissions to AWS Services and Resources used or managed by Amazon Q Apps. */
AwsManagedPolicy.QAppsServiceRolePolicy = 'aws-service-role/QAppsServiceRolePolicy';
/** Grants permissions to QBusiness to call QuickSight APIs for the QuickSight plugin */
AwsManagedPolicy.QBusinessQuicksightPluginPolicy = 'QBusinessQuicksightPluginPolicy';
/** Grants permissions to AWS Services and Resources used or managed by Amazon Q */
AwsManagedPolicy.QBusinessServiceRolePolicy = 'aws-service-role/QBusinessServiceRolePolicy';
/** Policy used by QuickSight team to access customer data produced by S3 Storage Management Analytics. */
AwsManagedPolicy.QuickSightAccessForS3StorageManagementAnalyticsReadOnly = 'service-role/QuickSightAccessForS3StorageManagementAnalyticsReadOnly';
/** Default policy for the Amazon RDS service role. */
AwsManagedPolicy.RDSCloudHsmAuthorizationRole = 'service-role/RDSCloudHsmAuthorizationRole';
/** Provides read-only access to AWS services and resources. */
AwsManagedPolicy.ReadOnlyAccess = 'ReadOnlyAccess';
/** Provides full access to Resource Groups and Tag Editor. */
AwsManagedPolicy.ResourceGroupsandTagEditorFullAccess = 'ResourceGroupsandTagEditorFullAccess';
/** Provides access to use Resource Groups and Tag Editor, but does not allow editing of tags via the Tag Editor. */
AwsManagedPolicy.ResourceGroupsandTagEditorReadOnlyAccess = 'ResourceGroupsandTagEditorReadOnlyAccess';
/** Allows AWS Resource Groups to query the AWS services that own your resources to keep the group up-to-date */
AwsManagedPolicy.ResourceGroupsServiceRolePolicy = 'aws-service-role/ResourceGroupsServiceRolePolicy';
/** Provides permissions to tag and untag all the resources supported by Resource Groups Tagging API. This policy also grants the permissions required to retrieve all tagged, or previously tagged, resources through the Resource Groups Tagging API. */
AwsManagedPolicy.ResourceGroupsTaggingAPITagUntagSupportedResources = 'ResourceGroupsTaggingAPITagUntagSupportedResources';
/** Allows the OpenShift Amazon EBS Container Storage Interface (CSI) Driver Operator to install and maintain the Amazon EBS CSI driver on a Red Hat OpenShift Service on AWS (ROSA) cluster. The Amazon EBS CSI driver allows ROSA clusters to manage the lifecycle of Amazon EBS volumes for persistent volumes. */
AwsManagedPolicy.ROSAAmazonEBSCSIDriverOperatorPolicy = 'service-role/ROSAAmazonEBSCSIDriverOperatorPolicy';
/** Allows the OpenShift Cloud Network Config Controller Operator to provision and manage networking resources for use by the Red Hat OpenShift Service on AWS (ROSA) cluster networking overlay. The OpenShift Cloud Network Operator interfaces with AWS APIs on behalf of the network plugins via CustomResourceDefinitions. The operator uses these policy permissions to manage private IP addresses for Amazon EC2 instances as part of the ROSA cluster. */
AwsManagedPolicy.ROSACloudNetworkConfigOperatorPolicy = 'service-role/ROSACloudNetworkConfigOperatorPolicy';
/** Allows Red Hat OpenShift Service on AWS (ROSA) control plane to manage ROSA cluster Amazon EC2 and Amazon Route 53 resources. */
AwsManagedPolicy.ROSAControlPlaneOperatorPolicy = 'service-role/ROSAControlPlaneOperatorPolicy';
/** Allows the OpenShift Image Registry Operator to provision and manage Amazon S3 buckets and objects for use by the Red Hat OpenShift Service on AWS (ROSA) in-cluster image registry to satisfy ROSA storage requirements. The OpenShift Image Registry Operator installs and maintains the internal registry of a Red Hat OpenShift cluster. */
AwsManagedPolicy.ROSAImageRegistryOperatorPolicy = 'service-role/ROSAImageRegistryOperatorPolicy';
/** Allows the OpenShift Ingress Operator to provision and manage load balancers and domain name system (DNS) configurations for Red Hat OpenShift Service on AWS (ROSA) clusters. The policy allows read access to tag values, which the operator filters for Route 53 resources to discover hosted zones. */
AwsManagedPolicy.ROSAIngressOperatorPolicy = 'service-role/ROSAIngressOperatorPolicy';
/** Allows the Red Hat OpenShift Service on AWS (ROSA) installer to manage AWS resources that support ROSA cluster installation. This includes managing instance profiles for ROSA worker nodes. */
AwsManagedPolicy.ROSAInstallerPolicy = 'service-role/ROSAInstallerPolicy';
/** Allows the built-in ROSA AWS Encryption Provider to manage AWS Key Management Service (KMS) keys to support etcd data encryption using a customer provided AWS KMS key. The policy allows encryption and decryption of data using KMS keys. */
AwsManagedPolicy.ROSAKMSProviderPolicy = 'service-role/ROSAKMSProviderPolicy';
/** Allows the ROSA Kubernetes controller to manage Amazon EC2, Elastic Load Balancing (ELB), and AWS Key Management Service (KMS) resources for a ROSA cluster. */
AwsManagedPolicy.ROSAKubeControllerPolicy = 'service-role/ROSAKubeControllerPolicy';
/** This policy provides the permissions required to manage the Red Hat OpenShift Service on AWS (ROSA) subscription. */
AwsManagedPolicy.ROSAManageSubscription = 'ROSAManageSubscription';
/** Allows Red Hat OpenShift Service on AWS (ROSA) to manage cluster EC2 instances as worker nodes, including permission to configure security groups and tag instances and volumes. This policy also allows for the use of EC2 instances with disk encryption provided by AWS Key Management Service (KMS) keys. */
AwsManagedPolicy.ROSANodePoolManagementPolicy = 'service-role/ROSANodePoolManagementPolicy';
/** Allows the Red Hat OpenShift Service on AWS (ROSA) installer to configure VPC Endpoints and Security Groups. Intended to be used on a shared VPC. */
AwsManagedPolicy.ROSASharedVPCEndpointPolicy = 'ROSASharedVPCEndpointPolicy';
/** Allows the Red Hat OpenShift Service on AWS (ROSA) installer to configure Route53 records. Intended to be used on a shared VPC. */
AwsManagedPolicy.ROSASharedVPCRoute53Policy = 'ROSASharedVPCRoute53Policy';
/** Provides ROSA site reliability engineering (SRE) the permissions needed to initially observe, diagnose, and support AWS resources associated with Red Hat OpenShift Service on AWS (ROSA) clusters, including the ability to change ROSA cluster node state. */
AwsManagedPolicy.ROSASRESupportPolicy = 'service-role/ROSASRESupportPolicy';
/** Allows Red Hat OpenShift Service on AWS (ROSA) worker nodes in your account read-only access to Amazon EC2 instances and AWS Regions for compute node lifecycle management. */
AwsManagedPolicy.ROSAWorkerInstancePolicy = 'service-role/ROSAWorkerInstancePolicy';
/** Service Linked Role Policy for Route 53 Recovery Readiness */
AwsManagedPolicy.Route53RecoveryReadinessServiceRolePolicy = 'aws-service-role/Route53RecoveryReadinessServiceRolePolicy';
/** Enables access to AWS Services and Resources used or managed by Route53 Resolver */
AwsManagedPolicy.Route53ResolverServiceRolePolicy = 'aws-service-role/Route53ResolverServiceRolePolicy';
/** Enables access to AWS Services and Resources used or managed by S3 Storage Lens */
AwsManagedPolicy.S3StorageLensServiceRolePolicy = 'aws-service-role/S3StorageLensServiceRolePolicy';
/** Provides access required to unlock a S3 bucket policy using the Security Token Service (STS) AssumeRoot API. Use this managed policy only with the STS AssumeRoot action. */
AwsManagedPolicy.S3UnlockBucketPolicy = 'root-task/S3UnlockBucketPolicy';
/** Provides initial administrative and individual setup privileges for Amazon SageMaker Unified Studio via the AWS Management Console and SDK. Allows launching of SageMaker Unified Studio Portal. */
AwsManagedPolicy.SageMakerStudioAdminIAMConsolePolicy = 'SageMakerStudioAdminIAMConsolePolicy';
/** Administrative execution policy for using IAM roles with SageMaker Unified Studio. Allows admins to provision, manage and access resources in your account (excluding access to data resources) for IAM-based usage of SageMaker Unified Studio. */
AwsManagedPolicy.SageMakerStudioAdminIAMDefaultExecutionPolicy = 'SageMakerStudioAdminIAMDefaultExecutionPolicy';
/** Administrative execution policy for using IAM roles with SageMaker Unified Studio. Allows admins to provision, manage and access resources in the local account (including broad access to all APIs in data services like S3, Glue, CloudWatch Logs, and others) for IAM-based usage of SageMaker Unified Studio. */
AwsManagedPolicy.SageMakerStudioAdminIAMPermissiveExecutionPolicy = 'SageMakerStudioAdminIAMPermissiveExecutionPolicy';
/** This IAM policy grants an IAM role full access to AWS Glue Data Catalog (metadata) and Amazon S3 (actual data) for data lake operations, with access scoped by account, and role tags. */
AwsManagedPolicy.SageMakerStudioAdminProjectUserRolePolicy = 'SageMakerStudioAdminProjectUserRolePolicy';
/** Allows Amazon Bedrock Agents to access Amazon Bedrock models and other resources attached to an agent in SageMaker Studio. */
AwsManagedPolicy.SageMakerStudioBedrockAgentServiceRolePolicy = 'service-role/SageMakerStudioBedrockAgentServiceRolePolicy';
/** Provides access to an Amazon Bedrock chat agent app's configuration and Amazon Bedrock agent in SageMaker Studio. */
AwsManagedPolicy.SageMakerStudioBedrockChatAgentUserRolePolicy = 'service-role/SageMakerStudioBedrockChatAgentUserRolePolicy';
/** Allows Amazon Bedrock to access Amazon Bedrock models and datasets for evaluation jobs in SageMaker Studio. */
AwsManagedPolicy.SageMakerStudioBedrockEvaluationJobServiceRolePolicy = 'service-role/SageMakerStudioBedrockEvaluationJobServiceRolePolicy';
/** Allows Amazon Bedrock Flows to access Amazon Bedrock models and other resources attached to a flow in SageMaker Studio. */
AwsManagedPolicy.SageMakerStudioBedrockFlowServiceRolePolicy = 'service-role/SageMakerStudioBedrockFlowServiceRolePolicy';
/** Allows AWS Lambda to access an Amazon Bedrock function component's configuration in SageMaker Studio. */
AwsManagedPolicy.SageMakerStudioBedrockFunctionExecutionRolePolicy = 'service-role/SageMakerStudioBedrockFunctionExecutionRolePolicy';
/** Provides access to configure vector stores and Amazon Bedrock knowledge bases in SageMaker Studio. */
AwsManagedPolicy.SageMakerStudioBedrockKnowledgeBaseCustomResourcePolicy = 'service-role/SageMakerStudioBedrockKnowledgeBaseCustomResourcePolicy';
/** Allows Amazon Bedrock Knowledge Bases to access Amazon Bedrock models and data sources in SageMaker Studio. */
AwsManagedPolicy.SageMakerStudioBedrockKnowledgeBaseServiceRolePolicy = 'service-role/SageMakerStudioBedrockKnowledgeBaseServiceRolePolicy';
/** Provides access to an Amazon Bedrock prompt and its configuration in SageMaker Studio. */
AwsManagedPolicy.SageMakerStudioBedrockPromptUserRolePolicy = 'service-role/SageMakerStudioBedrockPromptUserRolePolicy';
/** This policy is used by Amazon SageMaker Studio to catalog, discover, govern, share, and analyze data in the Amazon SageMaker Studio domain. */
AwsManagedPolicy.SageMakerStudioDomainExecutionRolePolicy = 'service-role/SageMakerStudioDomainExecutionRolePolicy';
/** Service role for domain level actions in the portal that are performed by Amazon SageMaker Studio. */
AwsManagedPolicy.SageMakerStudioDomainServiceRolePolicy = 'service-role/SageMakerStudioDomainServiceRolePolicy';
/** Amazon SageMaker Studio creates IAM roles for projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the permissions related to EMR. */
AwsManagedPolicy.SageMakerStudioEMRInstanceRolePolicy = 'service-role/SageMakerStudioEMRInstanceRolePolicy';
/** Amazon SageMaker Studio creates IAM roles for projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the permissions related to EMR. */
AwsManagedPolicy.SageMakerStudioEMRServiceRolePolicy = 'service-role/SageMakerStudioEMRServiceRolePolicy';
/** This policy provides full access to Amazon SageMaker Unified Studio via the Amazon SageMaker management console. */
AwsManagedPolicy.SageMakerStudioFullAccess = 'SageMakerStudioFullAccess';
/** Amazon SageMaker Studio uses this policy to provision and manage resources in your account. */
AwsManagedPolicy.SageMakerStudioProjectProvisioningRolePolicy = 'service-role/SageMakerStudioProjectProvisioningRolePolicy';
/** Amazon SageMaker Studio creates IAM roles for projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the permissions related to SageMaker. */
AwsManagedPolicy.SageMakerStudioProjectRoleMachineLearningPolicy = 'SageMakerStudioProjectRoleMachineLearningPolicy';
/** Amazon SageMaker creates IAM roles for Projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the boundary of their permissions. */
AwsManagedPolicy.SageMakerStudioProjectUserRolePermissionsBoundary = 'SageMakerStudioProjectUserRolePermissionsBoundary';
/** Amazon SageMaker Studio creates IAM roles for projects users to perform data analytics, artificial intelligence, and machine learning actions, and uses this policy when creating these roles to define the permissions. */
AwsManagedPolicy.SageMakerStudioProjectUserRolePolicy = 'SageMakerStudioProjectUserRolePolicy';
/** Amazon SageMaker Studio uses this policy when running query executions on federated connections. */
AwsManagedPolicy.SageMakerStudioQueryExecutionRolePolicy = 'service-role/SageMakerStudioQueryExecutionRolePolicy';
/** Provides individual setup privileges for Amazon SageMaker Unified Studio via the AWS Management Console and SDK. Allows launching of SageMaker Unified Studio Portal. */
AwsManagedPolicy.SageMakerStudioUserIAMConsolePolicy = 'SageMakerStudioUserIAMConsolePolicy';
/** Execution policy for using IAM roles with SageMaker Unified Studio. Allows users to access resources in the local account (excluding access to data resources) for IAM-based usage of SageMaker Unified Studio. */
AwsManagedPolicy.SageMakerStudioUserIAMDefaultExecutionPolicy = 'SageMakerStudioUserIAMDefaultExecutionPolicy';
/** Execution policy for using IAM roles with SageMaker Unified Studio. Allows users to access resources in your account (including broad access to all APIs in data services like S3, Glue, CloudWatch Logs, and others) for IAM-based usage of SageMaker Unified Studio. */
AwsManagedPolicy.SageMakerStudioUserIAMPermissiveExecutionPolicy = 'SageMakerStudioUserIAMPermissiveExecutionPolicy';
/** Provides read/write access to AWS Secrets Manager via the AWS Management Console. Note: this exludes IAM actions, so combine with IAMFullAccess if rotation configuration is required. */
AwsManagedPolicy.SecretsManagerReadWrite = 'SecretsManagerReadWrite';
/** The security audit template grants access to read security configuration metadata. It is useful for software that audits the configuration of an AWS account. */
AwsManagedPolicy.SecurityAudit = 'SecurityAudit';
/** Provides access to manage resources created by Security Lake. */
AwsManagedPolicy.SecurityLakeResourceManagementServiceRolePolicy = 'aws-service-role/SecurityLakeResourceManagementServiceRolePolicy';
/** This policy grants permissions to operate the Amazon Security Lake service on your behalf */
AwsManagedPolicy.SecurityLakeServiceLinkedRole = 'aws-service-role/SecurityLakeServiceLinkedRole';
/** Permissions to allow the AWS Server Migration Connector to migrate VMs to EC2. Allows communication with the AWS Server Migration Service, read/write access to S3 buckets starting with 'sms-b-' and 'import-to-ec2-' as well as the buckets used for AWS Server Migration Connector upgrade, AWS Server Migration Connector registration with AWS, and metrics upload to AWS. */
AwsManagedPolicy.ServerMigrationConnector = 'ServerMigrationConnector';
/** Required permissions to use all features of the Server Migration Service Console */
AwsManagedPolicy.ServerMigrationServiceConsoleFullAccess = 'ServerMigrationServiceConsoleFullAccess';
/** Permissions to allow the AWS Server Migration Service to create and update relevant AWS resources into the customer's AWS account for launching migrated servers and applications. */
AwsManagedPolicy.ServerMigrationServiceLaunchRole = 'service-role/ServerMigrationServiceLaunchRole';
/** Permissions to allow the AWS SMS to run used data validation script and send script success/failure back to SMS */
AwsManagedPolicy.ServerMigrationServiceRoleForInstanceValidation = 'service-role/ServerMigrationServiceRoleForInstanceValidation';
/** Provides full access to Service Quotas */
AwsManagedPolicy.ServiceQuotasFullAccess = 'ServiceQuotasFullAccess';
/** Provides read only access to Service Quotas */
AwsManagedPolicy.ServiceQuotasReadOnlyAccess = 'ServiceQuotasReadOnlyAccess';
/** Allows Service Quotas to create support cases on your behalf */
AwsManagedPolicy.ServiceQuotasServiceRolePolicy = 'aws-service-role/ServiceQuotasServiceRolePolicy';
/** Provides full access to the Simple Workflow configuration service. */
AwsManagedPolicy.SimpleWorkflowFullAccess = 'SimpleWorkflowFullAccess';
/** Allows SMSVoice to publish metrics to CloudWatch on your behalf */
AwsManagedPolicy.SMSVoiceServiceRolePolicy = 'aws-service-role/SMSVoiceServiceRolePolicy';
/** Allows split cost allocation data to retrieve AWS Organizations information, if applicable, and collect telemetry data for the split cost allocation data services that the customer has opted in to. */
AwsManagedPolicy.SplitCostAllocationDataServiceRolePolicy = 'aws-service-role/SplitCostAllocationDataServiceRolePolicy';
/** Provides access required to unlock a SQS queue policy using the Security Token Service (STS) AssumeRoot API. Use this managed policy only with the STS AssumeRoot action. */
AwsManagedPolicy.SQSUnlockQueuePolicy = 'root-task/SQSUnlockQueuePolicy';
/** Provides permissions to check Quick Setup configuration health, ensure consistent use of parameters and provisioned resources, and remediate resources when drift is detected. */
AwsManagedPolicy.SSMQuickSetupRolePolicy = 'aws-service-role/SSMQuickSetupRolePolicy';
/** This policy grants permissions to troubleshoot and resolve issues in an AWS account. This policy also enables the user to contact AWS support to create and manage cases. */
AwsManagedPolicy.SupportUser = 'job-function/SupportUser';
/** Grants full access permissions necessary for resources required for application and development operations. */
AwsManagedPolicy.SystemAdministrator = 'job-function/SystemAdministrator';
/** Provides full access to Amazon Translate. */
AwsManagedPolicy.TranslateFullAccess = 'TranslateFullAccess';
/** Provides read-only access to Amazon Translate. */
AwsManagedPolicy.TranslateReadOnly = 'TranslateReadOnly';
/** This policy grants permissions to view resources and basic metadata across all AWS services. */
AwsManagedPolicy.ViewOnlyAccess = 'job-function/ViewOnlyAccess';
/** Default policy for the VM Import/Export service role, for customers using the AWS Connector. The VM Import/Export service assumes a role with this policy to fulfill virtual machine migration requests from the AWS Connector virtual appliance. (Note that the AWS Connector uses the "AWSConnector" managed policy to issue requests on the customer's behalf to the VM Import/Export service.) Provides the ability to create AMIs and EBS snapshots, modify EBS snapshot attributes, make "Describe*" calls on EC2 objects, and read from S3 buckets starting with 'import-to-ec2-'. */
AwsManagedPolicy.VMImportExportRoleForAWSConnector = 'service-role/VMImportExportRoleForAWSConnector';
/** Provides full access to Amazon VPC Lattice and access to dependency services. */
AwsManagedPolicy.VPCLatticeFullAccess = 'VPCLatticeFullAccess';
/** Provides read-only access to Amazon VPC Lattice via the AWS Management Console, and limited access to dependency services. */
AwsManagedPolicy.VPCLatticeReadOnlyAccess = 'VPCLatticeReadOnlyAccess';
/** Provides access to invoking Amazon VPC Lattice services. */
AwsManagedPolicy.VPCLatticeServicesInvokeAccess = 'VPCLatticeServicesInvokeAccess';
/** Creating SLR to write customer's logs to a firehose stream */
AwsManagedPolicy.WAFLoggingServiceRolePolicy = 'aws-service-role/WAFLoggingServiceRolePolicy';
/** Creating SLR to write customer's logs to a firehose stream */
AwsManagedPolicy.WAFRegionalLoggingServiceRolePolicy = 'aws-service-role/WAFRegionalLoggingServiceRolePolicy';
/** This policy creates a service-linked role that allows AWS WAF to write logs to Amazon Kinesis Data Firehose. */
AwsManagedPolicy.WAFV2LoggingServiceRolePolicy = 'aws-service-role/WAFV2LoggingServiceRolePolicy';
/** Provides full access to AWS Well-Architected Tool via the AWS Management Console */
AwsManagedPolicy.WellArchitectedConsoleFullAccess = 'WellArchitectedConsoleFullAccess';
/** Provides read-only access to AWS Well-Architected Tool via the AWS Management Console */
AwsManagedPolicy.WellArchitectedConsoleReadOnlyAccess = 'WellArchitectedConsoleReadOnlyAccess';
/** Enables access to AWS Services and Resources used or managed by Amazon WorkLink */
AwsManagedPolicy.WorkLinkServiceRolePolicy = 'WorkLinkServiceRolePolicy';
//# sourceMappingURL=data:application/json;base64,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