import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [aiops](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonaioperations.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Aiops extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create a new investigation in the specified investigation group
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kms:Decrypt
     * - kms:GenerateDataKey
     * - sts:SetContext
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/API_CreateInvestigation.html
     */
    toCreateInvestigation(): this;
    /**
     * Grants permission to create a new investigation event in the specified investigation group
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - cloudwatch:DescribeAlarmHistory
     * - cloudwatch:DescribeAlarms
     * - cloudwatch:GetInsightRuleReport
     * - cloudwatch:GetMetricData
     * - kms:Decrypt
     * - kms:GenerateDataKey
     * - logs:GetQueryResults
     * - sts:SetContext
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/API_CreateInvestigationEvent.html
     */
    toCreateInvestigationEvent(): this;
    /**
     * Grants permission to create a new investigation group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - aiops:TagResource
     * - cloudtrail:DescribeTrails
     * - iam:PassRole
     * - kms:Decrypt
     * - kms:DescribeKey
     * - kms:GenerateDataKey
     * - sso:CreateApplication
     * - sso:DeleteApplication
     * - sso:PutApplicationAccessScope
     * - sso:PutApplicationAssignmentConfiguration
     * - sso:PutApplicationAuthenticationMethod
     * - sso:PutApplicationGrant
     * - sso:TagResource
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/API_CreateInvestigationGroup.html
     */
    toCreateInvestigationGroup(): this;
    /**
     * Grants permission to create an investigation resource in the specified investigation group
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - cloudwatch:DescribeAlarmHistory
     * - cloudwatch:DescribeAlarms
     * - cloudwatch:GetInsightRuleReport
     * - cloudwatch:GetMetricData
     * - kms:GenerateDataKey
     * - logs:GetQueryResults
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/API_CreateInvestigationResource.html
     */
    toCreateInvestigationResource(): this;
    /**
     * Grants permission to delete an investigation in the specified investigation group
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sts:SetContext
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/API_DeleteInvestigation.html
     */
    toDeleteInvestigation(): this;
    /**
     * Grants permission to delete the specified investigation group
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sso:DeleteApplication
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/API_DeleteInvestigationGroup.html
     */
    toDeleteInvestigationGroup(): this;
    /**
     * Grants permission to delete the investigation group policy attached to an investigation group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/API_DeleteInvestigationGroupPolicy.html
     */
    toDeleteInvestigationGroupPolicy(): this;
    /**
     * Grants permission to run and retrieve ephemeral investigation results
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/API_GetEphemeralInvestigationResults.html
     */
    toGetEphemeralInvestigationResults(): this;
    /**
     * Grants permission to retrieve an investigation in the specified investigation group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/API_GetInvestigation.html
     */
    toGetInvestigation(): this;
    /**
     * Grants permission to retrieve an investigation event in the specified investigation group
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - kms:Decrypt
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/API_GetInvestigationEvent.html
     */
    toGetInvestigationEvent(): this;
    /**
     * Grants permission to retrieve the specified investigation group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/API_GetInvestigationGroup.html
     */
    toGetInvestigationGroup(): this;
    /**
     * Grants permission to retrieve the investigation group policy attached to an investigation group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/API_GetInvestigationGroupPolicy.html
     */
    toGetInvestigationGroupPolicy(): this;
    /**
     * Grants permission to retrieve an investigation resource in the specified investigation group
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - kms:Decrypt
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/API_GetInvestigationResource.html
     */
    toGetInvestigationResource(): this;
    /**
     * Grants permission to list all investigation events in the specified investigation group
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/API_ListInvestigationEvents.html
     */
    toListInvestigationEvents(): this;
    /**
     * Grants permission to list all investigation groups in the AWS account making the request
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/API_ListInvestigationGroups.html
     */
    toListInvestigationGroups(): this;
    /**
     * Grants permission to list all investigations that are in the specified investigation group
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/API_ListInvestigations.html
     */
    toListInvestigations(): this;
    /**
     * Grants permission to list the tags for the specified resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to create/update the investigation group policy attached to an investigation group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/API_PutInvestigationGroupPolicy.html
     */
    toPutInvestigationGroupPolicy(): this;
    /**
     * Grants permission to add or update the specified tags for the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove the specified tags from the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update an investigation in the specified investigation group
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kms:Decrypt
     * - kms:GenerateDataKey
     * - sts:SetContext
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/API_UpdateInvestigation.html
     */
    toUpdateInvestigation(): this;
    /**
     * Grants permission to update an investigation event in the specified investigation group
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - kms:Decrypt
     * - kms:GenerateDataKey
     * - sts:SetContext
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/API_UpdateInvestigationEvent.html
     */
    toUpdateInvestigationEvent(): this;
    /**
     * Grants permission to update the specified investigation group
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - cloudtrail:DescribeTrails
     * - iam:PassRole
     * - kms:Decrypt
     * - kms:DescribeKey
     * - kms:GenerateDataKey
     * - sso:CreateApplication
     * - sso:DeleteApplication
     * - sso:PutApplicationAccessScope
     * - sso:PutApplicationAssignmentConfiguration
     * - sso:PutApplicationAuthenticationMethod
     * - sso:PutApplicationGrant
     * - sso:TagResource
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/API_UpdateInvestigationGroup.html
     */
    toUpdateInvestigationGroup(): this;
    /**
     * Grants permission to validate the specified investigation group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/API_ValidateInvestigationGroup.html
     */
    toValidateInvestigationGroup(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type investigation-group to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/API_InvestigationGroup.html
     *
     * @param investigationGroupId - Identifier for the investigationGroupId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onInvestigationGroup(investigationGroupId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateInvestigationGroup()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toCreateInvestigationGroup()
     *
     * Applies to resource types:
     * - investigation-group
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateInvestigationGroup()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [aiops](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonaioperations.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
