"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.A2c = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [a2c](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapp2container.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class A2c extends shared_1.PolicyStatement {
    /**
     * Grants permission to get the details of all Containerization jobs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/tk-dotnet-refactoring/latest/userguide/what-is-tk-dotnet-refactoring.html
     */
    toGetContainerizationJobDetails() {
        return this.to('GetContainerizationJobDetails');
    }
    /**
     * Grants permission to get the details of all Deployment jobs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/tk-dotnet-refactoring/latest/userguide/what-is-tk-dotnet-refactoring.html
     */
    toGetDeploymentJobDetails() {
        return this.to('GetDeploymentJobDetails');
    }
    /**
     * Grants permission to start a Containerization job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tk-dotnet-refactoring/latest/userguide/what-is-tk-dotnet-refactoring.html
     */
    toStartContainerizationJob() {
        return this.to('StartContainerizationJob');
    }
    /**
     * Grants permission to start a Deploymnet job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tk-dotnet-refactoring/latest/userguide/what-is-tk-dotnet-refactoring.html
     */
    toStartDeploymentJob() {
        return this.to('StartDeploymentJob');
    }
    /**
     * Statement provider for service [a2c](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapp2container.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'a2c';
        this.accessLevelList = {
            Read: [
                'GetContainerizationJobDetails',
                'GetDeploymentJobDetails'
            ],
            Write: [
                'StartContainerizationJob',
                'StartDeploymentJob'
            ]
        };
    }
}
exports.A2c = A2c;
//# sourceMappingURL=data:application/json;base64,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