import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [mgn](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapplicationmigrationservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Mgn extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to archive an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ArchiveApplication.html
     */
    toArchiveApplication(): this;
    /**
     * Grants permission to archive a wave
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ArchiveWave.html
     */
    toArchiveWave(): this;
    /**
     * Grants permission to associate applications to a wave
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_AssociateApplications.html
     */
    toAssociateApplications(): this;
    /**
     * Grants permission to associate source servers to an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_AssociateSourceServers.html
     */
    toAssociateSourceServers(): this;
    /**
     * Grants permission to create volume snapshot group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toBatchCreateVolumeSnapshotGroupForMgn(): this;
    /**
     * Grants permission to batch delete snapshot request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toBatchDeleteSnapshotRequestForMgn(): this;
    /**
     * Grants permission to change source server life cycle state
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ChangeServerLifeCycleState.html
     */
    toChangeServerLifeCycleState(): this;
    /**
     * Grants permission to create an application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_CreateApplication.html
     */
    toCreateApplication(): this;
    /**
     * Grants permission to create connector
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_CreateConnector.html
     */
    toCreateConnector(): this;
    /**
     * Grants permission to create launch configuration template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_CreateLaunchConfigurationTemplate.html
     */
    toCreateLaunchConfigurationTemplate(): this;
    /**
     * Grants permission to create a network migration definition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_CreateNetworkMigrationDefinition.html
     */
    toCreateNetworkMigrationDefinition(): this;
    /**
     * Grants permission to create replication configuration template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_CreateReplicationConfigurationTemplate.html
     */
    toCreateReplicationConfigurationTemplate(): this;
    /**
     * Grants permission to create vcenter client
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toCreateVcenterClientForMgn(): this;
    /**
     * Grants permission to create a wave
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_CreateWave.html
     */
    toCreateWave(): this;
    /**
     * Grants permission to delete an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteApplication.html
     */
    toDeleteApplication(): this;
    /**
     * Grants permission to delete connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteConnector.html
     */
    toDeleteConnector(): this;
    /**
     * Grants permission to delete job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteJob.html
     */
    toDeleteJob(): this;
    /**
     * Grants permission to delete launch configuration template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteLaunchConfigurationTemplate.html
     */
    toDeleteLaunchConfigurationTemplate(): this;
    /**
     * Grants permission to delete a network migration definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteNetworkMigrationDefinition.html
     */
    toDeleteNetworkMigrationDefinition(): this;
    /**
     * Grants permission to delete replication configuration template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteReplicationConfigurationTemplate.html
     */
    toDeleteReplicationConfigurationTemplate(): this;
    /**
     * Grants permission to delete source server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteSourceServer.html
     */
    toDeleteSourceServer(): this;
    /**
     * Grants permission to delete vcenter client
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteVcenterClient.html
     */
    toDeleteVcenterClient(): this;
    /**
     * Grants permission to delete a wave
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteWave.html
     */
    toDeleteWave(): this;
    /**
     * Grants permission to describe job log items
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeJobLogItems.html
     */
    toDescribeJobLogItems(): this;
    /**
     * Grants permission to describe jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeJobs.html
     */
    toDescribeJobs(): this;
    /**
     * Grants permission to describe launch configuration template
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeLaunchConfigurationTemplates.html
     */
    toDescribeLaunchConfigurationTemplates(): this;
    /**
     * Grants permission to describe replication configuration template
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeReplicationConfigurationTemplates.html
     */
    toDescribeReplicationConfigurationTemplates(): this;
    /**
     * Grants permission to describe replication server associations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toDescribeReplicationServerAssociationsForMgn(): this;
    /**
     * Grants permission to describe snapshots requests
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toDescribeSnapshotRequestsForMgn(): this;
    /**
     * Grants permission to describe source servers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeSourceServers.html
     */
    toDescribeSourceServers(): this;
    /**
     * Grants permission to describe vcenter clients
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeVcenterClients.html
     */
    toDescribeVcenterClients(): this;
    /**
     * Grants permission to disassociate applications from a wave
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DisassociateApplications.html
     */
    toDisassociateApplications(): this;
    /**
     * Grants permission to disassociate source servers from an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DisassociateSourceServers.html
     */
    toDisassociateSourceServers(): this;
    /**
     * Grants permission to disconnect source server from service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DisconnectFromService.html
     */
    toDisconnectFromService(): this;
    /**
     * Grants permission to finalize cutover
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_FinalizeCutover.html
     */
    toFinalizeCutover(): this;
    /**
     * Grants permission to get agent command
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetAgentCommandForMgn(): this;
    /**
     * Grants permission to get agent confirmed resume info
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetAgentConfirmedResumeInfoForMgn(): this;
    /**
     * Grants permission to get agent installation assets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetAgentInstallationAssetsForMgn(): this;
    /**
     * Grants permission to get agent replication info
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetAgentReplicationInfoForMgn(): this;
    /**
     * Grants permission to get agent runtime configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetAgentRuntimeConfigurationForMgn(): this;
    /**
     * Grants permission to get agent snapshots credits
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetAgentSnapshotCreditsForMgn(): this;
    /**
     * Grants permission to get channel commands
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetChannelCommandsForMgn(): this;
    /**
     * Grants permission to get launch configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_GetLaunchConfiguration.html
     */
    toGetLaunchConfiguration(): this;
    /**
     * Grants permission to get a network migration definition
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_GetNetworkMigrationDefinition.html
     */
    toGetNetworkMigrationDefinition(): this;
    /**
     * Grants permission to get a network migration mapper segment construct
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_GetNetworkMigrationMapperSegmentConstruct.html
     */
    toGetNetworkMigrationMapperSegmentConstruct(): this;
    /**
     * Grants permission to get replication configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_GetReplicationConfiguration.html
     */
    toGetReplicationConfiguration(): this;
    /**
     * Grants permission to get vcenter client commands
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetVcenterClientCommandsForMgn(): this;
    /**
     * Grants permission to initialize service
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:AddRoleToInstanceProfile
     * - iam:CreateInstanceProfile
     * - iam:CreateServiceLinkedRole
     * - iam:GetInstanceProfile
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_InitializeService.html
     */
    toInitializeService(): this;
    /**
     * Grants permission to issue a client certificate
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toIssueClientCertificateForMgn(): this;
    /**
     * Grants permission to list application summaries
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListApplications.html
     */
    toListApplications(): this;
    /**
     * Grants permission to list connectors
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListConnectors.html
     */
    toListConnectors(): this;
    /**
     * Grants permission to list the errors of an export task
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListExportErrors.html
     */
    toListExportErrors(): this;
    /**
     * Grants permission to list export tasks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListExports.html
     */
    toListExports(): this;
    /**
     * Grants permission to list the errors of an import task
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListImportErrors.html
     */
    toListImportErrors(): this;
    /**
     * Grants permission to list the import tasks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListImports.html
     */
    toListImports(): this;
    /**
     * Grants permission to list managed accounts
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListManagedAccounts.html
     */
    toListManagedAccounts(): this;
    /**
     * Grants permission to list network migration analyses
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationAnalyses.html
     */
    toListNetworkMigrationAnalyses(): this;
    /**
     * Grants permission to list network migration analysis results
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationAnalysisResults.html
     */
    toListNetworkMigrationAnalysisResults(): this;
    /**
     * Grants permission to list network migration code generation segments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationCodeGenerationSegments.html
     */
    toListNetworkMigrationCodeGenerationSegments(): this;
    /**
     * Grants permission to list network migration code generations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationCodeGenerations.html
     */
    toListNetworkMigrationCodeGenerations(): this;
    /**
     * Grants permission to list network migration definitions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationDefinitions.html
     */
    toListNetworkMigrationDefinitions(): this;
    /**
     * Grants permission to list network migration deployed stacks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationDeployedStacks.html
     */
    toListNetworkMigrationDeployedStacks(): this;
    /**
     * Grants permission to list network migration deployed stacks deletions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationDeployedStacksDeletions.html
     */
    toListNetworkMigrationDeployedStacksDeletions(): this;
    /**
     * Grants permission to list network migration deployments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationDeployments.html
     */
    toListNetworkMigrationDeployments(): this;
    /**
     * Grants permission to list network migration executions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationExecutions.html
     */
    toListNetworkMigrationExecutions(): this;
    /**
     * Grants permission to list network migration mapper segment constructs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationMapperSegmentConstructs.html
     */
    toListNetworkMigrationMapperSegmentConstructs(): this;
    /**
     * Grants permission to list network migration mapper segments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationMapperSegments.html
     */
    toListNetworkMigrationMapperSegments(): this;
    /**
     * Grants permission to list network migration mappings
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationMappings.html
     */
    toListNetworkMigrationMappings(): this;
    /**
     * Grants permission to list source server action documents
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListSourceServerActions.html
     */
    toListSourceServerActions(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list launch configuration template action documents
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListTemplateActions.html
     */
    toListTemplateActions(): this;
    /**
     * Grants permission to list wave summaries
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListWaves.html
     */
    toListWaves(): this;
    /**
     * Grants permission to mark source server as archived
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_MarkAsArchived.html
     */
    toMarkAsArchived(): this;
    /**
     * Grants permission to notify agent authentication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toNotifyAgentAuthenticationForMgn(): this;
    /**
     * Grants permission to notify agent is connected
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toNotifyAgentConnectedForMgn(): this;
    /**
     * Grants permission to notify agent is disconnected
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toNotifyAgentDisconnectedForMgn(): this;
    /**
     * Grants permission to notify agent replication progress
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toNotifyAgentReplicationProgressForMgn(): this;
    /**
     * Grants permission to notify vcenter client started
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toNotifyVcenterClientStartedForMgn(): this;
    /**
     * Grants permission to pause replication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_PauseReplication.html
     */
    toPauseReplication(): this;
    /**
     * Grants permission to put source server action document
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_PutSourceServerAction.html
     */
    toPutSourceServerAction(): this;
    /**
     * Grants permission to put launch configuration template action document
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_PutTemplateAction.html
     */
    toPutTemplateAction(): this;
    /**
     * Grants permission to register agent
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toRegisterAgentForMgn(): this;
    /**
     * Grants permission to remove source server action document
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_RemoveSourceServerAction.html
     */
    toRemoveSourceServerAction(): this;
    /**
     * Grants permission to remove launch configuration template action document
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_RemoveTemplateAction.html
     */
    toRemoveTemplateAction(): this;
    /**
     * Grants permission to resume replication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ResumeReplication.html
     */
    toResumeReplication(): this;
    /**
     * Grants permission to retry replication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_RetryDataReplication.html
     */
    toRetryDataReplication(): this;
    /**
     * Grants permission to send agent logs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendAgentLogsForMgn(): this;
    /**
     * Grants permission to send agent metrics
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendAgentMetricsForMgn(): this;
    /**
     * Grants permission to send channel command result
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendChannelCommandResultForMgn(): this;
    /**
     * Grants permission to send client logs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendClientLogsForMgn(): this;
    /**
     * Grants permission to send client metrics
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendClientMetricsForMgn(): this;
    /**
     * Grants permission to send vcenter client command result
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendVcenterClientCommandResultForMgn(): this;
    /**
     * Grants permission to send vcenter client logs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendVcenterClientLogsForMgn(): this;
    /**
     * Grants permission to send vcenter client metrics
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendVcenterClientMetricsForMgn(): this;
    /**
     * Grants permission to start cutover
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:AttachVolume
     * - ec2:AuthorizeSecurityGroupEgress
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:CreateLaunchTemplate
     * - ec2:CreateLaunchTemplateVersion
     * - ec2:CreateSecurityGroup
     * - ec2:CreateSnapshot
     * - ec2:CreateTags
     * - ec2:CreateVolume
     * - ec2:DeleteLaunchTemplateVersions
     * - ec2:DeleteSnapshot
     * - ec2:DeleteVolume
     * - ec2:DescribeAccountAttributes
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeImages
     * - ec2:DescribeInstanceAttribute
     * - ec2:DescribeInstanceStatus
     * - ec2:DescribeInstanceTypes
     * - ec2:DescribeInstances
     * - ec2:DescribeLaunchTemplateVersions
     * - ec2:DescribeLaunchTemplates
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSnapshots
     * - ec2:DescribeSubnets
     * - ec2:DescribeVolumes
     * - ec2:DetachVolume
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifyLaunchTemplate
     * - ec2:ReportInstanceStatus
     * - ec2:RevokeSecurityGroupEgress
     * - ec2:RunInstances
     * - ec2:StartInstances
     * - ec2:StopInstances
     * - ec2:TerminateInstances
     * - iam:PassRole
     * - mgn:ListTagsForResource
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartCutover.html
     */
    toStartCutover(): this;
    /**
     * Grants permission to start an export task
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:DescribeLaunchTemplateVersions
     * - mgn:DescribeSourceServers
     * - mgn:GetLaunchConfiguration
     * - mgn:ListApplications
     * - mgn:ListWaves
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartExport.html
     */
    toStartExport(): this;
    /**
     * Grants permission to create an import task
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:CreateLaunchTemplateVersion
     * - ec2:DescribeLaunchTemplateVersions
     * - ec2:ModifyLaunchTemplate
     * - mgn:DescribeSourceServers
     * - mgn:GetLaunchConfiguration
     * - mgn:ListApplications
     * - mgn:ListWaves
     * - mgn:TagResource
     * - mgn:UpdateLaunchConfiguration
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartImport.html
     */
    toStartImport(): this;
    /**
     * Grants permission to start a network migration analysis
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - directconnect:DescribeConnections
     * - directconnect:DescribeDirectConnectGatewayAssociations
     * - directconnect:DescribeDirectConnectGatewayAttachments
     * - directconnect:DescribeDirectConnectGateways
     * - directconnect:DescribeVirtualGateways
     * - directconnect:DescribeVirtualInterfaces
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:CreateNetworkInsightsPath
     * - ec2:CreateNetworkInterface
     * - ec2:CreateSecurityGroup
     * - ec2:CreateTags
     * - ec2:DeleteNetworkInsightsAnalysis
     * - ec2:DeleteNetworkInsightsPath
     * - ec2:DeleteNetworkInterface
     * - ec2:DeleteSecurityGroup
     * - ec2:DeleteTags
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeCustomerGateways
     * - ec2:DescribeInstances
     * - ec2:DescribeInternetGateways
     * - ec2:DescribeManagedPrefixLists
     * - ec2:DescribeNatGateways
     * - ec2:DescribeNetworkAcls
     * - ec2:DescribeNetworkInsightsAnalyses
     * - ec2:DescribeNetworkInsightsPaths
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribePrefixLists
     * - ec2:DescribeRegions
     * - ec2:DescribeRouteTables
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSubnets
     * - ec2:DescribeTransitGatewayAttachments
     * - ec2:DescribeTransitGatewayConnects
     * - ec2:DescribeTransitGatewayPeeringAttachments
     * - ec2:DescribeTransitGatewayRouteTables
     * - ec2:DescribeTransitGatewayVpcAttachments
     * - ec2:DescribeTransitGateways
     * - ec2:DescribeVpcEndpointServiceConfigurations
     * - ec2:DescribeVpcEndpoints
     * - ec2:DescribeVpcPeeringConnections
     * - ec2:DescribeVpcs
     * - ec2:DescribeVpnConnections
     * - ec2:DescribeVpnGateways
     * - ec2:GetManagedPrefixListEntries
     * - ec2:GetTransitGatewayRouteTablePropagations
     * - ec2:SearchTransitGatewayRoutes
     * - ec2:StartNetworkInsightsAnalysis
     * - elasticloadbalancing:DescribeListeners
     * - elasticloadbalancing:DescribeLoadBalancerAttributes
     * - elasticloadbalancing:DescribeLoadBalancers
     * - elasticloadbalancing:DescribeRules
     * - elasticloadbalancing:DescribeTags
     * - elasticloadbalancing:DescribeTargetGroupAttributes
     * - elasticloadbalancing:DescribeTargetGroups
     * - elasticloadbalancing:DescribeTargetHealth
     * - globalaccelerator:ListAccelerators
     * - globalaccelerator:ListCustomRoutingAccelerators
     * - globalaccelerator:ListCustomRoutingEndpointGroups
     * - globalaccelerator:ListCustomRoutingListeners
     * - globalaccelerator:ListCustomRoutingPortMappings
     * - globalaccelerator:ListEndpointGroups
     * - globalaccelerator:ListListeners
     * - network-firewall:DescribeFirewall
     * - network-firewall:DescribeFirewallPolicy
     * - network-firewall:DescribeResourcePolicy
     * - network-firewall:DescribeRuleGroup
     * - network-firewall:ListFirewallPolicies
     * - network-firewall:ListFirewalls
     * - network-firewall:ListRuleGroups
     * - tiros:CreateQuery
     * - tiros:ExtendQuery
     * - tiros:GetQueryAnswer
     * - tiros:GetQueryExplanation
     * - tiros:GetQueryExtensionAccounts
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartNetworkMigrationAnalysis.html
     */
    toStartNetworkMigrationAnalysis(): this;
    /**
     * Grants permission to start network migration code generation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartNetworkMigrationCodeGeneration.html
     */
    toStartNetworkMigrationCodeGeneration(): this;
    /**
     * Grants permission to start deletion of network migration deployed stacks
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:AcceptTransitGatewayVpcAttachment
     * - ec2:AssociateNatGatewayAddress
     * - ec2:AssociateRouteTable
     * - ec2:AssociateSubnetCidrBlock
     * - ec2:AssociateTransitGatewayRouteTable
     * - ec2:AssociateVpcCidrBlock
     * - ec2:AttachInternetGateway
     * - ec2:AttachVolume
     * - ec2:AuthorizeSecurityGroupEgress
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:DeleteInternetGateway
     * - ec2:DeleteLaunchTemplate
     * - ec2:DeleteLaunchTemplateVersions
     * - ec2:DeleteNatGateway
     * - ec2:DeleteNetworkAcl
     * - ec2:DeleteNetworkAclEntry
     * - ec2:DeleteNetworkInsightsAnalysis
     * - ec2:DeleteNetworkInsightsPath
     * - ec2:DeleteNetworkInterface
     * - ec2:DeleteRoute
     * - ec2:DeleteRouteTable
     * - ec2:DeleteSecurityGroup
     * - ec2:DeleteSnapshot
     * - ec2:DeleteSubnet
     * - ec2:DeleteTransitGateway
     * - ec2:DeleteTransitGatewayRoute
     * - ec2:DeleteTransitGatewayRouteTable
     * - ec2:DeleteTransitGatewayVpcAttachment
     * - ec2:DeleteVolume
     * - ec2:DeleteVpc
     * - ec2:DetachInternetGateway
     * - ec2:DetachVolume
     * - ec2:DisableTransitGatewayRouteTablePropagation
     * - ec2:DisassociateNatGatewayAddress
     * - ec2:DisassociateRouteTable
     * - ec2:DisassociateTransitGatewayRouteTable
     * - ec2:EnableTransitGatewayRouteTablePropagation
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifyLaunchTemplate
     * - ec2:ModifySubnetAttribute
     * - ec2:ModifyTransitGateway
     * - ec2:ModifyTransitGatewayVpcAttachment
     * - ec2:ModifyVolume
     * - ec2:ModifyVpcAttribute
     * - ec2:RejectTransitGatewayVpcAttachment
     * - ec2:ReleaseAddress
     * - ec2:ReplaceNetworkAclAssociation
     * - ec2:ReplaceNetworkAclEntry
     * - ec2:ReplaceRoute
     * - ec2:ReplaceTransitGatewayRoute
     * - ec2:RevokeSecurityGroupEgress
     * - ec2:RevokeSecurityGroupIngress
     * - ec2:SearchTransitGatewayRoutes
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartNetworkMigrationDeployedStacksDeletion.html
     */
    toStartNetworkMigrationDeployedStacksDeletion(): this;
    /**
     * Grants permission to start a network migration deployment
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:AcceptTransitGatewayVpcAttachment
     * - ec2:AssociateNatGatewayAddress
     * - ec2:AssociateRouteTable
     * - ec2:AssociateSubnetCidrBlock
     * - ec2:AssociateTransitGatewayRouteTable
     * - ec2:AssociateVpcCidrBlock
     * - ec2:AttachInternetGateway
     * - ec2:AttachVolume
     * - ec2:AuthorizeSecurityGroupEgress
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:CreateNatGateway
     * - ec2:CreateNetworkAcl
     * - ec2:CreateNetworkAclEntry
     * - ec2:CreateNetworkInsightsPath
     * - ec2:CreateNetworkInterface
     * - ec2:CreateRoute
     * - ec2:CreateRouteTable
     * - ec2:CreateSecurityGroup
     * - ec2:CreateSubnet
     * - ec2:CreateTags
     * - ec2:CreateTransitGatewayRoute
     * - ec2:CreateTransitGatewayRouteTable
     * - ec2:CreateTransitGatewayVpcAttachment
     * - ec2:DeleteInternetGateway
     * - ec2:DeleteLaunchTemplate
     * - ec2:DeleteLaunchTemplateVersions
     * - ec2:DeleteNatGateway
     * - ec2:DeleteNetworkAcl
     * - ec2:DeleteNetworkAclEntry
     * - ec2:DeleteNetworkInsightsAnalysis
     * - ec2:DeleteNetworkInsightsPath
     * - ec2:DeleteNetworkInterface
     * - ec2:DeleteRoute
     * - ec2:DeleteRouteTable
     * - ec2:DeleteSecurityGroup
     * - ec2:DeleteSnapshot
     * - ec2:DeleteSubnet
     * - ec2:DeleteTransitGateway
     * - ec2:DeleteTransitGatewayRoute
     * - ec2:DeleteTransitGatewayRouteTable
     * - ec2:DeleteTransitGatewayVpcAttachment
     * - ec2:DeleteVolume
     * - ec2:DeleteVpc
     * - ec2:DescribeAccountAttributes
     * - ec2:DescribeAddresses
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeCustomerGateways
     * - ec2:DescribeEgressOnlyInternetGateways
     * - ec2:DescribeHosts
     * - ec2:DescribeImages
     * - ec2:DescribeInstanceAttribute
     * - ec2:DescribeInstanceStatus
     * - ec2:DescribeInstanceTypes
     * - ec2:DescribeInstances
     * - ec2:DescribeInternetGateways
     * - ec2:DescribeLaunchTemplateVersions
     * - ec2:DescribeLaunchTemplates
     * - ec2:DescribeManagedPrefixLists
     * - ec2:DescribeNatGateways
     * - ec2:DescribeNetworkAcls
     * - ec2:DescribeNetworkInsightsAnalyses
     * - ec2:DescribeNetworkInsightsPaths
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribePrefixLists
     * - ec2:DescribeRegions
     * - ec2:DescribeRouteTables
     * - ec2:DescribeSecurityGroupRules
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSnapshots
     * - ec2:DescribeSubnets
     * - ec2:DescribeTransitGatewayAttachments
     * - ec2:DescribeTransitGatewayConnects
     * - ec2:DescribeTransitGatewayPeeringAttachments
     * - ec2:DescribeTransitGatewayRouteTables
     * - ec2:DescribeTransitGatewayVpcAttachments
     * - ec2:DescribeTransitGateways
     * - ec2:DescribeVolumes
     * - ec2:DescribeVpcEndpointServiceConfigurations
     * - ec2:DescribeVpcEndpoints
     * - ec2:DescribeVpcPeeringConnections
     * - ec2:DescribeVpcs
     * - ec2:DescribeVpnConnections
     * - ec2:DescribeVpnGateways
     * - ec2:DetachInternetGateway
     * - ec2:DetachVolume
     * - ec2:DisableTransitGatewayRouteTablePropagation
     * - ec2:DisassociateNatGatewayAddress
     * - ec2:DisassociateRouteTable
     * - ec2:DisassociateTransitGatewayRouteTable
     * - ec2:EnableTransitGatewayRouteTablePropagation
     * - ec2:GetEbsDefaultKmsKeyId
     * - ec2:GetEbsEncryptionByDefault
     * - ec2:GetManagedPrefixListEntries
     * - ec2:GetTransitGatewayRouteTableAssociations
     * - ec2:GetTransitGatewayRouteTablePropagations
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifyLaunchTemplate
     * - ec2:ModifySubnetAttribute
     * - ec2:ModifyTransitGateway
     * - ec2:ModifyTransitGatewayVpcAttachment
     * - ec2:ModifyVolume
     * - ec2:ModifyVpcAttribute
     * - ec2:RejectTransitGatewayVpcAttachment
     * - ec2:ReleaseAddress
     * - ec2:ReplaceNetworkAclAssociation
     * - ec2:ReplaceNetworkAclEntry
     * - ec2:ReplaceRoute
     * - ec2:ReplaceTransitGatewayRoute
     * - ec2:RevokeSecurityGroupEgress
     * - ec2:RevokeSecurityGroupIngress
     * - ec2:SearchTransitGatewayRoutes
     * - ec2:StartNetworkInsightsAnalysis
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartNetworkMigrationDeployment.html
     */
    toStartNetworkMigrationDeployment(): this;
    /**
     * Grants permission to start a network migration mapping
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartNetworkMigrationMapping.html
     */
    toStartNetworkMigrationMapping(): this;
    /**
     * Grants permission to start replication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartReplication.html
     */
    toStartReplication(): this;
    /**
     * Grants permission to start test
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:AttachVolume
     * - ec2:AuthorizeSecurityGroupEgress
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:CreateLaunchTemplate
     * - ec2:CreateLaunchTemplateVersion
     * - ec2:CreateSecurityGroup
     * - ec2:CreateSnapshot
     * - ec2:CreateTags
     * - ec2:CreateVolume
     * - ec2:DeleteLaunchTemplateVersions
     * - ec2:DeleteSnapshot
     * - ec2:DeleteVolume
     * - ec2:DescribeAccountAttributes
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeImages
     * - ec2:DescribeInstanceAttribute
     * - ec2:DescribeInstanceStatus
     * - ec2:DescribeInstanceTypes
     * - ec2:DescribeInstances
     * - ec2:DescribeLaunchTemplateVersions
     * - ec2:DescribeLaunchTemplates
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSnapshots
     * - ec2:DescribeSubnets
     * - ec2:DescribeVolumes
     * - ec2:DetachVolume
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifyLaunchTemplate
     * - ec2:ReportInstanceStatus
     * - ec2:RevokeSecurityGroupEgress
     * - ec2:RunInstances
     * - ec2:StartInstances
     * - ec2:StopInstances
     * - ec2:TerminateInstances
     * - iam:PassRole
     * - mgn:ListTagsForResource
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartTest.html
     */
    toStartTest(): this;
    /**
     * Grants permission to stop replication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StopReplication.html
     */
    toStopReplication(): this;
    /**
     * Grants permission to assign a resource tag
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifCreateAction()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to terminate target instances
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:DeleteVolume
     * - ec2:DescribeInstances
     * - ec2:DescribeVolumes
     * - ec2:TerminateInstances
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_TerminateTargetInstances.html
     */
    toTerminateTargetInstances(): this;
    /**
     * Grants permission to unarchive an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UnarchiveApplication.html
     */
    toUnarchiveApplication(): this;
    /**
     * Grants permission to unarchive a wave
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UnarchiveWave.html
     */
    toUnarchiveWave(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update agent backlog
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toUpdateAgentBacklogForMgn(): this;
    /**
     * Grants permission to update agent conversion info
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toUpdateAgentConversionInfoForMgn(): this;
    /**
     * Grants permission to update agent replication info
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toUpdateAgentReplicationInfoForMgn(): this;
    /**
     * Grants permission to update agent replication process state
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toUpdateAgentReplicationProcessStateForMgn(): this;
    /**
     * Grants permission to update agent source properties
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toUpdateAgentSourcePropertiesForMgn(): this;
    /**
     * Grants permission to update an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateApplication.html
     */
    toUpdateApplication(): this;
    /**
     * Grants permission to update connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateConnector.html
     */
    toUpdateConnector(): this;
    /**
     * Grants permission to update launch configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateLaunchConfiguration.html
     */
    toUpdateLaunchConfiguration(): this;
    /**
     * Grants permission to update launch configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateLaunchConfigurationTemplate.html
     */
    toUpdateLaunchConfigurationTemplate(): this;
    /**
     * Grants permission to update a network migration definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateNetworkMigrationDefinition.html
     */
    toUpdateNetworkMigrationDefinition(): this;
    /**
     * Grants permission to update a network migration mapper segment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateNetworkMigrationMapperSegment.html
     */
    toUpdateNetworkMigrationMapperSegment(): this;
    /**
     * Grants permission to update a network migration mapper segment construct
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateNetworkMigrationMapperSegmentConstruct.html
     */
    toUpdateNetworkMigrationMapperSegmentConstruct(): this;
    /**
     * Grants permission to update replication configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateReplicationConfiguration.html
     */
    toUpdateReplicationConfiguration(): this;
    /**
     * Grants permission to update replication configuration template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateReplicationConfigurationTemplate.html
     */
    toUpdateReplicationConfigurationTemplate(): this;
    /**
     * Grants permission to update source server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateSourceServer.html
     */
    toUpdateSourceServer(): this;
    /**
     * Grants permission to update source server replication type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateSourceServerReplicationType.html
     */
    toUpdateSourceServerReplicationType(): this;
    /**
     * Grants permission to update a wave
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateWave.html
     */
    toUpdateWave(): this;
    /**
     * Grants permission to verify client role
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toVerifyClientRoleForMgn(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type JobResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/launching-target-servers.html
     *
     * @param jobID - Identifier for the jobID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onJobResource(jobID: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ReplicationConfigurationTemplateResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/replication-settings-template.html
     *
     * @param replicationConfigurationTemplateID - Identifier for the replicationConfigurationTemplateID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onReplicationConfigurationTemplateResource(replicationConfigurationTemplateID: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type LaunchConfigurationTemplateResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/post-launch-settings.html
     *
     * @param launchConfigurationTemplateID - Identifier for the launchConfigurationTemplateID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onLaunchConfigurationTemplateResource(launchConfigurationTemplateID: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type VcenterClientResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/agentless-mgn.html
     *
     * @param vcenterClientID - Identifier for the vcenterClientID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onVcenterClientResource(vcenterClientID: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type SourceServerResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/source-servers.html
     *
     * @param sourceServerID - Identifier for the sourceServerID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSourceServerResource(sourceServerID: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ApplicationResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/applications.html
     *
     * @param applicationID - Identifier for the applicationID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApplicationResource(applicationID: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type WaveResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/waves.html
     *
     * @param waveID - Identifier for the waveID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWaveResource(waveID: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ImportResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/imports.html
     *
     * @param importID - Identifier for the importID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onImportResource(importID: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ExportResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/exports.html
     *
     * @param exportID - Identifier for the exportID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onExportResource(exportID: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ConnectorResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/connectors.html
     *
     * @param connectorID - Identifier for the connectorID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConnectorResource(connectorID: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type NetworkMigrationDefinitionResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/network-migration-definition.html
     *
     * @param networkMigrationDefinitionID - Identifier for the networkMigrationDefinitionID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onNetworkMigrationDefinitionResource(networkMigrationDefinitionID: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by presence of tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateApplication()
     * - .toCreateConnector()
     * - .toCreateLaunchConfigurationTemplate()
     * - .toCreateNetworkMigrationDefinition()
     * - .toCreateReplicationConfigurationTemplate()
     * - .toCreateVcenterClientForMgn()
     * - .toCreateWave()
     * - .toRegisterAgentForMgn()
     * - .toStartCutover()
     * - .toStartExport()
     * - .toStartTest()
     * - .toTagResource()
     * - .toTerminateTargetInstances()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - JobResource
     * - ReplicationConfigurationTemplateResource
     * - LaunchConfigurationTemplateResource
     * - VcenterClientResource
     * - SourceServerResource
     * - ApplicationResource
     * - WaveResource
     * - ImportResource
     * - ExportResource
     * - ConnectorResource
     * - NetworkMigrationDefinitionResource
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by presence of tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateApplication()
     * - .toCreateConnector()
     * - .toCreateLaunchConfigurationTemplate()
     * - .toCreateNetworkMigrationDefinition()
     * - .toCreateReplicationConfigurationTemplate()
     * - .toCreateVcenterClientForMgn()
     * - .toCreateWave()
     * - .toRegisterAgentForMgn()
     * - .toStartCutover()
     * - .toStartExport()
     * - .toStartTest()
     * - .toTagResource()
     * - .toTerminateTargetInstances()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the name of a resource-creating API action
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/supported-iam-actions-tagging.html
     *
     * Applies to actions:
     * - .toTagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCreateAction(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [mgn](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapplicationmigrationservice.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
