"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mgn = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [mgn](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapplicationmigrationservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Mgn extends shared_1.PolicyStatement {
    /**
     * Grants permission to archive an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ArchiveApplication.html
     */
    toArchiveApplication() {
        return this.to('ArchiveApplication');
    }
    /**
     * Grants permission to archive a wave
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ArchiveWave.html
     */
    toArchiveWave() {
        return this.to('ArchiveWave');
    }
    /**
     * Grants permission to associate applications to a wave
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_AssociateApplications.html
     */
    toAssociateApplications() {
        return this.to('AssociateApplications');
    }
    /**
     * Grants permission to associate source servers to an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_AssociateSourceServers.html
     */
    toAssociateSourceServers() {
        return this.to('AssociateSourceServers');
    }
    /**
     * Grants permission to create volume snapshot group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toBatchCreateVolumeSnapshotGroupForMgn() {
        return this.to('BatchCreateVolumeSnapshotGroupForMgn');
    }
    /**
     * Grants permission to batch delete snapshot request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toBatchDeleteSnapshotRequestForMgn() {
        return this.to('BatchDeleteSnapshotRequestForMgn');
    }
    /**
     * Grants permission to change source server life cycle state
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ChangeServerLifeCycleState.html
     */
    toChangeServerLifeCycleState() {
        return this.to('ChangeServerLifeCycleState');
    }
    /**
     * Grants permission to create an application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_CreateApplication.html
     */
    toCreateApplication() {
        return this.to('CreateApplication');
    }
    /**
     * Grants permission to create connector
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_CreateConnector.html
     */
    toCreateConnector() {
        return this.to('CreateConnector');
    }
    /**
     * Grants permission to create launch configuration template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_CreateLaunchConfigurationTemplate.html
     */
    toCreateLaunchConfigurationTemplate() {
        return this.to('CreateLaunchConfigurationTemplate');
    }
    /**
     * Grants permission to create a network migration definition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_CreateNetworkMigrationDefinition.html
     */
    toCreateNetworkMigrationDefinition() {
        return this.to('CreateNetworkMigrationDefinition');
    }
    /**
     * Grants permission to create replication configuration template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_CreateReplicationConfigurationTemplate.html
     */
    toCreateReplicationConfigurationTemplate() {
        return this.to('CreateReplicationConfigurationTemplate');
    }
    /**
     * Grants permission to create vcenter client
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toCreateVcenterClientForMgn() {
        return this.to('CreateVcenterClientForMgn');
    }
    /**
     * Grants permission to create a wave
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_CreateWave.html
     */
    toCreateWave() {
        return this.to('CreateWave');
    }
    /**
     * Grants permission to delete an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteApplication.html
     */
    toDeleteApplication() {
        return this.to('DeleteApplication');
    }
    /**
     * Grants permission to delete connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteConnector.html
     */
    toDeleteConnector() {
        return this.to('DeleteConnector');
    }
    /**
     * Grants permission to delete job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteJob.html
     */
    toDeleteJob() {
        return this.to('DeleteJob');
    }
    /**
     * Grants permission to delete launch configuration template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteLaunchConfigurationTemplate.html
     */
    toDeleteLaunchConfigurationTemplate() {
        return this.to('DeleteLaunchConfigurationTemplate');
    }
    /**
     * Grants permission to delete a network migration definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteNetworkMigrationDefinition.html
     */
    toDeleteNetworkMigrationDefinition() {
        return this.to('DeleteNetworkMigrationDefinition');
    }
    /**
     * Grants permission to delete replication configuration template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteReplicationConfigurationTemplate.html
     */
    toDeleteReplicationConfigurationTemplate() {
        return this.to('DeleteReplicationConfigurationTemplate');
    }
    /**
     * Grants permission to delete source server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteSourceServer.html
     */
    toDeleteSourceServer() {
        return this.to('DeleteSourceServer');
    }
    /**
     * Grants permission to delete vcenter client
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteVcenterClient.html
     */
    toDeleteVcenterClient() {
        return this.to('DeleteVcenterClient');
    }
    /**
     * Grants permission to delete a wave
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DeleteWave.html
     */
    toDeleteWave() {
        return this.to('DeleteWave');
    }
    /**
     * Grants permission to describe job log items
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeJobLogItems.html
     */
    toDescribeJobLogItems() {
        return this.to('DescribeJobLogItems');
    }
    /**
     * Grants permission to describe jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeJobs.html
     */
    toDescribeJobs() {
        return this.to('DescribeJobs');
    }
    /**
     * Grants permission to describe launch configuration template
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeLaunchConfigurationTemplates.html
     */
    toDescribeLaunchConfigurationTemplates() {
        return this.to('DescribeLaunchConfigurationTemplates');
    }
    /**
     * Grants permission to describe replication configuration template
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeReplicationConfigurationTemplates.html
     */
    toDescribeReplicationConfigurationTemplates() {
        return this.to('DescribeReplicationConfigurationTemplates');
    }
    /**
     * Grants permission to describe replication server associations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toDescribeReplicationServerAssociationsForMgn() {
        return this.to('DescribeReplicationServerAssociationsForMgn');
    }
    /**
     * Grants permission to describe snapshots requests
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toDescribeSnapshotRequestsForMgn() {
        return this.to('DescribeSnapshotRequestsForMgn');
    }
    /**
     * Grants permission to describe source servers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeSourceServers.html
     */
    toDescribeSourceServers() {
        return this.to('DescribeSourceServers');
    }
    /**
     * Grants permission to describe vcenter clients
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DescribeVcenterClients.html
     */
    toDescribeVcenterClients() {
        return this.to('DescribeVcenterClients');
    }
    /**
     * Grants permission to disassociate applications from a wave
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DisassociateApplications.html
     */
    toDisassociateApplications() {
        return this.to('DisassociateApplications');
    }
    /**
     * Grants permission to disassociate source servers from an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DisassociateSourceServers.html
     */
    toDisassociateSourceServers() {
        return this.to('DisassociateSourceServers');
    }
    /**
     * Grants permission to disconnect source server from service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_DisconnectFromService.html
     */
    toDisconnectFromService() {
        return this.to('DisconnectFromService');
    }
    /**
     * Grants permission to finalize cutover
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_FinalizeCutover.html
     */
    toFinalizeCutover() {
        return this.to('FinalizeCutover');
    }
    /**
     * Grants permission to get agent command
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetAgentCommandForMgn() {
        return this.to('GetAgentCommandForMgn');
    }
    /**
     * Grants permission to get agent confirmed resume info
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetAgentConfirmedResumeInfoForMgn() {
        return this.to('GetAgentConfirmedResumeInfoForMgn');
    }
    /**
     * Grants permission to get agent installation assets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetAgentInstallationAssetsForMgn() {
        return this.to('GetAgentInstallationAssetsForMgn');
    }
    /**
     * Grants permission to get agent replication info
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetAgentReplicationInfoForMgn() {
        return this.to('GetAgentReplicationInfoForMgn');
    }
    /**
     * Grants permission to get agent runtime configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetAgentRuntimeConfigurationForMgn() {
        return this.to('GetAgentRuntimeConfigurationForMgn');
    }
    /**
     * Grants permission to get agent snapshots credits
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetAgentSnapshotCreditsForMgn() {
        return this.to('GetAgentSnapshotCreditsForMgn');
    }
    /**
     * Grants permission to get channel commands
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetChannelCommandsForMgn() {
        return this.to('GetChannelCommandsForMgn');
    }
    /**
     * Grants permission to get launch configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_GetLaunchConfiguration.html
     */
    toGetLaunchConfiguration() {
        return this.to('GetLaunchConfiguration');
    }
    /**
     * Grants permission to get a network migration definition
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_GetNetworkMigrationDefinition.html
     */
    toGetNetworkMigrationDefinition() {
        return this.to('GetNetworkMigrationDefinition');
    }
    /**
     * Grants permission to get a network migration mapper segment construct
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_GetNetworkMigrationMapperSegmentConstruct.html
     */
    toGetNetworkMigrationMapperSegmentConstruct() {
        return this.to('GetNetworkMigrationMapperSegmentConstruct');
    }
    /**
     * Grants permission to get replication configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_GetReplicationConfiguration.html
     */
    toGetReplicationConfiguration() {
        return this.to('GetReplicationConfiguration');
    }
    /**
     * Grants permission to get vcenter client commands
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toGetVcenterClientCommandsForMgn() {
        return this.to('GetVcenterClientCommandsForMgn');
    }
    /**
     * Grants permission to initialize service
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:AddRoleToInstanceProfile
     * - iam:CreateInstanceProfile
     * - iam:CreateServiceLinkedRole
     * - iam:GetInstanceProfile
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_InitializeService.html
     */
    toInitializeService() {
        return this.to('InitializeService');
    }
    /**
     * Grants permission to issue a client certificate
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toIssueClientCertificateForMgn() {
        return this.to('IssueClientCertificateForMgn');
    }
    /**
     * Grants permission to list application summaries
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListApplications.html
     */
    toListApplications() {
        return this.to('ListApplications');
    }
    /**
     * Grants permission to list connectors
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListConnectors.html
     */
    toListConnectors() {
        return this.to('ListConnectors');
    }
    /**
     * Grants permission to list the errors of an export task
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListExportErrors.html
     */
    toListExportErrors() {
        return this.to('ListExportErrors');
    }
    /**
     * Grants permission to list export tasks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListExports.html
     */
    toListExports() {
        return this.to('ListExports');
    }
    /**
     * Grants permission to list the errors of an import task
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListImportErrors.html
     */
    toListImportErrors() {
        return this.to('ListImportErrors');
    }
    /**
     * Grants permission to list the import tasks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListImports.html
     */
    toListImports() {
        return this.to('ListImports');
    }
    /**
     * Grants permission to list managed accounts
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListManagedAccounts.html
     */
    toListManagedAccounts() {
        return this.to('ListManagedAccounts');
    }
    /**
     * Grants permission to list network migration analyses
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationAnalyses.html
     */
    toListNetworkMigrationAnalyses() {
        return this.to('ListNetworkMigrationAnalyses');
    }
    /**
     * Grants permission to list network migration analysis results
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationAnalysisResults.html
     */
    toListNetworkMigrationAnalysisResults() {
        return this.to('ListNetworkMigrationAnalysisResults');
    }
    /**
     * Grants permission to list network migration code generation segments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationCodeGenerationSegments.html
     */
    toListNetworkMigrationCodeGenerationSegments() {
        return this.to('ListNetworkMigrationCodeGenerationSegments');
    }
    /**
     * Grants permission to list network migration code generations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationCodeGenerations.html
     */
    toListNetworkMigrationCodeGenerations() {
        return this.to('ListNetworkMigrationCodeGenerations');
    }
    /**
     * Grants permission to list network migration definitions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationDefinitions.html
     */
    toListNetworkMigrationDefinitions() {
        return this.to('ListNetworkMigrationDefinitions');
    }
    /**
     * Grants permission to list network migration deployed stacks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationDeployedStacks.html
     */
    toListNetworkMigrationDeployedStacks() {
        return this.to('ListNetworkMigrationDeployedStacks');
    }
    /**
     * Grants permission to list network migration deployed stacks deletions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationDeployedStacksDeletions.html
     */
    toListNetworkMigrationDeployedStacksDeletions() {
        return this.to('ListNetworkMigrationDeployedStacksDeletions');
    }
    /**
     * Grants permission to list network migration deployments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationDeployments.html
     */
    toListNetworkMigrationDeployments() {
        return this.to('ListNetworkMigrationDeployments');
    }
    /**
     * Grants permission to list network migration executions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationExecutions.html
     */
    toListNetworkMigrationExecutions() {
        return this.to('ListNetworkMigrationExecutions');
    }
    /**
     * Grants permission to list network migration mapper segment constructs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationMapperSegmentConstructs.html
     */
    toListNetworkMigrationMapperSegmentConstructs() {
        return this.to('ListNetworkMigrationMapperSegmentConstructs');
    }
    /**
     * Grants permission to list network migration mapper segments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationMapperSegments.html
     */
    toListNetworkMigrationMapperSegments() {
        return this.to('ListNetworkMigrationMapperSegments');
    }
    /**
     * Grants permission to list network migration mappings
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListNetworkMigrationMappings.html
     */
    toListNetworkMigrationMappings() {
        return this.to('ListNetworkMigrationMappings');
    }
    /**
     * Grants permission to list source server action documents
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListSourceServerActions.html
     */
    toListSourceServerActions() {
        return this.to('ListSourceServerActions');
    }
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to list launch configuration template action documents
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListTemplateActions.html
     */
    toListTemplateActions() {
        return this.to('ListTemplateActions');
    }
    /**
     * Grants permission to list wave summaries
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ListWaves.html
     */
    toListWaves() {
        return this.to('ListWaves');
    }
    /**
     * Grants permission to mark source server as archived
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_MarkAsArchived.html
     */
    toMarkAsArchived() {
        return this.to('MarkAsArchived');
    }
    /**
     * Grants permission to notify agent authentication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toNotifyAgentAuthenticationForMgn() {
        return this.to('NotifyAgentAuthenticationForMgn');
    }
    /**
     * Grants permission to notify agent is connected
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toNotifyAgentConnectedForMgn() {
        return this.to('NotifyAgentConnectedForMgn');
    }
    /**
     * Grants permission to notify agent is disconnected
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toNotifyAgentDisconnectedForMgn() {
        return this.to('NotifyAgentDisconnectedForMgn');
    }
    /**
     * Grants permission to notify agent replication progress
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toNotifyAgentReplicationProgressForMgn() {
        return this.to('NotifyAgentReplicationProgressForMgn');
    }
    /**
     * Grants permission to notify vcenter client started
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toNotifyVcenterClientStartedForMgn() {
        return this.to('NotifyVcenterClientStartedForMgn');
    }
    /**
     * Grants permission to pause replication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_PauseReplication.html
     */
    toPauseReplication() {
        return this.to('PauseReplication');
    }
    /**
     * Grants permission to put source server action document
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_PutSourceServerAction.html
     */
    toPutSourceServerAction() {
        return this.to('PutSourceServerAction');
    }
    /**
     * Grants permission to put launch configuration template action document
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_PutTemplateAction.html
     */
    toPutTemplateAction() {
        return this.to('PutTemplateAction');
    }
    /**
     * Grants permission to register agent
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toRegisterAgentForMgn() {
        return this.to('RegisterAgentForMgn');
    }
    /**
     * Grants permission to remove source server action document
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_RemoveSourceServerAction.html
     */
    toRemoveSourceServerAction() {
        return this.to('RemoveSourceServerAction');
    }
    /**
     * Grants permission to remove launch configuration template action document
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_RemoveTemplateAction.html
     */
    toRemoveTemplateAction() {
        return this.to('RemoveTemplateAction');
    }
    /**
     * Grants permission to resume replication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_ResumeReplication.html
     */
    toResumeReplication() {
        return this.to('ResumeReplication');
    }
    /**
     * Grants permission to retry replication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_RetryDataReplication.html
     */
    toRetryDataReplication() {
        return this.to('RetryDataReplication');
    }
    /**
     * Grants permission to send agent logs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendAgentLogsForMgn() {
        return this.to('SendAgentLogsForMgn');
    }
    /**
     * Grants permission to send agent metrics
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendAgentMetricsForMgn() {
        return this.to('SendAgentMetricsForMgn');
    }
    /**
     * Grants permission to send channel command result
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendChannelCommandResultForMgn() {
        return this.to('SendChannelCommandResultForMgn');
    }
    /**
     * Grants permission to send client logs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendClientLogsForMgn() {
        return this.to('SendClientLogsForMgn');
    }
    /**
     * Grants permission to send client metrics
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendClientMetricsForMgn() {
        return this.to('SendClientMetricsForMgn');
    }
    /**
     * Grants permission to send vcenter client command result
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendVcenterClientCommandResultForMgn() {
        return this.to('SendVcenterClientCommandResultForMgn');
    }
    /**
     * Grants permission to send vcenter client logs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendVcenterClientLogsForMgn() {
        return this.to('SendVcenterClientLogsForMgn');
    }
    /**
     * Grants permission to send vcenter client metrics
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toSendVcenterClientMetricsForMgn() {
        return this.to('SendVcenterClientMetricsForMgn');
    }
    /**
     * Grants permission to start cutover
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:AttachVolume
     * - ec2:AuthorizeSecurityGroupEgress
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:CreateLaunchTemplate
     * - ec2:CreateLaunchTemplateVersion
     * - ec2:CreateSecurityGroup
     * - ec2:CreateSnapshot
     * - ec2:CreateTags
     * - ec2:CreateVolume
     * - ec2:DeleteLaunchTemplateVersions
     * - ec2:DeleteSnapshot
     * - ec2:DeleteVolume
     * - ec2:DescribeAccountAttributes
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeImages
     * - ec2:DescribeInstanceAttribute
     * - ec2:DescribeInstanceStatus
     * - ec2:DescribeInstanceTypes
     * - ec2:DescribeInstances
     * - ec2:DescribeLaunchTemplateVersions
     * - ec2:DescribeLaunchTemplates
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSnapshots
     * - ec2:DescribeSubnets
     * - ec2:DescribeVolumes
     * - ec2:DetachVolume
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifyLaunchTemplate
     * - ec2:ReportInstanceStatus
     * - ec2:RevokeSecurityGroupEgress
     * - ec2:RunInstances
     * - ec2:StartInstances
     * - ec2:StopInstances
     * - ec2:TerminateInstances
     * - iam:PassRole
     * - mgn:ListTagsForResource
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartCutover.html
     */
    toStartCutover() {
        return this.to('StartCutover');
    }
    /**
     * Grants permission to start an export task
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:DescribeLaunchTemplateVersions
     * - mgn:DescribeSourceServers
     * - mgn:GetLaunchConfiguration
     * - mgn:ListApplications
     * - mgn:ListWaves
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartExport.html
     */
    toStartExport() {
        return this.to('StartExport');
    }
    /**
     * Grants permission to create an import task
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:CreateLaunchTemplateVersion
     * - ec2:DescribeLaunchTemplateVersions
     * - ec2:ModifyLaunchTemplate
     * - mgn:DescribeSourceServers
     * - mgn:GetLaunchConfiguration
     * - mgn:ListApplications
     * - mgn:ListWaves
     * - mgn:TagResource
     * - mgn:UpdateLaunchConfiguration
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartImport.html
     */
    toStartImport() {
        return this.to('StartImport');
    }
    /**
     * Grants permission to start a network migration analysis
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - directconnect:DescribeConnections
     * - directconnect:DescribeDirectConnectGatewayAssociations
     * - directconnect:DescribeDirectConnectGatewayAttachments
     * - directconnect:DescribeDirectConnectGateways
     * - directconnect:DescribeVirtualGateways
     * - directconnect:DescribeVirtualInterfaces
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:CreateNetworkInsightsPath
     * - ec2:CreateNetworkInterface
     * - ec2:CreateSecurityGroup
     * - ec2:CreateTags
     * - ec2:DeleteNetworkInsightsAnalysis
     * - ec2:DeleteNetworkInsightsPath
     * - ec2:DeleteNetworkInterface
     * - ec2:DeleteSecurityGroup
     * - ec2:DeleteTags
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeCustomerGateways
     * - ec2:DescribeInstances
     * - ec2:DescribeInternetGateways
     * - ec2:DescribeManagedPrefixLists
     * - ec2:DescribeNatGateways
     * - ec2:DescribeNetworkAcls
     * - ec2:DescribeNetworkInsightsAnalyses
     * - ec2:DescribeNetworkInsightsPaths
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribePrefixLists
     * - ec2:DescribeRegions
     * - ec2:DescribeRouteTables
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSubnets
     * - ec2:DescribeTransitGatewayAttachments
     * - ec2:DescribeTransitGatewayConnects
     * - ec2:DescribeTransitGatewayPeeringAttachments
     * - ec2:DescribeTransitGatewayRouteTables
     * - ec2:DescribeTransitGatewayVpcAttachments
     * - ec2:DescribeTransitGateways
     * - ec2:DescribeVpcEndpointServiceConfigurations
     * - ec2:DescribeVpcEndpoints
     * - ec2:DescribeVpcPeeringConnections
     * - ec2:DescribeVpcs
     * - ec2:DescribeVpnConnections
     * - ec2:DescribeVpnGateways
     * - ec2:GetManagedPrefixListEntries
     * - ec2:GetTransitGatewayRouteTablePropagations
     * - ec2:SearchTransitGatewayRoutes
     * - ec2:StartNetworkInsightsAnalysis
     * - elasticloadbalancing:DescribeListeners
     * - elasticloadbalancing:DescribeLoadBalancerAttributes
     * - elasticloadbalancing:DescribeLoadBalancers
     * - elasticloadbalancing:DescribeRules
     * - elasticloadbalancing:DescribeTags
     * - elasticloadbalancing:DescribeTargetGroupAttributes
     * - elasticloadbalancing:DescribeTargetGroups
     * - elasticloadbalancing:DescribeTargetHealth
     * - globalaccelerator:ListAccelerators
     * - globalaccelerator:ListCustomRoutingAccelerators
     * - globalaccelerator:ListCustomRoutingEndpointGroups
     * - globalaccelerator:ListCustomRoutingListeners
     * - globalaccelerator:ListCustomRoutingPortMappings
     * - globalaccelerator:ListEndpointGroups
     * - globalaccelerator:ListListeners
     * - network-firewall:DescribeFirewall
     * - network-firewall:DescribeFirewallPolicy
     * - network-firewall:DescribeResourcePolicy
     * - network-firewall:DescribeRuleGroup
     * - network-firewall:ListFirewallPolicies
     * - network-firewall:ListFirewalls
     * - network-firewall:ListRuleGroups
     * - tiros:CreateQuery
     * - tiros:ExtendQuery
     * - tiros:GetQueryAnswer
     * - tiros:GetQueryExplanation
     * - tiros:GetQueryExtensionAccounts
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartNetworkMigrationAnalysis.html
     */
    toStartNetworkMigrationAnalysis() {
        return this.to('StartNetworkMigrationAnalysis');
    }
    /**
     * Grants permission to start network migration code generation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartNetworkMigrationCodeGeneration.html
     */
    toStartNetworkMigrationCodeGeneration() {
        return this.to('StartNetworkMigrationCodeGeneration');
    }
    /**
     * Grants permission to start deletion of network migration deployed stacks
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:AcceptTransitGatewayVpcAttachment
     * - ec2:AssociateNatGatewayAddress
     * - ec2:AssociateRouteTable
     * - ec2:AssociateSubnetCidrBlock
     * - ec2:AssociateTransitGatewayRouteTable
     * - ec2:AssociateVpcCidrBlock
     * - ec2:AttachInternetGateway
     * - ec2:AttachVolume
     * - ec2:AuthorizeSecurityGroupEgress
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:DeleteInternetGateway
     * - ec2:DeleteLaunchTemplate
     * - ec2:DeleteLaunchTemplateVersions
     * - ec2:DeleteNatGateway
     * - ec2:DeleteNetworkAcl
     * - ec2:DeleteNetworkAclEntry
     * - ec2:DeleteNetworkInsightsAnalysis
     * - ec2:DeleteNetworkInsightsPath
     * - ec2:DeleteNetworkInterface
     * - ec2:DeleteRoute
     * - ec2:DeleteRouteTable
     * - ec2:DeleteSecurityGroup
     * - ec2:DeleteSnapshot
     * - ec2:DeleteSubnet
     * - ec2:DeleteTransitGateway
     * - ec2:DeleteTransitGatewayRoute
     * - ec2:DeleteTransitGatewayRouteTable
     * - ec2:DeleteTransitGatewayVpcAttachment
     * - ec2:DeleteVolume
     * - ec2:DeleteVpc
     * - ec2:DetachInternetGateway
     * - ec2:DetachVolume
     * - ec2:DisableTransitGatewayRouteTablePropagation
     * - ec2:DisassociateNatGatewayAddress
     * - ec2:DisassociateRouteTable
     * - ec2:DisassociateTransitGatewayRouteTable
     * - ec2:EnableTransitGatewayRouteTablePropagation
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifyLaunchTemplate
     * - ec2:ModifySubnetAttribute
     * - ec2:ModifyTransitGateway
     * - ec2:ModifyTransitGatewayVpcAttachment
     * - ec2:ModifyVolume
     * - ec2:ModifyVpcAttribute
     * - ec2:RejectTransitGatewayVpcAttachment
     * - ec2:ReleaseAddress
     * - ec2:ReplaceNetworkAclAssociation
     * - ec2:ReplaceNetworkAclEntry
     * - ec2:ReplaceRoute
     * - ec2:ReplaceTransitGatewayRoute
     * - ec2:RevokeSecurityGroupEgress
     * - ec2:RevokeSecurityGroupIngress
     * - ec2:SearchTransitGatewayRoutes
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartNetworkMigrationDeployedStacksDeletion.html
     */
    toStartNetworkMigrationDeployedStacksDeletion() {
        return this.to('StartNetworkMigrationDeployedStacksDeletion');
    }
    /**
     * Grants permission to start a network migration deployment
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:AcceptTransitGatewayVpcAttachment
     * - ec2:AssociateNatGatewayAddress
     * - ec2:AssociateRouteTable
     * - ec2:AssociateSubnetCidrBlock
     * - ec2:AssociateTransitGatewayRouteTable
     * - ec2:AssociateVpcCidrBlock
     * - ec2:AttachInternetGateway
     * - ec2:AttachVolume
     * - ec2:AuthorizeSecurityGroupEgress
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:CreateNatGateway
     * - ec2:CreateNetworkAcl
     * - ec2:CreateNetworkAclEntry
     * - ec2:CreateNetworkInsightsPath
     * - ec2:CreateNetworkInterface
     * - ec2:CreateRoute
     * - ec2:CreateRouteTable
     * - ec2:CreateSecurityGroup
     * - ec2:CreateSubnet
     * - ec2:CreateTags
     * - ec2:CreateTransitGatewayRoute
     * - ec2:CreateTransitGatewayRouteTable
     * - ec2:CreateTransitGatewayVpcAttachment
     * - ec2:DeleteInternetGateway
     * - ec2:DeleteLaunchTemplate
     * - ec2:DeleteLaunchTemplateVersions
     * - ec2:DeleteNatGateway
     * - ec2:DeleteNetworkAcl
     * - ec2:DeleteNetworkAclEntry
     * - ec2:DeleteNetworkInsightsAnalysis
     * - ec2:DeleteNetworkInsightsPath
     * - ec2:DeleteNetworkInterface
     * - ec2:DeleteRoute
     * - ec2:DeleteRouteTable
     * - ec2:DeleteSecurityGroup
     * - ec2:DeleteSnapshot
     * - ec2:DeleteSubnet
     * - ec2:DeleteTransitGateway
     * - ec2:DeleteTransitGatewayRoute
     * - ec2:DeleteTransitGatewayRouteTable
     * - ec2:DeleteTransitGatewayVpcAttachment
     * - ec2:DeleteVolume
     * - ec2:DeleteVpc
     * - ec2:DescribeAccountAttributes
     * - ec2:DescribeAddresses
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeCustomerGateways
     * - ec2:DescribeEgressOnlyInternetGateways
     * - ec2:DescribeHosts
     * - ec2:DescribeImages
     * - ec2:DescribeInstanceAttribute
     * - ec2:DescribeInstanceStatus
     * - ec2:DescribeInstanceTypes
     * - ec2:DescribeInstances
     * - ec2:DescribeInternetGateways
     * - ec2:DescribeLaunchTemplateVersions
     * - ec2:DescribeLaunchTemplates
     * - ec2:DescribeManagedPrefixLists
     * - ec2:DescribeNatGateways
     * - ec2:DescribeNetworkAcls
     * - ec2:DescribeNetworkInsightsAnalyses
     * - ec2:DescribeNetworkInsightsPaths
     * - ec2:DescribeNetworkInterfaces
     * - ec2:DescribePrefixLists
     * - ec2:DescribeRegions
     * - ec2:DescribeRouteTables
     * - ec2:DescribeSecurityGroupRules
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSnapshots
     * - ec2:DescribeSubnets
     * - ec2:DescribeTransitGatewayAttachments
     * - ec2:DescribeTransitGatewayConnects
     * - ec2:DescribeTransitGatewayPeeringAttachments
     * - ec2:DescribeTransitGatewayRouteTables
     * - ec2:DescribeTransitGatewayVpcAttachments
     * - ec2:DescribeTransitGateways
     * - ec2:DescribeVolumes
     * - ec2:DescribeVpcEndpointServiceConfigurations
     * - ec2:DescribeVpcEndpoints
     * - ec2:DescribeVpcPeeringConnections
     * - ec2:DescribeVpcs
     * - ec2:DescribeVpnConnections
     * - ec2:DescribeVpnGateways
     * - ec2:DetachInternetGateway
     * - ec2:DetachVolume
     * - ec2:DisableTransitGatewayRouteTablePropagation
     * - ec2:DisassociateNatGatewayAddress
     * - ec2:DisassociateRouteTable
     * - ec2:DisassociateTransitGatewayRouteTable
     * - ec2:EnableTransitGatewayRouteTablePropagation
     * - ec2:GetEbsDefaultKmsKeyId
     * - ec2:GetEbsEncryptionByDefault
     * - ec2:GetManagedPrefixListEntries
     * - ec2:GetTransitGatewayRouteTableAssociations
     * - ec2:GetTransitGatewayRouteTablePropagations
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifyLaunchTemplate
     * - ec2:ModifySubnetAttribute
     * - ec2:ModifyTransitGateway
     * - ec2:ModifyTransitGatewayVpcAttachment
     * - ec2:ModifyVolume
     * - ec2:ModifyVpcAttribute
     * - ec2:RejectTransitGatewayVpcAttachment
     * - ec2:ReleaseAddress
     * - ec2:ReplaceNetworkAclAssociation
     * - ec2:ReplaceNetworkAclEntry
     * - ec2:ReplaceRoute
     * - ec2:ReplaceTransitGatewayRoute
     * - ec2:RevokeSecurityGroupEgress
     * - ec2:RevokeSecurityGroupIngress
     * - ec2:SearchTransitGatewayRoutes
     * - ec2:StartNetworkInsightsAnalysis
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartNetworkMigrationDeployment.html
     */
    toStartNetworkMigrationDeployment() {
        return this.to('StartNetworkMigrationDeployment');
    }
    /**
     * Grants permission to start a network migration mapping
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartNetworkMigrationMapping.html
     */
    toStartNetworkMigrationMapping() {
        return this.to('StartNetworkMigrationMapping');
    }
    /**
     * Grants permission to start replication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartReplication.html
     */
    toStartReplication() {
        return this.to('StartReplication');
    }
    /**
     * Grants permission to start test
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:AttachVolume
     * - ec2:AuthorizeSecurityGroupEgress
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:CreateLaunchTemplate
     * - ec2:CreateLaunchTemplateVersion
     * - ec2:CreateSecurityGroup
     * - ec2:CreateSnapshot
     * - ec2:CreateTags
     * - ec2:CreateVolume
     * - ec2:DeleteLaunchTemplateVersions
     * - ec2:DeleteSnapshot
     * - ec2:DeleteVolume
     * - ec2:DescribeAccountAttributes
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeImages
     * - ec2:DescribeInstanceAttribute
     * - ec2:DescribeInstanceStatus
     * - ec2:DescribeInstanceTypes
     * - ec2:DescribeInstances
     * - ec2:DescribeLaunchTemplateVersions
     * - ec2:DescribeLaunchTemplates
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSnapshots
     * - ec2:DescribeSubnets
     * - ec2:DescribeVolumes
     * - ec2:DetachVolume
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifyLaunchTemplate
     * - ec2:ReportInstanceStatus
     * - ec2:RevokeSecurityGroupEgress
     * - ec2:RunInstances
     * - ec2:StartInstances
     * - ec2:StopInstances
     * - ec2:TerminateInstances
     * - iam:PassRole
     * - mgn:ListTagsForResource
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StartTest.html
     */
    toStartTest() {
        return this.to('StartTest');
    }
    /**
     * Grants permission to stop replication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_StopReplication.html
     */
    toStopReplication() {
        return this.to('StopReplication');
    }
    /**
     * Grants permission to assign a resource tag
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifCreateAction()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to terminate target instances
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:DeleteVolume
     * - ec2:DescribeInstances
     * - ec2:DescribeVolumes
     * - ec2:TerminateInstances
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_TerminateTargetInstances.html
     */
    toTerminateTargetInstances() {
        return this.to('TerminateTargetInstances');
    }
    /**
     * Grants permission to unarchive an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UnarchiveApplication.html
     */
    toUnarchiveApplication() {
        return this.to('UnarchiveApplication');
    }
    /**
     * Grants permission to unarchive a wave
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UnarchiveWave.html
     */
    toUnarchiveWave() {
        return this.to('UnarchiveWave');
    }
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update agent backlog
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toUpdateAgentBacklogForMgn() {
        return this.to('UpdateAgentBacklogForMgn');
    }
    /**
     * Grants permission to update agent conversion info
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toUpdateAgentConversionInfoForMgn() {
        return this.to('UpdateAgentConversionInfoForMgn');
    }
    /**
     * Grants permission to update agent replication info
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toUpdateAgentReplicationInfoForMgn() {
        return this.to('UpdateAgentReplicationInfoForMgn');
    }
    /**
     * Grants permission to update agent replication process state
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toUpdateAgentReplicationProcessStateForMgn() {
        return this.to('UpdateAgentReplicationProcessStateForMgn');
    }
    /**
     * Grants permission to update agent source properties
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toUpdateAgentSourcePropertiesForMgn() {
        return this.to('UpdateAgentSourcePropertiesForMgn');
    }
    /**
     * Grants permission to update an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateApplication.html
     */
    toUpdateApplication() {
        return this.to('UpdateApplication');
    }
    /**
     * Grants permission to update connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateConnector.html
     */
    toUpdateConnector() {
        return this.to('UpdateConnector');
    }
    /**
     * Grants permission to update launch configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateLaunchConfiguration.html
     */
    toUpdateLaunchConfiguration() {
        return this.to('UpdateLaunchConfiguration');
    }
    /**
     * Grants permission to update launch configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateLaunchConfigurationTemplate.html
     */
    toUpdateLaunchConfigurationTemplate() {
        return this.to('UpdateLaunchConfigurationTemplate');
    }
    /**
     * Grants permission to update a network migration definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateNetworkMigrationDefinition.html
     */
    toUpdateNetworkMigrationDefinition() {
        return this.to('UpdateNetworkMigrationDefinition');
    }
    /**
     * Grants permission to update a network migration mapper segment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateNetworkMigrationMapperSegment.html
     */
    toUpdateNetworkMigrationMapperSegment() {
        return this.to('UpdateNetworkMigrationMapperSegment');
    }
    /**
     * Grants permission to update a network migration mapper segment construct
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateNetworkMigrationMapperSegmentConstruct.html
     */
    toUpdateNetworkMigrationMapperSegmentConstruct() {
        return this.to('UpdateNetworkMigrationMapperSegmentConstruct');
    }
    /**
     * Grants permission to update replication configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateReplicationConfiguration.html
     */
    toUpdateReplicationConfiguration() {
        return this.to('UpdateReplicationConfiguration');
    }
    /**
     * Grants permission to update replication configuration template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateReplicationConfigurationTemplate.html
     */
    toUpdateReplicationConfigurationTemplate() {
        return this.to('UpdateReplicationConfigurationTemplate');
    }
    /**
     * Grants permission to update source server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateSourceServer.html
     */
    toUpdateSourceServer() {
        return this.to('UpdateSourceServer');
    }
    /**
     * Grants permission to update source server replication type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateSourceServerReplicationType.html
     */
    toUpdateSourceServerReplicationType() {
        return this.to('UpdateSourceServerReplicationType');
    }
    /**
     * Grants permission to update a wave
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mgn/latest/APIReference/API_UpdateWave.html
     */
    toUpdateWave() {
        return this.to('UpdateWave');
    }
    /**
     * Grants permission to verify client role
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/mgn-apis.html
     */
    toVerifyClientRoleForMgn() {
        return this.to('VerifyClientRoleForMgn');
    }
    /**
     * Adds a resource of type JobResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/launching-target-servers.html
     *
     * @param jobID - Identifier for the jobID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onJobResource(jobID, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:mgn:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:job/${jobID}`);
    }
    /**
     * Adds a resource of type ReplicationConfigurationTemplateResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/replication-settings-template.html
     *
     * @param replicationConfigurationTemplateID - Identifier for the replicationConfigurationTemplateID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onReplicationConfigurationTemplateResource(replicationConfigurationTemplateID, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:mgn:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:replication-configuration-template/${replicationConfigurationTemplateID}`);
    }
    /**
     * Adds a resource of type LaunchConfigurationTemplateResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/post-launch-settings.html
     *
     * @param launchConfigurationTemplateID - Identifier for the launchConfigurationTemplateID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onLaunchConfigurationTemplateResource(launchConfigurationTemplateID, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:mgn:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:launch-configuration-template/${launchConfigurationTemplateID}`);
    }
    /**
     * Adds a resource of type VcenterClientResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/agentless-mgn.html
     *
     * @param vcenterClientID - Identifier for the vcenterClientID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onVcenterClientResource(vcenterClientID, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:mgn:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:vcenter-client/${vcenterClientID}`);
    }
    /**
     * Adds a resource of type SourceServerResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/source-servers.html
     *
     * @param sourceServerID - Identifier for the sourceServerID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSourceServerResource(sourceServerID, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:mgn:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:source-server/${sourceServerID}`);
    }
    /**
     * Adds a resource of type ApplicationResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/applications.html
     *
     * @param applicationID - Identifier for the applicationID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApplicationResource(applicationID, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:mgn:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:application/${applicationID}`);
    }
    /**
     * Adds a resource of type WaveResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/waves.html
     *
     * @param waveID - Identifier for the waveID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWaveResource(waveID, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:mgn:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:wave/${waveID}`);
    }
    /**
     * Adds a resource of type ImportResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/imports.html
     *
     * @param importID - Identifier for the importID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onImportResource(importID, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:mgn:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:import/${importID}`);
    }
    /**
     * Adds a resource of type ExportResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/exports.html
     *
     * @param exportID - Identifier for the exportID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onExportResource(exportID, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:mgn:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:export/${exportID}`);
    }
    /**
     * Adds a resource of type ConnectorResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/connectors.html
     *
     * @param connectorID - Identifier for the connectorID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConnectorResource(connectorID, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:mgn:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:connector/${connectorID}`);
    }
    /**
     * Adds a resource of type NetworkMigrationDefinitionResource to the statement
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/network-migration-definition.html
     *
     * @param networkMigrationDefinitionID - Identifier for the networkMigrationDefinitionID.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onNetworkMigrationDefinitionResource(networkMigrationDefinitionID, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:mgn:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:network-migration-definition/${networkMigrationDefinitionID}`);
    }
    /**
     * Filters access by presence of tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateApplication()
     * - .toCreateConnector()
     * - .toCreateLaunchConfigurationTemplate()
     * - .toCreateNetworkMigrationDefinition()
     * - .toCreateReplicationConfigurationTemplate()
     * - .toCreateVcenterClientForMgn()
     * - .toCreateWave()
     * - .toRegisterAgentForMgn()
     * - .toStartCutover()
     * - .toStartExport()
     * - .toStartTest()
     * - .toTagResource()
     * - .toTerminateTargetInstances()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey, value, operator) {
        return this.if(`aws:RequestTag/${tagKey}`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - JobResource
     * - ReplicationConfigurationTemplateResource
     * - LaunchConfigurationTemplateResource
     * - VcenterClientResource
     * - SourceServerResource
     * - ApplicationResource
     * - WaveResource
     * - ImportResource
     * - ExportResource
     * - ConnectorResource
     * - NetworkMigrationDefinitionResource
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey, value, operator) {
        return this.if(`aws:ResourceTag/${tagKey}`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by presence of tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateApplication()
     * - .toCreateConnector()
     * - .toCreateLaunchConfigurationTemplate()
     * - .toCreateNetworkMigrationDefinition()
     * - .toCreateReplicationConfigurationTemplate()
     * - .toCreateVcenterClientForMgn()
     * - .toCreateWave()
     * - .toRegisterAgentForMgn()
     * - .toStartCutover()
     * - .toStartExport()
     * - .toStartTest()
     * - .toTagResource()
     * - .toTerminateTargetInstances()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value, operator) {
        return this.if(`aws:TagKeys`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by the name of a resource-creating API action
     *
     * https://docs.aws.amazon.com/mgn/latest/ug/supported-iam-actions-tagging.html
     *
     * Applies to actions:
     * - .toTagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCreateAction(value, operator) {
        return this.if(`CreateAction`, value, operator ?? 'StringLike');
    }
    /**
     * Statement provider for service [mgn](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapplicationmigrationservice.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'mgn';
        this.accessLevelList = {
            Write: [
                'ArchiveApplication',
                'ArchiveWave',
                'AssociateApplications',
                'AssociateSourceServers',
                'BatchCreateVolumeSnapshotGroupForMgn',
                'BatchDeleteSnapshotRequestForMgn',
                'ChangeServerLifeCycleState',
                'CreateApplication',
                'CreateConnector',
                'CreateLaunchConfigurationTemplate',
                'CreateNetworkMigrationDefinition',
                'CreateReplicationConfigurationTemplate',
                'CreateVcenterClientForMgn',
                'CreateWave',
                'DeleteApplication',
                'DeleteConnector',
                'DeleteJob',
                'DeleteLaunchConfigurationTemplate',
                'DeleteNetworkMigrationDefinition',
                'DeleteReplicationConfigurationTemplate',
                'DeleteSourceServer',
                'DeleteVcenterClient',
                'DeleteWave',
                'DisassociateApplications',
                'DisassociateSourceServers',
                'DisconnectFromService',
                'FinalizeCutover',
                'InitializeService',
                'IssueClientCertificateForMgn',
                'MarkAsArchived',
                'NotifyAgentAuthenticationForMgn',
                'NotifyAgentConnectedForMgn',
                'NotifyAgentDisconnectedForMgn',
                'NotifyAgentReplicationProgressForMgn',
                'NotifyVcenterClientStartedForMgn',
                'PauseReplication',
                'PutSourceServerAction',
                'PutTemplateAction',
                'RegisterAgentForMgn',
                'RemoveSourceServerAction',
                'RemoveTemplateAction',
                'ResumeReplication',
                'RetryDataReplication',
                'SendAgentLogsForMgn',
                'SendAgentMetricsForMgn',
                'SendChannelCommandResultForMgn',
                'SendClientLogsForMgn',
                'SendClientMetricsForMgn',
                'SendVcenterClientCommandResultForMgn',
                'SendVcenterClientLogsForMgn',
                'SendVcenterClientMetricsForMgn',
                'StartCutover',
                'StartExport',
                'StartImport',
                'StartNetworkMigrationAnalysis',
                'StartNetworkMigrationCodeGeneration',
                'StartNetworkMigrationDeployedStacksDeletion',
                'StartNetworkMigrationDeployment',
                'StartNetworkMigrationMapping',
                'StartReplication',
                'StartTest',
                'StopReplication',
                'TerminateTargetInstances',
                'UnarchiveApplication',
                'UnarchiveWave',
                'UpdateAgentBacklogForMgn',
                'UpdateAgentConversionInfoForMgn',
                'UpdateAgentReplicationInfoForMgn',
                'UpdateAgentReplicationProcessStateForMgn',
                'UpdateAgentSourcePropertiesForMgn',
                'UpdateApplication',
                'UpdateConnector',
                'UpdateLaunchConfiguration',
                'UpdateLaunchConfigurationTemplate',
                'UpdateNetworkMigrationDefinition',
                'UpdateNetworkMigrationMapperSegment',
                'UpdateNetworkMigrationMapperSegmentConstruct',
                'UpdateReplicationConfiguration',
                'UpdateReplicationConfigurationTemplate',
                'UpdateSourceServer',
                'UpdateSourceServerReplicationType',
                'UpdateWave'
            ],
            Read: [
                'DescribeJobLogItems',
                'DescribeReplicationServerAssociationsForMgn',
                'DescribeSnapshotRequestsForMgn',
                'GetAgentCommandForMgn',
                'GetAgentConfirmedResumeInfoForMgn',
                'GetAgentInstallationAssetsForMgn',
                'GetAgentReplicationInfoForMgn',
                'GetAgentRuntimeConfigurationForMgn',
                'GetAgentSnapshotCreditsForMgn',
                'GetChannelCommandsForMgn',
                'GetLaunchConfiguration',
                'GetNetworkMigrationDefinition',
                'GetNetworkMigrationMapperSegmentConstruct',
                'GetReplicationConfiguration',
                'GetVcenterClientCommandsForMgn',
                'ListConnectors',
                'ListTagsForResource',
                'VerifyClientRoleForMgn'
            ],
            List: [
                'DescribeJobs',
                'DescribeLaunchConfigurationTemplates',
                'DescribeReplicationConfigurationTemplates',
                'DescribeSourceServers',
                'DescribeVcenterClients',
                'ListApplications',
                'ListExportErrors',
                'ListExports',
                'ListImportErrors',
                'ListImports',
                'ListManagedAccounts',
                'ListNetworkMigrationAnalyses',
                'ListNetworkMigrationAnalysisResults',
                'ListNetworkMigrationCodeGenerationSegments',
                'ListNetworkMigrationCodeGenerations',
                'ListNetworkMigrationDefinitions',
                'ListNetworkMigrationDeployedStacks',
                'ListNetworkMigrationDeployedStacksDeletions',
                'ListNetworkMigrationDeployments',
                'ListNetworkMigrationExecutions',
                'ListNetworkMigrationMapperSegmentConstructs',
                'ListNetworkMigrationMapperSegments',
                'ListNetworkMigrationMappings',
                'ListSourceServerActions',
                'ListTemplateActions',
                'ListWaves'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
}
exports.Mgn = Mgn;
//# sourceMappingURL=data:application/json;base64,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