import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [appsync](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsappsync.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Appsync extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to attach a GraphQL API to a custom domain name in AppSync
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_AssociateApi.html
     */
    toAssociateApi(): this;
    /**
     * Grants permission to associate a merged API to a source API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_AssociateMergedGraphqlApi.html
     */
    toAssociateMergedGraphqlApi(): this;
    /**
     * Grants permission to associate a source API to a merged API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_AssociateSourceGraphqlApi.html
     */
    toAssociateSourceGraphqlApi(): this;
    /**
     * Grants permission to create an API
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_CreateApi.html
     */
    toCreateApi(): this;
    /**
     * Grants permission to create an API cache in AppSync
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_CreateApiCache.html
     */
    toCreateApiCache(): this;
    /**
     * Grants permission to create a unique key that you can distribute to clients who are executing your API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_CreateApiKey.html
     */
    toCreateApiKey(): this;
    /**
     * Grants permission to create a channel namespace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_CreateChannelNamespace.html
     */
    toCreateChannelNamespace(): this;
    /**
     * Grants permission to create a data source
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_CreateDataSource.html
     */
    toCreateDataSource(): this;
    /**
     * Grants permission to create a custom domain name in AppSync
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_CreateDomainName.html
     */
    toCreateDomainName(): this;
    /**
     * Grants permission to create a new function
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_CreateFunction.html
     */
    toCreateFunction(): this;
    /**
     * Grants permission to create a GraphQL API, which is the top level AppSync resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVisibility()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_CreateGraphqlApi.html
     */
    toCreateGraphqlApi(): this;
    /**
     * Grants permission to create a resolver. A resolver converts incoming requests into a format that a data source can understand, and converts the data source's responses into GraphQL
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_CreateResolver.html
     */
    toCreateResolver(): this;
    /**
     * Grants permission to create a type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_CreateType.html
     */
    toCreateType(): this;
    /**
     * Grants permission to delete a API. This will also clean up every AppSync resource below that API
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_DeleteApi.html
     */
    toDeleteApi(): this;
    /**
     * Grants permission to delete an API cache in AppSync
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_DeleteApiCache.html
     */
    toDeleteApiCache(): this;
    /**
     * Grants permission to delete an API key
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_DeleteApiKey.html
     */
    toDeleteApiKey(): this;
    /**
     * Grants permission to delete a channel namespace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_DeleteChannelNamespace.html
     */
    toDeleteChannelNamespace(): this;
    /**
     * Grants permission to delete a data source
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_DeleteDataSource.html
     */
    toDeleteDataSource(): this;
    /**
     * Grants permission to delete a custom domain name in AppSync
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_DeleteDomainName.html
     */
    toDeleteDomainName(): this;
    /**
     * Grants permission to delete a function
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_DeleteFunction.html
     */
    toDeleteFunction(): this;
    /**
     * Grants permission to delete a GraphQL Api. This will also clean up every AppSync resource below that API
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_DeleteGraphqlApi.html
     */
    toDeleteGraphqlApi(): this;
    /**
     * Grants permission to delete a resolver
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_DeleteResolver.html
     */
    toDeleteResolver(): this;
    /**
     * Grants permission to remove a resource policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/devguide/merge-api.html
     */
    toDeleteResourcePolicy(): this;
    /**
     * Grants permission to delete a type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_DeleteType.html
     */
    toDeleteType(): this;
    /**
     * Grants permission to detach a GraphQL API to a custom domain name in AppSync
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_DisassociateApi.html
     */
    toDisassociateApi(): this;
    /**
     * Grants permission to remove an associated source API from a merged API identified by the source API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_DisassociateMergedGraphqlApi.html
     */
    toDisassociateMergedGraphqlApi(): this;
    /**
     * Grants permission to remove an associated source API from a merged API identified by the merged API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_DisassociateSourceGraphqlApi.html
     */
    toDisassociateSourceGraphqlApi(): this;
    /**
     * Grants permission to evaluate code with a runtime and context
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_EvaluateCode.html
     */
    toEvaluateCode(): this;
    /**
     * Grants permission to evaluate template mapping
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_EvaluateMappingTemplate.html
     */
    toEvaluateMappingTemplate(): this;
    /**
     * Grants permission to connect to an Event API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/devguide/using-your-event-api.html
     */
    toEventConnect(): this;
    /**
     * Grants permission to publish events to a channel namespace
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/devguide/using-your-event-api.html
     */
    toEventPublish(): this;
    /**
     * Grants permission to subscribe to a channel namespace
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/devguide/using-your-event-api.html
     */
    toEventSubscribe(): this;
    /**
     * Grants permission to flush an API cache in AppSync
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_FlushApiCache.html
     */
    toFlushApiCache(): this;
    /**
     * Grants permission to retrieve an API
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_GetApi.html
     */
    toGetApi(): this;
    /**
     * Grants permission to read custom domain name - GraphQL API association details in AppSync
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_GetApiAssociation.html
     */
    toGetApiAssociation(): this;
    /**
     * Grants permission to read information about an API cache in AppSync
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_GetApiCache.html
     */
    toGetApiCache(): this;
    /**
     * Grants permission to retrieve a channel namespace
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_GetChannelNamespace.html
     */
    toGetChannelNamespace(): this;
    /**
     * Grants permission to retrieve a data source
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_GetDataSource.html
     */
    toGetDataSource(): this;
    /**
     * Grants permission to retrieve a data source introspection
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_GetDataSourceIntrospection.html
     */
    toGetDataSourceIntrospection(): this;
    /**
     * Grants permission to read information about a custom domain name in AppSync
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_GetDomainName.html
     */
    toGetDomainName(): this;
    /**
     * Grants permission to retrieve a function
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_GetFunction.html
     */
    toGetFunction(): this;
    /**
     * Grants permission to retrieve a GraphQL API
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_GetGraphqlApi.html
     */
    toGetGraphqlApi(): this;
    /**
     * Grants permission to retrieve the environment variables for a GraphQL API
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_GetGraphqlApiEnvironmentVariables.html
     */
    toGetGraphqlApiEnvironmentVariables(): this;
    /**
     * Grants permission to retrieve the introspection schema for a GraphQL API
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_GetIntrospectionSchema.html
     */
    toGetIntrospectionSchema(): this;
    /**
     * Grants permission to retrieve a resolver
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_GetResolver.html
     */
    toGetResolver(): this;
    /**
     * Grants permission to read a resource policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appsync/latest/devguide/merge-api.html
     */
    toGetResourcePolicy(): this;
    /**
     * Grants permission to retrieve the current status of a schema creation operation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_GetSchemaCreationStatus.html
     */
    toGetSchemaCreationStatus(): this;
    /**
     * Grants permission to read information about a merged API associated source API
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_GetSourceApiAssociation.html
     */
    toGetSourceApiAssociation(): this;
    /**
     * Grants permission to retrieve a type
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_GetType.html
     */
    toGetType(): this;
    /**
     * Grants permission to send a GraphQL query to a GraphQL API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/devguide/security-authz.html#aws-iam-authorization
     */
    toGraphQL(): this;
    /**
     * Grants permission to list the API keys for a given API
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_ListApiKeys.html
     */
    toListApiKeys(): this;
    /**
     * Grants permission to list APIs
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_ListApis.html
     */
    toListApis(): this;
    /**
     * Grants permission to list channel namespace
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_ListChannelNamespaces.html
     */
    toListChannelNamespaces(): this;
    /**
     * Grants permission to list the data sources for a given API
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_ListDataSources.html
     */
    toListDataSources(): this;
    /**
     * Grants permission to enumerate custom domain names in AppSync
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_ListDomainNames.html
     */
    toListDomainNames(): this;
    /**
     * Grants permission to list the functions for a given API
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_ListFunctions.html
     */
    toListFunctions(): this;
    /**
     * Grants permission to list GraphQL APIs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_ListGraphqlApis.html
     */
    toListGraphqlApis(): this;
    /**
     * Grants permission to list the resolvers for a given API and type
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_ListResolvers.html
     */
    toListResolvers(): this;
    /**
     * Grants permission to list the resolvers that are associated with a specific function
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_ListResolversByFunction.html
     */
    toListResolversByFunction(): this;
    /**
     * Grants permission to list source APIs associated to a given merged API
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_ListSourceApiAssociations.html
     */
    toListSourceApiAssociations(): this;
    /**
     * Grants permission to list the tags for a resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list the types for a given API
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_ListTypes.html
     */
    toListTypes(): this;
    /**
     * Grants permission to list the types for a given merged API and source API association
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_ListTypesByAssociation.html
     */
    toListTypesByAssociation(): this;
    /**
     * Grants permission to update the environment variables for a GraphQL API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_PutGraphqlApiEnvironmentVariables.html
     */
    toPutGraphqlApiEnvironmentVariables(): this;
    /**
     * Grants permission to set a resource policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/devguide/merge-api.html
     */
    toPutResourcePolicy(): this;
    /**
     * Grants permission to set a web ACL
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/appsync/latest/devguide/WAF-Integration.html
     */
    toSetWebACL(): this;
    /**
     * Grants permission to send a GraphQL query to a source API of a merged API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/devguide/using-your-api.html
     */
    toSourceGraphQL(): this;
    /**
     * Grants permission to introspect a data source
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_StartDataSourceIntrospection.html
     */
    toStartDataSourceIntrospection(): this;
    /**
     * Grants permission to add a new schema to your GraphQL API. This operation is asynchronous - GetSchemaCreationStatus can show when it has completed
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_StartSchemaCreation.html
     */
    toStartSchemaCreation(): this;
    /**
     * Grants permission to initiate a schema merge for a given merged API and associated source API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_StartSchemaMerge.html
     */
    toStartSchemaMerge(): this;
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update an API
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_UpdateApi.html
     */
    toUpdateApi(): this;
    /**
     * Grants permission to update an API cache in AppSync
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_UpdateApiCache.html
     */
    toUpdateApiCache(): this;
    /**
     * Grants permission to update an API key for a given API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_UpdateApiKey.html
     */
    toUpdateApiKey(): this;
    /**
     * Grants permission to update a channel namespace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_UpdateChannelNamespace.html
     */
    toUpdateChannelNamespace(): this;
    /**
     * Grants permission to update a data source
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_UpdateDataSource.html
     */
    toUpdateDataSource(): this;
    /**
     * Grants permission to update a custom domain name in AppSync
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_UpdateDomainName.html
     */
    toUpdateDomainName(): this;
    /**
     * Grants permission to update an existing function
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_UpdateFunction.html
     */
    toUpdateFunction(): this;
    /**
     * Grants permission to update a GraphQL API
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_UpdateGraphqlApi.html
     */
    toUpdateGraphqlApi(): this;
    /**
     * Grants permission to update a resolver
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_UpdateResolver.html
     */
    toUpdateResolver(): this;
    /**
     * Grants permission to update a merged API source API association
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_UpdateSourceApiAssociation.html
     */
    toUpdateSourceApiAssociation(): this;
    /**
     * Grants permission to update a type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appsync/latest/APIReference/API_UpdateType.html
     */
    toUpdateType(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type datasource to the statement
     *
     * https://docs.aws.amazon.com/appsync/latest/devguide/attaching-a-data-source.html
     *
     * @param graphQLAPIId - Identifier for the graphQLAPIId.
     * @param datasourceName - Identifier for the datasourceName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDatasource(graphQLAPIId: string, datasourceName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type domain to the statement
     *
     * https://docs.aws.amazon.com/appsync/latest/devguide/custom-domain-name.html
     *
     * @param domainName - Identifier for the domainName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDomain(domainName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type graphqlapi to the statement
     *
     * https://docs.aws.amazon.com/appsync/latest/devguide/designing-a-graphql-api.html
     *
     * @param graphQLAPIId - Identifier for the graphQLAPIId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onGraphqlapi(graphQLAPIId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type field to the statement
     *
     * https://docs.aws.amazon.com/appsync/latest/devguide/configuring-resolvers.html
     *
     * @param graphQLAPIId - Identifier for the graphQLAPIId.
     * @param typeName - Identifier for the typeName.
     * @param fieldName - Identifier for the fieldName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onField(graphQLAPIId: string, typeName: string, fieldName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type type to the statement
     *
     * https://docs.aws.amazon.com/appsync/latest/devguide/designing-your-schema.html#adding-a-root-query-type
     *
     * @param graphQLAPIId - Identifier for the graphQLAPIId.
     * @param typeName - Identifier for the typeName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onType(graphQLAPIId: string, typeName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type function to the statement
     *
     * https://docs.aws.amazon.com/appsync/latest/devguide/pipeline-resolvers.html
     *
     * @param graphQLAPIId - Identifier for the graphQLAPIId.
     * @param functionId - Identifier for the functionId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onFunction(graphQLAPIId: string, functionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type sourceApiAssociation to the statement
     *
     * https://docs.aws.amazon.com/appsync/latest/devguide/merged-api.html
     *
     * @param mergedGraphQLAPIId - Identifier for the mergedGraphQLAPIId.
     * @param associationid - Identifier for the associationid.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSourceApiAssociation(mergedGraphQLAPIId: string, associationid: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type mergedApiAssociation to the statement
     *
     * https://docs.aws.amazon.com/appsync/latest/devguide/merged-api.html
     *
     * @param sourceGraphQLAPIId - Identifier for the sourceGraphQLAPIId.
     * @param associationid - Identifier for the associationid.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onMergedApiAssociation(sourceGraphQLAPIId: string, associationid: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type api to the statement
     *
     * https://docs.aws.amazon.com/appsync/latest/eventapi/event-api-welcome.html
     *
     * @param apiId - Identifier for the apiId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApi(apiId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type channelNamespace to the statement
     *
     * https://docs.aws.amazon.com/appsync/latest/eventapi/channel-namespaces.html
     *
     * @param apiId - Identifier for the apiId.
     * @param channelNamespaceName - Identifier for the channelNamespaceName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onChannelNamespace(apiId: string, channelNamespaceName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the visibility of an API
     *
     * Applies to actions:
     * - .toCreateGraphqlApi()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVisibility(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateApi()
     * - .toCreateChannelNamespace()
     * - .toCreateDomainName()
     * - .toCreateGraphqlApi()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toCreateApi()
     * - .toCreateChannelNamespace()
     * - .toCreateDomainName()
     * - .toDeleteApi()
     * - .toDeleteChannelNamespace()
     * - .toDeleteDomainName()
     * - .toDeleteGraphqlApi()
     * - .toGetApi()
     * - .toGetChannelNamespace()
     * - .toGetDomainName()
     * - .toGetGraphqlApi()
     * - .toListApis()
     * - .toListChannelNamespaces()
     * - .toListDomainNames()
     * - .toListTagsForResource()
     * - .toTagResource()
     * - .toUntagResource()
     * - .toUpdateApi()
     * - .toUpdateChannelNamespace()
     * - .toUpdateDomainName()
     * - .toUpdateGraphqlApi()
     *
     * Applies to resource types:
     * - domain
     * - graphqlapi
     * - api
     * - channelNamespace
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the presence of tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateApi()
     * - .toCreateChannelNamespace()
     * - .toCreateDomainName()
     * - .toCreateGraphqlApi()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [appsync](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsappsync.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
