import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [arc-region-switch](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonarcregionswitch.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class ArcRegionSwitch extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to approve a plan execution step
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/arc-region-switch/latest/api/API_ApprovePlanExecutionStep.html
     */
    toApprovePlanExecutionStep(): this;
    /**
     * Grants permission to cancel a plan execution
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/arc-region-switch/latest/api/API_CancelPlanExecution.html
     */
    toCancelPlanExecution(): this;
    /**
     * Grants permission to create a plan
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/arc-region-switch/latest/api/API_CreatePlan.html
     */
    toCreatePlan(): this;
    /**
     * Grants permission to delete a plan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/arc-region-switch/latest/api/API_DeletePlan.html
     */
    toDeletePlan(): this;
    /**
     * Grants permission to delete the RAM access control policy for a plan
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/r53recovery/latest/dg/arc-region-switch.region-switch-different-accounts.html
     */
    toDeleteResourcePolicy(): this;
    /**
     * Grants permission to get information about plans in all AWS Regions using a control plane
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/arc-region-switch/latest/api/API_GetPlan.html
     */
    toGetPlan(): this;
    /**
     * Grants permission to get a plan's evaluation status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/arc-region-switch/latest/api/API_GetPlanEvaluationStatus.html
     */
    toGetPlanEvaluationStatus(): this;
    /**
     * Grants permission to get plan execution details and setup information
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/arc-region-switch/latest/api/API_GetPlanExecution.html
     */
    toGetPlanExecution(): this;
    /**
     * Grants permission to get information about a plan in a specific AWS Region using the Region switch Regional data plane
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/arc-region-switch/latest/api/API_GetPlanInRegion.html
     */
    toGetPlanInRegion(): this;
    /**
     * Grants permission to get the resource policy of a plan
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/r53recovery/latest/dg/arc-region-switch.region-switch-different-accounts.html
     */
    toGetResourcePolicy(): this;
    /**
     * Grants permission to list plan execution events
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/arc-region-switch/latest/api/API_ListPlanExecutionEvents.html
     */
    toListPlanExecutionEvents(): this;
    /**
     * Grants permission to list plan executions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/arc-region-switch/latest/api/API_ListPlanExecutions.html
     */
    toListPlanExecutions(): this;
    /**
     * Grants permission to list plans in all AWS Regions using a control plane
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/arc-region-switch/latest/api/API_ListPlans.html
     */
    toListPlans(): this;
    /**
     * Grants permission to list plans in a specific AWS Region using the Region switch Regional data plane
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/arc-region-switch/latest/api/API_ListPlansInRegion.html
     */
    toListPlansInRegion(): this;
    /**
     * Grants permission to list Route 53 health checks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/arc-region-switch/latest/api/API_ListRoute53HealthChecks.html
     */
    toListRoute53HealthChecks(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/arc-region-switch/latest/api/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to define the RAM access control policy for a plan
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/r53recovery/latest/dg/arc-region-switch.region-switch-different-accounts.html
     */
    toPutResourcePolicy(): this;
    /**
     * Grants permission to start a plan execution
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/arc-region-switch/latest/api/API_StartPlanExecution.html
     */
    toStartPlanExecution(): this;
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/arc-region-switch/latest/api/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/arc-region-switch/latest/api/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a plan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/arc-region-switch/latest/api/API_UpdatePlan.html
     */
    toUpdatePlan(): this;
    /**
     * Grants permission to update a plan execution
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/arc-region-switch/latest/api/API_UpdatePlanExecution.html
     */
    toUpdatePlanExecution(): this;
    /**
     * Grants permission to update a plan execution step
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/arc-region-switch/latest/api/API_UpdatePlanExecutionStep.html
     */
    toUpdatePlanExecutionStep(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type plan to the statement
     *
     * https://docs.aws.amazon.com/r53recovery/latest/dg/plan.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPlan(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreatePlan()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a tag's key and value in a request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toListTagsForResource()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * Applies to resource types:
     * - plan
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the presence of tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreatePlan()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [arc-region-switch](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonarcregionswitch.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
