import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [artifact](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsartifact.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Artifact extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to accept an AWS agreement that has not yet been accepted by the customer account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/artifact/latest/APIReference/API_AcceptAgreement.html
     */
    toAcceptAgreement(): this;
    /**
     * Grants permission to accept the terms of an NDA Document for a given agreement resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/artifact/latest/APIReference/API_AcceptNdaForAgreement.html
     */
    toAcceptNdaForAgreement(): this;
    /**
     * Grants permission to get the account settings for Artifact
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/artifact/latest/APIReference/API_GetAccountSettings.html
     */
    toGetAccountSettings(): this;
    /**
     * Grants permission to get an AWS agreement that has not yet been accepted by the customer account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/artifact/latest/APIReference/API_GetAgreement.html
     */
    toGetAgreement(): this;
    /**
     * Grants permission to get an AWS agreement that has been accepted by the customer account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/artifact/latest/APIReference/API_GetCustomerAgreement.html
     */
    toGetCustomerAgreement(): this;
    /**
     * Grants permission to retrieve the NDA Document for a given agreement resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/artifact/latest/APIReference/API_GetNdaForAgreement.html
     */
    toGetNdaForAgreement(): this;
    /**
     * Grants permission to download a report
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/artifact/latest/APIReference/API_GetReport.html
     */
    toGetReport(): this;
    /**
     * Grants permission to download metadata associated with a report
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/artifact/latest/APIReference/API_GetReportMetadata.html
     */
    toGetReportMetadata(): this;
    /**
     * Grants permission to download a term associated with a report
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/artifact/latest/APIReference/API_GetTermForReport.html
     */
    toGetTermForReport(): this;
    /**
     * Grants permission to list AWS agreements
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/artifact/latest/APIReference/API_ListAgreements.html
     */
    toListAgreements(): this;
    /**
     * Grants permission to list customer-agreement resources that have been accepted by the customer account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/artifact/latest/APIReference/API_ListCustomerAgreements.html
     */
    toListCustomerAgreements(): this;
    /**
     * Grants permission to list reports in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/artifact/latest/APIReference/API_ListReports.html
     */
    toListReports(): this;
    /**
     * Grants permission to put account settings for Artifact
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/artifact/latest/APIReference/API_PutAccountSettings.html
     */
    toPutAccountSettings(): this;
    /**
     * Grants permission to terminate a customer agreement that was previously accepted by the customer account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/artifact/latest/APIReference/API_TerminateAgreement.html
     */
    toTerminateAgreement(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type customer-agreement to the statement
     *
     * https://docs.aws.amazon.com/artifact/latest/ug/managing-agreements.html
     *
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCustomerAgreement(resourceName: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type agreement to the statement
     *
     * https://docs.aws.amazon.com/artifact/latest/ug/managing-agreements.html
     *
     * @param resourceName - Identifier for the resourceName.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onAgreement(resourceName: string, partition?: string): this;
    /**
     * Adds a resource of type report to the statement
     *
     * https://docs.aws.amazon.com/artifact/latest/ug/what-is-aws-artifact.html
     *
     * @param reportId - Identifier for the reportId.
     * @param version - Identifier for the version.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifReportCategory()
     * - .ifReportSeries()
     */
    onReport(reportId: string, version: string, region?: string, partition?: string): this;
    /**
     * Filters access by which category reports are associated with
     *
     * https://docs.aws.amazon.com/artifact/latest/ug/using-condition-keys.html
     *
     * Applies to resource types:
     * - report
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifReportCategory(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by which series reports are associated with
     *
     * https://docs.aws.amazon.com/artifact/latest/ug/using-condition-keys.html
     *
     * Applies to resource types:
     * - report
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifReportSeries(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [artifact](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsartifact.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
