"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bedrock = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [bedrock](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbedrock.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Bedrock extends shared_1.PolicyStatement {
    /**
     * Grants permission to configure vended log delivery for a knowledge base
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toAllowVendedLogDeliveryForResource() {
        return this.to('AllowVendedLogDeliveryForResource');
    }
    /**
     * Grants permission to apply a guardrail
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toApplyGuardrail() {
        return this.to('ApplyGuardrail');
    }
    /**
     * Grants permission to associate another existing agent as a collaborator to an existing agent
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_AssociateAgentCollaborator.html
     */
    toAssociateAgentCollaborator() {
        return this.to('AssociateAgentCollaborator');
    }
    /**
     * Grants permission to associate a knowledge base with an agent
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_AssociateAgentKnowledgeBase.html
     */
    toAssociateAgentKnowledgeBase() {
        return this.to('AssociateAgentKnowledgeBase');
    }
    /**
     * Grants permission to use 3rd party platform to store knowledge data
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifThirdPartyKnowledgeBaseCredentialsSecretArn()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toAssociateThirdPartyKnowledgeBase() {
        return this.to('AssociateThirdPartyKnowledgeBase');
    }
    /**
     * Grants permission to batch delete list of bedrock evaluation jobs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_BatchDeleteEvaluationJob.html
     */
    toBatchDeleteEvaluationJob() {
        return this.to('BatchDeleteEvaluationJob');
    }
    /**
     * Grants permission to use bearer token
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toCallWithBearerToken() {
        return this.to('CallWithBearerToken');
    }
    /**
     * Grants permission to cancel a build workflow for an automated reasoning policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toCancelAutomatedReasoningPolicyBuildWorkflow() {
        return this.to('CancelAutomatedReasoningPolicyBuildWorkflow');
    }
    /**
     * Grants permission to create a new agent and a test agent alias pointing to the DRAFT agent version
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgent.html
     */
    toCreateAgent() {
        return this.to('CreateAgent');
    }
    /**
     * Grants permission to create a new action group in an existing agent
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html
     */
    toCreateAgentActionGroup() {
        return this.to('CreateAgentActionGroup');
    }
    /**
     * Grants permission to create a new alias for an agent
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentAlias.html
     */
    toCreateAgentAlias() {
        return this.to('CreateAgentAlias');
    }
    /**
     * Grants permission to create a new automated reasoning policy
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifBearerTokenType()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toCreateAutomatedReasoningPolicy() {
        return this.to('CreateAutomatedReasoningPolicy');
    }
    /**
     * Grants permission to create a test case for an automated reasoning policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toCreateAutomatedReasoningPolicyTestCase() {
        return this.to('CreateAutomatedReasoningPolicyTestCase');
    }
    /**
     * Grants permission to create a new automated reasoning policy version
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifBearerTokenType()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toCreateAutomatedReasoningPolicyVersion() {
        return this.to('CreateAutomatedReasoningPolicyVersion');
    }
    /**
     * Grants permission to create a blueprint for custom output from data automation
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_data-automation_CreateBlueprint.html
     */
    toCreateBlueprint() {
        return this.to('CreateBlueprint');
    }
    /**
     * Grants permission to create a new version for an existing blueprint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_data-automation_CreateBlueprintVersion.html
     */
    toCreateBlueprintVersion() {
        return this.to('CreateBlueprintVersion');
    }
    /**
     * Grants permission to create a custom model into Bedrock
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifBearerTokenType()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateCustomModel.html
     */
    toCreateCustomModel() {
        return this.to('CreateCustomModel');
    }
    /**
     * Grants permission to create a custom model deployment for custom model
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifBearerTokenType()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateCustomModelDeployment.html
     */
    toCreateCustomModelDeployment() {
        return this.to('CreateCustomModelDeployment');
    }
    /**
     * Grants permission to create a data automation project
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_data-automation_CreateDataAutomationProject.html
     */
    toCreateDataAutomationProject() {
        return this.to('CreateDataAutomationProject');
    }
    /**
     * Grants permission to create a data source
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateDataSource.html
     */
    toCreateDataSource() {
        return this.to('CreateDataSource');
    }
    /**
     * Grants permission to create a job for evaluation foundation models or custom models
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifBearerTokenType()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateEvaluationJob.html
     */
    toCreateEvaluationJob() {
        return this.to('CreateEvaluationJob');
    }
    /**
     * Grants permission to create a prompt flow
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateFlow.html
     */
    toCreateFlow() {
        return this.to('CreateFlow');
    }
    /**
     * Grants permission to create an alias of a prompt flow
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateFlowAlias.html
     */
    toCreateFlowAlias() {
        return this.to('CreateFlowAlias');
    }
    /**
     * Grants permission to create an immutable version of a prompt flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateFlowVersion.html
     */
    toCreateFlowVersion() {
        return this.to('CreateFlowVersion');
    }
    /**
     * Grants permission to create a new foundation model agreement
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbedrock.html
     */
    toCreateFoundationModelAgreement() {
        return this.to('CreateFoundationModelAgreement');
    }
    /**
     * Grants permission to create a new guardrail
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifBearerTokenType()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toCreateGuardrail() {
        return this.to('CreateGuardrail');
    }
    /**
     * Grants permission to create a new guardrail version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toCreateGuardrailVersion() {
        return this.to('CreateGuardrailVersion');
    }
    /**
     * Grants permission to create inference profiles
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateInferenceProfile.html
     */
    toCreateInferenceProfile() {
        return this.to('CreateInferenceProfile');
    }
    /**
     * Grants permission to create a new invocation in an existing session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_CreateInvocation.html
     */
    toCreateInvocation() {
        return this.to('CreateInvocation');
    }
    /**
     * Grants permission to create a knowledge base
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateKnowledgeBase.html
     */
    toCreateKnowledgeBase() {
        return this.to('CreateKnowledgeBase');
    }
    /**
     * Grants permission to create a marketplace model endpoint
     *
     * Access Level: Write
     */
    toCreateMarketplaceModelEndpoint() {
        return this.to('CreateMarketplaceModelEndpoint');
    }
    /**
     * Grants permission to create a job for copying a custom model across region or across account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifBearerTokenType()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelCopyJob.html
     */
    toCreateModelCopyJob() {
        return this.to('CreateModelCopyJob');
    }
    /**
     * Grants permission to create a job for customizing the model with your custom training data
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifBearerTokenType()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelCustomizationJob.html
     */
    toCreateModelCustomizationJob() {
        return this.to('CreateModelCustomizationJob');
    }
    /**
     * Grants permission to create a job for evaluation foundation models or custom models
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifBearerTokenType()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelEvaluationJob.html
     */
    toCreateModelEvaluationJob() {
        return this.to('CreateModelEvaluationJob');
    }
    /**
     * Grants permission to create a job for importing model into Bedrock
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifBearerTokenType()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelImportJob.html
     */
    toCreateModelImportJob() {
        return this.to('CreateModelImportJob');
    }
    /**
     * Grants permission to create a new model invocation job
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifBearerTokenType()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelInvocationJob.html
     */
    toCreateModelInvocationJob() {
        return this.to('CreateModelInvocationJob');
    }
    /**
     * Grants permission to create a prompt
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreatePrompt.html
     */
    toCreatePrompt() {
        return this.to('CreatePrompt');
    }
    /**
     * Grants permission to create a custom prompt router
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifBearerTokenType()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreatePromptRouter.html
     */
    toCreatePromptRouter() {
        return this.to('CreatePromptRouter');
    }
    /**
     * Grants permission to create a version of a prompt
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreatePromptVersion.html
     */
    toCreatePromptVersion() {
        return this.to('CreatePromptVersion');
    }
    /**
     * Grants permission to create a new provisioned model throughput
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifBearerTokenType()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateProvisionedModelThroughput.html
     */
    toCreateProvisionedModelThroughput() {
        return this.to('CreateProvisionedModelThroughput');
    }
    /**
     * Grants permission to create a new session
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_CreateSession.html
     */
    toCreateSession() {
        return this.to('CreateSession');
    }
    /**
     * Grants permission to delete an Agent that you created earlier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DeleteAgent.html
     */
    toDeleteAgent() {
        return this.to('DeleteAgent');
    }
    /**
     * Grants permission to delete an actionGroup that you created earlier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DeleteAgentActionGroup.html
     */
    toDeleteAgentActionGroup() {
        return this.to('DeleteAgentActionGroup');
    }
    /**
     * Grants permission to delete an AgentAlias that you created earlier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DeleteAgentAlias.html
     */
    toDeleteAgentAlias() {
        return this.to('DeleteAgentAlias');
    }
    /**
     * Grants permission to delete existing memory for an alias
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_DeleteAgentMemory.html
     */
    toDeleteAgentMemory() {
        return this.to('DeleteAgentMemory');
    }
    /**
     * Grants permission to delete an Agent Version that you created earlier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DeleteAgentVersion.html
     */
    toDeleteAgentVersion() {
        return this.to('DeleteAgentVersion');
    }
    /**
     * Grants permission to delete an automated reasoning policy or its version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toDeleteAutomatedReasoningPolicy() {
        return this.to('DeleteAutomatedReasoningPolicy');
    }
    /**
     * Grants permission to delete a build workflow for an automated reasoning policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toDeleteAutomatedReasoningPolicyBuildWorkflow() {
        return this.to('DeleteAutomatedReasoningPolicyBuildWorkflow');
    }
    /**
     * Grants permission to delete a test case for an automated reasoning policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toDeleteAutomatedReasoningPolicyTestCase() {
        return this.to('DeleteAutomatedReasoningPolicyTestCase');
    }
    /**
     * Grants permission to delete a blueprint for data automation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_data-automation_DeleteBlueprint.html
     */
    toDeleteBlueprint() {
        return this.to('DeleteBlueprint');
    }
    /**
     * Grants permission to delete a custom model that you created earlier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_DeleteCustomModel.html
     */
    toDeleteCustomModel() {
        return this.to('DeleteCustomModel');
    }
    /**
     * Grants permission to delete a custom model deployment that you created earlier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_DeleteCustomModelDeployment.html
     */
    toDeleteCustomModelDeployment() {
        return this.to('DeleteCustomModelDeployment');
    }
    /**
     * Grants permission to delete a data automation project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_data-automation_DeleteDataAutomationProject.html
     */
    toDeleteDataAutomationProject() {
        return this.to('DeleteDataAutomationProject');
    }
    /**
     * Grants permission to delete a data source
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DeleteDataSource.html
     */
    toDeleteDataSource() {
        return this.to('DeleteDataSource');
    }
    /**
     * Grants permission to delete a prompt flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DeleteFlow.html
     */
    toDeleteFlow() {
        return this.to('DeleteFlow');
    }
    /**
     * Grants permission to delete an alias of a prompt flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DeleteFlowAlias.html
     */
    toDeleteFlowAlias() {
        return this.to('DeleteFlowAlias');
    }
    /**
     * Grants permission to delete a version of a prompt flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DeleteFlowVersion.html
     */
    toDeleteFlowVersion() {
        return this.to('DeleteFlowVersion');
    }
    /**
     * Grants permission to delete a foundation model agreement that you created earlier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbedrock.html
     */
    toDeleteFoundationModelAgreement() {
        return this.to('DeleteFoundationModelAgreement');
    }
    /**
     * Grants permission to delete a guardrail or its version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toDeleteGuardrail() {
        return this.to('DeleteGuardrail');
    }
    /**
     * Grants permission to delete previously created Bedrock imported model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_DeleteImportedModel.html
     */
    toDeleteImportedModel() {
        return this.to('DeleteImportedModel');
    }
    /**
     * Grants permission to delete inference profiles
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_DeleteInferenceProfile.html
     */
    toDeleteInferenceProfile() {
        return this.to('DeleteInferenceProfile');
    }
    /**
     * Grants permission to delete a knowledge base
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DeleteKnowledgeBase.html
     */
    toDeleteKnowledgeBase() {
        return this.to('DeleteKnowledgeBase');
    }
    /**
     * Grants permission to delete documents from a knowledge base
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DeleteKnowledgeBaseDocuments.html
     */
    toDeleteKnowledgeBaseDocuments() {
        return this.to('DeleteKnowledgeBaseDocuments');
    }
    /**
     * Grants permission to unsubscribe from a bedrock marketplace enabled AWS marketplace model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbedrock.html
     */
    toDeleteMarketplaceModelAgreement() {
        return this.to('DeleteMarketplaceModelAgreement');
    }
    /**
     * Grants permission to delete a marketplace model endpoint
     *
     * Access Level: Write
     */
    toDeleteMarketplaceModelEndpoint() {
        return this.to('DeleteMarketplaceModelEndpoint');
    }
    /**
     * Grants permission to delete an existing Invocation logging configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_DeleteModelInvocationLoggingConfiguration.html
     */
    toDeleteModelInvocationLoggingConfiguration() {
        return this.to('DeleteModelInvocationLoggingConfiguration');
    }
    /**
     * Grants permission to delete a prompt or its version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DeletePrompt.html
     */
    toDeletePrompt() {
        return this.to('DeletePrompt');
    }
    /**
     * Grants permission to delete a custom prompt router
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_DeletePromptRouter.html
     */
    toDeletePromptRouter() {
        return this.to('DeletePromptRouter');
    }
    /**
     * Grants permission to delete a provisioned model throughput that you created earlier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_DeleteProvisionedModelThroughput.html
     */
    toDeleteProvisionedModelThroughput() {
        return this.to('DeleteProvisionedModelThroughput');
    }
    /**
     * Deletes a previously created Bedrock resource policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_DeleteResourcePolicy.html
     */
    toDeleteResourcePolicy() {
        return this.to('DeleteResourcePolicy');
    }
    /**
     * Grants permission to delete a Session that you created earlier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_DeleteSession.html
     */
    toDeleteSession() {
        return this.to('DeleteSession');
    }
    /**
     * Grants permission to deregister a marketplace model endpoint to make it unusable in Bedrock Marketplace
     *
     * Access Level: Write
     */
    toDeregisterMarketplaceModelEndpoint() {
        return this.to('DeregisterMarketplaceModelEndpoint');
    }
    /**
     * Grants permission to detect if the provided content is generated using Amazon Bedrock
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toDetectGeneratedContent() {
        return this.to('DetectGeneratedContent');
    }
    /**
     * Grants permission to diassociate a collaborator that you associated earlier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DisassociateAgentCollaborator.html
     */
    toDisassociateAgentCollaborator() {
        return this.to('DisassociateAgentCollaborator');
    }
    /**
     * Grants permission to disassociate a knowledge base from the agent
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DisassociateAgentKnowledgeBase.html
     */
    toDisassociateAgentKnowledgeBase() {
        return this.to('DisassociateAgentKnowledgeBase');
    }
    /**
     * Grants permission to end a Session that you created earlier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_EndSession.html
     */
    toEndSession() {
        return this.to('EndSession');
    }
    /**
     * Grants permission to retrieve an automated reasoning policy version artifact
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toExportAutomatedReasoningPolicyVersion() {
        return this.to('ExportAutomatedReasoningPolicyVersion');
    }
    /**
     * Grants permission to generate queries associated with user input
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toGenerateQuery() {
        return this.to('GenerateQuery');
    }
    /**
     * Grants permission to retrieve an existing agent
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetAgent.html
     */
    toGetAgent() {
        return this.to('GetAgent');
    }
    /**
     * Grants permission to retrieve an existing action group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetAgentActionGroup.html
     */
    toGetAgentActionGroup() {
        return this.to('GetAgentActionGroup');
    }
    /**
     * Grants permission to retrieve an existing alias
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetAgentAlias.html
     */
    toGetAgentAlias() {
        return this.to('GetAgentAlias');
    }
    /**
     * Grants permission to retrieve an existing collaborator
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetAgentCollaborator.html
     */
    toGetAgentCollaborator() {
        return this.to('GetAgentCollaborator');
    }
    /**
     * Grants permission to describe a knowledge base associated with an agent
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetAgentKnowledgeBase.html
     */
    toGetAgentKnowledgeBase() {
        return this.to('GetAgentKnowledgeBase');
    }
    /**
     * Grants permission to retrieve existing memory for an alias
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_GetAgentMemory.html
     */
    toGetAgentMemory() {
        return this.to('GetAgentMemory');
    }
    /**
     * Grants permission to retrieve an existing version of an agent
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetAgentVersion.html
     */
    toGetAgentVersion() {
        return this.to('GetAgentVersion');
    }
    /**
     * Grants permission to get the properties associated with an asynchronous invocation that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetAsyncInvoke.html
     */
    toGetAsyncInvoke() {
        return this.to('GetAsyncInvoke');
    }
    /**
     * Grants permission to retrieve an automated reasoning policy or its version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toGetAutomatedReasoningPolicy() {
        return this.to('GetAutomatedReasoningPolicy');
    }
    /**
     * Grants permission to retrieve annotations for a build workflow for an automated reasoning policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toGetAutomatedReasoningPolicyAnnotations() {
        return this.to('GetAutomatedReasoningPolicyAnnotations');
    }
    /**
     * Grants permission to retrieve a build workflow for an automated reasoning policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toGetAutomatedReasoningPolicyBuildWorkflow() {
        return this.to('GetAutomatedReasoningPolicyBuildWorkflow');
    }
    /**
     * Grants permission to retrieve assets for a build workflow for an automated reasoning policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toGetAutomatedReasoningPolicyBuildWorkflowResultAssets() {
        return this.to('GetAutomatedReasoningPolicyBuildWorkflowResultAssets');
    }
    /**
     * Grants permission to retrieve the next unreviewed generated scenario for a build workflow for an automated reasoning policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toGetAutomatedReasoningPolicyNextScenario() {
        return this.to('GetAutomatedReasoningPolicyNextScenario');
    }
    /**
     * Grants permission to retrieve a test case for an automated reasoning policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toGetAutomatedReasoningPolicyTestCase() {
        return this.to('GetAutomatedReasoningPolicyTestCase');
    }
    /**
     * Grants permission to retrieve result for a test case for an automated reasoning policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toGetAutomatedReasoningPolicyTestResult() {
        return this.to('GetAutomatedReasoningPolicyTestResult');
    }
    /**
     * Grants permission to retrieve an existing blueprint for data automation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_data-automation_GetBlueprint.html
     */
    toGetBlueprint() {
        return this.to('GetBlueprint');
    }
    /**
     * Grants permission to retrieve blueprint recommendation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toGetBlueprintRecommendation() {
        return this.to('GetBlueprintRecommendation');
    }
    /**
     * Grants permission to get the properties associated with a Bedrock custom model that you have created
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetCustomModel.html
     */
    toGetCustomModel() {
        return this.to('GetCustomModel');
    }
    /**
     * Grants permission to get the properties associated with a custom model deployment. Use this operation to get the status of a custom model deployment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetCustomModelDeployment.html
     */
    toGetCustomModelDeployment() {
        return this.to('GetCustomModelDeployment');
    }
    /**
     * Grants permission to retrieve an existing data automation project
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_data-automation_GetDataAutomationProject.html
     */
    toGetDataAutomationProject() {
        return this.to('GetDataAutomationProject');
    }
    /**
     * Grants permission to retrieve the status of a data automation invocation job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_data-automation-runtime_GetDataAutomationStatus.html
     */
    toGetDataAutomationStatus() {
        return this.to('GetDataAutomationStatus');
    }
    /**
     * Grants permission to retrieve an existing data source
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetDataSource.html
     */
    toGetDataSource() {
        return this.to('GetDataSource');
    }
    /**
     * Grants permission to get the properties associated with a evaluation job. Use this operation to get the status of a evaluation job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetEvaluationJob.html
     */
    toGetEvaluationJob() {
        return this.to('GetEvaluationJob');
    }
    /**
     * Grants permission to retrieve the flow definition for a flow execution
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_GetExecutionFlowSnapshot.html
     */
    toGetExecutionFlowSnapshot() {
        return this.to('GetExecutionFlowSnapshot');
    }
    /**
     * Grants permission to retrieve an existing prompt flow
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html
     */
    toGetFlow() {
        return this.to('GetFlow');
    }
    /**
     * Grants permission to retrieve an existing alias of a prompt flow
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlowAlias.html
     */
    toGetFlowAlias() {
        return this.to('GetFlowAlias');
    }
    /**
     * Grants permission to retrieve an existing execution of a flow alias
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_GetFlowExecution.html
     */
    toGetFlowExecution() {
        return this.to('GetFlowExecution');
    }
    /**
     * Grants permission to retrieve an existing version of a prompt flow
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlowVersion.html
     */
    toGetFlowVersion() {
        return this.to('GetFlowVersion');
    }
    /**
     * Grants permission to get the properties associated with a Bedrock foundation model
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetFoundationModel.html
     */
    toGetFoundationModel() {
        return this.to('GetFoundationModel');
    }
    /**
     * Grants permission to get the availability of a foundation model
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbedrock.html
     */
    toGetFoundationModelAvailability() {
        return this.to('GetFoundationModelAvailability');
    }
    /**
     * Grants permission to retrieve a guardrail or its version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toGetGuardrail() {
        return this.to('GetGuardrail');
    }
    /**
     * Grants permission to get the properties associated with Bedrock imported model
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetImportedModel.html
     */
    toGetImportedModel() {
        return this.to('GetImportedModel');
    }
    /**
     * Grants permission to get the properties associated with an inference profile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetInferenceProfile.html
     */
    toGetInferenceProfile() {
        return this.to('GetInferenceProfile');
    }
    /**
     * Grants permission to retrieve an existing ingestion job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetIngestionJob.html
     */
    toGetIngestionJob() {
        return this.to('GetIngestionJob');
    }
    /**
     * Grants permission to get an invocation step from a session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_GetInvocationStep.html
     */
    toGetInvocationStep() {
        return this.to('GetInvocationStep');
    }
    /**
     * Grants permission to retrieve an existing knowledge base
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetKnowledgeBase.html
     */
    toGetKnowledgeBase() {
        return this.to('GetKnowledgeBase');
    }
    /**
     * Grants permission to get details for documents in a knowledge base
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetKnowledgeBaseDocuments.html
     */
    toGetKnowledgeBaseDocuments() {
        return this.to('GetKnowledgeBaseDocuments');
    }
    /**
     * Grants permission to get the properties of a marketplace model endpoint
     *
     * Access Level: Read
     */
    toGetMarketplaceModelEndpoint() {
        return this.to('GetMarketplaceModelEndpoint');
    }
    /**
     * Grants permission to get the properties associated with a model-copy job. Use this operation to get the status of a model-copy job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetModelCopyJob.html
     */
    toGetModelCopyJob() {
        return this.to('GetModelCopyJob');
    }
    /**
     * Grants permission to get the properties associated with a model-customization job. Use this operation to get the status of a model-customization job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetModelCustomizationJob.html
     */
    toGetModelCustomizationJob() {
        return this.to('GetModelCustomizationJob');
    }
    /**
     * Grants permission to get the properties associated with a model-evaluation job. Use this operation to get the status of a model-evaluation job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetModelEvaluationJob.html
     */
    toGetModelEvaluationJob() {
        return this.to('GetModelEvaluationJob');
    }
    /**
     * Grants permission to get the properties associated with a model import job and is used to get the status of a model import job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetModelImportJob.html
     */
    toGetModelImportJob() {
        return this.to('GetModelImportJob');
    }
    /**
     * Grants permission to retrieve a model invocation job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetModelInvocationJob.html
     */
    toGetModelInvocationJob() {
        return this.to('GetModelInvocationJob');
    }
    /**
     * Grants permission to retrieve an existing Invocation logging configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetModelInvocationLoggingConfiguration.html
     */
    toGetModelInvocationLoggingConfiguration() {
        return this.to('GetModelInvocationLoggingConfiguration');
    }
    /**
     * Grants permission to retrieve an existing prompt or its version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetPrompt.html
     */
    toGetPrompt() {
        return this.to('GetPrompt');
    }
    /**
     * Grants permission to get the properties associated with a prompt router
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetPromptRouter.html
     */
    toGetPromptRouter() {
        return this.to('GetPromptRouter');
    }
    /**
     * Grants permission to retrieve a provisioned model throughput
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetProvisionedModelThroughput.html
     */
    toGetProvisionedModelThroughput() {
        return this.to('GetProvisionedModelThroughput');
    }
    /**
     * Gets the resource policy document for a Bedrock resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetResourePolicy.html
     */
    toGetResourcePolicy() {
        return this.to('GetResourcePolicy');
    }
    /**
     * Grants permission to retrieve an existing session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_GetSession.html
     */
    toGetSession() {
        return this.to('GetSession');
    }
    /**
     * Grants permission to retrieve a use case for model access
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbedrock.html
     */
    toGetUseCaseForModelAccess() {
        return this.to('GetUseCaseForModelAccess');
    }
    /**
     * Grants permission to directly ingest documents into a knowledge base
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_IngestKnowledgeBaseDocuments.html
     */
    toIngestKnowledgeBaseDocuments() {
        return this.to('IngestKnowledgeBaseDocuments');
    }
    /**
     * Grants permission to send user input (text-only) to the alias of an agent for Bedrock
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html
     */
    toInvokeAgent() {
        return this.to('InvokeAgent');
    }
    /**
     * Grants permission to invoke an Automated Reasoning policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toInvokeAutomatedReasoningPolicy() {
        return this.to('InvokeAutomatedReasoningPolicy');
    }
    /**
     * Grants permission to invoke blueprint recommendations asynchronously
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toInvokeBlueprintRecommendationAsync() {
        return this.to('InvokeBlueprintRecommendationAsync');
    }
    /**
     * Grants permission to use the conversational builder which aids in building supported bedrock resources
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/userguide/agents-create-cb.html
     */
    toInvokeBuilder() {
        return this.to('InvokeBuilder');
    }
    /**
     * Grants permission to invoke a Bedrock data automation job
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_data-automation-runtime_InvokeDataAutomationAsync.html
     */
    toInvokeDataAutomationAsync() {
        return this.to('InvokeDataAutomationAsync');
    }
    /**
     * Grants permission to invoke a prompt flow with user input
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeFlow.html
     */
    toInvokeFlow() {
        return this.to('InvokeFlow');
    }
    /**
     * Grants permission to send user input (text-only) to the inline agent for Bedrock
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInlineAgentName()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeInlineAgent.html
     */
    toInvokeInlineAgent() {
        return this.to('InvokeInlineAgent');
    }
    /**
     * Grants permission to invoke the specified Bedrock model to run inference using the input provided in the request body
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInferenceProfileArn()
     * - .ifPromptRouterArn()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifGuardrailIdentifier()
     * - .ifBearerTokenType()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_InvokeModel.html
     */
    toInvokeModel() {
        return this.to('InvokeModel');
    }
    /**
     * Grants permission to invoke the specified Bedrock model to run inference using the input provided in the request body with streaming response
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInferenceProfileArn()
     * - .ifPromptRouterArn()
     * - .ifGuardrailIdentifier()
     * - .ifBearerTokenType()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_InvokeModelWithResponseStream.html
     */
    toInvokeModelWithResponseStream() {
        return this.to('InvokeModelWithResponseStream');
    }
    /**
     * Grants permission to list action groups in an agent
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListAgentActionGroups.html
     */
    toListAgentActionGroups() {
        return this.to('ListAgentActionGroups');
    }
    /**
     * Grants permission to list aliases for an agent
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListAgentAliases.html
     */
    toListAgentAliases() {
        return this.to('ListAgentAliases');
    }
    /**
     * Grants permission to list collaborators for an agent
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListAgentCollaborators.html
     */
    toListAgentCollaborators() {
        return this.to('ListAgentCollaborators');
    }
    /**
     * Grants permission to list knowledge bases associated with an agent
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListAgentKnowledgeBases.html
     */
    toListAgentKnowledgeBases() {
        return this.to('ListAgentKnowledgeBases');
    }
    /**
     * Grants permission to list existing versions of an agent
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListAgentVersions.html
     */
    toListAgentVersions() {
        return this.to('ListAgentVersions');
    }
    /**
     * Grants permission to list existing agents
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListAgents.html
     */
    toListAgents() {
        return this.to('ListAgents');
    }
    /**
     * Grants permission to get a list of asynchronous invocations that you have submitted
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListAsyncInvokes.html
     */
    toListAsyncInvokes() {
        return this.to('ListAsyncInvokes');
    }
    /**
     * Grants permission to list automated reasoning policies or its versions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toListAutomatedReasoningPolicies() {
        return this.to('ListAutomatedReasoningPolicies');
    }
    /**
     * Grants permission to list build workflows for an automated reasoning policy
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toListAutomatedReasoningPolicyBuildWorkflows() {
        return this.to('ListAutomatedReasoningPolicyBuildWorkflows');
    }
    /**
     * Grants permission to list test cases for an automated reasoning policy
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toListAutomatedReasoningPolicyTestCases() {
        return this.to('ListAutomatedReasoningPolicyTestCases');
    }
    /**
     * Grants permission to list test result for an automated reasoning policy
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toListAutomatedReasoningPolicyTestResults() {
        return this.to('ListAutomatedReasoningPolicyTestResults');
    }
    /**
     * Grants permission to list existing blueprints for data automation
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_data-automation_ListBlueprints.html
     */
    toListBlueprints() {
        return this.to('ListBlueprints');
    }
    /**
     * Grants permission to get the list of custom model deployments that you have submitted
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListCustomModelDeployments.html
     */
    toListCustomModelDeployments() {
        return this.to('ListCustomModelDeployments');
    }
    /**
     * Grants permission to get a list of Bedrock custom models that you have created
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListCustomModels.html
     */
    toListCustomModels() {
        return this.to('ListCustomModels');
    }
    /**
     * Grants permission to list existing data automation projects
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_data-automation_ListDataAutomationProjects.html
     */
    toListDataAutomationProjects() {
        return this.to('ListDataAutomationProjects');
    }
    /**
     * Grants permission to list existing data sources in an knowledge base
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListDataSources.html
     */
    toListDataSources() {
        return this.to('ListDataSources');
    }
    /**
     * Grants permission to get the list of evaluation jobs that you have submitted
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListEvaluationJobs.html
     */
    toListEvaluationJobs() {
        return this.to('ListEvaluationJobs');
    }
    /**
     * Grants permission to list existing aliases of a prompt flow
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListFlowAliases.html
     */
    toListFlowAliases() {
        return this.to('ListFlowAliases');
    }
    /**
     * Grants permission to retrieve events for a flow execution
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListFlowExecutionEvents.html
     */
    toListFlowExecutionEvents() {
        return this.to('ListFlowExecutionEvents');
    }
    /**
     * Grants permission to list executions of a flow or a flow alias
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListFlowExecutions.html
     */
    toListFlowExecutions() {
        return this.to('ListFlowExecutions');
    }
    /**
     * Grants permission to list existing versions of a prompt flow
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListFlowVersions.html
     */
    toListFlowVersions() {
        return this.to('ListFlowVersions');
    }
    /**
     * Grants permission to list existing prompt flows
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListFlows.html
     */
    toListFlows() {
        return this.to('ListFlows');
    }
    /**
     * Grants permission to get a list of foundation model agreement offers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbedrock.html
     */
    toListFoundationModelAgreementOffers() {
        return this.to('ListFoundationModelAgreementOffers');
    }
    /**
     * Grants permission to list Bedrock foundation models that you can use
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListFoundationModels.html
     */
    toListFoundationModels() {
        return this.to('ListFoundationModels');
    }
    /**
     * Grants permission to list guardrails or its versions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toListGuardrails() {
        return this.to('ListGuardrails');
    }
    /**
     * Grants permission to get list of Bedrock imported models
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListImportedModels.html
     */
    toListImportedModels() {
        return this.to('ListImportedModels');
    }
    /**
     * Grants permission to list inference profiles that you can use
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListInferenceProfiles.html
     */
    toListInferenceProfiles() {
        return this.to('ListInferenceProfiles');
    }
    /**
     * Grants permission to list ingestion jobs in a data source
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListIngestionJobs.html
     */
    toListIngestionJobs() {
        return this.to('ListIngestionJobs');
    }
    /**
     * Grants permission to get list of invocation step from a session
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListInvocationSteps.html
     */
    toListInvocationSteps() {
        return this.to('ListInvocationSteps');
    }
    /**
     * Grants permission to list invocations in a session
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListInvocations.html
     */
    toListInvocations() {
        return this.to('ListInvocations');
    }
    /**
     * Grants permission to list documents in a knowledge base
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListKnowledgeBaseDocuments.html
     */
    toListKnowledgeBaseDocuments() {
        return this.to('ListKnowledgeBaseDocuments');
    }
    /**
     * Grants permission to list existing knowledge bases
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListKnowledgeBases.html
     */
    toListKnowledgeBases() {
        return this.to('ListKnowledgeBases');
    }
    /**
     * Grants permission to list marketplace model endpoints that you can use
     *
     * Access Level: Read
     */
    toListMarketplaceModelEndpoints() {
        return this.to('ListMarketplaceModelEndpoints');
    }
    /**
     * Grants permission to get the list of model copy jobs that you have submitted
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListModelCopyJobs.html
     */
    toListModelCopyJobs() {
        return this.to('ListModelCopyJobs');
    }
    /**
     * Grants permission to get the list of model customization jobs that you have submitted
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListModelCustomizationJobs.html
     */
    toListModelCustomizationJobs() {
        return this.to('ListModelCustomizationJobs');
    }
    /**
     * Grants permission to get the list of model evaluation jobs that you have submitted
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListModelEvaluationJobs.html
     */
    toListModelEvaluationJobs() {
        return this.to('ListModelEvaluationJobs');
    }
    /**
     * Grants permission to get list of model import jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListModelImportJobs.html
     */
    toListModelImportJobs() {
        return this.to('ListModelImportJobs');
    }
    /**
     * Grants permission to list model invocation jobs that you created earlier
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListModelInvocationJobs.html
     */
    toListModelInvocationJobs() {
        return this.to('ListModelInvocationJobs');
    }
    /**
     * Grants permission to list prompt routers that you can use
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListPromptRouters.html
     */
    toListPromptRouters() {
        return this.to('ListPromptRouters');
    }
    /**
     * Grants permission to list existing prompts
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListPrompts.html
     */
    toListPrompts() {
        return this.to('ListPrompts');
    }
    /**
     * Grants permission to list provisioned model throughputs that you created earlier
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListProvisionedModelThroughputs.html
     */
    toListProvisionedModelThroughputs() {
        return this.to('ListProvisionedModelThroughputs');
    }
    /**
     * Grants permission to list existing sessions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListSessions.html
     */
    toListSessions() {
        return this.to('ListSessions');
    }
    /**
     * Grants permission to list tags for a Bedrock resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to optimize a prompt with user input
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_OptimizePrompt.html
     */
    toOptimizePrompt() {
        return this.to('OptimizePrompt');
    }
    /**
     * Grants permission to prepare an existing agent to receive runtime requests
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareAgent.html
     */
    toPrepareAgent() {
        return this.to('PrepareAgent');
    }
    /**
     * Grants permission to apply the latest changes made to a prompt flow, so that they are reflected at runtime
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareFlow.html
     */
    toPrepareFlow() {
        return this.to('PrepareFlow');
    }
    /**
     * Grants permission to put entitlement to access a foundation model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbedrock.html
     */
    toPutFoundationModelEntitlement() {
        return this.to('PutFoundationModelEntitlement');
    }
    /**
     * Grants permission to put an invocation step into an invocation in session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_PutInvocationStep.html
     */
    toPutInvocationStep() {
        return this.to('PutInvocationStep');
    }
    /**
     * Grants permission to create an existing Invocation logging configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_PutModelInvocationLoggingConfiguration.html
     */
    toPutModelInvocationLoggingConfiguration() {
        return this.to('PutModelInvocationLoggingConfiguration');
    }
    /**
     * Adds a resource policy for a Bedrock resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_PutResourcePolicy.html
     */
    toPutResourcePolicy() {
        return this.to('PutResourcePolicy');
    }
    /**
     * Grants permission to put a use case for model access
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbedrock.html
     */
    toPutUseCaseForModelAccess() {
        return this.to('PutUseCaseForModelAccess');
    }
    /**
     * Grants permission to register a sagemaker endpoint as a marketplace model endpoint
     *
     * Access Level: Write
     */
    toRegisterMarketplaceModelEndpoint() {
        return this.to('RegisterMarketplaceModelEndpoint');
    }
    /**
     * Grants permission to render an existing prompt or its version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toRenderPrompt() {
        return this.to('RenderPrompt');
    }
    /**
     * Grants permission to rank documents based on user input
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toRerank() {
        return this.to('Rerank');
    }
    /**
     * Grants permission to retrieve ingested data from a knowledge base
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toRetrieve() {
        return this.to('Retrieve');
    }
    /**
     * Grants permission to send user input to perform retrieval and generation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toRetrieveAndGenerate() {
        return this.to('RetrieveAndGenerate');
    }
    /**
     * Grants permission to start a build workflow for an automated reasoning policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toStartAutomatedReasoningPolicyBuildWorkflow() {
        return this.to('StartAutomatedReasoningPolicyBuildWorkflow');
    }
    /**
     * Grants permission to start a test workflow for an automated reasoning policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toStartAutomatedReasoningPolicyTestWorkflow() {
        return this.to('StartAutomatedReasoningPolicyTestWorkflow');
    }
    /**
     * Grants permission to start an execution of a flow alias
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_StartFlowExecution.html
     */
    toStartFlowExecution() {
        return this.to('StartFlowExecution');
    }
    /**
     * Grants permission to start an ingestion job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_StartIngestionJob.html
     */
    toStartIngestionJob() {
        return this.to('StartIngestionJob');
    }
    /**
     * Grants permission to stop a evaluation job while in progress
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_StopEvaluationJob.html
     */
    toStopEvaluationJob() {
        return this.to('StopEvaluationJob');
    }
    /**
     * Grants permission to stop an execution of a flow alias
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_StopFlowExecution.html
     */
    toStopFlowExecution() {
        return this.to('StopFlowExecution');
    }
    /**
     * Grants permission to stop an ingestion job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_StopIngestionJob.html
     */
    toStopIngestionJob() {
        return this.to('StopIngestionJob');
    }
    /**
     * Grants permission to stop a Bedrock model customization job while in progress
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_StopModelCustomizationJob.html
     */
    toStopModelCustomizationJob() {
        return this.to('StopModelCustomizationJob');
    }
    /**
     * Grants permission to stop a model invocation job that you started earlier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_StopModelInvocationJob.html
     */
    toStopModelInvocationJob() {
        return this.to('StopModelInvocationJob');
    }
    /**
     * Grants permission to Tag a Bedrock resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifBearerTokenType()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to Untag a Bedrock resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifBearerTokenType()
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update an existing agent
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgent.html
     */
    toUpdateAgent() {
        return this.to('UpdateAgent');
    }
    /**
     * Grants permission to update an existing action group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html
     */
    toUpdateAgentActionGroup() {
        return this.to('UpdateAgentActionGroup');
    }
    /**
     * Grants permission to update an existing alias
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentAlias.html
     */
    toUpdateAgentAlias() {
        return this.to('UpdateAgentAlias');
    }
    /**
     * Grants permission to update an existing collaborator
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentCollaborator.html
     */
    toUpdateAgentCollaborator() {
        return this.to('UpdateAgentCollaborator');
    }
    /**
     * Grants permission to update a knowledge base associated with an agent
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentKnowledgeBase.html
     */
    toUpdateAgentKnowledgeBase() {
        return this.to('UpdateAgentKnowledgeBase');
    }
    /**
     * Grants permission to update an automated reasoning policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toUpdateAutomatedReasoningPolicy() {
        return this.to('UpdateAutomatedReasoningPolicy');
    }
    /**
     * Grants permission to update annotations for a build workflow for an automated reasoning policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toUpdateAutomatedReasoningPolicyAnnotations() {
        return this.to('UpdateAutomatedReasoningPolicyAnnotations');
    }
    /**
     * Grants permission to update a test case for automated reasoning policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toUpdateAutomatedReasoningPolicyTestCase() {
        return this.to('UpdateAutomatedReasoningPolicyTestCase');
    }
    /**
     * Grants permission to update a blueprint for data automation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_data-automation_UpdateBlueprint.html
     */
    toUpdateBlueprint() {
        return this.to('UpdateBlueprint');
    }
    /**
     * Grants permission to update a data automation project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_data-automation_UpdateDataAutomationProject.html
     */
    toUpdateDataAutomationProject() {
        return this.to('UpdateDataAutomationProject');
    }
    /**
     * Grants permission to update a data source
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateDataSource.html
     */
    toUpdateDataSource() {
        return this.to('UpdateDataSource');
    }
    /**
     * Grants permission to update a prompt flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateFlow.html
     */
    toUpdateFlow() {
        return this.to('UpdateFlow');
    }
    /**
     * Grants permission to update the configuration of an alias of a prompt flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateFlowAlias.html
     */
    toUpdateFlowAlias() {
        return this.to('UpdateFlowAlias');
    }
    /**
     * Grants permission to update a guardrail
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     */
    toUpdateGuardrail() {
        return this.to('UpdateGuardrail');
    }
    /**
     * Grants permission to update a knowledge base
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateKnowledgeBase.html
     */
    toUpdateKnowledgeBase() {
        return this.to('UpdateKnowledgeBase');
    }
    /**
     * Grants permission to update a marketplace model endpoint
     *
     * Access Level: Write
     */
    toUpdateMarketplaceModelEndpoint() {
        return this.to('UpdateMarketplaceModelEndpoint');
    }
    /**
     * Grants permission to update a prompt
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdatePrompt.html
     */
    toUpdatePrompt() {
        return this.to('UpdatePrompt');
    }
    /**
     * Grants permission to update a provisioned model throughput that you created earlier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_UpdateProvisionedModelThroughput.html
     */
    toUpdateProvisionedModelThroughput() {
        return this.to('UpdateProvisionedModelThroughput');
    }
    /**
     * Grants permission to update an existing session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_UpdateSession.html
     */
    toUpdateSession() {
        return this.to('UpdateSession');
    }
    /**
     * Grants permission to validate prompt flow definitions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ValidateFlowDefinition.html
     */
    toValidateFlowDefinition() {
        return this.to('ValidateFlowDefinition');
    }
    /**
     * Adds a resource of type foundation-model to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onFoundationModel(resourceId, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}::foundation-model/${resourceId}`);
    }
    /**
     * Adds a resource of type async-invoke to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAsyncInvoke(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:async-invoke/${resourceId}`);
    }
    /**
     * Adds a resource of type inference-profile to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onInferenceProfile(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:inference-profile/${resourceId}`);
    }
    /**
     * Adds a resource of type default-prompt-router to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDefaultPromptRouter(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:default-prompt-router/${resourceId}`);
    }
    /**
     * Adds a resource of type prompt-router to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onPromptRouter(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:prompt-router/${resourceId}`);
    }
    /**
     * Adds a resource of type application-inference-profile to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApplicationInferenceProfile(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:application-inference-profile/${resourceId}`);
    }
    /**
     * Adds a resource of type custom-model to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCustomModel(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:custom-model/${resourceId}`);
    }
    /**
     * Adds a resource of type provisioned-model to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onProvisionedModel(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:provisioned-model/${resourceId}`);
    }
    /**
     * Adds a resource of type model-customization-job to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onModelCustomizationJob(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:model-customization-job/${resourceId}`);
    }
    /**
     * Adds a resource of type agent to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param agentId - Identifier for the agentId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAgent(agentId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:agent/${agentId}`);
    }
    /**
     * Adds a resource of type agent-alias to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param agentId - Identifier for the agentId.
     * @param agentAliasId - Identifier for the agentAliasId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAgentAlias(agentId, agentAliasId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:agent-alias/${agentId}/${agentAliasId}`);
    }
    /**
     * Adds a resource of type knowledge-base to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param knowledgeBaseId - Identifier for the knowledgeBaseId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onKnowledgeBase(knowledgeBaseId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:knowledge-base/${knowledgeBaseId}`);
    }
    /**
     * Adds a resource of type model-evaluation-job to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onModelEvaluationJob(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:model-evaluation-job/${resourceId}`);
    }
    /**
     * Adds a resource of type evaluation-job to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEvaluationJob(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:evaluation-job/${resourceId}`);
    }
    /**
     * Adds a resource of type model-invocation-job to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param jobIdentifier - Identifier for the jobIdentifier.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onModelInvocationJob(jobIdentifier, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:model-invocation-job/${jobIdentifier}`);
    }
    /**
     * Adds a resource of type guardrail to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param guardrailId - Identifier for the guardrailId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onGuardrail(guardrailId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:guardrail/${guardrailId}`);
    }
    /**
     * Adds a resource of type guardrail-profile to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/userguide/guardrail-profiles-permissions.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onGuardrailProfile(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:guardrail-profile/${resourceId}`);
    }
    /**
     * Adds a resource of type automated-reasoning-policy to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param automatedReasoningPolicyId - Identifier for the automatedReasoningPolicyId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAutomatedReasoningPolicy(automatedReasoningPolicyId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:automated-reasoning-policy/${automatedReasoningPolicyId}`);
    }
    /**
     * Adds a resource of type automated-reasoning-policy-version to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param automatedReasoningPolicyId - Identifier for the automatedReasoningPolicyId.
     * @param automatedReasoningPolicyVersion - Identifier for the automatedReasoningPolicyVersion.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAutomatedReasoningPolicyVersion(automatedReasoningPolicyId, automatedReasoningPolicyVersion, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:automated-reasoning-policy/${automatedReasoningPolicyId}:${automatedReasoningPolicyVersion}`);
    }
    /**
     * Adds a resource of type flow to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_FlowSummary.html
     *
     * @param flowId - Identifier for the flowId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onFlow(flowId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:flow/${flowId}`);
    }
    /**
     * Adds a resource of type flow-alias to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_FlowAliasSummary.html
     *
     * @param flowId - Identifier for the flowId.
     * @param flowAliasId - Identifier for the flowAliasId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onFlowAlias(flowId, flowAliasId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:flow/${flowId}/alias/${flowAliasId}`);
    }
    /**
     * Adds a resource of type flow-execution to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_FlowExecutionSummary.html
     *
     * @param flowId - Identifier for the flowId.
     * @param flowAliasId - Identifier for the flowAliasId.
     * @param flowExecutionId - Identifier for the flowExecutionId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onFlowExecution(flowId, flowAliasId, flowExecutionId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:flow/${flowId}/alias/${flowAliasId}/execution/${flowExecutionId}`);
    }
    /**
     * Adds a resource of type model-copy-job to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onModelCopyJob(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:model-copy-job/${resourceId}`);
    }
    /**
     * Adds a resource of type prompt to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptSummary.html
     *
     * @param promptId - Identifier for the promptId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPrompt(promptId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:prompt/${promptId}`);
    }
    /**
     * Adds a resource of type prompt-version to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptSummary.html
     *
     * @param promptId - Identifier for the promptId.
     * @param promptVersion - Identifier for the promptVersion.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPromptVersion(promptId, promptVersion, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:prompt/${promptId}:${promptVersion}`);
    }
    /**
     * Adds a resource of type model-import-job to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onModelImportJob(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:model-import-job/${resourceId}`);
    }
    /**
     * Adds a resource of type imported-model to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onImportedModel(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:imported-model/${resourceId}`);
    }
    /**
     * Adds a resource of type bedrock-marketplace-model-endpoint to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onBedrockMarketplaceModelEndpoint(account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:marketplace/model-endpoint/all-access`);
    }
    /**
     * Adds a resource of type data-automation-project to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param projectId - Identifier for the projectId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDataAutomationProject(projectId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:data-automation-project/${projectId}`);
    }
    /**
     * Adds a resource of type blueprint to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param blueprintId - Identifier for the blueprintId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onBlueprint(blueprintId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:blueprint/${blueprintId}`);
    }
    /**
     * Adds a resource of type data-automation-invocation-job to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDataAutomationInvocationJob(jobId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:data-automation-invocation/${jobId}`);
    }
    /**
     * Adds a resource of type data-automation-profile to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param profileId - Identifier for the profileId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDataAutomationProfile(profileId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:data-automation-profile/${profileId}`);
    }
    /**
     * Adds a resource of type session to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param sessionId - Identifier for the sessionId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSession(sessionId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:session/${sessionId}`);
    }
    /**
     * Adds a resource of type custom-model-deployment to the statement
     *
     * https://docs.aws.amazon.com/bedrock/latest/APIReference/welcome.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCustomModelDeployment(resourceId, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:bedrock:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:custom-model/${resourceId}`);
    }
    /**
     * Filters access by creating requests based on the allowed set of values for each of the mandatory tags
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-globally-available
     *
     * Applies to actions:
     * - .toCreateAgent()
     * - .toCreateAgentActionGroup()
     * - .toCreateAgentAlias()
     * - .toCreateAutomatedReasoningPolicy()
     * - .toCreateAutomatedReasoningPolicyVersion()
     * - .toCreateBlueprint()
     * - .toCreateCustomModel()
     * - .toCreateCustomModelDeployment()
     * - .toCreateDataAutomationProject()
     * - .toCreateEvaluationJob()
     * - .toCreateFlow()
     * - .toCreateFlowAlias()
     * - .toCreateGuardrail()
     * - .toCreateInferenceProfile()
     * - .toCreateKnowledgeBase()
     * - .toCreateModelCopyJob()
     * - .toCreateModelCustomizationJob()
     * - .toCreateModelEvaluationJob()
     * - .toCreateModelImportJob()
     * - .toCreateModelInvocationJob()
     * - .toCreatePrompt()
     * - .toCreatePromptRouter()
     * - .toCreatePromptVersion()
     * - .toCreateProvisionedModelThroughput()
     * - .toCreateSession()
     * - .toInvokeDataAutomationAsync()
     * - .toInvokeModel()
     * - .toPutResourcePolicy()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey, value, operator) {
        return this.if(`aws:RequestTag/${tagKey}`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by having actions based on the tag value associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-globally-available
     *
     * Applies to resource types:
     * - async-invoke
     * - application-inference-profile
     * - custom-model
     * - provisioned-model
     * - model-customization-job
     * - agent
     * - agent-alias
     * - knowledge-base
     * - model-evaluation-job
     * - evaluation-job
     * - model-invocation-job
     * - guardrail
     * - automated-reasoning-policy
     * - automated-reasoning-policy-version
     * - flow
     * - flow-alias
     * - model-copy-job
     * - prompt
     * - prompt-version
     * - model-import-job
     * - imported-model
     * - data-automation-project
     * - blueprint
     * - data-automation-invocation-job
     * - session
     * - custom-model-deployment
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey, value, operator) {
        return this.if(`aws:ResourceTag/${tagKey}`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by creating requests based on the presence of mandatory tags in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-globally-available
     *
     * Applies to actions:
     * - .toCreateAgent()
     * - .toCreateAgentActionGroup()
     * - .toCreateAgentAlias()
     * - .toCreateAutomatedReasoningPolicy()
     * - .toCreateAutomatedReasoningPolicyVersion()
     * - .toCreateBlueprint()
     * - .toCreateCustomModel()
     * - .toCreateCustomModelDeployment()
     * - .toCreateDataAutomationProject()
     * - .toCreateEvaluationJob()
     * - .toCreateFlow()
     * - .toCreateFlowAlias()
     * - .toCreateGuardrail()
     * - .toCreateInferenceProfile()
     * - .toCreateKnowledgeBase()
     * - .toCreateModelCopyJob()
     * - .toCreateModelCustomizationJob()
     * - .toCreateModelEvaluationJob()
     * - .toCreateModelImportJob()
     * - .toCreateModelInvocationJob()
     * - .toCreatePrompt()
     * - .toCreatePromptRouter()
     * - .toCreatePromptVersion()
     * - .toCreateProvisionedModelThroughput()
     * - .toCreateSession()
     * - .toInvokeDataAutomationAsync()
     * - .toInvokeModel()
     * - .toPutResourcePolicy()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value, operator) {
        return this.if(`aws:TagKeys`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by the Short-term or Long-term bearer tokens
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbedrock.html#amazonbedrock-policy-keys
     *
     * Applies to actions:
     * - .toCreateAutomatedReasoningPolicy()
     * - .toCreateAutomatedReasoningPolicyVersion()
     * - .toCreateCustomModel()
     * - .toCreateCustomModelDeployment()
     * - .toCreateEvaluationJob()
     * - .toCreateGuardrail()
     * - .toCreateModelCopyJob()
     * - .toCreateModelCustomizationJob()
     * - .toCreateModelEvaluationJob()
     * - .toCreateModelImportJob()
     * - .toCreateModelInvocationJob()
     * - .toCreatePromptRouter()
     * - .toCreateProvisionedModelThroughput()
     * - .toInvokeModel()
     * - .toInvokeModelWithResponseStream()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifBearerTokenType(value, operator) {
        return this.if(`BearerTokenType`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by the GuardrailIdentifier containing the GuardrailArn or the GuardrailArn:NumericVersion
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbedrock.html#amazonbedrock-policy-keys
     *
     * Applies to actions:
     * - .toInvokeModel()
     * - .toInvokeModelWithResponseStream()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifGuardrailIdentifier(value, operator) {
        return this.if(`GuardrailIdentifier`, value, operator ?? 'ArnLike');
    }
    /**
     * Filters access by the specified inference profile
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-globally-available
     *
     * Applies to actions:
     * - .toInvokeModel()
     * - .toInvokeModelWithResponseStream()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifInferenceProfileArn(value, operator) {
        return this.if(`InferenceProfileArn`, value, operator ?? 'ArnLike');
    }
    /**
     * Filters access by the Inline Agent Names, this will be used in InvokeInlineAgent API names
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbedrock.html#amazonbedrock-policy-keys
     *
     * Applies to actions:
     * - .toInvokeInlineAgent()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifInlineAgentName(value, operator) {
        return this.if(`InlineAgentName`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by the specified prompt router
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-globally-available
     *
     * Applies to actions:
     * - .toInvokeModel()
     * - .toInvokeModelWithResponseStream()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifPromptRouterArn(value, operator) {
        return this.if(`PromptRouterArn`, value, operator ?? 'ArnLike');
    }
    /**
     * Filters access by the secretArn containing the credentials of the third party platform
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-globally-available
     *
     * Applies to actions:
     * - .toAssociateThirdPartyKnowledgeBase()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifThirdPartyKnowledgeBaseCredentialsSecretArn(value, operator) {
        return this.if(`ThirdPartyKnowledgeBaseCredentialsSecretArn`, value, operator ?? 'ArnLike');
    }
    /**
     * Statement provider for service [bedrock](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbedrock.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'bedrock';
        this.accessLevelList = {
            'Permissions management': [
                'AllowVendedLogDeliveryForResource'
            ],
            Read: [
                'ApplyGuardrail',
                'CallWithBearerToken',
                'DetectGeneratedContent',
                'ExportAutomatedReasoningPolicyVersion',
                'GenerateQuery',
                'GetAgent',
                'GetAgentActionGroup',
                'GetAgentAlias',
                'GetAgentCollaborator',
                'GetAgentKnowledgeBase',
                'GetAgentMemory',
                'GetAgentVersion',
                'GetAsyncInvoke',
                'GetAutomatedReasoningPolicy',
                'GetAutomatedReasoningPolicyAnnotations',
                'GetAutomatedReasoningPolicyBuildWorkflow',
                'GetAutomatedReasoningPolicyBuildWorkflowResultAssets',
                'GetAutomatedReasoningPolicyNextScenario',
                'GetAutomatedReasoningPolicyTestCase',
                'GetAutomatedReasoningPolicyTestResult',
                'GetBlueprint',
                'GetBlueprintRecommendation',
                'GetCustomModel',
                'GetCustomModelDeployment',
                'GetDataAutomationProject',
                'GetDataAutomationStatus',
                'GetDataSource',
                'GetEvaluationJob',
                'GetExecutionFlowSnapshot',
                'GetFlow',
                'GetFlowAlias',
                'GetFlowExecution',
                'GetFlowVersion',
                'GetFoundationModel',
                'GetFoundationModelAvailability',
                'GetGuardrail',
                'GetImportedModel',
                'GetInferenceProfile',
                'GetIngestionJob',
                'GetInvocationStep',
                'GetKnowledgeBase',
                'GetKnowledgeBaseDocuments',
                'GetMarketplaceModelEndpoint',
                'GetModelCopyJob',
                'GetModelCustomizationJob',
                'GetModelEvaluationJob',
                'GetModelImportJob',
                'GetModelInvocationJob',
                'GetModelInvocationLoggingConfiguration',
                'GetPrompt',
                'GetPromptRouter',
                'GetProvisionedModelThroughput',
                'GetResourcePolicy',
                'GetSession',
                'GetUseCaseForModelAccess',
                'InvokeAgent',
                'InvokeAutomatedReasoningPolicy',
                'InvokeFlow',
                'InvokeInlineAgent',
                'InvokeModel',
                'InvokeModelWithResponseStream',
                'ListMarketplaceModelEndpoints',
                'ListTagsForResource',
                'OptimizePrompt',
                'RenderPrompt',
                'Retrieve',
                'ValidateFlowDefinition'
            ],
            Write: [
                'AssociateAgentCollaborator',
                'AssociateAgentKnowledgeBase',
                'AssociateThirdPartyKnowledgeBase',
                'BatchDeleteEvaluationJob',
                'CancelAutomatedReasoningPolicyBuildWorkflow',
                'CreateAgent',
                'CreateAgentActionGroup',
                'CreateAgentAlias',
                'CreateAutomatedReasoningPolicy',
                'CreateAutomatedReasoningPolicyTestCase',
                'CreateAutomatedReasoningPolicyVersion',
                'CreateBlueprint',
                'CreateBlueprintVersion',
                'CreateCustomModel',
                'CreateCustomModelDeployment',
                'CreateDataAutomationProject',
                'CreateDataSource',
                'CreateEvaluationJob',
                'CreateFlow',
                'CreateFlowAlias',
                'CreateFlowVersion',
                'CreateFoundationModelAgreement',
                'CreateGuardrail',
                'CreateGuardrailVersion',
                'CreateInferenceProfile',
                'CreateInvocation',
                'CreateKnowledgeBase',
                'CreateMarketplaceModelEndpoint',
                'CreateModelCopyJob',
                'CreateModelCustomizationJob',
                'CreateModelEvaluationJob',
                'CreateModelImportJob',
                'CreateModelInvocationJob',
                'CreatePrompt',
                'CreatePromptRouter',
                'CreatePromptVersion',
                'CreateProvisionedModelThroughput',
                'CreateSession',
                'DeleteAgent',
                'DeleteAgentActionGroup',
                'DeleteAgentAlias',
                'DeleteAgentMemory',
                'DeleteAgentVersion',
                'DeleteAutomatedReasoningPolicy',
                'DeleteAutomatedReasoningPolicyBuildWorkflow',
                'DeleteAutomatedReasoningPolicyTestCase',
                'DeleteBlueprint',
                'DeleteCustomModel',
                'DeleteCustomModelDeployment',
                'DeleteDataAutomationProject',
                'DeleteDataSource',
                'DeleteFlow',
                'DeleteFlowAlias',
                'DeleteFlowVersion',
                'DeleteFoundationModelAgreement',
                'DeleteGuardrail',
                'DeleteImportedModel',
                'DeleteInferenceProfile',
                'DeleteKnowledgeBase',
                'DeleteKnowledgeBaseDocuments',
                'DeleteMarketplaceModelAgreement',
                'DeleteMarketplaceModelEndpoint',
                'DeleteModelInvocationLoggingConfiguration',
                'DeletePrompt',
                'DeletePromptRouter',
                'DeleteProvisionedModelThroughput',
                'DeleteResourcePolicy',
                'DeleteSession',
                'DeregisterMarketplaceModelEndpoint',
                'DisassociateAgentCollaborator',
                'DisassociateAgentKnowledgeBase',
                'EndSession',
                'IngestKnowledgeBaseDocuments',
                'InvokeBlueprintRecommendationAsync',
                'InvokeBuilder',
                'InvokeDataAutomationAsync',
                'PrepareAgent',
                'PrepareFlow',
                'PutFoundationModelEntitlement',
                'PutInvocationStep',
                'PutModelInvocationLoggingConfiguration',
                'PutResourcePolicy',
                'PutUseCaseForModelAccess',
                'RegisterMarketplaceModelEndpoint',
                'Rerank',
                'RetrieveAndGenerate',
                'StartAutomatedReasoningPolicyBuildWorkflow',
                'StartAutomatedReasoningPolicyTestWorkflow',
                'StartFlowExecution',
                'StartIngestionJob',
                'StopEvaluationJob',
                'StopFlowExecution',
                'StopIngestionJob',
                'StopModelCustomizationJob',
                'StopModelInvocationJob',
                'UpdateAgent',
                'UpdateAgentActionGroup',
                'UpdateAgentAlias',
                'UpdateAgentCollaborator',
                'UpdateAgentKnowledgeBase',
                'UpdateAutomatedReasoningPolicy',
                'UpdateAutomatedReasoningPolicyAnnotations',
                'UpdateAutomatedReasoningPolicyTestCase',
                'UpdateBlueprint',
                'UpdateDataAutomationProject',
                'UpdateDataSource',
                'UpdateFlow',
                'UpdateFlowAlias',
                'UpdateGuardrail',
                'UpdateKnowledgeBase',
                'UpdateMarketplaceModelEndpoint',
                'UpdatePrompt',
                'UpdateProvisionedModelThroughput',
                'UpdateSession'
            ],
            List: [
                'ListAgentActionGroups',
                'ListAgentAliases',
                'ListAgentCollaborators',
                'ListAgentKnowledgeBases',
                'ListAgentVersions',
                'ListAgents',
                'ListAsyncInvokes',
                'ListAutomatedReasoningPolicies',
                'ListAutomatedReasoningPolicyBuildWorkflows',
                'ListAutomatedReasoningPolicyTestCases',
                'ListAutomatedReasoningPolicyTestResults',
                'ListBlueprints',
                'ListCustomModelDeployments',
                'ListCustomModels',
                'ListDataAutomationProjects',
                'ListDataSources',
                'ListEvaluationJobs',
                'ListFlowAliases',
                'ListFlowExecutionEvents',
                'ListFlowExecutions',
                'ListFlowVersions',
                'ListFlows',
                'ListFoundationModelAgreementOffers',
                'ListFoundationModels',
                'ListGuardrails',
                'ListImportedModels',
                'ListInferenceProfiles',
                'ListIngestionJobs',
                'ListInvocationSteps',
                'ListInvocations',
                'ListKnowledgeBaseDocuments',
                'ListKnowledgeBases',
                'ListModelCopyJobs',
                'ListModelCustomizationJobs',
                'ListModelEvaluationJobs',
                'ListModelImportJobs',
                'ListModelInvocationJobs',
                'ListPromptRouters',
                'ListPrompts',
                'ListProvisionedModelThroughputs',
                'ListSessions'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
}
exports.Bedrock = Bedrock;
//# sourceMappingURL=data:application/json;base64,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