import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [bedrock-agentcore](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbedrockagentcore.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class BedrockAgentcore extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to configure vended telemetry for a resource
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toAllowVendedLogDeliveryForResource(): this;
    /**
     * Grants permission to connect to a browser automation stream
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toConnectBrowserAutomationStream(): this;
    /**
     * Grants permission to connect to a browser live view stream
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toConnectBrowserLiveViewStream(): this;
    /**
     * Grants permission to create a new agent runtime
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toCreateAgentRuntime(): this;
    /**
     * Grants permission to create a new agent runtime endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toCreateAgentRuntimeEndpoint(): this;
    /**
     * Grants permission to create a new API Key Credential Provider
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_CreateApiKeyCredentialProvider.html
     */
    toCreateApiKeyCredentialProvider(): this;
    /**
     * Grants permission to create a new custom browser
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toCreateBrowser(): this;
    /**
     * Grants permission to create a new custom code interpreter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toCreateCodeInterpreter(): this;
    /**
     * Grants permission to create an Event
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifSessionId()
     * - .ifActorId()
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_CreateEvent.html
     */
    toCreateEvent(): this;
    /**
     * Grants permission to create a new gateway
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_CreateGateway.html
     */
    toCreateGateway(): this;
    /**
     * Grants permission to create a new target in an existing gateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_CreateGatewayTarget.html
     */
    toCreateGatewayTarget(): this;
    /**
     * Grants permission to create a Memory resource
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_CreateMemory.html
     */
    toCreateMemory(): this;
    /**
     * Grants permission to create a new Credential Provider to access external resources with OAuth2 protocol
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_CreateOauth2CredentialProvider.html
     */
    toCreateOauth2CredentialProvider(): this;
    /**
     * Grants permission to create a new Workload Identity
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_CreateWorkloadIdentity.html
     */
    toCreateWorkloadIdentity(): this;
    /**
     * Grants permission to delete an agent runtime
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toDeleteAgentRuntime(): this;
    /**
     * Grants permission to delete an agent runtime endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toDeleteAgentRuntimeEndpoint(): this;
    /**
     * Grants permission to delete a registered API Key Credential Provider
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_DeleteApiKeyCredentialProvider.html
     */
    toDeleteApiKeyCredentialProvider(): this;
    /**
     * Grants permission to delete a custom browser
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toDeleteBrowser(): this;
    /**
     * Grants permission to delete a custom code interpreter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toDeleteCodeInterpreter(): this;
    /**
     * Grants permission to delete an Event
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifSessionId()
     * - .ifActorId()
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_DeleteEvent.html
     */
    toDeleteEvent(): this;
    /**
     * Grants permission to delete an existing gateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_DeleteGateway.html
     */
    toDeleteGateway(): this;
    /**
     * Grants permission to delete an existing gateway target
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_DeleteGatewayTarget.html
     */
    toDeleteGatewayTarget(): this;
    /**
     * Grants permission to delete a Memory resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_DeleteMemory.html
     */
    toDeleteMemory(): this;
    /**
     * Grants permission to delete a Memory Record
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_DeleteMemoryRecord.html
     */
    toDeleteMemoryRecord(): this;
    /**
     * Grants permission to delete a registered OAuth2 Credential Provider
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_DeleteOauth2CredentialProvider.html
     */
    toDeleteOauth2CredentialProvider(): this;
    /**
     * Grants permission to delete a registered Workload Identity
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_DeleteWorkloadIdentity.html
     */
    toDeleteWorkloadIdentity(): this;
    /**
     * Grants permission to get details of an agent runtime
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toGetAgentRuntime(): this;
    /**
     * Grants permission to get details of an agent runtime endpoint
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toGetAgentRuntimeEndpoint(): this;
    /**
     * Grants permission to fetch a registered API Key Credential Provider by its name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_GetApiKeyCredentialProvider.html
     */
    toGetApiKeyCredentialProvider(): this;
    /**
     * Grants permission to get details of a browser
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toGetBrowser(): this;
    /**
     * Grants permission to get details of a browser session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toGetBrowserSession(): this;
    /**
     * Grants permission to get details of a code interpreter
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toGetCodeInterpreter(): this;
    /**
     * Grants permission to get details of a code interpreter session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toGetCodeInterpreterSession(): this;
    /**
     * Grants permission to fetch an Event
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifSessionId()
     * - .ifActorId()
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_GetEvent.html
     */
    toGetEvent(): this;
    /**
     * Grants permission to retrieve an existing gateway
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_GetGateway.html
     */
    toGetGateway(): this;
    /**
     * Grants permission to retrieve an existing gateway target
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_GetGatewayTarget.html
     */
    toGetGatewayTarget(): this;
    /**
     * Grants permission to fetch details for a Memory resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_GetMemory.html
     */
    toGetMemory(): this;
    /**
     * Grants permission to fetch a Memory Record
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_GetMemoryRecord.html
     */
    toGetMemoryRecord(): this;
    /**
     * Grants permission to fetch a registered OAuth2 Credential Provider by its name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_GetOauth2CredentialProvider.html
     */
    toGetOauth2CredentialProvider(): this;
    /**
     * Grants permission to retrieve an API Key associated with an Api Key Credential Provider
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_GetResourceApiKey.html
     */
    toGetResourceApiKey(): this;
    /**
     * Grants permission to retrieve access token with OAuth2 2LO or 3LO flow to access external resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_GetResourceOauth2Token.html
     */
    toGetResourceOauth2Token(): this;
    /**
     * Grants permission to fetch the current configuration of the TokenVault, including encryption settings
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_GetTokenVault.html
     */
    toGetTokenVault(): this;
    /**
     * Grants permission to retrieve an Workload access token for agentic workloads not acting on behalf of a user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_GetWorkloadAccessToken.html
     */
    toGetWorkloadAccessToken(): this;
    /**
     * Grants permission to retrieve an Workload access token for agentic workloads acting on behalf of user with JWT token
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_GetWorkloadAccessTokenForJWT.html
     */
    toGetWorkloadAccessTokenForJWT(): this;
    /**
     * Grants permission to retrieve an Workload access token for agentic workloads acting on behalf of user with User Id
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_GetWorkloadAccessTokenForUserId.html
     */
    toGetWorkloadAccessTokenForUserId(): this;
    /**
     * Grants permission to fetch details for a specific Workload identity, including its name and allowed OAuth2 return URLs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_GetWorkloadIdentity.html
     */
    toGetWorkloadIdentity(): this;
    /**
     * Grants permission to invoke an agent runtime endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toInvokeAgentRuntime(): this;
    /**
     * Grants permission to invoke a code interpreter session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toInvokeCodeInterpreter(): this;
    /**
     * Grants permission to list Actors
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_ListActors.html
     */
    toListActors(): this;
    /**
     * Grants permission to list agent runtime endpoints
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toListAgentRuntimeEndpoints(): this;
    /**
     * Grants permission to list agent runtime versions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toListAgentRuntimeVersions(): this;
    /**
     * Grants permission to list agent runtimes
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toListAgentRuntimes(): this;
    /**
     * Grants permission to list all API Key Credential Providers in the Token Vault
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_ListApiKeyCredentialProviders.html
     */
    toListApiKeyCredentialProviders(): this;
    /**
     * Grants permission to list browser sessions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toListBrowserSessions(): this;
    /**
     * Grants permission to list browsers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toListBrowsers(): this;
    /**
     * Grants permission to list code interpreter sessions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toListCodeInterpreterSessions(): this;
    /**
     * Grants permission to list code interpreters
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toListCodeInterpreters(): this;
    /**
     * Grants permission to list events
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifSessionId()
     * - .ifActorId()
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_ListEvents.html
     */
    toListEvents(): this;
    /**
     * Grants permission to list existing gateway targets
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_ListGatewayTargets.html
     */
    toListGatewayTargets(): this;
    /**
     * Grants permission to list existing gateways
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_ListGateways.html
     */
    toListGateways(): this;
    /**
     * Grants permission to list memory resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_ListMemories.html
     */
    toListMemories(): this;
    /**
     * Grants permission to list memory records
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifNamespace()
     * - .ifStrategyId()
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_ListMemoryRecords.html
     */
    toListMemoryRecords(): this;
    /**
     * Grants permission to list all OAuth2 Credential Providers in the Token Vault
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_ListOauth2CredentialProviders.html
     */
    toListOauth2CredentialProviders(): this;
    /**
     * Grants permission to list sessions
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifActorId()
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_ListSessions.html
     */
    toListSessions(): this;
    /**
     * Grants permission to list all Workload Identities in the caller's AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_ListWorkloadIdentities.html
     */
    toListWorkloadIdentities(): this;
    /**
     * Grants permission to retrieve memory records through sematic query
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifNamespace()
     * - .ifStrategyId()
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_RetrieveMemoryRecords.html
     */
    toRetrieveMemoryRecords(): this;
    /**
     * Grants permission to associate a Customer Managed Key (CMK) or a Service Managed Key with a specific TokenVault
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_SetTokenVaultCMK.html
     */
    toSetTokenVaultCMK(): this;
    /**
     * Grants permission to starts a new browser session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toStartBrowserSession(): this;
    /**
     * Grants permission to start a new code interpreter session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toStartCodeInterpreterSession(): this;
    /**
     * Grants permission to stop a browser session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toStopBrowserSession(): this;
    /**
     * Grants permission to stop a code interpreter session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toStopCodeInterpreterSession(): this;
    /**
     * Grants permission to enable search on gateways
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/welcome.html
     */
    toSynchronizeGatewayTargets(): this;
    /**
     * Grants permission to update an agent runtime
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toUpdateAgentRuntime(): this;
    /**
     * Grants permission to update an agent runtime endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toUpdateAgentRuntimeEndpoint(): this;
    /**
     * Grants permission to update an existing API Key Credential Provider
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_UpdateApiKeyCredentialProvider.html
     */
    toUpdateApiKeyCredentialProvider(): this;
    /**
     * Grants permission to update the status of browser session stream
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/
     */
    toUpdateBrowserStream(): this;
    /**
     * Grants permission to update an existing gateway
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_UpdateGateway.html
     */
    toUpdateGateway(): this;
    /**
     * Grants permission to update an existing gateway target
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_UpdateGatewayTarget.html
     */
    toUpdateGatewayTarget(): this;
    /**
     * Grants permission to update a Memory resource
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_UpdateMemory.html
     */
    toUpdateMemory(): this;
    /**
     * Grants permission to update an existing OAuth2 Credential Provider
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_UpdateOauth2CredentialProvider.html
     */
    toUpdateOauth2CredentialProvider(): this;
    /**
     * Grants permission to update the metadata of an existing Workload Identity
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_UpdateWorkloadIdentity.html
     */
    toUpdateWorkloadIdentity(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type memory to the statement
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/memory.html
     *
     * @param memoryId - Identifier for the memoryId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onMemory(memoryId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type gateway to the statement
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/gateway.html
     *
     * @param gatewayId - Identifier for the gatewayId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onGateway(gatewayId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type workload-identity to the statement
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/workloadIdentity.html
     *
     * @param directoryId - Identifier for the directoryId.
     * @param workloadIdentityName - Identifier for the workloadIdentityName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onWorkloadIdentity(directoryId: string, workloadIdentityName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type oauth2credentialprovider to the statement
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/oauth2credentialprovider.html
     *
     * @param tokenVaultId - Identifier for the tokenVaultId.
     * @param name - Identifier for the name.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onOauth2credentialprovider(tokenVaultId: string, name: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type apikeycredentialprovider to the statement
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/apikeycredentialprovider.html
     *
     * @param tokenVaultId - Identifier for the tokenVaultId.
     * @param name - Identifier for the name.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onApikeycredentialprovider(tokenVaultId: string, name: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type runtime to the statement
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/runtime.html
     *
     * @param runtimeId - Identifier for the runtimeId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onRuntime(runtimeId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type runtime-endpoint to the statement
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/runtimeEndpoint.html
     *
     * @param runtimeId - Identifier for the runtimeId.
     * @param name - Identifier for the name.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onRuntimeEndpoint(runtimeId: string, name: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type code-interpreter-custom to the statement
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/codeInterpreter.html
     *
     * @param codeInterpreterId - Identifier for the codeInterpreterId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCodeInterpreterCustom(codeInterpreterId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type code-interpreter to the statement
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/codeInterpreter.html
     *
     * @param codeInterpreterId - Identifier for the codeInterpreterId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCodeInterpreter(codeInterpreterId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type browser-custom to the statement
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/browser.html
     *
     * @param browserId - Identifier for the browserId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onBrowserCustom(browserId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type browser to the statement
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/browser.html
     *
     * @param browserId - Identifier for the browserId.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onBrowser(browserId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type workload-identity-directory to the statement
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/workloadIdentityDirectory.html
     *
     * @param directoryId - Identifier for the directoryId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onWorkloadIdentityDirectory(directoryId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type token-vault to the statement
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/tokenVault.html
     *
     * @param tokenVaultId - Identifier for the tokenVaultId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onTokenVault(tokenVaultId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by Actor Id
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/#condition-keys-actorId
     *
     * Applies to actions:
     * - .toCreateEvent()
     * - .toDeleteEvent()
     * - .toGetEvent()
     * - .toListEvents()
     * - .toListSessions()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifActorId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by namespace
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/#condition-keys-namespace
     *
     * Applies to actions:
     * - .toListMemoryRecords()
     * - .toRetrieveMemoryRecords()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifNamespace(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by Session Id
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/#condition-keys-sessionId
     *
     * Applies to actions:
     * - .toCreateEvent()
     * - .toDeleteEvent()
     * - .toGetEvent()
     * - .toListEvents()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSessionId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by Memory Strategy Id
     *
     * https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/#condition-keys-strategyId
     *
     * Applies to actions:
     * - .toListMemoryRecords()
     * - .toRetrieveMemoryRecords()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifStrategyId(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [bedrock-agentcore](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonbedrockagentcore.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
