import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [bcm-recommended-actions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbillingandcostmanagementrecommendedactions.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class BcmRecommendedActions extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to list all recommended actions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_BillingAndCostManagementRecommendedActions_ListRecommendedActions.html
     */
    toListRecommendedActions(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [bcm-recommended-actions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbillingandcostmanagementrecommendedactions.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
