import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [acm](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscertificatemanager.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Acm extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to add one or more tags to a certificate
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/acm/latest/APIReference/API_AddTagsToCertificate.html
     */
    toAddTagsToCertificate(): this;
    /**
     * Grants permission to delete a certificate and its associated private key
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/acm/latest/APIReference/API_DeleteCertificate.html
     */
    toDeleteCertificate(): this;
    /**
     * Grants permission to retreive a certificates and its metadata
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html
     */
    toDescribeCertificate(): this;
    /**
     * Grants permission to export an exportable certificate for use anywhere
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifDomainNames()
     *
     * https://docs.aws.amazon.com/acm/latest/APIReference/API_ExportCertificate.html
     */
    toExportCertificate(): this;
    /**
     * Grants permission to retrieve account level configuration from AWS Certificate Manager
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/acm/latest/APIReference/API_GetAccountConfiguration.html
     */
    toGetAccountConfiguration(): this;
    /**
     * Grants permission to retrieve a certificate and certificate chain for a certificate ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/acm/latest/APIReference/API_GetCertificate.html
     */
    toGetCertificate(): this;
    /**
     * Grants permission to import a 3rd party certificate into AWS Certificate Manager (ACM)
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/acm/latest/APIReference/API_ImportCertificate.html
     */
    toImportCertificate(): this;
    /**
     * Grants permission to retrieve a list of the certificate ARNs and the domain name for each ARN
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/acm/latest/APIReference/API_ListCertificates.html
     */
    toListCertificates(): this;
    /**
     * Grants permission to lists the tags that have been associated with a certificate
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/acm/latest/APIReference/API_ListTagsForCertificate.html
     */
    toListTagsForCertificate(): this;
    /**
     * Grants permission to update account level configuration in AWS Certificate Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/acm/latest/APIReference/API_PutAccountConfiguration.html
     */
    toPutAccountConfiguration(): this;
    /**
     * Grants permission to remove one or more tags from a certificate
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/acm/latest/APIReference/API_RemoveTagsFromCertificate.html
     */
    toRemoveTagsFromCertificate(): this;
    /**
     * Grants permission to renew an eligible private certificate
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/acm/latest/APIReference/API_RenewCertificate.html
     */
    toRenewCertificate(): this;
    /**
     * Grants permission to requests a public or private certificate
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifDomainNames()
     * - .ifCertificateTransparencyLogging()
     * - .ifValidationMethod()
     * - .ifKeyAlgorithm()
     * - .ifCertificateAuthority()
     * - .ifExport()
     *
     * https://docs.aws.amazon.com/acm/latest/APIReference/API_RequestCertificate.html
     */
    toRequestCertificate(): this;
    /**
     * Grants permission to resend an email to request domain ownership validation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/acm/latest/APIReference/API_ResendValidationEmail.html
     */
    toResendValidationEmail(): this;
    /**
     * Grants permission to revoke an exportable certificate
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifDomainNames()
     *
     * https://docs.aws.amazon.com/acm/latest/APIReference/API_RevokeCertificate.html
     */
    toRevokeCertificate(): this;
    /**
     * Grants permission to update a certificate configuration. Use this to specify whether to opt in to or out of certificate transparency logging
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/acm/latest/APIReference/API_UpdateCertificateOptions.html
     */
    toUpdateCertificateOptions(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type certificate to the statement
     *
     * https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-acm-cert
     *
     * @param certificateId - Identifier for the certificateId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCertificate(certificateId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by certificateAuthority in the request. Can be used to restrict which Certificate Authorites certificates can be issued from
     *
     * https://docs.aws.amazon.com/acm/latest/userguide/security-iam.html
     *
     * Applies to actions:
     * - .toRequestCertificate()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCertificateAuthority(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by certificateTransparencyLogging option in the request. Default 'ENABLED' if no key is present in the request
     *
     * https://docs.aws.amazon.com/acm/latest/userguide/security-iam.html
     *
     * Applies to actions:
     * - .toRequestCertificate()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCertificateTransparencyLogging(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by domainNames in the request. This key can be used to restrict which domains can be in certificate requests
     *
     * https://docs.aws.amazon.com/acm/latest/userguide/security-iam.html
     *
     * Applies to actions:
     * - .toExportCertificate()
     * - .toRequestCertificate()
     * - .toRevokeCertificate()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifDomainNames(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the export option in the request. Can be used to restrict creation of certificates that can be exported
     *
     * https://docs.aws.amazon.com/acm/latest/userguide/security-iam.html
     *
     * Applies to actions:
     * - .toRequestCertificate()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifExport(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by keyAlgorithm in the request
     *
     * https://docs.aws.amazon.com/acm/latest/userguide/security-iam.html
     *
     * Applies to actions:
     * - .toRequestCertificate()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifKeyAlgorithm(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by validationMethod in the request. Default 'EMAIL' if no key is present in the request
     *
     * https://docs.aws.amazon.com/acm/latest/userguide/security-iam.html
     *
     * Applies to actions:
     * - .toRequestCertificate()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifValidationMethod(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the presence of tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toAddTagsToCertificate()
     * - .toImportCertificate()
     * - .toRemoveTagsFromCertificate()
     * - .toRequestCertificate()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - certificate
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the presence of tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toAddTagsToCertificate()
     * - .toImportCertificate()
     * - .toRemoveTagsFromCertificate()
     * - .toRequestCertificate()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [acm](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscertificatemanager.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
