import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [cloudformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscloudformation.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Cloudformation extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to activate trusted access between StackSets and Organizations. With trusted access between StackSets and Organizations activated, the management account has permissions to create and manage StackSets for your organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateOrganizationsAccess.html
     */
    toActivateOrganizationsAccess(): this;
    /**
     * Grants permission to activate a public third-party extension, making it available for use in stack templates
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html
     */
    toActivateType(): this;
    /**
     * Grants permission to return configuration data for the specified CloudFormation extensions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_BatchDescribeTypeConfigurations.html
     */
    toBatchDescribeTypeConfigurations(): this;
    /**
     * Grants permission to cancel an update on the specified stack
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CancelUpdateStack.html
     */
    toCancelUpdateStack(): this;
    /**
     * Grants permission to continue rolling back a stack that is in the UPDATE_ROLLBACK_FAILED state to the UPDATE_ROLLBACK_COMPLETE state
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRoleArn()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ContinueUpdateRollback.html
     */
    toContinueUpdateRollback(): this;
    /**
     * Grants permission to create a list of changes for a stack
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifChangeSetName()
     * - .ifResourceTypes()
     * - .ifImportResourceTypes()
     * - .ifRoleArn()
     * - .ifStackPolicyUrl()
     * - .ifTemplateUrl()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateChangeSet.html
     */
    toCreateChangeSet(): this;
    /**
     * Grants permission to create a template from existing resources that are not already managed with CloudFormation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateGeneratedTemplate.html
     */
    toCreateGeneratedTemplate(): this;
    /**
     * Grants permission to create a stack as specified in the template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifResourceTypes()
     * - .ifRoleArn()
     * - .ifStackPolicyUrl()
     * - .ifTemplateUrl()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStack.html
     */
    toCreateStack(): this;
    /**
     * Grants permission to create stack instances for the specified accounts, within the specified regions
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifTargetRegion()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackInstances.html
     */
    toCreateStackInstances(): this;
    /**
     * Grants permission to create a stack refactor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackRefactor.html
     */
    toCreateStackRefactor(): this;
    /**
     * Grants permission to create a stackset as specified in the template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRoleArn()
     * - .ifTemplateUrl()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackSet.html
     */
    toCreateStackSet(): this;
    /**
     * Grants permission to upload templates to Amazon S3 buckets. Used only by the AWS CloudFormation console and is not documented in the API reference
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html
     */
    toCreateUploadBucket(): this;
    /**
     * Grants permission to deactivate trusted access between StackSets and Organizations. If trusted access is deactivated, the management account does not have permissions to create and manage service-managed StackSets for your organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeactivateOrganizationsAccess.html
     */
    toDeactivateOrganizationsAccess(): this;
    /**
     * Grants permission to deactivate a public extension that was previously activated in this account and region
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeactivateType.html
     */
    toDeactivateType(): this;
    /**
     * Grants permission to delete the specified change set. Deleting change sets ensures that no one executes the wrong change set
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifChangeSetName()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeleteChangeSet.html
     */
    toDeleteChangeSet(): this;
    /**
     * Grants permission to delete a generated template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeleteGeneratedTemplate.html
     */
    toDeleteGeneratedTemplate(): this;
    /**
     * Grants permission to delete a specified stack
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRoleArn()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeleteStack.html
     */
    toDeleteStack(): this;
    /**
     * Grants permission to delete stack instances for the specified accounts, in the specified regions
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifTargetRegion()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeleteStackInstances.html
     */
    toDeleteStackInstances(): this;
    /**
     * Grants permission to delete a specified stackset
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeleteStackSet.html
     */
    toDeleteStackSet(): this;
    /**
     * Grants permission to deregister an existing CloudFormation type or type version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeregisterType.html
     */
    toDeregisterType(): this;
    /**
     * Grants permission to retrieve your account's AWS CloudFormation limits
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeAccountLimits.html
     */
    toDescribeAccountLimits(): this;
    /**
     * Grants permission to return the description for the specified change set
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifChangeSetName()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeChangeSet.html
     */
    toDescribeChangeSet(): this;
    /**
     * Grants permission to return the Hook invocation information for the specified change set
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifChangeSetName()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeChangeSetHooks.html
     */
    toDescribeChangeSetHooks(): this;
    /**
     * Grants permission to describe a generated template. The output includes details about the progress of the creation of a generated template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeGeneratedTemplate.html
     */
    toDescribeGeneratedTemplate(): this;
    /**
     * Grants permission to return information about the account's OrganizationAccess status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeOrganizationsAccess.html
     */
    toDescribeOrganizationsAccess(): this;
    /**
     * Grants permission to return information about a CloudFormation extension publisher
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribePublisher.html
     */
    toDescribePublisher(): this;
    /**
     * Grants permission to describe details of a resource scan
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeResourceScan.html
     */
    toDescribeResourceScan(): this;
    /**
     * Grants permission to return information about a stack drift detection operation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackDriftDetectionStatus.html
     */
    toDescribeStackDriftDetectionStatus(): this;
    /**
     * Grants permission to return all stack related events for a specified stack
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackEvents.html
     */
    toDescribeStackEvents(): this;
    /**
     * Grants permission to return the stack instance that's associated with the specified stack set, AWS account, and region
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackInstance.html
     */
    toDescribeStackInstance(): this;
    /**
     * Grants permission to return the description for the specified stack refactor
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackRefactor.html
     */
    toDescribeStackRefactor(): this;
    /**
     * Grants permission to return a description of the specified resource in the specified stack
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackResource.html
     */
    toDescribeStackResource(): this;
    /**
     * Grants permission to return drift information for the resources that have been checked for drift in the specified stack
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackResourceDrifts.html
     */
    toDescribeStackResourceDrifts(): this;
    /**
     * Grants permission to return AWS resource descriptions for running and deleted stacks
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackResources.html
     */
    toDescribeStackResources(): this;
    /**
     * Grants permission to return the description of the specified stack set
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackSet.html
     */
    toDescribeStackSet(): this;
    /**
     * Grants permission to return the description of the specified stack set operation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStackSetOperation.html
     */
    toDescribeStackSetOperation(): this;
    /**
     * Grants permission to return the description for the specified stack, and to all stacks when used in combination with the ListStacks action
     *
     * Access Level: List
     *
     * Dependent actions:
     * - cloudformation:ListStacks
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeStacks.html
     */
    toDescribeStacks(): this;
    /**
     * Grants permission to return information about the CloudFormation type requested
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html
     */
    toDescribeType(): this;
    /**
     * Grants permission to return information about the registration process for a CloudFormation type
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeTypeRegistration.html
     */
    toDescribeTypeRegistration(): this;
    /**
     * Grants permission to detects whether a stack's actual configuration differs, or has drifted, from it's expected configuration, as defined in the stack template and any values specified as template parameters
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DetectStackDrift.html
     */
    toDetectStackDrift(): this;
    /**
     * Grants permission to return information about whether a resource's actual configuration differs, or has drifted, from it's expected configuration, as defined in the stack template and any values specified as template parameters
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DetectStackResourceDrift.html
     */
    toDetectStackResourceDrift(): this;
    /**
     * Grants permission to enable users to detect drift on a stack set and the stack instances that belong to that stack set
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DetectStackSetDrift.html
     */
    toDetectStackSetDrift(): this;
    /**
     * Grants permission to return the estimated monthly cost of a template
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifTemplateUrl()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_EstimateTemplateCost.html
     */
    toEstimateTemplateCost(): this;
    /**
     * Grants permission to update a stack using the input information that was provided when the specified change set was created
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifChangeSetName()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ExecuteChangeSet.html
     */
    toExecuteChangeSet(): this;
    /**
     * Grants permission to execute a stack refactor using the input information that was provided when the specified stack refactor was created
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ExecuteStackRefactor.html
     */
    toExecuteStackRefactor(): this;
    /**
     * Grants permission to retrieve a generated template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_GetGeneratedTemplate.html
     */
    toGetGeneratedTemplate(): this;
    /**
     * Grants permission to return the stack policy for a specified stack
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_GetStackPolicy.html
     */
    toGetStackPolicy(): this;
    /**
     * Grants permission to return the template body for a specified stack
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_GetTemplate.html
     */
    toGetTemplate(): this;
    /**
     * Grants permission to return information about a new or existing template
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifTemplateUrl()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_GetTemplateSummary.html
     */
    toGetTemplateSummary(): this;
    /**
     * Grants permission to enable users to import existing stacks to a new or existing stackset
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ImportStacksToStackSet.html
     */
    toImportStacksToStackSet(): this;
    /**
     * Grants permission to return Hook invocations result information for a specified Hook, a combination of Hook and status, or all Hooks
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifTypeArn()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListHookResults.html
     */
    toListAllHookResults(): this;
    /**
     * Grants permission to return the ID and status of each active change set for a stack. For example, AWS CloudFormation lists change sets that are in the CREATE_IN_PROGRESS or CREATE_PENDING state
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListChangeSets.html
     */
    toListChangeSets(): this;
    /**
     * Grants permission to list all exported output values in the account and region in which you call this action
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListExports.html
     */
    toListExports(): this;
    /**
     * Grants permission to list your generated templates in this Region
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListGeneratedTemplates.html
     */
    toListGeneratedTemplates(): this;
    /**
     * Grants permission to return Hook invocations result information for the specified target
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifChangeSetName()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListHookResults.html
     */
    toListHookResults(): this;
    /**
     * Grants permission to list all stacks that are importing an exported output value
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListImports.html
     */
    toListImports(): this;
    /**
     * Grants permission to list the related resources for a list of resources from a resource scan. The response indicates whether each returned resource is already managed by CloudFormation
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListResourceScanRelatedResources.html
     */
    toListResourceScanRelatedResources(): this;
    /**
     * Grants permission to list the resources from a resource scan. The results can be filtered by resource identifier, resource type prefix, tag key, and tag value
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListResourceScanResources.html
     */
    toListResourceScanResources(): this;
    /**
     * Grants permission to list the resource scans from newest to oldest. By default it will return up to 10 resource scans
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListResourceScans.html
     */
    toListResourceScans(): this;
    /**
     * Grants permission to return drift information for the resources that have been checked for drift in the specified stack instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStackInstanceResourceDrifts.html
     */
    toListStackInstanceResourceDrifts(): this;
    /**
     * Grants permission to return summary information about stack instances that are associated with the specified stack set
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStackSets.html
     */
    toListStackInstances(): this;
    /**
     * Grants permission to return the list of actions of the specified stack refactor
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStackRefactorActions.html
     */
    toListStackRefactorActions(): this;
    /**
     * Grants permission to return the ID and status of each active stack refactor
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStackRefactors.html
     */
    toListStackRefactors(): this;
    /**
     * Grants permission to return descriptions of all resources of the specified stack
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStackResources.html
     */
    toListStackResources(): this;
    /**
     * Grants permission to return summary information about StackSet Auto Deployment Targets
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStackSetAutoDeploymentTargets.html
     */
    toListStackSetAutoDeploymentTargets(): this;
    /**
     * Grants permission to return summary information about the results of a stack set operation
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStackSetOperationResults.html
     */
    toListStackSetOperationResults(): this;
    /**
     * Grants permission to return summary information about operations performed on a stack set
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStackSetOperations.html
     */
    toListStackSetOperations(): this;
    /**
     * Grants permission to return summary information about stack sets that are associated with the user
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStackSets.html
     */
    toListStackSets(): this;
    /**
     * Grants permission to return the summary information for stacks whose status matches the specified StackStatusFilter. In combination with the DescribeStacks action, grants permission to list descriptions for stacks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListStacks.html
     */
    toListStacks(): this;
    /**
     * Grants permission to list CloudFormation type registration attempts
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListTypeRegistrations.html
     */
    toListTypeRegistrations(): this;
    /**
     * Grants permission to list versions of a particular CloudFormation type
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListTypeVersions.html
     */
    toListTypeVersions(): this;
    /**
     * Grants permission to list available CloudFormation types
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListTypes.html
     */
    toListTypes(): this;
    /**
     * Grants permission to publish the specified extension to the CloudFormation registry as a public extension in this region
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_PublishType.html
     */
    toPublishType(): this;
    /**
     * Grants permission to record the handler progress
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RecordHandlerProgress.html
     */
    toRecordHandlerProgress(): this;
    /**
     * Grants permission to register account as a publisher of public extensions in the CloudFormation registry
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterPublisher.html
     */
    toRegisterPublisher(): this;
    /**
     * Grants permission to register a new CloudFormation type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html
     */
    toRegisterType(): this;
    /**
     * Grants permission to rollback the stack to the last stable state
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRoleArn()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RollbackStack.html
     */
    toRollbackStack(): this;
    /**
     * Grants permission to set a stack policy for a specified stack
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifStackPolicyUrl()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetStackPolicy.html
     */
    toSetStackPolicy(): this;
    /**
     * Grants permission to set the configuration data for a registered CloudFormation extension, in the given account and region
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeConfiguration.html
     */
    toSetTypeConfiguration(): this;
    /**
     * Grants permission to set which version of a CloudFormation type applies to CloudFormation operations
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SetTypeDefaultVersion.html
     */
    toSetTypeDefaultVersion(): this;
    /**
     * Grants permission to send a signal to the specified resource with a success or failure status
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_SignalResource.html
     */
    toSignalResource(): this;
    /**
     * Grants permission to start a scan of the resources in this account in this Region
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_StartResourceScan.html
     */
    toStartResourceScan(): this;
    /**
     * Grants permission to stop an in-progress operation on a stack set and its associated stack instances
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_StopStackSetOperation.html
     */
    toStopStackSetOperation(): this;
    /**
     * Grants permission to tag cloudformation resources
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifCreateAction()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to test a registered extension to make sure it meets all necessary requirements for being published in the CloudFormation registry
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_TestType.html
     */
    toTestType(): this;
    /**
     * Grants permission to untag cloudformation resources
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifCreateAction()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a generated template. This can be used to change the name, add and remove resources, refresh resources, and change the DeletionPolicy and UpdateReplacePolicy settings
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateGeneratedTemplate.html
     */
    toUpdateGeneratedTemplate(): this;
    /**
     * Grants permission to update a stack as specified in the template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifResourceTypes()
     * - .ifRoleArn()
     * - .ifStackPolicyUrl()
     * - .ifTemplateUrl()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStack.html
     */
    toUpdateStack(): this;
    /**
     * Grants permission to update the parameter values for stack instances for the specified accounts, within the specified regions
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifTargetRegion()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackInstances.html
     */
    toUpdateStackInstances(): this;
    /**
     * Grants permission to update a stackset as specified in the template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRoleArn()
     * - .ifTemplateUrl()
     * - .ifTargetRegion()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html
     */
    toUpdateStackSet(): this;
    /**
     * Grants permission to update termination protection for the specified stack
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateTerminationProtection.html
     */
    toUpdateTerminationProtection(): this;
    /**
     * Grants permission to validate a specified template
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifTemplateUrl()
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ValidateTemplate.html
     */
    toValidateTemplate(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type changeset to the statement
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-whatis-concepts.html#w2ab1b5c15c11
     *
     * @param changeSetName - Identifier for the changeSetName.
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onChangeset(changeSetName: string, id: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type stack to the statement
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-whatis-concepts.html#w2ab1b5c15b9
     *
     * @param stackName - Identifier for the stackName.
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onStack(stackName: string, id: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type stackset to the statement
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stacksets-concepts-stackset
     *
     * @param stackSetName - Identifier for the stackSetName.
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onStackset(stackSetName: string, id: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type stackset-target to the statement
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html
     *
     * @param stackSetTarget - Identifier for the stackSetTarget.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onStacksetTarget(stackSetTarget: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type type to the statement
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html
     *
     * @param type - Identifier for the type.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onType(type: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type generatedtemplate to the statement
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/generate-IaC.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onGeneratedtemplate(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type resourcescan to the statement
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/generate-IaC.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onResourcescan(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-template-conditions
     *
     * Applies to actions:
     * - .toCreateChangeSet()
     * - .toCreateStack()
     * - .toCreateStackSet()
     * - .toTagResource()
     * - .toUpdateStack()
     * - .toUpdateStackSet()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-template-conditions
     *
     * Applies to resource types:
     * - changeset
     * - stack
     * - stackset
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-template-conditions
     *
     * Applies to actions:
     * - .toCreateChangeSet()
     * - .toCreateStack()
     * - .toCreateStackInstances()
     * - .toCreateStackSet()
     * - .toTagResource()
     * - .toUntagResource()
     * - .toUpdateStack()
     * - .toUpdateStackSet()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by an AWS CloudFormation change set name. Use to control which change sets IAM users can execute or delete
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-template-conditions
     *
     * Applies to actions:
     * - .toCreateChangeSet()
     * - .toDeleteChangeSet()
     * - .toDescribeChangeSet()
     * - .toDescribeChangeSetHooks()
     * - .toExecuteChangeSet()
     * - .toListHookResults()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifChangeSetName(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the name of a resource-mutating API action. Use to control which APIs IAM users can use to add or remove tags on a stack or stack set
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-template-conditions
     *
     * Applies to actions:
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCreateAction(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the template resource types, such as AWS::EC2::Instance. Use to control which resource types IAM users can work with when they want to import a resource into a stack
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-template-conditions
     *
     * Applies to actions:
     * - .toCreateChangeSet()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifImportResourceTypes(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the template resource types, such as AWS::EC2::Instance. Use to control which resource types IAM users can work with when they create or update a stack
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-template-conditions
     *
     * Applies to actions:
     * - .toCreateChangeSet()
     * - .toCreateStack()
     * - .toUpdateStack()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifResourceTypes(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of an IAM service role. Use to control which service role IAM users can use to work with stacks or change sets
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-template-conditions
     *
     * Applies to actions:
     * - .toContinueUpdateRollback()
     * - .toCreateChangeSet()
     * - .toCreateStack()
     * - .toCreateStackSet()
     * - .toDeleteStack()
     * - .toRollbackStack()
     * - .toUpdateStack()
     * - .toUpdateStackSet()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifRoleArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by an Amazon S3 stack policy URL. Use to control which stack policies IAM users can associate with a stack during a create or update stack action
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-template-conditions
     *
     * Applies to actions:
     * - .toCreateChangeSet()
     * - .toCreateStack()
     * - .toSetStackPolicy()
     * - .toUpdateStack()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifStackPolicyUrl(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by stack set target region. Use to control which regions IAM users can use when they create or update stack sets
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-template-conditions
     *
     * Applies to actions:
     * - .toCreateStackInstances()
     * - .toDeleteStackInstances()
     * - .toUpdateStackInstances()
     * - .toUpdateStackSet()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifTargetRegion(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by an Amazon S3 template URL. Use to control which templates IAM users can use when they create or update stacks
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-template-conditions
     *
     * Applies to actions:
     * - .toCreateChangeSet()
     * - .toCreateStack()
     * - .toCreateStackSet()
     * - .toEstimateTemplateCost()
     * - .toGetTemplateSummary()
     * - .toUpdateStack()
     * - .toUpdateStackSet()
     * - .toValidateTemplate()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifTemplateUrl(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of a CloudFormation extension
     *
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-template-conditions
     *
     * Applies to actions:
     * - .toListAllHookResults()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifTypeArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [cloudformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscloudformation.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
