import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [observabilityadmin](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchobservabilityadminservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Observabilityadmin extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create a new organization centralization rule with the specified name for the organization
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifCentralizationSourceRegions()
     * - .ifCentralizationDestinationRegion()
     * - .ifCentralizationBackupRegion()
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_CreateCentralizationRuleForOrganization.html
     */
    toCreateCentralizationRuleForOrganization(): this;
    /**
     * Grants permission to create a new telemetry rule with the specified name for the account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_CreateTelemetryRule.html
     */
    toCreateTelemetryRule(): this;
    /**
     * Grants permission to create a new organization telemetry rule with the specified name for the organization
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_CreateTelemetryRuleForOrganization.html
     */
    toCreateTelemetryRuleForOrganization(): this;
    /**
     * Grants permission to delete an organization centralization rule with the specified name for the organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_DeleteCentralizationRuleForOrganization.html
     */
    toDeleteCentralizationRuleForOrganization(): this;
    /**
     * Grants permission to delete a telemetry rule with the specified name for the account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_DeleteTelemetryRule.html
     */
    toDeleteTelemetryRule(): this;
    /**
     * Grants permission to delete an organization telemetry rule with the specified name for the organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_DeleteTelemetryRuleForOrganization.html
     */
    toDeleteTelemetryRuleForOrganization(): this;
    /**
     * Grants permission to retrieve the specified organization centralization rule for the organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_GetCentralizationRuleForOrganization.html
     */
    toGetCentralizationRuleForOrganization(): this;
    /**
     * Grants permission to retrieve the status of the Resource tags for telemetry feature for the account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_GetTelemetryEnrichmentStatus.html
     */
    toGetTelemetryEnrichmentStatus(): this;
    /**
     * Grants permission to retrieve the Telemetry Config feature status for the account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_GetTelemetryEvaluationStatus.html
     */
    toGetTelemetryEvaluationStatus(): this;
    /**
     * Grants permission to retrieve the Telemetry Config feature status for the organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_GetTelemetryEvaluationStatusForOrganization.html
     */
    toGetTelemetryEvaluationStatusForOrganization(): this;
    /**
     * Grants permission to retrieve the specified telemetry rule for the account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_GetTelemetryRule.html
     */
    toGetTelemetryRule(): this;
    /**
     * Grants permission to retrieve the specified organization telemetry rule for the organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_GetTelemetryRuleForOrganization.html
     */
    toGetTelemetryRuleForOrganization(): this;
    /**
     * Grants permission to list the centralization rules for the organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_ListCentralizationRulesForOrganization.html
     */
    toListCentralizationRulesForOrganization(): this;
    /**
     * Grants permission to retrieve telemetry configurations for resources associated with the account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_ListResourceTelemetry.html
     */
    toListResourceTelemetry(): this;
    /**
     * Grants permission to retrieve telemetry configurations for resources associated with accounts in the organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_ListResourceTelemetryForOrganization.html
     */
    toListResourceTelemetryForOrganization(): this;
    /**
     * Grants permission to list the tags for the specified resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list the telemetry rules for the account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_ListTelemetryRules.html
     */
    toListTelemetryRules(): this;
    /**
     * Grants permission to list the telemetry rules for the organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_ListTelemetryRulesForOrganization.html
     */
    toListTelemetryRulesForOrganization(): this;
    /**
     * Grants permission to enable the Resource tags for telemetry feature for the account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_StartTelemetryEnrichment.html
     */
    toStartTelemetryEnrichment(): this;
    /**
     * Grants permission to start the Telemetry Config feature for the account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_StartTelemetryEvaluation.html
     */
    toStartTelemetryEvaluation(): this;
    /**
     * Grants permission to start the Telemetry Config feature for the organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_StartTelemetryEvaluationForOrganization.html
     */
    toStartTelemetryEvaluationForOrganization(): this;
    /**
     * Grants permission to disable the Resource tags for telemetry feature for the account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_StopTelemetryEnrichment.html
     */
    toStopTelemetryEnrichment(): this;
    /**
     * Grants permission to stop the Telemetry Config feature for the account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_StopTelemetryEvaluation.html
     */
    toStopTelemetryEvaluation(): this;
    /**
     * Grants permission to stop the Telemetry Config feature for the organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_StopTelemetryEvaluationForOrganization.html
     */
    toStopTelemetryEvaluationForOrganization(): this;
    /**
     * Grants permission to add or update the specified tags for the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove the specified tags from the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update the specified centralization rule for the organization
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifCentralizationSourceRegions()
     * - .ifCentralizationDestinationRegion()
     * - .ifCentralizationBackupRegion()
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_UpdateCentralizationRuleForOrganization.html
     */
    toUpdateCentralizationRuleForOrganization(): this;
    /**
     * Grants permission to update the specified telemetry rule for the account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_UpdateTelemetryRule.html
     */
    toUpdateTelemetryRule(): this;
    /**
     * Grants permission to update the specified telemetry rule for the organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_UpdateTelemetryRuleForOrganization.html
     */
    toUpdateTelemetryRuleForOrganization(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type telemetry-rule to the statement
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_TelemetryRule.html
     *
     * @param telemetryRuleName - Identifier for the telemetryRuleName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTelemetryRule(telemetryRuleName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type organization-telemetry-rule to the statement
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_OrganizationTelemetryRule.html
     *
     * @param telemetryRuleName - Identifier for the telemetryRuleName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onOrganizationTelemetryRule(telemetryRuleName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type organization-centralization-rule to the statement
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_OrganizationCentralizationRule.html
     *
     * @param centralizationRuleName - Identifier for the centralizationRuleName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onOrganizationCentralizationRule(centralizationRuleName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateCentralizationRuleForOrganization()
     * - .toCreateTelemetryRule()
     * - .toCreateTelemetryRuleForOrganization()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - telemetry-rule
     * - organization-telemetry-rule
     * - organization-centralization-rule
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateCentralizationRuleForOrganization()
     * - .toCreateTelemetryRule()
     * - .toCreateTelemetryRuleForOrganization()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the backup region that is passed in the request
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/reference_policies_condition-keys.htmlcondition-keys-observabilityadmin.html#condition-keys-centralizationbackupregion
     *
     * Applies to actions:
     * - .toCreateCentralizationRuleForOrganization()
     * - .toUpdateCentralizationRuleForOrganization()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCentralizationBackupRegion(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the destination region that is passed in the request
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/reference_policies_condition-keys.htmlcondition-keys-observabilityadmin.html#condition-keys-centralizationdestinationregion
     *
     * Applies to actions:
     * - .toCreateCentralizationRuleForOrganization()
     * - .toUpdateCentralizationRuleForOrganization()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCentralizationDestinationRegion(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the source regions that are passed in the request
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/reference_policies_condition-keys.htmlcondition-keys-observabilityadmin.html#condition-keys-centralizationsourceregions
     *
     * Applies to actions:
     * - .toCreateCentralizationRuleForOrganization()
     * - .toUpdateCentralizationRuleForOrganization()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCentralizationSourceRegions(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [observabilityadmin](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchobservabilityadminservice.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
