"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Observabilityadmin = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [observabilityadmin](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchobservabilityadminservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Observabilityadmin extends shared_1.PolicyStatement {
    /**
     * Grants permission to create a new organization centralization rule with the specified name for the organization
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifCentralizationSourceRegions()
     * - .ifCentralizationDestinationRegion()
     * - .ifCentralizationBackupRegion()
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_CreateCentralizationRuleForOrganization.html
     */
    toCreateCentralizationRuleForOrganization() {
        return this.to('CreateCentralizationRuleForOrganization');
    }
    /**
     * Grants permission to create a new telemetry rule with the specified name for the account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_CreateTelemetryRule.html
     */
    toCreateTelemetryRule() {
        return this.to('CreateTelemetryRule');
    }
    /**
     * Grants permission to create a new organization telemetry rule with the specified name for the organization
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_CreateTelemetryRuleForOrganization.html
     */
    toCreateTelemetryRuleForOrganization() {
        return this.to('CreateTelemetryRuleForOrganization');
    }
    /**
     * Grants permission to delete an organization centralization rule with the specified name for the organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_DeleteCentralizationRuleForOrganization.html
     */
    toDeleteCentralizationRuleForOrganization() {
        return this.to('DeleteCentralizationRuleForOrganization');
    }
    /**
     * Grants permission to delete a telemetry rule with the specified name for the account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_DeleteTelemetryRule.html
     */
    toDeleteTelemetryRule() {
        return this.to('DeleteTelemetryRule');
    }
    /**
     * Grants permission to delete an organization telemetry rule with the specified name for the organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_DeleteTelemetryRuleForOrganization.html
     */
    toDeleteTelemetryRuleForOrganization() {
        return this.to('DeleteTelemetryRuleForOrganization');
    }
    /**
     * Grants permission to retrieve the specified organization centralization rule for the organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_GetCentralizationRuleForOrganization.html
     */
    toGetCentralizationRuleForOrganization() {
        return this.to('GetCentralizationRuleForOrganization');
    }
    /**
     * Grants permission to retrieve the status of the Resource tags for telemetry feature for the account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_GetTelemetryEnrichmentStatus.html
     */
    toGetTelemetryEnrichmentStatus() {
        return this.to('GetTelemetryEnrichmentStatus');
    }
    /**
     * Grants permission to retrieve the Telemetry Config feature status for the account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_GetTelemetryEvaluationStatus.html
     */
    toGetTelemetryEvaluationStatus() {
        return this.to('GetTelemetryEvaluationStatus');
    }
    /**
     * Grants permission to retrieve the Telemetry Config feature status for the organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_GetTelemetryEvaluationStatusForOrganization.html
     */
    toGetTelemetryEvaluationStatusForOrganization() {
        return this.to('GetTelemetryEvaluationStatusForOrganization');
    }
    /**
     * Grants permission to retrieve the specified telemetry rule for the account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_GetTelemetryRule.html
     */
    toGetTelemetryRule() {
        return this.to('GetTelemetryRule');
    }
    /**
     * Grants permission to retrieve the specified organization telemetry rule for the organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_GetTelemetryRuleForOrganization.html
     */
    toGetTelemetryRuleForOrganization() {
        return this.to('GetTelemetryRuleForOrganization');
    }
    /**
     * Grants permission to list the centralization rules for the organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_ListCentralizationRulesForOrganization.html
     */
    toListCentralizationRulesForOrganization() {
        return this.to('ListCentralizationRulesForOrganization');
    }
    /**
     * Grants permission to retrieve telemetry configurations for resources associated with the account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_ListResourceTelemetry.html
     */
    toListResourceTelemetry() {
        return this.to('ListResourceTelemetry');
    }
    /**
     * Grants permission to retrieve telemetry configurations for resources associated with accounts in the organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_ListResourceTelemetryForOrganization.html
     */
    toListResourceTelemetryForOrganization() {
        return this.to('ListResourceTelemetryForOrganization');
    }
    /**
     * Grants permission to list the tags for the specified resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to list the telemetry rules for the account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_ListTelemetryRules.html
     */
    toListTelemetryRules() {
        return this.to('ListTelemetryRules');
    }
    /**
     * Grants permission to list the telemetry rules for the organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_ListTelemetryRulesForOrganization.html
     */
    toListTelemetryRulesForOrganization() {
        return this.to('ListTelemetryRulesForOrganization');
    }
    /**
     * Grants permission to enable the Resource tags for telemetry feature for the account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_StartTelemetryEnrichment.html
     */
    toStartTelemetryEnrichment() {
        return this.to('StartTelemetryEnrichment');
    }
    /**
     * Grants permission to start the Telemetry Config feature for the account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_StartTelemetryEvaluation.html
     */
    toStartTelemetryEvaluation() {
        return this.to('StartTelemetryEvaluation');
    }
    /**
     * Grants permission to start the Telemetry Config feature for the organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_StartTelemetryEvaluationForOrganization.html
     */
    toStartTelemetryEvaluationForOrganization() {
        return this.to('StartTelemetryEvaluationForOrganization');
    }
    /**
     * Grants permission to disable the Resource tags for telemetry feature for the account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_StopTelemetryEnrichment.html
     */
    toStopTelemetryEnrichment() {
        return this.to('StopTelemetryEnrichment');
    }
    /**
     * Grants permission to stop the Telemetry Config feature for the account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_StopTelemetryEvaluation.html
     */
    toStopTelemetryEvaluation() {
        return this.to('StopTelemetryEvaluation');
    }
    /**
     * Grants permission to stop the Telemetry Config feature for the organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_StopTelemetryEvaluationForOrganization.html
     */
    toStopTelemetryEvaluationForOrganization() {
        return this.to('StopTelemetryEvaluationForOrganization');
    }
    /**
     * Grants permission to add or update the specified tags for the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove the specified tags from the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update the specified centralization rule for the organization
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifCentralizationSourceRegions()
     * - .ifCentralizationDestinationRegion()
     * - .ifCentralizationBackupRegion()
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_UpdateCentralizationRuleForOrganization.html
     */
    toUpdateCentralizationRuleForOrganization() {
        return this.to('UpdateCentralizationRuleForOrganization');
    }
    /**
     * Grants permission to update the specified telemetry rule for the account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_UpdateTelemetryRule.html
     */
    toUpdateTelemetryRule() {
        return this.to('UpdateTelemetryRule');
    }
    /**
     * Grants permission to update the specified telemetry rule for the organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_UpdateTelemetryRuleForOrganization.html
     */
    toUpdateTelemetryRuleForOrganization() {
        return this.to('UpdateTelemetryRuleForOrganization');
    }
    /**
     * Adds a resource of type telemetry-rule to the statement
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_TelemetryRule.html
     *
     * @param telemetryRuleName - Identifier for the telemetryRuleName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTelemetryRule(telemetryRuleName, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:observabilityadmin:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:telemetry-rule:${telemetryRuleName}`);
    }
    /**
     * Adds a resource of type organization-telemetry-rule to the statement
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_OrganizationTelemetryRule.html
     *
     * @param telemetryRuleName - Identifier for the telemetryRuleName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onOrganizationTelemetryRule(telemetryRuleName, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:observabilityadmin:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:organization-telemetry-rule:${telemetryRuleName}`);
    }
    /**
     * Adds a resource of type organization-centralization-rule to the statement
     *
     * https://docs.aws.amazon.com/cloudwatch/latest/observabilityadmin/API_OrganizationCentralizationRule.html
     *
     * @param centralizationRuleName - Identifier for the centralizationRuleName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onOrganizationCentralizationRule(centralizationRuleName, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:observabilityadmin:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:organization-centralization-rule:${centralizationRuleName}`);
    }
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateCentralizationRuleForOrganization()
     * - .toCreateTelemetryRule()
     * - .toCreateTelemetryRuleForOrganization()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey, value, operator) {
        return this.if(`aws:RequestTag/${tagKey}`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - telemetry-rule
     * - organization-telemetry-rule
     * - organization-centralization-rule
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey, value, operator) {
        return this.if(`aws:ResourceTag/${tagKey}`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateCentralizationRuleForOrganization()
     * - .toCreateTelemetryRule()
     * - .toCreateTelemetryRuleForOrganization()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value, operator) {
        return this.if(`aws:TagKeys`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by the backup region that is passed in the request
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/reference_policies_condition-keys.htmlcondition-keys-observabilityadmin.html#condition-keys-centralizationbackupregion
     *
     * Applies to actions:
     * - .toCreateCentralizationRuleForOrganization()
     * - .toUpdateCentralizationRuleForOrganization()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCentralizationBackupRegion(value, operator) {
        return this.if(`CentralizationBackupRegion`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by the destination region that is passed in the request
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/reference_policies_condition-keys.htmlcondition-keys-observabilityadmin.html#condition-keys-centralizationdestinationregion
     *
     * Applies to actions:
     * - .toCreateCentralizationRuleForOrganization()
     * - .toUpdateCentralizationRuleForOrganization()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCentralizationDestinationRegion(value, operator) {
        return this.if(`CentralizationDestinationRegion`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by the source regions that are passed in the request
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/reference_policies_condition-keys.htmlcondition-keys-observabilityadmin.html#condition-keys-centralizationsourceregions
     *
     * Applies to actions:
     * - .toCreateCentralizationRuleForOrganization()
     * - .toUpdateCentralizationRuleForOrganization()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCentralizationSourceRegions(value, operator) {
        return this.if(`CentralizationSourceRegions`, value, operator ?? 'StringLike');
    }
    /**
     * Statement provider for service [observabilityadmin](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchobservabilityadminservice.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'observabilityadmin';
        this.accessLevelList = {
            Write: [
                'CreateCentralizationRuleForOrganization',
                'CreateTelemetryRule',
                'CreateTelemetryRuleForOrganization',
                'DeleteCentralizationRuleForOrganization',
                'DeleteTelemetryRule',
                'DeleteTelemetryRuleForOrganization',
                'StartTelemetryEnrichment',
                'StartTelemetryEvaluation',
                'StartTelemetryEvaluationForOrganization',
                'StopTelemetryEnrichment',
                'StopTelemetryEvaluation',
                'StopTelemetryEvaluationForOrganization',
                'UpdateCentralizationRuleForOrganization',
                'UpdateTelemetryRule',
                'UpdateTelemetryRuleForOrganization'
            ],
            Read: [
                'GetCentralizationRuleForOrganization',
                'GetTelemetryEnrichmentStatus',
                'GetTelemetryEvaluationStatus',
                'GetTelemetryEvaluationStatusForOrganization',
                'GetTelemetryRule',
                'GetTelemetryRuleForOrganization',
                'ListResourceTelemetry',
                'ListResourceTelemetryForOrganization'
            ],
            List: [
                'ListCentralizationRulesForOrganization',
                'ListTagsForResource',
                'ListTelemetryRules',
                'ListTelemetryRulesForOrganization'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
}
exports.Observabilityadmin = Observabilityadmin;
//# sourceMappingURL=data:application/json;base64,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