import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [codewhisperer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncodewhisperer.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Codewhisperer extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to configure vended log delivery for CodeWhisperer customization resource
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/userguide/monitoring-overview.html
     */
    toAllowVendedLogDeliveryForResource(): this;
    /**
     * Grants permission to invoke AssociateCustomizationPermission on CodeWhisperer
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/userguide/security_iam_service-with-iam.html
     */
    toAssociateCustomizationPermission(): this;
    /**
     * Grants permission to invoke CreateCustomization on CodeWhisperer
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/userguide/security_iam_service-with-iam.html
     */
    toCreateCustomization(): this;
    /**
     * Grants permission to invoke CreateProfile on CodeWhisperer
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/userguide/security_iam_service-with-iam.html
     */
    toCreateProfile(): this;
    /**
     * Grants permission to invoke DeleteCustomization on CodeWhisperer
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/userguide/security_iam_service-with-iam.html
     */
    toDeleteCustomization(): this;
    /**
     * Grants permission to invoke DeleteProfile on CodeWhisperer
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/userguide/security_iam_service-with-iam.html
     */
    toDeleteProfile(): this;
    /**
     * Grants permission to invoke DisassociateCustomizationPermission on CodeWhisperer
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/userguide/security_iam_service-with-iam.html
     */
    toDisassociateCustomizationPermission(): this;
    /**
     * Grants permission to invoke GenerateRecommendations on CodeWhisperer
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/userguide/security_iam_service-with-iam.html
     */
    toGenerateRecommendations(): this;
    /**
     * Grants permission to invoke GetCustomization on CodeWhisperer
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/userguide/security_iam_service-with-iam.html
     */
    toGetCustomization(): this;
    /**
     * Grants permission to invoke ListCustomizationPermissions on CodeWhisperer
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/userguide/security_iam_service-with-iam.html
     */
    toListCustomizationPermissions(): this;
    /**
     * Grants permission to invoke ListCustomizationVersions on CodeWhisperer
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/userguide/security_iam_service-with-iam.html
     */
    toListCustomizationVersions(): this;
    /**
     * Grants permission to invoke ListCustomizations on CodeWhisperer
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/userguide/security_iam_service-with-iam.html
     */
    toListCustomizations(): this;
    /**
     * Grants permission to invoke ListProfiles on CodeWhisperer
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/userguide/security_iam_service-with-iam.html
     */
    toListProfiles(): this;
    /**
     * Grants permission to invoke ListTagsForResource on CodeWhisperer
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/userguide/security_iam_service-with-iam.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to invoke TagResource on CodeWhisperer
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/userguide/security_iam_service-with-iam.html
     */
    toTagResource(): this;
    /**
     * Grants permission to invoke UntagResource on CodeWhisperer
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/userguide/security_iam_service-with-iam.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to invoke UpdateCustomization on CodeWhisperer
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/userguide/security_iam_service-with-iam.html
     */
    toUpdateCustomization(): this;
    /**
     * Grants permission to invoke UpdateProfile on CodeWhisperer
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/userguide/security_iam_service-with-iam.html
     */
    toUpdateProfile(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type profile to the statement
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/userguide/as-whisper-admin.html#about-profiles
     *
     * @param identifier - Identifier for the identifier.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onProfile(identifier: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type customization to the statement
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/userguide/as-whisper-admin.html#about-customizations
     *
     * @param identifier - Identifier for the identifier.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCustomization(identifier: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/userguide/codewhisperer-setup-enterprise-admin.html
     *
     * Applies to actions:
     * - .toCreateCustomization()
     * - .toCreateProfile()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tags associated with CodeWhisperer resource
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/userguide/codewhisperer-setup-enterprise-admin.html
     *
     * Applies to actions:
     * - .toAllowVendedLogDeliveryForResource()
     * - .toAssociateCustomizationPermission()
     * - .toDeleteCustomization()
     * - .toDeleteProfile()
     * - .toDisassociateCustomizationPermission()
     * - .toGetCustomization()
     * - .toListCustomizationPermissions()
     * - .toListCustomizationVersions()
     * - .toListTagsForResource()
     * - .toTagResource()
     * - .toUntagResource()
     * - .toUpdateCustomization()
     * - .toUpdateProfile()
     *
     * Applies to resource types:
     * - profile
     * - customization
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/userguide/codewhisperer-setup-enterprise-admin.html
     *
     * Applies to actions:
     * - .toCreateCustomization()
     * - .toCreateProfile()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [codewhisperer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncodewhisperer.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
